<?php

namespace App\Services\Auth;

use App\Repositories\UserRepository;
use App\Repositories\EmailTemplateRepository;
use App\Services\EmailService;

class PasswordResetService
{
    private UserRepository $users;
    private EmailTemplateRepository $templates;
    private EmailService $email;

    public function __construct(
        ?UserRepository $users = null,
        ?EmailTemplateRepository $templates = null,
        ?EmailService $email = null
    ) {
        $this->users = $users ?? new UserRepository();
        $this->templates = $templates ?? new EmailTemplateRepository();
        $this->email = $email ?? new EmailService();
    }

    public function sendResetLink(string $username, array $config): bool
    {
        global $_L;
        if (!is_array($_L)) {
            $_L = [];
        }
        $user = $this->users->findByUsername($username);
        if (!$user) {
            return false;
        }

        $token = _raid('10');
        $updated = $this->users->setResetToken((int) $user->id, $token, time() + 3600);
        if (!$updated) {
            return false;
        }

        $template = $this->templates->findByName('Admin:Password Change Request');
        if (!$template) {
            return false;
        }

        $subject = new \Template($template['subject']);
        $subject->set('business_name', $config['CompanyName']);
        $subj = $subject->output();

        $message = new \Template($template['message']);
        $message->set('name', $user['fullname']);
        $message->set('business_name', $config['CompanyName']);
        $message->set(
            'password_reset_link',
            U . 'login/pwreset-validate/' . $user['id'] . '/token_' . $token
        );
        $message->set('username', $user['username']);
        $message->set('ip_address', $_SERVER['REMOTE_ADDR'] ?? '');
        $message_o = $message->output();

        $this->email->send(
            $config,
            $_L,
            $user['fullname'],
            $user['username'],
            $subj,
            $message_o
        );

        return true;
    }
}
