<?php
namespace App\Services\Auth;

use ORM;

final class PermissionService
{
    private static array $cache = [];

    public static function hasAccess(
        int $rid,
        string $shortname,
        string $action = 'view'
    ): bool {
        if ($rid === 0) return true;

        $key = $rid . ':' . $shortname;

        if (!isset(self::$cache[$key])) {
            self::$cache[$key] = ORM::for_table('sys_staffpermissions')
                ->where('rid', $rid)
                ->where('shortname', $shortname)
                ->first();
        }

        $d = self::$cache[$key];
        if (!$d) return false;

        return match ($action) {
            'view'     => (int)$d->can_view === 1,
            'edit'     => (int)$d->can_edit === 1,
            'create'   => (int)$d->can_create === 1,
            'delete'   => (int)$d->can_delete === 1,
            'all_data' => (int)$d->all_data === 1,
            default    => false,
        };
    }
}
