<?php

namespace App\Services;

use Symfony\Component\Mailer\Mailer;
use Symfony\Component\Mailer\Transport;
use Symfony\Component\Mime\Address;
use Symfony\Component\Mime\Email as MimeEmail;

class EmailService
{
    public function send(array $config, array $_L, string $fullname, string $email, string $subject, string $message): void
    {
        if (defined('APP_STAGE') && APP_STAGE === 'Demo') {
            return;
        }

        if ($email === '') {
            return;
        }

        if (!class_exists(Transport::class)) {
            throw new \RuntimeException('Symfony Mailer is not installed. Run composer install.');
        }

        $email_config = \EmailConfig::first();
        $method = $email_config ? $email_config->method : 'sendmail';

        switch ($method) {
            case 'smtp':
                $host = $email_config->host ?? '';
                $port = $email_config->port ?? null;
                $user = $email_config->username ?? '';
                $pass = $email_config->password ?? '';
                $secure = $email_config->secure ?? '';

                $dsn = 'smtp://';
                if ($user !== '') {
                    $dsn .= rawurlencode($user);
                    if ($pass !== '') {
                        $dsn .= ':' . rawurlencode($pass);
                    }
                    $dsn .= '@';
                }
                $dsn .= $host;
                if (!empty($port)) {
                    $dsn .= ':' . $port;
                }
                if ($secure !== '') {
                    $dsn .= '?encryption=' . rawurlencode($secure);
                }

                $transport = Transport::fromDsn($dsn);
                break;

            case 'phpmail':
                $transport = Transport::fromDsn('native://default');
                break;

            default:
                $transport = Transport::fromDsn('sendmail://default');
                break;
        }

        $fromEmail = $config['sysEmail'] ?? '';
        $fromName = $config['CompanyName'] ?? '';

        $mailer = new Mailer($transport);
        $mail = (new MimeEmail())
            ->from(new Address($fromEmail, $fromName))
            ->to(new Address($email, $fullname))
            ->subject($subject)
            ->html($message);

        $mailer->send($mail);
    }
}
