<?php
namespace App\Services;

use ORM;
use InvalidArgumentException;
use RuntimeException;

class FormDownloadService
{
    public function getW7(string $uuid): array
    {
        return $this->fetchOne('form_w_7', $uuid);
    }

    public function get656(string $uuid): array
    {
        return $this->fetchOne('form_656', $uuid);
    }

    public function get433A(string $uuid): array
    {
        $data = [];
        for ($i = 1; $i <= 10; $i++) {
            $data['data_seccion' . $i] = $this->fetchOne('form_443_section' . $i, $uuid);
        }
        return $data;
    }

    protected function fetchOne(string $table, string $uuid): array
    {
        if (empty($uuid)) {
            throw new InvalidArgumentException('UUID_ENC is required');
        }

        $row = ORM::for_table($table)->where('UUID_ENC', $uuid)->find_one();

        if (!$row) {
            throw new RuntimeException('Form not found');
        }

        return $row->as_array();
    }
}
