<?php

namespace App\Services;

use App\Repositories\InvoiceRepository;

class InvoiceService
{
    private InvoiceRepository $repository;

    public function __construct(?InvoiceRepository $repository = null)
    {
        $this->repository = $repository ?? new InvoiceRepository();
    }

    public function getCustomerInvoices(int $customerId): array
    {
        return $this->repository->findByCustomerId($customerId);
    }
}
