{block name="content"}

<div class="block w-table">
    <div class="block-header">
        <h1 class="block-title">Logs</h1>
    </div>

    <div class="block-body">

        {if $logs|@count}

            <table class="ui-table">
                <thead>
                    <tr>
                        <th>Date time</th>
                        <th>From</th>
                        <th>To</th>
                        <th>Message</th>
                        <th>Detail</th>
                    </tr>
                </thead>
                <tbody>
                    {foreach $logs as $log}
                        <tr>
                            <td data-label="Date time">{$log['created_at']}</td>
                            <td data-label="From">{$log['sms_from']}</td>
                            <td data-label="To">{$log['sms_to']}</td>
                            <td data-label="Message">{$log['sms']}</td>
                            <td data-actions>
                                <button
                                    type="button"
                                    class="btn btn-sm btn-view-log"
                                    data-created="{$log['created_at']|escape:'html'}"
                                    data-from="{$log['sms_from']|escape:'html'}"
                                    data-to="{$log['sms_to']|escape:'html'}"
                                    data-message="{$log['sms']|escape:'html'}"
                                >
                                <svg class="fill-current" width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M10.8749 13.8619C8.10837 13.8619 5.74279 12.1372 4.79804 9.70241C5.74279 7.26761 8.10837 5.54297 10.8749 5.54297C13.6415 5.54297 16.0071 7.26762 16.9518 9.70243C16.0071 12.1372 13.6415 13.8619 10.8749 13.8619ZM10.8749 4.04297C7.35666 4.04297 4.36964 6.30917 3.29025 9.4593C3.23626 9.61687 3.23626 9.78794 3.29025 9.94552C4.36964 13.0957 7.35666 15.3619 10.8749 15.3619C14.3932 15.3619 17.3802 13.0957 18.4596 9.94555C18.5136 9.78797 18.5136 9.6169 18.4596 9.45932C17.3802 6.30919 14.3932 4.04297 10.8749 4.04297ZM10.8663 7.84413C9.84002 7.84413 9.00808 8.67606 9.00808 9.70231C9.00808 10.7286 9.84002 11.5605 10.8663 11.5605H10.8811C11.9074 11.5605 12.7393 10.7286 12.7393 9.70231C12.7393 8.67606 11.9074 7.84413 10.8811 7.84413H10.8663Z" fill="#667085"></path>
                                </svg>
                                </button>
                            </td>
                        </tr>
                    {/foreach}
                </tbody>
            </table>
            
        {else}

            <div class="empty-state">
                <i class="fal fa-calendar-times"></i>
                <p>No logs</p>
            </div>

        {/if}

    </div>
</div>

<div class="modal fade" id="logDetailModal" tabindex="-1" role="dialog" aria-labelledby="logDetailModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="logDetailModalLabel">Log detail</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="mb-2"><strong>Date:</strong> <span id="logDetailDate"></span></div>
        <div class="mb-2"><strong>From:</strong> <span id="logDetailFrom"></span></div>
        <div class="mb-2"><strong>To:</strong> <span id="logDetailTo"></span></div>
        <div class="mb-2"><strong>Message:</strong></div>
        <pre id="logDetailMessage" class="mb-0" style="white-space: pre-wrap; word-break: break-word;"></pre>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>
{/block}

{block name="script"}
<script>
$(function() {
    $(document).on('click', '.btn-view-log', function () {
        var $btn = $(this);
        $('#logDetailDate').text($btn.data('created'));
        $('#logDetailFrom').text($btn.data('from'));
        $('#logDetailTo').text($btn.data('to'));
        $('#logDetailMessage').text($btn.data('message'));
        $('#logDetailModal').modal('show');
    });

    // Simple skeleton -> table swap
    setTimeout(function () {
        $('.skeleton-loading-frame').addClass('is-hidden');
        $('.table-wrapper').addClass('is-loaded');
    }, 400);
});
</script>
<script>
/*window.crmDataTableConfig = {
    baseUrl: "{$_url}",
    ajaxUrl: "{$app_url}api/contacts/list",
    tableSelector: "#crm_table_records",
	paths: {
        view: "{$_url}contacts/view/[[id]]",
        groupList: "{$_url}contacts/list/customer/"
    },
    translations: {
        noItems: "{$_L['No items to display']}",
        showing: "{$_L['Showing _START_ to _END_ of _TOTAL_ entries']}",
        searchPlaceholder: "{__('Search')}"
    },
	columns: [
		{ data: 'id' },
		{ data: 'account' },
		{ data: 'code' },
		{ data: 'company' },
		{ data: 'gname' },
		{ data: 'email' },
		{ data: 'phone' },
		{ data: 'address' },
		{
            data: null,
            render: function(row, type, data) {
                return `<div class="float-end d-flex">
                            <a href="?ng=contacts/view/`+row.id+`" class="btn btn-icon me-2 btn-action" title="View">
                                <svg class="fill-current" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M8.0254 6.17845C8.0254 4.90629 9.05669 3.875 10.3289 3.875C11.601 3.875 12.6323 4.90629 12.6323 6.17845C12.6323 7.45061 11.601 8.48191 10.3289 8.48191C9.05669 8.48191 8.0254 7.45061 8.0254 6.17845ZM10.3289 2.375C8.22827 2.375 6.5254 4.07786 6.5254 6.17845C6.5254 8.27904 8.22827 9.98191 10.3289 9.98191C12.4294 9.98191 14.1323 8.27904 14.1323 6.17845C14.1323 4.07786 12.4294 2.375 10.3289 2.375ZM8.92286 11.03C5.7669 11.03 3.2085 13.5884 3.2085 16.7444V17.0333C3.2085 17.4475 3.54428 17.7833 3.9585 17.7833C4.37271 17.7833 4.7085 17.4475 4.7085 17.0333V16.7444C4.7085 14.4169 6.59533 12.53 8.92286 12.53H11.736C14.0635 12.53 15.9504 14.4169 15.9504 16.7444V17.0333C15.9504 17.4475 16.2861 17.7833 16.7004 17.7833C17.1146 17.7833 17.4504 17.4475 17.4504 17.0333V16.7444C17.4504 13.5884 14.8919 11.03 11.736 11.03H8.92286Z" fill=""></path></svg>
                            </a>
                            <a href="?ng=contacts/view/`+row.id+`/edit" class="btn btn-icon me-2 btn-action" title="Edit">
                                <svg class="fill-current" width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.0911 3.53206C16.2124 2.65338 14.7878 2.65338 13.9091 3.53206L5.6074 11.8337C5.29899 12.1421 5.08687 12.5335 4.99684 12.9603L4.26177 16.445C4.20943 16.6931 4.286 16.9508 4.46529 17.1301C4.64458 17.3094 4.90232 17.3859 5.15042 17.3336L8.63507 16.5985C9.06184 16.5085 9.45324 16.2964 9.76165 15.988L18.0633 7.68631C18.942 6.80763 18.942 5.38301 18.0633 4.50433L17.0911 3.53206ZM14.9697 4.59272C15.2626 4.29982 15.7375 4.29982 16.0304 4.59272L17.0027 5.56499C17.2956 5.85788 17.2956 6.33276 17.0027 6.62565L16.1043 7.52402L14.0714 5.49109L14.9697 4.59272ZM13.0107 6.55175L6.66806 12.8944C6.56526 12.9972 6.49455 13.1277 6.46454 13.2699L5.96704 15.6283L8.32547 15.1308C8.46772 15.1008 8.59819 15.0301 8.70099 14.9273L15.0436 8.58468L13.0107 6.55175Z" fill=""></path></svg>
                            </a>
                        </div>
                    `;
            }
        }
	],
    onInitComplete: function(dt) {
        //console.log("Tabla inicializada", dt);
    }
};*/
</script>
{/block}
