<a href="{$_url}invoices/add/1/{$cid}/" class="btn btn-primary waves-effect waves-light">{$_L['New Invoice']}</a>
<a href="{$_url}invoices/add/recurring/{$cid}/" class="btn btn-primary waves-effect waves-light">{$_L['New Recurring Invoice']}</a>

<hr>
<br>


<div class="row">

    <div class="col-md-12">
        <div class="card-box">

            <div class="card-top">
                <svg class="icon-svg" width="25" height="24" viewBox="0 0 25 24" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M13.4164 2.79175C13.4164 2.37753 13.0806 2.04175 12.6664 2.04175C12.2522 2.04175 11.9164 2.37753 11.9164 2.79175V4.39876C9.94768 4.67329 8.43237 6.36366 8.43237 8.40795C8.43237 10.0954 9.47908 11.6058 11.0591 12.1984L13.7474 13.2066C14.7419 13.5795 15.4008 14.5303 15.4008 15.5925C15.4008 16.9998 14.2599 18.1407 12.8526 18.1407H11.7957C10.7666 18.1407 9.93237 17.3064 9.93237 16.2773C9.93237 15.8631 9.59659 15.5273 9.18237 15.5273C8.76816 15.5273 8.43237 15.8631 8.43237 16.2773C8.43237 18.1348 9.9382 19.6407 11.7957 19.6407H11.9164V21.2083C11.9164 21.6225 12.2522 21.9583 12.6664 21.9583C13.0806 21.9583 13.4164 21.6225 13.4164 21.2083V19.6017C15.3853 19.3274 16.9008 17.6369 16.9008 15.5925C16.9008 13.905 15.8541 12.3946 14.2741 11.8021L11.5858 10.7939C10.5912 10.4209 9.93237 9.47013 9.93237 8.40795C9.93237 7.00063 11.0732 5.85976 12.4806 5.85976H13.5374C14.5665 5.85976 15.4008 6.69401 15.4008 7.72311C15.4008 8.13732 15.7366 8.47311 16.1508 8.47311C16.565 8.47311 16.9008 8.13732 16.9008 7.72311C16.9008 5.86558 15.395 4.35976 13.5374 4.35976H13.4164V2.79175Z"></path>
                </svg>
            </div>

            <div class="row">
                <div class="col-md-4">
                    <div class="card-content">
                        <p class="title">Total Invoice Amount</p>
                    </div>
                    
                    <div class="card-end">
                        <div>
                            <h4 class="value">
                                <span class="amount" data-a-dec="{$config['dec_point']}" data-a-sep="{$config['thousands_sep']}" data-a-pad="{$config['currency_decimal_digits']}" data-p-sign="{$config['currency_symbol_position']}" data-a-sign="{$config['currency_code']} " data-d-group="{$config['thousand_separator_placement']}">{$total_invoice_amount}</span>
                            </h4>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card-content">
                        <p class="title">Total Paid Amount</p>
                    </div>
                    
                    <div class="card-end">
                        <div>
                            <h4 class="value" style="font-size: 24px;">
                                <span class="amount" data-a-dec="{$config['dec_point']}" data-a-sep="{$config['thousands_sep']}" data-a-pad="{$config['currency_decimal_digits']}" data-p-sign="{$config['currency_symbol_position']}" data-a-sign="{$config['currency_code']} " data-d-group="{$config['thousand_separator_placement']}">{$total_paid_amount}</span>
                            </h4>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card-content">
                        <p class="title">Total Un Paid Amount</p>
                    </div>
                    
                    <div class="card-end">
                        <div>
                            <h4 class="value" style="font-size: 24px;">
                                <span class="amount{if $total_unpaid_amount > 0} text-negative{/if}" data-a-dec="{$config['dec_point']}" data-a-sep="{$config['thousands_sep']}" data-a-pad="{$config['currency_decimal_digits']}" data-p-sign="{$config['currency_symbol_position']}" data-a-sign="{$config['currency_code']} " data-d-group="{$config['thousand_separator_placement']}">{$total_unpaid_amount}</span>
                            </h4>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

</div>

<hr>

<div class="block w-table">
    <div class="block-header">
        <h1 class="block-title">Invoices</h1>
    </div>

    <div class="block-body">
        <table class="ui-table sys_table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>{$_L['Account']}</th>
                    {if !empty($config['invoice_group'])}
                        <th>
                            {$_L['Group']}
                        </th>
                    {/if}
                    {if !empty($config['invoice_single_service'])}
                        <th>
                            {__('Service')}
                        </th>
                    {/if}
                    <th>{$_L['Staff']}</th>
                    <th>{$_L['Amount']}</th>
                    <th>{$_L['Invoice Date']}</th>
                    <th>{$_L['Due Date']}</th>
                    <th>{$_L['Status']}</th>
                    <th>{$_L['Manage']}</th>
                </tr>
            </thead>
            <tbody>

            {foreach $invoices as $invoice}
                <tr>
                    <td>{$invoice['invoicenum']}{if $invoice['cn'] neq ''} {$invoice['cn']} {else} {$invoice['id']} {/if}</td>
                    <td>{$invoice['account']}</td>

                    {if !empty($config['invoice_group'])}
                        <td>
                            {if !empty($invoice_groups[$invoice['group_id']])}
                                {$invoice_groups[$invoice['group_id']]->name}
                            {/if}
                        </td>
                    {/if}
                    {if !empty($config['invoice_single_service'])}
                        <td>
                            {if !empty($services[$invoice['service_id']])}
                                {$services[$invoice['service_id']]->name}
                            {/if}
                        </td>
                    {/if}
                    <td>
                        {if !empty($staffs[$invoice['aid']])}
                            {$staffs[$invoice['aid']]->fullname}
                        {/if}
                    </td>
                    <td>{formatCurrency($invoice['total'],$invoice['currency_iso_code'])}</td>
                    <td>{date( $config['df'], strtotime($invoice['date']))}</td>
                    <td>{date( $config['df'], strtotime($invoice['duedate']))}</td>
                    <td>{ib_lan_get_line($invoice['status'])}</td>
                    <td>
                        <div class="btn-group">
                            <a href="{$_url}invoices/view/{$invoice['id']}/" class="btn btn-primary btn-sm"> {$_L['View']}</a>
                            <a href="{$_url}invoices/edit/{$invoice['id']}/" class="btn btn-info btn-sm"> {$_L['Edit']}</a>

                        </div>
                    </td>
                </tr>
            {/foreach}

            </tbody>
        </table>
    </div>
</div>

