{extends file="$layouts_admin"}

{block name="head"}
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" rel="stylesheet" /> 
{/block}

{assign "page_content_extra_class" "p-0"}

{block name="content"}
<style type="text/css">
.list-group{
    max-height: 150px;
    margin-bottom: 10px;
    overflow:scroll;
    -webkit-overflow-scrolling: touch;
}    
.swal2-container {
    z-index: 9999;
}
.wrapper {
    overflow: hidden;  
}
ul.breadcrumbs {
    margin: 0;
    padding: 0;
    display: flex;
    flex-wrap: wrap;
    justify-content:center;
}
ul.breadcrumbs li {
    position: relative;
    margin: 0;
    padding: 0;
    list-style: none;
    display: inline-block;
    border-left: 1px solid #ccc;
    transition: 0.3s ease;
}
ul.breadcrumbs li:hover:before {
  /* border-left: 10px solid #5e6e82; */
}
ul.breadcrumbs li:hover a {
  /* color: white;
  background: #5e6e82; */
 
}
ul.breadcrumbs li:before {
  content: "";
  position: absolute;
  right: -9px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 20;
  border-left: 10px solid #fff;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
  transition: 0.3s ease;
}
ul.breadcrumbs li:after {
  content: "";
  position: absolute;
  right: -10px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 10;
  border-left: 10px solid #ccc;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
}
ul.breadcrumbs li.active {
  background: #5e6e82; /* Fondo para el activo */
}
ul.breadcrumbs li.active a {
  color: white !important; /* Color del texto activo */
  padding: 0 15px 0 25px; /* Ajustar el padding */
  background: #5e6e82;
}
ul.breadcrumbs li.first {
  border-left: none;
}
ul.breadcrumbs li.first a {
  font-size: 18px;
  padding-left: 20px;
  border-radius: 5px 0px 0px 5px;
}
ul.breadcrumbs li.last:before {
  display: none;
}
ul.breadcrumbs li.last:after {
  display: none;
}
ul.breadcrumbs li.last a {
  padding-right: 20px;
  border-radius: 0px 40px 40px 0px;
}
ul.breadcrumbs li a {
  display: block;
  font-size: 12px;
  line-height: 40px;
  color: #757575;
  padding: 0px 15px 0px 25px;
  text-decoration: none;
  background: #fff;
  border: 1px solid #ddd;
  white-space: nowrap; /* Evitar que el texto se envuelva */
  overflow: hidden;
  transition: 0.3s ease;
}
ul.breadcrumbs li.active:before {
  display: block; /* Mostrar el triángulo en el activo */
}
ul.breadcrumbs li.active:after {
  display: block; /* Mostrar el triángulo secundario en el activo */
}

@media (max-width: 768px) {
  ul.breadcrumbs {
    flex-direction: column; /* Cambiar a una columna en pantallas más pequeñas */
  }

  ul.breadcrumbs li {
    border-left: none; /* Eliminar el borde izquierdo en pantallas pequeñas */
    margin-bottom: 5px; /* Espaciado entre elementos */
    margin-right: 10px;
  }
}
ul.breadcrumbs li.active:before {
  border-left: 10px solid #5e6e82; /* Cambia el color del triángulo al hacer hover sobre el activo */
}
.cursor_manito {
  cursor: pointer;
}
table.estilosTabla > :not(caption) > * > * {
    /*
    padding-top: 5px !important;
    padding-bottom: 5px !important;
    */
}

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
}

.btn-edit-referencia-personal {
        margin-bottom: 4px; 
        background-color: #001b3b; 
        color: white; 
        border: 1px solid rgb(211, 202, 192) !important; 
        box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
        float: inline-end;
    }

.btn-eliminar-referencia-personal {
    margin-bottom: 4px;
    background-color: red;
    color: white;
    border: 1px solid rgb(211, 202, 192) !important;
    box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
    float: inline-end;
    }

.btn-edit-referencia-personal:hover i,
.btn-eliminar-referencia-personal:hover i {
    color: white; /* Mantén el color blanco del icono en hover */
}

.tamano-icono{
    font-size:small;
}
    
.centrar-botones{
    text-align: center;
    justify-content: center;
    display: flex;
    padding: 0px;
}

.btn-descargar {
    margin-bottom: 4px; 
    background-color: #001b3b; 
    color: white; 
    border: 1px solid rgb(211, 202, 192) !important; 
    box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
    float: inline-end;
}

.btn-eliminar {
    margin-bottom: 4px;
    background-color: red;
    color: white;
    border: 1px solid rgb(211, 202, 192) !important;
    box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
    float: inline-end;
}

.btn-descargar:hover i,
.btn-eliminar:hover i {
    color: white;
}

@media (max-width: 576px)
{
    .btn_general_plan{
        margin-top: 10px;
    }
}

.btn-edit {
        margin-bottom: 4px; 
        background-color: #001b3b; 
        color: white; 
        border: 1px solid rgb(211, 202, 192) !important; 
        box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
        float: inline-end;
}

.btn-eliminar {
    margin-bottom: 4px;
    background-color: red;
    color: white;
    border: 1px solid rgb(211, 202, 192) !important;
    box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
    float: inline-end;
}

.btn-edit:hover i,
.btn-eliminar:hover i {
    color: white;
}


.bg-succes{
   background-color: green;
} 
</style>

<div
    id="contact-app"
    class="account-profile-view d-flex flex-grow-1 p-0"
    data-initial="{if $user['fullname']}{$user['fullname']|substr:0:1}{else}{$user['username']|substr:0:1}{/if}"
    v-cloak
>
    <!-- left slider -->
    <div id="js-inbox-menu" class="flex-wrap position-relative bg-white slide-on-mobile slide-on-mobile-left" v-cloak>
        <div class="position-absolute pos-top pos-bottom w-100">
            <div class="d-flex h-100 flex-column">
                <div class="px-3 px-sm-4 px-lg-5 py-4 align-items-center text-center">
                    
                    <div class="user-btn xl">
                        <div class="user-avatar-initials" v-text="userInitial"></div>
                    </div>

                    <div class="mt-3">
                        <h5 v-if="user.email" style="font-size: 14px;overflow-wrap: break-word;">{{ user.email }}</h5>
                        <h5 v-if="user.phone" style="font-size: 14px;overflow-wrap: break-word;">{{ user.phone }}</h5>
                    </div>
                </div>
                <div class="pr-3 account-profile-menu">

                    <div v-for="tab in visibleTabs" :key="tab.id">
                        <a
                            href="javascript:void(0)"
                            class="dropdown-item clx-side-menu-item"
                            :class="[(tab.classNames || ''), activeTab === tab.id ? 'active' : '']"
                            @click.prevent="loadTab(tab.id)"
                        >
                            <div class="svg-icon svg-icon-primary" v-html="tab.icon"></div>
                            <span>{{ tab.label }}</span>
                            <span v-if="tab.count !== null" class="fw-400 fs-xs">({{ tab.count }})</span>
                        </a>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="slide-backdrop" data-action="toggle" data-class="slide-on-mobile-left-show" data-target="#js-inbox-menu"></div> <!-- end left slider -->
    <!-- inbox container -->
    <div class="d-flex flex-column flex-grow-1 bg-white">
        <!-- inbox header -->
        <div class="flex-grow-0">
            <!-- inbox title -->
            <div class="d-flex align-items-center py-3 pl-sm-3 pr-sm-4 py-sm-4 py-lg-4 pl-lg-0 flex-shrink-0">
                <!-- button for mobile -->
                <a href="javascript:void(0);" class="pl-3 pr-3 py-2 d-flex d-lg-none align-items-center justify-content-center me-2 btn" data-action="toggle" data-class="slide-on-mobile-left-show" data-target="#js-inbox-menu">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <polygon points="0 0 24 0 24 24 0 24"/>
                            <rect fill="#000000" opacity="0.3" transform="translate(14.000000, 12.000000) rotate(-90.000000) translate(-14.000000, -12.000000) " x="13" y="5" width="2" height="14" rx="1"/>
                            <rect fill="#000000" opacity="0.3" x="3" y="3" width="2" height="18" rx="1"/>
                            <path d="M11.7071032,15.7071045 C11.3165789,16.0976288 10.6834139,16.0976288 10.2928896,15.7071045 C9.90236532,15.3165802 9.90236532,14.6834152 10.2928896,14.2928909 L16.2928896,8.29289093 C16.6714686,7.914312 17.281055,7.90106637 17.675721,8.26284357 L23.675721,13.7628436 C24.08284,14.136036 24.1103429,14.7686034 23.7371505,15.1757223 C23.3639581,15.5828413 22.7313908,15.6103443 22.3242718,15.2371519 L17.0300721,10.3841355 L11.7071032,15.7071045 Z" fill="#000000" fill-rule="nonzero" transform="translate(16.999999, 11.999997) scale(1, -1) rotate(90.000000) translate(-16.999999, -11.999997) "/>
                        </g>
                    </svg>
                </a>
                <!-- end button for mobile -->
                <h4 class="subheader-title">
                    {{ user.account }}
                    <template v-if="user.code">- [{{ user.code }}]</template>
                </h4>
            </div>
            <!-- end inbox title -->
            <!-- inbox button shortcut -->

            <!-- end inbox button shortcut -->
        </div>
        <!-- end inbox header -->
        <!-- inbox message -->
        <div class="flex-wrap align-items-center flex-grow-1 position-relative">
            <div class="position-absolute pos-top w-100 panel">
                <div class="panel-container">
                    <div class="panel-content full-height">
                        <div class="d-flex h-100 flex-column">
                            <!-- message list (the part that scrolls) -->
                            <div class="alert alert-danger" id="emsg" style="display: none;">
                                <span id="emsgbody"></span>
                            </div>
                            <div id="application_ajaxrender" style="min-height: 200px;" v-pre>

                            </div>
                            <!-- end message list -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end inbox message -->
    </div>
    <!-- end inbox container -->
    <!-- compose message -->
    <!-- end compose message -->
</div>


<input type="hidden" id="_lan_are_you_sure" value="Are you sure">
<input type="hidden" id="_active_tab" value="{$tab}">
{/block}

{block name="script"}
<script>
const contactAutoCfg = {
    aSign: "{$config.currency_code} ",
    dGroup: {$config.thousand_separator_placement},
    aPad: {$config.currency_decimal_digits},
    pSign: "{$config.currency_symbol_position}",
    aDec: "{$config.dec_point}",
    aSep: "{$config.thousands_sep}",
    vMax: '9999999999999999.00',
    vMin: '-9999999999999999.00'
};
const tabFlags = {
    showPurchases: {if $is_supplier && has_access($user->roleid,'suppliers') && ($config['purchase'])}true{else}false{/if},
    invoicing: {if $config['invoicing'] eq '1'}true{else}false{/if},
    quotes: {if $config['quotes'] eq '1'}true{else}false{/if},
    documents: {if $config['documents'] eq '1'}true{else}false{/if},
    accounting: {if $config['accounting'] eq '1'}true{else}false{/if},
    passwordManager: {if ($config['password_manager']) && has_access($user->roleid,'password_manager')}true{else}false{/if}
};
const tabCounts = {
    po: {$po_count|default:0},
    inv: {$inv_count|default:0},
    quote: {$quote_count|default:0}
};
const tabLabels = {
    summary: "{$_L['Summary']}",
    edit: "{$_L['Edit']}",
    finance: "Finance",
    activity: "{$_L['Activity']}",
    purchases: "{$_L['Purchase Orders']}",
    invoices: "{$_L['Invoices']}",
    quotes: "{$_L['Quotes']}",
    files: "{$_L['Files']}",
    transactions: "{$_L['Transactions']}",
    email: "{$_L['Email']}",
    log: "{$_L['Log']}",
    passwordManager: "{$_L['Password Manager']}",
    autoPayment: "Auto-Payment",
    paymentMethod: "Payment method",
    more: "{$_L['More']}",
    creditCardInfo: "Credit Card Info"
};
const tabIcons = {
    summary: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"/><path d="M3.95709826,8.41510662 L11.47855,3.81866389 C11.7986624,3.62303967 12.2013376,3.62303967 12.52145,3.81866389 L20.0429,8.41510557 C20.6374094,8.77841684 21,9.42493654 21,10.1216692 L21,19.0000642 C21,20.1046337 20.1045695,21.0000642 19,21.0000642 L4.99998155,21.0000673 C3.89541205,21.0000673 2.99998155,20.1046368 2.99998155,19.0000673 L2.99999828,10.1216672 C2.99999935,9.42493561 3.36258984,8.77841732 3.95709826,8.41510662 Z M10,13 C9.44771525,13 9,13.4477153 9,14 L9,17 C9,17.5522847 9.44771525,18 10,18 L14,18 C14.5522847,18 15,17.5522847 15,17 L15,14 C15,13.4477153 14.5522847,13 14,13 L10,13 Z" fill="#000000"/></g></svg>`,
    edit: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"/><path d="M8,17.9148182 L8,5.96685884 C8,5.56391781 8.16211443,5.17792052 8.44982609,4.89581508 L10.965708,2.42895648 C11.5426798,1.86322723 12.4640974,1.85620921 13.0496196,2.41308426 L15.5337377,4.77566479 C15.8314604,5.0588212 16,5.45170806 16,5.86258077 L16,17.9148182 C16,18.7432453 15.3284271,19.4148182 14.5,19.4148182 L9.5,19.4148182 C8.67157288,19.4148182 8,18.7432453 8,17.9148182 Z" fill="#000000" fill-rule="nonzero" transform="translate(12.000000, 10.707409) rotate(-135.000000) translate(-12.000000, -10.707409) "/><rect fill="#000000" opacity="0.3" x="5" y="20" width="15" height="2" rx="1"/></g></svg>`,
    finance: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"></rect><rect fill="#000000" opacity="0.3" x="2" y="5" width="20" height="14" rx="2"></rect><rect fill="#000000" x="2" y="8" width="20" height="3"></rect><rect fill="#000000" opacity="0.3" x="16" y="14" width="4" height="2" rx="1"></rect></g></svg>`,
    activity: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"/><circle fill="#000000" opacity="0.3" cx="12" cy="12" r="10"/><path d="M12.4208204,17.1583592 L15.4572949,11.0854102 C15.6425368,10.7149263 15.4923686,10.2644215 15.1218847,10.0791796 C15.0177431,10.0271088 14.9029083,10 14.7864745,10 L12,10 L12,7.17705098 C12,6.76283742 11.6642136,6.42705098 11.25,6.42705098 C10.965921,6.42705098 10.7062236,6.58755277 10.5791796,6.84164079 L7.5427051,12.9145898 C7.35746316,13.2850737 7.50763142,13.7355785 7.87811529,13.9208204 C7.98225687,13.9728912 8.09709167,14 8.21352549,14 L11,14 L11,16.822949 C11,17.2371626 11.3357864,17.572949 11.75,17.572949 C12.034079,17.572949 12.2937764,17.4124472 12.4208204,17.1583592 Z" fill="#000000"/></g></svg>`,
    purchases: `<i class="fal fa-star width-1"></i>`,
    invoices: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"/><circle fill="#000000" opacity="0.3" cx="20.5" cy="12.5" r="1.5"/><rect fill="#000000" opacity="0.3" transform="translate(12.000000, 6.500000) rotate(-15.000000) translate(-12.000000, -6.500000) " x="3" y="3" width="18" height="7" rx="1"/><path d="M22,9.33681558 C21.5453723,9.12084552 21.0367986,9 20.5,9 C18.5670034,9 17,10.5670034 17,12.5 C17,14.4329966 18.5670034,16 20.5,16 C21.0367986,16 21.5453723,15.8791545 22,15.6631844 L22,18 C22,19.1045695 21.1045695,20 20,20 L4,20 C2.8954305,20 2,19.1045695 2,18 L2,6 C2,4.8954305 2.8954305,4 4,4 L20,4 C21.1045695,4 22,4.8954305 22,6 L22,9.33681558 Z" fill="#000000"/></g></svg>`,
    quotes: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><polygon points="0 0 24 0 24 24 0 24"/><path d="M3.52270623,14.028695 C2.82576459,13.3275941 2.82576459,12.19529 3.52270623,11.4941891 L11.6127629,3.54050571 C11.9489429,3.20999263 12.401513,3.0247814 12.8729533,3.0247814 L19.3274172,3.0247814 C20.3201611,3.0247814 21.124939,3.82955935 21.124939,4.82230326 L21.124939,11.2583059 C21.124939,11.7406659 20.9310733,12.2027862 20.5869271,12.5407722 L12.5103155,20.4728108 C12.1731575,20.8103442 11.7156477,21 11.2385688,21 C10.7614899,21 10.3039801,20.8103442 9.9668221,20.4728108 L3.52270623,14.028695 Z M16.9307214,9.01652093 C17.9234653,9.01652093 18.7282432,8.21174298 18.7282432,7.21899907 C18.7282432,6.22625516 17.9234653,5.42147721 16.9307214,5.42147721 C15.9379775,5.42147721 15.1331995,6.22625516 15.1331995,7.21899907 C15.1331995,8.21174298 15.9379775,9.01652093 16.9307214,9.01652093 Z" fill="#000000" fill-rule="nonzero" opacity="0.3"/></g></svg>`,
    files: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><polygon points="0 0 24 0 24 24 0 24"/><path d="M4.85714286,1 L11.7364114,1 C12.0910962,1 12.4343066,1.12568431 12.7051108,1.35473959 L17.4686994,5.3839416 C17.8056532,5.66894833 18,6.08787823 18,6.52920201 L18,19.0833333 C18,20.8738751 17.9795521,21 16.1428571,21 L4.85714286,21 C3.02044787,21 3,20.8738751 3,19.0833333 L3,2.91666667 C3,1.12612489 3.02044787,1 4.85714286,1 Z M8,12 C7.44771525,12 7,12.4477153 7,13 C7,13.5522847 7.44771525,14 8,14 L15,14 C15.5522847,14 16,13.5522847 16,13 C16,12.4477153 15.5522847,12 15,12 L8,12 Z M8,16 C7.44771525,16 7,16.4477153 7,17 C7,17.5522847 7.44771525,18 8,18 L11,18 C11.5522847,18 12,17.5522847 12,17 C12,16.4477153 11.5522847,16 11,16 L8,16 Z" fill="#000000" fill-rule="nonzero" opacity="0.3"/><path d="M6.85714286,3 L14.7364114,3 C15.0910962,3 15.4343066,3.12568431 15.7051108,3.35473959 L20.4686994,7.3839416 C20.8056532,7.66894833 21,8.08787823 21,8.52920201 L21,21.0833333 C21,22.8738751 20.9795521,23 19.1428571,23 L6.85714286,23 C5.02044787,23 5,22.8738751 5,21.0833333 L5,4.91666667 C5,3.12612489 5.02044787,3 6.85714286,3 Z M8,12 C7.44771525,12 7,12.4477153 7,13 C7,13.5522847 7.44771525,14 8,14 L15,14 C15.5522847,14 16,13.5522847 16,13 C16,12.4477153 15.5522847,12 15,12 L8,12 Z M8,16 C7.44771525,16 7,16.4477153 7,17 C7,17.5522847 7.44771525,18 8,18 L11,18 C11.5522847,18 12,17.5522847 12,17 C12,16.4477153 11.5522847,16 11,16 L8,16 Z" fill="#000000" fill-rule="nonzero"/></g></svg>`,
    transactions: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"/><path d="M4,4 L20,4 C21.1045695,4 22,4.8954305 22,6 L22,18 C22,19.1045695 21.1045695,20 20,20 L4,20 C2.8954305,20 2,19.1045695 2,18 L2,6 C2,4.8954305 2.8954305,4 4,4 Z" fill="#000000" opacity="0.3"/><path d="M18.5,11 L5.5,11 C4.67157288,11 4,11.6715729 4,12.5 L4,13 L8.58578644,13 C8.85100293,13 9.10535684,13.1053568 9.29289322,13.2928932 L10.2928932,14.2928932 C10.7456461,14.7456461 11.3597108,15 12,15 C12.6402892,15 13.2543539,14.7456461 13.7071068,14.2928932 L14.7071068,13.2928932 C14.8946432,13.1053568 15.1489971,13 15.4142136,13 L20,13 L20,12.5 C20,11.6715729 19.3284271,11 18.5,11 Z" fill="#000000"/><path d="M5.5,6 C4.67157288,6 4,6.67157288 4,7.5 L4,8 L20,8 L20,7.5 C20,6.67157288 19.3284271,6 18.5,6 L5.5,6 Z" fill="#000000"/></g></svg>`,
    email: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"/><path d="M5,6 L19,6 C20.1045695,6 21,6.8954305 21,8 L21,17 C21,18.1045695 20.1045695,19 19,19 L5,19 C3.8954305,19 3,18.1045695 3,17 L3,8 C3,6.8954305 3.8954305,6 5,6 Z M18.1444251,7.83964668 L12,11.1481833 L5.85557487,7.83964668 C5.4908718,7.6432681 5.03602525,7.77972206 4.83964668,8.14442513 C4.6432681,8.5091282 4.77972206,8.96397475 5.14442513,9.16035332 L11.6444251,12.6603533 C11.8664074,12.7798822 12.1335926,12.7798822 12.3555749,12.6603533 L18.8555749,9.16035332 C19.2202779,8.96397475 19.3567319,8.5091282 19.1603533,8.14442513 C18.9639747,7.77972206 18.5091282,7.6432681 18.1444251,7.83964668 Z" fill="#000000"/></g></svg>`,
    log: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"/><path d="M11.5,5 L18.5,5 C19.3284271,5 20,5.67157288 20,6.5 C20,7.32842712 19.3284271,8 18.5,8 L11.5,8 C10.6715729,8 10,7.32842712 10,6.5 C10,5.67157288 10.6715729,5 11.5,5 Z M5.5,17 L18.5,17 C19.3284271,17 20,17.6715729 20,18.5 C20,19.3284271 19.3284271,20 18.5,20 L5.5,20 C4.67157288,20 4,19.3284271 4,18.5 C4,17.6715729 4.67157288,17 5.5,17 Z M5.5,11 L18.5,11 C19.3284271,11 20,11.6715729 20,12.5 C20,13.3284271 19.3284271,14 18.5,14 L5.5,14 C4.67157288,14 4,13.3284271 4,12.5 C4,11.6715729 4.67157288,11 5.5,11 Z" fill="#000000" opacity="0.3"/><path d="M4.82866499,9.40751652 L7.70335558,6.90006821 C7.91145727,6.71855155 7.9330087,6.40270347 7.75149204,6.19460178 C7.73690043,6.17787308 7.72121098,6.16213467 7.70452782,6.14749103 L4.82983723,3.6242308 C4.62230202,3.44206673 4.30638833,3.4626341 4.12422426,3.67016931 C4.04415337,3.76139218 4,3.87862714 4,4.00000654 L4,9.03071508 C4,9.30685745 4.22385763,9.53071508 4.5,9.53071508 C4.62084305,9.53071508 4.73759731,9.48695028 4.82866499,9.40751652 Z" fill="#000000"/></g></svg>`,
    passwordManager: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"/><circle fill="#000000" opacity="0.3" cx="12" cy="12" r="10"/><path d="M14.5,11 C15.0522847,11 15.5,11.4477153 15.5,12 L15.5,15 C15.5,15.5522847 15.0522847,16 14.5,16 L9.5,16 C8.94771525,16 8.5,15.5522847 8.5,15 L8.5,12 C8.5,11.4477153 8.94771525,11 9.5,11 L9.5,10.5 C9.5,9.11928813 10.6192881,8 12,8 C13.3807119,8 14.5,9.11928813 14.5,10.5 L14.5,11 Z M12,9 C11.1715729,9 10.5,9.67157288 10.5,10.5 L10.5,11 L13.5,11 L13.5,10.5 C13.5,9.67157288 12.8284271,9 12,9 Z" fill="#000000"/></g></svg>`,
    autoPayment: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"/><path d="M4,4 L20,4 C21.1045695,4 22,4.8954305 22,6 L22,18 C22,19.1045695 21.1045695,20 20,20 L4,20 C2.8954305,20 2,19.1045695 2,18 L2,6 C2,4.8954305 2.8954305,4 4,4 Z" fill="#000000" opacity="0.3"/><path d="M18.5,11 L5.5,11 C4.67157288,11 4,11.6715729 4,12.5 L4,13 L8.58578644,13 C8.85100293,13 9.10535684,13.1053568 9.29289322,13.2928932 L10.2928932,14.2928932 C10.7456461,14.7456461 11.3597108,15 12,15 C12.6402892,15 13.2543539,14.7456461 13.7071068,14.2928932 L14.7071068,13.2928932 C14.8946432,13.1053568 15.1489971,13 15.4142136,13 L20,13 L20,12.5 C20,11.6715729 19.3284271,11 18.5,11 Z" fill="#000000"/><rect fill="#000000" opacity="0.3" x="10" y="6" width="4" height="3" rx="1"/></g></svg>`,
    paymentMethod: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"/><circle fill="#000000" opacity="0.3" cx="12" cy="12" r="9"/><path d="M11.7357634,20.9961946 C6.88740052,20.8563914 3,16.8821712 3,12 C3,11.9168367 3.00112797,11.8339369 3.00336944,11.751315 C3.66233009,11.8143341 4.85636818,11.9573854 4.91262842,12.4204038 C4.9904938,13.0609191 4.91262842,13.8615942 5.45804656,14.101772 C6.00346469,14.3419498 6.15931561,13.1409372 6.6267482,13.4612567 C7.09418079,13.7815761 8.34086797,14.0899175 8.34086797,14.6562185 C8.34086797,15.222396 8.10715168,16.1034596 8.34086797,16.2636193 C8.57458427,16.423779 9.5089688,17.54465 9.50920913,17.7048097 C9.50956962,17.8649694 9.83857487,18.6793513 9.74040201,18.9906563 C9.65905192,19.2487394 9.24857641,20.0501554 8.85059781,20.4145589 C9.75315358,20.7620621 10.7235846,20.9657742 11.7357634,20.9960544 L11.7357634,20.9961946 Z M8.28272988,3.80112099 C9.4158415,3.28656421 10.6744554,3 12,3 C15.5114513,3 18.5532143,5.01097452 20.0364482,7.94408274 C20.069657,8.72412177 20.0638332,9.39135321 20.2361262,9.6327358 C21.1131932,10.8600506 18.0995147,11.7043158 18.5573343,13.5605384 C18.7589671,14.3794892 16.5527814,14.1196773 16.0139722,14.886394 C15.4748026,15.6527403 14.1574598,15.137809 13.8520064,14.9904917 C13.546553,14.8431744 12.3766497,15.3341497 12.4789081,14.4995164 C12.5805657,13.664636 13.2922889,13.6156126 14.0555619,13.2719546 C14.8184743,12.928667 15.9189236,11.7871741 15.3781918,11.6380045 C12.8323064,10.9362407 11.963771,8.47852395 11.963771,8.47852395 C11.8110443,8.44901109 11.8493762,6.74109366 11.1883616,6.69207022 C10.5267462,6.64279981 10.170464,6.88841096 9.20435656,6.69207022 C8.23764828,6.49572949 8.44144409,5.85743687 8.2887174,4.48255778 C8.25453994,4.17415686 8.25619136,3.95717082 8.28272988,3.80112099 Z M20.9991771,11.8770357 C20.9997251,11.9179585 21,11.9589471 21,12 C21,16.9406923 17.0188468,20.9515364 12.0895088,20.9995641 C16.970233,20.9503326 20.9337111,16.888438 20.9991771,11.8770357 Z" fill="#000000" opacity="0.3"/></g></svg>`,
    creditCardInfo: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"/><path d="M4.85714286,3 L19.1428571,3 C20.1797017,3 21,3.82029825 21,4.85714286 L21,19.1428571 C21,20.1797017 20.1797017,21 19.1428571,21 L4.85714286,21 C3.82029825,21 3,20.1797017 3,19.1428571 L3,4.85714286 C3,3.82029825 3.82029825,3 4.85714286,3 Z M5,7 L5,17 L19,17 L19,7 L5,7 Z" fill="#000000" opacity="0.3"/><rect fill="#000000" x="7" y="10" width="5" height="2" rx="0.5"/><rect fill="#000000" x="7" y="13" width="3" height="2" rx="0.5"/></g></svg>`,
    more: `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24"/><circle fill="#000000" opacity="0.3" cx="12" cy="12" r="9"/><path d="M11.7357634,20.9961946 C6.88740052,20.8563914 3,16.8821712 3,12 C3,11.9168367 3.00112797,11.8339369 3.00336944,11.751315 C3.66233009,11.8143341 4.85636818,11.9573854 4.91262842,12.4204038 C4.9904938,13.0609191 4.91262842,13.8615942 5.45804656,14.101772 C6.00346469,14.3419498 6.15931561,13.1409372 6.6267482,13.4612567 C7.09418079,13.7815761 8.34086797,14.0899175 8.34086797,14.6562185 C8.34086797,15.222396 8.10715168,16.1034596 8.34086797,16.2636193 C8.57458427,16.423779 9.5089688,17.54465 9.50920913,17.7048097 C9.50956962,17.8649694 9.83857487,18.6793513 9.74040201,18.9906563 C9.65905192,19.2487394 9.24857641,20.0501554 8.85059781,20.4145589 C9.75315358,20.7620621 10.7235846,20.9657742 11.7357634,20.9960544 L11.7357634,20.9961946 Z M8.28272988,3.80112099 C9.4158415,3.28656421 10.6744554,3 12,3 C15.5114513,3 18.5532143,5.01097452 20.0364482,7.94408274 C20.069657,8.72412177 20.0638332,9.39135321 20.2361262,9.6327358 C21.1131932,10.8600506 18.0995147,11.7043158 18.5573343,13.5605384 C18.7589671,14.3794892 16.5527814,14.1196773 16.0139722,14.886394 C15.4748026,15.6527403 14.1574598,15.137809 13.8520064,14.9904917 C13.546553,14.8431744 12.3766497,15.3341497 12.4789081,14.4995164 C12.5805657,13.664636 13.2922889,13.6156126 14.0555619,13.2719546 C14.8184743,12.928667 15.9189236,11.7871741 15.3781918,11.6380045 C12.8323064,10.9362407 11.963771,8.47852395 11.963771,8.47852395 C11.8110443,8.44901109 11.8493762,6.74109366 11.1883616,6.69207022 C10.5267462,6.64279981 10.170464,6.88841096 9.20435656,6.69207022 C8.23764828,6.49572949 8.44144409,5.85743687 8.2887174,4.48255778 C8.25453994,4.17415686 8.25619136,3.95717082 8.28272988,3.80112099 Z M20.9991771,11.8770357 C20.9997251,11.9179585 21,11.9589471 21,12 C21,16.9406923 17.0188468,20.9515364 12.0895088,20.9995641 C16.970233,20.9503326 20.9337111,16.888438 20.9991771,11.8770357 Z" fill="#000000" opacity="0.3"/></g></svg>`
};

const contactMenuApp = Vue.createApp({
    data() {
        return {
            activeTab: document.getElementById('_active_tab')?.value || 'summary',
            cid: document.getElementById('cid')?.value || null,
            baseUrl: document.getElementById('_url')?.value,
            initialFallback: document.getElementById('contact-app')?.dataset?.initial || '',
            loading: false,
            user: {},
            autoNumericConfig: contactAutoCfg,
            flags: tabFlags,
            counts: tabCounts,
            labels: tabLabels,
            icons: tabIcons,
            tabs: []
        };
    },
    async mounted() {
        this.cid = this.cid || this.extractContactId();
        this.bindLegacyHandlers();
        this.tabs = this.buildTabs();
        await this.fetchUserSummary();
        this.loadTab(this.activeTab);
    },
    computed: {
        userInitial() {
            const name = (this.user.account || this.user.email || this.user.phone || '').toString().trim();
            if (name) {
                return name.charAt(0).toUpperCase();
            }
            return (this.initialFallback || '').toString().trim().charAt(0).toUpperCase();
        },
        visibleTabs() {
            return this.tabs.filter(t => t.show);
        }
    },
    methods: {
        extractContactId() {
            const url = new URL(window.location.href);
            const ngParam = url.searchParams.get('ng'); // "contacts/view/1/summary"
            return ngParam.split('/')[2];
        },
        async fetchUserSummary() {
            const contactId = this.extractContactId();
            console.log("contactId", contactId);
            if (!contactId) {
                console.error('Missing contact id for summary fetch');
                return;
            }

            try {
                const response = await fetch('{$app_url}api/contacts/summary/'+ contactId);
                if (!response.ok) {
                    throw new Error('API responded with status '+response.status);
                }
                const data = await response.json();
                if (data && data.customer) {
                    this.user = {
                        account: data.customer.account,
                        email: data.customer.email,
                        phone: data.customer.phone,
                        code: data.customer.code,
                        image: data.customer.img || data.customer.image || ''
                    };
                }
            } catch (error) {
                console.error('Error fetching contact summary', error);
                toastr.error('No se pudo cargar la información del contacto');
            }
        },
        buildTabs() {
            return [
                { id: 'summary', label: this.labels.summary, icon: this.icons.summary, count: null, show: true },
                { id: 'edit', label: this.labels.edit, icon: this.icons.edit, count: null, show: true },
                { id: 'finance', label: this.labels.finance, icon: this.icons.finance, count: null, show: true },
                { id: 'activity', label: this.labels.activity, icon: this.icons.activity, count: null, show: true },
                { id: 'purchases', label: this.labels.purchases, icon: this.icons.purchases, count: this.counts.po, show: this.flags.showPurchases, classNames: 'px-3 px-sm-4 pr-lg-3 pl-lg-5 py-2 fs-md d-flex justify-content-between rounded-pill border-top-left-radius-0 border-bottom-left-radius-0' },
                { id: 'invoices', label: this.labels.invoices, icon: this.icons.invoices, count: this.counts.inv, show: this.flags.invoicing },
                { id: 'quotes', label: this.labels.quotes, icon: this.icons.quotes, count: this.counts.quote, show: this.flags.quotes },
                { id: 'files', label: this.labels.files, icon: this.icons.files, count: null, show: this.flags.documents },
                { id: 'transactions', label: this.labels.transactions, icon: this.icons.transactions, count: null, show: this.flags.accounting },
                { id: 'email', label: this.labels.email, icon: this.icons.email, count: null, show: true },
                { id: 'log', label: this.labels.log, icon: this.icons.log, count: null, show: true },
                { id: 'auto-payment', label: this.labels.autoPayment, icon: this.icons.autoPayment, count: null, show: true },
                { id: 'payment-method', label: this.labels.paymentMethod, icon: this.icons.paymentMethod, count: null, show: true },
                { id: 'more', label: this.labels.more, icon: this.icons.more, count: null, show: true }
            ];
        },
        loadTab(tab) {
            if (!this.baseUrl || !this.cid) {
                console.error('Missing baseUrl or cid');
                return;
            }
            this.activeTab = tab;
            const container = document.getElementById('application_ajaxrender');
            $('#ibox_form').block({ message: block_msg });
            $('html, body').animate({ scrollTop:0 }, '1000', 'swing');
            if (window.history.replaceState) {
                window.history.replaceState({}, '', this.baseUrl + 'contacts/view/' + this.cid + '/' + tab + '/');
            }

            fetch(this.baseUrl + 'contacts/' + tab + '/', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({ cid: this.cid })
            })
                .then(res => res.text())
                .then(html => {
                    this.injectHtml(container, html);
                    this.afterLoad(tab);
                })
                .catch(err => {
                    console.error(err);
                    toastr.error('Error loading tab');
                })
                .finally(() => {
                    $('#ibox_form').unblock();
                });
        },
        injectHtml(container, html) {
            if (!container) return;
            container.innerHTML = '';
            const temp = document.createElement('div');
            temp.innerHTML = html;
            while (temp.firstChild) {
                container.appendChild(temp.firstChild);
            }
            this.runInlineScripts(container);
        },
        runInlineScripts(container) {
            const scripts = container.querySelectorAll('script');
            scripts.forEach(oldScript => {
                const newScript = document.createElement('script');
                if (oldScript.src) {
                    newScript.src = oldScript.src;
                }
                if (oldScript.type) {
                    newScript.type = oldScript.type;
                }
                newScript.text = oldScript.text || oldScript.textContent;
                document.body.appendChild(newScript);
                oldScript.parentNode.removeChild(oldScript);
            });
        },
        afterLoad(tab) {
            document.querySelectorAll('.mmnt').forEach(el => {
                const ut = el.textContent;
                if (ut) el.textContent = moment.unix(ut).fromNow();
            });

            if (this.autoNumericConfig) {
                $('.amount').autoNumeric('init', this.autoNumericConfig);
            }

            switch(tab) {
                case 'edit':
                    $("#country").select2();
                    $('#tags').select2({ tags: true, tokenSeparators: [','] });
                    $('#company_id').select2();
                    break;
                case 'more':
                    var croppicHeaderOptions = {
                        uploadUrl: this.baseUrl + 'sys_imgcrop/save/',
                        cropData:{ "email":1, "rnd":"rnd" },
                        cropUrl:  this.baseUrl + 'sys_imgcrop/crop/',
                        outputUrlId:'picture',
                        customUploadButtonId:'cropContainerHeaderButton',
                        modal:false,
                        loaderHtml:'<div class="loader bubblingG"><span id="bubblingG_1"></span><span id="bubblingG_2"></span><span id="bubblingG_3"></span></div> ',
                        onBeforeImgUpload: function(){},
                        onAfterImgUpload: function(){},
                        onImgDrag: function(){},
                        onImgZoom: function(){},
                        onBeforeImgCrop: function(){},
                        onAfterImgCrop:function(){}
                    };
                    new Croppic('croppic', croppicHeaderOptions);
                    break;
                case 'activity':
                    $('#msg').redactor({ minHeight: 200 });
                    break;
                case 'email':
                    $('#content').redactor({ minHeight: 300 });
                    break;
                case 'files':
                    $("#c_file").select2();
                    break;
                case 'client-password-manager':
                    var clipboard = new Clipboard('.copy_to_clipboard', {
                        text: function(trigger) {
                            return trigger.getAttribute('aria-label');
                        }
                    });
                    clipboard.on('success', function(e) {
                        toastr.success('Text Copied!');
                        e.clearSelection();
                    });
                    break;
                default:
                    break;
            }
        },
        bindLegacyHandlers() {
            $("#emsg").hide();
            const $modal = $('#cloudonex_body');
            const $ibox_form = $('#ibox_form');
            const baseUrl = this.baseUrl;
            const cid = this.cid;
            const sysrender = $('#application_ajaxrender');

            $(".cdelete").click(function (e) {
                e.preventDefault();
                var id = this.id;
                var lan_msg = $("#_lan_are_you_sure").val();
                app.confirm(lan_msg, function(result) {
                    if(result){
                        window.location.href = baseUrl + "delete/user/" + id + '/';
                    }
                });
            });

            $("#note_update").click(function (e) {
                e.preventDefault();
                $('#ibox_panel').block({ message: null });
                $.post(baseUrl + 'contacts/edit-notes/', {
                    cid: $('#cid').val(),
                    notes: $('#notes').val()
                }).done(function () {
                    $('#ibox_panel').unblock();
                });
            });

            sysrender.on('click', '#acf-post', function(e){
                e.preventDefault();
                $('#ibox_form').block({ message: null });
                $.post(baseUrl + 'contacts/add-activity-post/', {
                    cid: $('#cid').val(),
                    msg: $('#msg').val(),
                    icon: $('#activity-type').val()
                }).done(function (data) {
                    if ($.isNumeric(data)) {
                        window.location = baseUrl + 'contacts/view/' + data + '/activity/';
                    } else {
                        $('#ibox_form').unblock();
                        $("#emsgbody").html(data);
                        $("#emsg").show("slow");
                    }
                });
            });

            function isEmpty(value) {
                if (value === null || value === undefined) return true;
                if (typeof value === 'string') {
                    return value.trim().length === 0;
                }
                if (Array.isArray(value)) {
                    return value.length === 0;
                }
                if (typeof value === 'object') {
                    return Object.keys(value).length === 0;
                }
                return false;
            }

            sysrender.on('click', '#submit', function(e){
                e.preventDefault();
                $ibox_form.block({ message: null });
                let valor_grupo =  $("#group").val();
                if(isEmpty(valor_grupo) || valor_grupo == 0 || valor_grupo == "0"){
                    Swal.fire({ icon: "error", title: "Oops...", text: "Please select a group" });
                    return;
                }
                $.post(baseUrl + 'contacts/edit-post/', $( "#rform" ).serialize())
                    .done(function (data) {
                        if ($.isNumeric(data)) {
                            window.location = baseUrl + 'contacts/view/' + data + '/edit/';
                        } else {
                            $('#ibox_form').unblock();
                            $("#emsgbody").html(data);
                            $("#emsg").show("slow");
                        }
                    });
            });

            sysrender.on('click','#save_credit_card',function (e) {
                e.preventDefault();
                $ibox_form.block({ message: null });
                $.post(baseUrl + 'contacts/save_credit_card/', $('#credit_card_from').serialize())
                    .done(function (data) {
                        if ($.isNumeric(data)) {
                            window.location = baseUrl + 'contacts/view/' + data + '/credit_card_info/';
                        } else {
                            $('#ibox_form').unblock();
                            $("#emsgbody").html(data);
                            $("#emsg").show("slow");
                        }
                    });
            });

            sysrender.on('click', '#send_email', function(e){
                e.preventDefault();
                $ibox_form.block({ message: null });
                $.post(baseUrl + 'contacts/send_email/', {
                    cid: $('#cid').val(),
                    subject: $('#subject').val(),
                    message: $('#content').val(),
                }).done(function (data) {
                    if ($.isNumeric(data)) {
                        window.location = baseUrl + 'contacts/view/' + data + '/email/';
                    } else {
                        $('#ibox_form').unblock();
                        $("#emsgbody").html(data);
                        $("#emsg").show("slow");
                    }
                });
            });

            sysrender.on('click', '#assign_file', function(e){
                e.preventDefault();
                $ibox_form.block({ message: null });
                $.post(baseUrl + 'contacts/assign_file/', {
                    cid: $('#cid').val(),
                    did: $('#c_file').val()
                }).done(function (data) {
                    if ($.isNumeric(data)) {
                        window.location = baseUrl + 'contacts/view/' + data + '/files/';
                    } else {
                        $('#ibox_form').unblock();
                        $("#emsgbody").html(data);
                        $("#emsg").show("slow");
                    }
                });
            });

            sysrender.on('click', '#no_image', function(e){
                e.preventDefault();
                $('#picture').val('');
            });

            sysrender.on('change', '#contact_note', function(){
                $.post(baseUrl + 'contacts/edit-notes/', {
                    cid: '{$d['id']}',
                    notes: $('#contact_note').val()
                });
            });

            sysrender.on('change', '#is_primary_contact', function(){
                toastr.success('{$_L['Updated']}');
                let set = 0;
                if($(this).prop('checked')){
                    set = 1;
                }
                $.post(baseUrl + 'contacts/set-boolean/', {
                    contact_id: '{$d['id']}',
                    key: 'is_primary_contact',
                    value: set,
                });
            });

            sysrender.on('click', '#opt_gravatar', function(e){
                e.preventDefault();
                $('.picture').val('gravatar');
            });

            sysrender.on('click', '#more_submit', function(e){
                e.preventDefault();
                $ibox_form.block({ message: null });
                $.post(baseUrl + 'contacts/edit-more/', {
                    cid: $('#cid').val(),
                    picture: $('#picture').val(),
                    facebook: $('#facebook').val(),
                    google: $('#google').val(),
                    linkedin: $('#linkedin').val()
                }).done(function (data) {
                    if ($.isNumeric(data)) {
                        window.location = baseUrl + 'contacts/view/' + data + '/';
                    } else {
                        $('#ibox_form').unblock();
                        $("#emsgbody").html(data);
                        $("#emsg").show("slow");
                    }
                });
            });

            sysrender.on('click', '.clickable', function(e){
                e.preventDefault();
                $(".compose-toolbar li").removeClass("action-active");
                $(this).addClass("action-active");
                var atype = $(this).html();
                $('#activity-type').val(atype);
            });

            sysrender.on('click', '.activity_edit', function(e){
                e.preventDefault();
                var activity_id = this.id;
                $.fancybox.open({
                    src  :  baseUrl + 'contacts/modal_edit_activity/' +  activity_id,
                    type : 'ajax',
                    opts : {
                        touch: false,
                        keyboard: false,
                        autoFocus: false,
                        trapFocus: false,
                        afterShow : function() {
                            $('.edit_activity').redactor({ minHeight: 200 });
                        }
                    },
                });
            });

            $modal.on('click', '.modal_activity_submit', function(e){
                e.preventDefault();
                $.post( baseUrl + "contacts/edit_activity_post/", $("#ib_modal_edit_activity_form").serialize())
                    .done(function( data ) {
                        if ($.isNumeric(data)) {
                            location.reload();
                        } else {
                            $modal.modal('loading');
                            toastr.error(data);
                        }
                    });
            });

            $modal.on('click', '.modal_activity_edit_cancel', function(e){
                location.reload();
            });

            $modal.on('click', '.clickable', function(e){
                e.preventDefault();
                $(".compose-toolbar li").removeClass("action-active");
                $(this).addClass("action-active");
                var atype = $(this).html();
                $('#edit_activity_type').val(atype);
            });

            sysrender.on('click', '.choose_from_template', function(e){
                e.preventDefault();
                $.fancybox.open({
                    src  :  baseUrl + 'handler/view_email_templates/',
                    type : 'ajax',
                    opts : {
                        afterShow : function() {
                            $('#tbl_email_templates').dataTable({
                                "language": {
                                    "emptyTable": "{$_L['No items to display']}",
                                    "info":      "{$_L['Showing _START_ to _END_ of _TOTAL_ entries']}",
                                    "infoEmpty":      "{$_L['Showing 0 to 0 of 0 entries']}",
                                    buttons: {
                                        pageLength: '{$_L['Show all']}'
                                    },
                                    searchPlaceholder: "{__('Search')}"
                                },
                            });
                        }
                    },
                });
            });

            $modal.on('click', '.eml_select', function(e) {
                e.preventDefault();
                var eml_id = this.id;
                $.getJSON(baseUrl + "handler/json_eml_tpl/"+eml_id + '/' + {$contact->id}, function (data) {
                    $("#subject").val(data.subject);
                    $('#content').redactor('code.set', data.message);
                    $.fancybox.close();
                });
            });

            sysrender.on('click', '.add_fund', function(e){
                e.preventDefault();
                (async () => {
                    const { value: amount } = await Swal.fire({
                        title: '{__('Add Fund')}',
                        input: 'text',
                        inputLabel: '{__('Amount')}',
                        inputPlaceholder: '{__('Amount')}',
                    });
                    if (amount) {
                        $.redirectPost(baseUrl + "contacts/add_fund/",{ amount: amount, cid: cid});
                    }
                })();
            });

            sysrender.on('click', '.return_fund', function(e){
                e.preventDefault();
                (async () => {
                    const { value: amount } = await Swal.fire({
                        title: '{__('Return Fund')}',
                        input: 'text',
                        inputLabel: '{__('Amount')}',
                        inputPlaceholder: '{__('Amount')}',
                    });
                    if (amount) {
                        $.redirectPost(baseUrl + "contacts/return_fund/",{ amount: amount, cid: cid});
                    }
                })();
            });
        }
    }
});

document.addEventListener('DOMContentLoaded', function() {
    const mountTarget = document.getElementById('contact-app');
    if (mountTarget) {
        contactMenuApp.mount(mountTarget);
    } else {
        console.error('contactMenuApp mount target not found');
    }
});
</script>
{/block}

