{block name="head"}
<meta charset="utf-8">
<title>Sales Manager Dashboard - HISPANOS DE ÉXITO LLC</title>
<meta name="description" content="HISPANOS DE ÉXITO LLC">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no, user-scalable=no, minimal-ui">
<!-- Call App Mode on ios devices -->
<meta name="apple-mobile-web-app-capable" content="yes">
<!-- Remove Tap Highlight on Windows Phone IE -->
<meta name="msapplication-tap-highlight" content="no">

<link rel="icon" href="{{APP_URL}}/storage/system/{get_or_default($config,'icon-32','icon-32x32.png')}" sizes="32x32" />
<link rel="icon" href="{{APP_URL}}/storage/system/{get_or_default($config,'icon-192','icon-192x192.png')}" sizes="192x192" />
<link rel="apple-touch-icon" href="{{APP_URL}}/storage/system/{get_or_default($config,'icon-180','icon-180x180.png')}" />
<meta name="msapplication-TileImage" content="{{APP_URL}}/storage/system/{get_or_default($config,'icon-270','icon-270x270.png')}" />

<link id="custom_css_app" rel="stylesheet" media="screen, print" href="{{APP_URL}}/ui/custom/css/style.css?v={{_raid()}}">

<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<style>
body {
    margin: 0;
    padding: 0;
    background-color: #0b1524;
}
</style>
{/block}

{block name="content"}
<div id="sales-dashboard" class="sales-manager-dashboard" v-cloak>
    <div class="sd-shell">
        <div class="sd-header">
            <div>
                <div class="eyebrow">Sales</div>
                <h1>Sales Manager Dashboard</h1>
                <!--<p>{$salesBoard.period|default:'Current Week'}</p>-->
            </div>
        </div>

        <div class="sd-layout">
            <div class="sd-skeleton" v-if="showSkeleton">
                <div class="skeleton-grid">
                    <div class="skeleton-card skeleton-span-8">
                        <div class="skeleton-line lg skeleton-shine full"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line sm skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                    </div>
                    <div class="skeleton-card skeleton-span-4">
                        <div class="skeleton-line lg skeleton-shine full"></div>
                        <ul class="list-unstyled skeleton-list mb-0">
                            <li class="skeleton-line md skeleton-shine"></li>
                            <li class="skeleton-line md skeleton-shine"></li>
                            <li class="skeleton-line sm skeleton-shine"></li>
                        </ul>
                    </div>
                    <div class="skeleton-card skeleton-span-6">
                        <div class="skeleton-line lg skeleton-shine full"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line sm skeleton-shine"></div>
                    </div>
                    <div class="skeleton-card skeleton-span-6">
                        <div class="skeleton-line lg skeleton-shine full"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line sm skeleton-shine"></div>
                    </div>
                    <div class="skeleton-card skeleton-span-12">
                        <div class="skeleton-line lg skeleton-shine full"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                    </div>
                </div>
            </div>

            <div class="sd-main" v-if="!showSkeleton">
                <div class="sd-grid top">
                    <div class="sd-stack">
                        <div class="sd-subcard">
                            <h3 class="title-lg">Total Sales</h3>
                            <p class="value total-gross" id="stat-total-sales">{{ formattedStaffTotal }}</p>

                            <h4 class="title-lg">Total Sales (Invoices)</h4>
                            <p class="value total-net" id="stat-total-sales-net">{{ formattedTotalSales }}</p>

                            <h4 class="title-lg">Total invoice (Paid + Partially Paid)</h4>
                            <p class="value total-net" id="stat-total-sales">{{ formattedPaidInvoices }}</p>
                        </div>
                        <div class="sd-subcard">
                            <h3 class="title-lg">Total Invoices</h3>
                            <p class="value" id="stat-total-sales">{{ invoicesMetrics.total }}</p>

                            <ul class="list-unstyled stat-invoice-details mb-0 small text-muted">
                                <li>Paid: {{ invoicesMetrics.paid }}</li>
                                <li>Partially Paid: {{ invoicesMetrics.partial }}</li>
                                <li>Not Paid: {{ invoicesMetrics.unpaid }}</li>
                            </ul>
                        </div>
                    </div>

                    <div class="sd-card ranking">
                        <h3 style="margin-bottom:20px;">Revenue by Sales Rep</h3>
                        <div class="reps" id="reps-container">
                            <p v-if="!topReps.length" class="text-muted">No sales data available.</p>
                            <template v-else>
                                <div v-for="rep in topReps" :key="rep.id || rep.fullname || rep.name" :class="['rep-card', medalClass(rep.rank)]">
                                    <div class="rank">#{{ rep.rank }}</div>
                                    <div :class="['rep-avatar', avatarClass(rep.rank), rep.image ? '' : 'is-fallback']">
                                        <img v-if="rep.image" :src="resolveImageUrl(rep.image)" :alt="rep.fullname || rep.name || 'Sales rep'" @error="onAvatarError(rep)" />
                                        <div class="initials">
                                            <span>{{ rep.initials || getInitials(rep.fullname || rep.name) }}</span>
                                        </div>
                                        <div class="medal-badge" :class="badgeClass(rep.rank)">{{ rep.rank }}</div>
                                        <div v-if="rep.rank === 1" class="sparkles">***</div>
                                    </div>
                                    <div class="rep-meta">
                                        <p class="name">{{ rep.fullname || rep.name || 'Unknown' }}</p>
                                        <p class="value">{{ formatMoney(rep.total_amount || rep.value || 0) }}</p>
                                    </div>
                                </div>
                            </template>
                        </div>
                    </div>
                </div>

                <div class="sd-grid groups">
                    <div class="sd-card group-board">
                        <div class="group-board-grid">
                            <div v-for="group in groupedSales" :key="group.key" class="group-column">
                                <div :class="['group-summary', group.themeClass]">
                                    <div class="group-title">{{ group.label }}</div>
                                    <div class="group-stats">
                                        <div class="group-stat">
                                            <span class="label">Won Deals</span>
                                            <span class="value">{{ formatMoney(group.totalWon) }}</span>
                                        </div>
                                        <div class="group-stat">
                                            <span class="label">Tax Issued</span>
                                            <span class="value accent">{{ group.taxIssued }} of {{ group.taxTarget }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="group-members">
                                    <div v-if="!group.hasActivity" class="group-empty">No activity recorded for this group yet.</div>
                                    <template v-else>
                                        <div v-for="member in group.members" :key="member.id" class="group-member">
                                            <div class="member-avatar">{{ member.initials }}</div>
                                            <div class="member-meta">
                                                <div class="member-name">{{ member.name }}</div>
                                                <div class="member-won">{{ formatMoney(member.won) }} Won</div>
                                            </div>
                                            <div class="member-tax" :class="{ active: member.taxes > 0 }">
                                                {{ member.taxes }} / {{ group.taxPerRep }}
                                            </div>
                                        </div>
                                    </template>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="sd-grid bottom">
                    <div class="sd-card leaderboard">
                        <h3>Current Week</h3>
                        <table>
                            <thead>
                                <tr>
                                    <th>Employee</th>
                                    <th>Won Deals</th>
                                    <th class="text-end">Tax Issued</th>
                                </tr>
                            </thead>
                            <tbody id="current-month-body">
                                <tr v-if="!currentMonthRows.length">
                                    <td colspan="3" class="text-center text-muted">No sales data available.</td>
                                </tr>
                                <tr v-else v-for="(row, idx) in currentMonthRows" :key="row.id || idx">
                                    <td>{{ row.fullname || row.name || 'Unknown' }}</td>
                                    <td>{{ formatMoney(row.total_amount || 0) }}</td>
                                    <td class="text-end">
                                        <span
                                        :style="{
                                            color: Number(row.taxes_issued) > 0 ? '#5de0a3' : 'inherit',
                                            fontWeight: Number(row.taxes_issued) > 0 ? 600 : 'normal'
                                        }"
                                        >
                                        {{ Number(row.taxes_issued) || 0 }} of 15
                                        </span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="sd-card team-bars">
                        <h3>Taxes by Team</h3>
                        <div class="bar-label" style="margin-bottom: 35px;">
                            <span>Total</span>
                            <span>{{ Math.round(teamDealsTotal || 0) }}</span>
                        </div>
                        <div v-for="(bar, idx) in teamDeals.bars" :key="idx" class="bar-row">
                            <div class="bar-label">
                                <span><img :src="'https://flagcdn.com/28x21/' + bar.flag.toLowerCase() + '.png'" /> {{ bar.flag + " Team" }}</span>
                                <span>{{ Number(bar.value || 0) }}</span>
                            </div>
                            <div class="bar-track">
                                <div class="bar" :style="{literal}{ width: (bar.percent || 0) + '%' }{/literal}"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="sd-aside sd-skeleton" v-if="showSkeleton">
                <div class="skeleton-grid">
                    <div class="skeleton-card skeleton-span-12">
                        <div class="skeleton-line lg skeleton-shine full"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line sm skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line sm skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line sm skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                        <div class="skeleton-line md skeleton-shine"></div>
                    </div>
                </div>
            </div>

            <div class="sd-aside" v-if="!showSkeleton">
                <div class="sd-card pbx-groups">
                    <h3>PBX Call Groups</h3>
                    <div v-if="pbxLoading && !pbxHasLoaded" class="sd-skeleton pbx-skeleton">
                        <div class="skeleton-grid">
                            <div class="skeleton-card skeleton-span-12">
                                <div class="skeleton-line lg skeleton-shine full"></div>
                                <div class="skeleton-line sm skeleton-shine"></div>
                                <div class="skeleton-line md skeleton-shine"></div>
                                <div class="skeleton-line md skeleton-shine"></div>
                            </div>
                            <div class="skeleton-card skeleton-span-12">
                                <div class="skeleton-line md skeleton-shine full"></div>
                                <div class="skeleton-line sm skeleton-shine"></div>
                                <div class="skeleton-line sm skeleton-shine"></div>
                            </div>
                            <div class="skeleton-card skeleton-span-12">
                                <div class="skeleton-line md skeleton-shine full"></div>
                                <div class="skeleton-line sm skeleton-shine"></div>
                                <div class="skeleton-line sm skeleton-shine"></div>
                            </div>
                        </div>
                    </div>
                    <div v-else-if="pbxError" class="text-center py-3">
                        <p class="text-muted">No calls data available.</p>
                    </div>
                    <div v-else class="pbx-groups-content">
                        <!-- Total Calls Display -->
                        <div class="pbx-total-calls">
                            <div class="total-number">{{ pbxTotalCalls }}</div>
                            <div class="total-label">TOTAL CALLS</div>
                        </div>

                        <!-- Group A -->
                        <div class="pbx-group">
                            <div class="group-header">
                                <span class="group-badge">GROUP A</span>
                                <span class="group-label">IN / OUT</span>
                            </div>
                            <div v-for="emp in pbxGroupedData.groupA" :key="emp.name" class="employee-row">
                                <span class="employee-name">{{ emp.name }}</span>
                                <span class="employee-stats">
                                    <span class="stat-in">{{ emp.incoming }}</span>
                                    <span class="stat-separator">/</span>
                                    <span class="stat-out">{{ emp.outgoing }}</span>
                                </span>
                            </div>
                        </div>

                        <!-- Group B -->
                        <div class="pbx-group">
                            <div class="group-header">
                                <span class="group-badge">GROUP B</span>
                                <span class="group-label">IN / OUT</span>
                            </div>
                            <div v-for="emp in pbxGroupedData.groupB" :key="emp.name" class="employee-row">
                                <span class="employee-name">{{ emp.name }}</span>
                                <span class="employee-stats">
                                    <span class="stat-in">{{ emp.incoming }}</span>
                                    <span class="stat-separator">/</span>
                                    <span class="stat-out">{{ emp.outgoing }}</span>
                                </span>
                            </div>
                        </div>

                        <!-- Group C -->
                        <div class="pbx-group">
                            <div class="group-header">
                                <span class="group-badge">GROUP C</span>
                                <span class="group-label">IN / OUT</span>
                            </div>
                            <div v-for="emp in pbxGroupedData.groupC" :key="emp.name" class="employee-row">
                                <span class="employee-name">{{ emp.name }}</span>
                                <span class="employee-stats">
                                    <span class="stat-in">{{ emp.incoming }}</span>
                                    <span class="stat-separator">/</span>
                                    <span class="stat-out">{{ emp.outgoing }}</span>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
{/block}

{block name="script"}
<script src="https://unpkg.com/vue@3/dist/vue.global.prod.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    var _Vue = (typeof Vue !== 'undefined') ? Vue : {};
    var createApp = _Vue.createApp, ref = _Vue.ref, computed = _Vue.computed, onMounted = _Vue.onMounted, watch = _Vue.watch, onBeforeUnmount = _Vue.onBeforeUnmount, nextTick = _Vue.nextTick;
    var apiUrl = "{$app_url}api/dashboard/sales?range=weekly";
    var currencyCode = "{$config['home_currency']|default:'USD'}";
    var appBaseUrl = "{$app_url|default:''}";

    if (!createApp) {
        console.warn('Vue is not available.');
        return;
    }

    var initialReps = [
{foreach from=$salesBoard.reps item=rep name=replist}
        {
            id: '{$rep.id|default:''|escape:'javascript'}',
            name: '{$rep.name|escape:'javascript'}',
            fullname: '{$rep.fullname|escape:'javascript'}',
            rank: {$rep.rank|default:0},
            value: '{$rep.value|escape:'javascript'}',
            total_amount: Number('{$rep.total_amount|default:0|escape:'javascript'}') || 0,
            image: '{$rep.image|escape:'javascript'}',
            initials: '{$rep.initials|escape:'javascript'}'
        }{if not $smarty.foreach.replist.last},{/if}
{/foreach}
    ];

    var initialLeaderboard = [
{foreach from=$salesBoard.leaderboard item=row name=leadlist}
        {
            id: '{$row.id|default:''|escape:'javascript'}',
            name: '{$row.name|escape:'javascript'}',
            fullname: '{$row.fullname|escape:'javascript'}',
            total_amount: Number('{$row.won_deals|default:0|escape:'javascript'}') || 0,
            demos: '{$row.demos|escape:'javascript'}',
            taxes_issued: Number('{$row.taxes_issued|default:0|escape:'javascript'}') || 0
        }{if not $smarty.foreach.leadlist.last},{/if}
{/foreach}
    ];

    var initialKpis = [
{foreach from=$salesBoard.kpis item=kpi name=kpilist}
        {
            label: '{$kpi.label|escape:'javascript'}',
            value: '{$kpi.value|escape:'javascript'}',
            note: '{$kpi.note|escape:'javascript'}'
        }{if not $smarty.foreach.kpilist.last},{/if}
{/foreach}
    ];

    var initialStaffSalesTotal = '{$salesBoard.staff_sales_week.total|default:0|escape:'javascript'}';

    var initialTeamDeals = {
        average: '{$salesBoard.team_deals.average|escape:'javascript'}',
        bars: [
{foreach from=$salesBoard.team_deals.bars item=bar name=barlist}
            {
                flag: '{$bar.flag|escape:'javascript'}',
                label: '{$bar.label|escape:'javascript'}',
                value: '{$bar.value|escape:'javascript'}',
                percent: Number('{$bar.percent|escape:'javascript'}') || 0
            }{if not $smarty.foreach.barlist.last},{/if}
{/foreach}
        ]
    };

    var initialGroupedSales = [];
    var groupDefinitions = [
        {
            key: 'A',
            label: 'Group A',
            themeClass: 'group-a',
            members: [
                { id: 47, name: 'Ninoska Chirinos' },
                { id: 48, name: 'Michelle Cerritos' },
                { id: 54, name: 'Cristhian Moreno' }
            ]
        },
        {
            key: 'B',
            label: 'Group B',
            themeClass: 'group-b',
            members: [
                { id: 51, name: 'Michell Paz' },
                { id: 32, name: 'Jose Gutierrez' },
                { id: 55, name: 'Julia Doubleday' }
            ]
        },
        {
            key: 'C',
            label: 'Group C',
            themeClass: 'group-c',
            members: [
                { id: 50, name: 'Heidy Calix' },
                { id: 52, name: 'Emilio Pagoaga' },
                { id: 56, name: 'Sara Orellana' }
            ]
        }
    ];

    var groupTaxTarget = 15;

    var defaultDealsWonValue = '{$salesBoard.stats.deals_won.value|escape:'javascript'}';
    var defaultDealsWonTarget = '{$salesBoard.stats.deals_won.target|escape:'javascript'}';
    var defaultForecasted = '{$salesBoard.stats.forecasted|escape:'javascript'}';
    var initialInvoiceMetrics = {
        total: Number('{$salesBoard.metrics_invoices365.count_sales|default:0|escape:'javascript'}') || 0,
        paid: Number('{$salesBoard.metrics_invoices365.count_paid|default:0|escape:'javascript'}') || 0,
        partial: Number('{$salesBoard.metrics_invoices365.count_partial|default:0|escape:'javascript'}') || 0,
        unpaid: Number('{$salesBoard.metrics_invoices365.count_unpaid|default:0|escape:'javascript'}') || 0
    };
    var initialTotalSalesNet = Number('{$salesBoard.total_sales|default:0|escape:'javascript'}') || 0;

    createApp({
        setup: function () {
            var refreshTimer = ref(null);
            var isLoading = ref(true);
            var hasLoaded = ref(false);
            var reps = ref(initialReps);
            var currentMonthRows = ref(initialLeaderboard.length ? initialLeaderboard : initialReps);
            var kpis = ref(initialKpis);
            var staffSalesTotal = ref(initialStaffSalesTotal);
            var invoicesMetrics = ref(initialInvoiceMetrics);
            var totalSalesNet = ref(initialTotalSalesNet);
            var paidInvoicesAmount = ref(0);
            var teamDeals = ref(initialTeamDeals);
            var groupedSalesRaw = ref(initialGroupedSales);
            var paymentMethods = ref([]);
            var dealsWonValue = ref(defaultDealsWonValue);
            var dealsWonTarget = ref(defaultDealsWonTarget);
            var forecasted = ref(defaultForecasted);
            var paymentChartEl = ref(null);
            var paymentLegendEl = ref(null);
            var paymentEmptyEl = ref(null);
            var chartInstances = { paymentMethods: null };
            var pbxData = ref([]);
            var pbxLoading = ref(false);
            var pbxNoData = ref(false);
            var pbxHasLoaded = ref(false);
            var pbxError = ref(null);
            var pbxGroupedData = ref({ groupA: [], groupB: [], groupC: [] });
            var pbxGroupTotals = ref({ groupA: 0, groupB: 0, groupC: 0 });
            var pbxTotalCalls = ref(0);

            var currencyFormatter;
            try {
                currencyFormatter = new Intl.NumberFormat('en-US', { style: 'currency', currency: currencyCode });
            } catch (e) {
                currencyFormatter = null;
            }

            var formatMoney = function (val) {
                var num = Number(val || 0);
                if (currencyFormatter) {
                    return currencyFormatter.format(num);
                }
                return num.toFixed(2);
            };

            var parseAmount = function (str) {
                if (!str) { return 0; }
                var clean = String(str).replace(/[^0-9.,a-zA-Z]/g, '').trim();
                var mult = 1;
                if (clean.match(/b$/i)) { mult = 1e9; clean = clean.slice(0, -1); }
                else if (clean.match(/m$/i)) { mult = 1e6; clean = clean.slice(0, -1); }
                else if (clean.match(/k$/i)) { mult = 1e3; clean = clean.slice(0, -1); }
                clean = clean.replace(/,/g, '');
                var num = parseFloat(clean);
                if (isNaN(num)) { return 0; }
                return num * mult;
            };

            var getInitials = function (name) {
                if (!name) { return ''; }
                var parts = name.trim().split(/\s+/);
                if (parts.length === 1) {
                    return parts[0].substring(0, 2).toUpperCase();
                }
                return ((parts[0][0] || '') + (parts[1][0] || '')).toUpperCase();
            };

            var resolveImageUrl = function (url) {
                if (!url) { return ''; }
                var out = String(url);
                if (out.indexOf('http') === 0) { return out; }
                if (appBaseUrl) {
                    return appBaseUrl.replace(/\/+$/, '') + '/' + out.replace(/^\/+/, '');
                }
                return out;
            };

            var gaugeDegree = computed(function () {
                var val = parseAmount(dealsWonValue.value);
                var target = parseAmount(dealsWonTarget.value);
                var pct = target > 0 ? Math.min(100, Math.max(0, (val / target) * 100)) : 0;
                return pct * 1.8;
            });

            var formattedDealsWon = computed(function () { return formatMoney(parseAmount(dealsWonValue.value)); });
            var teamDealsTotal = computed(function () {
                var bars = (teamDeals.value && teamDeals.value.bars) ? teamDeals.value.bars : [];
                return bars.reduce(function (sum, bar) {
                    return sum + Number((bar && bar.value) || 0);
                }, 0);
            });
            var formattedDealsTarget = computed(function () { return formatMoney(parseAmount(dealsWonTarget.value)); });
            var formattedForecasted = computed(function () { return formatMoney(parseAmount(forecasted.value)); });
            var formattedStaffTotal = computed(function () { return formatMoney(parseAmount(staffSalesTotal.value)); });
            var formattedTotalSales = computed(function () { return formatMoney(parseAmount(totalSalesNet.value)); });
            var formattedPaidInvoices = computed(function () { return formatMoney(parseAmount(paidInvoicesAmount.value)); });
            var formattedInvoices = computed(function () {
                return {
                    total: Number(invoicesMetrics.value.total || 0),
                    paid: Number(invoicesMetrics.value.paid || 0),
                    partial: Number(invoicesMetrics.value.partial || 0),
                    unpaid: Number(invoicesMetrics.value.unpaid || 0)
                };
            });
            var showSkeleton = computed(function () {
                return !hasLoaded.value && isLoading.value;
            });

            var topReps = computed(function () {
                var rows = (reps.value || []).slice().sort(function (a, b) {
                    return Number(b.total_amount || 0) - Number(a.total_amount || 0);
                });
                rows.forEach(function (rep, idx) { rep.rank = idx + 1; });
                return rows.slice(0, 3);
            });

            var buildGroupsFromDefinitions = function () {
                var rows = Array.isArray(reps.value) ? reps.value : [];

                return groupDefinitions.map(function (group) {
                    var members = group.members.map(function (member) {
                        var rep = rows.find(function (row) {
                            return Number(row.id) === Number(member.id);
                        }) || {};
                        var name = rep.fullname || rep.name || member.name || 'Unknown';
                        var won = Number(rep.total_amount || rep.value || 0);
                        var taxes = Number(rep.taxes_issued || rep.taxesIssued || rep.taxes || 0);

                        return {
                            id: member.id,
                            name: name,
                            initials: getInitials(name),
                            won: won,
                            taxes: taxes
                        };
                    });

                    var totalWon = members.reduce(function (sum, member) {
                        return sum + Number(member.won || 0);
                    }, 0);
                    var taxIssued = members.reduce(function (sum, member) {
                        return sum + Number(member.taxes || 0);
                    }, 0);
                    var hasActivity = members.some(function (member) {
                        return Number(member.won || 0) > 0 || Number(member.taxes || 0) > 0;
                    });

                    return {
                        key: group.key,
                        label: group.label,
                        themeClass: group.themeClass,
                        members: members,
                        totalWon: totalWon,
                        taxIssued: taxIssued,
                        taxTarget: group.members.length * groupTaxTarget,
                        taxPerRep: groupTaxTarget,
                        hasActivity: hasActivity
                    };
                });
            };

            var normalizeGroup = function (group) {
                var rawMembers = Array.isArray(group.members) ? group.members : [];
                var members = rawMembers.map(function (member) {
                    var name = member.name || member.fullname || 'Unknown';
                    var won = Number(member.total_amount || member.won || 0);
                    var taxes = Number(member.taxes_issued || member.taxes || 0);

                    return {
                        id: member.id,
                        name: name,
                        initials: getInitials(name),
                        won: won,
                        taxes: taxes
                    };
                });

                var totalWon = Number(group.total_won || group.totalWon || 0);
                if (!totalWon) {
                    totalWon = members.reduce(function (sum, member) {
                        return sum + Number(member.won || 0);
                    }, 0);
                }
                var taxIssued = Number(group.taxes_issued || group.taxIssued || 0);
                if (!taxIssued) {
                    taxIssued = members.reduce(function (sum, member) {
                        return sum + Number(member.taxes || 0);
                    }, 0);
                }
                var taxPerRep = Number(group.tax_per_rep || group.taxPerRep || groupTaxTarget);
                var taxTarget = Number(group.tax_target || group.taxTarget || (members.length * taxPerRep));
                var hasActivity = (typeof group.has_activity !== 'undefined')
                    ? Boolean(group.has_activity)
                    : ((typeof group.hasActivity !== 'undefined')
                        ? Boolean(group.hasActivity)
                        : members.some(function (member) {
                            return Number(member.won || 0) > 0 || Number(member.taxes || 0) > 0;
                        }));
                var themeClass = group.theme_class || group.themeClass || (group.key ? ('group-' + String(group.key).toLowerCase()) : '');
                var label = group.label || group.name || (group.key ? ('Group ' + group.key) : 'Group');

                return {
                    key: group.key || '',
                    label: label,
                    themeClass: themeClass,
                    members: members,
                    totalWon: totalWon,
                    taxIssued: taxIssued,
                    taxTarget: taxTarget,
                    taxPerRep: taxPerRep,
                    hasActivity: hasActivity
                };
            };

            var groupedSales = computed(function () {
                if (Array.isArray(groupedSalesRaw.value) && groupedSalesRaw.value.length) {
                    return groupedSalesRaw.value.map(normalizeGroup);
                }

                return buildGroupsFromDefinitions();
            });

            var medalClass = function (rank) {
                if (rank === 1) { return 'medal-gold'; }
                if (rank === 2) { return 'medal-silver'; }
                if (rank === 3) { return 'medal-bronze'; }
                return '';
            };
            var avatarClass = function (rank) {
                if (rank === 1) { return 'avatar-gold'; }
                if (rank === 2) { return 'avatar-silver'; }
                if (rank === 3) { return 'avatar-bronze'; }
                return '';
            };
            var badgeClass = function (rank) {
                if (rank === 1) { return 'badge-gold'; }
                if (rank === 2) { return 'badge-silver'; }
                return 'badge-bronze';
            };

            var onAvatarError = function (rep) {
                if (rep) { rep.image = ''; }
            };

            var loadPbxData = function (forceSync) {
                pbxLoading.value = true;
                pbxNoData.value = false;
                pbxError.value = null;
                
                // Get current year and month in YYYYMM format
                var now = new Date();
                var currentMonth = now.getFullYear().toString() + (now.getMonth() + 1).toString().padStart(2, '0');
                
                // Calculate start and end of current week (Monday to Sunday)
                var currentDay = now.getDay(); // 0 = Sunday, 1 = Monday, ..., 6 = Saturday
                var daysSinceMonday = currentDay === 0 ? 6 : currentDay - 1; // Adjust for Monday start
                
                var startOfWeek = new Date(now);
                startOfWeek.setDate(now.getDate() - daysSinceMonday);
                startOfWeek.setHours(0, 0, 0, 0);
                
                var endOfWeek = new Date(startOfWeek);
                endOfWeek.setDate(startOfWeek.getDate() + 6);
                endOfWeek.setHours(23, 59, 59, 999);
                
                // Format dates as YYYY-MM-DD
                var formatDate = function(date) {
                    var year = date.getFullYear();
                    var month = (date.getMonth() + 1).toString().padStart(2, '0');
                    var day = date.getDate().toString().padStart(2, '0');
                    return year + '-' + month + '-' + day;
                };
                
                var initDate = formatDate(startOfWeek);
                var endDate = formatDate(endOfWeek);
                
                // Build filters object with direction and callStatus

                var filters = {
                    direction: {
                        incoming: true,
                        outgoing: true,
                        internal: false
                    },
                    callStatus: {
                        answered: true,
                        notAnswered: false
                    },
                    date: {
                        initDate: initDate,
                        endDate: endDate
                    }
                };
                
                fetch(appBaseUrl + 'api/pbx/cdr', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    credentials: 'include',
                    body: JSON.stringify({
                        month: currentMonth,
                        limit: 100,
                        order: "callerid",
                        filters: JSON.stringify(filters),
                        bypass_cache: false,
                        sync: Boolean(forceSync),
                        source: "agg"
                    })
                })
                .then(function (response) {
                    if (!response.ok) {
                        return response.text().then(function (bodyText) {
                            console.error('PBX API error:', response.status, bodyText);
                            throw new Error('PBX data not available');
                        });
                    }
                    return response.json();
                })
                    .then(function (result) {
                        console.log('PBX CDR Data loaded:', result);
                        if (result.success && result.data) {
                            pbxData.value = result.data;

                            var groupedData = result.data || { groupA: [], groupB: [], groupC: [] };
                            var groupTotals = { groupA: 0, groupB: 0, groupC: 0 };
                            var totalCalls = 0;

                            ['groupA', 'groupB', 'groupC'].forEach(function(groupKey) {
                                var members = Array.isArray(groupedData[groupKey]) ? groupedData[groupKey] : [];
                                members.forEach(function(emp) {
                                    var incoming = Number(emp.incoming || 0);
                                    var outgoing = Number(emp.outgoing || 0);
                                    var total = incoming + outgoing;
                                    groupTotals[groupKey] += total;
                                    totalCalls += total;
                                });
                            });

                        // Keep previous values during refresh
                        if (totalCalls > 0) {
                            pbxGroupedData.value = groupedData;
                            pbxGroupTotals.value = groupTotals;
                            pbxTotalCalls.value = totalCalls;
                        }
                        
                        console.log('PBX Grouped Data:', groupedData);
                        console.log('PBX Group Totals:', groupTotals);
                        console.log('PBX Total Calls:', totalCalls);
                        
                        // Update chart data for groups
                        var pbxChartData = [
                            { payment_type: 'Group A', total_amount: groupTotals.groupA },
                            { payment_type: 'Group B', total_amount: groupTotals.groupB },
                            { payment_type: 'Group C', total_amount: groupTotals.groupC }
                        ].filter(function(item) { return item.total_amount > 0; });
                        
                        if (pbxChartData.length > 0) {
                            paymentMethods.value = pbxChartData;
                        } else {
                            paymentMethods.value = [];
                        }
                    }
                })
                .catch(function (err) {
                    console.error('Error loading PBX data:', err);
                    pbxError.value = err.message;
                })
                .finally(function () {
                    pbxLoading.value = false;
                    if (!pbxHasLoaded.value) {
                        pbxHasLoaded.value = true;
                    }
                });
            };

            var renderPaymentMethods = function(pmData) {
                var chartEl = paymentChartEl.value;
                var legendEl = paymentLegendEl.value;
                var emptyEl = paymentEmptyEl.value;

                if (!chartEl) { return; }
                if (chartInstances.paymentMethods) {
                    chartInstances.paymentMethods.destroy();
                    chartInstances.paymentMethods = null;
                }
                chartEl.innerHTML = '';

                if (pmData && !Array.isArray(pmData)) {
                    var tmp = [];
                    for (var key in pmData) {
                        if (Object.prototype.hasOwnProperty.call(pmData, key)) {
                            tmp.push(pmData[key]);
                        }
                    }
                    pmData = tmp;
                }

                if (!pmData || !pmData.length) {
                    if (legendEl) { legendEl.innerHTML = ''; }
                    if (emptyEl) { emptyEl.style.display = 'block'; }
                    return;
                }
                if (emptyEl) { emptyEl.style.display = 'none'; }

                if (typeof ApexCharts === 'undefined') {
                    console.warn('ApexCharts is not loaded.');
                    return;
                }

                var toTitle = function (str) {
                    if (!str) { return ''; }
                    return String(str)
                        .toLowerCase()
                        .replace(/\b\w/g, function (c) { return c.toUpperCase(); });
                };

                pmData.sort(function(a, b) {
                    var va = (a && typeof a.total_amount !== 'undefined') ? Number(a.total_amount) : 0;
                    var vb = (b && typeof b.total_amount !== 'undefined') ? Number(b.total_amount) : 0;
                    return vb - va;
                });

                var pmLabels = pmData.map(function(pm) { return toTitle(pm.payment_type); });
                var pmSeries = pmData.map(function(pm) {
                    if (pm && typeof pm.total_amount !== 'undefined' && pm.total_amount !== null) {
                        return Number(pm.total_amount);
                    }
                    return 0;
                });

                var isDark = Boolean({if !empty($config['admin_dark_theme'])}true{else}false{/if});
                var colors = isDark ? ['#35C28F', '#3699ff', '#A3A3A3'] : ['#1782c3', '#a8d885', '#3ab5b1', '#0891b2', '#ddb43b', '#533afd'];

                var options = {
                    chart: {
                        fontFamily: 'Outfit, sans-serif',
                        type: 'donut',
                        height: 320,
                        toolbar: { show: false },
                        background: 'transparent'
                    },
                    labels: pmLabels,
                    series: pmSeries,
                    colors: colors,
                    legend: { show: false },
                    dataLabels: { enabled: true },
                    tooltip: {
                        y: {
                            formatter: function (val) {
                                return val + ' calls';
                            }
                        }
                    },
                    theme: { mode: isDark ? 'dark' : 'light' }
                };

                chartInstances.paymentMethods = new ApexCharts(chartEl, options);
                chartInstances.paymentMethods.render();

                if (legendEl) {
                    var total = pmSeries.reduce(function(sum, n) { return sum + (Number(n) || 0); }, 0);
                    var legendHtml = pmLabels.map(function(label, idx) {
                        var val = pmSeries[idx] || 0;
                        var pct = total ? ((val / total) * 100).toFixed(1) + '%' : '';
                        return '' +
                            '<div style="display: flex; align-items: center; justify-content: space-between; padding: 8px 12px; border-bottom: 1px solid #1a2332;">' +
                                '<div style="display: flex; align-items: center; gap: 8px;">' +
                                    '<span style="width: 12px; height: 12px; border-radius: 2px; background:' + (colors[idx % colors.length] || '#888') + ';"></span>' +
                                    '<span style="color: #e1e3e6; font-size: 13px; font-weight: 500;">' + label + '</span>' +
                                '</div>' +
                                '<div style="display: flex; align-items: center; gap: 8px;">' +
                                    '<span style="color: #fff; font-size: 14px; font-weight: 700;">' + val + ' calls</span>' +
                                    '<span style="color: #6c7a8d; font-size: 12px; font-weight: 600;">(' + pct + ')</span>' +
                                '</div>' +
                            '</div>';
                    }).join('');
                    legendEl.innerHTML = '<div style="background: #0f1621; border-radius: 6px; margin-top: 16px; overflow: hidden;">' + legendHtml + '</div>';
                }
            };

            var loadData = function () {
                if (isLoading.value && hasLoaded.value) return;
                isLoading.value = true;

                fetch(apiUrl, { method: 'GET' })
                    .then(function (response) {
                        if (!response.ok) { throw new Error('Network response was not ok'); }
                        return response.json();
                    })
                    .then(function (data) {
                        var staff = (data && data.staff_sales_week && Array.isArray(data.staff_sales_week.rows)) ? data.staff_sales_week.rows : [];
                        if (staff && staff.length) {
                            reps.value = staff;
                            currentMonthRows.value = staff;
                        }
                        if (data && data.staff_sales_week && typeof data.staff_sales_week.total !== 'undefined') {
                            staffSalesTotal.value = data.staff_sales_week.total;
                        }
                        if (data && data.team_deals) {
                            teamDeals.value = data.team_deals;
                        }
                        if (data && data.metrics_invoices365) {
                            invoicesMetrics.value = {
                                total: Number(data.metrics_invoices365.count_sales || data.metrics_invoices365.count_total || 0),
                                paid: Number(data.metrics_invoices365.count_paid || 0),
                                partial: Number(data.metrics_invoices365.count_partial || 0),
                                unpaid: Number(data.metrics_invoices365.count_unpaid || 0)
                            };
                            if (typeof data.metrics_invoices365.invoice_total_paid_partial !== 'undefined') {
                                paidInvoicesAmount.value = data.metrics_invoices365.invoice_total_paid_partial;
                            }
                        }
                        if (typeof data.total_sales !== 'undefined') {
                            totalSalesNet.value = data.total_sales;
                        }
                        if (data && data.payment_methods_comparison) {
                            paymentMethods.value = data.payment_methods_comparison;
                        }
                        if (data && data.grouped_sales) {
                            groupedSalesRaw.value = data.grouped_sales;
                        }
                        if (data && data.staff_sales_week && data.staff_sales_week.metrics) {
                            var m = data.staff_sales_week.metrics;
                            if (m.deals_value) { dealsWonValue.value = m.deals_value; }
                            if (m.deals_target) { dealsWonTarget.value = m.deals_target; }
                        }
                    })
                    .catch(function (err) {
                        console.error('Error loading sales data', err);
                    })
                    .finally(function () {
                        isLoading.value = false;
                        if (!hasLoaded.value) {
                            hasLoaded.value = true;
                        }
                        if (nextTick) {
                            nextTick(function () {
                                renderPaymentMethods(paymentMethods.value);
                            });
                        } else {
                            renderPaymentMethods(paymentMethods.value);
                        }
                    });
            };

            watch(paymentMethods, function (pmData) { renderPaymentMethods(pmData); }, { deep: true });

            onMounted(function () {
                renderPaymentMethods(paymentMethods.value);
                loadData();
                loadPbxData(false);

                refreshTimer.value = setInterval(function() {
                    loadData();
                    loadPbxData(false);
                }, 30000);

                setInterval(function() {
                    loadPbxData(true);
                }, 120000);
            });

            onBeforeUnmount(function () {
                if (refreshTimer.value) {
                    clearInterval(refreshTimer.value);
                    refreshTimer.value = null;
                }
                if (chartInstances.paymentMethods) {
                    chartInstances.paymentMethods.destroy();
                    chartInstances.paymentMethods = null;
                }
            });

            return {
                isLoading: isLoading,
                showSkeleton: showSkeleton,
                reps: reps,
                kpis: kpis,
                teamDeals: teamDeals,
                teamDealsTotal: teamDealsTotal,
                topReps: topReps,
                groupedSales: groupedSales,
                currentMonthRows: currentMonthRows,
                formatMoney: formatMoney,
                resolveImageUrl: resolveImageUrl,
                getInitials: getInitials,
                onAvatarError: onAvatarError,
                medalClass: medalClass,
                avatarClass: avatarClass,
                badgeClass: badgeClass,
                gaugeDegree: gaugeDegree,
                formattedDealsWon: formattedDealsWon,
                formattedDealsTarget: formattedDealsTarget,
                formattedForecasted: formattedForecasted,
                formattedStaffTotal: formattedStaffTotal,
                formattedTotalSales: formattedTotalSales,
                formattedPaidInvoices: formattedPaidInvoices,
                invoicesMetrics: invoicesMetrics,
                formattedInvoices: formattedInvoices,
                parseAmount: parseAmount,
                paymentChartEl: paymentChartEl,
                paymentLegendEl: paymentLegendEl,
                paymentEmptyEl: paymentEmptyEl,
                pbxGroupedData: pbxGroupedData,
                pbxGroupTotals: pbxGroupTotals,
                pbxTotalCalls: pbxTotalCalls,
                pbxLoading: pbxLoading,
                pbxHasLoaded: pbxHasLoaded,
                pbxError: pbxError
            };
        }
    }).mount('#sales-dashboard');
});
</script>
{/block}
