{extends file="$layouts_admin"}

{block name="content"}

    <div class="row">

        <div class="overview-header">

            <div class="title">
                <h1>Documents</h1>
            </div>
        
        </div>

        <div class="col-lg-12">
            <div class="panel">

                <!-- panel hdr -->
                <div class="panel-hdr">
                    <h2>Documents list</h2>

                    <div class="panel-toolbar">
                        <div class="btn-group">                        
                            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modal_add_item">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="currentColor">
                                    <path d="M5 10.0002H15.0006M10.0002 5V15.0006" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg> Add File
                            </button>
                        </div>
                    </div>
                </div>

                <div class="panel-container show">
                    <div class="panel-content">
                        <div class="table-responsive">

                            <div class="table-data-content">

                                <table id="documents_table">
                                    <thead>
                                        <tr>
                                            <th data-sort-ignore="true" width="20">{$_L['Type']}</th>
                                            <th width="200">{$_L['Title']}</th>
                                            <th>{$_L['Date']}</th>
                                            <th data-sort-ignore="true" width="200">{$_L['Manage']}</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                    {foreach $files as $file}
                                    <tr>
                                        <td>
                                            {if $file->file_mime_type eq 'jpg' || $file->file_mime_type eq 'png' || $file->file_mime_type eq 'gif'}
                                                <div class="d-flex gap-2">
                                                    <img src="{$app_url}ui/lib/img/svg/file-image.svg" title="Image">
                                                    <span>Image</span>
                                                </div>
                                            {elseif $file->file_mime_type eq 'pdf'}
                                                <div class="d-flex gap-2">
                                                    <img src="{$app_url}ui/lib/img/svg/file-pdf.svg" title="PDF file">
                                                    <span>PDF</span>
                                                </div>
                                            {elseif $file->file_mime_type eq 'zip'}
                                                <div class="d-flex gap-2">
                                                    <img src="{$app_url}ui/lib/img/svg/file-zip.svg" title="Zip file">
                                                    <span>Zip file</span>
                                                </div>
                                            {else}
                                                <div class="d-flex gap-2">
                                                    <img src="{$app_url}ui/lib/img/svg/file-pdf.svg" title="File">
                                                    <span>File</span>
                                                </div>
                                            {/if}
                                        </td>
                                        <td>
                                            <a href="{$_url}documents/view/{$file->id}/">{$file['title']}</a>
                                        </td>
                                        {assign var=orderDate value=$file.created_at|default:$file.updated_at}
                                        <td data-order="{$orderDate|date_format:"%Y-%m-%d %H:%M:%S"}">
                                            {$orderDate|date_format:"%d/%m/%Y"}
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="#" class="btn btn-sm c_link" data-token="{$file['id']}_{$file['file_dl_token']}">
                                                    <i class="fal fa-link"></i>
                                                </a>
                                                <a href="{$_url}documents/view/{$file['id']}/" class="btn btn-sm">
                                                    <svg class="fill-current" width="21" height="20" viewBox="0 0 21 20" fill="#344054" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.8749 13.8619C8.10837 13.8619 5.74279 12.1372 4.79804 9.70241C5.74279 7.26761 8.10837 5.54297 10.8749 5.54297C13.6415 5.54297 16.0071 7.26762 16.9518 9.70243C16.0071 12.1372 13.6415 13.8619 10.8749 13.8619ZM10.8749 4.04297C7.35666 4.04297 4.36964 6.30917 3.29025 9.4593C3.23626 9.61687 3.23626 9.78794 3.29025 9.94552C4.36964 13.0957 7.35666 15.3619 10.8749 15.3619C14.3932 15.3619 17.3802 13.0957 18.4596 9.94555C18.5136 9.78797 18.5136 9.6169 18.4596 9.45932C17.3802 6.30919 14.3932 4.04297 10.8749 4.04297ZM10.8663 7.84413C9.84002 7.84413 9.00808 8.67606 9.00808 9.70231C9.00808 10.7286 9.84002 11.5605 10.8663 11.5605H10.8811C11.9074 11.5605 12.7393 10.7286 12.7393 9.70231C12.7393 8.67606 11.9074 7.84413 10.8811 7.84413H10.8663Z" fill=""></path>
                                                    </svg>
                                                </a>
                                                <a href="#" class="btn btn-sm cdelete" id="did{$file['id']}">
                                                    <svg class="fill-current" width="21" height="20" viewBox="0 0 21 20" fill="#344054" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M7.4163 3.79199C7.4163 2.54935 8.42366 1.54199 9.6663 1.54199H12.083C13.3256 1.54199 14.333 2.54935 14.333 3.79199V4.04199H16.5H17.5409C17.9551 4.04199 18.2909 4.37778 18.2909 4.79199C18.2909 5.20621 17.9551 5.54199 17.5409 5.54199H17.25V8.24687V13.2469V16.2087C17.25 17.4513 16.2427 18.4587 15 18.4587H6.75004C5.5074 18.4587 4.50004 17.4513 4.50004 16.2087V13.2469V8.24687V5.54199H4.20837C3.79416 5.54199 3.45837 5.20621 3.45837 4.79199C3.45837 4.37778 3.79416 4.04199 4.20837 4.04199H5.25004H7.4163V3.79199ZM15.75 13.2469V8.24687V5.54199H14.333H13.583H8.1663H7.4163H6.00004V8.24687V13.2469V16.2087C6.00004 16.6229 6.33583 16.9587 6.75004 16.9587H15C15.4143 16.9587 15.75 16.6229 15.75 16.2087V13.2469ZM8.9163 4.04199H12.833V3.79199C12.833 3.37778 12.4972 3.04199 12.083 3.04199H9.6663C9.25209 3.04199 8.9163 3.37778 8.9163 3.79199V4.04199ZM9.20837 8.00033C9.62259 8.00033 9.95837 8.33611 9.95837 8.75033V13.7503C9.95837 14.1645 9.62259 14.5003 9.20837 14.5003C8.79416 14.5003 8.45837 14.1645 8.45837 13.7503V8.75033C8.45837 8.33611 8.79416 8.00033 9.20837 8.00033ZM13.2917 8.75033C13.2917 8.33611 12.9559 8.00033 12.5417 8.00033C12.1275 8.00033 11.7917 8.33611 11.7917 8.75033V13.7503C11.7917 14.1645 12.1275 14.5003 12.5417 14.5003C12.9559 14.5003 13.2917 14.1645 13.2917 13.7503V8.75033Z" fill=""></path>
                                                    </svg>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    {/foreach}
                                    </tbody>
                                </table>

                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>
 
    </div>


    <div id="modal_add_item" class="modal fade" tabindex="-1"  role="dialog" aria-hidden="true">

        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">
                        {$_L['New Document']}
                    </h4>
                    <button type="button" class="close btn btn-danger" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="fal fa-times"></i></span>
                    </button>
                </div>
                <div class="modal-body">
                    <form>
                        <div class="mb-3">
                            <label for="doc_title">{$_L['Title']}</label>
                            <input type="text" class="form-control" id="doc_title" name="doc_title">

                        </div>

                        <div class="checkbox">
                            <label>
                                <input type="checkbox" id="is_global" name="is_global"> {$_L['Available for all Customers']}
                            </label>
                        </div>

                    </form>

                    <hr>

                    <form action="" class="dropzone" id="upload_container">

                        <div class="dz-message">
                            <h3> <i class="fal fa-cloud-upload"></i>  {$_L['Drop File Here']}</h3>
                            <br />
                            <span class="note">{$_L['Click to Upload']}</span>
                        </div>

                    </form>
                    <hr>
                    <h4>{$_L['Server Config']}:</h4>
                    <p>{$_L['Upload Maximum Size']}: {$upload_max_size}</p>
                    <p>{$_L['POST Maximum Size']}: {$post_max_size}</p>

                </div>
                <div class="modal-footer">
                    <input type="hidden" name="file_link" id="file_link" value="">
                    <button type="button" data-bs-dismiss="modal" class="btn btn-danger">{$_L['Close']}</button>
                    <button type="button" id="btn_add_file" class="btn btn-primary">{$_L['Submit']}</button>
                </div>
            </div>
        </div>


    </div>


{/block}


{block name="script"}
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>


window.crmDataTableConfig = {
    baseUrl: "{$_url}",
    ajaxUrl: "",
    tableSelector: "#documents_table",
    buttons: false,
    lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
    pageLength: 10,
    paths: {
        view: "{$_url}documents/view/[[id]]",
        groupList: "{$_url}contacts/list/customer/"
    },
    translations: {
        noItems: "{$_L['No items to display']}",
        showing: "{$_L['Showing _START_ to _END_ of _TOTAL_ entries']}",
        searchPlaceholder: "{__('Search')}"
    },
    responsiveControl: false,
    columns: [
        { data: 'type' },
        { data: 'title' },
        { data: 'date' },
        { data: 'manage' }
    ],
    order: [[2, 'desc']],
    onInitComplete: function(dt) {
        //console.log("Tabla inicializada", dt);
        hideSkeleton();
    }
};



        Dropzone.autoDiscover = false;

        $(function () {
            var dl_token;

            $(".c_link").click(function (e) {
                e.preventDefault();

                dl_token = $(this).attr("data-token");


                Swal.fire({
                    icon: 'info',
                    title: '{__('Secure download link')}',
                    text: base_url + "client/dl/" + dl_token,
                })

            });

            var $modal = $('#cloudonex_body');

            $('[data-bs-toggle="tooltip"]').tooltip();

            var $btn_add_file = $("#btn_add_file");

            var $file_link = $("#file_link");

            var upload_resp;




            var ib_file = new Dropzone("#upload_container",
                {
                    url: base_url + "documents/upload/",
                    maxFiles: 1
                }
            );


            ib_file.on("sending", function() {

                $btn_add_file.prop('disabled', true);

            });

            ib_file.on("success", function(file,response) {

                $btn_add_file.prop('disabled', false);

                upload_resp = response;

                if(upload_resp.success == 'Yes'){

                    toastr.success(upload_resp.msg);
                    $file_link.val(upload_resp.file);


                }
                else{
                    toastr.error(upload_resp.msg);
                }


            });




            var $doc_title = $("#doc_title");

            var is_global = '0';


            $btn_add_file.on('click', function(e) {
                e.preventDefault();

                if ($('#is_global').is(":checked"))
                {
                    is_global = '1';
                }

                $.post( base_url + "documents/post/", { title: $doc_title.val(), file_link: $file_link.val(), is_global: is_global })
                    .done(function( data ) {

                        if ($.isNumeric(data)) {

                            location.reload();

                        }

                        else {
                            toastr.error(data);
                        }




                    });


            });


            $('#clx_datatable').dataTable(
                {
                    responsive: true,
                    "language": {
                        "emptyTable": "{$_L['No items to display']}",
                        "info":      "{$_L['Showing _START_ to _END_ of _TOTAL_ entries']}",
                        "infoEmpty":      "{$_L['Showing 0 to 0 of 0 entries']}",
                        buttons: {
                            pageLength: '{$_L['Show all']}'
                        },
                        searchPlaceholder: "{__('Search')}"
                    },
                }
            );


            $(".cdelete").click(function (e) {
                e.preventDefault();
                var id = this.id;
                app.confirm(_L['are_you_sure'], function(result) {
                    if(result){
                        window.location.href = base_url + "delete/document/" + id + '/';
                    }
                });
            });

        });
    </script>
{/block}
