{extends file="$layouts_admin"}

{block name="content"}
<div id="dmv-app" v-cloak>
	<div class="row">
		<div class="col-md-12">
			<div class="panel">
			
				<div class="alert alert-danger" v-if="errorMessage">
				<span>{{ errorMessage }}</span>
				</div>

				<form class="profile-panel" autocomplete="off" @submit.prevent="submitForm">
				<div class="profile-panel-header">
					<h3>New DMV Form</h3>
				</div>

			<div class="card-box">
				<h2>Personal Information</h2>

				<div class="card-grid mb-4">
					<div class="card-row">
						<label class="key" for="idImage">Upload ID (auto-fill)</label>
						<div>
							<input type="file" id="idImage" class="form-control" accept="image/*" @change="handleImageUpload">
							<small class="text-muted">Sube una imagen legible; se intentará extraer nombre y dirección.</small>
							<div v-if="imagePreview" class="mt-2">
								<img :src="imagePreview" alt="preview" style="max-width: 220px; border: 1px solid #ddd; border-radius: 4px;">
							</div>
							<div v-if="ocrError" class="text-danger mt-1">{{ ocrError }}</div>
						</div>
					</div>
				</div>

				<div class="card-grid mb-4">
				<div class="card-row">
					<label class="key" for="formType">Form type <span class="text-danger">*</span></label>
						<select id="formType" class="form-control" v-model="form.formType" :disabled="loading">
						<option value="">Select an option</option>
						<option v-for="type in formTypes" :key="type" :value="type">{{ type }}</option>
						</select>
					</div>

					<div class="card-row">
						<label class="key" for="staffId">Collected by <span class="text-danger">*</span></label>
						<select id="staffId" class="form-control" v-model="form.staffId" :disabled="loading">
						<option value="">Select Staff</option>
						<option v-for="member in staff" :key="member.id" :value="member.id">{{ member.name }}</option>
						</select>
					</div>

					<div class="card-row">
						<label class="key" for="name">Name <span class="text-danger">*</span></label>
						<input type="text" id="name" class="form-control" v-model="form.name">
					</div>

					<div class="card-row">
						<label class="key" for="email">Email <span class="text-danger">*</span></label>
						<input type="email" id="email" class="form-control" v-model="form.email">
					</div>
					</div>

					<div class="card-grid">
					<div class="card-row">
						<label class="key" for="country">Country <span class="text-danger">*</span></label>
						<select id="country" class="form-control" v-model="form.country">
						<option value="">{$_L['Select Country']}</option>
						{$countries}
						</select>
					</div>

					<div class="card-row">
						<label class="key" for="address">Address <span class="text-danger">*</span></label>
						<div>
						<input type="text" id="address" class="form-control" v-model="form.address" autocomplete="new-address">
						<ol class="list-group" id="browsers"></ol>
						</div>
					</div>

					<div class="card-row">
						<label class="key" for="city">City/State <span class="text-danger">*</span></label>
						<input type="text" id="city" class="form-control" v-model="form.city">
					</div>

					<div class="card-row">
						<label class="key" for="state">State/Region <span class="text-danger">*</span></label>
						<input type="text" id="state" class="form-control" v-model="form.state">
					</div>

					<div class="card-row">
						<label class="key" for="zip">ZIP/Postal Code <span class="text-danger">*</span></label>
						<input type="text" id="zip" class="form-control" v-model="form.zip">
					</div>
					</div>
				</div>

				<div class="row">
					<div class="col-12">
					<div class="d-flex justify-content-end">
						<button type="submit" class="btn btn-primary guardar_siguiente" :disabled="loading">
						<span v-if="loading">Saving...</span>
						<span v-else>{$_L['Submit']}</span>
						</button>
					</div>
					</div>
				</div>
				</form>


			</div>
		</div>
	</div>
</div>
{/block}

{block name="script"}
{literal}
<script>
const app = Vue.createApp({
	data() {
		return {
			loading: false,
			errorMessage: '',
			uploading: false,
			ocrError: '',
			imagePreview: '',
			formTypes: [],
			staff: [],
			form: {
				formType: '',
				staffId: '',
				name: '',
				email: '',
				country: '',
				address: '',
				city: '',
				state: '',
				zip: ''
			},
			customFields: {}
		};
	},
	mounted() {
		this.fetchOptions();
	},
	methods: {
		async fetchOptions() {
			try {

				this.loading = true;

				const res = await fetch('/api/form/opt', { credentials: 'same-origin' });

				if (!res.ok) throw new Error('Failed to load form options');

				const data = await res.json();

				this.formTypes = data.formTypes || [];

				this.staff = (data.staff || []).map(item => ({
					id: item.id ?? item.staff_id ?? item.value ?? item,
					name: item.name ?? item.label ?? item.text ?? item
				}));

			} catch (err) {

				this.errorMessage = err.message || 'Error loading options';

			} finally {

				this.loading = false;

			}
		},
		async handleImageUpload(event) {
			this.ocrError = '';
			const file = event.target.files?.[0];
			if (!file) return;
			this.imagePreview = URL.createObjectURL(file);

			const formData = new FormData();
			formData.append('file', file);

			try {
				this.uploading = true;
				const res = await fetch('/api/form/ocr', {
					method: 'POST',
					body: formData,
					credentials: 'same-origin'
				});

				if (!res.ok) throw new Error('Failed to process image');

				const data = await res.json();

				this.form.name = data.name ?? this.form.name;
				this.form.address = data.address ?? this.form.address;
				this.form.city = data.city ?? this.form.city;
				this.form.state = data.state ?? this.form.state;
				this.form.zip = data.zip ?? this.form.zip;
				this.form.country = data.country ?? this.form.country;
			} catch (err) {
				this.ocrError = err.message || 'No se pudo extraer la información';
			} finally {
				this.uploading = false;
			}
		},
		async submitForm() {
				
			this.errorMessage = '';

			const payload = {
				...this.form,
				customFields: this.customFields
			};

			try {

				this.loading = true;

				const res = await fetch('/api/form/submit', {
					method: 'POST',
					headers: { 'Content-Type': 'application/json' },
					body: JSON.stringify(payload),
					credentials: 'same-origin'
				});

				if (!res.ok) throw new Error('Failed to submit form');

				const data = await res.json();

				alert(data.message || 'Form submitted');

			} catch (err) {

				this.errorMessage = err.message || 'Error submitting form';

			} finally {

				this.loading = false;

			}
		}
	}
});
app.mount('#dmv-app');
</script>
{/literal}
{/block}
