{extends file="$layouts_admin"}


{block name="head"}


    <style>

        .btn-default {
            color: #333;
            background-color: #fff;
            border-color: #ccc;
        }

        .btn-default:hover, .btn-default:focus, .btn-default:active, .btn-default.active {
            color: #333;
            background-color: #fff;
            border-color: #ccc;
        }

        {if $pos eq 'pos'}
        .pos_item {

        {if $config['nstyle'] == 'dark_mode'}
            background: #182138;
        {else}
            background: #f3f6f9;
        {/if}


            cursor: pointer;
        }

        .pos_item:hover {
            background: #2196f3;
            color: #ffffff;
        }

 


        {/if}

    </style>
{/block}


{block name="content"}
 
 
 <textarea disabled hidden class="tener_contactos" value="{$c}">
        {$c}
 </textarea>

 <textarea disabled hidden class="tener_crm_account_company" value="{$list_crm_accounts_company}">
        {$list_crm_accounts_company}
 </textarea>

 
    <input id="habilitar_precio_facturas" class="habilitar_precio_facturas"  name="habilitar_precio_facturas" value="{$habilitar_precio_facturas}" disabled hidden>

    <input id="cliente_id" class="cliente_id"  name="cliente_id" value="{$p_cid}" disabled hidden>

    <input id="existe_invoices" class="existe_invoices"  name="existe_invoices" value="{$existe_invoices}" disabled hidden>
    <input id="existe_invoices_refiere_staff_id" class="existe_invoices_refiere_staff_id"  name="existe_invoices_refiere_staff_id" value="{$invoice->refiere_staff_id}"  disabled hidden>
    
    <input id="existe_recommended_type_id" class="existe_recommended_type_id"  name="existe_recommended_type_id" value="{$invoice->recommended_type_id}" disabled hidden >
    <input id="existe_refiere_clients_id" class="existe_refiere_clients_id"  name="existe_refiere_clients_id" value="{$invoice->refiere_clients_id}"  disabled hidden >
    
    
    <input id="getCompanyId" class="getCompanyId"  name="getCompanyId" value="{$invoice->company_id}"  disabled hidden>

 


            {if $user["roleid"] == 0 && $invoice["status"] == "Pending Approval" }
                {* observaciones *}
                <div class="row">
                    <div class="col-md-12">
                        
                        <div class="panel ">
                            <div class="panel-hdr">
                                                                                                                                                     
                                <h2><span></span>Add Observations</h2>
                                
                                <div class="panel-toolbar">
                                    <div class="btn-group">
                                            <button class="btn btn-sm btn-primary enviarObservaciones" > {$_L['Save']}</button>
                                    </div>
                                </div>

                            </div>

                            <div class="panel-container show" id="ibox_form_observaciones">

                                <div class="panel-content">

                                    <div class="px-2">
                                        <div class="alert alert-danger" id="emsg_observaciones" style="display: none;">
                                            <span id="emsgbody_observaciones"></span>
                                        </div>
            

                                        <form id="rform">

                                            <div class="row">

                                            <div class="col-md-12 col-sm-12">
                                                    <div class="mb-3">
                                                            <label for="estado_invoices">State</label>
                                                            <select id="estado_invoices" name="estado_invoices" class="form-control tener_estado_invoices" >
                                                                <option value="1" selected>Modify Discount</option>
                                                                <option value="2">Approve</option>
                                                                <option value="3">Reject</option>
                                                            </select>                                                                                                  
                                                    </div> 

                                                </div>

                                                <div class="col-md-12 col-sm-12">
                                                    <div class="mb-3">
                                                            <input type="text" disabled hidden class="tener_invoice_id" value="{$invoice["id"]}">                                                                                                       
                                                            <input type="text" disabled hidden class="tener_user_id" value="{$user["id"]}">         
                                                           
                                                            <label for="observaciones_invoices">Observations</label>
                                                                                      
                                                            <textarea class="form-control tener_obsevaciones_invoices" id="observaciones_invoices" name="observaciones_invoices"   rows="3"
                                                            placeholder="Observations...."></textarea>

                                                    </div>                       
                                                </div>

                                        </form>

                                    
                                    </div>

                                

                                </div>
                
                            </div>
                        </div>
                        
                    </div>
                </div>
                {* fin observaciones *}                      
            {/if}


            {* Invoices *}
            <form id="invform" method="post">

                <div class="row" id="ibox_form">

                    <div class="alert alert-danger" id="emsg" style="display: none;">
                        <span id="emsgbody"></span>
                    </div>

                    <div class="col-md-12">
 
                    <div class="panel">

                            <div class="panel-hdr">
                                <h2>


                                    {if $invoice}

                                        {if $action === 'credit-note'}
                                            {{__('Credit Note')}}-
                                            {else}
                                            {{__('Invoice')}}-
                                        {/if}

                                            {$invoice->invoicenum}{if $invoice->cn neq ''} {$invoice->cn} {else}
                                            {$invoice->id} {/if}

                                        {else}

                                        {if $action === 'credit-note'}
                                            {predict_next_serial($config,'credit-note')}
                                        {else}
                                            {predict_next_serial($config,'invoice')}
                                        {/if}



                                        {if $project}
                                            [{$project->name}]

                                            <input type="hidden" name="pid" value="{$project->id}">
                                        {/if}

                                    {/if}

                                </h2>
                                <div class="panel-toolbar">

                                    {if $invoice}

                                        <input type="hidden" name="invoice_id" value="{$invoice->id}">

                                    {else}

                                        <input type="hidden" name="invoice_id" value="">

                                    {/if}

                                    {if !$invoice || $invoice["status"] != "Paid"}
                                        <div class="btn-group">
                                            <button class="btn btn-sm btn-primary" id="submit"> {$_L['Save']}</button>
                                            <button class="btn btn-sm btn-info" id="save_n_close"> {$_L['Save n Close']}</button>
                                        </div>
                                    {/if}

                                    


                                </div>
                            </div>

                            <div class="panel-container">
                                <div class="panel-content">


                                    <div class="row">
                                        <div class="col-md-12">

                                            <div class='row'>

                                                <div class='col-sm-4'>
                                                    <div class='mb-3'>
                                                        <label for="user_title">{$_L['Customer']}</label>

                                                        <select id="cid" name="cid" class="form-select" 
                                                        {if $invoice["status"] == "Paid"}
                                                        disabled
                                                        {/if} >
                                                                        
                                                        
                                                            <option value="">{$_L['Select Contact']}...</option>
                                                            {* 
                                                            {foreach $c as $cs}
                                                                <option value="{$cs['id']}"
                                                                        {if $p_cid eq ($cs['id'])}selected="selected" {/if}>{if $cs['company'] neq ''} {$cs['company']} - {/if} {$cs['account']} {if $cs['email'] neq ''}- {$cs['email']}{/if} {if $cs['phone'] neq ''}- {$cs['phone']}{/if} {if $cs['code']}[{$cs['code']}]{/if} </option>
                                                            {/foreach}
                                                            *}

                                                        </select>
                                                        {if !$invoice || $invoice["status"] != "Paid"}
                                                            <span class="help-block"><a href="#" id="contact_add">| {$_L['Or Add New Customer']}</a> </span>                    
                                                        {/if}
                                                        
                                                    </div>
                                                </div>

                                                <div class='col-sm-4'>
                                                    <div class='mb-3'>
                                                        <label for="company_id">Company</label>

                                                        <select id="company_id" name="company_id" class="form-select" 
                                                            {if $invoice["status"] == "Paid"}
                                                            disabled
                                                            {/if} 
                                                        >
                                                            <option value="0">None</option>
                                                        </select>

                                                        
                                                    </div>
                                                </div>
 

                                                <div class='col-sm-2'>
                                                    <div class="mb-3">
                                                        <label for="currency">{$_L['Currency']}</label>

                                                        <select id="currency" name="currency" class="form-select"
                                                        {if $invoice["status"] == "Paid"}
                                                        disabled
                                                        {/if}
                                                        >

                                                            {foreach $currencies as $key=>$value}
                                                                <option value="{$key}"


                                                                        {if $invoice}
                                                                            {if $invoice->currency_iso_code == $key}selected {/if}
                                                                        {else}
                                                                            {if $config['home_currency'] eq ($key)}selected {/if}
                                                                        {/if}


                                                                        data-decimal-mark="{$value['decimal_mark']}" data-thousands-separator="{$value['thousands_separator']}" data-symbol="{$value['symbol']}"

                                                                        {if $value['symbol_first']}
                                                                            data-symbol-first="yes"
                                                                        {else}
                                                                            data-symbol-first="no"
                                                                        {/if}



                                                                >{$key}</option>
                                                                {foreachelse}
                                                            {/foreach}

                                                        </select>

                                                    </div>
                                                </div>


                                                <div class='col-sm-2'>
                                                    <div class="mb-3">
                                                        <label for="status">{$_L['Status']}</label>

                                                        <select id="status" name="status" class="form-select"
                                                        {if $invoice["status"] == "Paid"}
                                                        disabled
                                                        {/if}
                                                        >

                                                            <option value="Published" {if $invoice && $invoice->status != 'Draft'}selected{/if}>{$_L['Published']}</option>
                                                            <option value="Draft" {if $invoice && $invoice->status == 'Draft'}selected{/if}>{$_L['Draft']}</option>


                                                        </select>

                                                    </div>
                                                </div>

                                            </div>


                                            {if !empty($config['invoice_group'])}
                                                <div class="mb-3">
                                                    <label>{__('Group')}</label>
                                                    <select class="form-select" name="group_id">
                                                        <option value="0">{__('None')}</option>
                                                        {foreach $invoice_groups as $group}
                                                            <option value="{$group->id}" {if $invoice && $invoice->group_id == $group->id}selected{/if}>{$group->name}</option>
                                                        {/foreach}
                                                    </select>
                                                </div>
                                            {/if}

                                            {if !empty($config['invoice_single_service'])}
                                                <div class="mb-3">
                                                    <label>{__('Service')}</label>
                                                    <select class="form-select" id="service_id" name="service_id">
                                                        <option value="0">{__('None')}</option>
                                                        {foreach $services as $service}
                                                            <option data-price="{numberFormatUsingCurrency($service->sales_price,$config['home_currency'])}" value="{$service->id}" {if $invoice && $invoice->service_id == $service->id}selected{/if}>{$service->name}</option>
                                                        {/foreach}
                                                    </select>
                                                </div>
                                            {/if}


                                            <div class="row">

                                                
                                                <div class="col-sm-12">
                                                    <div class="mb-3">
                                                        <label for="invoice_title">{$_L['Title']}  <small><em>({$_L['optional']})</em></small></label>

                                                        <input type="text" class="form-control" id="invoice_title" name="title" {if $invoice}value="{$invoice->title}" {/if}
                                                        {if $invoice["status"] == "Paid"}
                                                        disabled
                                                        {/if}
                                                        >
                                                    </div>
                                                </div>


                                                <div class='col-sm-4'>
                                                    <div class='mb-3'>
                                                        <label for="aid">{$_L['Staff']}</label>
                                                        <select class="form-select" name="aid" id="aid"
                                                        {if $invoice["status"] == "Paid"}
                                                            disabled
                                                        {/if}
                                                        >
                                                            {foreach $staffs as $owner}
                                                                <option value="{$owner->id}"
                                                                        {if $invoice}
                                                                        {if $invoice->aid eq $owner->id}selected="selected"{/if}
                                                                    {else}
                                                                    {if $owner->id == $user->id}selected{/if}
                                                                {/if} >{$owner->fullname}</option>
                                                            {/foreach}
                                                        </select>
                                                    </div>
                                                </div>


                                                {**}
                                                <div class='col-sm-8 changesColumnsRecommendedType'>
                                                    <div class='mb-3'>
                                                        <label for="recommended_type_id">Referred by</label>
                                                        <select class="form-select" name="recommended_type_id" id="recommended_type_id"
                                                            {if $invoice["status"] == "Paid"}
                                                                disabled
                                                            {/if}
                                                        >
                                                            <option value="None" selected>None</option>
                                                            <option value="By Staff" >By Staff</option>
                                                            <option value="By clients" >By clients</option>
                                                            <option value="Other" >OTHER</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                {**}

                                                <div class='col-sm-4 showByStaff' style="display: none;">
                                                    <div class='mb-3'>
                                                        <label for="refiere_staff_id">Referred by Staff</label>
                                                        <select class="form-select" name="refiere_staff_id" id="refiere_staff_id"
                                                            {if $invoice["status"] == "Paid"}
                                                                disabled
                                                            {/if}
                                                        >
                                                            <option value="NULL" selected>-- None --</option>
                                                            <option value="0" >Others</option>
                                                            
                                                            {foreach $staffs as $refStaff}
                                                                <option 
                                                                    value="{$refStaff->id}"
                                                                >
                                                                {*                                                                {if $invoice}
                                                                        {if $invoice->refiere_staff_id eq $refStaff->id}
                                                                            selected
                                                                        {/if}
                                                                    {/if} 
                                                                    *}


                                                                    {$refStaff->fullname}
                                                                </option>
                                                            {/foreach}
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class='col-sm-4 showByClients' style="display: none;">
                                                    <div class='mb-3'>
                                                        <label for="refiere_clients_id">Referred by Clients</label>
                                                        <select class="form-select" name="refiere_clients_id" id="refiere_clients_id"
                                                            {if $invoice["status"] == "Paid"}
                                                                disabled
                                                            {/if}
                                                        >
                                                            <option value="NULL" selected>-- None --</option>
                                                            <option value="0" >Others</option>
                                                            
                                                        </select>
                                                    </div>
                                                </div>

                                                

                                            </div>

                                            {*nombre de otros en staff id*}

                                            <div class="row habilitar_otros_nombre_referencia" style="display: none;">

                                                <div class='col-sm-12'>
                                                    <div class='mb-3'>
                                                        <label for="refiere_staff_nombre">Reference name staff</label>
                                                        <input type="text" class="form-control refiere_staff_nombre" id="refiere_staff_nombre" name="refiere_staff_nombre" value="{$invoice->refiere_staff_nombre}">
                                                    </div>
                                                </div>

                                            </div>
                                            {**}

                                            {*nombre de otros en cliente id*}
                                            <div class="row habilitar_otros_nombre_referencia_clientes" style="display: none;">

                                                <div class='col-sm-12'>
                                                    <div class='mb-3'>
                                                        <label for="refiere_clients_nombre">Reference name clients</label>
                                                        <input type="text" class="form-control refiere_clients_nombre" id="refiere_clients_nombre" name="refiere_clients_nombre" value="{$invoice->refiere_clients_nombre}">
                                                    </div>
                                                </div>

                                            </div>
                                            {**}

                                            {*nombre de otros*}
                                            <div class="row habilitar_otros_nombre_referencia_otros" style="display: none;">

                                                <div class='col-sm-12'>
                                                    <div class='mb-3'>
                                                        <label for="refiere_otros_nombre">Name of other references</label>
                                                        <input type="text" class="form-control refiere_otros_nombre" id="refiere_otros_nombre" name="refiere_otros_nombre" value="{$invoice->refiere_otros_nombre}">
                                                    </div>
                                                </div>

                                            </div>
                                            {**}
                                             

                                            <div class='row'>


                                                <div class='col-sm-4'>
                                                    <div class="mb-3">
                                                        <label for="address">{$_L['Address']}</label>

                                                        <textarea id="address" readonly class="form-control" rows="5"></textarea>
                                                    </div>
                                                </div>
                                                <div class='col-sm-4'>
                                                    <div class="mb-3">
                                                        <label for="invoicenum">{__('Prefix')}</label>

                                                        <input type="text" readonly
                                                        {if $invoice["status"] == "Paid"}
                                                        disabled
                                                        {/if}
                                                        class="form-control" id="invoicenum" name="invoicenum" {if $invoice}value="{$invoice->invoicenum}" {else}

                                                                {if $action == 'credit-note'}

                                                                    {if !empty($config['credit_note_prefix'])}

                                                                        value="{sp_transform_string_template($config['invoice_code_prefix'])}"



                                                                        {else}

                                                                        value="{__('CN')}"

                                                                        {/if}

                                                                    {else}
                                                                    value="{sp_transform_string_template($config['invoice_code_prefix'])}"
                                                                {/if}

                                                                {/if}>
                                                    </div>

                                                    {if $invoice}

                                                    <div class="mb-3">
                                                        <label for="cn">{__('Number')} #</label>
        
                                                        <input type="text" readonly="disabled" class="form-control" id="cn" name="cn" {if $invoice}value="{$invoice->cn}" {else} value="{str_pad($config['invoice_code_current_number'], $config['number_pad'], '0', STR_PAD_LEFT)}" {/if}>
                                                        {if $action !== 'credit-note'}
                                                            <span class="help-block">{$_L['invoice_number_help']}</span>
                                                        {/if}


                                                    </div>

                                                    {/if}

                                                </div>
                                                <div class='col-sm-4'>
                                                    {if $config['invoice_receipt_number'] eq '1'}
                                                        <div class="mb-3">
                                                            <label for="receipt_number">{$_L['Receipt Number']}</label>

                                                            <input type="text" class="form-control" id="receipt_number"
                                                                name="receipt_number" {if $invoice}value="{$invoice->receipt_number}" {/if}>
                                                        </div>
                                                    {else}
                                                        <input type="hidden" name="receipt_number" id="receipt_number" value="">
                                                    {/if}

                                                    <div class="mb-3">
                                                        <label for="show_quantity_as">{$_L['Show quantity as']}</label>

                                                        <input type="text" class="form-control" id="show_quantity_as"
                                                            name="show_quantity_as"
                                                                
                                                                {if $invoice["status"] == "Paid"}
                                                                disabled
                                                                {/if}

                                                                {if $invoice}
                                                                    value="{$invoice->show_quantity_as}"
                                                                {else}

                                                                    value="{if $config['show_quantity_as'] eq ''}{$_L['Qty']}{else}{$config['show_quantity_as']}{/if}"
                                                                {/if}

                                                        >

                                                    </div>

                                                    {if $recurring}
                                                        <div class="mb-3">
                                                            <label for="repeat">{$_L['Repeat Every']}</label>

                                                            <select class="form-select" name="repeat" id="repeat">
                                                                <option value="daily" {if $invoice && $invoice->r == '+1 day'} selected{/if}>{$_L['Daily']}</option>
                                                                <option value="week1" {if $invoice && $invoice->r == '+1 week'} selected{/if}>{$_L['Weekly']}</option>
                                                                <option value="weeks2" {if $invoice && $invoice->r == '+2 weeks'} selected{/if}>{$_L['Weeks_2']}</option>
                                                                <option value="weeks3" {if $invoice && $invoice->r == '+3 weeks'} selected{/if}>{$_L['Weeks_3']}</option>
                                                                <option value="weeks4" {if $invoice && $invoice->r == '+4 weeks'} selected{/if}>{$_L['Weeks_4']}</option>
                                                                <option value="month1" {if $invoice} {if $invoice->r == '+1 month'} selected{/if} {else} selected {/if}>{$_L['Month']}</option>
                                                                <option value="months2" {if $invoice && $invoice->r == '+2 months'} selected{/if}>{$_L['Months_2']}</option>
                                                                <option value="months3" {if $invoice && $invoice->r == '+3 months'} selected{/if}>{$_L['Months_3']}</option>
                                                                <option value="months6" {if $invoice && $invoice->r == '+6 months'} selected{/if}>{$_L['Months_6']}</option>
                                                                <option value="year1" {if $invoice && $invoice->r == '+1 year'} selected{/if}>{$_L['Year']}</option>
                                                                <option value="years2" {if $invoice && $invoice->r == '+2 years'} selected{/if}>{$_L['Years_2']}</option>
                                                                <option value="years3" {if $invoice && $invoice->r == '+3 years'} selected{/if}>{$_L['Years_3']}</option>

                                                            </select>
                                                        </div>
                                                    {else}
                                                        <input type="hidden" name="repeat" id="repeat" value="0">
                                                    {/if}



                                                </div>
                                            </div>


                                            {if $config['tax_system'] eq 'India'}
                                                <div class="row">
                                                    <div class="col-sm-4">
                                                        <div class="mb-3">
                                                            <label for="duedate">GSTIN</label>
                                                            <input type="text" class="form-control" id="business_number" name="business_number">

                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4">
                                                        <div class="mb-3">
                                                            <label for="duedate">Place of Supply</label>
                                                            <select id="place_of_supply" name="place_of_supply"
                                                                    class="form-control">


                                                                {if $invoice}

                                                                    <option value="{$config['business_location']}" {if $invoice->is_same_state == 1} selected{/if}>{$config['business_location']}</option>
                                                                    <option value="other" {if $invoice->is_same_state == 0} selected{/if}>Other</option>

                                                                {else}

                                                                    <option value="{$config['business_location']}">{$config['business_location']}</option>
                                                                    <option value="other">Other</option>


                                                                {/if}


                                                                {*{foreach $states as $state}*}
                                                                {*<option value="{$state['name']}"*}
                                                                {*{if $invoice}*}
                                                                {*{if $contact && $contact->state == $state['name']} selected{/if}*}
                                                                {*{else}*}
                                                                {*{if $config['business_location'] == $state['name']}*}
                                                                {*selected*}
                                                                {*{/if}*}
                                                                {*{/if}*}

                                                                {*>{$state['name']}</option>*}
                                                                {*{/foreach}*}



                                                            </select>

                                                        </div>
                                                    </div>


                                                </div>
                                            {/if}


                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <div class="mb-3">
                                                        <label for="idate">{$_L['Date']}</label>

                                                        <input type="text" class="form-control" id="idate" name="idate" datepicker
                                                            data-date-format="yyyy-mm-dd" data-auto-close="true"
                                                                {if $invoice}
                                                                    value="{$invoice->date}"
                                                                {else}
                                                                    value="{$idate}"
                                                                {/if}

                                                                {if $invoice["status"] == "Paid"}
                                                                disabled
                                                                {/if}
                                                        >
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="mb-3">
                                                        <label for="duedate">{$_L['Payment Terms']}</label>

                                                        {if $invoice}

                                                            <input type="text" class="form-control" id="duedate" name="duedate" datepicker
                                                                data-date-format="yyyy-mm-dd" data-auto-close="true"
                                                                value="{$invoice->duedate}" 
                                                                {if $invoice["status"] == "Paid"}
                                                                disabled
                                                                {/if}
                                                                >

                                                        {else}

                                                            <select class="form-select" name="duedate" id="duedate">
                                                                <option value="due_on_receipt" {if isset($config['invoice_default_date']) && ($config['invoice_default_date'] == 'due_on_receipt' )} selected{/if}>{$_L['Due On Receipt']}</option>
                                                                <option value="days3" {if isset($config['invoice_default_date']) && ($config['invoice_default_date'] == 'days3' )} selected{/if}>{$_L['days_3']}</option>
                                                                <option value="days5" {if isset($config['invoice_default_date']) && ($config['invoice_default_date'] == 'days5' )} selected{/if}>{$_L['days_5']}</option>
                                                                <option value="days7" {if isset($config['invoice_default_date']) && ($config['invoice_default_date'] == 'days7' )} selected{/if}>{$_L['days_7']}</option>
                                                                <option value="days10" {if isset($config['invoice_default_date']) && ($config['invoice_default_date'] == 'days10' )} selected{/if}>{$_L['days_10']}</option>
                                                                <option value="days15" {if isset($config['invoice_default_date']) && ($config['invoice_default_date'] == 'days15' )} selected{/if}>{$_L['days_15']}</option>
                                                                <option value="days30" {if isset($config['invoice_default_date']) && ($config['invoice_default_date'] == 'days30' )} selected{/if}>{$_L['days_30']}</option>
                                                                <option value="days45" {if isset($config['invoice_default_date']) && ($config['invoice_default_date'] == 'days45' )} selected{/if}>{$_L['days_45']}</option>
                                                                <option value="days60" {if isset($config['invoice_default_date']) && ($config['invoice_default_date'] == 'days60' )} selected{/if}>{$_L['days_60']}</option>
                                                            </select>

                                                        {/if}


                                                    </div>
                                                </div>
                                                <div class="col-sm-4">

                                                </div>
                                            </div>






                                            {$extraHtml}


                                        </div>
                                    </div>
                                    
                                     
                                    {if $pos eq 'pos'}
                                        <div class="ib-search-bar my-3" style="margin-bottom: 30px;">
                                            <div class="input-group">
                                                <input type="text" class="form-control" id="ib_search_input"
                                                    placeholder="{$_L['Search']}..." autofocus data-list=".list_pos_items"></div>
                                        </div>

                                        <hr>

                                        <div id="block_items" class="list_pos_items row">


                                        </div>
                                    {/if}


                                    <div class="table-responsive mt-3">

                                        {if $config['tax_system'] == 'India'}
                                            <table class="table table-bordered invoice-table" id="invoice_items">


                                                <thead>


                                                <tr>

                                                    <th width="25%" rowspan="2">{$_L['Item Name']}</th>
                                                    <th rowspan="2">HSN / SAC</th>
                                                    <th rowspan="2">{if $config['show_quantity_as'] eq ''}{$_L['Qty']}{else}{$config['show_quantity_as']}{/if}</th>
                                                    <th rowspan="2">{$_L['Price']}</th>

                                                    <th colspan="2">{$_L['Discount']}</th>

                                                    <th rowspan="2" style="width: 80px;">Rate</th>

                                                    <th colspan="3" class="text-center">
                                                        Tax Values (Rs.)
                                                    </th>

                                                    <th rowspan="2">{$_L['Total']}</th>


                                                </tr>

                                                <tr>

                                                    <th colspan="2">

                                                        {if $invoice}

                                                            <label class="radio-inline">
                                                                <input  class="discountType" id="discountTypeP" type="radio" name="discount_type" value="p"
                                                                    {if $invoice->discount_type == 'p'}checked{/if}

                                                                    {if $invoice["status"] == "Paid"}
                                                                        disabled
                                                                        {/if}
                                                                >%
                                                            </label>
                                                            <label class="radio-inline">
                                                                <input  class="discountType" id="discountTypeF" type="radio" name="discount_type" value="f" {if $invoice->discount_type == 'f'}checked{/if}
                                                                {if $invoice["status"] == "Paid"}
                                                                disabled
                                                                {/if}
                                                                >Rs
                                                            </label>

                                                        {else}

                                                            <label class="radio-inline">
                                                                <input  class="discountType" id="discountTypeP" type="radio" name="discount_type" value="p" checked>%
                                                            </label>
                                                            <label class="radio-inline">
                                                                <input class="discountType" id="discountTypeF" type="radio" name="discount_type" value="f">Rs
                                                            </label>

                                                        {/if}



                                                    </th>


                                                    <th>CGST</th>
                                                    <th>SGST</th>
                                                    <th>IGST</th>

                                                </tr>

                                                </thead>
                                                <tbody>

                                                {if $items}

                                              

                                                    {foreach $items as $item}

                                                        <tr>
                                                            <td>
                                                                <textarea class="form-control item_name" name="desc[]" rows="3" {if $invoice["status"] == "Paid"}disabled{/if}>{$item->description}</textarea>
                                                                <input type="hidden" name="item_code[]" value="{$item->itemcode}" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                            </td>

                                                            <td>
                                                                <input type="text" class="form-control tax_code" value="{$item->tax_code}" name="tax_code[]" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                            </td>

                                                            <td>
                                                                <input type="text" class="form-control qty" value="{numberFormatUsingCurrency($item->qty,$invoice->currency_iso_code)}" name="qty[]" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                            </td>

                                                            <td>
                                                                
                                                                 

                                                                {if $habilitar_precio_facturas == "1"}

                                                                    {if $item->itemcode == 17}
                                                                        <input type="text"  class="form-control item_price" name="amount[]" value="{numberFormatUsingCurrency($item->amount,$invoice->currency_iso_code)}" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                                    {else}
                                                                        <input type="text" readonly class="form-control item_price" name="amount[]" value="{numberFormatUsingCurrency($item->amount,$invoice->currency_iso_code)}" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                                    {/if}

                                                                {else}
                                                                    
                                                                    {if $item->itemcode == 17}
                                                                        <input type="text"  class="form-control item_price" readonly name="amount[]" value="{numberFormatUsingCurrency($item->amount,$invoice->currency_iso_code)}" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                                    {else}
                                                                        <input type="text" readonly class="form-control item_price" readonly name="amount[]" value="{numberFormatUsingCurrency($item->amount,$invoice->currency_iso_code)}" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                                    {/if}

                                                                {/if}

                                                                 
                                                            </td>

                                                            <td colspan="2">
                                                                <input type="text" class="form-control item_discount" name="discount[]" value="{numberFormatUsingCurrency($item->discount_amount,$invoice->currency_iso_code)}" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                            </td>

                                                            <td>

                                                                <select class="form-select taxed" name="taxed[]" {if $invoice["status"] == "Paid"}disabled{/if}>

                                                                    {foreach $t as $ts}
                                                                        <option value="{$ts['rate']}"
                                                                                {if $ts['rate'] eq $item['tax_rate']}selected{/if}>{$ts['name']}</option>
                                                                    {/foreach}

                                                                </select>


                                                            </td>

                                                            <td>
                                                                <input type="text" class="form-control cgst" name="cgst[]" disabled value="">
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control sgst" name="sgst[]" disabled value="">
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control igst" name="igst[]" disabled value="">
                                                            </td>

                                                            <td class="ltotal"><input type="text" class="form-control lvtotal" readonly=""
                                                                                    value=""></td>
                                                        </tr>

                                                    {/foreach}

                                                {/if}


                                                <tr>
                                                    <td>
                                                       <!-- <textarea class="form-control item_name" name="desc[]" rows="3"></textarea> -->
                                                        <label style="color: #666;">
                                                            Name Product
                                                        </label>
                                                        <textarea readonly class="form-control " name="nombre_producto[]" rows="3"></textarea>
                                                        
                                                        <label style="color: #666; margin-top:20px;">
                                                            Description Product
                                                        </label>
                                                        <textarea class="form-control item_name" name="desc[]" rows="3"></textarea>
                                                            
                                                        <input type="hidden" name="item_code[]" value="">
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control tax_code" value="" name="tax_code[]">
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control qty" value="" name="qty[]">
                                                    </td>
                                                    <td>

                                                    {if $habilitar_precio_facturas == "1"}
                                                        <input type="text" class="form-control item_price" name="amount[]" value="">
                                                    {else}
                                                        <input type="text" class="form-control item_price" readonly name="amount[]" value="">
                                                    {/if}

                                                    <td colspan="2"><input type="text" class="form-control item_discount" name="discount[]" value="">

                                                    </td>

                                                    <td><select class="form-select taxed" name="taxed[]">
                                                            {foreach $t as $ts}
                                                                <option value="{$ts['rate']}"
                                                                        {if $ts['is_default'] eq '1'}selected{/if}>{$ts['name']}</option>
                                                            {/foreach} </select></td>

                                                    <td>
                                                        <input type="text" class="form-control cgst" name="cgst[]" disabled value="">
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control sgst" name="sgst[]" disabled value="">
                                                    </td>
                                                    <td>
                                                        <input type="text" class="form-control igst" name="igst[]" disabled value="">
                                                    </td>

                                                    <td class="ltotal"><input type="text" class="form-control lvtotal" readonly=""
                                                                            value=""></td>
                                                </tr>

                                                </tbody>
                                            </table>

                                        {else}

                                            <table class="table table-bordered invoice-table" id="invoice_items">
                                                <thead>
                                                <tr>

                                                    <th width="30%">{$_L['Item Name']}</th>
                                                    <th width="10%">{if $config['show_quantity_as'] eq ''}{$_L['Qty']}{else}{$config['show_quantity_as']}{/if}</th>
                                                    <th width="15%">{$_L['Price']}</th>

                                                    <th colspan="2">{$_L['Discount']}</th>

                                                    <th width="20%">{$_L['Tax']}</th>

                                                    <th width="15%">{$_L['Total']}</th>


                                                </tr>
                                                <tr>
                                                    <th colspan="3"></th>
                                                    <th colspan="2">

                                                        {if $invoice}


                                                            <label class="radio-inline">
                                                                <input class="discountType" id="discountTypeP" type="radio" name="discount_type" value="p" {if $invoice->discount_type == 'p'}checked{/if}
                                                                {if $invoice["status"] == "Paid"}
                                                                disabled
                                                                {/if}
                                                                > <span  data-bs-toggle="tooltip" data-placement="top" title="{$_L['Percentage']}">%</span>
                                                            </label>
                                                            <label class="radio-inline">
                                                                <input class="discountType" id="discountTypeF" type="radio" name="discount_type" value="f" {if $invoice->discount_type == 'f'}checked{/if}
                                                                {if $invoice["status"] == "Paid"}
                                                                disabled
                                                                {/if}
                                                                > <span data-bs-toggle="tooltip" data-placement="top" title="{$_L['Fixed Amount']}" id="fixedDiscountText">
                                                            {if isset($currencies[$config['home_currency']])}
                                                                {$currencies[$config['home_currency']]['symbol']}
                                                            {else}

                                                            {/if}
                                                        </span>
                                                            </label>

                                                        {else}

                                                            <label class="radio-inline">
                                                                <input class="discountType" id="discountTypeP" type="radio" name="discount_type" value="p" checked> <span  data-bs-toggle="tooltip" data-placement="top" title="{$_L['Percentage']}">%</span>
                                                            </label>
                                                            <label class="radio-inline">
                                                                <input class="discountType" id="discountTypeF" type="radio" name="discount_type" value="f"> <span data-bs-toggle="tooltip" data-placement="top" title="{$_L['Fixed Amount']}" id="fixedDiscountText">
                                                            {if isset($currencies[$config['home_currency']])}
                                                                {$currencies[$config['home_currency']]['symbol']}
                                                            {else}

                                                            {/if}
                                                        </span>
                                                            </label>

                                                        {/if}



                                                    </th>
                                                    <th colspan="2"></th>
                                                </tr>
                                                </thead>
                                                <tbody>


                                                {if $items}
 
                                                    {foreach $items as $item}

                                                        <tr>
                                                            <td>
                                                                {if !empty($config['invoicing_allow_staff_selection_for_each_item'])}

                                                                    <div class="mb-3">
                                                                        <select name="staff_id[]" class="form-select" 
                                                                        {if $invoice["status"] == "Paid"}
                                                                        disabled
                                                                        {/if}
                                                                        ><option value="0">{{__('Select Staff')}}</option>{foreach $staffs as $employee}<option value="{$employee->id}"
                                                                            {if $item->staff_id == $employee->id} selected {/if}
                                                                            >{$employee->fullname}</option>{/foreach}</select>
                                                                    </div>

                                                                {/if}
                                                                <label style="color: #666;">
                                                                    Name Product
                                                                </label>
                                                                <textarea readonly class="form-control " name="nombre_producto[]" rows="3">{$item->name_products}</textarea>
                                                                
                                                                <label style="color: #666; margin-top:20px;">
                                                                    Description Product
                                                                </label>
                                                                <textarea class="form-control item_name" name="desc[]" rows="3" >{$item->description}</textarea>
                                                                <input type="hidden" name="item_code[]" value="{$item->itemcode}" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                                
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control qty" value="{numberFormatUsingCurrency($item->qty,$invoice->currency_iso_code)}" name="qty[]" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                            </td>
                                                            <td>

                                                            {if $habilitar_precio_facturas == "1"}
                                                                
                                                                {if $item->itemcode == 17}
                                                                    <input type="text" class="form-control item_price" name="amount[]" value="{numberFormatUsingCurrency($item->amount,$invoice->currency_iso_code)}" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                                {else}
                                                                    <input type="text" class="form-control item_price" name="amount[]" value="{numberFormatUsingCurrency($item->amount,$invoice->currency_iso_code)}" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                                {/if}

                                                            {else}
                                                                
                                                                {if $item->itemcode == 17}
                                                                    <input type="text" class="form-control item_price" name="amount[]" value="{numberFormatUsingCurrency($item->amount,$invoice->currency_iso_code)}" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                                {else}
                                                                    <input type="text" readonly class="form-control item_price" name="amount[]" value="{numberFormatUsingCurrency($item->amount,$invoice->currency_iso_code)}" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                                {/if}

                                                            {/if}

                                                            

                                                            </td>
                                                            <td colspan="2">
                                                                <input type="text" class="form-control item_discount" name="discount[]" value="{numberFormatUsingCurrency($item->discount_amount,$invoice->currency_iso_code)}" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                            </td>
                                                            <td>
                                                                <select class="form-select taxed" name="taxed[]" {if $invoice["status"] == "Paid"}disabled{/if}>
                                                                    {foreach $t as $ts}
                                                                        <option value="{$ts['rate']}"
                                                                                {if $item->tax_rate eq $ts['rate']}selected{/if}>{$ts['name']}</option>
                                                                    {/foreach} </select></td>

                                                            <td class="ltotal">
                                                                <input type="text" class="form-control lvtotal" readonly="" value="">                                                                         
                                                            </td>
                                                        </tr>

                                                    {/foreach}

                                                {/if}

                                                {if $invoice["status"] != "Paid"}

                                                <!--
                                                    <tr>
                                                        <td>

                                                            {if !empty($config['invoicing_allow_staff_selection_for_each_item'])}
                                                                <div class='mb-3'>

                                                                    <select name="staff_id[]"  class="form-select"><option value="0">{{__('Select Staff')}}</option>{foreach $staffs as $employee}<option value="{$employee->id}">{$employee->fullname}</option>{/foreach}</select>

                                                                </div>

                                                            {/if}


                                                            <label style="color: #666;">
                                                                Name Product
                                                            </label>
                                                            <textarea readonly class="form-control " name="nombre_producto[]" rows="3"></textarea>
                                                            
                                                            <label style="color: #666; margin-top:20px;">
                                                                Description Product
                                                            </label>
                                                            <textarea class="form-control item_name" name="desc[]" rows="3"></textarea>
 

                                                    
                                                            <input type="hidden" name="item_code[]" value="">
                                                        </td>
                                                        <td>
                                                            <input type="text" class="form-control qty" value="" name="qty[]">
                                                        </td>
                                                        
                                                        <td>
                                                            
                                                            {if $habilitar_precio_facturas == "1"}
                                                                <input type="text" class="form-control item_price" name="amount[]" value=""> 
                                                            {else}
                                                                <input type="text" class="form-control item_price" readonly name="amount[]" value="">
                                                            {/if}

                                                             
                                                        </td>
                                                        
                                                        
                                                        <td colspan="2">
                                                            <input type="text" class="form-control item_discount" name="discount[]" value="">
                                                        </td>
                                                        <td>
                                                            <select class="form-select taxed" name="taxed[]">
                                                                {foreach $t as $ts}
                                                                    <option value="{$ts['rate']}"
                                                                            {if $ts['is_default'] eq '1'}selected{/if}>{$ts['name']}</option>
                                                                {/foreach} 
                                                            </select>
                                                        </td>

                                                        <td class="ltotal">
                                                            <input type="text" class="form-control lvtotal" readonly="" value="">
                                                                                 
                                                        </td>
                                                    </tr>
                                                -->
                                                {/if}

                                                


                                                </tbody>
                                            </table>

                                        {/if}


                                    </div>
                                    <!-- /table-responsive -->
                                    {if !$invoice || $invoice["status"] != "Paid"}


                                       <!-- <button type="button" class="btn btn-primary" id="blank-add"><i
                                                class="fal fa-plus"></i> {$_L['Add blank Line']}</button> -->


                                        <button type="button" class="btn btn-primary" id="item-add"><i
                                                    class="fal fa-search"></i> {$_L['Add Product OR Service']}</button>
                                        <button type="button" class="btn btn-danger" id="item-remove"><i
                                                    class="fal fa-minus-circle"></i> {$_L['Delete']}</button>
                                    {/if}

                                    
                                    <br>
                                    <br>
                                    <hr>

                                    <div class="row">
                                        <div class="col-md-4 offset-md-8">
                                            <table class="table invoice-total">
                                                <tbody>
                                                <tr>
                                                    <td><strong>{$_L['Sub Total']} :</strong></td>
                                                    <td id="sub_total" class="amount">0.00
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <strong>{$_L['Discount']} <span id="is_pt"></span> : </strong>


                                                    </td>
                                                    <td id="discount_amount_total" class="amount">0.00
                                                    </td>
                                                </tr>
                                                {if $config['tax_system'] eq 'default'}
                                                    <tr>
                                                        <td><strong>{$_L['TAX']} :</strong></td>
                                                        <td id="taxtotal" class="amount">0.00
                                                        </td>
                                                    </tr>

                                                {elseif $config['tax_system'] eq 'ca_quebec'}

                                                    <div id="taxValTr">
                                                        <tr>
                                                            <td><strong>{$_L['TAX']} :</strong></td>
                                                            <td id="taxtotal" class="amount">0.00
                                                            </td>
                                                        </tr>
                                                    </div>


                                                {elseif $config['tax_system'] eq 'India'}


                                                    <div id="taxValTr">
                                                        <tr>
                                                            <td><strong>{$_L['TAX']} :</strong></td>
                                                            <td id="taxtotal" class="amount">0.00
                                                            </td>
                                                        </tr>
                                                    </div>
                                                {/if}
                                                <tr>
                                                    <td><strong>{$_L['TOTAL']} :</strong></td>
                                                    <td id="total" class="amount">0.00
                                                    </td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>


                                    <hr>
                                    <textarea class="form-control" name="notes" id="notes" rows="3"
                                            placeholder="{$_L['Invoice Terms']}...">{if $invoice}{$invoice->notes}{else}{$config['invoice_terms']}{/if}</textarea>
                                    <br>



                                    {if $recurring}
                                        <input type="hidden" id="is_recurring" value="yes">
                                    {else}
                                        <input type="hidden" id="is_recurring" value="no">
                                    {/if}

                                </div>
                            </div>

                        </div>

 




                    </div>






                </div>


                <input type="hidden" name="document_type" value="{{$action}}">

            </form>
            {* Fin Invoices *}


            {* Historial de aprobacion *}
            {if count($historial_aprobacion) != 0 }
                <div class="row">
                    <div class="col-md-12">
                        
                        <div class="panel ">
                            <div class="panel-hdr">                                                                                                                       
                                <h2><span></span>Approval history</h2>
                            </div>

                            <div class="panel-container show" id="ibox_form_observaciones">
                                <div class="panel-content">
                                    <div class="px-2">
                                        
                                        <div class="table-responsive">

                            <table id="clx_datatable" class="table table-striped w-100 sys_table footable">
                                <thead style="background: #f0f2ff">
                                <tr>
                                    <th>Date</th>
                                    <th>User</th>
                                    <th>State</th>
                                    <th>Observations</th>
                               
                                </tr>
                                </thead>
                                <tbody>

                                {foreach $historial_aprobacion as $ds}
                                    <tr>

 

                                        <td>
                                              {$ds['fecha']}
                                        </td>

                                        <td>
                                             {$ds['username']}
                                        </td>

                                        <td>
                                             {$ds['state']}
                                        </td>

                                        <td>
                                             {$ds['observations']}
                                        </td>

 
                                    </tr>
                                {/foreach}

                                </tbody>



                            </table>

                        </div>
                                    
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </div>
            {/if}
            {* FIN Historial de aprobacion *}

            {* lan variables *}
            <input type="hidden" id="_lan_set_discount" value="{$_L['Set Discount']}">
            <input type="hidden" id="_lan_discount" value="{$_L['Discount']}">
            <input type="hidden" id="_lan_discount_type" value="{$_L['Discount Type']}">
            <input type="hidden" id="_lan_percentage" value="{$_L['Percentage']}">
            <input type="hidden" id="_lan_fixed_amount" value="{$_L['Fixed Amount']}">
            <input type="hidden" id="_lan_btn_save" value="{$_L['Save']}">
            <input type="hidden" id="_lan_no_results_found" value="{$_L['No results found']}">
{/block}


{block name="script"}

    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.2/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.2/js/buttons.html5.min.js"></script>

    <script>

        var habilitar_precio_facturas = $(".habilitar_precio_facturas").val();

        console.log("habilitar_precio_facturas");
        console.log(habilitar_precio_facturas);

        /* var $modal = $('#cloudonex_body');


        $modal.on('click', '.cdelete', function(e){
                e.preventDefault();
                var id = this.id;
                app.confirm("{__('are_you_sure')}", function(result) {
                    if(result){
                        window.location.href = base_url + "delete/invoice/" + id;
                    }
                });
        }) */;

     

    function isEmpty(variable) {
        if (variable === null || variable === undefined) {
            return true;
        }

        if (typeof variable === "string") {
            return variable.trim() === "";
        }

        if (Array.isArray(variable)) {
            return variable.length === 0;
        }

        if (typeof variable === "object") {
            return Object.keys(variable).length === 0;
        }

        return false;
    }

 
    const tomarContactos = $('.tener_contactos').text();
    //console.log(tomarContactos);

    var arrayCrmClientes = [];

    try {
        let parsearContacto = JSON.parse(tomarContactos);

        if (Array.isArray(parsearContacto)) {

            arrayCrmClientes = parsearContacto || [];

            let p_cid = $('.cliente_id').val();
            let html = '';
            let html_client_reference = '';

            html += '<option value="" ' + (p_cid ? '' : 'selected="selected"') + '>Select Contact</option>';

            for (let i = 0; i < parsearContacto.length; i++) {
                const contacto = parsearContacto[i];
                const value = contacto.id;

                let text = '';

                if (contacto.company) {
                    text += contacto.company + ' - ';
                }
                text += contacto.account;
                if (contacto.email) {
                    text += ' - ' + contacto.email;
                }
                if (contacto.phone) {
                    text += ' - ' + contacto.phone;
                }
                if (contacto.code) {
                    text += ' [' + contacto.code + ']';
                }

                let selected = (p_cid == value) ? ' selected="selected"' : '';

                html += '<option value="' + value + '"' + selected + '>' + text + '</option>';
                html_client_reference += '<option value="' + value + '"' + selected + '>' + text + '</option>';
            }

            $('#cid').html(html);
            $('#refiere_clients_id').append(html_client_reference);

            $('#refiere_clients_id').select2({

                language: {
                    noResults: function () {
                        return $("#_lan_no_results_found").val();
                    }
                }
            });

        }
    } catch (error) {
        console.error('Error al parsear los contactos:', error);
    }

    var accountCompanys = [];
    /*
    const tener_crm_account_company = $('.tener_crm_account_company').text();
    //console.log(tomarContactos);

    try {
        let parsearCRMAccount = JSON.parse(tener_crm_account_company);

        if (Array.isArray(parsearCRMAccount)) 
        {
            accountCompanys = parsearCRMAccount; 
        }

    } catch (error) {
        console.error('Error al parsear los account:', error);
    }
    */

 

        $('#observaciones_invoices').redactor(
                {
                    minHeight: 200, // pixels
                    plugins: ['fontcolor']
                }
            );

        String.prototype.replaceAll = function(search, replacement) {
            var target = this;
            return target.replace(new RegExp(search, 'g'), replacement);
        };

        String.prototype.trunc = String.prototype.trunc ||
            function (n) {
                return (this.length > n) ? this.substr(0, n - 1) + '&hellip;' : this;
            };

        var selectedCurrency;

        function getSelectedCurrencySymbol() {
            selectedCurrency = document.getElementById('currency');
            return selectedCurrency.options[selectedCurrency.selectedIndex].getAttribute('data-symbol');
        }

        function getSelectedCurrencyDecimalMark() {
            selectedCurrency = document.getElementById('currency');
            return selectedCurrency.options[selectedCurrency.selectedIndex].getAttribute('data-decimal-mark');
        }

        function getSelectedCurrencyThousandsSeparator() {
            selectedCurrency = document.getElementById('currency');
            return selectedCurrency.options[selectedCurrency.selectedIndex].getAttribute('data-thousands-separator');
        }

        function selectedCurrencyIsSymbolFirst() {
            selectedCurrency = document.getElementById('currency');
            if(selectedCurrency.options[selectedCurrency.selectedIndex].getAttribute('data-symbol-first') === 'yes')
            {
                return true;
            }
            else
            {
                return false;
            }

        }

        function clx_number_format(number, decimals, dec_point, thousands_sep) {

            var n = !isFinite(+number) ? 0 : +number,
                prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
                sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
                dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
                toFixedFix = function (n, prec) {
                    // Fix for IE parseFloat(0.55).toFixed(0) = 0;
                    var k = Math.pow(10, prec);
                    return Math.round(n * k) / k;
                },
                s = (prec ? toFixedFix(n, prec) : Math.round(n)).toString().split('.');
            if (s[0].length > 3) {
                s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
            }
            if ((s[1] || '').length < prec) {
                s[1] = s[1] || '';
                s[1] += new Array(prec - s[1].length + 1).join('0');
            }
            return s.join(dec);
        }

        function formatCurrency(amount) {
            var prefix = '';
            var suffix = '';
            if(selectedCurrencyIsSymbolFirst())
            {
                prefix = getSelectedCurrencySymbol() + ' ';
            }
            else
            {
                suffix = ' ' + getSelectedCurrencySymbol();
            }


            return prefix + clx_number_format(amount,2,getSelectedCurrencyDecimalMark(),getSelectedCurrencyThousandsSeparator()) + suffix;

        }


        function parseAmount(amount,to_fixed_digits) {

            let digits = 2;

            if(amount === '')
            {
                return 0.00;
            }

            if(typeof to_fixed_digits !== 'undefined')
            {
                digits = to_fixed_digits;
            }


            if(getSelectedCurrencyDecimalMark() === ',')
            {
                amount = amount.split('.').join('');
                amount = amount.replace(',','.');
            }
            else{
                amount = amount.replace(',','');
            }


            return parseFloat(amount).toFixed(digits);

        }



        function calculatePercentage(amount,percentage) {
            return (amount)*(percentage/100);
        }

        var is_same_state = false;

        {if $config['tax_system'] eq 'India'}

        var $place_of_supply = $('#place_of_supply');

        function taxState() {
            if($place_of_supply.val() == '{$config['business_location']}')
            {
                is_same_state = true;
            }
            else
            {
                is_same_state = false;
            }
        }


        taxState();





        {/if}



        $(document).ready(function () {

            let existe_recommended_type_id = $('#existe_recommended_type_id').val();
            let existe_refiere_clients_id = $('#existe_refiere_clients_id').val();

            let existe_invoices_refiere_staff_id = $('#existe_invoices_refiere_staff_id').val();

            if(!isEmpty(existe_recommended_type_id))
            {
                $("#recommended_type_id").val(existe_recommended_type_id);   
                
                $(".showByStaff").css("display", "none");
                $(".showByClients").css("display", "none");

                $(".habilitar_otros_nombre_referencia").css("display", "none");
                $(".habilitar_otros_nombre_referencia_clientes").css("display", "none");
                $(".habilitar_otros_nombre_referencia_otros").css("display", "none");

                $(".changesColumnsRecommendedType").removeClass("col-sm-4");  
                $(".changesColumnsRecommendedType").removeClass("col-sm-8"); 
                
                //$("#refiere_clients_id").val("NULL").trigger("change"); 
                //$("#refiere_staff_nombre").val(""); 
                //$("#refiere_staff_id").val("NULL"); 
                //$("#refiere_otros_nombre").val(""); 
                //$("#refiere_clients_nombre").val(""); 
    
                if(existe_recommended_type_id == "None")
                {
                    $(".changesColumnsRecommendedType").addClass("col-sm-8");  
                } 

                if(existe_recommended_type_id == "By Staff")
                {
                    $(".showByStaff").css("display", "");
                    $(".changesColumnsRecommendedType").addClass("col-sm-4");  

                    if(isEmpty(existe_invoices_refiere_staff_id) == true)
                    {
                        $('#refiere_staff_id').val("NULL").trigger("change");
                    }else{
                    
                        if(existe_invoices_refiere_staff_id == "0")
                        {
                            $('#refiere_staff_id').val("0").trigger("change");
                        }else{
                            $('#refiere_staff_id').val(existe_invoices_refiere_staff_id).trigger("change");
                        }
                    }

                }

                if(existe_recommended_type_id == "By clients")
                {
                    $(".showByClients").css("display", "");
                    $(".changesColumnsRecommendedType").addClass("col-sm-4");  

                    if(isEmpty(existe_refiere_clients_id) == true)
                    {
                        $('#refiere_clients_id').val("NULL");
                    }else{
                    
                        if(existe_refiere_clients_id == "0")
                        {
                            $('#refiere_clients_id').val("0");
                        }else{
                            $('#refiere_clients_id').val(existe_refiere_clients_id);
                        }
                    }


                }

                // Si no es staff ni clientes es otros
                if(existe_recommended_type_id == "Other")
                {
                    $(".habilitar_otros_nombre_referencia_otros").css("display", "");
                    $(".changesColumnsRecommendedType").addClass("col-sm-8");  
                }

            }else{
                 
            }

             

            //console.log("existe_recommended_type_id");
            //console.log(existe_recommended_type_id);

            //console.log("existe_invoices_refiere_staff_id");
            //console.log(existe_invoices_refiere_staff_id);

            /*
            if(isEmpty(existe_invoices_refiere_staff_id) == true)
            {
                $('#refiere_staff_id').val("NULL");
            }else{
             
                if(existe_invoices_refiere_staff_id == "0")
                {
                    $('#refiere_staff_id').val("0");
                }else{
                     $('#refiere_staff_id').val(existe_invoices_refiere_staff_id);
                }
            }
            */

             
              

            let refiere_staff_id = $('#refiere_staff_id').val();

            let existe_invoices = $('#existe_invoices').val();
 
            //console.log("existe_invoices");
            //console.log(existe_invoices);

            //console.log("refiere_staff_id");
            //console.log(refiere_staff_id);

            //existe_invoices_refiere_staff_id

            if(existe_invoices == 2)
            {

                if(refiere_staff_id != "NULL")
                {
                    if(refiere_staff_id == "0")
                    {
                        $(".habilitar_otros_nombre_referencia").css("display", "");
                        //$("#refiere_staff_nombre").val("");
                    }else{
                        $(".habilitar_otros_nombre_referencia").css("display", "none");

                        /*
                        var staffs = {$staffs|@json_encode nofilter};

                        var staffsData = Object.values(staffs);
                        
                        if(Array.isArray(staffsData))
                        {
                            let tener_nombre = staffsData.find((staff) => staff.id == refiere_staff_id);

                            if(tener_nombre)
                            {
                                $("#refiere_staff_nombre").val(tener_nombre.fullname);
                            }
                        }
                        */
        
                    }
                }else{
                    //$("#refiere_staff_nombre").val("");
                    $(".habilitar_otros_nombre_referencia").css("display", "none");
                }

            }

            /* $('#clx_datatable').dataTable(
                {
                    responsive: true,
                    lengthChange: false,
                    dom:
                     
                        "<'row mb-3'<'col-sm-12 col-md-6 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-6 d-flex align-items-center justify-content-end'lB>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                    buttons: [

                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-warning btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-secondary btn-sm'
                        }
                    ],
                    "language": {
                        "emptyTable": "{$_L['No items to display']}",
                        "info":      "{$_L['Showing _START_ to _END_ of _TOTAL_ entries']}",
                        "infoEmpty":      "{$_L['Showing 0 to 0 of 0 entries']}",
                        buttons: {
                            pageLength: '{$_L['Show all']}'
                        },
                        searchPlaceholder: "{__('Search')}"
                    },
                }
            ); */

            $('[data-bs-toggle="tooltip"]').tooltip();




            var c_qty;
            var c_price;
            var c_taxed;
            var c_discount;

            var lineTotal;
            var lineDiscount;

            var tax_val;

            var $discount_amount_total = $("#discount_amount_total");

            var $discount_amount = $("#discount_amount");
            var $discount_type = $("#discount_type");


            function spEditor(selector) {

                $(selector).redactor({
                    minHeight: 30,
                    buttons: ['html', '|', 'formatting', '|', 'bold', 'italic', 'link', 'unorderedlist', 'orderedlist']
                });

            }


            function spMultiSelect(selector) {
                /*
                $(selector).multiselect(
                    {
                        allSelectedText: false,
                        nonSelectedText: 'None'
                    }
                );
                */


            }

            spMultiSelect('.taxed');


            var $total = $("#total");
            var $taxtotal = $("#taxtotal");
            var $sub_total = $("#sub_total");



            var $invoice_items = $('#invoice_items');

            var invTotal = 0;

            var totalTaxVal = 0;


            var lineTotalWithoutTax;

            var totalLineTotalWithoutTax = 0;

            var discount_type = 'p';

            var totalDiscount;

            function calculateTotal() {

                discount_type = document.querySelector('.discountType:checked').value;

                invTotal = 0;

                totalTaxVal = 0;

                tax_val = 0;

                lineTotalWithoutTax = 0;

                totalLineTotalWithoutTax = 0;

                totalDiscount = 0;

                var c_taxed_split;



                {if $config['tax_system'] == 'India'}


                $.each($('.qty'), function (index, value) {

                    c_qty = this.value;

                    c_qty = parseAmount(c_qty);

                    c_price = $(this).closest('tr').find('.item_price').val();


                    {if isset($config['decimal_places_products_and_services'])}
                    c_price = parseAmount(c_price,{$config['decimal_places_products_and_services']});
                    {else}
                    c_price = parseAmount(c_price);
                    {/if}



                    c_discount = $(this).closest('tr').find('.item_discount').val();
                    c_discount = parseAmount(c_discount);

                    if (c_qty === '' || c_price === '') {
                        return;
                    }




                    c_taxed = $(this).closest('tr').find('.taxed').val();

                    c_taxed_split = (c_taxed/2).toFixed(2);

                    lineTotal = c_price * c_qty;
                    lineTotal = parseFloat(lineTotal);

                    lineTotalWithoutTax = lineTotal;


                    if(discount_type == 'p')
                    {
                        lineDiscount = calculatePercentage(lineTotal,c_discount);
                    }
                    else {
                        lineDiscount = c_discount;
                    }

                    lineTotal = (lineTotal-lineDiscount);



                    if (c_taxed === '' || c_taxed === null) {

                        tax_val = 0;

                    }
                    else {
                        c_taxed = parseFloat(c_taxed).toFixed(3);

                        tax_val = (lineTotal * c_taxed) / 100;


                        lineTotal = lineTotal + tax_val;
                    }

                    if(is_same_state)
                    {
                        $(this).closest('tr').find('.cgst').val(tax_val/2);
                        $(this).closest('tr').find('.sgst').val(tax_val/2);
                        $(this).closest('tr').find('.igst').val(0);
                    }
                    else
                    {
                        $(this).closest('tr').find('.cgst').val(0);
                        $(this).closest('tr').find('.sgst').val(0);
                        $(this).closest('tr').find('.igst').val(tax_val/2);
                    }



                    //  console.log(c_taxed);


                    $(this).closest('tr').find('.lvtotal').val(lineTotal.toFixed(2));




                    totalTaxVal += tax_val;

                    totalLineTotalWithoutTax += lineTotalWithoutTax;

                    totalDiscount += lineDiscount;


                });






                {else}




                $.each($('.qty'), function (index, value) {
                    //                    console.log(index);
                    //                    console.log(this.value);


                    c_qty = this.value;

                    c_qty = parseAmount(c_qty);

                    c_price = $(this).closest('tr').find('.item_price').val();



                    {if isset($config['decimal_places_products_and_services'])}
                    c_price = parseAmount(c_price,{$config['decimal_places_products_and_services']});
                    {else}
                    c_price = parseAmount(c_price);
                    {/if}


                    c_discount = $(this).closest('tr').find('.item_discount').val();
                    c_discount = parseAmount(c_discount);

                    // console.log(c_discount);


                    if (c_qty === '' || c_price === '') {
                        return;
                    }


                    c_taxed = $(this).closest('tr').find('.taxed').val();



                    lineTotal = c_price * c_qty;

                    lineTotal = parseFloat(lineTotal);



                    lineTotalWithoutTax = lineTotal;

                    if(discount_type == 'p')
                    {
                        lineDiscount = calculatePercentage(lineTotal,c_discount);
                    }
                    else {
                        lineDiscount = c_discount;
                    }

                    // console.log(lineDiscount);

                    lineTotal = (lineTotal-lineDiscount);


                    if (c_taxed === '' || c_taxed === null) {

                        tax_val = 0;

                    }
                    else {
                        c_taxed = parseFloat(c_taxed).toFixed(3);

                        tax_val = (lineTotal * c_taxed) / 100;



                        //  console.log(c_taxed);
                        //  console.log(lineTotal);

                        lineTotal = lineTotal + tax_val;
                    }



                    $(this).closest('tr').find('.lvtotal').val(lineTotal.toFixed(2));




                    totalTaxVal += tax_val;

                    totalLineTotalWithoutTax += lineTotalWithoutTax;

                    lineDiscount = parseFloat(lineDiscount);

                    totalDiscount += lineDiscount;


                });







                {/if}


                totalDiscount = parseFloat(totalDiscount);

                invTotal = totalLineTotalWithoutTax - totalDiscount + totalTaxVal;

                $total.html(formatCurrency(invTotal.toFixed(2)));
                $taxtotal.html(formatCurrency(totalTaxVal.toFixed(2)));
                $sub_total.html(formatCurrency(totalLineTotalWithoutTax.toFixed(2)));
                $discount_amount_total.html(formatCurrency(totalDiscount.toFixed(2)));


            }

            calculateTotal();

            {if $config['tax_system'] == 'India'}

            $place_of_supply.on('change',function () {

                taxState();
                calculateTotal();

            });

            {/if}


            $('#discountTypeP').change(function () {
                calculateTotal();
            });

            $('#discountTypeF').change(function () {
                calculateTotal();
            });

            var $currency = $('#currency');
            var $fixedDiscountText = $('#fixedDiscountText');

            $currency.on('change',function () {
                $fixedDiscountText.html(getSelectedCurrencySymbol());
                calculateTotal();
            });


            var $block_items = $("#block_items");

            var _url = $("#_url").val();



            $('#notes').redactor(
                {
                    minHeight: 200, // pixels
                    plugins: ['fontcolor']
                }
            );


            spEditor('.item_name');


            $invoice_items.on('change', '.taxed', function () {
                //   $('#taxtotal').html('dd');
                // var taxrate = $('#stax').val().replace(',', '.');
                // $(this).val(taxrate);

                calculateTotal();


            });


            $invoice_items.on('change', '.qty', function () {

                calculateTotal();

            });

            $invoice_items.on('change', '.item_price', function () {

                calculateTotal();

            });

            $invoice_items.on('change', '.item_discount', function () {

                calculateTotal();

            });


            var item_remove = $('#item-remove');
            item_remove.hide();


            function update_address() {
                var _url = $("#_url").val();
                var cid = $('#cid').val();

                if (cid != '') {

                    $.post(_url + 'contacts/json-single-contact-v1/', {
                        cid: cid

                    })
                        .done(function (data) {
                            var adrs = $("#address");

                            adrs.html(data.address_full);

                            if (document.getElementById('business_number')) {
                                $('#business_number').val(data.business_number);
                            }

                            accountCompanys = data.list_of_companies || [];

                            let options = '0';

                            if(accountCompanys.length == 0)
                            {
                                options += '<option value="' + "" + '" >' + "None" + '</option>';
                            }

                            for (const datos of accountCompanys) {
                                options += '<option value="' + datos.idCompany + '" >' + datos.company_name + '</option>';
                            }

                            $('#company_id').html(options);

                            if(accountCompanys.length == 1)
                            {
                                let miID = accountCompanys[0]; 
                                //console.log(miID);
                                $('#company_id').val(miID.idCompany).trigger("change");
                            }


                        });
                }

            }

            function update_address_edit() {
                var _url = $("#_url").val();
                var cid = $('#cid').val();

                if (cid != '') {

                    $.post(_url + 'contacts/json-single-contact-v1/', {
                        cid: cid

                    })
                        .done(function (data) {
                            var adrs = $("#address");

                            adrs.html(data.address_full);

                            if (document.getElementById('business_number')) {
                                $('#business_number').val(data.business_number);
                            }

                            accountCompanys = data.list_of_companies || [];

                            let options = '0';

                            if(accountCompanys.length == 0)
                            {
                                options += '<option value="' + "" + '" >' + "None" + '</option>';
                            }

                            for (const datos of accountCompanys) {
                                options += '<option value="' + datos.idCompany + '" >' + datos.company_name + '</option>';
                            }

                            $('#company_id').html(options);


                            let getCompanyId = $('#getCompanyId').val();

                            if(!isEmpty(getCompanyId)){
                                $('#company_id').val(getCompanyId);
                                $('#company_id').val(getCompanyId).trigger("change");
                            }


                        });
                }

            }

            update_address_edit();

            $('#cid').select2({

                language: {
                    noResults: function () {
                        return $("#_lan_no_results_found").val();
                    }
                }
            })
                .on("change", function (e) {
                    // mostly used event, fired to the original element when the value changes
                    // log("change val=" + e.val);
                    //  alert(e.val);

                    update_address();

                    //console.log(e.val);
                });

             
            $('#company_id').select2({

                language: {
                    noResults: function () {
                        return $("#_lan_no_results_found").val();
                    }
                }
            });

            {if $config['tax_system'] eq 'India'}

            var $place_to_supply = $("#place_of_supply");

            $place_to_supply.select2({

                language: {
                    noResults: function () {
                        return $("#_lan_no_results_found").val();
                    }
                }
            })
                .on("change", function (e) {

                });
            {/if}


            item_remove.on('click', function () {
                $("#invoice_items tr.info").fadeOut(300, function () {
                    $(this).remove();

                });

            });

            var $modal = $('#cloudonex_body');


            $('#item-add').on('click', function () {





                $.fancybox.open({
                    src  : base_url + 'ps/modal-list/',
                    type : 'ajax',
                    opts : {
                        afterShow : function( instance, current ) {
                            $('#modal_items_table').dataTable(
                                {
                                    responsive: true,
                                    "language": {
                                        "emptyTable": "{$_L['No items to display']}",
                                        "info":      "{$_L['Showing _START_ to _END_ of _TOTAL_ entries']}",
                                        "infoEmpty":      "{$_L['Showing 0 to 0 of 0 entries']}",
                                        buttons: {
                                            pageLength: '{$_L['Show all']}'
                                        },
                                        searchPlaceholder: "{__('Search')}"
                                    },
                                });
                        },
                        touch: false,
                        autoFocus: false,
                    }
                });




            });

            /*
             / @since v 2.0
             */

            $('#contact_add').on('click', function (e) {
                e.preventDefault();

                $.fancybox.open({
                    src  : _url + 'contacts/modal_add/',
                    type : 'ajax',
                    opts : {
                        afterShow : function( instance, current ) {
                            $("#country").select2({

                            });
                        }
                    }
                });


            });

            var rowNum = 0;

            let with_staff_selection = '';

            {if !empty($config['invoicing_allow_staff_selection_for_each_item'])}

            with_staff_selection = '<div class="mb-3"><select name="staff_id[]" class="form-select"><option value="0">{{__('Select Staff')}}</option>{foreach $staffs as $employee}<option value="{$employee->id}">{$employee->fullname}</option>{/foreach}</select></div>';

            {/if}

            $('#blank-add').on('click', function () {
                rowNum++;



                {if $config['tax_system'] == 'India'}

                    /*
                    $invoice_items.find('tbody')
                        .append(
                            '<tr>  <td> ' + with_staff_selection + '<textarea class="form-control item_name" name="desc[]" rows="3" id="i_' + rowNum + '"></textarea> <input type="hidden" name="item_code[]" value=""></td> <td><input type="text" class="form-control tax_code" value="" name="tax_code[]"></td>'  +
                            ' <td><input type="text" class="form-control qty" value="" name="qty[]"></td> <td><input type="text" class="form-control item_price" readonly name="amount[]" value=""></td> <td colspan="2"><input type="text" class="form-control item_discount" name="discount[]" value=""></td>  <td> <select class="form-select taxed" name="taxed[]" id="t_' + rowNum + '"> {foreach $t as $ts}  <option value="{$ts['rate']}" {if $ts['is_default'] eq '1'}selected{/if}>{$ts['name']}</option> {/foreach} </select></td> <td>\n' +
                            '                                            <input type="text" class="form-control cgst" disabled name="cgst[]" value="">\n' +
                            '                                        </td>\n' +
                            '                                        <td>\n' +
                            '                                            <input type="text" class="form-control sgst" disabled name="sgst[]" value="">\n' +
                            '                                        </td>\n' +
                            '                                        <td>\n' +
                            '                                            <input type="text" class="form-control igst" disabled name="igst[]" value="">\n' +
                            '                                        </td> <td class="ltotal"><input type="text" class="form-control lvtotal" readonly="" value=""></td>  </tr>'
                        );
                    */

                    let aplicarReadonly = "";

                    if(habilitar_precio_facturas == 1 || habilitar_precio_facturas == "1"){
                        aplicarReadonly = "readonly";
                    }

                    $invoice_items.find('tbody')
                        .append(
                            '<tr>' +
                            '  <td>' +
                            '    <label style="color: #666;">Name Product</label>' +
                            '    <textarea readonly class="form-control " name="nombre_producto[]" rows="3" id="ix_' + rowNum + '"></textarea>' +
                            '    <label style="color: #666; margin-top:20px;">Description Product</label>' +
                            '    <textarea class="form-control item_name" name="desc[]" rows="3" id="i_' + rowNum + '"></textarea>' +
                            '    <input type="hidden" name="item_code[]" value="">' +
                            '  </td>' +
                            '  <td><input type="text" class="form-control tax_code" value="" name="tax_code[]"></td>' +
                            '  <td><input type="text" class="form-control qty" value="" name="qty[]"></td>' +
                            '  <td><input type="text" class="form-control item_price" ' + aplicarReadonly + ' name="amount[]" value=""></td>' +

                            '  <td colspan="2"><input type="text" class="form-control item_discount" name="discount[]" value=""></td>' +
                            '  <td>' +
                            '    <select class="form-select taxed" name="taxed[]" id="t_' + rowNum + '">' +
                            '      {foreach $t as $ts} <option value="{$ts['rate']}" {if $ts['is_default'] eq '1'}selected{/if}>{$ts['name']}</option> {/foreach}' +
                            '    </select>' +
                            '  </td>' +
                            '  <td><input type="text" class="form-control cgst" disabled name="cgst[]" value=""></td>' +
                            '  <td><input type="text" class="form-control sgst" disabled name="sgst[]" value=""></td>' +
                            '  <td><input type="text" class="form-control igst" disabled name="igst[]" value=""></td>' +
                            '  <td class="ltotal"><input type="text" class="form-control lvtotal" readonly="" value=""></td>' +
                            '</tr>'
                        );


                {else}

                    /* $invoice_items.find('tbody')
                        .append(
                            '<tr>  <td>' + with_staff_selection + '<textarea class="form-control item_name" name="desc[]" rows="3" id="i_' + rowNum + '"></textarea> <input type="hidden" name="item_code[]" value=""> </td> <td><input type="text" class="form-control qty" value="" name="qty[]"></td> <td><input type="text" class="form-control item_price" readonly name="amount[]" value=""></td> <td colspan="2"><input type="text" class="form-control item_discount" name="discount[]" value=""></td>  <td> <select class="form-select taxed" name="taxed[]" id="t_' + rowNum + '"> {foreach $t as $ts}  <option value="{$ts['rate']}" {if $ts['is_default'] eq '1'}selected{/if}>{$ts['name']}</option> {/foreach} </select></td> <td class="ltotal"><input type="text" class="form-control lvtotal" readonly="" value=""></td>  </tr>'
                        );
                    */

                    let aplicarReadonly = "";

                    if(habilitar_precio_facturas == 1 || habilitar_precio_facturas == "1"){
                        aplicarReadonly = "readonly";
                    }

                    $invoice_items.find('tbody')
                    .append(
                        '<tr>' +
                        '  <td>' + with_staff_selection +
                        '    <label style="color: #666;">Name Product</label>' +
                        '    <textarea readonly class="form-control " name="nombre_producto[]" rows="3" id="ix_' + rowNum + '"></textarea>' +
                        '    <label style="color: #666; margin-top:20px;">Description Product</label>' +
                        '    <textarea class="form-control item_name" name="desc[]" rows="3" id="i_' + rowNum + '"></textarea>' +
                        '    <input type="hidden" name="item_code[]" value="">' +
                        '  </td>' +
                        '  <td>' +
                        '    <input type="text" class="form-control qty" value="" name="qty[]">' +
                        '  </td>' +
                        '  <td>' +
                        //'    <input type="text" class="form-control item_price" readonly name="amount[]" value="">' +
                        '    <input type="text" class="form-control item_price" ' + aplicarReadonly +  ' name="amount[]" value="">' +
                        '  </td>' +
                        '  <td colspan="2">' +
                        '    <input type="text" class="form-control item_discount" name="discount[]" value="">' +
                        '  </td>' +
                        '  <td>' +
                        '    <select class="form-select taxed" name="taxed[]" id="t_' + rowNum + '">' +
                        '      {foreach $t as $ts}' +
                        '        <option value="{$ts.rate}" {if $ts.is_default eq 1}selected{/if}>{$ts.name}</option>' +
                        '      {/foreach}' +
                        '    </select>' +
                        '  </td>' +
                        '  <td class="ltotal">' +
                        '    <input type="text" class="form-control lvtotal" readonly="" value="">' +
                        '  </td>' +
                        '</tr>'
                    );


                {/if}



                spEditor('#i_' + rowNum);
                //spEditor('#ix_' + rowNum);


                spMultiSelect('#t_' + rowNum);

                //   calculateTotal();


            });

            $invoice_items.on('click', '.redactor-editor', function () {
                $("tr").removeClass("info");
                $(this).closest('tr').addClass("info");

                item_remove.show();
            });

            $modal.on('click', '.update', function () {
                var tableControl = document.getElementById('items_table');

                $.fancybox.close();


                $('input:checkbox:checked', tableControl).each(function () {
                    rowNum++;
                    var item_code = $(this).closest('tr').find('td:eq(1)').text();
                    var item_name = $(this).closest('tr').find('td:eq(2)').text();

                    //console.log(item_code);
                    //console.log(item_name);

                    let isReadonly = "";

                    if(habilitar_precio_facturas == 1 || habilitar_precio_facturas == "1"){
                        
                    }else{
                        if(item_code != 17)
                        {
                            isReadonly = "readonly";
                        } 
                    }
                     
                    var item_price = $(this).closest('tr').find('td:eq(3)').text();
                    let tax_code = $(this).closest('tr').find('td:eq(4)').text();
                    let item_descripcion = $(this).closest('tr').find('td:eq(5)').text();

                    {if $config['tax_system'] == 'India'}

                        /*
                        $invoice_items.find('tbody')
                            .append(
                                '<tr>  <td>' + with_staff_selection + '<textarea class="form-control item_name" name="desc[]" rows="3" id="i_' + rowNum + '">' + item_name + '</textarea> <input type="hidden" name="item_code[]" value="' + item_code + '"> </td> <td><input type="text" class="form-control tax_code" value="' + tax_code + '" name="tax_code[]"></td>'  +
                                ' <td><input type="text" class="form-control qty" value="1" name="qty[]"></td> <td><input type="text" class="form-control item_price" readonly name="amount[]" value="' + item_price + '"></td> <td colspan="2"><input type="text" class="form-control item_discount" value="0.00" name="discount[]"></td>  <td> <select class="form-select taxed" name="taxed[]" id="t_' + rowNum + '"> {foreach $t as $ts}  <option value="{$ts['rate']}" {if $ts['is_default'] eq '1'}selected{/if}>{$ts['name']}</option> {/foreach} </select></td> <td>\n' +
                                '                                            <input type="text" class="form-control cgst" disabled name="cgst[]" value="">\n' +
                                '                                        </td>\n' +
                                '                                        <td>\n' +
                                '                                            <input type="text" class="form-control sgst" disabled name="sgst[]" value="">\n' +
                                '                                        </td>\n' +
                                '                                        <td>\n' +
                                '                                            <input type="text" class="form-control igst" disabled name="igst[]" value="">\n' +
                                '                                        </td> <td class="ltotal"><input type="text" class="form-control lvtotal" readonly="" value=""></td>  </tr>'
                            );
                        */

                         

                        $invoice_items.find('tbody').append(
                            '<tr>' +
                            '  <td>' + with_staff_selection +
                            '    <label style="color: #666;">Name Product</label>' +
                            '    <textarea readonly class="form-control " name="nombre_producto[]" rows="3" id="ix_' + rowNum + '">' + item_name + '</textarea>' +
                            '    <label style="color: #666; margin-top:20px;">Description Product</label>' +
                            '    <textarea class="form-control item_name" name="desc[]" rows="3" id="i_' + rowNum + '">' + item_descripcion + '</textarea>' +
                            '    <input type="hidden" name="item_code[]" value="' + item_code + '">' +
                            '  </td>' +
                            '  <td>' +
                            '    <input type="text" class="form-control tax_code" value="' + tax_code + '" name="tax_code[]">' +
                            '  </td>' +
                            '  <td>' +
                            '    <input type="text" class="form-control qty" value="1" name="qty[]">' +
                            '  </td>' +
                            '  <td>' +
                            '    <input type="text" class="form-control item_price" '+isReadonly+' name="amount[]" value="' + item_price + '">' +
                            '  </td>' +
                            '  <td colspan="2">' +
                            '    <input type="text" class="form-control item_discount" value="0.00" name="discount[]">' +
                            '  </td>' +
                            '  <td>' +
                            '    <select class="form-select taxed" name="taxed[]" id="t_' + rowNum + '">' +
                            '      {foreach $t as $ts}' +
                            '        <option value="{$ts.rate}" {if $ts.is_default eq 1}selected{/if}>{$ts.name}</option>' +
                            '      {/foreach}' +
                            '    </select>' +
                            '  </td>' +
                            '  <td>' +
                            '    <input type="text" class="form-control cgst" disabled name="cgst[]" value="">' +
                            '  </td>' +
                            '  <td>' +
                            '    <input type="text" class="form-control sgst" disabled name="sgst[]" value="">' +
                            '  </td>' +
                            '  <td>' +
                            '    <input type="text" class="form-control igst" disabled name="igst[]" value="">' +
                            '  </td>' +
                            '  <td class="ltotal">' +
                            '    <input type="text" class="form-control lvtotal" readonly="" value="">' +
                            '  </td>' +
                            '</tr>'
                        );


                    {else}
                        /*
                        $invoice_items.find('tbody')
                        .append(
                            '<tr>  <td>' + with_staff_selection + '<textarea class="form-control item_name" name="desc[]" rows="3" id="i_' + rowNum + '">' + item_name + '</textarea> <input type="hidden" name="item_code[]" value="' + item_code + '"></td> <td><input type="text" class="form-control qty" value="1" name="qty[]"></td> <td><input type="text" class="form-control item_price" readonly name="amount[]" value="' + item_price + '"></td> <td colspan="2"><input type="text" class="form-control item_discount" name="discount[]" value=""></td>  <td> <select class="form-select taxed" name="taxed[]" id="t_' + rowNum + '"> {foreach $t as $ts}  <option value="{$ts['rate']}" {if $ts['is_default'] eq '1'}selected{/if}>{$ts['name']}</option> {/foreach} </select></td> <td class="ltotal"><input type="text" class="form-control lvtotal" readonly="" value=""></td>  </tr>'
                        );
                        */

                        $invoice_items.find('tbody').append(
                        '<tr>' +
                        '  <td>' + with_staff_selection +
                        '    <label style="color: #666;">Name Product</label>' +
                        '    <textarea readonly class="form-control " name="nombre_producto[]" rows="3" id="ix_' + rowNum + '">' + item_name + '</textarea>' +
                        '    <label style="color: #666; margin-top:20px;">Description Product</label>' +
                        '    <textarea class="form-control item_name" name="desc[]" rows="3" id="i_' + rowNum + '">' + item_descripcion + '</textarea>' +
                        '    <input type="hidden" name="item_code[]" value="' + item_code + '">' +
                        '  </td>' +
                        '  <td>' +
                        '    <input type="text" class="form-control qty" value="1" name="qty[]">' +
                        '  </td>' +
                        '  <td>' +
                        '    <input type="text" class="form-control item_price" '+isReadonly+' name="amount[]" value="' + item_price + '">' +
                        '  </td>' +
                        '  <td colspan="2">' +
                        '    <input type="text" class="form-control item_discount" name="discount[]" value="">' +
                        '  </td>' +
                        '  <td>' +
                        '    <select class="form-select taxed" name="taxed[]" id="t_' + rowNum + '">' +
                        '      {foreach $t as $ts}' +
                        '        <option value="{$ts.rate}" {if $ts.is_default eq 1}selected{/if}>{$ts.name}</option>' +
                        '      {/foreach}' +
                        '    </select>' +
                        '  </td>' +
                        '  <td class="ltotal">' +
                        '    <input type="text" class="form-control lvtotal" readonly="" value="">' +
                        '  </td>' +
                        '</tr>'
                    );


                    {/if}



                    spEditor('#i_' + rowNum);
                    //spEditor('#ix_' + rowNum);

                    spMultiSelect('#t_' + rowNum);

                    calculateTotal();

                });


                $modal.modal('hide');

            });


            $modal.on('click', '.contact_submit', function (e) {
                e.preventDefault();
                //  var tableControl= document.getElementById('items_table');


                var _url = $("#_url").val();
                $.post(_url + 'contacts/add-post/', {


                    account: $('#account').val(),
                    company: $('#company').val(),
                    address: $('#m_address').val(),


                    city: $('#city').val(),
                    state: $('#state').val(),
                    zip: $('#zip').val(),
                    country: $('#country').val(),
                    phone: $('#phone').val(),
                    email: $('#email').val()

                })
                    .done(function (data) {

                        var _url = $("#_url").val();
                        if ($.isNumeric(data)) {

                            // location.reload();
                            var is_recurring = $('#is_recurring').val();
                            if (is_recurring == 'yes') {
                                window.location = _url + 'invoices/add/recurring/' + data + '/';
                            }
                            else {
                                window.location = _url + 'invoices/add/1/' + data + '/';
                            }

                        }
                        else {


                            $modal
                                .modal('loading')
                                .find('.modal-body')
                                .prepend('<div class="alert alert-danger fade in">' + data +
                                    '<button type="button" class="close btn btn-danger" data-dismiss="alert">&times;</button>' +
                                    '</div>');
                            //  $("#cid").select2('data', { id: newID, text: newText });
                        }
                    });


            });


            // $("#add_discount").click(function (e) {
            //     e.preventDefault();
            //     var s_discount_amount = $('#discount_amount');
            //     var c_discount = s_discount_amount.val();
            //     var c_discount_type = $('#discount_type').val();
            //     var p_checked = "";
            //     var f_checked = "";
            //     if (c_discount_type == "p") {
            //         p_checked = 'checked="checked"';
            //     } else {
            //         f_checked = 'checked="checked"';
            //     }
            //     bootbox.dialog({
            //             title: $("#_lan_set_discount").val(),
            //             message: '<div class="row">  ' +
            //                 '<div class="col-md-12"> ' +
            //                 '<form class="form-horizontal" action="javascript:void(0);"> ' +
            //                 '<div class="mb-3"> ' +
            //                 '<label class="col-md-4 control-label" for="set_discount">' + $("#_lan_discount").val() + '</label> ' +
            //                 '<div class="col-md-4"> ' +
            //                 '<input id="set_discount" name="set_discount" type="text" class="form-control input-md" value="' + c_discount + '"> ' +
            //                 '</div> ' +
            //                 '</div> ' +
            //                 '<div class="mb-3"> ' +
            //                 '<label class="col-md-4 control-label" for="set_discount_type">' + $("#_lan_discount_type").val() + '</label> ' +
            //                 '<div class="col-md-4"> <div class="radio"> <label for="set_discount_type-0"> ' +
            //                 '<input type="radio" name="set_discount_type" id="set_discount_type-0" value="p" ' + p_checked + '> ' +
            //                 '' + $("#_lan_percentage").val() + ' (%) </label> ' +
            //                 '</div><div class="radio"> <label for="set_discount_type-1"> ' +
            //                 '<input type="radio" name="set_discount_type" id="set_discount_type-1" value="f" ' + f_checked + '> ' + $("#_lan_fixed_amount").val() + ' </label> ' +
            //                 '</div> ' +
            //                 '</div> </div>' +
            //                 '</form> </div>  </div>',
            //             buttons: {
            //                 success: {
            //                     label: $("#_lan_btn_save").val(),
            //                     className: "btn-success",
            //                     callback: function () {
            //                         var discount_amount = $('#set_discount').val();
            //                         var discount_type = $("input[name='set_discount_type']:checked").val();
            //                         $('#discount_amount').val(discount_amount);
            //                         $('#discount_type').val(discount_type);
            //                         calculateTotal();
            //                         //updateTax();
            //                         //updateTotal();
            //                     }
            //                 }
            //             }
            //         }
            //     );
            // });


            $(".progress").hide();
            $("#emsg").hide();
            $("#submit").click(function (e) {
                e.preventDefault();

                //console.log( $('#invform').serialize());
                //return; 

                $('#ibox_form').block({ message: "Please wait while the process is completed",
                    css: {
                        color: '#ffffff',        
                        border: 'none',         
                        padding: '10px',          
                        borderRadius: '5px',     
                        fontSize: '16px'          
                    } 
                });

                var _url = $("#_url").val();

                $.post(_url + 'invoices/add-post/', $('#invform').serialize(), function (data) {

                    //console.log(data);
                    //console.log("return aqui abajo");
                    //return;

                    var _url = $("#_url").val();
                    if ($.isNumeric(data)) {

                        window.location = _url + 'invoices/edit/' + data + '/';
                    }
                    else {
                        $('#ibox_form').unblock();
                        var body = $("html, body");
                        body.animate({ scrollTop: 0 }, '1000', 'swing');
                        $("#emsgbody").html(data);
                        $("#emsg").show("slow");
                    }
                });
            });

             $(".enviarObservaciones").click(function (e) {
                e.preventDefault();
                //aaaaaaaa
    
                let informacion = {
                    usuario_id: $(".tener_user_id").val(),
                    invoices_id: $(".tener_invoice_id").val(),
                    observaciones: $(".tener_obsevaciones_invoices").val(),
                    estado_id:  $(".tener_estado_invoices").val()
                };

                const jsonString = JSON.stringify(informacion);

                $('#ibox_form_observaciones').block({ message: "Please wait while the process is completed",
                    css: {
                        color: '#ffffff',        
                        border: 'none',         
                        padding: '10px',          
                        borderRadius: '5px',     
                        fontSize: '16px'          
                    } 
                });

                /* console.log(jsonString);
                return;  */
                 
                var _url = $("#_url").val();
                $.post(_url + 'invoices/add-invoice-approbal-history/', jsonString, function (data) {

                    $('#ibox_form_observaciones').unblock();

                    /* console.log(data);
                    return; */

                     try {
                        const info = JSON.parse(data);
                       
                        if( info.type == "success")
                        {
                            toastr.success(info.message);

                            window.location = info.redirect;
                            
                            $(".tener_obsevaciones_invoices").val("");
                            $(".tener_estado_invoices").val("1");
                                         
                        }else{
                            var body = $("html, body");
                            body.animate({ scrollTop:0 }, '1000', 'swing');
                            $("#emsgbody_observaciones").html(info.message);
                            $("#emsg_observaciones").show("slow");
                        }
                    } catch (error) {
                        var body = $("html, body");
                        body.animate({ scrollTop:0 }, '1000', 'swing');
                        $("#emsgbody_observaciones").html(data);
                        $("#emsg_observaciones").show("slow");
                    }
                    
                });
            });


            $("#save_n_close").click(function (e) {
                e.preventDefault();
                $('#ibox_form').block({ message: "Please wait while the process is completed",
                    css: {
                        color: '#ffffff',        
                        border: 'none',         
                        padding: '10px',          
                        borderRadius: '5px',     
                        fontSize: '16px'          
                    } 
                });
                var _url = $("#_url").val();
                $.post(_url + 'invoices/add-post/', $('#invform').serialize(), function (data) {

                    var _url = $("#_url").val();
                    if ($.isNumeric(data)) {

                        window.location = _url + 'invoices/view/' + data + '/';
                    }
                    else {
                        $('#ibox_form').unblock();
                        var body = $("html, body");
                        body.animate({ scrollTop: 0 }, '1000', 'swing');
                        $("#emsgbody").html(data);
                        $("#emsg").show("slow");
                    }
                });
            });


            {if $pos eq 'pos'}

            function loadItems() {

                $block_items.html(block_msg);

                var item_name;

                $.getJSON(base_url + "items/all/", function (data) {
                    var items = "";
                    var b_p;

                    //console.log(data);
                    $.each(data, function (key, val) {

                        item_name = val.name;

                        item_name = item_name.trunc(12);

                        var image;

                        if(val.image == '') {
                            image = '{$app_url}ui/lib/img/item_placeholder.png';
                        }
                        else{
                            image = '{$app_url}storage/items/thumb'+ val.image;
                        }


                        //b_p = '<div class="col-lg-2 col-md-2 col-sm-3 col-xs-4"><div class="pos_item text-center" id="pos_item_'+ val.id +'" data-pos-item-name="'+val.name+'" data-pos-item-price="'+val.sales_price+'" data-pos-tax-code="'+val.tax_code+'" data-id="'+ val.id +'" data-pos-item-number="'+ val.item_number +'"><img src="'+ image +'" alt="'+ item_name +'" class="img-circle"><hr>'+ item_name +' <br>'+ val.sales_price +'  <hr></div> </div>';
                        b_p = '<div class="col-lg-2 col-md-2 col-sm-3 col-xs-4">' +
                                '<div class="pos_item text-center" id="pos_item_' + val.id + '" ' +
                                'data-pos-item-name="' + val.name + '" ' +
                                'data-pos-item-descripcion="' + val.descripcion + '" ' +
                                'data-pos-item-price="' + val.sales_price + '" ' +
                                'data-pos-tax-code="' + val.tax_code + '" ' +
                                'data-id="' + val.id + '" ' +
                                'data-pos-item-number="' + val.item_number + '">' +
                                '<img src="' + image + '" alt="' + item_name + '" class="img-circle"><hr>' +
                                item_name + '<br>' +
                                val.sales_price + '<hr>' +
                                '</div>' +
                                '</div>';

                        items = items + b_p;
                    });

                    $block_items.html(items);

                    $('#ib_search_input').hideseek({
                        highlight: true
                    });

                });

            }

            loadItems();

            var pos_item_name, pos_item_price, pos_item_id, pos_item_number, pos_tax_code, pos_descripcion ;

            var item_sl = 5000;

            $block_items.on('click', '.pos_item', function () {

                pos_item_number = $(this).data('pos-item-number');
                pos_item_name = $(this).data('pos-item-name');
                pos_item_price = $(this).data('pos-item-price');
                pos_item_id = $(this).data('id');
                pos_tax_code = ($(this).data('pos-tax-code')) ?? '';
                pos_descripcion = ($(this).data('pos-item-descripcion')) ?? '';

                console.log(pos_item_number);
                console.log(pos_item_name);

                let item_code = parseInt(pos_item_number, 10);

                let isReadonly = "";
                
                if(habilitar_precio_facturas == 1 || habilitar_precio_facturas == "1"){
                    
                }else{
                    if(item_code != 17)
                    {
                        isReadonly = "readonly";
                    } 
                }
 
                {if $config['tax_system'] == 'India'}

                    /*
                    $invoice_items.find('tbody')
                        .prepend(
                            '<tr>  <td>' + with_staff_selection + '<textarea class="form-control item_name" name="desc[]" rows="3" id="i_' + item_sl + '">' + pos_item_name + '</textarea> <input type="hidden" name="item_code[]" value="' + pos_item_number + '"> </td> <td><input type="text" class="form-control tax_code" value="' + pos_tax_code + '" name="tax_code[]"></td>'  +
                            ' <td><input type="text" class="form-control qty" value="1" name="qty[]"></td> <td><input type="text" class="form-control item_price" readonly name="amount[]" value="' + pos_item_price + '"></td> <td colspan="2"><input type="text" class="form-control item_discount" value="0.00" name="discount[]"></td>  <td> <select class="form-select taxed" name="taxed[]" id="t_' + item_sl + '"> {foreach $t as $ts}  <option value="{$ts['rate']}" {if $ts['is_default'] eq '1'}selected{/if}>{$ts['name']}</option> {/foreach} </select></td> <td>\n' +
                            '                                            <input type="text" class="form-control cgst" disabled name="cgst[]" value="">\n' +
                            '                                        </td>\n' +
                            '                                        <td>\n' +
                            '                                            <input type="text" class="form-control sgst" disabled name="sgst[]" value="">\n' +
                            '                                        </td>\n' +
                            '                                        <td>\n' +
                            '                                            <input type="text" class="form-control igst" disabled name="igst[]" value="">\n' +
                            '                                        </td> <td class="ltotal"><input type="text" class="form-control lvtotal" readonly="" value=""></td>  </tr>'
                        );
                    */

                    $invoice_items.find('tbody').prepend(
                    '<tr>' +
                    '  <td>' + with_staff_selection +
                    '    <label style="color: #666;">Name Product</label>' +
                    '    <textarea readonly class="form-control " name="nombre_producto[]" rows="3" id="ix_' + rowNum + '">' + pos_descripcion + '</textarea>' +
                    '    <label style="color: #666; margin-top:20px;">Description Product</label>' +
                    '    <textarea class="form-control item_name" name="desc[]" rows="3" id="i_' + item_sl + '">' + pos_item_name + '</textarea>' +
                    '    <input type="hidden" name="item_code[]" value="' + pos_item_number + '">' +
                    '  </td>' +
                    '  <td>' +
                    '    <input type="text" class="form-control tax_code" value="' + pos_tax_code + '" name="tax_code[]">' +
                    '  </td>' +
                    '  <td>' +
                    '    <input type="text" class="form-control qty" value="1" name="qty[]">' +
                    '  </td>' +
                    '  <td>' +
                    '    <input type="text" class="form-control item_price" '+isReadonly+' name="amount[]" value="' + pos_item_price + '">' +
                    '  </td>' +
                    '  <td colspan="2">' +
                    '    <input type="text" class="form-control item_discount" value="0.00" name="discount[]">' +
                    '  </td>' +
                    '  <td>' +
                    '    <select class="form-select taxed" name="taxed[]" id="t_' + item_sl + '">' +
                    '      {foreach $t as $ts}' +
                    '        <option value="{$ts.rate}" {if $ts.is_default eq '1'}selected{/if}>{$ts.name}</option>' +
                    '      {/foreach}' +
                    '    </select>' +
                    '  </td>' +
                    '  <td>' +
                    '    <input type="text" class="form-control cgst" disabled name="cgst[]" value="">' +
                    '  </td>' +
                    '  <td>' +
                    '    <input type="text" class="form-control sgst" disabled name="sgst[]" value="">' +
                    '  </td>' +
                    '  <td>' +
                    '    <input type="text" class="form-control igst" disabled name="igst[]" value="">' +
                    '  </td>' +
                    '  <td class="ltotal">' +
                    '    <input type="text" class="form-control lvtotal" readonly="" value="">' +
                    '  </td>' +
                    '</tr>'
                );


                {else}

                    /*
                        $invoice_items.find('tbody')
                        .prepend(
                            '<tr>  <td>' + with_staff_selection + '<textarea class="form-control item_name" name="desc[]" rows="3" id="i_' + item_sl + '">' + pos_item_name + '</textarea> <input type="hidden" name="item_code[]" value="' + pos_item_number + '"></td> <td><input type="text" class="form-control qty" value="1" name="qty[]"></td> <td><input type="text" class="form-control item_price" readonly name="amount[]" value="' + pos_item_price + '"></td> <td colspan="2"><input type="text" class="form-control item_discount" name="discount[]" value=""></td>  <td> <select class="form-select taxed" name="taxed[]" id="t_' + item_sl + '"> {foreach $t as $ts}  <option value="{$ts['rate']}" {if $ts['is_default'] eq '1'}selected{/if}>{$ts['name']}</option> {/foreach} </select></td> <td class="ltotal"><input type="text" class="form-control lvtotal" readonly="" value=""></td>  </tr>'
                        );
                    */

                    $invoice_items.find('tbody').prepend(
                        '<tr>' +
                        '  <td>' + with_staff_selection +
                        '    <label style="color: #666;">Name Product</label>' +
                        '    <textarea readonly class="form-control " name="nombre_producto[]" rows="3" id="ix_' + rowNum + '">' + pos_item_name + '</textarea>' +
                        '    <label style="color: #666; margin-top:20px;">Description Product</label>' +
                        '    <textarea class="form-control item_name" name="desc[]" rows="3" id="i_' + item_sl + '">' + pos_descripcion + '</textarea>' +
                        '    <input type="hidden" name="item_code[]" value="' + pos_item_number + '">' +
                        '  </td>' +
                        '  <td>' +
                        '    <input type="text" class="form-control qty" value="1" name="qty[]">' +
                        '  </td>' +
                        '  <td>' +
                        '    <input type="text" class="form-control item_price" '+isReadonly+' name="amount[]" value="' + pos_item_price + '">' +
                        '  </td>' +
                        '  <td colspan="2">' +
                        '    <input type="text" class="form-control item_discount" name="discount[]" value="">' +
                        '  </td>' +
                        '  <td>' +
                        '    <select class="form-select taxed" name="taxed[]" id="t_' + item_sl + '">' +
                        '      {foreach $t as $ts}' +
                        '        <option value="{$ts.rate}" {if $ts.is_default eq '1'}selected{/if}>{$ts.name}</option>' +
                        '      {/foreach}' +
                        '    </select>' +
                        '  </td>' +
                        '  <td class="ltotal">' +
                        '    <input type="text" class="form-control lvtotal" readonly="" value="">' +
                        '  </td>' +
                        '</tr>'
                    );


                {/if}



                spEditor('#i_' + item_sl);
                //spEditor('#ix_' + item_sl);


                spMultiSelect('#t_' + rowNum);

                calculateTotal();

                item_sl = item_sl + 1;


            });



            {/if}


            {if !empty($config['invoice_single_service'])}

            const service_id = document.getElementById('service_id');

            service_id.addEventListener('change', () => {

                console.log("que onda aqui encontramos el evento");

                let item_sl = 15000;

                let price = service_id.options[service_id.selectedIndex].getAttribute('data-price');
                let name = service_id.options[service_id.selectedIndex].text;

                let aplicarReadonly = "";

                if(habilitar_precio_facturas == 1 || habilitar_precio_facturas == "1"){
                    aplicarReadonly = "readonly";
                }


                //$invoice_items.find('tbody')
                //    .prepend(
                //        '<tr>  <td>' + with_staff_selection + '<textarea class="form-control item_name" name="desc[]" rows="3" id="i_' + item_sl + '">' + name + '</textarea> <input type="hidden" name="item_code[]" value=""></td> <td><input type="text" class="form-control qty" value="1" name="qty[]"></td> <td><input type="text" class="form-control item_price" readonly name="amount[]" value="' + price + '"></td> <td colspan="2"><input type="text" class="form-control item_discount" name="discount[]" value=""></td>  <td> <select class="form-select taxed" name="taxed[]" id="t_' + item_sl + '"> {foreach $t as $ts}  <option value="{$ts['rate']}" {if $ts['is_default'] eq '1'}selected{/if}>{$ts['name']}</option> {/foreach} </select></td> <td class="ltotal"><input type="text" class="form-control lvtotal" readonly="" value=""></td>  </tr>'
                //    );
                
                $invoice_items.find('tbody')
                .prepend(
                    '<tr>' +
                    '  <td>' +
                    with_staff_selection +
                    '<textarea class="form-control item_name" name="desc[]" rows="3" id="i_' + item_sl + '">' + name + '</textarea>' +
                    ' <input type="hidden" name="item_code[]" value="">' +
                    '</td>' +
                    ' <td><input type="text" class="form-control qty" value="1" name="qty[]"></td>' +
                    ' <td><input type="text" class="form-control item_price" ' + aplicarReadonly + ' name="amount[]" value="' + price + '"></td>' +
                    ' <td colspan="2"><input type="text" class="form-control item_discount" name="discount[]" value=""></td>' +
                    ' <td>' +
                    ' <select class="form-select taxed" name="taxed[]" id="t_' + item_sl + '">' +
                    ' {foreach $t as $ts} <option value="{$ts['rate']}" {if $ts['is_default'] eq '1'}selected{/if}>{$ts['name']}</option> {/foreach}' +
                    ' </select></td>' +
                    ' <td class="ltotal"><input type="text" class="form-control lvtotal" readonly="" value=""></td>' +
                    '</tr>'
                );

                spEditor('#i_' + item_sl);

                spMultiSelect('#t_' + rowNum);

                calculateTotal();

                item_sl = item_sl + 1;
            });

            {/if}


            $('#refiere_staff_id').change(function() {
                valorSeleccionado = $(this).val();
                textoSeleccionado = $('#refiere_staff_id option:selected').text();

                // Actualizar los elementos en la página
                //$('#valor-seleccionado').text(valorSeleccionado || 'Ninguno');
                //$('#texto-seleccionado').text(textoSeleccionado || 'Ninguno');

                var staffs = {$staffs|@json_encode nofilter};

                var staffsData = Object.values(staffs);

                //console.log(staffsData);

                if(valorSeleccionado != "NULL")
                {
                    if(valorSeleccionado == "0")
                    {
                        $(".habilitar_otros_nombre_referencia").css("display", "");
                        $("#refiere_staff_nombre").val("");
                    }else{
                        $(".habilitar_otros_nombre_referencia").css("display", "none");
                        
                        if(Array.isArray(staffsData))
                        {
                           let tener_nombre = staffsData.find((staff) => staff.id == valorSeleccionado);

                            if(tener_nombre)
                            {
                                $("#refiere_staff_nombre").val(tener_nombre.fullname);
                            }
                        }
 
                    }
                }else{
                    $("#refiere_staff_nombre").val("");
                    $(".habilitar_otros_nombre_referencia").css("display", "none");
                }
 
                // También puedes usar los valores para otras acciones
                console.log('Valor seleccionado:', valorSeleccionado);
                //console.log('Texto seleccionado:', textoSeleccionado);
            });

 
            $('#recommended_type_id').change(function() {
                let miValorSeleccionado = $(this).val();
                //textoSeleccionado = $('#refiere_staff_id option:selected').text();

                // Actualizar los elementos en la página
                //$('#valor-seleccionado').text(valorSeleccionado || 'Ninguno');
                //$('#texto-seleccionado').text(textoSeleccionado || 'Ninguno');
 
                //console.log(staffsData);

                $(".showByStaff").css("display", "none");
                $(".showByClients").css("display", "none");

                $(".habilitar_otros_nombre_referencia").css("display", "none");
                $(".habilitar_otros_nombre_referencia_clientes").css("display", "none");
                $(".habilitar_otros_nombre_referencia_otros").css("display", "none");

                $(".changesColumnsRecommendedType").removeClass("col-sm-4");  
                $(".changesColumnsRecommendedType").removeClass("col-sm-8"); 
                
                $("#refiere_clients_id").val("NULL").trigger("change"); 
                $("#refiere_staff_nombre").val(""); 
                $("#refiere_staff_id").val("NULL"); 
                $("#refiere_otros_nombre").val(""); 
                $("#refiere_clients_nombre").val(""); 
  
                if(miValorSeleccionado == "None")
                {
                    $(".changesColumnsRecommendedType").addClass("col-sm-8");  
                } 


                if(miValorSeleccionado == "By Staff")
                {
                    $(".showByStaff").css("display", "");
                    $(".changesColumnsRecommendedType").addClass("col-sm-4");  
                }

                if(miValorSeleccionado == "By clients")
                {
                    $(".showByClients").css("display", "");
                    $(".changesColumnsRecommendedType").addClass("col-sm-4");  
                }

                // Si no es staff ni clientes es otros
                if(miValorSeleccionado == "Other")
                {
                    $(".habilitar_otros_nombre_referencia_otros").css("display", "");
                    $(".changesColumnsRecommendedType").addClass("col-sm-8");  
                }
 
                // También puedes usar los valores para otras acciones
                console.log('Valor seleccionado:', miValorSeleccionado);
                //console.log('Texto seleccionado:', textoSeleccionado);
            });


            $('#refiere_clients_id').change(function() {
                valorSeleccionado = $(this).val();
                textoSeleccionado = $('#refiere_clients_id option:selected').text();
 
                //console.log(staffsData);

                if(valorSeleccionado != "NULL")
                {
                    if(valorSeleccionado == "0")
                    {
                        $(".habilitar_otros_nombre_referencia_clientes").css("display", "");
                        $("#refiere_clients_nombre").val("");
                    }else{
                        $(".habilitar_otros_nombre_referencia_clientes").css("display", "none");
                        
                        if(Array.isArray(arrayCrmClientes))
                        {
                           let tener_nombre = arrayCrmClientes.find((data) => data.id == valorSeleccionado);

                            if(tener_nombre)
                            {
                                $("#refiere_clients_nombre").val(tener_nombre.account);
                            }
                        }
 
                    }
                }else{
                    $("#refiere_clients_nombre").val("");
                    $(".habilitar_otros_nombre_referencia_clientes").css("display", "none");
                }
 
                // También puedes usar los valores para otras acciones
                console.log('Valor seleccionado:', valorSeleccionado);
                //console.log('Texto seleccionado:', textoSeleccionado);
            });


        });
    </script>
{/block}
