{extends file="$layouts_admin"}

<style>
.strong_p p {
    margin: 0;
}
</style>

{block name="content"}
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

<input type="text" disabled hidden id="ws_nombre_socket" value="{$ws_nombre_socket}">

<input type="text" disabled hidden id="invoices_id" value="{$invoices_id}">
<input type="text" disabled hidden id="invoice_number" value="{$invoice_no}">
<input
        type="text"
        value="{$APP_URL_ORIGINAL_SOCKET}"
        disabled
        hidden
        id="APP_URL_ORIGINAL_SOCKET"
     />

<input
        type="text"
        value="{$DB_NAME}"
        disabled
        hidden
        id="DB_NAME"
      />

<input type="hidden" name="iid" value="{$d['id']}" id="iid">

<div class="row">

    <div class="col-lg-12">
        <div class="invoice-hero d-flex flex-wrap justify-content-between align-items-center p-3 mb-3">
            <div class="d-flex flex-column gap-1">
                <div class="hero-meta">
                    Sales / {$_L['Invoices']} / {$d['invoicenum']}{if $d['cn'] neq ''} {$d['cn']} {else} {$d['id']} {/if}
                </div>
                <div class="d-flex align-items-center gap-2 flex-wrap">
                    <h3 class="hero-title">
                        {if $d['type'] == 'Credit Note'}
                            {{__('Credit Note')}} {$d['invoicenum']}{if $d['cn'] neq ''} {$d['cn']} {else} {$d['id']} {/if}
                        {else}
                            {$_L['Invoice']} {$d['invoicenum']}{if $d['cn'] neq ''} {$d['cn']} {else} {$d['id']} {/if}
                        {/if}
                    </h3>
                    {if $d['status'] neq 'Paid' && $d['status'] neq 'Cancelled'}
                        <span class="badge-overdue">{$_L['Overdue']|default:'Overdue'}</span>
                    {/if}
                </div>
                <div class="hero-meta">
                    {$_L['Issued on']|default:'Issued on'} {date($config['df'], strtotime($d['date']))}
                </div>
            </div>

            <div class="hero-actions d-flex align-items-center gap-2">
                <a class="btn btn-light btn-icon border" href="{$_url}iview/print/{$d['id']}/token_{$d['vtoken']}" target="_blank" data-bs-toggle="tooltip" title="{$_L['Print']}">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="#000000" width="20" height="20" viewBox="0 0 24 24"><path d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z"/></svg>
                </a>
                <a class="btn btn-light btn-icon border" href="{$_url}client/ipdf/{$d['id']}/token_{$d['vtoken']}/dl/" data-bs-toggle="tooltip" title="{$_L['Download PDF']}">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none"><path d="M3 15C3 17.8284 3 19.2426 3.87868 20.1213C4.75736 21 6.17157 21 9 21H15C17.8284 21 19.2426 21 20.1213 20.1213C21 19.2426 21 17.8284 21 15" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M12 3V16M12 16L16 11.625M12 16L8 11.625" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>
                </a>
                <a class="btn btn-light btn-icon border" href="{$_url}client/ipdf/{$d['id']}/token_{$d['vtoken']}/view/" target="_blank" data-bs-toggle="tooltip" title="{$_L['View PDF']}">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none"><path d="M15.7955 15.8111L21 21M18 10.5C18 14.6421 14.6421 18 10.5 18C6.35786 18 3 14.6421 3 10.5C3 6.35786 6.35786 3 10.5 3C14.6421 3 18 6.35786 18 10.5Z" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>
                </a>

                <div class="dropdown">
                    <button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="fal fa-credit-card-front"></i> <span class="d-none d-md-inline">{$_L['Mark As']}</span>
                    </button>
                    <ul class="dropdown-menu">
                        {if $d['status'] neq 'Paid'}
                            <li class="dropdown-item set_invoice_status" data-status="Paid"><a href="javascript:;">{$_L['Paid']}</a></li>
                        {/if}
                        {if $d['status'] neq 'Unpaid'}
                            <li class="dropdown-item set_invoice_status" data-status="Unpaid"><a href="javascript:;">{$_L['Unpaid']}</a></li>
                        {/if}
                        {if $d['status'] neq 'Partially Paid'}
                            <li class="dropdown-item set_invoice_status set_invoice_status" data-status="Partially Paid"><a href="javascript:;">{$_L['Partially Paid']}</a></li>
                        {/if}
                        {if $d['status'] neq 'Cancelled'}
                            <li class="dropdown-item set_invoice_status" data-status="Cancelled"><a href="javascript:;">{$_L['Cancelled']}</a></li>
                        {/if}
                    </ul>
                </div>
                
            </div>
        </div>

        <div class="mb-3">
            <label for="exampleInputEmail1">{$_L['Unique Invoice URL']}:</label>
            <input type="text" class="form-control mb-3" id="invoice_public_url" onClick="this.setSelectionRange(0, this.value.length)" value="{$_url}client/iview/{$d['id']}/token_{$d['vtoken']}">
        </div>
    </div>

    <div id="invoice-view-app" v-cloak>
        <div class="text-center mb-3">

            <div class="btn-group" role="group" aria-label="Invoice actions group">
                
                {if $d['type'] == 'Credit Note'}

                    {if $config['accounting'] eq '1'}
                        <button type="button" class="btn btn-danger btn-sm" @click.prevent="addPayment"><span class="d-none d-md-inline">{{__('Refund')}}</span></button>
                    {/if}

                {else}

                    {if $config['accounting'] eq '1'}
                        {if $d['status'] == 'Unpaid' || $d['status'] == 'Partially Paid' }
                            <button type="button" class="btn btn-secondary btn-sm" @click.prevent="addPayment"><i class="fal fa-plus"></i> <span class="d-none d-md-inline">{$_L['Add Payment']}</span></button>
                        {/if}
                    {/if}
                
                {/if}

                <a href="{$_url}client/iview/{$d['id']}/token_{$d['vtoken']}" target="_blank" class="btn"><i class="fal fa-file-alt"></i> <span class="d-none d-md-inline">{$_L['Preview']}</span></a>

                {if $d['type'] == 'Invoice'}
                    <a href="{$_url}invoices/pos-receipt/{$d['id']}" target="_blank" class="btn"><i class="fal fa-file-alt"></i> <span class="d-none d-md-inline">{{__('Receipt')}}</span></a>
                {/if}
                <a href="{$_url}invoices/edit/{$d['id']}" class="btn"><i class="fal fa-pencil"></i> <span class="d-none d-md-inline">{$_L['Edit']}</span></a>
                <a data-bs-toggle="modal" href="#modal_add_item" class="btn">
                    <span data-bs-toggle="tooltip" data-placement="top" title="Add new document">
                        <i class="fal fa-paperclip"></i>
                    </span>
                </a>

            </div>


            {literal}
            <div v-show="openModal" class="modal fade" :class="{'show': openModal}" tabindex="-1" role="dialog" style="display:block; background: rgba(0,0,0,0.35);">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Add Payment</h5>
                            <button type="button" class="btn-close" aria-label="Close" @click="closeModal"></button>
                        </div>
                        <div class="modal-body">
                            <div v-if="formErrors.length" class="alert alert-danger mb-3">
                                <div v-for="err in formErrors" :key="err">{{ err }}</div>
                            </div>
                            <form @submit.prevent="submitPayment" class="d-flex flex-column gap-3 text-start">

                                <h3 class="m-0">Invoice Total: {{ invoiceTotal }} {{ currencyISOCode }}</h3>

                                <div>
                                    <label class="form-label">Account</label>
                                    <select class="form-select" v-model="form.account" required>
                                        <option value="">Select an account</option>
                                        <option v-for="acc in accounts" :key="acc.id" :value="acc.id">
                                            {{ acc.account }}
                                        </option>
                                    </select>
                                </div>

                                <div>
                                    <label class="form-label">Collected by</label>
                                    <select class="form-select" v-model="form.staff" required>
                                        <option value="">Select a staff</option>
                                        <option v-for="staff in staffs" :key="staff.id" :value="staff.id">
                                            {{ staff.fullname }}
                                        </option>
                                    </select>
                                </div>

                                <div>
                                    <label class="form-label">Date</label>
                                    <input type="date" class="form-control" v-model="form.date" required />
                                </div>

                                <div>
                                    <label class="form-label">Description</label>
                                    <input type="text" class="form-control" v-model="form.description" />
                                </div>

                                <div>
                                    <label class="form-label">Amount ({{ currencyISOCode }})</label>
                                    <input type="text" class="form-control" v-model="form.amount" required />
                                </div>

                                <div>
                                    <label class="form-label">Category</label>
                                    <select class="form-select" v-model="form.category">
                                        <option value="">Uncategorized</option>
                                        <option v-for="cat in categories" :key="cat.id" :value="cat.id">
                                            {{ cat.name }}
                                        </option>
                                    </select>
                                </div>

                                
                                <div>
                                    <label class="form-label">Payer</label>
                                    <input type="text" class="form-control" v-model="form.payer" disabled required />
                                </div>

                                <div>
                                    <label class="form-label">Method</label>
                                    <select class="form-select" v-model="form.method" required>
                                        <option value="">Select</option>
                                        <option v-for="method in paymentMethods" :key="method.id" :value="String(method.id)">
                                            {{ method.name }}
                                        </option>
                                    </select>
                                </div>

                                <div v-if="showSavingAccount">
                                    <label class="form-label">Bank accounts</label>
                                    <select class="form-select" v-model="form.bankAccountId">
                                        <option value="">Select an option</option>
                                        <option v-for="acc in bankAccounts" :key="acc.id" :value="String(acc.id)">
                                            {{ acc.name }}
                                        </option>
                                    </select>
                                </div>

                                <div v-if="showGateway">
                                    <label class="form-label">Payment Gateway</label>
                                    <select class="form-select" v-model="form.gatewayId">
                                        <option value="">Select a payment gateway</option>
                                        <option v-for="pg in paymentGateways" :key="pg.id" :value="pg.id">
                                            {{ pg.name }} - {{ pg.identificador }}
                                        </option>
                                    </select>
                                </div>

                                <div v-if="showReader">
                                    <label class="form-label">POS Terminal Reader</label>
                                    <select class="form-select"
                                            v-model="form.readerId"
                                            @change="console.log('reader changed =>', $event.target.value, form.readerId)">
                                        <option value="" disabled>Select a terminal</option>

                                        <option v-for="reader in readerTerminals"
                                                :key="reader.id"
                                                :value="String(reader.id)">
                                        {{ reader.identification }} - {{ reader.serial_number_stripe }}
                                        </option>
                                    </select>
                                </div>

                                <div>
                                    <label class="form-label">Reference</label>
                                    <input type="text" class="form-control" v-model="form.ref" />
                                </div>

                                <div class="d-flex justify-content-end gap-2 mt-2">
                                    <button type="button" class="btn btn-light" @click="closeModal" :disabled="submitting">Cancel</button>
                                    <button type="submit" class="btn btn-primary" :disabled="submitting">
                                        <span v-if="submitting" class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>
                                        Save
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            {/literal}
            
        </div>

        
        <div class="col-lg-12"  id="application_ajaxrender">
            <div class="panel">
                <div class="panel-hdr">

                    <h2 class="d-none d-md-inline">
                        <span v-if="isCreditNote">Credit Note</span>
                        <span v-else>Invoice</span> - {{ invoiceNumber }}
                    </h2>

                    <div class="panel-toolbar"></div>

                </div>

                <div class="panel-container">
                    <div class="panel-content">

                        <div class="invoice">
                            <header class="clearfix">
                                <div class="row">
                                    <div class="col-sm-6 mt-md">

                                    <h2 v-if="isCreditNote" class="h2 mt-none mb-sm text-dark text-bold">CREDIT NOTE</h2>
                                    <h2 v-else class="h2 mt-none mb-sm text-dark text-bold">INVOICE</h2>

                                    <h4 class="h4 m-none text-dark text-bold">#{{ invoiceNumber }}</h4>

                                    <h3 class="alert" :class="invoiceStatusClass">{{ invoice.status || '' }}</h3>

                                    <h4 v-if="invoice.title">{{ invoice.title }}</h4>
                                    <hr v-if="invoice.title">

                                    <h4 v-if="invoiceConfig.invoice_receipt_number == '1' && invoice.receipt_number">
                                        Receipt Number: {{ invoice.receipt_number }}
                                    </h4>
                                    <hr v-if="invoiceConfig.invoice_receipt_number == '1' && invoice.receipt_number">


                                        {if !empty($config['invoice_items_purchasing'])}

                                        <div class="p-3 rounded-3 mb-4" style="background: #C6DAFF;">



                                            <div class="row">
                                                <div class="col-4">
                                                    <h5>Purchase Info</h5>
                                                    {if $d['purchase_status']}
                                                    <span class="badge bg-info text-white">{$d['purchase_status']}</span>
                                                    {/if}
                                                </div>
                                                <div class="col-8 text-end">

                                                    <div class="btn-group" role="group" aria-label="Button group with nested dropdown">
                                                        <div class="btn-group" role="group">
                                                            <button type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                                                Purchase Status
                                                            </button>
                                                            <ul class="dropdown-menu">
                                                                <li class="dropdown-item set_invoice_purchase_status" data-status="Purchased"><a href="javascript:;">{__('Purchased')}</a></li>
                                                                <li class="dropdown-item set_invoice_purchase_status" data-status="On Hold"><a href="javascript:;">{__('On Hold')}</a></li>
                                                                <li class="dropdown-item set_invoice_purchase_status" data-status="Arrived"><a href="javascript:;">{__('Arrived')}</a></li>
                                                                <li class="dropdown-item set_invoice_purchase_status" data-status="Collected"><a href="javascript:;">{__('Collected')}</a></li>
                                                            </ul>
                                                        </div>
                                                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#purchaseInfo"><i class="fal fa-plus"></i> {__('Purchase Info')}</button>
                                                    </div>


                                                </div>
                                            </div>

                                            {if !empty($d['purchase_id'])}
                                            <p class="mb-1"><strong>Purchase ID:</strong> {$d['purchase_id']}</p>
                                            {/if}

                                            {if !empty($d['purchase_date'])}
                                            <p class="mb-1"><strong>Purchase Date:</strong> {$d['purchase_date']}</p>
                                            {/if}

                                            {if !empty($d['purchase_cost'])}
                                            <p class="mb-1"><strong>Purchase Cost:</strong> {formatCurrency($d['purchase_cost'],$d['currency'])}</p>
                                            {/if}

                                            {if !empty($d['purchase_staff_id']) && !empty($staffs[$d['purchase_staff_id']])}
                                            <p class="mb-1"><strong>Staff:</strong> {$staffs[$d['purchase_staff_id']]->fullname}</p>
                                            {/if}

                                            {if !empty($d['purchase_notes'])}
                                            <p class="mb-1"><strong>Notes:</strong> {$d['purchase_notes']}</p>
                                            {/if}

                                        </div>

                                        {/if}

                                        {if !empty($config['invoice_items_shipping'])}

                                        <div class="p-3 rounded-3 mb-4" style="background: #C6DAFF;">

                                            <div class="row">
                                                <div class="col-3">
                                                    <h5>Shipping Info</h5>
                                                    {if $d['shipping_status']}
                                                    <span class="badge bg-info text-white">{$d['shipping_status']}</span>
                                                    {/if}
                                                </div>
                                                <div class="col-9 text-end">

                                                    <div class="btn-group" role="group" aria-label="Button group with nested dropdown">
                                                        <div class="btn-group" role="group">
                                                            <button type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                                                Shipping Status
                                                            </button>
                                                            <ul class="dropdown-menu">
                                                                {if $d['shipping_status'] !== 'In Progress'}
                                                                <li class="dropdown-item set_invoice_shipping_status" data-status="In Progress"><a href="javascript:;">{__('In Progress')}</a></li>
                                                                {/if}

                                                                {if $d['shipping_status'] !== 'Shipped'}
                                                                <li class="dropdown-item set_invoice_shipping_status" data-status="Shipped"><a href="javascript:;">{__('Shipped')}</a></li>
                                                                {/if}

                                                            </ul>
                                                        </div>
                                                        <a href="{$_url}invoices/delivery-label/{$d['id']}" target="_blank" class="btn btn-primary">{{__('Delivery Label')}}</a>
                                                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#shippingInfo"><i class="fal fa-plus"></i> {__('Shipping Info')}</button>
                                                    </div>

                                                </div>
                                            </div>

                                            {if !empty($d['shipping_date'])}
                                            <p class="mb-1"><strong>Shipping Date:</strong> {$d['shipping_date']}</p>
                                            {/if}

                                            {if !empty($d['shipping_tracking_number'])}
                                            <p class="mb-1"><strong>Tracking Number:</strong> {$d['shipping_tracking_number']}</p>
                                            {/if}

                                            {if !empty($d['shipping_weight'])}
                                            <p class="mb-1"><strong>Weight:</strong> {$d['shipping_weight']}</p>
                                            {/if}

                                            {if !empty($d['shipping_cost'])}
                                            <p class="mb-1"><strong>Shipping Cost:</strong> {$d['shipping_cost']}</p>
                                            {/if}

                                            {if !empty($d['shipping_notes'])}
                                            <p class="mb-1"><strong>Notes:</strong> {$d['shipping_notes']}</p>
                                            {/if}

                                        </div>

                                        {/if}


                                    </div>
                                    <div class="col-sm-6 text-end mt-md mb-md">

                                        <div class="ib">
                                            <img v-if="invoiceConfig.logo_default" :src="'{$app_url}storage/system/' + invoiceConfig.logo_default" alt="Logo" style="margin-bottom: 15px; width: 200px;">
                                        </div>

                                        <address class="ib mr-xlg">
                                            <strong>{{ invoiceConfig.company_name }}</strong>
                                            <br>
                                            <span v-html="invoiceConfig.company_address || ''"></span>

                                            <template v-if="invoiceConfig.vat_number">
                                                <br>
                                                <strong>{{ invoiceConfig.label_tax_number || 'Vat number' }}:</strong> {{ invoiceConfig.vat_number }}
                                            </template>


                                        </address>

                                    </div>
                                </div>
                            </header>
                            <div class="bill-info">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="bill-to">
                                            <p class="h5 mb-xs text-dark text-semibold">
                                                <strong>
                                                    <span v-if="isCreditNote">To</span>
                                                    <span v-else>Invoiced To:</span>
                                                </strong>
                                            </p>
                                            <address>
                                                <template v-if="invoiceContact && invoiceContact.company">
                                                    {{ invoiceContact.company }}
                                                    <br>
                                                    <template v-if="invoiceConfig.show_business_number == '1' && invoiceContact.business_number">
                                                        Business number: {{ invoiceContact.business_number }}
                                                        <br>
                                                    </template>
                                                    ATTN: {{ invoice.account }}
                                                    <br>
                                                </template>
                                                <template v-else>
                                                    {{ invoice.account }}
                                                    <br>
                                                </template>

                                                <span v-if="invoiceContact && invoiceContact.formatted_address" v-html="invoiceContact.formatted_address"></span>

                                                <template v-if="invoiceContact && invoiceContact.formatted_address">
                                                    <br>
                                                </template>

                                                <template v-if="invoiceContact && invoiceContact.phone">
                                                    <strong>Phone:</strong> {{ invoiceContact.phone }}
                                                </template>

                                                <template v-if="invoiceConfig.fax_field != '0' && invoiceContact && invoiceContact.fax">
                                                    <br>
                                                    <strong>Fax:</strong> {{ invoiceContact.fax }}
                                                </template>

                                                <template v-if="invoiceContact && invoiceContact.email">
                                                    <br>
                                                    <strong>Email:</strong> {{ invoiceContact.email }}
                                                </template>

                                                <template v-if="isIndiaTax && invoiceContact && invoiceContact.business_number">
                                                    <br>
                                                    <strong>GSTIN:</strong> {{ invoiceContact.business_number }}
                                                </template>
                                            </address>

                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="bill-data text-end">
                                            <p class="mb-none">
                                                <span class="text-dark">Invoice Date:</span> <span class="value">{{ invoiceFormatted.date || '' }}</span>
                                            </p>
                                            <p class="mb-none">
                                                <span class="text-dark">Due Date:</span> <span class="value">{{ invoiceFormatted.due || '' }}</span>
                                            </p>
                                            <h2>
                                                <span v-if="isCreditNote">Total</span>
                                                <span v-else>Invoice Total:</span>
                                                {{ formatPaymentAmount(invoice.total) }}
                                            </h2>
                                            <template v-if="Number(invoice.credit || 0) !== 0">
                                                <h2>Total Paid: {{ formatPaymentAmount(invoice.credit) }}</h2>
                                                <h2>Amount Due: {{ formatPaymentAmount(invoiceAmountDue) }}</h2>
                                            </template>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            {$extraHtml}





                            {if $quote}

                            <h4>{$_L['Quote']}: {$quote->id}</h4>

                            <div class="row">
                                <div class="col-md-12">
                                    <hr>
                                    {$quote->proposal}
                                    <hr>
                                </div>
                            </div>
                            {/if}

                            <div class="table-responsive">


                                <template v-if="isIndiaTax">

                                <table class="table table-bordered invoice-items">
                                    <thead>
                                        <tr class="text-dark">
                                            <th id="cell-id" class="text-semibold">S/L</th>
                                            <th id="cell-item" class="text-semibold">{$_L['Item']}</th>
                                            <th class="text-semibold">HSN / SAC</th>
                                            <th id="cell-price" class="text-center text-semibold">{$_L['Price']}</th>
                                            <th id="cell-qty" class="text-center text-semibold">Qty</th>
                                            <th class="text-end">Taxable Value</th>


                                            <template v-if="invoice.is_same_state">

                                            <th class="text-end">CGST</th>
                                            <th class="text-end">SGST/UTGST</th>
                                            <th class="text-end">GST</th>

                                            </template>
                                            <template v-else>

                                            <th class="text-end">IGST</th>

                                            </template>

                                            <th id="cell-total" class="text-end text-semibold">{$_L['Total']}</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <tr v-for="(item, index) in items" :key="item.id || item.itemcode || index">
                                            <td>
                                                {{ item.itemcode || (index + 1) }}
                                            </td>
                                            <td class="text-semibold text-dark">
                                                <template v-if="!item.name_products">
                                                    {{ item.description }}
                                                </template>
                                                <template v-else>
                                                    <strong class="strong_p">
                                                        {{ item.name_products }}
                                                    </strong>
                                                    <div style="font-size:11px; margin:0px;" v-html="item.description"></div>
                                                </template>

                                            </td>
                                            <td class="text-semibold text-dark">{{ item.tax_code }}</td>
                                            <td class="text-center">{{ formatPaymentAmount(item.amount) }}</td>
                                            <td class="text-center">{{ item.qty }}</td>
                                            <td class="text-end">
                                                <template v-if="Number(item.discount_amount || 0) > 0">
                                                    Total: {{ formatPaymentAmount(getLineTotal(item)) }}
                                                    <br>
                                                    Discount: {{ item.discount_amount }}
                                                    <br>
                                                    Taxable amount: {{ formatPaymentAmount(getBaseTotal(item)) }}
                                                </template>
                                                <template v-else>
                                                    {{ formatPaymentAmount(getLineTotal(item)) }}
                                                </template>


                                            </td>


                                            <template v-if="invoice.is_same_state">

                                            <td class="text-end">
                                                {{ formatPaymentAmount(getTaxSplitValue(item, 2)) }}
                                                <br>
                                                @{{ (Number(item.tax_rate || 0) / 2).toFixed(2) }}%
                                            </td>
                                            <td class="text-end">

                                                {{ formatPaymentAmount(getTaxSplitValue(item, 2)) }}
                                                <br>
                                                @{{ (Number(item.tax_rate || 0) / 2).toFixed(2) }}%
                                            </td>
                                            <td class="text-end">
                                                {{ formatPaymentAmount(item.taxamount) }} <br>
                                                @{{ Number(item.tax_rate || 0).toFixed(2) }}%
                                            </td>

                                            </template>
                                            <template v-else>



                                            <td class="text-end">
                                                {{ formatPaymentAmount(getTaxSplitValue(item, 1)) }} <br>
                                                @{{ Number(item.tax_rate || 0).toFixed(2) }}%

                                            </td>

                                            </template>




                                            <td class="text-end">{{ formatPaymentAmount((Number(item.total || 0) + Number(item.taxamount || 0)) || getBaseTotal(item)) }}</td>
                                        </tr>
                                    </tbody>
                                </table>

                                </template>
                                <template v-else>

                                <table class="table table-bordered invoice-items">
                                    <thead>
                                        <tr class="text-dark">
                                            <th id="cell-id" class="fw-bold">#</th>
                                            <th id="cell-item" class="fw-bold">{$_L['Item']}</th>
                                            <th id="cell-price" class="text-end fw-bold">{$_L['Price']}</th>
                                            <th id="cell-qty" class="text-end fw-bold">Qty</th>
                                            <th id="cell-total" class="text-end fw-bold">{$_L['Total']}</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <tr v-for="(item, index) in items" :key="item.id || item.itemcode || index">
                                            <td>
                                                {{ item.itemcode || (index + 1) }}
                                            </td>
                                            <td class="text-dark">

                                                <template v-if="!item.name_products">
                                                    {{ item.description }}
                                                </template>
                                                <template v-else>
                                                    <strong class="strong_p">
                                                        {{ item.name_products }}
                                                    </strong>
                                                    <div style="font-size:11px; margin:0px;" v-html="item.description"></div>
                                                </template>

                                                <template v-if="invoiceConfig.invoicing_allow_staff_selection_for_each_item && item.staff_id">
                                                    <br>
                                                    <p class="badge bg-primary" style="background-color: #2361ce !important;border-radius: 20px;">
                                                        Staff: {{ itemStaffName(item) }}
                                                    </p>
                                                </template>

                                            </td>
                                            <td class="text-end">{{ formatPaymentAmount(item.amount) }}</td>
                                            <td class="text-end">{{ item.qty }}</td>
                                            <td class="text-end">
                                                <template v-if="Number(item.discount_amount || 0) > 0">
                                                    {{ formatPaymentAmount(item.total) }} <br>
                                                    <span class="text-danger">- {{ formatPaymentAmount(getDiscountAmount(item.discount_amount, item.discount_type, getLineTotal(item))) }}</span>
                                                </template>
                                                <template v-else>
                                                    {{ formatPaymentAmount(Number(item.total || 0) + Number(item.discount_amount || 0)) }}
                                                </template>

                                            </td>
                                        </tr>
                                    </tbody>
                                </table>

                                </template>

                            </div>

                            <div class="invoice-summary">
                                <div class="row">
                                    <div class="col-md-4 offset-md-8">
                                        <table class="table h5 text-dark">
                                            <tbody>
                                                <tr class="b-top-none">
                                                    <td colspan="2">Subtotal</td>
                                                    <td class="text-end">{{ formatPaymentAmount(invoice.subtotal) }}</td>
                                                </tr>
                                                <tr v-if="Number(invoice.discount || 0) !== 0">
                                                    <td colspan="2">Discount</td>
                                                    <td class="text-end">{{ formatPaymentAmount(invoice.discount) }}</td>
                                                </tr>

                                                <tr v-if="isIndiaTax">
                                                    <td colspan="2">GST Total</td>
                                                    <td class="text-end">{{ formatPaymentAmount(invoice.tax) }}</td>
                                                </tr>
                                                <tr v-else>
                                                    <td colspan="2">Tax</td>
                                                    <td class="text-end">{{ formatPaymentAmount(invoice.tax) }}</td>
                                                </tr>

                                                <template v-if="Number(invoice.credit || 0) !== 0">
                                                    <tr>
                                                        <td colspan="2">Total</td>
                                                        <td class="text-end">{{ formatPaymentAmount(invoice.total) }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="2">Total Paid</td>
                                                        <td class="text-end">{{ formatPaymentAmount(invoice.credit) }}</td>
                                                    </tr>
                                                    <tr class="h4" style="color: #2361ce !important;">
                                                        <td colspan="2">Amount Due</td>
                                                        <td class="text-end">{{ formatPaymentAmount(invoiceAmountDue) }}</td>
                                                    </tr>
                                                </template>
                                                <tr v-else class="h4">
                                                    <td colspan="2">Grand Total</td>
                                                    <td class="text-end">{{ formatPaymentAmount(invoice.total) }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                </div>


                <div class="block bloqueo_v2" hidden></div>
                <div class="block-content block bloqueo_v3" hidden>
                    <div class="loader-card">
                        <div class="preloader">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 200"><radialGradient id="a12" cx=".66" fx=".66" cy=".3125" fy=".3125" gradientTransform="scale(1.5)"><stop offset="0" stop-color="#0058FF"></stop><stop offset=".3" stop-color="#0058FF" stop-opacity=".9"></stop><stop offset=".6" stop-color="#0058FF" stop-opacity=".6"></stop><stop offset=".8" stop-color="#0058FF" stop-opacity=".3"></stop><stop offset="1" stop-color="#0058FF" stop-opacity="0"></stop></radialGradient><circle transform-origin="center" fill="none" stroke="url(#a12)" stroke-width="15" stroke-linecap="round" stroke-dasharray="200 1000" stroke-dashoffset="0" cx="100" cy="100" r="70"><animateTransform type="rotate" attributeName="transform" calcMode="spline" dur="2" values="360;0" keyTimes="0;1" keySplines="0 0 1 1" repeatCount="indefinite"></animateTransform></circle><circle transform-origin="center" fill="none" opacity=".2" stroke="#0058FF" stroke-width="15" stroke-linecap="round" cx="100" cy="100" r="70"></circle></svg>
                        </div>

                        <div class="confirmation-message">
                            Waiting for payment confirmation…
                        </div>
                    </div>
                </div>


            </div>
        </div>


        <!-- Related Transactions -->
        <div class="col-lg-12" v-if="transactions.length">

            <h3 class="invoice-section-title">Related Transactions</h3>

            <div class="table-container tc-table m-0">
            
                <table class="sys_table">
                    <th>Date</th>
                    <th>Account</th>
                    <th>Staff</th>
                    <th class="text-end">Amount</th>
                    <th>Description</th>
                    <th>Ref</th>
                    <th>Method</th>
                    <th>Payment Gateway</th>

                    <tr v-for="tx in transactions" :key="tx.id || (tx.ref + '-' + tx.date)" :class="tx.cr === '0.00' ? 'warning' : 'info'">
                        <td>{{ formatTransactionDate(tx.date) }}</td>
                        <td>{{ tx.account || '' }}</td>
                        <td>{{ staffName(tx) }}</td>
                        <td class="text-end">{{ formatTransactionAmount(tx.amount) }}</td>
                        <td>{{ tx.description || '' }}</td>
                        <td>{{ tx.ref || '' }}</td>
                        <td>{{ tx.method || '' }}</td>
                        <td>{{ tx.name_pg || '' }}</td>
                    </tr>

                </table>

            </div>

        </div>
        <div v-else class="payment-history-card">
            <div class="flex-grow-1">
                <div class="payment-history-title">No payments found</div>
                <p class="payment-history-meta">Payments will appear here once they are recorded.</p>
            </div>
        </div>
        <!-- End Related Transactions -->

        <!-- Payment History -->
        <div class="col-lg-12 mt-3" v-if="paymentHistory.length">
            <h3 class="invoice-section-title">Payment History</h3>

            <div class="payment-history-wrapper">
                <div>
                    <div class="payment-history-card" v-for="(payment, index) in paymentHistory" :key="payment.source + '-' + (payment.link_id || index) + '-' + payment.date">
                        <div class="flex-grow-1">
                            <div class="payment-history-title">
                                Payment of {{ formatPaymentAmount(payment.amount) }} via {{ payment.method || 'Unknown' }}
                                <span class="ms-2 payment-history-status" :class="{ overdue: (payment.status || '').toLowerCase() === 'unpaid', rejected: (payment.status || '').toLowerCase() === 'rejected' }">
                                    {{ payment.status || '' }}
                                </span>
                            </div>
                            <p class="payment-history-meta">
                                Source: {{ paymentSourceLabel(payment) }}
                                <span v-if="payment.source === 'terminal' && payment.serial_number_stripe"><br>SN: {{ payment.serial_number_stripe }}</span>
                                <span v-if="payment.staff"><br>By {{ payment.staff }}</span>
                                <span v-if="payment.error"><br>Error: {{ payment.error }}</span>
                            </p>
                            <div class="payment-history-date">
                                Performed on
                                {{ payment.display_date || '' }}
                                <span class="payment-history-time" v-if="payment.display_time">{{ payment.display_time }}</span>
                            </div>
                            <div class="payment-history-actions" v-if="payment.source === 'link' && payment.link_url">
                                <a :href="payment.link_url" :id="'enlaces_pago' + (payment.link_id || '')" target="_blank" class="text-success">
                                    <i class='fa fa-external-link'></i> Open link
                                </a>
                                <a href="javascript:;" class="text-info enlaces_pago"
                                   :id="'copy_link_' + (payment.link_id || index)"
                                   :data-data1="payment.link_id || ''"
                                   data-bs-toggle="tooltip"
                                   data-bs-placement="top"
                                   title="Copy"
                                   @click.prevent="copyPaymentLink(payment, index)">
                                    <i class='fa fa-copy'></i> Copy
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Payment History -->

    </div>







    {if $inv_files_c neq '' && $inv_files|@count gt 0}
    <div class="col-lg-12 mt-3">
        
        <h3 class="invoice-section-title">Files</h3>

        <div class="table-container tc-table m-0">
        
            <table>
                <thead>
                    <tr>
                        <th data-sort-ignore="true" width="20px;">{$_L['Type']}</th>

                        <th>{$_L['File']}</th>

                        <th data-sort-ignore="true" width="100px;">{$_L['Manage']}</th>
                    </tr>
                </thead>
                <tbody>

                    {if $inv_files|@count gt 0}
                        {foreach $inv_files as $ds}

                        <tr>

                            <td>
                                {if $ds['file_mime_type'] eq 'jpg' || $ds['file_mime_type'] eq 'png' || $ds['file_mime_type'] eq 'gif'}
                                <i class="fal fa-file-image-o" style="font-size: 27px;width: 30px;"></i>
                                {elseif $ds['file_mime_type'] eq 'pdf'}
                                <i class="fal fa-file-pdf-o" style="font-size: 27px;width: 30px;"></i>
                                {elseif $ds['file_mime_type'] eq 'zip'}
                                <i class="fal fa-file-archive-o" style="font-size: 27px;width: 30px;"></i>
                                {else}
                                <i class="fal fa-file" style="font-size: 27px;width: 30px;"></i>
                                {/if}
                            </td>


                            <td>

                                {$ds['title']}

                                {if $ds['file_mime_type'] eq 'jpg' || $ds['file_mime_type'] eq 'png' || $ds['file_mime_type'] eq 'gif'}

                                <div class="hr-line-dashed"></div>

                                <img src="{$app_url}storage/docs/{$ds['file_path']}" class="img-responsive" alt="{$ds['title']}">

                                {/if}

                            </td>

                            <td class="apply_display">

                                <a data-bs-toggle="tooltip" data-placement="top" title="{$_L['Download']}" href="{$_url}client/dl/{$ds['id']}_{$ds['file_dl_token']}/" class="btn btn-light border">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none"><path d="M3 15C3 17.8284 3 19.2426 3.87868 20.1213C4.75736 21 6.17157 21 9 21H15C17.8284 21 19.2426 21 20.1213 20.1213C21 19.2426 21 17.8284 21 15" stroke="#000000" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M12 3V16M12 16L16 11.625M12 16L8 11.625" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>
                                </a>

                                <a data-bs-toggle="tooltip" data-placement="top" title="{$_L['Delete']}" onclick="confirmThenGoToUrl(event,'delete/document/{$ds['id']}');" href="javascript:;" class="btn btn-light border">
                                    <svg class="cursor-pointer hover:fill-error-500 dark:hover:fill-error-500 fill-gray-700 dark:fill-gray-400" width="20" height="20" viewBox="0 0 20 20" fill="#000000" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.54142 3.7915C6.54142 2.54886 7.54878 1.5415 8.79142 1.5415H11.2081C12.4507 1.5415 13.4581 2.54886 13.4581 3.7915V4.0415H15.6252H16.666C17.0802 4.0415 17.416 4.37729 17.416 4.7915C17.416 5.20572 17.0802 5.5415 16.666 5.5415H16.3752V8.24638V13.2464V16.2082C16.3752 17.4508 15.3678 18.4582 14.1252 18.4582H5.87516C4.63252 18.4582 3.62516 17.4508 3.62516 16.2082V13.2464V8.24638V5.5415H3.3335C2.91928 5.5415 2.5835 5.20572 2.5835 4.7915C2.5835 4.37729 2.91928 4.0415 3.3335 4.0415H4.37516H6.54142V3.7915ZM14.8752 13.2464V8.24638V5.5415H13.4581H12.7081H7.29142H6.54142H5.12516V8.24638V13.2464V16.2082C5.12516 16.6224 5.46095 16.9582 5.87516 16.9582H14.1252C14.5394 16.9582 14.8752 16.6224 14.8752 16.2082V13.2464ZM8.04142 4.0415H11.9581V3.7915C11.9581 3.37729 11.6223 3.0415 11.2081 3.0415H8.79142C8.37721 3.0415 8.04142 3.37729 8.04142 3.7915V4.0415ZM8.3335 7.99984C8.74771 7.99984 9.0835 8.33562 9.0835 8.74984V13.7498C9.0835 14.1641 8.74771 14.4998 8.3335 14.4998C7.91928 14.4998 7.5835 14.1641 7.5835 13.7498V8.74984C7.5835 8.33562 7.91928 7.99984 8.3335 7.99984ZM12.4168 8.74984C12.4168 8.33562 12.081 7.99984 11.6668 7.99984C11.2526 7.99984 10.9168 8.33562 10.9168 8.74984V13.7498C10.9168 14.1641 11.2526 14.4998 11.6668 14.4998C12.081 14.4998 12.4168 14.1641 12.4168 13.7498V8.74984Z" fill=""></path></svg>
                                </a>

                            </td>


                        </tr>

                        {/foreach}
                    {else}
                        <tr>
                            <td colspan="3">No files found</td>
                        </tr>
                    {/if}

                </tbody>



            </table>

        </div>

    </div>
    {/if}

    
    {if ($d['notes']) neq ''}
    <div class="col-lg-12 mt-3">

        <h3 class="invoice-section-title">Notes</h3>
        
        <div class="card-box" style="font-size: 15px;font-weight: 500;">
            {$d['notes']}
        </div>
    
    </div>     
    {/if}

    {*Logs*}
    {if count($access_logs) neq 0}
        <div class="col-lg-12 mt-3">

            <h3 class="invoice-section-title">{$_L['Customer']} : {$_L['Access Log']}</h3>

            <div class="table-container tc-table m-0">
            
                <table class="sys_table">
                    <thead>
                        <tr class="text-dark">
                            <th>{$_L['Time']}</th>
                            <th>{$_L['IP']}</th>
                            <th>{$_L['Country']}</th>
                            <th>{$_L['City']}</th>
                            <th>{$_L['Browser']}</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $access_logs as $log}
                        <tr>
                            <td>{date( $config['df']|cat:' H:i:s', strtotime($log['viewed_at']))}</td>
                            <td>{$log['ip']}</td>
                            <td>{$log['country']}</td>
                            <td>{$log['city']}</td>
                            <td>{$log['browser']}</td>
                        </tr>
                        {/foreach}
                    </tbody>
                </table>

            </div>
        
        </div>
    {/if}
    {**}


</div>



<div id="modal_add_item" class="modal fade" tabindex="-1"  role="dialog" aria-hidden="true">

    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    {$_L['New Document']}
                </h4>
                <button type="button" class="close btn btn-danger" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <form>
                    <div class="mb-3">
                        <label for="doc_title">{$_L['Title']}</label>
                        <input type="text" class="form-control" id="doc_title" name="doc_title">

                    </div>

                    <div class="checkbox">
                        <label>
                            <input type="checkbox" id="is_global" name="is_global"> {$_L['Available for all Customers']}
                        </label>
                    </div>





                </form>

                <hr>

                <form action="{$base_url}documents/upload/" class="dropzone" id="upload_container">

                    <div class="dz-message">
                        <h3> <i class="fal fa-cloud-upload"></i>  {$_L['Drop File Here']}</h3>
                        <br />
                        <span class="note">{$_L['Click to Upload']}</span>
                    </div>

                </form>
                <hr>
                <h4>{$_L['Server Config']}:</h4>
                <p>{$_L['Upload Maximum Size']}: {$upload_max_size}</p>
                <p>{$_L['POST Maximum Size']}: {$post_max_size}</p>

            </div>
            <div class="modal-footer">
                <input type="hidden" name="file_link" id="file_link" value="">
                <button type="button" data-bs-dismiss="modal" class="btn btn-danger">{$_L['Close']}</button>
                <button type="button" id="btn_add_file" class="btn btn-primary">{$_L['Submit']}</button>
            </div>
        </div>
    </div>


</div>

{if !empty($config['invoice_items_purchasing'])}

<div class="modal fade" id="purchaseInfo" tabindex="-1" aria-labelledby="purchaseInfoLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
           <form method="post" action="{$base_url}invoices/save-purchase-info">
               <div class="modal-header">
                   <h1 class="modal-title fs-5" id="purchaseInfoLabel">Purchase Info</h1>
                   <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
               </div>
               <div class="modal-body">

                   <div class="mb-3">
                       <label for="purchase_id">Purchase ID</label>
                       <input type="text" class="form-control" id="purchase_id" name="purchase_id" value="{$d['purchase_id']}">
                   </div>

                   <div class="row">
                       <div class="col-md-6">
                           <div class="mb-3">
                               <label for="purchase_date">Purchase Date</label>
                               <input type="text" class="form-control" id="purchase_date" datepicker
                               data-date-format="yyyy-mm-dd" data-auto-close="true" name="purchase_date"

                               {if !empty($d['purchase_date'])}
                               value="{$d['purchase_date']}"
                               {else}
                               value="{date('Y-m-d')}"
                               {/if}


                               >
                           </div>
                       </div>
                       <div class="col-md-6">
                           <div class="mb-3">
                               <label for="purchase_cost">Purchase Cost</label>
                               <input type="text" class="form-control" id="purchase_cost" name="purchase_cost" value="{$d['purchase_cost']}">
                           </div>
                       </div>
                   </div>

                   <div class="mb-3">
                       <label for="staff_id">{__('Staff')}</label>
                       <select name="staff_id" id="staff_id" class="form-select">
                           <option value="0">{__('Select Staff')}</option>
                           {foreach $staffs as $staff}
                           <option value="{$staff['id']}"
                           {if $staff['id'] == $d['purchase_staff_id']}
                           selected="selected"
                           {else}
                           {if $staff['id'] == $user['id']}
                           selected="selected"
                           {/if}
                           {/if}
                           >{$staff['fullname']}</option>
                           {/foreach}
                       </select>
                   </div>

                   <div class="mb-3">
                       <label for="purchase_notes">Purchase Notes</label>
                       <textarea class="form-control" id="purchase_notes" rows="5" name="purchase_notes">{$d['purchase_notes']}</textarea>
                   </div>


               </div>
               <div class="modal-footer">
                   <input type="hidden" name="invoice_id" value="{$d['id']}">
                   <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                   <button type="submit" class="btn btn-primary">Save</button>
               </div>
           </form>
       </div>
   </div>
</div>

{/if}

{if !empty($config['invoice_items_shipping'])}

<div class="modal fade" id="shippingInfo" tabindex="-1" aria-labelledby="shippingInfoLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="post" action="{$base_url}invoices/save-shipping-info">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="shippingInfoLabel">Shipping Info</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div class="mb-3">
                        <label for="shipping_weight">Weight</label>
                        <input type="text" class="form-control" id="shipping_weight" name="shipping_weight" value="{$d['shipping_weight']}">
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="shipping_date">Shipping Date</label>
                                <input type="text" class="form-control" id="shipping_date" datepicker
                                data-date-format="yyyy-mm-dd" data-auto-close="true" name="shipping_date"

                                {if !empty($d['shipping_date'])}
                                value="{$d['shipping_date']}"
                                {else}
                                value="{date('Y-m-d')}"
                                {/if}


                                >
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="shipping_cost">Shipping Cost</label>
                                <input type="text" class="form-control" id="shipping_cost" name="shipping_cost" value="{$d['shipping_cost']}">
                            </div>
                        </div>
                    </div>


                    <div class="mb-3">
                        <label for="shipping_notes">Shipping Notes</label>
                        <textarea class="form-control" id="shipping_notes" rows="5" name="shipping_notes">{$d['shipping_notes']}</textarea>
                    </div>


                </div>
                <div class="modal-footer">
                    <input type="hidden" name="invoice_id" value="{$d['id']}">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>

{/if}


<input type="hidden" id="_lan_msg_confirm" value="{$_L['are_you_sure']}">
<input type="hidden" id="admin_email" value="{$user->username}">




{/block}




<script type="application/json" id="add-payment-data">
{
  "invoiceNo": {$d['cn']},
  "invoiceId": {$d['id']},
  "invoiceType": "{$d['type']}",
  "payerId": "{$d['userid']}",
  "currency": "{$d['currency_iso_code']}"
}
</script>

{block name="script"}
<script>
(function () {
    if (!window.Vue) {
        console.warn('Invoice view: Vue no disponible');
        return;
    }

    window.ShowMessage = window.ShowMessage || false;

    const addPaymentDataEl = document.getElementById('add-payment-data');
    const addPaymentData = addPaymentDataEl ? JSON.parse(addPaymentDataEl.textContent || '{}') : {};
    const { createApp, ref, computed, watch, onMounted } = Vue;

    const METHOD = {
        CASH: '1',
        SAVINGS: '2',
        GATEWAY: '3',
        READER: '4',
    };

    const todayIso = () => new Date().toISOString().slice(0, 10);
    const defaultFormState = () => ({
        account: '',
        staff: '',
        date: todayIso(),
        description: '',
        amount: '',
        payer: '',
        category: '',
        method: '',
        gatewayId: '',
        readerId: '',
        bankAccountId: '',
        ref: '',
    });

    createApp({
        setup() {
            const openModal = ref(false);
            const submitting = ref(false);
            const connected = ref(false);
            const formErrors = ref([]);
            const invoiceTotal = ref(null);
            const amountDue = ref(null);
            const currencyISOCode = ref(null);
            const accounts = ref(addPaymentData.accounts || []);
            const staffs = ref(addPaymentData.staffs || []);
            const methods = ref(addPaymentData.methods || []);
            const categories = ref(addPaymentData.categories || []);
            const paymentGateways = ref(addPaymentData.paymentGateways || []);
            const readerTerminals = ref(addPaymentData.readerTerminals || []);
            const bankAccounts = ref(addPaymentData.bankAccounts || []);
            const accountMethods = ref(addPaymentData.accountMethods || []);
            const paymentMethods = ref(addPaymentData.paymentMethods  || []);
            const transactions = ref([]);
            const paymentHistory = ref([]);
            const invoice = ref({});
            const invoiceConfig = ref({});
            const invoiceContact = ref(null);
            const invoiceFormatted = ref({});
            const items = ref([]);
            const invoiceNo = addPaymentData.invoiceNo || Number(document.getElementById('invoice_number').value) || 0;
            const invoiceId = addPaymentData.invoiceId || Number(document.getElementById('iid').value) || 0;
            const invoiceType = addPaymentData.invoiceType || '';
            const payerId = ref(addPaymentData.payerId || '');
            const currency = addPaymentData.currency || '';
            const payer = ref([]);

            const form = ref(defaultFormState());

            const fileLink = ref('');
            const currentMethod = computed(() => String(form.value.method || ''));
            const showGateway = computed(() => currentMethod.value === METHOD.GATEWAY);
            const showReader = computed(() => currentMethod.value === METHOD.READER);
            const showSavingAccount = computed(() => currentMethod.value === METHOD.SAVINGS);

            watch(showReader, (isOn) => {
                if (isOn) {
                    form.value.readerId = '';
                }
            });


            watch(currentMethod, () => {
                if (!showGateway.value) {
                    form.value.gatewayId = '';
                }
                if (!showReader.value) {
                    form.value.readerId = '';
                }
                if (!showSavingAccount.value) {
                    form.value.bankAccountId = '';
                }
            });

            const uploadResponse = ref(null);
            const globalBaseUrl = typeof base_url !== 'undefined' ? base_url : (window.base_url || '');
            const uploadBaseUrl = document.getElementById('_url').value || '';

            const docTitleEl = () => document.getElementById('doc_title');
            const addFileButton = () => document.getElementById('btn_add_file');
            const uploadContainer = () => document.getElementById('upload_container');
            const invoiceIdInput = () => document.getElementById('iid');
            const confirmMessageInput = () => document.getElementById('_lan_msg_confirm');

            const notifySuccess = (msg) => {
                if (window.toastr) {
                    toastr.success(msg);
                } else {
                    alert(msg);
                }
            };

            const notifyError = (msg) => {
                if (window.toastr) {
                    toastr.error(msg);
                } else {
                    alert(msg);
                }
            };

            const postStatusUpdate = async (endpoint, status) => {
                try {
                    await fetch(globalBaseUrl + endpoint, {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                        body: new URLSearchParams({
                            status,
                            invoice_id: (invoiceIdInput() && invoiceIdInput().value) || invoiceId,
                        }).toString(),
                    });
                    window.location.reload();
                } catch (err) {
                    notifyError(err.message || 'Error');
                }
            };

            const confirmAction = (cb) => {
                const message = (confirmMessageInput() && confirmMessageInput().value) || 'Are you sure?';
                if (window.app && typeof window.app.confirm === 'function') {
                    window.app.confirm(message, cb);
                    return;
                }
                cb(window.confirm(message));
            };

            const decodeHtml = (value) => {
                if (!value) return '';
                const el = document.createElement('textarea');
                el.innerHTML = value;
                return el.value;
            };

            const showCopyTooltip = (linkId, message) => {
                const el = document.getElementById('copy_link_' + linkId);
                const label = message || 'Copied';
                if (!el) {
                    return;
                }

                el.setAttribute('title', label);

                if (window.bootstrap && bootstrap.Tooltip) {
                    const existing = bootstrap.Tooltip.getInstance(el);
                    if (existing) {
                        existing.dispose();
                    }
                    const tip = new bootstrap.Tooltip(el, { trigger: 'manual', title: label });
                    tip.show();
                    setTimeout(() => tip.hide(), 1200);
                    return;
                }

                if (window.toastr) {
                    toastr.success(label);
                }
            };

            const copyPaymentLink = async (payment, fallbackId) => {
                const link = payment && payment.link_url ? String(payment.link_url) : '';
                const linkId = payment && payment.link_id ? payment.link_id : fallbackId;

                if (!link) {
                    notifyError('Link not available');
                    return;
                }

                try {
                    if (navigator.clipboard && window.isSecureContext) {
                        await navigator.clipboard.writeText(link);
                    } else {
                        const input = document.createElement('input');
                        input.value = link;
                        input.setAttribute('readonly', '');
                        input.style.position = 'absolute';
                        input.style.left = '-9999px';
                        document.body.appendChild(input);
                        input.select();
                        document.execCommand('copy');
                        document.body.removeChild(input);
                    }
                    showCopyTooltip(linkId, 'Copied');
                } catch (err) {
                    notifyError('Copy failed');
                }
            };

            const formatPaymentAmount = (amount) => {
                if (typeof window.formatCurrency === 'function') {
                    return window.formatCurrency(amount, currencyISOCode.value || currency || '');
                }
                const value = Number(amount || 0);
                if (Number.isNaN(value)) {
                    return amount || '';
                }
                const iso = currencyISOCode.value || currency || '';
                if (iso && typeof Intl !== 'undefined' && Intl.NumberFormat) {
                    try {
                        return new Intl.NumberFormat(undefined, { style: 'currency', currency: iso }).format(value);
                    } catch (err) {
                        return value.toFixed(2) + (iso ? ' ' + iso : '');
                    }
                }
                return value.toFixed(2) + (iso ? ' ' + iso : '');
            };

            const paymentSourceLabel = (payment) => {
                const source = payment && payment.source ? String(payment.source) : '';
                if (source === 'link') return 'Payment Link';
                if (source === 'bank') return 'Bank Account';
                if (source === 'terminal') return 'POS Terminal';
                return source || 'Unknown';
            };

            const isCreditNote = computed(() => (invoice.value.type || '') === 'Credit Note');
            const isIndiaTax = computed(() => (invoiceConfig.value.tax_system || '') === 'India');

            const invoiceNumber = computed(() => {
                const inv = invoice.value.invoicenum || '';
                const cn = invoice.value.cn || '';
                const id = invoice.value.id || '';
                if (cn) {
                    return inv + ' ' + cn;
                }
                if (id) {
                    return inv + ' ' + id;
                }
                return inv;
            });

            const invoiceStatusClass = computed(() => {
                const status = String(invoice.value.status || '').toLowerCase();
                if (status === 'unpaid') return 'alert-danger';
                if (status === 'paid') return 'alert-success';
                if (status === 'partially paid') return 'alert-info';
                return 'alert-info';
            });

            const formatTransactionAmount = (amount) => {
                if (typeof window.formatCurrency === 'function') {
                    return window.formatCurrency(amount, currencyISOCode.value || currency || '');
                }
                const value = Number(amount || 0);
                if (Number.isNaN(value)) {
                    return amount || '';
                }
                const iso = currencyISOCode.value || currency || '';
                if (iso && typeof Intl !== 'undefined' && Intl.NumberFormat) {
                    try {
                        return new Intl.NumberFormat(undefined, { style: 'currency', currency: iso }).format(value);
                    } catch (err) {
                        return value.toFixed(2) + (iso ? ' ' + iso : '');
                    }
                }
                return value.toFixed(2) + (iso ? ' ' + iso : '');
            };

            const formatTransactionDate = (value) => {
                if (!value) return '';
                return value;
            };

            const staffName = (tr) => {
                if (!tr) return '';
                const staffId = tr.aid || tr.staff_id || tr.id_staff || '';
                if (!staffId) return '';
                const match = (staffs.value || []).find((staff) => String(staff.id) === String(staffId));
                return match ? (match.fullname || '') : '';
            };

            const invoiceAmountDue = computed(() => {
                const total = Number(invoice.value.total || 0);
                const credit = Number(invoice.value.credit || 0);
                if (credit && credit !== 0) {
                    return total - credit;
                }
                return total;
            });

            const getDiscountAmount = (discountAmount, discountType, totalAmount) => {
                if (discountType === 'percentage' || discountType === 'p') {
                    return (Number(discountAmount || 0) / 100) * Number(totalAmount || 0);
                }
                return Number(discountAmount || 0);
            };

            const getLineTotal = (item) => {
                const amount = Number(item && item.amount ? item.amount : 0);
                const qty = Number(item && item.qty ? item.qty : 0);
                return amount * qty;
            };

            const getBaseTotal = (item) => {
                if (!item) return 0;
                const rawTotal = Number(item.total || 0);
                if (rawTotal) return rawTotal;
                const lineTotal = getLineTotal(item);
                const discount = getDiscountAmount(item.discount_amount, item.discount_type, lineTotal);
                return lineTotal - discount;
            };

            const getTaxSplitValue = (item, divisor) => {
                const baseTotal = getBaseTotal(item);
                const rate = Number(item && item.tax_rate ? item.tax_rate : 0);
                if (!rate || !baseTotal) return 0;
                const appliedRate = divisor ? rate / divisor : rate;
                return (baseTotal * appliedRate) / 100;
            };

            const itemStaffName = (item) => {
                if (!item) return '';
                const staffId = item.staff_id || '';
                if (!staffId) return '';
                const match = (staffs.value || []).find((staff) => String(staff.id) === String(staffId));
                return match ? (match.fullname || '') : '';
            };

            const bindStatusHandlers = (selector, endpoint) => {
                const buttons = document.querySelectorAll(selector);
                if (!buttons || !buttons.length) {
                    return;
                }

                buttons.forEach((btn) => {
                    btn.addEventListener('click', (e) => {
                        e.preventDefault();
                        const status = btn.getAttribute('data-status') || '';
                        if (!status) {
                            return;
                        }
                        confirmAction((result) => {
                            if (!result) {
                                return;
                            }
                            postStatusUpdate(endpoint, status);
                        });
                    });
                });
            };

            const initDropzone = () => {
                const container = uploadContainer();
                const button = addFileButton();

                if (!container || !window.Dropzone) {
                    return;
                }

                if (typeof Dropzone !== 'undefined') {
                    Dropzone.autoDiscover = false;
                }

                let dz = container.dropzone;

                if (!dz) {
                    dz = new Dropzone(container, {
                        url: uploadBaseUrl + 'documents/upload/',
                        maxFiles: 1,
                    });
                } else {
                    dz.options.url = uploadBaseUrl + 'documents/upload/';
                    dz.options.maxFiles = 1;
                }

                if (container.dataset && container.dataset.dzListenersAttached === '1') {
                    return;
                }

                dz.on('sending', () => {
                    if (button) {
                        button.disabled = true;
                    }
                });

                dz.on('success', (file, response) => {
                    if (button) {
                        button.disabled = false;
                    }

                    uploadResponse.value = response;
                    const success = response && response.success === 'Yes';

                    if (success) {
                        notifySuccess(response.msg || 'Upload completed');
                        console.log("fileLink", response.file);

                        fileLink.value = response.file || '';
                    } else {
                        notifyError((response && response.msg) || 'Upload error');
                    }
                });

                dz.on('error', (file, errorMessage) => {
                    if (button) {
                        button.disabled = false;
                    }
                    notifyError(typeof errorMessage === 'string' ? errorMessage : 'Upload error');
                });

                if (container.dataset) {
                    container.dataset.dzListenersAttached = '1';
                }
            };

            const submitDocument = async (event) => {
                if (event) {
                    event.preventDefault();
                }

                const button = addFileButton();
                if (button) {
                    button.disabled = true;
                }

                const payload = new URLSearchParams({
                    title: (docTitleEl() && docTitleEl().value) || '',
                    file_link: fileLink.value || '',
                    rid: invoiceId,
                    rtype: 'invoice',
                });

                try {
                    const res = await fetch(uploadBaseUrl + 'documents/post/', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        body: payload.toString(),
                    });

                    const text = await res.text();

                    if (!Number.isNaN(Number(text))) {
                        window.location.reload();
                    } else {
                        notifyError(text || 'Error');
                    }
                } catch (err) {
                    notifyError(err.message || 'Error');
                } finally {
                    if (button) {
                        button.disabled = false;
                    }
                }
            };

            const initDocumentSubmit = () => {
                const button = addFileButton();
                if (!button) {
                    return;
                }
                button.addEventListener('click', submitDocument);
            };

            const resetForm = () => {
                form.value = defaultFormState();
                formErrors.value = [];
            };

            const closeModal = () => {
                openModal.value = false;
            };

            const addPayment = () => {
                openModal.value = true;
            };

            const setBlockingOverlay = (active) => {
                var $v2 = $('.bloqueo_v2');
                var $v3 = $('.bloqueo_v3');
                if (active) {
                    $v2.removeAttr('hidden');
                    $v3.removeAttr('hidden');
                } else {
                    $v2.attr('hidden', true);
                    $v3.attr('hidden', true);
                }
            };

            const validate = () => {
                const errors = [];
                if (!form.value.account) errors.push('Account is required');
                if (!form.value.date) errors.push('Date is required');
                if (!form.value.amount) errors.push('Amount is required');
                if (!form.value.method) errors.push('Method is required');
                if (showSavingAccount.value && !form.value.bankAccountId) {
                    errors.push('Bank account is required for savings deposits');
                }
                if (showGateway.value && !form.value.gatewayId) {
                    errors.push('Payment gateway is required for this method');
                }
                if (showReader.value && !form.value.readerId) {
                    errors.push('POS terminal is required for this method');
                }
                return errors;
            };


            const fetchInvoice = async () => {                
                let invoiceId = (invoiceIdInput().value);

                try {
                    const response = await fetch('{$app_url}api/invoices/'+invoiceId);
                    const res = await response.json();

                    if (!res || res.status !== 'success' || !res.invoice) {
                        connected.value = false;
                        toastr.error((res && res.message) || 'Connection error');
                        return;
                    }

                    invoice.value = res.invoice || {};
                    invoiceConfig.value = res.config || {};
                    invoiceContact.value = res.contact || null;
                    invoiceFormatted.value = res.formatted || {};

                    // Prefill form with invoice data when available
                    invoiceTotal.value = invoice.value.total || '';
                    amountDue.value = invoice.value.credit || '';
                    currencyISOCode.value = invoice.value.currency_iso_code || '';
                    form.value.payer = invoice.value.account || '';
                    form.value.description = res.description || '';
                    payerId.value = invoice.value.userid || payerId.value;
                    items.value = res.items || [];
                    transactions.value = res.transactions || [];
                    paymentHistory.value = res.paymentHistory || [];
                    connected.value = true;

                } catch (err) {
                    console.error('Error', err);
                    connected.value = false;
                }
            };

            const fetchInvoiceContext = async () => {
                let invoiceId = (invoiceIdInput().value);

                try {

                    const response = await fetch('{$app_url}api/invoices/'+invoiceId+'/context');

                    if (!response.ok) {
                        connected.value = false;
                        toastr.error('Connection error');
                        return;
                    }

                    const res = await response.json();

                    if (res.status !== 'success') {
                        connected.value = false;
                        toastr.error(res.message || 'Connection error');
                        return;
                    }

                    accounts.value = res.accounts || [];
                    staffs.value = res.staffs || [];
                    paymentMethods.value = res.paymentMethods || [];
                    categories.value = (res.categories || []).map((cat) => ({
                        ...cat,
                        name: decodeHtml(cat.name || ''),
                    }));
                    accountMethods.value = res.accountMethods || [];
                    paymentGateways.value = res.paymentGateways || [];
                    readerTerminals.value = res.readerTerminals || [];
                    connected.value = true;

                } catch (err) {
                    console.error('Error', err);
                    connected.value = false;
                }
            };

            const submitPayment = async () => {
                
                if (submitting.value) return;

                formErrors.value = validate();
                if (formErrors.value.length) {
                    (window.toastr ? toastr.error(formErrors.value[0]) : alert(formErrors.value[0]));
                    return;
                }

                // Si el método es POS reader, mostramos el bloqueo mientras llega la confirmación por socket
                if (currentMethod.value === METHOD.READER) {
                    window.paymentId = null;
                    window.ShowMessage = true;
                    setBlockingOverlay(true);
                }

                const terminalId = showReader.value ? String(form.value.readerId || '') : '';
                submitting.value = true;

                const payload = new URLSearchParams({
                    staff: form.value.staff || '',
                    account: form.value.account || '',
                    date: form.value.date || '',
                    description: form.value.description || '',
                    amount: String(form.value.amount || '').trim(),
                    cats: form.value.category || '',
                    pmethod: form.value.method || '',
                    ref: form.value.ref || '',
                    invoiceNo: invoiceNo,
                    iid: invoiceId,
                    payer: payerId.value || '',
                    currency: currency,
                    pgateway: showGateway.value ? form.value.gatewayId || '' : '',
                    getTerminalReader: terminalId,
                    bankAccounts: showSavingAccount.value ? String(form.value.bankAccountId || '') : '',
                });

                /*const saveUrl =
                    invoiceType === 'Credit Note'
                        ? base_url + 'transactions/expense-post/' + invoiceId
                        : base_url + 'invoices/add-payment-post/' + invoiceId;*/

                const full_app_url = document.getElementById("_app_url").value;
                const saveUrl =
                    invoiceType === 'Credit Note'
                        ? base_url + 'transactions/expense-post/' + invoiceId
                        : full_app_url + '/api/stripe/payment';

                try {
                    const res = await fetch(saveUrl, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        body: payload.toString(),
                    });

                    const responseText = await res.text();
                    let info = null;

                    try {
                        info = JSON.parse(responseText);
                    } catch (err) {
                        info = { status: res.ok ? 'success' : 'error', message: responseText };
                    }

                    if (info && info.status === 'success') {
                        if (String(info.type_method) === METHOD.READER) {
                            // Esperar confirmación por socket; mantenemos el overlay
                            window.paymentId = info.id_stripe || null; 
                            console.log("METHOD READER payment ID", window.paymentId);
                            resetForm();
                            closeModal();
                        } else {
                            window.location.reload();
                            setBlockingOverlay(false);
                        }
                    } else {
                        const message = (info && info.message) || 'Error';
                        (window.toastr ? toastr.error(message) : alert(message));
                        closeModal();
                        setBlockingOverlay(false);
                    }
                } catch (error) {
                    (window.toastr ? toastr.error(error.message) : alert(error.message));
                    closeModal();
                } finally {
                    submitting.value = false;
                }
            };

            onMounted(async () => {
                await fetchInvoice();
                await fetchInvoiceContext();
                initDropzone();
                initDocumentSubmit();
                bindStatusHandlers('.set_invoice_status', 'invoices/set-status');
                bindStatusHandlers('.set_invoice_purchase_status', 'invoices/set-purchase-status');
                bindStatusHandlers('.set_invoice_shipping_status', 'invoices/set-shipping-status');
            }); 

            return {
                openModal,
                submitting,
                formErrors,
                accounts,
                staffs,
                methods,
                categories,
                paymentGateways,
                paymentMethods,
                accountMethods,
                readerTerminals,
                bankAccounts,
                paymentHistory,
                transactions,
                invoice,
                invoiceConfig,
                invoiceContact,
                invoiceFormatted,
                items,
                invoiceTotal,
                amountDue,
                currencyISOCode,
                form,
                showGateway,
                showReader,
                showSavingAccount,
                formatPaymentAmount,
                paymentSourceLabel,
                isCreditNote,
                isIndiaTax,
                copyPaymentLink,
                invoiceNumber,
                invoiceStatusClass,
                invoiceAmountDue,
                formatTransactionAmount,
                formatTransactionDate,
                staffName,
                getDiscountAmount,
                getLineTotal,
                getBaseTotal,
                getTaxSplitValue,
                itemStaffName,
                closeModal,
                addPayment,
                submitPayment,
            };
        },
    }).mount('#invoice-view-app');
})();

// Socket listener for invoice status updates
(function() {
    console.log("invoice socket script init", Date.now());

    if (window.__invoiceSocketInitialized) {
    console.warn("invoice socket script already initialized");
    return;
    }
    window.__invoiceSocketInitialized = true;

    if (typeof io === 'undefined') {
        console.warn('Socket.IO no disponible en esta vista.');
        return;
    }

    var wsInput = document.getElementById('ws_nombre_socket');
    var appUrlSocketInput = document.getElementById('APP_URL_ORIGINAL_SOCKET');
    var dbInput = document.getElementById('DB_NAME');

    if (!wsInput || !appUrlSocketInput || !dbInput) {
        console.warn('Socket config faltante en el DOM.');
        return;
    }

    var WS_NOMBRE_SOCKET        = wsInput.value;
    var APP_URL_ORIGINAL_SOCKET = appUrlSocketInput.value;
    var GLOBAL_DATABASE    = dbInput.value;

    if (!window.invoiceSocket) {
        window.invoiceSocket = io(APP_URL_ORIGINAL_SOCKET, {
            path: "/" + WS_NOMBRE_SOCKET + "/socket.io",
            transports: ["polling"]
        });
    }

    const socket = window.invoiceSocket;

    const joinRoom = () => socket.emit("join-chat-room", GLOBAL_DATABASE);

    socket.off("connect", joinRoom);
    socket.on("connect", joinRoom);
    if (socket.connected) joinRoom();

    socket.off("disconnect");
    socket.on("disconnect", () => {
        console.log("Desconectado del servidor de Socket.IO");
    });

    const evInvoiceStatus = "invoices-status";
    console.log("Escuchando:", evInvoiceStatus);

    socket.off(evInvoiceStatus);
    socket.on(evInvoiceStatus, (data) => {
        if (!window.ShowMessage) return;

        const paymentId = window.paymentId ? String(window.paymentId) : null;
        const incomingPaymentId = data?.payment_id ? String(data.payment_id) : null;

        if (paymentId && !incomingPaymentId) return;
        if (paymentId && (incomingPaymentId !== paymentId)) return;

        window.ShowMessage = false;
        window.paymentId = null;

        $(".bloqueo_v2, .bloqueo_v3").attr("hidden", true);

        const statusRaw = data && data.status;
        const ok =
            statusRaw === true ||
            statusRaw === "true" ||
            statusRaw === "succeeded" ||
            statusRaw === "success" ||
            statusRaw === "paid" ||
            statusRaw === "completed";

        Swal.fire({
            title: ok ? "¡Payment successful!" : "¡Transaction rejected!",
            text: ok ? "The payment was successful" : "An error occurred",
            icon: ok ? "success" : "error",
            confirmButtonText: "OK",
            allowOutsideClick: false,
            allowEscapeKey: false
        }).then(r => r.isConfirmed && location.reload());

    });

})();
</script>
{/block}
