<?php

use Bramus\Router\Router;
use App\Middleware\AuthMiddleware;
use App\Middleware\PlaidAuthMiddleware;

/*error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);*/

$router = new Router();
$router->setNamespace('\App\Controllers');

$router->before('GET|POST|PUT|DELETE', '/api/plaid/.*', function () {
    PlaidAuthMiddleware::ensureAuthenticatedClient();
});

$router->before('GET|POST|PUT|DELETE', '/api/.*', function () {
    $path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

    if (preg_match('#/api/plaid/.*$#', $path)) {
        return;
    }

    if (preg_match('#/api/dashboard/sales$#', $path)) {
        return;
    }

    if (preg_match('#/api/pbx/connection/status$#', $path)) {
        return;
    }

    if (preg_match('#/api/pbx/authenticate$#', $path)) {
        return;
    }

    if (preg_match('#/api/pbx/cdr$#', $path)) {
        return;
    }

    if (preg_match('#/api/pbx/cdr/sync$#', $path)) {
        return;
    }

    if (preg_match('#/api/auth/password/recover$#', $path)) {
        return;
    }

    if (preg_match('#/api/webhooks/stripe/invoice-status$#', $path)) {
        return;
    }

    if (preg_match('#/api/webhooks/stripe$#', $path)) {
        return;
    }
    
    if (preg_match('#/api/contacts/payment-methods$#', $path)) {
        return;
    }
    
    if (preg_match('#/api/contacts/summary/.*$#', $path)) {
        return;
    }
    
    AuthMiddleware::ensureAuthenticated();
});

// normalizar trailing slash
$path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
if ($path !== '/' && substr($path, -1) === '/') {
    $newPath = rtrim($path, '/');
    $query = $_SERVER['QUERY_STRING'] ? '?' . $_SERVER['QUERY_STRING'] : '';
    header("Location: $newPath$query", true, 301);
    exit;
}

// hojas
require __DIR__ . '/Routes/api.php';
//require __DIR__ . '/Routes/web.php';

// 404
$router->set404(function () {});
$router->run();
