<?php
/*
|--------------------------------------------------------------------------
| Controller
|--------------------------------------------------------------------------
|
*/

_auth();
$ui->assign('selected_navigation', 'util');
$ui->assign('_title', $_L['Password Manager'] . '- ' . $config['CompanyName']);
$action = route(1, 'manage');
$user = User::_info();
$ui->assign('user', $user);

$ui->assign('base_datos_para_socket', DB_NAME);
$ui->assign('config_whatsapp_other_id_para_socket', empty($user["config_whatsapp_other_id"]) == true ? "No_existe" : $user["config_whatsapp_other_id"] );
$ui->assign('url_ir_chat_empleado', U . "social/social-chat-employee");
$ui->assign('url_ir_chat_admin', U . "social/social-chat");

$ui->assign('url_ir_chat_crm', U . "social/chat-crm");
$ui->assign('url_base_plantilla_admintpl', U);
$ui->assign('APP_URL_ORIGINAL_SOCKET', APP_URL_ORIGINAL_SOCKET);
$ui->assign('url_setting_CRM_Parnerts_prepared', url_setting_CRM_Parnerts_prepared);
$ui->assign('db_crm_administrative', getDBCRMAdministrative());
$ui->assign('url_origen', U);

$ruta_segundaria = route(1);
$armado_ruta = "";
$ui->assign('ws_nombre_socket', ws_nombre_socket);
if(empty($ruta_segundaria) == true )
{
    $armado_ruta = route(0);
}else{
    $armado_ruta = route(0) . "/" . route(1);
}

//$ui->assign('sin_ruta', $armado_ruta);
$ui->assign('sin_ruta', _get('ng'));



if(empty($_SESSION['menu_categorias_user']) == false)
{
    $ui->assign('menu_categorias_user', $_SESSION['menu_categorias_user']);
}

if (!has_access($user->roleid, 'password_manager')) {
    permissionDenied();
}

switch ($action) {
    case 'manage':
        if (has_access($user->roleid, 'password_manager', 'all_data')) {
            $passwords = PasswordManager::all();
        } else {
            $passwords = PasswordManager::where('admin_id', $user->id)->get();
        }

        $clients = Contact::select('id', 'account')->get();

        $cls = [];

        foreach ($clients as $cl) {
            $cls[$cl->id] = $cl->account;
        }

        view('password_manager', [
            'passwords' => $passwords,
            'cls' => $cls,
        ]);

        break;

    case 'modal_password':
        $id = route(2);

        $edit = false;

        if ($id == '') {
            $password = [
                'id' => '',
                'client_id' => '',
                'name' => '',
                'url' => '',
                'username' => '',
                'password' => '',
                'notes' => '',
            ];
        } else {
            $id = str_replace('pe_', '', $id);

            $p = PasswordManager::find($id);

            if (
                !has_access($user->roleid, 'password_manager', 'all_data') &&
                $p->admin_id != $user->id
            ) {
                permissionDenied();
            }

            if ($p) {
                $edit = true;
                $password = [
                    'id' => $p->id,
                    'client_id' => $p->client_id,
                    'name' => $p->name,
                    'url' => $p->url,
                    'username' => $p->username,
                    'password' => $p->password,
                    'notes' => $p->notes,
                ];
            }
        }

        $c = Contact::all();

        view('modal_password', [
            'edit' => $edit,
            'password' => $password,
            'c' => $c,
        ]);

        break;

    case 'save':
        $id = _post('password_id');

        $name = _post('name');

        if ($name == '') {
            exit($_L['name_error']);
        }

        if ($id != '') {
            $p = PasswordManager::find($id);
            if ($p) {
                $p->client_id = _post('client_id');
                $p->name = _post('name');
                $p->url = _post('url');
                $p->username = _post('username');
                $p->password = _post('password');
                $p->notes = _post('notes');
                $p->save();
                $id = $p->id;
            }
        } else {
            $p = new PasswordManager();
            $p->client_id = _post('client_id');
            $p->name = _post('name');
            $p->url = _post('url');
            $p->username = _post('username');
            $p->password = _post('password');
            $p->notes = _post('notes');
            $p->save();
            $id = $p->id;
        }

        echo $id;

        break;

    case 'modal_view_password':
        $id = route(2);
        $id = str_replace('v_', '', $id);

        $p = PasswordManager::find($id);

        if ($p) {
            if (
                !has_access($user->roleid, 'password_manager', 'all_data') &&
                $p->admin_id != $user->id
            ) {
                permissionDenied();
            }
            view('modal_view_password', [
                'p' => $p,
            ]);
        }

        break;

    default:
        echo 'action not defined';
}
