<?php
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");
$method = $_SERVER['REQUEST_METHOD'];
if($method == "OPTIONS") {
    die();
}


//tipos de mensajes y su peso 
//https://developers.facebook.com/docs/whatsapp/on-premises/reference/media#upload


ini_set('memory_limit', '-1');

set_time_limit(56000);

_auth();
$ui->assign('selected_navigation', 'chat_social');
$ui->assign('_title', 'Social Chat' . ' - ' . $config['CompanyName']);
$ui->assign('_st', 'SOCIAL CHAT');
$action = $routes['1'];

$user = User::_info();
$ui->assign('user', $user);

$ui->assign('base_datos_para_socket', DB_NAME);
$ui->assign('config_whatsapp_other_id_para_socket', empty($user["config_whatsapp_other_id"]) == true ? "No_existe" : $user["config_whatsapp_other_id"] );
$ui->assign('url_ir_chat_empleado', U . "social/social-chat-employee");
$ui->assign('url_ir_chat_admin', U . "social/social-chat");

$ui->assign('url_ir_chat_crm', U . "social/chat-crm");
$ui->assign('url_base_plantilla_admintpl', U); 
$ui->assign('APP_URL_ORIGINAL_SOCKET', APP_URL_ORIGINAL_SOCKET);
$ui->assign('ws_nombre_socket', ws_nombre_socket);
$ruta_segundaria = route(1);
$armado_ruta = "";

if(empty($ruta_segundaria) == true )
{
    $armado_ruta = route(0);
}else{
    $armado_ruta = route(0) . "/" . route(1);
}

$ui->assign('sin_ruta', $armado_ruta);

if(empty($_SESSION['menu_categorias_user']) == false)
{
    $ui->assign('menu_categorias_user', $_SESSION['menu_categorias_user']);
}

use ElephantIO\Client;
use ElephantIO\Engine\SocketIO\Version4X;
use Carbon\Carbon;
use SendGrid\Mail\Mail;

//$token_acceso = "EAADxTGyoEmwBO9ypxfXW0bge2Da8Fc0SbTEThvB3kwxjTjg8enxCHh0tqiPUB7fhZCfulZCm7eevUNLV0ZAVPeLFO35ZAF4bBigWnKNLUNTYqpwMdD1QzRu7vIegrkIaZAZA3cCZAvj2x5EpG0Eo78HSyATmySTEVmKTZCTAuf0zVZA5X97OejJa4bmRHlWrQQJtD";
//$version_api_whatapp = "v19.0";

$data = request()->all();
switch ($action) {

    //r2(U . 'sms/init/drivers/', 's', 'Deleted Successfully');

    case 'social-chat':

        $user = User::_info();
        $ui->assign('user', $user);

        if($user["roleid"] == "3")
        {
            echo "not fount"; exit;
        }

        //print_r(json_encode($user)); exit;

        $ui->assign('url_base', U);

        $path_img = APP_URL . "/ui/theme/default/img/";
        $ui->assign('path_img', $path_img);

        $img = "";
        $ruta_img = "";

        if(empty($user["img"]) == true)
        {
            $img = $path_img . "perfil.jpg";
            $ruta_img = $path_img . "perfil.jpg";
        }else{
            $img      = APP_URL . "/" . $user["img"];
            $ruta_img = APP_URL . "/" ;
        }

        $ui->assign('img_nombre_perfil', $user["img"]);
        $ui->assign('ruta_img', $ruta_img);
        $ui->assign('ruta_proyecto',  APP_URL . "/");

        $ui->assign('imagen_perfil', $img);
        $ui->assign('fullname', $user["fullname"]);
        $ui->assign('username', $user["username"]);
        $ui->assign('id_user', $user["id"]);
        $ui->assign('DB_NAME', DB_NAME);

        $ui->assign('countries', Countries::all($config['country'])); // may add this $config['country_code']

        $fs = ORM::for_table('crm_customfields')
        ->where('ctype', 'crm')
        ->order_by_asc('id')
        ->find_many();
        $ui->assign('fs', $fs);

        // find all companies

        $companies = ORM::for_table('sys_companies')
        ->select('id')
        ->select('company_name')
        ->order_by_desc('id')
        ->find_array();

        $ui->assign('companies', $companies);

        // find all groups

        $gs = ORM::for_table('crm_groups')
        ->order_by_asc('sorder')
        ->find_array();

        $ui->assign('gs', $gs);

        $g_selected_id = route(3);
        $c_selected_id = route(4);

        if ($g_selected_id !== '' && $g_selected_id !== '0') {
            $ui->assign('g_selected_id', $g_selected_id);
        } else {
            $ui->assign('g_selected_id', '');
        }

        if ($c_selected_id !== '' && $c_selected_id !== '0') {
            $ui->assign('c_selected_id', $c_selected_id);
        } else {
            $ui->assign('c_selected_id', '');
        }
        $tags = Tags::get_all('Contacts');
        $ui->assign('tags', $tags);

        $currencies = Currency::all();

        //echo json_encode($currencies); exit;

        $ui->assign('currencies', $currencies);

        $owners = getOwners($user);
        
         

        $ui->assign('APP_URL_ORIGINAL_SOCKET', APP_URL_ORIGINAL_SOCKET);
        
        view('social_chat_test', [
            'contact_type' => $contact_type,
            'title_type' => $title_type,
            'db_type' => $db_type,
            'predict_customer_number' => $predict_customer_number,
            'owners' => $owners,
        ]);
    break;

    case 'social-chat-employee':

        $user = User::_info();
        $ui->assign('user', $user);

        if($user["roleid"] == "0" || $user["roleid"] == "1")
        {
            echo "not fount"; exit;
        }

        //print_r(json_encode($user)); exit;

        $ui->assign('url_base', U);

        $path_img = APP_URL . "/ui/theme/default/img/";
        $ui->assign('path_img', $path_img);

        $img = "";

        if(empty($user["img"]) == true)
        {
            $img = $path_img . "perfil.jpg";
        }else{
            $img = APP_URL . "/" . $user["img"];
        }

        $img = "";
        $ruta_img = "";

        if(empty($user["img"]) == true)
        {
            $img = $path_img . "perfil.jpg";
            $ruta_img = $path_img . "perfil.jpg";
        }else{
            $img      = APP_URL . "/" . $user["img"];
            $ruta_img = APP_URL . "/" ;
        }

        $ui->assign('img_nombre_perfil', $user["img"]);
        $ui->assign('ruta_img', $ruta_img);
        $ui->assign('ruta_proyecto',  APP_URL . "/");

        $ui->assign('imagen_perfil', $img);
        $ui->assign('fullname', $user["fullname"]);
        $ui->assign('username', $user["username"]);
        $ui->assign('id_user', $user["id"]);
        $ui->assign('DB_NAME', DB_NAME);

 
        $ui->assign('APP_URL_ORIGINAL_SOCKET', APP_URL_ORIGINAL_SOCKET);


        $ui->assign('countries', Countries::all($config['country'])); // may add this $config['country_code']

        $fs = ORM::for_table('crm_customfields')
        ->where('ctype', 'crm')
        ->order_by_asc('id')
        ->find_many();
        $ui->assign('fs', $fs);

        // find all companies

        $companies = ORM::for_table('sys_companies')
        ->select('id')
        ->select('company_name')
        ->order_by_desc('id')
        ->find_array();

        $ui->assign('companies', $companies);

        // find all groups

        $gs = ORM::for_table('crm_groups')
        ->order_by_asc('sorder')
        ->find_array();

        $ui->assign('gs', $gs);

        $g_selected_id = route(3);
        $c_selected_id = route(4);

        if ($g_selected_id !== '' && $g_selected_id !== '0') {
            $ui->assign('g_selected_id', $g_selected_id);
        } else {
            $ui->assign('g_selected_id', '');
        }

        if ($c_selected_id !== '' && $c_selected_id !== '0') {
            $ui->assign('c_selected_id', $c_selected_id);
        } else {
            $ui->assign('c_selected_id', '');
        }
        $tags = Tags::get_all('Contacts');
        $ui->assign('tags', $tags);

        $currencies = Currency::all();

        //echo json_encode($currencies); exit;

        $ui->assign('currencies', $currencies);

        $owners = getOwners($user);
        
        view('social_chat_empleado_v1',[
            'contact_type' => $contact_type,
            'title_type' => $title_type,
            'db_type' => $db_type,
            'predict_customer_number' => $predict_customer_number,
            'owners' => $owners,
        ]);
    break;

    case 'chat-crm':

        $user = User::_info();
        $ui->assign('user', $user);
 
        //print_r(json_encode($user)); exit;

        $ui->assign('url_base', U);

        $path_img = APP_URL . "/ui/theme/default/img/";
        $ui->assign('path_img', $path_img);

        $img = "";
        $ruta_img = "";

        if(empty($user["img"]) == true)
        {
            $img = $path_img . "perfil.jpg";
            $ruta_img = $path_img . "perfil.jpg";
        }else{
            $img      = APP_URL . "/" . $user["img"];
            $ruta_img = APP_URL . "/" ;
        }
        

        $ui->assign('img_nombre_perfil', $user["img"]);
        $ui->assign('ruta_img', $ruta_img);
        $ui->assign('imagen_perfil', $img);
        $ui->assign('fullname', $user["fullname"]);
        $ui->assign('username', $user["username"]);
        $ui->assign('id_user', $user["id"]);
        $ui->assign('DB_NAME', DB_NAME);
        $ui->assign('APP_URL', APP_URL);

        
        view('chat_crm');
    break;
 
 
    case 'enviar-mensaje-texto':

 
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $messageBody                    = $informacion_front['mensaje'];
        $to                             = $informacion_front['to'];
        $from                           = $informacion_front['from'];
        $phone_number_id                = $informacion_front['phone_number_id'];

        $tipo_usuario                   = $informacion_front['tipo_usuario'];
        $staff_id                       = $informacion_front['staff_id'];

        $token_acceso                   = $informacion_front['token_acceso'];
        $version_api_whatapp            = $informacion_front['version_api_whatapp'];
        $configuracion_whatsapp_sms_id  = $informacion_front['configuracion_whatsapp_sms_id'];

        if(empty($configuracion_whatsapp_sms_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp settings / sms id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($token_acceso) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp Token is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($version_api_whatapp) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp Api Version is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        $url = "https://graph.facebook.com/$version_api_whatapp/$phone_number_id/messages";


        if(empty($phone_number_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required: Phone number identifier",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($from) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required Phone number, created in developer Facebook",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($to) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required a phone to send a message",
            );
            print_r(json_encode( $response)) ; exit;
        }

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $marcar_leidos = $mysqli->query("SELECT wam_id FROM chat_social WHERE `status`='delivered' AND `from`='$from' AND `to`='$to' AND esContacto=1 AND tipo_producto='whatsapp' AND config_whatsapp_other_id='$configuracion_whatsapp_sms_id' order by id desc")->fetch_all(MYSQLI_ASSOC) ;

        $existeMensajesPendientes = 0;

        if($tipo_usuario != "admin")
        {

            if(empty($staff_id) == true)
            {
                $response = array(
                    "type" => "error",
                    "message" => "Staff is required",
                    "data" => [],
                );
                print_r(json_encode( $response)) ; exit;
            }

            //$existe = $mysqli->query("SELECT * from chat_number WHERE `number`='$to' AND staff_id='$staff_id'")->fetch_all(MYSQLI_ASSOC) ?? [];
            //$existe = $mysqli->query("SELECT * FROM chat_number WHERE `number`='$to' AND staff_id='$staff_id'");
            $existe = $mysqli->query("SELECT COUNT(*) AS total FROM chat_number WHERE `number`='$to' AND staff_id='$staff_id'")->fetch_assoc();

            if($existe["total"] == 0)
            {
                $response = array(
                    "type" => "error",
                    "data" => "¡You are not assigned to send a message to this number!",
                );
        
                print_r(json_encode($response)); exit;
            }

            $chat_number = $mysqli->query("SELECT id FROM `chat_number` WHERE staff_id='$staff_id' AND `number` != '$to'")->fetch_all(MYSQLI_ASSOC) ;
            $ids = array_column($chat_number, 'id');
            $ids_concatenados = implode(',', $ids);

            if(empty($ids_concatenados) != true)
            {
                $res         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `status`='delivered' AND esContacto=1 AND chat_number_id IN ($ids_concatenados) ");
                $row         = $res->fetch_assoc(); 
                $existeMensajesPendientes          = $row['total_mensajes'] + 0;
            }else{
                $existeMensajesPendientes = 0;
            }

            //print_r(json_encode($ids_concatenados)); exit;
            //exit;

        }else{
            //aqui si es admin
            $chat_number = $mysqli->query("SELECT id FROM `chat_number` WHERE  `number` = '$to' AND config_whatsapp_other_id ='$configuracion_whatsapp_sms_id' AND staff_id='$staff_id'")->fetch_all(MYSQLI_ASSOC) ;
            $ids = array_column($chat_number, 'id');
            $ids_concatenados = implode(',', $ids);

            if(empty($ids_concatenados) != true)
            {
                $res         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `status`='delivered' AND esContacto=1  AND chat_number_id NOT IN ($ids_concatenados)  ");
                $row         = $res->fetch_assoc(); 
                $existeMensajesPendientes  = $row['total_mensajes'] + 0;
            }else{
                $existeMensajesPendientes = 0;
            }

            //print_r(json_encode($existeMensajesPendientes)); exit;
            //exit;
        }

        //echo "aqui abajo hay exit; " . $existeMensajesPendientes;
        //exit;

        $validacion_configuracion = $mysqli->query("SELECT id, zona_horaria FROM `config_whatsapp_other` WHERE id='$configuracion_whatsapp_sms_id' AND `status`=1")->fetch_assoc() ;

        if(empty($validacion_configuracion) == true)
        {
            $salida = array(
                "type" => "error",
                "message" => "WhatsApp/SMS settings not found or inactive",
                "wam_id" => null,
            );
            $mysqli->close();
            print_r(json_encode($salida)); 
            exit;
        }

        $zona_horaria = $validacion_configuracion["zona_horaria"];

        $data = array(
            "messaging_product" => "whatsapp",    
            "recipient_type" => "individual",
            "to" => $to,
            "type" => "text",
            "text" => array(
                "body" => $messageBody
            )
        );

        $jsonData = json_encode($data);

        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $jsonData,
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token_acceso,
        ),
        ));

        $response = curl_exec($curl);

        $responseData = json_decode($response, true);
        $messageId = $responseData['messages'][0]['id'];

        curl_close($curl);

        if(isset($messageId) == false)
        {
            $salida = array(
                "type" => "error",
                "message" => $responseData['error']["message"],
                "wam_id" => null,
            );
            $mysqli->close();
            print_r(json_encode($salida)); 
            exit;
        }

                                                          
        //$mysqli->begin_transaction();

        try {
            
            /* //se crea el numero en caso de que el numero no exista
            $sql = "INSERT INTO chat_number (`number`)
                SELECT '$to' 
                FROM DUAL
                WHERE NOT EXISTS (
                    SELECT 1
                    FROM chat_number
                    WHERE `number` = '$to'
                );"; */
            
            //se crea el numero en caso de que no exista
            $sql = "INSERT INTO chat_number (`number`, config_whatsapp_other_id)
                    SELECT '$to', '$configuracion_whatsapp_sms_id'
                    FROM DUAL
                    WHERE NOT EXISTS (
                        SELECT 1
                        FROM chat_number
                        WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id
                    );";


            $mysqli->query($sql);

            $id_chat_number = null;

            // Comprobar si se insertó una fila nueva
            if ($mysqli->affected_rows > 0) {
                $id_chat_number = $mysqli->insert_id;
            } else {
                $sql = "SELECT id FROM chat_number WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id";
                $result = $mysqli->query($sql);

                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    $id_chat_number = $row['id'];
                }  
            }

            if(empty($zona_horaria) == true)
            {
                $fechaActual   = Carbon::now();
            }else{
                $fechaActual   = Carbon::now()->setTimezone($zona_horaria);
            }

            // Construcción de la consulta SQL
            $sql = "INSERT INTO chat_social (
                wam_id, 
                chat_number_id,
                `from`, 
                `to`, 
                mensaje, 
                `url`, 
                tipo_mensaje, 
                esContacto, 
                error_codigo, 
                error_mensaje, 
                phone_number_id, 
                tipo_producto,
                fecha_creacion, 
                `status`,
                config_whatsapp_other_id,
                user_id
            ) VALUES (
                '$messageId', 
                '$id_chat_number',
                '$from', 
                '$to', 
                '$messageBody', 
                '', 
                'text', 
                0, 
                '', 
                '', 
                '$phone_number_id', 
                'whatsapp',
                '$fechaActual', 
                'sent',
                $configuracion_whatsapp_sms_id,
                $staff_id
            )";

            //$staff_id

            $mysqli->query($sql);

            $ultimoId = $mysqli->insert_id;

            /* if(count($marcar_leidos) != 0)
            {
                // ID del mensaje wam_id
                $messageId = $marcar_leidos[0]["wam_id"];

                if($messageId != null)
                {   
                    marcar_leidos($messageId, $url, $token_acceso, $mysqli, $from, $to);
                }

            } */

            $salida = array(
                "type"                          => "success",
                "message"                       => "Message sent",
                "id_chat_social"                => $ultimoId,
                "wam_id"                        => $messageId,
                "mensajes_no_leidos"            => count($marcar_leidos),                 
                "mensajes_no_leidos_pendiente"  => $existeMensajesPendientes,  
                "fecha_creacion"                => $fechaActual->format('d-m-Y h:i A'),  
                "fecha_creacion_"                => $fechaActual,  

            );
             
            //$mysqli->commit();

            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($salida)); exit;
           
        } catch (Exception $e) {
             
            $response = array(
                "type" => "error",
                "message" => "Insert failed: (" . $mysqli->errno . ") " . $mysqli->error,
                "details" =>  $e->getMessage()
            );

            //$mysqli->rollback();

            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($response)); exit;
        }

 
    break;

    case 'enviar-mensaje-imagen':
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $logotipo                       = $informacion_front['imagen'];
        $caption                        = $informacion_front['caption'];
        $to                             = $informacion_front['to'];
        $from                           = $informacion_front['from'];
        $phone_number_id                = $informacion_front['phone_number_id'];

        $tipo_usuario                   = $informacion_front['tipo_usuario'];
        $staff_id                       = $informacion_front['staff_id'];

        $token_acceso                   = $informacion_front['token_acceso'];
        $version_api_whatapp            = $informacion_front['version_api_whatapp'];
        $configuracion_whatsapp_sms_id  = $informacion_front['configuracion_whatsapp_sms_id'];

        if(empty($configuracion_whatsapp_sms_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp settings / sms id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($token_acceso) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp Token is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($version_api_whatapp) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp Api Version is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($logotipo) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Image is required",
            );

            print_r(json_encode( $response)) ; exit;
        }

        if(empty($phone_number_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required: Phone number identifier",
            );
            print_r(json_encode( $response)) ; exit;
        }

        $url = "https://graph.facebook.com/$version_api_whatapp/$phone_number_id/messages";

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $existeMensajesPendientes = 0;

        if($tipo_usuario != "admin")
        {

            if(empty($staff_id) == true)
            {
                $response = array(
                    "type" => "error",
                    "message" => "Staff is required",
                    "data" => [],
                );
                print_r(json_encode( $response)) ; exit;
            }

            /* $existe = $mysqli->query("SELECT * from chat_number WHERE `number`='$to' AND staff_id='$staff_id'")->fetch_all(MYSQLI_ASSOC) ?? [];

            if(count($existe) == 0)
            {
                $response = array(
                    "type" => "error",
                    "data" => "¡You are not assigned to send a message to this number!",
                );
        
                print_r(json_encode($response)); exit;
            } */

            $existe = $mysqli->query("SELECT COUNT(*) AS total FROM chat_number WHERE `number`='$to' AND staff_id='$staff_id'")->fetch_assoc();

            if($existe["total"] == 0)
            {
                $response = array(
                    "type" => "error",
                    "data" => "¡You are not assigned to send a message to this number!",
                );
        
                print_r(json_encode($response)); exit;
            }

            $chat_number = $mysqli->query("SELECT id FROM `chat_number` WHERE staff_id='$staff_id' AND `number` != '$to'")->fetch_all(MYSQLI_ASSOC) ;
            $ids = array_column($chat_number, 'id');
            $ids_concatenados = implode(',', $ids);

            if(empty($ids_concatenados) != true)
            {
                $res         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `status`='delivered' AND esContacto=1 AND chat_number_id IN ($ids_concatenados) ");
                $row         = $res->fetch_assoc(); 
                $existeMensajesPendientes          = $row['total_mensajes'] + 0;
            }else{
                $existeMensajesPendientes = 0;
            }


        }else{
            //aqui si es admin
            $chat_number = $mysqli->query("SELECT id FROM `chat_number` WHERE  `number` = '$to' AND config_whatsapp_other_id ='$configuracion_whatsapp_sms_id' AND staff_id='$staff_id'")->fetch_all(MYSQLI_ASSOC) ;
            $ids = array_column($chat_number, 'id');
            $ids_concatenados = implode(',', $ids);

            if(empty($ids_concatenados) != true)
            {
                $res         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `status`='delivered' AND esContacto=1  AND chat_number_id NOT IN ($ids_concatenados)  ");
                $row         = $res->fetch_assoc(); 
                $existeMensajesPendientes  = $row['total_mensajes'] + 0;
            }else{
                $existeMensajesPendientes = 0;
            }

            //print_r(json_encode($existeMensajesPendientes)); exit;
            //exit;
        }

        $validacion_configuracion = $mysqli->query("SELECT id, zona_horaria FROM `config_whatsapp_other` WHERE id='$configuracion_whatsapp_sms_id' AND `status`=1")->fetch_assoc() ;

        if(empty($validacion_configuracion) == true)
        {
            $salida = array(
                "type" => "error",
                "message" => "WhatsApp/SMS settings not found or inactive",
                "wam_id" => null,
            );
            $mysqli->close();
            print_r(json_encode($salida)); 
            exit;
        }

        $zona_horaria = $validacion_configuracion["zona_horaria"];

        $ruta_root = $_SERVER['DOCUMENT_ROOT'];   

        // Verificar si la ruta tiene una barra al final
        if (substr($ruta_root, -1) === '/') {
            // Si hay una barra al final, eliminarla
            $ruta_root = rtrim($ruta_root, '/');
        }

        $tipo_proyecto_produccion = APP_DIRECTORIO;
 

        $basePath = $ruta_root . "/$tipo_proyecto_produccion/storage/whatsapp/imagen/";
        $path_db = "/storage/whatsapp/imagen/";
        $numero_aleatorio = rand(1, 100000); 

        if(!file_exists($basePath))
        {
           mkdir($basePath, 0777, true);
           createHtmlFile($basePath."/index.html");
        } 

        $formato = date('Y-m-d-H-i-s');
                    
        $idImagen = $formato."_".$numero_aleatorio . "_from" . $from . "_to" . $to . '_enviado.png';
        
        $folderPath = $basePath;
        $image_base64 = base64_decode($logotipo);
        $file = $folderPath . $idImagen ;
        //file_put_contents($file, $image_base64);

        $imagen = imagecreatefromstring($image_base64);

        if ($imagen !== false)
        {
            $anchoOriginal = imagesx($imagen);
            $altoOriginal  = imagesy($imagen);

            $creado = DimensionesImagen($imagen,500,500,$anchoOriginal, $altoOriginal, $file);

            if($creado == false)
            {
                file_put_contents($file, $image_base64);
            }

        }else{
            file_put_contents($file, $image_base64);
        }

        //marcar como leidos
        $marcar_leidos = $mysqli->query("SELECT wam_id FROM chat_social WHERE `status`='delivered' AND `from`='$from' AND `to`='$to' AND esContacto=1 AND tipo_producto='whatsapp' AND config_whatsapp_other_id='$configuracion_whatsapp_sms_id' order by id desc")->fetch_all(MYSQLI_ASSOC) ;

        $url_final = APP_URL . $path_db . $idImagen;
        
        $data = array(
            "messaging_product" => "whatsapp",
            "recipient_type" => "individual",
            "to" => $to,
            "type" => "image",
            "image" => array(
                "link" => $url_final,
                "caption" => $caption
            )
        );
        
        $jsonData = json_encode($data);

        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $jsonData,
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token_acceso,
        ),
        ));

        $response = curl_exec($curl);

        $responseData = json_decode($response, true);
        $messageId = $responseData['messages'][0]['id'];

        curl_close($curl);

        if(isset($messageId) == false)
        {
            $salida = array(
                "type" => "error",
                "message" => $responseData['error']["message"],
                "wam_id" => null,
            );
            $mysqli->close();
            print_r(json_encode($salida)); 
            exit;
        }
     
        /* if(count($marcar_leidos) != 0)
        {
            // ID del mensaje wam_id
            $messageId = $marcar_leidos[0]["wam_id"];

            if($messageId != null)
            {   
                marcar_leidos($messageId, $url, $token_acceso, $mysqli, $from, $to);
            }
        } */

        //$mysqli->begin_transaction();

        try {

            //se crea un numero en caso de que no exista
            $sql = "INSERT INTO chat_number (`number`, config_whatsapp_other_id)
                    SELECT '$to', '$configuracion_whatsapp_sms_id'
                    FROM DUAL
                    WHERE NOT EXISTS (
                        SELECT 1
                        FROM chat_number
                        WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id
                    );";

            $mysqli->query($sql);
   
            $id_chat_number = null;

            // Comprobar si se insertó una fila nueva
            if ($mysqli->affected_rows > 0) {
                $id_chat_number = $mysqli->insert_id;
            } else {
                //$sql = "SELECT id FROM chat_number WHERE `number` = '$to'";
                $sql = "SELECT id FROM chat_number WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id";

                $result = $mysqli->query($sql);

                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    $id_chat_number = $row['id'];
                }  
            }

            if(empty($zona_horaria) == true)
            {
                $fechaActual   = Carbon::now();
            }else{
                $fechaActual   = Carbon::now()->setTimezone($zona_horaria);
            }

            // Construcción de la consulta SQL
            $sql = "INSERT INTO chat_social (
                wam_id, 
                chat_number_id, 
                `from`, 
                `to`, 
                mensaje, 
                `url`, 
                tipo_mensaje, 
                esContacto, 
                error_codigo, 
                error_mensaje, 
                phone_number_id,
                tipo_producto, 
                fecha_creacion, 
                `status`,
                config_whatsapp_other_id,
                user_id
            ) VALUES (
                '$messageId', 
                '$id_chat_number', 
                '$from', 
                '$to', 
                '$caption', 
                '$url_final', 
                'image', 
                0, 
                '', 
                '', 
                '$phone_number_id', 
                'whatsapp',
                '$fechaActual', 
                'sent',
                $configuracion_whatsapp_sms_id,
                $staff_id
            )";
 
            $mysqli->query($sql);

            $ultimoId = $mysqli->insert_id;

            //$mysqli->commit();
             
            $salida = array(
                "type"                => "success",
                "message"             => "Message sent",
                "id_chat_social"      => $ultimoId,
                "wam_id"              => $messageId,
                "url"                 => $url_final,
                "mensajes_no_leidos"  => count($marcar_leidos),
                "mensajes_no_leidos_pendiente"  => $existeMensajesPendientes,
                "fecha_creacion"                => $fechaActual->format('d-m-Y h:i A'),  
            );

            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($salida)); exit;
           
        } catch (Exception $e) {
           
            $response = array(
                "type" => "error",
                "message" => "Insert failed: (" . $mysqli->errno . ") " . $mysqli->error,
                "details" =>  $e->getMessage(),
                "wam_id" => null,
                "url"     => $url_final,
                "mensajes_no_leidos"  => 0,
            );

            //$mysqli->rollback();

            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($response)); exit;
        }

 
    break;

    case 'tener-numeros':

        $parametro                           = $routes['2'];
        $canal                               = $routes['3'];
        $configuracion_whatsapp_other_id     = $routes['4'];


        if(empty($configuracion_whatsapp_other_id) == true){
            $response = array(
                "type" => "success",
                "mensaje" => "Select configuracion channel",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($canal) == true){
            $response = array(
                "type" => "success",
                "mensaje" => "Select type channel",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($parametro) == true){
            $response = array(
                "type" => "success",
                "mensaje" => "Select type user. Admin o Employees",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }
  
        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $result_info_configuracion             = $mysqli->query("SELECT * FROM `config_whatsapp_other` WHERE id='$configuracion_whatsapp_other_id' AND `status`=1");
        $row_informacion_configuracion         = $result_info_configuracion->fetch_assoc();

        if($row_informacion_configuracion == false )
        {
            $response = array(
                "type" => "error",
                "data" => [],
            );

            $mysqli->close();
            print_r(json_encode($response)) ; exit;
        }

        $zona_horaria = $row_informacion_configuracion["zona_horaria"]; 

        if(empty($zona_horaria) == true)
        {
            $fechaActual   = Carbon::now();
        }else{
            $fechaActual   = Carbon::now()->setTimezone($zona_horaria);
        }
 
        //echo json_encode($row_informacion_configuracion); exit;

        $contactos = [];

        $filtro_canal = "";

        $filtro_mensajes = "";

 
        $contactos = [];
 
        if($parametro == "admin")
        {

            //$filtro_canal .= " AND cn.config_whatsapp_other_id='$configuracion_whatsapp_other_id'";

            /* if($canal == "todos")
            {
                $contactos = $mysqli->query("SELECT 
                                            chat_number.id, 
                                            chat_number.number, 
                                            chat_number.custumer_id, 
                                            chat_number.staff_id, 
                                            chat_number.created_at, 

                                            IFNULL(crm_accounts.account, 'Desconocido') AS nombre,
                                            crm_accounts.email as email_custumers, 
                                            crm_accounts.phone as phone_custumers, 
                                            crm_accounts.company as company_custumers , 
                                            crm_accounts.address as address_custumers, 
                                            
                                            IFNULL(sys_users.fullname, 'Unassigned staff') AS fullname_staff,
                                            sys_users.username as username_staff, 
                                            sys_users.user_type as     user_type_staff, 
                                            sys_users.phonenumber as     phonenumber, 
                                            
                                            sys_users.config_whatsapp_other_id as     sys_users_config_whatsapp_other_id, 
                                            chat_number.config_whatsapp_other_id,
                                            -- fecha_ultimo_mensaje, Colocar este campo en tabla chat_number y actualizarlo cada vez que entre un mensaje nuevo, desde alli lo leeremos
                                            -- fecha_humana, fecha_creacion este esta actualemente en chat_social, trasladar este nombre a tabla chat_number y obtenerlo de alli
                                            crm_accounts.account as nombre_actual,
                                            -- nombre_whatsapp, este esta actualemente en chat_social, trasladar este nombre a tabla chat_number y obtenerlo de alli
                                            
                                            CASE 
                                                WHEN DATE( chat_number.fecha_ultimo_mensaje_recibido  ) = CURDATE() THEN
                                                    DATE_FORMAT( chat_number.fecha_ultimo_mensaje_recibido , '%h:%i %p')
                                                WHEN DATE(chat_number.fecha_ultimo_mensaje_recibido) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) THEN
                                                    'Yesterday'
                                                ELSE
                                                    DATE_FORMAT(chat_number.fecha_ultimo_mensaje_recibido, '%m/%d/%Y')
                                                END as fecha_humana,

                                            CASE 
                                                WHEN DATE( chat_number.fecha_ultimo_mensaje_enviado  ) = CURDATE() THEN
                                                    DATE_FORMAT( chat_number.fecha_ultimo_mensaje_enviado , '%h:%i %p')
                                                WHEN DATE(chat_number.fecha_ultimo_mensaje_enviado) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) THEN
                                                    'Yesterday'
                                                ELSE
                                                    DATE_FORMAT(chat_number.fecha_ultimo_mensaje_enviado, '%m/%d/%Y')
                                                END as fecha_humana_enviado,
                                            
                                            chat_number.fecha_ultimo_mensaje_recibido_unix,
                                            chat_number.fecha_ultimo_mensaje_enviado_unix,

                                            chat_number.nombre_whatsapp,
                                            
                                             
                                            (SELECT COUNT(*) 
                                                    FROM chat_social as cs_sub 
                                                    WHERE cs_sub.to = chat_number.number 
                                                    AND cs_sub.status = 'received' 
                                                    AND cs_sub.esContacto = 1 
                                                    AND cs_sub.tipo_producto = 'sms' 
                                                    AND cs_sub.config_whatsapp_other_id = chat_number.config_whatsapp_other_id
                                            ) as mensajes_no_leidos_sms, 
                                             
                                            (SELECT 
                                                    COUNT(*) 
                                                    FROM chat_social 
                                                    WHERE 
                                                        `to` = chat_number.number 
                                                        AND `status` = 'delivered' 
                                                        AND esContacto = 1 
                                                        AND tipo_producto = 'whatsapp' 
                                                        AND config_whatsapp_other_id = chat_number.config_whatsapp_other_id
                                                ) as mensajes_no_leidos_whatsapp,  
                                                 
                                            ((select mensajes_no_leidos_whatsapp) + (SELECT mensajes_no_leidos_sms )) as mensajes_no_leidos
                                             
                                             
                                        FROM chat_number AS chat_number

                                            LEFT JOIN
                                                crm_accounts on crm_accounts.id = chat_number.custumer_id

                                            LEFT JOIN
                                                sys_users on sys_users.id = chat_number.staff_id 
                                                
                                            WHERE 1 
                                                
                                                AND chat_number.config_whatsapp_other_id = '$configuracion_whatsapp_other_id'    
                                                
                                            ORDER BY chat_number.fecha_ultimo_mensaje_recibido_unix DESC; 
 
                                        ")->fetch_all(MYSQLI_ASSOC) ;
            } */

            if($canal == "whatsapp-sms")
            {
                $contactos = $mysqli->query("SELECT 
                                            chat_number.id, 
                                            chat_number.number, 
                                            chat_number.custumer_id, 
                                            chat_number.staff_id, 
                                            chat_number.created_at, 

                                            IFNULL(crm_accounts.account, 'Desconocido') AS nombre,
                                            crm_accounts.email as email_custumers, 
                                            crm_accounts.phone as phone_custumers, 
                                            crm_accounts.company as company_custumers , 
                                            crm_accounts.address as address_custumers, 
                                            
                                            IFNULL(sys_users.fullname, 'Unassigned staff') AS fullname_staff,
                                            sys_users.username as username_staff, 
                                            sys_users.user_type as     user_type_staff, 
                                            sys_users.phonenumber as     phonenumber, 
                                            
                                            sys_users.config_whatsapp_other_id as     sys_users_config_whatsapp_other_id, 
                                            chat_number.config_whatsapp_other_id,
                                            -- fecha_ultimo_mensaje, Colocar este campo en tabla chat_number y actualizarlo cada vez que entre un mensaje nuevo, desde alli lo leeremos
                                            -- fecha_humana, fecha_creacion este esta actualemente en chat_social, trasladar este nombre a tabla chat_number y obtenerlo de alli
                                            IFNULL(crm_accounts.account, 'Desconocido') AS nombre_actual,
                                            -- nombre_whatsapp, este esta actualemente en chat_social, trasladar este nombre a tabla chat_number y obtenerlo de alli
                                            
                                            CASE 
                                                WHEN DATE( chat_number.fecha_ultimo_mensaje_recibido  ) = CURDATE() THEN
                                                    DATE_FORMAT( chat_number.fecha_ultimo_mensaje_recibido , '%h:%i %p')
                                                WHEN DATE(chat_number.fecha_ultimo_mensaje_recibido) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) THEN
                                                    'Yesterday'
                                                ELSE
                                                    DATE_FORMAT(chat_number.fecha_ultimo_mensaje_recibido, '%m/%d/%Y')
                                                END as fecha_humana,

                                            CASE 
                                                WHEN DATE( chat_number.fecha_ultimo_mensaje_enviado  ) = CURDATE() THEN
                                                    DATE_FORMAT( chat_number.fecha_ultimo_mensaje_enviado , '%h:%i %p')
                                                WHEN DATE(chat_number.fecha_ultimo_mensaje_enviado) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) THEN
                                                    'Yesterday'
                                                ELSE
                                                    DATE_FORMAT(chat_number.fecha_ultimo_mensaje_enviado, '%m/%d/%Y')
                                                END as fecha_humana_enviado,
                                            
                                            chat_number.fecha_ultimo_mensaje_recibido_unix,
                                            chat_number.fecha_ultimo_mensaje_enviado_unix,

                                            chat_number.nombre_whatsapp,
                                            
                                             
                                            (SELECT COUNT(*) 
                                                    FROM chat_social as cs_sub 
                                                    WHERE cs_sub.to = chat_number.number 
                                                    AND cs_sub.status = 'received' 
                                                    AND cs_sub.esContacto = 1 
                                                    AND cs_sub.tipo_producto = 'sms' 
                                                    AND cs_sub.config_whatsapp_other_id = chat_number.config_whatsapp_other_id
                                            ) as mensajes_no_leidos_sms, 
                                             
                                            (SELECT 
                                                    COUNT(*) 
                                                    FROM chat_social 
                                                    WHERE 
                                                        `to` = chat_number.number 
                                                        AND `status` = 'delivered' 
                                                        AND esContacto = 1 
                                                        AND tipo_producto = 'whatsapp' 
                                                        AND config_whatsapp_other_id = chat_number.config_whatsapp_other_id
                                                ) as mensajes_no_leidos_whatsapp,  
                                                 
                                            ((select mensajes_no_leidos_whatsapp) + (SELECT mensajes_no_leidos_sms )) as mensajes_no_leidos
                                             
                                             
                                        FROM chat_number AS chat_number

                                            LEFT JOIN
                                                crm_accounts on crm_accounts.id = chat_number.custumer_id

                                            LEFT JOIN
                                                sys_users on sys_users.id = chat_number.staff_id 
                                                
                                            WHERE 1 
                                                
                                                AND chat_number.config_whatsapp_other_id = '$configuracion_whatsapp_other_id'    
                                                
                                            ORDER BY chat_number.fecha_ultimo_mensaje_recibido_unix DESC; 
 
                                        ")->fetch_all(MYSQLI_ASSOC) ;
            }

            if($canal == "whatsapp")
            {

                //echo "whatsapp"; exit;

                $sql = "SELECT * FROM (
                    SELECT 
                                chat_number.id, 
                                chat_number.number, 
                                chat_number.custumer_id, 
                                chat_number.staff_id, 
                                chat_number.created_at, 

                                IFNULL(crm_accounts.account, 'Desconocido') AS nombre,
                                crm_accounts.email as email_custumers, 
                                crm_accounts.phone as phone_custumers, 
                                crm_accounts.company as company_custumers , 
                                crm_accounts.address as address_custumers, 
                                
                                IFNULL(sys_users.fullname, 'Unassigned staff') AS fullname_staff,
                                sys_users.username as username_staff, 
                                sys_users.user_type as user_type_staff, 
                                sys_users.phonenumber as phonenumber, 
                                
                                sys_users.config_whatsapp_other_id as sys_users_config_whatsapp_other_id, 
                                chat_number.config_whatsapp_other_id,
                                IFNULL(crm_accounts.account, 'Desconocido') AS nombre_actual,
                                
                                CASE 
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_recibido) = CURDATE() THEN
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_recibido, '%h:%i %p')
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_recibido) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) THEN
                                        'Yesterday'
                                    ELSE
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_recibido, '%m/%d/%Y')
                                END as fecha_humana,

                                CASE 
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_enviado) = CURDATE() THEN
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_enviado, '%h:%i %p')
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_enviado) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) THEN
                                        'Yesterday'
                                    ELSE
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_enviado, '%m/%d/%Y')
                                END as fecha_humana_enviado,

                                chat_number.fecha_ultimo_mensaje_recibido_unix,
                                chat_number.fecha_ultimo_mensaje_enviado_unix,
                                
                                chat_number.nombre_whatsapp,

                                (SELECT 
                                        COUNT(*) 
                                        FROM chat_social 
                                        WHERE 
                                            `to` = chat_number.number 
                                            AND tipo_producto = 'whatsapp' 
                                            AND config_whatsapp_other_id = chat_number.config_whatsapp_other_id
                                    ) as chat_con_mensaje_whatsapp,  
                                
                                (0) as mensajes_no_leidos_sms, 
                                 
                                (SELECT 
                                        COUNT(*) 
                                        FROM chat_social 
                                        WHERE 
                                            `to` = chat_number.number 
                                            AND `status` = 'delivered' 
                                            AND esContacto = 1 
                                            AND tipo_producto = 'whatsapp' 
                                            AND config_whatsapp_other_id = chat_number.config_whatsapp_other_id
                                    ) as mensajes_no_leidos_whatsapp,  
                                     
                                    ((SELECT mensajes_no_leidos_whatsapp) + (SELECT mensajes_no_leidos_sms)) as mensajes_no_leidos

                    FROM chat_number
                    LEFT JOIN crm_accounts ON crm_accounts.id = chat_number.custumer_id
                    LEFT JOIN sys_users ON sys_users.id = chat_number.staff_id

                ) as sub
                WHERE 1 AND sub.chat_con_mensaje_whatsapp > 1 AND sub.config_whatsapp_other_id = '$configuracion_whatsapp_other_id' 
                ORDER BY sub.fecha_ultimo_mensaje_recibido_unix DESC;";

 
                $contactos = $mysqli->query($sql)->fetch_all(MYSQLI_ASSOC) ;
            }

            if($canal == "sms")
            {

                //echo "whatsapp"; exit;

                $sql = "SELECT * FROM (
                    SELECT 
                                chat_number.id, 
                                chat_number.number, 
                                chat_number.custumer_id, 
                                chat_number.staff_id, 
                                chat_number.created_at, 

                                IFNULL(crm_accounts.account, 'Desconocido') AS nombre,
                                crm_accounts.email as email_custumers, 
                                crm_accounts.phone as phone_custumers, 
                                crm_accounts.company as company_custumers , 
                                crm_accounts.address as address_custumers, 
                                
                                IFNULL(sys_users.fullname, 'Unassigned staff') AS fullname_staff,
                                sys_users.username as username_staff, 
                                sys_users.user_type as user_type_staff, 
                                sys_users.phonenumber as phonenumber, 
                                
                                sys_users.config_whatsapp_other_id as sys_users_config_whatsapp_other_id, 
                                chat_number.config_whatsapp_other_id,
                                IFNULL(crm_accounts.account, 'Desconocido') AS nombre_actual,
                                
                                CASE 
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_recibido) = CURDATE() THEN
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_recibido, '%h:%i %p')
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_recibido) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) THEN
                                        'Yesterday'
                                    ELSE
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_recibido, '%m/%d/%Y')
                                END as fecha_humana,

                                CASE 
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_enviado) = CURDATE() THEN
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_enviado, '%h:%i %p')
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_enviado) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) THEN
                                        'Yesterday'
                                    ELSE
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_enviado, '%m/%d/%Y')
                                END as fecha_humana_enviado,

                                chat_number.fecha_ultimo_mensaje_recibido_unix,
                                chat_number.fecha_ultimo_mensaje_enviado_unix,
                                
                                chat_number.nombre_whatsapp,

                                (
                                    SELECT COUNT(*) 
                                        FROM chat_social as cs_sub 
                                    WHERE cs_sub.to = chat_number.number 
                                        AND cs_sub.tipo_producto = 'sms' 
                                        AND cs_sub.config_whatsapp_other_id = chat_number.config_whatsapp_other_id
                                ) as chat_con_mensaje_sms,
                                
                                (
                                    SELECT COUNT(*) 
                                        FROM chat_social as cs_sub 
                                    WHERE cs_sub.to = chat_number.number 
                                        AND cs_sub.status = 'received' 
                                        AND cs_sub.esContacto = 1 
                                        AND cs_sub.tipo_producto = 'sms' 
                                        AND cs_sub.config_whatsapp_other_id = chat_number.config_whatsapp_other_id
                                ) as mensajes_no_leidos_sms,
                                 
                                (0) as mensajes_no_leidos_whatsapp,  
                                     
                                ((SELECT mensajes_no_leidos_whatsapp) + (SELECT mensajes_no_leidos_sms)) as mensajes_no_leidos

                    FROM chat_number
                    LEFT JOIN crm_accounts ON crm_accounts.id = chat_number.custumer_id
                    LEFT JOIN sys_users ON sys_users.id = chat_number.staff_id

                ) as sub
                WHERE 1 AND sub.chat_con_mensaje_sms > 1 AND sub.config_whatsapp_other_id = '$configuracion_whatsapp_other_id' 
                ORDER BY sub.fecha_ultimo_mensaje_recibido_unix DESC;";

                $contactos = $mysqli->query($sql)->fetch_all(MYSQLI_ASSOC) ;
            }

          
            //echo json_encode($contactos); exit;
 
        }else{

            if($canal == "whatsapp-sms")
            {
                $contactos = $mysqli->query("SELECT 
                                            chat_number.id, 
                                            chat_number.number, 
                                            chat_number.custumer_id, 
                                            chat_number.staff_id, 
                                            chat_number.created_at, 

                                            IFNULL(crm_accounts.account, 'Desconocido') AS nombre,
                                            crm_accounts.email as email_custumers, 
                                            crm_accounts.phone as phone_custumers, 
                                            crm_accounts.company as company_custumers , 
                                            crm_accounts.address as address_custumers, 
                                            
                                            IFNULL(sys_users.fullname, 'Unassigned staff') AS fullname_staff,
                                            sys_users.username as username_staff, 
                                            sys_users.user_type as     user_type_staff, 
                                            sys_users.phonenumber as     phonenumber, 
                                            
                                            sys_users.config_whatsapp_other_id as     sys_users_config_whatsapp_other_id, 
                                            chat_number.config_whatsapp_other_id,
                                            -- fecha_ultimo_mensaje, Colocar este campo en tabla chat_number y actualizarlo cada vez que entre un mensaje nuevo, desde alli lo leeremos
                                            -- fecha_humana, fecha_creacion este esta actualemente en chat_social, trasladar este nombre a tabla chat_number y obtenerlo de alli
                                            
                                            IFNULL(crm_accounts.account, 'Desconocido') AS nombre_actual,
                                            -- nombre_whatsapp, este esta actualemente en chat_social, trasladar este nombre a tabla chat_number y obtenerlo de alli
                                            
                                            CASE 
                                                WHEN DATE( chat_number.fecha_ultimo_mensaje_recibido  ) = CURDATE() THEN
                                                    DATE_FORMAT( chat_number.fecha_ultimo_mensaje_recibido , '%h:%i %p')
                                                WHEN DATE(chat_number.fecha_ultimo_mensaje_recibido) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) THEN
                                                    'Yesterday'
                                                ELSE
                                                    DATE_FORMAT(chat_number.fecha_ultimo_mensaje_recibido, '%m/%d/%Y')
                                                END as fecha_humana,

                                            IFNULL(chat_number.fecha_ultimo_mensaje_recibido, chat_number.fecha_ultimo_mensaje_enviado) AS fecha_ultimo_mensaje,

                                            CASE 
                                                WHEN DATE( chat_number.fecha_ultimo_mensaje_enviado  ) = CURDATE() THEN
                                                    DATE_FORMAT( chat_number.fecha_ultimo_mensaje_enviado , '%h:%i %p')
                                                WHEN DATE(chat_number.fecha_ultimo_mensaje_enviado) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) THEN
                                                    'Yesterday'
                                                ELSE
                                                    DATE_FORMAT(chat_number.fecha_ultimo_mensaje_enviado, '%m/%d/%Y')
                                                END as fecha_humana_enviado,
                                            
                                            chat_number.fecha_ultimo_mensaje_recibido_unix,
                                            chat_number.fecha_ultimo_mensaje_enviado_unix,

                                            chat_number.nombre_whatsapp,
                                            
                                             
                                            (SELECT COUNT(*) 
                                                    FROM chat_social as cs_sub 
                                                    WHERE cs_sub.to = chat_number.number 
                                                    AND cs_sub.status = 'received' 
                                                    AND cs_sub.esContacto = 1 
                                                    AND cs_sub.tipo_producto = 'sms' 
                                                    AND cs_sub.config_whatsapp_other_id = chat_number.config_whatsapp_other_id
                                            ) as mensajes_no_leidos_sms, 
                                             
                                            (SELECT 
                                                    COUNT(*) 
                                                    FROM chat_social 
                                                    WHERE 
                                                        `to` = chat_number.number 
                                                        AND `status` = 'delivered' 
                                                        AND esContacto = 1 
                                                        AND tipo_producto = 'whatsapp' 
                                                        AND config_whatsapp_other_id = chat_number.config_whatsapp_other_id
                                                ) as mensajes_no_leidos_whatsapp,  
                                                 
                                            ((select mensajes_no_leidos_whatsapp) + (SELECT mensajes_no_leidos_sms )) as mensajes_no_leidos
                                             
                                             
                                        FROM chat_number AS chat_number

                                            LEFT JOIN
                                                crm_accounts on crm_accounts.id = chat_number.custumer_id

                                            LEFT JOIN
                                                sys_users on sys_users.id = chat_number.staff_id 
                                                
                                            WHERE 1 
                                                
                                                AND chat_number.config_whatsapp_other_id = '$configuracion_whatsapp_other_id' 
                                                AND chat_number.staff_id = '$parametro'
                                                
                                            ORDER BY chat_number.fecha_ultimo_mensaje_recibido_unix DESC; 
 
                                        ")->fetch_all(MYSQLI_ASSOC) ;
            }

            if($canal == "whatsapp")
            {

                //echo "whatsapp"; exit;

                $sql = "SELECT * FROM (
                    SELECT 
                                chat_number.id, 
                                chat_number.number, 
                                chat_number.custumer_id, 
                                chat_number.staff_id, 
                                chat_number.created_at, 

                                IFNULL(crm_accounts.account, 'Desconocido') AS nombre,
                                crm_accounts.email as email_custumers, 
                                crm_accounts.phone as phone_custumers, 
                                crm_accounts.company as company_custumers , 
                                crm_accounts.address as address_custumers, 
                                
                                IFNULL(sys_users.fullname, 'Unassigned staff') AS fullname_staff,
                                sys_users.username as username_staff, 
                                sys_users.user_type as user_type_staff, 
                                sys_users.phonenumber as phonenumber, 
                                
                                sys_users.config_whatsapp_other_id as sys_users_config_whatsapp_other_id, 
                                chat_number.config_whatsapp_other_id,
                                IFNULL(crm_accounts.account, 'Desconocido') AS nombre_actual,
                                
                                CASE 
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_recibido) = CURDATE() THEN
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_recibido, '%h:%i %p')
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_recibido) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) THEN
                                        'Yesterday'
                                    ELSE
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_recibido, '%m/%d/%Y')
                                END as fecha_humana,

                                CASE 
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_enviado) = CURDATE() THEN
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_enviado, '%h:%i %p')
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_enviado) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) THEN
                                        'Yesterday'
                                    ELSE
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_enviado, '%m/%d/%Y')
                                END as fecha_humana_enviado,

                                chat_number.fecha_ultimo_mensaje_recibido_unix,
                                chat_number.fecha_ultimo_mensaje_enviado_unix,
                                
                                chat_number.nombre_whatsapp,

                                (SELECT 
                                        COUNT(*) 
                                        FROM chat_social 
                                        WHERE 
                                            `to` = chat_number.number 
                                            AND tipo_producto = 'whatsapp' 
                                            AND config_whatsapp_other_id = chat_number.config_whatsapp_other_id
                                    ) as chat_con_mensaje_whatsapp,  
                                
                                (0) as mensajes_no_leidos_sms, 
                                 
                                (SELECT 
                                        COUNT(*) 
                                        FROM chat_social 
                                        WHERE 
                                            `to` = chat_number.number 
                                            AND `status` = 'delivered' 
                                            AND esContacto = 1 
                                            AND tipo_producto = 'whatsapp' 
                                            AND config_whatsapp_other_id = chat_number.config_whatsapp_other_id
                                    ) as mensajes_no_leidos_whatsapp,  
                                     
                                    ((SELECT mensajes_no_leidos_whatsapp) + (SELECT mensajes_no_leidos_sms)) as mensajes_no_leidos

                    FROM chat_number
                    LEFT JOIN crm_accounts ON crm_accounts.id = chat_number.custumer_id
                    LEFT JOIN sys_users ON sys_users.id = chat_number.staff_id

                ) as sub
                WHERE 1 
                    AND sub.chat_con_mensaje_whatsapp > 1 
                    AND sub.config_whatsapp_other_id = '$configuracion_whatsapp_other_id' 
                    AND sub.staff_id = '$parametro'
                ORDER BY sub.fecha_ultimo_mensaje_recibido_unix DESC;";

 
                $contactos = $mysqli->query($sql)->fetch_all(MYSQLI_ASSOC) ;
            }

            if($canal == "sms")
            {

                //echo "whatsapp"; exit;

                $sql = "SELECT * FROM (
                    SELECT 
                                chat_number.id, 
                                chat_number.number, 
                                chat_number.custumer_id, 
                                chat_number.staff_id, 
                                chat_number.created_at, 

                                IFNULL(crm_accounts.account, 'Desconocido') AS nombre,
                                crm_accounts.email as email_custumers, 
                                crm_accounts.phone as phone_custumers, 
                                crm_accounts.company as company_custumers , 
                                crm_accounts.address as address_custumers, 
                                
                                IFNULL(sys_users.fullname, 'Unassigned staff') AS fullname_staff,
                                sys_users.username as username_staff, 
                                sys_users.user_type as user_type_staff, 
                                sys_users.phonenumber as phonenumber, 
                                
                                sys_users.config_whatsapp_other_id as sys_users_config_whatsapp_other_id, 
                                chat_number.config_whatsapp_other_id,
                                IFNULL(crm_accounts.account, 'Desconocido') AS nombre_actual,
                                
                                CASE 
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_recibido) = CURDATE() THEN
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_recibido, '%h:%i %p')
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_recibido) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) THEN
                                        'Yesterday'
                                    ELSE
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_recibido, '%m/%d/%Y')
                                END as fecha_humana,

                                CASE 
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_enviado) = CURDATE() THEN
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_enviado, '%h:%i %p')
                                    WHEN DATE(chat_number.fecha_ultimo_mensaje_enviado) = DATE_SUB(CURDATE(), INTERVAL 1 DAY) THEN
                                        'Yesterday'
                                    ELSE
                                        DATE_FORMAT(chat_number.fecha_ultimo_mensaje_enviado, '%m/%d/%Y')
                                END as fecha_humana_enviado,

                                chat_number.fecha_ultimo_mensaje_recibido_unix,
                                chat_number.fecha_ultimo_mensaje_enviado_unix,
                                
                                chat_number.nombre_whatsapp,

                                (
                                    SELECT COUNT(*) 
                                        FROM chat_social as cs_sub 
                                    WHERE cs_sub.to = chat_number.number 
                                        AND cs_sub.tipo_producto = 'sms' 
                                        AND cs_sub.config_whatsapp_other_id = chat_number.config_whatsapp_other_id
                                ) as chat_con_mensaje_sms,
                                
                                (
                                    SELECT COUNT(*) 
                                        FROM chat_social as cs_sub 
                                    WHERE cs_sub.to = chat_number.number 
                                        AND cs_sub.status = 'received' 
                                        AND cs_sub.esContacto = 1 
                                        AND cs_sub.tipo_producto = 'sms' 
                                        AND cs_sub.config_whatsapp_other_id = chat_number.config_whatsapp_other_id
                                ) as mensajes_no_leidos_sms,
                                 
                                (0) as mensajes_no_leidos_whatsapp,  
                                     
                                ((SELECT mensajes_no_leidos_whatsapp) + (SELECT mensajes_no_leidos_sms)) as mensajes_no_leidos

                    FROM chat_number
                    LEFT JOIN crm_accounts ON crm_accounts.id = chat_number.custumer_id
                    LEFT JOIN sys_users ON sys_users.id = chat_number.staff_id

                ) as sub
                WHERE 1 
                    AND sub.chat_con_mensaje_sms > 1 
                    AND sub.config_whatsapp_other_id = '$configuracion_whatsapp_other_id' 
                    AND sub.staff_id = '$parametro'
                ORDER BY sub.fecha_ultimo_mensaje_recibido_unix DESC;";

                $contactos = $mysqli->query($sql)->fetch_all(MYSQLI_ASSOC) ;
            }

 

                                          
 
        }

    
        /* $contactos_mensajes = [];

        foreach($contactos as $c)
        {
            
            $number = $c["number"];
            $nombre = $c["nombre"];
 
            $total_mensajes          = 0;
            $total_mensajes_whatsapp = 0;
            $total_mensajes_sms      = 0;

            if($canal == "whatsapp-sms"){
                //contacto es igual a 1 es enviados por el cliente
                $result_whatsapp         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `to`='$number' AND `status`='delivered' AND esContacto=1 AND  tipo_producto='whatsapp' AND config_whatsapp_other_id='$configuracion_whatsapp_other_id'");
                $result_sms              = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `to`='$number' AND `status`='received' AND esContacto=1 AND  tipo_producto='sms' AND config_whatsapp_other_id='$configuracion_whatsapp_other_id'");

                $row_whatsapp            = $result_whatsapp->fetch_assoc();
                $row_sms                 = $result_sms->fetch_assoc();

                // Obtener el valor de total_mensajes
                $total_mensajes          = $row_whatsapp['total_mensajes'] + $row_sms['total_mensajes'] + 0;

                $total_mensajes_whatsapp = $row_whatsapp['total_mensajes'];
                $total_mensajes_sms      = $row_sms['total_mensajes'];

            }

            if($canal == "whatsapp"){
                //contacto es igual a 1 es enviados por el cliente
                $result_whatsapp         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `to`='$number' AND `status`='delivered' AND esContacto=1 AND  tipo_producto='whatsapp' AND config_whatsapp_other_id='$configuracion_whatsapp_other_id'");
                $row_whatsapp            = $result_whatsapp->fetch_assoc();
                // Obtener el valor de total_mensajes
                $total_mensajes          = $row_whatsapp['total_mensajes'];

                $total_mensajes_whatsapp = $total_mensajes;
            }

            if($canal == "sms"){
                //contacto es igual a 1 es enviados por el cliente
                $result_sms              = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `to`='$number' AND `status`='received' AND esContacto=1 AND  tipo_producto='sms' AND config_whatsapp_other_id='$configuracion_whatsapp_other_id'");
                $row_sms                 = $result_sms->fetch_assoc();
                // Obtener el valor de total_mensajes
                $total_mensajes          = $row_sms['total_mensajes'];

                $total_mensajes_sms      = $total_mensajes;
            }

            //cs.fecha_creacion,
            //cs.mensaje,

            $result_fecha_ultimo             = $mysqli->query("SELECT id, mensaje, fecha_creacion, nombre_whatsapp FROM chat_social where `to`='$number' AND config_whatsapp_other_id='$configuracion_whatsapp_other_id' ORDER BY id DESC LIMIT 1");
            $row_fecha_ultimo                = $result_fecha_ultimo->fetch_assoc();

            $c["fecha_ultimo_mensaje"]        = $row_fecha_ultimo['fecha_creacion'];
            $fecha_humana                     = $row_fecha_ultimo['fecha_creacion'];
            $nombre_whatsapp                  = $row_fecha_ultimo['nombre_whatsapp'];

            $c["nombre_actual"] = $c["nombre"];

            //if($nombre == "Desconocido")
            //{
            //    if(empty($nombre_whatsapp) == false)
            //    {
            //        $c["nombre"] = $nombre_whatsapp;
            //    }
            //}

 
            $c["nombre_whatsapp"] = $nombre_whatsapp ?? "";

            //$c["id_chat_social"]            = $row_fecha_ultimo['id'];

            if(empty($fecha_humana) == false)
            {
                // Fecha que deseas comparar
                $fechaComparar = Carbon::parse($fecha_humana);

                $fecha_humana = "";

                if ($fechaComparar->isToday()) 
                {
                    $fecha_humana = $fechaComparar->format('h:i A');
                } elseif ($fechaComparar->isYesterday()) {
                    $fecha_humana = "Yesterday";
                } else {
                    $fecha_humana = $fechaComparar->format('m/d/Y');
                }

                $c["fecha_humana"] = $fecha_humana;
                 
            }else{
                $c["fecha_humana"] = "";
            }

             
            $c["mensajes_no_leidos"]          = $total_mensajes + 0;
            $c["mensajes_no_leidos_sms"]      = $total_mensajes_sms + 0;
            $c["mensajes_no_leidos_whatsapp"] = $total_mensajes_whatsapp + 0;
            //$c["nombre"] = "Desconocido";
            $contactos_mensajes[] = $c;
        }

        if(count($contactos_mensajes) != 0)
        {
            usort($contactos_mensajes, function ($a, $b) {
                $dateA = $a['fecha_ultimo_mensaje'] ?? '';
                $dateB = $b['fecha_ultimo_mensaje'] ?? '';
            
                // Si una fecha es null, colócala al final
                if ($dateA === '') return 1;
                if ($dateB === '') return -1;
            
                return strtotime($dateB) - strtotime($dateA);
            });
        }    */


        //ESTE JSON es el que recorria con ciclos for
        /* {
            "tipo_producto": "sms",
            "id": "56",
            "number": "50497747446",
            "custumer_id": "11813",
            "staff_id": null,
            "created_at": "11-02-2025 10:08 am",
            "mensajes_no_leidos": 0,
            "nombre": "prueba",
            "email_custumers": "prueba_nive@live.com",
            "phone_custumers": "50497747446",
            "company_custumers": "",
            "address_custumers": "asd",
            "fullname_staff": "Unassigned staff",
            "username_staff": null,
            "user_type_staff": null,
            "phonenumber": null,
            "sys_users_config_whatsapp_other_id": null,
            "config_whatsapp_other_id": "1",
            "fecha_ultimo_mensaje": "2025-04-07 17:01:39",
            "nombre_actual": "prueba",
            "nombre_whatsapp": "",
            "fecha_humana": "Yesterday",
            "mensajes_no_leidos_sms": 0,
            "mensajes_no_leidos_whatsapp": 0,

 

       
        }, */

         
 

        $response = array(
            "type" => "success",
            "data" => $contactos,
        );
        $mysqli->close();
        print_r(json_encode( $response)) ; exit;

           
    break;

    case 'tener-chat-numero':
  
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $to                            = $informacion_front['to'];
        $from                          = $informacion_front['from'];
        $phone_number_id               = $informacion_front['phone_number_id'];
        $tipo_de_plataforma            = $informacion_front['tipo_de_plataforma'];
        $configuracion_whatsapp_sms_id = $informacion_front['configuracion_whatsapp_sms_id'];

        if(empty($configuracion_whatsapp_sms_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp/sms setup is required",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($to) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required a phone to send a message",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($tipo_de_plataforma) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Channel is required",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $tipo = "";

        if($tipo_de_plataforma == "whatsapp")
        {
            $tipo = " AND tipo_producto='whatsapp' AND `to` = '$to'";
        }

        if($tipo_de_plataforma == "sms")
        {
            $tipo = " AND tipo_producto='sms' AND `to` = '$to' ";
        }

        $lastIdQuery = "SELECT id FROM chat_social 
                        WHERE 1 $tipo
                        ORDER BY id DESC 
                        LIMIT 1";

        $result = $mysqli->query($lastIdQuery);

        $lastId = 0;

        // Verificar si se obtuvo un resultado
        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $lastId = $row['id'];
        } 

        //$chat = $mysqli->query("SELECT * FROM chat_social WHERE `to`='$to' AND `from`='$from' AND `phone_number_id`='$phone_number_id' AND id <= $lastId order by id DESC  limit 30")->fetch_all(MYSQLI_ASSOC) ;
        
        $chat = [];

        if($tipo_de_plataforma == "whatsapp")
        {

           

            /* if(empty($phone_number_id) == true)
            {
                $response = array(
                    "type" => "error",
                    "message" => "Required: Phone number identifier",
                    "data" => [],
                );
                print_r(json_encode( $response)) ; exit;
            }

            if(empty($from) == true)
            {
                $response = array(
                    "type" => "error",
                    "message" => "Required Phone number, created in developer Facebook",
                    "data" => [],
                );
                print_r(json_encode( $response)) ; exit;
            } */

            /* $chat = $mysqli->query("SELECT 
                                    subquery.*,  
                                    LOWER(DATE_FORMAT(subquery.fecha_creacion, '%d-%m-%Y %I:%i %p')) AS fecha_creacion
                                FROM (
                                    SELECT 
                                        *   
                                    FROM 
                                        chat_social 
                                    WHERE 
                                        `to` = '$to' 
                                        AND `from` = '$from' 
                                        AND `phone_number_id` = '$phone_number_id' 
                                        AND id <= $lastId 
                                        AND tipo_producto='whatsapp'
                                    ORDER BY 
                                        id DESC 
                                    LIMIT 30
                                ) AS subquery;")->fetch_all(MYSQLI_ASSOC) ; */

                             

                 
                    $chat = $mysqli->query("SELECT 
                                    cs.*,  
                                    LOWER(DATE_FORMAT(cs.fecha_creacion, '%d-%m-%Y %I:%i %p')) AS fecha_creacion 
                                FROM (
                                    SELECT 
                                        cs.id,
                                        cs.wam_id,
                                        cs.sid,
                                        cs.chat_number_id,
                                        cs.from,
                                        cs.to,
                                        cs.mensaje,
                                        cs.url,
                                        cs.filename,
                                        cs.template_original,
                                        cs.template_data,
                                        cs.tipo_mensaje,
                                        cs.esContacto,
                                        cs.error_codigo,
                                        cs.error_mensaje,
                                        cs.phone_number_id,
                                        cs.tipo_producto,
                                        cs.fecha_creacion,
                                        cs.status,
                                        cs.config_whatsapp_other_id,
                                        cs.user_id,
                                        su.img AS user_img
                                    FROM 
                                        chat_social AS cs
                                    LEFT JOIN sys_users AS su 
                                        ON su.id = cs.user_id
                                    WHERE 
                                        cs.`to` = '$to' 
                                        AND cs.id <= $lastId 
                                        AND cs.tipo_producto='whatsapp'
                                        AND cs.config_whatsapp_other_id='$configuracion_whatsapp_sms_id'
                                    ORDER BY 
                                        cs.id DESC 
                                    LIMIT 10
                                ) AS cs
                            ")->fetch_all(MYSQLI_ASSOC);
                            
        }

        if($tipo_de_plataforma == "whatsapp-sms")
        {
            //echo "exasd"; exit;
            $chat = $mysqli->query("SELECT 
                                    subquery.*,  
                                    LOWER(DATE_FORMAT(subquery.fecha_creacion, '%d-%m-%Y %I:%i %p')) AS fecha_creacion
                                FROM (
                                    SELECT 
                                        cs.id,
                                        cs.wam_id,
                                        cs.sid,
                                        cs.chat_number_id,
                                        cs.from,
                                        cs.to,
                                        cs.mensaje,
                                        cs.url,
                                        cs.filename,
                                        cs.template_original,
                                        cs.template_data,
                                        cs.tipo_mensaje,
                                        cs.esContacto,
                                        cs.error_codigo,
                                        cs.error_mensaje,
                                        cs.phone_number_id,
                                        cs.tipo_producto,
                                        cs.fecha_creacion,
                                        cs.status,
                                        cs.config_whatsapp_other_id,
                                        cs.user_id,
                                        su.img AS user_img  
                                    FROM 
                                         chat_social AS cs
                                        LEFT JOIN sys_users AS su 
                                            ON su.id = cs.user_id
                                    WHERE 
                                        cs.`to` = '$to' 
                                        AND cs.id <= $lastId 
                                        AND cs.config_whatsapp_other_id='$configuracion_whatsapp_sms_id'
                                    ORDER BY 
                                        cs.id DESC 
                                    LIMIT 10
                                ) AS subquery;")->fetch_all(MYSQLI_ASSOC) ;
        }

        if($tipo_de_plataforma == "sms")
        {
            $chat = $mysqli->query("SELECT 
                                    subquery.*,  
                                    LOWER(DATE_FORMAT(subquery.fecha_creacion, '%d-%m-%Y %I:%i %p')) AS fecha_creacion
                                FROM (
                                    SELECT 
                                        cs.id,
                                        cs.wam_id,
                                        cs.sid,
                                        cs.chat_number_id,
                                        cs.from,
                                        cs.to,
                                        cs.mensaje,
                                        cs.url,
                                        cs.filename,
                                        cs.template_original,
                                        cs.template_data,
                                        cs.tipo_mensaje,
                                        cs.esContacto,
                                        cs.error_codigo,
                                        cs.error_mensaje,
                                        cs.phone_number_id,
                                        cs.tipo_producto,
                                        cs.fecha_creacion,
                                        cs.status,
                                        cs.config_whatsapp_other_id,
                                        cs.user_id,
                                        su.img AS user_img  
                                    FROM 
                                        chat_social AS cs
                                        LEFT JOIN sys_users AS su 
                                            ON su.id = cs.user_id 
                                    WHERE 
                                        cs.`to` = '$to' 
                                        AND cs.id <= $lastId 
                                        AND cs.tipo_producto='sms'
                                        AND cs.config_whatsapp_other_id='$configuracion_whatsapp_sms_id'
                                    ORDER BY 
                                        cs.id DESC 
                                    LIMIT 10
                                ) AS subquery;")->fetch_all(MYSQLI_ASSOC) ;
        }
        
         
       
        $chat = array_reverse($chat);

        $response = array(
            "type"   => "success",
            "lastId" =>  $lastId,
            "data"   => $chat,
        );
        $mysqli->close();
        print_r(json_encode( $response)) ; exit;

           
    break;

    case 'tener-chat-numero-by-last-id':

 
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $to                            = $informacion_front['to'];
        //$from               = $informacion_front['from'];
        //$phone_number_id    = $informacion_front['phone_number_id'];
        $lastId                        = $informacion_front['last_id'];
        $tipo_de_plataforma            = $informacion_front['tipo_de_plataforma'];
        $configuracion_whatsapp_sms_id = $informacion_front['configuracion_whatsapp_sms_id'];

        if(empty($configuracion_whatsapp_sms_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp/sms setup is required",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($tipo_de_plataforma) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Select a platform type: SMS / Whatsapp",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        /* if(empty($from) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required Phone number, created in developer Facebook",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        } */

        if(empty($to) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required a phone to send a message",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($lastId) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required message ids",
                "data" => [],

            );
            print_r(json_encode( $response)) ; exit;
        }

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }


        $chat = [];

        //SELECT * FROM chat_social WHERE `to`='$to' AND `from`='$from' AND `phone_number_id`='$phone_number_id' AND id < $lastId  order by id DESC limit 30
        /* $chat = $mysqli->query("SELECT 
                                    subquery.*,  
                                    LOWER(DATE_FORMAT(subquery.fecha_creacion, '%d-%m-%Y %I:%i %p')) AS fecha_creacion
                                FROM (
                                    SELECT * FROM chat_social WHERE `to`='$to' AND `from`='$from' AND `phone_number_id`='$phone_number_id' AND id < $lastId  order by id DESC limit 30
                                ) AS subquery;
         ")->fetch_all(MYSQLI_ASSOC) ; */

         if($tipo_de_plataforma == "whatsapp")
         {
            $chat = $mysqli->query("SELECT 
                                        subquery.*,  
                                        LOWER(DATE_FORMAT(subquery.fecha_creacion, '%d-%m-%Y %I:%i %p')) AS fecha_creacion
                                    FROM (
                                        SELECT 
                                            cs.id,
                                            cs.wam_id,
                                            cs.sid,
                                            cs.chat_number_id,
                                            cs.from,
                                            cs.to,
                                            cs.mensaje,
                                            cs.url,
                                            cs.filename,
                                            cs.template_original,
                                            cs.template_data,
                                            cs.tipo_mensaje,
                                            cs.esContacto,
                                            cs.error_codigo,
                                            cs.error_mensaje,
                                            cs.phone_number_id,
                                            cs.tipo_producto,
                                            cs.fecha_creacion,
                                            cs.status,
                                            cs.config_whatsapp_other_id,
                                            cs.user_id,
                                            su.img AS user_img 
                                        FROM 
                                            chat_social AS cs
                                            LEFT JOIN sys_users AS su  ON su.id = cs.user_id  
                                        WHERE 
                                            cs.`to`='$to' AND 
                                            cs.id < $lastId AND 
                                            cs.tipo_producto='whatsapp' AND 
                                            cs.config_whatsapp_other_id='$configuracion_whatsapp_sms_id' order by cs.id DESC limit 5
                                    ) AS subquery;
            ")->fetch_all(MYSQLI_ASSOC); 
       
         }

         if($tipo_de_plataforma == "whatsapp-sms")
         {

            /* $chat = $mysqli->query("SELECT 
                                    cs.*,  
                                    LOWER(DATE_FORMAT(cs.fecha_creacion, '%d-%m-%Y %I:%i %p')) AS fecha_creacion 
                                FROM (
                                    SELECT 
                                        cs.id,
                                        cs.wam_id,
                                        cs.sid,
                                        cs.chat_number_id,
                                        cs.from,
                                        cs.to,
                                        cs.mensaje,
                                        cs.url,
                                        cs.filename,
                                        cs.template_original,
                                        cs.template_data,
                                        cs.tipo_mensaje,
                                        cs.esContacto,
                                        cs.error_codigo,
                                        cs.error_mensaje,
                                        cs.phone_number_id,
                                        cs.tipo_producto,
                                        cs.fecha_creacion,
                                        cs.status,
                                        cs.config_whatsapp_other_id,
                                        cs.user_id,
                                        su.img AS user_img
                                    FROM 
                                        chat_social AS cs
                                    LEFT JOIN sys_users AS su 
                                        ON su.id = cs.user_id
                                    WHERE 
                                        cs.`to` = '$to' 
                                        AND cs.id <= $lastId 
                                        AND cs.tipo_producto='whatsapp'
                                        AND cs.config_whatsapp_other_id='$configuracion_whatsapp_sms_id'
                                    ORDER BY 
                                        cs.id DESC 
                                    LIMIT 30
                                ) AS cs
                            ")->fetch_all(MYSQLI_ASSOC); */

            $chat = $mysqli->query("SELECT 
                                        subquery.*,  
                                        LOWER(DATE_FORMAT(subquery.fecha_creacion, '%d-%m-%Y %I:%i %p')) AS fecha_creacion

                                    FROM (
                                        SELECT 
                                            cs.id,
                                            cs.wam_id,
                                            cs.sid,
                                            cs.chat_number_id,
                                            cs.from,
                                            cs.to,
                                            cs.mensaje,
                                            cs.url,
                                            cs.filename,
                                            cs.template_original,
                                            cs.template_data,
                                            cs.tipo_mensaje,
                                            cs.esContacto,
                                            cs.error_codigo,
                                            cs.error_mensaje,
                                            cs.phone_number_id,
                                            cs.tipo_producto,
                                            cs.fecha_creacion,
                                            cs.status,
                                            cs.config_whatsapp_other_id,
                                            cs.user_id,
                                            su.img AS user_img 
                                        FROM 
                                            chat_social AS cs
                                            LEFT JOIN sys_users AS su  ON su.id = cs.user_id 
                                                WHERE 
                                                    cs.`to`='$to' AND 
                                                    cs.id < $lastId AND 
                                                    cs.config_whatsapp_other_id='$configuracion_whatsapp_sms_id' 
                                                order by cs.id DESC limit 5
                                    ) AS subquery;
            ")->fetch_all(MYSQLI_ASSOC); 
       
         }

         if($tipo_de_plataforma == "sms")
         {
            $chat = $mysqli->query("SELECT 
                                        subquery.*,  
                                        LOWER(DATE_FORMAT(subquery.fecha_creacion, '%d-%m-%Y %I:%i %p')) AS fecha_creacion
                                    FROM (
                                        SELECT 
                                            cs.id,
                                            cs.wam_id,
                                            cs.sid,
                                            cs.chat_number_id,
                                            cs.from,
                                            cs.to,
                                            cs.mensaje,
                                            cs.url,
                                            cs.filename,
                                            cs.template_original,
                                            cs.template_data,
                                            cs.tipo_mensaje,
                                            cs.esContacto,
                                            cs.error_codigo,
                                            cs.error_mensaje,
                                            cs.phone_number_id,
                                            cs.tipo_producto,
                                            cs.fecha_creacion,
                                            cs.status,
                                            cs.config_whatsapp_other_id,
                                            cs.user_id,
                                            su.img AS user_img  
                                        FROM 
                                            chat_social AS cs
                                            LEFT JOIN sys_users AS su  ON su.id = cs.user_id  
                                        WHERE 
                                            cs.`to`='$to' AND 
                                            cs.id < $lastId AND 
                                            cs.tipo_producto='sms' AND 
                                            cs.config_whatsapp_other_id='$configuracion_whatsapp_sms_id' order by cs.id DESC limit 5
                                    ) AS subquery;
            ")->fetch_all(MYSQLI_ASSOC); 
       
         }

          
        $chat = array_reverse($chat);

        $response = array(
            "type" => "success",
            "data" => $chat,
        );
        $mysqli->close();
        print_r(json_encode( $response)) ; exit;

           
    break;

    case 'listado-staff':


        $parametro                           = $routes['2'];

        if(empty($parametro) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp/sms id configuration is required",
                "data" => $usuarios_data ?? []
            );
        
            print_r(json_encode($response));
        }

        $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
        $mysqli->set_charset("utf8");
    
        if ($mysqli->connect_error) {
            $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $mysqli->connect_error
            );
            print_r(json_encode($response));
            exit;
        }
    
        $usuarios = $mysqli->query("SELECT id, username, fullname, phonenumber, user_type FROM sys_users WHERE `status`='Active' AND config_whatsapp_other_id=$parametro");
 
        $usuarios_data = $usuarios->fetch_all(MYSQLI_ASSOC);
    
        $response = array(
            "type" => "success",
            "data" => $usuarios_data ?? []
        );
    
        $mysqli->close();
        print_r(json_encode($response));
        exit;
    break;
    

    case 'listado-custumers':

        $contacts = Contact::select(['id', 'account', 'email', 'phone', 'company','address'])->where('type', 'Customer')->orderBy('id', 'desc')->get();
        
        $res = array(
            "type" => "success",
            "data" => $contacts ?? []
        );

        print_r(json_encode($res));
        exit;

           
    break;

 
    case 'asignar-staff-y-contactos-chat':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $chat_number_id  = $informacion_front['chat_number_id'];
        $staff_id        = $informacion_front['staff_id'];
        $custumers_id    = $informacion_front['custumers_id'];
        $config_whatsapp_other_id    = $informacion_front['config_whatsapp_other_id'];

        if(empty($config_whatsapp_other_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Settings whatsapp/sms id is required",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }
         
        if(empty($chat_number_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Contacto is required",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        //if(empty($staff_id) == true)
        //{
        //    $response = array(
        //        "type" => "error",
        //        "message" => "Staff is required",
        //        "data" => [],
        //    );
        //    print_r(json_encode( $response)) ; exit;
        //}

        //if(empty($custumers_id) == true)
        //{
        //    $response = array(
        //        "type" => "error",
        //        "message" => "Customers is required",
        //        "data" => [],
        //    );
        //    print_r(json_encode( $response)) ; exit;
        //}

        if(empty($custumers_id) == true && empty($staff_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Customers o Staff is required",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $existe = $mysqli->query("SELECT * from chat_number WHERE id='$chat_number_id'")->fetch_all(MYSQLI_ASSOC) ?? [];

        if(count($existe) == 0)
        {
            $response = array(
                "type" => "error",
                "data" => "¡The contact id does not exist!",
            );
    
            print_r(json_encode($response)); exit;
        }
        //staff_id='$staff_id'
        $estaAsignado = $mysqli->query("SELECT * from chat_number WHERE  config_whatsapp_other_id != $config_whatsapp_other_id AND staff_id='$staff_id'")->fetch_all(MYSQLI_ASSOC);


        //if(count($estaAsignado) != 0)
        //{

        //    $response = array(
        //        "type" => "error",
        //        "data" => "¡I can't assign the staff to 2 or more WhatsApp/SMS configurations!",
        //    );
    
        //    print_r(json_encode($response)); exit;
        //}

        $chat_number_id = $existe[0]["id"];
        $chat_number_number = $existe[0]["number"];
        $chat_number_staff_id = $existe[0]["staff_id"];
        $chat_number_created_at = $existe[0]["created_at"];

        if(empty($custumers_id) == false)
        {
            //echo "que paso"; exit;

            $contacts = Contact::select(['id'])->where('id', $custumers_id)->first();

            if(!$contacts)
            {
                $response = array(
                    "type" => "error",
                    "data" => "¡The contact id does not exist!",
                );
        
                print_r(json_encode($response)); exit;
            }
        }

  
        if(empty($staff_id) == false)
        {
            $user = User::select(['id','config_whatsapp_other_id'])->where('id', $staff_id)->first();

            if(!$user)
            {
                $response = array(
                    "type" => "error",
                    "data" => "¡The users/staff id does not exist!",
                );
        
                print_r(json_encode($response)); exit;
            }
        }

 
        //if(empty($user->config_whatsapp_other_id) == true )
        //{
        //    $response = array(
        //        "type" => "error",
        //        "data" => "¡This user does not have a WhatsApp/SMS configuration assigned!",
        //    );
        //    print_r(json_encode($response)); exit;
        //}

        //if($user->config_whatsapp_other_id != $config_whatsapp_other_id)
        //{
        //    $response = array(
        //        "type" => "error",
        //        "data" => "¡This staff does not belong to the assigned WhatsApp/SMS configuration!",
        //    );
        //    print_r(json_encode($response)); exit;
        //} 

        //$mysqli->query("UPDATE chat_number SET staff_id='$staff_id', custumer_id='$custumers_id' WHERE id='$chat_number_id'");

        $data_personal = $mysqli->query("SELECT 
                                        cn.id, 
                                        cn.number, 
                                        cn.custumer_id, 
                                        cn.staff_id, 
                                        LOWER(DATE_FORMAT(cn.created_at, '%d-%m-%Y %I:%i %p')) AS created_at, 
                                        0 AS mensajes_no_leidos,  
                                        IFNULL(crm_a.account, 'Desconocido') AS nombre,
                                        crm_a.email AS email_custumers,
                                        crm_a.phone AS phone_custumers,
                                        crm_a.company AS company_custumers,
                                        crm_a.address AS address_custumers,
                                        IFNULL(sys_u.fullname, 'Unassigned staff') AS fullname_staff,
                                        sys_u.username AS username_staff,
                                        sys_u.user_type AS user_type_staff,
                                        sys_u.phonenumber AS phonenumber

                                    FROM 
                                        chat_number AS cn 
                                    LEFT JOIN 
                                        crm_accounts AS crm_a 
                                    ON 
                                        crm_a.id = cn.custumer_id 
                                    LEFT JOIN 
                                        sys_users AS sys_u 
                                    ON 
                                        sys_u.id = cn.staff_id 

                                    WHERE cn.staff_id='$chat_number_staff_id'

                                    ORDER BY 
                                        cn.id ASC;")->fetch_assoc() ;


        $id                   = null;
        $number               = null;
        $custumer_id          = null;
        $staff_id_db          = null;
        $created_at           = null;
        $mensajes_no_leidos   = null;
        $nombre               = null;
        $email_custumers      = null;
        $phone_custumers      = null;
        $company_custumers    = null;
        $address_custumers    = null;
        $fullname_staff       = null;
        $username_staff       = null;
        $user_type_staff      = null;
        $phonenumber          = null;

        //status delivered = whatsapp
        //status received  = sms
        //echo "entro"; exit;
        
        $msj_no_leidos_whatsapp = tener_mensajes_no_leidos($mysqli, $chat_number_id, "whatsapp", "delivered");
        $msj_no_leidos_sms = tener_mensajes_no_leidos($mysqli, $chat_number_id, "sms", "received");

        $mensajes_no_leidos =  $msj_no_leidos_whatsapp + $msj_no_leidos_sms;

        //echo json_encode($data_personal); exit;

        $inf_data = tener_staff($mysqli, $staff_id);

        $inf_data_customers = [];

        $inf_data_customers = tener_custumers($mysqli, $custumers_id);

        //if(empty($custumers_id) == false)
        //{
        //    //echo "entro"; exit;
        //    $inf_data_customers = tener_custumers($mysqli, $custumers_id);
        //}

        //echo json_encode($inf_data_customers); exit;

        $id                   = $chat_number_id;
        $number               = $chat_number_number;
        $custumer_id          = $custumers_id;
        $staff_id_db          = $staff_id;
        $created_at           = $chat_number_created_at;

        //PERTENECE STAFF
        $fullname_staff       = $inf_data["fullname_staff"] ?? "Unassigned staff";
        $username_staff       = $inf_data["username_staff"] ?? "";
        $user_type_staff      = $inf_data["user_type_staff"] ?? "";
        $phonenumber          = $inf_data["phonenumber"] ?? "";

        //PERTENECE CUSTOMERS
        $nombre               = $inf_data_customers["account"] ?? "Desconocido";
        $email_custumers      = $inf_data_customers["email_custumers"] ?? "";
        $phone_custumers      = $inf_data_customers["phone_custumers"] ?? "";
        $company_custumers    = $inf_data_customers["company_custumers"] ?? "";
        $address_custumers    = $inf_data_customers["address_custumers"] ?? "";

        $estructura = [
            'id'                  => $id,
            'number'              => $number,
            'custumer_id'         => $custumer_id,
            'staff_id'            => $staff_id_db, // base de datos
            //'staff_id_nuevo'      => $staff_id, // viene del frontend
            'created_at'          => $created_at,
            'mensajes_no_leidos'  => $mensajes_no_leidos,
            'nombre'              => $nombre,
            'email_custumers'     => $email_custumers,
            'phone_custumers'     => $phone_custumers,
            'company_custumers'   => $company_custumers,
            'address_custumers'   => $address_custumers,
            'fullname_staff'      => $fullname_staff,
            'username_staff'      => $username_staff,
            'user_type_staff'     => $user_type_staff,
            'phonenumber'         => $phonenumber,
            'accion'              => "modificar",
            "db"                  => DB_NAME, 
             
        ];

        //echo json_encode($estructura); exit;
       
        enviarSocket($estructura);

        //echo json_encode($estructura); exit;

        //$mysqli->query("UPDATE chat_number SET staff_id='$staff_id', custumer_id='$custumers_id' WHERE id='$chat_number_id'");

        if(empty($custumers_id) == false && empty($staff_id) == false)
        {
            $mysqli->query("UPDATE chat_number SET staff_id='$staff_id', custumer_id='$custumers_id' WHERE id='$chat_number_id'");
        }
        else
        {
            if(empty($staff_id) == false)
            {
                $mysqli->query("UPDATE chat_number SET staff_id='$staff_id', custumer_id=null WHERE id='$chat_number_id'");
            } 

            if(empty($custumers_id) == false )
            {
                $mysqli->query("UPDATE chat_number SET staff_id=null, custumer_id='$custumers_id' WHERE id='$chat_number_id'");
            }

        }
 
        $response = array(
            "type"    => "success",
            "data"    => "¡Successfully assigned client!",
            "data_personal"    => $estructura,
        );  

        $mysqli->close();
        print_r(json_encode($response));  exit;


        /* if($data_personal == null)
        {

            $inf_data = tener_staff($mysqli, $staff_id);

            $inf_data_customers = tener_custumers($mysqli, $custumers_id);

            //echo json_encode($inf_data_customers); exit;

            $id                   = $chat_number_id;
            $number               = $chat_number_number;
            $custumer_id          = $custumers_id;
            $staff_id_db          = $staff_id;
            $created_at           = $chat_number_created_at;

            //PERTENECE STAFF
            $fullname_staff       = $inf_data["fullname_staff"] ?? "Unassigned staff";
            $username_staff       = $inf_data["username_staff"] ?? "";
            $user_type_staff      = $inf_data["user_type_staff"] ?? "";
            $phonenumber          = $inf_data["phonenumber"] ?? "";

            //PERTENECE CUSTOMERS
            $nombre               = $inf_data_customers["account"] ?? "Desconocido";
            $email_custumers      = $inf_data_customers["email_custumers"] ?? "";
            $phone_custumers      = $inf_data_customers["phone_custumers"] ?? "";
            $company_custumers    = $inf_data_customers["company_custumers"] ?? "";
            $address_custumers    = $inf_data_customers["address_custumers"] ?? "";

            $accion = "agregar";

            
        }else{

            $inf_data = tener_staff($mysqli, $staff_id);

            $inf_data_customers = tener_custumers($mysqli, $custumers_id);

            $id                   = $data_personal["id"];
            $number               = $data_personal["number"];
            $custumer_id          = $data_personal["custumer_id"];
            $staff_id_db          = $data_personal["staff_id"];
            $created_at           = $data_personal["created_at"];
            
            //PERTENECE CUSTOMERS
            $nombre               = $inf_data_customers["account"];
            $email_custumers      = $inf_data_customers["email_custumers"];
            $phone_custumers      = $inf_data_customers["phone_custumers"];
            $company_custumers    = $inf_data_customers["company_custumers"];
            $address_custumers    = $inf_data_customers["address_custumers"];

            //PERTENECE STAFF
            $fullname_staff       = $inf_data["fullname_staff"];
            $username_staff       = $inf_data["username_staff"];
            $user_type_staff      = $inf_data["user_type_staff"];
            $phonenumber          = $inf_data["phonenumber"];

            if($staff_id == $staff_id_db)
            {
                $accion = "modificar";
            }else{
                $accion = "eliminar";
            }
        } */
        
    
        /* if($accion == "agregar" || $accion == "modificar")
        {
            $estructura = [
                'id'                  => $id,
                'number'              => $number,
                'custumer_id'         => $custumer_id,
                'staff_id'            => $staff_id_db, // base de datos
                //'staff_id_nuevo'      => $staff_id, // viene del frontend
                'created_at'          => $created_at,
                'mensajes_no_leidos'  => $mensajes_no_leidos,
                'nombre'              => $nombre,
                'email_custumers'     => $email_custumers,
                'phone_custumers'     => $phone_custumers,
                'company_custumers'   => $company_custumers,
                'address_custumers'   => $address_custumers,
                'fullname_staff'      => $fullname_staff,
                'username_staff'      => $username_staff,
                'user_type_staff'     => $user_type_staff,
                'phonenumber'         => $phonenumber,
                'accion'              => "modificar",
                "db"                  => DB_NAME, 
                 
            ];

            //echo json_encode($estructura); exit;
    
            enviarSocket($estructura);

            //echo json_encode($estructura); exit;

            //$mysqli->query("UPDATE chat_number SET staff_id='$staff_id', custumer_id='$custumers_id' WHERE id='$chat_number_id'");

            $mysqli->query("UPDATE chat_number SET staff_id='$staff_id', custumer_id='$custumers_id' WHERE id='$chat_number_id'");


            $response = array(
                "type"    => "success",
                "data"    => "¡Successfully assigned client!",
                "data_personal"    => $estructura,
            );  
    
            $mysqli->close();
            print_r(json_encode($response));  exit;
     
        }else{
            //cuando entra aqui es porque va a eliminar en una y agregar en otra
            $estructura_eliminar = [
                'id'                  => $id,
                'number'              => $number,
                'custumer_id'         => $custumer_id,
                'staff_id'            => $staff_id_db, // base de datos
                //'staff_id_nuevo'      => $staff_id, // viene del frontend
                'created_at'          => $created_at,
                'mensajes_no_leidos'  => $mensajes_no_leidos,
                'nombre'              => $nombre,
                'email_custumers'     => $email_custumers,
                'phone_custumers'     => $phone_custumers,
                'company_custumers'   => $company_custumers,
                'address_custumers'   => $address_custumers,
                'fullname_staff'      => $fullname_staff,
                'username_staff'      => $username_staff,
                'user_type_staff'     => $user_type_staff,
                'phonenumber'         => $phonenumber,
                'accion'              => $accion,
                "db"                  => DB_NAME, 
                 
            ];
    
            enviarSocket($estructura_eliminar);

            $estructura_agregar = [
                'id'                  => $id,
                'number'              => $number,
                'custumer_id'         => $custumer_id,
                'staff_id'            => $staff_id, // base de datos
                //'staff_id_nuevo'      => $staff_id, // viene del frontend
                'created_at'          => $created_at,
                'mensajes_no_leidos'  => $mensajes_no_leidos,
                'nombre'              => $nombre,
                'email_custumers'     => $email_custumers,
                'phone_custumers'     => $phone_custumers,
                'company_custumers'   => $company_custumers,
                'address_custumers'   => $address_custumers,
                'fullname_staff'      => $fullname_staff,
                'username_staff'      => $username_staff,
                'user_type_staff'     => $user_type_staff,
                'phonenumber'         => $phonenumber,
                'accion'              => "agregar",
                "db"                  => DB_NAME, 
                 
            ];

            $mysqli->query("UPDATE chat_number SET staff_id='$staff_id', custumer_id='$custumers_id' WHERE id='$chat_number_id'");

    
            enviarSocket($estructura_agregar);

            $response = array(
                "type"    => "success",
                "data"    => "¡Successfully assigned client!",
                "data_personal"    => $estructura_agregar,
            );  
    
            $mysqli->close();
            print_r(json_encode($response));  exit;
        } */

        

 
 
    break;

    case 'asignar-custumers-chat-empleado':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $chat_number_id  = $informacion_front['chat_number_id'];
        $custumers_id    = $informacion_front['custumers_id'];
         
        if(empty($chat_number_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Contacto is required",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($custumers_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Customers is required",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $existe = $mysqli->query("SELECT * from chat_number WHERE id='$chat_number_id'")->fetch_all(MYSQLI_ASSOC) ?? [];

        if(count($existe) == 0)
        {
            $response = array(
                "type" => "error",
                "data" => "¡The contact id does not exist!",
            );
    
            print_r(json_encode($response)); exit;
        }

        $chat_number_id = $existe[0]["id"];
        $chat_number_number = $existe[0]["number"];
        $chat_number_staff_id = $existe[0]["staff_id"];
        $chat_number_created_at = $existe[0]["created_at"];


        //$contacts = Contact::select(['id','email','phone','company','address','account'])->where('id', $custumers_id)->first();
        $inf_data_customers = tener_custumers($mysqli, $custumers_id);

        if(!$inf_data_customers)
        {
            $response = array(
                "type" => "error",
                "data" => "¡The contact id does not exist!",
            );
    
            print_r(json_encode($response)); exit;
        }
        

        $id                   = null;
        $number               = null;
        $custumer_id          = null;
        $staff_id_db          = null;
        $created_at           = null;
        $mensajes_no_leidos   = null;
        $nombre               = null;
        $email_custumers      = null;
        $phone_custumers      = null;
        $company_custumers    = null;
        $address_custumers    = null;
        $fullname_staff       = null;
        $username_staff       = null;
        $user_type_staff      = null;
        $phonenumber          = null;

        //status delivered = whatsapp
        //status received  = sms

        //$msj_no_leidos_whatsapp = tener_mensajes_no_leidos($mysqli, $chat_number_id, "whatsapp", "delivered");
        //$msj_no_leidos_sms = tener_mensajes_no_leidos($mysqli, $chat_number_id, "sms", "received");
        //$mensajes_no_leidos =  $msj_no_leidos_whatsapp + $msj_no_leidos_sms;
    
        $inf_data = tener_staff($mysqli, $staff_id);

        $id                   = $chat_number_id;
        $number               = $chat_number_number;
        $custumer_id          = $custumers_id;
        $staff_id_db          = $staff_id;
        $created_at           = $chat_number_created_at;

        //PERTENECE STAFF
        $fullname_staff       = $inf_data["fullname_staff"];
        $username_staff       = $inf_data["username_staff"];
        $user_type_staff      = $inf_data["user_type_staff"];
        $phonenumber          = $inf_data["phonenumber"];

        //PERTENECE CUSTOMERS
        $nombre               = $inf_data_customers["account"];
        $email_custumers      = $inf_data_customers["email_custumers"];
        $phone_custumers      = $inf_data_customers["phone_custumers"];
        $company_custumers    = $inf_data_customers["company_custumers"];
        $address_custumers    = $inf_data_customers["address_custumers"];
    
        $estructura = [
            'id'                  => $id,
            'to'                  => $number,
            'custumer_id'         => $custumer_id,
            'created_at'          => $created_at,
            //'mensajes_no_leidos'=> $mensajes_no_leidos,
            'nombre'              => $nombre,
            'email_custumers'     => $email_custumers,
            'phone_custumers'     => $phone_custumers,
            'company_custumers'   => $company_custumers,
            'address_custumers'   => $address_custumers,
            'fullname_staff'      => $fullname_staff,
            'username_staff'      => $username_staff,
            'user_type_staff'     => $user_type_staff,
            'phonenumber_staff'   => $phonenumber,
            "db"                  => DB_NAME, 
             
        ];

        enviarSocketNotificarChatAdmin($estructura);
        $mysqli->query("UPDATE chat_number SET custumer_id='$custumers_id' WHERE id='$chat_number_id'");

        $response = array(
            "type"    => "success",
            "mensaje" => "¡Successfully assigned client!",
            "data"    => $estructura,
        );  

        $mysqli->close();
        print_r(json_encode($response));  exit;

 
    break;

    case 'agregar-custumers-contacto-chat':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        
        $tipo_configuracion_ws_sms_id    = $informacion_front['tipo_configuracion_ws_sms_id'];
        $account     = $informacion_front['account'];
        $display_name    = $informacion_front['display_name'];
        $country     = $informacion_front['country'];
        $address     = $informacion_front['address'];
        $city        = $informacion_front['city'];
        $email       = $informacion_front['email'];
        $currency    = $informacion_front['currency'];
        $owner_id    = $informacion_front['owner_id'];
        $username    = $informacion_front['username'];
        $state       = $informacion_front['state'];
        $zip         = $informacion_front['zip'];
        $numero_contacto    = $informacion_front['numero_contacto'];
        $business_number    = $informacion_front['business_number'];
        $staff_id    = $informacion_front['staff_id'];
        $id_contacto_seleccionado    = $informacion_front['id_contacto_seleccionado'];



        /* {
        business_number
            "account": "prueba fullname",
            "display_name": "prueba displayname",
            "country": "Honduras",
            "address": "direccion",
            "city": "san pedro sula",
            "email": "prueba@hotmail.com",
            "currency": "1",
            "owner_id": "1",
            "username": "pruebaxd",
            "state": "State/Region",
            "zip": "1111",
            "numero_contacto": 16318098987,
            "tipo_configuracion_ws_sms_id": 2
        } */

        if(empty($id_contacto_seleccionado) == true)
         {
             $response = array(
                 "type" => "error",
                 "message" => "Contact must be required.",
                 "data" => [],
             );
             print_r(json_encode( $response)) ; exit;
         }
 
         if(empty($account) == true)
         {
             $response = array(
                 "type" => "error",
                 "message" => "The Full Name field is required.",
                 "data" => [],
             );
             print_r(json_encode( $response)) ; exit;
         }

         if(empty($staff_id) == true)
         {
             $response = array(
                 "type" => "error",
                 "message" => "The Staff is required.",
                 "data" => [],
             );
             print_r(json_encode( $response)) ; exit;
         }
 

         /* if(empty($display_name) == true)
         {
             $response = array(
                 "type" => "error",
                 "message" => "The Display Name field is required.",
                 "data" => [],
             );
             print_r(json_encode( $response)) ; exit;
         } */
 
         if(empty($country) == true)
         {
             $response = array(
                 "type" => "error",
                 "message" => "The Country field is required.",
                 "data" => [],
             );
             print_r(json_encode( $response)) ; exit;
         }
 
 
         if(empty($address) == true)
         {
             $response = array(
                 "type" => "error",
                 "message" => "The Address field is required.",
                 "data" => [],
             );
             print_r(json_encode( $response)) ; exit;
         }
 
         if(empty($city) == true)
         {
             $response = array(
                 "type" => "error",
                 "message" => "The City field is required.",
                 "data" => [],
             );
             print_r(json_encode( $response)) ; exit;
         }

         if(empty($email) == true)
         {
             $response = array(
                 "type" => "error",
                 "message" => "The Email field is required.",
                 "data" => [],
             );
             print_r(json_encode( $response)) ; exit;
         }
 
         if(empty($currency) == true)
         {
             $response = array(
                 "type" => "error",
                 "message" => "The Currency field is required.",
                 "data" => [],
             );
             print_r(json_encode( $response)) ; exit;
         }

         if(empty($owner_id) == true)
         {
             $response = array(
                 "type" => "error",
                 "message" => "The Owner ID field is required.",
                 "data" => [],
             );
             print_r(json_encode( $response)) ; exit;
         }
 
         /* if(empty($username) == true)
         {
             $response = array(
                 "type" => "error",
                 "message" => "The Username field is required.",
                 "data" => [],
             );
             print_r(json_encode( $response)) ; exit;
         } */

         if(empty($state) == true)
         {
             $response = array(
                 "type" => "error",
                 "message" => "The State field is required.",
                 "data" => [],
             );
             print_r(json_encode( $response)) ; exit;
         }
 

         if(empty($zip) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "The ZIP field is required.",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($tipo_configuracion_ws_sms_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Settings whatsapp/sms id is required",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }
  
        //echo "llego"; exit;
 
 
        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $existe = $mysqli->query("SELECT * from crm_accounts WHERE email='$email'")->fetch_all(MYSQLI_ASSOC) ?? [];

        if(count($existe) != 0)
        {
            $response = array(
                "type" => "error",
                "message" => "¡The mail already exists!",
            );
    
            print_r(json_encode($response)); exit;
        }

        /* $contactos = $mysqli->query("SELECT 
                                            cn.id, 
                                            cn.number, 
                                            cn.custumer_id, 
                                            cn.staff_id,
                                            LOWER(DATE_FORMAT(cn.created_at, '%d-%m-%Y %I:%i %p')) AS created_at, 
                                            IFNULL(crm_a.account, 'Desconocido') AS nombre,
                                            crm_a.email AS email_custumers,
                                            crm_a.phone AS phone_custumers,
                                            crm_a.company AS company_custumers,
                                            crm_a.address AS address_custumers,
                                            IFNULL(sys_u.fullname, 'Unassigned staff') AS fullname_staff,
                                            sys_u.username AS username_staff,
                                            sys_u.user_type AS user_type_staff,
                                            sys_u.phonenumber AS phonenumber,
                                            sys_u.config_whatsapp_other_id AS 'sys_users_config_whatsapp_other_id'
                                          
                                        FROM 
                                            chat_number AS cn 
                                            LEFT JOIN crm_accounts AS crm_a 
                                                ON crm_a.id = cn.custumer_id
                                            LEFT JOIN sys_users AS sys_u 
                                                ON sys_u.id = cn.staff_id

                                            WHERE cn.id=$id_contacto_seleccionado

                                        ")->fetch_assoc() ;

        echo json_encode($contactos); exit;

            */
        /* {
            "tipo_producto": "sms",
            "id": "31",
            "number": "50498632131",
            "custumer_id": "11790",
            "staff_id": "1",
            "created_at": "12-08-2024 12:53 pm",
            "mensajes_no_leidos": 0,
            "nombre": "Mr. xxx  xx",
            "email_custumers": "",
            "phone_custumers": "",
            "company_custumers": "",
            "address_custumers": "",
            "fullname_staff": "Edilberto Martinez",
            "username_staff": "edilberto@hispanosdeexitollc.info",
            "user_type_staff": "Admin",
            "phonenumber": "+15162526299",
            "sys_users_config_whatsapp_other_id": "1",
            "config_whatsapp_other_id": "1",
            "mensajes_no_leidos_sms": 0,
            "mensajes_no_leidos_whatsapp": 0
        } */

        $d = ORM::for_table('crm_accounts')->create();

        $d->account = $account;
        $d->email = $email;
        $d->phone = $numero_contacto;
        $d->address = $address;
        $d->city = $city;
        $d->zip = $zip;
        $d->state = $state;
        $d->country = $country;
        $d->tags = Arr::arr_to_str($tags);

        $d->fname = '';
        $d->lname = '';
        $d->company = "";
        $d->jobtitle = '';
        $d->cid = "";
        $d->o = $owner_id;
        $d->balance = '0.00';
        $d->status = 'Active';
        $d->notes = '';
        $d->password = null;
        $d->token = '';
        $d->ts = '';
        $d->img = '';
        $d->web = '';
        $d->facebook = '';
        $d->google = '';
        $d->linkedin = '';

        $d->gname = null;
        $d->gid = 0;
        $d->currency = $currency;
        $d->created_at = date('Y-m-d H:i:s');
        $d->type = "Customer";
        $d->business_number = $business_number;
        $d->fax = null;
        $drive = time() . Misc::random_string(12);
        $d->drive = $drive;
        $d->code = $code;
        $d->secondary_email = null;
        $d->o = $user->id;

        $d->save();

        $cid = $d->id();

        //$staff_id = $user->id;

        $cid = mysqli_real_escape_string($mysqli, $cid);
        $staff_id = mysqli_real_escape_string($mysqli, $staff_id);
        $numero_contacto = mysqli_real_escape_string($mysqli, $numero_contacto);
        $tipo_configuracion_ws_sms_id = mysqli_real_escape_string($mysqli, $tipo_configuracion_ws_sms_id);

        $query = "UPDATE chat_number SET 
                    custumer_id = '$cid', 
                    staff_id = '$staff_id' 
                WHERE `number` = '$numero_contacto' AND config_whatsapp_other_id = '$tipo_configuracion_ws_sms_id'";

        $result = $mysqli->query($query);


        //echo $cid; exit; 

        $id_contacto_seleccionado = mysqli_real_escape_string($mysqli, $id_contacto_seleccionado);

        $contactos = $mysqli->query("SELECT 
                                            cn.id, 
                                            cn.number, 
                                            cn.custumer_id, 
                                            cn.staff_id,
                                            LOWER(DATE_FORMAT(cn.created_at, '%d-%m-%Y %I:%i %p')) AS created_at, 
                                            IFNULL(crm_a.account, 'Desconocido') AS nombre,
                                            crm_a.email AS email_custumers,
                                            crm_a.phone AS phone_custumers,
                                            crm_a.company AS company_custumers,
                                            crm_a.address AS address_custumers,
                                            IFNULL(sys_u.fullname, 'Unassigned staff') AS fullname_staff,
                                            sys_u.username AS username_staff,
                                            sys_u.user_type AS user_type_staff,
                                            sys_u.phonenumber AS phonenumber,
                                            sys_u.config_whatsapp_other_id AS 'sys_users_config_whatsapp_other_id'
                                          
                                        FROM 
                                            chat_number AS cn 
                                            LEFT JOIN crm_accounts AS crm_a 
                                                ON crm_a.id = cn.custumer_id
                                            LEFT JOIN sys_users AS sys_u 
                                                ON sys_u.id = cn.staff_id

                                            WHERE cn.id=$id_contacto_seleccionado

                                        ")->fetch_assoc() ;

 
        $salida = array(
            "type"               => "success",
            "message"            => "Message sent",
            "contactos"          => $contactos,
        );

        print_r(json_encode($salida)); exit;

 
    break;

    case 'enviar-mensaje-documentos':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $mensaje                        = $informacion_front['mensaje'];
        $archivo                        = $informacion_front['archivo'];
        $filename                       = $informacion_front['filename'];
        $tipo_usuario                   = $informacion_front['tipo_usuario'];
        $staff_id                       = $informacion_front['staff_id'];
        $to                             = $informacion_front['to'];
        $from                           = $informacion_front['from'];
        $phone_number_id                = $informacion_front['phone_number_id'];
        $tipo_documento                 = $informacion_front['tipo_documento'];

        $token_acceso                   = $informacion_front['token_acceso'];
        $version_api_whatapp            = $informacion_front['version_api_whatapp'];
        $configuracion_whatsapp_sms_id  = $informacion_front['configuracion_whatsapp_sms_id'];

        if(empty($configuracion_whatsapp_sms_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp settings / sms id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($token_acceso) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp Token is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($version_api_whatapp) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp Api Version is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

         
        if(empty($archivo) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Document is required",
                "data" => [],
            );
            print_r(json_encode($response)) ; exit;
        }

        if(empty($tipo_documento) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Type Document is required",
                "data" => [],
            );
            print_r(json_encode($response)) ; exit;
        }

        if(empty($tipo_usuario) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Type users is required",
                "data" => [],
            );
            print_r(json_encode($response)) ; exit;
        }

        if(empty($from) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required Phone number, created in developer Facebook",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($to) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required a phone to send a message",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($phone_number_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required: Phone number identifier",
            );
            print_r(json_encode( $response)) ; exit;
        }
 

        $url = "https://graph.facebook.com/$version_api_whatapp/$phone_number_id/messages";


        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $existeMensajesPendientes = 0;

        if($tipo_usuario != "admin")
        {

            if(empty($staff_id) == true)
            {
                $response = array(
                    "type" => "error",
                    "message" => "Staff is required",
                    "data" => [],
                );
                print_r(json_encode( $response)) ; exit;
            }

            /* $existe = $mysqli->query("SELECT * from chat_number WHERE `number`='$to' AND staff_id='$staff_id'")->fetch_all(MYSQLI_ASSOC) ?? [];

            if(count($existe) == 0)
            {
                $response = array(
                    "type" => "error",
                    "data" => "¡You are not assigned to send a message to this number!",
                );
        
                print_r(json_encode($response)); exit;
            } */
            $existe = $mysqli->query("SELECT COUNT(*) AS total FROM chat_number WHERE `number`='$to' AND staff_id='$staff_id'")->fetch_assoc();

            if($existe["total"] == 0)
            {
                $response = array(
                    "type" => "error",
                    "data" => "¡You are not assigned to send a message to this number!",
                );
        
                print_r(json_encode($response)); exit;
            }

            $chat_number = $mysqli->query("SELECT id FROM `chat_number` WHERE staff_id='$staff_id' AND `number` != '$to'")->fetch_all(MYSQLI_ASSOC) ;
            $ids = array_column($chat_number, 'id');
            $ids_concatenados = implode(',', $ids);

            if(empty($ids_concatenados) != true)
            {
                $res         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `status`='delivered' AND esContacto=1 AND chat_number_id IN ($ids_concatenados) ");
                $row         = $res->fetch_assoc(); 
                $existeMensajesPendientes          = $row['total_mensajes'] + 0;
            }else{
                $existeMensajesPendientes = 0;
            }


        }else{
            //aqui si es admin
            $chat_number = $mysqli->query("SELECT id FROM `chat_number` WHERE  `number` = '$to' AND config_whatsapp_other_id ='$configuracion_whatsapp_sms_id' AND staff_id='$staff_id'")->fetch_all(MYSQLI_ASSOC) ;
            $ids = array_column($chat_number, 'id');
            $ids_concatenados = implode(',', $ids);

            if(empty($ids_concatenados) != true)
            {
                $res         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `status`='delivered' AND esContacto=1  AND chat_number_id NOT IN ($ids_concatenados)  ");
                $row         = $res->fetch_assoc(); 
                $existeMensajesPendientes  = $row['total_mensajes'] + 0;
            }else{
                $existeMensajesPendientes = 0;
            }

            //print_r(json_encode($existeMensajesPendientes)); exit;
            //exit;
        }

        $validacion_configuracion = $mysqli->query("SELECT id,zona_horaria FROM `config_whatsapp_other` WHERE id='$configuracion_whatsapp_sms_id' AND `status`=1")->fetch_assoc() ;

        if(empty($validacion_configuracion) == true)
        {
            $salida = array(
                "type" => "error",
                "message" => "WhatsApp/SMS settings not found or inactive",
                "wam_id" => null,
            );
            $mysqli->close();
            print_r(json_encode($salida)); 
            exit;
        }

        $zona_horaria = $validacion_configuracion["zona_horaria"];

        $fileDataDecoded = base64_decode($archivo);
        if ($fileDataDecoded == false) {
            $response = array(
                "type" => "error",
                "data" => "¡Error encoding file!",
            );
    
            print_r(json_encode($response)); exit;
        }

        $filename_original = $filename;
        $filename  = trim($filename);
        $extension = pathinfo($filename, PATHINFO_EXTENSION);

        $ruta_root = $_SERVER['DOCUMENT_ROOT'];   

        // Verificar si la ruta tiene una barra al final
        if (substr($ruta_root, -1) === '/') {
            // Si hay una barra al final, eliminarla
            $ruta_root = rtrim($ruta_root, '/');
        }

        $tipo_proyecto_produccion = APP_DIRECTORIO;
 
        $basePath = $ruta_root . "/$tipo_proyecto_produccion/storage/whatsapp/$extension/";
        $path_db = "/storage/whatsapp/$extension/";
        $numero_aleatorio = rand(1, 100000); 

        if(!file_exists($basePath))
        {
           mkdir($basePath, 0777, true);
           createHtmlFile($basePath."/index.html");
        } 

        $formato = date('Y-m-d-H-i-s');
                    
        $nombre_archivo = $formato."_".$numero_aleatorio . "_from" . $from . "_to" . $to . "_enviado.$extension";
        $folderPath = $basePath;
        $file = $folderPath . $nombre_archivo ;

        file_put_contents($file, $fileDataDecoded);

        $url_final = APP_URL . $path_db . $nombre_archivo;

        $messageId = null;

        //marcar como leidos
        $marcar_leidos = $mysqli->query("SELECT wam_id FROM chat_social WHERE `status`='delivered' AND `from`='$from' AND `to`='$to' AND esContacto=1 AND tipo_producto='whatsapp' AND config_whatsapp_other_id='$configuracion_whatsapp_sms_id' order by id desc")->fetch_all(MYSQLI_ASSOC) ;
       

        if($tipo_documento == "document")
        {
            $data = array(
                "messaging_product" => "whatsapp",
                "recipient_type" => "individual",
                "to" => $to,
                "type" => "document",
                "document" => array(
                    "link" => $url_final,
                    "caption" => $mensaje
                )
            );
            
    
            $jsonData = json_encode($data);
    
            $curl = curl_init();
    
            curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $jsonData,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Authorization: Bearer ' . $token_acceso,
                ),
            ));
    
            $response = curl_exec($curl);
    
            $responseData = json_decode($response, true);
            $messageId = $responseData['messages'][0]['id'];
    
            curl_close($curl);
    
            if(isset($messageId) == false)
            {
                $salida = array(
                    "type" => "error",
                    "message" => $responseData['error']["message"],
                    "wam_id" => null,
                );
                $mysqli->close();
                print_r(json_encode($salida)); 
                exit;
            }
        }

        if($tipo_documento == "audio")
        {
            $data = array(
                "messaging_product" => "whatsapp",
                "recipient_type" => "individual",
                "to" => $to,
                "type" => "audio",
                "audio" => array(
                    "link" => $url_final,
                )
            );
            
    
            $jsonData = json_encode($data);
    
            $curl = curl_init();
    
            curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $jsonData,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Authorization: Bearer ' . $token_acceso,
                ),
            ));
    
            $response = curl_exec($curl);
    
            $responseData = json_decode($response, true);
            $messageId = $responseData['messages'][0]['id'];
    
            curl_close($curl);
    
            if(isset($messageId) == false)
            {
                $salida = array(
                    "type" => "error",
                    "message" => "error sending message type image",
                    "wam_id" => null,
                );
                $mysqli->close();
                print_r(json_encode($salida)); 
                exit;
            }
        }
 
        /* if(count($marcar_leidos) != 0)
        {
            // ID del mensaje wam_id
            $messageId = $marcar_leidos[0]["wam_id"];

            if($messageId != null)
            {   
                marcar_leidos($messageId, $url, $token_acceso, $mysqli, $from, $to);
            }

        } */

        //$mysqli->begin_transaction();

        try {

            //se crea un numero en caso de que no exista
            $sql = "INSERT INTO chat_number (`number`, config_whatsapp_other_id)
                    SELECT '$to', '$configuracion_whatsapp_sms_id'
                    FROM DUAL
                    WHERE NOT EXISTS (
                        SELECT 1
                        FROM chat_number
                        WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id
                    );";

            $mysqli->query($sql);
   

            $id_chat_number = null;

            // Comprobar si se insertó una fila nueva
            if ($mysqli->affected_rows > 0) {
                $id_chat_number = $mysqli->insert_id;
            } else {
                //$sql = "SELECT id FROM chat_number WHERE `number` = '$to'";
                $sql = "SELECT id FROM chat_number WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id";
                $result = $mysqli->query($sql);

                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    $id_chat_number = $row['id'];
                }  
            }

            //$fechaActual = Carbon::now();
            if(empty($zona_horaria) == true)
            {
                $fechaActual   = Carbon::now();
            }else{
                $fechaActual   = Carbon::now()->setTimezone($zona_horaria);
            }

            // Construcción de la consulta SQL
            $sql = "INSERT INTO chat_social (
                wam_id, 
                chat_number_id, 
                `from`, 
                `to`, 
                mensaje, 
                `url`, 
                `filename`,
                tipo_mensaje, 
                esContacto, 
                error_codigo, 
                error_mensaje, 
                phone_number_id,
                tipo_producto, 
                fecha_creacion, 
                `status`,
                config_whatsapp_other_id,
                user_id
            ) VALUES (
                '$messageId', 
                '$id_chat_number', 
                '$from', 
                '$to', 
                '$mensaje', 
                '$url_final', 
                '$filename_original', 
                '$tipo_documento', 
                0, 
                '', 
                '', 
                '$phone_number_id', 
                'whatsapp',
                '$fechaActual', 
                'sent',
                 $configuracion_whatsapp_sms_id,
                 $staff_id
            )";

            $ultimoId = $mysqli->insert_id;

            $mysqli->query($sql);

            //$mysqli->commit();

            $salida = array(
                "type"               => "success",
                "message"            => "Message sent",
                "id_chat_social"     => $ultimoId,
                "wam_id"             => $messageId,
                "url"                => $url_final,
                "tipo_documento"     => $tipo_documento,
                "mensajes_no_leidos" => count($marcar_leidos),
                "mensajes_no_leidos_pendiente"  => $existeMensajesPendientes,
                "fecha_creacion"                => $fechaActual->format('d-m-Y h:i A'),  
            );
          
            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($salida)); exit;
           
        } catch (Exception $e) {
           
            $response = array(
                "type" => "error",
                "message" => "Insert failed: (" . $mysqli->errno . ") " . $mysqli->error,
                "details" =>  $e->getMessage(),
                "wam_id" => null,
                "url"     => $url_final,
            );

            //$mysqli->rollback();

            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($response)); exit;
        }


 
        
    break;

    case 'enviar-mensaje-voices':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $mensaje                        = $informacion_front['mensaje'];
        $archivo                        = $informacion_front['archivo'];
        $tipo_usuario                   = $informacion_front['tipo_usuario'];
        $staff_id                       = $informacion_front['staff_id'];
        $to                             = $informacion_front['to'];
        $from                           = $informacion_front['from'];
        $phone_number_id                = $informacion_front['phone_number_id'];
        $token_acceso                   = $informacion_front['token_acceso'];
        $version_api_whatapp            = $informacion_front['version_api_whatapp'];
        $configuracion_whatsapp_sms_id  = $informacion_front['configuracion_whatsapp_sms_id'];

        if(empty($configuracion_whatsapp_sms_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp settings / sms id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($token_acceso) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp Token is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($version_api_whatapp) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp Api Version is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

         
        if(empty($archivo) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Document is required",
                "data" => [],
            );
            print_r(json_encode($response)) ; exit;
        }

        if(empty($tipo_usuario) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Type users is required",
                "data" => [],
            );
            print_r(json_encode($response)) ; exit;
        }

        if(empty($from) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required Phone number, created in developer Facebook",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($to) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required a phone to send a message",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($phone_number_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required: Phone number identifier",
            );
            print_r(json_encode( $response)) ; exit;
        }
 

        $url = "https://graph.facebook.com/$version_api_whatapp/$phone_number_id/messages";


        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $existeMensajesPendientes = 0;

        if($tipo_usuario != "admin")
        {

            if(empty($staff_id) == true)
            {
                $response = array(
                    "type" => "error",
                    "message" => "Staff is required",
                    "data" => [],
                );
                print_r(json_encode( $response)) ; exit;
            }

            /* $existe = $mysqli->query("SELECT * from chat_number WHERE `number`='$to' AND staff_id='$staff_id'")->fetch_all(MYSQLI_ASSOC) ?? [];

            if(count($existe) == 0)
            {
                $response = array(
                    "type" => "error",
                    "data" => "¡You are not assigned to send a message to this number!",
                );
        
                print_r(json_encode($response)); exit;
            } */
            $existe = $mysqli->query("SELECT COUNT(*) AS total FROM chat_number WHERE `number`='$to' AND staff_id='$staff_id'")->fetch_assoc();

            if($existe["total"] == 0)
            {
                $response = array(
                    "type" => "error",
                    "data" => "¡You are not assigned to send a message to this number!",
                );
        
                print_r(json_encode($response)); exit;
            }

            $chat_number = $mysqli->query("SELECT id FROM `chat_number` WHERE staff_id='$staff_id' AND `number` != '$to'")->fetch_all(MYSQLI_ASSOC) ;
            $ids = array_column($chat_number, 'id');
            $ids_concatenados = implode(',', $ids);

            if(empty($ids_concatenados) != true)
            {
                $res         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `status`='delivered' AND esContacto=1 AND chat_number_id IN ($ids_concatenados) ");
                $row         = $res->fetch_assoc(); 
                $existeMensajesPendientes          = $row['total_mensajes'] + 0;
            }else{
                $existeMensajesPendientes = 0;
            }


        }else{
            //aqui si es admin
            $chat_number = $mysqli->query("SELECT id FROM `chat_number` WHERE  `number` = '$to' AND config_whatsapp_other_id ='$configuracion_whatsapp_sms_id' AND staff_id='$staff_id'")->fetch_all(MYSQLI_ASSOC) ;
            $ids = array_column($chat_number, 'id');
            $ids_concatenados = implode(',', $ids);

            if(empty($ids_concatenados) != true)
            {
                $res         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `status`='delivered' AND esContacto=1  AND chat_number_id NOT IN ($ids_concatenados)  ");
                $row         = $res->fetch_assoc(); 
                $existeMensajesPendientes  = $row['total_mensajes'] + 0;
            }else{
                $existeMensajesPendientes = 0;
            }

            //print_r(json_encode($existeMensajesPendientes)); exit;
            //exit;
        }

        $validacion_configuracion = $mysqli->query("SELECT id, zona_horaria FROM `config_whatsapp_other` WHERE id='$configuracion_whatsapp_sms_id' AND `status`=1")->fetch_assoc() ;

        if(empty($validacion_configuracion) == true)
        {
            $salida = array(
                "type" => "error",
                "message" => "WhatsApp/SMS settings not found or inactive",
                "wam_id" => null,
            );
            $mysqli->close();
            print_r(json_encode($salida)); 
            exit;
        }

        $zona_horaria = $validacion_configuracion["zona_horaria"];

        $fileDataDecoded = base64_decode($archivo);
        if ($fileDataDecoded == false) {
            $response = array(
                "type" => "error",
                "data" => "¡Error encoding file!",
            );
    
            print_r(json_encode($response)); exit;
        }
         
        $extension = "ogg";

        $ruta_root = $_SERVER['DOCUMENT_ROOT'];   

        // Verificar si la ruta tiene una barra al final
        if (substr($ruta_root, -1) === '/') {
            // Si hay una barra al final, eliminarla
            $ruta_root = rtrim($ruta_root, '/');
        }

        $tipo_proyecto_produccion = APP_DIRECTORIO;
 
        $basePath = $ruta_root . "/$tipo_proyecto_produccion/storage/whatsapp/$extension/";
        $path_db = "/storage/whatsapp/$extension/";
        $numero_aleatorio = rand(1, 100000); 

        if(!file_exists($basePath))
        {
           mkdir($basePath, 0777, true);
           createHtmlFile($basePath."/index.html");
        } 

        $formato = date('Y-m-d-H-i-s');
                    
        $nombre_archivo = $formato."_".$numero_aleatorio . "_from" . $from . "_to" . $to . "_enviado.$extension";
        $folderPath = $basePath;
        $file = $folderPath . $nombre_archivo ;

        file_put_contents($file, $fileDataDecoded);

        $url_final = APP_URL . $path_db . $nombre_archivo;

        //marcar como leidos
        $marcar_leidos = $mysqli->query("SELECT wam_id FROM chat_social WHERE `status`='delivered' AND `from`='$from' AND `to`='$to' AND esContacto=1 AND tipo_producto='whatsapp' AND config_whatsapp_other_id='$configuracion_whatsapp_sms_id' order by id desc")->fetch_all(MYSQLI_ASSOC) ;       

        $messageId = null;

        $data = array(
            "messaging_product" => "whatsapp",
            "recipient_type" => "individual",
            "to" => $to,
            "type" => "audio",
            "audio" => array(
                "link" => $url_final,
            )
        );

        $jsonData = json_encode($data);

        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $jsonData,
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token_acceso,
            ),
        ));

        $response = curl_exec($curl);

        $responseData = json_decode($response, true);
        $messageId = $responseData['messages'][0]['id'];

        curl_close($curl);

        if(isset($messageId) == false)
        {
            $salida = array(
                "type" => "error",
                "message" => "error sending message type image",
                "wam_id" => null,
            );
    
            print_r(json_encode($salida)); 
            exit;
        }

        /* if(count($marcar_leidos) != 0)
        {
            // ID del mensaje wam_id
            $messageId = $marcar_leidos[0]["wam_id"];

            if($messageId != null)
            {   
                marcar_leidos($messageId, $url, $token_acceso, $mysqli, $from, $to);
            }

        } */

        //$mysqli->begin_transaction();

        try {

            //se crea un numero en caso de que no exista
            $sql = "INSERT INTO chat_number (`number`, config_whatsapp_other_id)
            SELECT '$to', '$configuracion_whatsapp_sms_id'
            FROM DUAL
            WHERE NOT EXISTS (
                SELECT 1
                FROM chat_number
                WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id
            );";

            $mysqli->query($sql);
   

            $id_chat_number = null;

            // Comprobar si se insertó una fila nueva
            if ($mysqli->affected_rows > 0) {
                $id_chat_number = $mysqli->insert_id;
            } else {
                //$sql = "SELECT id FROM chat_number WHERE `number` = '$to'";
                $sql = "SELECT id FROM chat_number WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id";
                $result = $mysqli->query($sql);

                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    $id_chat_number = $row['id'];
                }  
            }

            //$fechaActual = Carbon::now();

            if(empty($zona_horaria) == true)
            {
                $fechaActual   = Carbon::now();
            }else{
                $fechaActual   = Carbon::now()->setTimezone($zona_horaria);
            }

            // Construcción de la consulta SQL
            $sql = "INSERT INTO chat_social (
                wam_id, 
                chat_number_id, 
                `from`, 
                `to`, 
                mensaje, 
                `url`, 
                `filename`,
                tipo_mensaje, 
                esContacto, 
                error_codigo, 
                error_mensaje, 
                phone_number_id,
                tipo_producto, 
                fecha_creacion, 
                `status`,
                config_whatsapp_other_id,
                user_id
            ) VALUES (
                '$messageId', 
                '$id_chat_number', 
                '$from', 
                '$to', 
                '$mensaje', 
                '$url_final', 
                '$filename_original', 
                'audio', 
                0, 
                '', 
                '', 
                '$phone_number_id', 
                'whatsapp',
                '$fechaActual', 
                'sent',
                $configuracion_whatsapp_sms_id,
                $staff_id
            )";

            $mysqli->query($sql);

            //$mysqli->commit();

            $finfo = finfo_open(FILEINFO_MIME_TYPE);
            $mimeType = finfo_file($finfo, $file);
            finfo_close($finfo);

            $salida = array(
                "type"               => "success",
                "message"            => "Message sent",
                "wam_id"             => $messageId,
                "url"                => $url_final,
                "mimeType"           => $mimeType,
                "mensajes_no_leidos" => count($marcar_leidos),
                "mensajes_no_leidos_pendiente"  => $existeMensajesPendientes,
                "fecha_creacion"                => $fechaActual->format('d-m-Y h:i A'),  
            );
          
            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($salida)); exit;
           
        } catch (Exception $e) {
           
            $response = array(
                "type" => "error",
                "message" => "Insert failed: (" . $mysqli->errno . ") " . $mysqli->error,
                "details" =>  $e->getMessage(),
                "wam_id" => null,
                "url"     => $url_final,
            );

            //$mysqli->rollback();

            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($response)); exit;
        }


 
        
    break;

    case 'enviar-mensaje-sms-texto':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $mensaje            = $informacion_front['mensaje'];
        $tipo_usuario       = $informacion_front['tipo_usuario'];
        $staff_id           = $informacion_front['staff_id'];
        $to                 = $informacion_front['to'];
        $from               = $informacion_front['from'];
        $account_sid        = $informacion_front['account_sid'];
        $auth_token         = $informacion_front['auth_token'];

        $configuracion_whatsapp_sms_id  = $informacion_front['configuracion_whatsapp_sms_id'];

        if(empty($configuracion_whatsapp_sms_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp settings / sms id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }
         

        if(empty($account_sid) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Account sid is required, created in twilio",
                "data" => [],
            );
            print_r(json_encode($response)) ; exit;
        }

        if(empty($auth_token) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Authentication token is required, created in twilio",
                "data" => [],
            );
            print_r(json_encode($response)) ; exit;
        }
 
        if(empty($tipo_usuario) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Type users is required",
                "data" => [],
            );
            print_r(json_encode($response)) ; exit;
        }

        if(empty($from) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Phone number required, created in twilio",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($to) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required a phone to send a message",
            );
            print_r(json_encode( $response)) ; exit;
        }

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $existeMensajesPendientes = 0;

        if($tipo_usuario != "admin")
        {

            if(empty($staff_id) == true)
            {
                $response = array(
                    "type" => "error",
                    "message" => "Staff is required",
                    "data" => [],
                );
                print_r(json_encode( $response)) ; exit;
            }

            /* $existe = $mysqli->query("SELECT * from chat_number WHERE `number`='$to' AND staff_id='$staff_id'")->fetch_all(MYSQLI_ASSOC) ?? [];

            if(count($existe) == 0)
            {
                $response = array(
                    "type" => "error",
                    "data" => "¡You are not assigned to send a message to this number!",
                );
        
                print_r(json_encode($response)); exit;
            } */
            $existe = $mysqli->query("SELECT COUNT(*) AS total FROM chat_number WHERE `number`='$to' AND staff_id='$staff_id'")->fetch_assoc();

            if($existe["total"] == 0)
            {
                $response = array(
                    "type" => "error",
                    "data" => "¡You are not assigned to send a message to this number!",
                );
        
                print_r(json_encode($response)); exit;
            }

            $chat_number = $mysqli->query("SELECT id FROM `chat_number` WHERE staff_id='$staff_id' AND `number` != '$to'")->fetch_all(MYSQLI_ASSOC) ;
            $ids = array_column($chat_number, 'id');
            $ids_concatenados = implode(',', $ids);

            if(empty($ids_concatenados) != true)
            {
                $res         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `status`='delivered' AND esContacto=1 AND chat_number_id IN ($ids_concatenados) ");
                $row         = $res->fetch_assoc(); 
                $existeMensajesPendientes          = $row['total_mensajes'] + 0;
            }else{
                $existeMensajesPendientes = 0;
            }

        }else{
            //aqui si es admin
            $chat_number = $mysqli->query("SELECT id FROM `chat_number` WHERE  `number` = '$to' AND config_whatsapp_other_id ='$configuracion_whatsapp_sms_id' AND staff_id='$staff_id'")->fetch_all(MYSQLI_ASSOC) ;
            $ids = array_column($chat_number, 'id');
            $ids_concatenados = implode(',', $ids);

            if(empty($ids_concatenados) != true)
            {
                $res         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `status`='delivered' AND esContacto=1  AND chat_number_id NOT IN ($ids_concatenados)  ");
                $row         = $res->fetch_assoc(); 
                $existeMensajesPendientes  = $row['total_mensajes'] + 0;
            }else{
                $existeMensajesPendientes = 0;
            }

            //print_r(json_encode($existeMensajesPendientes)); exit;
            //exit;
        }

        $validacion_configuracion = $mysqli->query("SELECT id, zona_horaria FROM `config_whatsapp_other` WHERE id='$configuracion_whatsapp_sms_id' AND `status`=1")->fetch_assoc() ;

        if(empty($validacion_configuracion) == true)
        {
            $salida = array(
                "type" => "error",
                "message" => "WhatsApp/SMS settings not found or inactive",
                "wam_id" => null,
            );
            $mysqli->close();
            print_r(json_encode($salida)); 
            exit;
        }

        $zona_horaria = $validacion_configuracion["zona_horaria"];

        
        //mensajes no leidos
        $marcar_leidos = $mysqli->query("SELECT `sid` FROM chat_social WHERE `status`='received' AND `to`='$to' AND esContacto=1 AND tipo_producto='sms' AND config_whatsapp_other_id='$configuracion_whatsapp_sms_id' order by id desc")->fetch_all(MYSQLI_ASSOC) ;

        $url_sockets = "https://xhde365.com/socket-chat/mensajes/";

        $sys_appconfig = $mysqli->query("SELECT `value` FROM sys_appconfig WHERE setting='socket_webhook_sms'")->fetch_assoc();         

        if(empty($sys_appconfig) == false)
        {
            $url_sockets = $sys_appconfig["value"];
        }

        $url_sockets = rtrim($url_sockets, '/');

        //$mysqli->begin_transaction();

        try {

            //se crea un numero en caso de que no exista
            /* $sql = "INSERT INTO chat_number (`number`)
                SELECT '$to' 
                FROM DUAL
                WHERE NOT EXISTS (
                    SELECT 1
                    FROM chat_number
                    WHERE `number` = '$to'
                );"; */

            $sql = "INSERT INTO chat_number (`number`, config_whatsapp_other_id)
                SELECT '$to', '$configuracion_whatsapp_sms_id'
                FROM DUAL
                WHERE NOT EXISTS (
                    SELECT 1
                    FROM chat_number
                    WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id
                );";

            $mysqli->query($sql);

            $id_chat_number = null;

            // Comprobar si se insertó una fila nueva
            if ($mysqli->affected_rows > 0) {
                $id_chat_number = $mysqli->insert_id;
            } else {
                //$sql = "SELECT id FROM chat_number WHERE `number` = '$to'";
                $sql = "SELECT id FROM chat_number WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id";
                $result = $mysqli->query($sql);

                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    $id_chat_number = $row['id'];
                }  
            }

            $messageId   = null;
            $status      = null;

            //$fechaActual = Carbon::now();
            if(empty($zona_horaria) == true)
            {
                $fechaActual   = Carbon::now();
            }else{
                $fechaActual   = Carbon::now()->setTimezone($zona_horaria);
            }

            //echo U; exit; // resultado http://localhost:50001/app_dev/?ng=

            $db   = DB_NAME;
            $slug = APP_DIRECTORIO;
 
            $client = new Twilio\Rest\Client($account_sid, $auth_token);
            $message = $client->messages->create(
                // Where to send a text message (your cell phone?)
                "+$to", //50499196322 = jair 50498632131=jefe
                array(
                    'from' => "+$from",
                    'body' => "$mensaje",
                    'statusCallback' => $url_sockets. "/status?db=$db&url=$slug"
                )
            );

            if($message == null){

                $response = array(
                    "type" => "error",
                    "message" => "Error sending message to twilio",
                    "sid" => null,
                );
    
                $mysqli->close();
    
                print_r(json_encode($response)); exit;
                exit;
            }

            $messageId    = $message->sid;
            $status       = $message->status;


            // Construcción de la consulta SQL
            $sql = "INSERT INTO chat_social (
                wam_id, 
                `sid`, 
                chat_number_id, 
                `from`, 
                `to`, 
                mensaje, 
                `url`, 
                `filename`,
                tipo_mensaje, 
                esContacto, 
                error_codigo, 
                error_mensaje, 
                phone_number_id,
                tipo_producto, 
                fecha_creacion, 
                `status`,
                config_whatsapp_other_id,
                user_id
            ) VALUES (
                null, 
                '$messageId', 
                '$id_chat_number', 
                '$from', 
                '$to', 
                '$mensaje', 
                null, 
                null, 
                'text', 
                0, 
                null, 
                null, 
                null, 
                'sms',
                '$fechaActual', 
                '$status',
                $configuracion_whatsapp_sms_id,
                $staff_id
            )";

            $mysqli->query($sql);

            $ultimoId = $mysqli->insert_id;

            //$mysqli->commit();

            //marcar como leidos
            $mysqli->query("UPDATE chat_social SET `status` = 'read' WHERE `to` = '$to' AND `status` = 'received' AND esContacto = 1 AND tipo_producto = 'sms' AND config_whatsapp_other_id=$configuracion_whatsapp_sms_id;");

            $salida = array(
                "type"               => "success",
                "message"            => "Message sent",
                "id_chat_social"     => $ultimoId,
                "sid"                => $messageId,
                "status"             => $status,
                "mensaje"            => $mensaje,
                "mensajes_no_leidos" => count($marcar_leidos),
                "mensajes_no_leidos_pendiente"  => $existeMensajesPendientes,
                "fecha_creacion"      => $fechaActual->format('d-m-Y h:i A'),  
            );
           
            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($salida)); exit;
           
        } catch (Exception $e) {
           
            $response = array(
                "type" => "error",
                "message" => "Insert failed: (" . $mysqli->errno . ") " . $mysqli->error,
                "details" =>  $e->getMessage(),
                "sid" => null,
            );

            //$mysqli->rollback();

            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($response)); exit;
        }


 
        
    break;

    case 'configuracion-whatsapp-activo':

 
        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }
 
        $chat = [];

        $chat = $mysqli->query("SELECT * FROM `config_whatsapp_other` WHERE `status`=1")->fetch_all(MYSQLI_ASSOC);

        if(count($chat) != 0){
            $chat = $chat[0];
        }
  
        $response = array(
            "type"   => "success",
            "data"   => $chat,
        );
        $mysqli->close();
        print_r(json_encode( $response)) ; exit;

           
    break;

    case 'configuracion-whatsapp-other-id-empleados':

        $staff_id                           = $routes['2'];

        if(empty($staff_id) == true)
        {
            $response = array(
                "type"     => "error",
                "message"  => "Staff id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

 
        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }
 
 
        $usuario = $mysqli->query("SELECT * FROM `sys_users` WHERE id=$staff_id")->fetch_assoc();

        $data = null;

        if(empty($usuario) == false)
        {
            $config_whatsapp_other_id = $usuario["config_whatsapp_other_id"];

            if(empty($config_whatsapp_other_id) == true )
            {
                $response = array(
                    "type"      => "error",
                    "message"   => "This user does not have a WhatsApp/SMS configuration assigned",
                );
                $mysqli->close();
                print_r(json_encode( $response)) ; exit;
            }

            $data = $mysqli->query("SELECT * FROM `config_whatsapp_other` WHERE id=$config_whatsapp_other_id")->fetch_assoc();

            if(empty($data) == true )
            {
                $response = array(
                    "type"      => "error",
                    "message"   => "WhatsApp/SMS settings not found",
                );
                $mysqli->close();
                print_r(json_encode( $response)) ; exit;
            }

        }

  
  
        $response = array(
            "type"    => "success",
            "data"    => $data,
            "message" => "",
            
        );
        $mysqli->close();
        print_r(json_encode( $response)) ; exit;

           
    break;

    case 'lista-configuracion-whatsapp-activo':

 
        try {
            $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
            $mysqli->set_charset("utf8");
            // Establecer el conjunto de caracteres a UTF-8
            $mysqli->set_charset("utf8");
        } catch (\Exception $e) {
            $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            print_r(json_encode($response));
            exit;
        }
        
        $chat = $mysqli->query("SELECT * FROM `config_whatsapp_other` WHERE `status`=1 AND (`enable_whatsapp` = 1 OR `enable_twilio` = 1)")->fetch_all(MYSQLI_ASSOC);
        
        $response = array(
            "type" => "success",
            "data" => $chat,
        );
        $mysqli->close();
        print_r(json_encode($response));
        exit;
        
           
    break;


    case 'tener-plantillas-whatsapp':

 
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $token                         = $informacion_front['token'];
        $whatssapp_business_account_id = $informacion_front['whatssapp_business_account_id'];
        $limite                        = $informacion_front['limite'];
        $version                       = $informacion_front['version_api_whatapp'];
        
        if(empty($token) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Token is requerid",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($limite) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Limit is requerid",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($whatssapp_business_account_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatssapp business account id is requerid",
                "data" => [],
            );

            print_r(json_encode( $response)) ; exit;
        }

        if(empty($version) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Version is requerid",
                "data" => [],
            );
            
            print_r(json_encode( $response)) ; exit;
        }

        //$url = "https://graph.facebook.com/$version/{$whatssapp_business_account_id}/message_templates?limit=$limite";
        $url = "https://graph.facebook.com/$version/{$whatssapp_business_account_id}/message_templates";

        $ch = curl_init();
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Authorization: Bearer $token"
        ]);
        
        $response = curl_exec($ch);

        $IsError = true;
        $DetailsError = "";
        $data = [];
        
        if (curl_errno($ch)) {
            $DetailsError = curl_error($ch);
        } else {
            $data = json_decode($response, true);
        }
        
        curl_close($ch);

      
        $namespaces = null;
        $url = "https://graph.facebook.com/$version/$whatssapp_business_account_id?fields=message_template_namespace&access_token=$token";

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Authorization: Bearer $token"
        ]);

        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            $error_msg = curl_error($ch);
            echo "CURL Error: " . $error_msg;
        } else {
            $inf = json_decode($response, true);
            $namespaces = $inf["message_template_namespace"];
          
        }

        curl_close($ch);

        $response = array(
            "type"        => "success",
            "details"     => $DetailsError,
            "namcespaces" => $namespaces,
            "data"        => $data["data"],
            "paging"      => $data["paging"],
        );

        print_r(json_encode( $response)) ; exit;

           
    break;

    case 'enviar-mensaje-plantillas':
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $components                     = $informacion_front['components'];
        $language                       = $informacion_front['language']; //
        $name                           = $informacion_front['name']; //
        $to                             = $informacion_front['to']; //
        $from                           = $informacion_front['from'];  //
        $phone_number_id                = $informacion_front['phone_number_id'];
        $tipo_usuario                   = $informacion_front['tipo_usuario']; //
        $staff_id                       = $informacion_front['staff_id']; //
        $token_acceso                   = $informacion_front['token_acceso']; //
        $version_api_whatapp            = $informacion_front['version_api_whatapp']; //
        $namespaces                     = $informacion_front['namespaces']; //
        $plantilla_original             = $informacion_front['plantilla_original']; //
        $configuracion_whatsapp_sms_id  = $informacion_front['configuracion_whatsapp_sms_id'];

        if(empty($configuracion_whatsapp_sms_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp settings / sms id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($plantilla_original) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Template is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($to) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Shipping number is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($from) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "From number is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($name) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Name is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($language) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Language is required",
            );
            print_r(json_encode( $response)) ; exit;
        }
     
        if(empty($token_acceso) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp Token is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($version_api_whatapp) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp Api Version is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($phone_number_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Required: Phone number identifier",
            );
            print_r(json_encode( $response)) ; exit;
        }

        $url = "https://graph.facebook.com/$version_api_whatapp/$phone_number_id/messages";

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }


        $existeMensajesPendientes = 0;

        if($tipo_usuario != "admin")
        {

            if(empty($staff_id) == true)
            {
                $response = array(
                    "type" => "error",
                    "message" => "Staff is required",
                    "data" => [],
                );
                print_r(json_encode( $response)) ; exit;
            }

            /* $existe = $mysqli->query("SELECT * from chat_number WHERE `number`='$to' AND staff_id='$staff_id'")->fetch_all(MYSQLI_ASSOC) ?? [];

            if(count($existe) == 0)
            {
                $response = array(
                    "type" => "error",
                    "data" => "¡You are not assigned to send a message to this number!",
                );
        
                print_r(json_encode($response)); exit;
            } */
            $existe = $mysqli->query("SELECT COUNT(*) AS total FROM chat_number WHERE `number`='$to' AND staff_id='$staff_id'")->fetch_assoc();

            if($existe["total"] == 0)
            {
                $response = array(
                    "type" => "error",
                    "data" => "¡You are not assigned to send a message to this number!",
                );
        
                print_r(json_encode($response)); exit;
            }

            $chat_number = $mysqli->query("SELECT id FROM `chat_number` WHERE staff_id='$staff_id' AND `number` != '$to'")->fetch_all(MYSQLI_ASSOC) ;
            $ids = array_column($chat_number, 'id');
            $ids_concatenados = implode(',', $ids);

            if(empty($ids_concatenados) != true)
            {
                $res         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `status`='delivered' AND esContacto=1 AND chat_number_id IN ($ids_concatenados) ");
                $row         = $res->fetch_assoc(); 
                $existeMensajesPendientes          = $row['total_mensajes'] + 0;
            }else{
                $existeMensajesPendientes = 0;
            }


        }else{
            //aqui si es admin
            $chat_number = $mysqli->query("SELECT id FROM `chat_number` WHERE  `number` = '$to' AND config_whatsapp_other_id ='$configuracion_whatsapp_sms_id' AND staff_id='$staff_id'")->fetch_all(MYSQLI_ASSOC) ;
            $ids = array_column($chat_number, 'id');
            $ids_concatenados = implode(',', $ids);

            if(empty($ids_concatenados) != true)
            {
                $res         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `status`='delivered' AND esContacto=1  AND chat_number_id NOT IN ($ids_concatenados)  ");
                $row         = $res->fetch_assoc(); 
                $existeMensajesPendientes  = $row['total_mensajes'] + 0;
            }else{
                $existeMensajesPendientes = 0;
            }

            //print_r(json_encode($existeMensajesPendientes)); exit;
            //exit;
        }

        $validacion_configuracion = $mysqli->query("SELECT id FROM `config_whatsapp_other` WHERE id='$configuracion_whatsapp_sms_id' AND `status`=1")->fetch_assoc() ;

        if(empty($validacion_configuracion) == true)
        {
            $salida = array(
                "type" => "error",
                "message" => "WhatsApp/SMS settings not found or inactive",
                "wam_id" => null,
            );
            $mysqli->close();
            print_r(json_encode($salida)); 
            exit;
        }

        $zona_horaria = $validacion_configuracion["zona_horaria"];

        //marcar como leidos
        $marcar_leidos = $mysqli->query("SELECT wam_id FROM chat_social WHERE `status`='delivered' AND `from`='$from' AND `to`='$to' AND esContacto=1 AND tipo_producto='whatsapp' AND config_whatsapp_other_id='$configuracion_whatsapp_sms_id' order by id desc")->fetch_all(MYSQLI_ASSOC) ;

         
   
        $headers = [];
        $cabecera = [];
        $componente_preparado = [
            "messaging_product" => "whatsapp",
            "to"                => $to,
            "type"              => "template",
            "template"          => [
                    "namespace" => $namespaces,
                    "name"      => $name,
                    "language"  => [
                        "code"  => $language,
                    ],

                    "components"=>[]
                
            ],

        ];

        $formato_headers = "";

        foreach ($components as $component) {
            // Verificar si el campo 'texto' está vacío
            if ($component['type'] == "HEADER") {

                $format          = $component['format'];
                $formato_headers = $format;

                if($format == "text"){

                    $contenido = $component['contenido'];

                    $tipo = [
                        [
                            "type"  => $format,
                            "text" =>  $contenido,
                        ]
                     ];
     
                     $headers = [
                         "type" => "header",
                         "parameters" => $tipo 
                     ];

                    $componente_preparado["template"]["components"][] = $headers;

                    //print_r(json_encode($componente_preparado)); exit;


                }else{

                    if($format == "location"){

                        $tipo = [
                            [
                                "type"  => $format,
                                $format => [
                                        "latitude"  => $component['lati'],
                                        "longitude" => $component['lon'],
                                        "name"      => $component['address'],
                                        "address"   => $component['name'],
                                    ],
                            ]
                        ];
            
                        $headers = [
                            "type" => "header",
                            "parameters" => $tipo 
                        ];

                        //$componente_preparado["template"]["components"] = [$headers];
                        $componente_preparado["template"]["components"][] = $headers;


                    }else{
                        $contenido = $component['contenido'];

                        $extension = $component['extension'];
                        $ext       = explode('/', $extension)[1];

                        $ruta_root = $_SERVER['DOCUMENT_ROOT'];   

                        // Verificar si la ruta tiene una barra al final
                        if (substr($ruta_root, -1) === '/') {
                            // Si hay una barra al final, eliminarla
                            $ruta_root = rtrim($ruta_root, '/');
                        }

                        $tipo_proyecto_produccion = APP_DIRECTORIO;

                        $basePath = $ruta_root . "/$tipo_proyecto_produccion/storage/whatsapp/$ext/";
                        $path_db = "/storage/whatsapp/$ext/";
                        $numero_aleatorio = rand(1, 100000); 

                        if(!file_exists($basePath))
                        {
                            mkdir($basePath, 0777, true);
                            createHtmlFile($basePath."/index.html");
                        } 

                        $formato = date('Y-m-d-H-i-s');
                                    
                        $NombreArchivo = $formato."_".$numero_aleatorio . "_from" . $from . "_to" . $to . '_enviado.' . $ext;
                        
                        $folderPath = $basePath;
                        $archivo_base = base64_decode($contenido);
                        $file = $folderPath . $NombreArchivo ;

                        if($format == "image")
                        {
                            $imagen = imagecreatefromstring($archivo_base);

                            if ($imagen !== false)
                            {
                                $anchoOriginal = imagesx($imagen);
                                $altoOriginal  = imagesy($imagen);

                                $creado = DimensionesImagen($imagen,500,500,$anchoOriginal, $altoOriginal, $file);

                                if($creado == false)
                                {
                                    file_put_contents($file, $archivo_base);
                                }

                            }else{
                                file_put_contents($file, $archivo_base);
                            }
                        }else{
                            file_put_contents($file, $archivo_base);
                        } 
                        

                        $url_final = APP_URL . $path_db . $NombreArchivo;      
                                          

                        $tipo = [
                        [
                            "type"  => $format,
                            $format => [
                                    "link" => $url_final
                                ],
                        ]
                        ];
        
                        $headers = [
                            "type" => "header",
                            "parameters" => $tipo 
                        ];

                        //$componente_preparado["template"]["components"] = [$headers];
                        $componente_preparado["template"]["components"][] = $headers;

                    }

                } 
            
                 
            }  

            if ($component['type'] == "BODY") {

                $contenido = $component['contenido'];

                $body = [
                    "type" => "body",
                    "parameters" => [] 
                ];

                foreach($contenido as $items)
                {
                    $parameters = [
                        "type"  => "text",
                        "text"  => $items["texto"],
                     ];

                     $body["parameters"][] = $parameters;
                     
                }

                $componente_preparado["template"]["components"][] = $body;


            }  

            if ($component['type'] == "BUTTONS") 
            {
                $botones_con_parametros = $component['botones_con_parametros'];
                $botones = $component['botones'];

               /*  for($i = 0; $i < count($botones_con_parametros); $i++)
                {
                    $index = $botones_con_parametros[$i]["index"];
                    $texto = $botones_con_parametros[$i]["texto"];
                    

                    
                } */

                $componentes_botones = [];

                foreach ($botones_con_parametros as $parametro) {
                    $index = $parametro['index'];
                    $texto = $parametro['texto'];

                    if (isset($botones[$index])) {
                        $boton = $botones[$index];
                        $type = $boton['type'];
                        
                        if ($type === 'URL') {
                            $sub_type = 'url';
                            $parameters = [
                                [
                                    "type" => "text",
                                    "text" => $texto
                                ]
                            ];
                        } elseif ($type === 'PHONE_NUMBER') {
                            $sub_type = 'phone_number';
                            $parameters = []; // No se requieren parámetros para PHONE_NUMBER
                        } elseif ($type === 'COPY_CODE') {
                            $sub_type = 'copy_code';
                            $parameters = [
                                [
                                    "type" => "coupon_code",
                                    "coupon_code" => $texto
                                ]
                            ];
                        } else {
                            // Si el tipo no es reconocido, puedes manejar el caso aquí
                            continue;
                        }

                        $componentes_botones  = [
                            "type" => "button",
                            "sub_type" => $sub_type,
                            "index" => $index,
                            "parameters" => $parameters
                        ];

                        $componente_preparado["template"]["components"][] = $componentes_botones;
                    }
                }

            }

        }

         
        $indices = array_keys(array_filter(array_map(function($item, $index) {
            return [
                'item' => $item,
                'index' => $index
            ];
        }, $components, array_keys($components)), function($entry) {
            return $entry['item']['type'] === 'HEADER' && in_array($entry['item']['format'], ['image', 'document', 'video']);
        }));

 
        // Imprimir las posiciones
        //print_r(json_encode($indices[0])  ); exit;
        
        if(count($indices) != 0)
        {
            $components[$indices[0]]["contenido"] =""; 
        }

        $contenido_componenete_preparado = json_encode($componente_preparado);

        //echo  $contenido_componenete_preparado; exit;
        

        //$plantilla_original = json_encode($plantilla_original);
        //$components = json_encode($filteredData);

        /* $salida = array(
            "type"                => "success",
            "message"             => "Message sent",
            "headers"             => $plantilla_original,
            "components"          => $components,
            "url"                 => $url_final,
            //"mensajes_no_leidos"  => count($marcar_leidos),
        );

        print_r(json_encode($salida)); exit; */

        $contenido_componenete_preparado = json_encode($componente_preparado);

   

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $contenido_componenete_preparado,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Authorization: Bearer ' . $token_acceso,
            ),
        ));

        $response      = curl_exec($curl);

        $responseData  = json_decode($response, true);
        $messageId     = $responseData['messages'][0]['id'];
        $messageStatus = $responseData['messages'][0]['message_status'];
        $messageError  = $responseData['error']["message"];
        $messageCode   = $responseData['error']["code"];

        curl_close($curl);

        //print_r(json_encode($responseData)); exit;

        $salida = array();

        $plantilla_original = json_encode($plantilla_original);
        $components = json_encode($components);

        if($messageStatus == "accepted")
        {

            if(empty($zona_horaria) == true)
            {
                $fechaActual   = Carbon::now();
            }else{
                $fechaActual   = Carbon::now()->setTimezone($zona_horaria);
            }

            $salida = array(
                "type"                   => "success",
                "message"                => "Message sent",
                "wam_id"                 => $messageId,
                "url"                    => $url_final,
                "formato_headers"        => $formato_headers,
                "template_original"      => $plantilla_original,
                "template_data"          => $components,
                "mensaje_error_code"     => $messageCode,
                "mensaje_error_mensaje"  => $messageError,
                "mensajes_no_leidos"     => count($marcar_leidos),
                "mensajes_no_leidos_pendiente"  => $existeMensajesPendientes,
                "fecha_creacion"      => $fechaActual->format('d-m-Y h:i A'),  

            );

        }else{

             

            $salida = array(
                "type"                   => "error",
                "message"                => $messageError,
                "wam_id"                 => null,
                "url"                    => $url_final,
                "formato_headers"        => $formato_headers,
                "template_original"      => $plantilla_original,
                "template_data"          => $components,
                "mensaje_error_code"     => $messageCode,
                "mensaje_error_mensaje"  => $messageError,
                "mensajes_no_leidos"     => 0,
                "mensajes_no_leidos_pendiente"  => $existeMensajesPendientes,

            );
        
            print_r(json_encode($salida)); exit;
        }

        //$mysqli->begin_transaction();

        try {

            //se crea un numero en caso de que no exista
            /* $sql = "INSERT INTO chat_number (`number`)
                SELECT '$to' 
                FROM DUAL
                WHERE NOT EXISTS (
                    SELECT 1
                    FROM chat_number
                    WHERE `number` = '$to'
                );"; */
            
            $sql = "INSERT INTO chat_number (`number`, config_whatsapp_other_id)
                    SELECT '$to', '$configuracion_whatsapp_sms_id'
                    FROM DUAL
                    WHERE NOT EXISTS (
                        SELECT 1
                        FROM chat_number
                        WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id
                    );";

            $mysqli->query($sql);
   
            $id_chat_number = null;

            // Comprobar si se insertó una fila nueva
            if ($mysqli->affected_rows > 0) {
                $id_chat_number = $mysqli->insert_id;
            } else {
                //$sql = "SELECT id FROM chat_number WHERE `number` = '$to'";
                $sql = "SELECT id FROM chat_number WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id";
                $result = $mysqli->query($sql);

                if ($result->num_rows > 0) {
                    $row = $result->fetch_assoc();
                    $id_chat_number = $row['id'];
                }  
            }

            //$fechaActual = Carbon::now();
            if(empty($zona_horaria) == true)
            {
                $fechaActual   = Carbon::now();
            }else{
                $fechaActual   = Carbon::now()->setTimezone($zona_horaria);
            }



            $sql = "INSERT INTO chat_social (
                wam_id, 
                chat_number_id, 
                `from`, 
                `to`, 
                mensaje, 
                `url`, 
                template_original,
                template_data,
                tipo_mensaje, 
                esContacto, 
                error_codigo, 
                error_mensaje, 
                phone_number_id,
                tipo_producto, 
                fecha_creacion, 
                `status`,
                config_whatsapp_other_id,
                user_id
            ) VALUES (
                ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
            )";

            $stmt = $mysqli->prepare($sql);

            $tipo_mensaje = 'template';  
            $esContacto = 0;  
            $status = 'sent';  
            $tipo_producto = "whatsapp";

            $stmt->bind_param(
                "ssssssssssssssssii",
                $messageId, 
                $id_chat_number, 
                $from, 
                $to, 
                $caption, 
                $url_final, 
                $plantilla_original,
                $components, 
                $tipo_mensaje, 
                $esContacto, 
                $messageCode, 
                $messageError, 
                $phone_number_id, 
                $tipo_producto, 
                $fechaActual, 
                $status,
                $configuracion_whatsapp_sms_id,
                $staff_id
            );
            
            $stmt->execute();

            $ultimoId = $mysqli->insert_id;

            $salida["id_chat_social"] =  $ultimoId;
            
            $stmt->close();

            //$mysqli->commit();

            /* $salida = array(
                "type"                => "success",
                "message"             => "Message sent",
                "wam_id"              => $messageId,
                "url"                 => $url_final,
                "formato_headers"     => $formato_headers,
                "mensajes_no_leidos"  => count($marcar_leidos),
            ); */
          
            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($salida)); exit;
           
        } catch (Exception $e) {
           
            $response = array(
                "type"                => "error",
                "message"             => "Insert failed: (" . $mysqli->errno . ") " . $mysqli->error,
                "details"             =>  $e->getMessage(),
                "wam_id"              => null,
                "url"                 => $url_final,
                "formato_headers"     => $formato_headers,
                "mensajes_no_leidos"  => 0,
                "fecha_creacion"      => $fechaActual->format('d-m-Y h:i A'),  
            );

            //$mysqli->rollback();

            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($response)); exit;
        }

 
    break;

    case 'enviar-mensaje-plantillas-grupal':
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $components           = $informacion_front['components'];
        $language             = $informacion_front['language']; //
        $name_templates                 = $informacion_front['name']; //
 
        $configuracion_id     = $informacion_front['configuracion_id']; //
        $campaign             = $informacion_front['campaign']; //
        $group                = $informacion_front['group']; //
        $users_id             = $informacion_front['users_id']; //

        $tipo_usuario         = $informacion_front['tipo_usuario']; //
        $namespaces           = $informacion_front['namespaces']; //
        $plantilla_original   = $informacion_front['plantilla_original']; //

        $configuracion_whatsapp_sms_id  = $informacion_front['configuracion_whatsapp_sms_id'];

        if(empty($configuracion_whatsapp_sms_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp settings / sms id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }


        if(empty($users_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Users id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($group) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Group is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($campaign) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Campaign is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($configuracion_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "WhatsApp/SMS configuration is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($plantilla_original) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Template is required",
            );
            print_r(json_encode( $response)) ; exit;
        }
 
        if(empty($name_templates) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Name is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($language) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Language is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if($tipo_usuario != "admin")
        {
            $response = array(
                "type" => "error",
                "data" => "¡You cannot consume this api!",
            );
    
            print_r(json_encode($response)); exit;
        }

        $mysqli = null;

        $configuracion_whatspp_sms = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");

            if($configuracion_id == "all")
            {
                $configuracion_whatspp_sms = $mysqli->query("SELECT * FROM config_whatsapp_other WHERE `status`=1")->fetch_all(MYSQLI_ASSOC) ;
            }else{
                $configuracion_whatspp_sms = $mysqli->query("SELECT * FROM config_whatsapp_other WHERE id=$configuracion_id")->fetch_all(MYSQLI_ASSOC) ;
            }

 
            //print_r(json_encode($configuracion_whatspp_sms)); exit;


            if(count($configuracion_whatspp_sms) == 0)
            {
                $response = array(
                    "type"    => "error",
                    "message" => "Whatsapp/SMS settings were not found",
                );
        
                print_r(json_encode($response)); exit;
            }

            $tener_grupos = $mysqli->query("SELECT * FROM `crm_accounts` WHERE gid='$group'")->fetch_all(MYSQLI_ASSOC) ;

            if(count($tener_grupos) == 0)
            {
                $response = array(
                    "type"    => "error",
                    "message" => "This groups have no contacts",
                );
        
                print_r(json_encode($response)); exit;
            }

            //$configuracion_whatspp_sms = $configuracion_whatspp_sms[0];
             

        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $headers = [];
        $cabecera = [];
        $componente_preparado = [
            "messaging_product" => "whatsapp",
            "to"                => $to,
            "type"              => "template",
            "template"          => [
                    "namespace" => $namespaces,
                    "name"      => $name_templates,
                    "language"  => [
                        "code"  => $language,
                    ],

                    "components"=>[]
                
            ],

        ];

        $plantilla_original = json_encode($plantilla_original);
        
        /* $channel = 'whatsapp';
        $send_date = Carbon::now()->format('Y-m-d H:i:s');
        $contacts_total = count($tener_grupos);
        $contact_sent = 0;
        $contacts_pending = count($tener_grupos);
        $state = 2;

        // Consulta SQL con marcadores de posición
        $sql_group_message_sent = "INSERT INTO `group_message_sent` 
                (`campaign`, `crm_groups_id`, `channel`, `template`, `send_date`, `configuration_whatsapp_other_id`, `contacts_total`, `contact_sent`, `contacts_pending`, `state`, `users_id`) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        // Preparar la declaración
        $stmt = $mysqli->prepare($sql_group_message_sent);

        // Enlazar los parámetros (s = string, i = integer)
        $stmt->bind_param(
            "sisssiiiiii", 
            $campaign, 
            $group, 
            $channel, 
            $plantilla_original, 
            $send_date, 
            $configuracion_id, 
            $contacts_total, 
            $contact_sent, 
            $contacts_pending, 
            $state, 
            $users_id
        );

        // Ejecutar la declaración
        $stmt->execute();

        // Obtener el ID del último registro insertado
        $last_id = $mysqli->insert_id;

        // Cerrar la declaración
        $stmt->close(); 


        $json_template = null;
        $sql = "INSERT INTO `contact_group_sent` ( `group_message_sent_id`, `contacto_id` ,`envio_estado`, `template_data`, `fecha_post`, `fecha_update`) 
                VALUES (?, ?, ?, ?, ?, ?)";

        foreach($tener_grupos as $miembros)
        {
            // Preparar la declaración
            $stmt = $mysqli->prepare($sql);

            // Asignar valores a los marcadores de posición
            $contacto_id = $miembros["id"];
            $envio_estado = 2;
            $fecha_post = Carbon::now()->format('Y-m-d H:i:s');    
            $fecha_update = null;  

            // Enlazar los parámetros (i = integer, s = string)
            $stmt->bind_param("iiisss", $last_id, $contacto_id, $envio_estado, $json_template, $fecha_post, $fecha_update);

            // Ejecutar la declaración
            $stmt->execute();

            // Cerrar la declaración
            $stmt->close();                
        } */

        //$salida = array(
        //    "type"                => "success",
        //    "message"             => "Mensaje enviado",
        //);
        //print_r(json_encode($salida)); exit;

        $formato_headers = "";

        foreach ($components as $component) {
            // Verificar si el campo 'texto' está vacío
            if ($component['type'] == "HEADER") {

                $format          = $component['format'];
                $formato_headers = $format;

                if($format == "text"){

                    $contenido = $component['contenido'];
                    $campoBD   = $component['campoBD'];
         
                    $tipo = [
                        [
                            "type"      =>  $format,
                            "text"      =>  $contenido,
                            "campoBD"   =>  $campoBD,
                            "format"    =>  $format,
                            "extension" =>  "",
                            "lati"      =>  null,
                            "lon"       =>  null,
                            "address"   =>  null,
                            "name"      =>  null,
                        ]
                    ];

                    //unset($tipo[0]["text"]);
     
                    $headers = [
                        "type" => "header",
                        "parameters" => $tipo 
                    ];

                    $componente_preparado["template"]["components"][] = $headers;

                    //print_r(json_encode($componente_preparado)); exit;


                }else{


                   

                    if($format == "location"){

                        $tipo = [
                            [
                                "type"  => $format,
                                $format => [
                                        "latitude"  => $component['lati'],
                                        "longitude" => $component['lon'],
                                        "name"      => $component['name'],
                                        "address"   => $component['address'],

                                        "type"      => $component['type'],
                                        "text"      => "",
                                        "format"    => $format,
                                        "campoBD"   => "",
                                        "extension" => "",
                                        "contenido" => "",

                                ],
                            ]
                        ];
            
                        $headers = [
                            "type" => "header",
                            "parameters" => $tipo 
                        ];

                        //$componente_preparado["template"]["components"] = [$headers];
                        $componente_preparado["template"]["components"][] = $headers;


                    }else{
                        $contenido = $component['contenido'];

                        $extension = $component['extension'];
                        $ext       = explode('/', $extension)[1];

                        $ruta_root = $_SERVER['DOCUMENT_ROOT'];   

                        // Verificar si la ruta tiene una barra al final
                        if (substr($ruta_root, -1) === '/') {
                            // Si hay una barra al final, eliminarla
                            $ruta_root = rtrim($ruta_root, '/');
                        }

                        $tipo_proyecto_produccion = APP_DIRECTORIO;

                        $basePath = $ruta_root . "/$tipo_proyecto_produccion/storage/whatsapp/$ext/";
                        $path_db = "/storage/whatsapp/$ext/";
                        $numero_aleatorio = rand(1, 100000); 

                        if(!file_exists($basePath))
                        {
                            mkdir($basePath, 0777, true);
                            createHtmlFile($basePath."/index.html");
                        } 

                        $formato = date('Y-m-d-H-i-s');
                                    
                        $NombreArchivo = $formato."_".$numero_aleatorio . "_from" . $from . "_to" . $to . '_enviado.' . $ext;
                        
                        $folderPath = $basePath;
                        $archivo_base = base64_decode($contenido);
                        $file = $folderPath . $NombreArchivo ;

                        if($format == "image")
                        {
                            $imagen = imagecreatefromstring($archivo_base);

                            if ($imagen !== false)
                            {
                                $anchoOriginal = imagesx($imagen);
                                $altoOriginal  = imagesy($imagen);

                                $creado = DimensionesImagen($imagen,500,500,$anchoOriginal, $altoOriginal, $file);

                                if($creado == false)
                                {
                                    file_put_contents($file, $archivo_base);
                                }

                            }else{
                                file_put_contents($file, $archivo_base);
                            }
                        }else{
                            file_put_contents($file, $archivo_base);
                        }         

                        $url_final = APP_URL . $path_db . $NombreArchivo;      
                                          

                        $tipo = [
                            [
                                "type"  => $format,
                                $format => [
                                        "link" => $url_final,
                                        "type" => $format,
                                        "format" => $format,
                                        "extension" => $extension,
                                        "contenido" => "",
                                        "lati" => null,
                                        "lon" => null,
                                        "address" => null,
                                        "name" => null,
                                        
                                    ],
                            ]
                        ];
        
                        $headers = [
                            "type" => "header",
                            "parameters" => $tipo 
                        ];

                        //$componente_preparado["template"]["components"] = [$headers];
                        $componente_preparado["template"]["components"][] = $headers;

                    }

                } 
            
                 
            }  

            if ($component['type'] == "BODY") {

                $contenido = $component['contenido'];
                
                $body = [
                    "type" => "body",
                    "parameters" => [] 
                ];

                foreach($contenido as $items)
                {
                    $parameters = [
                        "type"         => "text",
                        "text"         => $items["texto"],
                        "campoBD"      => $items["campoDB"],
                        "buscar"       => $items["buscar"],
                        "isSelecNone"  => $items["isSelecNone"],

                    ];

                    $body["parameters"][] = $parameters;
                     
                }

                $componente_preparado["template"]["components"][] = $body;

            }  

            if ($component['type'] == "BUTTONS") 
            {
                $botones_con_parametros = $component['botones_con_parametros'];
                $botones = $component['botones'];

                $componentes_botones = [];

                foreach ($botones_con_parametros as $parametro) {
                    $index = $parametro['index'];
                    $texto = $parametro['texto'];

                    if (isset($botones[$index])) {
                        $boton = $botones[$index];
                        $type = $boton['type'];
                        
                        if ($type === 'URL') {
                            $sub_type = 'url';
                            $parameters = [
                                [
                                    "type" => "text",
                                    "text" => $texto
                                ]
                            ];
                        } elseif ($type === 'PHONE_NUMBER') {
                            $sub_type = 'phone_number';
                            $parameters = []; // No se requieren parámetros para PHONE_NUMBER
                        } elseif ($type === 'COPY_CODE') {
                            $sub_type = 'copy_code';
                            $parameters = [
                                [
                                    "type" => "coupon_code",
                                    "coupon_code" => $texto
                                ]
                            ];
                        } else {
                            // Si el tipo no es reconocido, puedes manejar el caso aquí
                            continue;
                        }

                        $componentes_botones  = [
                            "type" => "button",
                            "sub_type" => $sub_type,
                            "index" => $index,
                            "parameters" => $parameters
                        ];

                        $componente_preparado["template"]["components"][] = $componentes_botones;
                    }
                }

            }

        }


        $indices = array_keys(array_filter(array_map(function($item, $index) {
            return [
                'item' => $item,
                'index' => $index
            ];
        }, $components, array_keys($components)), function($entry) {
            return $entry['item']['type'] === 'HEADER' && in_array($entry['item']['format'], ['image', 'document', 'video']);
        }));

        $indices_buttons = array_keys(array_filter(array_map(function($item, $index) {
            return [
                'item' => $item,
                'index' => $index
            ];
        }, $components, array_keys($components)), function($entry) {
            return $entry['item']['type'] === 'BUTTONS';
        }));
        
        // Imprimir las posiciones
        //print_r(json_encode($indices_buttons)); exit;

        $buttons_contenido = [];

        if(count($indices_buttons) != 0)
        {
            $buttons_contenido = $components[$indices_buttons[0]]; 
        }
        
        if(count($indices) != 0)
        {
            $components[$indices[0]]["contenido"] =""; 
        }

        $salida = array(
            "type"                => "success",
            "message"             => "Message sent",
            "headers"             => $plantilla_original,
            "components"          => $components,
            "url"                 => $url_final,
            //"mensajes_no_leidos"  => count($marcar_leidos),
        );

        //print_r(json_encode($componente_preparado)); exit;
        //print_r(json_encode($componente_preparado)); exit;
        
        $arr = [];
        $templates_contenido = [];
        

        $ver = [];

        $contacts_total = count($tener_grupos);
        $contact_sent = 0;
        $contacts_pending = count($tener_grupos);
        $state = 2;

        //dar ciclo for a este: $componente_preparado teniendo la informacion de la base de datos
        foreach ($configuracion_whatspp_sms as $config) {

            $version_api_whatapp = $config["version"]; 
            $phone_number_id     = $config["phone_identifier"];
            $token_acceso        = $config["token"];
            $from                = $config["phone"];
            $configuracion_id    = $config["id"];

            $channel = 'whatsapp';
            $send_date = Carbon::now()->format('Y-m-d H:i:s');
            $contacts_total = count($tener_grupos);
            $contact_sent = 0;
            $contacts_pending = count($tener_grupos);
            $state = 2;

            // Consulta SQL con marcadores de posición
            $sql_group_message_sent = "INSERT INTO `group_message_sent` 
                    (`campaign`, `crm_groups_id`, `channel`, `template`, `send_date`, `configuration_whatsapp_other_id`, `contacts_total`, `contact_sent`, `contacts_pending`, `state`, `users_id`) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

            // Preparar la declaración
            $stmt = $mysqli->prepare($sql_group_message_sent);

            // Enlazar los parámetros (s = string, i = integer)
            $stmt->bind_param(
                "sisssiiiiii", 
                $campaign, 
                $group, 
                $channel, 
                $plantilla_original, 
                $send_date, 
                $configuracion_id, 
                $contacts_total, 
                $contact_sent, 
                $contacts_pending, 
                $state, 
                $users_id
            );

            // Ejecutar la declaración
            $stmt->execute();

            // Obtener el ID del último registro insertado
            $last_id = $mysqli->insert_id;

            // Cerrar la declaración
            $stmt->close(); 


            $json_template = null;
            $sql = "INSERT INTO `contact_group_sent` ( `group_message_sent_id`, `contacto_id` ,`envio_estado`, `template_data`, `fecha_post`, `fecha_update`) 
                    VALUES (?, ?, ?, ?, ?, ?)";

            foreach($tener_grupos as $miembros)
            {
                // Preparar la declaración
                $stmt = $mysqli->prepare($sql);

                // Asignar valores a los marcadores de posición
                $contacto_id = $miembros["id"];
                $envio_estado = 2;
                $fecha_post = Carbon::now()->format('Y-m-d H:i:s');    
                $fecha_update = null;  

                // Enlazar los parámetros (i = integer, s = string)
                $stmt->bind_param("iiisss", $last_id, $contacto_id, $envio_estado, $json_template, $fecha_post, $fecha_update);

                // Ejecutar la declaración
                $stmt->execute();

                // Cerrar la declaración
                $stmt->close();                
            }
            //terminamos con crear group_message_sent y asignare un contact_group_sent 

            //$arr[] = $config;

            $url = "https://graph.facebook.com/$version_api_whatapp/$phone_number_id/messages";

            $contact_sent = 0; 
            $contacts_pending = count($tener_grupos);
            $contacts_total = count($tener_grupos);

            foreach($tener_grupos as $miembros)
            {
                $nuevo_componente = [];
                $templates_contenido = [];

                $to =  $miembros["phone"];

                if (empty($to) == false) {

                    $to = dejarSoloNumeros($to);

                    $nuevo_componente = [
                        "messaging_product" => "whatsapp",
                        "to"                => $to,
                        "type"              => "template",
                        "template"          => [
                                "namespace" => $namespaces,
                                "name"      => $name_templates,
                                "language"  => [
                                    "code"  => $language,
                                ],
            
                                "components"=>[]
                            
                        ],
            
                    ];

                    $nuevo_componente_copia = [
                        "messaging_product" => "whatsapp",
                        "to"                => $to,
                        "type"              => "template",
                        "template"          => [
                                "namespace" => $namespaces,
                                "name"      => $name_templates,
                                "language"  => [
                                    "code"  => $language,
                                ],
            
                                "components"=>[]
                            
                        ],
            
                    ];
                
                    foreach ($componente_preparado["template"]["components"] as $component) {
                            
                        //$arr[] = $component["parameters"];

                        if ($component['type'] == "header") 
                        {
            
                            //print_r(json_encode("xd")); exit;
                            //$arr[] = $component["parameters"][0]['type'];

                            $type            = $component["parameters"][0]['type'];

                            if($type == "text")
                            {
                                $contenido       = $component["parameters"][0]['text'];
                                $campoBD         = $component["parameters"][0]['campoBD'];
                                $format          = $component["parameters"][0]['format'];
                                $extension       = $component["parameters"][0]['extension'];
                                $lati            = $component["parameters"][0]['lati'];
                                $lon             = $component["parameters"][0]['lon'];
                                $address         = $component["parameters"][0]['address'];
                                $name            = $component["parameters"][0]['name'];
                            }else{
                                $contenido       = $component["parameters"][0][$type]['text'];
                                $campoBD         = $component["parameters"][0][$type]['campoBD'];
                                $format          = $component["parameters"][0][$type]['format'];
                                $extension       = $component["parameters"][0][$type]['extension'];
                                $lati            = $component["parameters"][0][$type]['lati'];
                                $lon             = $component["parameters"][0][$type]['lon'];
                                $address         = $component["parameters"][0][$type]['address'];
                                $name            = $component["parameters"][0][$type]['name'];
                            }

                             

                            
                            if($type == "text")
                            {
                                $text            = $component["parameters"][0]['text'];
                                $campoBD         = $component["parameters"][0]['campoBD'];
                                 
                                $tipo = [];
                                $tipo_copia = [];

                                if($campoBD == "0" || $campoBD == 0)
                                {

                                    $contenido = $text;


                                    $tipo = [
                                        [
                                            "type"    => "text",
                                            "text"    =>  $text,
                                        ]
                                    ];

                                    $tipo_copia = [
                                        [
                                            "type"    => "text",
                                            "text"    =>  $text,
                                        ]
                                    ];
                                }else{

                                    $value           = $miembros[$campoBD];
                                    $placeholder = "{{1}}";

                                    $result = reemplazarComodinPorText($text, $placeholder, $value);
                                    $contenido = $result;

                                    $tipo = [
                                        [
                                            "type"    => "text",
                                            "text"    =>  $result,
                                        ]
                                    ];

                                    $tipo_copia = [
                                        [
                                            "type"    => "text",
                                            "text"    =>  $value,
                                        ]
                                    ];
                
                                }

                                //unset($tipo[0]["text"]);
                
                                $headers = [
                                    "type" => "header",
                                    "parameters" => $tipo 
                                ];

                                $headers_copia = [
                                    "type" => "header",
                                    "parameters" => $tipo_copia 
                                ];

                                                                
                                $nuevo_componente["template"]["components"][] = $headers;
                                $nuevo_componente_copia["template"]["components"][] = $headers_copia;

                            }

                            if($type == "image" || $type == "document" || $type == "video")
                            {
                                $tipo = [
                                    [
                                        "type"  => $type,
                                        $type   => [
                                            "link" => $url_final
                                        ],
                                    ]
                                ];
                    
                                $headers = [
                                    "type" => "header",
                                    "parameters" => $tipo 
                                ];
            
                                //$componente_preparado["template"]["components"] = [$headers];
                                $nuevo_componente["template"]["components"][] = $headers;

                                $nuevo_componente_copia["template"]["components"][] = $headers;

                            }

                            if($type == "location")
                            {

                                 


                                $tipo = [
                                    [
                                        "type"  => $format,
                                        $format => [
                                                "latitude"  => $component["parameters"][0]['location']["latitude"],
                                                "longitude" => $component["parameters"][0]['location']["longitude"],
                                                "name"      => $component["parameters"][0]['location']["name"],
                                                "address"   => $component["parameters"][0]['location']["address"],
                                            ],
                                    ]
                                ];
                    
                                $headers = [
                                    "type" => "header",
                                    "parameters" => $tipo 
                                ];
        
                                //$componente_preparado["template"]["components"] = [$headers];
                                $nuevo_componente["template"]["components"][] = $headers;

                                $nuevo_componente_copia["template"]["components"][] = $headers;

                            }

                            $header_bd = [
                                "type" => "HEADER" ,
                                "contenido" => $contenido,
                                "campoBD" => $campoBD,
                                "format"  => $format,
                                "extension" =>$extension,
                                "lati"=> $lati,
                                "lon"=> $lon,
                                "address" => $address,
                                "name"=> $name
                            ];

                            $templates_contenido[] = $header_bd;
                                        
                        }

                        if ($component['type'] == "body") 
                        {    
                
                            $type            = $component["parameters"][0]['type'];

                            $contenido       = $component["parameters"][0]['text'];
                            $campoBD         = $component["parameters"][0]['campoBD'];
                            $format          = $component["parameters"][0]['format'];
                            $extension       = $component["parameters"][0]['extension'];
                            $lati            = $component["parameters"][0]['lati'];
                            $lon             = $component["parameters"][0]['lon'];
                            $address         = $component["parameters"][0]['address'];
                            $name            = $component["parameters"][0]['name'];

                            $body = [
                                "type" => "body",
                                "parameters" => [] 
                            ];

                            $body_copia = [
                                "type" => "body",
                                "parameters" => [] 
                            ];

                            $contenido_params = $component['parameters'];

                            $contenido_body = [];

                            foreach($contenido_params as $items)
                            {              
                                $text            = $items["text"];
                                $buscar          = $items["buscar"];
                                $campoBD         = $items["campoBD"];
                                $isSelecNone     = $items["isSelecNone"];

                                $parameters = [];
                                $parameters_copia = [];

                                $texto = "";

                                if($isSelecNone == true)
                                {
                                    $parameters = [
                                        "type"     => "text",
                                        "text"     => $text,
                                    ];

                                    $parameters_copia = [
                                        "type"     => "text",
                                        "text"     => $text,
                                    ];

                                    $texto = $text;

                                }else{
                                    $value_data      = $miembros[$campoBD];
                                 
                                    $result = reemplazarComodinPorText($text, $buscar, $value_data);

                                    $texto = $result;

                                    $parameters = [
                                        "type"     => "text",
                                        "text"     => $result,
                                        //"campoBD"  => $campoBD,
                                        //"value"       => $value_data,
                                        //"result"       => $result,
                                    ];

                                    $parameters_copia = [
                                        "type"     => "text",
                                        "text"     => $value_data,
                                        
                                    ];
                                }

                                $contenido_body[] = [
                                    "buscar"   => $buscar,
                                    "texto"    => $texto,
                                    "campoBD"  => $campoBD ,

                                ];

                                $body["parameters"][] = $parameters;
                                $body_copia["parameters"][] = $parameters_copia;
                                
                            }

                            $nuevo_componente["template"]["components"][] = $body;
                            $nuevo_componente_copia["template"]["components"][] = $body_copia;


                            $body_bd = [
                                "type" => "BODY" ,
                                "contenido" => $contenido_body,
                                
                            ];

                            $templates_contenido[] = $body_bd;

                        }

                        if ($component['type'] == "button") 
                        {

                            $parameters = [];
                            $sub_type = $component['sub_type'];
                            $tipo_texto = $component['parameters'][0];


                            if ($sub_type == 'url') {
                                 
                                $parameters = [
                                    [
                                        "type" => "text",
                                        "text" => $tipo_texto["text"]
                                    ]
                                ];


                            }  elseif ($sub_type == 'copy_code') {
                                $parameters = [
                                    [
                                        "type" => "coupon_code",
                                        "coupon_code" => $tipo_texto["coupon_code"]
                                    ]
                                ];


                            } else {
                                // Si el tipo no es reconocido, puedes manejar el caso aquí
                                continue;
                            }

                            $componentes_botones  = [
                                "type"       => "button",
                                "sub_type"   => $sub_type,
                                "index"      => $component['index'],
                                "parameters" => $parameters
                            ];

                            $nuevo_componente["template"]["components"][] = $componentes_botones;
                            $nuevo_componente_copia["template"]["components"][] = $componentes_botones;

                             
                        }

            
                        //$arr[] = $nuevo_componente;
                    }

                    //aqui enviamos plantilla y guardamos mensajes

                      
                    if(count($buttons_contenido) != 0)
                    {
                        $templates_contenido[] = $buttons_contenido;
                    }
                     
                    $contact_sent++;
                     
                    $json_template = json_encode($nuevo_componente_copia);
                    $sql_update_contactos = "UPDATE `contact_group_sent` 
                                            SET `envio_estado` = ?, `template_data` = ?, 
                                                `codigo_error` = ?, `mensaje_error` = ?
                                            WHERE `contacto_id` = ? AND `group_message_sent_id` = ?";

                    // Preparar la declaración
                    $stmt_contacto_mensaje = $mysqli->prepare($sql_update_contactos);

                    // Asignar valores a los marcadores de posición
                    $envio_estado = 1;
                    $contacto_id = $miembros["id"] + 0;  
                    $group_message_sent_id = $last_id;
                    $codigo_error = null;  
                    $mensaje_error = null; 

                    //$arr[] = $nuevo_componente;

                    $data_recibida = enviar_plantilla($url, $token_acceso, $nuevo_componente);
                    $messageId = $data_recibida["messageId"];
                    $messageStatus = $data_recibida["messageStatus"];
                    $messageError = $data_recibida["messageError"];
                    $messageCode = $data_recibida["messageCode"];

                    if($messageStatus == "accepted"){

                        $contacts_pending = $contacts_pending - $contact_sent; 

                        $arr[] = $nuevo_componente;

                        //$mysqli->begin_transaction();
                        
                        $template_data = json_encode($templates_contenido);

                        try {

                            //se crea un numero en caso de que no exista
                            /* $sql = "INSERT INTO chat_number (`number`)
                                SELECT '$to' 
                                FROM DUAL
                                WHERE NOT EXISTS (
                                    SELECT 1
                                    FROM chat_number
                                    WHERE `number` = '$to'
                                );"; */
                            
                            $sql = "INSERT INTO chat_number (`number`, config_whatsapp_other_id)
                                    SELECT '$to', '$configuracion_whatsapp_sms_id'
                                    FROM DUAL
                                    WHERE NOT EXISTS (
                                        SELECT 1
                                        FROM chat_number
                                        WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id
                                    );";
                
                            $mysqli->query($sql);
                   
                            $id_chat_number = null;
                
                            // Comprobar si se insertó una fila nueva
                            if ($mysqli->affected_rows > 0) {
                                $id_chat_number = $mysqli->insert_id;
                            } else {
                                //$sql = "SELECT id FROM chat_number WHERE `number` = '$to'";
                                $sql = "SELECT id FROM chat_number WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id";
                                $result = $mysqli->query($sql);
                
                                if ($result->num_rows > 0) {
                                    $row = $result->fetch_assoc();
                                    $id_chat_number = $row['id'];
                                }  
                            }
                
                            $fechaActual = Carbon::now();
                
                            $sql = "INSERT INTO chat_social (
                                wam_id, 
                                chat_number_id, 
                                `from`, 
                                `to`, 
                                mensaje, 
                                `url`, 
                                template_original,
                                template_data,
                                tipo_mensaje, 
                                esContacto, 
                                error_codigo, 
                                error_mensaje, 
                                phone_number_id,
                                tipo_producto, 
                                fecha_creacion, 
                                `status`,
                                config_whatsapp_other_id,
                                user_id
                            ) VALUES (
                                ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
                            )";
                
                            $stmt = $mysqli->prepare($sql);
                
                            $tipo_mensaje = 'template';  
                            $esContacto = 0;  
                            $status = 'sent';  
                            $tipo_producto = "whatsapp";
                 
                            $stmt->bind_param(
                                "ssssssssssssssssii",
                                $messageId, 
                                $id_chat_number, 
                                $from, 
                                $to, 
                                $caption, 
                                $url_final, 
                                $plantilla_original,
                                $template_data, 
                                $tipo_mensaje, 
                                $esContacto, 
                                $messageCode, 
                                $messageError, 
                                $phone_number_id, 
                                $tipo_producto, 
                                $fechaActual, 
                                $status,
                                $configuracion_whatsapp_sms_id,
                                $users_id
                            );
                            
                            $stmt->execute();
                            
                            $stmt->close();

                            

                            //tabla contact_group_sent
                            // Enlazar los parámetros (i = integer, s = string)
                            $stmt_contacto_mensaje->bind_param("isssii", $envio_estado, $json_template, $codigo_error, $mensaje_error, $contacto_id, $group_message_sent_id);

                            $stmt_contacto_mensaje->execute(); 
                            $stmt_contacto_mensaje->close();

                            $mysqli->query("UPDATE group_message_sent SET contact_sent=$contact_sent, contacts_pending=$contacts_pending WHERE id=$last_id");

                            //$arr[] = $nuevo_componente;
                
                            //$mysqli->commit();
                
                        } catch (Exception $e) {
                                
                
                            //$mysqli->rollback();
                
                            // Cerrar la conexión
                            //$mysqli->close();
                
                            //print_r(json_encode($response)); exit;
                        }
                    }else{

                        $envio_estado = 2;
                        $codigo_error = $messageCode;  
                        $mensaje_error = $messageError; 

                        // Enlazar los parámetros (i = integer, s = string)
                        $stmt_contacto_mensaje->bind_param("isssii", $envio_estado, $json_template, $codigo_error, $mensaje_error, $contacto_id, $group_message_sent_id);

                        $stmt_contacto_mensaje->execute(); 
                        $stmt_contacto_mensaje->close();
                    }

                    //$arr[] = $nuevo_componente["template"]["components"];
                }//fin del if para validar si el el campo telefono no este vacio
                     
                
            }//fin del if para tener grupos


            if($contacts_total != 0)
            {
                $estado_camp = 2; //dejamos pendiente

                if($contacts_pending == $contacts_total)
                {
                    $estado_camp = 3;
                }else{
                    if($contacts_pending <= 0)
                    {
                        $estado_camp = 1; //completo
                        $contacts_pending = 0;
                        $mysqli->query("UPDATE group_message_sent SET contacts_pending=$contacts_pending WHERE id=$last_id");
                    }else{
                        $estado_camp = 3;
                    }
                }

                //$ver = [
                //    "estado_camp" => $estado_camp,
                //    "contacts_pending" => $contacts_pending,
                //    "contacts_total" => $contacts_total,
                //];

                $mysqli->query("UPDATE group_message_sent SET `state`=$estado_camp WHERE id=$last_id");
            }


             
         
        }//fin del if para configuracion de whatsapp
         
        // Cerrar la conexión
        $mysqli->close();


        $salida = array(
            "type"                => "success",
            "message"             => "Message sent",
            "arr"                 => $ver,
        );

        print_r(json_encode($salida)); exit;



    break;

    case 'tener-listado-mensajes-grupales':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $fecha_desde          = $informacion_front['fecha_desde'];
        $fecha_hasta          = $informacion_front['fecha_hasta'];
        $usuario_id           = $informacion_front['usuario_id']; //
        $canal                = $informacion_front['canal']; //
        $nombre_campaña       = $informacion_front['nombre_campaña']; //
        $status               = $informacion_front['status']; //
 
        $sql = "";

        if(empty($fecha_desde) != true && empty($fecha_hasta) != true)
        {
            $fecha_desde_formato = $fecha_desde . " 00:00:01";
            $fecha_hasta_formato = $fecha_hasta . " 23:59:59";
             $sql .= " AND send_date BETWEEN '$fecha_desde_formato' AND '$fecha_hasta_formato'";
        }

        if(empty($usuario_id) != true)
        {
 
             $sql .= " AND gms.users_id=$usuario_id";
        }

        if(empty($canal) != true)
        {
             $sql .= " AND gms.channel='$canal'";
        }

        if(empty($nombre_campaña) != true)
        {
             $sql .= " AND gms.campaign like '%$nombre_campaña%'";
        }

        if(empty($status) != true)
        {
             $sql .= " AND gms.`state`=$status";
        }

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }
 
        $consulta = [];

        $select = "SELECT 
                    gms.`id` AS `id`, 
                    gms.`campaign` AS `campaign`, 
                    gms.`crm_groups_id` AS `crm_groups_id`, 
                    gms.`channel` AS `channel`, 
                    gms.`template` AS `template`, 
                    DATE_FORMAT(gms.`send_date`, '%Y-%m-%d %h:%i %p') AS `send_date`, 
                    gms.`configuration_whatsapp_other_id` AS `configuration_whatsapp_other_id`, 
                    gms.`contacts_total` AS `contacts_total`, 
                    gms.`contact_sent` AS `contact_sent`, 
                    gms.`contacts_pending` AS `contacts_pending`, 
                    IF(gms.`state` = 1, 'Complete', 
                        IF(gms.`state` = 3, 'Incomplete', 
                            IF(gms.`state` = 2, 'Pending', 'Unknown')
                        )
                    ) AS `state_description`,
                    gms.`state` AS `state`,
                    gms.`users_id` AS `users_id`,
                    su.fullname AS user_fullname,
                    su.username AS user_username
                  --   IF( gms.`channel`='sms', SELECT identifier FROM config_whatsapp_other WHERE id=gms.configuration_whatsapp_other_id, 'No encontrado' ) AS identificado,
                  --  cwo.identifier AS config_identifier
                FROM `group_message_sent` AS gms
                LEFT JOIN sys_users AS su ON su.id=gms.users_id
                -- LEFT JOIN config_whatsapp_other AS cwo ON cwo.id=gms.configuration_whatsapp_other_id
                WHERE 1 $sql ORDER by gms.id DESC";

                 

        //echo $select; exit;

        $consulta = $mysqli->query($select)->fetch_all(MYSQLI_ASSOC);

        $newRow = '';
        

        foreach ($consulta as $item) {

            $config_identifier = "";
            $id_config = $item["configuration_whatsapp_other_id"];

            if($item['channel'] == "sms")
            {
                $data = $mysqli->query("SELECT identifier FROM config_whatsapp_other where id=$id_config")->fetch_assoc();

                if($data){
                    $config_identifier = $data["identifier"];
                }
            }

            if($item['channel'] == "whatsapp")
            {
                $data = $mysqli->query("SELECT identifier FROM config_whatsapp_other where id=$id_config")->fetch_assoc();

                if($data){
                    $config_identifier = $data["identifier"];
                }
            }

            if($item['channel'] == "email")
            {
                $data = $mysqli->query("SELECT identifier FROM config_email where id=$id_config")->fetch_assoc();

                if($data){
                    $config_identifier = $data["identifier"];
                }
            }

            $url_id =  U . "group/contact-message-list/" . htmlspecialchars($item['id']);

            $newRow .= "<tr>";
            $newRow .= '<td class="centrar">' . htmlspecialchars($item['send_date']) . '</td>';
            $newRow .= '<td class="centrar">' . htmlspecialchars($item['channel']) . '</td>';
            $newRow .= '<td class="centrar">' . htmlspecialchars($item['campaign']) . '</td>';
            $newRow .= '<td class="centrar">' . $config_identifier . '</td>';
            $newRow .= '<td class="centrar">' . htmlspecialchars($item['contacts_total']) . '</td>';
            $newRow .= '<td class="centrar">' . htmlspecialchars($item['contact_sent']) . '</td>';
            $newRow .= '<td class="centrar">' . htmlspecialchars($item['contacts_pending']) . '</td>';
            $newRow .= '<td class="centrar">' . htmlspecialchars($item['state_description']) . '</td>';
            $newRow .= '<td class="centrar">';
            $newRow .= '<a href="' . $url_id . '" class="btn btn-primary btnView" data-id="' . htmlspecialchars($item['id']) . '">View</a>';
            $newRow .= '</td>';
            $newRow .= "</tr>";
        }

        $response = array(
            "type"   => "success",
            //"data"   => $consulta,
            "data"   => $newRow,
        );
        $mysqli->close();
        print_r(json_encode( $response)) ; exit;

           
    break;

    case 'lista-usuarios-admin':

 
        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }
 
        $contenido = [];

        $contenido = $mysqli->query("SELECT id, fullname FROM `sys_users`  WHERE `user_type`='Admin' ")->fetch_all(MYSQLI_ASSOC);

        $response = array(
            "type"   => "success",
            "data"   => $contenido,
        );
        $mysqli->close();
        print_r(json_encode( $response)) ; exit;

           
    break;

    //solo plantillas de sms

    case 'crear_o_modificar_plantilla_sms':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $identificador            = $informacion_front['identificador'];
        $templates                = $informacion_front['templates'];
        $accion                = $informacion_front['accion'];
        $id                = $informacion_front['id'];
        $status                = $informacion_front['status'];


        if(empty($accion) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Accion is required",
            );
            print_r(json_encode( $response)) ; exit;
        }
 
        if(empty($identificador) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Identifier is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($templates) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "templates is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $identificador = slug($identificador);
 

        if($accion == "modificar")
        {
            $id = $id + 0; // Asegúrate de que $id sea un entero
            $status = $status + 0; // Asegúrate de que $status sea un entero
 
            $fecha_update = Carbon::now()->format('Y-m-d H:i:s'); // El valor para la columna `fecha_update`
            
             // Consulta SQL para actualizar datos en la tabla
             $sql = "UPDATE `templates_sms` 
                     SET `identificador` = ?, `plantilla` = ?, `status` = ?, `fecha_update` = ? 
                     WHERE `id` = ?";
            
            // Preparar la declaración
            $stmt = $mysqli->prepare($sql);
            
            

            // Enlazar los parámetros (s = string, i = integer)
            $stmt->bind_param("ssisi", $identificador, $templates, $status, $fecha_update, $id);
            $stmt->execute();
            // Cerrar la declaración
            $stmt->close();

            $salida = array(
                "type"               => "success",
                "message"            => "Message saved successfully",
            );
           
            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($salida)); exit;
        }


        //$mysqli->begin_transaction();

        try {
 
            // Definir los valores que deseas insertar
            $fecha_post = Carbon::now();
            $fecha_update = null;

            // Consulta SQL para insertar datos en la tabla
            $sql = "INSERT INTO `templates_sms` (`identificador`, `plantilla`, `status`, `fecha_post`, `fecha_update`) 
                    VALUES (?, ?, ?, ?, ?)";

            // Preparar la declaración
            $stmt = $mysqli->prepare($sql);

            // Enlazar los parámetros (s = string)
            $stmt->bind_param("ssiss", $identificador, $templates, $status, $fecha_post, $fecha_update);

            // Ejecutar la declaración
            $stmt->execute();

            // Cerrar la declaración
            $stmt->close();
           
            
            //$mysqli->commit();

       
            $salida = array(
                "type"               => "success",
                "message"            => "Message saved successfully",
            );
           
            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($salida)); exit;
           
        } catch (Exception $e) {
           
            $response = array(
                "type" => "error",
                "message" => "Insert failed: (" . $mysqli->errno . ") " . $mysqli->error,
                "details" =>  $e->getMessage(),
                "sid" => null,
            );

            //$mysqli->rollback();

            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($response)); exit;
        }


 
        
    break;

    case 'tener_plantilla_sms':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $status         = $informacion_front['status'];
        $nombres        = $informacion_front['nombres'];
 
        $sql = "";

        if(empty($status) != true)
        {
            $sql = " AND `status`=$status";
        }

        if(empty($nombres) != true)
        {
            $sql = " AND `identificador` like '%$nombres%'";
        }

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $consulta = [];

        $select = "SELECT 
            `id`, 
            `identificador`, 
            `plantilla`, 
            IF(`status`=1, 'Active', 'Inactive') AS `status`, 
            `status` AS status_id, 
            LOWER(DATE_FORMAT(fecha_post, '%d-%m-%Y %I:%i %p')) AS fecha_post, 
            LOWER(DATE_FORMAT(fecha_update, '%d-%m-%Y %I:%i %p')) AS `fecha_update` FROM `templates_sms` WHERE 1 $sql";

        $consulta = $mysqli->query($select)->fetch_all(MYSQLI_ASSOC) ;
 
        $response = array(
            "type" => "success",
            "message" => "",
            "data"    =>  $consulta
        );
        $mysqli->close();
        print_r(json_encode( $response)) ; exit;
 
        
    break;

    case 'deshabilitar_sms':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $id         = $informacion_front['id'];
 
        if(empty($id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "ID is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

 

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $consulta = [];

        $select = "UPDATE `templates_sms` SET `status`=2 WHERE id=$id;";

        $consulta = $mysqli->query($select);
 
        $response = array(
            "type" => "success",
            "message" => "Changes saved successfully",
        );
        $mysqli->close();
        print_r(json_encode( $response)) ; exit;
 
        
    break;

    case 'tener_configuracion_sms':

         
        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $consulta = [];

        $select = "SELECT id,
                          identifier,
                          sms_auth_token,
                          sms_account_sid,
                          sms_phone_number,
                          `status`,
                          fecha_creacion   
                    FROM `config_whatsapp_other` WHERE sms_auth_token is not null AND sms_account_sid is not null and sms_phone_number is not null AND `status`=1";

        $consulta = $mysqli->query($select)->fetch_all(MYSQLI_ASSOC) ;
 
        $response = array(
            "type" => "success",
            "message" => "",
            "data"    =>  $consulta
        );
        $mysqli->close();
        print_r(json_encode( $response)) ; exit;
 
        
    break;

    case 'enviar-mensaje-plantillas-grupal-sms':
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $contenido                 = $informacion_front['contenido'];
        $configuracion_id          = $informacion_front['configuracion_id']; //
        $campaign                  = $informacion_front['campaign']; //
        $group                     = $informacion_front['group']; //
        $users_id                  = $informacion_front['users_id']; //
        $tipo_usuario              = $informacion_front['tipo_usuario']; //
        $plantilla_original        = $informacion_front['plantilla_original']; //
        $plantilla_personalizada   = $informacion_front['plantilla_personalizada']; //

        $configuracion_whatsapp_sms_id  = $informacion_front['configuracion_whatsapp_sms_id'];

        if(empty($configuracion_whatsapp_sms_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp settings / sms id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }


        if(empty($contenido) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Content is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($users_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Users id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($group) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Group is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($campaign) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Campaign is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($configuracion_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "WhatsApp/SMS configuration is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($plantilla_original) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Template is required",
            );
            print_r(json_encode( $response)) ; exit;
        }
 

        if($tipo_usuario != "admin")
        {
            $response = array(
                "type" => "error",
                "data" => "¡You cannot consume this api!",
            );
    
            print_r(json_encode($response)); exit;
        }

        $mysqli = null;

        $configuracion_whatspp_sms = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");

            if($configuracion_id == "all")
            {
                $configuracion_whatspp_sms = $mysqli->query("SELECT * FROM config_whatsapp_other WHERE `status`=1")->fetch_all(MYSQLI_ASSOC) ;
            }else{
                $configuracion_whatspp_sms = $mysqli->query("SELECT * FROM config_whatsapp_other WHERE id=$configuracion_id")->fetch_all(MYSQLI_ASSOC) ;
            }
             
            //print_r(json_encode($configuracion_whatspp_sms)); exit;


            if(count($configuracion_whatspp_sms) == 0)
            {
                $response = array(
                    "type"    => "error",
                    "message" => "Whatsapp/SMS settings were not found",
                );
        
                print_r(json_encode($response)); exit;
            }

            $tener_grupos = $mysqli->query("SELECT * FROM `crm_accounts` WHERE gid='$group'")->fetch_all(MYSQLI_ASSOC) ;

            if(count($tener_grupos) == 0)
            {
                $response = array(
                    "type"    => "error",
                    "message" => "This groups have no contacts",
                );
        
                print_r(json_encode($response)); exit;
            }

            //$configuracion_whatspp_sms = $configuracion_whatspp_sms[0];
             

        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }
 

        $url_sockets = "https://xhde365.com/socket-chat/mensajes/";

        $sys_appconfig = $mysqli->query("SELECT `value` FROM sys_appconfig WHERE setting='socket_webhook_sms'")->fetch_assoc();         

        if(empty($sys_appconfig) == false)
        {
            $url_sockets = $sys_appconfig["value"];
        }

        $url_sockets = rtrim($url_sockets, '/');

         
        $arr = [];
         
        $db   = DB_NAME;
        $slug = APP_DIRECTORIO;

        $plantilla_original = json_encode($plantilla_original);

        foreach ($configuracion_whatspp_sms as $config) {
            $sms_account_sid  = $config["sms_account_sid"];
            $sms_auth_token   = $config["sms_auth_token"];
            $sms_phone_number = $config["sms_phone_number"];
            $configuracion_id = $config["id"];

             
            if (empty($sms_phone_number) == true) 
            {
                continue;
            }

            $sms_phone_number = dejarSoloNumeros($sms_phone_number);


            $messageId   = null;
            $status      = null;

            $fechaActual = Carbon::now();

            $channel = 'sms';
            $send_date = Carbon::now()->format('Y-m-d H:i:s');
            $contacts_total = count($tener_grupos);
            $contact_sent = 0;
            $contacts_pending = count($tener_grupos);
            $state = 2;

            // Consulta SQL con marcadores de posición
            $sql_group_message_sent = "INSERT INTO `group_message_sent` 
                    (`campaign`, `crm_groups_id`, `channel`, `template`, `send_date`, `configuration_whatsapp_other_id`, `contacts_total`, `contact_sent`, `contacts_pending`, `state`, `users_id`) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

            // Preparar la declaración
            $stmt = $mysqli->prepare($sql_group_message_sent);

            // Enlazar los parámetros (s = string, i = integer)
            $stmt->bind_param(
                "sisssiiiiii", 
                $campaign, 
                $group, 
                $channel, 
                $plantilla_original, 
                $send_date, 
                $configuracion_id, 
                $contacts_total, 
                $contact_sent, 
                $contacts_pending, 
                $state, 
                $users_id
            );

            // Ejecutar la declaración
            $stmt->execute();

            // Obtener el ID del último registro insertado
            $last_id = $mysqli->insert_id;

            // Cerrar la declaración
            $stmt->close(); 

            $json_template = null;
            $sql = "INSERT INTO `contact_group_sent` ( `group_message_sent_id`, `contacto_id` ,`envio_estado`, `template_data`, `fecha_post`, `fecha_update`) 
                    VALUES (?, ?, ?, ?, ?, ?)";

            //lo recorro para cambiar su estado a 2
            foreach($tener_grupos as $miembros)
            {
                // Preparar la declaración
                $stmt = $mysqli->prepare($sql);

                // Asignar valores a los marcadores de posición
                $contacto_id = $miembros["id"];
                $envio_estado = 2;
                $fecha_post = Carbon::now()->format('Y-m-d H:i:s');    
                $fecha_update = null;  

                // Enlazar los parámetros (i = integer, s = string)
                $stmt->bind_param("iiisss", $last_id, $contacto_id, $envio_estado, $json_template, $fecha_post, $fecha_update);

                // Ejecutar la declaración
                $stmt->execute();

                // Cerrar la declaración
                $stmt->close();                
            }

            
            $client = new Twilio\Rest\Client($sms_account_sid, $sms_auth_token);
            
            $contact_sent = 0; 
            $contacts_pending = count($tener_grupos);
            $contacts_total = count($tener_grupos);

            //aqui modifica su estado a 1 y guarda mensaje
            foreach($tener_grupos as $miembros)
            {
                $to  =  $miembros["phone"];

                if (empty($to) == false) {

                    $to = dejarSoloNumeros($to);

                    $tempo_plantilla_personalizada = $plantilla_personalizada;

                    $texto_plantilla_finalizada = "";

                    //aqui reemplazamos contenido en ves de {{ n }}
                    foreach ($contenido as $itemContenido)
                    {
                        $buscar            = $itemContenido["buscar"];
                        $texto             = $itemContenido["texto"];
                        $campoDB_front     = $itemContenido["campoDB"];
                        $dataReal          = $itemContenido["dataReal"];
                        $isSelecNone       = $itemContenido["isSelecNone"];
                        
                        $value_data = "";

                        if($isSelecNone == true)
                        {
                            $value_data = $texto;
                        }else{
                            $value_data = reemplazarComodinPorText($texto, $buscar, $miembros[$campoDB_front]);                                            
                        }

                        $tempo_plantilla_personalizada = reemplazarComodinPorText($tempo_plantilla_personalizada, $buscar, $value_data);
                        $texto_plantilla_finalizada = $tempo_plantilla_personalizada;
                                            
                    }

                    $contact_sent++;
                     
                    //$json_template = json_encode($contenido);
                    $json_template = $texto_plantilla_finalizada;
                    $sql_update_contactos = "UPDATE `contact_group_sent` 
                                            SET `envio_estado` = ?, `template_data` = ?, 
                                                `codigo_error` = ?, `mensaje_error` = ?
                                            WHERE `contacto_id` = ? AND `group_message_sent_id` = ?";

                    // Preparar la declaración
                    $stmt_contacto_mensaje = $mysqli->prepare($sql_update_contactos);

                    // Asignar valores a los marcadores de posición
                    $envio_estado = 1;
                    $contacto_id = $miembros["id"] + 0;  
                    $group_message_sent_id = $last_id;
                    $codigo_error = null;  
                    $mensaje_error = null; 

                     
                    $cuerpo_mensaje = array(
                        'from' => "+$sms_phone_number",
                        'body' => "$texto_plantilla_finalizada",
                        'statusCallback' => $url_sockets . "/status?db=$db&url=$slug"
                    );

                    $message = $client->messages->create(
                        // Where to send a text message (your cell phone?)
                        "+$to", 
                        $cuerpo_mensaje
                    );
        
                    if($message == null){
                        //si cae aqui es porque hubo un error

                        $envio_estado = 2;
                        $codigo_error  = "";  
                        $mensaje_error = "error al enviar mensaje grupal"; 

                        // Enlazar los parámetros (i = integer, s = string)
                        $stmt_contacto_mensaje->bind_param("isssii", $envio_estado, $json_template, $codigo_error, $mensaje_error, $contacto_id, $group_message_sent_id);

                        $stmt_contacto_mensaje->execute(); 
                        $stmt_contacto_mensaje->close();
                        
                    }else{

                        $contacts_pending = $contacts_pending - $contact_sent; 

                        $messageId    = $message->sid;
                        $status       = $message->status;

                        $fechaActual = Carbon::now();

                        //$mysqli->begin_transaction();

                        try {

                            //se crea un numero en caso de que no exista
                            /* $sql = "INSERT INTO chat_number (`number`)
                                SELECT '$to' 
                                FROM DUAL
                                WHERE NOT EXISTS (
                                    SELECT 1
                                    FROM chat_number
                                    WHERE `number` = '$to'
                                );"; */
                            $sql = "INSERT INTO chat_number (`number`, config_whatsapp_other_id)
                                SELECT '$to', '$configuracion_whatsapp_sms_id'
                                FROM DUAL
                                WHERE NOT EXISTS (
                                    SELECT 1
                                    FROM chat_number
                                    WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id
                                );";

                            $mysqli->query($sql);

                            $id_chat_number = null;

                            // Comprobar si se insertó una fila nueva
                            if ($mysqli->affected_rows > 0) {
                                $id_chat_number = $mysqli->insert_id;
                            } else {
                                //$sql = "SELECT id FROM chat_number WHERE `number` = '$to'";
                                $sql = "SELECT id FROM chat_number WHERE `number` = '$to' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id";
                                $result = $mysqli->query($sql);

                                if ($result->num_rows > 0) {
                                    $row = $result->fetch_assoc();
                                    $id_chat_number = $row['id'];
                                }  
                            }


                            $messageId    = $message->sid;
                            $status       = $message->status;

                            // Construcción de la consulta SQL
                            /* $sql = "INSERT INTO chat_social (
                                wam_id, 
                                `sid`, 
                                chat_number_id, 
                                `from`, 
                                `to`, 
                                mensaje, 
                                `url`, 
                                `filename`,
                                tipo_mensaje, 
                                esContacto, 
                                error_codigo, 
                                error_mensaje, 
                                phone_number_id,
                                tipo_producto, 
                                fecha_creacion, 
                                `status`
                            ) VALUES (
                                null, 
                                '$messageId', 
                                '$id_chat_number', 
                                '$from', 
                                '$to', 
                                '$texto_plantilla_finalizada', 
                                null, 
                                null, 
                                'text', 
                                false, 
                                null, 
                                null, 
                                null, 
                                'sms',
                                '$fechaActual', 
                                '$status'
                            )";

                            $mysqli->query($sql); */
                            // Construcción de la consulta SQL
                            $sql = "INSERT INTO chat_social (
                                wam_id, 
                                `sid`, 
                                chat_number_id, 
                                `from`, 
                                `to`, 
                                mensaje, 
                                `url`, 
                                `filename`,
                                tipo_mensaje, 
                                esContacto, 
                                error_codigo, 
                                error_mensaje, 
                                phone_number_id,
                                tipo_producto, 
                                fecha_creacion, 
                                `status`,
                                config_whatsapp_other_id,
                                user_id
                            ) VALUES (
                                ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
                            )";

                            $stmt = $mysqli->prepare($sql);

                            // Valores a insertar
                            $wam_id = null;  
                            $tipo_mensaje = 'text';  
                            $esContacto = 0;  
                            $tipo_producto = "sms";

                            // Enlazar los parámetros (s = string, i = integer, etc.)
                            $stmt->bind_param(
                                "sssssssssssssssssi",
                                $wam_id, 
                                $messageId, 
                                $id_chat_number, 
                                $sms_phone_number, 
                                $to, 
                                $texto_plantilla_finalizada, 
                                $url, 
                                $filename,
                                $tipo_mensaje, 
                                $esContacto, 
                                $error_codigo, 
                                $error_mensaje, 
                                $phone_number_id, 
                                $tipo_producto, 
                                $fechaActual, 
                                $status,
                                $configuracion_whatsapp_sms_id,
                                $users_id
                            );

                            $stmt->execute();

                            $stmt->close();

                            //$mysqli->commit();

                            //tabla contact_group_sent
                            // Enlazar los parámetros (i = integer, s = string)
                            $stmt_contacto_mensaje->bind_param("isssii", $envio_estado, $json_template, $codigo_error, $mensaje_error, $contacto_id, $group_message_sent_id);

                            $stmt_contacto_mensaje->execute(); 
                            $stmt_contacto_mensaje->close();

                            $mysqli->query("UPDATE group_message_sent SET contact_sent=$contact_sent, contacts_pending=$contacts_pending WHERE id=$last_id");
                        
                        } catch (Exception $e) {
                        
                             
                        }

                        //$arr[] = [
                        //    "sid"    => $message->sid,
                        //    "status" => $message->status,
                        //];
                    }

                    
        
                     
                    //$arr[] = $texto_plantilla_finalizada;

                }
            }

            //cambiar estado a completado
            if($contacts_total != 0)
            {
                $estado_camp = 2; //dejamos pendiente

                if($contacts_pending == $contacts_total)
                {
                    $estado_camp = 3;
                }else{
                    if($contacts_pending <= 0)
                    {
                        $estado_camp = 1; //completo
                        $contacts_pending = 0;
                        $mysqli->query("UPDATE group_message_sent SET contacts_pending=$contacts_pending WHERE id=$last_id");
                    }else{
                        $estado_camp = 3;
                    }
                }

                //$ver = [
                //    "estado_camp" => $estado_camp,
                //    "contacts_pending" => $contacts_pending,
                //    "contacts_total" => $contacts_total,
                //];

                $mysqli->query("UPDATE group_message_sent SET `state`=$estado_camp WHERE id=$last_id");
            }


        }


        $mysqli->close();

        $salida = array(
            "type"                => "success",
            "message"             => "Message sent",
            //"arr"                 => $arr,
            //"cuerpo_mensaje"      => $cuerpo_mensaje,
        );

        print_r(json_encode($salida)); exit;

       



    break;

    //solo plantillas de email

    case 'crear_o_modificar_plantilla_email':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $identificador            = $informacion_front['identificador'];
        $templates                = $informacion_front['templates'];
        $accion                   = $informacion_front['accion'];
        $id                       = $informacion_front['id'];
        $status                   = $informacion_front['status'];
        $subject                  = $informacion_front['subject'];
         
        if(empty($subject) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Subject is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($accion) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Accion is required",
            );
            print_r(json_encode( $response)) ; exit;
        }
 
        if(empty($identificador) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Identifier is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($templates) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "templates is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $identificador = slug($identificador);


        if($accion == "modificar")
        {
            $id = $id + 0; // Asegúrate de que $id sea un entero
            $status = $status + 0; // Asegúrate de que $status sea un entero
 
            $fecha_update = Carbon::now()->format('Y-m-d H:i:s'); // El valor para la columna `fecha_update`
            
             // Consulta SQL para actualizar datos en la tabla
             $sql = "UPDATE `templates_email` 
                     SET `subject` = ?, `identificador` = ?, `plantilla` = ?, `status` = ?, `fecha_update` = ? 
                     WHERE `id` = ?";
            
            // Preparar la declaración
            $stmt = $mysqli->prepare($sql);
            
            // Enlazar los parámetros (s = string, i = integer)
            $stmt->bind_param("sssisi", $subject, $identificador, $templates, $status, $fecha_update, $id);
            $stmt->execute();
            // Cerrar la declaración
            $stmt->close();

            $salida = array(
                "type"               => "success",
                "message"            => "Message saved successfully",
            );
           
            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($salida)); exit;
        }


        //$mysqli->begin_transaction();

        try {
 
            // Definir los valores que deseas insertar
            $fecha_post = Carbon::now();
            $fecha_update = null;

            // Consulta SQL para insertar datos en la tabla
            $sql = "INSERT INTO `templates_email` (`subject`, `identificador`, `plantilla`, `status`, `fecha_post`, `fecha_update`) 
                    VALUES (?, ?, ?, ?, ?, ?)";

            // Preparar la declaración
            $stmt = $mysqli->prepare($sql);
 

            // Enlazar los parámetros (s = string)
            $stmt->bind_param("sssiss", $subject, $identificador, $templates, $status, $fecha_post, $fecha_update);

            // Ejecutar la declaración
            $stmt->execute();

            // Cerrar la declaración
            $stmt->close();
           
            
            //$mysqli->commit();

       
            $salida = array(
                "type"               => "success",
                "message"            => "Message saved successfully",
            );
           
            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($salida)); exit;
           
        } catch (Exception $e) {
           
            $response = array(
                "type" => "error",
                "message" => "Insert failed: (" . $mysqli->errno . ") " . $mysqli->error,
                "details" =>  $e->getMessage(),
                "sid" => null,
            );

            //$mysqli->rollback();

            // Cerrar la conexión
            $mysqli->close();

            print_r(json_encode($response)); exit;
        }


 
        
    break;

    case 'tener_plantilla_email':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $status         = $informacion_front['status'];
        $nombres        = $informacion_front['nombres'];
 
        $sql = "";

        if(empty($status) != true)
        {
            $sql = " AND `status`=$status";
        }

        if(empty($nombres) != true)
        {
            $sql = " AND `identificador` like '%$nombres%'";
        }

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $consulta = [];

        $select = "SELECT 
            `id`, 
            `identificador`, 
            `subject`, 
            `plantilla`, 
            IF(`status`=1, 'Active', 'Inactive') AS `status`, 
            `status` AS status_id, 
            LOWER(DATE_FORMAT(fecha_post, '%d-%m-%Y %I:%i %p')) AS fecha_post, 
            LOWER(DATE_FORMAT(fecha_update, '%d-%m-%Y %I:%i %p')) AS `fecha_update` FROM `templates_email` WHERE 1 $sql";

        $consulta = $mysqli->query($select)->fetch_all(MYSQLI_ASSOC) ;
 
        $response = array(
            "type" => "success",
            "message" => "",
            "data"    =>  $consulta
        );
        $mysqli->close();
        print_r(json_encode( $response)) ; exit;
 
        
    break;

    case 'deshabilitar_email':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $id         = $informacion_front['id'];
 
        if(empty($id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "ID is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

 

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $consulta = [];

        $select = "UPDATE `templates_email` SET `status`=2 WHERE id=$id;";

        $consulta = $mysqli->query($select);
 
        $response = array(
            "type" => "success",
            "message" => "Changes saved successfully",
        );
        $mysqli->close();
        print_r(json_encode( $response)) ; exit;
 
        
    break;

    case 'tener_configuracion_email':

         
        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }

        $consulta = [];

        $select = "SELECT id, identifier, token, email, nombre, `status`, fecha_post, fecha_update FROM config_email WHERE `status`=1;";

        /* $select = "SELECT id,
                          identifier,
                          sms_auth_token,
                          sms_account_sid,
                          sms_phone_number,
                          `status`,
                          fecha_creacion   
                    FROM `config_whatsapp_other` WHERE sms_auth_token is not null AND sms_account_sid is not null and sms_phone_number is not null AND `status`=1"; */

        $consulta = $mysqli->query($select)->fetch_all(MYSQLI_ASSOC) ;
 
        $response = array(
            "type" => "success",
            "message" => "",
            "data"    =>  $consulta
        );
        $mysqli->close();
        print_r(json_encode( $response)) ; exit;
 
        
    break;

    case 'enviar-mensaje-plantillas-grupal-email':
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $contenido                 = $informacion_front['contenido'];
        $configuracion_id          = $informacion_front['configuracion_id']; //
        $campaign                  = $informacion_front['campaign']; //
        $group                     = $informacion_front['group']; //
        $users_id                  = $informacion_front['users_id']; //
        $tipo_usuario              = $informacion_front['tipo_usuario']; //
        $plantilla_original        = $informacion_front['plantilla_original']; //
        $plantilla_personalizada   = $informacion_front['plantilla_personalizada']; //
        $subject                   = $informacion_front['subject']; //


        if(empty($subject) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Subject is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        /* if(empty($contenido) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Content is required",
            );
            print_r(json_encode( $response)) ; exit;
        } */

        if(empty($users_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Users id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($group) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Group is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($campaign) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Campaign is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($configuracion_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "WhatsApp/SMS configuration is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($plantilla_original) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Template is required",
            );
            print_r(json_encode( $response)) ; exit;
        }
 

        if($tipo_usuario != "admin")
        {
            $response = array(
                "type" => "error",
                "data" => "¡You cannot consume this api!",
            );
    
            print_r(json_encode($response)); exit;
        }

        $mysqli = null;

        $configuracion_whatspp_sms = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");

            if($configuracion_id == "all")
            {
                $configuracion_whatspp_sms = $mysqli->query("SELECT * FROM config_email WHERE `status`=1")->fetch_all(MYSQLI_ASSOC) ;
            }else{
                $configuracion_whatspp_sms = $mysqli->query("SELECT * FROM config_email WHERE id=$configuracion_id")->fetch_all(MYSQLI_ASSOC) ;
            }
             
            //print_r(json_encode($configuracion_whatspp_sms)); exit;

            if(count($configuracion_whatspp_sms) == 0)
            {
                $response = array(
                    "type"    => "error",
                    "message" => "Whatsapp/SMS settings were not found",
                );
        
                print_r(json_encode($response)); exit;
            }

            $tener_grupos = $mysqli->query("SELECT * FROM `crm_accounts` WHERE gid='$group'")->fetch_all(MYSQLI_ASSOC) ;

            if(count($tener_grupos) == 0)
            {
                $response = array(
                    "type"    => "error",
                    "message" => "This groups have no contacts",
                );
        
                print_r(json_encode($response)); exit;
            }

            //$configuracion_whatspp_sms = $configuracion_whatspp_sms[0];
             

        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }
 
         
        $arr = [];
         
        $db   = DB_NAME;
        $slug = APP_DIRECTORIO;

        $plantilla_original = json_encode($plantilla_original);

        foreach ($configuracion_whatspp_sms as $config) {
            $email_token       = $config["token"];
            $email_email       = $config["email"];
            $email_nombre      = $config["nombre"];
            $configuracion_id  = $config["id"];

            $fechaActual = Carbon::now();

            $channel = 'email';
            $send_date = Carbon::now()->format('Y-m-d H:i:s');
            $contacts_total = count($tener_grupos);
            $contact_sent = 0;
            $contacts_pending = count($tener_grupos);
            $state = 2;

            // Consulta SQL con marcadores de posición
            $sql_group_message_sent = "INSERT INTO `group_message_sent` 
                    (`campaign`, `crm_groups_id`, `channel`, `template`, `send_date`, `configuration_whatsapp_other_id`, `contacts_total`, `contact_sent`, `contacts_pending`, `state`, `users_id`) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

            // Preparar la declaración
            $stmt = $mysqli->prepare($sql_group_message_sent);

            // Enlazar los parámetros (s = string, i = integer)
            $stmt->bind_param(
                "sisssiiiiii", 
                $campaign, 
                $group, 
                $channel, 
                $plantilla_original, 
                $send_date, 
                $configuracion_id, 
                $contacts_total, 
                $contact_sent, 
                $contacts_pending, 
                $state, 
                $users_id
            );

            // Ejecutar la declaración
            $stmt->execute();

            // Obtener el ID del último registro insertado
            $last_id = $mysqli->insert_id;

            // Cerrar la declaración
            $stmt->close(); 

            $json_template = null;
            $sql = "INSERT INTO `contact_group_sent` ( `group_message_sent_id`, `contacto_id` ,`envio_estado`, `template_data`, `fecha_post`, `fecha_update`) 
                    VALUES (?, ?, ?, ?, ?, ?)";

            //lo recorro para cambiar su estado a 2
            foreach($tener_grupos as $miembros)
            {
                // Preparar la declaración
                $stmt = $mysqli->prepare($sql);

                // Asignar valores a los marcadores de posición
                $contacto_id = $miembros["id"];
                $envio_estado = 2;
                $fecha_post = Carbon::now()->format('Y-m-d H:i:s');    
                $fecha_update = null;  

                // Enlazar los parámetros (i = integer, s = string)
                $stmt->bind_param("iiisss", $last_id, $contacto_id, $envio_estado, $json_template, $fecha_post, $fecha_update);

                // Ejecutar la declaración
                $stmt->execute();

                // Cerrar la declaración
                $stmt->close();                
            }

                
            $contact_sent = 0; 
            $contacts_pending = count($tener_grupos);
            $contacts_total = count($tener_grupos);

            //aqui modifica su estado a 1 y guarda mensaje
            foreach($tener_grupos as $miembros)
            {
                $email_miembro  =  $miembros["email"];
                $email_account  =  $miembros["account"];

                if (empty($email_miembro) == false) {

                    $tempo_plantilla_personalizada = $plantilla_personalizada;

                    $texto_plantilla_finalizada = "";

                    //aqui reemplazamos contenido en ves de {{ n }}
                    foreach ($contenido as $itemContenido)
                    {
                        $buscar            = $itemContenido["buscar"];
                        $texto             = $itemContenido["texto"];
                        $campoDB_front     = $itemContenido["campoDB"];
                        $dataReal          = $itemContenido["dataReal"];
                        $isSelecNone       = $itemContenido["isSelecNone"];
                        
                        $value_data = "";

                        if($isSelecNone == true)
                        {
                            $value_data = $texto;
                        }else{
                            $value_data = reemplazarComodinPorText($texto, $buscar, $miembros[$campoDB_front]);                                            
                        }

                        $tempo_plantilla_personalizada = reemplazarComodinPorText($tempo_plantilla_personalizada, $buscar, $value_data);
                        $texto_plantilla_finalizada = $tempo_plantilla_personalizada;
                                            
                    }

                    if(count($contenido) == 0)
                    {
                        $texto_plantilla_finalizada = $plantilla_personalizada; 
                    }

                    $arr[] = $texto_plantilla_finalizada;

                    $contact_sent++;

                    //$json_template = json_encode($contenido);
                    $json_template = $texto_plantilla_finalizada;

                    $sql_update_contactos = "UPDATE `contact_group_sent` 
                                            SET `envio_estado` = ?, `template_data` = ?, 
                                                `codigo_error` = ?, `mensaje_error` = ?
                                            WHERE `contacto_id` = ? AND `group_message_sent_id` = ?";

                    // Preparar la declaración
                    $stmt_contacto_mensaje = $mysqli->prepare($sql_update_contactos);

                    // Asignar valores a los marcadores de posición
                    $envio_estado = 1;
                    $contacto_id = $miembros["id"] + 0;  
                    $group_message_sent_id = $last_id;
                    $codigo_error = null;  
                    $mensaje_error = null; 

                    try {
   
                        $email = new Mail();
                        $email->setFrom($email_email, $email_nombre);
                        $email->setSubject($subject);
                        $email->addTo($email_miembro, $email_account); // Asegúrate de que el email sea válido
                        $email->addContent('text/html', $texto_plantilla_finalizada);
                        $sendgrid = new \SendGrid($email_token); // el key
                        $response = $sendgrid->send($email);           
                     
                        $contacts_pending = $contacts_pending - $contact_sent; 

                        try {

                            //tabla contact_group_sent
                            // Enlazar los parámetros (i = integer, s = string)
                            $stmt_contacto_mensaje->bind_param("isssii", $envio_estado, $json_template, $codigo_error, $mensaje_error, $contacto_id, $group_message_sent_id);

                            $stmt_contacto_mensaje->execute(); 
                            $stmt_contacto_mensaje->close();

                            $mysqli->query("UPDATE group_message_sent SET contact_sent=$contact_sent, contacts_pending=$contacts_pending WHERE id=$last_id");
                        
                        } catch (Exception $e) {
                             
                        }
                    
                        
                        
                    }  catch (Exception $e) {
                        // Captura errores generales
                        
                         //si cae aqui es porque hubo un error

                         $envio_estado = 2;
                         $codigo_error  = "";  
                         $mensaje_error = $e->getMessage(); 
 
                         // Enlazar los parámetros (i = integer, s = string)
                         $stmt_contacto_mensaje->bind_param("isssii", $envio_estado, $json_template, $codigo_error, $mensaje_error, $contacto_id, $group_message_sent_id);
 
                         $stmt_contacto_mensaje->execute(); 
                         $stmt_contacto_mensaje->close();
                    }

                   
  
                     
                    //$arr[] = $texto_plantilla_finalizada;

                }
            }

            //cambiar estado a completado
            if($contacts_total != 0)
            {
                $estado_camp = 2; //dejamos pendiente

                if($contacts_pending == $contacts_total)
                {
                    $estado_camp = 3;
                }else{
                    if($contacts_pending <= 0)
                    {
                        $estado_camp = 1; //completo
                        $contacts_pending = 0;
                        $mysqli->query("UPDATE group_message_sent SET contacts_pending=$contacts_pending WHERE id=$last_id");
                    }else{
                        $estado_camp = 3;
                    }
                }

                //$ver = [
                //    "estado_camp" => $estado_camp,
                //    "contacts_pending" => $contacts_pending,
                //    "contacts_total" => $contacts_total,
                //];

                $mysqli->query("UPDATE group_message_sent SET `state`=$estado_camp WHERE id=$last_id");
            }


        }


        $mysqli->close();

        $salida = array(
            "type"                => "success",
            "message"             => "Message sent",
            //"arr"                 => $arr,
            //"cuerpo_mensaje"      => $cuerpo_mensaje,
        );

        print_r(json_encode($salida)); exit;

       



    break;

    case 'agregar-contacto-chat':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $phone                          = $informacion_front['phone'];
        $configuracion_whatsapp_sms_id  = $informacion_front['configuracion_whatsapp_sms_id'];
        $custumers_id                   = $informacion_front['custumers_id'];
         
        if(empty($custumers_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Customers id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($configuracion_whatsapp_sms_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp settings / sms id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($phone) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Phone is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }
                                           
        //$mysqli->begin_transaction();

        try {
            
            //se crea el numero en caso de que no exista
            $sql = "INSERT INTO chat_number (`number`, config_whatsapp_other_id, custumer_id)
                    SELECT '$phone', '$configuracion_whatsapp_sms_id', '$custumers_id'
                    FROM DUAL
                    WHERE NOT EXISTS (
                        SELECT 1
                        FROM chat_number
                        WHERE `number` = '$phone' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id
                    );";


            $mysqli->query($sql);

            // Comprobar si se insertó una fila nueva
            if ($mysqli->affected_rows > 0) {

                $id_chat_number = $mysqli->insert_id;

                $salida = array(
                    "type"                => "success",
                    "message"             => "!Contact added successfully¡",        
                    "chat_number_id"      => $id_chat_number,      
                );
                 
                //$mysqli->commit();
                $mysqli->close();
                print_r(json_encode($salida)); exit;

            } else {

                $salida = array(
                    "type"                => "error",
                    "message"             => "!The contact is already added¡",      
                    "chat_number_id"      => 0,      
                );
                $mysqli->close();
                print_r(json_encode($salida)); exit;

            }

        } catch (Exception $e) {
             
            $response = array(
                "type" => "error",
                "message" => "Insert failed: (" . $mysqli->errno . ") " . $mysqli->error,
                "details" =>  $e->getMessage()
            );

            //$mysqli->rollback();

            // Cerrar la conexión
            $mysqli->close();
            print_r(json_encode($response)); exit;
        }

 
    break;

    case 'agregar-telefono-contacto-chat':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $phone                          = $informacion_front['phone'];
        $configuracion_whatsapp_sms_id  = $informacion_front['configuracion_whatsapp_sms_id'];
        $staff_id  = $informacion_front['staff_id'];
 
        if(empty($configuracion_whatsapp_sms_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Whatsapp settings / sms id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($staff_id) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Staff id is required",
            );
            print_r(json_encode( $response)) ; exit;
        }
 

        if(empty($phone) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Phone is required",
            );
            print_r(json_encode( $response)) ; exit;
        }

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }
                                           
        //$mysqli->begin_transaction();

        try {
            
            //se crea el numero en caso de que no exista
            $sql = "INSERT INTO chat_number (`number`, config_whatsapp_other_id, staff_id)
                    SELECT '$phone', '$configuracion_whatsapp_sms_id', '$staff_id'
                    FROM DUAL
                    WHERE NOT EXISTS (
                        SELECT 1
                        FROM chat_number
                        WHERE `number` = '$phone' AND config_whatsapp_other_id = $configuracion_whatsapp_sms_id
                    );";


            $mysqli->query($sql);

            // Comprobar si se insertó una fila nueva
            if ($mysqli->affected_rows > 0) {

                $id_chat_number = $mysqli->insert_id;

                $contactos = $mysqli->query("SELECT 
                                            cn.id, 
                                            cn.number, 
                                            cn.custumer_id, 
                                            cn.staff_id,
                                            LOWER(DATE_FORMAT(cn.created_at, '%d-%m-%Y %I:%i %p')) AS created_at, 
                                            IFNULL(crm_a.account, 'Desconocido') AS nombre,
                                            crm_a.email AS email_custumers,
                                            crm_a.phone AS phone_custumers,
                                            crm_a.company AS company_custumers,
                                            crm_a.address AS address_custumers,
                                            IFNULL(sys_u.fullname, 'Unassigned staff') AS fullname_staff,
                                            sys_u.username AS username_staff,
                                            sys_u.user_type AS user_type_staff,
                                            sys_u.phonenumber AS phonenumber,
                                            sys_u.config_whatsapp_other_id AS 'sys_users_config_whatsapp_other_id'
                                          
                                        FROM 
                                            chat_number AS cn 
                                            LEFT JOIN crm_accounts AS crm_a 
                                                ON crm_a.id = cn.custumer_id
                                            LEFT JOIN sys_users AS sys_u 
                                                ON sys_u.id = cn.staff_id

                                            WHERE cn.id=$id_chat_number

                                        ")->fetch_assoc() ;

                $salida = array(
                    "type"                => "success",
                    "message"             => "!Contact added successfully¡",        
                    "chat_number_id"      => $id_chat_number,      
                    "contactos"           => $contactos,      
                );
                
                //$mysqli->commit();
                $mysqli->close();
                print_r(json_encode($salida)); exit;

            } else {

                $salida = array(
                    "type"                => "error",
                    "message"             => "!The contact is already added¡",      
                    "chat_number_id"      => 0,      
                );
                $mysqli->close();
                print_r(json_encode($salida)); exit;

            }

        } catch (Exception $e) {
             
            $response = array(
                "type" => "error",
                "message" => "Insert failed: (" . $mysqli->errno . ") " . $mysqli->error,
                "details" =>  $e->getMessage()
            );

            //$mysqli->rollback();

            // Cerrar la conexión
            $mysqli->close();
            print_r(json_encode($response)); exit;
        }

 
    break;

    case 'post-add-config-whatsapp-sms':
         
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $identificador = $informacion_front['identificador'];
        $phone_ws = $informacion_front['phone_ws'];
        $whatsapp_business_account_identifier = $informacion_front['whatsapp_business_account_identifier'];
        $tener_version_ws = $informacion_front['tener_version_ws'];
        $token_ws = $informacion_front['token_ws'];
        $phone_identifier = $informacion_front['phone_identifier'];
        $app_Identifier = $informacion_front['app_Identifier'];

        $secret_key_app = $informacion_front['secret_key_app'];
        $whatsapp_app_id_configuration = $informacion_front['whatsapp_app_id_configuration'];
 

        $sms_account_sid = $informacion_front['sms_account_sid'];
        $sms_phone_number = $informacion_front['sms_phone_number'];
        $sms_auth_token = $informacion_front['sms_auth_token'];
        $version_sms = $informacion_front['version_sms'];
        $status = $informacion_front['status'];

        $enable_whatsapp = $informacion_front['habilitarConfigWs'];
        $enable_twilio = $informacion_front['habilitarConfigSMS'];

        $zona_horaria = $informacion_front['tenerTimeZone'];

        $msg = "";

        //if(empty($zona_horaria) == true)
        //{
        //    $msg .= "* The Time zone is required" . ' <br>';
        //}

        if(empty($identificador) == true  )
        {
            $msg .= "* The identifier is required" . ' <br>';
        }

        /* if(empty($phone_ws) == true && $enable_whatsapp == true)
        {
            $msg .= "* WhatsApp phone is required" . ' <br>';
        }

        if(empty($whatsapp_business_account_identifier) == true && $enable_whatsapp == true)
        {
            $msg .= "* The WhatsApp Business Account is required" . ' <br>';
        }

        if(empty($tener_version_ws) == true && $enable_whatsapp == true)
        {
            $msg .= "* The WhatsApp version is required" . ' <br>';
        }

        if(empty($token_ws) == true && $enable_whatsapp == true)
        {
            $msg .= "* WhatsApp token is required" . ' <br>';
        }

        if(empty($phone_identifier) == true && $enable_whatsapp == true)
        {
            $msg .= "* WhatsApp phone identifier is required" . ' <br>';
        }

        if(empty($app_Identifier) == true && $enable_whatsapp == true)
        {
            $msg .= "* The WhatsApp app identifier is required" . ' <br>';
        }

        if(empty($secret_key_app) == true && $enable_whatsapp == true)
        {
            $msg .= "* The WhatsApp Secret key of the app is required" . ' <br>';
        }
 
        if(empty($whatsapp_app_id_configuration) == true && $enable_whatsapp == true)
        {
            $msg .= "* The WhatsApp app configuration is required" . ' <br>';
        }

        if(empty($sms_account_sid) == true && $enable_twilio == true)
        {
            $msg .= "* The sms account sid is required" . ' <br>';
        }

        if(empty($sms_phone_number) == true && $enable_twilio == true)
        {
            $msg .= "* SMS phone number is required" . ' <br>';
        }

        if(empty($sms_auth_token) == true && $enable_twilio == true)
        {
            $msg .= "* SMS Auth token is required" . ' <br>';
        }

        if(empty($version_sms) == true && $enable_twilio == true)
        {
            $msg .= "* The SMS version is required" . ' <br>';
        }

        if(empty($status) == true)
        {
            $msg .= "* Status is required" . ' <br>';
        } */



        //r2(U . "settings/list-config-whatsapp-sms", 's', "Information added successfully");

 
        
        if($msg == "")
        {

            //echo "PASO A GUARDAR"; exit;

            ///registerWhatsAppPhoneNumber($phone_number_id, $business_token, $pin, $api_version)

            if($enable_whatsapp == true)
            {

                $salida = registerWhatsAppPhoneNumber($phone_identifier, $token_ws, "123456", $tener_version_ws);

                //"mensaje" => $error_message,
                //"status" => false

                if($salida["status"] == false)
                {
                    $response = array(
                        "type"    => "error",
                        "message" => $salida["mensaje"],
                        "redirect" => ""
                    );

                    print_r(json_encode($response)) ; exit;
                }

                //En Caso de que sea WHATSAPP
                $d = ORM::for_table('config_whatsapp_other')->create();
                $d->identifier = slug($identificador);
                $d->token = $token_ws;
                $d->phone = $phone_ws;
                $d->phone_identifier = $phone_identifier;
                $d->whatsapp_business_account_identifier = $whatsapp_business_account_identifier;
                $d->app_Identifier = $app_Identifier;

                $d->secret_key_app = $secret_key_app;
                $d->whatsapp_app_id_configuration = $whatsapp_app_id_configuration;

                $d->version = $tener_version_ws;
                $d->status = $status;

                $d->fecha_creacion = date('Y-m-d H:i:s');
                $d->sms_account_sid = $sms_account_sid;
                $d->sms_auth_token = $sms_auth_token;
                $d->sms_phone_number = $sms_phone_number;
                $d->version_sms = $version_sms;

                $d->zona_horaria = $zona_horaria;

                $d->enable_whatsapp = $enable_whatsapp == true? 1 : 2;
                $d->enable_twilio   = $enable_twilio == true? 1 : 2;

                $d->save();

                $id = $d->id;

                $response = array(
                    "type"    => "success",
                    "title" => "Successful identifier creation",
                    "message" => "The identifier has been created successfully. Please complete the messaging service channel information below.",
                    "redirect" => U . "settings/update-config-whatsapp-sms/" . $id,
                    //"redirect" => U . "settings/list-config-whatsapp-sms"
                );
                print_r(json_encode($response)) ; exit;

            }else{

                //En Caso de que sea WHATSAPP
                $d = ORM::for_table('config_whatsapp_other')->create();
                $d->identifier = slug($identificador);
                $d->token = $token_ws;
                $d->phone = $phone_ws;
                $d->phone_identifier = $phone_identifier;
                $d->whatsapp_business_account_identifier = $whatsapp_business_account_identifier;
                $d->app_Identifier = $app_Identifier;

                $d->secret_key_app = $secret_key_app;
                $d->whatsapp_app_id_configuration = $whatsapp_app_id_configuration;

                $d->version = $tener_version_ws;
                $d->status = $status;

                $d->fecha_creacion = date('Y-m-d H:i:s');
                $d->sms_account_sid = $sms_account_sid;
                $d->sms_auth_token = $sms_auth_token;
                $d->sms_phone_number = $sms_phone_number;
                $d->version_sms = $version_sms;

                $d->zona_horaria = $zona_horaria;

                $d->enable_whatsapp = $enable_whatsapp == true? 1 : 2;
                $d->enable_twilio   = $enable_twilio == true? 1 : 2;

                $d->save();

                $id = $d->id;

                $response = array(
                    "type"    => "success",
                    "title" => "Successful identifier creation",
                    "message" => "The identifier has been created successfully. Please complete the messaging service channel information below.",
                    "redirect" => U . "settings/update-config-whatsapp-sms/" . $id,
                    "id" => $id
                );

                print_r(json_encode($response)) ; exit;
            }

             
        }else{
            $response = array(
                "type"    => "error",
                "message" => $msg
            );
            print_r(json_encode($response)) ; exit;
        }

 
    
    break;

    case 'update-add-config-whatsapp-sms':
         
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $identificador = $informacion_front['identificador'];
        $phone_ws = $informacion_front['phone_ws'];
        $whatsapp_business_account_identifier = $informacion_front['whatsapp_business_account_identifier'];
        $tener_version_ws = $informacion_front['tener_version_ws'];
        $token_ws = $informacion_front['token_ws'];
        $phone_identifier = $informacion_front['phone_identifier'];
        $app_Identifier = $informacion_front['app_Identifier'];
        $secret_key_app = $informacion_front['secret_key_app'];
        $whatsapp_app_id_configuration = $informacion_front['whatsapp_app_id_configuration'];

        $sms_account_sid = $informacion_front['sms_account_sid'];
        $sms_phone_number = $informacion_front['sms_phone_number'];
        $sms_auth_token = $informacion_front['sms_auth_token'];
        $version_sms = $informacion_front['version_sms'];
        $status = $informacion_front['status'];
        $id = $informacion_front['id'];

        $enable_whatsapp = $informacion_front['habilitarConfigWs'];
        $enable_twilio = $informacion_front['habilitarConfigSMS'];

        $zona_horaria = $informacion_front['tenerTimeZone'];

        $msg = "";

        if(empty($zona_horaria) == true)
        {
            $msg .= "* The Time zone is required" . ' <br>';
        }

        if(empty($identificador) == true && $enable_whatsapp== true)
        {
            $msg .= "* The identifier is required" . ' <br>';
        }

        if(empty($phone_ws) == true && $enable_whatsapp== true)
        {
            $msg .= "* WhatsApp phone is required" . ' <br>';
        }

        if(empty($whatsapp_business_account_identifier) == true && $enable_whatsapp== true)
        {
            $msg .= "* The WhatsApp Business Account is required" . ' <br>';
        }

        if(empty($tener_version_ws) == true && $enable_whatsapp== true)
        {
            $msg .= "* The WhatsApp version is required" . ' <br>';
        }

        if(empty($token_ws) == true && $enable_whatsapp== true)
        {
            $msg .= "* WhatsApp token is required" . ' <br>';
        }

        if(empty($phone_identifier) == true && $enable_whatsapp== true)
        {
            $msg .= "* WhatsApp phone identifier is required" . ' <br>';
        }

        if(empty($app_Identifier) == true && $enable_whatsapp== true)
        {
            $msg .= "* The WhatsApp app identifier is required" . ' <br>';
        }

        if(empty($secret_key_app) == true && $enable_whatsapp == true)
        {
            $msg .= "* The WhatsApp Secret key of the app is required" . ' <br>';
        }
 
        if(empty($whatsapp_app_id_configuration) == true && $enable_whatsapp == true)
        {
            $msg .= "* The WhatsApp app configuration is required" . ' <br>';
        }

        if(empty($sms_account_sid) == true && $enable_twilio == true)
        {
            $msg .= "* The sms account sid is required" . ' <br>';
        }

        if(empty($sms_phone_number) == true && $enable_twilio == true)
        {
            $msg .= "* SMS phone number is required" . ' <br>';
        }

        if(empty($sms_auth_token) == true && $enable_twilio == true)
        {
            $msg .= "* SMS Auth token is required" . ' <br>';
        }

        if(empty($version_sms) == true && $enable_twilio == true)
        {
            $msg .= "* The SMS version is required" . ' <br>';
        }

        if(empty($status) == true)
        {
            $msg .= "* Status is required" . ' <br>';
        }

 
        if($msg == "")
        {

            $d = ORM::for_table('config_whatsapp_other')->find_one($id); 
            $d->identifier = slug($identificador);
            $d->token = $token_ws;
            $d->phone = $phone_ws;
            $d->phone_identifier = $phone_identifier;
            $d->whatsapp_business_account_identifier = $whatsapp_business_account_identifier;
            $d->app_Identifier = $app_Identifier;

            $d->secret_key_app = $secret_key_app;
            $d->whatsapp_app_id_configuration = $whatsapp_app_id_configuration;

            $d->version = $tener_version_ws;
            $d->status = $status;
            $d->fecha_modificado = date('Y-m-d H:i:s');
            $d->sms_account_sid = $sms_account_sid;
            $d->sms_auth_token = $sms_auth_token;
            $d->sms_phone_number = $sms_phone_number;
            $d->version_sms = $version_sms;
            $d->zona_horaria = $zona_horaria;
            
            $d->enable_whatsapp = $enable_whatsapp == true? 1 : 2;
            $d->enable_twilio   = $enable_twilio == true? 1 : 2;
            $d->save();

            $response = array(
                "type"    => "success",
                "title"     => "Saved information",
                "message" => "Information saved successfully",
                "redirect" => U . "settings/list-config-whatsapp-sms"
            );
            print_r(json_encode($response)) ; exit;
        }else{
            $response = array(
                "type"    => "error",
                "message" => $msg
            );
            print_r(json_encode($response)) ; exit;
        }

 
    
    break;

    case 'update-only-whatsapp-configuration':
         
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);
 

        
        $phone_ws  = $informacion_front['phone_ws'];
        $whatsapp_business_account_identifier = $informacion_front['whatsapp_business_account_identifier'];
        $tener_version_ws  = $informacion_front['tener_version_ws'];
        $token_ws = $informacion_front['token_ws'];
        $phone_identifier = $informacion_front['phone_identifier'];
        $app_Identifier = $informacion_front['app_Identifier'];
        $secret_key_app = $informacion_front['secret_key_app'];
        $whatsapp_app_id_configuration = $informacion_front['whatsapp_app_id_configuration'];

        $id     = $informacion_front['id'];
 

        $msg = "";

        if(empty($id) == true)
        {
            $msg .= "* ID is required" . ' <br>';
        }

        if(empty($phone_ws) == true  )
        {
            $msg .= "* WhatsApp phone is required" . ' <br>';
        }

        if(empty($whatsapp_business_account_identifier) == true  )
        {
            $msg .= "* The WhatsApp Business Account is required" . ' <br>';
        }

        if(empty($tener_version_ws) == true  )
        {
            $msg .= "* The WhatsApp version is required" . ' <br>';
        }

        if(empty($token_ws) == true  )
        {
            $msg .= "* WhatsApp token is required" . ' <br>';
        }

        if(empty($phone_identifier) == true )
        {
            $msg .= "* WhatsApp phone identifier is required" . ' <br>';
        }

        if(empty($app_Identifier) == true  )
        {
            $msg .= "* The WhatsApp app identifier is required" . ' <br>';
        }

        if(empty($secret_key_app) == true )
        {
            $msg .= "* The WhatsApp Secret key of the app is required" . ' <br>';
        }
 
        if(empty($whatsapp_app_id_configuration) == true  )
        {
            $msg .= "* The WhatsApp app configuration is required" . ' <br>';
        }
 
        //r2(U . "settings/list-config-whatsapp-sms", 's', "Information added successfully");

        if($msg == "")
        {
 
            $d = ORM::for_table('config_whatsapp_other')->find_one($id); 
           
            $d->token = $token_ws;
            $d->phone = $phone_ws;
            $d->phone_identifier = $phone_identifier;
            $d->whatsapp_business_account_identifier = $whatsapp_business_account_identifier;
            $d->app_Identifier = $app_Identifier;

            $d->secret_key_app = $secret_key_app;
            $d->whatsapp_app_id_configuration = $whatsapp_app_id_configuration;

            $d->version = $tener_version_ws;

            $d->enable_whatsapp = 1;
        

            $d->fecha_modificado = date('Y-m-d H:i:s');
            $d->save();

            $response = array(
                "type"    => "success",
                "title" => "Number successfully linked",
                "message" => "Your number has been successfully linked. You can now chat with your customers via WhatsApp.",
                
            );
            print_r(json_encode($response)) ; exit;
        }else{
            $response = array(
                "type"    => "error",
                "message" => $msg
            );
            print_r(json_encode($response)) ; exit;
        }

 
    
    break;

    case 'token-procedimientos-registro-insertado':
         
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);
 

        $app_id     = $informacion_front['app_id'];
        $app_secret = $informacion_front['app_secret'];
        $code       = $informacion_front['code'];
        $version    = $informacion_front['version'];
        $waba_id    = $informacion_front['waba_id'];

        $msg = "";

        if(empty($app_id) == true)
        {
            $msg .= "* The app identifier is required" . ' <br>';
        }

        if(empty($app_secret) == true)
        {
            $msg .= "* App secret key is required" . ' <br>';
        }

        if(empty($code) == true)
        {
            $msg .= "* The code that generates the inserted registration logged by Facebook is required" . ' <br>';
        }

        if(empty($version) == true)
        {
            $msg .= "* The WhatsApp version is required" . ' <br>';
        }

        if(empty($waba_id) == true)
        {
            $msg .= "* The Whatsapp business account is required" . ' <br>';
        }

        //r2(U . "settings/list-config-whatsapp-sms", 's', "Information added successfully");

        if($msg == "")
        {
 
            /* $d = ORM::for_table('config_email')->create();
            $d->identifier = slug($identificador);
            $d->token = $token;
            $d->email = $email;
            $d->nombre = $nombre;
            $d->status = $status;
            $d->fecha_post = date('Y-m-d H:i:s');
            $d->save(); */

            $url = "https://graph.facebook.com/$version/oauth/access_token?" . http_build_query([
                'client_id' => $app_id,
                'client_secret' => $app_secret,
                'code' => $code
            ]);
            
            // Inicializar cURL
            $ch = curl_init($url);
            
            // Configurar opciones de cURL
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPGET, true);
            
            // Ejecutar la solicitud y obtener la respuesta
            $response = curl_exec($ch);
            
            $salida = [];
            
            // Verificar errores
            if (curl_errno($ch)) {
                //echo "Error en cURL: " . curl_error($ch);

                $salida = [
                    "token" => "",
                    "phone" => "",
                    "mensaje" => curl_error($ch),
                    "status" => "error"
                ];

            } else {
                // Decodificar JSON
                $data = json_decode($response, true);
                
                // Verificar si se obtuvo el access token
                if (isset($data['access_token'])) {
            
                    $access_token = $data['access_token'];
 
                    $phone_number = getDisplayPhoneNumber($version, $waba_id, $access_token);
 
                    $override_callback_uri = U . "webhooks_whatasapp";
                    $verify_token = APP_DIRECTORIO;
                 
                    $suscripcion_creada = subscribeAppToWaba( $waba_id, $version, $access_token, $override_callback_uri, $verify_token);

                    $mensaje_salida = "";

                    if($suscripcion_creada == true){
                        $mensaje_salida = "!Información procesada exitosamente exitoso¡";
                    }else{
                        $mensaje_salida = "!Se completo todo el proceso para la creacion, Hubo un error al suscribir app¡";
                    }

                    $salida = [
                        "token" => $access_token,
                        "phone" => $phone_number,
                        "mensaje" => $mensaje_salida,
                        "status" =>  $suscripcion_creada == true? "success" : "error"
                    ];

                    // URL de la API de Meta
                     
                    //echo json_encode($token_data); exit;
            
                    //echo "Access Token: " . $data['access_token'];
                } else {
                    //echo "Error en la respuesta: " . $response;
            
                    $mensaje_error = ""; 
            
                    if ($data == null) {
                      $mensaje_error = "Error al decodificar el JSON.";
                    } elseif (is_array($data) && isset($data['error'])) {
                        if (isset($data['error']['message'])) {
                            
                          $mensaje_error = $data['error']['message'];
            
                        } else {
                          $mensaje_error = "El error no contiene un mensaje.";
                        }
                    } else {
                      $mensaje_error = "No se encontró un error en la respuesta.";
                    }
            
                    $salida = [
                      "token" => "",
                      "phone" => "",
                      "mensaje" => $mensaje_error,
                      "status" => "error"
                    ];
            
                    //echo  $mensaje_error; 
            
                    //echo $response; 
                }
            }
            
            // Cerrar cURL
            curl_close($ch);

            //$response = array(
            //    "type"    => "success",
            //    "message" => "Information saved successfully",
            //    "redirect" => U . "settings/list-config-email"
            //);

            print_r(json_encode($salida)) ; exit;

        }else{

            $salida = [
                "token" => "",
                "phone" => "",
                "mensaje" => $msg,
                "status" => "error"
            ];

            print_r(json_encode($salida)) ; exit;

        }

 
    
    break;

    case 'post-add-config-email':
         
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);
 

        $identificador = $informacion_front['identificador'];
        $email = $informacion_front['email'];
        $status = $informacion_front['status'];
        $token = $informacion_front['token'];
        $nombre = $informacion_front['nombre'];
 

        $msg = "";

        if(empty($identificador) == true)
        {
            $msg .= "* The identifier is required" . ' <br>';
        }

        if(empty($email) == true)
        {
            $msg .= "* Email is required" . ' <br>';
        }

        if(empty($status) == true)
        {
            $msg .= "* Status is required" . ' <br>';
        }

        if(empty($token) == true)
        {
            $msg .= "* Token is required" . ' <br>';
        }

        if(empty($nombre) == true)
        {
            $msg .= "* Name is required" . ' <br>';
        }

 
        //r2(U . "settings/list-config-whatsapp-sms", 's', "Information added successfully");

        if($msg == "")
        {
 
            $d = ORM::for_table('config_email')->create();
            $d->identifier = slug($identificador);
            $d->token = $token;
            $d->email = $email;
            $d->nombre = $nombre;
            $d->status = $status;
            $d->fecha_post = date('Y-m-d H:i:s');
            $d->save();

            $response = array(
                "type"    => "success",
                "message" => "Information saved successfully",
                "redirect" => U . "settings/list-config-email"
            );
            print_r(json_encode($response)) ; exit;
        }else{
            $response = array(
                "type"    => "error",
                "message" => $msg
            );
            print_r(json_encode($response)) ; exit;
        }

 
    
    break;

    case 'update-add-config-email':
         
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);
 

        $identificador = $informacion_front['identificador'];
        $email  = $informacion_front['email'];
        $status = $informacion_front['status'];
        $token  = $informacion_front['token'];
        $nombre = $informacion_front['nombre'];
        $id     = $informacion_front['id'];
 

        $msg = "";

        if(empty($id) == true)
        {
            $msg .= "* ID is required" . ' <br>';
        }

        if(empty($identificador) == true)
        {
            $msg .= "* The identifier is required" . ' <br>';
        }

        if(empty($email) == true)
        {
            $msg .= "* Email is required" . ' <br>';
        }

        if(empty($status) == true)
        {
            $msg .= "* Status is required" . ' <br>';
        }

        if(empty($token) == true)
        {
            $msg .= "* Token is required" . ' <br>';
        }

        if(empty($nombre) == true)
        {
            $msg .= "* Name is required" . ' <br>';
        }

 
        //r2(U . "settings/list-config-whatsapp-sms", 's', "Information added successfully");

        if($msg == "")
        {
 
            $d = ORM::for_table('config_email')->find_one($id); 
            $d->identifier = slug($identificador);
            $d->token = $token;
            $d->email = $email;
            $d->nombre = $nombre;
            $d->status = $status;
            $d->fecha_update = date('Y-m-d H:i:s');
            $d->save();

            $response = array(
                "type"    => "success",
                "message" => "Information saved successfully",
                "redirect" => U . "settings/list-config-email"
            );
            print_r(json_encode($response)) ; exit;
        }else{
            $response = array(
                "type"    => "error",
                "message" => $msg
            );
            print_r(json_encode($response)) ; exit;
        }

 
    
    break;

    case 'total-mensajes-no-leidos-ws-crm':

        $roll_id                            = $routes['2'];
        $user_id                            = $routes['3'];

        if(empty($roll_id) == true && $roll_id != "0"){
            $response = array(
                "type" => "error",
                "mensaje" => "Roll id is required",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($user_id) == true){
            $response = array(
                "type" => "error",
                "mensaje" => "User id is required",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }
        
        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
           //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
           $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }


        if($roll_id == "3"){
            $chat_number = $mysqli->query("SELECT id FROM `chat_number` WHERE staff_id='$user_id'")->fetch_all(MYSQLI_ASSOC) ;
            $ids = array_column($chat_number, 'id');
            $ids_concatenados = implode(',', $ids);

            $res         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `status`='delivered' AND esContacto=1 AND chat_number_id IN ($ids_concatenados) ");
            $row         = $res->fetch_assoc(); 
            $total_mensajes          = $row['total_mensajes'] + 0;

        } else{

            $res         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `status`='delivered' AND esContacto=1  ");
            $row         = $res->fetch_assoc(); 
            $total_mensajes          = $row['total_mensajes'] + 0;

        }

        $res_crm         = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_system where `status`='delivered' AND to_user_id='$user_id'  ");
        $row_crm         = $res_crm->fetch_assoc(); 
        $total_mensajes_crm          = $row_crm['total_mensajes'] + 0;

        $response = array(
            "type"     => "success",
            "data"     => $total_mensajes,
            "data_crm" => $total_mensajes_crm,
        );
        $mysqli->close();
        print_r(json_encode( $response)) ; exit;
           
    break;

    case 'marcar-chat-leido':
         
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);
 
        $id_contacto = $informacion_front['id_contacto'];
        $configuracion_whatsapp_sms_id = $informacion_front['configuracion_whatsapp_sms_id'];
        $numero_contacto = $informacion_front['numero_contacto'];
 
        $msg = "";

        if(empty($id_contacto) == true){
            $response = array(
                "type" => "error",
                "mensaje" => "Contact is required",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($numero_contacto) == true){
            $response = array(
                "type" => "error",
                "mensaje" => "Phone is required",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }

        if(empty($configuracion_whatsapp_sms_id) == true){
            $response = array(
                "type" => "error",
                "mensaje" => "WhatsApp configuration is required",
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;
        }
        
        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {

            //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
            $response = array(
                "type" => "error",
                "message" => "Database connection failed",
                "detalle" => $e->getMessage()
            );
            $mysqli->close();

            print_r(json_encode( $response)) ; exit;
        }

        $result_config              = $mysqli->query("SELECT * FROM config_whatsapp_other where `id`='$configuracion_whatsapp_sms_id' ");
        $row_config                 = $result_config->fetch_assoc();

        if(empty($row_config) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "configuration not found",
            );
            print_r(json_encode( $response)) ; exit;
        }

        //echo $row_config["token"]; exit;

        /* "id": "1",
        "identifier": "integraciones_tecnologicas",
        "token": "EAADxTGyoEmwBO9ypxfXW0bge2Da8Fc0SbTEThvB3kwxjTjg8enxCHh0tqiPUB7fhZCfulZCm7eevUNLV0ZAVPeLFO35ZAF4bBigWnKNLUNTYqpwMdD1QzRu7vIegrkIaZAZA3cCZAvj2x5EpG0Eo78HSyATmySTEVmKTZCTAuf0zVZA5X97OejJa4bmRHlWrQQJtD",
        "phone": "15550389264",
        "phone_identifier": "101245809711088",
        "whatsapp_business_account_identifier": "101464746355665",
        "app_Identifier": "265310542762604",
        "version": "v19.0",
        "status": "1",
        "fecha_creacion": "2024-08-02 09:58:41",
        "fecha_modificado": "2024-08-25 18:27:11",
        "sms_account_sid": "ACbed13a7af74fcf734b77b8069cfbeedd",
        "sms_auth_token": "0ef4fa3357c760c16bd4472cbe4c4113",
        "sms_phone_number": "14155211165",
        "version_sms": "2010-04-01" */

        $result              = $mysqli->query("SELECT wam_id, id FROM chat_social where `chat_number_id`='$id_contacto' AND `status`='delivered' AND esContacto=1 AND  tipo_producto='whatsapp' ORDER BY id DESC LIMIT 1");
        $row                 = $result->fetch_assoc();
 
        if(empty($row) == true)
        {
            $response = array(
                "type" => "success",
                "message" => "all conversations marked as read",
            );
            print_r(json_encode( $response)) ; exit;
        }

        $version_api_whatapp = $row_config["version"];
        $phone_number_id     = $row_config["phone_identifier"];
        $token_acceso        = $row_config["token"];
        $from                = $row_config["phone"];
        $to                  = $numero_contacto;

        $messageId = $row["wam_id"];

        marcar_leidos($messageId, "https://graph.facebook.com/$version_api_whatapp/$phone_number_id/messages", $token_acceso, $mysqli, $from, $to);

        $response = array(
            "type"    => "success",
            "message" => "Information saved successfully",
            //"data"    => $row,
            //"config"    => $row_config,
            //"version_api_whatapp"    => $version_api_whatapp,
            //"phone_number_id"    => $phone_number_id,
            //"from"    => $from,
            //"to"    => $to,

        );

        $mysqli->close();

        print_r(json_encode($response)) ; exit;

    break;

 
    default:
        echo 'action not defined';
}

function enviar_plantilla($url, $token_acceso, $data_enviar)
{
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode($data_enviar),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token_acceso,
        ),
    ));

    $response      = curl_exec($curl);
    $responseData  = json_decode($response, true);
    $messageId     = $responseData['messages'][0]['id'];
    $messageStatus = $responseData['messages'][0]['message_status'];
    $messageError  = $responseData['error']["message"];
    $messageCode   = $responseData['error']["code"];

    curl_close($curl);

    return array(
        "messageId"     => $messageId,
        "messageStatus" => $messageStatus,
        "messageError"  => $messageError,
        "messageCode"   => $messageCode,
    );

}

function reemplazarComodinPorText($text, $placeholder, $value) {
    // Escapar el placeholder para usarlo en una expresión regular
    $escapedPlaceholder = preg_quote($placeholder, '/');
    
    // Crear la expresión regular para buscar el placeholder
    $regex = '/' . $escapedPlaceholder . '/';

    // Reemplazar el placeholder con el valor o mantener el placeholder si el valor está vacío
    $updatedText = preg_replace($regex, $value ?: $placeholder, $text);

    return $updatedText;
}

function marcar_leidos($wam_id, $url,$token_acceso, $mysqli, $from, $to)
{
    // Datos a enviar en la solicitud
    $data = array(
        "messaging_product" => "whatsapp",
        "status" => "read",
        "message_id" => $wam_id
    );

    // Inicializar una sesión cURL
    $ch = curl_init($url);

    // Configurar opciones de cURL
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Retornar la transferencia como cadena del valor de curl_exec()
    curl_setopt($ch, CURLOPT_POST, true); // Establecer el método de solicitud a POST
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Authorization: Bearer ' . $token_acceso,
        'Content-Type: application/json'
    )); // Configurar las cabeceras HTTP

    // Codificar el array de datos como JSON
    $jsonData = json_encode($data);

    // Configurar el cuerpo de la solicitud
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);

    // Ejecutar la solicitud y obtener la respuesta
    $response = curl_exec($ch);

    //$inf = "";

    // Verificar si se produjo un error
    if (curl_errno($ch)) {
        //$inf =  curl_error($ch);
        //print_r(json_encode($inf)); 
    } else {
        // Imprimir la respuesta
        //$inf =   $response;
        //print_r(json_encode($inf)); 
        $mysqli->query("UPDATE chat_social SET `status`='read' WHERE `status`='delivered' AND `from`='$from' AND `to`='$to' AND esContacto=1");
    }

    // Cerrar la sesión cURL
    curl_close($ch);

    

}

function dejarSoloNumeros($texto) {
    // Usar preg_replace para eliminar todos los caracteres que no sean dígitos
    $textoSoloNumeros = preg_replace('/\D/', '', $texto);
    return $textoSoloNumeros;
}


//crea el archivo index para que nadie ve las imagenes
function createHtmlFile($filename) {
    // Abre el archivo para escritura. Si no existe, lo crea.
    $file = fopen($filename, 'w');
    
    // Verifica si el archivo se abrió correctamente
    if ($file === false) {
        return "Error al abrir el archivo.";
    }

    $content = '
    <html>
    <head>
        <title>403 Forbidden</title>
    </head>
    <body>
    <p>Directory access is forbidden.</p>
    </body>
    </html>
    ';

    // Escribe el contenido en el archivo
    fwrite($file, $content);

    // Cierra el archivo
    fclose($file);
}


//creacion de imagen renderizada
function DimensionesImagen($imagen, $anchoCanvas, $altoCanvas, $anchoOriginal, $altoOriginal, $rutaGuardarImagen) {
    $escala = min($anchoCanvas / $anchoOriginal, $altoCanvas / $altoOriginal);
    $nuevoAncho = $anchoOriginal * $escala;
    $nuevoAlto = $altoOriginal * $escala;

    // Crear un canvas blanco de 500x500
    $canvas = imagecreatetruecolor($anchoCanvas, $altoCanvas);

    // Definir el color blanco
    $blanco = imagecolorallocate($canvas, 255, 255, 255);

    imagesavealpha($canvas, true);
    $transparente = imagecolorallocatealpha($canvas, 0, 0, 0, 127);

    // Rellenar el fondo del canvas con color blanco
    imagefill($canvas, 0, 0, $transparente);

    // Calcular las coordenadas para centrar la imagen en el canvas
    $x = ($anchoCanvas - $nuevoAncho) / 2;
    $y = ($altoCanvas - $nuevoAlto) / 2;

    // Redimensionar la imagen para que se ajuste al canvas
    $imagenRedimensionada = imagecreatetruecolor($nuevoAncho, $nuevoAlto);
    imagefill($imagenRedimensionada, 0, 0, $blanco);// si queremos trasparente quitamos esto
    imagecopyresampled($imagenRedimensionada, $imagen, 0, 0, 0, 0, $nuevoAncho, $nuevoAlto, $anchoOriginal, $altoOriginal);

    // Copiar la imagen redimensionada al centro del canvas
    imagecopy($canvas, $imagenRedimensionada, $x, $y, 0, 0, $nuevoAncho, $nuevoAlto);

    $seCreo = false;

    // Guardar el canvas con la imagen colocada
    if (imagepng($canvas, $rutaGuardarImagen)) {
        //echo "Canvas con imagen guardado correctamente en $rutaGuardarImagen";
        $seCreo = true;
    } else {
        //echo "Error al guardar el canvas con imagen.";
        $seCreo = false;
    }

    // Liberar la memoria utilizada por la imagen, el canvas y la imagen redimensionada
    imagedestroy($canvas);
    imagedestroy($imagen);
    imagedestroy($imagenRedimensionada);

    return $seCreo;
}


function enviarSocket($datos)
{
    //$url = 'https://xhde365.com/socket-chat/socket.io/';  
    $url = APP_URL_SERVIDOR_SOCKET;  

    $options = [
        'client' => Client::CLIENT_4X,
        'context' => [
            'http' => [],
            'ssl' => [],
        ],
        'transports' => ['polling'],
    ];

    try {
        $client = Client::create($url, $options);

        $client->initialize(); // Inicializa la conexión

        // Emitir el evento "position"
        /* $dataPosition =
        [
            'id_order' => 10000,
            'lat' => 140.7128,
            'lng' => -74.006,
            'estadoId' => 12,
        ];

        $client->emit('position', $dataPosition); */

        // Emitir el evento "chat-social"
        $client->emit('add-contactos-empleados', $datos);

        $client->close(); // Cierra la conexión

        //http_response_code(200);
        //echo "Se envio la info";

    } catch (Exception $e) {
        /* http_response_code(500);
        echo 'Error: ', $e->getMessage(), "\n";
        exit; */
    }
}


function enviarSocketNotificarChatAdmin($datos)
{
    //$url = 'https://xhde365.com/socket-chat/socket.io/';  
    $url = APP_URL_SERVIDOR_SOCKET;  

    $options = [
        'client' => Client::CLIENT_4X,
        'context' => [
            'http' => [],
            'ssl' => [],
        ],
        'transports' => ['polling'],
    ];

    try {
        $client = Client::create($url, $options);

        $client->initialize(); // Inicializa la conexión

        // Emitir el evento "position"
        /* $dataPosition =
        [
            'id_order' => 10000,
            'lat' => 140.7128,
            'lng' => -74.006,
            'estadoId' => 12,
        ];

        $client->emit('position', $dataPosition); */

        // Emitir el evento "chat-social"
        $client->emit('change-customer-admin', $datos);

        $client->close(); // Cierra la conexión

        //http_response_code(200);
        //echo "Se envio la info";

    } catch (Exception $e) {
        /* http_response_code(500);
        echo 'Error: ', $e->getMessage(), "\n";
        exit; */
    }
}


function tener_staff($mysqli, $staff_id)
{
    $data_personal = $mysqli->query("SELECT 
                                       
                                        IFNULL(sys_u.fullname, 'Unassigned staff') AS fullname_staff,
                                        sys_u.username AS username_staff,
                                        sys_u.user_type AS user_type_staff,
                                        sys_u.phonenumber AS phonenumber
                                    FROM 
                                        sys_users AS sys_u
                                    
                                    WHERE sys_u.id='$staff_id'
                                     ;")->fetch_assoc();
                                    
    return $data_personal;
}

function tener_custumers($mysqli, $custumers_id)
{
    $data_personal = $mysqli->query("SELECT 
                                       
                                        crm_a.email AS email_custumers,
                                        crm_a.phone AS phone_custumers,
                                        crm_a.company AS company_custumers,
                                        crm_a.address AS address_custumers,
                                        crm_a.account AS account
                                    
                                    FROM 
                                        crm_accounts AS crm_a 
                               
                                    WHERE crm_a.id='$custumers_id'

                                    ;
                                     ")->fetch_assoc();
                                    
    return $data_personal;
}

function tener_mensajes_no_leidos($mysqli, $chat_number_id, $tipo_producto, $status)
{
    //status delivered = whatsapp
    //status received  = sms

    $result = $mysqli->query("SELECT count(*) as total_mensajes FROM chat_social where `chat_number_id`='$chat_number_id' AND `status`='$status' AND esContacto=1 AND  tipo_producto='$tipo_producto'");

    $row = $result->fetch_assoc();
    // Obtener el valor de total_mensajes
    $total_mensajes = $row['total_mensajes'];
                                    
    return $total_mensajes;
}


function guardar_archivos($nombre_directorio, $extencion, $binarios)
{
    $ruta_root = $_SERVER['DOCUMENT_ROOT'];   

    // Verificar si la ruta tiene una barra al final
    if (substr($ruta_root, -1) === '/') {
        // Si hay una barra al final, eliminarla
        $ruta_root = rtrim($ruta_root, '/');
    }

    $tipo_proyecto_produccion = APP_DIRECTORIO;

    $basePath = $ruta_root . "/$tipo_proyecto_produccion/storage/whatsapp/$nombre_directorio/";
    $path_db = "/storage/whatsapp/$nombre_directorio/";

    if (!file_exists($basePath))
    {
        mkdir($basePath, 0777, true);
        createHtmlFile($basePath."/index.html");
    } 

    $numero_aleatorio = rand(1, 1000000); 

    $formato = date('Y-m-d-H-i-s');
                        
    $nombre_archivo = $formato."_".$numero_aleatorio. "_enviado.$extencion";
    $folderPath = $basePath;

    $file = $folderPath . $nombre_archivo;

    $url_final = APP_URL . $path_db . $nombre_archivo;

    //si coloco file me estaria dando la direccion del archivo
    //$url = $url_final;

    file_put_contents($file, $binarios);

    return $url_final;
}

/* function slug($text, $length = null) {

    // Lista de reemplazos de caracteres no deseados
    $replacements = [
        '<' => '', '>' => '', '-' => ' ', '&' => '', '"' => '', 'À' => 'A', 'Á' => 'A', 'Â' => 'A', 'Ã' => 'A', 'Ä' => 'Ae', 'Ä' => 'A', 'Å' => 'A', 'Ā' => 'A', 'Ą' => 'A', 'Ă' => 'A', 'Æ' => 'Ae', 'Ç' => 'C', "'" => '', 'Ć' => 'C', 'Č' => 'C', 'Ĉ' => 'C', 'Ċ' => 'C', 'Ď' => 'D', 'Đ' => 'D', 'Ð' => 'D', 'È' => 'E', 'É' => 'E', 'Ê' => 'E', 'Ë' => 'E', 'Ē' => 'E', 'Ę' => 'E', 'Ě' => 'E', 'Ĕ' => 'E', 'Ė' => 'E', 'Ĝ' => 'G', 'Ğ' => 'G', 'Ġ' => 'G', 'Ģ' => 'G', 'Ĥ' => 'H', 'Ħ' => 'H', 'Ì' => 'I', 'Í' => 'I', 'Î' => 'I', 'Ï' => 'I', 'Ī' => 'I', 'Ĩ' => 'I', 'Ĭ' => 'I', 'Į' => 'I', 'İ' => 'I', 'Ĳ' => 'IJ', 'Ĵ' => 'J', 'Ķ' => 'K', 'Ł' => 'L', 'Ľ' => 'L', 'Ĺ' => 'L', 'Ļ' => 'L', 'Ŀ' => 'L', 'Ñ' => 'N', 'Ń' => 'N', 'Ň' => 'N', 'Ņ' => 'N', 'Ŋ' => 'N', 'Ò' => 'O', 'Ó' => 'O', 'Ô' => 'O', 'Õ' => 'O', 'Ö' => 'Oe', 'Ö' => 'Oe', 'Ø' => 'O', 'Ō' => 'O', 'Ő' => 'O', 'Ŏ' => 'O', 'Œ' => 'OE', 'Ŕ' => 'R', 'Ř' => 'R', 'Ŗ' => 'R', 'Ś' => 'S', 'Š' => 'S', 'Ş' => 'S', 'Ŝ' => 'S', 'Ș' => 'S', 'Ť' => 'T', 'Ţ' => 'T', 'Ŧ' => 'T', 'Ț' => 'T', 'Ù' => 'U', 'Ú' => 'U', 'Û' => 'U', 'Ü' => 'Ue', 'Ū' => 'U', 'Ü' => 'Ue', 'Ů' => 'U', 'Ű' => 'U', 'Ŭ' => 'U', 'Ũ' => 'U', 'Ų' => 'U', 'Ŵ' => 'W', 'Ý' => 'Y', 'Ŷ' => 'Y', 'Ÿ' => 'Y', 'Ź' => 'Z', 'Ž' => 'Z', 'Ż' => 'Z', 'Þ' => 'T', 'à' => 'a', 'á' => 'a', 'â' => 'a', 'ã' => 'a', 'ä' => 'ae', 'ä' => 'ae', 'å' => 'a', 'ā' => 'a', 'ą' => 'a', 'ă' => 'a', 'æ' => 'ae', 'ç' => 'c', 'ć' => 'c', 'č' => 'c', 'ĉ' => 'c', 'ċ' => 'c', 'ď' => 'd', 'đ' => 'd', 'ð' => 'd', 'è' => 'e', 'é' => 'e', 'ê' => 'e', 'ë' => 'e', 'ē' => 'e', 'ę' => 'e', 'ě' => 'e', 'ĕ' => 'e', 'ė' => 'e', 'ƒ' => 'f', 'ĝ' => 'g', 'ğ' => 'g', 'ġ' => 'g', 'ģ' => 'g', 'ĥ' => 'h', 'ħ' => 'h', 'ì' => 'i', 'í' => 'i', 'î' => 'i', 'ï' => 'i', 'ī' => 'i', 'ĩ' => 'i', 'ĭ' => 'i', 'į' => 'i', 'ı' => 'i', 'ĳ' => 'ij', 'ĵ' => 'j', 'ķ' => 'k', 'ĸ' => 'k', 'ł' => 'l', 'ľ' => 'l', 'ĺ' => 'l', 'ļ' => 'l', 'ŀ' => 'l', 'ñ' => 'n', 'ń' => 'n', 'ň' => 'n', 'ņ' => 'n', 'ŉ' => 'n', 'ŋ' => 'n', 'ò' => 'o', 'ó' => 'o', 'ô' => 'o', 'õ' => 'o', 'ö' => 'oe', 'ö' => 'oe', 'ø' => 'o', 'ō' => 'o', 'ő' => 'o', 'ŏ' => 'o', 'œ' => 'oe', 'ŕ' => 'r', 'ř' => 'r', 'ŗ' => 'r', 'š' => 's', 'ś' => 's', 'ù' => 'u', 'ú' => 'u', 'û' => 'u', 'ü' => 'ue', 'ū' => 'u', 'ü' => 'ue', 'ů' => 'u', 'ű' => 'u', 'ŭ' => 'u', 'ũ' => 'u', 'ų' => 'u', 'ŵ' => 'w', 'ý' => 'y', 'ÿ' => 'y', 'ŷ' => 'y', 'ž' => 'z', 'ż' => 'z', 'ź' => 'z', 'þ' => 't', 'α' => 'a', 'ß' => 'ss', 'ẞ' => 'b', 'ſ' => 'ss', 'ый' => 'iy', 'А' => 'A', 'Б' => 'B', 'В' => 'V', 'Г' => 'G', 'Д' => 'D', 'Е' => 'E', 'Ё' => 'YO', 'Ж' => 'ZH', 'З' => 'Z', 'И' => 'I', 'Й' => 'Y', 'К' => 'K', 'Л' => 'L', 'М' => 'M', 'Н' => 'N', 'О' => 'O', 'П' => 'P', 'Р' => 'R', 'С' => 'S', 'Т' => 'T', 'У' => 'U', 'Ф' => 'F', 'Х' => 'H', 'Ц' => 'C', 'Ч' => 'CH', 'Ш' => 'SH', 'Щ' => 'SCH', 'Ъ' => '', 'Ы' => 'Y', 'Ь' => '', 'Э' => 'E', 'Ю' => 'YU', 'Я' => 'YA', 'а' => 'a', 'б' => 'b', 'в' => 'v', 'г' => 'g', 'д' => 'd', 'е' => 'e', 'ё' => 'yo', 'ж' => 'zh', 'з' => 'z', 'и' => 'i', 'й' => 'y', 'к' => 'k', 'л' => 'l', 'м' => 'm', 'н' => 'n', 'о' => 'o', 'п' => 'p', 'р' => 'r', 'с' => 's', 'т' => 't', 'у' => 'u', 'ф' => 'f', 'х' => 'h', 'ц' => 'c', 'ч' => 'ch', 'ш' => 'sh', 'щ' => 'sch', 'ъ' => '', 'ы' => 'y', 'ь' => '', 'э' => 'e', 'ю' => 'yu', 'я' => 'ya', '.' => '_', '€' => '-eur-', '$' => '-usd-'
    ];

    // Reemplazar caracteres no deseados
    $text = strtr($text, $replacements);

    // Reemplazar caracteres que no sean letras o dígitos con "_"
    $text = preg_replace('~[^\\pL\d]+~u', '_', $text);

    // Trimear guiones bajos del principio y final
    $text = trim($text, '_');

    // Convertir a minúsculas
    $text = strtolower($text);

    // Si la longitud es especificada, cortar el texto
    if ($length && mb_strlen($text) > $length) {
        $text = mb_substr($text, 0, $length);
    }

    return $text;
}
 */

 function slug($text, $length = null) {

    // Lista de reemplazos de caracteres no deseados
    $replacements = [
        '<' => '', '>' => '', '-' => ' ', '&' => '', '"' => '', 'À' => 'A', 'Á' => 'A', 'Â' => 'A', 'Ã' => 'A', 'Ä' => 'Ae', 'Ä' => 'A', 'Å' => 'A', 'Ā' => 'A', 'Ą' => 'A', 'Ă' => 'A', 'Æ' => 'Ae', 'Ç' => 'C', "'" => '', 'Ć' => 'C', 'Č' => 'C', 'Ĉ' => 'C', 'Ċ' => 'C', 'Ď' => 'D', 'Đ' => 'D', 'Ð' => 'D', 'È' => 'E', 'É' => 'E', 'Ê' => 'E', 'Ë' => 'E', 'Ē' => 'E', 'Ę' => 'E', 'Ě' => 'E', 'Ĕ' => 'E', 'Ė' => 'E', 'Ĝ' => 'G', 'Ğ' => 'G', 'Ġ' => 'G', 'Ģ' => 'G', 'Ĥ' => 'H', 'Ħ' => 'H', 'Ì' => 'I', 'Í' => 'I', 'Î' => 'I', 'Ï' => 'I', 'Ī' => 'I', 'Ĩ' => 'I', 'Ĭ' => 'I', 'Į' => 'I', 'İ' => 'I', 'Ĳ' => 'IJ', 'Ĵ' => 'J', 'Ķ' => 'K', 'Ł' => 'L', 'Ľ' => 'L', 'Ĺ' => 'L', 'Ļ' => 'L', 'Ŀ' => 'L', 'Ñ' => 'N', 'Ń' => 'N', 'Ň' => 'N', 'Ņ' => 'N', 'Ŋ' => 'N', 'Ò' => 'O', 'Ó' => 'O', 'Ô' => 'O', 'Õ' => 'O', 'Ö' => 'Oe', 'Ö' => 'Oe', 'Ø' => 'O', 'Ō' => 'O', 'Ő' => 'O', 'Ŏ' => 'O', 'Œ' => 'OE', 'Ŕ' => 'R', 'Ř' => 'R', 'Ŗ' => 'R', 'Ś' => 'S', 'Š' => 'S', 'Ş' => 'S', 'Ŝ' => 'S', 'Ș' => 'S', 'Ť' => 'T', 'Ţ' => 'T', 'Ŧ' => 'T', 'Ț' => 'T', 'Ù' => 'U', 'Ú' => 'U', 'Û' => 'U', 'Ü' => 'Ue', 'Ū' => 'U', 'Ü' => 'Ue', 'Ů' => 'U', 'Ű' => 'U', 'Ŭ' => 'U', 'Ũ' => 'U', 'Ų' => 'U', 'Ŵ' => 'W', 'Ý' => 'Y', 'Ŷ' => 'Y', 'Ÿ' => 'Y', 'Ź' => 'Z', 'Ž' => 'Z', 'Ż' => 'Z', 'Þ' => 'T', 'à' => 'a', 'á' => 'a', 'â' => 'a', 'ã' => 'a', 'ä' => 'ae', 'ä' => 'ae', 'å' => 'a', 'ā' => 'a', 'ą' => 'a', 'ă' => 'a', 'æ' => 'ae', 'ç' => 'c', 'ć' => 'c', 'č' => 'c', 'ĉ' => 'c', 'ċ' => 'c', 'ď' => 'd', 'đ' => 'd', 'ð' => 'd', 'è' => 'e', 'é' => 'e', 'ê' => 'e', 'ë' => 'e', 'ē' => 'e', 'ę' => 'e', 'ě' => 'e', 'ĕ' => 'e', 'ė' => 'e', 'ƒ' => 'f', 'ĝ' => 'g', 'ğ' => 'g', 'ġ' => 'g', 'ģ' => 'g', 'ĥ' => 'h', 'ħ' => 'h', 'ì' => 'i', 'í' => 'i', 'î' => 'i', 'ï' => 'i', 'ī' => 'i', 'ĩ' => 'i', 'ĭ' => 'i', 'į' => 'i', 'ı' => 'i', 'ĳ' => 'ij', 'ĵ' => 'j', 'ķ' => 'k', 'ĸ' => 'k', 'ł' => 'l', 'ľ' => 'l', 'ĺ' => 'l', 'ļ' => 'l', 'ŀ' => 'l', 'ñ' => 'n', 'ń' => 'n', 'ň' => 'n', 'ņ' => 'n', 'ŉ' => 'n', 'ŋ' => 'n', 'ò' => 'o', 'ó' => 'o', 'ô' => 'o', 'õ' => 'o', 'ö' => 'oe', 'ö' => 'oe', 'ø' => 'o', 'ō' => 'o', 'ő' => 'o', 'ŏ' => 'o', 'œ' => 'oe', 'ŕ' => 'r', 'ř' => 'r', 'ŗ' => 'r', 'š' => 's', 'ś' => 's', 'ù' => 'u', 'ú' => 'u', 'û' => 'u', 'ü' => 'ue', 'ū' => 'u', 'ü' => 'ue', 'ů' => 'u', 'ű' => 'u', 'ŭ' => 'u', 'ũ' => 'u', 'ų' => 'u', 'ŵ' => 'w', 'ý' => 'y', 'ÿ' => 'y', 'ŷ' => 'y', 'ž' => 'z', 'ż' => 'z', 'ź' => 'z', 'þ' => 't', 'α' => 'a', 'ß' => 'ss', 'ẞ' => 'b', 'ſ' => 'ss', 'ый' => 'iy', 'А' => 'A', 'Б' => 'B', 'В' => 'V', 'Г' => 'G', 'Д' => 'D', 'Е' => 'E', 'Ё' => 'YO', 'Ж' => 'ZH', 'З' => 'Z', 'И' => 'I', 'Й' => 'Y', 'К' => 'K', 'Л' => 'L', 'М' => 'M', 'Н' => 'N', 'О' => 'O', 'П' => 'P', 'Р' => 'R', 'С' => 'S', 'Т' => 'T', 'У' => 'U', 'Ф' => 'F', 'Х' => 'H', 'Ц' => 'C', 'Ч' => 'CH', 'Ш' => 'SH', 'Щ' => 'SCH', 'Ъ' => '', 'Ы' => 'Y', 'Ь' => '', 'Э' => 'E', 'Ю' => 'YU', 'Я' => 'YA', 'а' => 'a', 'б' => 'b', 'в' => 'v', 'г' => 'g', 'д' => 'd', 'е' => 'e', 'ё' => 'yo', 'ж' => 'zh', 'з' => 'z', 'и' => 'i', 'й' => 'y', 'к' => 'k', 'л' => 'l', 'м' => 'm', 'н' => 'n', 'о' => 'o', 'п' => 'p', 'р' => 'r', 'с' => 's', 'т' => 't', 'у' => 'u', 'ф' => 'f', 'х' => 'h', 'ц' => 'c', 'ч' => 'ch', 'ш' => 'sh', 'щ' => 'sch', 'ъ' => '', 'ы' => 'y', 'ь' => '', 'э' => 'e', 'ю' => 'yu', 'я' => 'ya', '.' => '_', '€' => '-eur-', '$' => '-usd-'
    ];

    // Reemplazar caracteres no deseados
    $text = strtr($text, $replacements);

    // Reemplazar caracteres que no sean letras o dígitos por espacios
    $text = preg_replace('/[^A-Za-z0-9\-]/', ' ', $text);

    // Reemplazar espacios por guiones y eliminar múltiples guiones
    $text = preg_replace('/[\s-]+/', '_', $text);

    // Eliminar guiones iniciales y finales
    $text = trim($text, '-');

    // Convertir a minúsculas
    $text = strtolower($text);

    // Cortar a la longitud deseada si se especifica
    if ($length) {
        $text = substr($text, 0, $length);
    }

    return $text;
}

function getDisplayPhoneNumber($version, $waba_id, $access_token) {
    // Construir la URL de la API de Meta
    $url = "https://graph.facebook.com/{$version}/{$waba_id}/phone_numbers?access_token={$access_token}";

    // Inicializar cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPGET, true); // Método GET
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Devolver la respuesta como string
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true); // Verificar el certificado SSL

    // Ejecutar la solicitud
    $response = curl_exec($ch);

    // Verificar si hubo errores en cURL
    if ($response === false) {
        curl_close($ch);
        return ""; // Retornar cadena vacía en caso de error
    }

    // Obtener el código de respuesta HTTP
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Cerrar la conexión cURL
    curl_close($ch);

    // Si el código HTTP no es 200 (OK), retornar cadena vacía
    if ($http_code !== 200) {
        return "";
    }

    // Decodificar la respuesta JSON
    $response_data = json_decode($response, true);

    // Verificar si la respuesta tiene la clave 'data', es un arreglo y tiene al menos un elemento
    if (is_array($response_data) && isset($response_data['data']) && is_array($response_data['data']) && !empty($response_data['data']) && isset($response_data['data'][0]['display_phone_number'])) {
        return $response_data['data'][0]['display_phone_number']; // Retornar el número de teléfono
    }

    // Retornar cadena vacía si no hay datos válidos
    return "";
}

function subscribeAppToWaba($waba_id, $version, $access_token, $override_callback_uri, $verify_token) {
    $url = "https://graph.facebook.com/$version/{$waba_id}/subscribed_apps";
    $data = json_encode([
        'override_callback_uri' => $override_callback_uri,
        'verify_token' => $verify_token
    ]);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer {$access_token}",
        "Content-Type: application/json"
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);

    $response = curl_exec($ch);

    if ($response === false) {
        $error = curl_error($ch);
        curl_close($ch);
        //error_log("cURL error: " . $error);
        return false;
    }

    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code !== 200) {
        //error_log("HTTP error code: " . $http_code . " Response: " . $response);
        return false;
    }

    $response_data = json_decode($response, true);

    if (is_array($response_data)) {
        if (isset($response_data['success'])) {
            return $response_data['success'];
        } elseif (isset($response_data['error'])) {
            //error_log("API error: " . $response_data['error']['message']);
        }
    }

    return false;
}

function registerWhatsAppPhoneNumber($phone_number_id, $business_token, $pin, $api_version) {
    // URL de la API de Meta
    $url = "https://graph.facebook.com/{$api_version}/{$phone_number_id}/register";

    // Datos que se enviarán en el cuerpo de la solicitud (JSON)
    $data = [
        'messaging_product' => 'whatsapp',
        'pin' => $pin
    ];

    // Convertir los datos a formato JSON
    $json_data = json_encode($data);

    // Configurar las cabeceras
    $headers = [
        "Content-Type: application/json",
        "Authorization: Bearer {$business_token}"
    ];

    // Inicializar cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true); // Método POST
    curl_setopt($ch, CURLOPT_POSTFIELDS, $json_data); // Enviar datos JSON
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); // Añadir cabeceras
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Devolver la respuesta como string
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true); // Verificar SSL

    // Ejecutar la solicitud
    $response = curl_exec($ch);

    // Verificar si hubo errores en cURL
    if ($response === false) {
        $error = curl_error($ch);
        curl_close($ch);
        return [
            "mensaje" =>  $error,
            "status" => false
        ];
    }

    // Obtener el código de respuesta HTTP
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Cerrar la conexión cURL
    curl_close($ch);

    // Decodificar la respuesta de Meta
    $response_data = json_decode($response, true);

    // Verificar el resultado
    if ($http_code == 200 && isset($response_data['success']) && $response_data['success'] === true) {
        return [
            "mensaje" => "Número de teléfono registrado correctamente en WhatsApp",
            "status" => true
        ];
    } else {
        // Manejar el mensaje de error si existe, o un mensaje genérico si no
        $error_message = isset($response_data['error']['message']) ? $response_data['error']['message'] : "Error desconocido al registrar el número";
        return [
            "mensaje" => $error_message,
            "status" => false
        ];
    }
}