<?php
/*
|--------------------------------------------------------------------------
| Controller
|--------------------------------------------------------------------------
|
*/
_auth();
$ui->assign('selected_navigation', 'contacts');
$ui->assign('_title', $_L['Accounts'] . '- ' . $config['CompanyName']);
$action = $routes['1'];
$user = User::_info();
$ui->assign('user', $user);

$ui->assign('base_datos_para_socket', DB_NAME);
$ui->assign('config_whatsapp_other_id_para_socket', empty($user["config_whatsapp_other_id"]) == true ? "No_existe" : $user["config_whatsapp_other_id"] );
$ui->assign('url_ir_chat_empleado', U . "social/social-chat-employee");
$ui->assign('url_ir_chat_admin', U . "social/social-chat");

$ui->assign('url_ir_chat_crm', U . "social/chat-crm");
$ui->assign('url_base_plantilla_admintpl', U);
$ui->assign('APP_URL_ORIGINAL_SOCKET', APP_URL_ORIGINAL_SOCKET);
$ui->assign('url_setting_CRM_Parnerts_prepared', url_setting_CRM_Parnerts_prepared);
$ui->assign('db_crm_administrative', getDBCRMAdministrative());
$ui->assign('url_origen', U);

$ruta_segundaria = route(1);
$armado_ruta = "";
$ui->assign('ws_nombre_socket', ws_nombre_socket);
if(empty($ruta_segundaria) == true )
{
    $armado_ruta = route(0);
}else{
    $armado_ruta = route(0) . "/" . route(1);
}

//$ui->assign('sin_ruta', $armado_ruta);
$ui->assign('sin_ruta', _get('ng'));


if(empty($_SESSION['menu_categorias_user']) == false)
{
    $ui->assign('menu_categorias_user', $_SESSION['menu_categorias_user']);
}

$data = request()->all();
switch ($action) {
    case 'save':

        header('Content-Type: application/json; charset=utf-8');
    
        $imagePath = "storage/pics/";
        if (!is_dir($imagePath)) {
            mkdir($imagePath, 0755, true);
        }
        if (!is_writable($imagePath)) {
            echo json_encode(["status" => "error", "message" => "Upload folder not writable"]);
            exit;
        }
    
        if (empty($_FILES['img']) || $_FILES['img']['error'] !== UPLOAD_ERR_OK) {
            echo json_encode(["status" => "error", "message" => "Error uploading"]);
            exit;
        }
    
        $tmp = $_FILES['img']['tmp_name'];
    
        // validar MIME real (no extensión)
        $finfo = finfo_open(FILEINFO_MIME_TYPE);
        $mime  = finfo_file($finfo, $tmp);
        finfo_close($finfo);
    
        $extMap = [
            'image/jpeg' => '.jpg',
            'image/png'  => '.png',
            'image/gif'  => '.gif',
        ];
    
        if (!isset($extMap[$mime])) {
            echo json_encode(["status" => "error", "message" => "Unsupported image type"]);
            exit;
        }
    
        // leer dimensiones del tmp real
        $size = @getimagesize($tmp);
        if (!$size) {
            echo json_encode(["status" => "error", "message" => "Invalid image"]);
            exit;
        }
        [$width, $height] = $size;
    
        // guarda un archivo temporal "original" con nombre único
        $originalFullPath = $imagePath . 'up_' . uniqid() . $extMap[$mime];
        if (!move_uploaded_file($tmp, $originalFullPath)) {
            echo json_encode(["status" => "error", "message" => "Could not save file"]);
            exit;
        }
    
        // crear source image según mime
        switch ($mime) {
            case 'image/png':
                $source_image = imagecreatefrompng($originalFullPath);
                break;
            case 'image/gif':
                $source_image = imagecreatefromgif($originalFullPath);
                break;
            default:
                $source_image = imagecreatefromjpeg($originalFullPath);
                break;
        }
    
        if (!$source_image) {
            echo json_encode(["status" => "error", "message" => "Could not read image"]);
            exit;
        }
    
        // center crop square + max 462
        $cropSize = min($width, $height);
        $srcX = (int)(($width - $cropSize) / 2);
        $srcY = (int)(($height - $cropSize) / 2);
    
        $maxDim = 462;
        $scale = ($cropSize > $maxDim) ? ($maxDim / $cropSize) : 1;
        $targetSize = (int) round($cropSize * $scale);
    
        $dest_image = imagecreatetruecolor($targetSize, $targetSize);
        $white = imagecolorallocate($dest_image, 255, 255, 255);
        imagefill($dest_image, 0, 0, $white);
    
        // transparencias
        /*if ($mime === 'image/png') {
            imagealphablending($dest_image, false);
            imagesavealpha($dest_image, true);
        } elseif ($mime === 'image/gif') {
            $transparent_index = imagecolortransparent($source_image);
            if ($transparent_index >= 0) {
                $transparent_color = imagecolorsforindex($source_image, $transparent_index);
                $ti = imagecolorallocate($dest_image, $transparent_color['red'], $transparent_color['green'], $transparent_color['blue']);
                imagefill($dest_image, 0, 0, $ti);
                imagecolortransparent($dest_image, $ti);
            }
        }*/
    
        imagecopyresampled(
            $dest_image,
            $source_image,
            0, 0,
            $srcX, $srcY,
            $targetSize, $targetSize,
            $cropSize, $cropSize
        );
    
        //$outputFile = $imagePath . 'cr_' . uniqid() . $extMap[$mime];
        
        //Always save as jpg
        $outputFile = $imagePath . 'cr_' . uniqid() . '.jpg';
    
        // Save final image
        /*if ($mime === 'image/png') {
            imagepng($dest_image, $outputFile);
        } elseif ($mime === 'image/gif') {
            imagegif($dest_image, $outputFile);
        } else {
            imagejpeg($dest_image, $outputFile, 90);
        }*/

        imagejpeg($dest_image, $outputFile, 90);
    
        // Clean memory
        imagedestroy($source_image);
        imagedestroy($dest_image);
    
        // opcional: borra el original para no llenar disco
        @unlink($originalFullPath);
    
        echo json_encode([
            "status" => "success",
            "url"    => APP_URL . '/' . $outputFile,
            "width"  => $width,
            "height" => $height,
        ]);
        exit;
    
    break;
    

    case 'crop':
        header('Content-Type: application/json; charset=utf-8');

        $imgUrl = $data['imgUrl'];
        $imgInitW = (int) $data['imgInitW'];
        $imgInitH = (int) $data['imgInitH'];
        $imgW = (int) $data['imgW'];
        $imgH = (int) $data['imgH'];
        $imgY1 = (int) $data['imgY1'];
        $imgX1 = (int) $data['imgX1'];
        $cropW = (int) $data['cropW'];
        $cropH = (int) $data['cropH'];

        //$jpeg_quality = 100;

        $path = parse_url($imgUrl, PHP_URL_PATH);
        $root = rtrim($_SERVER['DOCUMENT_ROOT'], '/\\') . DIRECTORY_SEPARATOR;
        $fg = $root . ltrim($path, '/');

        if (!is_file($fg)) {
            echo json_encode(["status" => "error", "message" => "File not found"]);
            exit;
        }

        $what = getimagesize($fg);

        if (!$what) {
            echo json_encode(["status" => "error", "message" => "Invalid image"]);
            exit;
        }
        
        switch (strtolower($what['mime'])) {
            case 'image/png':
                $source_image = imagecreatefrompng($fg);
                break;
            case 'image/jpeg':
                $source_image = imagecreatefromjpeg($fg);
                break;
            case 'image/gif':
                $source_image = imagecreatefromgif($fg);
                break;
            default:
                echo json_encode(["status" => "error", "message" => "image type not supported"]);
                exit;
        }
        
        if (!$source_image) {
            echo json_encode(["status" => "error", "message" => "Could not read image"]);
            exit;
        }

        $resizedImage = imagecreatetruecolor($imgW, $imgH);
        $white = imagecolorallocate($resizedImage, 255, 255, 255);
        imagefill($resizedImage, 0, 0, $white);

        imagecopyresampled(
            $resizedImage,
            $source_image,
            0,
            0,
            0,
            0,
            $imgW,
            $imgH,
            $imgInitW,
            $imgInitH
        );

        $dest_image = imagecreatetruecolor($cropW, $cropH);
        $white = imagecolorallocate($dest_image, 255, 255, 255);
        imagefill($dest_image, 0, 0, $white);

        imagecopyresampled(
            $dest_image,
            $resizedImage,
            0,
            0,
            $imgX1,
            $imgY1,
            $cropW,
            $cropH,
            $cropW,
            $cropH
        );

        // limit final dimensions to max 462x462 without upscaling (preserve aspect ratio)
        $maxDim = 462;
        $final_image = $dest_image;


        if ($cropW > $maxDim || $cropH > $maxDim) {
            $scale = min($maxDim / $cropW, $maxDim / $cropH);
            $targetW = (int) round($cropW * $scale);
            $targetH = (int) round($cropH * $scale);
        
            $final_image = imagecreatetruecolor($targetW, $targetH);
            $white = imagecolorallocate($final_image, 255, 255, 255);
            imagefill($final_image, 0, 0, $white);
        
            imagecopyresampled(
                $final_image,
                $dest_image,
                0, 0, 0, 0,
                $targetW, $targetH,
                $cropW, $cropH
            );
        }

        /*switch ($type) {
            case '.png': imagepng($final_image, $output_filename . $type); break;
            case '.gif': imagegif($final_image, $output_filename . $type); break;
            default:     imagejpeg($final_image, $output_filename . $type, 90); break;
        }*/
        $output_filename = "storage/pics/cropped_" . uniqid() . ".jpg";
        imagejpeg($final_image, $output_filename, 90);

        // Clean memory
        imagedestroy($source_image);
        imagedestroy($resizedImage);
        imagedestroy($dest_image);
        if ($final_image !== $dest_image) imagedestroy($final_image);

        echo json_encode([
            "status" => "success",
            "url" => APP_URL . '/' . $output_filename
        ]);
        exit;
    break;

    default:
        echo 'action not defined';
}
