<?php
/**
 * @param string $l
 * @return bool|string
 */

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

use SendGrid\Mail\Mail;

use ElephantIO\Client;
use ElephantIO\Engine\SocketIO\Version4X;

function _raid($l = '6')
{
    return substr(str_shuffle(str_repeat('0123456789', $l)), 0, $l);
}

function sp_random_number($length = 6)
{
    return substr(str_shuffle(str_repeat('0123456789', $length)), 0, $length);
}

function current_number_would_be($string)
{
    $next_code = preg_replace("/[^0-9]/", '', $string);
    $next_code = $next_code == '' ? 0 : (int) $next_code;

    return $next_code + 1;
}

/**
 * @param $option
 * @param $value
 * @return bool
 */
function update_option($option, $value)
{
    $config_exist = AppConfig::where('setting', $option)->first();

    if ($config_exist) {
        $config_exist->value = $value;
        $config_exist->save();
    } else {
        $config_create = new AppConfig();
        $config_create->setting = $option;
        $config_create->value = $value;
        $config_create->save();
    }
    return true;
}

function remove_option($option)
{
    $config_exist = AppConfig::where('setting', $option)->first();

    if ($config_exist) {
        $config_exist->delete();
    }
    return true;
}

function sp_recursive_delete_contents($directory, $with_the_directory = false)
{
    $files = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator(
            $directory,
            RecursiveDirectoryIterator::SKIP_DOTS
        ),
        RecursiveIteratorIterator::CHILD_FIRST
    );

    foreach ($files as $fileinfo) {
        $todo = $fileinfo->isDir() ? 'rmdir' : 'unlink';
        $todo($fileinfo->getRealPath());
    }

    if ($with_the_directory) {
        rmdir($directory);
    }
}

function sp_recursive_copy($source_directory, $destination_directory)
{
    $dir = opendir($source_directory);

    if (!file_exists($destination_directory) && (!mkdir($destination_directory) && !is_dir($destination_directory))) {
        throw new \RuntimeException(
            sprintf(
                'Directory "%s" was not created',
                $destination_directory
            )
        );
    }

    while (false !== ($file = readdir($dir))) {
        if ($file !== '.' && $file !== '..') {
            if (is_dir($source_directory . '/' . $file)) {
                sp_recursive_copy(
                    $source_directory . '/' . $file,
                    $destination_directory . '/' . $file
                );
            } else {
                copy(
                    $source_directory . '/' . $file,
                    $destination_directory . '/' . $file
                );
            }
        }
    }
    closedir($dir);
}

function sp_create_directory($directory)
{
    if (!file_exists($directory) && (!mkdir($concurrentDirectory = $directory) &&
    !is_dir($concurrentDirectory))) {
        throw new \RuntimeException(
            sprintf('Directory "%s" was not created', $concurrentDirectory)
        );
    }
}

function sp_create_index_file_to_prevent_directory_listing($destination)
{
    file_put_contents(
        $destination . '/index.html',
        '<html>
<head>
    <title>403 Forbidden</title>
</head>
<body>
<p>Directory access is forbidden.</p>
</body>
</html>
'
    );
}

function sp_if_the_value_is_bollean($data, $param)
{
    if (!empty($data[$param])) {
        return 1;
    }
    return 0;
}

function sp_clean_and_create_line_json($values)
{
    $result = [];
    foreach ($values as $line) {
        $line = trim($line);
        if ($line !== '' && $line !== '0') {
            $result[] = $line;
        }
    }

    return json_encode($result);
}

function replace_in_file($file_path, $old_string, $new_string): array
{
    $result = [
        'success' => false,
        'message' => '',
    ];
    if (file_exists($file_path)) {
        if (is_writable($file_path)) {
            try {
                $file_content = file_get_contents($file_path);
                $file_content = str_replace(
                    $old_string,
                    $new_string,
                    $file_content,
                    $count
                );
                if ($count === 0) {
                    $result['message'] = 'The string is not found';
                } elseif (file_put_contents($file_path, $file_content) > 0) {
                    $result['success'] = true;
                } else {
                    $result['message'] = 'Error while writing file';
                }
            } catch (Exception $e) {
                $result['message'] = 'Error : ' . $e->getMessage();
            }
        } else {
            $result['message'] = 'File ' . $file_path . ' is not writable !';
        }
    } else {
        $result['message'] = 'File ' . $file_path . ' does not exist !';
    }
    return $result;
}

/**
 * @param $number
 * @return bool
 */
function numberIsNegative($number)
{
    return $number < 0;
}

/**
 * @param $amount
 * @param $currency_iso_code
 * @return string
 */
function formatCurrency($amount, $currency_iso_code = false, $override = [])
{
    $negative = numberIsNegative($amount);
    $currency = Currency::getAllCurrencies();

    global $config;

    if (!$currency_iso_code) {
        $currency_iso_code = $config['home_currency'];
    }

    if (isset($currency[$currency_iso_code])) {
        $selected_currency = $currency[$currency_iso_code];

        $precision = $selected_currency['precision'];

        if ($config['currency_decimal_digits'] == 'false') {
            $precision = 0;
        }

        if (isset($override['precision'])) {
            $precision = $override['precision'];
        }

        $amount = (float) $amount;



        $value = number_format(
            $amount,
            $precision,
            $selected_currency['decimal_mark'],
            $selected_currency['thousands_separator']
        );

        if (!$selected_currency['symbol_first']) {
            $prefix = '';
            $suffix = $selected_currency['symbol'];
        } else {
            $prefix = $selected_currency['symbol'];
            $suffix = '';
        }

        if (isset($override['prefix'])) {
            $prefix = $override['prefix'];
        }

        if (isset($override['suffix'])) {
            $prefix = $override['suffix'];
        }

        return ($negative ? '-' : '') . $prefix . $value . $suffix;
    }

    return $amount;
}

function formatCurrencyNonGlobalConfig(
    $config,
    $amount,
    $currency_iso_code = false,
    $override = []
) {
    $negative = numberIsNegative($amount);
    $currency = Currency::getAllCurrencies();

    if (!$currency_iso_code) {
        $currency_iso_code = $config['home_currency'];
    }

    if (isset($currency[$currency_iso_code])) {
        $selected_currency = $currency[$currency_iso_code];

        $precision = $selected_currency['precision'];

        if ($config['currency_decimal_digits'] == 'false') {
            $precision = 0;
        }

        if (isset($override['precision'])) {
            $precision = $override['precision'];
        }

        $value = number_format(
            $amount,
            $precision,
            $selected_currency['decimal_mark'],
            $selected_currency['thousands_separator']
        );

        if (!$selected_currency['symbol_first']) {
            $prefix = '';
            $suffix = $selected_currency['symbol'];
        } else {
            $prefix = $selected_currency['symbol'];
            $suffix = '';
        }

        if (isset($override['prefix'])) {
            $prefix = $override['prefix'];
        }

        if (isset($override['suffix'])) {
            $prefix = $override['suffix'];
        }

        return ($negative ? '-' : '') . $prefix . $value . $suffix;
    }

    return $amount;
}

function sp_random_strings($length_of_string)
{
    // String of all alphanumeric character
    $str_result = '123456789ABCDEFGHKMNPQRSTUVWXYZabcdefghkmnpqrstuvwxyz';

    // Shufle the $str_result and returns substring
    // of specified length
    return substr(str_shuffle($str_result), 0, $length_of_string);
}

function sp_string_remove_all_between($beginning, $end, $string)
{
    $beginningPos = strpos($string, $beginning);
    $endPos = strpos($string, $end);
    if ($beginningPos === false || $endPos === false) {
        return $string;
    }

    $textToDelete = substr(
        $string,
        $beginningPos,
        $endPos + strlen($end) - $beginningPos
    );

    return sp_string_remove_all_between(
        $beginning,
        $end,
        str_replace($textToDelete, '', $string)
    ); // recursion to ensure all occurrences are replaced
}

function create_tracking_id()
{
    $tracking_id = strtoupper(sp_random_strings(10));
    return substr($tracking_id, 0, 4) . '-' . substr($tracking_id, 4);
}

/**
 * @param $name
 * @param $type
 * @return string
 */
function categoryCalculateTotalByName($name, $type)
{
    $t = Transaction::where('type', $type)
        ->where('category', $name)
        ->sum('amount');

    if ($t == '' || $t == '0') {
        return '0.00';
    }

    return $t;
}

/**
 * @param array $data
 * @param int $code
 */
function jsonResponse($data = [], $code = 200)
{
    http_response_code($code);
    header('Content-type: application/json');
    echo json_encode($data);
    exit();
}

function sp_display_in_the_console($message)
{
    $message = date("H:i:s") . " - $message" . PHP_EOL;
    print $message;
    flush();
}

function sp_get_string_between($string, $start, $end)
{
    $string = ' ' . $string;
    $ini = strpos($string, $start);
    if ($ini == 0) {
        return '';
    }
    $ini += strlen($start);
    $len = strpos($string, $end, $ini) - $ini;
    return substr($string, $ini, $len);
}

function sp_get_last_n_days($days, $format = 'Y-m-d')
{
    $m = date("m");
    $de = date("d");
    $y = date("Y");
    $dateArray = [];
    for ($i = 0; $i <= $days - 1; $i++) {
        $dateArray[] = date($format, mktime(0, 0, 0, $m, $de - $i, $y));
    }
    return array_reverse($dateArray);
}

function sp_uuid()
{
    $data = random_bytes(16);
    assert(strlen($data) == 16);
    $data[6] = chr((ord($data[6]) & 0x0f) | 0x40); // set version to 0100
    $data[8] = chr((ord($data[8]) & 0x3f) | 0x80); // set bits 6-7 to 10
    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
}

/**
 * @param $option
 * @return bool
 */
function delete_option($option)
{
    $config_exist = AppConfig::where('setting', $option)->first();

    if ($config_exist) {
        $config_exist->delete();
        return true;
    }

    return false;
}

/**
 * @param array $data
 */
function api_response($data = [], $code = 200)
{
    http_response_code($code);
    header('Content-type: application/json');
    echo json_encode($data);
    exit();
}

function __($string)
{
    global $_L;
    if (!empty($_L[$string])) {
        return $_L[$string];
    }
    return $string;
}

function getContactFormattedAddress($config, $contact, $html = true)
{
    $address_format = isset($config['address_format']) ? $config['address_format'] : 'default';

    $address = $contact->address;
    $city = $contact->city;
    $state = $contact->state;
    $zip = $contact->zip;
    $country = $contact->country;

    $new_line = $html ? ' <br>' : PHP_EOL;

    switch ($address_format) {
        case 'eu':
            $address_full =
                $address .
                $new_line .
                $zip .
                ' ' .
                $city .
                $new_line .
                $state .
                $new_line .
                $country;

            break;

        case 'default':
        default:
            $address_full =
                $address .
                $new_line .
                $city .
                $new_line .
                $state .
                ' ' .
                $zip .
                $new_line .
                $country;

            break;
    }

    return $address_full;
}

/**
 * @param $line
 * @param string $fallback
 * @return mixed|string
 */
function ib_lan_get_line($line, $fallback = '')
{
    global $_L;
    if (isset($_L[$line])) {
        return str_replace($line, $_L[$line], $line);
    } elseif ($fallback != '') {
        return $fallback;
    } else {
        return $line;
    }
}

/**
 * @param $number
 * @param $currency_iso_code
 * @param bool $precision
 * @return string
 */
function numberFormatUsingCurrency(
    $number,
    $currency_iso_code,
    $precision = false
) {
    if ($currency_iso_code == 'USD') {
        return $number;
    }

    $currency = Currency::getAllCurrencies();

    if (isset($currency[$currency_iso_code])) {
        $selected_currency = $currency[$currency_iso_code];

        if (!$precision) {
            $precision = $selected_currency['precision'];
        }

        $number = number_format(
            $number,
            $precision,
            $selected_currency['decimal_mark'],
            $selected_currency['thousands_separator']
        );
    }

    return $number;
}

function sp_transform_string_template($string)
{
    try {
        $smarty = new Smarty();
        $smarty->setCompileDir('storage/compiled/');
        return $smarty->fetch('string:' . $string);
    } catch (\Exception $e) {
        return $string;
    }
}

function predict_next_serial($config, $type)
{
    switch ($type) {
        case 'customer':
            return $config['customer_code_prefix'] .
                str_pad(
                    $config['customer_code_current_number'],
                    $config['number_pad'],
                    '0',
                    STR_PAD_LEFT
                );

            break;

        case 'company':
            return $config['company_code_prefix'] .
                str_pad(
                    $config['company_code_current_number'],
                    $config['number_pad'],
                    '0',
                    STR_PAD_LEFT
                );

            break;

        case 'income':
            return $config['income_code_prefix'] .
                str_pad(
                    $config['income_code_current_number'],
                    $config['number_pad'],
                    '0',
                    STR_PAD_LEFT
                );

            break;

        case 'expense':
            return $config['expense_code_prefix'] .
                str_pad(
                    $config['expense_code_current_number'],
                    $config['number_pad'],
                    '0',
                    STR_PAD_LEFT
                );

            break;

        case 'invoice':
            return sp_transform_string_template(
                $config['invoice_code_prefix']
            ) .
                str_pad(
                    $config['invoice_code_current_number'],
                    $config['number_pad'],
                    '0',
                    STR_PAD_LEFT
                );

            break;

        case 'purchase':
            return $config['purchase_code_prefix'] .
                str_pad(
                    $config['purchase_code_current_number'],
                    $config['number_pad'],
                    '0',
                    STR_PAD_LEFT
                );

            break;

        case 'quote':
            return $config['quotation_code_prefix'] .
                str_pad(
                    $config['quotation_code_current_number'],
                    $config['number_pad'],
                    '0',
                    STR_PAD_LEFT
                );

            break;

        case 'supplier':
            return $config['supplier_code_prefix'] .
                str_pad(
                    $config['supplier_code_current_number'],
                    $config['number_pad'],
                    '0',
                    STR_PAD_LEFT
                );

            break;

        case 'credit-note':
            return ($config['credit_note_code_prefix'] ?? __('CN-')) .
                str_pad(
                    ($config['credit_note_code_current_number'] ?? 1),
                    $config['number_pad'],
                    '0',
                    STR_PAD_LEFT
                );

            break;

    }
}

function sp_config_or_default($key, $default_value = '')
{
    global $config;
    if (!empty($config[$key])) {
        return $config[$key];
    }

    return $default_value;
}

function format_number_using_currency_code($number, $currency_code)
{
    $currency = Currency::getAllCurrencies();

    if (isset($currency[$currency_code])) {
        $selected_currency = $currency[$currency_code];

        $number = number_format(
            $number,
            $selected_currency['precision'],
            $selected_currency['decimal_mark'],
            $selected_currency['thousands_separator']
        );
    }

    return $number;
}

function generate_random_password($char = 8)
{
    $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890@#*';
    $pass = [];
    $alphaLength = strlen($alphabet) - 1;
    for ($i = 0; $i < $char; $i++) {
        $n = rand(0, $alphaLength);
        $pass[] = $alphabet[$n];
    }

    return implode($pass);
}

/**
 * @param $setting
 * @param $value
 * @param bool $create
 *
 * @return bool
 */
function updateOption($setting, $value, $create = false)
{
    $check = AppConfig::where('setting', $setting)->first();

    if ($check) {
        if (is_null($value)) {
            $check->delete();
        }

        $check->setting = $setting;
        $check->value = $value;
        $check->save();
        return true;
    }

    if ($create) {
        if (is_null($value)) {
            return false;
        }
        // create option
        $create = new AppConfig();
        $create->setting = $setting;
        $create->value = $value;
        $create->save();
        return true;
    }

    return false;
}

function removeOption($key)
{
    $option = AppConfig::where('setting', $key)->first();
    if ($option) {
        $option->delete();
    }
}

function get_discount_amount($discount_amount, $type, $total_amount)
{
    if ($type == 'percentage' || $type == 'p') {
        return ($discount_amount / 100) * $total_amount;
    }

    return $discount_amount;
}


function createHtmlFilev1($filename) {
    // Abre el archivo para escritura. Si no existe, lo crea.
    $file = fopen($filename, 'w');
    
    // Verifica si el archivo se abrió correctamente
    if ($file === false) {
        return "Error al abrir el archivo.";
    }

    $content = '
    <html>
    <head>
        <title>403 Forbidden</title>
    </head>
    <body>
    <p>Directory access is forbidden.</p>
    </body>
    </html>
    ';

    // Escribe el contenido en el archivo
    fwrite($file, $content);

    // Cierra el archivo
    fclose($file);
}


function getRealIP(){

        if (isset($_SERVER["HTTP_CLIENT_IP"])){

            return $_SERVER["HTTP_CLIENT_IP"];

        }elseif (isset($_SERVER["HTTP_X_FORWARDED_FOR"])){

            return $_SERVER["HTTP_X_FORWARDED_FOR"];

        }elseif (isset($_SERVER["HTTP_X_FORWARDED"])){

            return $_SERVER["HTTP_X_FORWARDED"];

        }elseif (isset($_SERVER["HTTP_FORWARDED_FOR"])){

            return $_SERVER["HTTP_FORWARDED_FOR"];

        }elseif (isset($_SERVER["HTTP_FORWARDED"])){

            return $_SERVER["HTTP_FORWARDED"];

        }else{

            return $_SERVER["REMOTE_ADDR"];

        }
    } 

    function  matchesPattern($ipStr, $patternStr) {
        $ipParts = explode('.', $ipStr);
        $patternParts = explode('.', $patternStr);
        
        if (count($ipParts) !== 4 || count($patternParts) !== 4) {
            return false;
        }
        
        for ($i = 0; $i < 4; $i++) {
            if ($patternParts[$i] !== '*') {
                if ($patternParts[$i] !== $ipParts[$i]) {
                    return false;
                }
            }
        }
        return true;
    }

    function isIpAllowed($ip, $allowedIps) {
 

        foreach ($allowedIps as $item) {
            if (isset($item['ip']) && matchesPattern($ip, $item['ip'])) {
                return true;
            }
        }
        return false;
    }

    function checkIpAccess($ip, $denyIps) {
        foreach ($denyIps as $item) {
            if (isset($item['ip']) && matchesPattern($ip, $item['ip'])) {
                //return 'Access Denied';
                return true;
            }
        }
        return false;
        //return 'Access Granted';
    }

    function createPaymentIntents($data)
    {
        $stripeSecretKey = $data["sk_stripe"];

        // Variables que puedes setear dinámicamente
        $amount   = $data["amount"];
        $currency = $data["currency"];
        $invoice  = $data["invoice"];
        $customer = $data["customer"];

        $ch = curl_init();

        curl_setopt_array($ch, [
            CURLOPT_URL => "https://api.stripe.com/v1/payment_intents",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_USERPWD => $stripeSecretKey . ":",
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => http_build_query([
                "amount" => $amount,
                "currency" => $currency,
                "payment_method_types[]" => "card_present",
                "metadata[invoice_number]" => $invoice,
                "metadata[customer]" => $customer
            ])
        ]);

        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);

        if ($err) {
            echo json_encode([
                "status" => false,
                "message" => $err
            ]);
            exit;
        }

        $data = json_decode($response, true);

        if (isset($data["error"])) {
            echo json_encode([
                "status" => false,
                "message" => $data["error"]["message"]
            ]);
        } else {
            echo json_encode([
                "status" => true,
                "id" => $data["id"]
            ]);
        }
    }


function enviarCorreoElectronicoV2($mysqli, $data_gip, $resultados = [])
{
    $DB_NAME = DB_NAME;

    $monto_pagado = $data_gip["monto_pagado"];

    $sql = "SELECT * FROM $DB_NAME.`template_credit_line` WHERE tipo_pago = 'pago_prestamos_rechazado'";
                
    $data_template_credit_line = $mysqli->query($sql)->fetch_assoc();

    $subjeto_email_credito = "Payment of installments rejected";
    $mensaje_plantilla_credito = "Your fee payment has been rejected. For more information, please contact the administrative team. You will receive a response shortly. Thank you very much.";

    if(empty($data_template_credit_line) == false)
    {
        $template_original = $data_template_credit_line["template_original"];
        
        //echo $template_original; exit;
        $otra_informacion_plantilla = json_decode($template_original, true);

        $subjeto_email_credito = $otra_informacion_plantilla["subject"];
        $mensaje_plantilla_credito = $data_template_credit_line["template_modificado"];
        
        //echo $mensaje_plantilla_credito; exit;
        //echo $otra_informacion_plantilla["subject"]; exit;
    }

    /* echo json_encode($data_template_credit_line); exit;
    echo "aqui ahi un return";
    exit; */

    /* $sql = "SELECT `value` FROM `sys_appconfig` WHERE setting = 'logo_default' LIMIT 1";
 
    $logo = $mysqli->query($sql)->fetch_assoc();

    //echo json_encode($logo); exit;

    //$ruta_img = APP_URL . " /storage/system/" . $logo['value'];

    $ruta_root = $_SERVER['DOCUMENT_ROOT'];   

    // Verificar si la ruta tiene una barra al final
    if (substr($ruta_root, -1) === '/') {
        // Si hay una barra al final, eliminarla
        $ruta_root = rtrim($ruta_root, '/');
    }

    //$ruta_img = $ruta_root . "/app_dev_partners/storage/system/"  . $logo['value'];

    $ruta_img = $ruta_root . "/storage/system/"  . $logo['value'];

    //$url_firma_secretaria_base =  $ruta_root . "/assets/imagenes/firma/2025-02-12-10-41-54_869038.png";
    $imageData = file_get_contents($ruta_img);
    $base64Image = base64_encode($imageData);

    if(empty($base64Image) == true)
    {
        $base64Image = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAIAAAC0D9CtAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYSURBVDhPY/hPOhjVM6oHBEb1kKPn/38Ab+Nfy74Zl7wAAAAASUVORK5CYII=";
    } */

 

    $sql = "SELECT habilitar_modulo_correo_electronico FROM $DB_NAME.`modulo_disponible` AS ppp LIMIT 1 ";
        
    $data_modulo_correo_electronico_disponible = $mysqli->query($sql)->fetch_assoc();

    if(empty($data_modulo_correo_electronico_disponible) == false)
    {
        if($data_modulo_correo_electronico_disponible["habilitar_modulo_correo_electronico"] == 1)
        {
            $sql = "SELECT * FROM $DB_NAME.`modulo_envio_correos_parnerts` AS ppp LIMIT 1 ";
        
            $data_correo_electronico = $mysqli->query($sql)->fetch_assoc();

            //echo json_encode($data_correo_electronico); exit;

            if(empty($data_correo_electronico) == false)
            {
                $proveedor = $data_correo_electronico["proveedor"];

                if($proveedor == "twilio")
                {


                    $texto_plantilla_finalizada = mensajeCorreoElectronicoPlantillav1($data_gip, $resultados, $base64Image, $data_gip["numero_credito"], $monto_pagado, $mensaje_plantilla_credito);

                    $configuracion = [
                        "config_email_email"         => $data_correo_electronico["correo_electronico"],
                        "config_email_nombre"        => $data_correo_electronico["nombre_twilio"],
                        "subject"                    => $subjeto_email_credito,
                        "email_user_crm_accounts"    => $data_gip["email"],
                        "account_user_crm_accounts"  => $data_gip["account"],
                        "texto_plantilla_finalizada" => $texto_plantilla_finalizada,
                        "config_email_token"         => $data_correo_electronico["token_twilio"],
                    ];

                    //echo json_encode($configuracion); exit;
                    
                    enviar_mensaje_sendgridv1($configuracion);

                    //echo json_encode($configuracion); exit;
                          
                }

                if($proveedor == "phpmailer")
                {

                    $texto_plantilla_finalizada = mensajeCorreoElectronicoPlantillav1($data_gip, $resultados, $base64Image, $data_gip["numero_credito"], $monto_pagado, $mensaje_plantilla_credito);
 
                    $configuracion = [
                        "host"                       => $data_correo_electronico["host_phpmailer"],
                        "username"                   => $data_correo_electronico["correo_electronico"],
                        "password"                   => $data_correo_electronico["password_phpmailer"],
                        "port"                       => $data_correo_electronico["puerto_phpmailer"],
                        "send_copy"                  => $data_correo_electronico["copia_correo_electronico_phpmailer"],
                        
                        "html"                       => $texto_plantilla_finalizada,

                        "Subject"                    => $subjeto_email_credito,

                        "correo_electronico"         => $data_gip["email"],
                        "nombre_empresa_persona"     => $data_gip["account"],
                    ];

                    //echo json_encode($configuracion); exit;

                    mensajeCorreoPhpMailerv1($configuracion);

                    //echo json_encode($configuracion); exit;
                }

            }
 
        }
 
    }
}

function mensajeCorreoElectronicoPlantillav1($data_gip, $url = [], $url_img = "", $no_credito = "", $monto_pagado = "", $mensaje_plantilla_credito = "")
{

    $email = $data_gip["email"];
    $account = $data_gip["account"];

    // Format $monto_pagado
    $monto_pagado = is_numeric($monto_pagado) ? number_format($monto_pagado, 2, '.', ',') : $monto_pagado;

    /* // Handle Base64 image
    $url_img = !empty($url_img) ? htmlspecialchars($url_img, ENT_QUOTES, 'UTF-8') : 'https://xhde365.com/app/logo_hde.png';
    // If $url_img is a Base64 string (not a URL), add the data URI prefix
    if (!filter_var($url_img, FILTER_VALIDATE_URL) && !empty($url_img)) {
        // Assume PNG format
        $url_img = 'data:image/png;base64,' . $url_img;
    } */

    $url_img = 'data:image/png;base64,' . $url_img;

    // Generate links for each URL in the array
    $links_html = '';
    /* if (!empty($url) && is_array($url)) {
        foreach ($url as $item) {
            $url_item = !empty($item['url_codigo_qr']) ? htmlspecialchars($item['url_codigo_qr'], ENT_QUOTES, 'UTF-8') : '#';
            $link_text = !empty($item['cuotas_cantidad']) ? htmlspecialchars($item['cuotas_cantidad'], ENT_QUOTES, 'UTF-8') : 'No link available';
            $links_html .= "<p><a href=\"$url_item\" target=\"_blank\">Download quota $link_text</a></p>";
        }
    } else {
        $links_html = '<p><a href="#" target="_blank">No link available</a></p>';
    } */

    $nuevo_mensaje = "";

    if(empty($mensaje_plantilla_credito) == false)
    {
        $nuevo_mensaje = $mensaje_plantilla_credito . " <br>";
    }

    return <<<HTML
    <!DOCTYPE html>
        <html lang="es">
        <head>
            <meta charset="UTF-8" />
            <title>Payment of Fee</title>
            <meta name="viewport" content="width=device-width, initial-scale=1.0" />
            <style>
                body {
                    margin: 0;
                    font-family: Arial, sans-serif;
                    background: #f5f5f5;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    height: 100vh;
                }

                .card {
                    background: white;
                    padding: 40px;
                    border-radius: 12px;
                    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
                    text-align: center;
                    width: 50%;
                    
                }

                .card img {
                    max-width: 120px;
                    margin-bottom: 20px;
                }

                .card h2 {
                    font-size: 20px;
                    color: #333;
                    margin-bottom: 15px;
                }

                .card a {
                    color: #007bff;
                    text-decoration: none;
                    font-weight: bold;
                }

                .card a:hover {
                    text-decoration: underline;
                }

                .contenedor {
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                    margin-bottom: 10px;
                }

                .titulo_general {
                    font-weight: bold;
                }

                .titulo {
                    font-weight: bold;
                    text-align: left;
                }

                .texto {
                    font-weight: normal;
                    text-align: right;
                }
            </style>
        </head>
        <body>
            <div class="card">
                <img src="$url_img" alt="" />
               

                $nuevo_mensaje

                <p class="titulo_general">General information about the fee</p>

                <div class="contenedor">
                    <div class="titulo">Credit Number</div>
                    <div class="texto">$no_credito</div>
                </div>

                <div class="contenedor">
                    <div class="titulo">Amount paid</div>
                    <div class="texto">$ $monto_pagado</div>
                </div>

                <div class="contenedor">
                    <div class="titulo">Name</div>
                    <div class="texto">$account</div>
                </div>

                <div class="contenedor">
                    <div class="titulo">Email</div>
                    <div class="texto">$email</div>
                </div>
 

                $links_html
                <p>Thank you for your payment.</p>
            </div>
        </body>
        </html>
    HTML;
}

function mensajeCorreoElectronicoPlantillaBasica($mensaje_plantilla = "" )
{

  
    return <<<HTML
    <!DOCTYPE html>
        <html lang="es">
        <head>
            <meta charset="UTF-8" />
            <title>Payment of Fee</title>
            <meta name="viewport" content="width=device-width, initial-scale=1.0" />
            <style>
                body {
                    margin: 0;
                    font-family: Arial, sans-serif;
                    background: #f5f5f5;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    height: 100vh;
                }

                .card {
                    background: white;
                    padding: 40px;
                    border-radius: 12px;
                    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
                    text-align: center;
                    width: 50%;
                    
                }

                .card img {
                    max-width: 120px;
                    margin-bottom: 20px;
                }

                .card h2 {
                    font-size: 20px;
                    color: #333;
                    margin-bottom: 15px;
                }

                .card a {
                    color: #007bff;
                    text-decoration: none;
                    font-weight: bold;
                }

                .card a:hover {
                    text-decoration: underline;
                }

                .contenedor {
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                    margin-bottom: 10px;
                }

                .titulo_general {
                    font-weight: bold;
                }

                .titulo {
                    font-weight: bold;
                    text-align: left;
                }

                .texto {
                    font-weight: normal;
                    text-align: right;
                }
            </style>
        </head>
        <body>
            <div class="card">
                
                $mensaje_plantilla
               
            </div>
        </body>
        </html>
    HTML;
}


function enviar_mensaje_sendgridv1($configuracion)
{

    //echo json_encode($configuracion); exit;

    $config_email_email         = $configuracion["config_email_email"]; 
    $config_email_nombre        = $configuracion["config_email_nombre"];
    $subject                    = $configuracion["subject"];
    $email_user_crm_accounts    = $configuracion["email_user_crm_accounts"];
    $account_user_crm_accounts  = $configuracion["account_user_crm_accounts"];
    $texto_plantilla_finalizada = $configuracion["texto_plantilla_finalizada"];
    $config_email_token         = $configuracion["config_email_token"];

    try {
        $email = new Mail();
        $email->setFrom($config_email_email, $config_email_nombre);
        $email->setSubject($subject);
        $email->addTo($email_user_crm_accounts, $account_user_crm_accounts); // correo de la persona a quien le caerá el mensaje
        $email->addContent('text/html', $texto_plantilla_finalizada);
        $sendgrid = new \SendGrid($config_email_token); // el key
        $response = $sendgrid->send($email);

        // Check the response status code
        if ($response->statusCode() == 202) {
            // Email was accepted by SendGrid for delivery
            return true; // Or log success: echo "Email sent successfully!";
        } else {
            // Email was not accepted; log or handle the error
            $error_message = "Failed to send email. Status code: " . $response->statusCode() . 
                            ", Response body: " . $response->body();
            throw new Exception($error_message);
        }
    } catch (Exception $e) {
        // Handle any errors (e.g., network issues, invalid API key, etc.)
        echo("Email sending failed: " . $e->getMessage());
        //return false; // Or handle the error as needed
    }
}

function mensajeCorreoPhpMailerv1($configuracion_correo)
{
    $mail = new PHPMailer(true);

    $host                   = $configuracion_correo["host"];
    $username               = $configuracion_correo["username"];
    $password               = $configuracion_correo["password"];
    $port                   = $configuracion_correo["port"];
    $correo_electronico     = $configuracion_correo["correo_electronico"];
    $nombre_empresa_persona = $configuracion_correo["nombre_empresa_persona"];
    $send_copy              = $configuracion_correo["send_copy"];
    $Subject                = $configuracion_correo["Subject"];
    $html                   = $configuracion_correo["html"];

    try {
        // Configuración del servidor SMTP de Gmail
        $mail->isSMTP();
        $mail->Host       = $host;
        $mail->SMTPAuth   = true;
        $mail->Username   = $username; // Tu dirección de correo de Gmail
        $mail->Password   = $password;            // Tu contraseña de Gmail
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port       = $port;

        // Configuración de la codificación en UTF-8
        $mail->CharSet = 'UTF-8';
        $mail->Encoding = 'base64';

        // Remitente y destinatarios
        //$mail->setFrom($configuracion_correo->username, $configuracion_correo->username); 

        $mail->addAddress($correo_electronico, $nombre_empresa_persona); // Añadir un destinatario

        // Enviar copia (CC) o copia oculta (BCC)
        $mail->addCC($send_copy); // Cambia 'correo.copia@example.com' por la dirección de correo a la que quieres enviar una copia
        //$mail->addBCC('correo.oculto@example.com'); // Para una copia oculta (BCC), usa esta línea en lugar de addCC()

        //$mail->addAddress('pinedacesar253@gmail.com', 'Cesar Pineda'); // Añadir un destinatario
        //$mail->addAddress('cesar.pineda@itgrahn.com', 'cesar.pineda@itgrahn.com'); // Añadir un destinatario
        
        // Contenido del correo
        $mail->isHTML(true);
        $mail->Subject = $Subject;
        $mail->Body    = $html;
        $mail->AltBody = $html;

        $mail->send();
        //echo 'El mensaje ha sido enviado';

    } catch (Exception $e) {
        //echo "No se pudo enviar el mensaje. Error de PHPMailer: {$mail->ErrorInfo}";
        $error = json_encode(
          array(
            'mensaje'       => '' . $mail->ErrorInfo,
            'sql'           => "",
            'data'          => "",
            'auxiliar'  => '' 
          )
        );
        echo json_encode($error); exit;
    }
}
 
function pagoCuentasBancarias($datos)
{
    $SECRET_KEY_ADMIN = $datos["sk_stripe"];
    $tot              = $datos["amount"];
    $payment_method   = $datos["payment_method"];
    $customer_id      = $datos["customer_id"];

    //en este punto existen dos:
    //credit_line que es para lineas de credito
    //invoices que es para invoices. esto me servira para condicionante en el apartado de webhook para stripe
    $type_payment     = $datos["type_payment"];

    try {

        $stripe = new \Stripe\StripeClient($SECRET_KEY_ADMIN);

        //echo $tot; exit;

        $tot = intval(floatval($tot) * 100);

        $paymentIntent = $stripe->paymentIntents->create([
            'amount' => $tot, // Monto en centavos (e.g., $10.00)
            'currency' => 'usd',
            'payment_method_types' => ['us_bank_account'],
            'payment_method' => $payment_method,
            'customer' => $customer_id,
            'confirmation_method' => 'manual',
            'confirm' => true, // Confirmar inmediatamente
            //desde aqui es codigo nuevo
            'payment_method_options' => [
                'us_bank_account' => [
                    'verification_method' => 'instant'  // ¡ACTIVA EL DÉBITO RÁPIDO!
                ]
            ],
            //hasta aqui es otro codigo nuevo
            'mandate_data' => [
                'customer_acceptance' => [
                    'type' => 'online',
                    'online' => [
                        'ip_address' => $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1',
                        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'php-client',
                    ],
                ],
            ],
            'metadata' => [
                'type_payment' => $type_payment, // ID del pedido en tu sistema
            ],
        ]);


        /* $fileContent = "Fecha: {$timestamp}\n";
        $fileContent .= "Es JSON válido: " . ($isJson ? "Sí" : "No") . "\n";
        $fileContent .= "Datos: " . json_encode($paymentIntent) . "\n";
        
        $filename = "post_stripe.txt";
        file_put_contents($filename, $fileContent); */

        //echo json_encode($paymentIntent); exit;
 
        $salida = [
            "status"                => true,
            "id_stripe"             => $paymentIntent->id,
            "payment_method_stripe" => $paymentIntent->payment_method,
            "mensaje"               => "",
        ];

        return $salida;
 
    } catch (\Stripe\Exception\ApiErrorException $e) {
        // Captura errores de Stripe
        //echo "Error de Stripe: " . $e->getMessage() . PHP_EOL;
        //break;

        $salida = [
            "status"                => false,
            "id_stripe"             => "",
            "payment_method_stripe" => "",
            "mensaje"               => $e->getMessage(),
        ];

        return $salida;
       
    } catch (Exception $e) {
        // Captura errores generales
        //echo "Error general: " . $e->getMessage() . PHP_EOL;
        //break;
       
        $salida = [
            "status"                => false,
            "id_stripe"             => "",
            "payment_method_stripe" => "",
            "mensaje"               => $e->getMessage(),
        ];

        return $salida;

    }
}

function generateUUIDv4_especialv1() {
    $pattern = 'xxxxxxx-xxxxxx-4xxxxx-yxxxx-xxxxxxxxxxxx-xxxxxx-xxxx-xxxxxx-xxxxxx-xxxxxx-xxxxxx-xxxxxx-xxxxxx-xxxx-xxxxxx-xx-xxxxxx-xxxx-xxxx-xxxxxxxxx-xxx';
    $chars = str_split($pattern);
    
    foreach ($chars as &$char) {
        if ($char === 'x' || $char === 'y') {
            $r = mt_rand(0, 15); // Genera un número aleatorio entre 0 y 15
            $v = $char === 'x' ? $r : ($r & 0x3 | 0x8); // Aplica la lógica para 'x' o 'y'
            $char = dechex($v); // Convierte a hexadecimal
        }
    }
    
    return implode('', $chars);
}

function generateUUIDv4New() {
    // Generar un prefijo único basado en microsegundos
    $time_low = uniqid();
    
    // Generar 8 bytes aleatorios para completar el UUID
    $extra_bytes = bin2hex(random_bytes(8));
    
    // Unir las partes y crear el UUID v4
    $uuid = sprintf(
        '%08s-%04s-4%03s-%04x-%012s',
        // 32 bits para "time_low"
        substr($time_low, 0, 8),
        // 16 bits para "time_mid"
        substr($time_low, 8, 4),
        // 16 bits para "time_hi_and_version"
        substr($extra_bytes, 0, 3),
        // 16 bits para "clk_seq_hi_res"
        hexdec(substr($extra_bytes, 3, 4)) & 0x3fff | 0x8000,
        // 48 bits para "node"
        substr($extra_bytes, 7, 12)
    );
    
    return $uuid;
}

function uuidToBase64UrlRFC7515New($uuid) {
    // Eliminar los guiones del UUID
    $uuid = str_replace('-', '', $uuid);
    
    // Convertir el UUID de hexadecimal a binario
    $binaryUuid = hex2bin($uuid);
    
    // Convertir el binario a Base64
    $base64 = base64_encode($binaryUuid);
    
    // Convertir Base64 a formato URL-safe (RFC 7515)
    $base64Url = str_replace(['+', '/', '='], ['-', '_', ''], $base64);
    
    return $base64Url;
}

function enviarCorreoElectronicoLogin($datosCorreo)
{
      

    $DB_NAME = DB_NAME;

    $mysqli = null;

    try {
        $mysqli = new mysqli(DB_HOST,DB_USER,DB_PASSWORD,DB_CHAT_WS);
        $mysqli->set_charset("utf8");

        $sql = "SELECT * FROM $DB_NAME.`sys_appconfig` WHERE setting = 'correo_notificacion_ips_no_autorizadas'";
                
        $data_template_credit_line = $mysqli->query($sql)->fetch_assoc();

        $subjeto_email_credito = "Unauthorized login";
 
    
        $ip = $datosCorreo["correo"];

        $titulo_plantilla = "An email tried to enter from an IP: " . $datosCorreo["ip"];
        $mensaje_plantilla = "The email $ip attempted to enter from an unauthorized IP.";

        $correo_personal = null;

        if(empty($data_template_credit_line) == false)
        {   
            $correo_personal = $data_template_credit_line["value"];
            
            
            //echo $mensaje_plantilla_credito; exit;
            //echo $otra_informacion_plantilla["subject"]; exit;
        }

    

        /* echo json_encode($data_template_credit_line); exit;
        echo "aqui ahi un return";
        exit; */

        /* $sql = "SELECT `value` FROM `sys_appconfig` WHERE setting = 'logo_default' LIMIT 1";
    
        $logo = $mysqli->query($sql)->fetch_assoc();

        //echo json_encode($logo); exit;

        //$ruta_img = APP_URL . " /storage/system/" . $logo['value'];

        $ruta_root = $_SERVER['DOCUMENT_ROOT'];   

        // Verificar si la ruta tiene una barra al final
        if (substr($ruta_root, -1) === '/') {
            // Si hay una barra al final, eliminarla
            $ruta_root = rtrim($ruta_root, '/');
        }

        //$ruta_img = $ruta_root . "/app_dev_partners/storage/system/"  . $logo['value'];

        $ruta_img = $ruta_root . "/storage/system/"  . $logo['value'];

        //$url_firma_secretaria_base =  $ruta_root . "/assets/imagenes/firma/2025-02-12-10-41-54_869038.png";
        $imageData = file_get_contents($ruta_img);
        $base64Image = base64_encode($imageData);

        if(empty($base64Image) == true)
        {
            $base64Image = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAIAAAC0D9CtAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYSURBVDhPY/hPOhjVM6oHBEb1kKPn/38Ab+Nfy74Zl7wAAAAASUVORK5CYII=";
        } */

    
        $sql = "SELECT habilitar_modulo_correo_electronico FROM $DB_NAME.`modulo_disponible` AS ppp LIMIT 1 ";
            
        $data_modulo_correo_electronico_disponible = $mysqli->query($sql)->fetch_assoc();

        if(empty($data_modulo_correo_electronico_disponible) == false && !empty($correo_personal) )
        {
            if($data_modulo_correo_electronico_disponible["habilitar_modulo_correo_electronico"] == 1)
            {
                $sql = "SELECT * FROM $DB_NAME.`modulo_envio_correos_parnerts` AS ppp LIMIT 1 ";
            
                $data_correo_electronico = $mysqli->query($sql)->fetch_assoc();

                //echo json_encode($data_correo_electronico); exit;

                if(empty($data_correo_electronico) == false)
                {
                    $proveedor = $data_correo_electronico["proveedor"];

                    if($proveedor == "twilio")
                    {

                        $texto_plantilla_finalizada = mensajeCorreoElectronicoPlantillaLogin( $titulo_plantilla,  $mensaje_plantilla  );

                        $configuracion = [
                            "config_email_email"         => $data_correo_electronico["correo_electronico"],
                            "config_email_nombre"        => $data_correo_electronico["nombre_twilio"],
                            "subject"                    => $subjeto_email_credito,
                            "email_user_crm_accounts"    => $correo_personal,
                            "account_user_crm_accounts"  => "",
                            "texto_plantilla_finalizada" => $texto_plantilla_finalizada,
                            "config_email_token"         => $data_correo_electronico["token_twilio"],
                        ];

                        //echo json_encode($configuracion); exit;
                        
                        enviar_mensaje_sendgridv1($configuracion);

                        //echo json_encode($configuracion); exit;
                            
                    }

                    if($proveedor == "phpmailer")
                    {

                        $texto_plantilla_finalizada = mensajeCorreoElectronicoPlantillaLogin( $titulo_plantilla, $mensaje_plantilla );
    
                        $configuracion = [
                            "host"                       => $data_correo_electronico["host_phpmailer"],
                            "username"                   => $data_correo_electronico["correo_electronico"],
                            "password"                   => $data_correo_electronico["password_phpmailer"],
                            "port"                       => $data_correo_electronico["puerto_phpmailer"],
                            "send_copy"                  => $data_correo_electronico["copia_correo_electronico_phpmailer"],
                            
                            "html"                       => $texto_plantilla_finalizada,

                            "Subject"                    => $subjeto_email_credito,

                            "correo_electronico"         => $correo_personal,
                            "nombre_empresa_persona"     => "",
                        ];

                        //echo json_encode($configuracion); exit;

                        mensajeCorreoPhpMailerv1($configuracion);

                        //echo json_encode($configuracion); exit;
                    }

                }
    
            }
    
        }

        
    } catch (\Exception  $e) {
       //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
        //$response = array(
        //    "type" => "error",
        //    "message" => "Database connection failed",
        //    "detalle" => $e->getMessage()
        //);
        //$mysqli->close();
        //print_r(json_encode( $response)) ; exit;
    }

 
}


function mensajeCorreoElectronicoPlantillaLogin($titulo = "", $subtitulo = "")
{
 
 

    return <<<HTML
    <!DOCTYPE html>
        <html lang="es">
        <head>
            <meta charset="UTF-8" />
            <title>Email</title>
            <meta name="viewport" content="width=device-width, initial-scale=1.0" />
            <style>
                body {
                    margin: 0;
                    font-family: Arial, sans-serif;
                    background: #f5f5f5;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    height: 100vh;
                }

                .card {
                    background: white;
                    padding: 40px;
                    border-radius: 12px;
                    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
                    text-align: center;
                    width: 50%;
                    
                }

                .card img {
                    max-width: 120px;
                    margin-bottom: 20px;
                }

                .card h2 {
                    font-size: 20px;
                    color: #333;
                    margin-bottom: 15px;
                }

                .card a {
                    color: #007bff;
                    text-decoration: none;
                    font-weight: bold;
                }

                .card a:hover {
                    text-decoration: underline;
                }

                .contenedor {
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                    margin-bottom: 10px;
                }

                .titulo_general {
                    font-weight: bold;
                }

                .titulo {
                    font-weight: bold;
                    text-align: left;
                }

                .texto {
                    font-weight: normal;
                    text-align: right;
                }
            </style>
        </head>
        <body>
            <div class="card">
                 
               
                <h3>$titulo</h3>

                <p class="titulo_general">$subtitulo</p>
  
            </div>
        </body>
        </html>
    HTML;
}

function saveItemsCRMPartner($saveData)
{
    $curl = curl_init();

    if(empty(URL_CPANEL_ADMIN)  == false)
    {
        $url = rtrim(URL_CPANEL_ADMIN, '/');
    }

    $url = $url . "/administracion/configuracion-paquetes-partner-center";

    $acceso_api_publica = acceso_api_publica;
    $igp_id = IGP_ID;
 
    //echo $igp_id; exit;

    $crm_partner_sys_item_id = $saveData["crm_partner_sys_item_id"]; 
    $valor_caracteristicas   = $saveData["valor_caracteristicas"];
    $nombre_paquete          = $saveData["nombre_paquete"];
    $description             = $saveData["description"];

    //"acceso_token_api_publica": "9e7a3737-1ddd-4906-9138-15c1faaab7da-b5f1-35f7-27fc9e",
    //"igp_id": "WFxD",
    //"crm_partner_sys_item_id": 35,
    //"valor_caracteristicas": "3500",
    //"nombre_paquete": "paquete modificar api publica"
 
    $data = [
        "item" => [
            "acceso_token_api_publica"  => $acceso_api_publica,
            "igp_id"                    => $igp_id,
            "crm_partner_sys_item_id"   => $crm_partner_sys_item_id,
            "valor_caracteristicas"     => $valor_caracteristicas,
            "nombre_paquete"            => $nombre_paquete,
            "description"               => $description,
        ]
    ];

    // Convert to JSON for FormData
    $jsonData = json_encode($data);

    //echo $jsonData; exit;

    $contenido = [
        'contenido' => $jsonData
    ];

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url, // Ensure $url is defined
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $contenido,
        CURLOPT_HTTPHEADER => array(
            // Let curl set Content-Type: multipart/form-data automatically
        ),
    ));

    $response = curl_exec($curl);

    if ($response === false) {
        //echo 'Curl error: ' . curl_error($curl);

        $salida = array(
            "type"                   => "error",
            "message"                => "Error make Curl:" . curl_error($curl),  
        );
        curl_close($curl);
        //print_r(json_encode($salida)); exit;
        //exit;
        return $salida;
    }

    $responseData = json_decode($response, true);
    curl_close($curl);

    if ($responseData) {

        // Check if errorResponse.error is true
        if (isset($responseData['errorResponse']['error']) && $responseData['errorResponse']['error'] === true) {
            $salida = [
                "type" => "error",
                "message" => $responseData['errorResponse']['titulo']
            ];
            //print_r(json_encode($salida));
            return $salida;
        } else {
            // Output the full response if no error
            $salida = [
                "type"    => "success",
                "message" => "",
            ];
            //print_r(json_encode($salida));
            return $salida;
            //
        }
        
    } else {
        $salida = [
            "type" => "error",
            "message" => "The JSON response could not be decoded when saving information to the CRM Administrative Partner."
        ];

        return $salida;
        //print_r(json_encode($salida));
    }

}



function insertRegister($dataRegister)
{
    if(empty(URL_CPANEL_ADMIN)  == false)
    {
        $url = rtrim(URL_CPANEL_ADMIN, '/');
    }
    
    $url = $url . "/parnerts/api-publica-registro-pago-suscripciones";

    //echo $url; exit;

    $fm_id         = $dataRegister["fm_id"];
    $monto         = $dataRegister["monto"];
    $metodo        = $dataRegister["metodo"];
    $pasarela_pago = $dataRegister["pasarela_pago"];
    $fecha_pago    = $dataRegister["fecha_pago"];
    $status_pago   = $dataRegister["status_pago"];

    $status_pago   = $dataRegister["status_pago"];

    $id_stripe           = $dataRegister["id_stripe"];
    $id_square           = $dataRegister["id_square"];
    $orden_id_square     = $dataRegister["orden_id_square"];
    $secret_key_pg       = $dataRegister["secret_key_pg"];
    $version_square      = $dataRegister["version_square"];
    $token_square        = $dataRegister["token_square"];
    $location_ids_square = $dataRegister["location_ids_square"];

    $pi_stripe             = $dataRegister["pi_stripe"];
    $payment_method_stripe = $dataRegister["payment_method_stripe"];

    $payment_intent_id = $dataRegister["payment_intent_id"];
    $process_payment_intent_id = $dataRegister["process_payment_intent_id"];

    $data = [
        "item" => [
            "acceso_token_api_publica" => acceso_api_publica,
            "igp_id"                   => IGP_ID,
            "fm_id"                    => $fm_id,
            "monto"                    => $monto,
            "metodo"                   => $metodo,
            "pasarela_pago"            => $pasarela_pago,
            "fecha_pago"               => $fecha_pago,
            "status_pago"              => $status_pago,

            "id_stripe"                => $id_stripe,
            "id_square"                => $id_square,
            "orden_id_square"          => $orden_id_square,
            "secret_key_pg"            => $secret_key_pg,
            "version_square"           => $version_square,
            "token_square"             => $token_square,
            "location_ids_square"      => $location_ids_square,
            
            "pi_stripe"                => $pi_stripe,
            "payment_method_stripe"    => $payment_method_stripe,

            "payment_intent_id"         => $payment_intent_id,
            "process_payment_intent_id" => $process_payment_intent_id,

        ]
    ];

    //"acceso_token_api_publica": "9e7a3737-1ddd-4906-9138-15c1faaab7da-b5f1-35f7-27fc9e",
    //"igp_id": "WFxD",
    //"fm_id": 46,
    //"monto": 1000,
    //"metodo": "Credit Card",
    //"pasarela_pago": "Stripe",
    //"fecha_pago": "2025-09-18 17:01:17"
    
    // Convert to JSON for FormData
    $jsonData = json_encode($data);

    //echo $jsonData; exit;

    $contenido = [
        'contenido' => $jsonData
    ];

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url, // Ensure $url is defined
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $contenido,
        CURLOPT_HTTPHEADER => array(
            // Let curl set Content-Type: multipart/form-data automatically
        ),
    ));

    $response = curl_exec($curl);

    if ($response === false) {
        //echo 'Curl error: ' . curl_error($curl);

        $salida = array(
            "type"                   => "error",
            "message"                => "Error make Curl:" . curl_error($curl),  
        );

        //print_r(json_encode($salida)); exit;
        curl_close($curl);
        return $salida;
        //exit;
    }

    $responseData = json_decode($response, true);
    curl_close($curl);

    if ($responseData) {

        // Check if errorResponse.error is true
        if (isset($responseData['errorResponse']['error']) && $responseData['errorResponse']['error'] === true) {
            
            $salida = [
                "type" => "error",
                "message" => $responseData['errorResponse']['titulo']
            ];

            return $salida; 
            //print_r(json_encode($salida));

        } else {
            // Output the full response if no error

            $salida = array(
                "type"                => "success",
                "message"             => "Payment has been successfully registered",
            );

            return $salida; 
            //
        }
        
    } else {
        $salida = [
            "type" => "error",
            "message" => "Failed to decode JSON response"
        ];

        return $salida; 
    }
}




function insertRegisterTickets($dataRegister)
{
    if(empty(URL_CPANEL_ADMIN)  == false)
    {
        $url = rtrim(URL_CPANEL_ADMIN, '/');
    }
    
    $url = $url . "/parnerts/api-publica-registro-tickets";

    //echo $url; exit;

    $tid         = $dataRegister["tid"];
    $did         = $dataRegister["did"];
    $dname       = $dataRegister["dname"];
    $userid      = $dataRegister["userid"];
    $account         = $dataRegister["account"];
    $email           = $dataRegister["email"];
    $created_at      = $dataRegister["created_at"];
    $updated_at      = $dataRegister["updated_at"];
    $subject         = $dataRegister["subject"];
    $message         = $dataRegister["message"];

    $status         = $dataRegister["status"];
    $urgency        = $dataRegister["urgency"];
    $admin          = $dataRegister["admin"];
    $attachments    = $dataRegister["attachments"];
    $last_reply     = $dataRegister["last_reply"];
    $flag           = $dataRegister["flag"];

    $is_spam           = $dataRegister["is_spam"];
    $client_read       = $dataRegister["client_read"];
    $admin_read        = $dataRegister["admin_read"];
    $source            = $dataRegister["source"];
    $ttype             = $dataRegister["ttype"];
    $tstart            = $dataRegister["tstart"];
    $tend              = $dataRegister["tend"];
    $ttotal            = $dataRegister["ttotal"];

    $todo              = $dataRegister["todo"];
    $tags              = $dataRegister["tags"];
    $notes             = $dataRegister["notes"];
    $c1                = $dataRegister["c1"];
    $c2                = $dataRegister["c2"];
    $email_client      = $dataRegister["email_client"];
    $phone_client      = $dataRegister["phone_client"];
    $contact_client    = $dataRegister["contact_client"];

    $tipo_registro     = $dataRegister["tipo_registro"];
    $opening_date      = $dataRegister["opening_date"];
    $staff_created     = $dataRegister["staff_created"];
    $staff_name_created  = $dataRegister["staff_name_created"];

    $crm_admin_sys_tickets_id     = $dataRegister["crm_admin_sys_tickets_id"];
    $status_id     = $dataRegister["status_id"];
    $UUID     = $dataRegister["UUID"];
    
 
    $data = [
        "item" => [
            "acceso_token_api_publica" => acceso_api_publica,
            "igp_id"                   => IGP_ID,
            "fm_id"                    => $fm_id,
            "monto"                    => $monto,
            
            "tid"        => $tid,
            "did"        => $did,
            "dname"      => $dname,
            "userid"     => $userid,
            "account"    => $account,
            "email"      => $email,
            "created_at" => $created_at,
            "updated_at" => $updated_at,
            "subject"    => $subject,
            "message"    => $message,

            "status"      => $status, 
            "urgency"     => $urgency, 
            "admin"       => $admin, 
            "attachments" => $attachments, 
            "last_reply"  => $last_reply, 
            "flag"        => $flag, 

            "is_spam"     => $is_spam,
            "client_read" => $client_read,
            "admin_read"  => $admin_read,
            "source"      => $source,
            "ttype"       => $ttype,
            "tstart"      => $tstart,
            "tend"        => $tend,
            "ttotal"      => $ttotal,

            "todo"           => $todo,
            "tags"           => $tags,
            "notes"          => $notes,
            "c1"             => $c1,
            "c2"             => $c2,
            "email_client"   => $email_client,
            "phone_client"   => $phone_client,
            "contact_client" => $contact_client,

            "tipo_registro" => $tipo_registro,
            "opening_date"  => $opening_date,
            "staff_created" => $staff_created,
            "staff_name_created"       => $staff_name_created,
            "crm_admin_sys_tickets_id" => $crm_admin_sys_tickets_id,
            "status_id" => $status_id,
            "UUID" => $UUID,

        ]
    ];


    //"acceso_token_api_publica": "9e7a3737-1ddd-4906-9138-15c1faaab7da-b5f1-35f7-27fc9e",
    //"igp_id": "WFxD",
    //"fm_id": 46,
    //"monto": 1000,
    //"metodo": "Credit Card",
    //"pasarela_pago": "Stripe",
    //"fecha_pago": "2025-09-18 17:01:17"
    
    // Convert to JSON for FormData
    $jsonData = json_encode($data);

    //echo $jsonData; exit;

    $contenido = [
        'contenido' => $jsonData
    ];

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url, // Ensure $url is defined
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $contenido,
        CURLOPT_HTTPHEADER => array(
            // Let curl set Content-Type: multipart/form-data automatically
        ),
    ));

    $response = curl_exec($curl);

    if ($response === false) {
        //echo 'Curl error: ' . curl_error($curl);

        $salida = array(
            "type"                   => "error",
            "message"                => "Error make Curl:" . curl_error($curl),  
        );

        //print_r(json_encode($salida)); exit;
        curl_close($curl);
        return $salida;
        //exit;
    }

    $responseData = json_decode($response, true);
    curl_close($curl);

    if ($responseData) {

        // Check if errorResponse.error is true
        if (isset($responseData['errorResponse']['error']) && $responseData['errorResponse']['error'] === true) {
            
            $salida = [
                "type" => "error",
                "message" => $responseData['errorResponse']['titulo']
            ];

            return $salida; 
            //print_r(json_encode($salida));

        } else {
            // Output the full response if no error
            
            $sys_tickets_id = $responseData['contenido']['sys_tickets_id'];
            $status_id      = $responseData['contenido']['status_id'];
            $status_name    = $responseData['contenido']['status_name'];
            $UUID           = $responseData['contenido']['UUID'];
            $id_cliente_crm = $responseData['contenido']['id_cliente_crm'];

            $salida = array(
                "type"                => "success",
                "message"             => "Payment has been successfully registered",
                "sys_tickets_id"      => $sys_tickets_id,
                "status_id"           => $status_id,
                "status_name"         => $status_name,
                "UUID"                => $UUID,
                "id_cliente_crm"      => $id_cliente_crm,
            );

            return $salida; 
            //
        }
        
    } else {
        $salida = [
            "type" => "error",
            "message" => "Failed to decode JSON response"
        ];

        return $salida; 
    }
}


function getInformationTicketsDepartaments()
{
    if(empty(URL_CPANEL_ADMIN)  == false)
    {
        $url = rtrim(URL_CPANEL_ADMIN, '/');
    }
    
    $url = $url . "/parnerts/api-publica-lista-departamentos-tickets";

    //echo $url; exit;
 
    $data = [
        "item" => [
            "acceso_token_api_publica" => acceso_api_publica,
            "igp_id"                   => IGP_ID,
        ]
    ];

    // Convert to JSON for FormData
    $jsonData = json_encode($data);

    //echo $jsonData; exit;

    $contenido = [
        'contenido' => $jsonData
    ];

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url, // Ensure $url is defined
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $contenido,
        CURLOPT_HTTPHEADER => array(
            // Let curl set Content-Type: multipart/form-data automatically
        ),
    ));

    $response = curl_exec($curl);

    if ($response === false) {
        //echo 'Curl error: ' . curl_error($curl);

        $salida = array(
            "type"                   => "error",
            "message"                => "Error make Curl:" . curl_error($curl),  
            "dataArray" => [],
        );

        //print_r(json_encode($salida)); exit;
        curl_close($curl);
        return $salida;
        //exit;
    }

    $responseData = json_decode($response, true);
    curl_close($curl);

    if ($responseData) {

        // Check if errorResponse.error is true
        if (isset($responseData['errorResponse']['error']) && $responseData['errorResponse']['error'] === true) {
            
            $salida = [
                "type" => "error",
                "message" => $responseData['errorResponse']['titulo'],
                "dataArray" => [],
            ];

            return $salida; 
            //print_r(json_encode($salida));

        } else {
            // Output the full response if no error
            
            $listDepartaments = $responseData['contenido'];

            $salida = array(
                "type"                => "success",
                "message"             => "",
                "dataArray"      => $listDepartaments,
            );

            return $salida; 
            //
        }
        
    } else {
        $salida = [
            "type" => "error",
            "message" => "Failed to decode JSON response",
            "dataArray" => [],
        ];

        return $salida; 
    }
}



function updateInformationTickets($dataRegister)
{
    if(empty(URL_CPANEL_ADMIN)  == false)
    {
        $url = rtrim(URL_CPANEL_ADMIN, '/');
    }
    
    $url = $url . "/parnerts/api-publica-cambiar-informacion-general-tickets";

    //echo $url; exit;

    $sys_ticket_id         = $dataRegister["sys_ticket_id"];
    $aid                   = $dataRegister["aid"];
    $aname_staff_assigned  = $dataRegister["aname_staff_assigned"];
    $support_start_date    = $dataRegister["support_start_date"];
    $type_action           = $dataRegister["type_action"];
    $id_cliente_crm        = $dataRegister["id_cliente_crm"];

    $did                   = $dataRegister["did"];
    $dname                 = $dataRegister["dname"];

    $status                = $dataRegister["status"];
    $status_id             = $dataRegister["status_id"];
    $closing_date          = $dataRegister["closing_date"];
    $expected_closing_date = $dataRegister["expected_closing_date"];
 
    $sys_tickets_category_id   = $dataRegister["sys_tickets_category_id"];
    $sys_tickets_category_name = $dataRegister["sys_tickets_category_name"];
    $sys_ticket_id_crm_admin   = $dataRegister["sys_ticket_id_crm_admin"];
    $category_id               = $dataRegister["category_id"];

    $data = [
        "item" => [
            "acceso_token_api_publica" => acceso_api_publica,
            "igp_id"                   => IGP_ID,
            "sys_ticket_id"            => $sys_ticket_id,
            "aid"                      => $aid,
            "aname_staff_assigned"     => $aname_staff_assigned,
            "support_start_date"       => $support_start_date,
            "type_action"              => $type_action,
            "id_cliente_crm"           => $id_cliente_crm,

            "did"                      => $did,
            "dname"                    => $dname,

            "status"                    => $status,
            "status_id"                 => $status_id,
            "closing_date"              => $closing_date,
            "expected_closing_date"     => $expected_closing_date,

            "sys_tickets_category_id"   => $sys_tickets_category_id,
            "sys_tickets_category_name" => $sys_tickets_category_name,
            "sys_ticket_id_crm_admin"   => $sys_ticket_id_crm_admin,
            "category_id"               => $category_id,
        ]
    ];
 
    // Convert to JSON for FormData
    $jsonData = json_encode($data);

    //echo $jsonData; exit;

    $contenido = [
        'contenido' => $jsonData
    ];

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url, // Ensure $url is defined
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $contenido,
        CURLOPT_HTTPHEADER => array(
            // Let curl set Content-Type: multipart/form-data automatically
        ),
    ));

    $response = curl_exec($curl);

    if ($response === false) {
        //echo 'Curl error: ' . curl_error($curl);

        $salida = array(
            "type"                   => "error",
            "message"                => "Error make Curl:" . curl_error($curl),  
        );

        //print_r(json_encode($salida)); exit;
        curl_close($curl);
        return $salida;
        //exit;
    }

    $responseData = json_decode($response, true);
    curl_close($curl);

    if ($responseData) {

        // Check if errorResponse.error is true
        if (isset($responseData['errorResponse']['error']) && $responseData['errorResponse']['error'] === true) {
            
            $salida = [
                "type" => "error",
                "message" => $responseData['errorResponse']['titulo']
            ];

            return $salida; 
            //print_r(json_encode($salida));

        } else {
            // Output the full response if no error
            
            //$sys_tickets_id = $responseData['contenido']['sys_tickets_id'];

            $salida = array(
                "type"                => "success",
                "message"             => "",
            );

            return $salida; 
            //
        }
        
    } else {
        $salida = [
            "type" => "error",
            "message" => "Failed to decode JSON response"
        ];

        return $salida; 
    }
}


function enviarCorreoElectronicoPersonalizado($mysqli, $data_gip, $opcionesPlantilla)
{
    $DB_NAME = DB_NAME;

    $tipo_plantilla   = $opcionesPlantilla["tipo_plantilla"];
    $buscar_plantilla = $opcionesPlantilla["buscar_plantilla"];
    $mensaje_plantilla = $opcionesPlantilla["subjeto_email"];
    $subjeto_email     = $opcionesPlantilla["mensaje_plantilla"];

    //$subjeto_email = "Tickets Created";
    //$mensaje_plantilla = "A ticket has been created. For more information, please visit the following URL.";
    
    //entre otros
    if($buscar_plantilla == "personalizado")
    {

    }

     
    $sql = "SELECT habilitar_modulo_correo_electronico FROM $DB_NAME.`modulo_disponible` AS ppp LIMIT 1 ";
        
    $data_modulo_correo_electronico_disponible = $mysqli->query($sql)->fetch_assoc();

    if(empty($data_modulo_correo_electronico_disponible) == false)
    {
        if($data_modulo_correo_electronico_disponible["habilitar_modulo_correo_electronico"] == 1)
        {
            $sql = "SELECT * FROM $DB_NAME.`modulo_envio_correos_parnerts` AS ppp LIMIT 1 ";
        
            $data_correo_electronico = $mysqli->query($sql)->fetch_assoc();

            //echo json_encode($data_correo_electronico); exit;

            if(empty($data_correo_electronico) == false)
            {
                $proveedor = $data_correo_electronico["proveedor"];

                if($proveedor == "twilio")
                {

                    if($tipo_plantilla == "basica")
                    {
                        $texto_plantilla_finalizada = mensajeCorreoElectronicoPlantillaBasica( $mensaje_plantilla );
                    }
 
                    $configuracion = [
                        "config_email_email"         => $data_correo_electronico["correo_electronico"],
                        "config_email_nombre"        => $data_correo_electronico["nombre_twilio"],
                        "subject"                    => $subjeto_email,
                        "email_user_crm_accounts"    => $data_gip["email"],
                        "account_user_crm_accounts"  => $data_gip["account"],
                        "texto_plantilla_finalizada" => $texto_plantilla_finalizada,
                        "config_email_token"         => $data_correo_electronico["token_twilio"],
                    ];

                    //echo json_encode($configuracion); exit;
                    
                    enviar_mensaje_sendgridv1($configuracion);

                    //echo json_encode($configuracion); exit;
                          
                }

                if($proveedor == "phpmailer")
                {

                    if($tipo_plantilla == "")
                    {
                        $texto_plantilla_finalizada = mensajeCorreoElectronicoPlantillaBasica( $mensaje_plantilla );
                    }
 
                    $configuracion = [
                        "host"                       => $data_correo_electronico["host_phpmailer"],
                        "username"                   => $data_correo_electronico["correo_electronico"],
                        "password"                   => $data_correo_electronico["password_phpmailer"],
                        "port"                       => $data_correo_electronico["puerto_phpmailer"],
                        "send_copy"                  => $data_correo_electronico["copia_correo_electronico_phpmailer"],
                        
                        "html"                       => $texto_plantilla_finalizada,

                        "Subject"                    => $subjeto_email,

                        "correo_electronico"         => $data_gip["email"],
                        "nombre_empresa_persona"     => $data_gip["account"],
                    ];

                    //echo json_encode($configuracion); exit;

                    mensajeCorreoPhpMailerv1($configuracion);

                    //echo json_encode($configuracion); exit;
                }

            }
 
        }
 
    }
}


function datosInformacionGeneralV2($url, $data)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded'
    ]);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        $response = [
            "type" => "error",
            "data" => "Error bringing more detailed information: " . curl_error($ch)
        ];
        curl_close($ch);
        return json_encode($response);
    }

    $responseData = json_decode($response, true);

    if ($responseData === null) {
        $response = [
            "type" => "error",
            "data" => "Error decoding JSON response"
        ];
        curl_close($ch);
        return ($response);
    }

    //echo $response; exit;

    if (isset($responseData['errorResponse']['error']) && $responseData['errorResponse']['error'] === true) {
        
        //echo "cayo"; exit;

        $errorMessage = $responseData['errorResponse']['titulo'] ?? 'Error desconocido';
        $response = [
            "type" => "error",
            "data" => $errorMessage
        ];
        curl_close($ch);
        return ($response);
        
    }

    if (isset($responseData['contenido']['informacion_general_partners'])) {
        $informacion_general_partners = $responseData['contenido']['informacion_general_partners'];
        $configuracion_crm_partner_center = $responseData['contenido']['configuracion_crm_partner_center'];

        $response = [
            "type" => "success",
            "data" =>  "",
            "informacion_general_partners"     =>  $informacion_general_partners,
            "configuracion_crm_partner_center" =>  $configuracion_crm_partner_center,
        ];

        curl_close($ch);
        return $response;

    } else {
        $response = [
            "type" => "error",
            "data" => "No informacion_general_partners data found"
        ];

        curl_close($ch);
        return $response;
    }

    curl_close($ch);
    return $response;
}


function insertRegisterURLDocumentsTickets($dataRegister)
{
    if(empty(URL_CPANEL_ADMIN)  == false)
    {
        $url = rtrim(URL_CPANEL_ADMIN, '/');
    }
    
    $url = $url . "/parnerts/api-publica-registro-arreglo-documents";

    //echo $url; exit;

    $sys_ticket_id_crm         = $dataRegister["sys_ticket_id_crm"];
    $arreglo_rutas             = $dataRegister["arreglo_rutas"];
    $id_cliente_crm            = $dataRegister["id_cliente_crm"];
    
    $data = [
        "item" => [
            "acceso_token_api_publica" => acceso_api_publica,
            "igp_id"                   => IGP_ID,
            "sys_ticket_id_crm"        => $sys_ticket_id_crm,
            "id_cliente_crm"           => $id_cliente_crm,
            "arreglo_rutas"            => $arreglo_rutas,
        ]
    ];

    // Convert to JSON for FormData
    $jsonData = json_encode($data);

    //echo $jsonData; exit;

    $contenido = [
        'contenido' => $jsonData
    ];

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url, // Ensure $url is defined
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $contenido,
        CURLOPT_HTTPHEADER => array(
            // Let curl set Content-Type: multipart/form-data automatically
        ),
    ));

    $response = curl_exec($curl);

    if ($response === false) {
        //echo 'Curl error: ' . curl_error($curl);

        $salida = array(
            "type"                   => "error",
            "message"                => "Error make Curl:" . curl_error($curl),  
        );

        //print_r(json_encode($salida)); exit;
        curl_close($curl);
        return $salida;
        //exit;
    }

    $responseData = json_decode($response, true);
    curl_close($curl);

    if ($responseData) {

        // Check if errorResponse.error is true
        if (isset($responseData['errorResponse']['error']) && $responseData['errorResponse']['error'] === true) {
            
            $salida = [
                "type" => "error",
                "message" => $responseData['errorResponse']['titulo']
            ];

            return $salida; 
            //print_r(json_encode($salida));

        } else {
            // Output the full response if no error
            
            $sys_tickets_id = $responseData['contenido']['sys_tickets_id'];
            $status_id      = $responseData['contenido']['status_id'];
            $status_name    = $responseData['contenido']['status_name'];
            $UUID           = $responseData['contenido']['UUID'];

            $salida = array(
                "type"                => "success",
                "message"             => "Registration processed successfully",
                //"sys_tickets_id"      => $sys_tickets_id,
                //"status_id"           => $status_id,
                //"status_name"         => $status_name,
                //"UUID"                => $UUID,
            );

            return $salida; 
            //
        }
        
    } else {
        $salida = [
            "type" => "error",
            "message" => "Failed to decode JSON response"
        ];

        return $salida; 
    }
}


function PlantillaMensajes($mensaje_plantilla = "" )
{

  
    return <<<HTML
    <!DOCTYPE html>
        <html lang="es">
        <head>
            <meta charset="UTF-8" />
            <title>Payment of Fee</title>
            <meta name="viewport" content="width=device-width, initial-scale=1.0" />
            <style>
                body {
                    margin: 0;
                    font-family: Arial, sans-serif;
                    background: #f5f5f5;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    height: 100vh;
                }

                .card {
                    background: white;
                    padding: 40px;
                    border-radius: 12px;
                    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
                    text-align: center;
                    width: 50%;
                    
                }

                .card img {
                    max-width: 120px;
                    margin-bottom: 20px;
                }

                .card h2 {
                    font-size: 20px;
                    color: #333;
                    margin-bottom: 15px;
                }

                .card a {
                    color: #007bff;
                    text-decoration: none;
                    font-weight: bold;
                }

                .card a:hover {
                    text-decoration: underline;
                }

                .contenedor {
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                    margin-bottom: 10px;
                }

                .titulo_general {
                    font-weight: bold;
                }

                .titulo {
                    font-weight: bold;
                    text-align: left;
                }

                .texto {
                    font-weight: normal;
                    text-align: right;
                }
            </style>
        </head>
        <body>
            <div class="card">
                
                $mensaje_plantilla
               
            </div>
        </body>
        </html>
    HTML;
}


function insertTicketsReplies($dataRegister)
{
    if(empty(URL_CPANEL_ADMIN)  == false)
    {
        $url = rtrim(URL_CPANEL_ADMIN, '/');
    }
    
    $url = $url . "/parnerts/api-publica-crear-tickets-replies";

    //echo $url; exit;

    $sys_ticket_id             = $dataRegister["tid"];
    $id_cliente_crm            = $dataRegister["id_cliente_crm"];
    $tid_crm_admin             = $dataRegister["tid_crm_admin"];
    $id_cliente_crm            = $dataRegister["id_cliente_crm"];
    $tid                       = $dataRegister["tid"];
    $userid                    = $dataRegister["userid"];
    $account                   = $dataRegister["account"];
    $reply_type                = $dataRegister["reply_type"];
    $email                     = $dataRegister["email"];
    $created_at                = $dataRegister["created_at"];
    $updated_at                = $dataRegister["updated_at"];
    $message                   = $dataRegister["message"];
    $replied_by                = $dataRegister["replied_by"];
    $admin                     = $dataRegister["admin"];
    $attachments               = $dataRegister["attachments"];
    $client_read               = $dataRegister["client_read"];
    $admin_read                = $dataRegister["admin_read"];
    $type_accion               = $dataRegister["type_accion"];
    $UUID                      = $dataRegister["UUID"];
    $who_sent                  = $dataRegister["who_sent"];
    $crm_admin_sys_tickets_id  = $dataRegister["crm_admin_sys_tickets_id"];
    
 
    $data = [
        "item" => [
            "acceso_token_api_publica" => acceso_api_publica,
            "igp_id"                   => IGP_ID,
            "crm_admin_sys_tickets_id" => $crm_admin_sys_tickets_id,
            "id_cliente_crm"           => $id_cliente_crm,
            "sys_ticket_id"            => $sys_ticket_id,
            "id_cliente_crm"           => $id_cliente_crm,
            "tid_crm_admin"            => $tid_crm_admin,
            "tid"                      => $tid,
            "userid"                   => $userid,
            "account"                  => $account,
            "reply_type"               => $reply_type,
            "email"                    => $email,
            "created_at"               => $created_at,
            "updated_at"               => $updated_at,
            "message"                  => $message,
            "replied_by"               => $replied_by,
            "admin"                    => $admin,
            "attachments"              => $attachments,
            "client_read"              => $client_read,
            "admin_read"               => $admin_read,
            "type_accion"              => $type_accion,
            "UUID"                     => $UUID,
            "who_sent"                 => $who_sent,
        ]
    ];
 
    // Convert to JSON for FormData
    $jsonData = json_encode($data);

    //echo $jsonData; exit;

    $contenido = [
        'contenido' => $jsonData
    ];

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url, // Ensure $url is defined
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $contenido,
        CURLOPT_HTTPHEADER => array(
            // Let curl set Content-Type: multipart/form-data automatically
        ),
    ));

    $response = curl_exec($curl);

    if ($response === false) {
        //echo 'Curl error: ' . curl_error($curl);

        $salida = array(
            "type"                   => "error",
            "message"                => "Error make Curl:" . curl_error($curl),  
        );

        //print_r(json_encode($salida)); exit;
        curl_close($curl);
        return $salida;
        //exit;
    }

    $responseData = json_decode($response, true);
    curl_close($curl);

    if ($responseData) {

        // Check if errorResponse.error is true
        if (isset($responseData['errorResponse']['error']) && $responseData['errorResponse']['error'] === true) {
            
            $salida = [
                "type" => "error",
                "message" => $responseData['errorResponse']['titulo']
            ];

            return $salida; 
            //print_r(json_encode($salida));

        } else {
            // Output the full response if no error
            
            $tid_crm_admin_id = $responseData['contenido']['tid_crm_admin_id'];

            $salida = array(
                "type"                => "success",
                "message"             => "",
                "tid_crm_admin_id"    => $tid_crm_admin_id,
            );

            return $salida; 
            //
        }
        
    } else {
        $salida = [
            "type" => "error",
            "message" => "Failed to decode JSON response"
        ];

        return $salida; 
    }
}


function updateTicketsReplies($dataRegister)
{
    if(empty(URL_CPANEL_ADMIN)  == false)
    {
        $url = rtrim(URL_CPANEL_ADMIN, '/');
    }
    
    $url = $url . "/parnerts/api-publica-update-tickets-replies";

    //echo $url; exit;
    $type_accion               = $dataRegister["type_accion"];   

    //$sys_ticket_id             = $dataRegister["tid"];
    //$tid                       = $dataRegister["tid"];
    //$tid_crm_admin             = $dataRegister["tid_crm_admin"];
    $UUID                         = $dataRegister["UUID"];
    $crm_partnert_administrativo  = $dataRegister["crm_partnert_administrativo"];

    $tid_crm_admin                = $dataRegister["tid_crm_admin"];
    $crm_admin_sys_tickets_id     = $dataRegister["crm_admin_sys_tickets_id"];
    $tid                          = $dataRegister["tid"];
    $sys_ticketreplies_id         = $dataRegister["sys_ticketreplies_id"];
    $userid                       = $dataRegister["userid"];
    $id_cliente_crm               = $dataRegister["id_cliente_crm"];
    $account                      = $dataRegister["account"];
    $reply_type                   = $dataRegister["reply_type"];
    $email                        = $dataRegister["email"];
    $created_at                   = $dataRegister["created_at"];
    $updated_at                   = $dataRegister["updated_at"];
    $message                      = $dataRegister["message"];
    $replied_by                   = $dataRegister["replied_by"];
    $admin                        = $dataRegister["admin"];
    $attachments                  = $dataRegister["attachments"];
    $client_read                  = $dataRegister["client_read"];
    $admin_read                   = $dataRegister["admin_read"];
    $rating                       = $dataRegister["rating"];
    $who_sent                     = $dataRegister["who_sent"];

    //"tid_crm_admin"                => $d["id"],
    //"tid"                          => $d["tid"],
    //"sys_ticketreplies_id"         => $d["id"],

    $data = [
        "item" => [
            "acceso_token_api_publica" => acceso_api_publica,
            "igp_id"                   => IGP_ID,
            "type_accion"              => $type_accion,
 
            "UUID"                        => $UUID,
            "crm_partnert_administrativo" => $crm_partnert_administrativo,

            "crm_admin_sys_tickets_id"    => $crm_admin_sys_tickets_id,
            "tid_crm_admin"               => $tid_crm_admin,
            "tid"                         => $tid,
            "sys_ticketreplies_id"        => $sys_ticketreplies_id,
            "userid"                      => $userid,
            "id_cliente_crm"              => $id_cliente_crm,
            "account"                     => $account,
            "reply_type"                  => $reply_type,
            "email"                       => $email,
            "created_at"                  => $created_at,
            "updated_at"                  => $updated_at,
            "message"                     => $message,
            "replied_by"                  => $replied_by,
            "admin"                       => $admin,
            "attachments"                 => $attachments,
            "client_read"                 => $client_read,
            "admin_read"                  => $admin_read,
            "rating"                      => $rating,
            "who_sent"                    => $who_sent,
        ]
    ];
 
    // Convert to JSON for FormData
    $jsonData = json_encode($data);

    //echo $jsonData; exit;

    $contenido = [
        'contenido' => $jsonData
    ];

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url, // Ensure $url is defined
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $contenido,
        CURLOPT_HTTPHEADER => array(
            // Let curl set Content-Type: multipart/form-data automatically
        ),
    ));

    $response = curl_exec($curl);

    if ($response === false) {
        //echo 'Curl error: ' . curl_error($curl);

        $salida = array(
            "type"                   => "error",
            "message"                => "Error make Curl:" . curl_error($curl),  
        );

        //print_r(json_encode($salida)); exit;
        curl_close($curl);
        return $salida;
        //exit;
    }

    $responseData = json_decode($response, true);
    curl_close($curl);

    if ($responseData) {

        // Check if errorResponse.error is true
        if (isset($responseData['errorResponse']['error']) && $responseData['errorResponse']['error'] === true) {
            
            $salida = [
                "type" => "error",
                "message" => $responseData['errorResponse']['titulo']
            ];

            return $salida; 
            //print_r(json_encode($salida));

        } else {
            // Output the full response if no error
            
            $tid_crm_admin_id = $responseData['contenido']['tid_crm_admin_id'];

            $salida = array(
                "type"                => "success",
                "message"             => "",
                "tid_crm_admin_id"    => $tid_crm_admin_id,
            );

            return $salida; 
            //
        }
        
    } else {
        $salida = [
            "type" => "error",
            "message" => "Failed to decode JSON response"
        ];

        return $salida; 
    }
}

function daleteTicketsReplies($dataRegister)
{
    if(empty(URL_CPANEL_ADMIN)  == false)
    {
        $url = rtrim(URL_CPANEL_ADMIN, '/');
    }
    
    $url = $url . "/parnerts/api-publica-delete-tickets-replies";
    //echo $url; exit;
 
    $UUID                         = $dataRegister["UUID"];
    $crm_partnert_administrativo  = $dataRegister["crm_partnert_administrativo"];
    $userid                       = $dataRegister["userid"];


    $data = [
        "item" => [
            "acceso_token_api_publica"    => acceso_api_publica,
            "igp_id"                      => IGP_ID,
            "UUID"                        => $UUID,
            "crm_partnert_administrativo" => $crm_partnert_administrativo,
            "userid"                      => $userid,
        ]
    ];
 
    // Convert to JSON for FormData
    $jsonData = json_encode($data);

    //echo $jsonData; exit;

    $contenido = [
        'contenido' => $jsonData
    ];

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url, // Ensure $url is defined
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $contenido,
        CURLOPT_HTTPHEADER => array(
            // Let curl set Content-Type: multipart/form-data automatically
        ),
    ));

    $response = curl_exec($curl);

    if ($response === false) {
        //echo 'Curl error: ' . curl_error($curl);

        $salida = array(
            "type"                   => "error",
            "message"                => "Error make Curl:" . curl_error($curl),  
        );

        //print_r(json_encode($salida)); exit;
        curl_close($curl);
        return $salida;
        //exit;
    }

    $responseData = json_decode($response, true);
    curl_close($curl);

    if ($responseData) {

        // Check if errorResponse.error is true
        if (isset($responseData['errorResponse']['error']) && $responseData['errorResponse']['error'] === true) {
            
            $salida = [
                "type" => "error",
                "message" => $responseData['errorResponse']['titulo']
            ];

            return $salida; 
            //print_r(json_encode($salida));

        } else {
            // Output the full response if no error
            
            $tid_crm_admin_id = $responseData['contenido']['tid_crm_admin_id'];

            $salida = array(
                "type"                => "success",
                "message"             => "",
                "tid_crm_admin_id"    => $tid_crm_admin_id,
            );

            return $salida; 
            //
        }
        
    } else {
        $salida = [
            "type" => "error",
            "message" => "Failed to decode JSON response"
        ];

        return $salida; 
    }
}

function getDBCRMAdministrative()
{
 
    if(empty($_SESSION['db_crm_administrative']))
    {
        $dataCRMPartnerAdmins = ORM::get_db()->query("SELECT `value` FROM `sys_appconfig` WHERE setting = 'crm_partnert_administrativo' ")->fetch(PDO::FETCH_ASSOC);

        $crm_partnert_administrativo = 2;

        if(!empty($dataCRMPartnerAdmins))
        {
            $crm_partnert_administrativo = $dataCRMPartnerAdmins["value"];

            if($crm_partnert_administrativo == 1)
            {
                $_SESSION['db_crm_administrative'] = DB_NAME;
                return DB_NAME;
            }
        }

        $now = new DateTime();
        $_SESSION['db_crm_administrative'] = $now->format('Y-m-d H:i:s.v');
        return "";

    }else{
        return $_SESSION['db_crm_administrative'];
    }

    return "";
}

function emitInformationSocket($datos, $emit)
{
    //$url = 'https://xhde365.com/socket-chat/socket.io/';  
    $url = APP_URL_SERVIDOR_SOCKET;  

    $options = [
        'client' => Client::CLIENT_4X,
        'context' => [
            'http' => [],
            'ssl' => [],
        ],
        'transports' => ['polling'],
    ];

    try {
        $client = Client::create($url, $options);

        $client->initialize(); // Inicializa la conexión

        // Emitir el evento "position"
        /* $dataPosition =
        [
            'id_order' => 10000,
            'lat' => 140.7128,
            'lng' => -74.006,
            'estadoId' => 12,
        ];

        $client->emit('position', $dataPosition); */

        // Emitir el evento "chat-social"
        $client->emit($emit, $datos);

        $client->close(); // Cierra la conexión

        //http_response_code(200);

        //exit;
        //echo "Se envio la info";

    } catch (Exception $e) {
        //http_response_code(500);
        //echo 'Error: ', $e->getMessage(), "\n";
        //exit;
    }
}


//api-publica-tickets-servicios-activados
function listTicketsServiciosActivados()
{
    if(empty(URL_CPANEL_ADMIN)  == false)
    {
        $url = rtrim(URL_CPANEL_ADMIN, '/');
    }
    
    $url = $url . "/parnerts/api-publica-tickets-servicios-activados";

    //echo $url; exit;
 
    $data = [
        "item" => [
            "acceso_token_api_publica" => acceso_api_publica,
            "igp_id"                   => IGP_ID,
        ]
    ];
 
    // Convert to JSON for FormData
    $jsonData = json_encode($data);

    //echo $jsonData; exit;

    $contenido = [
        'contenido' => $jsonData
    ];

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url, // Ensure $url is defined
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $contenido,
        CURLOPT_HTTPHEADER => array(
            // Let curl set Content-Type: multipart/form-data automatically
        ),
    ));

    $response = curl_exec($curl);

    //echo $response; exit;

    if ($response === false) {
        //echo 'Curl error: ' . curl_error($curl);

        $salida = array(
            "type"                   => "error",
            "message"                => "Error make Curl:" . curl_error($curl),  
        );

        //print_r(json_encode($salida)); exit;
        curl_close($curl);
        return $salida;
        //exit;
    }

    $responseData = json_decode($response, true);
    curl_close($curl);

    if ($responseData) {

        // Check if errorResponse.error is true
        if (isset($responseData['errorResponse']['error']) && $responseData['errorResponse']['error'] === true) {
            
            $salida = [
                "type" => "error",
                "message" => $responseData['errorResponse']['titulo']
            ];

            return $salida; 
            //print_r(json_encode($salida));

        } else {
            // Output the full response if no error
            
            $list_status_tickets    = $responseData['contenido']['list_status_tickets'];
            $list_status_tickets_id = $responseData['contenido']['list_status_tickets_id'];

            $salida = array(
                "type"                      => "success",
                "message"                   => "",
                "list_status_tickets"       => $list_status_tickets,
                "list_status_tickets_id"    => $list_status_tickets_id,
            );

            return $salida; 
            //
        }
        
    } else {
        $salida = [
            "type" => "error",
            "message" => "Failed to decode JSON response"
        ];

        return $salida; 
    }
}
