

{block name="head"}

<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.6.2/css/buttons.dataTables.min.css" />

<link
  href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
  rel="stylesheet"
/>

{/block}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    .quitar_margin_pading{
        padding: 0px;
        margin: 0px;
    }

       .btn-edit {
         margin-bottom: 4px; 
         background-color: #001b3b; 
         color: white; 
         border: 1px solid rgb(211, 202, 192) !important; 
         box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
         float: inline-end;
   }

   .btn-eliminar {
      margin-bottom: 4px;
      background-color: red;
      color: white;
      border: 1px solid rgb(211, 202, 192) !important;
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
      float: inline-end;
    }

   .btn-edit:hover i,
   .btn-eliminar:hover i {
      color: white; /* Mantén el color blanco del icono en hover */
   }

</style>

<textarea disabled hidden class="tener_compania" value="{$companies_json}">
    {$companies_json}
</textarea>

<textarea disabled hidden class="micompanias" value="{$myCompanies}">
    {$myCompanies}
</textarea>

 

<form class="form-horizontal" id="rform" >

    <div class="mb-3"><label for="account"><span class="h6">{$_L['Account Name']}</span></label>

        <input type="text" id="account" name="account" class="form-control" value="{$d['account']}">
        <input type="text" class="form-control nacionalidad_tener" value="{$d['nationality']}" hidden disabled>


    </div>

    <div class="row mt-2">
        <div class="col-md-6 ">
            <div class="mb-3"><label for="code"><span class="h6">{$_L['Code']}</span></label>

                <input type="text" id="code" name="code" class="form-control" value="{$d['code']}">
            </div>

        </div>

        <div class="col-md-6 ">
            <div class="mb-3 h6"><label for="review_rating"><span class="h6">Review Rating</span></label>

                <select id="review_rating" name="review_rating" class="form-control review_rating">
                    <option value="1"  {if $d['rating_review'] == 1 } selected {/if} >Yes</option>
                    <option value="2"  {if empty($d['rating_review'])  } selected {/if} >No</option>
                </select>
            </div>
        </div>


        {*
            <div class="col-md-6 ">
                <div class="mb-3 h6"><label for="company_id"><span class="h6">{$_L['Company']}</span></label>

                    <select id="company_id" name="company_id" class="form-control">
                        <option value="0">{$_L['None']}</option>
                        {foreach $companies as $company}
                        <option value="{$company['id']}" {if $d->cid eq ($company['id'])}selected{/if}>{$company['company_name']}</option>
                        {/foreach}
                    </select>
                </div>
            </div>
        *}
         
    </div>

    <div class="row mt-2">
        <div class="col-md-6">
            <div class="mb-3 h6"><label for="edit_email"><span class="h6">{$_L['Email']}</span></label>

                <input type="text" id="edit_email" name="edit_email" class="form-control" value="{$d['email']}">
            </div>


        </div>
        <div class="col-md-6">
            <div class="mb-3 h6"><label for="edit_secondary_email"><span class="h6">{$_L['Secondary Email']}</span></label>
                <input type="text" id="edit_secondary_email" name="secondary_email" class="form-control" value="{$d['secondary_email']}">
            </div>


        </div>
    </div>

    <div class="row mt-2">
        <div class="col-md-6">
            <div class="mb-3 h6"><label for="phone"><span class="h6">{$_L['Phone']}</span></label>

            <div class="row">
                <div class="col-6">
                   {*<select class="form-control form-control-sm" id="codigo_pais" name="codigo_pais" id="codigo_pais" value="{$d['codigo_pais']}"></select>*}  

                    <select class="form-control form-control-sm" id="codigo_pais" name="codigo_pais" style="width: 100%;">
        <option value="">Seleccione un país</option>
        <option value="1" data-icon="https://flagcdn.com/w20/us.png">United States (+1)</option>
        <option value="504" data-icon="https://flagcdn.com/w20/hn.png">Honduras (+504)</option>
        <option value="93" data-icon="https://flagcdn.com/w20/af.png">Afghanistan (+93)</option>
        <option value="355" data-icon="https://flagcdn.com/w20/al.png">Albania (+355)</option>
        <option value="213" data-icon="https://flagcdn.com/w20/dz.png">Algeria (+213)</option>
        <option value="376" data-icon="https://flagcdn.com/w20/ad.png">Andorra (+376)</option>
        <option value="244" data-icon="https://flagcdn.com/w20/ao.png">Angola (+244)</option>
        <option value="1-268" data-icon="https://flagcdn.com/w20/ag.png">Antigua and Barbuda (+1-268)</option>
        <option value="54" data-icon="https://flagcdn.com/w20/ar.png">Argentina (+54)</option>
        <option value="374" data-icon="https://flagcdn.com/w20/am.png">Armenia (+374)</option>
        <option value="61" data-icon="https://flagcdn.com/w20/au.png">Australia (+61)</option>
        <option value="43" data-icon="https://flagcdn.com/w20/at.png">Austria (+43)</option>
        <option value="994" data-icon="https://flagcdn.com/w20/az.png">Azerbaijan (+994)</option>
        <option value="1-242" data-icon="https://flagcdn.com/w20/bs.png">Bahamas (+1-242)</option>
        <option value="973" data-icon="https://flagcdn.com/w20/bh.png">Bahrain (+973)</option>
        <option value="880" data-icon="https://flagcdn.com/w20/bd.png">Bangladesh (+880)</option>
        <option value="1-246" data-icon="https://flagcdn.com/w20/bb.png">Barbados (+1-246)</option>
        <option value="375" data-icon="https://flagcdn.com/w20/by.png">Belarus (+375)</option>
        <option value="32" data-icon="https://flagcdn.com/w20/be.png">Belgium (+32)</option>
        <option value="501" data-icon="https://flagcdn.com/w20/bz.png">Belize (+501)</option>
        <option value="229" data-icon="https://flagcdn.com/w20/bj.png">Benin (+229)</option>
        <option value="975" data-icon="https://flagcdn.com/w20/bt.png">Bhutan (+975)</option>
        <option value="591" data-icon="https://flagcdn.com/w20/bo.png">Bolivia (+591)</option>
        <option value="387" data-icon="https://flagcdn.com/w20/ba.png">Bosnia and Herzegovina (+387)</option>
        <option value="267" data-icon="https://flagcdn.com/w20/bw.png">Botswana (+267)</option>
        <option value="55" data-icon="https://flagcdn.com/w20/br.png">Brazil (+55)</option>
        <option value="673" data-icon="https://flagcdn.com/w20/bn.png">Brunei (+673)</option>
        <option value="359" data-icon="https://flagcdn.com/w20/bg.png">Bulgaria (+359)</option>
        <option value="226" data-icon="https://flagcdn.com/w20/bf.png">Burkina Faso (+226)</option>
        <option value="257" data-icon="https://flagcdn.com/w20/bi.png">Burundi (+257)</option>
        <option value="238" data-icon="https://flagcdn.com/w20/cv.png">Cabo Verde (+238)</option>
        <option value="855" data-icon="https://flagcdn.com/w20/kh.png">Cambodia (+855)</option>
        <option value="237" data-icon="https://flagcdn.com/w20/cm.png">Cameroon (+237)</option>
        <option value="1" data-icon="https://flagcdn.com/w20/ca.png">Canada (+1)</option>
        <option value="236" data-icon="https://flagcdn.com/w20/cf.png">Central African Republic (+236)</option>
        <option value="235" data-icon="https://flagcdn.com/w20/td.png">Chad (+235)</option>
        <option value="56" data-icon="https://flagcdn.com/w20/cl.png">Chile (+56)</option>
        <option value="86" data-icon="https://flagcdn.com/w20/cn.png">China (+86)</option>
        <option value="57" data-icon="https://flagcdn.com/w20/co.png">Colombia (+57)</option>
        <option value="269" data-icon="https://flagcdn.com/w20/km.png">Comoros (+269)</option>
        <option value="242" data-icon="https://flagcdn.com/w20/cg.png">Congo (Brazzaville) (+242)</option>
        <option value="243" data-icon="https://flagcdn.com/w20/cd.png">Congo (Kinshasa) (+243)</option>
        <option value="506" data-icon="https://flagcdn.com/w20/cr.png">Costa Rica (+506)</option>
        <option value="385" data-icon="https://flagcdn.com/w20/hr.png">Croatia (+385)</option>
        <option value="53" data-icon="https://flagcdn.com/w20/cu.png">Cuba (+53)</option>
        <option value="357" data-icon="https://flagcdn.com/w20/cy.png">Cyprus (+357)</option>
        <option value="420" data-icon="https://flagcdn.com/w20/cz.png">Czech Republic (+420)</option>
        <option value="45" data-icon="https://flagcdn.com/w20/dk.png">Denmark (+45)</option>
        <option value="253" data-icon="https://flagcdn.com/w20/dj.png">Djibouti (+253)</option>
        <option value="1-767" data-icon="https://flagcdn.com/w20/dm.png">Dominica (+1-767)</option>
        <option value="1-809" data-icon="https://flagcdn.com/w20/do.png">Dominican Republic (+1-809)</option>
        <option value="593" data-icon="https://flagcdn.com/w20/ec.png">Ecuador (+593)</option>
        <option value="20" data-icon="https://flagcdn.com/w20/eg.png">Egypt (+20)</option>
        <option value="503" data-icon="https://flagcdn.com/w20/sv.png">El Salvador (+503)</option>
        <option value="240" data-icon="https://flagcdn.com/w20/gq.png">Equatorial Guinea (+240)</option>
        <option value="291" data-icon="https://flagcdn.com/w20/er.png">Eritrea (+291)</option>
        <option value="372" data-icon="https://flagcdn.com/w20/ee.png">Estonia (+372)</option>
        <option value="268" data-icon="https://flagcdn.com/w20/sz.png">Eswatini (+268)</option>
        <option value="251" data-icon="https://flagcdn.com/w20/et.png">Ethiopia (+251)</option>
        <option value="679" data-icon="https://flagcdn.com/w20/fj.png">Fiji (+679)</option>
        <option value="358" data-icon="https://flagcdn.com/w20/fi.png">Finland (+358)</option>
        <option value="33" data-icon="https://flagcdn.com/w20/fr.png">France (+33)</option>
        <option value="241" data-icon="https://flagcdn.com/w20/ga.png">Gabon (+241)</option>
        <option value="220" data-icon="https://flagcdn.com/w20/gm.png">Gambia (+220)</option>
        <option value="995" data-icon="https://flagcdn.com/w20/ge.png">Georgia (+995)</option>
        <option value="49" data-icon="https://flagcdn.com/w20/de.png">Germany (+49)</option>
        <option value="233" data-icon="https://flagcdn.com/w20/gh.png">Ghana (+233)</option>
        <option value="30" data-icon="https://flagcdn.com/w20/gr.png">Greece (+30)</option>
        <option value="1-473" data-icon="https://flagcdn.com/w20/gd.png">Grenada (+1-473)</option>
        <option value="502" data-icon="https://flagcdn.com/w20/gt.png">Guatemala (+502)</option>
        <option value="224" data-icon="https://flagcdn.com/w20/gn.png">Guinea (+224)</option>
        <option value="245" data-icon="https://flagcdn.com/w20/gw.png">Guinea-Bissau (+245)</option>
        <option value="592" data-icon="https://flagcdn.com/w20/gy.png">Guyana (+592)</option>
        <option value="509" data-icon="https://flagcdn.com/w20/ht.png">Haiti (+509)</option>
        <option value="36" data-icon="https://flagcdn.com/w20/hu.png">Hungary (+36)</option>
        <option value="354" data-icon="https://flagcdn.com/w20/is.png">Iceland (+354)</option>
        <option value="91" data-icon="https://flagcdn.com/w20/in.png">India (+91)</option>
        <option value="62" data-icon="https://flagcdn.com/w20/id.png">Indonesia (+62)</option>
        <option value="98" data-icon="https://flagcdn.com/w20/ir.png">Iran (+98)</option>
        <option value="964" data-icon="https://flagcdn.com/w20/iq.png">Iraq (+964)</option>
        <option value="353" data-icon="https://flagcdn.com/w20/ie.png">Ireland (+353)</option>
        <option value="972" data-icon="https://flagcdn.com/w20/il.png">Israel (+972)</option>
        <option value="39" data-icon="https://flagcdn.com/w20/it.png">Italy (+39)</option>
        <option value="1-876" data-icon="https://flagcdn.com/w20/jm.png">Jamaica (+1-876)</option>
        <option value="81" data-icon="https://flagcdn.com/w20/jp.png">Japan (+81)</option>
        <option value="962" data-icon="https://flagcdn.com/w20/jo.png">Jordan (+962)</option>
        <option value="7" data-icon="https://flagcdn.com/w20/kz.png">Kazakhstan (+7)</option>
        <option value="254" data-icon="https://flagcdn.com/w20/ke.png">Kenya (+254)</option>
        <option value="686" data-icon="https://flagcdn.com/w20/ki.png">Kiribati (+686)</option>
        <option value="965" data-icon="https://flagcdn.com/w20/kw.png">Kuwait (+965)</option>
        <option value="996" data-icon="https://flagcdn.com/w20/kg.png">Kyrgyzstan (+996)</option>
        <option value="856" data-icon="https://flagcdn.com/w20/la.png">Laos (+856)</option>
        <option value="371" data-icon="https://flagcdn.com/w20/lv.png">Latvia (+371)</option>
        <option value="961" data-icon="https://flagcdn.com/w20/lb.png">Lebanon (+961)</option>
        <option value="266" data-icon="https://flagcdn.com/w20/ls.png">Lesotho (+266)</option>
        <option value="231" data-icon="https://flagcdn.com/w20/lr.png">Liberia (+231)</option>
        <option value="218" data-icon="https://flagcdn.com/w20/ly.png">Libya (+218)</option>
        <option value="423" data-icon="https://flagcdn.com/w20/li.png">Liechtenstein (+423)</option>
        <option value="370" data-icon="https://flagcdn.com/w20/lt.png">Lithuania (+370)</option>
        <option value="352" data-icon="https://flagcdn.com/w20/lu.png">Luxembourg (+352)</option>
        <option value="261" data-icon="https://flagcdn.com/w20/mg.png">Madagascar (+261)</option>
        <option value="265" data-icon="https://flagcdn.com/w20/mw.png">Malawi (+265)</option>
        <option value="60" data-icon="https://flagcdn.com/w20/my.png">Malaysia (+60)</option>
        <option value="960" data-icon="https://flagcdn.com/w20/mv.png">Maldives (+960)</option>
        <option value="223" data-icon="https://flagcdn.com/w20/ml.png">Mali (+223)</option>
        <option value="356" data-icon="https://flagcdn.com/w20/mt.png">Malta (+356)</option>
        <option value="692" data-icon="https://flagcdn.com/w20/mh.png">Marshall Islands (+692)</option>
        <option value="222" data-icon="https://flagcdn.com/w20/mr.png">Mauritania (+222)</option>
        <option value="230" data-icon="https://flagcdn.com/w20/mu.png">Mauritius (+230)</option>
        <option value="52" data-icon="https://flagcdn.com/w20/mx.png">Mexico (+52)</option>
        <option value="691" data-icon="https://flagcdn.com/w20/fm.png">Micronesia (+691)</option>
        <option value="373" data-icon="https://flagcdn.com/w20/md.png">Moldova (+373)</option>
        <option value="377" data-icon="https://flagcdn.com/w20/mc.png">Monaco (+377)</option>
        <option value="976" data-icon="https://flagcdn.com/w20/mn.png">Mongolia (+976)</option>
        <option value="382" data-icon="https://flagcdn.com/w20/me.png">Montenegro (+382)</option>
        <option value="212" data-icon="https://flagcdn.com/w20/ma.png">Morocco (+212)</option>
        <option value="258" data-icon="https://flagcdn.com/w20/mz.png">Mozambique (+258)</option>
        <option value="95" data-icon="https://flagcdn.com/w20/mm.png">Myanmar (+95)</option>
        <option value="264" data-icon="https://flagcdn.com/w20/na.png">Namibia (+264)</option>
        <option value="674" data-icon="https://flagcdn.com/w20/nr.png">Nauru (+674)</option>
        <option value="977" data-icon="https://flagcdn.com/w20/np.png">Nepal (+977)</option>
        <option value="31" data-icon="https://flagcdn.com/w20/nl.png">Netherlands (+31)</option>
        <option value="64" data-icon="https://flagcdn.com/w20/nz.png">New Zealand (+64)</option>
        <option value="505" data-icon="https://flagcdn.com/w20/ni.png">Nicaragua (+505)</option>
        <option value="227" data-icon="https://flagcdn.com/w20/ne.png">Niger (+227)</option>
        <option value="234" data-icon="https://flagcdn.com/w20/ng.png">Nigeria (+234)</option>
        <option value="850" data-icon="https://flagcdn.com/w20/kp.png">North Korea (+850)</option>
        <option value="389" data-icon="https://flagcdn.com/w20/mk.png">North Macedonia (+389)</option>
        <option value="47" data-icon="https://flagcdn.com/w20/no.png">Norway (+47)</option>
        <option value="968" data-icon="https://flagcdn.com/w20/om.png">Oman (+968)</option>
        <option value="92" data-icon="https://flagcdn.com/w20/pk.png">Pakistan (+92)</option>
        <option value="680" data-icon="https://flagcdn.com/w20/pw.png">Palau (+680)</option>
        <option value="507" data-icon="https://flagcdn.com/w20/pa.png">Panama (+507)</option>
        <option value="675" data-icon="https://flagcdn.com/w20/pg.png">Papua New Guinea (+675)</option>
        <option value="595" data-icon="https://flagcdn.com/w20/py.png">Paraguay (+595)</option>
        <option value="51" data-icon="https://flagcdn.com/w20/pe.png">Peru (+51)</option>
        <option value="63" data-icon="https://flagcdn.com/w20/ph.png">Philippines (+63)</option>
        <option value="48" data-icon="https://flagcdn.com/w20/pl.png">Poland (+48)</option>
        <option value="351" data-icon="https://flagcdn.com/w20/pt.png">Portugal (+351)</option>
        <option value="974" data-icon="https://flagcdn.com/w20/qa.png">Qatar (+974)</option>
        <option value="40" data-icon="https://flagcdn.com/w20/ro.png">Romania (+40)</option>
        <option value="7" data-icon="https://flagcdn.com/w20/ru.png">Russia (+7)</option>
        <option value="250" data-icon="https://flagcdn.com/w20/rw.png">Rwanda (+250)</option>
        <option value="1-869" data-icon="https://flagcdn.com/w20/kn.png">Saint Kitts and Nevis (+1-869)</option>
        <option value="1-758" data-icon="https://flagcdn.com/w20/lc.png">Saint Lucia (+1-758)</option>
        <option value="1-784" data-icon="https://flagcdn.com/w20/vc.png">Saint Vincent and the Grenadines (+1-784)</option>
        <option value="685" data-icon="https://flagcdn.com/w20/ws.png">Samoa (+685)</option>
        <option value="378" data-icon="https://flagcdn.com/w20/sm.png">San Marino (+378)</option>
        <option value="966" data-icon="https://flagcdn.com/w20/sa.png">Saudi Arabia (+966)</option>
        <option value="221" data-icon="https://flagcdn.com/w20/sn.png">Senegal (+221)</option>
        <option value="381" data-icon="https://flagcdn.com/w20/rs.png">Serbia (+381)</option>
        <option value="248" data-icon="https://flagcdn.com/w20/sc.png">Seychelles (+248)</option>
        <option value="232" data-icon="https://flagcdn.com/w20/sl.png">Sierra Leone (+232)</option>
        <option value="65" data-icon="https://flagcdn.com/w20/sg.png">Singapore (+65)</option>
        <option value="421" data-icon="https://flagcdn.com/w20/sk.png">Slovakia (+421)</option>
        <option value="386" data-icon="https://flagcdn.com/w20/si.png">Slovenia (+386)</option>
        <option value="677" data-icon="https://flagcdn.com/w20/sb.png">Solomon Islands (+677)</option>
        <option value="252" data-icon="https://flagcdn.com/w20/so.png">Somalia (+252)</option>
        <option value="27" data-icon="https://flagcdn.com/w20/za.png">South Africa (+27)</option>
        <option value="82" data-icon="https://flagcdn.com/w20/kr.png">South Korea (+82)</option>
        <option value="211" data-icon="https://flagcdn.com/w20/ss.png">South Sudan (+211)</option>
        <option value="34" data-icon="https://flagcdn.com/w20/es.png">Spain (+34)</option>
        <option value="94" data-icon="https://flagcdn.com/w20/lk.png">Sri Lanka (+94)</option>
        <option value="249" data-icon="https://flagcdn.com/w20/sd.png">Sudan (+249)</option>
        <option value="597" data-icon="https://flagcdn.com/w20/sr.png">Suriname (+597)</option>
        <option value="46" data-icon="https://flagcdn.com/w20/se.png">Sweden (+46)</option>
        <option value="41" data-icon="https://flagcdn.com/w20/ch.png">Switzerland (+41)</option>
        <option value="963" data-icon="https://flagcdn.com/w20/sy.png">Syria (+963)</option>
        <option value="886" data-icon="https://flagcdn.com/w20/tw.png">Taiwan (+886)</option>
        <option value="992" data-icon="https://flagcdn.com/w20/tj.png">Tajikistan (+992)</option>
        <option value="255" data-icon="https://flagcdn.com/w20/tz.png">Tanzania (+255)</option>
        <option value="66" data-icon="https://flagcdn.com/w20/th.png">Thailand (+66)</option>
        <option value="670" data-icon="https://flagcdn.com/w20/tl.png">Timor-Leste (+670)</option>
        <option value="228" data-icon="https://flagcdn.com/w20/tg.png">Togo (+228)</option>
        <option value="676" data-icon="https://flagcdn.com/w20/to.png">Tonga (+676)</option>
        <option value="1-868" data-icon="https://flagcdn.com/w20/tt.png">Trinidad and Tobago (+1-868)</option>
        <option value="216" data-icon="https://flagcdn.com/w20/tn.png">Tunisia (+216)</option>
        <option value="90" data-icon="https://flagcdn.com/w20/tr.png">Turkey (+90)</option>
        <option value="993" data-icon="https://flagcdn.com/w20/tm.png">Turkmenistan (+993)</option>
        <option value="688" data-icon="https://flagcdn.com/w20/tv.png">Tuvalu (+688)</option>
        <option value="256" data-icon="https://flagcdn.com/w20/ug.png">Uganda (+256)</option>
        <option value="380" data-icon="https://flagcdn.com/w20/ua.png">Ukraine (+380)</option>
        <option value="971" data-icon="https://flagcdn.com/w20/ae.png">United Arab Emirates (+971)</option>
        <option value="44" data-icon="https://flagcdn.com/w20/gb.png">United Kingdom (+44)</option>
        <option value="598" data-icon="https://flagcdn.com/w20/uy.png">Uruguay (+598)</option>
        <option value="998" data-icon="https://flagcdn.com/w20/uz.png">Uzbekistan (+998)</option>
        <option value="678" data-icon="https://flagcdn.com/w20/vu.png">Vanuatu (+678)</option>
        <option value="379" data-icon="https://flagcdn.com/w20/va.png">Vatican City (+379)</option>
        <option value="58" data-icon="https://flagcdn.com/w20/ve.png">Venezuela (+58)</option>
        <option value="84" data-icon="https://flagcdn.com/w20/vn.png">Vietnam (+84)</option>
        <option value="967" data-icon="https://flagcdn.com/w20/ye.png">Yemen (+967)</option>
        <option value="260" data-icon="https://flagcdn.com/w20/zm.png">Zambia (+260)</option>
        <option value="263" data-icon="https://flagcdn.com/w20/zw.png">Zimbabwe (+263)</option>
    </select>

                     <input type="text" class="form-control codigo_pais_tener" value="{$d['codigo_pais']}" hidden disabled>

                </div>
                <div class="col-6">
                    <input type="text" id="phone" name="phone" class="form-control" value="{$d['telephone_number']}">
                </div>
            </div>
                 
            </div>

        </div>

        <div class="col-md-6">
            <div class="mb-3 h6"><label for="company_id"><span class="h6">{$_L['Owner']}</span></label>

                <select class="form-select" name="owner_id" id="owner_id">
                    {foreach $owners as $owner}
                    <option value="{$owner->id}" {if $owner->id == $d->o}selected{/if} >{$owner->fullname}</option>
                    {/foreach}
                </select>
            </div>

        </div>
    </div>



    {if $config['show_business_number'] eq '1'}

    <div class="mb-3 h6">

        <label for="business_number"><span class="h6">{$config['label_business_number']}</span></label>

        <input type="text" id="business_number" name="business_number" class="form-control" value="{$d['business_number']}">
    </div>

    {/if}

    {if $config['fax_field']}

    <div class="mb-3 h6"><label for="phone"><span class="h6">{$_L['Fax']}</span></label>

        <input type="text" id="fax" name="fax" class="form-control" value="{$d['fax']}">
    </div>

    {/if}


    <div class="mb-3 h6"><label for="address"><span class="h6">{$_L['Address']}</span></label>

        <input type="text" autocomplete="off" list="browsers" id="address" name="address" class="form-control" value="{$d['address']}">

        <ol class="list-group " id="browsers">



        </ol>

    </div>
    <div class="row mt-2">

        <div class="col-md-12">
            <div class="mb-3 h6"><label for="nationality"><span class="h6">Nationality</span></label>
                <select name="nationality" id="nationality" class="form-control nationality">
                    <option value=""><span></span>Select Nationality</option>
                    {$countries}
                </select>
            </div>

        </div>

        <div class="col-md-6">
            <div class="mb-3 h6"><label for="city"><span class="h6">{$_L['City']}</span></label>

                <input type="text" id="city" name="city" class="form-control" value="{$d['city']}">
            </div>

        </div>
        <div class="col-md-6">
            <div class="mb-3 h6"><label for="state"><span class="h6">{$_L['State Region']}</span></label>
                <input type="text" id="state" name="state" class="form-control" value="{$d['state']}">
            </div>

        </div>
    </div>

    <div class="row mt-2">
        <div class="col-md-4">
            <div class="mb-3 h6"><label for="zip"><span class="h6">{$_L['ZIP Postal Code']} </span></label>
                <input type="text" id="zip" name="zip" class="form-control" value="{$d['zip']}">
            </div>
        </div>
        <div class="col-md-8">
            <div class="mb-3 h6"><label for="country"><span class="h6">{$_L['Country']}</span></label>
                <select name="country" id="country" class="form-control">
                    <option value="">{$_L['Select Country']}</option>
                    {$countries}
                </select>
            </div>

        </div>
    </div>



    <div class="row mt-2">
        <div class="col-md-7">
            <div class="mb-3 h6"><label for="group"><span class="h6">{$_L['Group']} </span></label>
                <select class="form-select" name="group" id="group">
                    <option value="0" {if ($d['gid']) eq 0}selected{/if}>{$_L['None']}</option>
                    {foreach $gs as $g}
                    <option value="{$g['id']}" {if ($d['gid']) eq ($g['id'])}selected{/if}>{$g['gname']}</option>
                    {/foreach}
                </select>
            </div>


        </div>
        <div class="col-md-5">
            {if $config['accounting'] eq '1'}

            <div class="mb-3"><label class="col-md-2 control-label h6" for="currency"><span class="h6">{$_L['Currency']}</span></label>
                <select id="currency" name="currency" class="form-control">

                    {foreach $currencies as $currency}
                    <option value="{$currency['id']}"
                    {if ($d['currency']) eq ($currency['id'])}selected="selected" {/if}>{$currency['cname']}</option>
                    {foreachelse}
                    <option value="0">{$config['home_currency']}</option>
                    {/foreach}

                </select>
            </div>

            {/if}
        </div>
    </div>

     

 


    {if $config['client_dashboard'] eq '1'}

    {if $config['customer_custom_username']}

    <div class="mb-3 h6"><label for="username"><span class="h6">{$_L['Username']} </span></label>

        <input type="text" id="username" name="username" class="form-control" value="{$d['username']}">
    </div>


    {/if}


    <div class="mb-3 h6"><label for="password"><span class="h6">{$_L['Password']}</span> </label>

        <input type="password" id="password" name="password" class="form-control" autocomplete="new-password">

        <span class="help-block text-info h6">{$_L['password_change_help']}</span>
    </div>

    {/if}



    {foreach $fs as $f}
    <div class="mb-3"><label for="cf{$f['id']}">{$f['fieldname']}</label>
        {if ($f['fieldtype']) eq 'text'}


        <input type="text" id="cf{$f['id']}" name="cf{$f['id']}" class="form-control" value="{if get_custom_field_value($f['id'],$d['id']) neq ''} {get_custom_field_value($f['id'],$d['id'])}{/if}">
        {if ($f['description']) neq ''}
        <span class="help-block">{$f['description']}</span>
        {/if}

        {elseif ($f['fieldtype']) eq 'password'}

        <input type="password" id="cf{$f['id']}" name="cf{$f['id']}" class="form-control" value="{if get_custom_field_value($f['id'],$d['id']) neq ''} {get_custom_field_value($f['id'],$d['id'])}{/if}">
        {if ($f['description']) neq ''}
        <span class="help-block">{$f['description']}</span>
        {/if}

        {elseif ($f['fieldtype']) eq 'dropdown'}
        <select id="cf{$f['id']}" name="cf{$f['id']}" class="form-control">
            {foreach explode(',',$f['fieldoptions']) as $fo}
            <option value="{$fo}" {if get_custom_field_value($f['id'],$d['id']) eq $fo} selected="selected" {/if}>{$fo}</option>
            {/foreach}
        </select>
        {if ($f['description']) neq ''}
        <span class="help-block">{$f['description']}</span>
        {/if}

        {elseif ($f['fieldtype']) eq 'textarea'}

        <textarea id="cf{$f['id']}" name="cf{$f['id']}" class="form-control" rows="3">{if get_custom_field_value($f['id'],$d['id']) neq ''} {get_custom_field_value($f['id'],$d['id'])}{/if}</textarea>
        {if ($f['description']) neq ''}
        <span class="help-block">{$f['description']}</span>
        {/if}

        {else}
        {/if}
    </div>
    {/foreach}

    <div class="mb-3"><label for="cid"><span class="h6">{$_L['Type']}</span> </label>

        <div class="checkbox">
            <label>
                <input type="checkbox" class="custom-checkbox" name="customer" value="Customer" {if $d->type == 'Customer,Supplier' || $d->type == 'Customer' } checked {/if}>
                {$_L['Customer']}
            </label>
        </div>

        {if $config['suppliers'] eq '1'}
        <div class="checkbox">
            <label>
                <input type="checkbox" class="custom-checkbox" name="supplier" value="Supplier"  {if $d->type == 'Customer,Supplier' || $d->type == 'Supplier' } checked {/if}>
                {$_L['Supplier']}
            </label>
        </div>
        {/if}
    </div>

    <div class="mb-3"><label for="tags"><span class="h6">{$_L['Tags']}</span></label>

        <select name="tags[]" id="tags"  class="form-control" multiple="multiple">
            {foreach $tags as $tag}
            <option value="{$tag['text']}" {if in_array($tag['text'],$dtags)}selected="selected"{/if}>{$tag['text']}</option>
            {/foreach}

        </select>
    </div>

    <div class="row mt-2">
        <div class="col-md-12">
            <div class="mb-3 h6"><label for="position"><span class="h6">Position</span></label>

                <input type="text" id="position" name="position" class="form-control" value="{$d['position']}">
            </div>

        </div>
       
    </div>

    <div class="row mt-2">
        <div class="col-md-12">
            <div class="mb-3 h6"><label for="notas"><span class="h6">Notes</span></label>
                <textarea class="form-control notas" id="notas" name="notas" rows="3" value="{$d['notas']}" >{$d['notas']}</textarea>
            </div>
        </div>
    
    </div>

    {*informacion general*}
    <div class="col-md-12">
        <div class="panel" style=" box-shadow: none; ">
            <div class="panel-hdr">
                <h2>Add company</h2>
            </div>
            <div class="panel-container show"   style=" border-radius: 18px; ">
                <div class="panel-content" style=" padding-bottom: 0px; ">
                
                    <div class="row">
                    
                        <div class="col-12 col-md-8 col-sm-8 col-lg-9">
                            <div class="mb-3 row">
                                <label
                                    for="tipo_identificacion_ig"
                                    class="col-sm-3"
                                    ><span class="h6">Company</span
                                    ><span class="text-danger">*</span></label
                                >
                                <div class="col-sm-9">
                                    <select id="compania" name="compania" class="form-control compania">
                                        <option value="">Select a company</option>
                                        {foreach $companies as $company}
                                        <option value="{$company['id']}" {if $c_selected_id eq ($company['id'])}selected{/if}>
                                            {$company['company_name']}
                                        </option>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-4 col-sm-4 col-lg-3 quitar_margin_pading">
                            <button
                                type="button"
                                class="btn btn-sm btn-success waves-effect waves-themed guardar_tabla_compania" 
                                style=" float: inline-end;  "
                            >
                                Add information
                            </button>
                        </div>

                    </div>

                </div>

            </div>
            <div class="row quitar_margin_pading">
                
                <div class="col-12 quitar_margin_pading">
                    <div class="table-responsive" style=" border-radius: 5px; ">
                        <table
                            class="table table-striped table-hover estilosTabla"
                            id="clx_datatable"
                            style="margin: 0px"
                        >
                            <thead>
                            <tr>
                                <th class="centrar">Company</th>
                            
                                <th class="centrar"></th>
                            </tr>
                            </thead>
                            <tbody class="tbody_envios_identificador">
                            <tr><th colspan="4" class="centrar " style=" text-align: center; "> No information</th></tr>
        
                            </tbody>
                        </table>
                    </div>
                </div>
                
            </div>

            </div>
        </div>
    </div>
    {*fin tabla*}

    <div class="mb-3">
        <button style=" float: inline-end; " class="btn btn-primary" type="submit" id="submit"><i class="fal fa-check"></i> {$_L['Submit']}</button>
    </div>

    <input type="hidden" name="fcid" id="fcid" value="{$d['id']}">


</form>

 
{literal}
<script>
function generateUUIDv4() {
    // Generar un prefijo único basado en microsegundos
    const time_low = Date.now().toString(16).padStart(8, '0') + Math.random().toString(16).slice(2, 6);

    // Generar 8 bytes aleatorios
    const array = new Uint8Array(8);
    crypto.getRandomValues(array);
    const extra_bytes = Array.from(array, byte => byte.toString(16).padStart(2, '0')).join('');

    // Unir las partes y crear el UUID v4
    const uuid = [
        time_low.slice(0, 8),
        time_low.slice(8, 12),
        '4' + extra_bytes.slice(0, 3),
        ((parseInt(extra_bytes.slice(3, 7), 16) & 0x3fff) | 0x8000).toString(16),
        extra_bytes.slice(7, 12) + Math.random().toString(16).slice(2, 7)
    ].join('-');

    return uuid;
}

function uuidToBase64UrlRFC7515(uuid) {
    // Eliminar los guiones del UUID
    const cleanUuid = uuid.replace(/-/g, '');

    // Convertir el UUID de hexadecimal a binario
    const binaryUuid = new Uint8Array(cleanUuid.match(/.{1,2}/g).map(byte => parseInt(byte, 16)));

    // Convertir el binario a Base64
    const base64 = btoa(String.fromCharCode(...binaryUuid));

    // Convertir Base64 a formato URL-safe (RFC 7515)
    const base64Url = base64.replace(/\+/g, '-').replace(/\//g, '_').replace(/=/g, '');

    return base64Url;
}

function isEmpty(value) {

    // Verificar si es nulo o indefinido
    if (value === null || value === undefined) return true;

    // Verificar si es una cadena
    if (typeof value === 'string') {
       return value.trim().length === 0;
    }

    // Verificar si es un arreglo
    if (Array.isArray(value)) {
       return value.length === 0;
    }

    // Verificar si es un objeto
    if (typeof value === 'object') {
       return Object.keys(value).length === 0;
    }

    // Para otros tipos (número, booleano, función), ajusta según tus necesidades
    return false;
 
    // Verifica si el valor es nulo, indefinido, o una cadena vacía (después de eliminar espacios)
    //return value === null || value === undefined || value === "";
}


</script>
{/literal}

{block name="script"}
<script>
 
        

        // Formatear la opción para mostrar la bandera y el nombre del país
        function formatOption(option) {
            if (!option.id) {
                return option.text; // Placeholder o texto por defecto
            }
            const $option = $(
                '<span>' +
                '<img src="' + option.element.dataset.icon + '" class="img-flag" style="width: 20px; margin-right: 8px; vertical-align: middle;" />' +
                option.text +
                '</span>'
            );
            return $option;
        }

        // Función para permitir búsqueda por nombre del país
        function matchCustom(params, data) {
           if (!params.term || params.term.trim() === '') {
              return data;
           }
           const term = params.term.toLowerCase();
           if (data.text.toLowerCase().indexOf(term) > -1) {
              return data;
           }
           return null;
        }

        //$('#codigo_pais').html(options);

        $('#codigo_pais').select2({
        templateResult: formatOption,
        templateSelection: formatOption,
        matcher: matchCustom,
        dropdownParent: $('#codigo_pais').parent() // Asegura que el dropdown se alinee con el contenedor padre
        }).on('select2:open', function() {
        $('.select2-container--open .select2-dropdown').css('z-index', '1060'); // Ajusta este valor según el z-index del modal
        });

        $nationality = $("#nationality");

        $nationality.select2();

        $("#codigo_pais").val($(".codigo_pais_tener").val()).trigger('change');
        $("#nationality").val($(".nacionalidad_tener").val()).trigger('change');


    function serach_address(address,secundary,option = 1) {
      var country = $('#country').val();
      let x=address.trim();
      if (x.length > 2 && country === "United States") {
        var settings = {
          "url": "https://us-autocomplete-pro.api.smarty.com/lookup?key=188805315395749398&search="+address+"&selected="+secundary+"&include_only_cities=&include_only_states=&include_only_zip_codes=&exclude_states=&prefer_cities=&prefer_states=&prefer_zip_codes=&source=all",
          "method": "GET",
          "timeout": 0,
          "headers": {
            "Host": "us-autocomplete-pro.api.smarty.com",
            "Referer": "https://hispanosdeexitollc.com"
        },
    };
    $('#browsers').html('');
    $('#browsers').show();
    $.ajax(settings).done(function (response) {

      $.each(response.suggestions, function (k, v) {
        let text=v.street_line+' '+v.secondary+' '+v.city+', '+v.state+' '+v.zipcode;
        let line=v.street_line+' '+v.secondary+' ('+v.entries+') '+v.city+', '+v.state+' '+v.zipcode;
        let line2=v.street_line+' '+v.secondary;
        let entries=(v.entries > 1) ? '<a href="#" data-data1="'+line+'" data-data2="'+line2+'" class="addresssec"><span class="badge bg-primary rounded-pill">+ '+v.entries+' Address</span></a>' : "" ;
        let option='<li class="list-group-item d-flex justify-content-between align-items-start "><div class="ms-2 me-auto address1" data-data1="'+v.city+'" data-data2="'+v.state+'" data-data3="'+v.zipcode+'" data-data4="'+v.street_line+' '+v.secondary+'"><div class="fw-bold">'+text+'</div></div>'+entries+'</li>';
        $('#browsers').append(option);
        x++;
    });
  });
}
}


$("input[name='address']").on('input', function(e){
  var address = $(this).val();
  var country = $('#country').val();
  let x=address.trim();
  if (x.length > 2 && country === "United States") {
    address = address.replace(/,/g, "");
    address = address.replace(/ /g, "+");
    address = address.replace(/#/g, "%23");
    serach_address(address,"",1);    
}
});


$(document).on('click', '.address1', function(e){
    e.preventDefault();
    $('#city').val($(this).data('data1'));
    $('#state').val($(this).data('data2'));
    $('#zip').val($(this).data('data3'));
    $('#address').val($(this).data('data4'));
    $('#browsers').hide();

});


$(document).on('click', '.addresssec', function(e){
    e.preventDefault();
    let address=$(this).data('data2');
    $('#address').val(address);
    let secundary=$(this).data('data1');
    secundary = secundary.replace(/,/g, "");
    secundary = secundary.replace(/ /g, "+");
    secundary = secundary.replace(/#/g, "%23");
    address = address.replace(/,/g, "");
    address = address.replace(/ /g, "+");
    address = address.replace(/#/g, "%23");
    serach_address(address,secundary,2);
});

$(document).ready(function () {

    var compania_ = $('.compania');
    compania_.select2();

    var arrCompania = [];
    var arrCompaniaBackend = [];
    var arrCompaniaEliminados = [];

    const tomarContactos = $('.tener_compania').text();
    //console.log(tomarContactos);

    try {
        
        if(!isEmpty(tomarContactos))
        {
            let parsearContacto = JSON.parse(tomarContactos);

            if (Array.isArray(parsearContacto)) {
                arrCompania = parsearContacto || [];

                console.log("arrCompania");
                console.log(arrCompania);
            }
        }

    } catch (error) {
        console.error('Error al parsear los compania:', error);
    }

    const tomarMiCompanias = $('.micompanias').text();

    try {
        
        if(!isEmpty(tomarMiCompanias))
        {
            let parsearMiCompania = JSON.parse(tomarMiCompanias);

            if (Array.isArray(parsearMiCompania)) {
                arrCompaniaBackend = parsearMiCompania || [];

                console.log("arrCompaniaBackend");
                console.log(arrCompaniaBackend);

                $(".tbody_envios_identificador").html(tabla_html_identificador(arrCompaniaBackend));
                eventosTablaIdentificador();
            }
        }

    } catch (error) {
        console.error('Error al parsear los mis compania:', error);
    }
     

    $(".guardar_tabla_compania").click(function(e){

        const selectedValue = $('#compania').val();
        const selectedText = $('#compania option:selected').text();

        // Verificar que se haya seleccionado una opción válida
        if (!isEmpty(selectedValue)) {
            //console.log('Valor:', selectedValue);
            //console.log('Texto:', selectedText);

            const findCompany = arrCompania.find((data) => data.id == selectedValue  )

            //console.log(arrCompania)
           
            if(findCompany)
            {
                let existeData = arrCompaniaBackend.find((data) => data.idCompany == selectedValue  );

                if(existeData)
                {
                    toastr.error(
                        "The company has already been added to the table",
                    );   
                    return;
                }

                let UUID = generateUUIDv4();
                let UUID_ENC = uuidToBase64UrlRFC7515(UUID);

                const informacion = {
                    UUID:UUID,
                    UUID_ENC:UUID_ENC,
                    idCompany: selectedValue,
                    nameCompany: findCompany.company_name,
                    accion: "guardar",
                };

                arrCompaniaBackend.push(informacion);

                $(".tbody_envios_identificador").html(tabla_html_identificador(arrCompaniaBackend));
                eventosTablaIdentificador();

                $('#compania').val("").trigger("change");

                //console.log("informacion");
                //console.log(informacion);
            }

           return;
        }

        toastr.error(
            "The company field is required",
            "Select a company",
        );

    });

    function tabla_html_identificador(arreglo) {
        let html = "";
        
        arreglo.forEach(function (element) {

            let {
                UUID,
                UUID_ENC,
                idCompany,
                nameCompany,
            } = element;
    

            html +=
                "<tr>" +
                "<td class='centrar'>" + nameCompany + "</td>" +
     
                "<td class='centrar'>" +
                "<div class='row'>" +
                "<div class='col-12 centrar-botones'>" +
     
                "<button type='button' class='btn btn-sm btn-eliminar waves-effect waves-themed' data-id='" + UUID_ENC + "'>" +
                "<i class='fas fa-trash tamano-icono' aria-hidden='true'></i>" +
                "</button>" +
                "</div>" +
                "</div>" +
                "</td>" +

                "</tr>";
        });

        return html;
    }

    function eventosTablaIdentificador()
    {
        $('.btn-eliminar').off('click');

        $('.btn-eliminar').on('click', function() {
            var dataId = $(this).data('id');
            console.log('ID de la referencia:', dataId);
    
            Swal.fire({
                title: "You are sure?",
                text: "Are you sure you want to delete a record?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Delete',
                cancelButtonText: 'Close'
            }).then((result) => {
                if (result.isConfirmed) {
                    console.log('producto eliminado');     
                    
                    let infoEncontrada = arrCompaniaBackend.find((data) => data.UUID_ENC == dataId);

                    if(infoEncontrada)
                    {
                        arrCompaniaBackend = arrCompaniaBackend.filter((data) => data.UUID_ENC != dataId);

                        arrCompaniaEliminados.push(infoEncontrada.id);

                        $(".tbody_envios_identificador").html(tabla_html_identificador(arrCompaniaBackend));
                        eventosTablaIdentificador();
                    }
                     

                }
            });
 
        });
        

    }

    $("#submit").click(function (e) {
        e.preventDefault();

        var _url = $("#_url").val();

        var base_url = _url;

        let valor_grupo =  $("#group").val();

        //console.log("_url");
        //console.log(_url);

        if(isEmpty(valor_grupo))
        {

            var body = $("html, body");
            //body.animate({ scrollTop:0 }, '1000', 'swing');
            //$("#emsgbody").html('Please select a group');
            //$("#emsg").show("slow");
            Swal.fire({
                icon: "error",
                title: "Oops...",
                text: "Please select a group",
            });
            return;
        }

        if(valor_grupo == 0 || valor_grupo == "0")
        {
            //var body = $("html, body");
            //body.animate({ scrollTop:0 }, '1000', 'swing');
            //$("#emsgbody").html('Please select a group');
            //$("#emsg").show("slow");
            Swal.fire({
                icon: "error",
                title: "Oops...",
                text: "Please select a group",
            });
            return;
        }

        //console.log("aada");
        //return;

        var formData = $("#rform").serializeArray();
        formData.push({
            name: "companies",
            value: JSON.stringify( arrCompaniaBackend )
        });

        formData.push({
            name: "companies_deletes",
            value: JSON.stringify( arrCompaniaEliminados )
        });

        //console.log("valor_grupo");
        //console.log($( "#rform" ).serialize());
        //console.log("formData");
        //console.log($.param(formData));
        //return;

        $('#ibox_form').block({ message:block_msg });
        $.post(base_url + 'contacts/edit-post/', $.param(formData))
        //$.post(base_url + 'contacts/add-post/', $( "#rform" ).serialize())
        .done(function (data) {

            //console.log(data);
            //return;

            var sbutton = $("#submit");
            if ($.isNumeric(data)) {

                window.location = _url + 'contacts/view/' + data + '/edit/';
            }
            else {
                $('#ibox_form').unblock();
                var body = $("html, body");
                body.animate({ scrollTop:0 }, '1000', 'swing');
                $("#emsgbody").html(data);
                $("#emsg").show("slow");
                
            }
        });
    });


});


</script>
{/block}