<input
     type="text"
     value="{$url_base}"
     disabled
     hidden
     id="URL_BASE"
/>

   
<input
     type="text"
     value="{$id_user}"
     id="ID_USER"
     disabled
     hidden
/>

<input
     type="text"
     value="{$customer_id}"
     disabled
     hidden
     id="CUSTOMER_ID"
/>
 

<div id="payment-methods-app" class="client-view" v-cloak>

   <header class="client-header">
      <h1>Payment Methods</h1>
      <p>Specify the payment method for installments (Automatic debit for payment of installments)</p>
   </header>

   <div class="client-body">

      <div class="block">
         <div class="block-header">
            <h2 class="block-title">Payment Method</h2>
         </div>
         <div class="block-body">
            <form id="payment-method-form" @submit.prevent="savePaymentMethod">
               <input type="hidden" v-model="form.id">
               <input type="hidden" v-model="form.uuid_enc">

               <div class="form-row">
                  <div class="form-group">
                     <label>Account type <span class="text-danger">*</span></label>
                     <select v-model="form.tipo_cuenta" class="form-control" @change="handleAccountTypeChange">
                        <option value="" disabled>Select a option</option>
                        <option v-for="type in accountTypes" :key="type.id" :value="String(type.id)">
                           {{ type.descripcion }}
                        </option>
                     </select>
                  </div>
                  <div class="form-group" v-if="isCreditCard">
                     <label>Payment gateway type <span class="text-danger">*</span></label>
                     <select v-model="form.tipo_pasarela_pago" class="form-control">
                        <option value="Stripe">Stripe</option>
                        <option value="Square">Square</option>
                     </select>
                  </div>
               </div>

               <div class="form-row" v-if="showGatewaySelect">
                  <div class="form-group">
                     <label>General payment gateway <span class="text-danger">*</span></label>
                     <select v-model="form.configuracion_stripe_id" class="form-control">
                        <option value="" disabled>Select a option</option>
                        <option v-for="gw in filteredGateways" :key="gw.id" :value="String(gw.id)">
                           {{ formatGatewayLabel(gw) }}
                        </option>
                     </select>
                  </div>
               </div>

               <div class="form-row" v-if="showDefaultFields">
                  <div class="form-group">
                     <label>{{ isBankAccount ? 'Account Holder' : 'Card name' }} <span class="text-danger">*</span></label>
                     <input type="text" v-model="form.titular_tarjeta" class="form-control" placeholder="John Doe">
                  </div>
                  <div class="form-group" v-if="isBankAccount">
                     <label>Bank <span class="text-danger">*</span></label>
                     <input type="text" v-model="form.banco_metodo_pago" class="form-control">
                  </div>
               </div>

               <div class="form-row" v-if="isBankAccount">
                  <div class="form-group">
                     <label>Account number <span class="text-danger">*</span></label>
                     <input type="text" v-model="form.numero_cuenta_metodo_pago" class="form-control">
                  </div>
                  <div class="form-group">
                     <label>Route number <span class="text-danger">*</span></label>
                     <input type="text" v-model="form.numero_ruta_metodo_pago" class="form-control">
                  </div>
               </div>

               <div class="form-row" v-if="isBankAccount">
                  <div class="form-group">
                     <label>Account Holder Type <span class="text-danger">*</span></label>
                     <select v-model="form.tipo_titular_metodo_pago" class="form-control">
                        <option value="" disabled>Select a option</option>
                        <option value="individual">Individual</option>
                        <option value="company">Company</option>
                     </select>
                  </div>
                  <div class="form-group">
                     <label>Email <span class="text-danger">*</span></label>
                     <input type="text" v-model="form.email_metodo_pago" class="form-control">
                  </div>
               </div>

               <div class="form-row" v-if="isCreditCard && !useStripeElement">
                  <div class="form-group">
                     <label>Card number <span class="text-danger">*</span></label>
                     <input type="text" v-model="form.numero_tarjeta" class="form-control" placeholder="4242424242424242">
                  </div>
                  <div class="form-group">
                     <label>CCV <span class="text-danger">*</span></label>
                     <input type="text" v-model="form.codigo_ccv" placeholder="123" class="form-control">
                  </div>
               </div>

               <div class="form-row" v-if="isCreditCard && !useStripeElement">
                  <div class="form-group">
                     <label>Expiration month <span class="text-danger">*</span></label>
                     <select v-model="form.exp_month" class="form-control">
                        <option value="" disabled>Select a Option</option>
                        <option value="1">January</option>
                        <option value="2">February</option>
                        <option value="3">March</option>
                        <option value="4">April</option>
                        <option value="5">May</option>
                        <option value="6">June</option>
                        <option value="7">July</option>
                        <option value="8">August</option>
                        <option value="9">September</option>
                        <option value="10">October</option>
                        <option value="11">November</option>
                        <option value="12">December</option>
                     </select>
                  </div>
                  <div class="form-group">
                     <label>Year of expiration <span class="text-danger">*</span></label>
                     <select v-model="form.exp_year" class="form-control">
                        <option value="" disabled>YYYY</option>
                        <option v-for="year in expirationYears" :key="year" :value="String(year)">
                           {{ year }}
                        </option>
                     </select>
                  </div>
               </div>

               <div class="form-row" v-if="useStripeElement">
                  <div class="form-group">
                     <label>Card <span class="text-danger">*</span></label>
                     <div id="stripe-card-element"></div>
                  </div>
               </div>

               <div class="form-row" v-if="showDefaultFields">
                  <div class="form-group">
                     <label>Payment method status <span class="text-danger">*</span></label>
                     <select v-model="form.estado_id" class="form-control">
                        <option value="" disabled>Select a Option</option>
                        <option value="1">Active</option>
                        <option value="2">Inactive</option>
                     </select>
                  </div>
                  <div class="form-group">
                     <label>Set as default payment method <span class="text-danger">*</span></label>
                     <select v-model="form.use_credit_card" class="form-control">
                        <option value="" disabled>Select a Option</option>
                        <option value="1">Predetermined</option>
                        <option value="2">Secondary</option>
                     </select>
                  </div>
               </div>

               <div class="form-actions">
                  <button class="ui-button primary" type="submit" :disabled="savingPaymentMethod">
                     {{ editMode ? 'Modify' : 'Save' }}
                  </button>
                  <button class="ui-button secondary" type="button" v-if="editMode" @click="resetForm" :disabled="savingPaymentMethod">
                     Cancel
                  </button>
               </div>
            </form>
         </div>
      </div>

      <div class="block">
         <div class="block-header">
            <h2 class="block-title">Payment Methods List</h2>
         </div>
         
         <div class="block-body">
            <div v-if="loading && paymentMethodRows.length === 0" class="loading-state">
                  <div>Loading...</div>
            </div>
            
            <div v-else-if="paymentMethodRows.length === 0" class="empty-state">
                  <i class="fal fa-calendar-times"></i>
                  <p>No payment methods</p>
            </div>

            <div v-else>
                  <table class="payment-table">
                     <thead>
                        <tr>
                              <th>Type</th>
                              <th>Payment gateway</th>
                              <th>Bank</th>
                              <th>Last 4 digits</th>
                              <th>State</th>
                              <th>Stripe default</th>
                              <th>Verified</th>
                              <th>Actions</th>
                        </tr>
                     </thead>
                     <tbody>
                        <tr v-for="pm in paymentMethodRows" :key="pm.UUID_ENC || pm.id" @click="editPaymentMethod(pm)" class="clickable-row">
                              <td>{{ pm.nombre_tipo_cuenta }}</td>
                              <td>{{ pm.tipo_pasarela_pago }}</td>
                              <td>{{ pm.banco_metodo_pago }}</td>
                              <td>{{ pm.last_4_digits || (pm.numero_tarjeta ? pm.numero_tarjeta.slice(-4) : "") }}</td>
                              <td>{{ pm.estado_nombre }}</td>
                              <td>
                                 <span v-if="isStripeDefault(pm)" class="status-badge active">Default</span>
                                 <span v-else class="status-badge failed">Secondary</span>
                              </td>
                              <td>
                                 <span v-if="isVerified(pm)" class="status-badge active">Verified</span>
                                 <span v-else class="status-badge failed">Not Verified</span>
                              </td>
                              <td>
                                 <div class="action-buttons">
                                    <button v-if="showAddCode(pm)" class="ui-button secondary btn-add-code" title="Add code" @click.stop="promptVerificationCode(pm)">
                                       Verify code
                                    </button>
                                    <button v-if="canSetStripeDefault(pm)" class="ui-button secondary" title="Set default" @click.stop="setStripeDefault(pm)">
                                       Set default
                                    </button>
                                    <a v-if="canEdit(pm)" class="btn btn-light border" title="Edit" @click.stop.prevent="editPaymentMethod(pm)">
                                       <svg class="fill-current" width="24" height="24" viewBox="0 0 21 21" fill="#667085" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.0911 3.53206C16.2124 2.65338 14.7878 2.65338 13.9091 3.53206L5.6074 11.8337C5.29899 12.1421 5.08687 12.5335 4.99684 12.9603L4.26177 16.445C4.20943 16.6931 4.286 16.9508 4.46529 17.1301C4.64458 17.3094 4.90232 17.3859 5.15042 17.3336L8.63507 16.5985C9.06184 16.5085 9.45324 16.2964 9.76165 15.988L18.0633 7.68631C18.942 6.80763 18.942 5.38301 18.0633 4.50433L17.0911 3.53206ZM14.9697 4.59272C15.2626 4.29982 15.7375 4.29982 16.0304 4.59272L17.0027 5.56499C17.2956 5.85788 17.2956 6.33276 17.0027 6.62565L16.1043 7.52402L14.0714 5.49109L14.9697 4.59272ZM13.0107 6.55175L6.66806 12.8944C6.56526 12.9972 6.49455 13.1277 6.46454 13.2699L5.96704 15.6283L8.32547 15.1308C8.46772 15.1008 8.59819 15.0301 8.70099 14.9273L15.0436 8.58468L13.0107 6.55175Z" fill=""></path></svg>
                                    </a>

                                    <a title="Delete" href="javascript:;" class="btn btn-light border" @click.stop.prevent="confirmDelete(pm)">
                                       <svg class="cursor-pointer hover:fill-error-500 dark:hover:fill-error-500 fill-gray-700 dark:fill-gray-400" width="20" height="20" viewBox="0 0 20 20" fill="#667085" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M6.54142 3.7915C6.54142 2.54886 7.54878 1.5415 8.79142 1.5415H11.2081C12.4507 1.5415 13.4581 2.54886 13.4581 3.7915V4.0415H15.6252H16.666C17.0802 4.0415 17.416 4.37729 17.416 4.7915C17.416 5.20572 17.0802 5.5415 16.666 5.5415H16.3752V8.24638V13.2464V16.2082C16.3752 17.4508 15.3678 18.4582 14.1252 18.4582H5.87516C4.63252 18.4582 3.62516 17.4508 3.62516 16.2082V13.2464V8.24638V5.5415H3.3335C2.91928 5.5415 2.5835 5.20572 2.5835 4.7915C2.5835 4.37729 2.91928 4.0415 3.3335 4.0415H4.37516H6.54142V3.7915ZM14.8752 13.2464V8.24638V5.5415H13.4581H12.7081H7.29142H6.54142H5.12516V8.24638V13.2464V16.2082C5.12516 16.6224 5.46095 16.9582 5.87516 16.9582H14.1252C14.5394 16.9582 14.8752 16.6224 14.8752 16.2082V13.2464ZM8.04142 4.0415H11.9581V3.7915C11.9581 3.37729 11.6223 3.0415 11.2081 3.0415H8.79142C8.37721 3.0415 8.04142 3.37729 8.04142 3.7915V4.0415ZM8.3335 7.99984C8.74771 7.99984 9.0835 8.33562 9.0835 8.74984V13.7498C9.0835 14.1641 8.74771 14.4998 8.3335 14.4998C7.91928 14.4998 7.5835 14.1641 7.5835 13.7498V8.74984C7.5835 8.33562 7.91928 7.99984 8.3335 7.99984ZM12.4168 8.74984C12.4168 8.33562 12.081 7.99984 11.6668 7.99984C11.2526 7.99984 10.9168 8.33562 10.9168 8.74984V13.7498C10.9168 14.1641 11.2526 14.4998 11.6668 14.4998C12.081 14.4998 12.4168 14.1641 12.4168 13.7498V8.74984Z" fill=""></path></svg>
                                    </a>

                                 </div>
                              </td>
                        </tr>
                     </tbody>
                  </table>
                  <div class="table-footer">
                     Showing {{ paymentMethodRows.length }} payment method{{ paymentMethodRows.length !== 1 ? 's' : '' }}
                  </div>
            </div>
         </div>

      </div>

   </div>


</div>




<script>
window.PAYMENT_METHODS_CONTACT_NAME = '{$contact_name|default:""|escape:"javascript"}';
</script>
{literal}
<script>
(function () {
   const mountEl = document.getElementById('payment-methods-app');
   if (!mountEl) {
      return;
   }

   if (window.PaymentMethodsApp && typeof window.PaymentMethodsApp.unmount === 'function') {
      window.PaymentMethodsApp.unmount();
   }

   const emptyPaymentMethodForm = () => ({
   id: '',
   uuid_enc: '',
   tipo_cuenta: '',
   tipo_pasarela_pago: 'Stripe',
   configuracion_stripe_id: '',
   titular_tarjeta: '',
   banco_metodo_pago: '',
   numero_cuenta_metodo_pago: '',
   numero_ruta_metodo_pago: '',
   tipo_titular_metodo_pago: '',
   email_metodo_pago: '',
   numero_tarjeta: '',
   codigo_ccv: '',
   exp_month: '',
   exp_year: '',
   estado_id: '',
   use_credit_card: '',
   payment_method: '',
   customer_id: '',
   setup_intent: '',
   verificado: '',
   tipo_verificacion_micro_deposito: ''
});

if (typeof Vue !== 'undefined') {
   const paymentMethodsApp = Vue.createApp({
      data() {
         return {
            appUrl: '',
            contactId: '',
            contactName: window.PAYMENT_METHODS_CONTACT_NAME || '',
            contactEmail: '',
            loading: false,
            savingPaymentMethod: false,
            editMode: false,
            editSnapshot: null,
            paymentMethodRows: [],
            gatewayOptions: [],
            accountTypes: [
               { id: 1, descripcion: 'Savings account' },
               { id: 2, descripcion: 'Checking Account' },
               { id: 3, descripcion: 'Credit Card' }
            ],
            form: emptyPaymentMethodForm(),
            stripeInstance: null,
            stripeElements: null,
            stripePaymentElement: null,
            stripePublishableKey: '',
            stripeCustomerId: '',
            stripeDefaultPaymentMethodId: '',
            stripeReady: false
         };
      },
      computed: {
         isCreditCard() {
            return String(this.form.tipo_cuenta) === '3';
         },
         isBankAccount() {
            const type = String(this.form.tipo_cuenta);
            return type === '1' || type === '2';
         },
         isStripeCard() {
            return this.isCreditCard && String(this.form.tipo_pasarela_pago).toLowerCase() === 'stripe';
         },
         showDefaultFields() {
            return String(this.form.tipo_cuenta) !== '';
         },
         showGatewaySelect() {
            return String(this.form.tipo_cuenta) !== '';
         },
         useStripeElement() {
            return this.isStripeCard && !this.editMode;
         },
         filteredGateways() {
            const processor = this.isCreditCard && String(this.form.tipo_pasarela_pago).toLowerCase() === 'square'
               ? 'square'
               : 'stripe';
            return this.gatewayOptions.filter((gw) => {
               if (!gw.processor) {
                  return true;
               }
               return String(gw.processor).toLowerCase() === processor;
            });
         },
         expirationYears() {
            const start = new Date().getFullYear();
            return Array.from({ length: 15 }, (_, i) => start + i);
         }
      },
      watch: {
         useStripeElement(value) {
            if (value) {
               this.setupStripeElement();
            } else {
               this.unmountStripeElement();
            }
         }
      },
      mounted() {
         this.appUrl = this.resolveAppUrl();
         this.contactId = this.resolveContactId();
         this.loadContactSummary();
         this.loadGateways();
         this.loadPaymentMethodTable();
      },
      methods: {
         resolveAppUrl() {
            const appUrl = document.getElementById('_app_url');
            const urlBase = document.getElementById('URL_BASE');
            const value = (appUrl && appUrl.value) ? appUrl.value : (urlBase ? urlBase.value : '');
            return value ? value.replace(/\/$/, '') : '';
         },
         resolveContactId() {
            const idInput = document.getElementById('CUSTOMER_ID');
            if (idInput && idInput.value) {
               return idInput.value;
            }

            try {
               const url = new URL(window.location.href);
               const ngParam = url.searchParams.get('ng');
               return ngParam ? ngParam.split('/')[2] : '';
            } catch (error) {
               return '';
            }
         },
         async loadContactSummary() {
            if (!this.contactId) {
               return;
            }

            try {
               const response = await fetch(`${this.appUrl}/api/contacts/summary/${this.contactId}`);
               const data = await response.json();
               const customer = data.customer || {};
               if (!this.contactName) {
                  this.contactName = customer.account || '';
               }
               this.contactEmail = customer.email || '';
            } catch (error) {
               console.error('Error loading contact summary:', error);
            }
         },
         async loadGateways() {
            try {
               const response = await fetch(`${this.appUrl}/api/billing/gateways`, {
                  method: 'POST',
                  headers: { 'Content-Type': 'application/json' },
                  body: JSON.stringify({})
               });
               const data = await response.json();
               this.gatewayOptions = data.data || [];
            } catch (error) {
               console.error('Error loading gateways:', error);
            }
         },
         async loadPaymentMethodTable() {
            if (!this.contactId) {
               return;
            }

            this.loading = true;
            try {
               const response = await fetch(`${this.appUrl}/api/contacts/payment-methods/table`, {
                  method: 'POST',
                  headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                  body: new URLSearchParams({ cid: this.contactId })
               });
               const data = await response.json();
               if (data.status === 'success') {
                  this.paymentMethodRows = this.normalizeRows(data.data || []);
                  this.syncStripeCustomerFromRows();
                  await this.loadStripeDefaultPaymentMethod();
               } else {
                  console.error('Payment method table error:', data.message);
               }
            } catch (error) {
               console.error('Error loading payment method table:', error);
            } finally {
               this.loading = false;
            }
         },
         formatGatewayLabel(gateway) {
            const name = gateway.name || '';
            const ident = gateway.identificador ? ` - ${gateway.identificador}` : '';
            return `${name}${ident}`.trim();
         },
         handleAccountTypeChange() {
            if (this.isCreditCard && !this.form.tipo_pasarela_pago) {
               this.form.tipo_pasarela_pago = 'Stripe';
            }
         },
         isVerified(pm) {
            return pm && (pm.verificado === 1 || pm.verificado === '1');
         },
        showAddCode(pm) {
           return pm && pm.tipo_verificacion_micro_deposito === 'descriptor_code' && (pm.verificado === 2 || pm.verificado === '2');
        },
        canSetStripeDefault(pm) {
           return pm && pm.payment_method && !this.isStripeDefault(pm);
        },
        isStripeDefault(pm) {
           return pm && pm.payment_method && this.stripeDefaultPaymentMethodId === pm.payment_method;
        },
        canEdit(pm) {
           if (!pm || !this.isVerified(pm)) {
              return false;
           }
           const isStripeCard = String(pm.tipo_cuenta) === '3' && String(pm.tipo_pasarela_pago).toLowerCase() === 'stripe';
            return !isStripeCard;
         },
         normalizeRows(rows) {
            const typeMap = {
               '1': 'Savings account',
               '2': 'Checking Account',
               '3': 'Credit Card'
            };
            return (rows || []).map((row) => {
               const tipoCuenta = row.tipo_cuenta != null ? String(row.tipo_cuenta) : '';
               const estadoId = row.estado_id != null ? String(row.estado_id) : '';
               const useCreditCard = row.use_credit_card != null ? String(row.use_credit_card) : '';
               return {
                  ...row,
                  nombre_tipo_cuenta: row.nombre_tipo_cuenta || typeMap[tipoCuenta] || '',
                  estado_nombre: row.estado_nombre || (estadoId === '1' ? 'Active' : 'Inactive'),
                  use_credit_card_nombre: row.use_credit_card_nombre || (useCreditCard === '1' ? 'Predetermined' : 'Secondary'),
                  last_4_digits: row.last_4_digits || (row.numero_tarjeta ? String(row.numero_tarjeta).slice(-4) : '')
               };
            });
         },
         generateUUIDv4() {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
               const r = (Math.random() * 16) | 0;
               const v = c === 'x' ? r : (r & 0x3) | 0x8;
               return v.toString(16);
            });
         },
         uuidToBase64UrlRFC7515(uuid) {
            const cleaned = uuid.replace(/-/g, '');
            const bytes = [];
            for (let i = 0; i < cleaned.length; i += 2) {
               bytes.push(parseInt(cleaned.substr(i, 2), 16));
            }
            const binary = String.fromCharCode.apply(null, bytes);
            const base64 = btoa(binary);
            return base64.replace(/\+/g, '-').replace(/\//g, '_').replace(/=+$/, '');
         },
         isEmpty(value) {
            return value === null || value === undefined || String(value).trim() === '';
         },
         isEmail(value) {
            return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(String(value));
         },
         editPaymentMethod(pm) {
            if (!this.canEdit(pm)) {
               return;
            }

            this.editMode = true;
            this.editSnapshot = {
               account: pm.numero_tarjeta || '',
               routing: pm.numero_ruta_metodo_pago || ''
            };
            this.form = {
               ...emptyPaymentMethodForm(),
               id: pm.id || '',
               uuid_enc: pm.UUID_ENC || '',
               tipo_cuenta: pm.tipo_cuenta != null ? String(pm.tipo_cuenta) : '',
               tipo_pasarela_pago: pm.tipo_pasarela_pago || 'Stripe',
               configuracion_stripe_id: pm.configuracion_stripe_id != null ? String(pm.configuracion_stripe_id) : '',
               titular_tarjeta: pm.titular_tarjeta || '',
               banco_metodo_pago: pm.banco_metodo_pago || '',
               numero_cuenta_metodo_pago: pm.numero_tarjeta || '',
               numero_ruta_metodo_pago: pm.numero_ruta_metodo_pago || '',
               tipo_titular_metodo_pago: pm.tipo_titular_metodo_pago || '',
               email_metodo_pago: pm.email_metodo_pago || '',
               numero_tarjeta: pm.numero_tarjeta || '',
               codigo_ccv: pm.codigo_ccv || '',
               exp_month: pm.exp_month != null ? String(pm.exp_month) : '',
               exp_year: pm.exp_year != null ? String(pm.exp_year) : '',
               estado_id: pm.estado_id != null ? String(pm.estado_id) : '',
               use_credit_card: pm.use_credit_card != null ? String(pm.use_credit_card) : '',
               payment_method: pm.payment_method || '',
               customer_id: pm.customer_id || '',
               setup_intent: pm.setup_intent || '',
               verificado: pm.verificado || '',
               tipo_verificacion_micro_deposito: pm.tipo_verificacion_micro_deposito || ''
            };

            this.scrollToForm();
         },
        resetForm() {
           this.editMode = false;
           this.editSnapshot = null;
           this.form = emptyPaymentMethodForm();
           this.unmountStripeElement();
        },
        syncStripeCustomerFromRows() {
           const candidate = this.paymentMethodRows.find((row) => row.customer_id);
           if (candidate && candidate.customer_id) {
              this.stripeCustomerId = candidate.customer_id;
           }
        },
        async loadStripeDefaultPaymentMethod() {
           if (!this.stripeCustomerId) {
              return;
           }

           try {
              const response = await fetch(`${this.appUrl}/api/billing/payment-methods/default/get`, {
                 method: 'POST',
                 headers: { 'Content-Type': 'application/json' },
                 body: JSON.stringify({ stripe_customer_id: this.stripeCustomerId })
              });
              const data = await response.json();
              this.stripeDefaultPaymentMethodId = data.payment_method_id || '';
           } catch (error) {
              console.error('Error loading default payment method:', error);
           }
        },
         scrollToForm() {
            const form = document.getElementById('payment-method-form');
            if (form) {
               form.scrollIntoView({ behavior: 'smooth', block: 'start' });
            }
         },
         async ensureStripeCustomer() {
            if (this.stripeCustomerId) {
               return this.stripeCustomerId;
            }

            await this.loadContactSummary();
            const response = await fetch(`${this.appUrl}/api/billing/customers`, {
               method: 'POST',
               headers: { 'Content-Type': 'application/json' },
               body: JSON.stringify({
                  crm_customer_id: this.contactId,
                  email: this.contactEmail,
                  name: this.contactName
               })
            });
            const data = await response.json();
            if (!data.stripe_customer_id) {
               throw new Error(data.error || 'Stripe customer not available');
            }
            this.stripeCustomerId = data.stripe_customer_id;
            return this.stripeCustomerId;
         },
         async ensureStripePublishableKey() {
            if (this.stripePublishableKey) {
               return this.stripePublishableKey;
            }

            const response = await fetch(`${this.appUrl}/api/billing/config`, {
               method: 'POST',
               headers: { 'Content-Type': 'application/json' },
               body: JSON.stringify({})
            });
            const data = await response.json();
            if (!data.publishable_key) {
               throw new Error('Stripe publishable key missing');
            }
            this.stripePublishableKey = data.publishable_key;
            return this.stripePublishableKey;
         },
         async setupStripeElement() {
            if (!this.useStripeElement || this.stripeReady) {
               return;
            }

            try {
               if (typeof Stripe === 'undefined') {
                  throw new Error('Stripe.js is not available');
               }

               const stripeCustomerId = await this.ensureStripeCustomer();
               await this.ensureStripePublishableKey();

               const response = await fetch(`${this.appUrl}/api/billing/setup-intents`, {
                  method: 'POST',
                  headers: { 'Content-Type': 'application/json' },
                  body: JSON.stringify({ stripe_customer_id: stripeCustomerId })
               });
               const data = await response.json();
               if (!data.client_secret) {
                  throw new Error(data.error || 'Setup intent failed');
               }

               this.unmountStripeElement();

               if (!this.stripeInstance) {
                  this.stripeInstance = Stripe(this.stripePublishableKey);
               }

               this.stripeElements = this.stripeInstance.elements({ clientSecret: data.client_secret });
               this.stripePaymentElement = this.stripeElements.create('payment');
               await this.$nextTick();
               this.stripePaymentElement.mount('#stripe-card-element');
               this.stripeReady = true;
            } catch (error) {
               console.error('Stripe element init error:', error);
               if (typeof toastr !== 'undefined') {
                  toastr.error(error.message || 'Stripe initialization failed');
               }
            }
         },
         unmountStripeElement() {
            if (this.stripePaymentElement) {
               this.stripePaymentElement.unmount();
            }
            this.stripePaymentElement = null;
            this.stripeElements = null;
            this.stripeReady = false;
         },
         shouldRefreshBankSetup() {
            if (!this.isBankAccount) {
               return false;
            }
            if (!this.editMode) {
               return true;
            }
            if (!this.editSnapshot) {
               return true;
            }
            return this.form.numero_cuenta_metodo_pago !== this.editSnapshot.account
               || this.form.numero_ruta_metodo_pago !== this.editSnapshot.routing;
         },
        async createBankAccountSetup() {
           const response = await fetch(`${this.appUrl}/api/billing/payment-methods/bank-setup`, {
              method: 'POST',
              headers: { 'Content-Type': 'application/json' },
              body: JSON.stringify({
                  crm_customer_id: this.contactId,
                  name: this.form.titular_tarjeta,
                  email: this.form.email_metodo_pago,
                  account_number: this.form.numero_cuenta_metodo_pago,
                  routing_number: this.form.numero_ruta_metodo_pago,
                  account_holder_type: this.form.tipo_titular_metodo_pago,
                  configuracion_stripe_id: this.form.configuracion_stripe_id
               })
            });
            const data = await response.json();
           if (!data.setup_intent) {
              throw new Error(data.error || 'Bank account setup failed');
           }
           return data;
        },
        async setStripeDefault(pm, updateCrm = true) {
           if (!pm || !pm.payment_method) {
              return;
           }

           const stripeCustomerId = pm.customer_id || this.stripeCustomerId;
           if (!stripeCustomerId) {
              if (typeof toastr !== 'undefined') toastr.error('Stripe customer not found.');
              return;
           }

           try {
              const response = await fetch(`${this.appUrl}/api/billing/payment-methods/default`, {
                 method: 'POST',
                 headers: { 'Content-Type': 'application/json' },
                 body: JSON.stringify({
                    stripe_customer_id: stripeCustomerId,
                    payment_method_id: pm.payment_method
                 })
              });
              const data = await response.json();
              if (data.ok) {
                 this.stripeDefaultPaymentMethodId = pm.payment_method;
                 if (updateCrm) {
                    await this.syncCrmDefault(pm);
                 }
                 if (typeof toastr !== 'undefined') toastr.success('Default payment method updated');
              } else if (typeof toastr !== 'undefined') {
                 toastr.error(data.error || 'Unable to set default');
              }
           } catch (error) {
              console.error('Error setting default payment method:', error);
              if (typeof toastr !== 'undefined') toastr.error('Unable to set default');
           }
        },
        async syncCrmDefault(pm) {
           const rows = this.paymentMethodRows.map((row) => ({
              ...row,
              use_credit_card: String(row.id) === String(pm.id) ? '1' : '2'
           }));

           const response = await fetch(`${this.appUrl}/api/contacts/post-payment-method-customer`, {
              method: 'POST',
              headers: { 'Content-Type': 'application/json' },
              body: JSON.stringify({
                 customer_id: this.contactId,
                 arreglo_planes: rows,
                 eliminar_metodo_pagos: []
              })
           });
           const data = await response.json();
           if (data.type === 'success') {
              this.paymentMethodRows = this.normalizeRows(data.data_credit_plan_payment_method || []);
           }
        },
         buildRowFromForm(bankSetup = null) {
            const uuid = this.form.id ? '' : this.generateUUIDv4();
            const uuidEnc = this.form.id ? this.form.uuid_enc : this.uuidToBase64UrlRFC7515(uuid);
            const tipoCuenta = String(this.form.tipo_cuenta);
            const isBank = tipoCuenta === '1' || tipoCuenta === '2';

            const row = {
               id: this.form.id || '',
               UUID: uuid || '',
               UUID_ENC: uuidEnc || '',
               tipo_cuenta: this.form.tipo_cuenta,
               tipo_pasarela_pago: this.isCreditCard ? this.form.tipo_pasarela_pago : 'Stripe',
               titular_tarjeta: this.form.titular_tarjeta || '',
               numero_tarjeta: isBank ? (this.form.numero_cuenta_metodo_pago || '') : (this.form.numero_tarjeta || ''),
               codigo_ccv: this.form.codigo_ccv || '',
               exp_month: this.form.exp_month || '',
               exp_year: this.form.exp_year || '',
               estado_id: this.form.estado_id || '',
               use_credit_card: this.form.use_credit_card || '',
               banco_metodo_pago: this.form.banco_metodo_pago || '',
               nombre_banco_metodo_pago: this.form.banco_metodo_pago || '',
               numero_ruta_metodo_pago: this.form.numero_ruta_metodo_pago || '',
               tipo_titular_metodo_pago: this.form.tipo_titular_metodo_pago || '',
               email_metodo_pago: this.form.email_metodo_pago || '',
               configuracion_stripe_id: this.form.configuracion_stripe_id || '',
               configuracion_pasarela_pago: this.isCreditCard ? String(this.form.tipo_pasarela_pago).toLowerCase() : 'stripe',
               payment_method: this.form.payment_method || '',
               customer_id: this.form.customer_id || '',
               setup_intent: this.form.setup_intent || '',
               verificado: this.form.verificado || ''
            };

            if (bankSetup) {
               row.payment_method = bankSetup.payment_method || '';
               row.customer_id = bankSetup.stripe_customer_id || '';
               row.setup_intent = bankSetup.setup_intent || '';
               row.tipo_verificacion_micro_deposito = bankSetup.tipo_verificacion_micro_deposito || '';
               row.verificado = bankSetup.verified ? 1 : 2;
            } else if (!row.verificado) {
               row.verificado = 1;
               row.tipo_verificacion_micro_deposito = '';
            } else {
               row.tipo_verificacion_micro_deposito = this.form.tipo_verificacion_micro_deposito || '';
            }

            return row;
         },
         async savePaymentMethod() {
            if (this.savingPaymentMethod) {
               return;
            }

            if (this.isEmpty(this.form.tipo_cuenta)) {
               if (typeof toastr !== 'undefined') toastr.error('Account type is required.');
               return;
            }

            if (this.isEmpty(this.form.configuracion_stripe_id)) {
               if (typeof toastr !== 'undefined') toastr.error('General payment gateway is required.');
               return;
            }

            if (this.isEmpty(this.form.titular_tarjeta)) {
               if (typeof toastr !== 'undefined') toastr.error('Card name is required.');
               return;
            }

            if (this.isBankAccount) {
               if (this.isEmpty(this.form.banco_metodo_pago)) {
                  if (typeof toastr !== 'undefined') toastr.error('Bank is required.');
                  return;
               }
               if (this.isEmpty(this.form.numero_cuenta_metodo_pago)) {
                  if (typeof toastr !== 'undefined') toastr.error('Account number is required.');
                  return;
               }
               if (this.isEmpty(this.form.numero_ruta_metodo_pago)) {
                  if (typeof toastr !== 'undefined') toastr.error('Route number is required.');
                  return;
               }
               if (this.isEmpty(this.form.tipo_titular_metodo_pago)) {
                  if (typeof toastr !== 'undefined') toastr.error('Account holder type is required.');
                  return;
               }
               if (this.isEmpty(this.form.email_metodo_pago)) {
                  if (typeof toastr !== 'undefined') toastr.error('Email is required.');
                  return;
               }
               if (!this.isEmail(this.form.email_metodo_pago)) {
                  if (typeof toastr !== 'undefined') toastr.error('Email is invalid.');
                  return;
               }
            }

            if (this.isCreditCard && !this.useStripeElement) {
               if (this.isEmpty(this.form.numero_tarjeta)) {
                  if (typeof toastr !== 'undefined') toastr.error('Card number is required.');
                  return;
               }
               if (this.isEmpty(this.form.codigo_ccv)) {
                  if (typeof toastr !== 'undefined') toastr.error('CCV is required.');
                  return;
               }
               if (this.isEmpty(this.form.exp_month)) {
                  if (typeof toastr !== 'undefined') toastr.error('Expiration month is required.');
                  return;
               }
               if (this.isEmpty(this.form.exp_year)) {
                  if (typeof toastr !== 'undefined') toastr.error('Year of expiration is required.');
                  return;
               }
            }

            if (this.isEmpty(this.form.estado_id)) {
               if (typeof toastr !== 'undefined') toastr.error('Payment method status is required.');
               return;
            }

            if (this.isEmpty(this.form.use_credit_card)) {
               if (typeof toastr !== 'undefined') toastr.error('Default payment method selection is required.');
               return;
            }

            this.savingPaymentMethod = true;

            if (this.useStripeElement) {
               try {
                  await this.setupStripeElement();
                  const result = await this.stripeInstance.confirmSetup({
                     elements: this.stripeElements,
                     redirect: 'if_required'
                  });

                  if (result.error) {
                     if (typeof toastr !== 'undefined') toastr.error(result.error.message || 'Card setup failed');
                     return;
                  }

                  const response = await fetch(`${this.appUrl}/api/billing/payment-methods/save`, {
                     method: 'POST',
                     headers: { 'Content-Type': 'application/json' },
                     body: JSON.stringify({
                        crm_customer_id: this.contactId,
                        stripe_customer_id: this.stripeCustomerId,
                        payment_method_id: result.setupIntent.payment_method,
                        estado_id: this.form.estado_id,
                        use_credit_card: this.form.use_credit_card,
                        configuracion_stripe_id: this.form.configuracion_stripe_id,
                        titular_tarjeta: this.form.titular_tarjeta
                     })
                  });
                  const data = await response.json();
                  if (data.ok) {
                     if (typeof toastr !== 'undefined') toastr.success('Saved information');
                     this.resetForm();
                     this.loadPaymentMethodTable();
                  } else {
                     if (typeof toastr !== 'undefined') toastr.error(data.error || 'Error saving payment method');
                  }
               } catch (error) {
                  console.error('Stripe card save error:', error);
                  if (typeof toastr !== 'undefined') toastr.error(error.message || 'Error saving payment method');
               } finally {
                  this.savingPaymentMethod = false;
               }
               return;
            }

            try {
               let bankSetup = null;
               if (this.isBankAccount && this.shouldRefreshBankSetup()) {
                  bankSetup = await this.createBankAccountSetup();
                  if (bankSetup && String(this.form.use_credit_card) === '1') {
                     await this.setStripeDefault({
                        payment_method: bankSetup.payment_method,
                        customer_id: bankSetup.stripe_customer_id
                     }, false);
                  }
               }

               let rows = this.paymentMethodRows.map((row) => ({ ...row }));
               if (String(this.form.use_credit_card) === '1') {
                  rows = rows.map((row) => ({
                     ...row,
                     use_credit_card: '2',
                     use_credit_card_nombre: 'Secondary'
                  }));
               }

               const newRow = this.buildRowFromForm(bankSetup);
               if (this.form.id) {
                  rows = rows.map((row) => (String(row.id) === String(this.form.id) ? { ...row, ...newRow } : row));
               } else {
                  rows.push(newRow);
               }

               const response = await fetch(`${this.appUrl}/api/contacts/post-payment-method-customer`, {
                  method: 'POST',
                  headers: { 'Content-Type': 'application/json' },
                  body: JSON.stringify({
                     customer_id: this.contactId,
                     arreglo_planes: rows,
                     eliminar_metodo_pagos: []
                  })
               });
               const data = await response.json();
               if (data.type === 'success') {
                  if (typeof toastr !== 'undefined') toastr.success('Saved information');
                  this.resetForm();
                  this.loadPaymentMethodTable();
               } else {
                  if (typeof toastr !== 'undefined') toastr.error(data.message || 'Error saving payment method');
               }
            } catch (error) {
               console.error('Error saving payment method:', error);
               if (typeof toastr !== 'undefined') toastr.error(error.message || 'Error saving payment method');
            } finally {
               this.savingPaymentMethod = false;
            }
         },
         async confirmDelete(pm) {
            const title = 'You are sure?';
            const text = 'Are you sure you want to delete this payment method?';

            if (window.Swal && Swal.fire) {
               const result = await Swal.fire({
                  title,
                  text,
                  icon: 'warning',
                  showCancelButton: true,
                  confirmButtonText: 'Yes, delete',
                  cancelButtonText: 'Cancel'
               });
               if (!result.isConfirmed) {
                  return;
               }
            } else if (!confirm(text)) {
               return;
            }

            this.deletePaymentMethod(pm);
         },
         async deletePaymentMethod(pm) {
            try {
               const remaining = this.paymentMethodRows.filter((row) => String(row.id) !== String(pm.id));
               const response = await fetch(`${this.appUrl}/api/contacts/post-payment-method-customer`, {
                  method: 'POST',
                  headers: { 'Content-Type': 'application/json' },
                  body: JSON.stringify({
                     customer_id: this.contactId,
                     arreglo_planes: remaining,
                     eliminar_metodo_pagos: [{ id: pm.id, UUID_ENC: pm.UUID_ENC }]
                  })
               });
               const data = await response.json();
               if (data.type === 'success') {
                  if (typeof toastr !== 'undefined') toastr.success('Record deleted');
                  this.loadPaymentMethodTable();
               } else {
                  if (typeof toastr !== 'undefined') toastr.error(data.message || 'Error deleting payment method');
               }
            } catch (error) {
               console.error('Error deleting payment method:', error);
               if (typeof toastr !== 'undefined') toastr.error('Error deleting payment method');
            }
         },
         async promptVerificationCode(pm) {
            if (this.isVerified(pm)) {
               if (typeof toastr !== 'undefined') toastr.error('The account is verified');
               return;
            }

            if (window.Swal && Swal.fire) {
               const result = await Swal.fire({
                  title: 'Verify code',
                  input: 'text',
                  inputPlaceholder: 'Descriptor code',
                  showCancelButton: true,
                  confirmButtonText: 'Verify',
                  cancelButtonText: 'Cancel'
               });
               if (!result.isConfirmed) {
                  return;
               }
               await this.verifyBankAccountCode(pm, result.value || '');
            } else {
               const code = prompt('Enter the descriptor code');
               if (code) {
                  await this.verifyBankAccountCode(pm, code);
               }
            }
         },
         async verifyBankAccountCode(pm, code) {
            const normalizedCode = String(code || '').trim().toUpperCase();
            if (this.isEmpty(normalizedCode)) {
               if (typeof toastr !== 'undefined') toastr.error('The field code is required.');
               return;
            }

            try {
               const response = await fetch(`${this.appUrl}/api/contacts/payment-methods/verify-bank-code`, {
                  method: 'POST',
                  headers: { 'Content-Type': 'application/json' },
                  body: JSON.stringify({
                     description_code: normalizedCode,
                     dc_uuid_enc: pm.UUID_ENC,
                     customer_id: this.contactId
                  })
               });
               const data = await response.json();
               if (data.status === 'success') {
                  if (window.Swal && Swal.fire) {
                     Swal.fire({
                        icon: 'success',
                        title: 'Successful operation',
                        text: data.message || 'Verification complete'
                     });
                  } else if (typeof toastr !== 'undefined') {
                     toastr.success(data.message || 'Verification complete');
                  }
                  this.loadPaymentMethodTable();
               } else {
                  if (window.Swal && Swal.fire) {
                     Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: data.message || 'Verification failed'
                     });
                  } else if (typeof toastr !== 'undefined') {
                     toastr.error(data.message || 'Verification failed');
                  }
               }
            } catch (error) {
               console.error('Error verifying bank code:', error);
               if (typeof toastr !== 'undefined') {
                  toastr.error('Error verifying bank code');
               }
            }
         }
      }
   });

   window.PaymentMethodsApp = paymentMethodsApp;
   paymentMethodsApp.mount('#payment-methods-app');
}
})();
</script>
{/literal}
