{extends file="$layouts_admin"}
{block name="head"}

 

<link
  href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
  rel="stylesheet"
/>


{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    .swal2-container {
         z-index: 9999;
      }

.wrapper {
  overflow: hidden;  
}

ul.breadcrumbs {
  margin: 0;
  padding: 0;
  display: flex; /* Cambiar a flex para un mejor ajuste en pantallas pequeñas */
  flex-wrap: wrap; /* Permitir que los elementos se ajusten en múltiples líneas si es necesario */
  justify-content:center;
}

ul.breadcrumbs li {
  position: relative;
  margin: 0;
  padding: 0;
  list-style: none;
  display: inline-block;
  border-left: 1px solid #ccc;
  transition: 0.3s ease;
}

ul.breadcrumbs li:hover:before {
  /* border-left: 10px solid #5e6e82; */
}

ul.breadcrumbs li:hover a {
  /* color: white;
  background: #5e6e82; */
 
}

ul.breadcrumbs li:before {
  content: "";
  position: absolute;
  right: -9px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 20;
  border-left: 10px solid #fff;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
  transition: 0.3s ease;
}

ul.breadcrumbs li:after {
  content: "";
  position: absolute;
  right: -10px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 10;
  border-left: 10px solid #ccc;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
}

ul.breadcrumbs li.active {
  background: #5e6e82; /* Fondo para el activo */
}

ul.breadcrumbs li.active a {
  color: white !important; /* Color del texto activo */
  padding: 0 15px 0 25px; /* Ajustar el padding */
  background: #5e6e82;
}

ul.breadcrumbs li.first {
  border-left: none;
}

ul.breadcrumbs li.first a {
  font-size: 18px;
  padding-left: 20px;
  border-radius: 5px 0px 0px 5px;
}

ul.breadcrumbs li.last:before {
  display: none;
}

ul.breadcrumbs li.last:after {
  display: none;
}

ul.breadcrumbs li.last a {
  padding-right: 20px;
  border-radius: 0px 40px 40px 0px;
}

ul.breadcrumbs li a {
  display: block;
  font-size: 12px;
  line-height: 40px;
  color: #757575;
  padding: 0px 15px 0px 25px;
  text-decoration: none;
  background: #fff;
  border: 1px solid #ddd;
  white-space: nowrap; /* Evitar que el texto se envuelva */
  overflow: hidden;
  transition: 0.3s ease;
}

ul.breadcrumbs li.active:before {
  display: block; /* Mostrar el triángulo en el activo */
}

ul.breadcrumbs li.active:after {
  display: block; /* Mostrar el triángulo secundario en el activo */
}

@media (max-width: 768px) {
  ul.breadcrumbs {
    flex-direction: column; /* Cambiar a una columna en pantallas más pequeñas */
  }

  ul.breadcrumbs li {
    border-left: none; /* Eliminar el borde izquierdo en pantallas pequeñas */
    margin-bottom: 5px; /* Espaciado entre elementos */
    margin-right: 10px;
  }
}
ul.breadcrumbs li.active:before {
  border-left: 10px solid #5e6e82; /* Cambia el color del triángulo al hacer hover sobre el activo */
}

.cursor_manito {
  cursor: pointer;
}

table.estilosTabla > :not(caption) > * > * {
        /*
        padding-top: 5px !important;
        padding-bottom: 5px !important;
        */
    }

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
   }

   .btn-edit-referencia-personal {
         margin-bottom: 4px; 
         background-color: #001b3b; 
         color: white; 
         border: 1px solid rgb(211, 202, 192) !important; 
         box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
         float: inline-end;
    }

   .btn-eliminar-referencia-personal {
      margin-bottom: 4px;
      background-color: red;
      color: white;
      border: 1px solid rgb(211, 202, 192) !important;
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
      float: inline-end;
    }

   .btn-edit-referencia-personal:hover i,
   .btn-eliminar-referencia-personal:hover i {
      color: white; /* Mantén el color blanco del icono en hover */
   }

   .tamano-icono{
      font-size:small;
   }
    
   .centrar-botones{
      text-align: center;
      justify-content: center;
      display: flex;
      padding: 0px;
   }

   .btn-descargar {
         margin-bottom: 4px; 
         background-color: #001b3b; 
         color: white; 
         border: 1px solid rgb(211, 202, 192) !important; 
         box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
         float: inline-end;
    }

   .btn-eliminar {
      margin-bottom: 4px;
      background-color: red;
      color: white;
      border: 1px solid rgb(211, 202, 192) !important;
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
      float: inline-end;
    }

   .btn-descargar:hover i,
   .btn-eliminar:hover i {
      color: white; /* Mantén el color blanco del icono en hover */
   }

 
</style>

    <input
         type="text"
         value="{$url_base}"
         disabled
         hidden
         id="URL_BASE"
    />

    <input
         type="text"
         value="{$UUID_ENC}"
         disabled
         hidden
         id="UUID_ENC"
    />

    <input
         type="text"
         value="{$UUID}"
         disabled
         hidden
         id="UUID"
    />

    <input
         type="text"
         value="{$id_user}"
         disabled
         hidden
         id="ID_USER"
    />

    <input
         type="text"
         value="{$id_ifp}"
         disabled
         hidden
         id="id_ifp"
    />

 

 
<div class="row pantalla_cargada"  style="display: none;">

   <div class="col-12 col-lg-12 col-sm-12 col-md-12">

      <div class="panel">
            <div class="panel-hdr">
                <h2><span></span>Prospecting Stages  <span class="ms-2 titulo_cabecera_credito"></span> </h2>
            </div>

            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">
                    
                  <div class="wrapper">
                     <ul class="breadcrumbs">

                        <li class="cursor_manito enableMenu" data-id="datos_prestamos" style="display: none;">
                           <a>Loan details</a>
                        </li>

                        <li class="cursor_manito enableMenu" data-id="historial_crediticio" style="display: none;">
                           <a>Credit history</a>
                        </li>

                        <li class="cursor_manito" data-id="general_information" >
                        <a>General information</a>
                        </li>

                        <li class="cursor_manito  "  data-id="referencia" >
                        <a>References</a>
                        </li>

                        <li class="cursor_manito active"  data-id="documento_respaldo">
                        <a>Supporting documents</a>
                        </li>

                        <li class="cursor_manito"  data-id="preaprobacion" >
                        <a>Pre-approval</a>
                        </li>

                        <li class="cursor_manito"  data-id="plan_pago" >
                        <a>Payment plan</a>
                        </li>

                        <li class="cursor_manito" data-id="desembolzo" >
                        <a>Disbursement</a>
                        </li>

                        <!--  -->
                     </ul>
                  </div>

                </div>
  
               
            </div>
      </div>

        
   </div>

   <div class="col-md-12">
        <div class="panel">
            <div class="panel-hdr">
               <h2>Documentation and backup files</h2>
            </div>

            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">

                    <div class="px-2">
                        
                        <form id="rform">

                           <div class="row">
                              
                              <div class="col-md-12 col-sm-12">
                                  <div class="mb-3 row">
                                     <label for="tipo_documento" class="col-sm-3"><span class="h6">Document type</span><span class="text-danger">*</span></label>
                                     <div class="col-sm-9">
 
                                          <select id="tipo_documento" name="tipo_documento" class="form-select tipo_documento">
                                                 
                                          </select>

                                     </div>
                                  </div>
                              </div>

                              <div class="col-md-12 col-sm-12">
                                  <div class="mb-3 row">
                                     <label for="observaciones" class="col-sm-3"><span class="h6">Observations</span><span class="text-danger"></span></label>
                                     <div class="col-sm-9">
 
                                       <textarea rows="3" id="observaciones" name="observaciones" class="form-control observaciones"></textarea>

                                     </div>
                                  </div>
                              </div>

                              <div class="col-md-12 col-sm-12">
                                  <div class="mb-3 row">
                                     <label for="file" class="col-sm-3"><span class="h6">File</span><span class="text-danger">*</span></label>
                                     <div class="col-sm-9">
                                        <input type="file" id="file" name="file" class="form-control file">
                                     </div>

                                    {*  
                                       <div class="col-sm-3 " style=" display: flex; justify-content: end; ">
                                          <button class="btn btn-default mt-2 waves-effect waves-themed guardar_archivo" type="button" id="submit">Add file</button>
                                       
                                             <button class="btn btn-default mt-2 waves-effect waves-themed loading_guardar_archivo" style="display: none;" disabled>
                                                <div style="display: flex; align-items: center">
                                                   <span
                                                   class="spinner-border spinner-border-sm"
                                                   style="height: 20px; width: 20px; margin-right: 5px"
                                                   role="status"
                                                   aria-hidden="true"
                                                   ></span>
                                                   Add file
                                                </div>
                                             </button>
                                       </div>
                                    *}
 
                                  </div>
                              </div>
 
                           </div>

                           <div class="row mt-3">
                                <div class="col-md-12">
                                    <div class="mb-3" style="display: flex;justify-content: space-between;">

                                       <button class="btn btn-default mt-2 waves-effect waves-themed back" type="button" id="submit">Back</button>


                                       <div>
                                           
                                          
                                          {*---*}
                                          <button class="btn btn-primary mt-2 waves-effect waves-themed guardar_siguiente" type="button" id="submit">Next</button>
                                       
                                          <button class="btn btn-primary mt-2 waves-effect waves-themed loading_guardar_siguiente" style="display: none;" disabled>
                                             <div style="display: flex; align-items: center">
                                                <span
                                                class="spinner-border spinner-border-sm"
                                                style="height: 20px; width: 20px; margin-right: 5px"
                                                role="status"
                                                aria-hidden="true"
                                                ></span>
                                                 Next
                                             </div>
                                          </button>
                                          {*---*}

                                       </div>
                                        
                                    </div>
                                </div>

                           </div>
 
                        </form>

                    </div>

                  

                </div>
  
               
            </div>
        </div>
   </div>

   

 
      <div
         class="modal fade"
         id="modalMensaje"
         data-bs-backdrop="static"
         data-bs-keyboard="false"
         tabindex="-1"
         aria-labelledby="staticBackdropLabel"
         aria-hidden="true"
      >
         <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
               <div class="modal-header">
                  <h5 class="modal-title modal_titulo_mensaje" id="staticBackdropLabel">
                     Group Message
                  </h5>
                  <button
                     type="button"
                     class="btn-close btn_cerrar_confirmacion_modal"
                  ></button>
               </div>
               <div class="modal-body text-center">
                  <p class="modal_contenido_mensaje">
                     The group advertising campaign has been sent. For more
                  </p>
               </div>
            </div>
         </div>
      </div>

</div>

<div class="row cargando_pantalla " style=" margin: 0px; ">

   <div
      class="container"
      style="
         display: flex;
         justify-content: center;
         align-items: center;
         height: 45vh;
         box-shadow: 0 0 13px 0 rgba(31,17,173,.08);
         border-radius: 11px;
         background-color: white;
      "
   >
      <div style="text-align: center">
         <span
         class="spinner-border spinner-border-sm"
         style="height: 45px; width: 45px; margin-bottom: 10px"
         role="status"
         aria-hidden="true"
         ></span>
         <br />
         <strong>Please wait while the <span style=" font-weight: 600; ">"Supporting Document"</span> screen loads...</strong>
         <br />
      </div>
   </div>

</div>

 
<div class="modal fade" id="ventana_confirmacion" tabindex="-1" aria-labelledby="exampleModalLabel__ventanaconfirmacion" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false" >
   <div class="modal-dialog modal-dialog-centered"  >
      <div class="modal-content" style="background-color:white">
         <div class="modal-header">
         <h3 class="titulo_modal_confirmar">Estas seguro de eliminar</h3>
            <button type="button" class="btn-close "  id="btn_close_ventana_confirmacion" ></button>
         </div>
         <div class="modal-body" style="background-color:white;border-radius:10px">
          
            <div class="row">
               <div class="col-md-12">
                  <div class="panel-container show" id="ibox_form">
                           <div class="panel-content">
                              <div class="px-2">
                                    <div class="alert alert-danger" id="emsg" style="display: none;">
                                       <span id="emsgbody"></span>
                                    </div>
                                    <input class="tipo_modal_confirmar" hidden disabled/> 
                                    <input class="data_id" hidden disabled/> 
                                    <div class="row">
                                          <div class="col-md-12 col-sm-12">

                                                <h4 class="mensaje_modal_confirmar" style="text-align:center; color:black">Estas seguro de eliminar</h4>
                                                 
                                                 <p class="mensaje_espera_moda_confirmacion mt-3" style="text-align:center; color:red; font-weight:600">Espere mientras termina el proceso</p>
                                          </div>
                                     
                                       </div>

                                       <div class="row mt-2">
                                          <div class="col-md-12">
                                                <div style=" float: inline-end; ">
                                                   <button class="btn me-2" type="button" id="btn_cerrar_ventana_confirmacion" style=" background: #001b3b; ">close</button>
                                                   <button class="btn " type="button" id="btn_aplicar_ventana_confirmacion" style=" background: red; ">Remove</button>
                                                </div>
                                          </div>
                                       </div>
                              </div>
                           </div>
                        </div>
               </div>
            </div>
          
         </div>
         
      </div>
   </div>
</div>


 

<div class="row card_container " style=" margin: 0px; ">

 
</div>
 
{/block}

{block name="script"}

{literal}
<script>

   var URL_BASE = $("#URL_BASE").val();
   var ID_USER = $("#ID_USER").val();
   var url_dashboard = $("#url_dashboard").val();
   var roll_id = $("#roll_id").val();

   var UUID_ENC = $("#UUID_ENC").val();
   var UUID     = $("#UUID").val();
   var id_ifp   = $("#id_ifp").val();

   var COLOR_FONDO_VENTANA_CERRAR = "#001b3b";
   var COLOR_TEXT_VENTANA_CERRAR = "white";

   var COLOR_FONDO_VENTANA_CONFIRMACION = "red";
   var COLOR_TEXT_VENTANA_CONFIRMACION = "white";
 
   var base64 = "";
   var base64_original = "";
   var extension = "";
   var nombre_original = "";
 
   var COLOR_FONDO_VENTANA_IR = "#001b3b";
   var COLOR_TEXT_VENTANA_IR = "white";

   var menus_disponibles = {};

   var list_document_type = [];

   $(document).ready(function () {

      cargarPrincipal();
  
      $(".progress").hide();
      $("#emsg").hide();
      $("#emsgSuccess").hide();

      var _url = '{$_url}';

      $('.cursor_manito').click(function() {

         const atributo_data =  $(this).attr('data-id');

         if(atributo_data == "datos_prestamos")
         {
            window.location = URL_BASE + "credit/data-loans/" + UUID_ENC;
         }

         if(atributo_data == "historial_crediticio")
         {
            window.location = URL_BASE + "credit/credit-history/" + UUID_ENC;
         }
 
         if(atributo_data == "general_information")
         {
            if(menus_disponibles.general_information == 1)
            {
               window.location = URL_BASE + "credit/new-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
            
         }

         if(atributo_data == "referencia")
         {
            if(menus_disponibles.referencia == 1)
            {
               window.location = URL_BASE + "credit/reference-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "documento_respaldo")
         {
            return;
            
            if(menus_disponibles.documento_respaldo == 1)
            {
               window.location = URL_BASE + "credit/supporting-document-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "preaprobacion")
         {
            if(menus_disponibles.preaprobacion == 1)
            {
               window.location = URL_BASE + "credit/pre-approval-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "plan_pago")
         {
            if(menus_disponibles.plan_pago == 1)
            {
               window.location = URL_BASE + "credit/payment-plan-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "desembolzo")
         {
            if(menus_disponibles.desembolzo == 1)
            {
               window.location = URL_BASE + "credit/disbursement-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

 
      });
 
      $('#submit_modal_confirmacion_correo').on('click', function() {
         window.location = url_dashboard;    
      });
 
      $("#btn_aplicar_ventana_confirmacion").off("click")
      .on("click", function () {

         console.log("se dio click");

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', true);
         $('#btn_close_ventana_confirmacion').prop('disabled', true);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', true);
 
         let opcion_predefinida = $(".tipo_modal_confirmar").val();
         let data_id = $(".data_id").val();

         if(opcion_predefinida == "eliminar_card_documento")
         {
            $(".mensaje_espera_moda_confirmacion").text("Please wait while the process finishes...");
            eliminarDocument(data_id);
         }

         if(opcion_predefinida == "navegar_pantalla_siguiente")
         {
            window.location = URL_BASE + "credit/pre-approval-prospecting/"+data_id;
         }

         
       
      });

      $("#btn_cerrar_ventana_confirmacion").off("click")
      .on("click", function () {
         
         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         $("#ventana_confirmacion").modal("hide");
       
      });

      $("#btn_close_ventana_confirmacion").off("click")
      .on("click", function () {

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         
         $("#ventana_confirmacion").modal("hide");
       
      });

      $('.btn_cerrar_confirmacion_modal').click(function() {
         $("#modalMensaje").modal("hide");
      });

      $('.abrir_modal_contacto').click(function() {
         $("#modal_asignar_clientes_contactos").modal("show");
      });

      $('.back').click(function() {
         window.location = URL_BASE + "credit/reference-prospecting/" + UUID_ENC;
      });

      $('.guardar_siguiente').click(function() {

         if(menus_disponibles.preaprobacion == 1){ // && menus_disponibles.estado_prestamo != 5
            window.location = URL_BASE + "credit/pre-approval-prospecting/" + UUID_ENC;
            return;
         }
        
         $('input, select, button, textarea').prop('disabled', true);

         $('.loading_guardar_siguiente').css('display', '');
         $('.guardar_siguiente').css('display', 'none');

         let dataFront = {
            id: id_ifp,
            stage: "3",
         };

         //console.log("dataFront");
         //console.log(JSON.stringify(dataFront));
         //return;
   
         $.ajax({
            type: "POST",
            url: URL_BASE + "credit/post-change-state-back-document-prospeccion",
            data: JSON.stringify(dataFront), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               $('input, select, button, textarea').prop('disabled', false);

               $('.loading_guardar_siguiente').css('display', 'none');
               $('.guardar_siguiente').css('display', '');
   
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {

                     //jajaja
                     toastr.success(
                         "Record added",
                         "¡Record added successfully!",
                     );

                     setTimeout(() => {
                       window.location = URL_BASE + "credit/pre-approval-prospecting/" + UUID_ENC;
                     }, 1000);

                     //navegarPantallaSiguiente(UUID_ENC); 

                  } else if (info.type == "error") {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
            
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

               $('input, select, button, textarea').prop('disabled', false);

               $('.loading_guardar_siguiente').css('display', 'none');
               $('.guardar_siguiente').css('display', '');

            },
         });

      });

      $('.guardar_archivo').click(function() {
 
         let tipo_documento = $(".tipo_documento").val();

         if(isEmpty(tipo_documento))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.tipo_documento');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Documentation and backup files" the field "Document type" is required.');
            return;
         }

         //let file = $(".file").val();

         //base64    = base64Data;
         //extension = result.extension;

         if(isEmpty(base64))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.file');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Documentation and backup files" the field "File" is required.');
            return;
         }

         let validacionCaracteres = validateFormFields();

         if(validacionCaracteres == true)
         {
            return;
         }         

         let observaciones = $(".observaciones").val();

         let informacionFront = {
            id_ifp: id_ifp,
            tipo_documento: tipo_documento,
            observaciones: observaciones,
            base64: base64,
            base64_original: base64_original,
            nombre_original: nombre_original,
            extension: extension
         };

         console.log(JSON.stringify(informacionFront));

         guardarArchivos(informacionFront);

 

      });

      function getFileBase64AndExtension(inputSelector, callback) {
         const fileInput = $(inputSelector)[0];
         if (!fileInput || !fileInput.files || fileInput.files.length === 0) {
            callback({ error: "No file selected" });
            return;
         }

         const file = fileInput.files[0];
         const reader = new FileReader();
         
         // Get file extension
         const fileName = file.name;
         const extension = fileName.split('.').pop().toLowerCase();

         reader.onload = function(e) {
            const base64String = e.target.result; // Full data URL (e.g., "data:image/png;base64,...")
            callback({
                  base64: base64String,
                  extension: extension,
                  name: file.name
            });
         };
 
         reader.onerror = function() {
            callback({ error: "Error reading file" });
         };

         reader.readAsDataURL(file);
      }

      // Example usage:
      $('.file').on('change', function() {

         var tipo_documento = $(".tipo_documento").val();

         if(isEmpty(tipo_documento))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.tipo_documento');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            $('.file').val("");

            toastr.error('!In "Documentation and backup files" the field "Document type" is required.');
            return;
         }


         var texto_tipo_documento = list_document_type.find((data) => data.id == tipo_documento );

         if(isEmpty(texto_tipo_documento) == true)
         {
            toastr.error('!The document type was not found, please refresh the page.');
            $('.file').val("");
            return;
         }

         let validacionCaracteres = validateFormFields();

         if(validacionCaracteres == true)
         {
            $('.file').val("");
            return;
         }         

 
         getFileBase64AndExtension('#file', function(result) {
            if (result.error) {
                  toastr.error(result.error);
                  return;
            }
 

            let observaciones = $(".observaciones").val();

            base64_original  = result.base64;
            const base64Data = result.base64.split(',')[1]; // Extract only the Base64 part
            
            //console.log('Base64:', base64Data);
            //console.log('Extension:', );

            base64          = base64Data;
            extension       = result.extension;
            nombre_original = result.name;

            let informacionFront = {
               id_ifp: id_ifp,
               tipo_documento: texto_tipo_documento.document,
               observaciones: observaciones,
               base64: base64,
               base64_original: base64_original,
               nombre_original: nombre_original,
               extension: extension
            };

            console.log(JSON.stringify(informacionFront));

            guardarArchivos(informacionFront);
 
         });
      });

      function guardarArchivos(informacionFront = {})
      {
         $('input, select, button, textarea').prop('disabled', true);

         $('.loading_guardar_archivo').css('display', '');
         $('.guardar_archivo').css('display', 'none');

         $.ajax({
            type: "POST",
            url: URL_BASE + "credit/post-back-document-prospeccion",
            data: JSON.stringify(informacionFront), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               $('input, select, button, textarea').prop('disabled', false);

               $('.loading_guardar_archivo').css('display', 'none');
               $('.guardar_archivo').css('display', '');
   
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {

                     let id = info.ultimo_id ;
                     let url = info.url ;
 
 
                     $(".card_container").append( generateCardHtml(
                           id,
                           informacionFront.tipo_documento,
                           extension,
                           informacionFront.observaciones,
                           url,
                           nombre_original,
                           nombre_original
                        ) 
                     );

                     eventoEliminarDocumento();

                     $(".tipo_documento").val("");
                     $(".observaciones").text("");
                     $(".observaciones").val("");
                     $(".file").val("");

                     base64 = "";
                     base64_original = "";
                     nombre_original = "";
                     extension = "";
            
 
                  } else if (info.type == "error") {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
            
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

               $('input, select, button, textarea').prop('disabled', false);

               $('.loading_guardar_archivo').css('display', 'none');
               $('.guardar_archivo').css('display', '');

            },
         });
      }

   });

   function contadorPosicion()
   {
      //if(menus_disponibles.documento_respaldo == 1 || menus_disponibles.documento_respaldo == "1")
      //{
      //   menus_disponibles.preaprobacion = "1";
      //}

      // Log the updated object for verification
      console.log("menus_disponibles");
      console.log(menus_disponibles);

   
      // Ordered list of properties to process
      const propertiesToCheck = [
         "general_information",
         "referencia",
         "documento_respaldo",
         "preaprobacion",
         "plan_pago",
         "desembolzo"
      ];

      // Find the first "1" and set the next property (if it's "2") to "1"
      for (let i = 0; i < propertiesToCheck.length - 1; i++) {
         const currentProp = propertiesToCheck[i];
         if (menus_disponibles[currentProp] === "1") {
            const nextProp = propertiesToCheck[i + 1];
            if (menus_disponibles[nextProp] === "2") {
                  menus_disponibles[nextProp] = "1";
                  break; // Stop after updating the next property
            }
         }
      }

      // Log the updated object for verification
      console.log("menus_disponibles");
      console.log(menus_disponibles);
 
   }

   function cargarPrincipal()
   {

      let data = {
         id_ifp: id_ifp,
      };

      $.ajax({
         type: "POST",
         url: URL_BASE + "credit/get-data-back-document",
         data: JSON.stringify(data),
         contentType: "application/json", // Tipo de contenido JSON
         success: function (response) {
            
            //console.log("Respuesta del servidor:", response);
            // Hacer algo con la respuesta del servidor
   
            try {
               let info = JSON.parse(response);

               if (info.type == "success") {

                  menus_disponibles = info.menu_habilitados || {};
 
                  list_document_type = info.list_document_type || [];
                  $(".tipo_documento").html(select_html_document_type(list_document_type));

                  let arreglo  = info.data_back_document || [];

                  let html = "";
 
                  arreglo.forEach((item) => {

                     let {
                           id,
                           id_ifp,
                           tipo_documento,
                           observaciones,
                           nombre_original,
                           extension,
                           url,
                           nombre_imagen,
                           fecha_post,
                           url_completa,
                     } = item;

                     html += generateCardHtml(
                        id,
                        tipo_documento,
                        extension,
                        observaciones,
                        url_completa,
                        nombre_original,
                        nombre_original,
                     );
                  });

                  $(".card_container").html(html);
                  eventoEliminarDocumento();

                  if(menus_disponibles.preaprobacion == 1)
                  {
                     $(".btn-edicion").css("display", "none");
                     $(".guardar_rechazar").css("display", "none");
                     $(".guardar_borrador").css("display", "none");
                     $(".guardar_siguiente").css("display", "");

                     $(".guardar_archivo").css("display", "none");
                     $(".btn-eliminar").css("display", "none");

                     $('.file, .observaciones, .tipo_documento').prop('disabled', true);

                     if(menus_disponibles.estado_prestamo != 5)
                     {
                        $(".guardar_siguiente").text("Next");
                        $(".guardar_siguiente").attr("disabled", false);
                     }
                  } 

                  if(menus_disponibles.desembolzo == 1 && menus_disponibles.estado_prestamo == 4)
                  {
                     $(".enableMenu").css("display", "");
                  }

                  let data_gip = info.data_gip || {};

                  if(Object.keys(data_gip).length != 0)
                  {
                     if(isEmpty(data_gip.numero_credito) == true)
                     {
                        $(".titulo_cabecera_credito").text(" " + data_gip.account);
                     }else{
                        $(".titulo_cabecera_credito").text(" No. Credit: " + data_gip.numero_credito + " - " + data_gip.account);
                     }

                  }

                  contadorPosicion();

                  $(".cargando_pantalla").css("display", "none");
                  $(".pantalla_cargada").css("display", "");
                  
               } else if (info.type == "error") {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: info.message,
                  //});

                  ventanaError("Opps there was an error", info.message);
               }
            } catch (error) {
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);
            }
         },
         error: function (xhr, status, error) {
            console.error("Error en la solicitud:", error);
            // Manejar errores aquí
            //Swal.fire({
            //   icon: "error",
            //   title: "Oops...",
            //   text: error,
            //});

            ventanaError("Opps there was an error", error);

         },
      });

       
   }
 
   function eventoEliminarDocumento() 
   {
      $('.btn-eliminar').off('click');

      $('.btn-eliminar').on('click', function() {
         
         let data_id = $(this).data("id");
         console.log("data_id eliminar: " + data_id);

         $(".titulo_modal_confirmar").text("You are sure?");
         $(".mensaje_modal_confirmar").text("Are you sure you want to delete this record?");
         $(".mensaje_espera_moda_confirmacion").text("");
         $(".tipo_modal_confirmar").val("eliminar_card_documento");
         $(".data_id").val(data_id);

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);

         //ventanaRegistroExito("Record deleted", "The record has been successfully deleted");
         //return;
          
         $('#btn_cerrar_ventana_confirmacion').css({
            'background-color': COLOR_FONDO_VENTANA_CERRAR,
            'color': COLOR_TEXT_VENTANA_CERRAR,
            'display': "",
         });

         $('#btn_aplicar_ventana_confirmacion').css({
            'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
            'color': COLOR_TEXT_VENTANA_CONFIRMACION,
            'display': "",
         });
 
         $("#ventana_confirmacion").modal("show");

         //$(".card_eliminar_" + data_id).remove();

      });

 
   }
 
   function ventanaRegistroExito(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
       
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }

   function isEmpty(value) {
       // Verificar si es null o undefined
       if (value == null) return true;

       // Verificar si es una cadena vacía
       if (typeof value === "string" && value.trim() === "") return true;

       // Verificar si es un array vacío
       if (Array.isArray(value) && value.length === 0) return true;

       // Verificar si es un objeto vacío
       if (typeof value === "object" && Object.keys(value).length === 0) return true;

       return false;
   }
 
   function validarSoloNumeros(input) {
       const number = parseInt(input, 10);
       return !isNaN(number) && number.toString() === input;
   }

   function validateEmail(email) {
      // Expresión regular para validar un formato de correo electrónico
      var emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
      
      if (emailPattern.test(email)) {
         return true;  // Es un correo válido
      } else {
         return false;  // No es un correo válido
      }
   }
 
   function isInvalidEmail(email) {
      const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      return !emailRegex.test(email);
   }

   function getRandomInt(min, max) {
      return Math.floor(Math.random() * (max - min + 1)) + min;
   }

   function validateFormFields() {
      const fields = [
         { selector: '.observaciones', section: 'Documentation and backup files', name: 'Observations' },
      ];

      for (const field of fields) {
         const value = $(field.selector).val();
         if (value && value.length > 255) {
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector(field.selector);
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               };
               toastr.error(`In "${field.section}" the field "${field.name}" cannot exceed 255 characters.`);
               return true;
         }
      }
      
      return false;
   }

   function generateCardHtml(id, tipo, tipoArchivo, observaciones, downloadUrl, fileName, nombreArchivo = "") {
      // Input validation
      if (!id || !tipo || !tipoArchivo || !downloadUrl) {
         console.error('Missing required parameters in generateCardHtml');
         return '';
      }

      // Sanitize inputs to prevent XSS
      const sanitize = (str) => {
         const div = document.createElement('div');
         div.textContent = str;
         return div.innerHTML;
      };

      const sanitizedId = sanitize(id);
      const sanitizedTipo = sanitize(tipo);
      const sanitizedTipoArchivo = sanitize(tipoArchivo);
      const sanitizedObservaciones = sanitize(observaciones);
      const sanitizedNameArchivo = sanitize(nombreArchivo);
   
      const sanitizedDownloadUrl = String(downloadUrl);
      const sanitizedFileName = fileName ? sanitize(fileName) : `document.${sanitizedTipoArchivo.toLowerCase()}`;

      return `
         <div class="col-12 col-sm-4 pt-4 card_eliminar_${sanitizedId}">
               <div class="card" style="width: 100%; max-width: 300px;">
                  <div class="card-body">
                     <h5 class="card-title">Type: <span class="card_tipo">${sanitizedTipo}</span></h5>
                     <h5 class="card-title">File type: <span class="card_tipo_archivo">${sanitizedTipoArchivo}</span></h5>
                     <h5 class="card-title">File name: <span class="card_nombre_archivo">${sanitizedNameArchivo}</span></h5>
                     <p class="card-text card_observaciones">${sanitizedObservaciones}</p>
                     <div class="row">
                           <div class="col-12">
                              <button class="btn btn-sm btn-eliminar waves-effect waves-themed" data-id="${sanitizedId}">
                                 <i class="fas fa-trash tamano-icono" aria-hidden="true"></i>
                              </button>
                              <a class="btn btn-sm btn-descargar waves-effect waves-themed" data-id="${sanitizedId}" href="${sanitizedDownloadUrl}" download="${sanitizedFileName}">
                                 <i class="fas fa-download tamano-icono" aria-hidden="true"></i>
                              </a>
                           </div>
                     </div>
                  </div>
               </div>
         </div>
      `;
   }

   function ventanaError(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }

   function eliminarDocument(id_)
   {
      let dataFront = {
         id: id_,
      };

      //console.log("dataFront");
      //console.log(JSON.stringify(dataFront));
      //return;

      $.ajax({
         type: "POST",
         url: URL_BASE + "credit/post-delete-back-document-prospeccion",
         data: JSON.stringify(dataFront), // Convertir datos a formato JSON
         contentType: "application/json", // Tipo de contenido JSON
         success: function (response) {
 
            try {
               let info = JSON.parse(response);

               if (info.type == "success") {
 
                  $(".card_eliminar_" + id_).remove();

                  $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
                  $('#btn_close_ventana_confirmacion').prop('disabled', false);
                  $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
                  
                  //$("#ventana_confirmacion").modal("hide");

                  ventanaRegistroExito("Record deleted", "¡The record has been successfully deleted!");

               } else if (info.type == "error") {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: info.message,
                  //});

                  ventanaError("Opps there was an error", info.message);
               }
            } catch (error) {
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);
            }
         },
         error: function (xhr, status, error) {
            console.error("Error en la solicitud:", error);
          
            //Swal.fire({
            //   icon: "error",
            //   title: "Oops...",
            //   text: error,
            //});

            ventanaError("Opps there was an error", error);

         },
      }); 
   }

   function navegarPantallaSiguiente(UUID_ENC_)
   {
      $(".titulo_modal_confirmar").text("Record added");
      $(".mensaje_modal_confirmar").text("¡Record added successfully!");
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("navegar_pantalla_siguiente");
      $(".data_id").val(UUID_ENC_);

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });

      $('#btn_close_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });
 
      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_IR,
         'color': COLOR_TEXT_VENTANA_IR,
         'display': "",
      });

      $('#btn_aplicar_ventana_confirmacion').text("Continue");
 
      $("#ventana_confirmacion").modal("show");
   }

   function select_html_document_type(arreglo) {
      let html = "<option value='' selected disabled >Select a option</option>";
   
      arreglo.forEach(function (element) {
         let {
            id,
            document,
            active,
        } = element;

         html += `<option value="${id}">${document}</option>`;
      });

      return html;
   }
 
</script>
{/literal}


{/block}