<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Invoice payment Quota</title>

    <link rel="icon" href="{{APP_URL}}/storage/system/{get_or_default($config,'icon-32','icon-32x32.png')}" sizes="32x32" />
    <link rel="icon" href="{{APP_URL}}/storage/system/{get_or_default($config,'icon-192','icon-192x192.png')}" sizes="192x192" />
    <link rel="apple-touch-icon" href="{{APP_URL}}/storage/system/{get_or_default($config,'icon-180','icon-180x180.png')}" />
    <meta name="msapplication-TileImage" content="{{APP_URL}}/storage/system/{get_or_default($config,'icon-270','icon-270x270.png')}" />
 

    {if APP_STAGE == 'Dev'}

        {if $config['rtl'] eq '1'}
            <link id="css_app" rel="stylesheet" media="screen, print" href="{{APP_URL}}/ui/theme/default/css/app-rtl.min.css?v={{_raid()}}">
        {else}
            <link id="css_app" rel="stylesheet" media="screen, print" href="{{APP_URL}}/ui/theme/default/css/app.min.css?v={{_raid()}}">

        {/if}

        <link href="{$theme}default/css/themes/{$config['nstyle']}.css?v={{_raid()}}" rel="stylesheet">

    {else}

        {if $config['rtl'] eq '1'}
            <link id="css_app" rel="stylesheet" media="screen, print" href="{{APP_URL}}/ui/theme/default/css/app-rtl.min.css?v=2">
        {else}
            <link id="css_app" rel="stylesheet" media="screen, print" href="{{APP_URL}}/ui/theme/default/css/app.min.css?v=2">
        {/if}

        <link href="{$theme}default/css/themes/{$config['nstyle']}.css?v=13" rel="stylesheet">
    {/if}


   <link
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
      rel="stylesheet"
   />

   <script src="https://unpkg.com/pdf-lib"></script>

   <script src="{$theme}default/js/qrcode.min.js?v={{_raid()}}"></script>
   <script src="{$theme}default/js/jspdf.umd.min.js?v={{_raid()}}"></script>
   <script src="{$theme}default/js/polyfills.umd.js?v={{_raid()}}"></script>
   <script src="{$theme}default/js/jspdf.plugin.autotable.min.js?v={{_raid()}}"></script>


    {block name=style}{/block}

    <script>
        var base_url = '{$_url}';
        var block_msg = '<div class="md-preloader text-center"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" height="32" width="32" viewbox="0 0 75 75"><circle cx="37.5" cy="37.5" r="33.5" stroke-width="6"/></svg></div>';
    </script>

    {$config['header_scripts']}

    <style type="text/css">
        body {

            background-color: #e9ebee;
            overflow-x: visible;
        }
        .paper {
            margin: 20px auto;
            max-width: 980px;
            background-color: #FFF;
            position: relative;

        }

        .fancybox-slide--iframe .fancybox-content {
            width  : 600px;
            max-width  : 80%;
            max-height : 80%;
            margin: 0;
        }

        .panel {

            /*box-shadow: none;*/

            -webkit-box-shadow: 0 10px 40px 0 rgba(18,106,211,.07), 0 2px 9px 0 rgba(18,106,211,.06);
            box-shadow: 0 10px 40px 0 rgba(18,106,211,.07), 0 2px 9px 0 rgba(18,106,211,.06);

        }

        .panel-body {
            padding: 25px;
        }

        {if isset($payment_gateways_by_processor['stripe'])}

        .StripeElement {
            background-color: white;
            height: 40px;
            padding: 10px 12px;
            border-radius: 4px;
            border: 1px solid transparent;
            box-shadow: 0 1px 3px 0 #e6ebf1;
            -webkit-transition: box-shadow 150ms ease;
            transition: box-shadow 150ms ease;
        }

        .StripeElement--focus {
            box-shadow: 0 1px 3px 0 #cfd7df;
        }

        .StripeElement--invalid {
            border-color: #fa755a;
        }

        .StripeElement--webkit-autofill {
            background-color: #fefde5 !important;
        }

        {/if}

        .table-bordered>thead>tr, .table-bordered>thead>tr>th{
            border-bottom-width: 0;
            border-top-width: 0;
        }
        .table-bordered>tbody>tr:first-child {
            border-top-width: 0;
        }

        .table>:not(:first-child) {
            border-top: none;
        }


        .table.invoice-items{
            border: 1px solid #dee2e6;
        }

        .table.invoice-items td, .table.invoice-items th {
            border: 1px solid #dee2e6;
        }

        .table-hover > tbody > tr:hover > * {
            --bs-table-accent-bg: black;
            color: #ffffff;
        }

        .table-striped>tbody>tr:nth-of-type(odd)>* {
            color: #ffffff!important;
        }

        .thead-light th {
            background-color: #5d6675;
        }
        .table-bordered>thead>tr, .table-bordered>thead>tr>th {
            border-bottom-width: 0;
            border-top-width: 0;
        }

    /*    Disable bootstrap 5 table black borders */

      .strong_p p {
        margin: 0;
       }

       
    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    .swal2-container {
         z-index: 9999;
      }

.wrapper {
  overflow: hidden;  
}

ul.breadcrumbs {
  margin: 0;
  padding: 0;
  display: flex; /* Cambiar a flex para un mejor ajuste en pantallas pequeñas */
  flex-wrap: wrap; /* Permitir que los elementos se ajusten en múltiples líneas si es necesario */
  justify-content:center;
}

ul.breadcrumbs li {
  position: relative;
  margin: 0;
  padding: 0;
  list-style: none;
  display: inline-block;
  border-left: 1px solid #ccc;
  transition: 0.3s ease;
}

ul.breadcrumbs li:hover:before {
  /* border-left: 10px solid #5e6e82; */
}

ul.breadcrumbs li:hover a {
  /* color: white;
  background: #5e6e82; */
 
}

ul.breadcrumbs li:before {
  content: "";
  position: absolute;
  right: -9px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 20;
  border-left: 10px solid #fff;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
  transition: 0.3s ease;
}

ul.breadcrumbs li:after {
  content: "";
  position: absolute;
  right: -10px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 10;
  border-left: 10px solid #ccc;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
}

ul.breadcrumbs li.active {
  background: #5e6e82; /* Fondo para el activo */
}

ul.breadcrumbs li.active a {
  color: white !important; /* Color del texto activo */
  padding: 0 15px 0 25px; /* Ajustar el padding */
  background: #5e6e82;
}

ul.breadcrumbs li.first {
  border-left: none;
}

ul.breadcrumbs li.first a {
  font-size: 18px;
  padding-left: 20px;
  border-radius: 5px 0px 0px 5px;
}

ul.breadcrumbs li.last:before {
  display: none;
}

ul.breadcrumbs li.last:after {
  display: none;
}

ul.breadcrumbs li.last a {
  padding-right: 20px;
  border-radius: 0px 40px 40px 0px;
}

ul.breadcrumbs li a {
  display: block;
  font-size: 12px;
  line-height: 40px;
  color: #757575;
  padding: 0px 15px 0px 25px;
  text-decoration: none;
  background: #fff;
  border: 1px solid #ddd;
  white-space: nowrap; /* Evitar que el texto se envuelva */
  overflow: hidden;
  transition: 0.3s ease;
}

ul.breadcrumbs li.active:before {
  display: block; /* Mostrar el triángulo en el activo */
}

ul.breadcrumbs li.active:after {
  display: block; /* Mostrar el triángulo secundario en el activo */
}

@media (max-width: 768px) {
  ul.breadcrumbs {
    flex-direction: column; /* Cambiar a una columna en pantallas más pequeñas */
  }

  ul.breadcrumbs li {
    border-left: none; /* Eliminar el borde izquierdo en pantallas pequeñas */
    margin-bottom: 5px; /* Espaciado entre elementos */
    margin-right: 10px;
  }
}
ul.breadcrumbs li.active:before {
  border-left: 10px solid #5e6e82; /* Cambia el color del triángulo al hacer hover sobre el activo */
}

.cursor_manito {
  cursor: pointer;
}

.grosor_fuente
{
   font-weight: 600;
}

.fondo{
  //background-color: #d1d1d1 !important;
}

.custom-modal-width {
    max-width: 95%;
    width: 95%;
}

.sombra{
   box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
}


.html_listado_cuotas {
   justify-content: center;
}

.titulo_modal_confirmar{
   color: black;
}
.custom-alert {
    position: relative;
    padding:1rem 2.15rem; /* Padding similar a Bootstrap */
    margin-bottom: 1rem; /* Espacio inferior */
    border: 1px solid #c3e6cb; /* Borde sutil */
    border-radius: 0.25rem; /* Bordes redondeados */
    background-color: #d4edda; /* Fondo verde claro */
    color: #155724; /* Texto verde oscuro */
    text-align: center;
    align-content: center;
    transition: opacity 0.15s linear; /* Efecto de desvanecimiento */

    box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
}

.custom-alert .descargar_otraves {
    cursor: pointer;
    margin-top: 0.5rem; /* Espacio encima del ícono */
}

.custom-alert .descargar_otraves i {
    font-size: 26px; /* Tamaño del ícono */
    color: #155724; /* Color del ícono coincide con el texto */
}


    </style>

 

</head>

<body style="background-color: #F9FBFE" >


<input type="text" value="{$url_base}" disabled hidden id="URL_BASE" />

<input type="text" value="{$id_user}" disabled hidden id="ID_USER" />

<input type="text" value="{$fullname}" disabled hidden id="FULLNAME_USER" />


<input type="text" value="{$url_redireccionamiento_principal}" disabled hidden id="url_redireccionamiento_principal" />

<input
   type="text"
   value="{$existe_registro}"
   disabled
   hidden
   id="existe_registro"
/>

<input type="text" value="{$UUID}" disabled hidden id="UUID" />

<div id="qr_code" style="display: none"></div>

<div class="row cargando_pantalla" style="margin: 0px; min-height: 100vh; display: flex; justify-content: center; align-items: center;">
    <div style="
         width: 90%;
         display: flex;
         flex-direction: column; /* Apila los elementos verticalmente */
         justify-content: center;
         align-items: center;
         height: 45vh;
         box-shadow: 0 10px 40px 0 rgba(18,106,211,.07), 0 2px 9px 0 rgba(18,106,211,.06);
         border-radius: 11px;
         background-color: white;
      ">
        <!-- Logo arriba -->
        <img
            src="{{APP_URL}}/storage/system/{{$config['logo_default']}}"
            alt=""
            style="max-width: 100%; width: 213px; height: 152px; margin-bottom: 20px;" /* Espacio debajo del logo */
        />

        <!-- Contenido debajo (spinner y mensaje) -->
        <div class="container" style="text-align: center; width: 100%;">
            <span
                class="spinner-border spinner-border-sm"
                style="height: 45px; width: 45px; margin-bottom: 10px"
                role="status"
                aria-hidden="true"
            ></span>
            <br />
            <strong>Please wait while the information is loading...</strong>
            <br />
        </div>

        <div
            class="container-archivo-descargado"
            style="
                display: flex;
                justify-content: center;
                align-items: center;
                width: 100%;
                display: none;
            "
        >
            <div class="custom-alert">
                !Invoice file downloaded successfully!
                <div class="descargar_otraves">
                    <i class="fas fa-download tamano-icono" aria-hidden="true"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="table-responsive" style="display:none">
   <table
      class="table table-striped table-hover estilosTabla"
      
      id="my-table-download"
      style="margin: 0px"
   >
      <head>
         <tr>
            <th class="centrar fondo"></th>
            <th class="centrar grosor_fuente fondo">PENDING AMOUNT</th>
            <th class="centrar grosor_fuente fondo">APPLIED AMOUNT</th>
            <th class="centrar grosor_fuente fondo">REMAINING BALANCE</th>
         </tr>
      </head>
      <tbody class="tbody_envios_">
         <tr>
            <td class="centrar grosor_fuente fondo">PENALTY FEE</td>
            <td class="centrar _mora_pendiente_valor_pendiente_">-</td>
            <td class="centrar _mora_pendiente_valor_aplicado_">-</td>
            <td class="centrar _mora_pendiente_saldo_pendiente_">-</td>
         </tr>
         <tr>
            <td class="centrar grosor_fuente fondo">INTEREST AMOUNT</td>
            <td class="centrar _interes_pendiente_valor_pendiente_">-</td>
            <td class="centrar _interes_pendiente_valor_aplicado_">-</td>
            <td class="centrar _interes_pendiente_saldo_pendiente_">-</td>
         </tr>
         <tr>
            <td class="centrar grosor_fuente fondo">PRINCIPAL AMOUNT</td>
            <td class="centrar _capital_pendiente_valor_pendiente_">-</td>
            <td class="centrar _capital_pendiente_valor_aplicado_">-</td>
            <td class="centrar _capital_pendiente_saldo_pendiente_">-</td>
         </tr>
         <tr>
            <td class="centrar grosor_fuente fondo">OUTSTANDING BALANCE</td>
            <td class="centrar _saldo_pendiente_valor_pendiente_ ">-</td>
            <td class="centrar _saldo_pendiente_valor_aplicado_">-</td>
            <td class="centrar _saldo_pendiente_saldo_pendiente_">-</td>
         </tr>
      </tbody>
   </table>
</div>

<input type="hidden" id="_url" name="_url" value="{$_url}">
<input type="hidden" id="_df" name="_df" value="{$config['df']}">
<input type="hidden" id="_lan" name="_lan" value="{$config['language']}">


 

{if APP_STAGE == 'Dev'}
    <script src="{{APP_URL}}/ui/theme/default/js/app.min.js?v={_raid()}"></script>
{else}
    <script src="{{APP_URL}}/ui/theme/default/js/app.min.js?v=2"></script>
{/if}

{literal}
<script>

  
   

   var URL_BASE = $("#URL_BASE").val();
   var url_redireccionamiento_principal = $("#url_redireccionamiento_principal").val();

   var UUID = $("#UUID").val();
 
   var ID_USER = $("#ID_USER").val();
   var FULLNAME_USER = $("#FULLNAME_USER").val();
   var url_dashboard = $("#url_dashboard").val();

   var COLOR_FONDO_VENTANA_CERRAR = "#001b3b";
   var COLOR_TEXT_VENTANA_CERRAR = "white";

   var COLOR_FONDO_VENTANA_CONFIRMACION = "red";
   var COLOR_TEXT_VENTANA_CONFIRMACION = "white";

   var COLOR_FONDO_VENTANA_EXISTOSA = "#2CCE89";
   var COLOR_TEXT_VENTANA_EXISTOSA = "white";

   var COLOR_FONDO_VENTANA_IR = "#001b3b";
   var COLOR_TEXT_VENTANA_IR = "white";
 
   var menus_disponibles = {};

   var valor_original_cuota = 0;

   // este sera el que venga en pendientes
   var mora_pendiente_valor_pendiente = 0;
   var interes_pendiente_valor_pendiente = 0;
   var capital_pendiente_valor_pendiente = 0;
   var saldo_pendiente_valor_pendiente = 0;

   //valor aplicado
   var mora_pendiente_valor_aplicado = 0;
   var interes_pendiente_valor_aplicado = 0;
   var capital_pendiente_valor_aplicado = 0;
   var saldo_pendiente_valor_aplicado = 0;

   //valor aplicado
   var mora_pendiente_saldo_pendiente = 0;
   var interes_pendiente_saldo_pendiente = 0;
   var capital_pendiente_saldo_pendiente = 0;
   var saldo_pendiente_saldo_pendiente = 0;

   var credit_history_id = 0;
   var gpi_id = 0;

   var imagen_sistema = "";

   var data_gip = {};

   var zona_horaria = "";

   var valid_saldo_pendiente = 0;

   var detalle_pago =  {} ;
   var informacionEnviar_p = {};
                    
                   

   var arreglo_tabla_resultado = [
     {
            "id": "66",
            "cuotas": "2",
            "cuotas_cantidad": "2 of 12",
            "valor_pagado": 0,
            "mora_pagado": 0,
            "interes_pagado": 0,
            "capital_pagado": 0,
            "mora_pendiente_valor_pendiente": 0,
            "interes_pendiente_valor_pendiente": 288.2,
            "capital_pendiente_valor_pendiente": 1968.26,
            "saldo_pendiente_valor_pendiente": 2256.46,
            "mora_pendiente_valor_aplicado": 0,
            "interes_pendiente_valor_aplicado": 288.2,
            "capital_pendiente_valor_aplicado": 1968.26,
            "saldo_pendiente_valor_aplicado": 2256.46,
            "mora_pendiente_saldo_pendiente": 0,
            "interes_pendiente_saldo_pendiente": 0,
            "capital_pendiente_saldo_pendiente": 0,
            "saldo_pendiente_saldo_pendiente": 0
        },
        {
            "id": "67",
            "cuotas": "3",
            "cuotas_cantidad": "3 of 12",
            "valor_pagado": 0,
            "mora_pagado": 0,
            "interes_pagado": 0,
            "capital_pagado": 0,
            "mora_pendiente_valor_pendiente": 0,
            "interes_pendiente_valor_pendiente": 263.6,
            "capital_pendiente_valor_pendiente": 1992.86,
            "saldo_pendiente_valor_pendiente": 2256.46,
            "mora_pendiente_valor_aplicado": 0,
            "interes_pendiente_valor_aplicado": 263.6,
            "capital_pendiente_valor_aplicado": 479.93999999999994,
            "saldo_pendiente_valor_aplicado": 743.54,
            "mora_pendiente_saldo_pendiente": 0,
            "interes_pendiente_saldo_pendiente": 0,
            "capital_pendiente_saldo_pendiente": 1512.92,
            "saldo_pendiente_saldo_pendiente": 1512.92
        }
   ];

   function procesarValor(valor) {
      // Si el valor es undefined, null o una cadena vacía, retornar 0
      if (isEmpty(valor)) {
         return 0;
      }
      
      // Si es un string, intentar convertirlo a float
      if (typeof valor === 'string') {
         const numero = parseFloat(valor);
         return isNaN(numero) ? 0 : numero; // Si no es un número válido, retornar 0
      }
      
      // Si es un número, retornarlo directamente
      if (typeof valor === 'number') {
         return valor;
      }
      
      // Caso por defecto (otros tipos, como objetos o arrays), retornar 0
      return 0;
   }

   function redondearNumero(numero, decimales) {
      // Validar parámetros
      if (typeof numero !== 'number' || isNaN(numero)) {
         return 0; // Retorna 0 si el número no es válido
      }
      if (typeof decimales !== 'number' || decimales < 0) {
         decimales = 0; // Usar 0 decimales si no es válido o negativo
      }

      // Redondear usando Math.pow y Math.round
      const factor = Math.pow(10, decimales);
      return Math.round(numero * factor) / factor;
   }

   $(document).ready(function () {


      cargarPrincipal();
 
      var _url = '{$_url}';
    
      //para activar el country_hi
      $credito = $(".credito");
      $credito.select2();

      //$('.valor_pagar').autoNumeric('init', {
      //   vMax: '9999999999999999.00', // Máximo permitido
      //   vMin: '-9999999999999999.00', // Mínimo permitido
      //   onChange: function() {
      //         // Este callback se ejecuta cuando el valor cambia
      //         const valor = $('.valor_pagar').autoNumeric('get');
      //         console.log("Valor ingresado (numérico):", valor);
      //   }
      //});

         // También puedes usar el evento 'input' con .autoNumeric('get')
      $('.valor_pagar').on('input', function() {
         let valor = procesarValor($(this).val());
          
         let resultado_recursivo = 0;

         const mora_pendiente_valor_pendiente_copia = mora_pendiente_valor_pendiente;
         const interes_pendiente_valor_pendiente_copia = interes_pendiente_valor_pendiente;
         const capital_pendiente_valor_pendiente_copia = capital_pendiente_valor_pendiente;
         const saldo_pendiente_valor_pendiente_copia = saldo_pendiente_valor_pendiente;

         //valor aplicado
         mora_pendiente_valor_aplicado = 0;
         interes_pendiente_valor_aplicado = 0;
         capital_pendiente_valor_aplicado = 0;
         saldo_pendiente_valor_aplicado = 0;

         mora_pendiente_saldo_pendiente = 0;
         interes_pendiente_saldo_pendiente = 0;
         capital_pendiente_saldo_pendiente = 0;
         saldo_pendiente_saldo_pendiente = 0;

         let texto_dollar = "$";

         if(valor <= 0)
         {
            toastr.error('It cannot be less than zero');
            $('.valor_pagar').val("")

            $(".interes_pendiente_valor_aplicado").text("-");
            $(".mora_pendiente_valor_aplicado").text("-");
            $(".capital_pendiente_valor_aplicado").text("-");

            $(".saldo_pendiente_valor_aplicado").text("-");
            return;
         }

         //resultado_recursivo =  mora_pendiente_valor_pendiente_copia - valor;
         //$(".mora_pendiente_valor_pendiente").text(formatNumber(resultado_recursivo));

         //var mora_pendiente_valor_aplicado = 0;
         //var interes_pendiente_valor_aplicado = 0;
         //var capital_pendiente_valor_aplicado = 0;
         //var saldo_pendiente_valor_aplicado = 0;

         //var mora_pendiente_saldo_pendiente = 0;
         //var interes_pendiente_saldo_pendiente = 0;
         //var capital_pendiente_saldo_pendiente = 0;
         //var saldo_pendiente_saldo_pendiente = 0;

         let resultado_mora = mora_pendiente_valor_pendiente_copia - valor;

         if (resultado_mora <= 0) {
           
            $(".mora_pendiente_saldo_pendiente").text("-");

            mora_pendiente_valor_aplicado = mora_pendiente_valor_pendiente_copia;
            $(".mora_pendiente_valor_aplicado").text(texto_dollar + formatNumber(mora_pendiente_valor_aplicado));

            let valor_restante = Math.abs(resultado_mora);  

            let resultado_interes = interes_pendiente_valor_pendiente_copia - valor_restante;

            if (resultado_interes <= 0) {
               
               $(".interes_pendiente_saldo_pendiente").text("-");
               interes_pendiente_valor_aplicado = interes_pendiente_valor_pendiente_copia;
               $(".interes_pendiente_valor_aplicado").text(texto_dollar + formatNumber(interes_pendiente_valor_aplicado));
               let valor_restante_interes = Math.abs(resultado_interes); 

               let resultado_capital = capital_pendiente_valor_pendiente_copia - valor_restante_interes;
               if (resultado_capital <= 0) {
                     
                     $(".capital_pendiente_saldo_pendiente").text("-");
                     capital_pendiente_valor_aplicado = capital_pendiente_valor_pendiente_copia;
                     $(".capital_pendiente_valor_aplicado").text(texto_dollar + formatNumber(capital_pendiente_valor_aplicado));
               } else {
                     
                     $(".capital_pendiente_saldo_pendiente").text(texto_dollar + formatNumber(resultado_capital));
                     capital_pendiente_valor_aplicado = valor_restante_interes;
                     $(".capital_pendiente_valor_aplicado").text(texto_dollar + formatNumber(capital_pendiente_valor_aplicado));
               }
            } else {
             
               $(".interes_pendiente_saldo_pendiente").text(texto_dollar + formatNumber(resultado_interes));
               interes_pendiente_valor_aplicado = valor_restante;
               $(".interes_pendiente_valor_aplicado").text(texto_dollar + formatNumber(interes_pendiente_valor_aplicado));
               $(".capital_pendiente_valor_aplicado").text("-");
               $(".capital_pendiente_saldo_pendiente").text(texto_dollar + formatNumber(capital_pendiente_valor_pendiente_copia));
            }
         } else {
            
            $(".mora_pendiente_saldo_pendiente").text(texto_dollar + formatNumber(resultado_mora));
            mora_pendiente_valor_aplicado = valor;
            $(".mora_pendiente_valor_aplicado").text(texto_dollar + formatNumber(mora_pendiente_valor_aplicado));
            $(".interes_pendiente_valor_aplicado").text("-");
            $(".interes_pendiente_saldo_pendiente").text(texto_dollar + formatNumber(interes_pendiente_valor_pendiente_copia));
            $(".capital_pendiente_valor_aplicado").text("-");
            $(".capital_pendiente_saldo_pendiente").text(texto_dollar + formatNumber(capital_pendiente_valor_pendiente_copia));
         }

 
         saldo_pendiente_valor_aplicado = 
            mora_pendiente_valor_aplicado + 
            interes_pendiente_valor_aplicado + 
            capital_pendiente_valor_aplicado;
         
 
         $(".saldo_pendiente_valor_aplicado").text(texto_dollar + formatNumber(saldo_pendiente_valor_aplicado));


         let resul = saldo_pendiente_valor_pendiente_copia - saldo_pendiente_valor_aplicado
         
         if (Math.abs(resul) <= 0.0001) {
            resul = 0;
         }

         if(redondearNumero(resul,0) == 0)
         {
            resul = 0;
         }

         $(".saldo_pendiente_saldo_pendiente").text(texto_dollar + formatNumber(resul));
 
         mora_pendiente_saldo_pendiente = mora_pendiente_valor_pendiente_copia - mora_pendiente_valor_aplicado;
         interes_pendiente_saldo_pendiente = interes_pendiente_valor_pendiente_copia - interes_pendiente_valor_aplicado;
         capital_pendiente_saldo_pendiente = capital_pendiente_valor_pendiente_copia - capital_pendiente_valor_aplicado;
         saldo_pendiente_saldo_pendiente = resul;
 
      });
 
      $("#btn_aplicar_ventana_confirmacion").off("click")
      .on("click", function () {

         console.log("se dio click");

            $('#btn_aplicar_ventana_confirmacion').prop('disabled', true);
            $('#btn_close_ventana_confirmacion').prop('disabled', true);
            $('#btn_cerrar_ventana_confirmacion').prop('disabled', true);

            //$(".mensaje_espera_moda_confirmacion").text("Please wait while the process finishes...");

            let opcion_predefinida = $(".tipo_modal_confirmar").val();
            let data_id = $(".data_id").val();

            if(opcion_predefinida == "navegar_pantalla_siguiente")
            {
               window.location = URL_BASE + "credit/reference-prospecting/"+data_id;
            }

            if(opcion_predefinida == "generar_link_pago")
            {
               $("#ventana_confirmacion").modal("hide");

               let valor_pagar = $(".valor_pagar").val();
               let link_pago   = $(".link_pago").val();
               let pasarelas_pagos   = $(".pasarelas_pagos").val();

               if(isEmpty(link_pago) == true)
               {
                  toastr.error('In the "PAYMENT" section the "Payment Type" field is required');
                  return;
               }

               let valor_pagar_num = procesarValor(valor_pagar);

               if(valor_pagar_num <= 0)
               {
                  toastr.error('Cannot be less than zero or empty');
                  return;
               }

               valid_saldo_pendiente = redondearNumero(valid_saldo_pendiente, 2);

               //if(valid_saldo_pendiente < redondearNumero(valor_pagar_num, 2) )
               //{
               //   toastr.error('The amount paid cannot be greater than the value of the amount to be paid.');
               //   return;
               //}

               if(link_pago == 2)
               {
                  if(isEmpty(pasarelas_pagos) == true)
                  {
                     toastr.error('In the "PAYMENT" section the "Payment gateway" field is required');
                     return;
                  }
               }

               console.log("valor_original_cuota");
               console.log(valor_original_cuota);

               //valor aplicado
               //mora_pendiente_valor_aplicado = 0;
               //interes_pendiente_valor_aplicado = 0;
               //capital_pendiente_valor_aplicado = 0;
               //saldo_pendiente_valor_aplicado = 0;

               console.log("mora_pendiente_valor_aplicado");
               console.log(mora_pendiente_valor_aplicado);

               console.log("interes_pendiente_valor_aplicado");
               console.log(interes_pendiente_valor_aplicado);

               console.log("capital_pendiente_valor_aplicado");
               console.log(capital_pendiente_valor_aplicado);

               console.log("saldo_pendiente_valor_aplicado");
               console.log(saldo_pendiente_valor_aplicado);

               console.log("mora_pendiente_saldo_pendiente------------");
               console.log(mora_pendiente_saldo_pendiente);

               console.log("interes_pendiente_saldo_pendiente------------");
               console.log(interes_pendiente_saldo_pendiente);

               console.log("capital_pendiente_saldo_pendiente------------");
               console.log(capital_pendiente_saldo_pendiente);

               console.log("saldo_pendiente_saldo_pendiente------------");
               console.log(saldo_pendiente_saldo_pendiente);

               let tipo_pago = link_pago == 1 ? "CASH" : "PAYMENT LINK" ;

               var informacionEnviar = {
                  gpi_id:            gpi_id,
                  credit_history_id: credit_history_id,
                  ID_USER:           ID_USER,
                  valor_pagar_num:  valor_pagar_num,
                  mora_pendiente_valor_aplicado:                   mora_pendiente_valor_aplicado,
                  interes_pendiente_valor_aplicado:                interes_pendiente_valor_aplicado,
                  capital_pendiente_valor_aplicado:                capital_pendiente_valor_aplicado,
                  saldo_pendiente_valor_aplicado:                  saldo_pendiente_valor_aplicado,
                  mora_pendiente_saldo_pendiente:                  mora_pendiente_saldo_pendiente,
                  interes_pendiente_saldo_pendiente:               interes_pendiente_saldo_pendiente,
                  capital_pendiente_saldo_pendiente:               capital_pendiente_saldo_pendiente,
                  saldo_pendiente_saldo_pendiente:                 saldo_pendiente_saldo_pendiente,
                  fecha_pago:                                      getFechaConZonaHoraria("",zona_horaria),

                  link_pago:         link_pago,
                  tipo_pago:         tipo_pago,
                  pasarelas_pagos:   pasarelas_pagos
               }; 

                

               console.log(JSON.stringify(informacionEnviar));
               //console.log("return aqui abajo")
               //return;
      
               $('input, select, button, textarea').prop('disabled', true);

               $('.loading_guardar_siguiente').css('display', '');
               $('.guardar_siguiente').css('display', 'none');

               if(link_pago == "1")
               {
                  informacionEnviar.tipo_pago = "CASH";
                  generarOrdenPago(informacionEnviar);
               }

               if(link_pago == "2")
               {
                  generarLinkOrdenPago(informacionEnviar);
               }

            }
       
      });

      $("#btn_cerrar_ventana_confirmacion").off("click")
      .on("click", function () {
         
         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         $("#ventana_confirmacion").modal("hide");
       
      });

      $("#btn_close_ventana_confirmacion").off("click")
      .on("click", function () {

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         
         $("#ventana_confirmacion").modal("hide");
       
      });
 

      $('#btn_copiar_hipervinculo').click(function() {

         const url = $('.url_access').attr('href');

         navigator.clipboard.writeText(url)
            .then(() => {
                  alert('URL copied to clipboard: ' + url);  
            })
            .catch(err => {
                  console.error('Error copying URL: ', err);  
            });
      });

     
      $('.btn_cerrar_confirmacion_modal').click(function() {
         $("#modalMensaje").modal("hide");
      });

      $('.abrir_modal_contacto').click(function() {
         $("#modal_asignar_clientes_contactos").modal("show");
      });

      $('.abrir_modal_busquedad_avanzadas').click(function() {
         $(".tbody_filtro_prestamo").html("<tr> <td colspan='7'>No information</td></tr>");

         $(".filtro_buscador_prestamos_avanzada").val("");
         $("#modalBuscarCuotasAvanzadas").modal("show");
      });
           
      $('.btn_cerrar_modal_cuotas_avanzadas').click(function() {
         $("#modalBuscarCuotasAvanzadas").modal("hide");
      });


      $('.btn_cerrar_modal_copiar_link').click(function() {
         $("#modalCopiarLink").modal("hide");
      });
       
      
      $('.btn_cerrar_modal_cuotas').click(function() {
         $("#modalCuotas").modal("hide");
      });

      $('.copiarEnlace').on('click', function() {
         const linkText = $('#paymentLink').text().trim(); // Obtiene el texto del div

         // Intentar copiar usando la API del portapapeles
         navigator.clipboard.writeText(linkText)
               .then(() => {

                  toastr.success('The link was copied successfully');

               })
               .catch(err => {
                  console.error('Error al copiar el link:', err);
                  // Fallback: Usar método alternativo con jQuery
                  const $temp = $('<input>');
                  $('body').append($temp);
                  $temp.val(linkText).select();
                  document.execCommand('copy');
                  $temp.remove();
                  toastr.success('The link was copied successfully');
               });
      });

      $('.consultar_filtros_avanzado').click(function() {
        
         let filtro_buscador_prestamos_avanzada = $(".filtro_buscador_prestamos_avanzada").val() || "";

         if( isEmpty(filtro_buscador_prestamos_avanzada) == true) {
            toastr.error('The loan number field is required.');
            return;
         }

         let enviar_informacion = {
            buscar_prestamo: filtro_buscador_prestamos_avanzada,
         };

         console.log(JSON.stringify(enviar_informacion));
         //return;
         //$("#consultar_filtros").prop("disabled", true);

         $('.consultar_filtros_avanzado, .filtro_buscador_prestamos_avanzada ').prop('disabled', true);
         $('.loading_consultar_filtros_avanzado').css('display', '');
         $('.consultar_filtros_avanzado').css('display', 'none');

         $.ajax({
            type: "POST",
            url: URL_BASE  + "credit/get-data-search-advanced-loan-filter",
            data: JSON.stringify(enviar_informacion),
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               console.log("response")
               console.log(response)

               $('.consultar_filtros_avanzado, .filtro_buscador_prestamos_avanzada ').prop('disabled', false);

               $('.loading_consultar_filtros_avanzado').css('display', 'none');
               $('.consultar_filtros_avanzado').css('display', '');
      
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {
                     
                     let data = info.data || [];

                     console.log("data");
                     console.log(data);

                     if(data.length == 0)
                     {         
                        $(".tbody_filtro_prestamo").html("<tr> <td colspan='7'>No information</td></tr>");
                     }else{
                        $(".tbody_filtro_prestamo").html(tabla_html_filtro_avanzado(data));
                        addPrestamoFiltroAvanzado();
                     }
 
                  } else if (info.type == "error") {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});
                     ventanaError("Opps there was an error", info.message);
                  }

               } catch (error) {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               
               $('.consultar_filtros_avanzado, .filtro_buscador_prestamos_avanzada ').prop('disabled', false);

               $('.loading_consultar_filtros_avanzado').css('display', 'none');
               $('.consultar_filtros_avanzado').css('display', '');

               console.error("Error en la solicitud:", error);
               // Manejar errores aquí
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

            },
         });
          

      });
 
      $('.guardar_siguiente').click(function() {

         let valor_pagar = $(".valor_pagar").val();
         let link_pago   = $(".link_pago").val();
         let pasarelas_pagos   = $(".pasarelas_pagos").val();

         if(isEmpty(link_pago) == true)
         {
            toastr.error('In the "PAYMENT" section the "Payment Type" field is required');
            return;
         }

         let valor_pagar_num = procesarValor(valor_pagar);

         if(valor_pagar_num <= 0)
         {
            toastr.error('Cannot be less than zero or empty');
            return;
         }

         valid_saldo_pendiente = redondearNumero(valid_saldo_pendiente, 2);

         //if(valid_saldo_pendiente < redondearNumero(valor_pagar_num, 2) )
         //{
         //   toastr.error('The amount paid cannot be greater than the value of the amount to be paid.');
         //   return;
         //}

         if(link_pago == 2)
         {
            if(isEmpty(pasarelas_pagos) == true)
            {
               toastr.error('In the "PAYMENT" section the "Payment gateway" field is required');
               return;
            }
         }
 
         $('#btn_aplicar_ventana_confirmacion').text("Confirm")
         ventanaConfirmacion("Generate payment", "Do you want to apply this payment?"); 

      });

      $('.descargar_otraves').click(function() {

          DescargarPDF( informacionEnviar_p , detalle_pago );

      });

       

      $('.credito').on('change', function() {
         const selectedValue = $(this).val(); // Obtiene el valor de la opción seleccionada (id)
         const selectedText = $(this).find('option:selected').text(); // Obtiene el texto de la opción seleccionada (fullname)
         
         console.log('ID seleccionado:', selectedValue);
         console.log('Nombre seleccionado:', selectedText);

         if( isEmpty(selectedValue) == true) {
            toastr.error('Please a valid credit.');
            return;
         }

         let informacionEnviar = {
            id_gip: selectedValue,
         };

         cargarInformacionCuotas(informacionEnviar, "credit/get-data-last-fee", "");
         return;
         

         console.log("informacionEnviar");
         console.log(JSON.stringify(informacionEnviar));

         $(".informacion_seleccionado").css("display", "none");
         $(".cargando_pantalla").css("display", "");

         //$(".pantalla_cargada").css("display", "none");

         valor_original_cuota = 0;

         $(".numero_credito").val("");
         $(".cliente").val("");
         $(".numero_cuota").val("");
         $(".valor_cuota").val("");

         $('.valor_pagar').val("");

         $.ajax({
            type: "POST",
            url: URL_BASE + "credit/get-data-last-fee",
            data: JSON.stringify(informacionEnviar),
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {
   
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {

                     $(".cargando_pantalla").css("display", "none");
                     $(".informacion_seleccionado").css("display", "");
 
                     data_gip = info.data_gip || {};

                     data_gip          = info.data_gip || {};
                     imagen_sistema    = info.base64Image || {};

                     zona_horaria      = info.zona_horaria || "";

                     if(Object.keys(data_gip).length != 0) 
                     {
                        $(".numero_credito").val(data_gip.numero_credito || "");
                        $(".cliente").val(data_gip.account || "");
                        $(".numero_cuota").val(data_gip.no_cuota || "");
                        $(".valor_cuota").val(data_gip.valor_cuota_formateado || "");

                        valor_original_cuota = procesarValor(data_gip.valor_cuota);

                        gpi_id = data_gip.id || 0;
                        
                          

                     } 

                     let data_cuota = info.data_cuota || {};

                     if(Object.keys(data_cuota).length != 0) 
                     {
                        let texto_dollar = "$ ";
 
                        mora_pendiente_valor_pendiente = procesarValor(data_cuota.mora_pendiente) ;
                        interes_pendiente_valor_pendiente = procesarValor(data_cuota.interes_pendiente);
                        capital_pendiente_valor_pendiente = procesarValor(data_cuota.capital_pendiente);
                        saldo_pendiente_valor_pendiente = procesarValor(data_cuota.saldo_pendiente);
                         
                        valid_saldo_pendiente = procesarValor(data_cuota.saldo_pendiente);

                        credit_history_id = data_cuota.id || 0;
 
                        //mora_pendiente_saldo_pendiente = procesarValor(data_cuota.mora_pendiente);
                        //interes_pendiente_saldo_pendiente = procesarValor(data_cuota.interes_pendiente);
                        //capital_pendiente_saldo_pendiente = procesarValor(data_cuota.capital_pendiente);
                        //saldo_pendiente_saldo_pendiente = procesarValor(data_cuota.saldo_pendiente);
                        
                        $(".mora_pendiente_valor_pendiente").text(texto_dollar + formatNumber(mora_pendiente_valor_pendiente));
                        $(".interes_pendiente_valor_pendiente").text(texto_dollar + formatNumber(interes_pendiente_valor_pendiente));
                        $(".capital_pendiente_valor_pendiente").text(texto_dollar +formatNumber(capital_pendiente_valor_pendiente));
                        $(".saldo_pendiente_valor_pendiente").text(texto_dollar +formatNumber(saldo_pendiente_valor_pendiente));

                        $(".mora_pendiente_saldo_pendiente").text(texto_dollar +formatNumber(mora_pendiente_valor_pendiente));
                        $(".interes_pendiente_saldo_pendiente").text(texto_dollar +formatNumber(interes_pendiente_valor_pendiente));
                        $(".capital_pendiente_saldo_pendiente").text(texto_dollar +formatNumber(capital_pendiente_valor_pendiente));
                        $(".saldo_pendiente_saldo_pendiente").text(texto_dollar +formatNumber(saldo_pendiente_valor_pendiente));


                     }

                     //procesarValor(data_gip.valor_cuota);

                     console.log("data_gip");
                     console.log(data_gip);
 
                     $(".cargando_pantalla").css("display", "none");
                     $(".pantalla_cargada").css("display", "");
   
                  } else if (info.type == "error") {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
               // Manejar errores aquí
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

            },
         });

   
      });

      $('.link_pago').on('change', function() {

         let opcion  = $(this).val();

         $(".mostrar_pasarelas_pagos").css("display","none");
         $(".pasarelas_pagos").val("");

         $(".guardar_siguiente").text("Payment quotas");
 
         if(opcion == 2)
         {
            $(".mostrar_pasarelas_pagos").css("display","");

            $(".guardar_siguiente").text("Generate payment link");
         }

      });
       

      $("#consultar_filtros").click(function () {

         let load_number = $(".load_number").val() || "";

         if( isEmpty(load_number) == true) {
            toastr.error('The loan number field is required.');
            return;
         }

         let enviar_informacion = {
            load_number: parseInt(load_number),
         };

         console.log(JSON.stringify(enviar_informacion));
         //return;
         //$("#consultar_filtros").prop("disabled", true);

         $('.load_number').prop('disabled', true);

         $('.loading_consultar_filtros').css('display', '');
         $('.consultar_filtros').css('display', 'none');
          
         let informacionEnviar = {
            load_number: load_number,
         };

         cargarInformacionCuotas(informacionEnviar, "credit/get-data-last-fee-credit-number", "find_load");

  
      });

 
   });

   function generarOrdenPago(informacionEnviar = {})
   {
      $.ajax({
         type: "POST",
         url: URL_BASE + "credit/post-pay-last-fee",
         data: JSON.stringify(informacionEnviar), // Convertir datos a formato JSON
         contentType: "application/json", // Tipo de contenido JSON
         success: function (response) {

            $('input, select, button, textarea').prop('disabled', false);
            $('.numero_credito, .cliente, .numero_cuota, .valor_cuota').prop('disabled', true);

            $('.loading_guardar_siguiente').css('display', 'none');
            $('.guardar_siguiente').css('display', '');

            //console.log("Respuesta del servidor:", response);
            // Hacer algo con la respuesta del servidor

            try {
               let info = JSON.parse(response);

               if (info.type == "success") {

                  informacionEnviar.fecha_pago = info.fecha_pago;

                  arreglo_tabla_resultado =  info.data_cuotas || [];

                  $("#modalCuotas").modal("show");
                  dibujarCantidadCuotasDescargar(informacionEnviar);
 
                  $(".cargando_pantalla").css("display", "none");
                  $(".pantalla_cargada").css("display", "");

                  $(".informacion_seleccionado").css("display", "none");

                  $(".mostrar_pasarelas_pagos").css("display","none");
                  $(".pasarelas_pagos").val("");
                  $(".guardar_siguiente").text("Payment quotas");
          
 
                  $(".valor_pagar").val("");
                  $(".link_pago").val("1");


                  limpiarCampos();

               } else if (info.type == "error") {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: info.message,
                  //});

                  ventanaError("Opps there was an error", info.message);

               }
            } catch (error) {
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error.", error);
            }
         },
         error: function (xhr, status, error) {
            console.error("Error en la solicitud:", error);
            // Manejar errores aquí
            //Swal.fire({
            //   icon: "error",
            //   title: "Oops...",
            //   text: error,
            //});

            ventanaError("Opps there was an error.", error);

            $('input, select, button, textarea').prop('disabled', false);
            $('.numero_credito, .cliente, .numero_cuota, .valor_cuota').prop('disabled', true);

            $('.loading_guardar_siguiente').css('display', 'none');
            $('.guardar_siguiente').css('display', '');

         },
      });
   }

   function generarLinkOrdenPago(informacionEnviar = {})
   {       

      $.ajax({
         type: "POST",
         url: URL_BASE + "credit/generate-link-payment-fee",
         data: JSON.stringify(informacionEnviar), // Convertir datos a formato JSON
         contentType: "application/json", // Tipo de contenido JSON
         success: function (response) {

            $('input, select, button, textarea').prop('disabled', false);
            $('.numero_credito, .cliente, .numero_cuota, .valor_cuota').prop('disabled', true);

            $('.loading_guardar_siguiente').css('display', 'none');
            $('.guardar_siguiente').css('display', '');

            //console.log("Respuesta del servidor:", response);
            // Hacer algo con la respuesta del servidor

            try {
               let info = JSON.parse(response);

               if (info.type == "success") {

                  
                  $("#paymentLink").text(info.url);
                  $("#modalCopiarLink").modal("show");
              
 
                  $(".cargando_pantalla").css("display", "none");
                  $(".pantalla_cargada").css("display", "");

                  $(".informacion_seleccionado").css("display", "none");

                  $(".mostrar_pasarelas_pagos").css("display","none");
                  $(".pasarelas_pagos").val("");
                  $(".guardar_siguiente").text("Payment quotas");
 
                  $(".valor_pagar").val("");
                  $(".link_pago").val("1");

                  limpiarCampos();

               } else if (info.type == "error") {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: info.message,
                  //});

                  ventanaError("Opps there was an error", info.message);

               }
            } catch (error) {
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error.", error);
            }
         },
         error: function (xhr, status, error) {
            console.error("Error en la solicitud:", error);
            // Manejar errores aquí
            //Swal.fire({
            //   icon: "error",
            //   title: "Oops...",
            //   text: error,
            //});

            ventanaError("Opps there was an error.", error);

            $('input, select, button, textarea').prop('disabled', false);
            $('.numero_credito, .cliente, .numero_cuota, .valor_cuota').prop('disabled', true);

            $('.loading_guardar_siguiente').css('display', 'none');
            $('.guardar_siguiente').css('display', '');

         },
      });
   }

   function addPrestamoFiltroAvanzado()
   {
   
      $(".btn_add_prestamo").click(function () {

         let prestamo_id = $(this).data("prestamo_id");

         console.log("prestamo_id");
         console.log(prestamo_id);

         $(".btn_add_prestamo_"+ prestamo_id).css("display","block");
         $('.btn_add_prestamo, .consultar_filtros_avanzado, .filtro_buscador_prestamos_avanzada').prop('disabled', true);

         let informacionEnviar = {
            id_gip: prestamo_id,
         };

         cargarInformacionCuotas(informacionEnviar, "credit/get-data-last-fee", "add_filter_avance");
 
  
      });
   }

   function cargarInformacionCuotas(informacionEnviar = {}, url = "", tipo="")
   {
      console.log("informacionEnviar");
      console.log(JSON.stringify(informacionEnviar));

      $(".informacion_seleccionado").css("display", "none");

      $(".cargando_pantalla").css("display", "");
      //$(".pantalla_cargada").css("display", "none");

      valor_original_cuota = 0;

      $(".numero_credito").val("");
      $(".cliente").val("");
      $(".numero_cuota").val("");
      $(".valor_cuota").val("");

      $('.valor_pagar').val("");

      $.ajax({
         type: "POST",
         url: URL_BASE  + url,
         data: JSON.stringify(informacionEnviar),
         contentType: "application/json", // Tipo de contenido JSON
         success: function (response) {

            if(tipo == "find_load")
            {
               $('.load_number').prop('disabled', false);

               $('.loading_consultar_filtros').css('display', 'none');
               $('.consultar_filtros').css('display', '');
            }


            if(tipo == "add_filter_avance")
            {
               $(".btn_add_prestamo_"+ informacionEnviar.id_gip).css("display","none");
               $('.btn_add_prestamo, .consultar_filtros_avanzado, .filtro_buscador_prestamos_avanzada').prop('disabled', false);
            }
   
            try {
               let info = JSON.parse(response);

               if (info.type == "success") {

                  $(".cargando_pantalla").css("display", "none");
                  $(".informacion_seleccionado").css("display", "");
 
                  data_gip = info.data_gip || {};

                  data_gip          = info.data_gip || {};
                  imagen_sistema    = info.base64Image || {};

                  zona_horaria      = info.zona_horaria || "";

                  if(Object.keys(data_gip).length != 0) 
                  {
                     $(".numero_credito").val(data_gip.numero_credito || "");
                     $(".cliente").val(data_gip.account || "");
                     $(".numero_cuota").val(data_gip.no_cuota || "");
                     //$(".valor_cuota").val(data_gip.valor_cuota_formateado || "");

                     valor_original_cuota = procesarValor(data_gip.valor_cuota);

                     gpi_id = data_gip.id || 0;
                     

                  } 

                  let data_cuota = info.data_cuota || {};

                  if(Object.keys(data_cuota).length != 0) 
                  {
                     let texto_dollar = "$ ";
 
                     mora_pendiente_valor_pendiente = procesarValor(data_cuota.mora_pendiente) ;
                     interes_pendiente_valor_pendiente = procesarValor(data_cuota.interes_pendiente);
                     capital_pendiente_valor_pendiente = procesarValor(data_cuota.capital_pendiente);
                     saldo_pendiente_valor_pendiente = procesarValor(data_cuota.saldo_pendiente);
                      
                     valid_saldo_pendiente = procesarValor(data_cuota.saldo_pendiente);

                     credit_history_id = data_cuota.id || 0;
 
                     //mora_pendiente_saldo_pendiente = procesarValor(data_cuota.mora_pendiente);
                     //interes_pendiente_saldo_pendiente = procesarValor(data_cuota.interes_pendiente);
                     //capital_pendiente_saldo_pendiente = procesarValor(data_cuota.capital_pendiente);
                     //saldo_pendiente_saldo_pendiente = procesarValor(data_cuota.saldo_pendiente);

                     $(".valor_cuota").val(texto_dollar +formatNumber(saldo_pendiente_valor_pendiente));
                     
                     $(".mora_pendiente_valor_pendiente").text(texto_dollar + formatNumber(mora_pendiente_valor_pendiente));
                     $(".interes_pendiente_valor_pendiente").text(texto_dollar + formatNumber(interes_pendiente_valor_pendiente));
                     $(".capital_pendiente_valor_pendiente").text(texto_dollar +formatNumber(capital_pendiente_valor_pendiente));
                     $(".saldo_pendiente_valor_pendiente").text(texto_dollar +formatNumber(saldo_pendiente_valor_pendiente));

                     $(".mora_pendiente_saldo_pendiente").text(texto_dollar +formatNumber(mora_pendiente_valor_pendiente));
                     $(".interes_pendiente_saldo_pendiente").text(texto_dollar +formatNumber(interes_pendiente_valor_pendiente));
                     $(".capital_pendiente_saldo_pendiente").text(texto_dollar +formatNumber(capital_pendiente_valor_pendiente));
                     $(".saldo_pendiente_saldo_pendiente").text(texto_dollar +formatNumber(saldo_pendiente_valor_pendiente));


                  }

                  if(tipo == "add_filter_avance")
                  {
                     $("#modalBuscarCuotasAvanzadas").modal("hide");
                  }


                  console.log("data_gip");
                  console.log(data_gip);
 
                  $(".cargando_pantalla").css("display", "none");
                  $(".pantalla_cargada").css("display", "");
   
               } else if (info.type == "error") {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: info.message,
                  //});

                  ventanaError("Opps there was an error", info.message);

                  $(".cargando_pantalla").css("display", "none");
                  $(".informacion_seleccionado").css("display", "none");
               }
            } catch (error) {
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);
            }
         },
         error: function (xhr, status, error) {
            
            if(tipo == "find_load")
            {
               $('.load_number').prop('disabled', false);

               $('.loading_consultar_filtros').css('display', 'none');
               $('.consultar_filtros').css('display', '');
            }

            if(tipo == "add_filter_avance")
            {
               $(".btn_add_prestamo_"+ informacionEnviar.id_gip).css("display","none");
               $('.btn_add_prestamo, .consultar_filtros_avanzado, .filtro_buscador_prestamos_avanzada').prop('disabled', false);
            }

            console.error("Error en la solicitud:", error);
            // Manejar errores aquí
            //Swal.fire({
            //   icon: "error",
            //   title: "Oops...",
            //   text: error,
            //});

            ventanaError("Opps there was an error", error);

         },
      });
   }

   function resizeImageBase64(base64String, maxWidth, maxHeight) {
      return new Promise((resolve, reject) => {
         // Agregar prefijo si no está presente
         let fullBase64 = base64String;
         if (!base64String.startsWith('data:image/')) {
               fullBase64 = 'data:image/png;base64,' + base64String; // Ajusta el tipo si es necesario
               //console.log("Base64 corregido:", fullBase64); // Depuración
         }

         const img = new Image();
         img.src = fullBase64;

         img.onload = () => {
               const canvas = document.createElement('canvas');
               const ctx = canvas.getContext('2d');

               if (ctx) {
                  const canvasWidth = maxWidth;
                  const canvasHeight = maxHeight;

                  let width = img.width;
                  let height = img.height;

                  if (width > height) {
                     if (width > maxWidth) {
                           height *= maxWidth / width;
                           width = maxWidth;
                     }
                  } else {
                     if (height > maxHeight) {
                           width *= maxHeight / height;
                           height = maxHeight;
                     }
                  }

                  const x = (canvasWidth - width) / 2;
                  const y = (canvasHeight - height) / 2;

                  canvas.width = canvasWidth;
                  canvas.height = canvasHeight;

                  ctx.fillStyle = 'rgba(0, 0, 0, 0)'; // Transparente
                  ctx.fillRect(0, 0, canvasWidth, canvasHeight);

                  ctx.drawImage(img, x, y, width, height);

                  const resizedBase64 = canvas.toDataURL('image/png', 1);
                  resolve(resizedBase64);
               } else {
                  reject(new Error('El contexto 2D del lienzo no se ha creado correctamente.'));
               }
         };

         img.onerror = (error) => {
               console.error("Error al cargar la imagen:", error);
               reject(new Error('No se pudo cargar la imagen desde la cadena base64.'));
         };
      });
   }
 

   async function generarPDF(informacionEnviar = {})
   {

      //const qrCodeContainer = document.createElement("div");
      //qrCodeContainer.id = "qrcode";
      //document.body.appendChild(qrCodeContainer);

      let base64Image = $('#qr_code img').attr('src');

      //console.log("imagen_sistema");
      //console.log(imagen_sistema);
      //return;

      const resizedBase64 = await resizeImageBase64(imagen_sistema, 400, 400);

      let valor_pagar = $(".valor_pagar").val();

      let valor_pagar_num = procesarValor(valor_pagar);

      // Acceder a jsPDF desde el módulo UMD
      const { jsPDF } = window.jspdf;

      // Crear nuevo documento PDF
      const doc = new jsPDF({
          orientation: "portrait",
          unit: "px",
          format: "letter"
      });

      // Dimensiones de la imagen
      const imgWidth = 100; // Ancho de la imagen en px
      const imgHeight = 100; // Alto de la imagen en px
      const pageWidth = doc.internal.pageSize.getWidth(); // Ancho de la página
      const x = (pageWidth - imgWidth) / 2; // Centrar horizontalmente
      const y = -10; // 20 px desde la parte superior

      // Agregar imagen centrada
      doc.addImage(resizedBase64, 'PNG', x, y, imgWidth, imgHeight);
 
      // Generar segunda tabla con alto de filas ajustado
      doc.autoTable({
          startY: 60,
          body: [
              [
                  {
                      content: data_gip.telefono_empresa  ,
                      styles: { fontStyle: 'bold', halign: 'center', fontSize: 8 },
                      colSpan: 4
                  }
              ]
          ],
           
          rowStyles: {
              0: { minCellHeight: 20 }, // Alto mínimo para la primera fila
              1: { minCellHeight: 20 }, // Alto mínimo para la segunda fila
              2: { minCellHeight: 20 }  // Alto mínimo para la tercera fila
          },
          styles: {
              fontSize: 8,
              textColor: [0, 0, 0],
              cellPadding: 2 // Ajusta el relleno interno para controlar el espacio vertical
          },

          theme: 'plain'
      });


      const ancho = doc.internal.pageSize.width;  // 792 px
      const alto = doc.internal.pageSize.height;  // 612 px

      // Dibujar una línea horizontal usando las dimensiones dinámicas
      const lineaY = doc.lastAutoTable.finalY + 10; // Altura basada en la última tabla + 10px
      const margen = 20; // Margen de 10px a izquierda y derecha
      doc.setDrawColor(35, 31, 32); // Color rojo (RGB)
      doc.setLineWidth(1); // Grosor de 3px (ajusta según necesites)
      doc.line(margen, lineaY, ancho - margen, lineaY);

      const nextTableStarty = doc.lastAutoTable.finalY + 15; 
 
      doc.autoTable({
         startY: nextTableStarty,
         body: [

            [
               {
                   content: "CREDIT PAYMENT RECEIPT",
                   styles: {
                       fontStyle: "bold",
                       fontSize: 8,
                       halign: "center"
                   },
               },
                 
            ],                  
         ],
         styles: {
             fontSize: 8,
             textColor: [0, 0, 0],
             cellPadding: 2
         },
         margin: { left: 20, right: 20 },
         theme: 'plain'
      });

      // Calcular la posición Y para la cuarta tabla
      const nextTableStartY2_ = doc.lastAutoTable.finalY + 2;

      // Generar cuarta tabla combinada
      doc.autoTable({
         startY: nextTableStartY2_,
         body: [
            [
                  {
                     content: "No. CREDIT: " + data_gip.numero_credito,
                     colSpan: 2,
                     styles: {
                        fontStyle: "bold",
                        fontSize: 8,
                        halign: "left" // Etiqueta alineada a la izquierda
                     },
                  },
                  {
                     content: "NO. QUOTAS: " + informacionEnviar.numero_cuotas,
                     colSpan: 2,
                     styles: {
                        fontStyle: "bold",
                        fontSize: 8,
                        halign: "right" // Valor alineado a la derecha
                     }
                  },
            ],
            [
                  {
                     content: "Customer: " + data_gip.account,
                     colSpan: 2,
                     styles: {
                        fontStyle: "bold",
                        fontSize: 8,
                        halign: "left" // Etiqueta alineada a la izquierda
                     },
                  },
                  {
                     content: "VALUE PAID: " + "$ " + formatNumber(informacionEnviar.monto_real_aplicado),
                     colSpan: 2,
                     styles: {
                        fontStyle: "bold",
                        fontSize: 8,
                        halign: "right" // Valor alineado a la derecha
                     }
                  },
            ],

            /*
            [
                  { content: '', styles: { fontStyle: 'bold' } }
            ],
            [
                  { content: '', styles: { fontStyle: 'bold' } }
            ],
            [
                  {
                     content: "NO. QUOTAS: " + informacionEnviar.numero_cuotas,
                     styles: {
                        fontStyle: "bold",
                        fontSize: 8,
                        halign: "left" // Etiqueta alineada a la izquierda
                     },
                  },
                  //{
                  //   content: informacionEnviar.numero_cuotas,
                  //   colSpan: 3,
                  //   styles: {
                  //      fontStyle: "bold",
                  //      fontSize: 8,
                  //      halign: "right" // Valor alineado a la derecha
                  //   }
                  //},
            ],
            [
                  {
                     content: "SHARE VALUE: " + "$ " + informacionEnviar.valor_real_cuota,
                     styles: {
                        fontStyle: "bold",
                        fontSize: 8,
                        halign: "left" // Etiqueta alineada a la izquierda
                     },
                  },
                  //{
                  //   content: "$ " + informacionEnviar.valor_real_cuota,
                  //   colSpan: 3,
                  //   styles: {
                  //      fontStyle: "bold",
                  //      fontSize: 8,
                  //      halign: "right" // Valor alineado a la derecha
                  //   }
                  //},
            ],

            */
         ],
         columnStyles: {
            //0: { cellWidth: 80 },
            //1: { cellWidth: 100 },
            //2: { cellWidth: 100 },
            //3: { cellWidth: 80 }
         },
         styles: {
            fontSize: 8,
            textColor: [0, 0, 0],
            cellPadding: 2
         },
         margin: { left: 20, right: 20 },
         theme: 'plain',
         didParseCell: (data) => {
            if (data.row.index === 2) {
                  data.row.height = 10; // Altura en px para la fila vacía
            }
         },
         didDrawCell: (data) => {
            if (data.row.index === 2) {
                  const { x, y, width } = data.cell;
                  doc.setDrawColor(35, 31, 32); // Color (aproximadamente marrón oscuro)
                  doc.setLineWidth(1); // Grosor moderado
                  doc.line(x, y + data.cell.height - 1, x + width, y + data.cell.height - 1); // Línea al fondo de la celda
            }
         }
      });

      // Calcular la posición Y para la cuarta tabla
 
 
      // Calcular la posición Y para el texto (después de la tabla)
      //const textY = doc.lastAutoTable.finalY + 20; // 20 px de margen después de la tabla
      //const pageWidth_ = doc.internal.pageSize.getWidth();
      //const text = "PAYMENT PLAN"; // Reemplaza con tu texto
      //const textWidth = doc.getTextWidth(text); // Ancho del texto
      //const textX = (pageWidth_ - textWidth + 20) / 2; // Posición x centrada

      // Añadir el texto centrado
      //doc.setFont('', 'bold');
      //doc.setFontSize(8);

      // Registrar la fuente Cabin Bold
      //doc.addFileToVFS('Cabin-Bold.ttf', fuente);
      //doc.addFont('Cabin-Bold.ttf', 'Cabin', 'bold');

      // Configurar la fuente y tamaño
      //doc.setFont('', 'bold');
      //doc.setFontSize(8);

      //doc.text(text, textX, textY);
 
      let nextTableStartY = doc.lastAutoTable.finalY + 4; // 10 px de margen después de la primera tabla

      doc.autoTable({
         html: '#my-table-download',
         startY: nextTableStartY,
         theme: 'plain',
         margin: { left: 20, right: 20 },
         headStyles: {
            fillColor: [0, 0, 0], // Black background for header
            textColor: [255, 255, 255], // White text for contrast
            fontStyle: 'bold',
            halign: 'center'
         },
         bodyStyles: {
            fillColor: [255, 255, 255], // Fondo blanco por defecto para el cuerpo
            textColor: [0, 0, 0], // Texto negro
            halign: 'center',
            valign: 'middle'
         },
         styles: {
            fontSize: 8,
            lineWidth: 1,
            lineColor: [0, 0, 0],
            fillColor: [255, 255, 255] // Fondo blanco por defecto
         },
         didParseCell: (data) => {
            let columnasPermitidas = [0, 1, 2, 3]; 

            let filasPermitidas = [0, 1, 2, 3, 4]; 

            // Cambiar el color de fondo y aumentar el grosor del texto
            if (data.row.index === 0 && columnasPermitidas.includes(data.column.index)) {
                  data.cell.styles.fillColor = [217, 217, 217]; // Color #D9D9D9
                  data.cell.styles.fontStyle = 'bold'; // Asegurar estilo bold
                  data.cell.styles.fontSize = 8; // Aumentar tamaño para simular grosor
            }


            // Cambiar el color de fondo y aumentar el grosor del texto
            if ( filasPermitidas.includes(data.row.index) && data.column.index == 0) {
                  data.cell.styles.fillColor = [217, 217, 217]; // Color #D9D9D9
                  data.cell.styles.fontStyle = 'bold'; // Asegurar estilo bold
                  data.cell.styles.fontSize = 8; // Aumentar tamaño para simular grosor
            }

            // Cambiar el color de fondo y aumentar el grosor del texto
            if (data.row.index === 4 && columnasPermitidas.includes(data.column.index)) {
                  data.cell.styles.fillColor = [217, 217, 217]; // Color #D9D9D9
                  
            }
         }
      });

      // Calcular la posición Y para la cuarta tabla
      const nextTableStartYFinal = doc.lastAutoTable.finalY + 10;

      let body_final = [];

      let usuario_sistema = "";

      if(isEmpty(FULLNAME_USER) == false)
      {
         usuario_sistema = FULLNAME_USER;
         /*
         body_final.push(
           [
                 {
                    content: "USER BOX: " + FULLNAME_USER,
                    styles: {
                       fontStyle: "bold",
                       fontSize: 8,
                       halign: "left"
                    },
                 },
                 {
                    content: "PAYMENT DATE: " + informacionEnviar.fecha_pago,
                    colSpan: 3,
                    styles: {
                       fontStyle: "bold",
                       fontSize: 8,
                       halign: "right"
                    }
                 },
           ]

         );
         */
      }else{
         usuario_sistema = "USER SYSTEM";
      }
 

      // Generar cuarta tabla combinada
      doc.autoTable({
         startY: nextTableStartYFinal,
         body: [
            
            [
                 {
                    content: "USER BOX: " + usuario_sistema,
                    colSpan: 2,
                    styles: {
                       fontStyle: "bold",
                       fontSize: 8,
                       halign: "left"
                    },
                 },
                 {
                    content: "PAYMENT DATE: " + informacionEnviar.fecha_pago,
                    colSpan: 2,
                    styles: {
                       fontStyle: "bold",
                       fontSize: 8,
                       halign: "right"
                    }
                 },
           ],

             
            [
                  { content: '', styles: { fontStyle: 'bold' } }
            ],

            [
                  { content: '', styles: { fontStyle: 'bold' } }
            ],

            /*
            //data
            [
                  {
                     content: "PAYMENT DATE: " + informacionEnviar.fecha_pago,
                     styles: {
                        fontStyle: "bold",
                        fontSize: 8,
                        halign: "left"
                     },
                  },
                  //{
                  //   content:  informacionEnviar.fecha_pago,
                  //   colSpan: 3,
                  //   styles: {
                  //      fontStyle: "bold",
                  //      fontSize: 8,
                  //      halign: "right"
                  //   }
                  //},
            ],

            [
                  { content: '', styles: { fontStyle: 'bold' } }
            ],

            [
                  { content: '', styles: { fontStyle: 'bold' } }
            ],
 
             
            //data
            [
                  {
                     content: "VALUE PAID: " + "$ " + formatNumber(informacionEnviar.monto_real_aplicado),
                     styles: {
                        fontStyle: "bold",
                        fontSize: 8,
                        halign: "left"
                     },
                  },
                  //{
                  //   content: "$ " + formatNumber(informacionEnviar.monto_real_aplicado),
                  //   colSpan: 3,
                  //   styles: {
                  //      fontStyle: "bold",
                  //      fontSize: 8,
                  //      halign: "right"
                  //   }
                  //},
            ],

            [
                  { content: '', styles: { fontStyle: 'bold' } }
            ],

            [
                  { content: '', styles: { fontStyle: 'bold' } }
            ],
            */
             
         ],
         columnStyles: {
            //0: { cellWidth: 80 },
            //1: { cellWidth: 100 },
            //2: { cellWidth: 100 },
            //3: { cellWidth: 80 }
         },
         styles: {
            fontSize: 8,
            textColor: [0, 0, 0],
            cellPadding: 2
         },
         margin: { left: 20, right: 20 },
         theme: 'plain',
         didParseCell: (data) => {
            if (data.row.index === 2) {
                  data.row.height = 3; // Altura en px para la fila vacía
            }

            if (data.row.index === 4) {
                  data.row.height = 10; // Altura en px para la fila vacía
            }

            if (data.row.index === 7) {
                  data.row.height = 10; // Altura en px para la fila vacía
            }
         },
         didDrawCell: (data) => {
            if (data.row.index === 1) {
                  const { x, y, width } = data.cell;
                  doc.setDrawColor(35, 31, 32); // Color rojo
                  doc.setLineWidth(1); // Grosor moderado
                  doc.line(x, y + data.cell.height - 1, x + width, y + data.cell.height - 1); // Línea al fondo de la celda
            }

            if (data.row.index === 4) {
                  const { x, y, width } = data.cell;
                  doc.setDrawColor(35, 31, 32); // Color rojo
                  doc.setLineWidth(1); // Grosor moderado
                  doc.line(x, y + data.cell.height - 1, x + width, y + data.cell.height - 1); // Línea al fondo de la celda
            }

            if (data.row.index === 7) {
                  const { x, y, width } = data.cell;
                  doc.setDrawColor(35, 31, 32); // Color rojo
                  doc.setLineWidth(1); // Grosor moderado
                  doc.line(x, y + data.cell.height - 1, x + width, y + data.cell.height - 1); // Línea al fondo de la celda
            }
         }
      });

      const nextTableStarty___ = doc.lastAutoTable.finalY + 15; 
 
      doc.autoTable({
         startY: nextTableStarty___,
         body: [

            [
               {
                   content: "Avoid late payment interest charges by paying your installments on time.",
                   styles: {
                       fontStyle: "bold",
                       fontSize: 8,
                       halign: "center"
                   },
               },
                 
            ],                  
         ],
         styles: {
             fontSize: 8,
             textColor: [0, 0, 0],
             cellPadding: 2
         },
         margin: { left: 20, right: 20 },
         theme: 'plain'
      });

      const nextTableStarty____ = doc.lastAutoTable.finalY + 5; 
 
      doc.autoTable({
         startY: nextTableStarty____,
         body: [

            [
               {
                   content: "Thank you for your payment",
                   styles: {
                       fontStyle: "bold",
                       fontSize: 8,
                       halign: "center"
                   },
               },
                 
            ],                  
         ],
         styles: {
             fontSize: 8,
             textColor: [0, 0, 0],
             cellPadding: 2
         },
         margin: { left: 20, right: 20 },
         theme: 'plain'
      });

      const tamano_qr= doc.lastAutoTable.finalY + 5; 

      // Calcular la posición horizontal centrada usando doc.internal.pageSize.width
      const pageWidth_qr = doc.internal.pageSize.width; // Ancho de la página en puntos (595 para A4)
      const qrWidth = 50; // Ancho del QR en puntos
      const xPosition = (pageWidth_qr - qrWidth) / 2; // Centrado en puntos

      // Añadir el QR centrado horizontalmente
      doc.addImage(base64Image, "PNG", xPosition, tamano_qr, qrWidth, qrWidth); // x, y, width, height

 

      // Guardar el PDF
      doc.save("payment quotas.pdf");

      $(".container").css("display", "none");
      $(".container-archivo-descargado").css("display", "flex");

      //window.location = url_redireccionamiento_principal;

      //$(".loading_descarga_cuota_" + informacionEnviar.cuota_actual).css("display", "none");
   }

   function dibujarCantidadCuotasDescargar(informacionEnviar = {})
   {
      let html = "";
      

      $(".html_listado_cuotas").html(html);
 
      DescargarPDF(informacionEnviar);
   }

   function delay(ms) {
      return new Promise(resolve => setTimeout(resolve, ms));
   }

   async function DescargarPDF(informacionEnviar = {}, informacionTabla = {})
   {
      
      let texto_dollar = "$ ";

      let {
         id,
         cuotas,
         cuotas_cantidad,
         mora_pendiente_valor_pendiente,
         interes_pendiente_valor_pendiente,
         capital_pendiente_valor_pendiente,
         saldo_pendiente_valor_pendiente,
         mora_pendiente_valor_aplicado,
         interes_pendiente_valor_aplicado,
         capital_pendiente_valor_aplicado,
         saldo_pendiente_valor_aplicado,
         mora_pendiente_saldo_pendiente,
         interes_pendiente_saldo_pendiente,
         capital_pendiente_saldo_pendiente,
         saldo_pendiente_saldo_pendiente,
         url_codigo_qr,
         UUID,
         UUID_ENC,
      } = informacionTabla;

      $(".loading_descarga_cuota_" + cuotas).css("display", "block");

      $("._mora_pendiente_valor_pendiente_").text(texto_dollar +  formatNumber(procesarValor(mora_pendiente_valor_pendiente)) );

      $("._interes_pendiente_valor_pendiente_").text( texto_dollar +  formatNumber(procesarValor(interes_pendiente_valor_pendiente)) );
      $("._capital_pendiente_valor_pendiente_").text( texto_dollar +  formatNumber(procesarValor(capital_pendiente_valor_pendiente)) );
      $("._saldo_pendiente_valor_pendiente_").text( texto_dollar +  formatNumber(procesarValor(saldo_pendiente_valor_pendiente)) );
 

      $("._mora_pendiente_valor_aplicado_").text( texto_dollar +  formatNumber(procesarValor(mora_pendiente_valor_aplicado)) );
      $("._interes_pendiente_valor_aplicado_").text( texto_dollar +  formatNumber(procesarValor(interes_pendiente_valor_aplicado)) );
      $("._capital_pendiente_valor_aplicado_").text( texto_dollar +  formatNumber(procesarValor(capital_pendiente_valor_aplicado)) );
      $("._saldo_pendiente_valor_aplicado_").text( texto_dollar +  formatNumber(procesarValor(saldo_pendiente_valor_aplicado)) );

      $("._mora_pendiente_saldo_pendiente_").text( texto_dollar +  formatNumber(procesarValor(mora_pendiente_saldo_pendiente)) );
      $("._interes_pendiente_saldo_pendiente_").text( texto_dollar +  formatNumber(procesarValor(interes_pendiente_saldo_pendiente)) );
      $("._capital_pendiente_saldo_pendiente_").text( texto_dollar +  formatNumber(procesarValor(capital_pendiente_saldo_pendiente)) );
      $("._saldo_pendiente_saldo_pendiente_").text( texto_dollar +  formatNumber(procesarValor(saldo_pendiente_saldo_pendiente)) );

      informacionEnviar.monto_real_aplicado = saldo_pendiente_valor_aplicado;

      informacionEnviar.numero_cuotas = cuotas_cantidad;
      informacionEnviar.cuota_actual = cuotas;

      informacionEnviar.url_codigo_qr = url_codigo_qr;
      informacionEnviar.UUID          = UUID;
      informacionEnviar.UUID_ENC      = UUID_ENC;

      informacionEnviar.valor_real_cuota = formatNumber(procesarValor(saldo_pendiente_valor_pendiente))  ;

      $("#qr_code").html("");

      new QRCode("qr_code", {
         text: informacionEnviar.url_codigo_qr,  
         width: 128,
         height: 128,
         colorDark: "#000000",
         colorLight: "#ffffff",
         correctLevel: QRCode.CorrectLevel.H // Nivel de corrección de errores
      });

       

      delay(600).then((data) => {
         //console.log("Hola "); //ayuda cesar
         generarPDF(informacionEnviar);
      });
      
   }

   const formatNumber = (number) => {
      return Number(number).toLocaleString('en-US', {
         minimumFractionDigits: 2,
         maximumFractionDigits: 2
      });
   };

 
   function cargarPrincipal()
   {

      let informacion = {
         UUID: UUID
      };

      console.log(JSON.stringify(informacion));


      //console.log("aqui abajo return");
      //return;
 
      $.ajax({
         type: "POST",
         url: URL_BASE + "credit-view/get-data-report-quotas",
         data: JSON.stringify(informacion),
         contentType: "application/json", // Tipo de contenido JSON
         success: function (response) {
   
            try {
               let info = JSON.parse(response);

               if (info.type == "success") {


                  data_gip = info.data_gip || {} ;

                  let data = info.data || {} ;

                  imagen_sistema    = info.base64Image_logo || "";
 
                  detalle_pago = info.detalle_pago || {} ;
                  informacionEnviar_p = {
                    fecha_pago: data.fecha_pago,
                  };

                  DescargarPDF( informacionEnviar_p , detalle_pago );

                  console.log("data_gip");
                  console.log(data_gip);

                  //let listado_general_informacion = info.listado_general_informacion || [];
 
                  //let options = '<option value="" selected disabled>Select a credit</option>';
 

                  //$(".credito").html(options);

                  //let listado_pasarela_pago = info.listado_pasarela_pago || [];
                  //let options_pg = '<option value="" selected disabled>Select a option</option>';

                
                  //$(".pasarelas_pagos").html(options_pg);
               
                  //$(".cargando_pantalla").css("display", "none");
                  //$(".pantalla_cargada").css("display", "");


   
               } else if (info.type == "error") {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: info.message,
                  //});

                  ventanaError("Opps there was an error", info.message);
               }
            } catch (error) {
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);
            }
         },
         error: function (xhr, status, error) {
            console.error("Error en la solicitud:", error);
            // Manejar errores aquí
            //Swal.fire({
            //   icon: "error",
            //   title: "Oops...",
            //   text: error,
            //});

            ventanaError("Opps there was an error", error);

         },
      });

   }

   function navegarPantallaSiguiente(UUID_ENC_)
   {
      $(".titulo_modal_confirmar").text("Record added");
      $(".mensaje_modal_confirmar").text("¡Record added successfully!");
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("navegar_pantalla_siguiente");
      $(".data_id").val(UUID_ENC_);

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });

      $('#btn_close_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });
 
      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_IR,
         'color': COLOR_TEXT_VENTANA_IR,
         'display': "",
      });

      $('#btn_aplicar_ventana_confirmacion').text("Continue");
 
      $("#ventana_confirmacion").modal("show");
   }


   function isEmpty(value) {
       // Verificar si es null o undefined
       if (value == null) return true;

       // Verificar si es una cadena vacía
       if (typeof value === "string" && value.trim() === "") return true;

       // Verificar si es un array vacío
       if (Array.isArray(value) && value.length === 0) return true;

       // Verificar si es un objeto vacío
       if (typeof value === "object" && Object.keys(value).length === 0) return true;

       return false;
   }
 
   function validarSoloNumeros(input) {
       const number = parseInt(input, 10);
       return !isNaN(number) && number.toString() === input;
   }

   function validateEmail(email) {
      // Expresión regular para validar un formato de correo electrónico
      var emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
      
      if (emailPattern.test(email)) {
         return true;  // Es un correo válido
      } else {
         return false;  // No es un correo válido
      }
   }
 
   function ventanaError(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });

      $('#btn_aplicar_ventana_confirmacion').text("Close")
 
      $("#ventana_confirmacion").modal("show");
   }

   function getFechaConZonaHoraria(dateString = "", timeZone = "America/Tegucigalpa") {
      

      return "";
   }

   function ventanaRegistroExito(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
       
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }

   function tabla_html_filtro_avanzado(arreglo) {
      let html = "";
 
      arreglo.forEach(function (element) {
         let { id, numero_credito, account, phone, numero_cuotas, valor_cuota_formateado, no_cuota } = element;

         //<th class="centrar">Credit number</th>
         //<th class="centrar">Name</th>
         //<th class="centrar">Phone</th>
         //<th class="centrar">Amount Quota</th>
         //<th class="centrar">Quota value</th>
         //<th class="centrar">Quota stage</th>

         html +=
            "<tr>" +
            //
            "<td class='centrar'>" +
            numero_credito +
            "</td>" +
            //
            "<td class='centrar'>" +
            account +
            "</td>" +
            //
            "<td class='centrar'>" +
            phone +
            "</td>" +
            //
            "<td class='centrar'>" +
            numero_cuotas +
            "</td>" +
            //
            //
            "<td class='centrar'>" +
            valor_cuota_formateado +
            "</td>" +
            //
            //
            "<td class='centrar'>" +
            no_cuota +
            "</td>" +
            //
            "<td class='centrar'>" +
            "<button class='btn  btn_add_prestamo' type='button' data-prestamo_id='" +
            id +
            "' style='border-color: #d3cac0;border: 1px solid #d3cac0;background-color: white;'> <span class='spinner-border spinner-border-sm btn_add_prestamo_" +id+ "' style='height: 18px; width: 18px; margin-right: 5px; display: none;' role='status' aria-hidden='true'></span> Add  </button>" +
            "</td>" +
            "</tr>";
      });
 

      return html;
   }

   function ventanaConfirmacion(titulo, mensaje) 
   {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("generar_link_pago");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': "rgb(95 98 101)",
         'color': COLOR_TEXT_VENTANA_CERRAR
      });
 
      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_EXISTOSA,
         'color': COLOR_TEXT_VENTANA_EXISTOSA,
         'display': ""
      });
 
      $("#ventana_confirmacion").modal("show");
   }

   function limpiarCampos()
   {
      $(".mora_pendiente_valor_pendiente").text("-");
      $(".interes_pendiente_valor_pendiente").text("-");
      $(".capital_pendiente_valor_pendiente").text("-");
      $(".saldo_pendiente_valor_pendiente").text("-");


      $(".mora_pendiente_valor_aplicado").text("-");
      $(".interes_pendiente_valor_aplicado").text("-");
      $(".capital_pendiente_valor_aplicado").text("-");
      $(".saldo_pendiente_valor_aplicado").text("-");

      $(".mora_pendiente_saldo_pendiente").text("-");
      $(".interes_pendiente_saldo_pendiente").text("-");
      $(".capital_pendiente_saldo_pendiente").text("-");
      $(".saldo_pendiente_saldo_pendiente").text("-");

      // otra tablas--
      $("._mora_pendiente_valor_pendiente_").text("-");
      $("._interes_pendiente_valor_pendiente_").text("-");
      $("._capital_pendiente_valor_pendiente_").text("-");
      $("._saldo_pendiente_valor_pendiente_").text("-");


      $("._mora_pendiente_valor_aplicado_").text("-");
      $("._interes_pendiente_valor_aplicado_").text("-");
      $("._capital_pendiente_valor_aplicado_").text("-");
      $("._saldo_pendiente_valor_aplicado_").text("-");

      $("._mora_pendiente_saldo_pendiente_").text("-");
      $("._interes_pendiente_saldo_pendiente_").text("-");
      $("._capital_pendiente_saldo_pendiente_").text("-");
      $("._saldo_pendiente_saldo_pendiente_").text("-");


   }

</script>
{/literal}




{block name=script}{/block}

 

<script>
 
</script>


{$config['footer_scripts']}
</body>

</html>
