{extends file="$layouts_admin"}


{block name="head"}
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.6.2/css/buttons.dataTables.min.css" />
{/block}




{block name="content"}
    <div class="row">
        <div class="col-md-12">
            <div class="panel">
                <div class="panel-hdr">
                    <h2>List of WhatsApp/SMS configuration</h2>

                    <div class="panel-toolbar">
                        <a href="{$_url}settings/add-config-whatsapp-sms" class="btn btn-primary"> Add New</a>

                    </div>

                    <input value="{$_url}" hidden disabled id="URL_BASE" />

              

                </div>
                <div class="panel-container">
                    <div class="panel-content">

                        <div class="table-responsive">
                            <table class="table table-striped" id="clx_datatable">
                                <thead style="background: #f0f2ff">
                                <tr>
                                    <th style="width: 60px;background: #f0f2ff">Identifier</th>
                                    <th>Token WS</th>
                                    <th>Phone WS</th>
                                    <th>Phone Identifier WS</th>
                                    <th>Business account identifier WS</th>
                                    <th>Account Sid TW</th>
                                    <th>Auth Token TW</th>
                                    <th>Phone Number TW</th>
                                    <th>Created At</th>
                                    <th>Status Whatsapp</th>
                                    <th>Status SMS</th>
                                    <th class="text-end">Manager</th>
                                </tr>
                                </thead>
 
                                {foreach $d as $ds}
                                    <tr>
                                        <td>{$ds['identifier']}</td>
                                        <td>{$ds['token']}</td>
                                        <td>{$ds['phone']}</td>
                                        <td>{$ds['phone_identifier']}</td>
                                        <td>{$ds['whatsapp_business_account_identifier']}</td>
                                        <td>{$ds['sms_account_sid']}</td>
                                        <td>{$ds['sms_auth_token']}</td>
                                        <td>{$ds['sms_phone_number']}</td>
                                        <td>{$ds['fecha_creacion']}</td>
                                        <td>
                                            {if $ds['enable_whatsapp'] == 1}
                                                  Active
                                            {/if}

                                            {if $ds['enable_whatsapp'] == 2}
                                                  Inactive
                                            {/if}
                                        
                                        </td>

                                        <td>
                                            {if $ds['enable_twilio'] == 1}
                                                  Active
                                            {/if}

                                            {if $ds['enable_twilio'] == 2}
                                                  Inactive
                                            {/if}
                                        
                                        </td>
                                         
                                        <td>
                                            <div class="btn-group float-end">
                                                <a href="{$_url}settings/update-config-whatsapp-sms/{$ds['id']}" class="btn btn-primary btn-sm"><i class="fal fa-pencil"></i> </a>
                                                {if ($_user['username']) neq ($ds['username'])}
                                                    <a  id="{$ds['id']}" data-id_data="{$ds['id']}" class="btn btn-danger btn-sm cdelete"><i class="fal fa-trash-alt"></i> </a>
                                                {/if}

                                            </div>

                                        </td>
                                    </tr>
                                {/foreach}


                            </table>
                        </div>


                    </div>





                </div>
            </div>



        </div>



    </div>



{/block}

{block name="script"}

 
    <script>
        $(function () {
            $('#clx_datatable').dataTable({
                responsive: true,
                "language": {
                    "emptyTable": "{$_L['No items to display']}",
                    "info":      "{$_L['Showing _START_ to _END_ of _TOTAL_ entries']}",
                    "infoEmpty":      "{$_L['Showing 0 to 0 of 0 entries']}",
                    buttons: {
                        pageLength: '{$_L['Show all']}'
                    },
                    searchPlaceholder: "{__('Search')}"
                },
            });
        });

        $(document).ready(function() {
            // Delegación de eventos para elementos dinámicos
            $(document).on('click', '.cdelete', function(e) {
                e.preventDefault();
                
                // Obtener todos los data-atributos
                const id = $(this).data('id_data');
               
                let url = $('#URL_BASE').val();

                //console.log(url);
                
                // Mostrar confirmación
                Swal.fire({
                    title: 'Confirm deletion?',
                    text: "Are you about to delete the configuration?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Yes, delete',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Redireccionar a la URL de eliminación
                        window.location.href = url + "settings/disabled-config-whatsapp-sms/" + id;
                    }
                });
            });
        });

        //href="{$_url}settings/disabled-config-whatsapp-sms/{$ds['id']}"


    </script>
 

{/block}
