{extends file="$layouts_admin"}
{block name="head"}

   <link href="{$theme}default/css/grupo.css?v={$config['version']}" rel="stylesheet">
   <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.6.2/css/buttons.dataTables.min.css" />



{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    table.estilosTabla > :not(caption) > * > * {
        /*
        padding-top: 5px !important;
        padding-bottom: 5px !important;
        */
    }

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
        
    }

</style>
<div class="row">

    <div class="col-md-12">

       
        <div class="panel">
            <div class="panel-hdr">
                <h2 style="color: #666; font-weight: 600; "><span></span>General Form List</h2>
                <input type="text" class=" tener_url_base" value={$url_base} disabled hidden/>
                <input type="text" class=" tener_role_id" value={$roleid} disabled hidden   />

                <input type="text" class=" tener_parametro_staff_id"  value={$parametro_staff_id}   disabled hidden  />
                <input type="text" class=" tener_parametro_estado_id" value={$parametro_estado_id}  disabled hidden  />

                <input type="text" class=" tener_url_formulario_w7" value={$url_form_w7}   disabled hidden  />
                <input type="text" class=" tener_url_formulario_656" value={$url_form_656}  disabled hidden   />
                <input type="text" class=" tener_url_formulario_433" value={$url_form_433}  disabled hidden   />

                 
            </div>
                                                         
            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">

                    <div class="px-2">
                        
                        <div class="row contenedor" style="padding: 10px">

                           {* formulario *}
                            <div class="col-12 col-sm-12 pt-3">
                                <label for="category_form"><span style="color:#666;">Category Form</span> </label>
                                
                                <select
                                    class="form-select form-control-sm tener_category_form"
                                    name="category_form"
                                    id="category_form"
                                    style="width: 100%"
                                    placeholder="Select a Forms"
                                >
                                    <option value="" >All</option>
                                    {foreach $listado_formulario as $ds}
                                        <option value="{$ds['id']}" >{$ds['name']}</option>
                                    {/foreach}
                                </select>
                            </div>

                           {* listado de estados *}
                            <div class="col-12 col-sm-12 pt-3">
                                <label for="state_form"><span style="color:#666;">State Form</span> </label>
                                <select
                                    class="form-select form-control-sm tener_state_form"
                                    name="state_form"
                                    id="state_form"
                                    style="width: 100%"
                                    placeholder="Select a state forms"
                                >
                                    <option value="">All</option>

                                    {foreach $listado_form_state as $ds}
                                        <option value="{$ds['id']}" >{$ds['name']}</option>
                                    {/foreach}
                                </select>
                            </div>

                            {* listado de staff *}
                            <div class="col-12 col-sm-12 pt-3">
                                <label for="state_form"><span style="color:#666;">Staff</span> </label>
                                <select
                                    class="form-select form-control-sm tener_staff"
                                    name="staff"
                                    id="staff"
                                    style="width: 100%"
                                    placeholder="Select a Staff"
                                   
                                >
                                    <option value="" >All</option>
                                    {foreach $listado_staff as $ds}
                                        <option value="{$ds['id']}" >{$ds['fullname']}</option>
                                    {/foreach}
                                </select>
                            </div>

                           {* listado de estados *}
                            <div class="col-12 col-sm-12 pt-3">
                                <label for="customers"><span style="color:#666;">Customer</span> </label>
                                <select
                                    class="form-select form-control-sm tener_customers"
                                    name="customers"
                                    id="customers"
                                    style="width: 100%"
                                    placeholder="Select a state forms"
                                >
                                    <option value="">All</option>

                                    {foreach $listado_clientes as $ds}
                                       <option value="{$ds['id']}" data-email="{$ds['email']}" data-account="{$ds['account']}" >{$ds['account']}</option>
                                    {/foreach}
                                </select>
                            </div>


                            {* fecha desde *}
                            <div class="col-12 col-sm-6 pt-3">
                                <label for="fecha_desde"
                                    ><span style="color:#666;">Date from</span>
                                </label>
                                <input
                                    type="date"
                                    id="fecha_desde"
                                    name="fecha_desde"
                                    class="form-control form-control-sm tener_fecha_desde"
                                />
                            </div>

                           {* fecha hasta *}
                            <div class="col-12 col-sm-6 pt-3">
                                <label for="fecha_hasta"
                                    ><span style="color:#666;">Date to date</span>
                                </label>
                                <input
                                    type="date"
                                    id="fecha_hasta"
                                    name="fecha_hasta"
                                    class="form-control form-control-sm tener_fecha_hasta"
                                />
                            </div>
 
 
                            <div class="col-12 col-sm-12 pt-3">
                                <button
                                    type="button"
                                    class="btn btn-default"
                                    id="consultar_filtros"
                                    style="
                                        border-color: #d3cac0;
                                        border: 1px solid #d3cac0;
                                        float: right;
                                    "
                                >
                                    Search
                                </button>
                            </div>

   
                           
                            <br />
                             
                            <div class="col-12 col-sm-12 pt-4">
                            
                            
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover mt-3 estilosTabla"  id="clx_datatable">
                                        <thead>
                                        <tr>
                                            <th class="centrar">Forms</th>
                                            <th class="centrar">Staff</th>
                                            <th class="centrar">Customers</th>
                                            <th class="centrar">Creation date</th>
                                            <th class="centrar">Days since creation</th>
                                            <th class="centrar">Update date</th>
                                            <th class="centrar">Days since last update</th>
                                            <th class="centrar">State</th>
                                            <th class="centrar">Action</th>
                                        </tr>
                                        </thead>
                                        <tbody class="tbody_envios">
                                           {$tabla_informacion}
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            </div>

                       
                    </div>

                  

                </div>
 
                
               
            </div>
        </div>
    </div>
</div>




{/block}

{block name="script"}

<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.2/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.2/js/buttons.html5.min.js"></script>

<script>
   const URL_BASE      = $(".tener_url_base").val();
   const API_FORM_BASE = URL_BASE.includes('?ng=') ? URL_BASE.split('?ng=')[0] + 'api/form/' : URL_BASE + 'api/form/';
   const tener_role_id = $(".tener_role_id").val();

   let tener_parametro_estado_id = $(".tener_parametro_estado_id").val();
   let tener_parametro_staff_id  = $(".tener_parametro_staff_id").val();

   let tener_url_formulario_w7  = $(".tener_url_formulario_w7").val();
   let tener_url_formulario_656  = $(".tener_url_formulario_656").val();
   let tener_url_formulario_433  = $(".tener_url_formulario_433").val();

 
  
    

    //cargar_usuarios_sistema().then((listado_usuarios_admin) =>{
    //    $(".tener_usuario_id").html(
    //        select_html_usuario_sistema(listado_usuarios_admin),
    //    );
    //});

   $country = $(".tener_customers");
   $country.select2();

   let fecha = cargar_fecha();
   $(".tener_fecha_desde").val(fecha);
   $(".tener_fecha_hasta").val(fecha);

 
   if(tener_parametro_estado_id != "/" && tener_parametro_estado_id != "" && tener_parametro_estado_id != null && tener_parametro_estado_id != "disabled" )
   {
      $(".tener_state_form").val(tener_parametro_estado_id);
   }


   if(tener_parametro_staff_id != "/" && tener_parametro_staff_id != "" && tener_parametro_staff_id != null && tener_parametro_staff_id != "disabled" )
   {
      $(".tener_staff").val(tener_parametro_staff_id);
   }

    //$('#clx_datatable').DataTable();
 
 
   EventoDescargarPDF();

    
         $("#consultar_filtros").click(function () {

            //tener_category_form
            //tener_state_form
            //tener_customers
            //tener_fecha_desde
            //tener_fecha_hasta
            //tener_staff

            let tener_category_form = $(".tener_category_form").val() || "";
            let tener_state_form    = $(".tener_state_form").val() || "";
            let tener_customers     = $(".tener_customers").val() || "";
            let tener_fecha_desde   = $(".tener_fecha_desde").val() || "";
            let tener_fecha_hasta   = $(".tener_fecha_hasta").val() || "";
            let tener_staff   = $(".tener_staff").val() || "";

            if(isEmpty(tener_fecha_desde) == true)
            {
                toastr.error("!From date is required¡");
                return;
            }

            if(isEmpty(tener_fecha_hasta) == true)
            {
                toastr.error("!Date by is required¡");
                return;
            }

            let enviar_informacion = {
               fecha_desde: tener_fecha_desde,
               fecha_hasta: tener_fecha_hasta,
               category_form: tener_category_form,
               state_form: tener_state_form,
               customers: tener_customers,
               staff: tener_staff,
               
               role_id: tener_role_id,
            };

            console.log(enviar_informacion);
            //console.log("aqui abajo ahi un return");
            //return;

            $("#consultar_filtros").prop("disabled", true);

            $.ajax({
               type: "POST",
               url: URL_BASE + "forms/tener-listado-formularios",
               data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
               contentType: "application/json", // Tipo de contenido JSON
               success: function (response) {
                  $("#consultar_filtros").prop("disabled", false);
                  //console.log("Respuesta del servidor:", response);
                  // Hacer algo con la respuesta del servidor
                  //$("#myModal").modal("hide");
                  $(".tbody_envios").html("");

                  try {
                     let info = JSON.parse(response);
                     if (info.type == "success") {
                        let arr = info.data;

                        if (arr == "") {
                           $(".tbody_envios").html(
                              '<tr><th colspan="9" class="centrar pt-4"> No information</th></tr>',
                           );
                        } else {
                           $(".tbody_envios").html(arr);

                           EventoDescargarPDF();
                        }

                        /*  if (Array.isArray(arr)) {
                           if (arr.length != 0) {
                              var newRow = "";

                              arr.forEach((element) => {
                                 let {
                                    id,
                                    campaign,
                                    crm_groups_id,
                                    channel,
                                    template,
                                    send_date,
                                    configuration_whatsapp_other_id,
                                    contacts_total,
                                    contact_sent,
                                    contacts_pending,
                                    state_description,
                                    state,
                                    users_id,
                                    user_fullname,
                                    user_username,
                                    config_identifier,
                                 } = element;

                                 // Crear una nueva fila de la tabla concatenando cadenas
                                 newRow +=
                                    "<tr>" +
                                    '<td class="centrar">' +
                                    send_date +
                                    "</td>" +
                                    '<td class="centrar">' +
                                    channel +
                                    "</td>" +
                                    '<td class="centrar">' +
                                    campaign +
                                    "</td>" +
                                    '<td class="centrar">' +
                                    config_identifier +
                                    "</td>" +
                                    '<td class="centrar">' +
                                    contacts_total +
                                    "</td>" +
                                    '<td class="centrar">' +
                                    contact_sent +
                                    "</td>" +
                                    '<td class="centrar">' +
                                    contacts_pending +
                                    "</td>" +
                                    '<td class="centrar">' +
                                    state_description +
                                    "</td>" +
                                    "</tr>";
                              });

                              // Agregar la nueva fila al tbody
                              $(".tbody_envios").html(newRow);
                           } else {
                              $(".tbody_envios").html(
                                 '<tr><th colspan="8" class="centrar pt-4"> No information</th></tr>',
                              );
                           }
                        }
                      */
                     } else {
                        alert("Error sending group messages");
                     }
                  } catch (error) {
                     $(".tbody_envios").html("");
                     alert("Error:" + error);
                  }
               },
               error: function (xhr, status, error) {
                  $("#consultar_filtros").prop("disabled", false);
                  $(".tbody_envios").html("");
                  console.error("Error en la solicitud:", error);
               },
            });
         });

          

         function EventoDescargarPDF()
         {
            $(".btnView").click( async  function () {

               const dataId = $(this).data('id');
               const formulario_categoria = $(this).data('formulario_categoria');
                
               console.log('El valor de data-formulario_categoria es:', formulario_categoria);

               if(formulario_categoria == 1)
               {
                   
                  if(isEmpty(dataId) == true)
                  {
                     alert("Error al obtener el id del formulario");
                     return;
                  }

                  descargar_formulario_656(dataId);
                   
               }

               if(formulario_categoria == 2)
               {
                  //443

                  if(isEmpty(dataId) == true)
                  {
                     alert("Error al obtener el id del formulario");
                     return;
                  }

                  descargar_formulario_433(dataId);
               }

               if(formulario_categoria == 3)
               {
                  //w7
                  if(isEmpty(dataId) == true)
                  {
                     alert("Error al obtener el id del formulario");
                     return;
                  }


                  descargar_formulario_w7(dataId);
               }


                

                 

            });
         }

         async function descargar_formulario_w7(UUID_ENC)
         {

            //processPdfForm();
            //return;
            
            let enviar_informacion = {
               //UUID_ENC: "Z2ndkLE2TcSVEAAD862oow",
                UUID_ENC: UUID_ENC,
               
            };

            console.log(enviar_informacion);
            //console.log("aqui abajo ahi un return");
            //return;

            $.ajax({
               type: "POST",
               url: API_FORM_BASE + 'w7/' + encodeURIComponent(UUID_ENC),
               data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
               contentType: "application/json",  
               success: function (response) {
              
                  try {

                     let data = response.data || {};

                     console.log(data);

                     construir_pdf_formulario_w7(data);
 
         
                  } catch (error) {
                     alert("Error:" + error);
                  }
               },
               error: function (xhr, status, error) {
                 
                  console.error("Error en la solicitud:", error);
               },
            });
 
            /*
            let data = {
                  "id": "19",
                  "UUID": "6769dd90-b136-4dc4-9510-0003f3ada8a3",
                  "UUID_ENC": "Z2ndkLE2TcSVEAAD862oow",
                  "forms_id": "15",
                  "aplicar_nuevo_ITIN": "1",
                  "renovar_ITIN": "0",
                  "renovar_aplicar_a": "1",
                  "renovar_aplicar_b": "1",
                  "renovar_aplicar_c": "1",
                  "renovar_aplicar_d": "1",
                  "renovar_aplicar_d_opcional": "primo",
                  "renovar_aplicar_e": "1",
                  "renovar_aplicar_d_e_opcional": "juana",
                  "renovar_aplicar_f": "1",
                  "renovar_aplicar_a_f_pais_tratado_opcional": "Enter treaty country",
                  "renovar_aplicar_a_f_numero_articulo_tratado_opcional": "Enter treaty article number",
                  "renovar_aplicar_g": "1",
                  "renovar_aplicar_h": "1",
                  "renovar_aplicar_h_opcional": "prueba unitaria",
                  "nombre_primer_nombre1": "First name (1) ",
                  "nombre_segundo_nombre1": "Middle name (1)",
                  "nombre_ultimo_nombre1": "Last name (1)",
                  "nombre_primer_nombre2": "First name (2)",
                  "nombre_segundo_nombre2": "Middle name (2)",
                  "nombre_ultimo_nombre2": "Last name (2)",
                  "direccion_apartado_postal": "Street address, apartment number, or rural route number.  11",
                  "direccion_ciudad_apartado_postal": "City or town, state or province, and country. Include ZIP code or postal code where appropriate.  11",
                  "direccion_no_apartado_postal": "Street address, apartment number, or rural route number.111",
                  "direccion_ciudad_no_apartado_postal": "City or town, state or province, and country. Include postal code where appropriate. 11",
                  "informacion_nacimiento_fecha_nacimiento": "2024-12-11",
                  "informacion_nacimiento_pais_nacimiento": "Vanuatu",
                  "informacion_nacimiento_ciudad_estado_provincia": "City and state or province (optional)",
                  "informacion_nacimiento_genero": "Male",
                  "otra_informacion_pais_ciudadania": "Uruguay",
                  "otra_informacion_numero_identificacion_fiscal_extranjero": "Foreign tax I.D. number",
                  "otra_informacion_tipo_visa_estadounidense": "Type of U.S. visa",
                  "otra_informacion_pasaporte": "1",
                  "otra_informacion_licencia_conducir": "0",
                  "otra_informacion_documentacion_USCIS": "1",
                  "otra_informacion_otros": "1",
                  "otra_informacion_otros_opcional": "nada",
                  "otra_informacion_expedido_por": "Issued by ",
                  "otra_informacion_No": "ejemplo No",
                  "otra_informacion_fecha_caducidad": "2024-12-11",
                  "otra_informacion_fecha_entrada_usa": "2025-01-01",
                  "otra_informacion_recibido_ITIN_o_IRSN": "Yes",
                  "otra_informacion_ITIN1": "111",
                  "otra_informacion_ITIN2": "22",
                  "otra_informacion_ITIN3": "3333",
                  "otra_informacion_IRSN1": "222",
                  "otra_informacion_IRSN2": "33",
                  "otra_informacion_IRSN3": "4444",
                  "otra_informacion_ITIN_IRSN_primer_nombre": "First name",
                  "otra_informacion_ITIN_IRSN_segundo_nombre": "Middle name ",
                  "otra_informacion_ITIN_IRSN_apellido": "Last name",
                  "otra_informacion_nombre_universidad_empresa": "Name of college/university",
                  "otra_informacion_ciudad_estado": "City and state ",
                  "otra_informacion_duracion_estancia": "Length of stay",
                  "firma_nombre_delegado": "Name of delegate, if applicable ",
                  "firma_fecha_delegado": "2024-12-23",
                  "firma_telefono_delegado": "Phone number 1",
                  "firma_nombre_madre": "1",
                  "firma_tutor_designado_tribunal": "1",
                  "firma_poder_legal": "1",
                  "agente_nombre_titulo": "Name and title ",
                  "agente_nombre_compania": "Name of company 1",
                  "agente_fecha": "2024-12-23",
                  "agente_EIN": "EIN ",
                  "agente_PTIN": "PTIN ",
                  "agente_office_code": "Office code",
                  "fecha_post": "2024-12-23 17:03:05",
                  "fecha_update": "2024-12-24 10:23:35",
                  "firma_firma_solicitante": "Signature of applicant (if delegate, see instructions) ",
                  "firma_fecha_solicitante": "2024-12-23",
                  "firma_firma": "Signature ",
                  "firma_fecha": "2024-12-23",
                  "firma_fax1": "Fax *",
                  "firma_telefono1": "112222112xd"
               };
               */

             
         }

         async function descargar_formulario_656(UUID_ENC)
         {
            //https://jsfiddle.net/Hopding/skevywdz/2/
            //https://pdf-lib.js.org/

            //processPdfForm();
            //return;
            
            let enviar_informacion = {
               UUID_ENC: UUID_ENC,
               
            };

            console.log(enviar_informacion);
            //console.log("aqui abajo ahi un return");
            //return;

  
           $.ajax({
               type: "POST",
               url: API_FORM_BASE + '656/' + encodeURIComponent(UUID_ENC),
               data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
               contentType: "application/json",  
               success: function (response) {
              
                  try {
                     let info = (typeof response === "string") ? JSON.parse(response) : response;
                     if (info.type == "success") {

                        let data = info.data || {};

                        console.log(data);

                         crear_pdf_656(data);
 
                     } else {
                        alert(info.message);
                     }
                  } catch (error) {
                     alert("Error:" + error);
                  }
               },
               error: function (xhr, status, error) {
                 
                  console.error("Error en la solicitud:", error);
               },
            });
             

               return;
            

            let data = {
                  "id": "24",
                  "UUID": "67577387-5721-403b-a067-0009b52d25f3",
                  "UUID_ENC": "Z1dzh1chQDugZwAJtS0l8w",
                  "forms_id": "4",
                  "herramientas_llenado": "No",
                  "tipo_negocio_personal": "Personal",
                  "seccion1_nombre_completo": "Your first name, middle initial, last name * Section 1 xd",
                  "seccion1_numero_ssn1": "111",
                  "seccion1_numero_ssn2": "11",
                  "seccion1_numero_ssn3": "1111",
                  "seccion1_nombre_completo_conjugue": "If a joint offer, spouse's first name, middle initial, last name * Section 1 xd\n",
                  "seccion1_numero_ssn1_conjugue": "222",
                  "seccion1_numero_ssn2_conjugue": "33",
                  "seccion1_numero_ssn3_conjugue": "4444",
                  "seccion1_direccion_fiscal_domicilio": "Your home physical address (street, city, state, ZIP code, county of residence) * xd",
                  "seccion1_direccion_postal_domicilio": "Your home mailing address (if different from above or post office box number) * Section 1 xd\n",
                  "seccion1_confirmacion_nueva_direccion": "No",
                  "seccion1_confirmacion_actualizar_direccion": "Yes",
                  "seccion1_numero_identificacion_empleador1": "Your Employer Identification Numbe  1 xd",
                  "seccion1_numero_identificacion_empleador2": "Your Employer Identification Numbe  2 xd",
                  "seccion1_pii_opcion1": "1",
                  "seccion1_pii_opcion1_opcional": "Individual Tax Periods 1 xd",
                  "seccion1_pii_opcion2": "1",
                  "seccion1_pii_opcion2_opcional": "ddddd",
                  "seccion1_pii_opcion3": "1",
                  "seccion1_pii_opcion3_opcional": "ssss",
                  "seccion1_pii_opcion4": "1",
                  "seccion1_pii_opcion4_opcional": "aaaaaa",
                  "seccion1_pii_opcion5": "1",
                  "seccion1_pii_opcion5_opcional": "asdasdas",
                  "seccion1_pii_opcion6": "Individual Tax Periods 6 xd",
                  "seccion1_certificacion_bajo_ingresos1": "1",
                  "seccion1_certificacion_bajo_ingresos2": "0",
                  "seccion2_nombre_negocio": "",
                  "seccion2_direccion_fiscal_empresa": "",
                  "seccion2_direccion_postal_empresa": "",
                  "seccion2_numero_identificacion_empleador1": "",
                  "seccion2_numero_identificacion_empleador2": "",
                  "seccion2_nombre_titulo_contacto_primario": "",
                  "seccion2_numero_telefono1": "",
                  "seccion2_numero_telefono2": "",
                  "seccion2_numero_telefono3": "",
                  "seccion2_pii_opcion1": "0",
                  "seccion2_pii_opcion1_opcional": "",
                  "seccion2_pii_opcion2": "0",
                  "seccion2_pii_opcion2_opcional": "",
                  "seccion2_pii_opcion3": "0",
                  "seccion2_pii_opcion3_opcional": "",
                  "seccion2_pii_opcion4": "0",
                  "seccion2_pii_opcion4_opcional": "",
                  "seccion2_pii_opcion5": "",
                  "seccion3_motivo_oferta1": "1",
                  "seccion3_motivo_oferta2": "0",
                  "seccion3_motivo_oferta3": "0",
                  "seccion4_condicion_pago": "Periodic Payment",
                  "seccion2_monto_total": "0",
                  "seccion2_pago_inicial": "0",
                  "seccion2_saldo_restante": "0",
                  "seccion4_monto_pago1": "",
                  "seccion4_monto_pago2": "",
                  "seccion4_monto_pago3": "",
                  "seccion4_monto_pago4": "",
                  "seccion4_monto_pago5": "",
                  "seccion2_monto_total_pago_periodico": "111",
                  "seccion2_pago_periodico1": "333",
                  "seccion2_pago_periodico2": "44",
                  "seccion2_pago_periodico3": "555",
                  "seccion2_pago_periodico4": "677",
                  "seccion2_pago_periodico5": "688",
                  "seccion2_pago_periodico6": "999",
                  "seccion2_pago_periodico7": "3555",
                  "seccion5_periodo_impositivo": "Section 5  tell us the tax period/quarter 1 xd",
                  "seccion5_tarifa_solicitud_ofertas": "Section 5 Offer application fee xd",
                  "seccion5_fecha_tarifa_solicitud_ofertas": "2024-12-24",
                  "seccion5_transferencia_electronica_tarifa_solicitud_ofertas": "Section 5 (Electronic funds transfer number (15 digits)) Offer application fee xd",
                  "seccion5_pago_oferta": "Section 5 Offer payment  xd",
                  "seccion5_fecha_pago_oferta": "2024-12-31",
                  "seccion5_transferencia_electronica_pago_oferta": "Section 5 (Electronic funds transfer number (15 digits)) Offer application fee xd",
                  "seccion6_descripcion_origen_fondo": "Section 6  Tell us where you will obtain the funds to pay your offer xd",
                  "seccion6_campo1_requisitos": "0",
                  "seccion6_campo2_requisitos": "0",
                  "seccion6_campo2_requisitos_opcional": "",
                  "seccion6_campo1_requisitos_pago": "0",
                  "seccion6_campo2_requisitos_pago": "0",
                  "seccion6_campo3_requisitos_pago": "0",
                  "seccion6_campo4_requisitos_pago": "0",
                  "seccion8_telefono_nombre_corporativo": "Section 8 pn Signature of Taxpayer/Corporation Name xd",
                  "seccion8_fecha_nombre_corporativo": "2024-12-27",
                  "seccion8_check_nombre_corporativo": "0",
                  "seccion8_telefono_firma_conyugue": "Section 8 pn Signature of Spouse/Authorized Corporate Officer xd",
                  "seccion8_fecha_firma_conyugue": "2025-01-10",
                  "seccion8_check_firma_conyugue": "0",
                  "seccion9_telefono_firma_preparadora": "Section 9 Paid Preparer Use Only PN xd",
                  "seccion9_fecha_firma_preparadora": "2025-04-03",
                  "seccion9_check_firma_preparadora": "0",
                  "seccion9_nombre_preparadora_pagada": "Section 9 Name of Paid Preparer xd",
                  "seccion9_numero_CAF_preparadora": "Section 9 Preparer's CAF no. or PTIN xd",
                  "seccion9_nombre_empresa_preparadora": "Section 9 Firm's name (or yours if self-employed), address, and ZIP code xd",
                  "seccion9_titulo_preparadora": "",
                  "seccion9_fecha_preparadora": "",
                  "fecha_post": "2024-12-13 14:58:41",
                  "fecha_update": null,
                  "seccion8_firma_contribuyente": "Signature of Taxpayer/Corporation Name 1",
                  "seccion8_firma_conyugue": "Signature of Spouse/Authorized Corporate Officer  1",
                  "seccion9_nombre_firma_preparadora": "Signature of Preparer 1"
               };

            let {
                
               aplicar_nuevo_ITIN,
               renovar_ITIN,

               renovar_aplicar_a,
               renovar_aplicar_b,
               renovar_aplicar_c,
               renovar_aplicar_d,
               renovar_aplicar_d_opcional,
               renovar_aplicar_e,
               renovar_aplicar_d_e_opcional,
               renovar_aplicar_f,
               renovar_aplicar_a_f_pais_tratado_opcional,
               renovar_aplicar_a_f_numero_articulo_tratado_opcional,
               renovar_aplicar_g,
               renovar_aplicar_h,
               renovar_aplicar_h_opcional,
               nombre_primer_nombre1,
               nombre_segundo_nombre1,
               nombre_ultimo_nombre1,
               nombre_primer_nombre2,
               nombre_segundo_nombre2,
               nombre_ultimo_nombre2,
               direccion_apartado_postal,
               direccion_ciudad_apartado_postal,
               direccion_no_apartado_postal,
               direccion_ciudad_no_apartado_postal,
               informacion_nacimiento_fecha_nacimiento,
               informacion_nacimiento_pais_nacimiento,
               informacion_nacimiento_ciudad_estado_provincia,
               informacion_nacimiento_genero,
               otra_informacion_pais_ciudadania,
               otra_informacion_numero_identificacion_fiscal_extranjero,
               otra_informacion_tipo_visa_estadounidense,
               otra_informacion_pasaporte,
               otra_informacion_licencia_conducir,
               otra_informacion_documentacion_USCIS,
               otra_informacion_otros,
               otra_informacion_otros_opcional,
               otra_informacion_expedido_por,
               otra_informacion_No,
               otra_informacion_fecha_caducidad,
               otra_informacion_fecha_entrada_usa,
               otra_informacion_recibido_ITIN_o_IRSN,
               otra_informacion_ITIN1,
               otra_informacion_ITIN2,
               otra_informacion_ITIN3,
               otra_informacion_IRSN1,
               otra_informacion_IRSN2,
               otra_informacion_IRSN3,
               otra_informacion_ITIN_IRSN_primer_nombre,
               otra_informacion_ITIN_IRSN_segundo_nombre,
               otra_informacion_ITIN_IRSN_apellido,
               otra_informacion_nombre_universidad_empresa,
               otra_informacion_ciudad_estado,
               otra_informacion_duracion_estancia,
               firma_nombre_delegado,
               firma_fecha_delegado,
               firma_telefono_delegado,
               firma_nombre_madre,
               firma_tutor_designado_tribunal,
               firma_poder_legal,
               agente_nombre_titulo,
               agente_nombre_compania,
               agente_fecha,
               agente_EIN,
               agente_PTIN,
               agente_office_code,
               fecha_post,
               fecha_update,
               firma_firma_solicitante,
               firma_fecha_solicitante,
               firma_firma,
               firma_fecha,
            } = data;

            // URL del PDF existente
            const url = 'https://pdf-lib.js.org/assets/with_update_sections.pdf';

            // Carga el archivo PDF
            const response = await fetch(tener_url_formulario_656);
            const existingPdfBytes = await response.arrayBuffer();

            // Crea un documento PDF con pdf-lib
            const pdfDoc = await PDFLib.PDFDocument.load(existingPdfBytes);

            // Embebe una fuente
            const helveticaFont = await pdfDoc.embedFont(PDFLib.StandardFonts.Helvetica);

            // Get the form containing all the fields
            const form = pdfDoc.getForm()

            // Obtén todos los campos del formulario
            const fields = form.getFields();

 
            //ITIN Application/Renewal

            if(aplicar_nuevo_ITIN == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].ApplicationType[0].c1_1[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].ApplicationType[0].c1_1[0]').uncheck();
            }

            if(renovar_ITIN == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].ApplicationType[0].c1_1[1]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].ApplicationType[0].c1_1[1]').uncheck();
            }

            //vamos con los check corridos
            /*
            if(renovar_aplicar_a == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_2[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_2[0]').uncheck();
            }
            
            if(renovar_aplicar_b == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_3[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_3[0]').uncheck();
            }

            if(renovar_aplicar_c == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_4[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_4[0]').uncheck();
            }
             

            if(renovar_aplicar_d == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_5[0]').check();
               //
               form.getTextField('topmostSubform[0].Page1[0].f1_1[0]').setText(renovar_aplicar_d_opcional || "");
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_5[0]').uncheck();
            }

            if(renovar_aplicar_e == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_7[0]').check();
            
               form.getTextField('topmostSubform[0].Page1[0].f1_2[0]').setText(renovar_aplicar_d_e_opcional || "");
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_7[0]').uncheck();
            }

            if(renovar_aplicar_f == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_7[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_6[0]').uncheck();
            }

            */

             

            form.getTextField('topmostSubform[0].Page1[0].f1_2[0]').setText("renovar_aplicar_d_e_opcional");

            //form.getRadioGroup('Group2').select('Choice1');
            //form.getRadioGroup('Group3').select('Choice3');

             
            
            form.getTextField('topmostSubform[0].Page1[0].f1_3[0]').setText(renovar_aplicar_d_e_opcional || "");
             


 
            // Itera sobre los campos y obtén sus nombres
            fields.forEach((field) => {
               console.log(field.getName());
            });

            // Obtén la primera página

            /*
            const pages = pdfDoc.getPages();
            const firstPage = pages[0];
            const { width, height } = firstPage.getSize();

            // Dibuja texto en la primera página
            firstPage.drawText('This text was added with JavaScript!', {
               x: 5,
               y: height / 2 + 300,
               size: 50,
               font: helveticaFont,
               color: PDFLib.rgb(0.95, 0.1, 0.1),
               rotate: PDFLib.degrees(-45),
            });
            */

            // Guarda el PDF actualizado
            const pdfBytes = await pdfDoc.save();

            // Descarga el PDF modificado
            const blob = new Blob([pdfBytes], { type: 'application/pdf' });
            const link = document.createElement('a');
            link.href = URL.createObjectURL(blob);
            link.download = 'forms W7.pdf';
            link.click();
         }

         async function processPdfForm() {
            const formUrl = 'https://pdf-lib.js.org/assets/form_to_flatten.pdf';

            try {
               // Obtener el PDF en forma de ArrayBuffer
               const response = await fetch(formUrl);
               const formPdfBytes = await response.arrayBuffer();

               // Cargar el documento PDF
               const pdfDoc = await PDFLib.PDFDocument.load(formPdfBytes);

               // Obtener el formulario del PDF
               const form = pdfDoc.getForm();

               // Obtener todos los campos del formulario
               const fields = form.getFields();

               // Iterar sobre los campos y mostrar sus nombres en la consola
               fields.forEach((field) => {
                  console.log(field.getName());
               });

               // Llenar algunos campos del formulario
               form.getTextField('Text1').setText('Some Text');
               form.getRadioGroup('Group2').select('Choice1');
               form.getRadioGroup('Group3').select('Choice3');
               form.getRadioGroup('Group4').select('Choice1');
               form.getCheckBox('Check Box3').check();
               form.getCheckBox('Check Box4').uncheck();
               form.getDropdown('Dropdown7').select('Infinity');
               form.getOptionList('List Box6').select('Honda');

               // Aplanar el formulario para convertirlo en texto plano
               form.flatten();

               // Guardar el PDF modificado como un Uint8Array
               const pdfBytes = await pdfDoc.save();

               // Descargar el PDF modificado
               const blob = new Blob([pdfBytes], { type: "application/pdf" });
               const link = document.createElement("a");
               link.href = URL.createObjectURL(blob);
               link.download = "pdf-lib_form_flattening_example.pdf";
               link.click();

               console.log("PDF procesado y descargado correctamente.");
            } catch (error) {
               console.error("Error al procesar el PDF:", error);
            }
         }

         async function cargar_cabecera_account() {
            return new Promise((resolve, reject) => {
               $.get(
                  URL_BASE + "group/get-groups-account-headers/",
                  function (data) {
                     try {
                        let info = JSON.parse(data);
                        resolve(info.data);
                     } catch (error) {
                        console.log(
                           "Error al parsear la respuesta cargar_cabecera_account: " +
                              error.message,
                        );
                        reject({
                           type: "error",
                           data: {},
                        });
                     }
                  },
               ).fail(function (jqXHR, textStatus, errorThrown) {
                  console.log(
                     "Error en la solicitud cargar_cabecera_account: " +
                        textStatus +
                        " - " +
                        errorThrown,
                  );
                  reject({
                     type: "error",
                     data: {},
                  });
               });
            });
         }

         async function cargar_grupos() {
            return new Promise((resolve, reject) => {
               $.get(URL_BASE + "group/get-groups/", function (data) {
                  try {
                     let info = JSON.parse(data);
                     resolve(info.data);
                  } catch (error) {
                     console.log(
                        "Error al parsear la respuesta cargar_grupos: " +
                           error.message,
                     );
                     reject({
                        type: "error",
                        data: {},
                     });
                  }
               }).fail(function (jqXHR, textStatus, errorThrown) {
                  console.log(
                     "Error en la solicitud cargar_grupos: " +
                        textStatus +
                        " - " +
                        errorThrown,
                  );
                  reject({
                     type: "error",
                     data: {},
                  });
               });
            });
         }

         async function cargar_usuarios_sistema() {
            return new Promise((resolve, reject) => {
               $.get(
                  URL_BASE + "social/lista-usuarios-admin/",
                  function (data) {
                     try {
                        let info = JSON.parse(data);
                        resolve(info.data);
                     } catch (error) {
                        console.log(
                           "Error al parsear la respuesta cargar_grupos: " +
                              error.message,
                        );
                        reject({
                           type: "error",
                           data: {},
                        });
                     }
                  },
               ).fail(function (jqXHR, textStatus, errorThrown) {
                  console.log(
                     "Error en la solicitud cargar_grupos: " +
                        textStatus +
                        " - " +
                        errorThrown,
                  );
                  reject({
                     type: "error",
                     data: {},
                  });
               });
            });
         }

         function cargar_fecha() {
            const today = new Date();

            // Formatear la fecha como YYYY-MM-DD
            const year = today.getFullYear();
            const month = String(today.getMonth() + 1).padStart(2, "0"); // Mes de 2 dígitos
            const day = String(today.getDate()).padStart(2, "0"); // Día de 2 dígitos

            const formattedDate = year + "-" + month + "-" + day;
            return formattedDate;
         }

         function select_html_usuario_sistema(arr) {
            if (arr.length == 0) {
               return;
            }

            var html = '<option value="">' + "None" + "</option>";

            arr.forEach((element) => {
               let value = element;

               html +=
                  '<option value="' +
                  value["id"] +
                  '">' +
                  value["fullname"] +
                  "</option>";
            });

            return html;
         }

         function isEmpty(value) {
            // Verificar si es null o undefined
            if (value == null) return true;

            // Verificar si es una cadena vacía
            if (typeof value === "string" && value.trim() === "") return true;

            // Verificar si es un array vacío
            if (Array.isArray(value) && value.length === 0) return true;

            // Verificar si es un objeto vacío
            if (typeof value === "object" && Object.keys(value).length === 0) return true;

            return false;
         }

         function convertirMayusculas(texto) {
            if (isEmpty(texto)) {
               return '';
            }
            return texto.toUpperCase();
         }
     
         async function construir_pdf_formulario_w7(data)
         {
            let {
                
               aplicar_nuevo_ITIN = "",
               renovar_ITIN = "",
               renovar_aplicar_a = "",
               renovar_aplicar_b = "",
               renovar_aplicar_c = "",
               renovar_aplicar_d = "",
               renovar_aplicar_d_opcional = "",
               renovar_aplicar_e = "",
               renovar_aplicar_d_e_opcional = "",
               renovar_aplicar_f = "",
               renovar_aplicar_a_f_pais_tratado_opcional = "",
               renovar_aplicar_a_f_numero_articulo_tratado_opcional = "",
               renovar_aplicar_g = "",
               renovar_aplicar_h = "",
               renovar_aplicar_h_opcional = "",
               nombre_primer_nombre1 = "",
               nombre_segundo_nombre1 = "",
               nombre_ultimo_nombre1 = "",
               nombre_primer_nombre2 = "",
               nombre_segundo_nombre2 = "",
               nombre_ultimo_nombre2 = "",
               direccion_apartado_postal = "",
               direccion_ciudad_apartado_postal = "",
               direccion_no_apartado_postal = "",
               direccion_ciudad_no_apartado_postal = "",
               informacion_nacimiento_fecha_nacimiento = "",
               informacion_nacimiento_pais_nacimiento = "",
               informacion_nacimiento_ciudad_estado_provincia = "",
               informacion_nacimiento_genero = "",
               otra_informacion_pais_ciudadania = "",
               otra_informacion_numero_identificacion_fiscal_extranjero = "",
               otra_informacion_tipo_visa_estadounidense = "",
               otra_informacion_pasaporte = "",
               otra_informacion_licencia_conducir = "",
               otra_informacion_documentacion_USCIS = "",
               otra_informacion_otros = "",
               otra_informacion_otros_opcional = "",
               otra_informacion_expedido_por = "",
               otra_informacion_No = "",
               otra_informacion_fecha_caducidad = "",
               otra_informacion_fecha_entrada_usa = "",
               otra_informacion_recibido_ITIN_o_IRSN = "",
               otra_informacion_ITIN1 = "",
               otra_informacion_ITIN2 = "",
               otra_informacion_ITIN3 = "",
               otra_informacion_IRSN1 = "",
               otra_informacion_IRSN2 = "",
               otra_informacion_IRSN3 = "",
               otra_informacion_ITIN_IRSN_primer_nombre = "",
               otra_informacion_ITIN_IRSN_segundo_nombre = "",
               otra_informacion_ITIN_IRSN_apellido = "",
               otra_informacion_nombre_universidad_empresa = "",
               otra_informacion_ciudad_estado = "",
               otra_informacion_duracion_estancia = "",
               firma_nombre_delegado = "",
               firma_fecha_delegado = "",
               firma_telefono_delegado = "",
               firma_nombre_madre = "",
               firma_tutor_designado_tribunal = "",
               firma_poder_legal = "",
               agente_nombre_titulo = "",
               agente_nombre_compania = "",
               agente_fecha = "",
               agente_EIN = "",
               agente_PTIN = "",
               agente_office_code = "",
               fecha_post = "",
               fecha_update = "",
               firma_firma_solicitante = "",
               firma_fecha_solicitante = "",
               firma_firma = "",
               firma_fecha = "",
               firma_fax1 = "",
               firma_telefono1 = "",
            } = data;

            // URL del PDF existente
            const url = 'https://pdf-lib.js.org/assets/with_update_sections.pdf';

            // Carga el archivo PDF
            const response = await fetch(tener_url_formulario_w7);
            const existingPdfBytes = await response.arrayBuffer();

            // Crea un documento PDF con pdf-lib
            const pdfDoc = await PDFLib.PDFDocument.load(existingPdfBytes);

            // Embebe una fuente
            const helveticaFont = await pdfDoc.embedFont(PDFLib.StandardFonts.Helvetica);

            // Get the form containing all the fields
            const form = pdfDoc.getForm()

            // Obtén todos los campos del formulario
            const fields = form.getFields();
 
            //ITIN Application/Renewal

            if(aplicar_nuevo_ITIN == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].ApplicationType[0].c1_1[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].ApplicationType[0].c1_1[0]').uncheck();
            }

            if(renovar_ITIN == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].ApplicationType[0].c1_1[1]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].ApplicationType[0].c1_1[1]').uncheck();
            }

            //vamos con los check corridos
          
            if(renovar_aplicar_a == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_2[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_2[0]').uncheck();
            }
            
            if(renovar_aplicar_b == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_3[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_3[0]').uncheck();
            }

            if(renovar_aplicar_c == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_4[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_4[0]').uncheck();
            }
             

            if(renovar_aplicar_d == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_5[0]').check();
               //
               form.getTextField('topmostSubform[0].Page1[0].f1_1[0]').setText( convertirMayusculas(renovar_aplicar_d_opcional)  || "");
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_5[0]').uncheck();
               form.getTextField('topmostSubform[0].Page1[0].f1_1[0]').setText( convertirMayusculas(renovar_aplicar_d_opcional) || "");
            }

            if(renovar_aplicar_e == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_6[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_6[0]').uncheck();
            }
            
            //estos dos le corresponden a la opcion e 
            //form.getTextField('topmostSubform[0].Page1[0].f1_2[0]').setText( convertirMayusculas(renovar_aplicar_d_e_opcional)  || "");
            form.getTextField('topmostSubform[0].Page1[0].f1_3[0]').setText( convertirMayusculas(renovar_aplicar_d_e_opcional)  || "");

            if(renovar_aplicar_f == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_7[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_7[0]').uncheck();
            }

            if(renovar_aplicar_g == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_8[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_8[0]').uncheck();
            }

            if(renovar_aplicar_h == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_9[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_9[0]').uncheck();
            }

            form.getTextField('topmostSubform[0].Page1[0].f1_4[0]').setText( convertirMayusculas(renovar_aplicar_h_opcional) || "");


            //estos 2 son en caso de que sea a y f
            form.getTextField('topmostSubform[0].Page1[0].f1_5[0]').setText( convertirMayusculas(renovar_aplicar_a_f_pais_tratado_opcional) || "");
            form.getTextField('topmostSubform[0].Page1[0].f1_6[0]').setText( convertirMayusculas(renovar_aplicar_a_f_numero_articulo_tratado_opcional) || "");

            //name 
            form.getTextField('topmostSubform[0].Page1[0].f1_7[0]').setText( convertirMayusculas(nombre_primer_nombre1) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_8[0]').setText( convertirMayusculas(nombre_segundo_nombre1) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_9[0]').setText( convertirMayusculas(nombre_ultimo_nombre1) || "N/A");

            //
            form.getTextField('topmostSubform[0].Page1[0].f1_10[0]').setText( convertirMayusculas(nombre_primer_nombre2) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_11[0]').setText( convertirMayusculas(nombre_segundo_nombre2) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_12[0]').setText( convertirMayusculas(nombre_ultimo_nombre2) || "N/A");


            form.getTextField('topmostSubform[0].Page1[0].f1_13[0]').setText( convertirMayusculas(direccion_apartado_postal) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_14[0]').setText( convertirMayusculas(direccion_ciudad_apartado_postal) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_15[0]').setText( convertirMayusculas(direccion_no_apartado_postal) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_16[0]').setText( convertirMayusculas(direccion_ciudad_no_apartado_postal) || "N/A");

            if(isEmpty(informacion_nacimiento_fecha_nacimiento) == false)
            {
               let [año, mes, dia] = informacion_nacimiento_fecha_nacimiento.split('-');
               
               //let a = "2024-12-11"
               let concatnacion = mes + "" + dia + "" + año;

               form.getTextField('topmostSubform[0].Page1[0].f1_17[0]').setText(concatnacion  || "");
            }

            form.getTextField('topmostSubform[0].Page1[0].f1_18[0]').setText( convertirMayusculas(informacion_nacimiento_pais_nacimiento) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_19[0]').setText( convertirMayusculas(informacion_nacimiento_ciudad_estado_provincia) || "N/A");
 

            if(informacion_nacimiento_genero == "Male")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_10[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_10[1]').check();
            }

            //OTROS
            form.getTextField('topmostSubform[0].Page1[0].f1_20[0]').setText( convertirMayusculas(otra_informacion_pais_ciudadania) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_21[0]').setText( convertirMayusculas(otra_informacion_numero_identificacion_fiscal_extranjero) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_22[0]').setText( convertirMayusculas(otra_informacion_tipo_visa_estadounidense) || "N/A");


            if(otra_informacion_pasaporte == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_11[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_11[0]').uncheck();
            }

            if(otra_informacion_licencia_conducir == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_11[1]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_11[1]').uncheck();
            }

            if(otra_informacion_documentacion_USCIS == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_11[2]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_11[2]').uncheck();
            }
            
            if(otra_informacion_otros == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_11[3]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_11[3]').uncheck();
            }

            //este le pertenece a otros
            form.getTextField('topmostSubform[0].Page1[0].f1_23[0]').setText( convertirMayusculas(otra_informacion_otros_opcional)  || "N/A");

            form.getTextField('topmostSubform[0].Page1[0].f1_24[0]').setText( convertirMayusculas(otra_informacion_expedido_por) || "N/A");

            form.getTextField('topmostSubform[0].Page1[0].f1_25[0]').setText( convertirMayusculas(otra_informacion_No) || "N/A");

            if(isEmpty(otra_informacion_fecha_caducidad) == false)
            {
               let [año, mes, dia] = otra_informacion_fecha_caducidad.split('-');
               
               //let a = "2024-12-11"
               let concatnacion = mes + "" + dia + "" + año;

               form.getTextField('topmostSubform[0].Page1[0].f1_26[0]').setText(concatnacion  || "");
            }

            if(isEmpty(otra_informacion_fecha_entrada_usa) == false)
            {
               let [año, mes, dia] = otra_informacion_fecha_entrada_usa.split('-');
               
               //let a = "2024-12-11"
               let concatnacion = mes + "" + dia + "" + año;

               form.getTextField('topmostSubform[0].Page1[0].f1_27[0]').setText(concatnacion  || "");
            }

            if(otra_informacion_recibido_ITIN_o_IRSN == "Yes")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_12[1]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_12[0]').check();
            }

            let [ITIN1_n1 = "", ITIN1_n2 = "", ITIN1_n3 = "", ] = otra_informacion_ITIN1.split('');
 
            form.getTextField('topmostSubform[0].Page1[0].f1_28[0]').setText( convertirMayusculas(ITIN1_n1)  || "");
            form.getTextField('topmostSubform[0].Page1[0].f1_29[0]').setText( convertirMayusculas(ITIN1_n2)  || "");
            form.getTextField('topmostSubform[0].Page1[0].f1_30[0]').setText( convertirMayusculas(ITIN1_n3)  || "");

            let [ITIN2_n1 = "", ITIN2_n2 = "" ] = otra_informacion_ITIN2.split('');

            form.getTextField('topmostSubform[0].Page1[0].f1_31[0]').setText( convertirMayusculas(ITIN2_n1)|| "");
            form.getTextField('topmostSubform[0].Page1[0].f1_32[0]').setText( convertirMayusculas(ITIN2_n2)|| "");

            let [ITIN3_n1 = "", ITIN3_n2 = "", ITIN3_n3 = "", ITIN3_n4 = "" ] = otra_informacion_ITIN3.split('');

            form.getTextField('topmostSubform[0].Page1[0].f1_33[0]').setText( convertirMayusculas(ITIN3_n1) || "");
            form.getTextField('topmostSubform[0].Page1[0].f1_34[0]').setText( convertirMayusculas(ITIN3_n2) || "");
            form.getTextField('topmostSubform[0].Page1[0].f1_35[0]').setText( convertirMayusculas(ITIN3_n3) || "");
            form.getTextField('topmostSubform[0].Page1[0].f1_36[0]').setText( convertirMayusculas(ITIN3_n4) || "");

            let [IRSN1_n1 = "", IRSN1_n2 = "", IRSN1_n3 = "", ] = otra_informacion_IRSN1.split('');
 
            form.getTextField('topmostSubform[0].Page1[0].f1_37[0]').setText( convertirMayusculas(IRSN1_n1) || "");
            form.getTextField('topmostSubform[0].Page1[0].f1_38[0]').setText( convertirMayusculas(IRSN1_n2) || "");
            form.getTextField('topmostSubform[0].Page1[0].f1_39[0]').setText( convertirMayusculas(IRSN1_n3) || "");

            let [IRSN2_n1 = "", IRSN2_n2 = "" ] = otra_informacion_IRSN2.split('');

            form.getTextField('topmostSubform[0].Page1[0].f1_40[0]').setText( convertirMayusculas(IRSN2_n1) || "");
            form.getTextField('topmostSubform[0].Page1[0].f1_41[0]').setText( convertirMayusculas(IRSN2_n2) || "");

            let [IRSN3_n1 = "", IRSN3_n2 = "", IRSN3_n3 = "", IRSN3_n4 = "" ] = otra_informacion_IRSN3.split('');

            form.getTextField('topmostSubform[0].Page1[0].f1_42[0]').setText( convertirMayusculas(IRSN3_n1) || "");
            form.getTextField('topmostSubform[0].Page1[0].f1_43[0]').setText( convertirMayusculas(IRSN3_n2) || "");
            form.getTextField('topmostSubform[0].Page1[0].f1_44[0]').setText( convertirMayusculas(IRSN3_n3) || "");
            form.getTextField('topmostSubform[0].Page1[0].f1_45[0]').setText( convertirMayusculas(IRSN3_n4) || "");

            form.getTextField('topmostSubform[0].Page1[0].f1_46[0]').setText( convertirMayusculas(otra_informacion_ITIN_IRSN_primer_nombre)  || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_47[0]').setText( convertirMayusculas(otra_informacion_ITIN_IRSN_segundo_nombre) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_48[0]').setText( convertirMayusculas(otra_informacion_ITIN_IRSN_apellido) || "N/A");

            form.getTextField('topmostSubform[0].Page1[0].f1_49[0]').setText( convertirMayusculas(otra_informacion_nombre_universidad_empresa) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_50[0]').setText( convertirMayusculas(otra_informacion_ciudad_estado)  || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_51[0]').setText( convertirMayusculas(otra_informacion_duracion_estancia)  || "N/A");

            if(firma_nombre_madre == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_13[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_13[0]').uncheck();
            }

            if(firma_tutor_designado_tribunal == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_13[1]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_13[1]').uncheck();
            }

            if(firma_poder_legal == "1")
            {
               form.getCheckBox('topmostSubform[0].Page1[0].c1_13[2]').check();
            }else{
               form.getCheckBox('topmostSubform[0].Page1[0].c1_13[2]').uncheck();
            }

            form.getTextField('topmostSubform[0].Page1[0].f1_52[0]').setText( convertirMayusculas(firma_telefono_delegado)  || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_53[0]').setText( convertirMayusculas(firma_nombre_delegado)  || "");

            form.getTextField('topmostSubform[0].Page1[0].f1_54[0]').setText( convertirMayusculas(firma_fax1) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_55[0]').setText( convertirMayusculas(firma_telefono1) || "N/A");

            form.getTextField('topmostSubform[0].Page1[0].f1_56[0]').setText( convertirMayusculas(agente_nombre_titulo) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_57[0]').setText( convertirMayusculas(agente_nombre_compania) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_58[0]').setText( convertirMayusculas(agente_EIN) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_59[0]').setText( convertirMayusculas(agente_PTIN) || "N/A");
            form.getTextField('topmostSubform[0].Page1[0].f1_60[0]').setText( convertirMayusculas(agente_office_code) || "N/A");

         
            //form.getCheckBox('topmostSubform[0].Page1[0].c1_13[2]').check();
 
            // Itera sobre los campos y obtén sus nombres
            fields.forEach((field) => {
               console.log(field.getName());
            });

            // Obtén la primera página

            /*
            const pages = pdfDoc.getPages();
            const firstPage = pages[0];
            const { width, height } = firstPage.getSize();

            // Dibuja texto en la primera página
            firstPage.drawText('This text was added with JavaScript!', {
               x: 5,
               y: height / 2 + 300,
               size: 50,
               font: helveticaFont,
               color: PDFLib.rgb(0.95, 0.1, 0.1),
               rotate: PDFLib.degrees(-45),
            });
            */

            // Guarda el PDF actualizado
            const pdfBytes = await pdfDoc.save();

            // Descarga el PDF modificado
            const blob = new Blob([pdfBytes], { type: 'application/pdf' });
            const link = document.createElement('a');
            link.href = URL.createObjectURL(blob);
            link.download = 'forms W7.pdf';
            link.click();
         }

         async function descargar_formulario_433(UUID_ENC)
         {
 
            let enviar_informacion = {
               //UUID_ENC: "Z1heD4n-RQ-LdwAGGoeseQ",
               UUID_ENC: UUID_ENC,
            };

            console.log(enviar_informacion);
            //console.log("aqui abajo ahi un return");
            //return;

     
           $.ajax({
               type: "POST",
               url: API_FORM_BASE + '433a/' + encodeURIComponent(UUID_ENC),
               data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
               contentType: "application/json",  
               success: function (response) {
               
                  try {
                     let info = (typeof response === "string") ? JSON.parse(response) : response;
                     if (info.type == "success") {

                        let data_seccion2 = info.data_seccion2;

                        console.log(info);

                      construir_pdf_formulario_433(info);
 
                     } else {
                        alert(info.message);
                     }
                  } catch (error) {
                     alert("Error:" + error);
                  }
               },
               error: function (xhr, status, error) {
                  console.error("Error en la solicitud:", error);
               },
            });
   
          
         
        
            
          
             return;

 
         let info = {
    "type": "success",
    "message": "Information saved successfully",
    "data_seccion1": {
        "id": "1",
        "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
        "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
        "forms_id": "9",
        "tener_seccion1_apellido": "Last name s1",
        "tener_seccion1_fecha_nacimiento": "2024-12-06",
        "tener_seccion1_nombre": "First name s1",
        "tener_seccion1_numero_seguro_social1": "s11",
        "tener_seccion1_numero_seguro_social2": "s1",
        "tener_seccion1_numero_seguro_social3": "s111",
        "tener_seccion1_estado_civil1": "Married",
        "tener_seccion1_vivienda1": "Other",
        "tener_seccion1_especificar_otros1": "(specify e.g., share rent, live with relative, etc.)  s1",
        "tener_seccion1_fecha_matrimonio1": "2024-12-07",
        "tener_seccion1_direccion_fiscal_domicilio1": "Home physical address (street, city, state, ZIP code) s1",
        "tener_seccion1_si_estuvo_casado_vivio": "1",
        "tener_seccion1_contado_residencia": "County of residence s1",
        "tener_seccion1_numero_telefono_primario1": "522",
        "tener_seccion1_numero_telefono_primario2": "112",
        "tener_seccion1_numero_telefono_primario3": "2221",
        "tener_seccion1_numero_telefono_segundario1": "112",
        "tener_seccion1_numero_telefono_segundario2": "333",
        "tener_seccion1_numero_telefono_segundario3": "2221",
        "tener_seccion1_numero_FAX1": "333",
        "tener_seccion1_numero_FAX2": "333",
        "tener_seccion1_numero_FAX3": "1111",
        "tener_seccion1_direccion_postal_domicilio1": "Home mailing address (if different from above or post office box number) xd",
        "tener_seccion1_apellido_conyugue1": "Spouse's last name s1",
        "tener_seccion1_nombre_conyugue1": "Spouse's first name s1",
        "tener_seccion1_fecha_nacimiento1": "2024-12-08",
        "tener_seccion1_numero_seguro_social_coyugue1": "s21",
        "tener_seccion1_numero_seguro_social_coyugue2": "s3",
        "tener_seccion1_numero_seguro_social_coyugue3": "s31",
        "tener_seccion1_nombre1": "Name (1) x1",
        "tener_seccion1_age1": "11",
        "tener_seccion1_relacion1": "Relationship (1)  x1",
        "tener_seccion1_contribuye_ingreso_familiar1": "Yes",
        "tener_seccion1_reclamado_independiente1": "No",
        "tener_seccion1_nombre2": "Name (2)  x2",
        "tener_seccion1_age2": "12",
        "tener_seccion1_relacion2": "Relationship (2)  x2",
        "tener_seccion1_reclamado_independiente2": "Yes",
        "tener_seccion1_contribuye_ingreso_familiar2": "No",
        "tener_seccion1_nombre3": "Name (3) x3",
        "tener_seccion1_age3": "13",
        "tener_seccion1_relacion3": "Relationship (3)  x3",
        "tener_seccion1_contribuye_ingreso_familiar3": "No",
        "tener_seccion1_reclamado_independiente3": "Yes",
        "tener_seccion1_nombre4": "Name (4) x4",
        "tener_seccion1_age4": "14",
        "tener_seccion1_relacion4": "Relationship (4) x4",
        "tener_seccion1_contribuye_ingreso_familiar4": "Yes",
        "tener_seccion1_reclamado_independiente4": "No",
        "fecha_post": "2024-12-21 11:18:21",
        "fecha_update": "2024-12-25 12:07:50"
    },
    "data_seccion2": {
        "id": "2",
        "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
        "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
        "forms_id": "9",
        "tener_seccion2_nombre_empleador": "cesar pineda s1",
        "tener_seccion2_semanalmente": "1",
        "tener_seccion2_quincenalmente": "1",
        "tener_seccion2_mensualmente": "1",
        "tener_seccion2_otro": "1",
        "tener_seccion2_participacion_negocio": "No",
        "tener_seccion2_ocupacion": "programador x1 ",
        "tener_seccion2_tiempo_empleador_anos": "26 11 x1",
        "tener_seccion2_tiempo_empleador_mes": "4 x1",
        "tener_seccion2_direccion_empleado": "Employer’s address (street, city, state, ZIP code) x1",
        "tener_seccion2_nombre_empleador_conyugue": "Spouse’s employer's name x1",
        "tener_seccion2_semanalmente_conyuge": "1",
        "tener_seccion2_quincenalmente_conyuge": "1",
        "tener_seccion2_mensualmente_conyuge": "1",
        "tener_seccion2_otro_conyuge": "1",
        "tener_seccion2_participacion_negocio_conyuge": "Yes",
        "tener_seccion2_direccion_empleado_conyuge": "Employer’s address (street, city, state, ZIP code)  spouse xx1",
        "fecha_post": "2024-12-21 13:37:03",
        "fecha_update": "2024-12-25 12:07:50",
        "tener_seccion2_ocupacion_conyuge": "Your occupation Spouse s ",
        "tener_seccion2_tiempo_empleador_anos_conyuge": "years Spouse ",
        "tener_seccion2_tiempo_empleador_mes_conyuge": "months Spouse "
    },
    "data_seccion3": {
        "id": "1",
        "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
        "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
        "forms_id": "9",
        "tener_seccion3_dinero1": "1",
        "tener_seccion3_ahorros1": "1",
        "tener_seccion3_cuenta_enlinea1": "1",
        "tener_seccion3_cheque": "1",
        "tener_seccion3_CD1": "1",
        "tener_seccion3_tarjeta_valor_almacenado1": "1",
        "tener_seccion3_nombre_banco_ubicacion_pais1": "BNCL1 xd",
        "tener_seccion3_numero_cuenta1": "AN1",
        "tener_seccion3_efectivo_inversiones_1a": "100",
        "tener_seccion3_cheque2": "1",
        "tener_seccion3_ahorros2": "1",
        "tener_seccion3_cuenta_enlinea2": "1",
        "tener_seccion3_CD2": "1",
        "tener_seccion3_tarjeta_valor_almacenado2": "1",
        "tener_seccion3_nombre_banco_ubicacion_pais2": "BNCL2 x1",
        "tener_seccion3_numero_cuenta2": "AN2 x1",
        "tener_seccion3_efectivo_inversiones_1b": "501",
        "tener_seccion3_efectivo_inversiones_1c": "601",
        "tener_seccion3_sumna_a1_c1_menos_1000": "-399",
        "tener_seccion3_acciones1": "1",
        "tener_seccion3_bonos1": "1",
        "tener_seccion3_otro1": "1",
        "tener_seccion3_otro1_opcional": "Otros detalles x1",
        "tener_seccion3_nombre_institucion_financiera_ubicacion_pais1": "NFICL1 x1",
        "tener_seccion3_numero_cuenta3": "AN3 x1",
        "tener_seccion3_valor_mercado_actual1": "10001",
        "tener_seccion3_valor_mercado_actual_resultado1": "8000.8",
        "tener_seccion3_saldo_negativo_prestados1": "101",
        "tener_seccion3_resultado_2a": "7899.8",
        "tener_seccion3_acciones2": "1",
        "tener_seccion3_bonos2": "1",
        "tener_seccion3_otro2": "1",
        "tener_seccion3_otro2_opcional": "x1",
        "tener_seccion3_nombre_institucion_financiera_ubicacion_pais2": "NFICL2 x1",
        "tener_seccion3_numero_cuenta4": "AN4  x1",
        "tener_seccion3_valor_mercado_actual2": "2001",
        "tener_seccion3_valor_mercado_actual_resultado2": "1600.8",
        "tener_seccion3_saldo_negativo_prestados2": "201",
        "tener_seccion3_resultado_2b": "1399.8",
        "tener_seccion3_activo_digital1": "1",
        "tener_seccion3_descripcion_activo_digital1": "Description of digital asset 1 x1",
        "tener_seccion3_numero_unidades1": "Number of units 1 x1",
        "tener_seccion3_ubicacion_activo_digital1": "Location of digital asset (exchange account, self-hosted wallet) 1 x1",
        "tener_seccion3_numero_cuenta_activo1": "Account number for assets held by a custodian or broker  1 x1",
        "tener_seccion3_direccion_activo_digitales1": "Digital asset address for self-hosted digital assets 1x1",
        "tener_seccion3_activo_digital_equivalente_dolares1": "231",
        "tener_seccion3_efectivo_inversiones_2c": "231",
        "tener_seccion3_total_cuentas_inversiones_2d": "9299.6",
        "tener_seccion3_resultado_2a_2d": "17199.4",
        "tener_seccion3_401K": "1",
        "tener_seccion3_IRA": "1",
        "tener_seccion3_otro3": "1",
        "tener_seccion3_otro3_opcional": "mi detalle de otros xq1",
        "tener_seccion3_nombre_institucion_financiera_ubicacion_pais3": "NFICL22 x1",
        "tener_seccion3_numero_cuenta5": "AN12 x1",
        "tener_seccion3_valor_mercado_actual3": "3001",
        "tener_seccion3_valor_mercado_actual_resultado3": "2400.8",
        "tener_seccion3_saldo_negativo_prestados3": "127",
        "tener_seccion3_resultado_3a": "2273.8",
        "tener_seccion3_total_cuentas_inversiones_3b": "2273.8",
        "tener_seccion3_resultado_3a_3b": "2273.8",
        "tener_seccion3_nombre_seguro_compania1": "Name of Insurance Company x1",
        "tener_seccion3_numero_poliza1": "Policy number x1",
        "tener_seccion3_valor_mercado_actual4": "4001",
        "tener_seccion3_valor_mercado_actual_resultado4": "3200.8",
        "tener_seccion3_saldo_negativo_prestados4": "401",
        "tener_seccion3_resultado_4a": "2799.8",
        "tener_seccion3_valor_total_efectivo_poliza1": "5001",
        "tener_seccion3_saldo_negativo_prestados_total_polizas1": "101",
        "tener_seccion3_resultado_4b": "4900",
        "tener_seccion3_resultado_4a_4b": "7699.8",
        "tener_seccion3_propiedad_inmobilitaria_venta1_si": "1",
        "tener_seccion3_propiedad_inmobilitaria_venta1_si_opcional": "127",
        "tener_seccion3_propiedad_inmobilitaria_venta1_no": "0",
        "tener_seccion3_descripcion_propiedad1": "Property description x1",
        "tener_seccion3_fecha_compra1": "2024-12-20",
        "tener_seccion3_monto_pago_hipoteca1": "12231",
        "tener_seccion3_fecha_pago_final1": "2024-12-20",
        "tener_seccion3_como_mantiene_titulo1": "How title is held (joint tenancy, etc.)  x1",
        "tener_seccion3_ubicacion1": "Location (street, city, state, ZIP code, county, and country) x1",
        "tener_seccion3_nombre_prestamista1": "Lender/Contract holder name, address  x1",
        "tener_seccion3_valor_mercado_actual5": "5001",
        "tener_seccion3_valor_mercado_actual_resultado5": "4000.8",
        "tener_seccion3_saldo_negativo_prestados5": "501",
        "tener_seccion3_resultado_5a": "3499.8",
        "tener_seccion3_descripcion_propiedad2": "Property description 1x1",
        "tener_seccion3_fecha_compra2": "2024-12-26",
        "tener_seccion3_monto_pago_hipoteca2": "3321",
        "tener_seccion3_fecha_pago_final2": "2024-12-30",
        "tener_seccion3_como_mantiene_titulo2": "2221",
        "tener_seccion3_ubicacion2": "Location (street, city, state, ZIP code, county, and country) x1",
        "tener_seccion3_nombre_prestamista4": "Lender/Contract holder name, address x1",
        "tener_seccion3_valor_mercado_actual6": "6001",
        "tener_seccion3_valor_mercado_actual_resultado6": "4800.8",
        "tener_seccion3_saldo_negativo_prestados6": "601",
        "tener_seccion3_resultado_5b": "4199.8",
        "tener_seccion3_total_cuentas_inversiones_5c": "7699.6",
        "tener_seccion3_resultado_5a_5c": "11199.4",
        "tener_seccion3_marca_modelo_vehiculo1": "Vehicle make & model x1",
        "tener_seccion3_ano_vehiculo1": "40011",
        "tener_seccion3_fecha_compra_vehiculo1": "2025-01-01",
        "tener_seccion3_kilometraje_vehiculo1": "34441",
        "tener_seccion3_numero_licencia_vehiculo1": "12331 x1",
        "tener_seccion3_dueno_propio_vehiculo1": "Lease",
        "tener_seccion3_nombre_acreedora_vehiculo1": "1122 x1",
        "tener_seccion3_fecha_pago_final_vehiculo1": "2025-01-07",
        "tener_seccion3_monto_prestamo_vehiculo1": "111",
        "tener_seccion3_valor_mercado_actual7": "7001",
        "tener_seccion3_valor_mercado_actual_resultado7": "5600.8",
        "tener_seccion3_saldo_negativo_prestados7": "701",
        "tener_seccion3_resultado_6a": "4899.8",
        "tener_seccion3_resultado_6b": "1449.8",
        "tener_seccion3_marca_modelo_vehiculo2": " Vehicle make & model 1 x1",
        "tener_seccion3_ano_vehiculo2": "111",
        "tener_seccion3_fecha_compra_vehiculo2": "2025-01-09",
        "tener_seccion3_kilometraje_vehiculo2": "33441",
        "tener_seccion3_numero_licencia_vehiculo2": "112221 x1",
        "tener_seccion3_dueno_propio_vehiculo2": "Own",
        "tener_seccion3_nombre_acreedora_vehiculo2": "112223 x1",
        "tener_seccion3_fecha_pago_final_vehiculo2": "2025-01-09",
        "tener_seccion3_monto_prestamo_vehiculo2": "1111",
        "tener_seccion3_valor_mercado_actual8": "127",
        "tener_seccion3_valor_mercado_actual_resultado8": "101.6",
        "tener_seccion3_saldo_negativo_prestados8": "801",
        "tener_seccion3_resultado_6c": "-699.4",
        "tener_seccion3_resultado_6d": "0",
        "tener_seccion3_total_cuentas_inversiones_6e": "4200.4",
        "tener_seccion3_resultado_6b_6d_6e": "5650.2",
        "tener_seccion3_descripcion_activos1": "Description of asset(s)  x1",
        "tener_seccion3_valor_mercado_actual9": "11221",
        "tener_seccion3_valor_mercado_actual_resultado9": "8976.8",
        "tener_seccion3_saldo_negativo_prestados9": "111",
        "tener_seccion3_resultado_7a": "8865.8",
        "tener_seccion3_descripcion_activos2": "Description of asset(s) * xd1",
        "tener_seccion3_valor_mercado_actual10": "9001",
        "tener_seccion3_valor_mercado_actual_resultado10": "7200.8",
        "tener_seccion3_saldo_negativo_prestados10": "901",
        "tener_seccion3_resultado_7b": "6299.8",
        "tener_seccion3_total_cuentas_inversiones_7c": "15165.6",
        "tener_seccion3_resultado_7a_7c": "12641.4",
        "tener_seccion3_caja_a1": "12242.4",
        "fecha_post": "2024-12-21 16:05:46",
        "fecha_update": "2024-12-25 12:07:50"
    },
    "data_seccion4": {
        "id": "2",
        "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
        "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
        "forms_id": "9",
        "tener_seccion4_pregunta_empresa_unipersonal": "No",
        "tener_seccion4_nombre_empresa1": "Name of business  x1",
        "tener_seccion4_direccion_negocio1": "Address of business (if other than personal residence) xd",
        "tener_seccion4_numero_telefono1": "122",
        "tener_seccion4_numero_telefono2": "222",
        "tener_seccion4_numero_telefono3": "3433",
        "tener_seccion4_numero_identificacion_empleador2": "Employer Identification Number x1",
        "tener_seccion4_descripcion_negocio1": "Description of business x1",
        "tener_seccion4_total_numero_empleados1": "1112",
        "tener_seccion4_direccion_sitio_web_comercial1": "Business website address  x1",
        "tener_seccion4_frecuencia_depositos_impuestos1": "Frequency of tax deposits x1",
        "tener_seccion4_nomuna_brutal_mensual_promedio1": "3211",
        "tener_seccion4_nombre_comercial1": "Trade name or DBA  x1",
        "tener_seccion4_direcion_comercial1": "Business address (street, city, state, ZIP code)  xd1",
        "tener_seccion4_numero_telefono6": "554",
        "tener_seccion4_numero_telefono7": "233",
        "tener_seccion4_numero_telefono8": "1434",
        "tener_seccion4_numero_identificacion_empleador1": "Employer Identification Number xd1",
        "tener_seccion4_otro_interesado_comercial_si": "1",
        "tener_seccion4_otro_interesado_comercial_no": "0",
        "tener_seccion4_porcentaje_propiedad_opcional": "11222",
        "tener_seccion4_titulo_opcional": "xd1",
        "tener_seccion4_nombre_comercial2": "Business name  xd1",
        "tener_seccion4_tipo_negocio": "Other",
        "tener_seccion4_otro_tipo_negocios_opcional1": "Description other xd1",
        "fecha_post": "2024-12-21 17:26:49",
        "fecha_update": "2024-12-25 12:07:50"
    },
    "data_seccion5": {
        "id": "2",
        "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
        "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
        "forms_id": "9",
        "tener_seccion5_dinero1": "1",
        "tener_seccion5_ahorros1": "1",
        "tener_seccion5_cuenta_enlinea1": "1",
        "tener_seccion5_cheque1": "1",
        "tener_seccion5_CD1": "1",
        "tener_seccion5_tarjeta_valor_almacenado1": "1",
        "tener_seccion5_nombre_banco_ubicacion_pais1": "BNCL1 x1",
        "tener_seccion5_numero_cuenta1": "AN1 x1",
        "tener_seccion5_resultado_8a": "1001",
        "tener_seccion5_dinero2": "0",
        "tener_seccion5_ahorros2": "1",
        "tener_seccion5_cuenta_enlinea2": "0",
        "tener_seccion5_cheque2": "1",
        "tener_seccion5_CD2": "1",
        "tener_seccion5_tarjeta_valor_almacenado2": "1",
        "tener_seccion5_nombre_banco_ubicacion_pais2": "BNCL2 x1",
        "tener_seccion5_numero_cuenta2": "AN2 x1",
        "tener_seccion5_resultado_8b": "5001",
        "tener_seccion5_activo_digital1": "1",
        "tener_seccion5_descripcion_activo_digital1": "Description of digital asset xd2",
        "tener_seccion5_numero_unidades1": "Number of units x2",
        "tener_seccion5_ubicacion_activo_digital1": "Location of digital asset (exchange account, self-hosted wallet) x2",
        "tener_seccion5_numero_cuenta_activo1": "Account number for assets held by a custodian or broker x2",
        "tener_seccion5_direccion_activo_digitales1": "Digital asset address for self-hosted digital assets x2",
        "tener_seccion5_activo_digital_equivalente_dolares1": "11111",
        "tener_seccion5_activo_equivalente_dolar_8c": "11111",
        "tener_seccion5_total_cuentas_bancarias_8d": "6002",
        "tener_seccion5_resultado_8a_8d": "7003",
        "tener_seccion5_descripcion_activos1": "Description of asset x2",
        "tener_seccion5_valor_mercado_actual1": "2001",
        "tener_seccion5_valor_mercado_actual_resultado1": "1600.8",
        "tener_seccion5_saldo_negativo_prestados1": "2001",
        "tener_seccion5_resultado_9a": "-400.2",
        "tener_seccion5_descripcion_activos2": "Description of asset(s)  x1",
        "tener_seccion5_valor_mercado_actual2": "3001",
        "tener_seccion5_valor_mercado_actual_resultado2": "2400.8",
        "tener_seccion5_saldo_negativo_prestados2": "301",
        "tener_seccion5_resultado_9b": "2099.8",
        "tener_seccion3_total_cuentas_inversiones_9c": "1699.6",
        "tener_seccion5_resultado_9a_9c": "1299.4",
        "tener_seccion5_resultado_IRS": "-4400.6",
        "tener_seccion5_resultado_9a_9c_menos_IRS": "5700",
        "tener_seccion5_nota_cobrar1_opcion": "Yes",
        "tener_seccion5_tiene_cobrar1_opcional": "Yes",
        "tener_seccion5_cuadro_b": "12703",
        "fecha_post": "2024-12-21 18:18:27",
        "fecha_update": "2024-12-25 12:07:50"
    },
    "data_seccion6": {
        "id": "1",
        "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
        "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
        "forms_id": "9",
        "tener_seccion6_periodo_previsto": "Period provided beginning x1",
        "tener_seccion6_atraves_de": "through x1",
        "tener_seccion6_ingreso_bruto1": "11",
        "tener_seccion6_ingreso_bruto_alquiler1": "22",
        "tener_seccion6_ingreso_por_inteneres1": "33",
        "tener_seccion6_dividiendos1": "44",
        "tener_seccion6_otros_ingresos1": "515",
        "tener_seccion6_total_ingresos_bruto_otros_ingresos1": "526",
        "tener_seccion6_materiales_adquiridos1": "67",
        "tener_seccion6_inventario_comprado1": "78",
        "tener_seccion6_salario_sueldo_bruto1": "89",
        "tener_seccion6_alquiler1": "90",
        "tener_seccion6_suministro1": "101",
        "tener_seccion6_servicios_publicos1": "112",
        "tener_seccion6_costo_vehiculo1": "123",
        "tener_seccion6_seguro_negocio1": "134",
        "tener_seccion6_impuesto_comerciales_actuales1": "145",
        "tener_seccion6_deudas_garantizadas1": "156",
        "tener_seccion6_otros_gastos_comerciales1": "167",
        "tener_seccion6_material_adquirido_otros_gastos_empresariales1": "234",
        "tener_seccion6_cuadro_c": "292",
        "fecha_post": "2024-12-21 19:42:46",
        "fecha_update": "2024-12-25 12:07:50"
    },
    "data_seccion7": {
        "id": "1",
        "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
        "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
        "forms_id": "9",
        "tener_seccion7_salario_bruto1": "111",
        "tener_seccion7_seguro_social1": "222",
        "tener_seccion7_pension1": "333",
        "tener_seccion7_otros_ingresos1": "444",
        "tener_seccion7_ingreso_totales_contribuyente_principal1": "1110",
        "tener_seccion7_salario_bruto2": "11",
        "tener_seccion7_pension2": "33",
        "tener_seccion7_seguro_social2": "22",
        "tener_seccion7_otros_ingresos2": "44",
        "tener_seccion7_ingreso_totales_contribuyente_principal2": "110",
        "tener_seccion7_fuente_adicionales_ingreso1": "Additional sources of income used to support the household, e.g., non-liable spouse, or anyone else who may contribute to the household income, etc. List source(s) ",
        "tener_seccion7_precio_fuente_adicionales_ingreso1": "121",
        "tener_seccion7_intereses1": "11",
        "tener_seccion7_distribuciones1": "22",
        "tener_seccion7_ingreso_neto_alquiler1": "33",
        "tener_seccion7_ingreso_comercial_neto1": "44",
        "tener_seccion7_manutenciol_infantil_recibida1": "11",
        "tener_seccion7_pension_alimenticia_recibida1": "22",
        "tener_seccion7_cuadro_d": "1132",
        "tener_seccion7_alimentos_ropa_articulos_varios1": "11",
        "tener_seccion7_vivienda_servicios_publicos1": "22",
        "tener_seccion7_precio_vivienda_servicios_publicos1": "33",
        "tener_seccion7_pago_prestamo1": "44",
        "tener_seccion7_costo_operativo_vehiculo1": "11",
        "tener_seccion7_costo_trasporte_publico1": "33",
        "tener_seccion7_prima_seguro_salud1": "33",
        "tener_seccion7_costo_atencion_medica_bolsillo1": "11",
        "tener_seccion7_pago_ordenado_tribunal1": "33",
        "tener_seccion7_pago_cuidado_ninos1": "33",
        "tener_seccion7_monto_poliza_seguro_vida1": "22",
        "tener_seccion7_impuestos_mensuales_actuales1": "33",
        "tener_seccion7_deudas_gatos1": "Secured debts/Other (e.g., any loan where you pledged an asset as collateral not previously listed, government guaranteed student loan, employer required retirement or dues)",
        "tener_seccion7_precio_deudas_gastos1": "11",
        "tener_seccion7_pago_moroso_impuesto1": "22",
        "tener_seccion7_cuadro_e": "33",
        "tener_seccion7_cuadro_f": "1099",
        "fecha_post": "2024-12-21 20:23:54",
        "fecha_update": "2024-12-25 12:07:50",
        "tener_seccion7_monto_poliza_seguro_vida_primas1": "112"
    },
    "data_seccion8": {
        "id": "1",
        "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
        "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
        "forms_id": "9",
        "tener_seccion8_opcion_pagar_oferta1": "1",
        "tener_seccion8_caja_f_g": "11",
        "tener_seccion8_caja_g": "132",
        "tener_seccion8_caja_f_h": "0",
        "tener_seccion8_caja_h": "0",
        "tener_seccion8_monto_caja_a_b": "2",
        "tener_seccion8_resultado_caja_g_h": "132",
        "tener_seccion8_monto_oferta1": "134",
        "fecha_post": "2024-12-21 20:56:12",
        "fecha_update": "2024-12-25 12:07:50"
    },
    "data_seccion9": {
        "id": "4",
        "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
        "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
        "forms_id": "9",
        "tener_seccion9_opcion_involucrado_litigio1": "Yes",
        "tener_seccion9_demantante1": "1",
        "tener_seccion9_acusada1": "1",
        "tener_seccion9_lugar_presentacion1": "Location of filing 1 x1",
        "tener_seccion9_representado_por1": "Represented by  1 x1",
        "tener_seccion9_numero_caso1": "Docket/Case number 1 x1",
        "tener_seccion9_cantidad_disputa1": "11333311",
        "tener_seccion9_fecha_finalizacion_posible1": "2024-12-18",
        "tener_seccion9_objeto_litigio1": "Subject of litigation 1 x1",
        "tener_seccion9_pregunta_estado_quiebra1": "Yes",
        "tener_seccion9_campo_fecha1": "2024-12-18",
        "tener_seccion9_fecha_despido1": "2024-12-19",
        "tener_seccion9_fecha_alta1": "2024-12-20",
        "tener_seccion9_numero_peticion1": "Petition no. * 1 x1",
        "tener_seccion9_ubicacion_archivada1": "Location filed *1 x1",
        "tener_seccion9_pregunta_vivido_fuera_EEUU_6_meses1": "Yes",
        "tener_seccion9_fecha_vivida_extranjero_desde1": "2024-12-12",
        "tener_seccion9_fecha_vivida_extranjero_hasta1": "2024-12-19",
        "tener_seccion9_pregunta_formo_parte_algun_litigio_EEUU1": "Yes",
        "tener_seccion9_he_cometido_algun_litigio_EEUU1": "If yes and the litigation included1 xd",
        "tener_seccion9_pregunta_beneficiario_algun_fideicomiso1": "Yes",
        "tener_seccion9_lugar_donde_se_grabo1": "Place where recorded * x1",
        "tener_seccion9_EIN1": "3d",
        "tener_seccion9_EIN2": "4",
        "tener_seccion9_nombre_fideicomiso1": "222 x1",
        "tener_seccion9_monto_previsto_recibir1": "221",
        "tener_seccion9_recibir_importe1": "Yes x1",
        "tener_seccion9_pregunta_es_fiduciario1": "Yes",
        "tener_seccion9_nombre_fideicomiso2": "ee1212312 x1",
        "tener_seccion9_fiduciario_EIN1": "1z",
        "tener_seccion9_fiduciario_EIN2": "z11111",
        "tener_seccion9_pregunta_tener_caja_seguridad1": "Yes",
        "tener_seccion9_ubicacion1": "123 x1",
        "tener_seccion9_contenido1": "1212 x1",
        "tener_seccion9_valor1": "111 1x",
        "tener_seccion9_pregunta_transferencia_activo1": "Yes",
        "tener_seccion9_lista_activos1": "12312 x1",
        "tener_seccion9_valor_momento_transferencia1": "11114",
        "tener_seccion9_fecha_transferencia1": "2024-12-01",
        "tener_seccion9_quien_transfirio1": "Yes x1",
        "tener_seccion9_pregunta_tiene_algun_activo1": "Yes",
        "tener_seccion9_descripcion_activos1": "111 x1",
        "tener_seccion9_pregunta_fondo_retenido_fideicomiso1": "Yes",
        "tener_seccion9_cuando_fondos_retenidos_fideicomiso1": "111",
        "tener_seccion9_donde_fondos_retenidos_fideicomiso1": "11 x1",
        "fecha_post": "2024-12-25 12:07:50",
        "fecha_update": null
    },
    "data_seccion10": {
        "id": "1",
        "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
        "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
        "forms_id": "9",
        "tener_seccion10_opcion1": "1",
        "tener_seccion10_opcion2": "1",
        "tener_seccion10_opcion3": "1",
        "tener_seccion10_opcion4": "1",
        "tener_seccion10_opcion5": "1",
        "tener_seccion10_opcion6": "1",
        "tener_seccion10_opcion7": "1",
        "tener_seccion10_opcion8": "1",
        "tener_seccion10_opcion9": "1",
        "tener_seccion10_opcion10": "1",
        "tener_seccion10_opcion11": "1",
        "tener_seccion10_opcion12": "1",
        "tener_seccion10_opcion13": "1",
        "fecha_post": "2024-12-22 14:47:17",
        "fecha_update": "2024-12-25 12:07:50",
        "tener_seccion10_firma_contribuyente": "Signature of Taxpayer",
        "tener_seccion10_firma_conyugue": "Signature of Spouse",
        "tener_seccion10_fecha_contribuyente": "2024-12-23",
        "tener_seccion10_fecha_conyugue": "2024-12-24"
    }
};
         
         construir_pdf_formulario_433(info);

             
         }

         async function construir_pdf_formulario_433(data)
         {
            let data_seccion1 = data.data_seccion1 || {};
            let data_seccion2 = data.data_seccion2 || {};
            let data_seccion3 = data.data_seccion3 || {};
            let data_seccion4 = data.data_seccion4 || {};
            let data_seccion5 = data.data_seccion5 || {};
            let data_seccion6 = data.data_seccion6 || {};
            let data_seccion7 = data.data_seccion7 || {};
            let data_seccion8 = data.data_seccion8 || {};
            let data_seccion9 = data.data_seccion9 || {};
            let data_seccion10 = data.data_seccion10 || {};

            //seccion 1
            /*
            {
 
               "tener_seccion1_apellido": "Last name s1",
               "tener_seccion1_fecha_nacimiento": "2024-12-06",
               "tener_seccion1_nombre": "First name s1",
               "tener_seccion1_numero_seguro_social1": "s11",
               "tener_seccion1_numero_seguro_social2": "s1",
               "tener_seccion1_numero_seguro_social3": "s111",
               "tener_seccion1_estado_civil1": "Married",
               "tener_seccion1_vivienda1": "Other",
               "tener_seccion1_especificar_otros1": "(specify e.g., share rent, live with relative, etc.)  s1",
               "tener_seccion1_fecha_matrimonio1": "2024-12-07",
               "tener_seccion1_direccion_fiscal_domicilio1": "Home physical address (street, city, state, ZIP code) s1",
               "tener_seccion1_si_estuvo_casado_vivio": "1",
               "tener_seccion1_contado_residencia": "County of residence s1",
               "tener_seccion1_numero_telefono_primario1": "522",
               "tener_seccion1_numero_telefono_primario2": "112",
               "tener_seccion1_numero_telefono_primario3": "2221",
               "tener_seccion1_numero_telefono_segundario1": "112",
               "tener_seccion1_numero_telefono_segundario2": "333",
               "tener_seccion1_numero_telefono_segundario3": "2221",
               "tener_seccion1_numero_FAX1": "333",
               "tener_seccion1_numero_FAX2": "333",
               "tener_seccion1_numero_FAX3": "1111",
               "tener_seccion1_direccion_postal_domicilio1": "Home mailing address (if different from above or post office box number) xd",

               "tener_seccion1_apellido_conyugue1": "Spouse's last name s1",
               "tener_seccion1_nombre_conyugue1": "Spouse's first name s1",
               "tener_seccion1_fecha_nacimiento1": "2024-12-08",
               "tener_seccion1_numero_seguro_social_coyugue1": "s21",
               "tener_seccion1_numero_seguro_social_coyugue2": "s3",
               "tener_seccion1_numero_seguro_social_coyugue3": "s31",

               "tener_seccion1_nombre1": "Name (1) x1",
               "tener_seccion1_age1": "11",
               "tener_seccion1_relacion1": "Relationship (1)  x1",
               "tener_seccion1_contribuye_ingreso_familiar1": "Yes",
               "tener_seccion1_reclamado_independiente1": "No",

               "tener_seccion1_nombre2": "Name (2)  x2",
               "tener_seccion1_age2": "12",
               "tener_seccion1_relacion2": "Relationship (2)  x2",
               "tener_seccion1_reclamado_independiente2": "Yes",
               "tener_seccion1_contribuye_ingreso_familiar2": "No",

               "tener_seccion1_nombre3": "Name (3) x3",
               "tener_seccion1_age3": "14",
               "tener_seccion1_relacion3": "Relationship (3)  x3",
               "tener_seccion1_contribuye_ingreso_familiar3": "No",
               "tener_seccion1_reclamado_independiente3": "Yes",

               "tener_seccion1_nombre4": "Name (4) x4",
               "tener_seccion1_age4": "15",
               "tener_seccion1_relacion4": "Relationship (4) x4",
               "tener_seccion1_contribuye_ingreso_familiar4": "Yes",
               "tener_seccion1_reclamado_independiente4": "No",
      
            }
            */

            let {
               tener_seccion1_apellido = "",
               tener_seccion1_fecha_nacimiento = "",
               tener_seccion1_nombre = "",
               tener_seccion1_numero_seguro_social1 = "",
               tener_seccion1_numero_seguro_social2 = "",
               tener_seccion1_numero_seguro_social3 = "",
               tener_seccion1_estado_civil1 = "",
               tener_seccion1_vivienda1 = "",
               tener_seccion1_especificar_otros1 = "",
               tener_seccion1_fecha_matrimonio1 = "",
               tener_seccion1_direccion_fiscal_domicilio1 = "",
               tener_seccion1_si_estuvo_casado_vivio = "",
               tener_seccion1_contado_residencia = "",
               tener_seccion1_numero_telefono_primario1 = "",
               tener_seccion1_numero_telefono_primario2 = "",
               tener_seccion1_numero_telefono_primario3 = "",
               tener_seccion1_numero_telefono_segundario1 = "",
               tener_seccion1_numero_telefono_segundario2 = "",
               tener_seccion1_numero_telefono_segundario3 = "",
               tener_seccion1_numero_FAX1 = "",
               tener_seccion1_numero_FAX2 = "",
               tener_seccion1_numero_FAX3 = "",
               tener_seccion1_direccion_postal_domicilio1 = "",
               tener_seccion1_apellido_conyugue1 = "",
               tener_seccion1_nombre_conyugue1 = "",
               tener_seccion1_fecha_nacimiento1 = "",
               tener_seccion1_numero_seguro_social_coyugue1 = "",
               tener_seccion1_numero_seguro_social_coyugue2 = "",
               tener_seccion1_numero_seguro_social_coyugue3 = "",
               tener_seccion1_nombre1 = "",
               tener_seccion1_age1 = "",
               tener_seccion1_relacion1 = "",
               tener_seccion1_contribuye_ingreso_familiar1 = "",
               tener_seccion1_reclamado_independiente1 = "",
               tener_seccion1_nombre2 = "",
               tener_seccion1_age2 = "",
               tener_seccion1_relacion2 = "",
               tener_seccion1_reclamado_independiente2 = "",
               tener_seccion1_contribuye_ingreso_familiar2 = "",
               tener_seccion1_nombre3 = "",
               tener_seccion1_age3 = "",
               tener_seccion1_relacion3 = "",
               tener_seccion1_contribuye_ingreso_familiar3 = "",
               tener_seccion1_reclamado_independiente3 = "",
               tener_seccion1_nombre4 = "",
               tener_seccion1_age4 = "",
               tener_seccion1_relacion4 = "",
               tener_seccion1_contribuye_ingreso_familiar4 = "",
               tener_seccion1_reclamado_independiente4 = "",
            } = data_seccion1;

            //seccion 2
            /*
               {
 
                  "tener_seccion2_nombre_empleador": "cesar pineda s1",
                  "tener_seccion2_semanalmente": "1",
                  "tener_seccion2_quincenalmente": "1",
                  "tener_seccion2_mensualmente": "1",
                  "tener_seccion2_otro": "1",
                  "tener_seccion2_participacion_negocio": "No",
                  "tener_seccion2_ocupacion": "programador x1 ",
                  "tener_seccion2_tiempo_empleador_anos": "26 11 x1",
                  "tener_seccion2_tiempo_empleador_mes": "4 x1",
                  "tener_seccion2_direccion_empleado": "Employer’s address (street, city, state, ZIP code) x1",
                  "tener_seccion2_nombre_empleador_conyugue": "Spouse’s employer's name x1",
                  "tener_seccion2_semanalmente_conyuge": "1",
                  "tener_seccion2_quincenalmente_conyuge": "1",
                  "tener_seccion2_mensualmente_conyuge": "1",
                  "tener_seccion2_otro_conyuge": "1",
                  "tener_seccion2_participacion_negocio_conyuge": "Yes",
                  "tener_seccion2_direccion_empleado_conyuge": "Employer’s address (street, city, state, ZIP code)  spouse xx1",
                  "tener_seccion2_ocupacion_conyuge": "years Spouse",
                  "tener_seccion2_tiempo_empleador_anos_conyuge": "years Spouse",
                  "tener_seccion2_tiempo_empleador_mes_conyuge": "months Spouse",
 
               }

            */

            let {
                  tener_seccion2_nombre_empleador,
                  tener_seccion2_semanalmente,
                  tener_seccion2_quincenalmente,
                  tener_seccion2_mensualmente,
                  tener_seccion2_otro,
                  tener_seccion2_participacion_negocio,
                  tener_seccion2_ocupacion,
                  tener_seccion2_tiempo_empleador_anos,
                  tener_seccion2_tiempo_empleador_mes,
                  tener_seccion2_direccion_empleado,
                  tener_seccion2_nombre_empleador_conyugue,
                  tener_seccion2_semanalmente_conyuge,
                  tener_seccion2_quincenalmente_conyuge,
                  tener_seccion2_mensualmente_conyuge,
                  tener_seccion2_otro_conyuge,
                  tener_seccion2_participacion_negocio_conyuge,
                  tener_seccion2_direccion_empleado_conyuge,

                  tener_seccion2_ocupacion_conyuge,
                  tener_seccion2_tiempo_empleador_anos_conyuge,
                  tener_seccion2_tiempo_empleador_mes_conyuge,
            } = data_seccion2;

            //seccion 3
            /*
               {
                  "tener_seccion3_dinero1": "1",
                  "tener_seccion3_ahorros1": "1",
                  "tener_seccion3_cuenta_enlinea1": "1",
                  "tener_seccion3_cheque": "1",
                  "tener_seccion3_CD1": "1",
                  "tener_seccion3_tarjeta_valor_almacenado1": "1",
                  "tener_seccion3_nombre_banco_ubicacion_pais1": "BNCL1 xd",
                  "tener_seccion3_numero_cuenta1": "AN1",
                  "tener_seccion3_efectivo_inversiones_1a": "100",

                  "tener_seccion3_cheque2": "1",
                  "tener_seccion3_ahorros2": "1",
                  "tener_seccion3_cuenta_enlinea2": "1",
                  "tener_seccion3_CD2": "1",
                  "tener_seccion3_tarjeta_valor_almacenado2": "1",
                  "tener_seccion3_nombre_banco_ubicacion_pais2": "BNCL2 x1",
                  "tener_seccion3_numero_cuenta2": "AN2 x1",
                  "tener_seccion3_efectivo_inversiones_1b": "501",
                  "tener_seccion3_efectivo_inversiones_1c": "601",
                  "tener_seccion3_sumna_a1_c1_menos_1000": "-399",

                  "tener_seccion3_acciones1": "1",
                  "tener_seccion3_bonos1": "1",
                  "tener_seccion3_otro1": "1",
                  "tener_seccion3_otro1_opcional": "Otros detalles x1",
                  "tener_seccion3_nombre_institucion_financiera_ubicacion_pais1": "NFICL1 x1",
                  "tener_seccion3_numero_cuenta3": "AN3 x1",
                  "tener_seccion3_valor_mercado_actual1": "10001",
                  "tener_seccion3_valor_mercado_actual_resultado1": "8000.8",
                  "tener_seccion3_saldo_negativo_prestados1": "101",
                  "tener_seccion3_resultado_2a": "7899.8",

                  "tener_seccion3_acciones2": "1",
                  "tener_seccion3_bonos2": "1",
                  "tener_seccion3_otro2": "1",
                  "tener_seccion3_otro2_opcional": "x1",
                  "tener_seccion3_nombre_institucion_financiera_ubicacion_pais2": "NFICL2 x1",
                  "tener_seccion3_numero_cuenta4": "AN4  x1",
                  "tener_seccion3_valor_mercado_actual2": "2001",
                  "tener_seccion3_valor_mercado_actual_resultado2": "1600.8",
                  "tener_seccion3_saldo_negativo_prestados2": "201",
                  "tener_seccion3_resultado_2b": "1399.8",
                  "tener_seccion3_activo_digital1": "1",
                  "tener_seccion3_descripcion_activo_digital1": "Description of digital asset 1 x1",
                  "tener_seccion3_numero_unidades1": "Number of units 1 x1",
                  "tener_seccion3_ubicacion_activo_digital1": "Location of digital asset (exchange account, self-hosted wallet) 1 x1",
                  "tener_seccion3_numero_cuenta_activo1": "Account number for assets held by a custodian or broker  1 x1",
                  "tener_seccion3_direccion_activo_digitales1": "Digital asset address for self-hosted digital assets 1x1",
                  "tener_seccion3_activo_digital_equivalente_dolares1": "231",
                  "tener_seccion3_efectivo_inversiones_2c": "231",
                  "tener_seccion3_total_cuentas_inversiones_2d": "9299.6",
                  "tener_seccion3_resultado_2a_2d": "17199.4",

                  "tener_seccion3_401K": "1",
                  "tener_seccion3_IRA": "1",
                  "tener_seccion3_otro3": "1",
                  "tener_seccion3_otro3_opcional": "mi detalle de otros xq1",
                  "tener_seccion3_nombre_institucion_financiera_ubicacion_pais3": "NFICL22 x1",
                  "tener_seccion3_numero_cuenta5": "AN12 x1",
                  "tener_seccion3_valor_mercado_actual3": "3001",
                  "tener_seccion3_valor_mercado_actual_resultado3": "2400.8",
                  "tener_seccion3_saldo_negativo_prestados3": "127",
                  "tener_seccion3_resultado_3a": "2099.8",
                  "tener_seccion3_total_cuentas_inversiones_3b": "2099.8",
                  "tener_seccion3_resultado_3a_3b": "127",

                  "tener_seccion3_nombre_seguro_compania1": "Name of Insurance Company x1",
                  "tener_seccion3_numero_poliza1": "Policy number x1",
                  "tener_seccion3_valor_mercado_actual4": "4001",
                  "tener_seccion3_valor_mercado_actual_resultado4": "3200.8",
                  "tener_seccion3_saldo_negativo_prestados4": "401",
                  "tener_seccion3_resultado_4a": "2799.8",
                  "tener_seccion3_valor_total_efectivo_poliza1": "5001",
                  "tener_seccion3_saldo_negativo_prestados_total_polizas1": "101",
                  "tener_seccion3_resultado_4b": "4900",
                  "tener_seccion3_resultado_4a_4b": "7699.8",

                  "tener_seccion3_propiedad_inmobilitaria_venta1_si": "1",
                  "tener_seccion3_propiedad_inmobilitaria_venta1_si_opcional": "127",
                  "tener_seccion3_propiedad_inmobilitaria_venta1_no": "0",
                  "tener_seccion3_descripcion_propiedad1": "Property description x1",
                  "tener_seccion3_fecha_compra1": "2024-12-20",
                  "tener_seccion3_monto_pago_hipoteca1": "12231",
                  "tener_seccion3_fecha_pago_final1": "2024-12-20",
                  "tener_seccion3_como_mantiene_titulo1": "How title is held (joint tenancy, etc.)  x1",
                  "tener_seccion3_ubicacion1": "Location (street, city, state, ZIP code, county, and country) x1",
                  "tener_seccion3_nombre_prestamista1": "Lender/Contract holder name, address  x1",
                  "tener_seccion3_valor_mercado_actual5": "5001",
                  "tener_seccion3_valor_mercado_actual_resultado5": "4000.8",
                  "tener_seccion3_saldo_negativo_prestados5": "501",
                  "tener_seccion3_resultado_5a": "3499.8",
                  "tener_seccion3_descripcion_propiedad2": "Property description 1x1",
                  "tener_seccion3_fecha_compra2": "2024-12-26",
                  "tener_seccion3_monto_pago_hipoteca2": "3321",
                  "tener_seccion3_fecha_pago_final2": "2024-12-30",
                  "tener_seccion3_como_mantiene_titulo2": "2221",
                  "tener_seccion3_ubicacion2": "Location (street, city, state, ZIP code, county, and country) x1",
                  "tener_seccion3_nombre_prestamista4": "Lender/Contract holder name, address x1",
                  "tener_seccion3_valor_mercado_actual6": "6001",
                  "tener_seccion3_valor_mercado_actual_resultado6": "4800.8",
                  "tener_seccion3_saldo_negativo_prestados6": "601",
                  "tener_seccion3_resultado_5b": "4199.8",
                  "tener_seccion3_total_cuentas_inversiones_5c": "7699.6",
                  "tener_seccion3_resultado_5a_5c": "11199.4",

                  "tener_seccion3_marca_modelo_vehiculo1": "Vehicle make & model x1",
                  "tener_seccion3_ano_vehiculo1": "40011",
                  "tener_seccion3_fecha_compra_vehiculo1": "2025-01-01",
                  "tener_seccion3_kilometraje_vehiculo1": "34441",
                  "tener_seccion3_numero_licencia_vehiculo1": "12331 x1",
                  "tener_seccion3_dueno_propio_vehiculo1": "Lease",
                  "tener_seccion3_nombre_acreedora_vehiculo1": "1122 x1",
                  "tener_seccion3_fecha_pago_final_vehiculo1": "2025-01-07",
                  "tener_seccion3_monto_prestamo_vehiculo1": "111",
                  "tener_seccion3_valor_mercado_actual7": "7001",
                  "tener_seccion3_valor_mercado_actual_resultado7": "5600.8",
                  "tener_seccion3_saldo_negativo_prestados7": "701",
                  "tener_seccion3_resultado_6a": "4899.8",
                  "tener_seccion3_resultado_6b": "1449.8",

                  "tener_seccion3_marca_modelo_vehiculo2": " Vehicle make & model 1 x1",
                  "tener_seccion3_ano_vehiculo2": "111",
                  "tener_seccion3_fecha_compra_vehiculo2": "2025-01-09",
                  "tener_seccion3_kilometraje_vehiculo2": "33441",
                  "tener_seccion3_numero_licencia_vehiculo2": "112221 x1",
                  "tener_seccion3_dueno_propio_vehiculo2": "Own",
                  "tener_seccion3_nombre_acreedora_vehiculo2": "112223 x1",
                  "tener_seccion3_fecha_pago_final_vehiculo2": "2025-01-09",
                  "tener_seccion3_monto_prestamo_vehiculo2": "1111",
                  "tener_seccion3_valor_mercado_actual8": "127",
                  "tener_seccion3_valor_mercado_actual_resultado8": "101.6",
                  "tener_seccion3_saldo_negativo_prestados8": "801",
                  "tener_seccion3_resultado_6c": "-699.4",
                  "tener_seccion3_resultado_6d": "0",
                  "tener_seccion3_total_cuentas_inversiones_6e": "5115.6",
                  "tener_seccion3_resultado_6b_6d_6e": "6565.4",

                  "tener_seccion3_descripcion_activos1": "Description of asset(s)  x1",
                  "tener_seccion3_valor_mercado_actual9": "11221",
                  "tener_seccion3_valor_mercado_actual_resultado9": "8976.8",
                  "tener_seccion3_saldo_negativo_prestados9": "111",
                  "tener_seccion3_resultado_7a": "8865.8",
                  "tener_seccion3_descripcion_activos2": "Description of asset(s) * xd1",
                  "tener_seccion3_valor_mercado_actual10": "9001",
                  "tener_seccion3_valor_mercado_actual_resultado10": "7200.8",
                  "tener_seccion3_saldo_negativo_prestados10": "901",
                  "tener_seccion3_resultado_7b": "6299.8",
                  "tener_seccion3_total_cuentas_inversiones_7c": "15165.6",
                  "tener_seccion3_resultado_7a_7c": "12641.4",
                  "tener_seccion3_caja_a1": "12242.4",
 
               }
            */

            let {
                  tener_seccion3_dinero1 = "",
                  tener_seccion3_ahorros1 = "",
                  tener_seccion3_cuenta_enlinea1 = "",
                  tener_seccion3_cheque = "",
                  tener_seccion3_CD1 = "",
                  tener_seccion3_tarjeta_valor_almacenado1 = "",
                  tener_seccion3_nombre_banco_ubicacion_pais1 = "",
                  tener_seccion3_numero_cuenta1 = "",
                  tener_seccion3_efectivo_inversiones_1a = "",
                  tener_seccion3_cheque2 = "",
                  tener_seccion3_ahorros2 = "",
                  tener_seccion3_cuenta_enlinea2 = "",
                  tener_seccion3_CD2 = "",
                  tener_seccion3_tarjeta_valor_almacenado2 = "",
                  tener_seccion3_nombre_banco_ubicacion_pais2 = "",
                  tener_seccion3_numero_cuenta2 = "",
                  tener_seccion3_efectivo_inversiones_1b = "",
                  tener_seccion3_efectivo_inversiones_1c = "",
                  tener_seccion3_sumna_a1_c1_menos_1000 = "",
                  tener_seccion3_acciones1 = "",
                  tener_seccion3_bonos1 = "",
                  tener_seccion3_otro1 = "",
                  tener_seccion3_otro1_opcional = "",
                  tener_seccion3_nombre_institucion_financiera_ubicacion_pais1 = "",
                  tener_seccion3_numero_cuenta3 = "",
                  tener_seccion3_valor_mercado_actual1 = "",
                  tener_seccion3_valor_mercado_actual_resultado1 = "",
                  tener_seccion3_saldo_negativo_prestados1 = "",
                  tener_seccion3_resultado_2a = "",
                  tener_seccion3_acciones2 = "",
                  tener_seccion3_bonos2 = "",
                  tener_seccion3_otro2 = "",
                  tener_seccion3_otro2_opcional = "",
                  tener_seccion3_nombre_institucion_financiera_ubicacion_pais2 = "",
                  tener_seccion3_numero_cuenta4 = "",
                  tener_seccion3_valor_mercado_actual2 = "",
                  tener_seccion3_valor_mercado_actual_resultado2 = "",
                  tener_seccion3_saldo_negativo_prestados2 = "",
                  tener_seccion3_resultado_2b = "",
                  tener_seccion3_activo_digital1 = "",
                  tener_seccion3_descripcion_activo_digital1 = "",
                  tener_seccion3_numero_unidades1 = "",
                  tener_seccion3_ubicacion_activo_digital1 = "",
                  tener_seccion3_numero_cuenta_activo1 = "",
                  tener_seccion3_direccion_activo_digitales1 = "",
                  tener_seccion3_activo_digital_equivalente_dolares1 = "",
                  tener_seccion3_efectivo_inversiones_2c = "",
                  tener_seccion3_total_cuentas_inversiones_2d = "",
                  tener_seccion3_resultado_2a_2d = "",
                  tener_seccion3_401K = "",
                  tener_seccion3_IRA = "",
                  tener_seccion3_otro3 = "",
                  tener_seccion3_otro3_opcional = "",
                  tener_seccion3_nombre_institucion_financiera_ubicacion_pais3 = "",
                  tener_seccion3_numero_cuenta5 = "",
                  tener_seccion3_valor_mercado_actual3 = "",
                  tener_seccion3_valor_mercado_actual_resultado3 = "",
                  tener_seccion3_saldo_negativo_prestados3 = "",
                  tener_seccion3_resultado_3a = "",
                  tener_seccion3_total_cuentas_inversiones_3b = "",
                  tener_seccion3_resultado_3a_3b = "",
                  tener_seccion3_nombre_seguro_compania1 = "",
                  tener_seccion3_numero_poliza1 = "",
                  tener_seccion3_valor_mercado_actual4 = "",
                  tener_seccion3_valor_mercado_actual_resultado4 = "",
                  tener_seccion3_saldo_negativo_prestados4 = "",
                  tener_seccion3_resultado_4a = "",
                  tener_seccion3_valor_total_efectivo_poliza1 = "",
                  tener_seccion3_saldo_negativo_prestados_total_polizas1 = "",
                  tener_seccion3_resultado_4b = "",
                  tener_seccion3_resultado_4a_4b = "",
                  tener_seccion3_propiedad_inmobilitaria_venta1_si = "",
                  tener_seccion3_propiedad_inmobilitaria_venta1_si_opcional = "",
                  tener_seccion3_propiedad_inmobilitaria_venta1_no = "",
                  tener_seccion3_descripcion_propiedad1 = "",
                  tener_seccion3_fecha_compra1 = "",
                  tener_seccion3_monto_pago_hipoteca1 = "",
                  tener_seccion3_fecha_pago_final1 = "",
                  tener_seccion3_como_mantiene_titulo1 = "",
                  tener_seccion3_ubicacion1 = "",
                  tener_seccion3_nombre_prestamista1 = "",
                  tener_seccion3_valor_mercado_actual5 = "",
                  tener_seccion3_valor_mercado_actual_resultado5 = "",
                  tener_seccion3_saldo_negativo_prestados5 = "",
                  tener_seccion3_resultado_5a = "",
                  tener_seccion3_descripcion_propiedad2 = "",
                  tener_seccion3_fecha_compra2 = "",
                  tener_seccion3_monto_pago_hipoteca2 = "",
                  tener_seccion3_fecha_pago_final2 = "",
                  tener_seccion3_como_mantiene_titulo2 = "",
                  tener_seccion3_ubicacion2 = "",
                  tener_seccion3_nombre_prestamista4 = "",
                  tener_seccion3_valor_mercado_actual6 = "",
                  tener_seccion3_valor_mercado_actual_resultado6 = "",
                  tener_seccion3_saldo_negativo_prestados6 = "",
                  tener_seccion3_resultado_5b = "",
                  tener_seccion3_total_cuentas_inversiones_5c = "",
                  tener_seccion3_resultado_5a_5c = "",
                  tener_seccion3_marca_modelo_vehiculo1 = "",
                  tener_seccion3_ano_vehiculo1 = "",
                  tener_seccion3_fecha_compra_vehiculo1 = "",
                  tener_seccion3_kilometraje_vehiculo1 = "",
                  tener_seccion3_numero_licencia_vehiculo1 = "",
                  tener_seccion3_dueno_propio_vehiculo1 = "",
                  tener_seccion3_nombre_acreedora_vehiculo1 = "",
                  tener_seccion3_fecha_pago_final_vehiculo1 = "",
                  tener_seccion3_monto_prestamo_vehiculo1 = "",
                  tener_seccion3_valor_mercado_actual7 = "",
                  tener_seccion3_valor_mercado_actual_resultado7 = "",
                  tener_seccion3_saldo_negativo_prestados7 = "",
                  tener_seccion3_resultado_6a = "",
                  tener_seccion3_resultado_6b = "",
                  tener_seccion3_marca_modelo_vehiculo2 = "",
                  tener_seccion3_ano_vehiculo2 = "",
                  tener_seccion3_fecha_compra_vehiculo2 = "",
                  tener_seccion3_kilometraje_vehiculo2 = "",
                  tener_seccion3_numero_licencia_vehiculo2 = "",
                  tener_seccion3_dueno_propio_vehiculo2 = "",
                  tener_seccion3_nombre_acreedora_vehiculo2 = "",
                  tener_seccion3_fecha_pago_final_vehiculo2 = "",
                  tener_seccion3_monto_prestamo_vehiculo2 = "",
                  tener_seccion3_valor_mercado_actual8 = "",
                  tener_seccion3_valor_mercado_actual_resultado8 = "",
                  tener_seccion3_saldo_negativo_prestados8 = "",
                  tener_seccion3_resultado_6c = "",
                  tener_seccion3_resultado_6d = "",
                  tener_seccion3_total_cuentas_inversiones_6e = "",
                  tener_seccion3_resultado_6b_6d_6e = "",
                  tener_seccion3_descripcion_activos1 = "",
                  tener_seccion3_valor_mercado_actual9 = "",
                  tener_seccion3_valor_mercado_actual_resultado9 = "",
                  tener_seccion3_saldo_negativo_prestados9 = "",
                  tener_seccion3_resultado_7a = "",
                  tener_seccion3_descripcion_activos2 = "",
                  tener_seccion3_valor_mercado_actual10 = "",
                  tener_seccion3_valor_mercado_actual_resultado10 = "",
                  tener_seccion3_saldo_negativo_prestados10 = "",
                  tener_seccion3_resultado_7b = "",
                  tener_seccion3_total_cuentas_inversiones_7c = "",
                  tener_seccion3_resultado_7a_7c = "",
                  tener_seccion3_caja_a1 = "",
 
            } = data_seccion3;

            /*
            {
            "id": "2",
            "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
            "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
            "forms_id": "9",
            "tener_seccion4_pregunta_empresa_unipersonal": "No",
            "tener_seccion4_nombre_empresa1": "Name of business  x1",
            "tener_seccion4_direccion_negocio1": "Address of business (if other than personal residence) xd",
            "tener_seccion4_numero_telefono1": "122",
            "tener_seccion4_numero_telefono2": "222",
            "tener_seccion4_numero_telefono3": "3433",
            "tener_seccion4_numero_identificacion_empleador2": "Employer Identification Number x1",
            "tener_seccion4_descripcion_negocio1": "Description of business x1",
            "tener_seccion4_total_numero_empleados1": "1112",
            "tener_seccion4_direccion_sitio_web_comercial1": "Business website address  x1",
            "tener_seccion4_frecuencia_depositos_impuestos1": "Frequency of tax deposits x1",
            "tener_seccion4_nomuna_brutal_mensual_promedio1": "3211",
            "tener_seccion4_nombre_comercial1": "Trade name or DBA  x1",
            "tener_seccion4_direcion_comercial1": "Business address (street, city, state, ZIP code)  xd1",
            "tener_seccion4_numero_telefono6": "554",
            "tener_seccion4_numero_telefono7": "233",
            "tener_seccion4_numero_telefono8": "1434",
            "tener_seccion4_numero_identificacion_empleador1": "Employer Identification Number xd1",
            "tener_seccion4_otro_interesado_comercial_si": "1",
            "tener_seccion4_otro_interesado_comercial_no": "0",
            "tener_seccion4_porcentaje_propiedad_opcional": "11222",
            "tener_seccion4_titulo_opcional": "xd1",
            "tener_seccion4_nombre_comercial2": "Business name  xd1",
            "tener_seccion4_tipo_negocio": "Other",
            "tener_seccion4_otro_tipo_negocios_opcional1": "Description other xd1",
            "fecha_post": "2024-12-21 17:26:49",
            "fecha_update": "2024-12-24 17:27:24"
            }
            */

               let {
               tener_seccion4_pregunta_empresa_unipersonal,
                     tener_seccion4_nombre_empresa1,
                     tener_seccion4_direccion_negocio1,
                     tener_seccion4_numero_telefono1,
                     tener_seccion4_numero_telefono2,
                     tener_seccion4_numero_telefono3,
                     tener_seccion4_numero_identificacion_empleador2,
                     tener_seccion4_descripcion_negocio1,
                     tener_seccion4_total_numero_empleados1,
                     tener_seccion4_direccion_sitio_web_comercial1,
                     tener_seccion4_frecuencia_depositos_impuestos1,
                     tener_seccion4_nomuna_brutal_mensual_promedio1,
                     tener_seccion4_nombre_comercial1,
                     tener_seccion4_direcion_comercial1,
                     tener_seccion4_numero_telefono6,
                     tener_seccion4_numero_telefono7,
                     tener_seccion4_numero_telefono8,
                     tener_seccion4_numero_identificacion_empleador1,
                     tener_seccion4_otro_interesado_comercial_si,
                     tener_seccion4_otro_interesado_comercial_no,
                     tener_seccion4_porcentaje_propiedad_opcional,
                     tener_seccion4_titulo_opcional,
                     tener_seccion4_nombre_comercial2,
                     tener_seccion4_tipo_negocio,
                     tener_seccion4_otro_tipo_negocios_opcional1,
               
                  } = data_seccion4;

               /*

               {
                  "id": "2",
                  "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
                  "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
                  "forms_id": "9",
                  "tener_seccion5_dinero1": "1",
                  "tener_seccion5_ahorros1": "1",
                  "tener_seccion5_cuenta_enlinea1": "1",
                  "tener_seccion5_cheque1": "1",
                  "tener_seccion5_CD1": "1",
                  "tener_seccion5_tarjeta_valor_almacenado1": "1",
                  "tener_seccion5_nombre_banco_ubicacion_pais1": "BNCL1 x1",
                  "tener_seccion5_numero_cuenta1": "AN1 x1",
                  "tener_seccion5_resultado_8a": "1001",

                  "tener_seccion5_dinero2": "0",
                  "tener_seccion5_ahorros2": "1",
                  "tener_seccion5_cuenta_enlinea2": "0",
                  "tener_seccion5_cheque2": "1",
                  "tener_seccion5_CD2": "1",
                  "tener_seccion5_tarjeta_valor_almacenado2": "1",
                  "tener_seccion5_nombre_banco_ubicacion_pais2": "BNCL2 x1",
                  "tener_seccion5_numero_cuenta2": "AN2 x1",
                  "tener_seccion5_resultado_8b": "5001",

                  "tener_seccion5_activo_digital1": "1",
                  "tener_seccion5_descripcion_activo_digital1": "Description of digital asset xd2",
                  "tener_seccion5_numero_unidades1": "Number of units x2",
                  "tener_seccion5_ubicacion_activo_digital1": "Location of digital asset (exchange account, self-hosted wallet) x2",
                  "tener_seccion5_numero_cuenta_activo1": "Account number for assets held by a custodian or broker x2",
                  "tener_seccion5_direccion_activo_digitales1": "Digital asset address for self-hosted digital assets x2",
                  "tener_seccion5_activo_digital_equivalente_dolares1": "11111",
                  "tener_seccion5_activo_equivalente_dolar_8c": "11111",
                  "tener_seccion5_total_cuentas_bancarias_8d": "6002",
                  "tener_seccion5_resultado_8a_8d": "7003",
                  
                  "tener_seccion5_descripcion_activos1": "Description of asset x2",
                  "tener_seccion5_valor_mercado_actual1": "2001",
                  "tener_seccion5_valor_mercado_actual_resultado1": "1600.8",
                  "tener_seccion5_saldo_negativo_prestados1": "2001",
                  "tener_seccion5_resultado_9a": "-400.2",
                  "tener_seccion5_descripcion_activos2": "Description of asset(s)  x1",
                  "tener_seccion5_valor_mercado_actual2": "3001",
                  "tener_seccion5_valor_mercado_actual_resultado2": "2400.8",
                  "tener_seccion5_saldo_negativo_prestados2": "301",
                  "tener_seccion5_resultado_9b": "2099.8",
                  "tener_seccion3_total_cuentas_inversiones_9c": "1699.6",
                  "tener_seccion5_resultado_9a_9c": "1299.4",
                  "tener_seccion5_resultado_IRS": "-4400.6",
                  "tener_seccion5_resultado_9a_9c_menos_IRS": "5700",
                  "tener_seccion5_nota_cobrar1_opcion": "Yes",
                  "tener_seccion5_tiene_cobrar1_opcional": "Yes",
                  "tener_seccion5_cuadro_b": "12703",
                  "fecha_post": "2024-12-21 18:18:27",
                  "fecha_update": "2024-12-24 17:27:24"
               }    

            */

             


               let {
            
                  tener_seccion5_dinero1 = '',
                  tener_seccion5_ahorros1 = '',
                  tener_seccion5_cuenta_enlinea1 = '',
                  tener_seccion5_cheque1 = '',
                  tener_seccion5_CD1 = '',
                  tener_seccion5_tarjeta_valor_almacenado1 = '',
                  tener_seccion5_nombre_banco_ubicacion_pais1 = '',
                  tener_seccion5_numero_cuenta1 = '',
                  tener_seccion5_resultado_8a = '',
                  tener_seccion5_dinero2 = '',
                  tener_seccion5_ahorros2 = '',
                  tener_seccion5_cuenta_enlinea2 = '',
                  tener_seccion5_cheque2 = '',
                  tener_seccion5_CD2 = '',
                  tener_seccion5_tarjeta_valor_almacenado2 = '',
                  tener_seccion5_nombre_banco_ubicacion_pais2 = '',
                  tener_seccion5_numero_cuenta2 = '',
                  tener_seccion5_resultado_8b = '',
                  tener_seccion5_activo_digital1 = '',
                  tener_seccion5_descripcion_activo_digital1 = '',
                  tener_seccion5_numero_unidades1 = '',
                  tener_seccion5_ubicacion_activo_digital1 = '',
                  tener_seccion5_numero_cuenta_activo1 = '',
                  tener_seccion5_direccion_activo_digitales1 = '',
                  tener_seccion5_activo_digital_equivalente_dolares1 = '',
                  tener_seccion5_activo_equivalente_dolar_8c = '',
                  tener_seccion5_total_cuentas_bancarias_8d = '',
                  tener_seccion5_resultado_8a_8d = '',
                  tener_seccion5_descripcion_activos1 = '',
                  tener_seccion5_valor_mercado_actual1 = '',
                  tener_seccion5_valor_mercado_actual_resultado1 = '',
                  tener_seccion5_saldo_negativo_prestados1 = '',
                  tener_seccion5_resultado_9a = '',
                  tener_seccion5_descripcion_activos2 = '',
                  tener_seccion5_valor_mercado_actual2 = '',
                  tener_seccion5_valor_mercado_actual_resultado2 = '',
                  tener_seccion5_saldo_negativo_prestados2 = '',
                  tener_seccion5_resultado_9b = '',
                  tener_seccion3_total_cuentas_inversiones_9c = '',
                  tener_seccion5_resultado_9a_9c = '',
                  tener_seccion5_resultado_IRS = '',
                  tener_seccion5_resultado_9a_9c_menos_IRS = '',
                  tener_seccion5_nota_cobrar1_opcion = '',
                  tener_seccion5_tiene_cobrar1_opcional = '',
                  tener_seccion5_cuadro_b = '',
            
               } = data_seccion5;

               /*
                     {
                     "id": "1",
                     "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
                     "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
                     "forms_id": "9",
                     "tener_seccion6_periodo_previsto": "Period provided beginning x1",
                     "tener_seccion6_atraves_de": "through x1",
                     "tener_seccion6_ingreso_bruto1": "11",
                     "tener_seccion6_ingreso_bruto_alquiler1": "22",
                     "tener_seccion6_ingreso_por_inteneres1": "33",
                     "tener_seccion6_dividiendos1": "44",
                     "tener_seccion6_otros_ingresos1": "515",
                     "tener_seccion6_total_ingresos_bruto_otros_ingresos1": "526",
                     "tener_seccion6_materiales_adquiridos1": "67",
                     "tener_seccion6_inventario_comprado1": "78",
                     "tener_seccion6_salario_sueldo_bruto1": "89",
                     "tener_seccion6_alquiler1": "90",
                     "tener_seccion6_suministro1": "101",
                     "tener_seccion6_servicios_publicos1": "112",
                     "tener_seccion6_costo_vehiculo1": "123",
                     "tener_seccion6_seguro_negocio1": "134",
                     "tener_seccion6_impuesto_comerciales_actuales1": "145",
                     "tener_seccion6_deudas_garantizadas1": "156",
                     "tener_seccion6_otros_gastos_comerciales1": "167",
                     "tener_seccion6_material_adquirido_otros_gastos_empresariales1": "234",
                     "tener_seccion6_cuadro_c": "292",
                     "fecha_post": "2024-12-21 19:42:46",
                     "fecha_update": "2024-12-24 17:27:24"
                  }
               */

               let {
        
                  tener_seccion6_periodo_previsto = '',
                  tener_seccion6_atraves_de = '',
                  tener_seccion6_ingreso_bruto1 = '',
                  tener_seccion6_ingreso_bruto_alquiler1 = '',
                  tener_seccion6_ingreso_por_inteneres1 = '',
                  tener_seccion6_dividiendos1 = '',
                  tener_seccion6_otros_ingresos1 = '',
                  tener_seccion6_total_ingresos_bruto_otros_ingresos1 = '',
                  tener_seccion6_materiales_adquiridos1 = '',
                  tener_seccion6_inventario_comprado1 = '',
                  tener_seccion6_salario_sueldo_bruto1 = '',
                  tener_seccion6_alquiler1 = '',
                  tener_seccion6_suministro1 = '',
                  tener_seccion6_servicios_publicos1 = '',
                  tener_seccion6_costo_vehiculo1 = '',
                  tener_seccion6_seguro_negocio1 = '',
                  tener_seccion6_impuesto_comerciales_actuales1 = '',
                  tener_seccion6_deudas_garantizadas1 = '',
                  tener_seccion6_otros_gastos_comerciales1 = '',
                  tener_seccion6_material_adquirido_otros_gastos_empresariales1 = '',
                  tener_seccion6_cuadro_c = '',
               
               } = data_seccion6;

               /*
                  {
                  "id": "1",
                  "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
                  "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
                  "forms_id": "9",
                  "tener_seccion7_salario_bruto1": "111",
                  "tener_seccion7_seguro_social1": "222",
                  "tener_seccion7_pension1": "333",
                  "tener_seccion7_otros_ingresos1": "444",
                  "tener_seccion7_ingreso_totales_contribuyente_principal1": "1110",
                  "tener_seccion7_salario_bruto2": "11",
                  "tener_seccion7_pension2": "33",
                  "tener_seccion7_seguro_social2": "22",
                  "tener_seccion7_otros_ingresos2": "44",
                  "tener_seccion7_ingreso_totales_contribuyente_principal2": "110",
                  "tener_seccion7_fuente_adicionales_ingreso1": "Additional sources of income used to support the household, e.g., non-liable spouse, or anyone else who may contribute to the household income, etc. List source(s) ",
                  "tener_seccion7_precio_fuente_adicionales_ingreso1": "121",
                  "tener_seccion7_intereses1": "11",
                  "tener_seccion7_distribuciones1": "22",
                  "tener_seccion7_ingreso_neto_alquiler1": "33",
                  "tener_seccion7_ingreso_comercial_neto1": "44",
                  "tener_seccion7_manutenciol_infantil_recibida1": "11",
                  "tener_seccion7_pension_alimenticia_recibida1": "22",
                  "tener_seccion7_cuadro_d": "1132",
                  "tener_seccion7_alimentos_ropa_articulos_varios1": "11",
                  "tener_seccion7_vivienda_servicios_publicos1": "22",
                  "tener_seccion7_precio_vivienda_servicios_publicos1": "33",
                  "tener_seccion7_pago_prestamo1": "44",
                  "tener_seccion7_costo_operativo_vehiculo1": "11",
                  "tener_seccion7_costo_trasporte_publico1": "33",
                  "tener_seccion7_prima_seguro_salud1": "33",
                  "tener_seccion7_monto_poliza_seguro_vida_primas1": "112",
                  "tener_seccion7_costo_atencion_medica_bolsillo1": "11",
                  "tener_seccion7_pago_ordenado_tribunal1": "33",
                  "tener_seccion7_pago_cuidado_ninos1": "33",
                  "tener_seccion7_monto_poliza_seguro_vida1": "22",
                  "tener_seccion7_impuestos_mensuales_actuales1": "33",
                  "tener_seccion7_deudas_gatos1": "Secured debts/Other (e.g., any loan where you pledged an asset as collateral not previously listed, government guaranteed student loan, employer required retirement or dues)",
                  "tener_seccion7_precio_deudas_gastos1": "11",
                  "tener_seccion7_pago_moroso_impuesto1": "22",
                  "tener_seccion7_cuadro_e": "33",
                  "tener_seccion7_cuadro_f": "1099",
                  "fecha_post": "2024-12-21 20:23:54",
                  "fecha_update": "2024-12-24 17:27:24"
               }
               */

               let {
           
                  tener_seccion7_salario_bruto1 = "",
                  tener_seccion7_seguro_social1 = "",
                  tener_seccion7_pension1 = "",
                  tener_seccion7_otros_ingresos1 = "",
                  tener_seccion7_ingreso_totales_contribuyente_principal1 = "",
                  tener_seccion7_salario_bruto2 = "",
                  tener_seccion7_pension2 = "",
                  tener_seccion7_seguro_social2 = "",
                  tener_seccion7_otros_ingresos2 = "",
                  tener_seccion7_ingreso_totales_contribuyente_principal2 = "",
                  tener_seccion7_fuente_adicionales_ingreso1 = "",
                  tener_seccion7_precio_fuente_adicionales_ingreso1 = "",
                  tener_seccion7_intereses1 = "",
                  tener_seccion7_distribuciones1 = "",
                  tener_seccion7_ingreso_neto_alquiler1 = "",
                  tener_seccion7_ingreso_comercial_neto1 = "",
                  tener_seccion7_manutenciol_infantil_recibida1 = "",
                  tener_seccion7_pension_alimenticia_recibida1 = "",
                  tener_seccion7_cuadro_d = "",
                  tener_seccion7_alimentos_ropa_articulos_varios1 = "",
                  tener_seccion7_vivienda_servicios_publicos1 = "",
                  tener_seccion7_precio_vivienda_servicios_publicos1 = "",
                  tener_seccion7_pago_prestamo1 = "",
                  tener_seccion7_costo_operativo_vehiculo1 = "",
                  tener_seccion7_costo_trasporte_publico1 = "",
                  tener_seccion7_prima_seguro_salud1 = "",
                  tener_seccion7_monto_poliza_seguro_vida_primas1 = "",
                  tener_seccion7_costo_atencion_medica_bolsillo1 = "",
                  tener_seccion7_pago_ordenado_tribunal1 = "",
                  tener_seccion7_pago_cuidado_ninos1 = "",
                  tener_seccion7_monto_poliza_seguro_vida1 = "",
                  tener_seccion7_impuestos_mensuales_actuales1 = "",
                  tener_seccion7_deudas_gatos1 = "",
                  tener_seccion7_precio_deudas_gastos1 = "",
                  tener_seccion7_pago_moroso_impuesto1 = "",
                  tener_seccion7_cuadro_e = "",
                  tener_seccion7_cuadro_f = "",
                 
               } = data_seccion7;

               /*
                  {
                     "id": "1",
                     "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
                     "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
                     "forms_id": "9",
                     "tener_seccion8_opcion_pagar_oferta1": "1",
                     "tener_seccion8_caja_f_g": "11",
                     "tener_seccion8_caja_g": "132",
                     "tener_seccion8_caja_f_h": "0",
                     "tener_seccion8_caja_h": "0",
                     "tener_seccion8_monto_caja_a_b": "2",
                     "tener_seccion8_resultado_caja_g_h": "132",
                     "tener_seccion8_monto_oferta1": "134",
                     "fecha_post": "2024-12-21 20:56:12",
                     "fecha_update": "2024-12-25 12:07:50"
                  }
               */

               let {
                  
                  tener_seccion8_opcion_pagar_oferta1 = "",
                  tener_seccion8_caja_f_g = "",
                  tener_seccion8_caja_g = "",
                  tener_seccion8_caja_f_h = "",
                  tener_seccion8_caja_h = "",
                  tener_seccion8_monto_caja_a_b = "",
                  tener_seccion8_resultado_caja_g_h = "",
                  tener_seccion8_monto_oferta1 = "",
                  
               } = data_seccion8;

               /*
                  {
                  "id": "4",
                  "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
                  "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
                  "forms_id": "9",
                  "tener_seccion9_opcion_involucrado_litigio1": "Yes",
                  "tener_seccion9_demantante1": "1",
                  "tener_seccion9_acusada1": "1",
                  "tener_seccion9_lugar_presentacion1": "Location of filing 1 x1",
                  "tener_seccion9_representado_por1": "Represented by  1 x1",
                  "tener_seccion9_numero_caso1": "Docket/Case number 1 x1",
                  "tener_seccion9_cantidad_disputa1": "11333311",
                  "tener_seccion9_fecha_finalizacion_posible1": "2024-12-18",
                  "tener_seccion9_objeto_litigio1": "Subject of litigation 1 x1",

                  "tener_seccion9_pregunta_estado_quiebra1": "Yes",
                  "tener_seccion9_campo_fecha1": "2024-12-18",
                  "tener_seccion9_fecha_despido1": "2024-12-19",
                  "tener_seccion9_fecha_alta1": "2024-12-20",
                  "tener_seccion9_numero_peticion1": "Petition no. * 1 x1",
                  "tener_seccion9_ubicacion_archivada1": "Location filed *1 x1",
                  "tener_seccion9_pregunta_vivido_fuera_EEUU_6_meses1": "Yes",
                  "tener_seccion9_fecha_vivida_extranjero_desde1": "2024-12-12",
                  "tener_seccion9_fecha_vivida_extranjero_hasta1": "2024-12-19",

                  "tener_seccion9_pregunta_formo_parte_algun_litigio_EEUU1": "Yes",
                  "tener_seccion9_he_cometido_algun_litigio_EEUU1": "If yes and the litigation included1 xd",
                  "tener_seccion9_pregunta_beneficiario_algun_fideicomiso1": "Yes",
                  "tener_seccion9_lugar_donde_se_grabo1": "Place where recorded * x1",
                  "tener_seccion9_EIN1": "3d",
                  "tener_seccion9_EIN2": "4",
                  "tener_seccion9_nombre_fideicomiso1": "222 x1",
                  "tener_seccion9_monto_previsto_recibir1": "221",
                  "tener_seccion9_recibir_importe1": "Yes x1",
                  "tener_seccion9_pregunta_es_fiduciario1": "Yes",
                  "tener_seccion9_nombre_fideicomiso2": "ee1212312 x1",
                  "tener_seccion9_fiduciario_EIN1": "1z",
                  "tener_seccion9_fiduciario_EIN2": "z11111",
                  "tener_seccion9_pregunta_tener_caja_seguridad1": "Yes",
                  "tener_seccion9_ubicacion1": "123 x1",
                  "tener_seccion9_contenido1": "1212 x1",
                  "tener_seccion9_valor1": "111 1x",
                  "tener_seccion9_pregunta_transferencia_activo1": "Yes",
                  "tener_seccion9_lista_activos1": "12312 x1",
                  "tener_seccion9_valor_momento_transferencia1": "11114",
                  "tener_seccion9_fecha_transferencia1": "2024-12-01",
                  "tener_seccion9_quien_transfirio1": "Yes x1",
                  "tener_seccion9_pregunta_tiene_algun_activo1": "Yes",
                  "tener_seccion9_descripcion_activos1": "111 x1",
                  "tener_seccion9_pregunta_fondo_retenido_fideicomiso1": "Yes",
                  "tener_seccion9_cuando_fondos_retenidos_fideicomiso1": "111",
                  "tener_seccion9_donde_fondos_retenidos_fideicomiso1": "11 x1",
                  "fecha_post": "2024-12-25 12:07:50",
                  "fecha_update": null
               }
               */

            let {
           
               tener_seccion9_opcion_involucrado_litigio1 = "",
               tener_seccion9_demantante1 = "",
               tener_seccion9_acusada1 = "",
               tener_seccion9_lugar_presentacion1 = "",
               tener_seccion9_representado_por1 = "",
               tener_seccion9_numero_caso1 = "",
               tener_seccion9_cantidad_disputa1 = "",
               tener_seccion9_fecha_finalizacion_posible1 = "",
               tener_seccion9_objeto_litigio1 = "",
               tener_seccion9_pregunta_estado_quiebra1 = "",
               tener_seccion9_campo_fecha1 = "",
               tener_seccion9_fecha_despido1 = "",
               tener_seccion9_fecha_alta1 = "",
               tener_seccion9_numero_peticion1 = "",
               tener_seccion9_ubicacion_archivada1 = "",
               tener_seccion9_pregunta_vivido_fuera_EEUU_6_meses1 = "",
               tener_seccion9_fecha_vivida_extranjero_desde1 = "",
               tener_seccion9_fecha_vivida_extranjero_hasta1 = "",
               tener_seccion9_pregunta_formo_parte_algun_litigio_EEUU1 = "",
               tener_seccion9_he_cometido_algun_litigio_EEUU1 = "",
               tener_seccion9_pregunta_beneficiario_algun_fideicomiso1 = "",
               tener_seccion9_lugar_donde_se_grabo1 = "",
               tener_seccion9_EIN1 = "",
               tener_seccion9_EIN2 = "",
               tener_seccion9_nombre_fideicomiso1 = "",
               tener_seccion9_monto_previsto_recibir1 = "",
               tener_seccion9_recibir_importe1 = "",
               tener_seccion9_pregunta_es_fiduciario1 = "",
               tener_seccion9_nombre_fideicomiso2 = "",
               tener_seccion9_fiduciario_EIN1 = "",
               tener_seccion9_fiduciario_EIN2 = "",
               tener_seccion9_pregunta_tener_caja_seguridad1 = "",
               tener_seccion9_ubicacion1 = "",
               tener_seccion9_contenido1 = "",
               tener_seccion9_valor1 = "",
               tener_seccion9_pregunta_transferencia_activo1 = "",
               tener_seccion9_lista_activos1 = "",
               tener_seccion9_valor_momento_transferencia1 = "",
               tener_seccion9_fecha_transferencia1 = "",
               tener_seccion9_quien_transfirio1 = "",
               tener_seccion9_pregunta_tiene_algun_activo1 = "",
               tener_seccion9_descripcion_activos1 = "",
               tener_seccion9_pregunta_fondo_retenido_fideicomiso1 = "",
               tener_seccion9_cuando_fondos_retenidos_fideicomiso1 = "",
               tener_seccion9_donde_fondos_retenidos_fideicomiso1 = "",
               
            } = data_seccion9;

            /*
             {
                  "id": "1",
                  "UUID": "67585e0f-89fe-450f-8b77-00061a87ac79",
                  "UUID_ENC": "Z1heD4n-RQ-LdwAGGoeseQ",
                  "forms_id": "9",
                  "tener_seccion10_opcion1": "1",
                  "tener_seccion10_opcion2": "1",
                  "tener_seccion10_opcion3": "1",
                  "tener_seccion10_opcion4": "1",
                  "tener_seccion10_opcion5": "1",
                  "tener_seccion10_opcion6": "1",
                  "tener_seccion10_opcion7": "1",
                  "tener_seccion10_opcion8": "1",
                  "tener_seccion10_opcion9": "1",
                  "tener_seccion10_opcion10": "1",
                  "tener_seccion10_opcion11": "1",
                  "tener_seccion10_opcion12": "1",
                  "tener_seccion10_opcion13": "1",
                  "fecha_post": "2024-12-22 14:47:17",
                  "fecha_update": "2024-12-25 12:07:50",
                  "tener_seccion10_firma_contribuyente": "Signature of Taxpayer",
                  "tener_seccion10_firma_conyugue": "Signature of Spouse",
                  "tener_seccion10_fecha_contribuyente": "2024-12-23",
                  "tener_seccion10_fecha_conyugue": "2024-12-24"
               }
            */

            let {
 
               tener_seccion10_opcion1 = "",
               tener_seccion10_opcion2 = "",
               tener_seccion10_opcion3 = "",
               tener_seccion10_opcion4 = "",
               tener_seccion10_opcion5 = "",
               tener_seccion10_opcion6 = "",
               tener_seccion10_opcion7 = "",
               tener_seccion10_opcion8 = "",
               tener_seccion10_opcion9 = "",
               tener_seccion10_opcion10 = "",
               tener_seccion10_opcion11 = "",
               tener_seccion10_opcion12 = "",
               tener_seccion10_opcion13 = "",
 
               tener_seccion10_firma_contribuyente = "",
               tener_seccion10_firma_conyugue = "",
               tener_seccion10_fecha_contribuyente = "",
               tener_seccion10_fecha_conyugue = "",
            } = data_seccion10;
               
             

 
            // URL del PDF existente
            const url = 'https://pdf-lib.js.org/assets/with_update_sections.pdf';

            // Carga el archivo PDF
            const response = await fetch(tener_url_formulario_433);
            const existingPdfBytes = await response.arrayBuffer();

            // Crea un documento PDF con pdf-lib
            const pdfDoc = await PDFLib.PDFDocument.load(existingPdfBytes);

            // Embebe una fuente
            const helveticaFont = await pdfDoc.embedFont(PDFLib.StandardFonts.Helvetica);

            // Get the form containing all the fields
            const form = pdfDoc.getForm()

            // Obtén todos los campos del formulario
            const fields = form.getFields();
 
            //ITIN Application/Renewal

            //if(aplicar_nuevo_ITIN == "1")
            //{
            //   form.getCheckBox('topmostSubform[0].Page1[0].ApplicationType[0].c1_1[0]').check();
            //}else{
            //   form.getCheckBox('topmostSubform[0].Page1[0].ApplicationType[0].c1_1[0]').uncheck();
            //}
 
 

            //Seccion #1
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Last_Name[0]').setText(tener_seccion1_apellido  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].First_Name[0]').setText(tener_seccion1_nombre  || "N/A");

            if(isEmpty(tener_seccion1_fecha_nacimiento) == false)
            {
               let [año, mes, dia] = tener_seccion1_fecha_nacimiento.split('-');
               
               //let a = "2024-12-11"
               let concatnacion = mes + "/" + dia + "/" + año;

               form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Date_Birth[0]').setText(tener_seccion1_nombre  || "");
            }else{
               form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Date_Birth[0]').setText(tener_seccion1_nombre  || "N/A");
            }
             

            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].SSN_3[0]').setText(tener_seccion1_numero_seguro_social1  || "");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].SSN_2[0]').setText(tener_seccion1_numero_seguro_social2  || "");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].SSN_4[0]').setText(tener_seccion1_numero_seguro_social3  || "");

            if(tener_seccion1_estado_civil1 == "Married")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].MaritalStatus[0].CB_02[0]').check();

                
               if(isEmpty(tener_seccion1_fecha_matrimonio1) == false)
               {
                  let [año, mes, dia] = tener_seccion1_fecha_matrimonio1.split('-');
                  
                  //let a = "2024-12-11"
                  let concatenacion = mes + "/" + dia + "/" + año;

                  form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].MaritalStatus[0].date_of_marrage[0]').setText(concatenacion  || "");
               }

            }else{
               //form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].MaritalStatus[0].CB_01[0]').check();
               form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].MaritalStatus[0].date_of_marrage[0]').setText("N/A");
            }

            if(tener_seccion1_estado_civil1 == "Unmarried"){
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].MaritalStatus[0].CB_01[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].MaritalStatus[0].CB_01[0]').uncheck();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Home_Address[0]').setText(tener_seccion1_direccion_fiscal_domicilio1  || "N/A");

            if(tener_seccion1_vivienda1 == "Other" )
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].CB_05[0]').check();

               form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Other[0]').setText(tener_seccion1_especificar_otros1  || "N/A");
            }else{
               form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Other[0]').setText(tener_seccion1_especificar_otros1  || "N/A");
            }

            if(tener_seccion1_vivienda1 == "Own your home" )
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].CB_03[0]').check();
            }

            if(tener_seccion1_vivienda1 == "Rent" )
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].CB_04[0]').check();
            }

            if(tener_seccion1_si_estuvo_casado_vivio == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].If_You_Were[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].If_You_Were[0]').uncheck();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Col1[0].County_Residence[0]').setText(tener_seccion1_contado_residencia  || "N/A");

 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Col1[0].primary[0].Primary_Area_Code[0]').setText(tener_seccion1_numero_telefono_primario1  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Col1[0].primary[0].Primary_Phone1[0]').setText(tener_seccion1_numero_telefono_primario2  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Col1[0].primary[0].Primary_Phone2[0]').setText(tener_seccion1_numero_telefono_primario3  || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Col1[0].Secondary[0].Secondary_Area_Code[0]').setText(tener_seccion1_numero_telefono_segundario1  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Col1[0].Secondary[0].Secondary_Phone1[0]').setText(tener_seccion1_numero_telefono_segundario2  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Col1[0].Secondary[0].Secondary_Phone2[0]').setText(tener_seccion1_numero_telefono_segundario3  || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Col1[0].fax[0].Fax_Area_Code[0]').setText(tener_seccion1_numero_FAX1  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Col1[0].fax[0].Fax_Phone1[0]').setText(tener_seccion1_numero_FAX2  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Col1[0].fax[0].Fax_Phone2[0]').setText(tener_seccion1_numero_FAX3  || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Mailing_Address[0]').setText(tener_seccion1_direccion_postal_domicilio1  || "N/A");
 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Spouse_Last_Name[0]').setText(tener_seccion1_apellido_conyugue1  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Spouse_First_Name[0]').setText(tener_seccion1_nombre_conyugue1  || "N/A");

            if(isEmpty(tener_seccion1_fecha_nacimiento1) == false)
            {
               let [año, mes, dia] = tener_seccion1_fecha_nacimiento1.split('-');
               
               //let a = "2024-12-11"
               let concatenacion = mes + "/" + dia + "/" + año;

               form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Spouse_Date_Birth[0]').setText(concatenacion  || "");
            }else{
               form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Spouse_Date_Birth[0]').setText("N/A");
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].SSN_3[1]').setText(tener_seccion1_numero_seguro_social_coyugue1 || "");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].SSN_2[1]').setText(tener_seccion1_numero_seguro_social_coyugue2 || "");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].SSN_4[1]').setText(tener_seccion1_numero_seguro_social_coyugue3 || "");
 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row1[0].Name_01[0]').setText(tener_seccion1_nombre1  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row1[0].Age_01[0]').setText(tener_seccion1_age1  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row1[0].Relationship_01[0]').setText(tener_seccion1_relacion1  || "N/A");

            if(tener_seccion1_contribuye_ingreso_familiar1 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row1[0].Dependent[0].CB_06[0]').check();
            }else{
               //form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row1[0].Dependent[0].CB_07[0]').check();
            }

            if(tener_seccion1_contribuye_ingreso_familiar1 == "No")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row1[0].Dependent[0].CB_07[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row1[0].Dependent[0].CB_07[0]').uncheck();
            }

            if(tener_seccion1_reclamado_independiente1 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row1[0].Contributes[0].CB_08[0]').check();
            }else{
               //form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row1[0].Contributes[0].CB_09[0]').check();
            }

            if(tener_seccion1_reclamado_independiente1 == "No")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row1[0].Contributes[0].CB_09[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row1[0].Contributes[0].CB_09[0]').uncheck();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row2[0].Name_02[0]').setText(tener_seccion1_nombre2  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row2[0].Age_02[0]').setText(tener_seccion1_age2  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row2[0].Relationship_02[0]').setText(tener_seccion1_relacion2  || "N/A");

            if(tener_seccion1_contribuye_ingreso_familiar2 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row2[0].Dependent[0].CB_10[0]').check();
            }else{
               //form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row2[0].Dependent[0].CB_11[0]').check();
            }

            if(tener_seccion1_contribuye_ingreso_familiar2 == "No")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row2[0].Dependent[0].CB_11[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row2[0].Dependent[0].CB_11[0]').uncheck();
            }

            if(tener_seccion1_reclamado_independiente2 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row2[0].Contributes[0].CB_12[0]').check();
            }else{
               //form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row2[0].Contributes[0].CB_13[0]').check();
            }

            if(tener_seccion1_reclamado_independiente2 == "No")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row2[0].Contributes[0].CB_13[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row2[0].Contributes[0].CB_13[0]').uncheck();
            }
 
            //name 3
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row3[0].Name_03[0]').setText(tener_seccion1_nombre3  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row3[0].Age_03[0]').setText(tener_seccion1_age3  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row3[0].Relationship_03[0]').setText(tener_seccion1_relacion3  || "N/A");

            if(tener_seccion1_contribuye_ingreso_familiar3 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row3[0].Dependent[0].CB_14[0]').check();
            }else{
               //form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row3[0].Dependent[0].CB_15[0]').check();
            }

            if(tener_seccion1_contribuye_ingreso_familiar3 == "No")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row3[0].Dependent[0].CB_15[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row3[0].Dependent[0].CB_15[0]').uncheck();
            }

            if(tener_seccion1_reclamado_independiente3 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row3[0].Contributes[0].CB_16[0]').check();
            }else{
               //form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row3[0].Contributes[0].CB_17[0]').check();
            }

            if(tener_seccion1_reclamado_independiente3 == "No")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row3[0].Contributes[0].CB_17[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row3[0].Contributes[0].CB_17[0]').uncheck();
            }

 
            //name 4
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row4[0].Name_04[0]').setText(tener_seccion1_nombre4  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row4[0].Age_04[0]').setText(tener_seccion1_age4  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row4[0].Relationship_04[0]').setText(tener_seccion1_relacion4  || "N/A");

            if(tener_seccion1_contribuye_ingreso_familiar4 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row4[0].Dependent[0].CB_18[0]').check();
            }else{
               //form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row4[0].Dependent[0].CB_19[0]').check();
            }

            if(tener_seccion1_contribuye_ingreso_familiar4 == "No")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row4[0].Dependent[0].CB_19[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row4[0].Dependent[0].CB_19[0]').uncheck();
            }

            if(tener_seccion1_reclamado_independiente4 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row4[0].Contributes[0].CB_20[0]').check();
            }else{
               //form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row4[0].Contributes[0].CB_21[0]').check();
            }

            if(tener_seccion1_reclamado_independiente4 == "No")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row4[0].Contributes[0].CB_21[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section1[0].Table1[0].Row4[0].Contributes[0].CB_21[0]').uncheck();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].Your_Employer_Name[0]').setText(tener_seccion2_nombre_empleador  || "N/A");

            if(tener_seccion2_semanalmente == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].pay_period[0].weekly[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].pay_period[0].weekly[0]').uncheck();
            }

            if(tener_seccion2_quincenalmente == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].pay_period[0].biweekly[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].pay_period[0].biweekly[0]').uncheck();
            }

            if(tener_seccion2_mensualmente == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].pay_period[0].monthly[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].pay_period[0].monthly[0]').uncheck();
            }

            if(tener_seccion2_otro == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].pay_period[0].other[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].pay_period[0].other[0]').uncheck();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].Your_Employer_Address[0]').setText(tener_seccion2_direccion_empleado  || "N/A");
            
            if(tener_seccion2_otro == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].pay_period[0].other[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].pay_period[0].other[0]').uncheck();
            }

            if(tener_seccion2_participacion_negocio == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].BusinessInterest[0].CB_22[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].BusinessInterest[0].CB_23[0]').check();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].Your_Occupation[0]').setText(tener_seccion2_ocupacion  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].Years_With_Employer_1[0]').setText(tener_seccion2_tiempo_empleador_anos  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].You[0].Months_With_Employer_1[0]').setText(tener_seccion2_tiempo_empleador_mes  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].Spouse[0].Spouse_Employer_Name[0]').setText(tener_seccion2_nombre_empleador_conyugue  || "N/A");
 
            if(tener_seccion2_semanalmente_conyuge == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].Spouse[0].pay_period[0].weekly[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].Spouse[0].pay_period[0].weekly[0]').uncheck();
            }

            if(tener_seccion2_quincenalmente_conyuge == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].Spouse[0].pay_period[0].biweekly[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].Spouse[0].pay_period[0].biweekly[0]').uncheck();
            }

            if(tener_seccion2_mensualmente_conyuge == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].Spouse[0].pay_period[0].monthly[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].Spouse[0].pay_period[0].monthly[0]').uncheck();
            }

            if(tener_seccion2_otro_conyuge == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].Spouse[0].pay_period[0].other[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].Spouse[0].pay_period[0].other[0]').uncheck();
            }

            if(tener_seccion2_participacion_negocio_conyuge == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].Spouse[0].InterestinBusiness[0].CB_27[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].Spouse[0].InterestinBusiness[0].CB_28[0]').check();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].Spouse[0].Spouse_Employer_Address[0]').setText(tener_seccion2_direccion_empleado_conyuge  || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].Spouse[0].Spouse_Occupation[0]').setText(tener_seccion2_ocupacion_conyuge  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].Spouse[0].Years_With_Employer_2[0]').setText(tener_seccion2_tiempo_empleador_mes_conyuge   || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page1[0].Section2[0].Spouse[0].Months_With_Employer_2[0]').setText(tener_seccion2_tiempo_empleador_mes_conyuge  || "N/A");

            //Seccion 3

            if(tener_seccion3_dinero1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account1[0].CB2_01[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account1[0].CB2_01[0]').uncheck();
            }

            if(tener_seccion3_cheque == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account1[0].CB2_02[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account1[0].CB2_02[0]').uncheck();
            }

            if(tener_seccion3_ahorros1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account1[0].CB2_03[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account1[0].CB2_03[0]').uncheck();
            }

            if(tener_seccion3_CD1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account1[0].CB2_04[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account1[0].CB2_04[0]').uncheck();
            }

            if(tener_seccion3_cuenta_enlinea1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account1[0].CB2_05[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account1[0].CB2_05[0]').uncheck();
            }

            if(tener_seccion3_tarjeta_valor_almacenado1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account1[0].CB2_06[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account1[0].CB2_06[0]').uncheck();
            }
 
 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Account1[0].Bank_Name_1[0]').setText(tener_seccion2_direccion_empleado_conyuge  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Account1[0].Account_Number_1[0]').setText(tener_seccion3_numero_cuenta1  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Account1[0].Total_Amount_1[0]').setText(tener_seccion3_efectivo_inversiones_1a  || "N/A");

            
            if(tener_seccion3_cheque2 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account2[0].CB2_07[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account2[0].CB2_07[0]').uncheck();
            }

            if(tener_seccion3_ahorros2 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account2[0].CB2_08[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account2[0].CB2_08[0]').uncheck();
            }

            if(tener_seccion3_CD2 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account2[0].CB2_09[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account2[0].CB2_09[0]').uncheck();
            }

            if(tener_seccion3_cuenta_enlinea2 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account2[0].CB2_10[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account2[0].CB2_10[0]').uncheck();
            }

            if(tener_seccion3_tarjeta_valor_almacenado2 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account2[0].CB2_11[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Account2[0].CB2_11[0]').uncheck();
            }
 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Account2[0].Bank_Name_2[0]').setText(tener_seccion3_nombre_banco_ubicacion_pais2 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Account2[0].Account_Number_2[0]').setText(tener_seccion3_numero_cuenta2  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Account2[0].Total_Amount_2[0]').setText(tener_seccion3_efectivo_inversiones_1b  || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].TotalAccounts[0].Total_Accounts_Attachment[0]').setText(tener_seccion3_efectivo_inversiones_1c  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].TotalAccounts[0].Total_Amount_3[0]').setText(tener_seccion3_sumna_a1_c1_menos_1000  || "N/A");

            // comment
 
            if(tener_seccion3_acciones1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Institution1[0].CB2_12[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Institution1[0].CB2_12[0]').uncheck();
            }

            if(tener_seccion3_bonos1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Institution1[0].CB2_13[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Institution1[0].CB2_13[0]').uncheck();
            }

            if(tener_seccion3_otro1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Institution1[0].CB2_14[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Institution1[0].CB2_14[0]').uncheck();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Institution1[0].Other[0]').setText(tener_seccion3_otro1_opcional  || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Institution1[0].Name_Financial_Institution[0]').setText(tener_seccion3_nombre_institucion_financiera_ubicacion_pais1  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Institution1[0].Account_Number_3[0]').setText(tener_seccion3_numero_cuenta3  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Institution1[0].CurrentMarketValue[0].Current_Market_Value[0]').setText(tener_seccion3_valor_mercado_actual1  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Institution1[0].CurrentMarketValue[0].Times_8[0]').setText(tener_seccion3_valor_mercado_actual_resultado1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Institution1[0].LessLoanBal[0].Less_Loan_Balance[0]').setText(tener_seccion3_saldo_negativo_prestados1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Institution1[0].Total_Current_Market_Value[0]').setText(tener_seccion3_resultado_2a || "N/A");

             
            if(tener_seccion3_acciones2 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Institution2[0].CB2_12[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Institution2[0].CB2_12[0]').uncheck();
            }

            if(tener_seccion3_bonos2 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Institution2[0].CB2_13[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Institution2[0].CB2_13[0]').uncheck();
            }

            if(tener_seccion3_otro2 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Institution2[0].CB2_14[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].Institution2[0].CB2_14[0]').uncheck();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Institution2[0].Other[0]').setText(tener_seccion3_otro2_opcional || "N/A");
 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Institution2[0].Name_Financial_Institution[0]').setText(tener_seccion3_nombre_institucion_financiera_ubicacion_pais2  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Institution2[0].Account_Number_3[0]').setText(tener_seccion3_numero_cuenta4  || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Institution2[0].CurrentMarketValue[0].Current_Market_Value[0]').setText(tener_seccion3_valor_mercado_actual2  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Institution2[0].CurrentMarketValue[0].Times_8[0]').setText(tener_seccion3_valor_mercado_actual_resultado2  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Institution2[0].LessLoanBal[0].Less_Loan_Balance[0]').setText(tener_seccion3_saldo_negativo_prestados2  || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].Institution2[0].Total_Current_Market_Value[0]').setText(tener_seccion3_resultado_2b || "N/A");

 
            if(tener_seccion3_activo_digital1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct1[0].virtualCurrency[0].virtualCurrency[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct1[0].virtualCurrency[0].virtualCurrency[0]').uncheck();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct1[0].virtualCurrency[0].descriptionDigitalAsset[0]').setText(tener_seccion3_descripcion_activo_digital1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct1[0].numberOfUnits[0]').setText(tener_seccion3_numero_unidades1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct1[0].locationDigitalAsset[0]').setText(tener_seccion3_ubicacion_activo_digital1|| "N/A") ;
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct1[0].assetsAccountNumber[0]').setText(tener_seccion3_numero_cuenta_activo1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct1[0].name_of_individual[0]').setText(tener_seccion3_direccion_activo_digitales1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct1[0].dollarEquivalentToday[0].digitalAssetToday[0]').setText(tener_seccion3_activo_digital_equivalente_dolares1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct1[0].TotalCurrentMarketValue[0]').setText(tener_seccion3_efectivo_inversiones_2c || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].TotalInvestmentAccts[0].Total_Investment_Acct_Attached[0]').setText(tener_seccion3_total_cuentas_inversiones_2d || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].TotalInvestmentAccts[0].Total_Investment_Accounts[0]').setText(tener_seccion3_resultado_2a_2d || "N/A");
            

            if(tener_seccion3_401K == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct2[0].CB2_15[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct2[0].CB2_15[0]').uncheck();
            }

            if(tener_seccion3_IRA == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct2[0].CB2_16[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct2[0].CB2_16[0]').uncheck();
            }

            if(tener_seccion3_otro3 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct2[0].CB2_17[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct2[0].CB2_17[0]').uncheck();
            }

 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct2[0].Name_Financial_Institution[0]').setText(tener_seccion3_nombre_institucion_financiera_ubicacion_pais3 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct2[0].Account_Number[0]').setText(tener_seccion3_numero_cuenta5 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct2[0].Other_Retirement_Acct[0]').setText(tener_seccion3_otro3_opcional || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct2[0].CurrentMarketValue[0].Current_Market_Value[0]').setText(tener_seccion3_otro3_opcional || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct2[0].Other_Retirement_Acct[0]').setText(tener_seccion3_valor_mercado_actual3 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct2[0].CurrentMarketValue[0].Times_7[0]').setText(tener_seccion3_valor_mercado_actual_resultado3 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct2[0].LessLoanBal[0].Less_Loan_Balance[0]').setText(tener_seccion3_saldo_negativo_prestados3 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct2[0].Total_Current_Market_Value[0]').setText(tener_seccion3_resultado_3a || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].TotalRetirementAccts[0].Total_Investment_Account_Attached[0]').setText(tener_seccion3_total_cuentas_inversiones_3b || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].TotalRetirementAccts[0].Total_Retirement_Accounts[0]').setText(tener_seccion3_resultado_3a_3b || "N/A");
 

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].CurrentCash[0].Name_Insurance_Company[0]').setText(tener_seccion3_nombre_seguro_compania1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].CurrentCash[0].Policy_Number[0]').setText(tener_seccion3_numero_poliza1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].CurrentCash[0].CurrentCashValue[0].Current_Cash_Value[0]').setText(tener_seccion3_valor_mercado_actual4 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].CurrentCash[0].LessLoanBal1[0].Less_Loan_Balance[0]').setText(tener_seccion3_valor_mercado_actual_resultado4 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].CurrentCash[0].Total_Current_Cash_Value[0]').setText(tener_seccion3_resultado_4a || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].TotalLife[0].TotalLifeIns[0].Total_Life_Ins_Attached[0]').setText(tener_seccion3_valor_total_efectivo_poliza1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].TotalLife[0].LessLoanbal2[0].Less_Loan_Balance[0]').setText(tener_seccion3_saldo_negativo_prestados_total_polizas1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].TotalLife[0].Total_Life_Insurance[0]').setText(tener_seccion3_resultado_4b || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page2[0].TotalCashLife[0].Total_Insurance[0]').setText(tener_seccion3_resultado_4a_4b || "N/A");

 

            if(tener_seccion3_propiedad_inmobilitaria_venta1_si == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page3[0].ForSale[0].CB2_15[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page3[0].ForSale[0].CB2_15[0]').uncheck();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].ForSale[0].listing_price[0]').setText(tener_seccion3_propiedad_inmobilitaria_venta1_si_opcional || "N/A");

            if(tener_seccion3_propiedad_inmobilitaria_venta1_no == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page3[0].ForSale[0].CB2_16[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page3[0].ForSale[0].CB2_16[0]').uncheck();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property1[0].property_description[0]').setText(tener_seccion3_descripcion_propiedad1 || "N/A");

            if(isEmpty(tener_seccion3_fecha_compra1) == false)
            {
               let [año, mes, dia] = tener_seccion3_fecha_compra1.split('-');
               
               //let a = "2024-12-11"
               let concatenacion = mes + "/" + dia + "/" + año;

               form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property1[0].purchased_lease_date[0]').setText(concatenacion || "");
            }else{
               form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property1[0].purchased_lease_date[0]').setText("N/A");
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property1[0].amount_of_mortgage[0]').setText(tener_seccion3_monto_pago_hipoteca1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property1[0].date_of_final[0]').setText(tener_seccion3_fecha_pago_final1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property1[0].how_title_held[0]').setText(tener_seccion3_como_mantiene_titulo1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property1[0].location[0]').setText(tener_seccion3_ubicacion1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property1[0].lender_lessor_landlord[0]').setText(tener_seccion3_nombre_prestamista1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property1[0].current_market_value[0].current_market_value[1]').setText(tener_seccion3_valor_mercado_actual5 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property1[0].current_market_value[0].times_8[0]').setText(tener_seccion3_valor_mercado_actual_resultado5 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property1[0].minus_loan_balance[0].minus_loan_balance[1]').setText(tener_seccion3_saldo_negativo_prestados5 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property1[0].total_real_estate[0]').setText(tener_seccion3_resultado_5a || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property2[0].property_description[0]').setText(tener_seccion3_total_cuentas_inversiones_5c || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].TotalValueProperty[0].Total_Value_Property[0]').setText(tener_seccion3_resultado_5a_5c || "N/A");

 
            if(isEmpty(tener_seccion3_fecha_compra2) == false)
            {
               let [año, mes, dia] = tener_seccion3_fecha_compra2.split('-');
               
               //let a = "2024-12-11"
               let concatenacion = mes + "/" + dia + "/" + año;

               form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property2[0].purchased_lease_date[0]').setText(concatenacion || "");
            }else{
               form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property2[0].purchased_lease_date[0]').setText("N/A");
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property2[0].amount_of_mortgage[0]').setText(tener_seccion3_monto_pago_hipoteca2 || "N/A");

            if(isEmpty(tener_seccion3_fecha_pago_final2) == false)
            {
               let [año, mes, dia] = tener_seccion3_fecha_pago_final2.split('-');
               
               //let a = "2024-12-11"
               let concatenacion = mes + "/" + dia + "/" + año;

               form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property2[0].date_of_final[0]').setText(concatenacion);
            }else{
               form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property2[0].date_of_final[0]').setText("N/A");
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property2[0].how_title_held[0]').setText(tener_seccion3_como_mantiene_titulo2 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property2[0].location[0]').setText(tener_seccion3_ubicacion2 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property2[0].lender_lessor_landlord[0]').setText(tener_seccion3_nombre_prestamista4 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property2[0].current_market_value[0].current_market_value[1]').setText(tener_seccion3_valor_mercado_actual6 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property2[0].current_market_value[0].times_8[0]').setText(tener_seccion3_valor_mercado_actual_resultado6 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property2[0].minus_loan_balance[0].minus_loan_balance[1]').setText(tener_seccion3_saldo_negativo_prestados6 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Property2[0].total_real_estate[0]').setText(tener_seccion3_resultado_5b || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].TotalValueProperty[0].Total_Value_Property_Attached[0]').setText(tener_seccion3_total_cuentas_inversiones_5c || "N/A");

 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle1[0].Vehicle_Make_Model[0]').setText(tener_seccion3_marca_modelo_vehiculo1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle1[0].Year[0]').setText(tener_seccion3_ano_vehiculo1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle1[0].Date_Purchased[0]').setText(tener_seccion3_fecha_compra_vehiculo1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle1[0].Mileage[0]').setText(tener_seccion3_kilometraje_vehiculo1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle1[0].LicenseTagNumber[0]').setText(tener_seccion3_numero_licencia_vehiculo1 || "N/A");

            if(tener_seccion3_dueno_propio_vehiculo1 == "Lease")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle1[0].LeaseLoan[0].CB3_05[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle1[0].LeaseLoan[0].CB3_06[0]').uncheck();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle1[0].Name_Creditor[0]').setText(tener_seccion3_nombre_acreedora_vehiculo1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle1[0].Date_Final_Payment[0]').setText(tener_seccion3_fecha_pago_final_vehiculo1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle1[0].Monthly_Lease_Amount[0]').setText(tener_seccion3_monto_prestamo_vehiculo1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle1[0].CurrentMarket[0].Current_Market_Value[0]').setText(tener_seccion3_valor_mercado_actual7 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle1[0].CurrentMarket[0].Times_8[0]').setText(tener_seccion3_valor_mercado_actual_resultado7 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle1[0].LessLoan[0].Less_Loan_Balance[0]').setText(tener_seccion3_saldo_negativo_prestados7 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle1[0].Total_Value_Vehicle[0]').setText(tener_seccion3_resultado_6a || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].line6b[0]').setText(tener_seccion3_resultado_6b || "N/A");
 
 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle2[0].Vehicle_Make_Model[0]').setText(tener_seccion3_marca_modelo_vehiculo2 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle2[0].Year[0]').setText(tener_seccion3_ano_vehiculo2 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle2[0].Date_Purchased[0]').setText(tener_seccion3_fecha_compra_vehiculo2 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle2[0].Mileage[0]').setText(tener_seccion3_kilometraje_vehiculo2 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle2[0].LicenseTagNumber[0]').setText(tener_seccion3_numero_licencia_vehiculo2 || "N/A");

            if(tener_seccion3_dueno_propio_vehiculo2 == "Lease")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle2[0].LeaseLoan[0].CB3_05[0]').check();
            }else{ 
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle2[0].LeaseLoan[0].CB3_06[0]').check();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle2[0].Name_Creditor[0]').setText(tener_seccion3_nombre_acreedora_vehiculo2 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle2[0].Date_Final_Payment[0]').setText(tener_seccion3_fecha_pago_final_vehiculo2 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle2[0].Monthly_Lease_Amount[0]').setText(tener_seccion3_monto_prestamo_vehiculo2 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle2[0].CurrentMarket[0].Current_Market_Value[0]').setText(tener_seccion3_valor_mercado_actual8 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle2[0].CurrentMarket[0].Times_8[0]').setText(tener_seccion3_valor_mercado_actual_resultado8 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle2[0].LessLoan[0].Less_Loan_Balance[0]').setText(tener_seccion3_saldo_negativo_prestados8 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Vehicle2[0].Total_Value_Vehicle[0]').setText(tener_seccion3_resultado_6c || "N/A");
 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Total_Value_Vehicles_Attached[0]').setText(tener_seccion3_resultado_6d || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Enter_Allowance[0]').setText(tener_seccion3_total_cuentas_inversiones_6e || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page3[0].Total_Value_Vehicles_Amount[0]').setText(tener_seccion3_resultado_6b_6d_6e || "N/A");

             form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section3[0].OtherAsset1[0].Description[0]').setText(tener_seccion3_descripcion_activos1 || "N/A");

             form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section3[0].OtherAsset1[0].CurrentMarketValue[0].Current_Market_Value[0]').setText(tener_seccion3_valor_mercado_actual9 || "N/A");

             form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section3[0].OtherAsset1[0].CurrentMarketValue[0].Times_8[0]').setText(tener_seccion3_valor_mercado_actual_resultado9 || "N/A");
             
             form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section3[0].OtherAsset1[0].LessLoanBal[0].Less_Loan_Balance[0]').setText(tener_seccion3_saldo_negativo_prestados9 || "N/A");

             form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section3[0].OtherAsset1[0].Total_Other_Asset[0]').setText(tener_seccion3_resultado_7a || "N/A");

             form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section3[0].OtherAsset2[0].Description[0]').setText(tener_seccion3_descripcion_activos2 || "N/A");

             form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section3[0].OtherAsset2[0].CurrentMarketValue[0].Current_Market_Value[0]').setText(tener_seccion3_valor_mercado_actual10 || "N/A");
             
             form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section3[0].OtherAsset2[0].CurrentMarketValue[0].Times_8[0]').setText(tener_seccion3_valor_mercado_actual_resultado10 || "N/A");
             
             form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section3[0].OtherAsset2[0].LessLoanBal[0].Less_Loan_Balance[0]').setText(tener_seccion3_saldo_negativo_prestados10 || "N/A");
            
             form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section3[0].OtherAsset2[0].Total_Other_Asset[0]').setText(tener_seccion3_resultado_7b || "N/A");

             form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section3[0].TotalOther[0].Total_Value_Attached[0]').setText(tener_seccion3_total_cuentas_inversiones_7c || "N/A");

             form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section3[0].TotalOther[0].Total_Value_Other_Valuable_Items[0]').setText(tener_seccion3_resultado_7a_7c || "N/A");

             form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section3[0].Available_Individual_Equity_Assets[0]').setText(tener_seccion3_caja_a1 || "N/A");

             //SECCION 4
 
 
            if(tener_seccion4_pregunta_empresa_unipersonal == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].Business[0].CB4_01[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].Business[0].CB4_02[0]').check();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].Business[0].Name_Business[0]').setText(tener_seccion4_nombre_empresa1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].Address_Business[0]').setText(tener_seccion4_direccion_negocio1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].BusinessTelephone[0].Business_Area_Code[0]').setText(tener_seccion4_numero_telefono1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].BusinessTelephone[0].Business_Phone1[0]').setText(tener_seccion4_numero_telefono2 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].BusinessTelephone[0].Business_Phone2[0]').setText(tener_seccion4_numero_telefono3 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].BusinessTelephone[0].Business_Phone2[0]').setText(tener_seccion4_numero_telefono3 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].EIN[0]').setText(tener_seccion4_numero_identificacion_empleador2 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].Business_Website[0]').setText(tener_seccion4_direccion_sitio_web_comercial1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].Trade_Name[0]').setText(tener_seccion4_nombre_comercial1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].Description_Business[0]').setText(tener_seccion4_descripcion_negocio1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].Total_Employees[0]').setText(tener_seccion4_total_numero_empleados1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].Frequency_Tax_Deposits[0]').setText(tener_seccion4_frecuencia_depositos_impuestos1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].AvgGross[0].Average_Gross_Monthly_Payroll[0]').setText(tener_seccion4_nomuna_brutal_mensual_promedio1 || "N/A");

            if(tener_seccion4_otro_interesado_comercial_si == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].OtherBusinessInterests[0].CB4_03[0]').check();
            }

            if(tener_seccion4_otro_interesado_comercial_no == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].OtherBusinessInterests[0].CB4_04[0]').check();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].OtherBusinessInterests[0].Percentage_Ownership[0]').setText(tener_seccion4_porcentaje_propiedad_opcional || "");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].OtherBusinessInterests[0].Title[0]').setText(tener_seccion4_titulo_opcional || "N/A");
            
 
            //form.getCheckBox('topmostSubform[0].F433-A-OIC_Page2[0].RetirementAcct1[0].virtualCurrency[0].virtualCurrency[0]').check();

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].Other_Business_Address[0]').setText(tener_seccion4_direcion_comercial1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].Other_Business_Name[0]').setText(tener_seccion4_nombre_comercial2 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].OtherTelephone[0].Other_Business_Area_Code[0]').setText(tener_seccion4_numero_telefono6 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].OtherTelephone[0].Other_Business_Phone1[0]').setText(tener_seccion4_numero_telefono7 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].OtherTelephone[0].Other_Business_Phone2[0]').setText(tener_seccion4_numero_telefono8 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].Other_Business_EIN[0]').setText(tener_seccion4_numero_identificacion_empleador1 || "N/A");

 

            if(tener_seccion4_tipo_negocio == "Other"){
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].CB4_08[0]').check();
               form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].Other_Type_Of_Business[0]').setText(tener_seccion4_otro_tipo_negocios_opcional1 || "N/A");
            }else{
               form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].Other_Type_Of_Business[0]').setText("N/A");
            }

            if(tener_seccion4_tipo_negocio == "Partnership"){
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].CB4_05[0]').check();
            }

            if(tener_seccion4_tipo_negocio == "LLC"){
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].CB4_06[0]').check();
            }

            if(tener_seccion4_tipo_negocio == "Corporation"){
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section4[0].CB4_07[0]').check();
            }

            //SECCION 5

            if(tener_seccion5_dinero1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account1[0].C2_07[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account1[0].C2_07[0]').uncheck();
            }

            if(tener_seccion5_cheque1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account1[0].C2_08[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account1[0].C2_08[0]').uncheck();
            }

            if(tener_seccion5_ahorros1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account1[0].C2_09[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account1[0].C2_09[0]').uncheck();
            }

            if(tener_seccion5_CD1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account1[0].C2_10[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account1[0].C2_10[0]').uncheck();
            }

            if(tener_seccion5_cuenta_enlinea1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account1[0].C2_11[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account1[0].C2_11[0]').uncheck();
            }

            if(tener_seccion5_tarjeta_valor_almacenado1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account1[0].C2_12[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account1[0].C2_12[0]').uncheck();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account1[0].Bank_Name[0]').setText(tener_seccion5_nombre_banco_ubicacion_pais1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account1[0].Account_Number[0]').setText(tener_seccion5_numero_cuenta1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account1[0].Total_Account[0]').setText(tener_seccion5_resultado_8a || "N/A");
 

            if(tener_seccion5_dinero2 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account2[0].C2_07[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account2[0].C2_07[0]').uncheck();
            }

            if(tener_seccion5_cheque2 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account2[0].C2_08[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account2[0].C2_08[0]').uncheck();
            }

            if(tener_seccion5_ahorros2 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account2[0].C2_09[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account2[0].C2_09[0]').uncheck();
            }

            if(tener_seccion5_CD2 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account2[0].C2_10[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account2[0].C2_10[0]').uncheck();
            }

            if(tener_seccion5_cuenta_enlinea2 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account2[0].C2_11[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account2[0].C2_11[0]').uncheck();
            }

            if(tener_seccion5_tarjeta_valor_almacenado2 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account2[0].C2_12[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account2[0].C2_12[0]').uncheck();
            }
 

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account2[0].Bank_Name[0]').setText(tener_seccion5_nombre_banco_ubicacion_pais2 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account2[0].Account_Number[0]').setText(tener_seccion5_numero_cuenta2 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].Account2[0].Total_Account[0]').setText(tener_seccion5_resultado_8b || "N/A");

 
            if(tener_seccion5_activo_digital1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].RetirementAcct1[0].virtualCurrency[0].virtualCurrency[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].RetirementAcct1[0].virtualCurrency[0].virtualCurrency[0]').uncheck();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].RetirementAcct1[0].virtualCurrency[0].descriptionDigitalAsset[0]').setText(tener_seccion5_descripcion_activo_digital1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].RetirementAcct1[0].numberOfUnits[0]').setText(tener_seccion5_numero_unidades1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].RetirementAcct1[0].locationDigitalAsset[0]').setText(tener_seccion5_ubicacion_activo_digital1 || "N/A");
           
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].RetirementAcct1[0].assetsAccountNumber[0]').setText(tener_seccion5_numero_cuenta_activo1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].RetirementAcct1[0].name_of_individual[0]').setText(tener_seccion5_direccion_activo_digitales1 || "N/A");
           
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].RetirementAcct1[0].dollarEquivalentToday[0].digitalAssetToday[0]').setText(tener_seccion5_activo_digital_equivalente_dolares1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].RetirementAcct1[0].TotalCurrentMarketValue[0]').setText(tener_seccion5_activo_equivalente_dolar_8c || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].TotalAccounts[0].Total_Accounts_Attached[0]').setText(tener_seccion5_total_cuentas_bancarias_8d || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page4[0].Section5[0].TotalAccounts[0].Total_Value_Bank_Accounts[0]').setText(tener_seccion5_resultado_8a_8d || "N/A");


            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].Asset1[0].Description_Asset[0]').setText(tener_seccion5_descripcion_activos1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].Asset1[0].CurrentMarket[0].Current_Market_Value[0]').setText(tener_seccion5_valor_mercado_actual1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].Asset1[0].CurrentMarket[0].Times_8[0]').setText(tener_seccion5_valor_mercado_actual_resultado1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].Asset1[0].LessLoan[0].Less_Loan_Balance[0]').setText(tener_seccion5_saldo_negativo_prestados1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].Asset1[0].Total_Value[0]').setText(tener_seccion5_resultado_9a || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].Asset2[0].Description_Asset[0]').setText(tener_seccion5_descripcion_activos2 || "N/A");
 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].Asset2[0].CurrentMarket[0].Current_Market_Value[0]').setText(tener_seccion5_valor_mercado_actual2 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].Asset2[0].CurrentMarket[0].Times_8[0]').setText(tener_seccion5_valor_mercado_actual_resultado2 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].Asset2[0].LessLoan[0].Less_Loan_Balance[0]').setText(tener_seccion5_saldo_negativo_prestados2 || "N/A");
           
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].Asset2[0].Total_Value[0]').setText(tener_seccion5_resultado_9b || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].TotalValue[0].Total_Value_Assets_Attached[0]').setText(tener_seccion3_total_cuentas_inversiones_9c || "N/A");
           
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].TotalValue[0].Total_Value_Assets[0]').setText(tener_seccion5_resultado_9a_9c || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].TotalValue[0].Line10[0]').setText(tener_seccion5_resultado_IRS || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].TotalValue[0].Total_Assets_Less_Deduction[0]').setText(tener_seccion5_resultado_9a_9c_menos_IRS || "N/A");
 

            if(tener_seccion5_nota_cobrar1_opcion == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].CB5_01[0]').check();
            }

            if(tener_seccion5_nota_cobrar1_opcion == "No")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].CB5_02[0]').check();
            }

            if(tener_seccion5_tiene_cobrar1_opcional == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].CB5_03[0]').check();
            }

            if(tener_seccion5_tiene_cobrar1_opcional == "No")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].CB5_04[0]').check();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section5[0].Available_Business_Equity_in_Assets[0]').setText(tener_seccion5_cuadro_b || "N/A");

            //SECCION 6
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].PeriodProvidedBegining[0]').setText(tener_seccion6_periodo_previsto || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Through[0]').setText(tener_seccion6_atraves_de || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Gross_Receipts[0]').setText(tener_seccion6_ingreso_bruto1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Gross_Rental_Income[0]').setText(tener_seccion6_ingreso_bruto_alquiler1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Interest_Income[0]').setText(tener_seccion6_ingreso_por_inteneres1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Dividend_Income[0]').setText(tener_seccion6_dividiendos1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Other_Income[0]').setText(tener_seccion6_otros_ingresos1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Total_Business_Income[0]').setText(tener_seccion6_total_ingresos_bruto_otros_ingresos1 || "N/A");
 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Materials_Purchased[0]').setText(tener_seccion6_materiales_adquiridos1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Inventory_Purchased[0]').setText(tener_seccion6_inventario_comprado1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Gross_Wages_Salaries[0]').setText(tener_seccion6_salario_sueldo_bruto1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Rent[0]').setText(tener_seccion6_alquiler1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Supplies[0]').setText(tener_seccion6_suministro1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Utilities_Telephones[0]').setText(tener_seccion6_servicios_publicos1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Vehicle_Costs[0]').setText(tener_seccion6_costo_vehiculo1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Business_Insurance[0]').setText(tener_seccion6_seguro_negocio1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Current_Business_Taxes[0]').setText(tener_seccion6_impuesto_comerciales_actuales1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Other_Secured_Debts[0]').setText(tener_seccion6_deudas_garantizadas1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Other_Business_Expenses[0]').setText(tener_seccion6_otros_gastos_comerciales1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Total_Business_Expenses[0]').setText(tener_seccion6_material_adquirido_otros_gastos_empresariales1 || "N/A");
 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page5[0].Section6[0].Net_Business_Income[0]').setText(tener_seccion6_cuadro_c || "N/A");

            //SECCION 7

 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Primary[0].Wages[0].Primary_Taxpayer_Wages[0]').setText(tener_seccion7_salario_bruto1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Primary[0].Social[0].Primary_Taxpayer_Social_Security[0]').setText(tener_seccion7_seguro_social1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Primary[0].Pensions[0].Primary_Taxpayer_Pensions[0]').setText(tener_seccion7_pension1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Primary[0].Other[0].Primary_Taxpayer_Other_Income[0]').setText(tener_seccion7_otros_ingresos1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Primary[0].Total_Primary_Taxpayer_Income[0]').setText(tener_seccion7_ingreso_totales_contribuyente_principal1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].SpouseOther[0].Wages[0].Spouse_Other_Wages[0]').setText(tener_seccion7_salario_bruto2 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].SpouseOther[0].Social[0].Spouse_Other_Social_Security[0]').setText(tener_seccion7_seguro_social2 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].SpouseOther[0].Pensions[0].Spouse_Other_Pensions[0]').setText(tener_seccion7_pension2 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].SpouseOther[0].Other[0].Spouse_Other_Other_Income[0]').setText(tener_seccion7_otros_ingresos2 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].SpouseOther[0].Total_Spouse_Other_Income[0]').setText(tener_seccion7_ingreso_totales_contribuyente_principal2 || "N/A");
             

            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Interest_Dividends[0]').setText(tener_seccion7_precio_fuente_adicionales_ingreso1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Interest_Dividends[1]').setText(tener_seccion7_intereses1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].tab_order[1].Interest_Dividends[0]').setText(tener_seccion7_fuente_adicionales_ingreso1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Distributions[0]').setText(tener_seccion7_distribuciones1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Net_Rental_Income[0]').setText(tener_seccion7_ingreso_neto_alquiler1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Net_Business_Income_BoxC[0]').setText(tener_seccion7_ingreso_comercial_neto1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Child_Support_Received[0]').setText(tener_seccion7_manutenciol_infantil_recibida1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Alimony_Received[0]').setText(tener_seccion7_pension_alimenticia_recibida1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Total_Household_Income[0]').setText(tener_seccion7_cuadro_d || "N/A");
 

            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Food_Clothing_Misc[0]').setText(tener_seccion7_alimentos_ropa_articulos_varios1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].tab_order[0].MonthlyRentPayment[0]').setText(tener_seccion7_vivienda_servicios_publicos1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Housing_Utilities[0]').setText(tener_seccion7_precio_vivienda_servicios_publicos1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Vehicle_Loan_Lease_Payments[0]').setText(tener_seccion7_pago_prestamo1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Vehicle_Operating_Costs[0]').setText(tener_seccion7_costo_operativo_vehiculo1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Public_Transportation_Costs[0]').setText(tener_seccion7_costo_trasporte_publico1 || "N/A");
           
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Health_Insurance_Premiums[0]').setText(tener_seccion7_prima_seguro_salud1 || "N/A");
           
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Out_Of_Pocket_Health_Care_Costs[0]').setText(tener_seccion7_costo_atencion_medica_bolsillo1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Court_Ordered_Payments[0]').setText(tener_seccion7_pago_ordenado_tribunal1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Child_Dependent_Care_Expenses[0]').setText(tener_seccion7_pago_cuidado_ninos1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].LifeIns[0].Line_Insureance_Policy[0]').setText(tener_seccion7_monto_poliza_seguro_vida1 || "N/A");
           
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Life_Insurance_Premiums[0]').setText(tener_seccion7_monto_poliza_seguro_vida_primas1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Current_Taxes[0]').setText(tener_seccion7_impuestos_mensuales_actuales1 || "N/A");
 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Other_Secured_Debts[0]').setText(tener_seccion7_precio_deudas_gastos1 || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].tab_order[2].Interest_Dividends[0]').setText(tener_seccion7_deudas_gatos1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].total_tax_owed[0]').setText(tener_seccion7_pago_moroso_impuesto1 || "N/A");

            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Delinquent_State_Local_Taxes[0]').setText(tener_seccion7_pago_moroso_impuesto1 || "N/A");
            
            //SECCION 8
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Total_Household_Expenses[0]').setText(tener_seccion7_cuadro_e || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page6[0].Remaing_Monthly_Income[0]').setText(tener_seccion7_cuadro_f || "N/A");
 
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].BoxF1[0].Total_Box_F_1[0]').setText(tener_seccion8_caja_f_g || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].Box_G_Future_Remaining_Income[0]').setText(tener_seccion8_caja_g || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].BoxF2[0].Total_Box_F_2[0]').setText(tener_seccion8_caja_f_h || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].Box_H_Future_Remaining_Income[0]').setText(tener_seccion8_caja_h || "N/A");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].BoxAB[0].Box_A_Plus_Box_B[0]').setText(tener_seccion8_monto_caja_a_b || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].BoxGH[0].Box_G_or_Box_H[0]').setText(tener_seccion8_resultado_caja_g_h || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].Offer_Amount[0]').setText(tener_seccion8_monto_oferta1 || "N/A");

            //SECCION 9
 
            if(tener_seccion9_opcion_involucrado_litigio1 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].C5_09[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].C5_10[0]').check();
            }

            if(tener_seccion9_acusada1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].tab_order[0].CB3_06[0]').check();
            }

            if(tener_seccion9_demantante1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].tab_order[0].CB3_05[0]').check();           
            }

 

            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].Name_Creditor[0]').setText(tener_seccion9_lugar_presentacion1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].Date_Final_Payment[0]').setText(tener_seccion9_numero_caso1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].Name_Creditor[1]').setText(tener_seccion9_representado_por1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].Name_Creditor[2]').setText(tener_seccion9_fecha_finalizacion_posible1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].Name_Creditor[3]').setText(tener_seccion9_objeto_litigio1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].tab_order[1].Gross_Receipts[0]').setText(tener_seccion9_cantidad_disputa1 || "N/A");
 
 
            if(tener_seccion9_pregunta_estado_quiebra1 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].c1_7_[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].c1_7_[1]').check();
            }

            if(isEmpty(tener_seccion9_campo_fecha1) == false)
            {
               let [año, mes, dia] = tener_seccion9_campo_fecha1.split('-');
               
               //let a = "2024-12-11"
               let concatenacion = mes + "" + dia + "" + año;

               form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1_t37_7[0]').setText(concatenacion || "");
            }else{
               form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1_t37_7[0]').setText("N/A");
            }

            if(isEmpty(tener_seccion9_fecha_despido1) == false)
            {
               let [año, mes, dia] = tener_seccion9_fecha_despido1.split('-');
               
               //let a = "2024-12-11"
               let concatenacion = mes + "" + dia + "" + año;

               form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1_t38_7[0]').setText(concatenacion || "");

            }else{
               form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1_t38_7[0]').setText("N/A");
            }

            if(isEmpty(tener_seccion9_fecha_alta1) == false)
            {
               let [año, mes, dia] = tener_seccion9_fecha_alta1.split('-');
               
               //let a = "2024-12-11"
               let concatenacion = mes + "" + dia + "" + año;

               form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1_t38_7[1]').setText(concatenacion || "");
            }else{
               form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1_t38_7[1]').setText("N/A");
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1_t39_7[0]').setText(tener_seccion9_numero_peticion1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1_t40_7[0]').setText(tener_seccion9_ubicacion_archivada1 || "N/A");
 

            if(tener_seccion9_pregunta_vivido_fuera_EEUU_6_meses1 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].c1_8_[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].c1_8_[1]').check();
            }
 
            if(isEmpty(tener_seccion9_fecha_vivida_extranjero_desde1) == false)
            {
               let [año, mes, dia] = tener_seccion9_fecha_vivida_extranjero_desde1.split('-');
               
               //let a = "2024-12-11"
               let concatenacion = mes + "" + dia + "" + año;

               form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p2_t50_8[0]').setText(concatenacion || "");
            }else{
               form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p2_t50_8[0]').setText("N/A");
            }

            if(isEmpty(tener_seccion9_fecha_vivida_extranjero_hasta1) == false)
            {
               let [año, mes, dia] = tener_seccion9_fecha_vivida_extranjero_hasta1.split('-');
               
               //let a = "2024-12-11"
               let concatenacion = mes + "" + dia + "" + año;

               form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p2_t51_8[0]').setText(concatenacion || "");
            }else{
               form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p2_t51_8[0]').setText("N/A");
            }

            if(tener_seccion9_pregunta_formo_parte_algun_litigio_EEUU1 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].#subform[6].CB7_07[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].#subform[6].CB7_08[0]').check();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].#subform[6].Date_Lawsuit_Resolved[0]').setText(tener_seccion9_he_cometido_algun_litigio_EEUU1 || "N/A");
 
            if(tener_seccion9_pregunta_beneficiario_algun_fideicomiso1 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].c1_9a_[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].c1_9a_[1]').check();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1_t44_9[0]').setText(tener_seccion9_lugar_donde_se_grabo1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1-t45_9[0]').setText(tener_seccion9_EIN1 || "");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1-t46_9[0]').setText(tener_seccion9_EIN2 || "");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].#subform[7].p1-t48_9[0]').setText(tener_seccion9_monto_previsto_recibir1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1-t49_9[0]').setText(tener_seccion9_recibir_importe1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1-t47_9[0]').setText(tener_seccion9_nombre_fideicomiso1 || "N/A");

            if(tener_seccion9_pregunta_es_fiduciario1 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].c1_9b_[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].c1_9b_[1]').check();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1-t02_9b[0]').setText(tener_seccion9_fiduciario_EIN1 || "");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1-t02_9b[0]').setText(tener_seccion9_fiduciario_EIN1 || "");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1-t01_9b[0]').setText(tener_seccion9_fiduciario_EIN2 || "");
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p2_t00_9b[0]').setText(tener_seccion9_nombre_fideicomiso2 || "N/A");

            if(tener_seccion9_pregunta_tener_caja_seguridad1 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].c1_10_[0]').check();
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page7[0].c1_10_[1]').check();
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1_t41_10[0]').setText(tener_seccion9_ubicacion1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1-t43_10[0]').setText(tener_seccion9_contenido1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page7[0].p1-t42_10[0]').setText(tener_seccion9_valor1 || "N/A");
             

            //topmostSubform[0].F433-A-OIC_Page8[0].past_10_years[0].c1_11_[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].past_10_years[0].c1_11_[1]
            //topmostSubform[0].F433-A-OIC_Page8[0].past_10_years[0].p3_t1_11[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].past_10_years[0].#subform[0].p3_t2_11[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].past_10_years[0].p3_t3_11[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].past_10_years[0].p3_t4_11[0]

            //"tener_seccion9_pregunta_transferencia_activo1": "Yes",
            //"tener_seccion9_lista_activos1": "12312 x1",
            //"tener_seccion9_valor_momento_transferencia1": "11114",
            //"tener_seccion9_fecha_transferencia1": "2024-12-01",
            //"tener_seccion9_quien_transfirio1": "Yes x1",

            if(tener_seccion9_pregunta_transferencia_activo1 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].past_10_years[0].c1_11_[0]').check();              
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].past_10_years[0].c1_11_[1]').check();              
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page8[0].past_10_years[0].p3_t1_11[0]').setText(tener_seccion9_lista_activos1 || "N/A");
            
            if(isEmpty(tener_seccion9_fecha_transferencia1) == false)
            {
               let [año, mes, dia] = tener_seccion9_fecha_transferencia1.split('-');
               
               //let a = "2024-12-11"
               let concatenacion = mes + "" + dia + "" + año;

               form.getTextField('topmostSubform[0].F433-A-OIC_Page8[0].past_10_years[0].p3_t3_11[0]').setText(concatenacion || "");
            }else{
               form.getTextField('topmostSubform[0].F433-A-OIC_Page8[0].past_10_years[0].p3_t3_11[0]').setText("N/A");
            }
            
            form.getTextField('topmostSubform[0].F433-A-OIC_Page8[0].past_10_years[0].#subform[0].p3_t2_11[0]').setText(tener_seccion9_valor_momento_transferencia1 || "N/A");
             
            form.getTextField('topmostSubform[0].F433-A-OIC_Page8[0].past_10_years[0].p3_t4_11[0]').setText(tener_seccion9_quien_transfirio1 || "N/A");
 

            if(tener_seccion9_pregunta_tiene_algun_activo1 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].do_you[0].CB7_yes[0]').check();              
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].do_you[0].CB7_no[0]').check();              
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page8[0].do_you[0].ifyes[0]').setText(tener_seccion9_descripcion_activos1 || "N/A");

            form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].any_funds[0].CB7_13[0]').check(); 
 

            if(tener_seccion9_pregunta_fondo_retenido_fideicomiso1 == "Yes")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].any_funds[0].CB7_13[0]').check(); 
            }else{
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].any_funds[0].CB7_14[0]').check(); 
            }

            form.getTextField('topmostSubform[0].F433-A-OIC_Page8[0].any_funds[0].Funds_Held_Trust[0]').setText(tener_seccion9_cuando_fondos_retenidos_fideicomiso1 || "N/A");
            form.getTextField('topmostSubform[0].F433-A-OIC_Page8[0].any_funds[0].Where_Funds_Held_Trust[0]').setText(tener_seccion9_donde_fondos_retenidos_fideicomiso1 || "N/A");

            //SECCION 10
 
            if(isEmpty(tener_seccion10_fecha_contribuyente) == false)
            {
               let [año, mes, dia] = tener_seccion10_fecha_contribuyente.split('-');
               
               //let a = "2024-12-11"
               let concatenacion = mes + "/" + dia + "/" + año;

               form.getTextField('topmostSubform[0].F433-A-OIC_Page8[0].Date_Signed_1[0]').setText(concatenacion || "");
            }else{
               form.getTextField('topmostSubform[0].F433-A-OIC_Page8[0].Date_Signed_1[0]').setText("N/A");
            }

            if(isEmpty(tener_seccion10_fecha_conyugue) == false)
            {
               let [año, mes, dia] = tener_seccion10_fecha_conyugue.split('-');
               
               //let a = "2024-12-11"
               let concatenacion = mes + "/" + dia + "/" + año;

               form.getTextField('topmostSubform[0].F433-A-OIC_Page8[0].Date_Signed_2[0]').setText(concatenacion || "");
            }else{
               form.getTextField('topmostSubform[0].F433-A-OIC_Page8[0].Date_Signed_2[0]').setText("N/A");
            }
 
            if(tener_seccion10_opcion1 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].CB8_01[0]').check(); 
            }

            if(tener_seccion10_opcion2 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].CB8_02[0]').check(); 
            }

            if(tener_seccion10_opcion3 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].CB8_03[0]').check(); 
            }

            if(tener_seccion10_opcion4 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].CB8_04[0]').check(); 
            }

            if(tener_seccion10_opcion5 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].CB8_CompleteForm433b[0]').check(); 
            }

            if(tener_seccion10_opcion6 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].CB8_05[0]').check(); 
            }

            if(tener_seccion10_opcion6 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].CB8_05[0]').check(); 
            }

            if(tener_seccion10_opcion7 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].CB8_06[0]').check(); 
            }

            if(tener_seccion10_opcion8 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].CB8_07[0]').check(); 
            }

            if(tener_seccion10_opcion9 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].CopiesOfTrust[0]').check(); 
            }

            if(tener_seccion10_opcion10 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].CopiesOfCourt[0]').check(); 
            }

            if(tener_seccion10_opcion10 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].CB8_08[0]').check(); 
            }

            if(tener_seccion10_opcion12 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].CB8_09[0]').check(); 
            }

            if(tener_seccion10_opcion13 == "1")
            {
               form.getCheckBox('topmostSubform[0].F433-A-OIC_Page8[0].CB8_08[1]').check(); 
            }
 

            //topmostSubform[0].F433-A-OIC_Page8[0].CB8_01[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].CB8_02[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].CB8_03[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].CB8_04[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].CB8_CompleteForm433b[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].CB8_05[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].CB8_06[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].CB8_07[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].CopiesOfCourt[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].CopiesOfTrust[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].CB8_08[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].CB8_09[0]
            //topmostSubform[0].F433-A-OIC_Page8[0].CB8_08[1]

            //"tener_seccion10_opcion1": "1",
            //"tener_seccion10_opcion2": "1",
            //"tener_seccion10_opcion3": "1",
            //"tener_seccion10_opcion4": "1",
            //"tener_seccion10_opcion5": "1",
            //"tener_seccion10_opcion6": "1",
            //"tener_seccion10_opcion7": "1",
            //"tener_seccion10_opcion8": "1",
            //"tener_seccion10_opcion9": "1",
            //"tener_seccion10_opcion10": "1",
            //"tener_seccion10_opcion11": "1",
            //"tener_seccion10_opcion12": "1",
            //"tener_seccion10_opcion13": "1",

 
 

            // Itera sobre los campos y obtén sus nombres
            fields.forEach((field) => {
               console.log(field.getName());
            });

            // Obtén la primera página

            /*
            const pages = pdfDoc.getPages();
            const firstPage = pages[0];
            const { width, height } = firstPage.getSize();

            // Dibuja texto en la primera página
            firstPage.drawText('This text was added with JavaScript!', {
               x: 5,
               y: height / 2 + 300,
               size: 50,
               font: helveticaFont,
               color: PDFLib.rgb(0.95, 0.1, 0.1),
               rotate: PDFLib.degrees(-45),
            });
            */

            // Guarda el PDF actualizado
            const pdfBytes = await pdfDoc.save();

            // Descarga el PDF modificado
            const blob = new Blob([pdfBytes], { type: 'application/pdf' });
            const link = document.createElement('a');
            link.href = URL.createObjectURL(blob);
            link.download = 'forms 433A.pdf';
            link.click();
         }


          async function   crear_pdf_656(data){
              let {
               herramientas_llenado='',
               tipo_negocio_personal='',
               seccion1_nombre_completo='',
               seccion1_numero_ssn1='',
               seccion1_numero_ssn2='',
               seccion1_numero_ssn3='',
               seccion1_nombre_completo_conjugue='',
               seccion1_numero_ssn1_conjugue='',
               seccion1_numero_ssn2_conjugue='',
               seccion1_numero_ssn3_conjugue='',
               seccion1_direccion_fiscal_domicilio='',
               seccion1_direccion_postal_domicilio='',
               seccion1_confirmacion_nueva_direccion='',
               seccion1_confirmacion_actualizar_direccion='',
               seccion1_numero_identificacion_empleador1='',
               seccion1_numero_identificacion_empleador2='',
               seccion1_pii_opcion1='',
               seccion1_pii_opcion1_opcional='',
               seccion1_pii_opcion2='',
               seccion1_pii_opcion2_opcional='',
               seccion1_pii_opcion3='',
               seccion1_pii_opcion3_opcional='',
               seccion1_pii_opcion4='',
               seccion1_pii_opcion4_opcional='',
               seccion1_pii_opcion5='',
               seccion1_pii_opcion5_opcional='',
               seccion1_pii_opcion6='',
               seccion1_certificacion_bajo_ingresos1='',
               seccion1_certificacion_bajo_ingresos2='',
               seccion2_nombre_negocio='',
               seccion2_direccion_fiscal_empresa='',
               seccion2_direccion_postal_empresa='',
               seccion2_numero_identificacion_empleador1='',
               seccion2_numero_identificacion_empleador2='',
               seccion2_nombre_titulo_contacto_primario='',
               seccion2_numero_telefono1='',
               seccion2_numero_telefono2='',
               seccion2_numero_telefono3='',
               seccion2_pii_opcion1='',
               seccion2_pii_opcion1_opcional='',
               seccion2_pii_opcion2='',
               seccion2_pii_opcion2_opcional='',
               seccion2_pii_opcion3='',
               seccion2_pii_opcion3_opcional='',
               seccion2_pii_opcion4='',
               seccion2_pii_opcion4_opcional='',
               seccion2_pii_opcion5='',
               seccion3_motivo_oferta1='',
               seccion3_motivo_oferta2='',
               seccion3_motivo_oferta3='',
               seccion4_condicion_pago='',
               seccion2_monto_total='',
               seccion2_pago_inicial='',
               seccion2_saldo_restante='',
               seccion4_monto_pago1='',
               seccion4_monto_pago2='',
               seccion4_monto_pago3='',
               seccion4_monto_pago4='',
               seccion4_monto_pago5='',
               seccion2_monto_total_pago_periodico='',
               seccion2_pago_periodico1='',
               seccion2_pago_periodico2='',
               seccion2_pago_periodico3='',
               seccion2_pago_periodico4='',
               seccion2_pago_periodico5='',
               seccion2_pago_periodico6='',
               seccion2_pago_periodico7='',
               seccion5_periodo_impositivo='',
               seccion5_tarifa_solicitud_ofertas='',
               seccion5_fecha_tarifa_solicitud_ofertas='',
               seccion5_transferencia_electronica_tarifa_solicitud_ofertas='',
               seccion5_pago_oferta='',
               seccion5_fecha_pago_oferta='',
               seccion5_transferencia_electronica_pago_oferta='',
               seccion6_descripcion_origen_fondo='',
               seccion6_campo1_requisitos='',
               seccion6_campo2_requisitos='',
               seccion6_campo2_requisitos_opcional='',
               seccion6_campo1_requisitos_pago='',
               seccion6_campo2_requisitos_pago='',
               seccion6_campo3_requisitos_pago='',
               seccion6_campo4_requisitos_pago='',
               seccion8_telefono_nombre_corporativo='',
               seccion8_fecha_nombre_corporativo='',
               seccion8_check_nombre_corporativo='',
               seccion8_telefono_firma_conyugue='',
               seccion8_fecha_firma_conyugue='',
               seccion8_check_firma_conyugue='',
               seccion9_telefono_firma_preparadora='',
               seccion9_fecha_firma_preparadora='',
               seccion9_check_firma_preparadora='',
               seccion9_nombre_preparadora_pagada='',
               seccion9_numero_CAF_preparadora='',
               seccion9_nombre_empresa_preparadora='',
               seccion9_titulo_preparadora='',
               seccion9_fecha_preparadora='',
               fecha_post='',
               fecha_update='',
               seccion8_firma_contribuyente='',
               seccion8_firma_conyugue='',
               seccion9_nombre_firma_preparadora=''
            } = data;

            // URL del PDF existente
            const url = 'https://pdf-lib.js.org/assets/with_update_sections.pdf';

            // Carga el archivo PDF
            const response = await fetch(tener_url_formulario_656);
            const existingPdfBytes = await response.arrayBuffer();

            // Crea un documento PDF con pdf-lib
            const pdfDoc = await PDFLib.PDFDocument.load(existingPdfBytes);

            // Embebe una fuente
            const helveticaFont = await pdfDoc.embedFont(PDFLib.StandardFonts.Helvetica);

            // Get the form containing all the fields
            const form = pdfDoc.getForm()

            // Obtén todos los campos del formulario
            const fields = form.getFields();

            console.log(data);

            //Did you use the Pre-Qualifier Yes / No
            if(herramientas_llenado=="No"){
               form.getCheckBox('topmostSubform[0].F656_Page1[0].cB1_01[0]').check();
               form.getCheckBox('topmostSubform[0].F656_Page1[0].cB1_02[0]').uncheck();
            }else{
               form.getCheckBox('topmostSubform[0].F656_Page1[0].cB1_01[0]').check();
            }

            //Section 1
            form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].Your_First_Middle_Last_Name[0]').setText(seccion1_nombre_completo || "N/A");
            form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].YourSSN[0].Your_SSN_1[0]').setText(seccion1_numero_ssn1 || "");
            form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].YourSSN[0].Your_SSN_2[0]').setText(seccion1_numero_ssn2 || "");
            form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].YourSSN[0].Your_SSN_3[0]').setText(seccion1_numero_ssn3 || "");
            form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].Spouse_First_Middle_Last_Name[0]').setText(seccion1_nombre_completo_conjugue || "N/A");
            form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].SpouseSSN[0].Spouse_SSN_1[0]').setText(seccion1_numero_ssn1_conjugue || "");
            form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].SpouseSSN[0].Spouse_SSN_2[0]').setText(seccion1_numero_ssn2_conjugue || "");
            form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].SpouseSSN[0].Spouse_SSN_3[0]').setText(seccion1_numero_ssn3_conjugue || "");
            form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].Your_Home_Address[0]').setText(seccion1_direccion_fiscal_domicilio || "N/A");
            form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].Your_Mailing_Address[0]').setText(seccion1_direccion_postal_domicilio || "N/A");
            
            if(seccion1_confirmacion_nueva_direccion=="Yes"){
               form.getCheckBox('topmostSubform[0].F656_Page1[0].#subform[1].yes[0]').check();
               form.getCheckBox('topmostSubform[0].F656_Page1[0].#subform[1].no[0]').uncheck();
            }else{
               form.getCheckBox('topmostSubform[0].F656_Page1[0].#subform[1].yes[0]').uncheck();
               form.getCheckBox('topmostSubform[0].F656_Page1[0].#subform[1].no[0]').check();
            }
            if(seccion1_confirmacion_actualizar_direccion=="Yes"){
               form.getCheckBox('topmostSubform[0].F656_Page1[0].#subform[1].yes2[0]').check();
               form.getCheckBox('topmostSubform[0].F656_Page1[0].#subform[1].no2[0]').uncheck();
            }else{
               form.getCheckBox('topmostSubform[0].F656_Page1[0].#subform[1].yes2[0]').uncheck();
               form.getCheckBox('topmostSubform[0].F656_Page1[0].#subform[1].no2[0]').check();
            }

            form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].EIN_1[0]').setText(seccion1_numero_identificacion_empleador1 || "");
            form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].EIN_2[0]').setText(seccion1_numero_identificacion_empleador2 || "N/A");


            //Section 1 - Individual Tax Periods
            

            if(seccion1_pii_opcion1==1){
               form.getCheckBox('topmostSubform[0].F656_Page1[0].#subform[1].cB_03[0]').check();
               form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1]._1040_Income_Tax_Years[0]').setText();
               form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1]._1040_Income_Tax_Years_2[0]').setText(seccion1_pii_opcion1_opcional || "N/A");
            }else{
               form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1]._1040_Income_Tax_Years_2[0]').setText(seccion1_pii_opcion1_opcional || "N/A");
            }
            
            
            if(seccion1_pii_opcion2==1){
               form.getCheckBox('topmostSubform[0].F656_Page1[0].#subform[1].#subform[4].cB_07[0]').check();
               form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].#subform[4].Trust_Fund_Recovery_Penalty_Corp_Name[0]').setText();
               form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].#subform[4].Trust_Fund_Recovery_Penalty_Period_Ending_1[0]').setText(seccion1_pii_opcion2_opcional || "N/A");
            }else{
               form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].#subform[4].Trust_Fund_Recovery_Penalty_Period_Ending_1[0]').setText(seccion1_pii_opcion2_opcional || "N/A");
            }
            
            if(seccion1_pii_opcion3==1){
               form.getCheckBox('topmostSubform[0].F656_Page1[0].#subform[1].#subform[4].cB_05[0]').check();
               form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].#subform[4]._941_Quarterly_Periods_1[0]').setText();
               form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].#subform[4]._941_Quarterly_Periods_2[0]').setText(seccion1_pii_opcion3_opcional || "N/A");
            }else{
               form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].#subform[4]._941_Quarterly_Periods_2[0]').setText(seccion1_pii_opcion3_opcional || "N/A");
            }

            if(seccion1_pii_opcion4==1){
               form.getCheckBox('topmostSubform[0].F656_Page1[0].#subform[1].#subform[4].cB_06[0]').check();
               form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].#subform[4]._940_Years_1[0]').setText();
               form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].#subform[4]._940_Years_2[0]').setText(seccion1_pii_opcion4_opcional || "N/A");
            }else{
               form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].#subform[4]._940_Years_2[0]').setText(seccion1_pii_opcion4_opcional || "N/A");
            }

            if(seccion1_pii_opcion5==1){
               form.getCheckBox('topmostSubform[0].F656_Page1[0].#subform[1].#subform[4].cB_08[0]').check();
               form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].#subform[4].Other_Federal_Taxes_1[0]').setText(seccion1_pii_opcion5_opcional || "N/A");   
            }else{
               form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].#subform[4].Other_Federal_Taxes_1[0]').setText(seccion1_pii_opcion5_opcional || "N/A");   
            }

            form.getTextField('topmostSubform[0].F656_Page1[0].#subform[1].Attachment_Date[0]').setText(seccion1_pii_opcion6 || "N/A");   

            //Low-Income Certification (Individuals and Sole Proprietors Only)
            if(seccion1_certificacion_bajo_ingresos1==1){
               form.getCheckBox('topmostSubform[0].F656_Page2[0].qualify_for[0].cB2_07[0]').check();
            }
            if(seccion1_certificacion_bajo_ingresos2==1){
               form.getCheckBox('topmostSubform[0].F656_Page2[0].qualify_for[0].cB2_07[0]').check();
            }

            //Section 2 -  Business Information (Form 1120, 1065, etc., filers)
            form.getTextField('topmostSubform[0].F656_Page2[0].Business_Name[0]').setText(seccion2_nombre_negocio || "N/A");
            form.getTextField('topmostSubform[0].F656_Page2[0].Business_Address[0]').setText(seccion2_direccion_fiscal_empresa || "N/A");
            form.getTextField('topmostSubform[0].F656_Page2[0].Business_Address[1]').setText(seccion2_direccion_postal_empresa || "N/A");
            form.getTextField('topmostSubform[0].F656_Page2[0].BusinessEIN[0].Business_EIN_1[0]').setText(seccion2_numero_identificacion_empleador1 || "");
            form.getTextField('topmostSubform[0].F656_Page2[0].BusinessEIN[0].Business_EIN_2[0]').setText(seccion2_numero_identificacion_empleador2 || "N/A");
            form.getTextField('topmostSubform[0].F656_Page2[0].Name_Title_Primary_Contact[0]').setText(seccion2_nombre_titulo_contacto_primario || "N/A");
            form.getTextField('topmostSubform[0].F656_Page2[0].Phone[0].Area_Code[0]').setText(seccion2_numero_telefono1 || "N/A");
            form.getTextField('topmostSubform[0].F656_Page2[0].Phone[0].Phone1[0]').setText(seccion2_numero_telefono2 || "N/A");
            form.getTextField('topmostSubform[0].F656_Page2[0].Phone[0].Phone2[0]').setText(seccion2_numero_telefono3 || "N/A");


            //section2 - Business Tax Periods (If Your Offer is for Business Tax Debt Only) List all years/periods owed
            if(seccion2_pii_opcion1=='1'){
               form.getCheckBox('topmostSubform[0].F656_Page2[0].cB2_01[0]').check();
               form.getTextField('topmostSubform[0].F656_Page2[0]._1120_Income_Tax_Years[0]').setText(seccion2_pii_opcion1_opcional || "N/A");
            }else{
               form.getTextField('topmostSubform[0].F656_Page2[0]._1120_Income_Tax_Years[0]').setText(seccion2_pii_opcion1_opcional || "N/A");
            }

            if(seccion2_pii_opcion2=='1'){
               form.getCheckBox('topmostSubform[0].F656_Page2[0].cB2_02[0]').check();
               form.getTextField('topmostSubform[0].F656_Page2[0]._941_Quarterly_Periods_2[0]').setText(seccion2_pii_opcion2_opcional || "N/A");
               form.getTextField('topmostSubform[0].F656_Page2[0]._941_Quarterly_Periods_1[0]').setText();
            }else{
               form.getTextField('topmostSubform[0].F656_Page2[0]._941_Quarterly_Periods_2[0]').setText(seccion2_pii_opcion2_opcional || "N/A");
            }

            if(seccion2_pii_opcion3=='1'){
               form.getCheckBox('topmostSubform[0].F656_Page2[0].cB2_03[0]').check();
               form.getTextField('topmostSubform[0].F656_Page2[0]._940_Years_2[0]').setText(seccion2_pii_opcion3_opcional || "N/A");
               form.getTextField('topmostSubform[0].F656_Page2[0]._940_Years_1[0]').setText();   
            }else{
               form.getTextField('topmostSubform[0].F656_Page2[0]._940_Years_2[0]').setText(seccion2_pii_opcion3_opcional || "N/A");
            }
            

            if(seccion2_pii_opcion4=='1'){
               form.getCheckBox('topmostSubform[0].F656_Page2[0].cB2_04[0]').check();
               form.getTextField('topmostSubform[0].F656_Page2[0].Other_Federal_Taxes_1[0]').setText();
               form.getTextField('topmostSubform[0].F656_Page2[0].Other_Federal_Taxes_2[0]').setText(seccion2_pii_opcion4_opcional || "N/A");   
            }else{
               form.getTextField('topmostSubform[0].F656_Page2[0].Other_Federal_Taxes_2[0]').setText(seccion2_pii_opcion4_opcional || "N/A");   
            }

            form.getTextField('topmostSubform[0].F656_Page2[0].Attachment_Date[0]').setText(seccion2_pii_opcion5 || "N/A");

            
            //Section 3 Reason for Offer
            if(seccion3_motivo_oferta1==1){
               form.getCheckBox('topmostSubform[0].F656_Page3[0].datc[0]').check();
            }
            if(seccion3_motivo_oferta2==1){
               form.getCheckBox('topmostSubform[0].F656_Page3[0].EconomicHardship[0]').check();
            }
            if(seccion3_motivo_oferta3==1){
               form.getCheckBox('topmostSubform[0].F656_Page3[0].publicPolicyEquity[0]').check();
            }


            //Section 4 Payment Terms Lump Sum
            if(seccion4_condicion_pago!='Periodic Payment'){
               form.getCheckBox('topmostSubform[0].F656_Page3[0].cB3_01[0]').check();

               form.getTextField('topmostSubform[0].F656_Page3[0].Table1[0].Row1[0].Total_Offer_Amount[0]').setText(seccion2_monto_total || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].Table1[0].Row1[0].Initial_Payment[0]').setText(seccion2_pago_inicial || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].Table1[0].Row1[0].Remaining_Balance[0]').setText(seccion2_saldo_restante || "N/A");
               
               form.getTextField('topmostSubform[0].F656_Page3[0].AmountOfPayments[0].Row1[0].Amount_Payment_1[0]').setText(seccion4_monto_pago1 || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].AmountOfPayments[0].Row2[0].Amount_Payment_2[0]').setText(seccion4_monto_pago2 || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].AmountOfPayments[0].Row3[0].Amount_Payment_3[0]').setText(seccion4_monto_pago3 || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].AmountOfPayments[0].Row4[0].Amount_Payment_4[0]').setText(seccion4_monto_pago4 || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].AmountOfPayments[0].Row5[0].Amount_Payment_5[0]').setText(seccion4_monto_pago5 || "N/A");

               //si una opcion no se aplica
               form.getTextField('topmostSubform[0].F656_Page3[0].Periodic_Payment_Amount_Of_Offer[0]').setText(seccion2_monto_total_pago_periodico || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].Installment_Payment_1[0]').setText(seccion2_pago_periodico1    || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].Installment_Payment_2[0]').setText(seccion2_pago_periodico2    || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].Installment_Payment_Day[0]').setText(seccion2_pago_periodico3  || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].Month[0]').setText(seccion2_pago_periodico4  || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].FinalPayment[0]').setText(seccion2_pago_periodico5  || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].ReceivedOn[0]').setText(seccion2_pago_periodico6 || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].FinalMonth[0]').setText(seccion2_pago_periodico7 || "N/A");

            }else{
               form.getCheckBox('topmostSubform[0].F656_Page3[0].cB3_02[0]').check();
               form.getTextField('topmostSubform[0].F656_Page3[0].Periodic_Payment_Amount_Of_Offer[0]').setText(seccion2_monto_total_pago_periodico || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].Installment_Payment_1[0]').setText(seccion2_pago_periodico1    || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].Installment_Payment_2[0]').setText(seccion2_pago_periodico2    || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].Installment_Payment_Day[0]').setText(seccion2_pago_periodico3  || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].Month[0]').setText(seccion2_pago_periodico4  || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].FinalPayment[0]').setText(seccion2_pago_periodico5  || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].ReceivedOn[0]').setText(seccion2_pago_periodico6 || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].FinalMonth[0]').setText(seccion2_pago_periodico7 || "N/A");

               //si la opcion de arriba no se aplicar
               form.getTextField('topmostSubform[0].F656_Page3[0].Table1[0].Row1[0].Total_Offer_Amount[0]').setText(seccion2_monto_total || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].Table1[0].Row1[0].Initial_Payment[0]').setText(seccion2_pago_inicial || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].Table1[0].Row1[0].Remaining_Balance[0]').setText(seccion2_saldo_restante || "N/A");
               
               form.getTextField('topmostSubform[0].F656_Page3[0].AmountOfPayments[0].Row1[0].Amount_Payment_1[0]').setText(seccion4_monto_pago1 || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].AmountOfPayments[0].Row2[0].Amount_Payment_2[0]').setText(seccion4_monto_pago2 || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].AmountOfPayments[0].Row3[0].Amount_Payment_3[0]').setText(seccion4_monto_pago3 || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].AmountOfPayments[0].Row4[0].Amount_Payment_4[0]').setText(seccion4_monto_pago4 || "N/A");
               form.getTextField('topmostSubform[0].F656_Page3[0].AmountOfPayments[0].Row5[0].Amount_Payment_5[0]').setText(seccion4_monto_pago5 || "N/A");
            }


            //Section 5 Designation of Payment and Electronic Federal Tax Payment System (EFTPS)
            form.getTextField('topmostSubform[0].F656_Page4[0].Tax_Year_Quarter[0]').setText(seccion5_periodo_impositivo || "N/A");
            form.getTextField('topmostSubform[0].F656_Page4[0].Business_Name[0]').setText(seccion5_tarifa_solicitud_ofertas || "N/A");//seccion5_tarifa_solicitud_ofertas
            form.getTextField('topmostSubform[0].F656_Page4[0].Business_Name[4]').setText(seccion5_fecha_tarifa_solicitud_ofertas || "N/A");//seccion5_fecha_pago_oferta
            form.getTextField('topmostSubform[0].F656_Page4[0].Business_Name[5]').setText(seccion5_transferencia_electronica_tarifa_solicitud_ofertas || "N/A");//seccion5_transferencia_electronica_tarifa_solicitud_ofertas 
            form.getTextField('topmostSubform[0].F656_Page4[0].Business_Name[3]').setText(seccion5_pago_oferta || "N/A");//seccion5_pago_oferta
            form.getTextField('topmostSubform[0].F656_Page4[0].Business_Name[2]').setText(seccion5_fecha_pago_oferta || "N/A");//seccion5_fecha_tarifa_solicitud_ofertas
            form.getTextField('topmostSubform[0].F656_Page4[0].Business_Name[1]').setText(seccion5_transferencia_electronica_pago_oferta || "N/A");//seccion5_transferencia_electronica_tarifa_solicitud_ofertas
            


            //Section 6 Source of Funds, Making Your Payment, Filing Requirements, and Tax Payment Requirements
            form.getTextField('topmostSubform[0].F656_Page4[0].section6[0].tell_us[0].Explanation_Of_Circumstances[0]').setText(seccion6_descripcion_origen_fondo || "N/A");
            if(seccion6_campo1_requisitos==1){
               form.getCheckBox('topmostSubform[0].F656_Page4[0].section6[0].cB4_01[0]').check();
            }

            if(seccion6_campo2_requisitos_pago==1){
               form.getCheckBox('topmostSubform[0].F656_Page4[0].section6[0].cB4_02[0]').check();
               form.getTextField('topmostSubform[0].F656_Page4[0].section6[0].Not_Required_To_File_Years[0]').setText(seccion6_campo2_requisitos_opcional || "N/A");
            }else{
               form.getTextField('topmostSubform[0].F656_Page4[0].section6[0].Not_Required_To_File_Years[0]').setText(seccion6_campo2_requisitos_opcional || "N/A");
            }

            if(seccion6_campo1_requisitos_pago==1){
               form.getCheckBox('topmostSubform[0].F656_Page4[0].section6[0].cB4_01[1]').check();
            }
            if(seccion6_campo2_requisitos_pago==1){
               form.getCheckBox('topmostSubform[0].F656_Page4[0].section6[0].cB4_01[2]').check();
            }
            if(seccion6_campo3_requisitos_pago==1){
               form.getCheckBox('topmostSubform[0].F656_Page4[0].section6[0].cB4_01[3]').check();
            }
            if(seccion6_campo4_requisitos_pago==1){
               form.getCheckBox('topmostSubform[0].F656_Page4[0].section6[0].cB4_01[4]').check();
            }
            
            
            //Section 8 Signatures
            form.getTextField('topmostSubform[0].F656_Page7[0].#subform[0].Phone_Number_1[0]').setText(seccion8_telefono_nombre_corporativo || "N/A");
            form.getTextField('topmostSubform[0].F656_Page7[0].#subform[0].Date_1[0]').setText(seccion8_fecha_nombre_corporativo || "N/A");
            if(seccion8_check_nombre_corporativo==1){
               form.getCheckBox( 'topmostSubform[0].F656_Page7[0].#subform[0].cB3_04[0]').check();
            }

            form.getTextField('topmostSubform[0].F656_Page7[0].#subform[0].Phone_Number_2[0]').setText(seccion8_telefono_firma_conyugue || "N/A");
            form.getTextField('topmostSubform[0].F656_Page7[0].#subform[0].Date_2[0]').setText(seccion8_fecha_firma_conyugue || "N/A");
            if(seccion8_check_firma_conyugue==1){
               form.getCheckBox( 'topmostSubform[0].F656_Page7[0].#subform[0].cB3_04[1]').check();
            }

            form.getTextField('topmostSubform[0].F656_Page7[0].Preparer_Phone[0]').setText(seccion9_telefono_firma_preparadora || "N/A");
            form.getTextField('topmostSubform[0].F656_Page7[0].Date_Preparer_Signed[0]').setText(seccion9_fecha_firma_preparadora || "N/A");
            if(seccion9_check_firma_preparadora==1){
               form.getCheckBox( 'topmostSubform[0].F656_Page7[0].cB3_04[2]').check();
            }
            
            form.getTextField('topmostSubform[0].F656_Page7[0].Name_Paid_Preparer[0]').setText(seccion9_nombre_preparadora_pagada || "N/A");
            form.getTextField('topmostSubform[0].F656_Page7[0].Preparer_CAF_PTIN[0]').setText(seccion9_numero_CAF_preparadora || "N/A");
            form.getTextField('topmostSubform[0].F656_Page7[0].firms_name[0]').setText(seccion9_nombre_empresa_preparadora || "N/A");

            
            
            











 
            // Itera sobre los campos y obtén sus nombres
            fields.forEach((field) => {
               {literal}
                  const fieldType = field.constructor.name;
                  console.log(`${field.getName()} - Tipo de campo: ${fieldType}`);
               {/literal}
            });

            // Obtén la primera página

            /*
            const pages = pdfDoc.getPages();
            const firstPage = pages[0];
            const { width, height } = firstPage.getSize();

            // Dibuja texto en la primera página
            firstPage.drawText('This text was added with JavaScript!', {
               x: 5,
               y: height / 2 + 300,
               size: 50,
               font: helveticaFont,
               color: PDFLib.rgb(0.95, 0.1, 0.1),
               rotate: PDFLib.degrees(-45),
            });
            */

            // Guarda el PDF actualizado
            const pdfBytes = await pdfDoc.save();

            // Descarga el PDF modificado
            const blob = new Blob([pdfBytes], { type: 'application/pdf' });
            const link = document.createElement('a');
            link.href = URL.createObjectURL(blob);
            link.download = 'forms 656.pdf';
            link.click();
         }


</script>
{/block}

