{extends file="$layouts_admin"}
{block name="head"}

 

<link
  href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
  rel="stylesheet"
/>


{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    .swal2-container {
         z-index: 9999;
      }

.wrapper {
  overflow: hidden;  
}

ul.breadcrumbs {
  margin: 0;
  padding: 0;
  display: flex; /* Cambiar a flex para un mejor ajuste en pantallas pequeñas */
  flex-wrap: wrap; /* Permitir que los elementos se ajusten en múltiples líneas si es necesario */
  justify-content:center;
}

ul.breadcrumbs li {
  position: relative;
  margin: 0;
  padding: 0;
  list-style: none;
  display: inline-block;
  border-left: 1px solid #ccc;
  transition: 0.3s ease;
}

ul.breadcrumbs li:hover:before {
  /* border-left: 10px solid #5e6e82; */
}

ul.breadcrumbs li:hover a {
  /* color: white;
  background: #5e6e82; */
 
}

ul.breadcrumbs li:before {
  content: "";
  position: absolute;
  right: -9px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 20;
  border-left: 10px solid #fff;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
  transition: 0.3s ease;
}

ul.breadcrumbs li:after {
  content: "";
  position: absolute;
  right: -10px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 10;
  border-left: 10px solid #ccc;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
}

ul.breadcrumbs li.active {
  background: #5e6e82; /* Fondo para el activo */
}

ul.breadcrumbs li.active a {
  color: white !important; /* Color del texto activo */
  padding: 0 15px 0 25px; /* Ajustar el padding */
  background: #5e6e82;
}

ul.breadcrumbs li.first {
  border-left: none;
}

ul.breadcrumbs li.first a {
  font-size: 18px;
  padding-left: 20px;
  border-radius: 5px 0px 0px 5px;
}

ul.breadcrumbs li.last:before {
  display: none;
}

ul.breadcrumbs li.last:after {
  display: none;
}

ul.breadcrumbs li.last a {
  padding-right: 20px;
  border-radius: 0px 40px 40px 0px;
}

ul.breadcrumbs li a {
  display: block;
  font-size: 12px;
  line-height: 40px;
  color: #757575;
  padding: 0px 15px 0px 25px;
  text-decoration: none;
  background: #fff;
  border: 1px solid #ddd;
  white-space: nowrap; /* Evitar que el texto se envuelva */
  overflow: hidden;
  transition: 0.3s ease;
}

ul.breadcrumbs li.active:before {
  display: block; /* Mostrar el triángulo en el activo */
}

ul.breadcrumbs li.active:after {
  display: block; /* Mostrar el triángulo secundario en el activo */
}

@media (max-width: 768px) {
  ul.breadcrumbs {
    flex-direction: column; /* Cambiar a una columna en pantallas más pequeñas */
  }

  ul.breadcrumbs li {
    border-left: none; /* Eliminar el borde izquierdo en pantallas pequeñas */
    margin-bottom: 5px; /* Espaciado entre elementos */
    margin-right: 10px;
  }
}
ul.breadcrumbs li.active:before {
  border-left: 10px solid #5e6e82; /* Cambia el color del triángulo al hacer hover sobre el activo */
}

.cursor_manito {
  cursor: pointer;
}

table.estilosTabla > :not(caption) > * > * {
        /*
        padding-top: 5px !important;
        padding-bottom: 5px !important;
        */
    }

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
   }

   .btn-edit-referencia-personal {
         margin-bottom: 4px; 
         background-color: #001b3b; 
         color: white; 
         border: 1px solid rgb(211, 202, 192) !important; 
         box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
         float: inline-end;
    }

   .btn-eliminar-referencia-personal {
      margin-bottom: 4px;
      background-color: red;
      color: white;
      border: 1px solid rgb(211, 202, 192) !important;
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
      float: inline-end;
    }

   .btn-edit-referencia-personal:hover i,
   .btn-eliminar-referencia-personal:hover i {
      color: white; /* Mantén el color blanco del icono en hover */
   }

   .tamano-icono{
      font-size:small;
   }
    
   .centrar-botones{
      text-align: center;
      justify-content: center;
      display: flex;
      padding: 0px;
   }

   .btn-descargar {
         margin-bottom: 4px; 
         background-color: #001b3b; 
         color: white; 
         border: 1px solid rgb(211, 202, 192) !important; 
         box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
         float: inline-end;
    }

   .btn-eliminar {
      margin-bottom: 4px;
      background-color: red;
      color: white;
      border: 1px solid rgb(211, 202, 192) !important;
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
      float: inline-end;
    }

   .btn-descargar:hover i,
   .btn-eliminar:hover i {
      color: white; /* Mantén el color blanco del icono en hover */
   }

 
</style>

    <input
         type="text"
         value="{$url_base}"
         disabled
         hidden
         id="URL_BASE"
    />

    <input
         type="text"
         value="{$UUID_ENC}"
         disabled
         hidden
         id="UUID_ENC"
    />

    <input
         type="text"
         value="{$UUID}"
         disabled
         hidden
         id="UUID"
    />

    <input
         type="text"
         value="{$id_ifp}"
         disabled
         hidden
         id="id_ifp"
    />

    <input
         type="text"
         value="{$id_user}"
         disabled
         hidden
         id="ID_USER"
    />

 
<div class="row pantalla_cargada" style="display: none;">
   <div class="col-12 col-lg-12 col-sm-12 col-md-12">
      <div class="panel">
         <div class="panel-hdr">
            <h2><span></span>Prospecting Stages <span class="ms-2 titulo_cabecera_credito"></span> </h2>

             
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="wrapper">
                  <ul class="breadcrumbs">

                     <li class="cursor_manito enableMenu" data-id="datos_prestamos" style="display: none;">
                        <a>Loan details</a>
                     </li>

                     <li class="cursor_manito enableMenu" data-id="historial_crediticio" style="display: none;">
                        <a>Credit history</a>
                     </li>

                     <li class="cursor_manito" data-id="general_information">
                        <a>General information</a>
                     </li>

                     <li class="cursor_manito" data-id="referencia">
                        <a>References</a>
                     </li>

                     <li class="cursor_manito" data-id="documento_respaldo">
                        <a>Supporting documents</a>
                     </li>

                     <li class="cursor_manito active" data-id="preaprobacion">
                        <a>Pre-approval</a>
                     </li>

                     <li class="cursor_manito" data-id="plan_pago">
                        <a>Payment plan</a>
                     </li>

                     <li class="cursor_manito" data-id="desembolzo">
                        <a>Disbursement</a>
                     </li>

                     <!--  -->
                  </ul>
               </div>
            </div>
         </div>
      </div>
   </div>

   {**}
   <div class="col-md-12">
      <div class="panel">
         <div class="panel-hdr">
            <h2>Pre-approval</h2>

            <div class="panel-toolbar">
               <div class="btn-group">
                  <button
                     class="btn btn-sm btn-default btn-edicion"
                     data-edicion="1"
                  >
                     <i class="fa-solid fa-pencil"></i>
                     <span class="btn-edicion-text">Enable editing</span>
                  </button>
               </div>
            </div>
            
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  <form id="rform">
                     <div class="row">
                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="referencias_contactadas"
                                 class="col-sm-3"
                                 ><span class="h6"
                                    >Were references contacted?</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <select
                                    id="referencias_contactadas"
                                    name="referencias_contactadas"
                                    class="form-select referencias_contactadas"
                                 >
                                    <option value="" selected disabled>
                                       Select a option
                                    </option>
                                    <option value="1">YES</option>
                                    <option value="2">NO</option>
                                 </select>
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="cliente_nuevo" class="col-sm-3"
                                 ><span class="h6">Are you a new customer?</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <select
                                    id="cliente_nuevo"
                                    name="cliente_nuevo"
                                    class="form-select cliente_nuevo"
                                 >
                                    <option value="" selected disabled>
                                       Select a option
                                    </option>
                                    <option value="1">YES</option>
                                    <option value="2">NO</option>
                                 </select>
                              </div>
                           </div>
                        </div>

                        {*
                           <div class="col-md-12 col-sm-12">
                              <div class="mb-3 row">
                                 <label
                                    for="relacion_ingreso_cuota"
                                    class="col-sm-3"
                                    ><span class="h6">Income quota ratio</span
                                    ><span class="text-danger">*</span></label
                                 >
                                 <div class="col-sm-9">
                                    <div class="input-group mb-3">
                                       <input
                                          class="form-control relacion_ingreso_cuota"
                                          id="relacion_ingreso_cuota"
                                          name="relacion_ingreso_cuota"
                                          type="number"
                                       /><span class="input-group-text">%</span>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        *}

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="documentacion_completa"
                                 class="col-sm-3"
                                 ><span class="h6">Complete documentation?</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <select
                                    id="documentacion_completa"
                                    name="documentacion_completa"
                                    class="form-select documentacion_completa"
                                 >
                                    <option value="" selected disabled>
                                       Select a option
                                    </option>
                                    <option value="1">YES</option>
                                    <option value="2">NO</option>
                                 </select>
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="calificacion_final" class="col-sm-3"
                                 ><span class="h6">Final grade</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <select
                                    id="calificacion_final"
                                    name="calificacion_final"
                                    class="form-select calificacion_final"
                                 >
                                    <option value="" selected disabled>
                                       Select a option
                                    </option>
                                    <option value="1">Approved Prequalification</option>
                                    <option value="2">Refused</option>
                                 </select>
                              </div>
                           </div>
                        </div>
                     </div>
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>

   {**}
   {*
      
   <div class="col-md-12">
      <div class="panel">
         <div class="panel-hdr">
            <h2>Payment methods</h2>
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  <form id="rform">
                     <div class="row">
                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="banco" class="col-sm-3"
                                 ><span class="h6">Bank</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <select
                                    id="banco"
                                    name="banco"
                                    class="form-select banco"
                                 >
                                    <option value="" selected disabled>
                                       Select a option
                                    </option>
                                 </select>
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="tipo_cuenta" class="col-sm-3"
                                 ><span class="h6">Account type</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <select
                                    id="tipo_cuenta"
                                    name="tipo_cuenta"
                                    class="form-select tipo_cuenta"
                                 >
                                    <option value="" selected disabled>
                                       Select a option
                                    </option>
                                 </select>
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="numero_cuenta" class="col-sm-3"
                                 ><span class="h6">Account number</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <input
                                    type="text"
                                    id="numero_cuenta"
                                    name="numero_cuenta"
                                    class="form-control numero_cuenta"
                                 />
                              </div>
                           </div>
                        </div>
                     </div>
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>
   *}
    

   {**}
   <div class="col-md-12">
      <div class="panel">
         <div class="panel-hdr">
            <h2>Observations</h2>
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  <form id="rform">
                     <div class="row">
                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="observaciones" class="col-sm-3"
                                 ><span class="h6">observations</span
                                 ><span class="text-danger"></span
                              ></label>
                              <div class="col-sm-9">
                                 <textarea
                                    rows="3"
                                    id="observaciones"
                                    name="observaciones"
                                    class="form-control observaciones"
                                 ></textarea>
                              </div>
                           </div>
                        </div>
                     </div>

                     {*botones*}
                     <div class="row">
                        <div class="col-md-12">
                           <div
                              class="mb-3"
                              style="
                                 display: flex;
                                 justify-content: space-between;
                              "
                           >
                              <button
                                 class="btn btn-default mt-2 waves-effect waves-themed back"
                                 type="button"
                                 id="submit"
                              >
                                 Back
                              </button>

                               

                              {*de aqui para abajo es guardar sin cambiar estados*}

                              <button
                                 class="btn btn-default mt-2 waves-effect waves-themed guardar_borrador"
                                 type="button"
                                 id="submit"
                              >
                                 Save draft
                              </button>

                              <button
                                 class="btn btn-default mt-2 waves-effect waves-themed loading_guardar_borrador"
                                 style="display: none"
                                 disabled
                              >
                                 <div
                                    style="display: flex; align-items: center"
                                 >
                                    <span
                                       class="spinner-border spinner-border-sm"
                                       style="
                                          height: 20px;
                                          width: 20px;
                                          margin-right: 5px;
                                       "
                                       role="status"
                                       aria-hidden="true"
                                    ></span>
                                    Save draft
                                 </div>
                              </button>

                              {*---*}

                              <div>
                              
                                 <button
                                    class="btn btn-danger mt-2 waves-effect waves-themed guardar_rechazar"
                                    type="button"
                                    style="display: none"
                                    id="submit"
                                 >
                                    Decline
                                 </button>

                                 <button
                                    class="btn btn-danger mt-2 waves-effect waves-themed loading_guardar_rechazar"
                                    style="display: none"
                                    disabled
                                 >
                                    <div
                                       style="display: flex; align-items: center"
                                    >
                                       <span
                                          class="spinner-border spinner-border-sm"
                                          style="
                                             height: 20px;
                                             width: 20px;
                                             margin-right: 5px;
                                          "
                                          role="status"
                                          aria-hidden="true"
                                       ></span>
                                       Decline
                                    </div>
                                 </button>

                                 {*boton aceptado*}


                                 <button
                                    class="btn btn-primary mt-2 waves-effect waves-themed btn_next_pantalla"
                                    type="button"
                                    style="display: none"
                                 >
                                    Next
                                 </button>

                                 <button
                                    class="btn btn-primary mt-2 waves-effect waves-themed guardar_siguiente"
                                    type="button"
                                    id="submit"
                                 >
                                    Pre-approved and Next
                                 </button>

                                 <button
                                    class="btn btn-primary mt-2 waves-effect waves-themed loading_guardar_siguiente"
                                    style="display: none"
                                    disabled
                                 >
                                    <div
                                       style="display: flex; align-items: center"
                                    >
                                       <span
                                          class="spinner-border spinner-border-sm"
                                          style="
                                             height: 20px;
                                             width: 20px;
                                             margin-right: 5px;
                                          "
                                          role="status"
                                          aria-hidden="true"
                                       ></span>
                                       Pre-approved and Next
                                    </div>
                                 </button>
                              
                              </div>

                               
                              {*---*}
                           </div>
                        </div>
                     </div>
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>

   <div
      class="modal fade"
      id="modalMensaje"
      data-bs-backdrop="static"
      data-bs-keyboard="false"
      tabindex="-1"
      aria-labelledby="staticBackdropLabel"
      aria-hidden="true"
   >
      <div class="modal-dialog modal-dialog-centered">
         <div class="modal-content">
            <div class="modal-header">
               <h5
                  class="modal-title modal_titulo_mensaje"
                  id="staticBackdropLabel"
               >
                  Group Message
               </h5>
               <button
                  type="button"
                  class="btn-close btn_cerrar_confirmacion_modal"
               ></button>
            </div>
            <div class="modal-body text-center">
               <p class="modal_contenido_mensaje">
                  The group advertising campaign has been sent. For more
               </p>
            </div>
         </div>
      </div>
   </div>
</div>


<div class="row cargando_pantalla " style=" margin: 0px; ">

   <div
      class="container"
      style="
         display: flex;
         justify-content: center;
         align-items: center;
         height: 45vh;
         box-shadow: 0 0 13px 0 rgba(31,17,173,.08);
         border-radius: 11px;
         background-color: white;
      "
   >
      <div style="text-align: center">
         <span
         class="spinner-border spinner-border-sm"
         style="height: 45px; width: 45px; margin-bottom: 10px"
         role="status"
         aria-hidden="true"
         ></span>
         <br />
         <strong>Please wait while the <span style=" font-weight: 600; ">"Pre-Approval"</span> screen loads...</strong>
         <br />
      </div>
   </div>

</div>


<div class="modal fade" id="ventana_confirmacion" tabindex="-1" aria-labelledby="exampleModalLabel__ventanaconfirmacion" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false" >
   <div class="modal-dialog modal-dialog-centered"  >
      <div class="modal-content" style="background-color:white">
         <div class="modal-header">
         <h3 class="titulo_modal_confirmar">Estas seguro de eliminar</h3>
            <button type="button" class="btn-close "  id="btn_close_ventana_confirmacion" ></button>
         </div>
         <div class="modal-body" style="background-color:white;border-radius:10px">
          
            <div class="row">
               <div class="col-md-12">
                  <div class="panel-container show" id="ibox_form">
                           <div class="panel-content">
                              <div class="px-2">
                                    <div class="alert alert-danger" id="emsg" style="display: none;">
                                       <span id="emsgbody"></span>
                                    </div>
                                    <input class="tipo_modal_confirmar" hidden disabled/> 
                                    <input class="data_id" hidden disabled/> 
                                    <div class="row">
                                          <div class="col-md-12 col-sm-12">

                                                <h4 class="mensaje_modal_confirmar" style="text-align:center; color:black">Estas seguro de eliminar</h4>
                                                 
                                                 <p class="mensaje_espera_moda_confirmacion mt-3" style="text-align:center; color:red; font-weight:600">Espere mientras termina el proceso</p>
                                          </div>
                                     
                                       </div>

                                       <div class="row mt-2">
                                          <div class="col-md-12">
                                                <div style=" float: inline-end; ">
                                                   <button class="btn me-2" type="button" id="btn_cerrar_ventana_confirmacion" style=" background: #001b3b; ">close</button>
                                                   <button class="btn " type="button" id="btn_aplicar_ventana_confirmacion" style=" background: red; ">Remove</button>
                                                </div>
                                          </div>
                                       </div>
                              </div>
                           </div>
                        </div>
               </div>
            </div>
          
         </div>
         
      </div>
   </div>
</div>

 
{/block}

{block name="script"}

{literal}
<script>

   var URL_BASE = $("#URL_BASE").val();
   var ID_USER = $("#ID_USER").val();
   var url_dashboard = $("#url_dashboard").val();
   var roll_id = $("#roll_id").val();

   var UUID_ENC = $("#UUID_ENC").val();
   var UUID     = $("#UUID").val();
   var id_ifp   = $("#id_ifp").val();

   var COLOR_FONDO_VENTANA_CERRAR = "#001b3b";
   var COLOR_TEXT_VENTANA_CERRAR = "white";

   var COLOR_FONDO_VENTANA_CONFIRMACION = "red";
   var COLOR_TEXT_VENTANA_CONFIRMACION = "white";

   var COLOR_FONDO_VENTANA_IR = "#001b3b";
   var COLOR_TEXT_VENTANA_IR = "white";

   var  arreglo_tipo_bancos = [];
   var  arreglo_tipo_cuentas = [];

   var menus_disponibles = {};

   var registro_completado = 2;
 
   $(document).ready(function () {

       
      cargarPrincipal();
  
      $(".progress").hide();
      $("#emsg").hide();
      $("#emsgSuccess").hide();

      var _url = '{$_url}';

      $('.cursor_manito').click(function() {

         const atributo_data =  $(this).attr('data-id');

         if(atributo_data == "datos_prestamos")
         {
            window.location = URL_BASE + "credit/data-loans/" + UUID_ENC;
         }

         if(atributo_data == "historial_crediticio")
         {
            window.location = URL_BASE + "credit/credit-history/" + UUID_ENC;
         }

         if(atributo_data == "general_information")
         {
            if(menus_disponibles.general_information == 1)
            {
               window.location = URL_BASE + "credit/new-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
            
         }

         if(atributo_data == "referencia")
         {
            if(menus_disponibles.referencia == 1)
            {
               window.location = URL_BASE + "credit/reference-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "documento_respaldo")
         {
            if(menus_disponibles.documento_respaldo == 1)
            {
               window.location = URL_BASE + "credit/supporting-document-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "preaprobacion")
         {
            return;

            if(menus_disponibles.preaprobacion == 1)
            {
               window.location = URL_BASE + "credit/pre-approval-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "plan_pago")
         {
            if(menus_disponibles.plan_pago == 1)
            {
               window.location = URL_BASE + "credit/payment-plan-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "desembolzo")
         {
            if(menus_disponibles.desembolzo == 1)
            {
               window.location = URL_BASE + "credit/disbursement-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

 
      });

      $(".btn-edicion").off("click")
      .on("click", function () {

         const edicionValue = $(this).data('edicion');

         //console.log("edicionValue");
         //console.log(edicionValue);

         if(edicionValue == "1")
         {
            $(this).data("edicion", "2")
            $(".btn-edicion-text").text("Disable editing");

            $('input, select, button, textarea').prop('disabled', false);
            $('input, select, button, textarea').prop('disabled', false);
         }else{
            $(this).data("edicion", "1")
            $(".btn-edicion-text").text("Enable editing");

            $('input, select, button, textarea').prop('disabled', true);
            $('input, select, button, textarea').prop('disabled', true);
         }

         $('.back').prop('disabled', false);
         $('.btn-edicion').prop('disabled', false);
       
      });
 
      $('#submit_modal_confirmacion_correo').on('click', function() {
         window.location = url_dashboard;    
      });
 
      $("#btn_aplicar_ventana_confirmacion").off("click")
      .on("click", function () {

         console.log("se dio click");

            $('#btn_aplicar_ventana_confirmacion').prop('disabled', true);
            $('#btn_close_ventana_confirmacion').prop('disabled', true);
            $('#btn_cerrar_ventana_confirmacion').prop('disabled', true);
 
            let opcion_predefinida = $(".tipo_modal_confirmar").val();
            let data_id = $(".data_id").val();

            if(opcion_predefinida == "eliminar_card_documento")
            {

               $(".mensaje_espera_moda_confirmacion").text("Please wait while the process finishes...");

               $(".card_eliminar_" + data_id).remove();

               $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
               $('#btn_close_ventana_confirmacion').prop('disabled', false);
               $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
               
               //$("#ventana_confirmacion").modal("hide");

               ventanaRegistroExito("Record deleted", "¡The record has been successfully deleted!");

            }

            if(opcion_predefinida == "navegar_pantalla_siguiente")
            {
               window.location = URL_BASE + "credit/payment-plan-prospecting/"+data_id;
            }

            if(opcion_predefinida == "navegar_otras_pantallas")
            {
               window.location = URL_BASE + data_id;
            }
         
       
      });

      $("#btn_cerrar_ventana_confirmacion").off("click")
      .on("click", function () {
         
         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         $("#ventana_confirmacion").modal("hide");
       
      });

      $("#btn_close_ventana_confirmacion").off("click")
      .on("click", function () {

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         
         $("#ventana_confirmacion").modal("hide");
       
      });

      $('.btn_cerrar_confirmacion_modal').click(function() {

         console.log("se dio click en cerrar modal");
         $("#modalMensaje").modal("hide");
      });

      $('.abrir_modal_contacto').click(function() {
         $("#modal_asignar_clientes_contactos").modal("show");
      });

      //usaremos la clase back para hacer el rechazar
      $('.back').click(function() {
          
         window.location = URL_BASE + "credit/supporting-document-prospecting/" + UUID_ENC;

          

      });

      //usaremos la clase back para hacer el rechazar
      $('.guardar_rechazar').click(function() {
          
         //window.location = URL_BASE + "credit/supporting-document-prospecting/" + UUID_ENC;

         //rechazar
         guardarInformacion(3);

      });

      $('.guardar_siguiente').click(function() {

         console.log("menus_disponibles");
         console.log(menus_disponibles);
         //return;

         //if(menus_disponibles.preaprobacion == 1 && menus_disponibles.estado_prestamo != 5){
         //   window.location = URL_BASE + "credit/payment-plan-prospecting/" + UUID_ENC;
         //   return;
         //}

         if(registro_completado == 1 && menus_disponibles.estado_prestamo != 5){
            window.location = URL_BASE + "credit/payment-plan-prospecting/" + UUID_ENC;
            return;
         }

          

         //cuando se le de click a guardar y siguiente, se cambira el estado
         guardarInformacion(1);
          
      });

      $('.btn_next_pantalla').click(function() {

         window.location = URL_BASE + "credit/payment-plan-prospecting/" + UUID_ENC;

      });

      $('.guardar_borrador').click(function() {

         guardarInformacion(2);

      });

      function guardarInformacion(esBorrador = 2)
      {
         
         let referencias_contactadas = $(".referencias_contactadas").val();
         let cliente_nuevo = $(".cliente_nuevo").val();
         let relacion_ingreso_cuota = $(".relacion_ingreso_cuota").val();
         let documentacion_completa = $(".documentacion_completa").val();
         let calificacion_final = $(".calificacion_final").val();
         let banco = $(".banco").val();
         let tipo_cuenta = $(".tipo_cuenta").val();
         let numero_cuenta = $(".numero_cuenta").val();
         let observaciones = $(".observaciones").val();

         if(esBorrador == 1)
         {
            if(isEmpty(referencias_contactadas))
            {
               
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector('.referencias_contactadas');
                  
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               }

               toastr.error('!In "Pre-approval" the field "Were references contacted?" is required.');
               return;
            }

            if(isEmpty(cliente_nuevo))
            {
               
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector('.cliente_nuevo');
                  
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               }

               toastr.error('!In "Pre-approval" the field "Are you a new customer?" is required.');
               return;
            }

            /*
            
            if(isEmpty(relacion_ingreso_cuota))
            {
               
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector('.relacion_ingreso_cuota');
                  
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               }

               toastr.error('!In "Pre-approval" the field "Income quota ratio" is required.');
               return;
            }

            */

            if(isEmpty(documentacion_completa))
            {
               
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector('.documentacion_completa');
                  
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               }

               toastr.error('!In "Pre-approval" the field "Complete documentation?" is required.');
               return;
            }

            if(isEmpty(calificacion_final))
            {
               
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector('.calificacion_final');
                  
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               }

               toastr.error('!In "Pre-approval" the field "Final grade" is required.');
               return;
            }
   
            /*
            

            if(isEmpty(banco))
            {
               
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector('.banco');
                  
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               }

               toastr.error('!In "Account information" the field "Bank" is required.');
               return;
            }

            if(isEmpty(tipo_cuenta))
            {
               
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector('.tipo_cuenta');
                  
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               }

               toastr.error('!In "Account information" the field "Account type" is required.');
               return;
            }

            if(isEmpty(numero_cuenta))
            {
               
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector('.numero_cuenta');
                  
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               }

               toastr.error('!In "Account information" the field "Account number" is required.');
               return;
            }

            */

            /*
            if(isEmpty(observaciones))
            {
               
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector('.observaciones');
                  
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               }

               toastr.error('!In "Observations" the field "observations" is required.');
               return;
            }
            */
         }

         let validacionCaracteres = validateFormFields();

         if(validacionCaracteres == true)
         {
            return;
         }

         //console.log("return abajo");
         //return;

         /*
         let nombre_banco = "";
         let nombre_tipo_cuenta = "";
 
         let findBank = arreglo_tipo_bancos.find((data) => String(data.id) == String(banco));
         
         if(findBank)
         {
            nombre_banco = findBank.name;
         }

         let findTypeAccount = arreglo_tipo_cuentas.find((banco) => String(banco.id) == String(tipo_cuenta));
         
         if(findTypeAccount)
         {
            nombre_tipo_cuenta = findTypeAccount.name;
         }

         */

         $('input, select, button, textarea').prop('disabled', true);

         if(esBorrador == 2)
         {
            $('.loading_guardar_borrador').css('display', '');
            $('.guardar_borrador').css('display', 'none');
         }

         if(esBorrador == 1)
         {
            $('.loading_guardar_siguiente').css('display', '');
            $('.guardar_siguiente').css('display', 'none');
         }

         if(esBorrador == 3)
         {
            $('.loading_guardar_rechazar').css('display', '');
            $('.guardar_rechazar').css('display', 'none');
         }

         var informacionEnviar = {
             esBorrador:                                esBorrador,
             id_ifp:                                    id_ifp,
             //nombre_banco:                              nombre_banco,
             //nombre_tipo_cuenta:                        nombre_tipo_cuenta,
             referencias_contactadas:                   referencias_contactadas,
             cliente_nuevo:                             cliente_nuevo,
             //relacion_ingreso_cuota:                    relacion_ingreso_cuota,
             documentacion_completa:                    documentacion_completa,
             calificacion_final:                        calificacion_final,
             //banco:                                     banco,
             //tipo_cuenta:                               tipo_cuenta,
             //numero_cuenta:                             numero_cuenta,
             observaciones:                             observaciones,
         }; 

         console.log(JSON.stringify(informacionEnviar));
         //console.log("return aqui abajo")
         //return;

         $.ajax({
            type: "POST",
            url: URL_BASE + "credit/post-save-pre-aprobacion",
            data: JSON.stringify(informacionEnviar), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               $('input, select, button, textarea').prop('disabled', false);

               if(esBorrador == 2)
               {
                  $('.loading_guardar_borrador').css('display', 'none');
                  $('.guardar_borrador').css('display', '');
               }

               if(esBorrador == 1)
               {
                  $('.loading_guardar_siguiente').css('display', 'none');
                  $('.guardar_siguiente').css('display', '');
               }

               if(esBorrador == 3)
               {
                  $('.loading_guardar_rechazar').css('display', 'none');
                  $('.guardar_rechazar').css('display', '');
               }
   
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {

                     if(esBorrador == 1)
                     {
                        //jajaja
                        toastr.success(
                            "Record added",
                            "¡Record added successfully!",
                        );

                        setTimeout(() => {
                           window.location = URL_BASE + "credit/payment-plan-prospecting/" + UUID_ENC;
                        }, 1000);

                        //navegarPantallaSiguiente(UUID_ENC); 
                     }

                     if(esBorrador == 2)
                     {
                        //ventanaRegistroExito("Draft saved successfully", "¡Draft saved successfully, you can edit again!")

                        toastr.success(
                            "Draft saved successfully",
                            "¡Draft saved successfully, you can edit again!",
                        );


                     }

                     if(esBorrador == 3)
                     {
                        toastr.success(
                            "Credit denied",
                            "¡Your credit has been successfully denied!",
                        );

                        window.location = URL_BASE + "credit/search-loans";

                        //navegarPantallaListado("Credit denied", "¡Your credit has been successfully denied!", "credit/search-loans" );
                     }
 
                  } else if (info.type == "error") {

                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {

                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
            
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

               $('input, select, button, textarea').prop('disabled', false);

               if(esBorrador == 2)
               {
                  $('.loading_guardar_borrador').css('display', 'none');
                  $('.guardar_borrador').css('display', '');
               }

               if(esBorrador == 1)
               {
                  $('.loading_guardar_siguiente').css('display', 'none');
                  $('.guardar_siguiente').css('display', '');
               }

               if(esBorrador == 3)
               {
                  $('.loading_guardar_rechazar').css('display', 'none');
                  $('.guardar_rechazar').css('display', '');
               }

            },
         });

          

      }

      $('.calificacion_final').on('change', function() {

         let calificacion_final = $(".calificacion_final").val();

         if(calificacion_final)
         {
            $(".guardar_siguiente").css("display", "none");
            $(".guardar_rechazar").css("display", "none");

            if(calificacion_final == "1" || calificacion_final == 1)
            {
               $(".guardar_siguiente").css("display", "");
            }

            if(calificacion_final == "2" || calificacion_final == 2)
            {
               $(".guardar_rechazar").css("display", "");
            }

         }


      });
 

   });

   function contadorPosicion()
   {
      //if(menus_disponibles.preaprobacion == 1 || menus_disponibles.preaprobacion == "1")
      //{
      //   menus_disponibles.plan_pago = "1";
      //}

      // Ordered list of properties to process
      const propertiesToCheck = [
         "general_information",
         "referencia",
         "documento_respaldo",
         "preaprobacion",
         "plan_pago",
         "desembolzo"
      ];

      // Find the first "1" and set the next property (if it's "2") to "1"
      for (let i = 0; i < propertiesToCheck.length - 1; i++) {
         const currentProp = propertiesToCheck[i];
         if (menus_disponibles[currentProp] === "1") {
            const nextProp = propertiesToCheck[i + 1];
            if (menus_disponibles[nextProp] === "2") {
                  menus_disponibles[nextProp] = "1";
                  break; // Stop after updating the next property
            }
         }
      }
 
   }

   function cargarPrincipal()
   {

      let data = {
         id_ifp: id_ifp,
      };

      $.ajax({
         type: "POST",
         url: URL_BASE + "credit/get-data-pre-aprobacion",
         data: JSON.stringify(data),
         contentType: "application/json", // Tipo de contenido JSON
         success: function (response) {
 
            try {
               let info = JSON.parse(response);

               if (info.type == "success") {

                  menus_disponibles = info.menu_habilitados || {};
 
                  //arreglo_tipo_bancos  = info.data_bank || [];
                  //$(".banco").html(select_html_bank(arreglo_tipo_bancos));

                  //arreglo_tipo_cuentas  = info.data_type_account || [];
                  //$(".tipo_cuenta").html(select_html_bank(arreglo_tipo_cuentas));
                   

                  let dataPreAprobbal = info.data_pre_approval_prospecting || {};

                  //console.log("dataPreAprobbal");
                  //console.log(dataPreAprobbal);

                  if(Object.keys(dataPreAprobbal).length != 0)
                  {
 
                     $(".referencias_contactadas").val(dataPreAprobbal.referencias_contactadas);
                     $(".cliente_nuevo").val(dataPreAprobbal.cliente_nuevo);
                     $(".relacion_ingreso_cuota").val(dataPreAprobbal.relacion_ingreso_cuota);
                     $(".documentacion_completa").val(dataPreAprobbal.documentacion_completa);
                     $(".calificacion_final").val(dataPreAprobbal.calificacion_final);
                     $(".banco").val(dataPreAprobbal.banco);
                     $(".tipo_cuenta").val(dataPreAprobbal.tipo_cuenta);
                     $(".numero_cuenta").val(dataPreAprobbal.numero_cuenta);
                     $(".observaciones").val(dataPreAprobbal.observaciones);

                     //habilitar el modo de edicion
                     $(".btn-edicion").attr("data-edicion", "1");
                     $(".btn-edicion-text").text("Enabled editing");

                     $('input, select, button, textarea').prop('disabled', true);
                     $('.back').prop('disabled', false);
                     $('.btn-edicion').prop('disabled', false);

                  }else{

                     //habilitar el modo de edicion
                     $(".btn-edicion").attr("data-edicion", "2");
                     $(".btn-edicion-text").text("Disabled editing");

                     $('input, select, button, textarea').prop('disabled', false);
                     $('.back').prop('disabled', false);
                     $('.btn-edicion').prop('disabled', false);


                     $(".btn-edicion").css("display", "none");
                  }

                  if(menus_disponibles.preaprobacion == 1)
                  {
                     $(".btn-edicion").css("display", "none");
                     $(".guardar_rechazar").css("display", "none");
                     $(".guardar_borrador").css("display", "none");
                     $(".guardar_siguiente").css("display", "");

                     if(menus_disponibles.estado_prestamo != 5)
                     {
                        $(".guardar_siguiente").text("Next");
                        $(".guardar_siguiente").attr("disabled", false);

                        
                     }else{
                        
                        if(menus_disponibles.plan_pago == 1)
                        {
                           $(".btn_next_pantalla").css("display", "");
                           $(".btn_next_pantalla").text("Next");
                           $(".btn_next_pantalla").attr("disabled", false);

                           $(".guardar_siguiente").css("display", "none");

                        }else{
                           $(".guardar_siguiente").css("display", "none");
                        }

                     }
                      
                  }

                  if(menus_disponibles.desembolzo == 1 && menus_disponibles.estado_prestamo == 4)
                  {
                     $(".enableMenu").css("display", "");
                  }


                  let data_gip = info.data_gip || {};

                  if(Object.keys(data_gip).length != 0)
                  {
                     if(isEmpty(data_gip.numero_credito) == true)
                     {
                        $(".titulo_cabecera_credito").text(" " + data_gip.account);
                     }else{
                        $(".titulo_cabecera_credito").text(" No. Credit: " + data_gip.numero_credito + " - " + data_gip.account);
                     }

                  }

                  registro_completado = menus_disponibles.preaprobacion;

                  console.log("registro_completado");
                  console.log(registro_completado);

                  console.log("menus_disponibles");
                  console.log(menus_disponibles);
                   

                  contadorPosicion();

                  $(".cargando_pantalla").css("display", "none");
                  $(".pantalla_cargada").css("display", "");
 
               } else if (info.type == "error") {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: info.message,
                  //});

                  ventanaError("Opps there was an error", info.message);
               }
            } catch (error) {
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);
            }
         },
         error: function (xhr, status, error) {
            console.error("Error en la solicitud:", error);
            // Manejar errores aquí
            //Swal.fire({
            //   icon: "error",
            //   title: "Oops...",
            //   text: error,
            //});

            ventanaError("Opps there was an error", error);

         },
      });

       
   }

  
 
   function ventanaRegistroExito(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
       
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }

   function isEmpty(value) {
       // Verificar si es null o undefined
       if (value == null) return true;

       // Verificar si es una cadena vacía
       if (typeof value === "string" && value.trim() === "") return true;

       // Verificar si es un array vacío
       if (Array.isArray(value) && value.length === 0) return true;

       // Verificar si es un objeto vacío
       if (typeof value === "object" && Object.keys(value).length === 0) return true;

       return false;
   }
 
   function validarSoloNumeros(input) {
       const number = parseInt(input, 10);
       return !isNaN(number) && number.toString() === input;
   }

   function validateEmail(email) {
      // Expresión regular para validar un formato de correo electrónico
      var emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
      
      if (emailPattern.test(email)) {
         return true;  // Es un correo válido
      } else {
         return false;  // No es un correo válido
      }
   }
 
   function isInvalidEmail(email) {
      const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      return !emailRegex.test(email);
   }

   function getRandomInt(min, max) {
      return Math.floor(Math.random() * (max - min + 1)) + min;
   }

   function validateFormFields() {
      const fields = [
         { selector: '.referencias_contactadas', section: 'Pre-approval', name: 'Were references contacted?' },
         { selector: '.cliente_nuevo', section: 'Pre-approval', name: 'Are you a new customer?' },
         { selector: '.relacion_ingreso_cuota', section: 'Pre-approval', name: 'Income quota ratio' },
         { selector: '.documentacion_completa', section: 'Pre-approval', name: 'Complete documentation?' },
         { selector: '.calificacion_final', section: 'Pre-approval', name: 'Final grade' },
         //{ selector: '.banco', section: 'Account information', name: 'Bank' },
         //{ selector: '.tipo_cuenta', section: 'Account information', name: 'Account type' },
         //{ selector: '.numero_cuenta', section: 'Account information', name: 'Account number' },
         { selector: '.observaciones', section: 'observations', name: 'observations' }
      ];

      for (const field of fields) {
         const value = $(field.selector).val();
         if (value && value.length > 255) {
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector(field.selector);
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               };
               toastr.error(`In "${field.section}" the field "${field.name}" cannot exceed 255 characters.`);
               return true;
         }
      }
      
      return false;
   }

   function navegarPantallaSiguiente(UUID_ENC_)
   {
      $(".titulo_modal_confirmar").text("Record added");
      $(".mensaje_modal_confirmar").text("¡Record added successfully!");
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("navegar_pantalla_siguiente");
      $(".data_id").val(UUID_ENC_);

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });

      $('#btn_close_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });
 
      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_IR,
         'color': COLOR_TEXT_VENTANA_IR,
         'display': "",
      });

      $('#btn_aplicar_ventana_confirmacion').text("Continue");
 
      $("#ventana_confirmacion").modal("show");
   }

   function navegarPantallaListado(titulo="", mensaje="", url="")
   {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("navegar_otras_pantallas");
      $(".data_id").val(url);

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });

      $('#btn_close_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });
 
      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_IR,
         'color': COLOR_TEXT_VENTANA_IR,
         'display': "",
      });

      $('#btn_aplicar_ventana_confirmacion').text("Continue");
 
      $("#ventana_confirmacion").modal("show");
   }

   function select_html_bank(arreglo) {
      let html = "<option value='' selected disabled >Select a option</option>";
   
      arreglo.forEach(function (element) {
         let {
            id,
            UUID,
            UUID_ENC,
            name,
            state,
        } = element;

         html += `<option value="${id}">${name}</option>`;
      });

      return html;
   }

   function ventanaError(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }



 
</script>
{/literal}


{/block}