{extends file="$layouts_admin"}

{block name="head"}
{if $d['img'] neq ''}

<style>
    #croppic{

        background-image: url({$app_url}{$d['img']});

    }
</style>

{/if}


{/block}


{block name="content"}

<div class="mx-auto" style="max-width: 800px;">
    <form role="form" name="accadd" method="post" action="{$_url}settings/users-edit-post">
        <div class="row">
            <div class="col-md-12">
                <div class="panel">
                    <div class="panel-hdr">
                        <h2>{$_L['Edit User']}</h2>

                    </div>
                    <div class="panel-container" id="application_ajaxrender">
                        <div class="panel-content">
                            <div class="mb-3">
                                <label for="username">{$_L['Username']}</label>
                                <input type="text" class="form-control" id="username" name="username" value="{$d['username']}">
                            </div>

                            <div class="mb-3">
                                <label for="fullname">{$_L['Full Name']}</label>
                                <input type="text" class="form-control" id="fullname" name="fullname" value="{$d['fullname']}">
                            </div>
                            <div class="mb-3">
                                <label for="phonenumber">{$_L['Phone']}</label>
                                <input type="text" class="form-control" id="phonenumber" name="phonenumber" value="{$d['phonenumber']}">
                            </div>
                            <div class="mb-3">
                                <label for="user_language">{$_L['Default_Language']}</label>
                                <select class="form-select" name="user_language" id="user_language">


                                    {foreach $languages as $language}
                                    <option value="{$language['iso_code']}" {if $selected_language eq $language['iso_code']} selected="selected" {/if}>{$language['name']}</option>
                                    {/foreach}


                                </select>
                            </div>

                            <div class="mb-3 ">
                                <label for="twi_phone"><span class="h6"></span>Twilio Phones </label>
                                <div >
                                    <select id="twi_phone" name="twi_phone" class="form-control">
                                        <option value="0">{$_L['None']}</option>
                                        {foreach $phones as $phone}
                                        <option value="{$phone['id']}" {if $d['id_number'] eq ($phone['id'])}selected{/if}>
                                            {$phone['number_twilio']}
                                        </option>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3 ">
                                <label for="config_ws_sm"><span class="h6"></span>Config. Whatsapp/SMS </label>
                                <div >
                                    <select id="config_ws_sm" name="config_ws_sm" class="form-control">
                                        <option value="0">{$_L['None']}</option>
                                        {foreach $config_whatsapp as $c}
                                        <option value="{$c['id']}" {if $d['config_whatsapp_other_id'] eq ($c['id'])}selected{/if}>
                                            {$c['identifier']}
                                        </option>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3 ">
                                <label for="configuracion_estatus"><span class="h6"></span>Status </label>
                                <div>
                                    <select id="configuracion_estatus" name="configuracion_estatus" class="form-control">
                                        <option value="Active" {if $d['status'] eq ("Active")} selected {/if} >Active</option>
                                        <option value="Inactive" {if $d['status'] eq ("Inactive")}selected{/if}>Inactive</option>
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3">
                                <div id="croppic"></div>

                                <button type="button" id="cropContainerHeaderButton" class="btn btn-primary">{$_L['Upload Picture']}</button>
                                <input type="file" id="picture_file" accept="image/*" class="d-none">
                                {*<button type="button" id="opt_gravatar" class="btn btn-info">{$_L['Use Gravatar']}</button>*}
                                <button type="button" id="no_image" class="btn btn-default">{$_L['No Image']}</button>
                            </div>
                            <div class="mb-3">
                                <label for="fullname">{$_L['Picture']}</label>
                                <input type="text" class="form-control picture" id="picture" readonly name="picture" value="{$d['img']}">
                            </div>

                            {if ($user['id']) neq ($d['id'])}
                            <div class="mb-3">


                                <label>{$_L['User']} {$_L['Type']}</label>

                                <div class="i-checks"><label> <input type="radio" value="Admin" name="user_type" {if $d->user_type eq 'Admin'}checked{/if}> <i></i> {$_L['Full Administrator']} </label></div>

                                {foreach $roles as $role}
                                <div class="i-checks"><label> <input type="radio" value="{$role['id']}" name="user_type" {if $d->roleid eq $role['id']}checked{/if}> <i></i> {$role['rname']} </label></div>
                                {/foreach}

                            </div>
                            {/if}

                            <div class="mb-3">
                                <label for="password">{$_L['Password']}</label>
                                <input type="password" class="form-control" id="password" name="password">
                                <span class="help-block">{$_L['password_change_help']}</span>
                            </div>

                            <div class="mb-3">
                                <label for="cpassword">{$_L['Confirm Password']}</label>
                                <input type="password" class="form-control" id="cpassword" name="cpassword">
                            </div>
                            {if $user->roleid == 0}

                            <div class="hr-line-dashed"></div>

                            <div class="mb-3">
                                <label>{$_L['Job title']}</label>
                                <input class="form-control" name="job_title" value="{$d->job_title}">
                            </div>

                            <div class="mb-3">
                                <label>{$_L['Address']}</label>
                                <input class="form-control" name="address" value="{$d->address_line_1}">
                            </div>

                            <div class="mb-3">
                                <label>{$_L['City']}</label>
                                <input class="form-control" name="city" value="{$d->city}">
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label>{$_L['State Region']}</label>
                                        <input class="form-control" name="state" value="{$d->state}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label>{$_L['ZIP Postal Code']}</label>
                                        <input class="form-control" name="zip" value="{$d->zip}">
                                    </div>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label>{$_L['Country']}</label>
                                <select class="form-select" name="country">
                                    {if $d->country != ''}
                                    {Countries::all($d->country)}
                                    {else}
                                    {Countries::all($config['country'])}
                                    {/if}
                                </select>
                            </div>

                            <div class="mb-3">
                                <label>{$_L['Date Joined']}</label>
                                <input class="form-control" name="date_hired" datepicker
                                data-date-format="yyyy-mm-dd" data-auto-close="true" value="{$d->date_hired}">
                            </div>

                            <div class="mb-3">
                                <label>{$_L['Pay frequency']}</label>
                                <select class="form-select" name="pay_frequency">
                                    <option value="Monthly" {if $d->pay_frequency == 'Monthly'} selected{/if}>{$_L['Monthly']}</option>
                                    <option value="Hourly" {if $d->pay_frequency == 'Hourly'} selected{/if}>{$_L['Hourly']}</option>
                                </select>
                            </div>


                            <div class="mb-3">
                                <label>{$_L['Amount']}</label>
                                <input class="form-control amount" name="amount" value="{$d->amount}">
                            </div>


                            <div class="mb-3">
                                <label>{$_L['Summary']}</label>
                                <textarea class="form-control" rows="10" name="summary">{$d->summary}</textarea>
                            </div>


                            {/if}



                            {csrf_field()}
                            <input type="hidden" name="id" value="{$d['id']}">
                            <button type="submit" class="btn btn-primary"> {$_L['Submit']}</button>
                            {$_L['Or']} <a href="{$_url}settings/users">{$_L['Cancel']}</a>



                        </div>



                    </div>
                </div>



            </div>


            <div class="col-md-12">



                <div class="panel" id="ui_settings">

                    <div id="application_ajaxrender">
                        <div class="panel-hdr">
                            <h2>{$_L['Notifications']}</h2>
                        </div>


                        <div class="panel-container">
                            <div class="panel-content">
                                <table class="table table-hover table-bordered">
                                    <tbody>


                                        <tr>
                                            <td width="80%"><label for="config_email_notify">{$_L['Email']} </label></td>
                                            <td> <input type="checkbox" {if $user->email_notify eq '1'}checked{/if} data-toggle="toggle" data-size="small" data-on="{$_L['Yes']}" data-off="{$_L['No']}" id="config_email_notify"></td>
                                        </tr>

                                        <tr>
                                            <td width="80%"><label for="config_sms_notify">{$_L['SMS']} </label></td>
                                            <td> <input type="checkbox" {if $user->sms_notify eq '1'}checked{/if} data-toggle="toggle" data-size="small" data-on="{$_L['Yes']}" data-off="{$_L['No']}" id="config_sms_notify"></td>
                                        </tr>


                                    </tbody>
                                </table>
                            </div>
                        </div>



                    </div>
                </div>




                {if $user->roleid == 0}

                <div class="panel">

                    <div class="panel-hdr">
                        <h2>{$_L['Departments']}</h2>
                    </div>

                    <div class="panel-container">
                        <div class="panel-content">
                            {foreach $departments as $department}

                            <div class="mb-3">
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input on_change_department" id="department_{$department->id}"
                                    {if isset($assigned_departments[$department->id])} checked{/if}
                                    >
                                    <label class="custom-control-label" for="department_{$department->id}">{$department->dname}</label>
                                </div>
                            </div>


                            {/foreach}
                        </div>
                    </div>



                </div>

                {/if}





            </div>



        </div>

    </form>
</div>



{/block}


{block name="script"}




<script>




    $(function () {


        $('.amount').autoNumeric('init', {

            aSign: '{$config['currency_code']} ',
            dGroup: {$config['thousand_separator_placement']},
            aPad: {$config['currency_decimal_digits']},
            pSign: '{$config['currency_symbol_position']}',
            aDec: '{$config['dec_point']}',
            aSep: '{$config['thousands_sep']}',
            vMax: '9999999999999999.00',
            vMin: '-9999999999999999.00'

        });

        $('#config_email_notify').change(function() {

            $('#ui_settings').block({ message: null });


            if($(this).prop('checked')){

                $.post( base_url+'settings/set_notify/', { opt: "email_notify", val: "1" })
                .done(function( data ) {
                    $('#ui_settings').unblock();
                    location.reload();
                });

            }
            else{
                $.post( _url+'settings/set_notify/', { opt: "email_notify", val: "0" })
                .done(function( data ) {
                    $('#ui_settings').unblock();
                    location.reload();
                });
            }
        });

        $('#config_sms_notify').change(function() {

            $('#ui_settings').block({ message: null });


            if($(this).prop('checked')){

                $.post( base_url+'settings/set_notify/', { opt: "sms_notify", val: "1" })
                .done(function( data ) {
                    $('#ui_settings').unblock();
                    location.reload();
                });

            }
            else{
                $.post( _url+'settings/set_notify/', { opt: "sms_notify", val: "0" })
                .done(function( data ) {
                    $('#ui_settings').unblock();
                    location.reload();
                });
            }
        });


        var _url = $("#_url").val();
        var appUrl = "{$app_url}";


        // simple file upload to replace croppic (keeps same backend endpoint)
        $('#cropContainerHeaderButton').on('click', function () {
            $('#picture_file').trigger('click');
        });
        // allow clicking on the preview area in case styles hide the button
        $('#croppic').on('click', function () {
            $('#picture_file').trigger('click');
        });

        $('#picture_file').on('change', function () {
            const file = this.files[0];
            if (!file) {
                return;
            }
            const formData = new FormData();
            formData.append('img', file);
            $.ajax({
                url: _url + 'sys_imgcrop/save/',
                method: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function (resp) {
                    let data = resp;
                    if (typeof resp === 'string') {
                        try { data = JSON.parse(resp); } catch (e) { data = {}; }
                    }
                    if (data.status === 'success' && data.url) {
                        var relativeUrl = data.url;
                        if (appUrl && data.url.indexOf(appUrl) === 0) {
                            relativeUrl = data.url.replace(appUrl, '').replace(/^\/+/, '');
                        }
                        $('#picture').val(relativeUrl);
                        $('#croppic').css('background-image', 'url(' + data.url + ')');
                        toastr.success('{$_L['Uploaded Successfully']}');
                    } else {
                        toastr.error(data.message || 'Upload failed');
                    }
                },
                error: function () {
                    toastr.error('Upload failed');
                }
            });
        });


        var sysrender = $('#application_ajaxrender');




        sysrender.on('click', '#no_image', function(e){
            e.preventDefault();
            $('#picture').val('');

        });

        sysrender.on('click', '#more_submit', function(e){
            e.preventDefault();


            $('#ibox_form').block({ message: null });
            var _url = $("#_url").val();
            $.post(_url + 'contacts/edit-more/', {
                cid: $('#cid').val(),
                picture: $('#picture').val(),
                facebook: $('#facebook').val(),
                google: $('#google').val(),
                linkedin: $('#linkedin').val()

            })
            .done(function (data) {

                setTimeout(function () {
                    var sbutton = $("#more_submit");
                    var _url = $("#_url").val();
                    if ($.isNumeric(data)) {

                        window.location = _url + 'contacts/view/' + data + '/';
                    }
                    else {
                        $('#ibox_form').unblock();

                        $("#emsgbody").html(data);
                        $("#emsg").show("slow");
                    }
                }, 2000);
            });

        });


        $('.on_change_department').on('change',function () {
            let that = $(this);
            let id = that.attr('id');
            let status = 0;
            if(that.prop('checked'))
            {
                status = 1;
            }
            $.post(base_url + 'settings/set-user-ticket-department/', {
                department_id: id,
                user_id: {$d['id']},
                status: status,
            })
            .done(function (data) {
                toastr.success('{$_L['Updated']}');
            });
        });



    })

</script>


{/block}
