<?php
class Admin
{
    /**
     * retutn void
     */
    public static function isLogged()
    {
        if (isset($_COOKIE['ib_at'])) {
            $ib_at = $_COOKIE['ib_at'];

            if ($ib_at == '') {
                return;
            }

            $d = ORM::for_table('sys_users')
                ->where('autologin', $ib_at)
                ->first();

            if ($d) {
                global $_L, $file_build, $config;

                $after = route(2);
                $rd = U . $config['redirect_url'] . '/';

                if ($after != '') {
                    $after = str_replace('*', '/', $after);

                    $rd = U . $after . '/';
                }

                $_SESSION['uid'] = $d['id'];
                $d->last_login = date('Y-m-d H:i:s');
                $d->save();
                _log(
                    $_L['Login Successful'] . ' ' . $d->username,
                    'Admin',
                    $d->id
                );

                r2($rd);
            }
        }
    }

    public static function login($username, $password)
    {
        global $_L;

        if ($username != '' && $password != '') {
            $d = ORM::for_table('sys_users')
                ->where('username', $username)
                ->first();

            if ($d) {
                $d_pass = $d->password;
                if (Password::_verify($password, $d_pass) == true) {
                    Event::trigger('admin/login/_verified', $d->id);

                    $_SESSION['uid'] = $d->id;
                    $_SESSION['language'] = $d->language;
                    $d->last_login = date('Y-m-d H:i:s');

                    if(empty($d->autologin))
                    {
                        $str = Misc::random_string(20) . $d->id;
                    }
                    else{
                        $str = $d->autologin;
                    }

                    $d->autologin = $str;

                    $d->last_activity = date('Y-m-d H:i:s');

                    $d->save();
                    //login log

                    setcookie('ib_at', $str, time() + 86400 * 180, "/");

                    _log(
                        $_L['Login Successful'] . ' ' . $username,
                        'Admin',
                        $d['id']
                    );

                    setcookie("tplsub", 'default', time() + 15552000);

                    return true;
                }

                _msglog('e', $_L['Invalid Username or Password']);
                _log($_L['Failed Login'] . ' ' . $username, 'Admin');

                return false;
            }

            _msglog('e', $_L['Invalid Username or Password']);

            return false;
        }

        _msglog('e', $_L['Invalid Username or Password']);

        return false;
    }

     

    public static function loginv2($username, $password)
    {
        global $_L;

        if ($username != '' && $password != '') {
            $d = ORM::for_table('sys_users')
                ->where('username', $username)
                ->first();

            if ($d) {
                $d_pass = $d->password;
                if (Password::_verify($password, $d_pass) == true) {
                     
                    if($d->status == 'Inactive')
                    {
                        return array(
                            "condicion" => false,
                            "descripcion" => "bloqueado",
                        );
                    }

                    $systema_config_parnert = ORM::for_table('systema_config_parnert')->find_array()[0];
                     
                    //echo json_encode($systema_config_parnert); exit;

                    //si es 3 verifica si esta inactivo o la fecha expiro
                    if (in_array($systema_config_parnert["tipo_cobro"], [3]))
                    {
                        if($systema_config_parnert["estado_id"] == 2)
                        {
                            return array(
                                "condicion" => false,
                                "descripcion" => "inactivo",
                                
                            );
                        }

                        //$fecha_actual = date('Y-m-d');
                        //$fecha_sistema = $systema_config_parnert->fecha_final_demostracion;
                         
                    }
                     
                    if (in_array($systema_config_parnert["tipo_cobro"], [1,2]))
                    {

                        if($systema_config_parnert["estado_id"] == 2)
                        {
                            return array(
                                "condicion" => false,
                                "descripcion" => "inactivo",
                                
                            );
                        }
                        
                        $fecha_actual = strtotime(date('Y-m-d')); 
                        //$fecha_actual = strtotime("2024-06-04"); 
                        $fecha_sistema = strtotime($systema_config_parnert["fecha_final_demostracion"]);
                    
                        //echo $fecha_actual . " - " . $fecha_sistema; exit;

                        // Comparar las fechas
                        if ($fecha_actual >= $fecha_sistema) {
                            
                            /* return array(
                                "condicion" => false,
                                "descripcion" => "vencido",                    
                            ); */

                            $factura_maestra = ORM::for_table('factura_maestra')
                            ->where("estado_pago",1)
                            ->find_array();

                            //echo json_encode($factura_maestra); exit;
                                
                            if(count($factura_maestra) != 0)
                            {

                                foreach($factura_maestra as $item)
                                {

                                    

                                    if($item["fecha_maxima_pago"] != null && preg_match('/[1-9]/', $item["fecha_maxima_pago"]))
                                    {
                                        //$fecha_desde = date('Y-m-d', strtotime($item["periodo_hasta"] . " + $dias_posterios_pagos days"));
                                        $fecha_desde = date('Y-m-d', strtotime($item["fecha_maxima_pago"]));

                                        $fecha_actual = strtotime(date('Y-m-d')); 
                                        //$fecha_actual = strtotime("2024-08-04"); 
                                        $fecha_sistema = strtotime($fecha_desde);

                                        //echo $fecha_desde . "  -  " . date('Y-m-d'); exit;

                                        if ($fecha_actual >= $fecha_sistema)
                                        {
                                            return array(
                                                "condicion" => false,
                                                "descripcion" => "moroso",
                                            );
                                        } 
                                    }
                                                                                                                
                                }
                                
                            }
                        }  

                         

                         
                    }

                    //validacion de ips

                    $access_configuration = $d->access_configuration;
                    $miIdUsuarios = $d->id;
                    //$datosUsuarios = ORM::get_db()->query("SELECT * FROM sys_users where id = $miIdUsuarios")->fetch(PDO::FETCH_ASSOC);

                    //echo json_encode($datosUsuarios); exit;
                    //echo $access_configuration; exit;
                    
                    //echo getRealIP(); exit;

                    //3 es para que pase cualquier tipo de persona
                    //ip permitidas

                    //getRealIP()
                    $ipToCheck = getRealIP();

                    $datosCorreo = [
                        "correo" => $username,
                        "ip"     => $ipToCheck,
                    ];

                    if($access_configuration == 1)
                    {
                        $listado_ip = ORM::get_db()->query("SELECT * FROM authorized_ip_staff where staff_id = $miIdUsuarios AND tipo_bloqueo = 1 ")->fetchAll(PDO::FETCH_ASSOC);

                        if(count($listado_ip) != 0)
                        {
                            //echo "IP $ipToCheck is " . (isIpAllowed($ipToCheck, $listado_ip) ? 'allowed' : 'not allowed') . "\n"; exit;
                            
                            //la funcions isIpAllowed getRealIP estan en helpers/common_functions.php
                            if(isIpAllowed($ipToCheck, $listado_ip) == false)
                            {
                                enviarCorreoElectronicoLogin($datosCorreo);

                                return array(
                                    "condicion" => false,
                                    "descripcion" => "ip_invalida",
                                );
                            }

                        }

                        //echo json_encode($listado_ip); exit;

                    }

                    if($access_configuration == 2)
                    {

                        $listado_ip = ORM::get_db()->query("SELECT * FROM authorized_ip_staff where staff_id = $miIdUsuarios AND tipo_bloqueo = 2")->fetchAll(PDO::FETCH_ASSOC);

                        if(count($listado_ip) != 0)
                        {
                            //echo "IP $ipToCheck is " . (isIpAllowed($ipToCheck, $listado_ip) ? 'allowed' : 'not allowed') . "\n"; exit;
                            
                            //la funcions isIpAllowed getRealIP estan en helpers/common_functions.php
                            if(checkIpAccess($ipToCheck, $listado_ip) == true)
                            {
                                enviarCorreoElectronicoLogin($datosCorreo);

                                return array(
                                    "condicion" => false,
                                    "descripcion" => "ip_invalida",
                                );
                            }

                        }

                        //echo json_encode($listado_ip); exit;

                    }

                    //este es para configuracion de sistema
                    if($access_configuration == 4)
                    {
                        //para denegadas
                        $listado_ip = ORM::get_db()->query("SELECT * FROM authorized_ip_setting where tipo_bloqueo = 2 ")->fetchAll(PDO::FETCH_ASSOC);

                        if(count($listado_ip) != 0)
                        {
                            if(checkIpAccess($ipToCheck, $listado_ip) == true)
                            {
                                enviarCorreoElectronicoLogin($datosCorreo);

                                return array(
                                    "condicion" => false,
                                    "descripcion" => "ip_invalida",
                                );
                            }
                        }

                        //echo json_encode($listado_ip); exit;

                        $listado_ip_aprobadas = ORM::get_db()->query("SELECT * FROM authorized_ip_setting where tipo_bloqueo = 1 ")->fetchAll(PDO::FETCH_ASSOC);

                        if(count($listado_ip_aprobadas) != 0)
                        {
                            if(isIpAllowed($ipToCheck, $listado_ip_aprobadas) == false)
                            {
                                enviarCorreoElectronicoLogin($datosCorreo);

                                return array(
                                    "condicion" => false,
                                    "descripcion" => "ip_invalida",
                                );
                            }
                        }

                        //echo json_encode($listado_ip_aprobadas); exit;

                    }

                    Event::trigger('admin/login/_verified', $d->id);

                    $_SESSION['uid'] = $d->id;
                    $_SESSION['language'] = $d->language;
                    $d->last_login = date('Y-m-d H:i:s');

                    if(empty($d->autologin))
                    {
                        $str = Misc::random_string(20) . $d->id;
                    }
                    else{
                        $str = $d->autologin;
                    }

                    $d->autologin = $str;

                    $d->last_activity = date('Y-m-d H:i:s');

                    $d->save();
                    //login log

                    setcookie('ib_at', $str, time() + 86400 * 180, "/");

                    _log(
                        $_L['Login Successful'] . ' ' . $username,
                        'Admin',
                        $d['id']
                    );

                    setcookie("tplsub", 'default', time() + 15552000);

                    //return true;
                    return array(
                        "condicion" => true,
                        "descripcion" => "aprobado",
                    );
                }

                _msglog('e', $_L['Invalid Username or Password']);
                _log($_L['Failed Login'] . ' ' . $username, 'Admin');

                //return false;
                return array(
                    "condicion" => false,
                    "descripcion" => "invalido",
                );
            }

            _msglog('e', $_L['Invalid Username or Password']);

            //return false;
            return array(
                "condicion" => false,
                "descripcion" => "invalido",
            );
        }

        _msglog('e', $_L['Invalid Username or Password']);

        //return false;
        return array(
            "condicion" => false,
            "descripcion" => "invalido",
        );
    }

     
    
    /**
     * return void
     */
    public static function logout()
    {
        if (isset($_COOKIE['ib_at'])) {
            $ib_at = $_COOKIE['ib_at'];

            $d = ORM::for_table('sys_users')
                ->where('autologin', $ib_at)
                ->first();

            if ($d) {
                setcookie('ib_at', 'expired', 1, "/");

                $d->autologin = '';
                $d->save();
            }
        }
    }
}
