<?php
/*
|--------------------------------------------------------------------------
| Controller
|--------------------------------------------------------------------------
|
*/
 

if (!defined('APP_RUN')) {
    exit('No direct access allowed');
}

$route_controller_directory =
    $config['route_controller_directory'] ?? 'default';
$admin_controller_path =
    'system/controllers/' . $route_controller_directory . '/admin/admin.php';

    $ui->assign('APP_URL_ORIGINAL_SOCKET', APP_URL_ORIGINAL_SOCKET);
$ui->assign('ws_nombre_socket', ws_nombre_socket);
    $ui->assign('DB_NAME', DB_NAME);

    $ui->assign('url_setting_CRM_Parnerts_prepared', url_setting_CRM_Parnerts_prepared);

 
    
if (file_exists($admin_controller_path)) {
    require $admin_controller_path;
} else {
    $do = route(1);

    if ($do == '') {
        $do = 'login-display';
    }
   
    switch ($do) {
        case 'login-display':

            $billing_credit_card = ORM::for_table('billing_credit_card')
            ->where("estado_id",1)
            ->find_array();

            $total = ORM::for_table('factura_maestra')
            ->select("total")
            ->where("estado_pago",1) // pendientes solo este tipo de facturas
            ->sum('total');

            $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);

            // Verificar la conexión
            if ($mysqli->connect_errno) {
                //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
                $response = array(
                    "type" => "error",
                    "data" =>"Database connection failed" 
                );
                $mysqli->close();
                print_r(json_encode($response)) ; exit;
            }

            //$sys_pg = $mysqli->query("SELECT * FROM sys_pg WHERE status = 'Active' order by sorder ASC")->fetch_all(MYSQLI_ASSOC);

            $resConfiguracion = cargarConfiguracion();

            $aplicacion_id_square = "";
            $location_id_square = "";

            if($resConfiguracion["type"] == "success")
            {
                $aplicacion_id_square = $resConfiguracion["aplicacion_id_square"];
                $location_id_square   = $resConfiguracion["location_id_square"];
            }

            // "type" => "success",
            //"publishable_key_stripe" => $publishable_key_stripe,  
            //"secret_key_stripe"     => $secret_key_stripe,  
            //"currency_code_stripe"  => $currency_code_stripe,  
            //"payment_gateway"       => $payment_gateway,  
            //"aplicacion_id_square"  => $aplicacion_id_square,  
            //"location_id_square"    => $location_id_square,  
            //"version_square"        => $version_square,  
            //"token_square"          => $token_square,  
            //"url_square"            => $url_square,  

            \view('auth', [
                'type' => 'admin_auth',
                'data' => $billing_credit_card,            
                'total' => $total,   

                'aplicacion_id_square' => $aplicacion_id_square,   
                'location_id_square'   => $location_id_square,   
                //'sys_pg' => $sys_pg[0],         
            ]);

            break;

        case 'forgot-pw':

            $resConfiguracion = cargarConfiguracion();

            $aplicacion_id_square = "";
            $location_id_square = "";

            if($resConfiguracion["type"] == "success")
            {
                $aplicacion_id_square = $resConfiguracion["aplicacion_id_square"];
                $location_id_square   = $resConfiguracion["location_id_square"];
            }
            
            \view('auth', [
                'type' => 'admin_password_reset',

                'aplicacion_id_square' => $aplicacion_id_square,   
                'location_id_square'   => $location_id_square,   
            ]);

            break;

        case 'forgot-pw-post':
            $username = _post('username');
            $d = ORM::for_table('sys_users')
                ->where('username', $username)
                ->first();
            if ($d) {
                $xkey = _raid('10');
                $d->pwresetkey = $xkey;
                $d->keyexpire = time() + 3600;
                $d->save();
                $e = ORM::for_table('sys_email_templates')
                    ->where('tplname', 'Admin:Password Change Request')
                    ->first();
                $subject = new Template($e['subject']);
                $subject->set('business_name', $config['CompanyName']);
                $subj = $subject->output();
                $message = new Template($e['message']);
                $message->set('name', $d['fullname']);
                $message->set('business_name', $config['CompanyName']);
                $message->set(
                    'password_reset_link',
                    U . 'login/pwreset-validate/' . $d['id'] . '/token_' . $xkey
                );
                $message->set('username', $d['username']);
                $message->set('ip_address', $_SERVER["REMOTE_ADDR"]);
                $message_o = $message->output();

                Email::sendEmail(
                    $config,
                    $_L,
                    $d['fullname'],
                    $d['username'],
                    $subj,
                    $message_o
                );

                _msglog('s', $_L['Check your email to reset Password']);
                r2(U . 'login/');
            } else {
                _msglog('e', $_L['User Not Found'] . '!');
                r2(U . 'login/forgot-pw/');
            }

        break;

        case 'pwreset-validate':
            $v_uid = $routes['2'];
            $v_token = $routes['3'];
            $v_token = str_replace('token_', '', $v_token);
            $d = ORM::for_table('sys_users')->find($v_uid);
            if ($d) {
                $d_token = $d['pwresetkey'];
                if ($v_token != $d_token) {
                    r2(
                        U . 'login/',
                        'e',
                        $_L['Invalid Password Reset Key'] . '!'
                    );
                }

                $keyexpire = $d['keyexpire'];
                $ctime = time();
                if ($ctime > $keyexpire) {
                    r2(U . 'login/', 'e', $_L['Password Reset Key Expired']);
                }

                $password = _raid('6');
                $npassword = Password::_crypt($password);
                $d->password = $npassword;
                $d->pwresetkey = '';
                $d->keyexpire = '0';
                $d->save();
                $e = ORM::for_table('sys_email_templates')
                    ->where('tplname', 'Admin:New Password')
                    ->first();
                $subject = new Template($e['subject']);
                $subject->set('business_name', $config['CompanyName']);
                $subj = $subject->output();
                $message = new Template($e['message']);
                $message->set('name', $d['fullname']);
                $message->set('business_name', $config['CompanyName']);
                $message->set('login_url', U . 'login/');
                $message->set('username', $d['username']);
                $message->set('password', $password);
                $message_o = $message->output();

                Email::sendEmail(
                    $config,
                    $_L,
                    $d['fullname'],
                    $d['username'],
                    $subj,
                    $message_o
                );

                _msglog('s', $_L['Check your email to reset Password'] . '.');
                r2(U . 'login/');
            }

        break;

        case 'where':
            r2(U . 'login');
            break;

        case 'after':
            $after = route(2);
            $ui->assign('after', $after);

            $billing_credit_card = ORM::for_table('billing_credit_card')
            ->where("estado_id",1)
            ->find_array();

            $total = ORM::for_table('factura_maestra')
            ->select("total")
            ->where("estado_pago",1) // pendientes solo este tipo de facturas
            ->sum('total');

            $mysqli = new mysqli(DB_HOST, DB_USER,DB_PASSWORD, DB_NAME);

            // Verificar la conexión
            if ($mysqli->connect_errno) {
                //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
                $response = array(
                    "type" => "error",
                    "data" =>"Database connection failed" 
                );
                $mysqli->close();
                print_r(json_encode($response)) ; exit;
            }

            $resConfiguracion = cargarConfiguracion();

            $aplicacion_id_square = "";
            $location_id_square = "";

            if($resConfiguracion["type"] == "success")
            {
                $aplicacion_id_square = $resConfiguracion["aplicacion_id_square"];
                $location_id_square   = $resConfiguracion["location_id_square"];
            }

            //$sys_pg = $mysqli->query("SELECT * FROM sys_pg WHERE status = 'Active' order by sorder ASC")->fetch_all(MYSQLI_ASSOC);

            \view('auth', [
                'type' => 'admin_auth',
                'data' => $billing_credit_card,            
                'total' => $total,     

                'aplicacion_id_square' => $aplicacion_id_square,   
                'location_id_square'   => $location_id_square, 
                //'sys_pg' => $sys_pg[0],         
            ]);

        break;

        default:
            
            $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);

            // Verificar la conexión
            if ($mysqli->connect_errno) {
                //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
                $response = array(
                    "type" => "error",
                    "data" =>"Database connection failed" 
                );
                $mysqli->close();
                print_r(json_encode($response)) ; exit;
            }

            //$sys_pg = $mysqli->query("SELECT * FROM sys_pg WHERE status = 'Active' order by sorder ASC")->fetch_all(MYSQLI_ASSOC);

            $billing_credit_card = ORM::for_table('billing_credit_card')
            ->where("estado_id",1)
            ->find_array();

            $total = ORM::for_table('factura_maestra')
            ->select("total")
            ->where("estado_pago",1) // pendientes solo este tipo de facturas
            ->sum('total');

            $resConfiguracion = cargarConfiguracion();

            $aplicacion_id_square = "";
            $location_id_square = "";

            if($resConfiguracion["type"] == "success")
            {
                $aplicacion_id_square = $resConfiguracion["aplicacion_id_square"];
                $location_id_square   = $resConfiguracion["location_id_square"];
            }

            \view('auth', [
                'type' => 'admin_auth',
                'data' => $billing_credit_card,            
                'total' => $total,     

                'aplicacion_id_square' => $aplicacion_id_square,   
                'location_id_square'   => $location_id_square, 
                //'sys_pg' => $sys_pg[0],   
            ]);

            //\view('auth', [
            //    'type' => 'admin_auth',
            //]);
            break;
    }
}


function cargarConfiguracion()
{
    $url_base = rtrim(URL_CPANEL_ADMIN, "/");
    $url = $url_base . '/parnerts/configuracion-stripe-parnert';

    // Datos que se enviarán en el FormData
    $data = [
        'contenido' => json_encode([
            'item' => [
                'UUID' => UUID,
                'UUID_ENC' => UUID_ENC,
                'IGP_ID' => IGP_ID
            ]
        ])
    ];

    // Inicializar cURL
    $ch = curl_init();

    // Configurar las opciones de cURL
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true); // Método POST
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data)); // Enviar los datos como FormData
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Para obtener la respuesta
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded' // Tipo de contenido para FormData
    ]);

    // Ejecutar la solicitud
    $response = curl_exec($ch);
 
    //echo $response; exit;

    $salida = [];

    // Verificar si hubo errores
    if (curl_errno($ch)) {
        //echo 'Error en cURL: ' . curl_error($ch);
        $response = array(
            "type" => "error",
            "data" => "Error bringing more detailed information:"  . curl_error($ch)
        );
        curl_close($ch);
        //print_r(json_encode( $response)) ; exit;
        return $response; 

    } else {
        // Decodificar la respuesta JSON
        $responseData = json_decode($response, true);

        // Verificar si el JSON se decodificó correctamente
        if ($responseData === null) {
            //echo 'Error al decodificar la respuesta JSON';
            $response = array(
                "type" => "error",
                "data" => "Error decoding JSON response"  
            );
            curl_close($ch);
            //print_r(json_encode( $response)) ; exit;
            return $response; 

        } else {

            // Determinar qué datos almacenar según el valor de error
            if (isset($responseData['errorResponse']['error']) && $responseData['errorResponse']['error'] === true) {
                // Si hay error, almacenar el título como variable de error
                $errorMessage = $responseData['errorResponse']['titulo'] ?? 'Error desconocido';
                //echo "Error: " . $errorMessage;

                $response = array(
                    "type" => "error",
                    "data" => $errorMessage  
                );
                curl_close($ch);
               
                //print_r(json_encode( $response)) ; exit;
                return $response; 

            } else {

                // Si no hay error, almacenar los datos de contenido en variables
                $publishable_key_stripe = $responseData['contenido']['publishable_key_stripe'] ?? null;
                $secret_key_stripe      = $responseData['contenido']['secret_key_stripe'] ?? null;
                $currency_code_stripe   = $responseData['contenido']['currency_code_stripe'] ?? null;
                $payment_gateway        = $responseData['contenido']['payment_gateway'] ?? null;
                $aplicacion_id_square   = $responseData['contenido']['aplicacion_id_square'] ?? null;
                $location_id_square     = $responseData['contenido']['location_id_square'] ?? null;
                $version_square         = $responseData['contenido']['version_square'] ?? null;
                $token_square           = $responseData['contenido']['token_square'] ?? null;
                $url_square             = $responseData['contenido']['url_square'] ?? null;

                $response = array(
                    "type" => "success",
                    "data" => "",  
                    "publishable_key_stripe" => $publishable_key_stripe,  
                    "secret_key_stripe"     => $secret_key_stripe,  
                    "currency_code_stripe"  => $currency_code_stripe,  
                    "payment_gateway"       => $payment_gateway,  
                    "aplicacion_id_square"  => $aplicacion_id_square,  
                    "location_id_square"    => $location_id_square,  
                    "version_square"        => $version_square,  
                    "token_square"          => $token_square,  
                    "url_square"            => $url_square,  
                );
 
                curl_close($ch);
                
                return $response; 

                //print_r(json_encode( $response)) ; exit;

                //$ui->assign('aplicacion_id_square', $aplicacion_id_square); 
                //$ui->assign('location_id_square', $location_id_square); 

                //echo $location_id_square; exit;
                
                //"aplicacion_id_square"   => $resultado_configuracion->aplicacion_id_square,
                //"location_id_square"     => $resultado_configuracion->location_id_square,
                //"version_square"         => $resultado_configuracion->version_square,
                //"token_square"           => $resultado_configuracion->token_square,
                //"url_square"             => $resultado_configuracion->url_square,
              
            }
        }
    }

    // Cerrar la sesión de cURL
    //curl_close($ch);
}