<?php

/*
|--------------------------------------------------------------------------
| Controller
|--------------------------------------------------------------------------
|
*/

_auth();
$action = route('1', 'contacts');
$action = strtolower($action);

header('Content-type: application/json');

$ui->assign('url_ir_chat_crm', U . "social/chat-crm");
$ui->assign('url_base_plantilla_admintpl', U);
$ui->assign('APP_URL_ORIGINAL_SOCKET', APP_URL_ORIGINAL_SOCKET);
$ui->assign('ws_nombre_socket', ws_nombre_socket);
$ui->assign('url_setting_CRM_Parnerts_prepared', url_setting_CRM_Parnerts_prepared);

$ruta_segundaria = route(1);
$armado_ruta = "";

if(empty($ruta_segundaria) == true )
{
    $armado_ruta = route(0);
}else{
    $armado_ruta = route(0) . "/" . route(1);
}

//$ui->assign('sin_ruta', $armado_ruta);
$ui->assign('sin_ruta', _get('ng'));


if(empty($_SESSION['menu_categorias_user']) == false)
{
    $ui->assign('menu_categorias_user', $_SESSION['menu_categorias_user']);
}


$app->emit('json/' . $action);

switch ($action) {
    case 'customer':
    case 'customers':
        $contacts = ORM::for_table('crm_accounts')
            ->select('id')
            ->select('account', 'text')
            ->select('email')
            ->find_array();

        echo json_encode($contacts);

        break;

    case 'invoice':
    case 'invoices':
        $invoices = ORM::for_table('sys_invoices')
            ->select('id')
            ->select('invoicenum')
            ->select('account')
            ->select('total')
            ->find_array();

        $x = 0;
        $val = [];
        foreach ($invoices as $invoice) {
            $val[$x]['id'] = $invoice['id'];
            $val[$x]['text'] =
                $invoice['invoicenum'] .
                $invoice['id'] .
                ' ' .
                $invoice['account'];
            $x++;
        }

        echo json_encode($val);

        break;

    case 'lead':
    case 'leads':
        $leads = ORM::for_table('crm_leads')
            ->select('first_name')
            ->select('middle_name')
            ->select('last_name')
            ->select('company')
            ->select('email')
            ->select('phone')
            ->select('id')
            ->find_array();

        $x = 0;
        $val = [];
        foreach ($leads as $lead) {
            $val[$x]['id'] = $lead['id'];
            $val[$x]['text'] =
                $lead['first_name'] .
                ' ' .
                $lead['middle_name'] .
                ' ' .
                $lead['last_name'] .
                ($lead['company'] != '' ? ' (' . $lead['company'] . ' )' : '');
            $x++;
        }

        echo json_encode($val);

        break;

    case 'quote':
    case 'quotes':
        $quotes = ORM::for_table('sys_quotes')
            ->select('subject')
            ->select('account')
            ->select('id')
            ->select('companyname')
            ->find_array();

        $x = 0;
        $val = [];
        foreach ($quotes as $quote) {
            $val[$x]['id'] = $quote['id'];
            $val[$x]['text'] =
                $quote['account'] .
                ' - ' .
                $quote['subject'] .
                ($quote['companyname'] != ''
                    ? ' (' . $quote['companyname'] . ' )'
                    : '');
            $x++;
        }

        echo json_encode($val);

        break;
}
