<?php
use Illuminate\Database\Eloquent\Model;

class Parnert extends Model
{
    protected $table = 'crm_parnerts';

    /**
     * @return array
     */
    public static function asArray()
    {
        return Parnert::all()
        ->keyBy('id')
        ->toArray();
    }

    /**
     * @return mixed
     */
    public static function getAllContacts()
    {
        return Parnert::select(['id', 'account', 'email', 'phone', 'company'])
        ->orderBy('id', 'desc')
        ->get();
    }

//Crear nuevos directorios completos
public function full_copy( $source, $target ) {
    if ( is_dir( $source ) ) {
        $d = dir( $source );
        while ( FALSE !== ( $entry = $d->read() ) ) {
            if ( $entry == '.' || $entry == '..' ) {
                continue;
            }
            $Entry = $source . '/' . $entry; 
            if ( is_dir( $Entry ) ) {
                full_copy( $Entry, $target . '/' . $entry );
                continue;
            }
            copy( $Entry, $target . '/' . $entry );
        }
 
        $d->close();
    }else {
        copy( $source, $target );
    }
}

}
