
{extends file="$layouts_admin"}

{block name="head"}

<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.6.2/css/buttons.dataTables.min.css" />

{/block}


{block name="content"}
<div class="row">

    <div class="col-md-2">
        <div class="card">
            <div class="card-body p-3">
                <h5>{__('Filter')}</h5>

                <div class="mb-3">
                    <label for="select_group_id">{__('Group')}</label>
                    <select class="form-select" id="select_group_id" name="group_id">
                        <option value="0">{__('None')}</option>
                        {foreach $groups as $group}
                        <option value="{$group->id}" {if $group->id == $group_id}selected{/if}>{$group->gname}</option>
                        {/foreach}
                    </select>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-10">
        <div class="panel">

            <input type="text" hidden class="tener_directorio" value="{$APP_DIRECTORIO}"  disabled  >
            <input type="text" hidden class="tener_url_base" value="{$url_base}"  disabled  >

            <div class="panel-hdr">
                {if $type == 'supplier'}
                <h2>{$_L['List Suppliers']}</h2>
                {else}
                <h2>List Clients</h2>
                {/if}

                <div class="panel-toolbar">
                    <div class="btn-group">

                        {if $type == 'supplier'}
                        <a href="{$_url}contacts/add/supplier" class="btn btn-sm btn-success"> {$_L['Add Supplier']}</a>
                        {else}
                        <a href="{$_url}contacts/add/" class="btn btn-sm btn-success"> Add Client </a>
                        {/if}
                        <a href="{$_url}contacts/import_csv/" class="btn btn-sm btn-warning"> {$_L['Import']}</a>
                    </div>



                </div>
            </div>


            <div class="panel-container show">


                <div id="filtercam">
                  <table id="filter" style="border-bottom: none;" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th style="width: 6%;"></th>
                        <th>{$_L['Name']}</th>
                        <th>{$_L['Code']}</th>
                        <th>Company Name</th>
                        <th>{$_L['Email']}</th>
                        <th>{$_L['Phone']}</th>
                        <th>{$_L['Address']}</th>
                    </tr>
                </thead>

                <tbody>
                  <tr >
                    <td></td>
                    <td><div class="form-group">
                      <input type="text" class="form-control column_filter" id="col1_filter" data-column="1" placeholder="{$_L['Name']}">
                  </div></td>
                  <td>
                    <div class="form-group">
                        <input type="text" class="form-control column_filter" id="col2_filter" data-column="2" placeholder="{$_L['Code']}">
                    </div>
                  </td>
                  <td>
                    <div class="form-group">
                        <input type="text" class="form-control column_filter" id="col3_filter" data-column="3" placeholder="Company Name">
                    </div>
                  </td>
                  <td><div class="form-group">
                      <input type="text" class="form-control column_filter" id="col5_filter" data-column="5" placeholder="{$_L['Email']}">
                  </div></td>
                  <td><div class="form-group">
                      <input type="text" class="form-control column_filter" id="col6_filter" data-column="6" placeholder="{$_L['Phone']}">
                  </div></td>                
                  <td><div class="form-group">
                      <input type="text" class="form-control column_filter" id="col7_filter" data-column="7" placeholder="{$_L['Address']}">
                  </div></td>    
              </tr>
          </tbody>
      </table>
  </div>

  <div class="panel-content">
    <div class="table-responsive" id="ib_data_panel">


        <table class="table w-100"  id="clx_datatable">
            <thead
            {if empty($config['admin_dark_theme'])}
            style="background: #f0f2ff"

            {/if}
            >
            <tr class="heading">
                <th></th>
                <th>{$_L['Name']}</th>
                <th>{$_L['Code']}</th>
                <th>{$_L['Company Name']}</th>
                <th>{$_L['Group']}</th>
                <th>{$_L['Email']}</th>
                <th>{$_L['Phone']}</th>
                <th>{$_L['Address']}</th>
                <th class="text-end" style="width: 80px;">{$_L['Manage']}</th>
            </tr>


        </thead>


        <tbody>

        </tbody>


    </table>
</div>
</div>


</div>
</div>
</div>

</div>
{/block}

{block name="script"}

<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.2/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.2/js/buttons.html5.min.js"></script>


<script>
    $(function() {

        $(document).ready(function(e) {
          $('#filtercam').hide();
          $('#clx_datatable_filter').append('<button class="btn btn-primary" id="addfilter">Advanced Filters</button>');
      });
        //Tabla de filtros//
        var wp_filter = $("#filter").DataTable({
           searching: false,
           paging: false,
           ordering:  false,
           responsive: {
              details: {
                type: 'column'
            }
        },
        columnDefs: [ {
          className: 'control',
          orderable: false,
          targets:   0
      } ],
        autoWidth: true,
        bProcessing: false,
        bServerSide: false,
        bInfo: false,
    });

//Funcion para buscar datos por columnas//
        function filterColumn (i) {
           wp_table
           .columns( i )
           .search($('#col'+i+'_filter').val(), true, false)
           .draw();
       }
       $('input.column_filter').on( 'keyup', function () {
          var data=$(this).data('column');
          filterColumn($(this).data('column'));
      } );
//Funcion abrir seccion filtros //
       $(document).on('click', '#addfilter', function(e){
          $('#filtercam').show();
          $("#addfilter").remove();
          $('#clx_datatable_filter').append('<button class="btn btn-danger" id="closefilter">Close</button>');
      });
//Funcion cerrar seccion filtros//
       $(document).on('click', '#closefilter', function(e){
          $('#filtercam').hide();
          $("#closefilter").remove();
          $('#clx_datatable_filter').append(' <button class="btn btn-primary" id="addfilter">Advanced Filters</button>');
      });

//Table//
       var wp_table = $("#clx_datatable").DataTable({
        dom:

        "<'row mb-3'<'col-sm-12 col-md-6 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-6 d-flex align-items-center justify-content-end'lB>>" +
        "<'row'<'col-sm-12'tr>>" +
        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        buttons: [
        {
            extend: 'pdfHtml5',
            text: 'PDF',
            titleAttr: 'Generate PDF',
            className: 'btn-danger-light btn-sm mr-1'
        },
        {
            extend: 'excelHtml5',
            text: 'Excel',
            titleAttr: 'Generate Excel',
            className: 'btn-success-light btn-sm mr-1'
        },
        {
            extend: 'csvHtml5',
            text: 'CSV',
            titleAttr: 'Generate CSV',
            className: 'btn-primary-light btn-sm mr-1'
        },
        {
            extend: 'copyHtml5',
            text: 'Copy',
            titleAttr: 'Copy to clipboard',
            className: 'btn-info-light btn-sm mr-1'
        },
        {
            extend: 'print',
            text: 'Print',
            titleAttr: 'Print Table',
            className: 'btn-secondary-light btn-sm'
        }
        ],
        "language": {
            "emptyTable": "{$_L['No items to display']}",
            "info":      "{$_L['Showing _START_ to _END_ of _TOTAL_ entries']}",
            "infoEmpty":      "{$_L['Showing 0 to 0 of 0 entries']}",
            buttons: {
                pageLength: '{$_L['Show all']}'
            },
            searchPlaceholder: "{__('Search')}"
        },

        responsive: {
            details: {
              type: 'column'
          }
      },
      columnDefs: [ {
        className: 'control',
        orderable: false,
        targets:   0
    } ],
      //order: [ 1, 'asc' ],
      autoWidth: true,
      bProcessing: false,
      bServerSide: false,
      bInfo: false,


      columns: [

        { data: 'id' , render: function(data, type, row){
            return cel(data, row.id);
        }},
        { data: 'id' , render: function(data, type, row){
            return img_table(data, row.account);
        }},
        { data: 'id' , render: function(data, type, row){
            return code(data,row.code);
        }},
        { data: 'company' },
        { data: 'gname' },
        { data: 'email' },
        { data: 'phone' },
        { data: 'address' },
        { data: 'id', render: function(data, type, row){
            return actions(data);
        }},
        ],
  });



//Function to consult client data and fill table//
       function dataTable_init() {
        var url = window.location.href;
        var url2=window.location.pathname;
        var url = url.split(url2);
        var urld=url[1].replace("list", "data_table");


        let directorio = $(".tener_directorio").val();
        let tener_url_base = $(".tener_url_base").val();

        //console.log("tener_url_base");
        //console.log(tener_url_base + "contacts/data_table");

        //console.log('/'+directorio+'/'+urld);
        //'/'+directorio+'/'+urld

        $.post(tener_url_base + "contacts/data_table")
        .done(function(resp){
           wp_table = $("#clx_datatable").DataTable();
           wp_table.clear();
           $.each(resp.datos, function (k, v) {
            wp_table.row.add(v);
        });
           wp_table.draw();
           wp_table.columns.adjust().responsive.recalc();
       }).fail( function(jqXHR, textStatus, errorThrown) {


       });
   }
   dataTable_init();


//Empty field for responsive//
   function cel(wpid, wpactive) {
      actions_cell = '';
      return actions_cell;
  }
//Empty field for responsive//
  function img_table(wpid, account) {
      actions_cell = '<a class="h6" href="{$_url}contacts/view/'+wpid+'"><strong>'+account+'</strong></a>';
      return actions_cell;
  }
//Empty field for responsive//
  function code(wpid, code) {
      if (code === null || code === "") {
          actions_cell = '<a class="h6" href="{$_url}contacts/view/'+wpid+'"><strong>N/A</strong></a>';
      }else{
          actions_cell = '<a class="h6" href="{$_url}contacts/view/'+wpid+'"><strong>'+code+'</strong></a>';
      }
      return actions_cell;
  }
//function for action buttons//
  function actions(wpid) {

      let x="'contacts/delete/"+wpid+"'";
      actions_cell = '<div class="float-end d-flex"><a href="{$_url}contacts/view/'+wpid+'" class="btn btn-secondary-light btn-icon waves-effect waves-themed has-tooltip me-2" data-bs-toggle="tooltip" title="{$_L['View']}" data-placement="top"><i class="fal fa-user-alt"></i> </a> <a href="{$_url}contacts/view/'+wpid+'/edit/" class="btn btn-secondary-light btn-icon waves-effect waves-themed has-tooltip me-2" data-bs-toggle="tooltip" title="{$_L['Edit']}" data-placement="top"><i class="fal fa-pencil"></i> </a> <a href="#" onclick="confirmThenGoToUrl(event,'+x+')"  class="btn btn-secondary-light btn-icon waves-effect waves-themed has-tooltip me-2" data-bs-toggle="tooltip" title="{$_L['Delete']}" data-placement="top"><i class="fal fa-trash-alt"></i> </a></div>';
      return actions_cell;
  }


  const select_group_id = document.getElementById('select_group_id');

  if(select_group_id)
  {
    select_group_id.addEventListener('change', function() {
        let group_id = this.value;
        window.location.href = "{$base_url}contacts/list/customer/" + group_id;
    });
}

});
</script>
{/block}
