{extends file="$layouts_admin"}
{block name="head"}




{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

</style>
<div class="row">

    <div class="col-md-12">

        <div class="panel">
            <div class="panel-hdr">
                <h2><span></span>Add Payment Method</h2>
            </div>

            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">

                    <h4>By creating this payment method it will become active in use to pay system subscription</h4>
                    </br>

                    <div class="px-2">
                        <div class="alert alert-danger" id="emsg" style="display: none;">
                            <span id="emsgbody"></span>
                        </div>

                        <div class="alert alert-success" id="emsgSuccess" style="display: none;">
                            <span id="emsgbodySuccess"></span>
                        </div>

                        <form id="rform">

                            <div class="row">

                                <div class="col-md-6 col-sm-12">

                                    <div class="mb-3 row">
                                        <label for="card_name" class="col-sm-3"><span class="h6">Card Name</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">
                                            <input type="text" id="card_name" name="card_name" class="form-control tenercard_name" autofocus>
                                        </div>
                                    </div>
           
                                   <div class="mb-3 row">
                                        <label for="card_number" class="col-sm-3"><span class="h6">Card Number</span> </label>
                                        <div class="col-sm-9">
                                            <input type="text" id="card_number" name="card_number" class="form-control tenercard_number">
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <label for="estado" class="col-sm-3"><span class="h6">State</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">
                                            <select id="estado" name="estado" class="form-control tenerestado" >
                                                <option value="1" selected>Activo</option>
                                                <option value="2">Inactivo</option>
                                            </select>
                                        </div>
                                    </div>
 
                                </div>


                                <div class="col-md-6 col-sm-12">
                                    <div class="mb-3 row">
                                        <label for="ccv_code" class="col-sm-3"><span class="h6">CCV code</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">
                                            <input type="text" id="ccv_code" name="ccv_code" class="form-control tenerccv_code" autofocus>
                                        </div>
                                    </div>


                                    <div class="mb-3 row">
                                        <label for="address" class="col-sm-3"><span class="h6">{$_L['Address']}</span><span class="text-danger">*</span> </label>
                                        <div class="col-sm-9">
                                            <input type="text" autocomplete="off"  id="address" name="address" class="form-control teneraddress">                                        
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <label for="cobro_automatico" class="col-sm-3"><span class="h6">Automatic Collection</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">
                                            <input type="checkbox" id="cobro_automatico" name="cobro_automatico" class="tenercobro_automatico" checked >
                                        </div>
                                    </div>

     
                                </div>
 
                           
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="mb-3">


                                        <button class="btn btn-primary mt-3 me-3" type="submit" id="submit">{$_L['Save']}</button>


                                    </div>
                                </div>
                            </div>


                        </form>
                    </div>

                </div>



            </div>
        </div>
    </div>
</div>




{/block}

{block name="script"}
<script>


    $(document).ready(function () {

       
        $(".progress").hide();
        $("#emsg").hide();
        $("#emsgSuccess").hide();
        var _url = '{$_url}';
        
        var $cid = $('#cid');
        $cid.select2();

        $country = $("#country");

        $country.select2();
  
        $("#submit").click(function (e) {
            e.preventDefault();
    
            $('#ibox_form').block({ message:block_msg });

            $("#emsg").hide();
            $("#emsgSuccess").hide();

            //console.log(base_url + 'parnerts/add-parnert-post/');
            //console.log($( "#rform" ).serialize());

            var informacionEnviar = {
                card_name: $(".tenercard_name").val(),
                ccv_code:     $(".tenerccv_code").val(),
                address:      $(".teneraddress").val(),
                card_number:  $(".tenercard_number").val(),
                state:        $(".tenerestado").val(),
                cobro_automatico:  $('.tenercobro_automatico').is(':checked'),
            };
             
            /* console.log(JSON.stringify(informacionEnviar));
            return;
            */

            $.post(base_url + 'system/payment-method-post/', JSON.stringify(informacionEnviar)  ) //$( "#rform" ).serialize()
            .done(function (data) {

                var sbutton = $("#submit");
                if ($.isNumeric(data)) {

                    //window.location = base_url + 'parnerts/list_parnert/' + data;
                    window.location = base_url + 'parnerts/list_parnert';

                }
                else {

                    //console.log(data);
                    /* console.log(data);
                    return; */

                     try {
                         const info = JSON.parse(data);
                       
                        if( info.type == "success")
                        {
                            $('#ibox_form').unblock();

                            toastr.success(info.message);

                            /* var body = $("html, body");
                            body.animate({ scrollTop:0 }, '1000', 'swing'); 
                            $("#emsgbodySuccess").html(info.message);
                            $("#emsgSuccess").show("slow"); */

                            window.location = info.redirect;

                            $(".tenercard_name").val("");
                            $(".tenerccv_code").val("");
                            $(".teneraddress").val("");
                            $(".tenercard_number").val("");
                            $(".tenerestado").val("");

                        }else{
                            $('#ibox_form').unblock();
                            var body = $("html, body");
                            body.animate({ scrollTop:0 }, '1000', 'swing');
                            $("#emsgbody").html(info.message);
                            $("#emsg").show("slow");
                        }
                    } catch (error) {
                        $('#ibox_form').unblock();
                        var body = $("html, body");
                        body.animate({ scrollTop:0 }, '1000', 'swing');
                        $("#emsgbody").html(data);
                        $("#emsg").show("slow");
                    }
 
                }
            });
        });


    });

 
function serach_address(address,secundary,option = 1) {

  var country = $('#country').val();
  let x=address.trim();
  if (x.length > 2 && country === "United States") {
    var settings = {
      "url": "https://us-autocomplete-pro.api.smarty.com/lookup?key=188805315395749398&search="+address+"&selected="+secundary+"&include_only_cities=&include_only_states=&include_only_zip_codes=&exclude_states=&prefer_cities=&prefer_states=&prefer_zip_codes=&source=all",
      "method": "GET",
      "timeout": 0,
      "headers": {
        "Host": "us-autocomplete-pro.api.smarty.com",
        "Referer": "https://hispanosdeexitollc.com"
    },
};

$('#browsers').html('');
$('#browsers').show();

$.ajax(settings).done(function (response) {

  $.each(response.suggestions, function (k, v) {
    let text=v.street_line+' '+v.secondary+' '+v.card_number+', '+v.state+' '+v.zipcode;
    let line=v.street_line+' '+v.secondary+' ('+v.entries+') '+v.card_number+', '+v.state+' '+v.zipcode;
    let line2=v.street_line+' '+v.secondary;
    let entries=(v.entries > 1) ? '<a href="#" data-data1="'+line+'" data-data2="'+line2+'" class="addresssec"><span class="badge bg-primary rounded-pill">+ '+v.entries+' Address</span></a>' : "" ;
    let option='<li class="list-group-item d-flex justify-content-between align-items-start "><div class="ms-2 me-auto address1" data-data1="'+v.card_number+'" data-data2="'+v.state+'" data-data3="'+v.zipcode+'" data-data4="'+v.street_line+' '+v.secondary+'"><div class="fw-bold">'+text+'</div></div>'+entries+'</li>';
    $('#browsers').append(option);
    x++;
});
});
}
}


$("input[name='address']").on('input', function(e){
  var address = $(this).val();
  var country = $('#country').val();
  let x=address.trim();
  if (x.length > 2 && country === "United States") {
    address = address.replace(/,/g, "");
    address = address.replace(/ /g, "+");
    address = address.replace(/#/g, "%23");
    serach_address(address,"",1);    
}
});


$(document).on('click', '.address1', function(e){
    e.preventDefault();
    $('#card_number').val($(this).data('data1'));
    $('#state').val($(this).data('data2'));
    $('#zip').val($(this).data('data3'));
    $('#address').val($(this).data('data4'));
    $('#browsers').hide();

});


$(document).on('click', '.addresssec', function(e){
    e.preventDefault();
    let address=$(this).data('data2');
    $('#address').val(address);
    let secundary=$(this).data('data1');
    secundary = secundary.replace(/,/g, "");
    secundary = secundary.replace(/ /g, "+");
    secundary = secundary.replace(/#/g, "%23");
    address = address.replace(/,/g, "");
    address = address.replace(/ /g, "+");
    address = address.replace(/#/g, "%23");
    serach_address(address,secundary,2);
});

</script>
{/block}