{extends file="$layouts_admin"}
{block name="head"}

 

<link
  href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
  rel="stylesheet"
/>


{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    .swal2-container {
         z-index: 9999;
      }

.wrapper {
  overflow: hidden;  
}

ul.breadcrumbs {
  margin: 0;
  padding: 0;
  display: flex; /* Cambiar a flex para un mejor ajuste en pantallas pequeñas */
  flex-wrap: wrap; /* Permitir que los elementos se ajusten en múltiples líneas si es necesario */
  justify-content:center;
}

ul.breadcrumbs li {
  position: relative;
  margin: 0;
  padding: 0;
  list-style: none;
  display: inline-block;
  border-left: 1px solid #ccc;
  transition: 0.3s ease;
}

ul.breadcrumbs li:hover:before {
  /* border-left: 10px solid #5e6e82; */
}

ul.breadcrumbs li:hover a {
  /* color: white;
  background: #5e6e82; */
 
}

ul.breadcrumbs li:before {
  content: "";
  position: absolute;
  right: -9px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 20;
  border-left: 10px solid #fff;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
  transition: 0.3s ease;
}

ul.breadcrumbs li:after {
  content: "";
  position: absolute;
  right: -10px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 10;
  border-left: 10px solid #ccc;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
}

ul.breadcrumbs li.active {
  background: #5e6e82; /* Fondo para el activo */
}

ul.breadcrumbs li.active a {
  color: white !important; /* Color del texto activo */
  padding: 0 15px 0 25px; /* Ajustar el padding */
  background: #5e6e82;
}

ul.breadcrumbs li.first {
  border-left: none;
}

ul.breadcrumbs li.first a {
  font-size: 18px;
  padding-left: 20px;
  border-radius: 5px 0px 0px 5px;
}

ul.breadcrumbs li.last:before {
  display: none;
}

ul.breadcrumbs li.last:after {
  display: none;
}

ul.breadcrumbs li.last a {
  padding-right: 20px;
  border-radius: 0px 40px 40px 0px;
}

ul.breadcrumbs li a {
  display: block;
  font-size: 12px;
  line-height: 40px;
  color: #757575;
  padding: 0px 15px 0px 25px;
  text-decoration: none;
  background: #fff;
  border: 1px solid #ddd;
  white-space: nowrap; /* Evitar que el texto se envuelva */
  overflow: hidden;
  transition: 0.3s ease;
}

ul.breadcrumbs li.active:before {
  display: block; /* Mostrar el triángulo en el activo */
}

ul.breadcrumbs li.active:after {
  display: block; /* Mostrar el triángulo secundario en el activo */
}

@media (max-width: 768px) {
  ul.breadcrumbs {
    flex-direction: column; /* Cambiar a una columna en pantallas más pequeñas */
  }

  ul.breadcrumbs li {
    border-left: none; /* Eliminar el borde izquierdo en pantallas pequeñas */
    margin-bottom: 5px; /* Espaciado entre elementos */
    margin-right: 10px;
  }
}
ul.breadcrumbs li.active:before {
  border-left: 10px solid #5e6e82; /* Cambia el color del triángulo al hacer hover sobre el activo */
}

.cursor_manito {
  cursor: pointer;
}

table.estilosTabla > :not(caption) > * > * {
        /*
        padding-top: 5px !important;
        padding-bottom: 5px !important;
        */
    }

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
   }

   .btn-edit {
         margin-bottom: 4px; 
         background-color: #001b3b; 
         color: white; 
         border: 1px solid rgb(211, 202, 192) !important; 
         box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
         float: inline-end;
    }

   .btn-eliminar {
      margin-bottom: 4px;
      background-color: red;
      color: white;
      border: 1px solid rgb(211, 202, 192) !important;
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
      float: inline-end;
    }

   .btn-edit:hover i,
   .btn-eliminar:hover i {
      color: white; /* Mantén el color blanco del icono en hover */
   }

   .tamano-icono{
      font-size:small;
   }
    
   .centrar-botones{
      text-align: center;
      justify-content: center;
      display: flex;
      padding: 0px;
   }

   .btn-edit-aval {
         margin-bottom: 4px; 
         background-color: #001b3b; 
         color: white; 
         border: 1px solid rgb(211, 202, 192) !important; 
         box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
         float: inline-end;
    }

   .btn-eliminar-aval {
      margin-bottom: 4px;
      background-color: red;
      color: white;
      border: 1px solid rgb(211, 202, 192) !important;
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
      float: inline-end;
    }

   .btn-edit-aval:hover i,
   .btn-eliminar-aval:hover i {
      color: white; /* Mantén el color blanco del icono en hover */
   }

 
</style>

    <input
         type="text"
         value="{$url_base}"
         disabled
         hidden
         id="URL_BASE"
    />

    <input
         type="text"
         value="{$id_user}"
         disabled
         hidden
         id="ID_USER"
    />

 
<div class="row">

   <div class="col-12 col-lg-12 col-sm-12 col-md-12">

    <div class="col-md-12">

        <div class="panel">
            <div class="panel-hdr">
                <h2>Payment plans</h2>
                
                <div class="panel-toolbar">
                    <div class="btn-group">
                        <button class="btn btn-sm btn-default waves-effect waves-themed add_plan">New Plan</button>
                     </div>
                </div>
            </div>

            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">

                    <div class="px-2">
                        
                        <div class="row">

                           <div class="col-12 col-sm-12 pt-4">

                              <div class="table-responsive">
                                  <table class="table table-striped table-hover mt-3 estilosTabla"  id="clx_datatable_referencia_personal">
                                      <thead>
                                          <tr>
                                                <th class="centrar">Payment plan name</th>
                                                <th class="centrar">Rate</th>
                                                <th class="centrar">Interest on late payment</th>
                                                <th class="centrar">Payment term</th>
                                                <th class="centrar">State</th>
                                                <th class="centrar">Payment method</th>
                                          </tr>
                                      </thead>

                                      <tbody class="tbody_envios">
                                          <tr>
                                                <td colspan="6" class="centrar"  style='text-align: center;'>No information</td>
                                          </tr>
                                      </tbody>

                                  </table>
                              </div>

                           </div>

                        </div>
                       
                    </div>

                  

                </div>
 
       
            </div>
        </div>
    </div>
 

      <div
         class="modal fade"
         id="modalMensaje"
         data-bs-backdrop="static"
         data-bs-keyboard="false"
         tabindex="-1"
         aria-labelledby="staticBackdropLabel"
         aria-hidden="true"
      >
         <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
               <div class="modal-header">
                  <h5 class="modal-title modal_titulo_mensaje" id="staticBackdropLabel">
                     Group Message
                  </h5>
                  <button
                     type="button"
                     class="btn-close btn_cerrar_confirmacion_modal"
                  ></button>
               </div>
               <div class="modal-body text-center">
                  <p class="modal_contenido_mensaje">
                     The group advertising campaign has been sent. For more
                  </p>
               </div>
            </div>
         </div>
      </div>

{**}
<div class="modal fade" id="addModalPlanes" tabindex="-1" aria-labelledby="exampleModalLabel_" aria-hidden="true"  data-bs-backdrop="static">
   <div class="modal-dialog modal-lg modal-dialog-centered" style="width: 97%; max-width:97%;">
      <div class="modal-content" style="background-color:white">
         <div class="modal-header">
         <h5 class="modal-title" id="exampleModalLabel_">Define payment plan</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
         </div>
         <div class="modal-body" style="background-color:white;border-radius:10px">
          
            <div class="row">
               <div class="col-md-12">
                  <div class="panel-container show" id="ibox_form">
                           <div class="panel-content">
                              <div class="px-2">
                                    <div class="alert alert-danger" id="emsg" style="display: none;">
                                       <span id="emsgbody"></span>
                                    </div>

                                      <input type="text" id="id" name="id" class="form-control id" disabled hidden/>
                                   
                                       <div class="row">

                                          <div class="col-md-12 col-sm-12">
                                                <div class="mb-3 row">
                                                   <label for="plan_nombre" class="col-sm-3"><span class="h6">Plan name</span><span class="text-danger">*</span></label>
                                                   <div class="col-sm-9">
                                                      <input type="text" id="plan_nombre" name="plan_nombre" class="form-control plan_nombre" autofocus >
                                                   </div>
                                                </div>
                                          </div>

                                          <div class="col-md-12 col-sm-12">
                                                <div class="mb-3 row">
                                                   <label for="plazo_meses" class="col-sm-3"><span class="h6">Payment term</span><span class="text-danger">*</span></label>
                                                   <div class="col-sm-9">
                                                      <input type="number" id="plazo_meses" name="plazo_meses" class="form-control plazo_meses" autofocus >
                                                   </div>
                                                </div>
                                          </div>

                                          <div class="col-md-12 col-sm-12">
                                                <div class="mb-3 row">
                                                   <label for="tasa_interes" class="col-sm-3"><span class="h6">Interest rate</span><span class="text-danger">*</span></label>
                                                   <div class="col-sm-9">
                                                      <div class="input-group mb-3">
                                                         <input
                                                            class="form-control tasa_interes"
                                                            type="number"
                                                            id="tasa_interes"
                                                            name="tasa_interes"
                                                         /><span class="input-group-text" >%</span>
                                                      </div>
                                                   </div>
                                                </div>
                                          </div>

                                          <div class="col-md-12 col-sm-12">
                                                <div class="mb-3 row">
                                                   <label for="manejo_mora" class="col-sm-3"><span class="h6">Blackberry management</span><span class="text-danger">*</span></label>
                                                   <div class="col-sm-9">
                                                      <select id="manejo_mora" name="manejo_mora" class="form-select manejo_mora">
                                                            <option value="" selected="" disabled="">Select a Option</option>
                                                            <option value="1">Per Day</option>
                                                            <option value="2">Per Months</option>
                                                      </select>
                                                   </div>
                                                </div>
                                          </div>

                                          <div class="col-md-12 col-sm-12">
                                                <div class="mb-3 row">
                                                   <label for="interes_por_mora" class="col-sm-3"><span class="h6">Interest on late payment</span><span class="text-danger">*</span></label>
                                                   <div class="col-sm-9">
                                                      <div class="input-group mb-3">
                                                         <input
                                                            class="form-control interes_por_mora"
                                                            type="number"
                                                            id="interes_por_mora"
                                                            name="interes_por_mora"
                                                         /><span class="input-group-text" >%</span>
                                                      </div>
                                                   </div>
                                                </div>
                                          </div>

                                          <div class="col-md-12 col-sm-12">
                                                <div class="mb-3 row">
                                                   <label for="monto_maximo" class="col-sm-3"><span class="h6">Maximum amount</span><span class="text-danger">*</span></label>
                                                   <div class="col-sm-9">
                                                      <input type="number" id="monto_maximo" name="monto_maximo" class="form-control monto_maximo" >
                                                   </div>
                                                </div>
                                          </div>

                                          <div class="col-md-12 col-sm-12">
                                                <div class="mb-3 row">
                                                   <label for="monto_minimo" class="col-sm-3"><span class="h6">Minimum amount</span><span class="text-danger">*</span></label>
                                                   <div class="col-sm-9">
                                                      <input type="number" id="monto_minimo" name="monto_minimo" class="form-control monto_minimo" >
                                                   </div>
                                                </div>
                                          </div>

                                          <div class="col-md-12 col-sm-12">
                                                <div class="mb-3 row">
                                                   <label for="modalidad_cobro" class="col-sm-3"><span class="h6">Payment method</span><span class="text-danger">*</span></label>
                                                   <div class="col-sm-9">
                                                      <select id="modalidad_cobro" name="modalidad_cobro" class="form-select modalidad_cobro">
                                                            <option value="" selected="" disabled="">Select a Option</option>
                                                            <option value="1">Weekly</option>
                                                            <option value="2">Fortnightly</option>
                                                            <option value="3">Monthly</option>
                                                      </select>
                                                   </div>
                                                </div>
                                          </div>

                                          <div class="col-md-12 col-sm-12">
                                                <div class="mb-3 row">
                                                   <label for="activo" class="col-sm-3"><span class="h6">State</span><span class="text-danger">*</span></label>
                                                   <div class="col-sm-9">
                                                      <select id="activo" name="activo" class="form-select activo">
                                                            <option value="" selected="" disabled="">Select a Option</option>
                                                            <option value="1">Active</option>
                                                            <option value="2">Inactive</option>
                                                      </select>
                                                   </div>
                                                </div>
                                          </div>
                                    
                                       </div>
                                        
                                       <div class="row">
                                          <div class="col-md-12">
                                                <div class="mb-3" style="float: inline-end;">
  
                                                      <button class="btn btn-primary mt-3 cambiar_texto_botones" type="button" id="guardar_modal_planes" style="float: inline-end;">Add</button>

                                                      <button class="btn btn-primary mt-3 loading_modal_planes" style="display: none;" disabled>
                                                         <div style="display: flex; align-items: center">
                                                            <span
                                                            class="spinner-border spinner-border-sm"
                                                            style="height: 20px; width: 20px; margin-right: 5px"
                                                            role="status"
                                                            aria-hidden="true"
                                                            ></span>
                                                            <span class="cambiar_texto_botones">Add</span>
                                                             
                                                         </div>
                                                      </button>
                                                
                                                </div>
                                          </div>
                                       </div>
                              
                              </div>
                           </div>
                        </div>
               </div>
            </div>
          
         </div>
         
      </div>
   </div>
</div>
 

<div class="modal fade" id="ventana_confirmacion" tabindex="-1" aria-labelledby="exampleModalLabel__ventanaconfirmacion" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false" >
   <div class="modal-dialog modal-dialog-centered"  >
      <div class="modal-content" style="background-color:white">
         <div class="modal-header">
         <h3 class="titulo_modal_confirmar">Estas seguro de eliminar</h3>
            <button type="button" class="btn-close "  id="btn_close_ventana_confirmacion" ></button>
         </div>
         <div class="modal-body" style="background-color:white;border-radius:10px">
          
            <div class="row">
               <div class="col-md-12">
                  <div class="panel-container show" id="ibox_form">
                           <div class="panel-content">
                              <div class="px-2">
                                    <div class="alert alert-danger" id="emsg" style="display: none;">
                                       <span id="emsgbody"></span>
                                    </div>
                                    <input class="tipo_modal_confirmar" hidden disabled/> 
                                    <input class="data_id" hidden disabled/> 
                                    <div class="row">
                                          <div class="col-md-12 col-sm-12">

                                                <h4 class="mensaje_modal_confirmar" style="text-align:center; color:black">Estas seguro de eliminar</h4>
                                                 
                                                 <p class="mensaje_espera_moda_confirmacion mt-3" style="text-align:center; color:red; font-weight:600">Espere mientras termina el proceso</p>
                                          </div>
                                     
                                       </div>

                                       <div class="row mt-2">
                                          <div class="col-md-12">
                                                <div  style="float: inline-end;" >

                                                  
                                                   <button class="btn me-2" type="button" id="btn_cerrar_ventana_confirmacion" style=" background: #001b3b; ">close</button>
                                                   <button class="btn " type="button" id="btn_aplicar_ventana_confirmacion" style=" background: red; ">Remove</button>
                                              
                                                    
                                                </div>
                                          </div>
                                       </div>
                              </div>
                           </div>
                        </div>
               </div>
            </div>
          
         </div>
         
      </div>
   </div>
</div>

 
{/block}

{block name="script"}

{literal}
<script>

   var URL_BASE = $("#URL_BASE").val();
   var ID_USER = $("#ID_USER").val();
   var url_dashboard = $("#url_dashboard").val();
   var roll_id = $("#roll_id").val();

   var COLOR_FONDO_VENTANA_CERRAR = "#001b3b";
   var COLOR_TEXT_VENTANA_CERRAR = "white";

   var COLOR_FONDO_VENTANA_CONFIRMACION = "red";
   var COLOR_TEXT_VENTANA_CONFIRMACION = "white";

   var arreglo_planes = [
      //{
      //   id: 1,
      //   plan_nombre: "Plan regular",
      //   plazo_meses: "10",
      //   manejo_mora: "5",
      //   interes_por_mora: "5",
      //   monto_maximo: "5",
      //   monto_minimo: "5",
      //   modalidad_cobro: "5",
      //}
   ];

 
   $(document).ready(function () {

      cargarPrincipal();
 
      $(".progress").hide();
      $("#emsg").hide();
      $("#emsgSuccess").hide();

      var _url = '{$_url}';
 
      $('#submit_modal_confirmacion_correo').on('click', function() {
         window.location = url_dashboard;    
      });

      $('.add_plan').on('click', function() {

         $(".id").val("");
         $(".plan_nombre").val("");
         $(".plazo_meses").val("");
         $(".manejo_mora").val("");
         $(".interes_por_mora").val("");
         $(".tasa_interes").val("");
         
         $(".monto_maximo").val("");
         $(".monto_minimo").val("");
         $(".modalidad_cobro").val("");
         $(".activo").val("");
         $(".cambiar_texto_botones").text("Add");
 
         $("#addModalPlanes").modal("show");
      });

 
      $('#guardar_modal_planes').on('click', function() {
  
         let id = $(".id").val();

         //console.log("id");
         //console.log(id); 

         let plan_nombre = $(".plan_nombre").val();

         if(isEmpty(plan_nombre))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.plan_nombre');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Define payment plan" the field "Plan name" is required.');
            return;
         }

         let plazo_meses = $(".plazo_meses").val();

         if(isEmpty(plazo_meses))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.plazo_meses');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Define payment plan" the field "Payment term" is required.');
            return;
         }

         let tasa_interes = $(".tasa_interes").val();

         if(isEmpty(tasa_interes))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.tasa_interes');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Define payment plan" the field "Interest rate" is required.');
            return;
         }

         let manejo_mora = $(".manejo_mora").val();

         if(isEmpty(manejo_mora))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.manejo_mora');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Define payment plan" the field "Blackberry management" is required.');
            return;
         }

         let interes_por_mora = $(".interes_por_mora").val();

         if(isEmpty(interes_por_mora))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.interes_por_mora');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Define payment plan" the field "Interest on late payment" is required.');
            return;
         }

         let monto_maximo = $(".monto_maximo").val();

         if(isEmpty(monto_maximo))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.monto_maximo');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Define payment plan" the field "Maximum amount" is required.');
            return;
         }

         let monto_minimo = $(".monto_minimo").val();

         if(isEmpty(monto_minimo))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.monto_minimo');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Define payment plan" the field "Minimum amount" is required.');
            return;
         }

         let modalidad_cobro = $(".modalidad_cobro").val();

         if(isEmpty(modalidad_cobro))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.modalidad_cobro');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Define payment plan" the field "Payment method" is required.');
            return;
         }

         let activo = $(".activo").val();

         if(isEmpty(activo))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.activo');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Define payment plan" the field "State" is required.');
            return;
         }
 
         let validacionCaracteres = validatePaymentPlanFields();

         if(validacionCaracteres == true){
            return;
         }

         let periodo_modalidad_cobro = 0;

         //Semana equivale a 52 semanas al año
         if(modalidad_cobro == 1)
         {
            periodo_modalidad_cobro = 52;
         }

         //Quincena equivale a 26 quincenas al año
         if(modalidad_cobro == 2)
         {
            periodo_modalidad_cobro = 24;
         }

         //Mensual equivale a 12 meses al año
         if(modalidad_cobro == 3)
         {
            periodo_modalidad_cobro = 12;
         }

         let informacionFrontend = {
            id:               id,
            plan_nombre: plan_nombre,
            plazo_meses:      plazo_meses,
            tasa_interes:     tasa_interes,
            manejo_mora:      manejo_mora,
            interes_por_mora:        interes_por_mora,
            monto_maximo:            monto_maximo,
            monto_minimo:            monto_minimo,
            modalidad_cobro:            modalidad_cobro,
            periodo_modalidad_cobro:            periodo_modalidad_cobro,
            activo:            activo,

            descripcion_activo: (activo == 1) ? "Active" : "Inactive",
         };
          
         console.log(JSON.stringify(informacionFrontend));
         //return;


         $('.plan_nombre, .plazo_meses, .manejo_mora, .interes_por_mora, .tasa_interes, .monto_maximo, .monto_minimo, .modalidad_cobro, .activo ').prop('disabled', true);
         $('.loading_modal_planes').css('display', '');
         $('#guardar_modal_planes').css('display', 'none');
 
         //{
         //   id: 1,
         //   nombre_plan_pago: "Plan regular",
         //   tasas: "10",
         //   meses: "5",
         //}
         
         //let plan_nombre = $(".plan_nombre").val();
         //let plazo_meses = $(".plazo_meses").val();
         //let manejo_mora = $(".manejo_mora").val();
         //let interes_por_mora = $(".interes_por_mora").val();
         //let monto_maximo = $(".monto_maximo").val();
         //let monto_minimo = $(".monto_minimo").val();
         //let modalidad_cobro = $(".modalidad_cobro").val();

         if(isEmpty(id) == true)
         {

            $.ajax({
               type: "POST",
               url: URL_BASE + "credit/post-payment-plans",
               data: JSON.stringify(informacionFrontend), // Convertir datos a formato JSON
               contentType: "application/json", // Tipo de contenido JSON
               success: function (response) {

                  $('.plan_nombre, .plazo_meses, .manejo_mora, .interes_por_mora, .tasa_interes, .monto_maximo, .monto_minimo, .modalidad_cobro, .activo').prop('disabled', false);
                  $('.loading_modal_planes').css('display', 'none');
                  $('#guardar_modal_planes').css('display', '');
                  
                  //console.log("Respuesta del servidor:", response);
                  // Hacer algo con la respuesta del servidor
      
                  try {
                     let info = JSON.parse(response);

                     if (info.type == "success") {

                        let data = info.data || [];

                        console.log("data");
                        console.log(data);

                        informacionFrontend.id = info.ultimo_id; 

                        
                        arreglo_planes.push(informacionFrontend);

                        $(".tbody_envios").html(tabla_html_planes(arreglo_planes));
                        eventosTablaPlanes();
                        
                        $("#addModalPlanes").modal("hide");

                        ventanaRegistroExito("Record added", "¡The record was added successfully!");
                        

                     } else if (info.type == "error") {
                        //Swal.fire({
                        //   icon: "error",
                        //   title: "Oops...",
                        //   text: info.message,
                        //});

                        ventanaError("Opps there was an error", info.message);

                     }
                  } catch (error) {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: error,
                     //});

                     ventanaError("Opps there was an error.", error);
                  }
               },
               error: function (xhr, status, error) {
                  console.error("Error en la solicitud:", error);
                  // Manejar errores aquí
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error.", error);

                  $('.plan_nombre, .plazo_meses, .manejo_mora, .interes_por_mora, .tasa_interes, .monto_maximo, .monto_minimo, .modalidad_cobro, .activo').prop('disabled', false);
                  $('.loading_modal_planes').css('display', 'none');
                  $('#guardar_modal_planes').css('display', '');

               },
            });

 
         }else{
            //cuando es editar

            $.ajax({
               type: "POST",
               url: URL_BASE + "credit/post-payment-plans",
               data: JSON.stringify(informacionFrontend), // Convertir datos a formato JSON
               contentType: "application/json", // Tipo de contenido JSON
               success: function (response) {

                  $('.plan_nombre, .plazo_meses, .manejo_mora, .interes_por_mora, .tasa_interes, .monto_maximo, .monto_minimo, .modalidad_cobro, .activo').prop('disabled', false);
                  $('.loading_modal_planes').css('display', 'none');
                  $('#guardar_modal_planes').css('display', '');
                  
                  //console.log("Respuesta del servidor:", response);
                  // Hacer algo con la respuesta del servidor
      
                  try {
                     let info = JSON.parse(response);

                     if (info.type == "success") {

                        let data = info.data || [];

                        console.log("data");
                        console.log(data);

                        let BusquedadInformacion = arreglo_planes.find(function(item) {
                           return item.id == id;
                        });

                        if(isEmpty(BusquedadInformacion) == false)
                        {
            
                           BusquedadInformacion.plan_nombre = plan_nombre; 
                           BusquedadInformacion.plazo_meses = plazo_meses; 
                           BusquedadInformacion.tasa_interes = tasa_interes; 
                           BusquedadInformacion.manejo_mora = manejo_mora; 
                           BusquedadInformacion.interes_por_mora = interes_por_mora; 
                           BusquedadInformacion.monto_maximo = monto_maximo; 
                           BusquedadInformacion.monto_minimo = monto_minimo; 
                           BusquedadInformacion.modalidad_cobro = modalidad_cobro; 
                           BusquedadInformacion.activo = activo; 
                           BusquedadInformacion.descripcion_activo = (activo == 1) ? "Active" : "Inactive"; 
                            
                           $(".tbody_envios").html(tabla_html_planes(arreglo_planes));
                           eventosTablaPlanes();

                           $("#addModalPlanes").modal("hide");

                           ventanaRegistroExito("Record added", "¡the record was successfully modified!");

                        }
                        

                     } else if (info.type == "error") {
                        //Swal.fire({
                        //   icon: "error",
                        //   title: "Oops...",
                        //   text: info.message,
                        //});

                        ventanaError("Opps there was an error", info.message);
                     }
                  } catch (error) {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: error,
                     //});

                     ventanaError("Opps there was an error", error);
                  }
               },
               error: function (xhr, status, error) {
                  console.error("Error en la solicitud:", error);
                  // Manejar errores aquí
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);

                  $('.plan_nombre, .plazo_meses, .manejo_mora, .interes_por_mora, .tasa_interes, .monto_maximo, .monto_minimo, .modalidad_cobro, .activo').prop('disabled', false);
                  $('.loading_modal_planes').css('display', 'none');
                  $('#guardar_modal_planes').css('display', '');

               },
            });
 
         }
 

      });

      $("#btn_aplicar_ventana_confirmacion").off("click")
      .on("click", function () {

         console.log("se dio click");

            $('#btn_aplicar_ventana_confirmacion').prop('disabled', true);
            $('#btn_close_ventana_confirmacion').prop('disabled', true);
            $('#btn_cerrar_ventana_confirmacion').prop('disabled', true);

            $(".mensaje_espera_moda_confirmacion").text("Please wait while the process finishes...");
             

            let opcion_predefinida = $(".tipo_modal_confirmar").val();
            let data_id = $(".data_id").val();

            if(opcion_predefinida == "eliminar_plan")
            {

               let informacionFrontend = {
                  id: data_id,
               };

               $.ajax({
                  type: "POST",
                  url: URL_BASE + "credit/post-inactive-payment-plans",
                  data: JSON.stringify(informacionFrontend), // Convertir datos a formato JSON
                  contentType: "application/json", // Tipo de contenido JSON
                  success: function (response) {

                     $('.plan_nombre, .plazo_meses, .manejo_mora, .interes_por_mora, .monto_maximo, .monto_minimo, .modalidad_cobro, .activo').prop('disabled', false);
                     $('.loading_modal_planes').css('display', 'none');
                     $('#guardar_modal_planes').css('display', '');
                     
                     //console.log("Respuesta del servidor:", response);
                     // Hacer algo con la respuesta del servidor
         
                     try {
                        let info = JSON.parse(response);

                        if (info.type == "success") {

                           let data = info.data || [];

                           console.log("data");
                           console.log(data);

                           let BusquedadInformacion = arreglo_planes.find(function(item) {
                              return item.id == data_id;
                           });

                           if(isEmpty(BusquedadInformacion) == false)
                           {
                              BusquedadInformacion.activo = 2;
                              BusquedadInformacion.descripcion_activo = "Inactive";

                              $(".tbody_envios").html(tabla_html_planes(arreglo_planes));
                              eventosTablaPlanes();

                              $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
                              $('#btn_close_ventana_confirmacion').prop('disabled', false);
                              $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
                              
                              //$("#ventana_confirmacion").modal("hide");

                              ventanaRegistroExito("Record inactive", "¡Registration has been successfully deactivated!");

                           }
                           

                        } else if (info.type == "error") {
                           //Swal.fire({
                           //   icon: "error",
                           //   title: "Oops...",
                           //   text: info.message,
                           //});

                           ventanaError("Opps there was an error", info.message);
                        }
                     } catch (error) {
                        //Swal.fire({
                        //   icon: "error",
                        //   title: "Oops...",
                        //   text: error,
                        //});

                        ventanaError("Opps there was an error", error);
                     }
                  },
                  error: function (xhr, status, error) {
                     console.error("Error en la solicitud:", error);
                     // Manejar errores aquí
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: error,
                     //});

                     ventanaError("Opps there was an error", error);

                     $('.plan_nombre, .plazo_meses, .manejo_mora, .interes_por_mora, .monto_maximo, .monto_minimo, .modalidad_cobro, .activo').prop('disabled', false);
                     $('.loading_modal_planes').css('display', 'none');
                     $('#guardar_modal_planes').css('display', '');

                  },
               });

 
            }
 
       
      });

      $("#btn_cerrar_ventana_confirmacion").off("click")
      .on("click", function () {
         
         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         $("#ventana_confirmacion").modal("hide");
       
      });

      $("#btn_close_ventana_confirmacion").off("click")
      .on("click", function () {

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         
         $("#ventana_confirmacion").modal("hide");
       
      });
 
 
      $('.btn_cerrar_confirmacion_modal').click(function() {
         $("#modalMensaje").modal("hide");
      });

      $('.abrir_modal_contacto').click(function() {
         $("#modal_asignar_clientes_contactos").modal("show");
      });

      $('.back').click(function() {
         window.location = URL_BASE + "credit/new-prospecting";
      });

      $('.guardar_siguiente').click(function() {

         
         window.location = URL_BASE + "credit/supporting-document-prospecting/UUID_ENCRIPTION";
         return;

         $('input, select, button, textarea').prop('disabled', true);

         $('.nombre_completo_ig, .correo_electronico_ig, .telefono_ig, .grupo_ig').prop('disabled', false);

         $('.loading_guardar_siguiente').css('display', '');
         $('.guardar_siguiente').css('display', 'none');
 
         let motivo_prestamo_li = $(".motivo_prestamo_li").val();

         if(isEmpty(motivo_prestamo_li))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.motivo_prestamo_li');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Loan information" the field "Reason for the loan" is required.');
            return;
         }

         let validacionCaracteres = validateFormFields();

         if(validacionCaracteres == true)
         {
            return;
         }
 
         $("#emsg").hide();
         $("#emsgSuccess").hide();
 
         //$("#submit").prop("disabled", true); // Deshabilitar el botón

         //customer_id_ig
         //grupo_id_ig
             
         var informacionEnviar = {
             customer_id_ig:                 customer_id_ig,
             grupo_id_ig:                    grupo_id_ig,

             tipo_identificacion_ig:         tipo_identificacion_ig,
             numero_identificacion_ig:       numero_identificacion_ig,
             sex_aci:                        sex_aci,
             fecha_nacimiento_aci:           fecha_nacimiento_aci,
             estado_civil_aci:               estado_civil_aci,
             numero_identificacion_hi:       numero_identificacion_hi,
             tipo_residencial_hi:            tipo_residencial_hi,
             tiempo_residir_hi:              tiempo_residir_hi,
             numero_dependiente_economico_hi:   numero_dependiente_economico_hi,
             ocupacion_economica_ei:            ocupacion_economica_ei,
             lugar_trabajo_ei:                  lugar_trabajo_ei,
             tiempo_laborando_ei:               tiempo_laborando_ei,
             ingreso_mensual_aproximado_ei:     ingreso_mensual_aproximado_ei,
             otros_ingresos_mensuales_ei:       otros_ingresos_mensuales_ei,
             gastos_mensaules_aproximados_ei:   gastos_mensaules_aproximados_ei,
             valor_monto_solicitado_li:         valor_monto_solicitado_li,
             motivo_prestamo_li:                motivo_prestamo_li,
            
         }; 

         console.log(JSON.stringify(informacionEnviar));
         //console.log("return aqui abajo")
         //return;

         //return;

         $.post(URL_BASE + 'forms/post-new-forms/', JSON.stringify(informacionEnviar)  ) //$( "#rform" ).serialize()
         .done(function (data) {

               $("#submit").prop("disabled", false); // Deshabilitar el botón
                
                   //console.log(data);
                   //console.log(data);
                   //return;

                   //$(".bloqueo_v1").attr("hidden", true);
                   //$(".bloqueo_v2").attr("hidden", true);
                   //$(".bloqueo_v3").attr("hidden", true);

                    try {
                       
                       const info = JSON.parse(data);
                      
                       if( info.type == "success")
                       {
                           toastr.success(info.message);

                           if(tenerPreguntaEnviarCorreo == 1)
                           {
                               $(".modal_correo").val(tenerCorreoElectronico);
                               $(".modal_codigo_acceso").val(tenerAccessCode);
                               $(".modal_codigo_verificacion").val(tenerVerificationCode);

                               let url_access = info.url_formulario_IRS;

                               $(".url_access").attr("href", url_access).find("span").text(url_access);

                               $("#modalFormIRS").modal("show");
                           }else{
                               window.location = info.redirect;    
                           }
 
                       }else{
                           //$('#ibox_form').unblock();
                           var body = $("html, body");
                           body.animate({ scrollTop:0 }, '1000', 'swing');
                           $("#emsgbody").html(info.message);
                           $("#emsg").show("slow");
                       }
                   } catch (error) {
                       //$('#ibox_form').unblock();
                       var body = $("html, body");
                       body.animate({ scrollTop:0 }, '1000', 'swing');
                       $("#emsgbody").html(data);
                       $("#emsg").show("slow");
                   }
         });

      });
 

   });

   function cargarPrincipal()
   {

      $.ajax({
         type: "POST",
         url: URL_BASE + "credit/get-list-payment-plans",
         contentType: "application/json", // Tipo de contenido JSON
         success: function (response) {
            
            //console.log("Respuesta del servidor:", response);
            // Hacer algo con la respuesta del servidor
   
            try {
               let info = JSON.parse(response);

               if (info.type == "success") {

                  let data = info.data || [];

                  console.log("data");
                  console.log(data);

                  arreglo_planes = data;

                  if(arreglo_planes.length == 0)
                  {
                     $(".tbody_envios").html("<tr> <td colspan='6' class='centrar' style='text-align: center;'>No information</td> </tr>");
                  }else{
                     $(".tbody_envios").html(tabla_html_planes(arreglo_planes));
                     eventosTablaPlanes();
                  }

                   
                  
               } else if (info.type == "error") {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: info.message,
                  //});

                  ventanaError("Opps there was an error", info.message);
               }
            } catch (error) {
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);
            }
         },
         error: function (xhr, status, error) {
            console.error("Error en la solicitud:", error);
            // Manejar errores aquí
            //Swal.fire({
            //   icon: "error",
            //   title: "Oops...",
            //   text: error,
            //});

            ventanaError("Opps there was an error", error);

         },
      });

       
 
   }

   function eventosTablaPlanes()
   {

      $('.btn-edit').off('click');
      $('.btn-eliminar').off('click');

      $('.btn-edit').on('click', function() {
         var dataId = $(this).data('id');
         console.log('ID de la referencia:', dataId);
        
         let BusquedadInformacion = arreglo_planes.find(function(item) {
            return item.id == dataId;
         });

         if(isEmpty(BusquedadInformacion) == false)
         {
            $(".id").val(dataId);
 
            $(".plan_nombre").val(BusquedadInformacion.plan_nombre);
            $(".plazo_meses").val(BusquedadInformacion.plazo_meses);
            $(".tasa_interes").val(BusquedadInformacion.tasa_interes);
            $(".manejo_mora").val(BusquedadInformacion.manejo_mora);
            $(".interes_por_mora").val(BusquedadInformacion.interes_por_mora);
            $(".monto_maximo").val(BusquedadInformacion.monto_maximo);
            $(".monto_minimo").val(BusquedadInformacion.monto_minimo);
            $(".modalidad_cobro").val(BusquedadInformacion.modalidad_cobro);
            $(".activo").val(BusquedadInformacion.activo);

            $(".cambiar_texto_botones").text("Modify");
            

            $("#addModalPlanes").modal("show");
         }

      });

      $('.btn-eliminar').on('click', function() {
         var dataId = $(this).data('id');
         console.log('ID de la referencia:', dataId);
        
         $(".titulo_modal_confirmar").text("You are sure?");
         $(".mensaje_modal_confirmar").text("This record will not be deleted, it will become inactive.");
         $(".mensaje_espera_moda_confirmacion").text("");
         $(".tipo_modal_confirmar").val("eliminar_plan");
         $(".data_id").val(dataId);

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);

         //ventanaRegistroExito("Record deleted", "The record has been successfully deleted");
         //return;
          
         $('#btn_cerrar_ventana_confirmacion').css({
            'background-color': COLOR_FONDO_VENTANA_CERRAR,
            'color': COLOR_TEXT_VENTANA_CERRAR,
            'display': "",
            
         });

         $('#btn_aplicar_ventana_confirmacion').css({
            'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
            'color': COLOR_TEXT_VENTANA_CONFIRMACION,
            'display': "",
         });
 
         $("#ventana_confirmacion").modal("show");

         //$('#clx_datatable_referencia_personal tbody tr').each(function() {
         //      var rowDataId = $(this).find('.btn-eliminar').data('id');
         //      if (rowDataId == dataId) {
         //         $(this).remove(); // Elimina la fila que coincide con el data-id
         //      }
         //});
    

      });
   }
 
   function ventanaRegistroExito(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
       
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }

   function ventanaError(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }

   function isEmpty(value) {
       // Verificar si es null o undefined
       if (value == null) return true;

       // Verificar si es una cadena vacía
       if (typeof value === "string" && value.trim() === "") return true;

       // Verificar si es un array vacío
       if (Array.isArray(value) && value.length === 0) return true;

       // Verificar si es un objeto vacío
       if (typeof value === "object" && Object.keys(value).length === 0) return true;

       return false;
   }
 
   function validarSoloNumeros(input) {
       const number = parseInt(input, 10);
       return !isNaN(number) && number.toString() === input;
   }

   function validateEmail(email) {
      // Expresión regular para validar un formato de correo electrónico
      var emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
      
      if (emailPattern.test(email)) {
         return true;  // Es un correo válido
      } else {
         return false;  // No es un correo válido
      }
   }
 
   function tabla_html_planes(arreglo) {
      let html = "";
      
      arreglo.forEach(function (element) {
         let {
            id,
            plan_nombre,
            plazo_meses,
            tasa_interes,
            manejo_mora,
            interes_por_mora,
            monto_maximo,
            monto_minimo,
            modalidad_cobro,
            descripcion_activo,
            descripcion_modalidad_cobro,
         } = element;

        
 
 
         html +=
               "<tr>" +
               "<td class='centrar'>" + plan_nombre + "</td>" +
               "<td class='centrar'>" + tasa_interes + "%</td>" +
               "<td class='centrar'>" + interes_por_mora + "%</td>" +
               "<td class='centrar'>" + plazo_meses + "</td>" +
               "<td class='centrar'>" + descripcion_activo + "</td>" +
               "<td class='centrar'>" + descripcion_modalidad_cobro + "</td>" +
     
               "<td class='centrar'>" +
               "<div class='row'>" +
               "<div class='col-12 centrar-botones'>" +
               "<button class='btn btn-sm btn-edit waves-effect waves-themed' data-id='" + id + "'>" +
               "<i class='fas fa-pencil-square tamano-icono' aria-hidden='true'></i>" +
               "</button>" +
               "<button class='btn btn-sm btn-eliminar waves-effect waves-themed' data-id='" + id + "'>" +
               "<i class='fas fa-trash tamano-icono' aria-hidden='true'></i>" +
               "</button>" +
               "</div>" +
               "</div>" +
               "</td>" +

               "</tr>";
      });

      return html;
   }
 
 
   function validatePaymentPlanFields() {
      const fields = [
         { selector: '.plan_nombre', section: 'Define payment plan', name: 'Plan name' },
         { selector: '.plazo_meses', section: 'Define payment plan', name: 'Payment term' },
         { selector: '.manejo_mora', section: 'Define payment plan', name: 'Blackberry management' },
         { selector: '.interes_por_mora', section: 'Define payment plan', name: 'Interest on late payment' },
         { selector: '.monto_maximo', section: 'Define payment plan', name: 'Maximum amount' },
         { selector: '.monto_minimo', section: 'Define payment plan', name: 'Minimum amount' },
         { selector: '.modalidad_cobro', section: 'Define payment plan', name: 'Payment method' }
      ];

      for (const field of fields) {
         const value = $(field.selector).val() || "";
         if (value && value.length > 255) {
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector(field.selector);
               if (targetDiv) {
                  targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            };
            toastr.error(`In "${field.section}" the field "${field.name}" cannot exceed 255 characters.`);
            return true;
         }
      }

      return false;
   }

   function validatePhoneFormFields_aval() {
      const fields = [
         { selector: '.nombre_completo_aval', section: 'Guarantee', name: 'Full name' },
         { selector: '.lugar_trabajo_aval', section: 'Guarantee', name: 'Workplace' },
         { selector: '.relacion_aval', section: 'Guarantee', name: 'Relationship' },
         { selector: '.telefono_aval', section: 'Guarantee', name: 'Phone' },
         { selector: '.correo_electronico_aval', section: 'Guarantee', name: 'Email' },
         { selector: '.direccion_aval', section: 'Guarantee', name: 'Address' }
      ];

      for (const field of fields) {
         const value = $(field.selector).val();
         if (value && value.length > 255) {
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector(field.selector);
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               };
               toastr.error(`In "${field.section}" the field "${field.name}" cannot exceed 255 characters.`);
               return true;
         }
      }
      
      return false;
   }

   function isInvalidEmail(email) {
      const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      return !emailRegex.test(email);
   }

   function getRandomInt(min, max) {
      return Math.floor(Math.random() * (max - min + 1)) + min;
   }

 
 
</script>
{/literal}


{/block}