<?php
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");
$method = $_SERVER['REQUEST_METHOD'];
if($method == "OPTIONS") {
    die();
}


//tipos de mensajes y su peso 
//https://developers.facebook.com/docs/whatsapp/on-premises/reference/media#upload


//ini_set('memory_limit', '-1');
set_time_limit(56000);

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Worksheet\Table;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
 
$ui->assign('_title', 'Social Chat' . ' - ' . $config['CompanyName']);
$ui->assign('_st', 'SOCIAL CHAT');
$ui->assign('selected_navigation', 'mnu-25');
$action = $routes['1'];

 

$ui->assign('base_datos_para_socket', DB_NAME);
$ui->assign('config_whatsapp_other_id_para_socket', empty($user["config_whatsapp_other_id"]) == true ? "No_existe" : $user["config_whatsapp_other_id"] );
$ui->assign('url_ir_chat_empleado', U . "social/social-chat-employee");
$ui->assign('url_ir_chat_admin', U . "social/social-chat");

$ui->assign('url_ir_chat_crm', U . "social/chat-crm");
$ui->assign('url_base_plantilla_admintpl', U); 
$ui->assign('APP_URL_ORIGINAL_SOCKET', APP_URL_ORIGINAL_SOCKET);
$ui->assign('ws_nombre_socket', ws_nombre_socket);

$ui->assign('sin_ruta', _get('ng'));

if(empty($_SESSION['menu_categorias_user']) == false)
{
    $ui->assign('menu_categorias_user', $_SESSION['menu_categorias_user']);
}
 
$ui->assign('url_setting_CRM_Parnerts_prepared', url_setting_CRM_Parnerts_prepared);



switch ($action) {
   
    case 'views-payment-quota':

         

        $UUID = $routes['2'];

        if(empty($UUID) == true)
        {
            
            mensaje("Required parameter", "Encrypted UUID parameter required");
            exit;
            
        } 

        //echo "bienvenido a mi apartado"; exit;

        //print_r(json_encode($user)); exit;

        $ui->assign('UUID', $UUID);
        $ui->assign('url_base', U);
        //$ui->assign('id_user', $user["id"]);

        try {
            $mysqli = new mysqli(DB_HOST, DB_USER,DB_PASSWORD, DB_NAME);//colocar la base de datos cuando este en produccion:h 
            $mysqli->set_charset("utf8");

            if ($mysqli->connect_errno) {
                $mysqli->close();

                mensaje("Error connecting to the database.",  $con->connect_errno );
                exit;
            }

        } catch (Exception $e) {
            // Cerrar la conexión si existe
            if (isset($mysqli) && $con instanceof mysqli) {
                $mysqli->close();
            }
 
            mensaje("Error connecting to the database",  $e->getMessage());
            exit;
        }

         //$ui->assign('id_user', $user["id"]);
        //$ui->assign('fullname', $user["fullname"]);
        
        $ui->assign('APP_URL_ORIGINAL_SOCKET', APP_URL_ORIGINAL_SOCKET);

        $url_redireccionamiento_principal = "";

        if(TIPO_DOMINIO == 1)
        {
            $texto = explode(".", DOMINIO);

            if (count($texto) >= 3) {
                $url_redireccionamiento_principal = "https://";

                for ($i = 1; $i < count($texto); $i++) { // Comienza desde el índice 1
                    $url_redireccionamiento_principal .= $texto[$i];
                    if ($i < count($texto) - 1) { // Agrega el punto solo si no es el último elemento
                        $url_redireccionamiento_principal .= ".";
                    }
                }
            } else {
                $url_redireccionamiento_principal = "https://" . DOMINIO;
            }
        }   

        $ui->assign('url_redireccionamiento_principal', $url_redireccionamiento_principal);

        //echo $url_redireccionamiento_principal; exit;
        //echo json_encode(count(explode(".", "cesar.pineda.lopez"))); 

        //exit;

        $DB_NAME = DB_NAME;

        $sql = "SELECT SUse.* FROM $DB_NAME.`credit_history_details` AS chd  
        LEFT JOIN $DB_NAME.`sys_users` AS SUse ON SUse.id = chd.user_id_post
        WHERE chd.UUID = '$UUID' ";
              
        $registro = $mysqli->query($sql)->fetch_assoc();
 
        //echo json_encode($registro); exit;

        if(empty($registro) == true)
        {
            mensaje("Record not found", "Record was not found in the database");
            exit;
        }

        $ui->assign('id_user', $registro["id"]);
        $ui->assign('fullname', $registro["fullname"]);

        //echo $UUID_ENC; exit;
 
        view('download_payment_fee', [
           
        ]);

    break;

     //api get
    case 'get-data-report-quotas':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);

        $UUID  = $informacion_front['UUID'];
        
        if(empty($UUID) == true)
        {
            $response = array(
                "type" => "error",
                "message" => "Parameter UUID is required",
            );
            echo json_encode($response); exit;
        }

        $mysqli = null;
        $response = array();

        try {
            // Conexión a la base de datos
            $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
            if ($mysqli->connect_error) {
                //throw new Exception("Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error);

                $response = array(
                    "type" => "error",
                    "message" => "Database connection or query failed" . $mysqli->connect_errno,
                );
                echo json_encode($response); exit;

            }

            $mysqli->set_charset("utf8");
 
            $DB_NAME = DB_NAME;

 

            $sql = "SELECT 
                        chd.id AS id_credit_history_details,
                        chd.UUID,
                        chd.UUID_ENC,
                        chd.fecha_post AS fecha_pago,

                         

                        CHist.cuotas,
                        CHist.gip_id,

                        (
                            SELECT CONCAT( CHist.cuotas, ' of ', COUNT(*)) FROM credit_history AS c WHERE c.gip_id = CHist.gip_id
                        ) AS cuotas_cantidad,

                        CHist.*,

                        chd.detalle_pago
      
                 
                
            FROM $DB_NAME.`credit_history_details` AS chd 
                LEFT JOIN $DB_NAME.`credit_history` AS CHist ON CHist.id  = chd.ch_id
            WHERE chd.UUID = '$UUID' ";

            $registro = $mysqli->query($sql)->fetch_assoc();
        
            //echo json_encode($registro); exit;

            if(empty($registro) == true)
            {
                $response = array(
                    "type" => "error",
                    "message" => "Information not found",
                );
                echo json_encode($response); exit;
            }

            if(empty($registro["detalle_pago"]) == true)
            {
                $response = array(
                    "type" => "error",
                    "message" => "No payment detail record found",
                );
                echo json_encode($response); exit;
            }

            $detalle = json_decode($registro["detalle_pago"]);

            $gip_id = $registro["gip_id"];

            //echo $gip_id; exit;

            // ------------ -----------------
            $sql = "SELECT 
                    
                    id_gip.*,
                    CAcc.id AS customer_id_ig,
                    CAcc.account AS account, 
                    CAcc.email AS email,
                    CAcc.gid AS gid,
                    CAcc.gname AS gname,
                    CAcc.phone AS phone,
                    CAcc.position AS position,
                    FORMAT(id_gip.valor_monto_solicitado_li, 2) AS valor_monto_solicitado_li_formateado,

                    CONCAT('', LPAD(id_gip.numero_credito, GREATEST(LENGTH(id_gip.numero_credito), 6), '0'))  AS numero_credito,

                    (
                        SELECT CHist.total_cuota
                            FROM credit_history AS CHist 
                        WHERE CHist.gip_id = id_gip.id ORDER BY CHist.id ASC LIMIT 1
                    ) AS valor_cuota,

                    (
                        SELECT CONCAT('$', FORMAT(CHist.total_cuota, 2))
                            FROM credit_history AS CHist 
                        WHERE CHist.gip_id = id_gip.id ORDER BY CHist.id ASC LIMIT 1
                    ) AS valor_cuota_formateado,

                    (
                        SELECT 

                            CONCAT(

                                SUM( 
                                    IF(
                                        CHist.estado_pago_id = 1, 
                                        1, 
                                        0
                                    )
                                ),
                                ' of ',
                                COUNT(*) 
                            )
                            
                            FROM credit_history AS CHist 
                        WHERE CHist.gip_id = id_gip.id ORDER BY CHist.id ASC LIMIT 1
                    ) AS no_cuota         
        
            FROM $DB_NAME.`general_information_prospecting` AS id_gip 
            LEFT JOIN $DB_NAME.`crm_accounts` AS CAcc ON CAcc.id = id_gip.customer_id_ig
            WHERE id_gip.id = $gip_id ";

            $data_igp = $mysqli->query($sql)->fetch_assoc();

            if(empty($data_igp) == true)
            {
                $response = array(
                    "type" => "error",
                    "message" => "Parent record information not found",
                );
                echo json_encode($response); exit;
            }


            //telefono empresa
            $DB_CHAT_WS = DB_CHAT_WS;

            $sql = "SELECT  

              *

            FROM $DB_CHAT_WS.config_whatsapp_other AS CWOther WHERE CWOther.status = 1 LIMIT 1 
             
           ";
 
            $telefono_empresa = $mysqli->query($sql)->fetch_assoc();
 
            $telefono = "";

            if(empty($telefono_empresa) == false)
            {   

                if($telefono_empresa['enable_whatsapp'] == 1 )
                {
                    if(empty($telefono_empresa['phone_original']) == false)
                    {
                        $telefono .= "Whatsapp: " . $telefono_empresa['phone_original'];
                    }

                }

                if($telefono_empresa['enable_twilio'] == 1 )
                {
                    if(empty($telefono_empresa['sms_phone_number']) == false)
                    {
                        if(empty($telefono) == false)
                        {
                            $telefono .= "/ SMS: " . $telefono_empresa['sms_phone_number'];
                        }else{
                            $telefono .= "SMS: " . $telefono_empresa['sms_phone_number'];
                        }

                         
                    }

                }

            }

            $data_igp["telefono_empresa"] = $telefono;

            //echo json_encode($data_igp); exit;

            // Devolver los resultados como JSON
            //echo json_encode($listado); exit;

            $sql = "SELECT `value` FROM `sys_appconfig` WHERE setting = 'logo_default' LIMIT 1";
 
            $logo = $mysqli->query($sql)->fetch_assoc();

            //$ruta_img = APP_URL . " /storage/system/" . $logo['value'];

            $ruta_root = $_SERVER['DOCUMENT_ROOT'];   

            // Verificar si la ruta tiene una barra al final
            if (substr($ruta_root, -1) === '/') {
                // Si hay una barra al final, eliminarla
                $ruta_root = rtrim($ruta_root, '/');
            }

            $ruta_img = $ruta_root . "/app_dev_parnerts/storage/system/"  . $logo['value'];

            //$url_firma_secretaria_base =  $ruta_root . "/assets/imagenes/firma/2025-02-12-10-41-54_869038.png";
            $imageData = file_get_contents($ruta_img);
            $base64Image = base64_encode($imageData);

            if(empty($base64Image) == true)
            {
                $base64Image = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAIAAAC0D9CtAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYSURBVDhPY/hPOhjVM6oHBEb1kKPn/38Ab+Nfy74Zl7wAAAAASUVORK5CYII=";
            }

            $response = array(
                "type" => "success",
                "message" => "",
                "data"    => $registro,
                "detalle_pago" => $detalle,
                "data_gip" => $data_igp,
                "ruta_img"                      => $ruta_img,
                "base64Image_logo"              => $base64Image,
            );
            
            echo json_encode($response);

        } catch (Exception $e) {
            $response = array(
                "type" => "error",
                "message" => "Database connection or query failed",
                "detalle" => $e->getMessage()
            );

            echo json_encode($response);
        } finally {
            // Cerrar la conexión si existe
            if ($mysqli !== null) {
                $mysqli->close();
            }
        }

 
    break;

   
   
 
    default:
        echo 'action not defined';
}

function procesarValor($valor) {
    return floatval($valor); // Convierte a float para cálculos
}

function formatNumber($number) {
    return number_format($number, 2, '.', ','); // Formato con 2 decimales
}

function redondearNumero($numero, $decimales) {
    // Validar que el número sea numérico
    if (!is_numeric($numero)) {
        return 0; // Retorna 0 si no es un número válido
    }

    // Asegurar que los decimales sean un entero no negativo
    $decimales = (int)abs($decimales);

    // Redondear el número con la precisión especificada
    return round($numero, $decimales);
}


function mensaje($title = "", $description = "")
{
    echo <<<HTML
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title></title>
        <style>
            body {
                margin: 0;
                height: 100vh;
                display: flex;
                justify-content: center;
                align-items: center;
                background-color: white;
            }
            .card {
                background-color: #ffffff;
                border-radius: 10px;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
                padding: 20px;
                width: 300px;
                text-align: center;
            }
            .card h2 {
                margin: 0 0 10px;
            }
            .card p {
                margin: 0;
                color: #555;
            }
        </style>
    </head>
    <body>
        <div class="card">
            <h2>$title</h2>
            <p>$description</p>
        </div>
    </body>
    </html>
    HTML;
}

function generateUUIDv4() {
    // Generar un prefijo único basado en microsegundos
    $time_low = uniqid();
    
    // Generar 8 bytes aleatorios para completar el UUID
    $extra_bytes = bin2hex(random_bytes(8));
    
    // Unir las partes y crear el UUID v4
    $uuid = sprintf(
        '%08s-%04s-4%03s-%04x-%012s',
        // 32 bits para "time_low"
        substr($time_low, 0, 8),
        // 16 bits para "time_mid"
        substr($time_low, 8, 4),
        // 16 bits para "time_hi_and_version"
        substr($extra_bytes, 0, 3),
        // 16 bits para "clk_seq_hi_res"
        hexdec(substr($extra_bytes, 3, 4)) & 0x3fff | 0x8000,
        // 48 bits para "node"
        substr($extra_bytes, 7, 12)
    );
    
    return $uuid;
}

function uuidToBase64UrlRFC7515($uuid) {
    // Eliminar los guiones del UUID
    $uuid = str_replace('-', '', $uuid);
    
    // Convertir el UUID de hexadecimal a binario
    $binaryUuid = hex2bin($uuid);
    
    // Convertir el binario a Base64
    $base64 = base64_encode($binaryUuid);
    
    // Convertir Base64 a formato URL-safe (RFC 7515)
    $base64Url = str_replace(['+', '/', '='], ['-', '_', ''], $base64);
    
    return $base64Url;
}

 

 
function isInvalidEmail($email) {
    $emailRegex = '/^[^\s@]+@[^\s@]+\.[^\s@]+$/';
    return !preg_match($emailRegex, $email);
}

//crea el archivo index para que nadie ve las imagenes
function createHtmlFile($filename) {
    // Abre el archivo para escritura. Si no existe, lo crea.
    $file = fopen($filename, 'w');
    
    // Verifica si el archivo se abrió correctamente
    if ($file === false) {
        return "Error al abrir el archivo.";
    }

    $content = '
    <html>
    <head>
        <title>403 Forbidden</title>
    </head>
    <body>
    <p>Directory access is forbidden.</p>
    </body>
    </html>
    ';

    // Escribe el contenido en el archivo
    fwrite($file, $content);

    // Cierra el archivo
    fclose($file);
}
