<?php
if (!defined('APP_RUN')) {
    exit('No direct access allowed');
}
if (!isset($myCtrl)) {
    $myCtrl = 'contacts';
}
_auth();

require APP_SYSTEM_PATH . '/lib/misc/smsdriver.php';

$workspace_id = $_SESSION['workspace_id'] ?? 0;
//$ui->assign('selected_navigation', 'contacts');
$ui->assign('selected_navigation', 'mnu-2');
$ui->assign('_title', $_L['Customers'] . ' - ' . $config['CompanyName']);
$action = $routes['1'];

$user = User::_info();
$ui->assign('user', $user);

$ui->assign('base_datos_para_socket', DB_NAME);
$ui->assign('config_whatsapp_other_id_para_socket', empty($user["config_whatsapp_other_id"]) == true ? "No_existe" : $user["config_whatsapp_other_id"] );
$ui->assign('url_ir_chat_empleado', U . "social/social-chat-employee");
$ui->assign('url_ir_chat_admin', U . "social/social-chat");

$ui->assign('url_ir_chat_crm', U . "social/chat-crm");

$ui->assign('url_base_plantilla_admintpl', U);

$ui->assign('APP_URL_ORIGINAL_SOCKET', APP_URL_ORIGINAL_SOCKET);
$ui->assign('ws_nombre_socket', ws_nombre_socket);

$ui->assign('url_setting_CRM_Parnerts_prepared', url_setting_CRM_Parnerts_prepared);

$ui->assign('url_base', U);

//echo U; exit;

/* $ruta_segundaria = route(1);
$armado_ruta = "";

if(empty($ruta_segundaria) == true )
{
    $armado_ruta = route(0);
}else{
    $armado_ruta = route(0) . "/" . route(1);
}

$ui->assign('sin_ruta', $armado_ruta); */

$ui->assign('sin_ruta', _get('ng'));


if(empty($_SESSION['menu_categorias_user']) == false)
{
    $ui->assign('menu_categorias_user', $_SESSION['menu_categorias_user']);
}


 


$data = request()->all();
switch ($action) {
    case 'add':
    Event::trigger('contacts/add/');

    $type = route(2);

    $title_type = $_L['Add Customer'];
    $contact_type = 'customer';

    $db_type = 'Customer';

    if ($type == 'supplier') {
        $type_title = $_L['Add Supplier'];
        $contact_type = 'supplier';
        $db_type = 'Supplier';
        $ui->assign('selected_navigation', 'suppliers');
        $predict_customer_number = predict_next_serial($config, 'supplier');
    } else {
        $predict_customer_number = predict_next_serial($config, 'customer');
    }

    if (!has_access($user->roleid, 'customers', 'create')) {
        permissionDenied();
    }

        $ui->assign('countries', Countries::all($config['country'])); // may add this $config['country_code']

        $fs = ORM::for_table('crm_customfields')
        ->where('ctype', 'crm')
        ->order_by_asc('id')
        ->find_many();
        $ui->assign('fs', $fs);

        // find all companies

        $companies = ORM::for_table('sys_companies')
        ->select('id')
        ->select('company_name')
        ->order_by_desc('id')
        ->find_array();

        $ui->assign('companies', $companies);
        $ui->assign('companies_json', json_encode($companies));

        // find all groups

        $gs = ORM::for_table('crm_groups')
        ->order_by_asc('sorder')
        ->find_array();

        $ui->assign('gs', $gs);

        $g_selected_id = route(3);
        $c_selected_id = route(4);

        if ($g_selected_id !== '' && $g_selected_id !== '0') {
            $ui->assign('g_selected_id', $g_selected_id);
        } else {
            $ui->assign('g_selected_id', '');
        }

        if ($c_selected_id !== '' && $c_selected_id !== '0') {
            $ui->assign('c_selected_id', $c_selected_id);
        } else {
            $ui->assign('c_selected_id', '');
        }
        $tags = Tags::get_all('Contacts');
        $ui->assign('tags', $tags);

        $currencies = Currency::all();

        $ui->assign('currencies', $currencies);

        //$owners = getOwners($user);

        //echo "asdas"; exit;

        //$owners = User::where("status","Active")->get();
        
        $owners = getOwnersActivos($user,"Active");

        //$modulo_api_direcciones_smarty = ORM::for_table('modulo_direcciones_parnerts')
        //->find_one();

        $modulo_api_direcciones_smarty = ORM::get_db()->query('SELECT * FROM modulo_direcciones_parnerts limit 1')->fetch(PDO::FETCH_ASSOC);

        $url_map = $modulo_api_direcciones_smarty["url_api"];

        if(empty($url_map) == false)
        {
            $url_map = rtrim($url_map, "/");
        }

        //echo $modulo_api_direcciones_smarty["token"]; exit;
        $ui->assign('url_modulo_api_direccion_smarty',$url_map);
        $ui->assign('key_modulo_api_direccion_smarty', $modulo_api_direcciones_smarty["token"]);
        $ui->assign('host_modulo_api_direccion_smarty', $modulo_api_direcciones_smarty["host"]);
        $ui->assign('referer_modulo_api_direccion_smarty', $modulo_api_direcciones_smarty["referer"]);
        //serach_address

        //echo json_encode($modulo_api_direcciones_smarty); exit;


        //echo json_encode( $owners ); exit;

        view('contacts_add', [
            'contact_type' => $contact_type,
            'title_type' => $title_type,
            'db_type' => $db_type,
            'predict_customer_number' => $predict_customer_number,
            'owners' => $owners,
        ]);

        break;

        case 'summary':
        $extra_html_0 = '';
        $extra_html_1 = '';
        $extra_html_2 = '';

        Event::trigger('contacts/summary/');

        $cid = _post('cid');
        $d = ORM::for_table('crm_accounts')->find($cid);
        if ($d) {
            $ti = ORM::for_table('sys_transactions')
            ->where('payerid', $cid)
            ->sum('cr');
            if ($ti == '') {
                $ti = '0';
            }
            $ui->assign('ti', $ti);
            $te = ORM::for_table('sys_transactions')
            ->where('payeeid', $cid)
            ->sum('dr');
            if ($te == '') {
                $te = '0';
            }

            $ui->assign('te', $te);
            $ui->assign('d', $d);

            $cf = ORM::for_table('crm_customfields')
            ->where('ctype', 'crm')
            ->order_by_asc('id')
            ->find_many();
            $ui->assign('cf', $cf);

            // Find Profit

            if ($ti > $te) {
                $happened = $_L['Profit'];
                $css_class = 'green';

                $d_amount = $ti - $te;
            } else {
                $happened = $_L['Loss'];
                $css_class = 'danger';
                $d_amount = $te - $ti;
            }

            $ui->assign('happened', $happened);
            $ui->assign('css_class', $css_class);
            $ui->assign('d_amount', $d_amount);

            $ui->assign('cid', $cid);

            // $customer = $d;

            Event::trigger('contacts/summary_display/');

            $staffs = User::all()->keyBy('id')->all();

            $ui->assign('extra_html_0', $extra_html_0);
            $ui->assign('extra_html_1', $extra_html_1);
            $ui->assign('extra_html_2', $extra_html_2);

            //echo $d->rating_review; exit;

            $ui->assign('rating_review', $d->rating_review);

            view('ajax-contact-summary',[

                'staffs' => $staffs,
            ]);
        }

        break;

        case 'activity':
        Event::trigger('contacts/activity/');

        $cid = _post('cid');
        $d = ORM::for_table('crm_accounts')->find($cid);
        if ($d) {
            $ac = ORM::for_table('sys_activity')
            ->where('cid', $cid)
            ->limit(30)
            ->order_by_desc('id')
            ->find_many();
            $ui->assign('ac', $ac);

            view('ajax-contact-activity');
        }

        break;

        case 'invoices':
        Event::trigger('contacts/invoices/');

        $cid = _post('cid');
        $ui->assign('cid', $cid);
        $d = ORM::for_table('crm_accounts')->find($cid);
        if ($d) {
            $invoices_summary = Invoice::getInvoicesSummaryForCustomer($d->id);

            $invoice_groups = [];

            if(!empty($config['invoice_group']))
            {
                $invoice_groups = InvoiceGroup::all()->keyBy('id')->all();
            }

            $services = [];

            if(!empty($config['invoice_single_service']))
            {
                $services = Item::all()->keyBy('id')->all();
            }

            $staffs = User::all()->keyBy('id')->all();

            view('ajax-contact-invoices', [
                'total_invoice_amount' =>
                $invoices_summary['total_invoiced_amount'],
                'total_paid_amount' => $invoices_summary['total_paid_amount'],
                'total_unpaid_amount' =>
                $invoices_summary['total_unpaid_amount'],
                'invoices' => $invoices_summary['invoices'],
                'invoice_groups' => $invoice_groups,
                'services' => $services,
                'staffs' => $staffs,
            ]);
        }

        break;

        case 'purchases':
        Event::trigger('contacts/purchases/');

        $cid = _post('cid');
        $ui->assign('cid', $cid);
        $d = ORM::for_table('crm_accounts')->find($cid);
        if ($d) {
            $i = ORM::for_table('sys_purchases')
            ->where('userid', $cid)
            ->find_many();

            $total_invoice_amount = Purchase::where('userid', $cid)->sum(
                'total'
            );
            $total_paid_amount = Purchase::where('userid', $cid)
            ->paid()
            ->sum('total');
            $total_unpaid_amount = Purchase::where('userid', $cid)
            ->unpaid()
            ->sum('total');

            $ui->assign('i', $i);

            view('ajax-contact-purchases', [
                'total_invoice_amount' => $total_invoice_amount,
                'total_paid_amount' => $total_paid_amount,
                'total_unpaid_amount' => $total_unpaid_amount,
            ]);
        }

        break;

        case 'quotes':
        Event::trigger('contacts/quotes/');

        $cid = _post('cid');
        $ui->assign('cid', $cid);
        $d = ORM::for_table('crm_accounts')->find($cid);
        if ($d) {
            $i = ORM::for_table('sys_quotes')
            ->where('userid', $cid)
            ->find_many();
            $ui->assign('i', $i);

            view('ajax-contact-quotes');
        }

        break;

        case 'transactions':
        Event::trigger('contacts/transactions/');

        $cid = _post('cid');
        $d = ORM::for_table('crm_accounts')->find($cid);
        if ($d) {
            $tr = ORM::for_table('sys_transactions')
            ->where_raw('(`payerid` = ? OR `payeeid` = ?)', [$cid, $cid])
            ->order_by_desc('id')
            ->find_many();
            $ui->assign('tr', $tr);

            view('ajax-contact-transactions');
        }

        break;

        case 'email':
        Event::trigger('contacts/email/');

        $cid = _post('cid');
        $d = ORM::for_table('crm_accounts')->find($cid);
        if ($d) {
            $e = ORM::for_table('sys_email_logs')
            ->where('userid', $cid)
            ->order_by_desc('id')
            ->find_many();
            $ui->assign('d', $d);
            $ui->assign('e', $e);

            view('ajax-contact-emails');
        }

        break;

        case 'edit':
        Event::trigger('contacts/edit/');

        if (!has_access($user->roleid, 'customers', 'edit')) {
            permissionDenied();
        }

        $cid = _post('cid');
        $d = ORM::for_table('crm_accounts')->find($cid);
        if ($d) {
            $fs = ORM::for_table('crm_customfields')
            ->where('ctype', 'crm')
            ->order_by_asc('id')
            ->find_many();
            $ui->assign('fs', $fs);
            $ui->assign('countries', Countries::all($d['country']));
            $ui->assign('d', $d);
            $tags = Tags::get_all('Contacts');
            $ui->assign('tags', $tags);
            $dtags = explode(',', ($d['tags'] ?? ''));
            $ui->assign('dtags', $dtags);

            // find all groups

            $gs = ORM::for_table('crm_groups')
            ->order_by_asc('sorder')
            ->find_array();

            $ui->assign('gs', $gs);

            $companies = ORM::for_table('sys_companies')
            ->select('id')
            ->select('company_name')
            ->order_by_desc('id')
            ->find_array();

            $ui->assign('companies', $companies);
            $ui->assign('companies_json', json_encode($companies));

            $g_selected_id = route(4);

            if ($g_selected_id !== '' && $g_selected_id !== '0') {
                $ui->assign('g_selected_id', $g_selected_id);
            } else {
                $ui->assign('g_selected_id', '');
            }

            $c_selected_id = route(5);

            if ($c_selected_id !== '' && $c_selected_id !== '0') {
                $ui->assign('c_selected_id', $c_selected_id);
            } else {
                $ui->assign('c_selected_id', '');
            }

            $currencies = Currency::all();

            $ui->assign('currencies', $currencies);

            //$owners = getOwners($user);
            $owners = getOwnersActivos($user,"Active");

            
            $myCompanies = ORM::get_db()->query("SELECT 
                    crm_accounts_company.*,
                    SCom.company_name AS nameCompany,
                    ('modificar') AS accion

                FROM `crm_accounts_company` 
                    LEFT JOIN sys_companies AS SCom ON SCom.id = crm_accounts_company.idCompany
                WHERE crm_accounts_company.crm_account_id = $cid ")->fetchAll(PDO::FETCH_ASSOC);
            
            //echo json_encode($myCompanies); exit;

            view('ajax-contact-edit', [
                'owners' => $owners,
                'myCompanies' => json_encode($myCompanies),
            ]);
        }

        break;

        case 'add-activity-post':
        Event::trigger('contacts/add-activity-post/');

        $cid = _post('cid');
        $msg = $data['msg'];
        $icon = $data['icon'];
        $icon = trim($icon);

        $icon = str_replace('<a href="#"><i class="', '', $icon);
        $icon = str_replace('"></i></a>', '', $icon);
        if ($icon == '') {
            $icon = 'fal fa-check';
        }

        if ($msg == '') {
            echo $_L['description_error'];
        } else {
            $d = ORM::for_table('sys_activity')->create();
            $d->cid = $cid;
            $d->msg = $msg;
            $d->icon = $icon;
            $d->stime = time();
            $d->sdate = date('Y-m-d');
            $d->o = $user->id;
            $d->oname = $user['fullname'];
            $d->save();

            echo $cid;
        }

        break;

        case 'activity-delete':
        Event::trigger('contacts/activity-delete/');

        $id = $routes['3'];
        $d = ORM::for_table('sys_activity')->find($id);
        $d->delete();
        $cid = $routes['2'];
        r2(
            U . 'contacts/view/' . $cid . '/activity',
            's',
            $_L['Deleted Successfully']
        );
        break;

        case 'view':
        Event::trigger('contacts/view/');
 
        $id = $routes['2'];

        if(empty($id) == true)
        {
            displayCard1("Parameter error","The contact parameter is required"); exit;
        }

        //echo $id; exit;

        $contact = $d = Contact::find($id);

        // check self data only

        $is_supplier = false;

        $po_count = 0;

        if ($d) {
            if (!has_access($user->roleid, 'customers', 'all_data') && $d->o != $user->id) {
                permissionDenied();
            }

            if ($d->type == 'Supplier') {
                $is_supplier = true;

                $ui->assign('selected_navigation', 'suppliers');

                $po_count = ORM::for_table('sys_purchases')
                ->where('userid', $id)
                ->count();

                if ($po_count == '') {
                    $po_count = 0;
                }
            }

            $extra_tab = '';
            $extra_jq = '';

            $tab = route(3);

            if ($tab === '' || $tab === '0') {
                $tab = 'summary';
            }

            $ui->assign('tab', $tab);

            Event::trigger('contacts/view/_on_start');

            $ui->assign('extra_tab', $extra_tab);

            // invoice count

            $inv_count = ORM::for_table('sys_invoices')
            ->where('userid', $id)
            ->count();

            if ($inv_count == '') {
                $inv_count = 0;
            }

            $ui->assign('inv_count', $inv_count);

            $quote_count = ORM::for_table('sys_quotes')
            ->where('userid', $id)
            ->count();

            if ($quote_count == '') {
                $quote_count = 0;
            }

            $ui->assign('quote_count', $quote_count);

            $ui->assign('d', $d);

            Event::trigger('contacts/view/_on_display');

            //echo "hola";
            //exit;

            view('account-profile-alt', [
                'is_supplier' => $is_supplier,
                'po_count' => $po_count,
                'body_extra_class' => 'layout-composed',
                'contact' => $contact,
            ]);
        } else {
            r2(U . 'customers/list/', 'e', $_L['Account_Not_Found']);
        }

        break;

        case 'add-post':
 
            $conexion_db_cliente = null;

            try {

                $conexion_db_cliente = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME_GENERAL); //colocar la base de datos cuando este en produccion:h 
                $conexion_db_cliente->set_charset("utf8");

                if ($conexion_db_cliente->connect_errno) {
                    $conexion_db_cliente->close();
                    echo $conexion_db_cliente->connect_errno; exit;
                }

            } catch (Exception $e) {
                echo $e->getMessage(); exit;
            } 
         

            $companies    = _post('companies');
            
            $arrCompanies = [];

            if(!empty($companies))
            {
                $arrCompanies = json_decode($companies, true);
            }
            
            //echo $arrCompanies;
            //exit;

            $account = _post('account');

            $type_customer = _post('customer');
            $type_supplier = _post('supplier');

            $type = $type_customer . ',' . $type_supplier;
            $type = trim($type, ',');

            if ($type == '') {
                $type = 'Customer';
            }

            $company_id = _post('cid');

            $company = '';
            $cid = 0;

            $email = _post('email');
            $username = _post('username');
            $phone = _post('phone');
            $currency = _post('currency');

            $address = _post('address');
            $city = _post('city');
            $state = _post('state');
            $zip = _post('zip');
            $country = _post('country');

            $code = _post('code');

            $secondary_email = _post('secondary_email');

            $position = _post('position');
            $notas = _post('notas');
            $codigo_pais = _post('codigo_pais');

            $nationality = _post('nationality');

            if ($company_id != '') {
                if ($company_id != '0') {
                    $company_db = db_find_one('sys_companies', $company_id);

                    if ($company_db) {
                        $company = $company_db->company_name;
                        $cid = $company_id;
                    }
                }
            } elseif (_post('company') != '') {
                // create compnay
                $company = _post('company');
                $c = new Company();

                $c->company_name = $company;
                $c->email = $email;
                $c->phone = $phone;

                $c->address1 = $address;
                $c->city = $city;
                $c->state = $state;
                $c->zip = $zip;
                $c->country = $country;

                $c->save();

                $cid = $c->id;
            } else {
            }

            if ($currency == '') {
                $currency = '0';
            }

            $tags = isset($data['tags']) && $data['tags'] != '' ? $data['tags'] : '';

            $msg = '';

            //check if tag is already exisit

            if ($nationality == '') {
                $msg .= "Nationality is required" . ' <br>';
            }

            if ($email == '') {
                $msg .= "Email is required" . ' <br>';
            }

            if ($username == '') {
                $msg .= "Username is required" . ' <br>';
            }

            if ($phone == '') {
                $msg .= "Phone is required" . ' <br>';
            }

            if ($address == '') {
                $msg .= "Address is required" . ' <br>';
            }

            if ($city == '') {
                $msg .= "city is required" . ' <br>';
            }

            if ($state == '') {
                $msg .= "state is required" . ' <br>';
            }

            if ($zip == '') {
                $msg .= "zip is required" . ' <br>';
            }
 
        /* if ($country == "United States") {

                $clas=new Contact();
                $address222=str_replace(",", "", $address);
                $address222=str_replace("#", "%23", $address);

                $tags = $clas->verificationadress($address222,$city,$state,$zip);

                if (!$tags) {
                    $msg .= "Your address could not be validated, please try again ". ' <br>';
                }

            }*/


            if ($account == '') {
                $msg .= $_L['Account Name is required'] . ' <br>';
            }

            if ($email != '') {
                if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    $msg .= $_L['Invalid Email'] . ' <br>';
                }
                $f = ORM::for_table('crm_accounts')
                ->where('email', $email)
                ->first();

                if ($f) {
                    $msg .= $_L['Email already exist'] . ' <br>';
                }
            }

            if ($secondary_email != '') {
                if (!filter_var($secondary_email, FILTER_VALIDATE_EMAIL)) {
                    $msg .= $_L['Invalid Email'] . ' <br>';
                }
            } else {
                $secondary_email = '';
            }

            if ($phone != '') {
                $f = ORM::for_table('crm_accounts')
                ->where('phone', $phone)
                ->first();

                if ($f) {
                    $msg .= $_L['Phone number already exist'] . ' <br>';
                }
            }

            $gid = (int) _post('group');

            $gname = '';

            if($gid)
            {
                $group = ContactGroup::find($gid);
                if($group)
                {
                    $gname = $group->gname;
                }
                else{
                    $gid = 0;
                }
            }

            $password = _post('password');
            $cpassword = _post('cpassword');

            $u_password = '';

            if ($password != '') {
                if ($password !== $cpassword) {
                    $msg .= 'Passwords does not match<br>';
                }

                $u_password = $password;
                $password = Password::_crypt($password);
            }

            if ($msg == '') {
                Tags::save($tags, 'Contacts');

                $data = [];

                $data['created_at'] = date('Y-m-d H:i:s');
                $data['updated_at'] = date('Y-m-d H:i:s');

                $owner_id = _post('owner_id');

                $d = ORM::for_table('crm_accounts')->create();

                //$position = _post('position');
                //$notas = _post('notas');
                //$codigo_pais = _post('codigo_pais');
                
    
                $d->nationality = $nationality;
                $d->account = $account;
                $d->email = $email;
                $d->position = $position;
                $d->notas = $notas;
                $d->codigo_pais = $codigo_pais;
                $d->telephone_number = $phone;
                $d->phone = $codigo_pais . $phone;
                $d->address = $address;
                $d->city = $city;
                $d->zip = $zip;
                $d->state = $state;
                $d->country = $country;
                $d->tags = Arr::arr_to_str($tags);

                $d->fname = '';
                $d->lname = '';
                $d->company = $company;
                $d->jobtitle = '';
                $d->cid = $cid;
                $d->o = $owner_id;
                $d->balance = '0.00';
                $d->status = 'Active';
                $d->notes = $notas;
                $d->password = $password;
                $d->token = '';
                $d->ts = '';
                $d->img = '';
                $d->web = '';
                $d->facebook = '';
                $d->google = '';
                $d->linkedin = '';

                $d->gname = $gname;
                $d->gid = $gid;


                $d->currency = $currency;


                $d->created_at = $data['created_at'];

                $d->type = $type;


                $d->business_number = _post('business_number');

                $d->fax = _post('fax');

                $drive = time() . Misc::random_string(12);

                $d->drive = $drive;

                $d->code = $code;

                $d->secondary_email = $secondary_email;

                $d->o = $user->id;

                $d->save();

                $cid = $d->id();


                if ($type == 'Supplier') {
                    update_option(
                        'supplier_code_current_number',
                        current_number_would_be($code)
                    );
                } else {
                    update_option(
                        'customer_code_current_number',
                        current_number_would_be($code)
                    );
                }

                _log(
                    $_L['New Contact Added'] .
                    ' ' .
                    $account .
                    ' [CID: ' .
                    $cid .
                    ']',
                    'Admin',
                    $user->id
                );

                $fs = ORM::for_table('crm_customfields')
                ->where('ctype', 'crm')
                ->order_by_asc('id')
                ->find_many();
                foreach ($fs as $f) {
                    $fvalue = _post('cf' . $f['id']);
                    $fc = ORM::for_table('crm_customfieldsvalues')->create();
                    $fc->fieldid = $f['id'];
                    $fc->relid = $cid;
                    $fc->fvalue = $fvalue;
                    $fc->save();
                }

                Event::trigger('contacts/add-post/_on_finished');

                $send_client_signup_email = _post('send_client_signup_email');

                if (
                    $email !== '' &&
                    $send_client_signup_email === 'on' &&
                    $u_password !== ''
                ) {
                    Email::send_client_welcome_email(
                        [
                            'account' => $account,
                            'email' => $email,
                            'password' => $u_password,
                        ],
                        true
                    );
                }

                foreach($arrCompanies as $item)
                {
                    $UUID = $item["UUID"];
                    $UUID_ENC = $item["UUID_ENC"];
                    $idCompany = $item["idCompany"];
                    //$item["nameCompany"];

                    $sql = "INSERT INTO `crm_accounts_company`(
                                `UUID`,
                                `UUID_ENC`,
                                `idCompany`,
                                `crm_account_id`
                            )
                            VALUES(
                                ?,
                                ?,
                                ?,
                                ?
                            )";
            
                    $stmt_detalles = $conexion_db_cliente->prepare($sql);
                    if ($stmt_detalles === false) {
                        //error_log("Prepare failed for detalle_facturacion insert (client): " . $conexion_db_cliente->error);
                        $conexion_db_cliente->close();
                        continue;  
                    }
 
                    $stmt_detalles->bind_param(
                        "ssss",
                        $UUID,
                        $UUID_ENC,
                        $idCompany,
                        $cid,
                    );

                    if (!$stmt_detalles->execute()) {
                         
                        $stmt_detalles->close();
                        $conexion_db_cliente->close();
                        continue ; // Continue to the next $db_configs iteration
                    }

                    $stmt_detalles->close();
                }

                $app->emit('customer.added', [$d]);

                echo $cid;

            } else {
                echo $msg;
            }
        break;

        case 'list':

        Event::trigger('contacts/list/');

        $show_company_column = false;
        $show_group_column = false;

        $group_id = (int) route(3);

        /*$has_delete_permission = true;
        $has_edit_permission = true;

        if (!has_access($user->roleid, 'customers', 'delete')) {
            $has_delete_permission = false;
        }

        if (!has_access($user->roleid, 'customers', 'edit')) {
            $has_edit_permission = false;
        }*/

        if (
            isset($config['contact_list_show_company_column']) &&
            $config['contact_list_show_company_column'] == 1
        ) {
            $show_company_column = true;
        }

        if (
            isset($config['contact_list_show_group_column']) &&
            $config['contact_list_show_group_column'] == 1
        ) {
            $show_group_column = true;
        }

        $contacts = Contact::orderBy('id', 'desc');

        $type = route(2,'customer');

        if ($type == 'supplier') {
            $ui->assign('selected_navigation', 'suppliers');
            $contacts = $contacts->where(function ($query) {
                $query
                ->where('type', 'Supplier')
                ->orWhere('type', 'Customer,Supplier');
            });
        } else {
            $contacts = $contacts->where(function ($query) {
                $query
                ->where('type', 'Customer')
                ->orWhere('type', 'Customer,Supplier');
            });
        }

        if (!has_access($user->roleid, 'customers', 'all_data')) {
            $contacts = $contacts->where('o', $user->id);
        }

        if ($group_id) {
            $contacts = $contacts->where('gid', $group_id);
        }

        $ui->assign(
            'companies',
            db_find_array('sys_companies', ['id', 'company_name'])
        );

        $name = _post('name');

        $contacts = $contacts->get();

        $groups = ContactGroup::get()->keyBy('id')->all();

        view('contacts_list', [
            'type' => $type,
            'show_company_column' => $show_company_column,
            'show_group_column' => $show_group_column,
            'name' => $name,
            //'contacts' => $contacts,
            //'has_edit_permission' => $has_edit_permission,
            //'has_delete_permission' => $has_delete_permission,
            'groups' => $groups,
            'group_id' => $group_id,
            'APP_DIRECTORIO' => APP_DIRECTORIO,
        ]);

        break;

        case   'data_table' :
        header('Content-Type: application/json');

        $group_id = (int) route(3);


        $has_delete_permission = true;
        $has_edit_permission = true;

        if (!has_access($user->roleid, 'customers', 'delete')) {
            $has_delete_permission = false;
        }

        if (!has_access($user->roleid, 'customers', 'edit')) {
            $has_edit_permission = false;
        }

        /* $contacts = Contact::select(['id', 'account', 'email', 'phone', 'company','gname','gid','code','address'])->where('type', 'Customer')->orderBy('id', 'desc')->get();

        if ($group_id) {
            $contacts = $contacts->where('gid', $group_id);
        } */

 
        $where = "";

        if ($group_id) {
            $where .= " AND ca.gid = $group_id ";
        } 

        //                    GROUP_CONCAT(sysc.company_name SEPARATOR '\n') AS company,
        
        $sql = "SELECT 
                    ca.*, 
                    GROUP_CONCAT(sysc.company_name SEPARATOR ',\n<br>') AS company,
                    if(ca.rating_review = 1, 'Yes', 'No') AS rating_review_descripcion

                FROM 
                    `crm_accounts` ca
                LEFT JOIN 
                    `crm_accounts_company` cac ON ca.id = cac.crm_account_id
                LEFT JOIN 
                    `sys_companies` sysc ON sysc.id = cac.idCompany

                WHERE 1 $where

                GROUP BY 
                    ca.id";
 
        
        $contacts = ORM::get_db()->query($sql)->fetchAll(PDO::FETCH_ASSOC);


        /* SELECT 
            ca.*, 
            GROUP_CONCAT(sysc.company_name SEPARATOR ',') AS related_id_companies
        FROM 
            `crm_accounts` ca
        LEFT JOIN 
            `crm_accounts_company` cac ON ca.id = cac.crm_account_id
        LEFT JOIN 
            `sys_companies` sysc ON sysc.id = cac.idCompany

        GROUP BY 
            ca.id; */
        
        
        $datos1 = array('datos' => $contacts,'has_delete_permission' => $has_delete_permission,'has_edit_permission' => $has_edit_permission);


        header("HTTP/1.1 200", true);

        print (json_encode($datos1));


        break;

        case   'data_address' :
        header('Content-Type: application/json');
        $text= $_POST['data'];
        /*$country= $_POST['country'];
        $city= $_POST['city'];
        $state= $_POST['state'];
        $zip= $_POST['zip'];*/

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://us-autocomplete-pro.api.smarty.com/lookup?key=188805315395749398&search=1200&include_only_cities=&include_only_states=&include_only_zip_codes=&exclude_states=&prefer_cities=&prefer_states=&prefer_zip_codes=&source=all',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
          CURLOPT_HTTPHEADER => array(
            'Host: us-autocomplete-pro.api.smarty.com',
            'Referer: ' . APP_URL_ORIGINAL
            //'Referer: https://hispanosdeexitollc.com/'
        ),
      ));
        $response = curl_exec($curl);
        curl_close($curl);
        $datos=json_decode($response);
        $datos=$datos->suggestions;

        $datos1 = array('datos' => $datos);

        header("HTTP/1.1 200", true);

        print (json_encode($datos1));


        break;

        case 'edit-post':
        Event::trigger('contacts/edit-post/');

        if (!has_access($user->roleid, 'customers', 'edit')) {
            permissionDenied();
        }

 
        $id = _post('fcid');
        $d = ORM::for_table('crm_accounts')->find($id);

        if ($d) {

            $conexion_db_cliente = null;

            try {

                $conexion_db_cliente = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME_GENERAL); //colocar la base de datos cuando este en produccion:h 
                $conexion_db_cliente->set_charset("utf8");

                if ($conexion_db_cliente->connect_errno) {
                    $conexion_db_cliente->close();
                    echo $conexion_db_cliente->connect_errno; exit;
                }

            } catch (Exception $e) {
                echo $e->getMessage(); exit;
            } 

            $companies    = _post('companies');
                
            //echo $companies; exit;

            $arrCompanies = [];

            if(!empty($companies))
            {
                $arrCompanies = json_decode($companies, true);
            }

            $companies_deletes    = _post('companies_deletes');

            if(!empty($companies_deletes))
            {
                $arrCompaniesDelete = [];
                $arrCompaniesDelete = json_decode($companies_deletes, true);

                $idEliminar = implode(",", $arrCompaniesDelete);

                if(!empty($idEliminar))
                {
                    ORM::get_db()->query("DELETE FROM `crm_accounts_company` WHERE id IN ($idEliminar) ");
                }
            }

            foreach($arrCompanies as $item)
            {
                $id_compania = $item["id"];
                $UUID        = $item["UUID"];
                $UUID_ENC    = $item["UUID_ENC"];
                $idCompany   = $item["idCompany"];
            
                if(empty($id_compania))
                {

                    $sql = "INSERT INTO `crm_accounts_company`(
                                `UUID`,
                                `UUID_ENC`,
                                `idCompany`,
                                `crm_account_id`
                            )
                            VALUES(
                                ?,
                                ?,
                                ?,
                                ?
                            )";
            
                    $stmt_detalles = $conexion_db_cliente->prepare($sql);
                    if ($stmt_detalles === false) {
                        //error_log("Prepare failed for detalle_facturacion insert (client): " . $conexion_db_cliente->error);
                        $conexion_db_cliente->close();
                        continue;  
                    }
    
                    $stmt_detalles->bind_param(
                        "ssss",
                        $UUID,
                        $UUID_ENC,
                        $idCompany,
                        $id,
                    );

                    if (!$stmt_detalles->execute()) {
                        
                        $stmt_detalles->close();
                        $conexion_db_cliente->close();
                        continue ; // Continue to the next $db_configs iteration
                    }

                    $stmt_detalles->close();
                }
                 
            }

            //echo $companies_deletes; exit;
            //echo "qwe";
            //exit;

            $old_account = $d->account;

            $account = _post('account');
            // $company = _post('company');

            $company_id = _post('company_id');

            $company = '';
            $cid = 0;

            if ($company_id != '' || $company_id != '0') {
                $company_db = db_find_one('sys_companies', $company_id);

                if ($company_db) {
                    $company = $company_db->company_name;
                    $cid = $company_id;
                }
            }

            $email = _post('edit_email');

            $tags = isset($data['tags']) ? $data['tags'] : '';

            $currency = _post('currency', '0');

            if ($currency == '') {
                $currency = '0';
            }

            $phone = _post('phone');
            $address = _post('address');
            $city = _post('city');
            $state = _post('state');
            $zip = _post('zip');
            $country = _post('country');
            $nationality = _post('nationality');


            $username = _post('username');

            $type_customer = _post('customer');
            $type_supplier = _post('supplier');

            $type = $type_customer . ',' . $type_supplier;
            $type = trim($type, ',');

            if ($type == '') {
                $type = 'Customer';
            }

            $msg = '';

            if ($account == '') {
                $msg .= $_L['Account Name is required'] . ' <br>';
            }
            //            if($tags != ''){
            //                $pieces = explode(',', $tags);
            //                foreach($pieces as $element)
            //                {
            //                    $tg = ORM::for_table('sys_tags')->where('text',$element)->where('type','Contacts')->first();
            //                    if(!$tg){
            //                        $tc = ORM::for_table('sys_tags')->create();
            //                        $tc->text = $element;
            //                        $tc->type = 'Contacts';
            //                        $tc->save();
            //                    }
            //                }
            //            }

            // Sadia ================= From V 2.4

            Tags::save($tags, 'Contacts');

            //check email already exist

            //            if($address == ''){
            //                $msg .= 'Address is required <br>';
            //            }
            //            if($city == ''){
            //                $msg .= 'City is required <br>';
            //            }
            //            if($state == ''){
            //                $msg .= 'State is required <br>';
            //            }
            //            if($zip == ''){
            //                $msg .= 'ZIP is required <br>';
            //            }
            //            if($country == ''){
            //                $msg .= 'Country is required <br>';
            //            }
            if ($email != '') {
                if ($email != $d['email']) {
                    $f = ORM::for_table('crm_accounts')
                    ->where('email', $email)
                    ->first();

                    if ($f) {
                        $msg .= $_L['Email already exist'] . ' <br>';
                    }
                }
                if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    $msg .= $_L['Invalid Email'] . ' <br>';
                }
            }
            //            if($phone != ''){
            //                if(!is_numeric($phone)){
            //                    $msg .= $_L['Invalid Phone'].' <br>';
            //                }
            //            }

            $gid = _post('group');

            $secondary_email = _post('secondary_email');

            if (!filter_var($secondary_email, FILTER_VALIDATE_EMAIL)) {
                $secondary_email = '';
            }
            $gname = '';

            if ($gid != '') {
                $g = db_find_one('crm_groups', $gid);
                if ($g) {
                    $gname = $g['gname'];
                }
            } else {
                $gid = 0;
                $gname = '';
            }

            $owner_id = _post('owner_id', 0);

            $password = _post('password');


            /*if ($country == "United States") {
                $address222=str_replace(",", "", $address);
                $address222=str_replace("#", "%23", $address);
                $clas=new Contact();
                $tags = $clas->verificationadress($address222,$city,$state,$zip);

                if (!$tags) {
                    $msg .= "Your address could not be validated, please try again ". ' <br>';
                }

            }*/

            if ($msg == '') {

                $position = _post('position');
                $notas = _post('notas');
                $codigo_pais = _post('codigo_pais');

                $d = ORM::for_table('crm_accounts')->find($id);
                $d->account = $account;
                $d->company = $company;
                //$d->cid = $company_id;
                $d->o = $owner_id;
                $d->nationality = $nationality;

                $d->email = $email;
                $d->tags = Arr::arr_to_str($tags);

                //$position = _post('position');
                //$notas = _post('notas');
                //$codigo_pais = _post('codigo_pais');

                $d->phone = $codigo_pais . $phone;
                $d->position = $position;
                $d->notas = $notas;
                $d->notes = $notas;
                $d->codigo_pais = $codigo_pais;
                $d->telephone_number = $phone;


                $d->address = $address;
                $d->city = $city;
                $d->zip = $zip;
                $d->state = $state;
                $d->country = $country;

                $d->type = $type;

                $d->username = $username;

                // v 4.2

                $d->gname = $gname;
                $d->gid = $gid;

                // build 4550

                $d->currency = $currency;

                //

                $d->fax = _post('fax');

                $d->code = _post('code');

                $d->secondary_email = $secondary_email;

                if ($config['show_business_number']) {
                    $d->business_number = _post('business_number');
                }

                if ($password != '') {
                    $d->password = Password::_crypt($password);
                }

                $d->save();

                //delete existing records
                $exf = ORM::for_table('crm_customfieldsvalues')
                ->where('relid', $id)
                ->delete_many();
                $fs = ORM::for_table('crm_customfields')
                ->order_by_asc('id')
                ->find_many();
                foreach ($fs as $f) {
                    $fvalue = _post('cf' . $f['id']);
                    $fc = ORM::for_table('crm_customfieldsvalues')->create();
                    $fc->fieldid = $f['id'];
                    $fc->relid = $id;
                    $fc->fvalue = $fvalue;
                    $fc->save();
                }

                // check account name changed

                if ($account != $old_account) {
                    // change invoice account

                    //                    $inv = ORM::for_table('sys_invoices')->where('account',$old_account);
                    //                    $inv->account = $account;
                    //                    $inv->save();

                    $sql = "update sys_invoices set account='$account' where account='$old_account'";

                    ORM::execute($sql);
                }

                _msglog('s', $_L['account_updated_successfully']);

                echo $id;
            } else {
                echo $msg;
            }
        } else {
            r2(U . 'contacts/list', 'e', $_L['Account_Not_Found']);
        }

        break;
        case 'delete':
        if (!has_access($user->roleid, 'customers', 'delete')) {
            permissionDenied();
        }

        Event::trigger('contacts/delete/');

        $id = $routes['2'];
        if (APP_STAGE == 'Demo') {
            r2(
                U . 'contacts/list/',
                'e',
                'Sorry! Deleting Account is disabled in the demo mode.'
            );
        }
        $d = Contact::find($id);
        if ($d) {
            $d->delete();
            r2(U . 'contacts/list/', 's', $_L['account_delete_successful']);
        }

        break;

        case 'more':
        Event::trigger('contacts/more/');

        $cid = _post('cid');
        $d = ORM::for_table('crm_accounts')->find($cid);
        if ($d) {
            $ui->assign('countries', Countries::all($d['country']));
            $ui->assign('d', $d);
            view('ajax-contact-more');
        }

        break;

        case 'edit-more':
        Event::trigger('contacts/edit-more/');

        $id = _post('cid');
        $d = ORM::for_table('crm_accounts')->find($id);
        if ($d) {
            $img = _post('picture');
            $facebook = _post('facebook');
            $google = _post('google');
            $linkedin = _post('linkedin');

            $msg = '';

            $img = str_replace(APP_URL . '/', '', $img);

            //check email already exist

            if ($msg === '') {
                $d = ORM::for_table('crm_accounts')->find($id);

                $d->img = $img;
                $d->facebook = $facebook;
                $d->google = $google;
                $d->linkedin = $linkedin;
                $d->save();
                echo $d->id();
            } else {
                echo $msg;
            }
        } else {
            r2(U . 'contacts/list/', 'e', $_L['Account_Not_Found']);
        }

        break;

        case 'edit-notes':
        Event::trigger('contacts/edit-notes/');

        $id = _post('cid');
        $d = ORM::for_table('crm_accounts')->find($id);
        if ($d) {
            $notes = _post('notes');

            $msg = '';

            //check email already exist

            if ($msg === '') {
                $d = ORM::for_table('crm_accounts')->find($id);

                $d->notes = $notes;
                $d->notas = $notes;
                $d->save();
                echo $d->id();
            } else {
                echo $msg;
            }
        } else {
            r2(U . 'contacts/list/', 'e', $_L['Account_Not_Found']);
        }

        break;

        case 'set-boolean':
        $key = _post('key');
        $contact_id = _post('contact_id');
        $value = _post('value');

        $contact = Contact::find($contact_id);

        if ($contact && $key === 'is_primary_contact') {
            $contact->is_primary_contact = $value;
        }

        $contact->save();

        break;

        case 'render-address':
        Event::trigger('contacts/render-address/');

        $cid = _post('cid');
        $d = ORM::for_table('crm_accounts')->find($cid);
        $address = $d['address'];
        $city = $d['city'];
        $state = $d['state'];
        $zip = $d['zip'];
        $country = $d['country'];
        echo "$address
        $city
        $state $zip
        $country
        ";
        break;

        case 'json-single-contact':
        $cid = _post('cid');

        $contact = Contact::find($cid);

        $address_full = '';
        $business_number = '';

        if ($contact) {
            $address_full = getContactFormattedAddress(
                $config,
                $contact,
                false
            );

            $business_number = $contact->business_number;
        }

        jsonResponse([
            'address_full' => $address_full,
            'business_number' => $business_number,
        ]);

        break;

        case 'json-single-contact-v1':
            $cid = _post('cid');

            $contact = Contact::find($cid);

            $address_full = '';
            $business_number = '';

            if ($contact) {
                $address_full = getContactFormattedAddress(
                    $config,
                    $contact,
                    false
                );

                $business_number = $contact->business_number;
            }

            //$cid

            $list_crm_accounts_company = ORM::get_db()->query("SELECT 
                    CACom.*,
                    SCom.company_name 
                FROM `crm_accounts_company` AS CACom
                LEFT JOIN sys_companies AS SCom ON SCom.id = CACom.idCompany

                WHERE CACom.crm_account_id = $cid
            
            ")->fetchAll(PDO::FETCH_ASSOC);

        
            $respueta = [
                'address_full'      => $address_full,
                'business_number'   => $business_number,
                'list_of_companies' => $list_crm_accounts_company,
            ];

            jsonResponse($respueta);

        break;

        case 'send_email':
        Event::trigger('contacts/send_email/');

        $msg = '';
        $cid = _post('cid');
        $d = ORM::for_table('crm_accounts')->find($cid);
        $email = $d['email'];
        $toname = $d['account'];
        $subject = _post('subject');
        if ($subject == '') {
            $msg .= $_L['Subject is Empty'] . ' <br>';
        }
        $message = $data['message'];
        if ($message == '') {
            $msg .= $_L['Message is Empty'] . ' <br>';
        }
        if ($msg === '') {
            //send email

            Email::sendEmail(
                $config,
                $_L,
                $toname,
                $email,
                $subject,
                $message,
                $cid
            );

            echo $cid;
        } else {
            echo $msg;
        }
        break;

        case 'modal_add':
        Event::trigger('contacts/modal_add/');

        $ui->assign('countries', Countries::all($config['country'])); // may add this $config['country_code']

        view('modal_add_contact');

        break;

        case 'set_view_mode':
        Event::trigger('contacts/set_view_mode/');

        //        if(isset($routes['2']) AND ($routes['2'] != 'tbl')){
        //            $mode = 'card';
        //        }
        //        else{
        //            $mode = 'tbl';
        //        }

        $mode = isset($routes[2]) && $routes[2] != '' ? $routes['2'] : 'tbl';

        $available_mode = ["tbl", "card", "search"];
        if (in_array($mode, $available_mode)) {
            update_option('contact_set_view_mode', $mode);
        }

        r2(U . 'contacts/list/');

        break;

        case 'export_csv':
        $fileName = 'contacts_' . time() . '.csv';

        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header('Content-Description: File Transfer');
        header("Content-type: text/csv");
        header("Content-Disposition: attachment; filename={$fileName}");
        header("Expires: 0");
        header("Pragma: public");

        $fh = @fopen('php://output', 'w');

        $headerDisplayed = false;

        // $results = ORM::for_table('crm_Accounts')->find_array();
        $results = db_find_array('crm_accounts', [
            'id',
            'account',
            'company',
            'phone',
            'email',
            'address',
            'city',
            'state',
            'zip',
            'country',
            'balance',
            'tags',
        ]);

        foreach ($results as $data) {
            // Add a header row if it hasn't been added yet
            if (!$headerDisplayed) {
                // Use the keys from $data as the titles
                fputcsv($fh, array_keys($data));
                $headerDisplayed = true;
            }

            // Put the data into the stream
            fputcsv($fh, $data);
        }
        // Close the file
        fclose($fh);

        break;

        case 'dev_demo_data':
        // this only work with dev mode
        is_dev();

        break;

        case 'import_csv':
        view('contacts_import');

        break;

        case 'csv_upload':
        $uploader = new Uploader();
        $uploader->setDir('storage/temp/');
        // $uploader->sameName(true);
        $uploader->setExtensions(['csv']); //allowed extensions list//
        if ($uploader->uploadFile('file')) {
            //txtFile is the filebrowse element name //
            $uploaded = $uploader->getUploadName(); //get uploaded file name, renames on upload//

            $_SESSION['uploaded'] = $uploaded;
        } else {
            //upload failed
            _msglog('e', $uploader->getMessage()); //get upload error message
        }

        break;

        case 'csv_uploaded':
        if (isset($_SESSION['uploaded'])) {
            $uploaded = $_SESSION['uploaded'];

            // _msglog('s',$uploaded);

            //            $csvData = file_get_contents('storage/temp/'.$uploaded);
            //            $lines = explode(PHP_EOL, $csvData);
            //            $contacts = array();
            //            foreach ($lines as $line) {
            //                $contacts[] = str_getcsv($line);
            //            }

            $csv = new parseCSV();
            $csv->auto('storage/temp/' . $uploaded);

            $contacts = $csv->data;

            $cn = 0;

            foreach ($contacts as $contact) {
                $data = [];
                $data['account'] = $contact['Full Name'];
                $data['email'] = $contact['Email'];
                $data['phone'] = $contact['Phone'];
                $data['address'] = $contact['Address'];
                $data['city'] = $contact['City'];
                $data['zip'] = $contact['Zip'];
                $data['state'] = $contact['State'];
                $data['country'] = $contact['Country'];
                $data['company'] = $contact['Company'];

                $save = Contacts::add($data);

                if (is_numeric($save)) {
                    $cn++;
                }
            }

            _msglog('s', $cn . ' Contacts Imported');

            //            ob_start();
            //            var_dump($contacts);
            //            $result = ob_get_clean();
            //
            //            _msglog('s',$result);
        } else {
            _msglog('e', 'An Error Occurred while uploading the files');
        }

        break;

        case 'groups':
        // find all groups

        $gs = ORM::for_table('crm_groups')
        ->order_by_asc('sorder')
        ->find_array();

        $ui->assign('gs', $gs);


        view('crm_groups');

        break;

        case 'add_group':
        $group_name = _post('group_name');

        if ($group_name != '') {
            //check same group already exist

            $c = ORM::for_table('crm_groups')
            ->where('gname', $group_name)
            ->first();

            if ($c) {
                ib_die('A Group with same name already exist');
            }

            $d = ORM::for_table('crm_groups')->create();
            $d->gname = $group_name;
            $d->color = '';
            $d->discount = '';
            $d->parent = '';
            $d->pid = 0;
            $d->exempt = '';
            $d->description = '';
            $d->separateinvoices = '';
            $d->sorder = 0;

            $d->save();

            echo $d->id();
        } else {
            echo 'Group Name is required';
        }

        break;

        case 'find_by_group':
        $gid = route(2);

        if ($gid !== '' && $gid !== '0') {
            $g = ORM::for_table('crm_groups')->find($gid);

            if ($g) {
                $d = ORM::for_table('crm_accounts')
                ->where('gid', $gid)
                ->order_by_desc('id')
                ->find_array();

                $ids = [];

                foreach ($d as $id_single) {
                    $ids[] = $id_single['id'];
                }

                $ui->assign('d', $d);
                $ui->assign('gid', $gid);

                view('contacts_find_by_group');
            }
        }

        break;

        case 'group_edit':
        $id = _post('id');
        $id = str_replace('e', '', $id);
        $gname = _post('gname');

        $d = ORM::for_table('crm_groups')->find($id);

        if ($d) {
            // update all gname in contacts

            $o_gname = $d->gname;

            ORM::execute(
                "update crm_accounts set gname='$gname' where gname='$o_gname'"
            );

            $d->gname = $gname;

            $d->save();

            echo $d->id;
        }

        break;

        case 'group_email':
        $gid = route(2);

        if ($gid !== '' && $gid !== '0') {
            // find group

            $ds = ORM::for_table('crm_accounts')
            ->where('gid', $gid)
            ->where_not_equal('email', '')
            ->select('account')
            ->select('email')
            ->order_by_desc('id')
            ->find_array();

            $ui->assign('ds', $ds);

            $ui->assign(
                'xheader',
                Asset::css([
                    's2/css/select2.min',
                    'sn/summernote',
                    'sn/summernote-bs3',
                    'sn/summernote-application',
                ])
            );

            view('contacts_group_email');
        }

        break;

        case 'group_whatsapp':
            $gid = route(2);
    
            if ($gid !== '' && $gid !== '0') {
                // find group

                $ds = ORM::for_table('crm_groups')
                ->where('id', $gid)
                ->find_array();

            
                if(count($ds) == 0){
                    echo "group not found"; exit;
                }

                $path_img = APP_URL . "/ui/theme/default/img/";

                $ui->assign('usuario_id', $user["id"]);
                $ui->assign('url_base', U);
                $ui->assign('grupo_id', $gid);
                $ui->assign('path_img', $path_img);

                $url_listado_plantilla = U . "group/list-messages-groups-send";
                $ui->assign('url_listado_plantillas', $url_listado_plantilla);

                //echo $url_listado_plantilla; exit;
    
                view('group_contacts_whatsapp');
            }
    
        break;

        case 'group_sms':
            $gid = route(2);
    
            if ($gid !== '' && $gid !== '0') {
                // find group

                $ds = ORM::for_table('crm_groups')
                ->where('id', $gid)
                ->find_array();

                if(count($ds) == 0){
                    echo "group not found"; exit;
                }

                $path_img = APP_URL . "/ui/theme/default/img/";

                $ui->assign('usuario_id', $user["id"]);
                $ui->assign('url_base', U);
                $ui->assign('grupo_id', $gid);
                $ui->assign('path_img', $path_img);

                $url_listado_plantilla = U . "group/list-messages-groups-send";
                $ui->assign('url_listado_plantillas', $url_listado_plantilla);

                //echo $url_listado_plantilla; exit;
    
                view('group_contacts_sms');
            }
    
        break;

        case 'group_email_v1':
            $gid = route(2);
    
            if ($gid !== '' && $gid !== '0') {
                // find group

                $ds = ORM::for_table('crm_groups')
                ->where('id', $gid)
                ->find_array();

                if(count($ds) == 0){
                    echo "group not found"; exit;
                }

                $path_img = APP_URL . "/ui/theme/default/img/";

                $ui->assign('usuario_id', $user["id"]);
                $ui->assign('url_base', U);
                $ui->assign('grupo_id', $gid);
                $ui->assign('path_img', $path_img);

                $url_listado_plantilla = U . "group/list-messages-groups-send";
                $ui->assign('url_listado_plantillas', $url_listado_plantilla);

                //echo $url_listado_plantilla; exit;
    
                view('group_contacts_email');
            }
    
        break;

        case 'group_email_post':


        $emails = $data['emails'];
        $subject = $data['subject'];
        $message = $data['message'];
        $cc = $data['cc'] ?? null;
        $bcc = $data['bcc'] ?? null;

        $email_config = EmailConfig::first();
        $contacts = Contact::all()->keyBy('email')->all();

        if ($email_config) {
            if ($email_config->method == 'smtp') {
                $transport = (new Swift_SmtpTransport(
                    $email_config->host,
                    $email_config->port,
                    $email_config->secure
                ))
                ->setUsername($email_config->username)
                ->setPassword($email_config->password)
                ->setStreamOptions([
                    'ssl' => [
                        'allow_self_signed' => true,
                        'verify_peer' => false,
                    ],
                ]);
            } else {
                $transport = new Swift_SendmailTransport(
                    '/usr/sbin/sendmail -bs'
                );
            }

            $mailer = new Swift_Mailer($transport);

            $receiver = [];

            $message_object = (new Swift_Message($subject))
            ->setFrom([$config['sysEmail'] => $config['CompanyName']])
            ->setBody($message, 'text/html');

            if (!empty($cc)) {
                $message_object->setCc([$cc]);
            }

            if (!empty($bcc)) {
                $message_object->setBcc([$bcc]);
            }

            foreach ($emails as $email)
            {
                $toname = $email;

                if (isset($contacts[$email])) {
                    $toname = $contacts[$email]->account;
                }

                $send = $message_object->setTo([$email => $toname]);

                $result = $mailer->send($send);

                Email::_log($user->id, $email, $subject, $message);
            }


        }



        break;

        case 'companies':
        $ui->assign(
            '_title',
            $_L['Companies'] . ' - ' . $config['CompanyName']
        );

        $companies = Company::orderBy('id', 'desc');

        if (!has_access($user->roleid, 'companies', 'all_data')) {
            $companies = $companies->where('aid', $user->id);
        }

        $companies = $companies->get();

        $ui->assign('companies', $companies);

        view('companies');

        break;

        case 'modal_add_company':
        $id = route(2);

        $company = false;

        if ($id != '') {
            $id = str_replace('ae', '', $id);
            $id = str_replace('be', '', $id);
            $id = str_replace('me', '', $id);

            $company = Company::find($id);
        }

        $val = [];

        if ($company) {
            $f_type = 'edit';
            $val['company_name'] = $company->company_name;
            $val['code'] = $company->code;
            $val['url'] = $company->url;
            $val['email'] = $company->email;
            $val['phone'] = $company->phone;
            $val['logo_url'] = $company->logo_url;
            $val['cid'] = $id;
            $val['fax'] = $company->fax;
            $val['business_number'] = $company->business_number;

            $val['address1'] = $company->address1;
            $val['city'] = $company->city;
            $val['zip'] = $company->zip;
            $val['state'] = $company->state;
            $val['country'] = $company->country;
            $val['ein'] = $company->ein;

            $countries = Countries::all($company->country);

            //$ruta_root = $_SERVER['DOCUMENT_ROOT'];   
            //$ruta_root = U;   

            // Verificar si la ruta tiene una barra al final
            //if (substr($ruta_root, -1) === '/') {
            //    // Si hay una barra al final, eliminarla
            //    $ruta_root = rtrim($ruta_root, '/');
            //}

            $myCompaniesDocuments = ORM::get_db()->query("SELECT
                                                `id`,
                                                `UUID`,
                                                `UUID_ENC`,
                                                `sys_companies_id`,
                                                `nombre_original`,
                                                `extension`,
                                                `nombre_img_sistema`,
                                                `url`,
                                                CONCAT(url,nombre_img_sistema) AS ruta_documento
                                            FROM
                                                `company_documents`
                                            WHERE
                                                sys_companies_id = $id ")->fetchAll(PDO::FETCH_ASSOC);

            $ui->assign('my_companies_documents', json_encode($myCompaniesDocuments));

            //echo json_encode($myCompaniesDocuments); exit;

            //            $val[''] = $company->;
        } else {
            $f_type = 'create';
            $val['company_name'] = '';
            $val['code'] = predict_next_serial($config, 'company');
            $val['url'] = 'http://';
            $val['email'] = '';
            $val['phone'] = '';
            $val['logo_url'] = '';
            $val['cid'] = '';
            $val['fax'] = '';
            $val['business_number'] = '';
            $val['address1'] = '';
            $val['city'] = '';
            $val['zip'] = '';
            $val['state'] = '';
            $val['country'] = '';
            $val['ein'] = '';
            //  $val[''] = '';

            $countries = Countries::all($config['country']);
        }

        $ui->assign('f_type', $f_type);
        $ui->assign('val', $val);


        $modulo_api_direcciones_smarty = ORM::get_db()->query('SELECT * FROM modulo_direcciones_parnerts limit 1')->fetch(PDO::FETCH_ASSOC);

        //echo json_encode($modulo_api_direcciones_smarty); exit;

        $url_map = $modulo_api_direcciones_smarty["url_api"];

        if(empty($url_map) == false)
        {
            $url_map = rtrim($url_map, "/");
        }

        //echo $modulo_api_direcciones_smarty["token"]; exit;
        $ui->assign('url_modulo_api_direccion_smarty',$url_map);
        $ui->assign('key_modulo_api_direccion_smarty', $modulo_api_direcciones_smarty["token"]);
        $ui->assign('host_modulo_api_direccion_smarty', $modulo_api_direcciones_smarty["host"]);
        $ui->assign('referer_modulo_api_direccion_smarty', $modulo_api_direcciones_smarty["referer"]);

        view('modal_add_company', [
            'countries' => $countries,
        ]);

        break;

        case 'add_company_post':
        $data = ib_posted_data();

        $code = _post('code');

        $data = request()->all();

        $logo_path = $data['logo_url'] ?? '';

        if (
            !empty($data['logo_url']) &&
            strpos($data['logo_url'], 'http') === 0
        ) {
            if (!filter_var($data['logo_url'], FILTER_VALIDATE_URL)) {
                i_close('Invalid logo url');
            }

            if (APP_STAGE === 'Live') {
                try {
                    $parse_url = parse_url($data['logo_url']);
                    $path = $parse_url['path'] ?? '';
                    $ext = (new SplFileInfo($path))->getExtension();
                    $logo_path = md5(time()) . '.' . $ext;
                    $client = new \GuzzleHttp\Client();
                    $client->request('GET', $data['logo_url'], [
                        'sink' => 'storage/companies/' . $logo_path,
                    ]);
                } catch (\Exception $e) {
                    i_close($e->getMessage());
                }
            }
        }

        $creating = false;
        if (isset($data['f_type']) && $data['f_type'] == 'edit') {
            $company = Company::find($data['cid']);

            if (!$company) {
                i_close('Company Not Found');
            }
        } else {
            $company = new Company();

            $creating = true;
        }

        if ($data['company_name'] == '') {
            i_close($_L['Company Name is required']);
        }

        if (
            $data['email'] != '' &&
            !filter_var($data['email'], FILTER_VALIDATE_EMAIL)
        ) {
            i_close($_L['Invalid Email']);
        }

        if ($data['url'] == 'http') {
            $data['url'] = '';
        }

        $company->company_name = $data['company_name'];

        $company->code = $code;

        $company->url = $data['url'];
        $company->email = $data['email'];
        $company->phone = $data['phone'];

        if (isset($data['business_number'])) {
            $company->business_number = $data['business_number'];
        }

        $company->address1 = $data['address1'];
        $company->city = $data['city'];
        $company->state = $data['state'];
        $company->zip = $data['zip'];
        $company->country = $data['country'];

        $company->aid = $user->id;

        $company->logo_url = $logo_path;

        $company->save();

        if ($creating) {
            update_option(
                'company_code_current_number',
                current_number_would_be($code)
            );
        }

        echo $company->id;

        break;

        case 'add_company_post_v1':
            //$data = ib_posted_data();
            //$data = request()->all();

            $json = file_get_contents('php://input');
            $data = json_decode($json, true);

            //echo json_encode($data);
            //exit;
            
            //$code = _post('code');
            $code = $data['code'];
            $logo_path = $data['logo_url'] ?? '';

            $ein = $data['ein'] ?? '';

            $ein = empty($ein) == true && $ein != 0 ? null : $ein;
 

            $arregloArchivos = $data['arregloArchivos'];
            $arregloArchivosEliminados = $data['arregloArchivosEliminados'];

            $mysqli = null;

            try {
                $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME_GENERAL);
                $mysqli->set_charset("utf8");
            } catch (\Exception  $e) {
                //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
                $response = array(
                    "type" => "error",
                    "message" => "Database connection failed",
                    "data" => [],
                );
                print_r(json_encode( $response)) ; exit;
            }

 
             
            if (
                !empty($data['logo_url']) &&
                strpos($data['logo_url'], 'http') === 0
            ) {
                if (!filter_var($data['logo_url'], FILTER_VALIDATE_URL)) {
                    //i_close('Invalid logo url');

                    $response = array(
                        "type" => "error",
                        "message" => 'Invalid logo url',
                        "data" => [],
                    );
                    print_r(json_encode( $response)) ; exit;

                }

                if (APP_STAGE === 'Live') {
                    try {
                        $parse_url = parse_url($data['logo_url']);
                        $path = $parse_url['path'] ?? '';
                        $ext = (new SplFileInfo($path))->getExtension();
                        $logo_path = md5(time()) . '.' . $ext;
                        $client = new \GuzzleHttp\Client();
                        $client->request('GET', $data['logo_url'], [
                            'sink' => 'storage/companies/' . $logo_path,
                        ]);
                    } catch (\Exception $e) {
                        //i_close($e->getMessage());
                        
                        $response = array(
                            "type" => "error",
                            "message" => $e->getMessage(),
                            "data" => [],
                        );
                        print_r(json_encode( $response)) ; exit;

                    }
                }
            }

            $creating = false;
            if (isset($data['f_type']) && $data['f_type'] == 'edit') {
                $company = Company::find($data['cid']);

                if (!$company) {
                    //i_close('Company Not Found');

                    $response = array(
                        "type" => "error",
                        "message" => 'Company Not Found',
                        "data" => [],
                    );
                    print_r(json_encode( $response)) ; exit;
                }
            } else {
                $company = new Company();

                $creating = true;
            }

            if ($data['company_name'] == '') {
                //i_close($_L['Company Name is required']);
                $response = array(
                    "type" => "error",
                    "message" => 'Company Name is required',
                    "data" => [],
                );
                print_r(json_encode( $response)) ; exit;
            }

            if (
                $data['email'] != '' &&
                !filter_var($data['email'], FILTER_VALIDATE_EMAIL)
            ) {
                //i_close($_L['Invalid Email']);
                $response = array(
                    "type" => "error",
                    "message" => 'Invalid Email',
                    "data" => [],
                );
                print_r(json_encode( $response)) ; exit;
            }

            if ($data['url'] == 'http') {
                $data['url'] = '';
            }

            $company->company_name = $data['company_name'];

            $company->code = $code;

            $company->url = $data['url'];
            $company->email = $data['email'];
            $company->phone = $data['phone'];

            if (isset($data['business_number'])) {
                $company->business_number = $data['business_number'];
            }

            $company->address1 = $data['address1'];
            $company->city = $data['city'];
            $company->state = $data['state'];
            $company->zip = $data['zip'];
            $company->country = $data['country'];

            $company->aid = $user->id;

            $company->logo_url = $logo_path;

            $company->ein = $ein;

            $company->save();

            if ($creating) {
                update_option(
                    'company_code_current_number',
                    current_number_would_be($code)
                );
            }

            $company_id = $company->id;

            $ruta_root = $_SERVER['DOCUMENT_ROOT'];   

            // Verificar si la ruta tiene una barra al final
            if (substr($ruta_root, -1) === '/') {
                // Si hay una barra al final, eliminarla
                $ruta_root = rtrim($ruta_root, '/');
            }

            if($arregloArchivosEliminados != null)
            {
                // Filtrar elementos con id no vacío y extraer los IDs
                $idsEliminar = array_filter(
                    array_column($arregloArchivosEliminados, 'id'),
                    function($id) {
                        return !empty($id);
                    }
                );

                $miIdEliminar = implode(',', $idsEliminar);

                if(!empty($miIdEliminar))
                {
                    ORM::get_db()->query("DELETE FROM `company_documents` WHERE id IN ($miIdEliminar) ");
                }

                $ruta_root = $_SERVER['DOCUMENT_ROOT'];   

                if (substr($ruta_root, -1) === '/') {
                    $ruta_root = rtrim($ruta_root, '/');
                }

                foreach($arregloArchivosEliminados as $item)
                {
                    $filePath = $ruta_root . $item["ruta_documento"];
 
                    if (file_exists($filePath)) {
                        // Intentar eliminar el archivo
                        unlink($filePath);
                    } 

                }
            }

            //$tipo_proyecto_produccion = APP_DIRECTORIO;
    
            $basePath = $ruta_root . "/storage/companies/docs/";
            $path_db = "/storage/companies/docs/";
             
            if(!file_exists($basePath))
            {
                mkdir($basePath, 0777, true);
                createHtmlFilev1($basePath."/index.html");
            } 

            if($arregloArchivos != null)
            {
                foreach($arregloArchivos as $item)
                {
                    $id              = $item["id"];
                    $base64          = $item["base64"];
                    $nombre_original = $item["nombre_original"];
                    $extension       = $item["extension"];
                    $UUID            = $item["UUID"];
                    $UUID_ENC        = $item["UUID_ENC"];

                    if(empty($id))
                    {
                        $formato = date('Y-m-d-H-i-s');
                        $numero_aleatorio = rand(1, 100000); 
                        
                        $idImagen = $company_id . "_" . $formato . "_" . $numero_aleatorio . "." . $extension;

                        $folderPath = $basePath;
                        $image_base64 = base64_decode($base64);

                        $file = $folderPath . $idImagen;

                        file_put_contents($file, $image_base64);

                        $sql = "INSERT INTO `company_documents`(
                                    `UUID`,
                                    `UUID_ENC`,
                                    `sys_companies_id`,
                                    `nombre_original`,
                                    `extension`,
                                    `nombre_img_sistema`,
                                    `url`
                                )
                                VALUES(
                                    ?,
                                    ?,
                                    ?,
                                    ?,
                                    ?,
                                    ?,
                                    ?
                                )";
                            
                            $stmt = $mysqli->prepare($sql);
                            
                            $stmt->bind_param(
                                'sssssss',
                                $UUID,
                                $UUID_ENC,
                                $company_id,
                                $nombre_original,
                                $extension,
                                $idImagen,
                                $path_db,
                            );
                            
                            $stmt->execute();
                            $stmt->close();
                    }

                     

                }
            }

            $response = array(
                "type" => "success",
                "message" => 'Registration processed successfully',
                "data" => [],
            );
            print_r(json_encode( $response)) ; exit;

            

        break;

        case 'modal_edit_activity':
        $id = route(2);

        $id = str_replace('activity_', '', $id);

        $d = ORM::for_table('sys_activity')->find($id);

        if ($d) {
            $ui->assign('d', $d);
            view('modal_edit_activity');
        }

        break;

        case 'edit_activity_post':
        $edit_activity_id = _post('edit_activity_id');

        $d = ORM::for_table('sys_activity')->find($edit_activity_id);

        if ($d) {
            $message_text = $data['message_text'];
            $icon = $data['edit_activity_type'];
            $icon = str_replace('<a href="#"><i class="', '', $icon);
            $icon = str_replace('"></i></a>', '', $icon);
            if ($icon == '') {
                $icon = 'fa fa-check';
            }
            $d->icon = $icon;
            $d->msg = $message_text;
            $d->save();
            echo $d->id();
        }

        break;

        case 'orders':
        // Event::trigger('contacts/orders/');

        $cid = _post('cid');
        $d = ORM::for_table('crm_accounts')->find($cid);
        if ($d) {
            $d = ORM::for_table('sys_orders')
            ->where('cid', $cid)
            ->find_array();
            $ui->assign('d', $d);
            view('contacts_orders');
        } else {
        }

        break;

        case 'files':
        
        //$id = $routes['2'];
        //$d = Contact::find($id);
        //echo json_encode($d); exit;
 

        Event::trigger('contacts/files/');

        $cid = _post('cid');
        $ui->assign('cid', $cid);

        // find all available files for this client

        $file_ids = ORM::for_table('ib_doc_rel')
        ->where('rtype', 'contact')
        ->where('rid', $cid)
        ->find_array();

        $ids = [];

        foreach ($file_ids as $f) {
            $ids[] = $f['did'];
        }

        $d = empty($ids) ? [] : ORM::for_table('sys_documents')
        ->where_in('id', $ids)
        ->find_many();

        // select all files

        $files = ORM::for_table('sys_documents')->find_array();

        $ui->assign('files', $files);

        $ui->assign('d', $d);

        $upload_max_size = ini_get('upload_max_filesize');
        $post_max_size = ini_get('post_max_size');

        $ui->assign('upload_max_size', $upload_max_size);
        $ui->assign('post_max_size', $post_max_size);

        $ui->assign('url_base', U);
 
        view('contacts_files');

        break;

        case 'save_upload':
            //$c = Contacts::details();

            $title = _post('title');
            $file_link = _post('file_link');
            $cid = _post('cid'); // id del contacto

            //echo $cid; exit;

            $d = Contact::find($cid);

            if($d)
            {
                 if ($title == '' || $file_link == '') {
                    //ib_die($_L['All Fields are Required']);

                    echo json_encode([
                        "type" => "error",
                        "mensaje" => "All Fields are Required",
                    ]); exit;

                } else {
                    $token = Misc::random_string(30);
                    $ext = pathinfo($file_link, PATHINFO_EXTENSION);

                    $document = new Document();

                    $document->title = $title;
                    $document->file_path = $file_link;
                    $document->file_dl_token = $token;
                    $document->file_mime_type = $ext;

                    $document->is_global = 0;

                    //$document->cid = $c->id;
                    $document->cid = $cid;

                    $document->save();

                    $d_ = ORM::for_table('ib_doc_rel')->create();
                    $d_->rtype = 'contact';
                    $d_->rid = $cid;
                    $d_->did = $document->id;;
                    $d_->save();


                    echo json_encode([
                        "type" => "success",
                        "mensaje" => "Registration processed successfully",
                    ]);

                    exit;

                    echo $document->id;
                }
            }else{
                //ib_die("The contact id was not found");

                echo json_encode([
                    "type" => "error",
                    "mensaje" => "The contact id was not found",
                ]);exit;
            }

    
            

        break;

        case 'document_upload':
        //$c = Contacts::details();
 
        $uploader = new Uploader();
        $uploader->setDir('storage/docs/');
        $uploader->sameName(false);

        $uploader->setExtensions([
            'zip',
            'pdf',
            'jpg',
            'png',
            'jpeg',
            'gif',
            'psd',
        ]); //allowed extensions list//

        if ($uploader->uploadFile('file')) {
            //txtFile is the filebrowse element name //
            $uploaded = $uploader->getUploadName(); //get uploaded file name, renames on upload//

            $file = $uploaded;
            $msg = $_L['Uploaded Successfully'];
            $success = 'Yes';
        } else {
            //upload failed
            $file = '';
            $msg = $uploader->getMessage();
            $success = 'No';
        }

        $a = [
            'success' => $success,
            'msg' => $msg,
            'file' => $file,
        ];

        header('Content-Type: application/json');

        echo json_encode($a);

        break;

        case 'assign_file':
        $cid = _post('cid');

        $did = _post('did');

        // find the customer

        // check if exist

        $check = ORM::for_table('ib_doc_rel')
        ->where('rtype', 'contact')
        ->where('rid', $cid)
        ->where('did', $did)
        ->first();

        if ($check) {
            i_close('This file is already available for this contact.');
        }

        $d = ORM::for_table('ib_doc_rel')->create();
        $d->rtype = 'contact';
        $d->rid = $cid;
        $d->did = $did;
        $d->save();

        echo $cid;

        break;

        case 'remove_file':
        $cid = route(2);
        $did = route(3);

        $d = ORM::for_table('ib_doc_rel')
        ->where('rtype', 'contact')
        ->where('rid', $cid)
        ->where('did', $did)
        ->first();

        if ($d) {
            $d->delete();
        }

        r2(U . 'contacts/view/' . $cid . '/files/', 's', $_L['Data Updated']);

        break;

        case 'gen_auto_login':
        $id = route(2);

        $d = ORM::for_table('crm_accounts')->find($id);

        if ($d) {
            $d->autologin = Misc::random_string(20) . $id . time();
            $d->save();
            r2(
                U . 'contacts/view/' . $id . '/summary/',
                's',
                $_L['Created Successfully']
            );
        } else {
            echo 'Contact Not Found.';
        }

        break;

        case 'revoke_auto_login':
        $id = route(2);

        $d = ORM::for_table('crm_accounts')->find($id);

        if ($d) {
            $d->autologin = '';
            $d->save();

            r2(
                U . 'contacts/view/' . $id . '/summary/',
                's',
                $_L['Data Updated']
            );
        } else {
            echo 'Contact Not Found.';
        }

        break;

        case 'modal_view_company':
        $id = route(2);
        $id = str_replace('ae', '', $id);

        $extra_links = '';

        $company = ORM::for_table('sys_companies')->find($id);

        if ($company) {
            $ui->assign('company', $company);

            Event::trigger('contacts/modal_view_company/');

            $ui->assign('extra_links', $extra_links);

            view('modal_view_company');
        } else {
            echo 'Company Not Found';
        }

        break;

        case 'company_memo':
        $cid = _post('cid');

        $d = ORM::for_table('sys_companies')->find($cid);

        if ($d) {
            echo '<textarea class="form-control" id="v_memo" name="v_memo" rows="6">' .
            $d->notes .
            '</textarea> <button type="button" id="memo_update" class="btn btn-primary btn-block mt-sm act_memo_update mt-3">' .
            $_L['Save'] .
            '</button>';
        }

        break;

        case 'company_update_notes':
        $id = _post('id');

        $d = ORM::for_table('sys_companies')->find($id);

        if ($d) {
            $memo = $data['memo'];
            $d->notes = $memo;
            $d->save();
        }

        echo $_L['Data Updated'];

        break;

        case 'company_customers':
        $cid = _post('cid');

        $customers = Contact::where('cid', $cid)
        ->get()
        ->toArray();

        $tr_customers = '';

        foreach ($customers as $customer) {
            $tr_customers .=
            '<tr>
            <th scope="row"><a href="' .
            U .
            'contacts/view/' .
            $customer['id'] .
            '">' .
            $customer['id'] .
            '</a></th>
            <td><a href="' .
            U .
            'contacts/view/' .
            $customer['id'] .
            '">' .
            $customer['account'] .
            '</a></td>
            <td>' .
            $customer['email'] .
            '</td>
            <td>' .
            $customer['phone'] .
            '</td>
            </tr>';
        }

        if ($tr_customers == '') {
            $tr_customers =
            '<tr><td colspan="4">' .
            $_L['No Data Available'] .
            '</td></tr>';
        }

        echo '
        <h4>' .
        $_L['Customers'] .
        '</h4>
        <hr>
        <a class="btn btn-primary" href="' .
        U .
        'contacts/add/0/' .
        $cid .
        '">' .
        $_L['Add Customer'] .
        '</a>
        <hr>
        <table class="table table-bordered">
        <thead>
        <tr>
        <th>#</th>
        <th>' .
        $_L['Name'] .
        '</th>
        <th>' .
        $_L['Email'] .
        '</th>
        <th>' .
        $_L['Phone'] .
        '</th>
        </tr>
        </thead>
        <tbody>
        ' .
        $tr_customers .
        '
        </tbody>
        </table>';

        break;

        case 'company_summary':
        $cid = _post('cid');

        $cid = str_replace('ae', '', $cid);

        $d = ORM::for_table('sys_companies')->find($cid);

        if ($d) {
            $url = $d->url;

            if ($url == 'http://') {
                $url = '';
            }

            echo '<p>

            <strong>' .
            $_L['Company Name'] .
            ': </strong>  ' .
            $d->company_name .
            '<br>
            <strong>' .
            $_L['URL'] .
            ': </strong>  ' .
            $url .
            '<br>
            <strong>' .
            $_L['Email'] .
            ': </strong>  ' .
            ($d->email != ''
                ? '<a href="#" class="send_email">' . $d->email . '</a>'
                : '') .
            '<br>
            <strong>' .
            $_L['Phone'] .
            ': </strong>  ' .
            $d->phone .
            '<br>






            </p>



            <a href="#" class="btn btn-primary cedit" id="me' .
            $d->id .
            '">' .
            $_L['Edit'] .
            '</a>


            <hr>

            <a href="#" class="btn btn-primary li_memo">' .
            $_L['Memo'] .
            '</a>

            <hr>

            ' .
            $d->notes .
            '

            ';
        }

        break;

        case 'company_invoices':
        $cid = _post('cid');
        $d = ORM::for_table('sys_companies')->find($cid);

        if ($d) {
            // find all customers with that company_id

            $customers = Contacts::findByCompany($cid);

            //  var_dump($invoices);

            if ($customers) {
                $invoices = ORM::for_table('sys_invoices')
                ->where_in('userid', $customers)
                ->find_array();

                $dt = '';

                foreach ($invoices as $invoice) {
                    $dt .=
                    '<tr>
                    <td><a href="' .
                    U .
                    'invoices/view/' .
                    $invoice['id'] .
                    '/">' .
                    $invoice['invoicenum'] .
                    ' ' .
                    ($invoice['cn'] != ''
                        ? $invoice['cn']
                        : $invoice['id']) .
                    '</a> </td>
                    <td><a href="' .
                    U .
                    'contacts/view/' .
                    $invoice['userid'] .
                    '/">' .
                    $invoice['account'] .
                    '</a></td>
                    <td class="amount" data-a-dec="." data-a-sep="," data-a-pad="true" data-p-sign="p" data-a-sign="$ " data-d-group="3">' .
                    formatCurrency(
                        $invoice['total'],
                        $invoice['currency_iso_code'] ?? false
                    ) .
                    '</td>
                    <td>' .
                    $invoice['date'] .
                    '</td>
                    <td>' .
                    $invoice['duedate'] .
                    '</td>
                    <td>' .
                    $invoice['status'] .
                    '</td>
                    <td>
                    <a href="' .
                    U .
                    'invoices/view/' .
                    $invoice['id'] .
                    '/" class="btn btn-primary btn-xs"><i class="fa fa-check"></i> </a>
                    <a href="' .
                    U .
                    'invoices/edit/' .
                    $invoice['id'] .
                    '/" class="btn btn-info btn-xs"><i class="fa fa-pencil"></i> </a>
                    </td>
                    </tr>';
                }

                $tds = $dt == '' ? '<tr><td colspan="7">' .
                $_L['No Data Available'] .
                '</td> </tr>' : $dt;
            } else {
                $tds =
                '<tr><td colspan="7">' .
                $_L['No Data Available'] .
                '</td> </tr>';
            }

            echo '<table class="table table-bordered table-hover sys_table">
            <thead>
            <tr>
            <th>#</th>
            <th>' .
            $_L['Customer'] .
            '</th>
            <th>' .
            $_L['Amount'] .
            '</th>
            <th>' .
            $_L['Invoice Date'] .
            '</th>
            <th>' .
            $_L['Due Date'] .
            '</th>
            <th>' .
            $_L['Status'] .
            '</th>
            <th class="text-right">' .
            $_L['Manage'] .
            '</th>
            </tr>
            </thead>
            <tbody>

            
            ' .
            $tds .
            ' 


            </tbody>
            </table>';
        }

        break;

        case 'company_quotes':
        $cid = _post('cid');
        $d = ORM::for_table('sys_companies')->find($cid);

        if ($d) {
            // find all customers with that company_id

            $customers = Contacts::findByCompany($cid);

            //  var_dump($invoices);

            if ($customers) {
                $quotes = ORM::for_table('sys_quotes')
                ->where_in('userid', $customers)
                ->find_array();

                $dt = '';

                foreach ($quotes as $quote) {
                    $dt .=
                    '<tr>
                    <td>' .
                    $quote['id'] .
                    ' </td>
                    <td><a href="' .
                    U .
                    'contacts/view/' .
                    $quote['userid'] .
                    '/">' .
                    $quote['account'] .
                    '</a></td>
                    <td><a href="' .
                    U .
                    'quotes/view/' .
                    $quote['id'] .
                    '/">' .
                    $quote['subject'] .
                    '</a></td>
                    <td class="amount" data-a-dec="." data-a-sep="," data-a-pad="true" data-p-sign="p" data-a-sign="$ " data-d-group="3">' .
                    formatCurrency(
                        $quote['total'],
                        $quote['currency_iso_code'] ?? false
                    ) .
                    '</td>
                    <td>' .
                    $quote['datecreated'] .
                    '</td>
                    <td>' .
                    $quote['validuntil'] .
                    '</td>
                    <td>' .
                    $quote['stage'] .
                    '</td>
                    <td>
                    <a href="' .
                    U .
                    'quotes/view/' .
                    $quote['id'] .
                    '/" class="btn btn-primary btn-xs"><i class="fa fa-check"></i></a>
                    <a href="' .
                    U .
                    'quotes/edit/' .
                    $quote['id'] .
                    '/" class="btn btn-info btn-xs"><i class="fa fa-repeat"></i></a>
                    </td>
                    </tr>';
                }

                $tds = $dt == '' ? '<tr><td colspan="8">' .
                $_L['No Data Available'] .
                '</td> </tr>' : $dt;
            } else {
                $tds =
                '<tr><td colspan="8">' .
                $_L['No Data Available'] .
                '</td> </tr>';
            }

            echo '<table class="table table-bordered table-hover sys_table">
            <thead>
            <tr>
            <th>#</th>
            <th>' .
            $_L['Customer'] .
            '</th>
            <th>' .
            $_L['Subject'] .
            '</th>
            <th>' .
            $_L['Amount'] .
            '</th>
            <th>' .
            $_L['Date Created'] .
            '</th>
            <th>' .
            $_L['Expiry Date'] .
            '</th>
            <th>' .
            $_L['Stage'] .
            '</th>
            <th class="text-right">' .
            $_L['Manage'] .
            '</th>
            </tr>
            </thead>
            <tbody>

            
            ' .
            $tds .
            ' 


            </tbody>
            </table>';
        }

        break;

        case 'company_orders':
        $cid = _post('cid');
        $d = ORM::for_table('sys_companies')->find($cid);

        if ($d) {
            // find all customers with that company_id

            $customers = Contacts::findByCompany($cid);

            //  var_dump($invoices);

            if ($customers) {
                $orders = ORM::for_table('sys_orders')
                ->where_in('cid', $customers)
                ->find_array();

                $dt = '';

                foreach ($orders as $order) {
                    $dt .=
                    '<tr>

                    <td><a href="' .
                    U .
                    'orders/view/' .
                    $order['id'] .
                    '">' .
                    $order['ordernum'] .
                    '</a> </td>
                    <td>' .
                    date($config['df'], strtotime($order['date_added'])) .
                    '</td>
                    <td><a href="' .
                    U .
                    'contacts/view/' .
                    $order['cid'] .
                    '">' .
                    $order['cname'] .
                    '</a> </td>
                    <td>' .
                    $order['amount'] .
                    '</td>
                    <td>' .
                    $order['status'] .
                    '</td>


                    </tr>';
                }

                $tds = $dt == '' ? '<tr><td colspan="5">' .
                $_L['No Data Available'] .
                '</td> </tr>' : $dt;
            } else {
                $tds =
                '<tr><td colspan="6">' .
                $_L['No Data Available'] .
                '</td> </tr>';
            }

            echo '<table class="table table-bordered table-responsive table-hover sys_table" style="width: 100%;">
            <thead>
            <tr>

            <th>' .
            $_L['Order'] .
            ' #</th>
            <th>' .
            $_L['Date'] .
            '</th>
            <th>' .
            $_L['Customer'] .
            '</th>
            <th>' .
            $_L['Total'] .
            '</th>
            <th>' .
            $_L['Status'] .
            '</th>

            </tr>
            </thead>
            <tbody>

            
            ' .
            $tds .
            ' 


            </tbody>
            </table>';
        }

        break;

        case 'company_files':
        break;

        case 'company_transactions':
        $cid = _post('cid');
        $d = ORM::for_table('sys_companies')->find($cid);

        if ($d) {
            // find all customers with that company_id

            $customers = Contacts::findByCompany($cid);

            //  var_dump($invoices);

            if ($customers) {
                $transactions_payer = ORM::for_table('sys_transactions')
                ->where_in('payerid', $customers)
                ->find_array();
                $transactions_payee = ORM::for_table('sys_transactions')
                ->where_in('payeeid', $customers)
                ->find_array();

                $transactions = array_merge(
                    $transactions_payer,
                    $transactions_payee
                );

                $dt = '';

                foreach ($transactions as $transaction) {
                    $dt .=
                    '<tr>
                    <td>' .
                    $transaction['id'] .
                    ' </td>
                    <td>' .
                    $transaction['date'] .
                    '</td>
                    <td>' .
                    $transaction['account'] .
                    '</td>
                    <td>' .
                    $transaction['type'] .
                    '</td>

                    <td class="amount" data-a-dec="." data-a-sep="," data-a-pad="true" data-p-sign="p" data-a-sign="$ " data-d-group="3">' .
                    $transaction['amount'] .
                    '</td>
                    <td>' .
                    $transaction['description'] .
                    '</td>
                    <td>' .
                    $transaction['dr'] .
                    '</td>
                    <td>' .
                    $transaction['cr'] .
                    '</td>
                    <td>' .
                    $transaction['bal'] .
                    '</td>
                    <td>
                    <a href="' .
                    U .
                    'transactions/manage/' .
                    $transaction['id'] .
                    '/" class="btn btn-primary btn-xs"><i class="fa fa-check"></i></a>

                    </td>
                    </tr>';
                }

                $tds = $dt == '' ? '<tr><td colspan="10">' .
                $_L['No Data Available'] .
                '</td> </tr>' : $dt;
            } else {
                $tds =
                '<tr><td colspan="10">' .
                $_L['No Data Available'] .
                '</td> </tr>';
            }

            echo '<table class="table table-bordered table-responsive table-hover sys_table">
            <thead>
            <tr>
            <th>#</th>
            <th>' .
            $_L['Date'] .
            '</th>
            <th>' .
            $_L['Account'] .
            '</th>
            <th>' .
            $_L['Type'] .
            '</th>
            <th>' .
            $_L['Amount'] .
            '</th>
            <th>' .
            $_L['Description'] .
            '</th>
            <th>' .
            $_L['Dr'] .
            '</th>
            <th>' .
            $_L['Cr'] .
            '</th>
            <th>' .
            $_L['Balance'] .
            '</th>
            <th class="text-right">' .
            $_L['Manage'] .
            '</th>
            </tr>
            </thead>
            <tbody>

            
            ' .
            $tds .
            ' 


            </tbody>
            </table>';
        }

        break;

        case 'json_list':
        $show_company_column = false;
        $show_group_column = false;

        if (
            isset($config['contact_list_show_company_column']) &&
            $config['contact_list_show_company_column'] == 1
        ) {
            $show_company_column = true;
        }

        if (
            isset($config['contact_list_show_group_column']) &&
            $config['contact_list_show_group_column'] == 1
        ) {
            $show_group_column = true;
        }

        $columns = [];

        $columns[] = '';
        $columns[] = 'id';
        $columns[] = 'img';
        $columns[] = 'account';

        if ($show_company_column) {
            $columns[] = 'company';
        }

        if ($show_group_column) {
            $columns[] = 'gname';
        }

        $columns[] = 'email';
        $columns[] = 'phone';
        $columns[] = '';

        $order_by = $data['order'];

        $o_c_id = $order_by[0]['column'];
        $o_type = $order_by[0]['dir'];

        $a_order_by = $columns[$o_c_id];

        $d = ORM::for_table('crm_accounts');

        $d->select('id');
        $d->select('account');
        $d->select('code');
        $d->select('img');

        if ($show_company_column) {
            $d->select('company');
        }

        if ($show_group_column) {
            $d->select('gname');
        }

        $d->select('email');
        $d->select('phone');

        $account = _post('account');

        if ($account != '') {
            $d->where_like('account', "%$account%");
        }

        $email = _post('email');

        if ($email != '') {
            $d->where_like('email', "%$email%");
        }

        $company = _post('company');

        if ($company != '') {
            $d->where_like('company', "%$company%");
        }

        $group = _post('group');

        if ($group != '') {
            $d->where_like('gname', "%$group%");
        }

        $phone = _post('phone');

        if ($phone != '') {
            $d->where_like('phone', "%$phone%");
        }

        $type = route(2);

        if ($type == 'supplier') {
            $d->where_like('type', "%Supplier%");
        } else {
            $d->where_like('type', "%Customer%");
        }

        if (!has_access($user->roleid, 'customers', 'all_data')) {
            $d->where('o', $user->id);
        }

        $iTotalRecords = $d->count();

        $iDisplayLength = (int) $_REQUEST['length'];
        $iDisplayLength =
        $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = (int) $_REQUEST['start'];
        $sEcho = (int) $_REQUEST['draw'];

        $records = [];
        $records["data"] = [];

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        if ($o_type == 'desc') {
            $d->order_by_desc($a_order_by);
        } else {
            $d->order_by_asc($a_order_by);
        }

        $d->limit($iDisplayLength);
        $d->offset($iDisplayStart);
        $x = $d->find_array();

        $i = $iDisplayStart;

        $colors = Colors::colorNames();

        foreach ($x as $xs) {
            $full_name = $xs['account'];

            if ($xs['img'] == '') {
                $css_bg = $colors[array_rand($colors)];

                $full_name_e = explode(' ', $full_name);

                $fn_count = count($full_name_e);

                $first_name = $fn_count == 0 ? '' : $full_name_e[0];

                $first_name_letter = $first_name == '' ? 'N' : $first_name[0];

                if (isset($full_name_e[1])) {
                    $last_name = $full_name_e[1];
                    $last_name_letter = isset($last_name[0]) ? $last_name[0] : '';
                } else {
                    $last_name_letter = '';
                }

                $two_l = strtoupper(
                    htmlentities($first_name_letter . $last_name_letter)
                );

                if ($two_l == '') {
                    $two_l = 'NA';
                }

                $img =
                '<span class="ib_avatar ib_bg_' .
                $css_bg .
                '">' .
                $two_l .
                '</span>';
            } else {
                $img =
                '<img src="' .
                APP_URL .
                '/' .
                $xs['img'] .
                '" class="img-thumbnail img-responsive" style="max-height: 32px;" alt="' .
                $full_name .
                '">';
            }

            $phone = $xs['phone'] == '' ? $_L['n_a'] : $xs['phone'];

            if ($xs['code'] != '') {
                $contact_details =
                htmlentities($xs['account']) . ' <br> ' . $xs['code'];
            } else {
                $contact_details = htmlentities($xs['account']);
            }

            if ($show_group_column && $show_company_column) {
                $records["data"][] = [
                    0 =>
                    '<input id="row_' .
                    $xs['id'] .
                    '" type="checkbox" value="" name=""  class="i-checks"/>',
                    1 => $xs['id'],
                    2 =>
                    '<a href="' .
                    U .
                    'contacts/view/' .
                    $xs['id'] .
                    '">' .
                    $img .
                    '</a>',
                    3 => $contact_details,
                    4 => htmlentities($xs['company']),
                    5 => htmlentities($xs['gname']),
                    6 => htmlentities($xs['email']),
                    7 => htmlentities($xs['phone']),
                    8 =>
                    '
                    <a href="' .
                    U .
                    'contacts/view/' .
                    $xs['id'] .
                    '" class="btn btn-primary btn-xs cview" id="vid' .
                    $xs['id'] .
                    '"><i class="fa fa-search"></i> </a>
                    <a href="' .
                    U .
                    'contacts/view/' .
                    $xs['id'] .
                    '/edit/" class="btn btn-warning btn-xs cedit" id="eid' .
                    $xs['id'] .
                    '"><i class="glyphicon glyphicon-pencil"></i> </a>
                    <a href="#" class="btn btn-danger btn-xs cdelete" id="uid' .
                    $xs['id'] .
                    '"><i class="fa fa-trash"></i> </a>
                    ',

                    9 => $xs['id'],

                    "DT_RowId" => 'dtr_' . $xs['id'],
                ];
            } elseif (
                $show_company_column == false &&
                $show_group_column == true
            ) {
                $records["data"][] = [
                    0 =>
                    '<input id="row_' .
                    $xs['id'] .
                    '" type="checkbox" value="" name=""  class="i-checks"/>',
                    1 => $xs['id'],
                    2 =>
                    '<a href="' .
                    U .
                    'contacts/view/' .
                    $xs['id'] .
                    '">' .
                    $img .
                    '</a>',
                    3 => $contact_details,
                    4 => htmlentities($xs['gname']),
                    5 => htmlentities($xs['email']),
                    6 => htmlentities($xs['phone']),
                    7 =>
                    '
                    <a href="' .
                    U .
                    'contacts/view/' .
                    $xs['id'] .
                    '" class="btn btn-primary btn-xs cview" id="vid' .
                    $xs['id'] .
                    '"><i class="fa fa-search"></i> </a>
                    <a href="' .
                    U .
                    'contacts/view/' .
                    $xs['id'] .
                    '/edit/" class="btn btn-warning btn-xs cedit" id="eid' .
                    $xs['id'] .
                    '"><i class="glyphicon glyphicon-pencil"></i> </a>
                    <a href="#" class="btn btn-danger btn-xs cdelete" id="uid' .
                    $xs['id'] .
                    '"><i class="fa fa-trash"></i> </a>
                    ',

                    9 => $xs['id'],

                    "DT_RowId" => 'dtr_' . $xs['id'],
                ];
            } elseif (
                $show_company_column == true &&
                !$show_group_column
            ) {
                $records["data"][] = [
                    0 =>
                    '<input id="row_' .
                    $xs['id'] .
                    '" type="checkbox" value="" name=""  class="i-checks"/>',
                    1 => $xs['id'],
                    2 =>
                    '<a href="' .
                    U .
                    'contacts/view/' .
                    $xs['id'] .
                    '">' .
                    $img .
                    '</a>',
                    3 => $contact_details,
                    4 => htmlentities($xs['company']),
                    5 => htmlentities($xs['email']),
                    6 => htmlentities($xs['phone']),
                    7 =>
                    '
                    <a href="' .
                    U .
                    'contacts/view/' .
                    $xs['id'] .
                    '" class="btn btn-primary btn-xs cview" id="vid' .
                    $xs['id'] .
                    '"><i class="fa fa-search"></i> </a>
                    <a href="' .
                    U .
                    'contacts/view/' .
                    $xs['id'] .
                    '/edit/" class="btn btn-warning btn-xs cedit" id="eid' .
                    $xs['id'] .
                    '"><i class="glyphicon glyphicon-pencil"></i> </a>
                    <a href="#" class="btn btn-danger btn-xs cdelete" id="uid' .
                    $xs['id'] .
                    '"><i class="fa fa-trash"></i> </a>
                    ',

                    9 => $xs['id'],

                    "DT_RowId" => 'dtr_' . $xs['id'],
                ];
            } else {
                $records["data"][] = [
                    0 =>
                    '<input id="row_' .
                    $xs['id'] .
                    '" type="checkbox" value="" name=""  class="i-checks"/>',
                    1 => $xs['id'],
                    2 =>
                    '<a href="' .
                    U .
                    'contacts/view/' .
                    $xs['id'] .
                    '">' .
                    $img .
                    '</a>',
                    3 => $contact_details,
                    4 => htmlentities($xs['email']),
                    5 => htmlentities($xs['phone']),
                    6 =>
                    '
                    <a href="' .
                    U .
                    'contacts/view/' .
                    $xs['id'] .
                    '" class="btn btn-primary btn-xs cview" id="vid' .
                    $xs['id'] .
                    '"><i class="fa fa-search"></i> </a>
                    <a href="' .
                    U .
                    'contacts/view/' .
                    $xs['id'] .
                    '/edit/" class="btn btn-warning btn-xs cedit" id="eid' .
                    $xs['id'] .
                    '"><i class="glyphicon glyphicon-pencil"></i> </a>
                    <a href="#" class="btn btn-danger btn-xs cdelete" id="uid' .
                    $xs['id'] .
                    '"><i class="fa fa-trash"></i> </a>
                    ',

                    9 => $xs['id'],

                    "DT_RowId" => 'dtr_' . $xs['id'],
                ];
            }
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        // var_dump($records);

        //   exit;

        api_response($records);

        break;

        case 'set_group':
        $ids_raw = $data['ids'];
        $gid = _post('gid');

        $g = ORM::for_table('crm_groups')->find($gid);

        if ($g) {
            $gid = $g->id;
            $gname = $g->gname;
        } else {
            $gid = '0';
            $gname = '';
        }

        foreach ($ids_raw as $id_single) {
            $id = str_replace('row_', '', $id_single);
            $c = ORM::for_table('crm_accounts')
            ->select('id')
            ->find($id);
            if ($c) {
                $c->gid = $gid;
                $c->gname = $gname;
                $c->save();
            }
        }

        echo $_L['Data Updated'];

        break;

        case 'add_fund':
        $amount = _post('amount');
        $cid = _post('cid');

        $customer = ORM::for_table('crm_accounts')->find($cid);

        if ($customer) {
            //            if(v::numeric()->between(0, 999999999999)->validate($amount)){
            //
            //                $prev_balance = $customer->balance;
            //
            //                $new_balance = $prev_balance+$amount;
            //
            //                $customer->balance = $new_balance;
            //                $customer->save();
            //
            //                _log('Amount '.$amount.' Added by Admin ['.$user->fullname.']'.' Customer - '.$customer->account.' Previous Balance: '.$prev_balance.' New Balance: '.$new_balance,'Client',$customer->id);
            //
            //            }

            if (is_numeric($amount)) {
                $prev_balance = $customer->balance;

                $new_balance = $prev_balance + $amount;

                $customer->balance = $new_balance;
                $customer->save();

                _log(
                    $_L['Amount'] .
                    ' ' .
                    $amount .
                    ' Added by Admin [' .
                    $user->fullname .
                    ']' .
                    ' Customer - ' .
                    $customer->account .
                    ' Previous Balance: ' .
                    $prev_balance .
                    ' New Balance: ' .
                    $new_balance,
                    'Client',
                    $customer->id
                );

                r2(
                    U . 'contacts/view/' . $cid . '/summary/',
                    's',
                    $_L['added_successful']
                );
            } else {
                r2(
                    U . 'contacts/view/' . $cid . '/summary/',
                    'e',
                    $_L['amount_error']
                );
            }
        }

        break;

        case 'return_fund':
        $amount = _post('amount');
        $cid = _post('cid');

        $customer = ORM::for_table('crm_accounts')->find($cid);

        if ($customer) {
            if (is_numeric($amount)) {
                $prev_balance = $customer->balance;

                $new_balance = $prev_balance - $amount;

                $customer->balance = $new_balance;
                $customer->save();

                _log(
                    'Amount ' .
                    $amount .
                    ' Balance returned by Admin [' .
                    $user->fullname .
                    ']' .
                    ' Customer - ' .
                    $customer->account .
                    ' Previous Balance: ' .
                    $prev_balance .
                    ' New Balance: ' .
                    $new_balance,
                    'Client',
                    $customer->id
                );

                r2(
                    U . 'contacts/view/' . $cid . '/summary/',
                    's',
                    $_L['added_successful']
                );
            } else {
                r2(
                    U . 'contacts/view/' . $cid . '/summary/',
                    'e',
                    $_L['amount_error']
                );
            }
        }

        break;

        case 'log':
        $cid = _post('cid');

        $logs = ORM::for_table('app_sms')
        ->limit(1000)
        ->order_by_desc('id')
        ->find_array();

        /*$logs = ORM::for_table('app_sms')
        ->where('iid', $cid)
        ->limit(1000)
        ->order_by_desc('id')
        ->find_array();*/
        $tr = '';


        foreach ($logs as $log) {
            $tr .=
            '<tr>
            <td>' .
            $log['created_at'] .
            '</td>
            <td>' .
            $log['sms_from'] .
            '</td>
            <td>' .
            $log['sms_to'] .
            '</td>
            <td>' .
            $log['sms'] .
            '</td>
            </tr>';
        }

        echo '<table class="table table-bordered table-hover sys_table">
        <thead>
        <tr>
        <th>Date time</th>
        <th>From</th>
        <th>To</th>
        <th>Message</th>
        
        </tr>
        </thead>
        <tbody>

        ' .
        $tr .
        '



        </tbody>
        </table>';

        break;

        case 'options':
        $ib_options = [];
        $ib_options['add_fund'] = false;

        echo json_encode($ib_options);

        break;

        case 'get_company_details':
        $cid = route(2);

        $company = Company::find($cid);

        if ($company) {
            api_response($company);
        } else {
            api_response([
                'message' => 'Company Not Found',
                'success' => false,
            ]);
        }

        break;

        case 'client-password-manager':
        $cid = _post('cid');

        $passwords = PasswordManager::where('client_id', $cid)->get();

        view('profile_client_password_manager', [
            'passwords' => $passwords,
        ]);

        break;

        case 'payment-method':
        $cid = _post('cid');

        //echo $cid; exit;

        _auth();
        $user = User::_info();
        $ui->assign('user', $user);

        $ui->assign('url_base', U);
        $ui->assign('id_user', $user["id"]);
        $ui->assign('customer_id', $cid);

        //echo json_encode($user); exit;

        //$passwords = PasswordManager::where('client_id', $cid)->get();

        view('ajax-contact-payment-method', [
            //'id_user' => "cesar",
        ]);

        break;

        case 'company-files':
            $cid = _post('cid');

            //echo $cid; exit;

            _auth();
            $user = User::_info();
            $ui->assign('user', $user);

            $ui->assign('url_base', U);
            $ui->assign('id_user', $user["id"]);
            $ui->assign('customer_id', $cid);
            
            $ArrayCompanyFile = ORM::get_db()->query("SELECT 
                CACom.*,

                SCom.id AS id_company,
                SCom.company_name,

                CDoc.`UUID`,
                CDoc.`UUID_ENC`,
                CDoc.`sys_companies_id`,
                CDoc.`nombre_original`,
                CDoc.`extension`,
                CDoc.`nombre_img_sistema`,
                CDoc.`url`,
                CONCAT(CDoc.url,CDoc.nombre_img_sistema) AS ruta_documento


            FROM `crm_accounts_company` AS CACom
            LEFT JOIN sys_companies AS SCom ON SCom.id = CACom.idCompany
            LEFT JOIN company_documents AS CDoc ON CDoc.sys_companies_id = SCom.id
            
            WHERE CACom.crm_account_id = $cid ;")->fetchAll(PDO::FETCH_ASSOC);


            $ui->assign('ArrayCompanyFile', json_encode($ArrayCompanyFile));
            //echo json_encode($ArrayCompanyFile); exit;

            //echo json_encode($user); exit;

            //$passwords = PasswordManager::where('client_id', $cid)->get();

            view('ajax-contact-company-files', [
                //'id_user' => "cesar",
            ]);

        break;

        case 'get-payment-method-customer':
         

            $json = file_get_contents('php://input');

            // Decodifica el JSON a un array asociativo
            $informacion_front = json_decode($json, true);

            $customer_id  = $informacion_front['customer_id'];
            
            if(empty($customer_id) == true)
            {
                $response = array(
                    "type" => "error",
                    "message" => 'Customer ID is required.',
                    "data" => [],
                );
                print_r(json_encode( $response)) ; exit;
            }

            $mysqli = null;
            $response = array();

            try {
                // Conexión a la base de datos
                $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
                if ($mysqli->connect_error) {
                    //throw new Exception("Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error);

                    $response = array(
                        "type" => "error",
                        "message" => "Database connection or query failed" . $mysqli->connect_errno,
                    );
                    echo json_encode($response); exit;

                }

                $mysqli->set_charset("utf8");
 
                $DB_NAME = DB_NAME;
    
                //--------------------
                $sql = "SELECT 
                        RPros.*, 
                        BPros.name AS nombre_banco_metodo_pago
 
                    FROM $DB_NAME.`credit_plan_payment_method` AS RPros
                    LEFT JOIN $DB_NAME.`bank_prospecting` AS BPros ON BPros.id = RPros.banco_metodo_pago  
                    WHERE RPros.crm_account_id = $customer_id ";

                $data_credit_plan_payment_method = $mysqli->query($sql)->fetch_all(MYSQLI_ASSOC);

                //Devolver los resultados como JSON
                //echo json_encode($data_sys_config); exit;

                //--------------------
                $sql = "SELECT 
                        SPg.* 
 
                    FROM $DB_NAME.`sys_pg` AS SPg
                    
                    WHERE SPg.processor IN ('square', 'stripe') AND SPg.status = 'Active' ";

                $data_payment_gateway = $mysqli->query($sql)->fetch_all(MYSQLI_ASSOC);

                //Devolver los resultados como JSON
                //echo json_encode($data_payment_gateway); exit;

                $response = array(
                    "type" => "success",
                    "message" => "",

                    "data_credit_plan_payment_method"  => $data_credit_plan_payment_method,
                    "data_payment_gateway"             => $data_payment_gateway,
                );
                
                echo json_encode($response);

            } catch (Exception $e) {
                $response = array(
                    "type" => "error",
                    "message" => "Database connection or query failed",
                    "detalle" => $e->getMessage()
                );

                echo json_encode($response);
            } finally {
                // Cerrar la conexión si existe
                if ($mysqli !== null) {
                    $mysqli->close();
                }
            }

         

        break;

        //api post
        case 'post-payment-method-customer':

            $json = file_get_contents('php://input');

            // Decodifica el JSON a un array asociativo
            $informacion_front = json_decode($json, true);

            $esBorrador  = $informacion_front['esBorrador'];
            $customer_id  = $informacion_front['customer_id'];
    
            $arreglo_planes                   = $informacion_front['arreglo_planes'] ?? [];
            $eliminar_metodo_pagos            = $informacion_front['eliminar_metodo_pagos'] ?? [];

            if(empty($customer_id) == true)
            {
                $response = array(
                    "type" => "error",
                    "message" => '!The client id is required.',
                    "data" => [],
                );
                print_r(json_encode( $response)) ; exit;
            }

            //if(count($arreglo_planes) == 0)
            //{
            //    $response = array(
            //        "type" => "error",
            //        "message" => '!The "Specify the payment method for installments" section must have at least one payment method added.',
            //        "data" => [],
            //    );
            //    print_r(json_encode( $response)) ; exit;
            //}
    
            $mysqli = null;
            $response = array();

            try {
                // Conexión a la base de datos
                $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
                if ($mysqli->connect_error) {
                    //throw new Exception("Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error);

                    $response = array(
                        "type" => "error",
                        "message" => "Database connection or query failed" . $mysqli->connect_errno,
                    );
                    echo json_encode($response); exit;

                }

                $mysqli->set_charset("utf8");

                $DB_NAME = DB_NAME;
    
                $sql = "SELECT * FROM $DB_NAME.`crm_accounts` WHERE `id` = $customer_id ";
                $data_general_informacion = $mysqli->query($sql)->fetch_assoc();

                if(empty($data_general_informacion) == true)
                {
                    $response = array(
                        "type" => "error",
                        "message" => '!The client id is required.',
                        "data" => [],
                    );
                    print_r(json_encode( $response)) ; exit;
                }
                
                //echo json_encode($data_general_informacion); exit;
                
                $correo_electronico_cliente_igp = $data_general_informacion["email"];
                $nombre_cliente_igp             = $data_general_informacion["account"];
                $crm_account_id_igp             = $data_general_informacion["id"];
                $email_address_igp              = $data_general_informacion["email"];
                $postal_code_igp                = $data_general_informacion["zip_hi"];
                $first_name                     = $data_general_informacion["account"];
                $address_line_1                 = $data_general_informacion["address"];

                //echo $nombre_cliente_igp; exit;
                //echo json_encode($data_general_informacion); exit;

                $sql = "SELECT * FROM $DB_NAME.`sys_appconfig` WHERE `setting` = 'url_api_square' ";
                $data_url_square = $mysqli->query($sql)->fetch_assoc();

                if(empty($data_url_square) == true)
                {
                    $response = array(
                        "type" => "error",
                        "message" => "No record found for Square endpoint in configuration.",
                    );
                    echo json_encode($response); exit;
                }

                $url_square = $data_url_square["value"];
                $url_square = rtrim($url_square, "/");
                
                if(empty($url_square) == true)
                {
                    $response = array(
                        "type" => "error",
                        "message" => "No record found for Square endpoint in configuration...",
                    );
                    echo json_encode($response); exit;
                }
 
                //echo $url_square; exit;
    
                //echo json_encode($data_plan); exit;

                $sys_pg_id        = null;
                $sys_pg_pk_stripe = null;
                $sys_pg_sk_stripe = null;

                $client_stripe_id = null;
    
                //---------------------------
 
                if($eliminar_metodo_pagos != null)
                {
                    if(count($eliminar_metodo_pagos) != 0)
                    {
                        $ids = array_column($eliminar_metodo_pagos, 'id');
                        $listaEliminarId = implode(',', $ids);

                        if(empty($listaEliminarId) == false)
                        {
                            $sql = "DELETE FROM `credit_plan_payment_method` WHERE id IN ($listaEliminarId) ";
                            $mysqli->query($sql);
                        }

                    }
                }
                
                //exit;
 
                /* if($arreglo_planes != null)
                {
                    foreach($arreglo_planes as $item)
                    {
                        $id = $item["id"];

                        $tipo_cuenta                = empty($item["tipo_cuenta"])  == true? null : $item["tipo_cuenta"];
                        $nombre_tipo_cuenta         = empty($item["nombre_tipo_cuenta"])  == true? null : $item["nombre_tipo_cuenta"];
                        $tipo_pasarela_pago         = empty($item["tipo_pasarela_pago"])  == true? null : $item["tipo_pasarela_pago"];
                        $titular_tarjeta            = empty($item["titular_tarjeta"])  == true? null : $item["titular_tarjeta"];
                        $numero_tarjeta             = empty($item["numero_tarjeta"])  == true? null : $item["numero_tarjeta"];
                        $codigo_ccv                 = empty($item["codigo_ccv"])  == true? null : $item["codigo_ccv"];
                        $exp_month                  = empty($item["exp_month"])  == true? null : $item["exp_month"];
                        $exp_year                   = empty($item["exp_year"])  == true? null : $item["exp_year"];
                        $estado_id                  = empty($item["estado_id"])  == true? null : $item["estado_id"];
                        $use_credit_card            = empty($item["use_credit_card"])  == true? null : $item["use_credit_card"];
                        $cnon_tarjetas_square       = empty($item["cnon_tarjetas_square"])  == true? null : $item["cnon_tarjetas_square"];
                        $estado_nombre              = empty($item["estado_nombre"])  == true? null : $item["estado_nombre"];
                        $use_credit_card_nombre     = empty($item["use_credit_card_nombre"])  == true? null : $item["use_credit_card_nombre"];
                        $UUID                       = empty($item["UUID"])  == true? null : $item["UUID"];
                        $UUID_ENC                   = empty($item["UUID_ENC"])  == true? null : $item["UUID_ENC"];
                        $banco_metodo_pago          = empty($item["banco_metodo_pago"])  == true? null : $item["banco_metodo_pago"];
                        $nombre_banco_metodo_pago   = empty($item["nombre_banco_metodo_pago"])  == true? null : $item["nombre_banco_metodo_pago"];

                        $numero_ruta_metodo_pago    = empty($item["numero_ruta_metodo_pago"])  == true? null : $item["numero_ruta_metodo_pago"];
                        $tipo_titular_metodo_pago   = empty($item["tipo_titular_metodo_pago"])  == true? null : $item["tipo_titular_metodo_pago"];
                        $email_metodo_pago          = empty($item["email_metodo_pago"])  == true? null : $item["email_metodo_pago"];
                        $configuracion_stripe_id    = empty($item["configuracion_stripe_id"])  == true? null : $item["configuracion_stripe_id"];
                        $payment_method             = empty($item["payment_method"])  == true? null : $item["payment_method"];
                        
                        $configuracion_stripe_id             = empty($item["configuracion_stripe_id"])  == true? null : $item["configuracion_stripe_id"];
    
                        //echo $configuracion_stripe_id; exit;

                        $sql = "SELECT * FROM $DB_NAME.`sys_pg` WHERE `id` = $configuracion_stripe_id ";
                        $registroPasarelaPago = $mysqli->query($sql)->fetch_assoc();

                        //echo json_encode($registroPasarelaPago); exit;

                        if(empty($registroPasarelaPago) == false)
                        {
                            
                            //$customer_id_stripe = $data_general_informacion["customer_id_stripe"];

                            $sys_pg_id        = $registroPasarelaPago["id"];
                            $sys_pg_sk_stripe = $registroPasarelaPago["c1"];
                            $sys_pg_pk_stripe = $registroPasarelaPago["value"];

                            $sys_pg_aplication_id_square = $registroPasarelaPago["value"];
                            $sys_pg_token_square         = $registroPasarelaPago["c1"];
                            $sys_pg_location_id_square   = $registroPasarelaPago["c2"];
                            $sys_pg_version_square       = $registroPasarelaPago["c3"];

                            $stripe_configuration_ = [
                                "id_stripe" => $sys_pg_id,
                                "pk_stripe" => $sys_pg_pk_stripe,
                                "sk_stripe" => $sys_pg_sk_stripe,
                            ];

                            $square_configuration_ = [
                                "sys_pg_aplication_id_square" => $sys_pg_aplication_id_square,
                                "sys_pg_token_square"         => $sys_pg_token_square,
                                "sys_pg_location_id_square"   => $sys_pg_location_id_square,
                                "sys_pg_version_square"       => $sys_pg_version_square,
                            ];
    
                            //echo json_encode($square_configuration_); exit;

                            //$customer_id_square = $data_general_informacion["customer_id_square"];
                            //exit;

                            if(empty($id) == true)
                            {

                                if($tipo_cuenta == "1" || $tipo_cuenta == "2")
                                {
                                    $sql = "SELECT * FROM $DB_NAME.`credit_plan_payment_method` WHERE `crm_account_id` = $crm_account_id_igp AND configuracion_stripe_id = $configuracion_stripe_id";
                                    $existeCustomerStripe = $mysqli->query($sql)->fetch_assoc();

                                    if(empty($existeCustomerStripe) == true)
                                    {
                                        $stripe = new \Stripe\StripeClient($sys_pg_sk_stripe);
            
                                        // 1. Crear un Customer
                                        $customer = $stripe->customers->create([
                                            'email' => $correo_electronico_cliente_igp,
                                            'name'  => $nombre_cliente_igp ,
                                        ]);

                                        $customer_id_stripe = $customer->id;
 

                                    }else{
                                        $customer_id_stripe = $existeCustomerStripe["customer_id"];
                                    }

                                    if(empty($sys_pg_sk_stripe) == false &&  empty($customer_id_stripe) == false)
                                    {
                                        $informacionEnviar = [
                                            "sk"                  => $sys_pg_sk_stripe,
                                            "account_number"      => $numero_tarjeta,
                                            "routing_number"      => $numero_ruta_metodo_pago,
                                            "account_holder_type" => $tipo_titular_metodo_pago,
                                            "name"                => $titular_tarjeta,
                                            "email"               => $email_metodo_pago,
                                            "customer_id"         => $customer_id_stripe,
                                        ];
        
                                        $salida = crearCuentaBancaria($informacionEnviar);
                                        
                                        //echo json_encode($salida); exit;

                                        if($salida["status"] == true)
                                        {

                                            $setup_intent   = $salida["setup_intent"];
                                            $payment_method = $salida["payment_method"];
                                            $customer_id    = $salida["customer_id"];

                                            $tarjetas_id_square = null;

                                            $stripe_configuration_ = [
                                                "id_stripe" => $sys_pg_id,
                                                "pk_stripe" => $sys_pg_pk_stripe,
                                                "sk_stripe" => $sys_pg_sk_stripe,
                                            ];

                                            $sql = "INSERT INTO $DB_NAME.credit_plan_payment_method (
                                                `id_gip`,
                                                `UUID`,
                                                `UUID_ENC`,
                                                `tarjetas_id_square`,
                                                `tipo_cuenta`,
                                                `tipo_pasarela_pago`,
                                                `titular_tarjeta`,
                                                `numero_tarjeta`,
                                                `codigo_ccv`,
                                                `exp_month`,
                                                `exp_year`,
                                                `estado_id`,
                                                `use_credit_card`,
                                                `banco_metodo_pago`,
                                                `verificado`,

                                                `numero_ruta_metodo_pago`,
                                                `tipo_titular_metodo_pago`,
                                                `configuracion_stripe_id`,
                                                `configuracion_pasarela_pago`,
                                                `setup_intent`,
                                                `payment_method`,
                                                `customer_id`,
                                                `email_metodo_pago`,
                                                `crm_account_id`

                                            ) VALUES (
                                                ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?  
                                            )";

                                            //$crm_account_id_igp  crm_account_id

                                            $stmt = $mysqli->prepare($sql);
                                            
                                            $verificado = 2;

                                            $stmt->bind_param(
                                                'ssssssssssssssssssssssss',
                                                $id_ifp,
                                                $UUID,
                                                $UUID_ENC,
                                                $tarjetas_id_square,
                                                $tipo_cuenta,
                                                $tipo_pasarela_pago,
                                                $titular_tarjeta,
                                                $numero_tarjeta,
                                                $codigo_ccv,
                                                $exp_month,
                                                $exp_year,
                                                $estado_id,
                                                $use_credit_card,
                                                $banco_metodo_pago,
                                                $verificado,

                                                $numero_ruta_metodo_pago,
                                                $tipo_titular_metodo_pago,
                                                $sys_pg_id,
                                                json_encode($stripe_configuration_),
                                                $setup_intent,
                                                $payment_method,
                                                $customer_id,
                                                $email_metodo_pago,
                                                $crm_account_id_igp,
                                            );
        
                                            $stmt->execute();
                                            $stmt->close();
                                        }else{
                                            $response = array(
                                                "type" => "error",
                                                "message" =>  $salida["mensaje"],
                                            );
                                            echo json_encode($response); exit;
                                        }
                                        
                                    } 

                                }else{
                                    
                                    //entramos con credit card
                                    if($tipo_pasarela_pago == "Stripe")
                                    {
                                        $tarjetas_id_square = null;

                                        $sql = "INSERT INTO $DB_NAME.credit_plan_payment_method (
                                            `id_gip`,
                                            `UUID`,
                                            `UUID_ENC`,
                                            `tarjetas_id_square`,
                                            `tipo_cuenta`,
                                            `tipo_pasarela_pago`,
                                            `titular_tarjeta`,
                                            `numero_tarjeta`,
                                            `codigo_ccv`,
                                            `exp_month`,
                                            `exp_year`,
                                            `estado_id`,
                                            `use_credit_card`,
                                            `banco_metodo_pago`,
                                            `verificado`,
                                            `crm_account_id`,

                                            `configuracion_stripe_id`,
                                            `configuracion_pasarela_pago` 
                                        ) VALUES (
                                            ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?  
                                        )";
    
                                        $stmt = $mysqli->prepare($sql);
                                        
                                        $verificado = 1;

                                        $stmt->bind_param(
                                            'ssssssssssssssssss',
                                            $id_ifp,
                                            $UUID,
                                            $UUID_ENC,
                                            $tarjetas_id_square,
                                            $tipo_cuenta,
                                            $tipo_pasarela_pago,
                                            $titular_tarjeta,
                                            $numero_tarjeta,
                                            $codigo_ccv,
                                            $exp_month,
                                            $exp_year,
                                            $estado_id,
                                            $use_credit_card,
                                            $banco_metodo_pago,
                                            $verificado,
                                            $crm_account_id_igp,
                                            $sys_pg_id,
                                            json_encode($stripe_configuration_),
                                        );
                
                                        $stmt->execute();
                                        $stmt->close();

                                    }else{

                                        $sql = "SELECT * FROM $DB_NAME.`credit_plan_payment_method` WHERE `crm_account_id` = $crm_account_id_igp AND configuracion_stripe_id = $configuracion_stripe_id";
                                        $existeCustomerStripe = $mysqli->query($sql)->fetch_assoc();

    
                                        if(empty($existeCustomerStripe) == true)
                                        {
                                            $dataInformacion = [
                                                "url" => $url_square,
                                                "version" => $sys_pg_version_square,
                                                "token" => $sys_pg_token_square,
                                                "idempotency_key" => createUUIDSquare(),
                                                "email_address" => $email_address_igp,
                                                "postal_code" => $postal_code_igp,
                                                "first_name" => $first_name,
                                                //"locality" => $contenido['contenido']->item->state,
                                                "address_line_1" => $address_line_1,
                                                //"address_line_2" => $contenido['contenido']->item->address2,
                                                //"company_name" => $contenido['contenido']->item->company,
                                                //"phone_number" => "+" . $contenido['contenido']->item->area_phone . $contenido['contenido']->item->phone,
                                            ];

                                            //echo json_encode($dataInformacion); exit;
                                            //echo $url_square ; exit; zip

                                            $salidaCreacionClienteSquare = creacionClientesSquare($dataInformacion);
                                        
                                            if($salidaCreacionClienteSquare["status"] == false)
                                            {
                                                $response = array(
                                                    "type" => "error",
                                                    "message" => $salidaCreacionClienteSquare["mensaje"],
                                                );
                                                echo json_encode($response); exit;
                                            }

                                            $customer_id_square = $salidaCreacionClienteSquare["id_customer"];

                                            //$customer_id_square = $customer->id;
 
                                        }else{
                                            $customer_id_square = $existeCustomerStripe["customer_id_square"];
                                        }

                                        //echo "llegamos a creacion de usuario";
                                        //exit;

                                        

                                        if(empty($customer_id_square) == false)
                                        {
                                            $dataCreacionTarjeta = [
                                                "url"             => $url_square,
                                                "version"         => $sys_pg_version_square,
                                                "token"           => $sys_pg_token_square,
                                                "idempotency_key" => createUUIDSquare(),
                                                "source_id"       => $cnon_tarjetas_square,
                                                "cardholder_name" => $titular_tarjeta,
                                                "customer_id"     => $customer_id_square,
                                                "exp_month"       => $exp_month,
                                                "exp_year"        => $exp_year,
                                            ];

                                            //echo json_encode($dataCreacionTarjeta); exit;
                                
                                            $resTarjetas = creacionTarjetasSquare($dataCreacionTarjeta);

                                            //echo json_encode($resTarjetas); exit;

                                            if($resTarjetas["status"] == true)
                                            {

                                                $tarjetas_id_square = $resTarjetas["id_card"];

                                                $sql = "INSERT INTO $DB_NAME.credit_plan_payment_method (
                                                    `id_gip`,
                                                    `UUID`,
                                                    `UUID_ENC`,
                                                    `tarjetas_id_square`,
                                                    `tipo_cuenta`,
                                                    `tipo_pasarela_pago`,
                                                    `titular_tarjeta`,
                                                    `numero_tarjeta`,
                                                    `codigo_ccv`,
                                                    `exp_month`,
                                                    `exp_year`,
                                                    `estado_id`,
                                                    `use_credit_card`,
                                                    `banco_metodo_pago`,
                                                    `verificado`,
                                                    `crm_account_id`,
                                                    
                                                    `configuracion_stripe_id`,
                                                    `configuracion_pasarela_pago`,
                                                    `customer_id_square`
                                                ) VALUES (
                                                    ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
                                                )";

    
                                                $stmt = $mysqli->prepare($sql);

                                                $verificado = 1;
                                                
                                                $stmt->bind_param(
                                                    'sssssssssssssssssss',
                                                    $id_ifp,
                                                    $UUID,
                                                    $UUID_ENC,
                                                    $tarjetas_id_square,
                                                    $tipo_cuenta,
                                                    $tipo_pasarela_pago,
                                                    $titular_tarjeta,
                                                    $numero_tarjeta,
                                                    $codigo_ccv,
                                                    $exp_month,
                                                    $exp_year,
                                                    $estado_id,
                                                    $use_credit_card,
                                                    $banco_metodo_pago,
                                                    $verificado,
                                                    $crm_account_id_igp,
                                                    $sys_pg_id,
                                                    json_encode($square_configuration_),
                                                    $customer_id_square,
                                                );
                        
                                                $stmt->execute();
                                                $stmt->close();

                                            }

                                        }

                                    }

                                }
        
                            }else{

                                if($tipo_cuenta == "1" || $tipo_cuenta == "2")
                                {

                                    $sys_pg_id        = $registroPasarelaPago["id"];
                                    $sys_pg_sk_stripe = $registroPasarelaPago["c1"];
                                    $sys_pg_pk_stripe = $registroPasarelaPago["value"];

                                    $sys_pg_aplication_id_square = $registroPasarelaPago["value"];
                                    $sys_pg_token_square         = $registroPasarelaPago["c1"];
                                    $sys_pg_location_id_square   = $registroPasarelaPago["c2"];
                                    $sys_pg_version_square       = $registroPasarelaPago["c3"];

                                    //$configuracion_stripe_id             = empty($item["configuracion_stripe_id"])  == true? null : $item["configuracion_stripe_id"];

                                    if(empty($sys_pg_sk_stripe) == false && empty($payment_method) == false)
                                    {
                                        $informacionEnviar = [
                                            "sk"                  => $sys_pg_sk_stripe,
                                            "name"                => $titular_tarjeta,
                                            "email"               => $email_metodo_pago,
                                            "payment_method_id"   => $payment_method,
                                        ];

                                        //echo json_encode($informacionEnviar); exit;

                                        $salida = modificarCuentaBancaria($informacionEnviar);

                                        if($salida["status"] == true)
                                        {
                                            $sql = "UPDATE $DB_NAME.credit_plan_payment_method 
                                                    SET 
                                                        `tipo_cuenta` = ?, 
                                                        `tipo_pasarela_pago` = ?, 
                                                        `titular_tarjeta` = ?, 
                                                        `numero_tarjeta` = ?, 
                                                        `codigo_ccv` = ?, 
                                                        `exp_month` = ?, 
                                                        `exp_year` = ?, 
                                                        `estado_id` = ?, 
                                                        `use_credit_card` = ?, 
                                                        `banco_metodo_pago` = ?
                                                    WHERE `id` = ?";

                                            $stmt = $mysqli->prepare($sql);

                                            $stmt->bind_param(
                                                'sssssssssss',
                                                $tipo_cuenta,
                                                $tipo_pasarela_pago,
                                                $titular_tarjeta,
                                                $numero_tarjeta,
                                                $codigo_ccv,
                                                $exp_month,
                                                $exp_year,
                                                $estado_id,
                                                $use_credit_card,
                                                $banco_metodo_pago,
                                                $id,
                                            );

                                            $stmt->execute();
                                            $stmt->close();
                                        }


                                    }
                                        

                                    

                                }else{


                                    if($tipo_pasarela_pago == "Stripe")
                                    {
                                        $sql = "UPDATE $DB_NAME.credit_plan_payment_method 
                                                SET 
                                                    `tipo_cuenta` = ?, 
                                                    `tipo_pasarela_pago` = ?, 
                                                    `titular_tarjeta` = ?, 
                                                    `numero_tarjeta` = ?, 
                                                    `codigo_ccv` = ?, 
                                                    `exp_month` = ?, 
                                                    `exp_year` = ?, 
                                                    `estado_id` = ?, 
                                                    `use_credit_card` = ?, 
                                                    `banco_metodo_pago` = ?
                                                WHERE `id` = ?";

                                        $stmt = $mysqli->prepare($sql);

                                        $stmt->bind_param(
                                            'sssssssssss',
                                            $tipo_cuenta,
                                            $tipo_pasarela_pago,
                                            $titular_tarjeta,
                                            $numero_tarjeta,
                                            $codigo_ccv,
                                            $exp_month,
                                            $exp_year,
                                            $estado_id,
                                            $use_credit_card,
                                            $banco_metodo_pago,
                                            $id,
                                        );

                                        $stmt->execute();
                                        $stmt->close();
                                    }else{

                                        //modificar solo cuando sea square

                                        $sql = "UPDATE $DB_NAME.credit_plan_payment_method 
                                                SET 
                                                    `titular_tarjeta` = ?, 
                                                    `estado_id` = ?, 
                                                    `use_credit_card` = ?
                                                WHERE `id` = ?";

                                        $stmt = $mysqli->prepare($sql);

                                        $stmt->bind_param(
                                            'ssss',
                                            $titular_tarjeta,
                                            $estado_id,
                                            $use_credit_card,
                                            $id,
                                        );

                                        $stmt->execute();
                                        $stmt->close();

                                        //fin cuando es square

                                    }

                                }

                            }


                        }//if comparacion pasarela pago
    
                    }
                } */

                $arreglo_lista_errores_metodos = [];

                if($arreglo_planes != null)
                {
                    foreach($arreglo_planes as $item)
                    {
                        $id = $item["id"];

                        $tipo_cuenta                = empty($item["tipo_cuenta"])  == true? null : $item["tipo_cuenta"];
                        $nombre_tipo_cuenta         = empty($item["nombre_tipo_cuenta"])  == true? null : $item["nombre_tipo_cuenta"];
                        $tipo_pasarela_pago         = empty($item["tipo_pasarela_pago"])  == true? null : $item["tipo_pasarela_pago"];
                        $titular_tarjeta            = empty($item["titular_tarjeta"])  == true? null : $item["titular_tarjeta"];
                        $numero_tarjeta             = empty($item["numero_tarjeta"])  == true? null : $item["numero_tarjeta"];
                        $codigo_ccv                 = empty($item["codigo_ccv"])  == true? null : $item["codigo_ccv"];
                        $exp_month                  = empty($item["exp_month"])  == true? null : $item["exp_month"];
                        $exp_year                   = empty($item["exp_year"])  == true? null : $item["exp_year"];
                        $estado_id                  = empty($item["estado_id"])  == true? null : $item["estado_id"];
                        $use_credit_card            = empty($item["use_credit_card"])  == true? null : $item["use_credit_card"];
                        $cnon_tarjetas_square       = empty($item["cnon_tarjetas_square"])  == true? null : $item["cnon_tarjetas_square"];
                        $estado_nombre              = empty($item["estado_nombre"])  == true? null : $item["estado_nombre"];
                        $use_credit_card_nombre     = empty($item["use_credit_card_nombre"])  == true? null : $item["use_credit_card_nombre"];
                        $UUID                       = empty($item["UUID"])  == true? null : $item["UUID"];
                        $UUID_ENC                   = empty($item["UUID_ENC"])  == true? null : $item["UUID_ENC"];
                        $banco_metodo_pago          = empty($item["banco_metodo_pago"])  == true? null : $item["banco_metodo_pago"];
                        $nombre_banco_metodo_pago   = empty($item["nombre_banco_metodo_pago"])  == true? null : $item["nombre_banco_metodo_pago"];

                        $numero_ruta_metodo_pago    = empty($item["numero_ruta_metodo_pago"])  == true? null : $item["numero_ruta_metodo_pago"];
                        $tipo_titular_metodo_pago   = empty($item["tipo_titular_metodo_pago"])  == true? null : $item["tipo_titular_metodo_pago"];
                        $email_metodo_pago          = empty($item["email_metodo_pago"])  == true? null : $item["email_metodo_pago"];
                        $configuracion_stripe_id    = empty($item["configuracion_stripe_id"])  == true? null : $item["configuracion_stripe_id"];
                        $payment_method             = empty($item["payment_method"])  == true? null : $item["payment_method"];
                        
                        $configuracion_stripe_id             = empty($item["configuracion_stripe_id"])  == true? null : $item["configuracion_stripe_id"];
    
                        //echo $configuracion_stripe_id; exit;

                        $sql = "SELECT * FROM $DB_NAME.`sys_pg` WHERE `id` = $configuracion_stripe_id ";
                        $registroPasarelaPago = $mysqli->query($sql)->fetch_assoc();

                        //echo json_encode($registroPasarelaPago); exit;

                        if(empty($registroPasarelaPago) == false)
                        {
                            
                            //$customer_id_stripe = $data_general_informacion["customer_id_stripe"];

                            $sys_pg_id        = $registroPasarelaPago["id"];
                            $sys_pg_sk_stripe = $registroPasarelaPago["c1"];
                            $sys_pg_pk_stripe = $registroPasarelaPago["value"];

                            $sys_pg_aplication_id_square = $registroPasarelaPago["value"];
                            $sys_pg_token_square         = $registroPasarelaPago["c1"];
                            $sys_pg_location_id_square   = $registroPasarelaPago["c2"];
                            $sys_pg_version_square       = $registroPasarelaPago["c3"];

                            $stripe_configuration_ = [
                                "id_stripe" => $sys_pg_id,
                                "pk_stripe" => $sys_pg_pk_stripe,
                                "sk_stripe" => $sys_pg_sk_stripe,
                            ];

                            $square_configuration_ = [
                                "sys_pg_aplication_id_square" => $sys_pg_aplication_id_square,
                                "sys_pg_token_square"         => $sys_pg_token_square,
                                "sys_pg_location_id_square"   => $sys_pg_location_id_square,
                                "sys_pg_version_square"       => $sys_pg_version_square,
                            ];
    
                            //echo json_encode($square_configuration_); exit;

                            //$customer_id_square = $data_general_informacion["customer_id_square"];
                            //exit;

                            if(empty($id) == true)
                            {

                                if($tipo_cuenta == "1" || $tipo_cuenta == "2")
                                {
                                    $sql = "SELECT * FROM $DB_NAME.`credit_plan_payment_method` WHERE `crm_account_id` = $crm_account_id_igp AND configuracion_stripe_id = $configuracion_stripe_id";
                                    $existeCustomerStripe = $mysqli->query($sql)->fetch_assoc();

                                    if(empty($existeCustomerStripe) == true)
                                    {
                                        $stripe = new \Stripe\StripeClient($sys_pg_sk_stripe);
            
                                        // 1. Crear un Customer
                                        $customer = $stripe->customers->create([
                                            'email' => $correo_electronico_cliente_igp,
                                            'name'  => $nombre_cliente_igp ,
                                        ]);

                                        $customer_id_stripe = $customer->id;

                                        /* $sql = "UPDATE
                                                    `crm_accounts`
                                                SET
                                                    `customer_id_stripe` = ?
                                                WHERE
                                                    id = ?";

                                        $stmt = $mysqli->prepare($sql);
                                    
                                        $stmt->bind_param(
                                            'ss',
                                            $customer_id_stripe,
                                            $crm_account_id_igp,
                                        );
                
                                        $stmt->execute();
                                        $stmt->close(); */

                                    }else{
                                        $customer_id_stripe = $existeCustomerStripe["customer_id"];
                                    }

                                    if(empty($sys_pg_sk_stripe) == false &&  empty($customer_id_stripe) == false)
                                    {
                                        $informacionEnviar = [
                                            "sk"                  => $sys_pg_sk_stripe,
                                            "account_number"      => $numero_tarjeta,
                                            "routing_number"      => $numero_ruta_metodo_pago,
                                            "account_holder_type" => $tipo_titular_metodo_pago,
                                            "name"                => $titular_tarjeta,
                                            "email"               => $email_metodo_pago,
                                            "customer_id"         => $customer_id_stripe,
                                        ];
        
                                        $salida = crearCuentaBancaria($informacionEnviar);
                                        
                                        //echo json_encode($salida); exit;

                                        if($salida["status"] == true)
                                        {

                                            $setup_intent   = $salida["setup_intent"];
                                            $payment_method = $salida["payment_method"];
                                            $customer_id    = $salida["customer_id"];

                                            $tarjetas_id_square = null;

                                            $stripe_configuration_ = [
                                                "id_stripe" => $sys_pg_id,
                                                "pk_stripe" => $sys_pg_pk_stripe,
                                                "sk_stripe" => $sys_pg_sk_stripe,
                                            ];

                                            $sql = "INSERT INTO $DB_NAME.credit_plan_payment_method (
                                                `id_gip`,
                                                `UUID`,
                                                `UUID_ENC`,
                                                `tarjetas_id_square`,
                                                `tipo_cuenta`,
                                                `tipo_pasarela_pago`,
                                                `titular_tarjeta`,
                                                `numero_tarjeta`,
                                                `codigo_ccv`,
                                                `exp_month`,
                                                `exp_year`,
                                                `estado_id`,
                                                `use_credit_card`,
                                                `banco_metodo_pago`,
                                                `verificado`,

                                                `numero_ruta_metodo_pago`,
                                                `tipo_titular_metodo_pago`,
                                                `configuracion_stripe_id`,
                                                `configuracion_pasarela_pago`,
                                                `setup_intent`,
                                                `payment_method`,
                                                `customer_id`,
                                                `email_metodo_pago`,
                                                `crm_account_id`

                                            ) VALUES (
                                                ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?  
                                            )";

                                            //$crm_account_id_igp  crm_account_id

                                            $stmt = $mysqli->prepare($sql);
                                            
                                            $verificado = 2;

                                            $stmt->bind_param(
                                                'ssssssssssssssssssssssss',
                                                $id_ifp,
                                                $UUID,
                                                $UUID_ENC,
                                                $tarjetas_id_square,
                                                $tipo_cuenta,
                                                $tipo_pasarela_pago,
                                                $titular_tarjeta,
                                                $numero_tarjeta,
                                                $codigo_ccv,
                                                $exp_month,
                                                $exp_year,
                                                $estado_id,
                                                $use_credit_card,
                                                $banco_metodo_pago,
                                                $verificado,

                                                $numero_ruta_metodo_pago,
                                                $tipo_titular_metodo_pago,
                                                $sys_pg_id,
                                                json_encode($stripe_configuration_),
                                                $setup_intent,
                                                $payment_method,
                                                $customer_id,
                                                $email_metodo_pago,
                                                $crm_account_id_igp,
                                            );
        
                                            $stmt->execute();
                                            $stmt->close();
                                        }else{
                                            //$response = array(
                                            //    "type" => "error",
                                            //    "message" =>  $salida["mensaje"],
                                            //);
                                            //echo json_encode($response); exit;

                                            $arreglo_lista_errores_metodos[] = [
                                                "tipo_cuenta_id"   => $tipo_cuenta, 
                                                "numero_ruta_metodo_pago"   => $numero_ruta_metodo_pago, 
                                                
                                                "tipo_cuenta"   => $nombre_tipo_cuenta, 
                                                "pasarela_pago" => $tipo_pasarela_pago, 
                                                "mensaje_error" => $salida["mensaje"], 
                                                "titular_tarjeta" => $titular_tarjeta, 
                                                "numero_tarjeta"  => $numero_tarjeta, 
                                                "exp_month"       => $exp_month, 
                                                "exp_year"        => $exp_year, 
                                                "nombre_banco_metodo_pago"       => $nombre_banco_metodo_pago, 
                                                "tipo_titular_metodo_pago"        => $tipo_titular_metodo_pago, 
                                            ];

                                        
                                        }
                                        
                                    } 

                                }else{
                                    
                                    //entramos con credit card
                                    if($tipo_pasarela_pago == "Stripe")
                                    {
                                        $tarjetas_id_square = null;

                                        $sql = "INSERT INTO $DB_NAME.credit_plan_payment_method (
                                            `id_gip`,
                                            `UUID`,
                                            `UUID_ENC`,
                                            `tarjetas_id_square`,
                                            `tipo_cuenta`,
                                            `tipo_pasarela_pago`,
                                            `titular_tarjeta`,
                                            `numero_tarjeta`,
                                            `codigo_ccv`,
                                            `exp_month`,
                                            `exp_year`,
                                            `estado_id`,
                                            `use_credit_card`,
                                            `banco_metodo_pago`,
                                            `verificado`,
                                            `crm_account_id`,

                                            `configuracion_stripe_id`,
                                            `configuracion_pasarela_pago` 
                                        ) VALUES (
                                            ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?  
                                        )";
    
                                        $stmt = $mysqli->prepare($sql);
                                        
                                        $verificado = 1;

                                        $stmt->bind_param(
                                            'ssssssssssssssssss',
                                            $id_ifp,
                                            $UUID,
                                            $UUID_ENC,
                                            $tarjetas_id_square,
                                            $tipo_cuenta,
                                            $tipo_pasarela_pago,
                                            $titular_tarjeta,
                                            $numero_tarjeta,
                                            $codigo_ccv,
                                            $exp_month,
                                            $exp_year,
                                            $estado_id,
                                            $use_credit_card,
                                            $banco_metodo_pago,
                                            $verificado,
                                            $crm_account_id_igp,
                                            $sys_pg_id,
                                            json_encode($stripe_configuration_),
                                        );
                
                                        $stmt->execute();
                                        $stmt->close();

                                    }else{

                                        $sql = "SELECT * FROM $DB_NAME.`credit_plan_payment_method` WHERE `crm_account_id` = $crm_account_id_igp AND configuracion_stripe_id = $configuracion_stripe_id";
                                        $existeCustomerStripe = $mysqli->query($sql)->fetch_assoc();

                                        if(empty($existeCustomerStripe) == true)
                                        {
                                            $dataInformacion = [
                                                "url" => $url_square,
                                                "version" => $sys_pg_version_square,
                                                "token" => $sys_pg_token_square,
                                                "idempotency_key" => createUUIDSquare(),
                                                "email_address" => $email_address_igp,
                                                "postal_code" => $postal_code_igp,
                                                "first_name" => $first_name,
                                                //"locality" => $contenido['contenido']->item->state,
                                                "address_line_1" => $address_line_1,
                                                //"address_line_2" => $contenido['contenido']->item->address2,
                                                //"company_name" => $contenido['contenido']->item->company,
                                                //"phone_number" => "+" . $contenido['contenido']->item->area_phone . $contenido['contenido']->item->phone,
                                            ];

                                            //echo json_encode($dataInformacion); exit;
                                            //echo $url_square ; exit; zip

                                            $salidaCreacionClienteSquare = creacionClientesSquare($dataInformacion);
                                        
                                            if($salidaCreacionClienteSquare["status"] == false)
                                            {
                                                /* $response = array(
                                                    "type" => "error",
                                                    "message" => $salidaCreacionClienteSquare["mensaje"],
                                                );
                                                echo json_encode($response); exit; */

                                                $arreglo_lista_errores_metodos[] = [
                                                    "tipo_cuenta_id"   => $tipo_cuenta, 
                                                    "numero_ruta_metodo_pago"   => $numero_ruta_metodo_pago, 
                                                    "tipo_cuenta"   => $nombre_tipo_cuenta, 
                                                    "pasarela_pago" => $tipo_pasarela_pago, 
                                                    "mensaje_error" => "Error Creating Square Client: " . $salidaCreacionClienteSquare["mensaje"], 

                                                    "titular_tarjeta" => $titular_tarjeta, 
                                                    "numero_tarjeta"  => $numero_tarjeta, 
                                                    "exp_month"       => $exp_month, 
                                                    "exp_year"        => $exp_year, 
                                                    "nombre_banco_metodo_pago"       => $nombre_banco_metodo_pago, 
                                                    "tipo_titular_metodo_pago"        => $tipo_titular_metodo_pago, 
                                                ];

                                                continue;

                                            }

                                            $customer_id_square = $salidaCreacionClienteSquare["id_customer"];

                                            //$customer_id_square = $customer->id;

                                            /* $sql = "UPDATE
                                                        `crm_accounts`
                                                    SET
                                                        `customer_id_square` = ?
                                                    WHERE
                                                        id = ?";

                                            $stmt = $mysqli->prepare($sql);
                                        
                                            $stmt->bind_param(
                                                'ss',
                                                $customer_id_square,
                                                $crm_account_id_igp,
                                            );
                    
                                            $stmt->execute();
                                            $stmt->close(); */

                                        }else{
                                            $customer_id_square = $existeCustomerStripe["customer_id_square"];
                                        }

                                        //echo "llegamos a creacion de usuario";
                                        //exit;

                                        //"version"         => $sys_pg_version_square,
                                        //"token"           => $sys_pg_token_square,

                                        if(empty($customer_id_square) == false)
                                        {
                                            $dataCreacionTarjeta = [
                                                "url"             => $url_square,
                                                "version"         => $sys_pg_version_square,
                                                "token"           => $sys_pg_token_square,
                                                "idempotency_key" => createUUIDSquare(),
                                                "source_id"       => $cnon_tarjetas_square,
                                                "cardholder_name" => $titular_tarjeta,
                                                "customer_id"     => $customer_id_square,
                                                "exp_month"       => $exp_month,
                                                "exp_year"        => $exp_year,
                                            ];

                                            //echo json_encode($dataCreacionTarjeta); exit;
                                
                                            $resTarjetas = creacionTarjetasSquare($dataCreacionTarjeta);

                                            //echo json_encode($resTarjetas); exit;

                                            if($resTarjetas["status"] == true)
                                            {

                                                $tarjetas_id_square = $resTarjetas["id_card"];

                                                $sql = "INSERT INTO $DB_NAME.credit_plan_payment_method (
                                                    `id_gip`,
                                                    `UUID`,
                                                    `UUID_ENC`,
                                                    `tarjetas_id_square`,
                                                    `tipo_cuenta`,
                                                    `tipo_pasarela_pago`,
                                                    `titular_tarjeta`,
                                                    `numero_tarjeta`,
                                                    `codigo_ccv`,
                                                    `exp_month`,
                                                    `exp_year`,
                                                    `estado_id`,
                                                    `use_credit_card`,
                                                    `banco_metodo_pago`,
                                                    `verificado`,
                                                    `crm_account_id`,
                                                    
                                                    `configuracion_stripe_id`,
                                                    `configuracion_pasarela_pago`,
                                                    `customer_id_square`
                                                ) VALUES (
                                                    ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
                                                )";

    
                                                $stmt = $mysqli->prepare($sql);

                                                $verificado = 1;
                                                
                                                $stmt->bind_param(
                                                    'sssssssssssssssssss',
                                                    $id_ifp,
                                                    $UUID,
                                                    $UUID_ENC,
                                                    $tarjetas_id_square,
                                                    $tipo_cuenta,
                                                    $tipo_pasarela_pago,
                                                    $titular_tarjeta,
                                                    $numero_tarjeta,
                                                    $codigo_ccv,
                                                    $exp_month,
                                                    $exp_year,
                                                    $estado_id,
                                                    $use_credit_card,
                                                    $banco_metodo_pago,
                                                    $verificado,
                                                    $crm_account_id_igp,
                                                    $sys_pg_id,
                                                    json_encode($square_configuration_),
                                                    $customer_id_square,
                                                );
                        
                                                $stmt->execute();
                                                $stmt->close();

                                            }else{
                                                $arreglo_lista_errores_metodos[] = [
                                                    "tipo_cuenta_id"   => $tipo_cuenta, 
                                                    "numero_ruta_metodo_pago"   => $numero_ruta_metodo_pago, 
                                                    "tipo_cuenta"   => $nombre_tipo_cuenta, 
                                                    "pasarela_pago" => $tipo_pasarela_pago, 
                                                    "mensaje_error" => $resTarjetas["mensaje"], 

                                                    "titular_tarjeta" => $titular_tarjeta, 
                                                    "numero_tarjeta"  => $numero_tarjeta, 
                                                    "exp_month"       => $exp_month, 
                                                    "exp_year"        => $exp_year, 
                                                    "nombre_banco_metodo_pago"       => $nombre_banco_metodo_pago, 
                                                    "tipo_titular_metodo_pago"        => $tipo_titular_metodo_pago, 
                                                ];
                                            }

                                        }

                                    }

                                }
        
                            }else{

                                if($tipo_cuenta == "1" || $tipo_cuenta == "2")
                                {

                                    $sys_pg_id        = $registroPasarelaPago["id"];
                                    $sys_pg_sk_stripe = $registroPasarelaPago["c1"];
                                    $sys_pg_pk_stripe = $registroPasarelaPago["value"];

                                    $sys_pg_aplication_id_square = $registroPasarelaPago["value"];
                                    $sys_pg_token_square         = $registroPasarelaPago["c1"];
                                    $sys_pg_location_id_square   = $registroPasarelaPago["c2"];
                                    $sys_pg_version_square       = $registroPasarelaPago["c3"];

                                    //$configuracion_stripe_id             = empty($item["configuracion_stripe_id"])  == true? null : $item["configuracion_stripe_id"];

                                    if(empty($sys_pg_sk_stripe) == false && empty($payment_method) == false)
                                    {
                                        $informacionEnviar = [
                                            "sk"                  => $sys_pg_sk_stripe,
                                            "name"                => $titular_tarjeta,
                                            "email"               => $email_metodo_pago,
                                            "payment_method_id"   => $payment_method,
                                        ];

                                        //echo json_encode($informacionEnviar); exit;

                                        $salida = modificarCuentaBancaria($informacionEnviar);

                                        if($salida["status"] == true)
                                        {
                                            $sql = "UPDATE $DB_NAME.credit_plan_payment_method 
                                                    SET 
                                                        `tipo_cuenta` = ?, 
                                                        `tipo_pasarela_pago` = ?, 
                                                        `titular_tarjeta` = ?, 
                                                        `numero_tarjeta` = ?, 
                                                        `codigo_ccv` = ?, 
                                                        `exp_month` = ?, 
                                                        `exp_year` = ?, 
                                                        `estado_id` = ?, 
                                                        `use_credit_card` = ?, 
                                                        `banco_metodo_pago` = ?
                                                    WHERE `id` = ?";

                                            $stmt = $mysqli->prepare($sql);

                                            $stmt->bind_param(
                                                'sssssssssss',
                                                $tipo_cuenta,
                                                $tipo_pasarela_pago,
                                                $titular_tarjeta,
                                                $numero_tarjeta,
                                                $codigo_ccv,
                                                $exp_month,
                                                $exp_year,
                                                $estado_id,
                                                $use_credit_card,
                                                $banco_metodo_pago,
                                                $id,
                                            );

                                            $stmt->execute();
                                            $stmt->close();
                                        }else{

                                            $arreglo_lista_errores_metodos[] = [
                                                "tipo_cuenta_id"   => $tipo_cuenta, 
                                                "numero_ruta_metodo_pago"   => $numero_ruta_metodo_pago, 
                                                "tipo_cuenta"   => $nombre_tipo_cuenta, 
                                                "pasarela_pago" => $tipo_pasarela_pago, 
                                                "mensaje_error" => $salida["mensaje"], 
                                                "titular_tarjeta" => $titular_tarjeta, 
                                                "numero_tarjeta"  => $numero_tarjeta, 
                                                "exp_month"       => $exp_month, 
                                                "exp_year"        => $exp_year, 
                                                "nombre_banco_metodo_pago"       => $nombre_banco_metodo_pago, 
                                                "tipo_titular_metodo_pago"        => $tipo_titular_metodo_pago, 
                                            ];

                                        }


                                    }
                                        

                                    

                                }else{


                                    if($tipo_pasarela_pago == "Stripe")
                                    {
                                        $sql = "UPDATE $DB_NAME.credit_plan_payment_method 
                                                SET 
                                                    `tipo_cuenta` = ?, 
                                                    `tipo_pasarela_pago` = ?, 
                                                    `titular_tarjeta` = ?, 
                                                    `numero_tarjeta` = ?, 
                                                    `codigo_ccv` = ?, 
                                                    `exp_month` = ?, 
                                                    `exp_year` = ?, 
                                                    `estado_id` = ?, 
                                                    `use_credit_card` = ?, 
                                                    `banco_metodo_pago` = ?
                                                WHERE `id` = ?";

                                        $stmt = $mysqli->prepare($sql);

                                        $stmt->bind_param(
                                            'sssssssssss',
                                            $tipo_cuenta,
                                            $tipo_pasarela_pago,
                                            $titular_tarjeta,
                                            $numero_tarjeta,
                                            $codigo_ccv,
                                            $exp_month,
                                            $exp_year,
                                            $estado_id,
                                            $use_credit_card,
                                            $banco_metodo_pago,
                                            $id,
                                        );

                                        $stmt->execute();
                                        $stmt->close();
                                    }else{

                                        //modificar solo cuando sea square

                                        $sql = "UPDATE $DB_NAME.credit_plan_payment_method 
                                                SET 
                                                    `titular_tarjeta` = ?, 
                                                    `estado_id` = ?, 
                                                    `use_credit_card` = ?
                                                WHERE `id` = ?";

                                        $stmt = $mysqli->prepare($sql);

                                        $stmt->bind_param(
                                            'ssss',
                                            $titular_tarjeta,
                                            $estado_id,
                                            $use_credit_card,
                                            $id,
                                        );

                                        $stmt->execute();
                                        $stmt->close();

                                        //fin cuando es square

                                    }

                                }

                            }


                        }//if comparacion pasarela pago
    
                    }
                }

 
                // Devolver los resultados como JSON
                //echo json_encode($results);

                $sql = "SELECT 
                        RPros.*, 
                        BPros.name AS nombre_banco_metodo_pago
    
                    FROM $DB_NAME.`credit_plan_payment_method` AS RPros
                    LEFT JOIN $DB_NAME.`bank_prospecting` AS BPros ON BPros.id = RPros.banco_metodo_pago  
                    WHERE RPros.crm_account_id =$crm_account_id_igp ";

                    // RPros.id_gip = $id_ifp

                $data_credit_plan_payment_method = $mysqli->query($sql)->fetch_all(MYSQLI_ASSOC);

                $response = array(
                    "type" => "success",
                    "message" => "",
                    "data_credit_plan_payment_method" => $data_credit_plan_payment_method,
                    "arreglo_lista_errores_metodos" => $arreglo_lista_errores_metodos,
                );
                
                echo json_encode($response);

            } catch (Exception $e) {
                $response = array(
                    "type" => "error",
                    "message" => "Database connection or query failed",
                    "detalle" => $e->getMessage()
                );

                echo json_encode($response);
            } finally {
                // Cerrar la conexión si existe
                if ($mysqli !== null) {
                    $mysqli->close();
                }
            }

    
        break;

        case 'credit_card_info':
        $cid = _post('cid');

        $contact = Contact::find($cid);

        //

        $credit_card = CreditCard::where('contact_id', $cid)->first();

        view('profile_client_credit_card_info', [
            'cid' => $cid,
            'contact' => $contact,
            'credit_card' => $credit_card,
        ]);

        break;

        case 'save_credit_card':
        $cid = _post('contact_id');

        $contact = Contact::find($cid);

        if ($contact) {
            $credit_card = CreditCard::where('contact_id', $cid)->first();

            if (!$credit_card) {
                $credit_card = new CreditCard();
            }

            $credit_card->contact_id = $cid;
            $credit_card->card_type = '';
            $credit_card->card_holder_name = _post('card-holder-name');
            $credit_card->card_number = _post('card-number');
            $credit_card->expiry_month = _post('expiry-month');
            $credit_card->expiry_year = _post('expiry-year');
            $credit_card->cvv = _post('cvv');

            $credit_card->save();

            echo $contact->id;
        }

        break;

        case 'drive':

        $contacts = Contact::select('id', 'account')
        ->get()
        ->groupBy('id')
        ->toArray();

        $files = Document::where('cid', '!=', 0)
        ->orderBy('id', 'desc')
        ->get();

        view('contacts_drive', [
            'files' => $files,
            'contacts' => $contacts,
        ]);

        break;

        case 'add-parnert':
        Event::trigger('contacts/add-parnert/');
        $ui->assign('selected_navigation', 'parnerts');

        $type = route(2);
        $title_type = $_L['Add Customer'];
        $contact_type = 'Parnert';
        $db_type = 'Parnert';
        if (!has_access($user->roleid, 'customers', 'create')) {
            permissionDenied();
        }

        $ui->assign('countries', Countries::all($config['country'])); // may add this $config['country_code']
        //$owners = getOwners($user);

        $owners = getOwnersActivos($user,"Active");


        view('client_web', [
            'contact_type' => $contact_type,
            'title_type' => $title_type,
            'db_type' => $db_type,
            'owners' => $owners,
        ]);

        break;


        case 'add-parnert-post':

        $ui->assign('selected_navigation', 'parnerts');

        $company_name = _post('company_name');
        $fullname = _post('fullname');
        $phone = _post('phone');
        $email = _post('email');
        $address = _post('address');
        $city = _post('city');
        $state = _post('state');
        $zip = _post('zip');
        $country = _post('country');
        $url_slug = _post('url_slug');
        $url_slug = strtolower($url_slug);

        $msg = '';

        //check if tag is already exisit
        if ($company_name == '') {
            $msg .= "Company name is required" . ' <br>';
        }
        if ($url_slug == '') {
            $msg .= "Url slug name is required" . ' <br>';
        }
        if ($email == '') {
            $msg .= "Email is required" . ' <br>';
        }
        if ($fullname == '') {
            $msg .= "Fullname is required" . ' <br>';
        }
        if ($phone == '') {
            $msg .= "Phone is required" . ' <br>';
        }
        if ($address == '') {
            $msg .= "Address is required" . ' <br>';
        }
        if ($city == '') {
            $msg .= "city is required" . ' <br>';
        }
        if ($state == '') {
            $msg .= "state is required" . ' <br>';
        }
        if ($zip == '') {
            $msg .= "zip is required" . ' <br>';
        }
        /*if ($country == "United States") {

            $clas=new Contact();
            $address222=str_replace(",", "", $address);
            $address222=str_replace("#", "%23", $address);

            $tags = $clas->verificationadress($address222,$city,$state,$zip);

            if (!$tags) {
                $msg .= "Your address could not be validated, please try again ". ' <br>';
            }

        }*/
        if ($email != '') {
            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $msg .= $_L['Invalid Email'] . ' <br>';
            }
            $f = ORM::for_table('crm_parnerts')
            ->where('email', $email)
            ->first();

            if ($f) {
                $msg .= $_L['Email already exist'] . ' <br>';
            }
        }
        if ($phone != '') {
            $f = ORM::for_table('crm_parnerts')
            ->where('phone', $phone)
            ->first();

            if ($f) {
                $msg .= $_L['Phone number already exist'] . ' <br>';
            }
        }

        $url_slug = str_replace(" ", "_", $url_slug);

        if ($msg == '') {
            $d = ORM::for_table('crm_parnerts')->create();
            $d->fullname = $fullname;
            $d->company = $company_name;
            $d->phone = $phone;
            $d->email = $email;
            $d->address = $address;
            $d->city = $city;
            $d->zip = $zip;
            $d->state = $state;
            $d->country = $country;
            $d->userid = $user->id;
            $d->url_slug = $url_slug;
            $d->created_at = date('Y-m-d H:i:s');
            $d->updated_at = date('Y-m-d H:i:s');
            $d->save();
            $cid = $d->id();
            _log(
                $_L['New Contact Added'] .
                ' ' .
                $fullname .
                ' [CID: ' .
                $cid .
                ']',
                'Admin',
                $user->id
            );
            /*Event::trigger('contacts/add-post/_on_finished');

            $send_client_signup_email = _post('send_client_signup_email');

            if (
                $email !== '' &&
                $send_client_signup_email === 'on' &&
                $u_password !== ''
            ) {
                Email::send_client_welcome_email(
                    [
                        'account' => $account,
                        'email' => $email,
                        'password' => $u_password,
                    ],
                    true
                );
            }*/
            echo $cid;
        } else {
            echo $msg;
        }
        break;

        case 'edit-parnert':
        Event::trigger('contacts/edit-parnert/');
        $ui->assign('selected_navigation', 'parnerts');

        $id = $routes['2'];

        $contact = $d = Parnert::find($id);
        $ui->assign('countries', Countries::all($config['country'])); // may add this $config['country_code']
        if ($d) {
            $ui->assign('d', $d);
            view('client_web_edit', [
                'contact' => $contact,
            ]);
        } else {
            r2(U . 'customers/list_parnert/', 'e', $_L['Account_Not_Found']);
        }

        break;

        case 'edit-parnert-post':
        Event::trigger('contacts/edit-parnert-post/');

        if (!has_access($user->roleid, 'customers', 'edit')) {
            permissionDenied();
        }

        //$id = $routes['2'];
        $id = _post('id_par');

        $d = Parnert::find($id);
        if ($d) {

            $company_name = _post('company_name');
            $fullname = _post('fullname');
            $phone = _post('phone');
            $email = _post('email');
            $address = _post('address');
            $city = _post('city');
            $state = _post('state');
            $zip = _post('zip');
            $country = _post('country');
            $url_slug = _post('url_slug');
            $url_slug = strtolower($url_slug);

            $msg = '';

            if ($company_name == '') {
                $msg .= "Company name is required" . ' <br>';
            }
            if ($url_slug == '') {
                $msg .= "Url slug name is required" . ' <br>';
            }
            if ($email == '') {
                $msg .= "Email is required" . ' <br>';
            }
            if ($fullname == '') {
                $msg .= "Fullname is required" . ' <br>';
            }
            if ($phone == '') {
                $msg .= "Phone is required" . ' <br>';
            }
            if ($address == '') {
                $msg .= "Address is required" . ' <br>';
            }
            if ($city == '') {
                $msg .= "city is required" . ' <br>';
            }
            if ($state == '') {
                $msg .= "state is required" . ' <br>';
            }
            if ($zip == '') {
                $msg .= "zip is required" . ' <br>';
            }


            if ($email != '') {
                if ($email != $d['email']) {
                    $f = ORM::for_table('crm_parnerts')
                    ->where('email', $email)
                    ->first();

                    if ($f) {
                        $msg .= $_L['Email already exist'] . ' <br>';
                    }
                }
                if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    $msg .= $_L['Invalid Email'] . ' <br>';
                }
            }

            /*if ($country == "United States") {
                $address222=str_replace(",", "", $address);
                $address222=str_replace("#", "%23", $address);
                $clas=new Contact();
                $tags = $clas->verificationadress($address222,$city,$state,$zip);

                if (!$tags) {
                    $msg .= "Your address could not be validated, please try again ". ' <br>';
                }

            }*/

            if ($msg == '') {
                $d = ORM::for_table('crm_parnerts')->find($id);
                $d->fullname = $fullname;
                $d->company = $company_name;
                $d->phone = $phone;
                $d->email = $email;
                $d->address = $address;
                $d->city = $city;
                $d->zip = $zip;
                $d->state = $state;
                $d->country = $country;
                $d->userid = $user->id;
                $d->url_slug = $url_slug;
                $d->updated_at = date('Y-m-d H:i:s');
                $d->save();
                echo $id;
            } else {
                echo $msg;
            }
        } else {
            //r2(U . 'contacts/list_parnert', 'e', $_L['Account_Not_Found']);
            echo "fff ".$id;
        }

        break;
        case 'delete-parnert':
        if (!has_access($user->roleid, 'customers', 'delete')) {
            permissionDenied();
        }

        Event::trigger('contacts/delete-parnert/');

        $id = $routes['2'];
        if (APP_STAGE == 'Demo') {
            r2(
                U . 'contacts/list/',
                'e',
                'Sorry! Deleting Account is disabled in the demo mode.'
            );
        }
        $d = Parnert::find($id);
        if ($d) {
            $d->delete();
            r2(U . 'contacts/list_parnert/', 's', $_L['account_delete_successful']);
        }

        break;

        case 'list_parnert':
        Event::trigger('contacts/list_parnert/');

        $ui->assign('selected_navigation', 'parnerts');


        view('client_web_list', [
            'type' => 1
        ]);

        break;

        case   'data_table_parnert' :
        header('Content-Type: application/json');

        $group_id = (int) route(3);
        $has_delete_permission = true;
        $has_edit_permission = true;
        if (!has_access($user->roleid, 'customers', 'delete')) {
            $has_delete_permission = false;
        }
        if (!has_access($user->roleid, 'customers', 'edit')) {
            $has_edit_permission = false;
        }
        $contacts = ORM::for_table('crm_parnerts')->order_by_desc('id')->find_array();
        $datos1 = array('datos' => $contacts,'has_delete_permission' => $has_delete_permission,'has_edit_permission' => $has_edit_permission);
        header("HTTP/1.1 200", true);
        print (json_encode($datos1));
        break;

        case 'modal_parnert':

        $val = [];
        $id = route(2);
        $id = str_replace('vid', '', $id);
        $id = str_replace('xid', '', $id);
        $lead = ORM::for_table('crm_parnerts')->find($id);
        $ui->assign('lead', $lead);
        $ui->assign('val', $val);
        view('modal_parnert');
        break;

        case 'send_sms':

        $cid = _post('cid');

        $message = _post('message');


        $number = ORM::for_table('twilio_number')->find($user->id_number);
        
        $account = ORM::for_table('crm_accounts')->find($cid);

        $twilio = ORM::for_table('twilio_config')->find($number->id_twilio);

        $from = $number->number_twilio;
        $to = $account->phone;
        $sid= $twilio->sid_twilio;
        $token= $twilio->auth_token;

        $resp = '';
        $alert = '';
        if ($to == '') {
            $alert .= 'Please choose Phone Number for receiver <br />';
        }

        if ($from == '') {
            $alert .= 'Please choose Sender Number <br />';
        }

        if ($message == '') {
            $alert .= 'Message is empty <br />';
        }

        if ($alert == '') {
            $resp = spSendSMS($to, $message, $from, $cid, 'text', '',false,true,$sid,$token);
        
            r2(
                U . 'contacts/view/' . $cid . '/summary/',
                's',
                '<strong>Success!</strong> Message Sent. Message Server Response: ' .$resp
            );

        } else {


            r2(
                U . 'contacts/view/' . $cid . '/summary/',
                'e',
                '<strong>Error: </strong> <br /> ' .$alert
            );

        }

        break;


        default:
        echo 'action not defined';
    }

 function displayCard1($title, $description) {
    echo <<<HTML
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Error</title>
        <style>
            body {
                margin: 0;
                height: 100vh;
                display: flex;
                justify-content: center;
                align-items: center;
                background-color: white;
            }
            .card {
                background-color: #ffffff;
                border-radius: 10px;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
                padding: 20px;
                width: 300px;
                text-align: center;
            }
            .card h2 {
                margin: 0 0 10px;
            }
            .card p {
                margin: 0;
                color: #555;
            }
        </style>
    </head>
    <body>
        <div class="card">
            <h2>$title</h2>
            <p>$description</p>
        </div>
    </body>
    </html>
    HTML;
}


function crearCuentaBancaria($data_recibida = [])
{

    $sk                  = $data_recibida["sk"];
    $account_number      = $data_recibida["account_number"];
    $routing_number      = $data_recibida["routing_number"];
    $account_holder_type = $data_recibida["account_holder_type"];
    $name                = $data_recibida["name"];
    $email               = $data_recibida["email"];
    $customer_id         = $data_recibida["customer_id"];

    try {
        // Clave secreta de Stripe (TEST)
        //\Stripe\Stripe::setApiKey("sk_test_51IEEnvG2Qzn6cMzPhpbs059cHl6tRq6qE4S1xaS0KSHeezXU4CF8KdbqvEbYqeQD2yyb6GglScwSHGdpXYoTRmJL00VLYpyvNL");
        $stripe = new \Stripe\StripeClient($sk);
 
        $setupIntent = $stripe->setupIntents->create([
            'customer' => $customer_id,
            'payment_method_data' => [
                'type' => 'us_bank_account',
                'us_bank_account' => [
                    'account_number'      => $account_number,
                    'routing_number'      => $routing_number,
                    'account_holder_type' => $account_holder_type,
                ],
                'billing_details' => [
                    'name'  => $name, // titular de la tarjeta
                    'email' => $email,
                ],
            ],
            'payment_method_types' => ['us_bank_account'],
            'confirm' => true,
            'mandate_data' => [
                'customer_acceptance' => [
                    'type' => 'online',
                    'online' => [
                        'ip_address' => $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1',
                        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'php-client',
                    ],
                ],
            ],
        ]);
        

        //echo "✅ SetupIntent creado: {$setupIntent->id}\n"; // campo importante
        //echo "✅ SetupIntent status: {$setupIntent->status}\n";
        //echo "✅ PaymentMethod: {$setupIntent->payment_method}\n"; // campo importante

        // 3. Verificar automáticamente la cuenta bancaria (solo test mode)
        //en produccion Identificar los dos microdepósitos enviados por Stripe (generalmente aparecen en 1-2 días hábiles).

        $verified = $stripe->setupIntents->verifyMicrodeposits(
            $setupIntent->id,
            ['amounts' => [32, 45]]
        );

        /* echo "\n";
        echo "\n";
        echo json_encode($setupIntent); exit;
        echo "\n";
        echo "\n";
        echo json_encode($verified); exit; */
 
        return [
            "status"         => true,
            "setup_intent"   => $setupIntent->id,
            "payment_method" => $setupIntent->payment_method,
            "customer_id"    => $customer_id,
        ];
    
    } catch (\Stripe\Exception\ApiErrorException $e) {
        // Captura errores de Stripe
        //echo "Error de Stripe: " . $e->getMessage() . PHP_EOL;

        return [
            "status" => false,
            "mensaje" => $e->getMessage(),
        ];

    } catch (Exception $e) {
        // Captura errores generales
        //echo "Error general: " . $e->getMessage() . PHP_EOL;

        return [
            "status" => false,
            "mensaje" => $e->getMessage(),
        ];
    }

}

function modificarCuentaBancaria($data_recibida = [])
{

    $sk                  = $data_recibida["sk"];
    $payment_method_id   = $data_recibida["payment_method_id"];
    
    $name                = $data_recibida["name"];
    $email               = $data_recibida["email"];

 
    try {
        // Clave secreta de Stripe (TEST)
        //\Stripe\Stripe::setApiKey("sk_test_51IEEnvG2Qzn6cMzPhpbs059cHl6tRq6qE4S1xaS0KSHeezXU4CF8KdbqvEbYqeQD2yyb6GglScwSHGdpXYoTRmJL00VLYpyvNL");
        $stripe = new \Stripe\StripeClient($sk);

        /* $paymentMethod = $stripe->paymentMethods->update(
            $paymentMethodId,
            [
                'billing_details' => [
                    'name' => 'Nuevo Titular de Cuenta',
                ],
            ]
        );
        */
        $paymentMethod = $stripe->paymentMethods->update(
            $payment_method_id, // Ejemplo: 'pm_xxx' (ID del PaymentMethod asociado)
            [
                'billing_details' => [
                    'name'  => $name, // Nuevo nombre del titular
                    'email' => $email, // Nuevo email
                ],
            ]
        );
 
        
 
       

        /* echo "\n";
        echo "\n";
        echo json_encode($setupIntent); exit;
        echo "\n";
        echo "\n";
        echo json_encode($verified); exit; */
 
        return [
            "status"         => true,
      
        ];
    
    } catch (\Stripe\Exception\ApiErrorException $e) {
        // Captura errores de Stripe
        //echo "Error de Stripe: " . $e->getMessage() . PHP_EOL;

        return [
            "status" => false,
            "mensaje" => $e->getMessage(),
        ];

    } catch (Exception $e) {
        // Captura errores generales
        //echo "Error general: " . $e->getMessage() . PHP_EOL;

        return [
            "status" => false,
            "mensaje" => $e->getMessage(),
        ];
    }

}

function creacionClientesSquare($data) 
{
    // Initialize output array
    $salida = [];
    // Validate input
    if (!$data || !isset($data['idempotency_key']) || !isset($data['email_address']) || 
        !isset($data['url']) || !isset($data['version']) || !isset($data['token'])) {
        $salida = [
            "status" => false,
            "mensaje" => "Missing required fields",
            "id_customer" => ""
        ];
        return $salida;
    }
    // Initialize cURL session
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $data['url'] . '/customers'); // e.g., https://connect.squareupsandbox.com/v2 or https://connect.squareup.com/v2
    curl_setopt($ch, CURLOPT_POST, 1);
    $headers = [
        'Square-Version: ' . $data['version'],
        'Authorization: Bearer ' . $data['token'],
        'Content-Type: application/json'
    ];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    // Prepare payload
    $payload = [
        'idempotency_key' => $data['idempotency_key'],
        'email_address' => $data['email_address'],
        'address' => [
            'postal_code' => $data['postal_code'] ?? '',
            'first_name' => $data['first_name'] ?? '',
            //'locality' => $data['locality'] ?? '',
            'address_line_1' => $data['address_line_1'] ?? '',
            //'address_line_2' => $data['address_line_2'] ?? ''
        ],
        'company_name' => $data['first_name'] ?? '',
        //'phone_number' => $data['phone_number'] ?? ''
    ];

    //$email_address_igp      = $data_general_informacion["email"];
    //$postal_code_igp        = $data_general_informacion["zip_hi"];
    //$first_name             = $data_general_informacion["account"];
    //$address_line_1         = $data_general_informacion["address"];

    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    // Execute cURL request
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    // Handle response
    if (curl_errno($ch)) {
        $salida = [
            "status" => false,
            "mensaje" => 'Square Customer cURL Error: ' . curl_error($ch),
            "id_customer" => ""
        ];
    } else {
        $responseData = json_decode($response, true);
        if ($httpCode >= 200 && $httpCode < 300 && isset($responseData['customer']['id'])) {
            // Successful response: Return only id_customer in salida
            $id_customer = $responseData['customer']['id'];
            $salida = [
                "status" => true,
                "mensaje" => "",
                "id_customer" => $id_customer
            ];
        } else if (isset($responseData['errors']) && !empty($responseData['errors'])) {
            // Error response: Extract 'detail' from first error
            $errorDetail = $responseData['errors'][0]['detail'] ?? 'Unknown error';
            $salida = [
                "status" => false,
                "mensaje" => "Square Customer " . $errorDetail,
                "id_customer" => ""
            ];
        } else {
            // Unexpected response
            $salida = [
                "status" => false,
                "mensaje" => "Square Customer Unexpected response from Square API",
                "id_customer" => ""
            ];
        }
    }
    curl_close($ch);
    return $salida;
}

function createUUIDSquare() {
    $data = random_bytes(16);
    $data[6] = chr(ord($data[6]) & 0x0f | 0x40);
    $data[8] = chr(ord($data[8]) & 0x3f | 0x80);
    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
}


function creacionTarjetasSquare($data) {

    // Initialize output array
    $salida = [];
    // Validate input
    if (!$data || !isset($data['idempotency_key']) || !isset($data['source_id']) || 
        !isset($data['url']) || !isset($data['version']) || !isset($data['token'])) {
        $salida = [
            "status" => false,
            "mensaje" => "Missing required fields",
            "id_card" => ""
        ];
        return $salida;
    }
    // Initialize cURL session
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $data['url'] . '/cards'); // e.g., https://connect.squareupsandbox.com/v2 or https://connect.squareup.com/v2
    curl_setopt($ch, CURLOPT_POST, 1);
    $headers = [
        'Square-Version: ' . $data['version'],
        'Authorization: Bearer ' . $data['token'],
        'Content-Type: application/json'
    ];
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    // Prepare payload
    $payload = [
        'idempotency_key' => $data['idempotency_key'],
        'source_id' => $data['source_id'],
        'card' => [
            'cardholder_name' => $data['cardholder_name'] ?? '',
            'customer_id' => $data['customer_id'] ?? '',
            'exp_month' => $data['exp_month'] ?? 0,
            'exp_year' => $data['exp_year'] ?? 0
        ]
    ];
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    // Execute cURL request
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    // Handle response
    if (curl_errno($ch)) {
        $salida = [
            "status" => false,
            "mensaje" => 'Square cURL Error: ' . curl_error($ch),
            "id_card" => ""
        ];
    } else {
        $responseData = json_decode($response, true);
        if ($httpCode >= 200 && $httpCode < 300 && isset($responseData['card']['id'])) {
            // Successful response: Return only id_card in salida
            $id_card = $responseData['card']['id'];
            $salida = [
                "status" => true,
                "mensaje" => "",
                "id_card" => $id_card
            ];
        } else if (isset($responseData['errors']) && !empty($responseData['errors'])) {
            // Error response: Extract 'detail' from first error
            $errorDetail = $responseData['errors'][0]['detail'] ?? 'Unknown error';
            $salida = [
                "status" => false,
                "mensaje" => "Square " . $errorDetail,
                "id_card" => ""
            ];
        } else {
            // Unexpected response
            $salida = [
                "status" => false,
                "mensaje" => "Square Unexpected response from Square API",
                "id_card" => ""
            ];
        }
    }
    curl_close($ch);
    return $salida;
}