<?php
/*
|--------------------------------------------------------------------------
| Controller
|--------------------------------------------------------------------------
|
*/
_auth();
$ui->assign('selected_navigation', 'mnu-12');
$ui->assign('_title', $_L['Leads'] . '- ' . $config['CompanyName']);
$action = route(1, 'list');
$user = User::_info();
$ui->assign('user', $user);

$ui->assign('base_datos_para_socket', DB_NAME);
$ui->assign('config_whatsapp_other_id_para_socket', empty($user["config_whatsapp_other_id"]) == true ? "No_existe" : $user["config_whatsapp_other_id"] );
$ui->assign('url_ir_chat_empleado', U . "social/social-chat-employee");
$ui->assign('url_ir_chat_admin', U . "social/social-chat");

$ui->assign('url_ir_chat_crm', U . "social/chat-crm");
$ui->assign('url_base_plantilla_admintpl', U);
$ui->assign('APP_URL_ORIGINAL_SOCKET', APP_URL_ORIGINAL_SOCKET);
$ui->assign('url_setting_CRM_Parnerts_prepared', url_setting_CRM_Parnerts_prepared);
$ruta_segundaria = route(1);
$armado_ruta = "";
$ui->assign('ws_nombre_socket', ws_nombre_socket);
if(empty($ruta_segundaria) == true )
{
    $armado_ruta = route(0);
}else{
    $armado_ruta = route(0) . "/" . route(1);
}

//$ui->assign('sin_ruta', $armado_ruta);
$ui->assign('sin_ruta', _get('ng'));


if(empty($_SESSION['menu_categorias_user']) == false)
{
    $ui->assign('menu_categorias_user', $_SESSION['menu_categorias_user']);
}

Event::trigger('leads');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Font;

switch ($action) {

    case 'lead-history':

        $leads_id = route(2);

        if(empty($leads_id) == true)
        {
            r2(
                U . 'leads/',
                'e',
                'Leads not Found'
            ); 
            exit();
        }

        $lead = Lead::find($leads_id);

        if($lead == null)
        {
            r2(
                U . 'leads/',
                'e',
                'Leads not Found'
            ); 
            exit();
        }


        $historial_leads = ORM::for_table('lead_history')->where("leads_id",$leads_id)->find_array();

        //print_r(json_encode($historial_leads)); exit;
        
        view('lead_history', [
            'user' => $user,   
            'lead' => $lead,   
            'historial_leads' => $historial_leads,   
        ]);
    
    break;

    case 'add-lead-history-post':

        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);
 
        $tener_usuario_id = $informacion_front['tener_usuario_id'];
        $tener_leads_id = $informacion_front['tener_leads_id'];
        $tener_username = $informacion_front['tener_username'];
        $tener_fullname = $informacion_front['tener_fullname'];
        $tener_email = $informacion_front['tener_email'];
        $tener_telefono = $informacion_front['tener_telefono'];
        $tener_observacion = $informacion_front['tener_observacion'];

        $msg = '';

        if (empty($tener_email) == true) {
            $msg .= "Email is required" . ' <br>';
        }

        if (empty($tener_telefono) == true) {
            $msg .= "Phone is required" . ' <br>';
        }

        if (empty($tener_observacion) == true) {
            $msg .= "Observations is required" . ' <br>';
        }

        $lead = Lead::find($tener_leads_id);

        if($lead == null)
        {
            $msg .= "Leads not Found" . ' <br>';           
        }

        if (empty($msg) == true) {


            $d = ORM::for_table('lead_history')->create();
            $d->leads_id = $tener_leads_id;
            $d->fecha = date("Y-m-d");
            $d->hora = date("H:i:s");
            $d->usuario_id = $tener_usuario_id;
            $d->username = $tener_username;
            $d->fullname = $tener_fullname;
            $d->observaciones = $tener_observacion;
            $d->telefono = $tener_telefono;
            $d->correo = $tener_email;
            
            $d->save();

            $response = array(
                "type" => "success",
                "message" => "¡Information Saved Successfully!",
                "redirect" => U . "leads/",
            );
            print_r(json_encode($response)); exit;

        }else{
            $response = array(
                "type" => "error",
                "message" => $msg,
            );
            print_r(json_encode($response)); exit;
        }
         


         
    
    break;

    case 'list':

        $items = Item::select(['id','name'])->where('type', 'Service')->get();
        $ui->assign('services', $items);

        $usuarios = User::select(['id','fullname'])->where('user_type', 'Employee')->get();

        $ui->assign('usuarios', $usuarios);


        $ui->assign('salutations', db_find_array('crm_salutations'));
        $ui->assign('sources', db_find_array('crm_lead_sources'));
        $ui->assign('industries', db_find_array('crm_industries'));
        $ui->assign('ls', db_find_array('crm_lead_status'));
        $ui->assign(
            'companies',
            db_find_array('sys_companies', ['id', 'company_name'])
        );

        
        view('leads');
    break;

    case 'lead-list':

        $items = Item::select(['id','name'])->where('type', 'Service')->get();
        $ui->assign('services', $items);
    
        $usuarios = User::select(['id','fullname'])->where('user_type', 'Employee')->where('status', 'Active')->get();
    
        $ui->assign('usuarios', $usuarios);

        $ui->assign('usuario_roll', $user->roleid);
    
        $ui->assign('salutations', db_find_array('crm_salutations'));
        $ui->assign('sources', db_find_array('crm_lead_sources'));
        $ui->assign('industries', db_find_array('crm_industries'));
        $ui->assign('ls', db_find_array('crm_lead_status'));
        $ui->assign(
            'companies',
            db_find_array('sys_companies', ['id', 'company_name'])
        );

        if ($user->roleid == "3") {
            //$leads_course = ORM::for_table('crm_leads')->where('id_admin',$user->id)->where('status',"Leads New");
            $id_user = $user->id;
            $leads_course = ORM::get_db()->query("SELECT 
                                                    crm_l.id,
                                                    crm_l.id_admin,
                                                    crm_l.salutation,
                                                    crm_l.first_name,
                                                    crm_l.middle_name,
                                                    crm_l.last_name,
                                                    crm_l.title,
                                                    crm_l.company,
                                                    crm_l.company_id,
                                                    crm_l.email,
                                                    crm_l.phone,
                                                    crm_l.o,
                                                    crm_l.status,
                                                    crm_l.oid,
                                                    crm_l.services,
                                                    crm_l.created_at,
                                                    crm_l.update_status,
                                                    crm_l.updated_at,
                                                    sys_i.name AS nombre_servicio,
                                                    sys_u.fullname AS nombre_usuario_asignado
                                                FROM 
                                                    crm_leads AS crm_l 
                                                LEFT JOIN 
                                                    sys_items AS sys_i 
                                                ON 
                                                    sys_i.id = crm_l.services 
                                                LEFT JOIN 
                                                    sys_users AS sys_u
                                                ON
                                                    sys_u.id=crm_l.id_admin
                                                WHERE 
                                                    crm_l.status = 'Leads New'
                                                AND 
                                                    id_admin='$id_user'

                                                 ORDER BY crm_l.id desc;
                                                ")->fetchAll(PDO::FETCH_ASSOC);

            $leads_discarded = ORM::get_db()->query("SELECT 
                                                    crm_l.id,
                                                    crm_l.id_admin,
                                                    crm_l.salutation,
                                                    crm_l.first_name,
                                                    crm_l.middle_name,
                                                    crm_l.last_name,
                                                    crm_l.title,
                                                    crm_l.company,
                                                    crm_l.company_id,
                                                    crm_l.email,
                                                    crm_l.phone,
                                                    crm_l.o,
                                                    crm_l.status,
                                                    crm_l.oid,
                                                    crm_l.services,
                                                    crm_l.created_at,
                                                    crm_l.update_status,
                                                    crm_l.updated_at,
                                                    sys_i.name AS nombre_servicio,
                                                    sys_u.fullname AS nombre_usuario_asignado
                                                FROM 
                                                    crm_leads AS crm_l 
                                                LEFT JOIN 
                                                    sys_items AS sys_i 
                                                ON 
                                                    sys_i.id = crm_l.services 
                                                LEFT JOIN 
                                                    sys_users AS sys_u
                                                ON
                                                    sys_u.id=crm_l.id_admin
                                                WHERE 
                                                    crm_l.status = 'Discarded Leads'
                                                AND 
                                                    id_admin='$id_user'

                                                ORDER BY crm_l.id desc;
                                                ")->fetchAll(PDO::FETCH_ASSOC);

            $leads_in_process = ORM::get_db()->query("SELECT 
                                                    crm_l.id,
                                                    crm_l.id_admin,
                                                    crm_l.salutation,
                                                    crm_l.first_name,
                                                    crm_l.middle_name,
                                                    crm_l.last_name,
                                                    crm_l.title,
                                                    crm_l.company,
                                                    crm_l.company_id,
                                                    crm_l.email,
                                                    crm_l.phone,
                                                    crm_l.o,
                                                    crm_l.status,
                                                    crm_l.oid,
                                                    crm_l.services,
                                                    crm_l.created_at,
                                                    crm_l.update_status,
                                                    crm_l.updated_at,
                                                    sys_i.name AS nombre_servicio,
                                                    sys_u.fullname AS nombre_usuario_asignado
                                                FROM 
                                                    crm_leads AS crm_l 
                                                LEFT JOIN 
                                                    sys_items AS sys_i 
                                                ON 
                                                    sys_i.id = crm_l.services 
                                                LEFT JOIN 
                                                    sys_users AS sys_u
                                                ON
                                                    sys_u.id=crm_l.id_admin
                                                WHERE 
                                                    crm_l.status = 'Leads in Process'
                                                AND 
                                                    id_admin='$id_user'

                                                ORDER BY crm_l.id desc;
                                                ")->fetchAll(PDO::FETCH_ASSOC);

            $leads_qualified = ORM::get_db()->query("SELECT 
                                                crm_l.id,
                                                crm_l.id_admin,
                                                crm_l.salutation,
                                                crm_l.first_name,
                                                crm_l.middle_name,
                                                crm_l.last_name,
                                                crm_l.title,
                                                crm_l.company,
                                                crm_l.company_id,
                                                crm_l.email,
                                                crm_l.phone,
                                                crm_l.o,
                                                crm_l.status,
                                                crm_l.oid,
                                                crm_l.services,
                                                crm_l.created_at,
                                                crm_l.update_status,
                                                crm_l.updated_at,
                                                sys_i.name AS nombre_servicio,
                                                sys_u.fullname AS nombre_usuario_asignado
                                                FROM 
                                                crm_leads AS crm_l 
                                                LEFT JOIN 
                                                sys_items AS sys_i 
                                                ON 
                                                sys_i.id = crm_l.services 
                                                LEFT JOIN 
                                                sys_users AS sys_u
                                                ON
                                                sys_u.id=crm_l.id_admin
                                                WHERE 
                                                crm_l.status = 'Leads Qualified'
                                                AND 
                                                id_admin='$id_user'

                                                ORDER BY crm_l.id desc;
                                                ")->fetchAll(PDO::FETCH_ASSOC);

            //$leads_discarded = ORM::for_table('crm_leads')->where('id_admin',$user->id)->where('status',"Discarded Leads");
            //$leads_in_process = ORM::for_table('crm_leads')->where('id_admin',$user->id)->where('status',"Leads in Process");
        }else{
            //$leads_course = ORM::for_table('crm_leads')->where('status',"Leads New"); 

            $leads_course = ORM::get_db()->query("SELECT 
                                                    crm_l.id,
                                                    crm_l.id_admin,
                                                    crm_l.salutation,
                                                    crm_l.first_name,
                                                    crm_l.middle_name,
                                                    crm_l.last_name,
                                                    crm_l.title,
                                                    crm_l.company,
                                                    crm_l.company_id,
                                                    crm_l.email,
                                                    crm_l.phone,
                                                    crm_l.o,
                                                    crm_l.status,
                                                    crm_l.oid,
                                                    crm_l.services,
                                                    crm_l.created_at,
                                                    crm_l.update_status,
                                                    crm_l.updated_at,
                                                    sys_i.name AS nombre_servicio,
                                                    sys_u.fullname AS nombre_usuario_asignado
                                                FROM 
                                                    crm_leads AS crm_l 
                                                LEFT JOIN 
                                                    sys_items AS sys_i 
                                                ON 
                                                    sys_i.id = crm_l.services
                                                LEFT JOIN 
                                                    sys_users AS sys_u
                                                ON
                                                    sys_u.id=crm_l.id_admin
                                                WHERE 
                                                    crm_l.status = 'Leads New'
                                                    ORDER BY crm_l.id desc;
                                                ")->fetchAll(PDO::FETCH_ASSOC);

            $leads_discarded = ORM::get_db()->query("SELECT 
                                                crm_l.id,
                                                crm_l.id_admin,
                                                crm_l.salutation,
                                                crm_l.first_name,
                                                crm_l.middle_name,
                                                crm_l.last_name,
                                                crm_l.title,
                                                crm_l.company,
                                                crm_l.company_id,
                                                crm_l.email,
                                                crm_l.phone,
                                                crm_l.o,
                                                crm_l.status,
                                                crm_l.oid,
                                                crm_l.services,
                                                crm_l.created_at,
                                                crm_l.update_status,
                                                crm_l.updated_at,
                                                sys_i.name AS nombre_servicio,
                                                sys_u.fullname AS nombre_usuario_asignado
                                                FROM 
                                                crm_leads AS crm_l 
                                                LEFT JOIN 
                                                sys_items AS sys_i 
                                                ON 
                                                sys_i.id = crm_l.services 
                                                LEFT JOIN 
                                                    sys_users AS sys_u
                                                ON
                                                    sys_u.id=crm_l.id_admin
                                                WHERE 
                                                crm_l.status = 'Discarded Leads'
                                                ORDER BY crm_l.id desc;
                                                ")->fetchAll(PDO::FETCH_ASSOC);

            $leads_in_process = ORM::get_db()->query("SELECT 
                                                crm_l.id,
                                                crm_l.id_admin,
                                                crm_l.salutation,
                                                crm_l.first_name,
                                                crm_l.middle_name,
                                                crm_l.last_name,
                                                crm_l.title,
                                                crm_l.company,
                                                crm_l.company_id,
                                                crm_l.email,
                                                crm_l.phone,
                                                crm_l.o,
                                                crm_l.status,
                                                crm_l.oid,
                                                crm_l.services,
                                                crm_l.created_at,
                                                crm_l.update_status,
                                                crm_l.updated_at,
                                                sys_i.name AS nombre_servicio,
                                                sys_u.fullname AS nombre_usuario_asignado
                                                FROM 
                                                crm_leads AS crm_l 
                                                LEFT JOIN 
                                                sys_items AS sys_i 
                                                ON 
                                                sys_i.id = crm_l.services 
                                                LEFT JOIN 
                                                    sys_users AS sys_u
                                                ON
                                                    sys_u.id=crm_l.id_admin
                                                WHERE 
                                                crm_l.status = 'Leads in Process'
                                                ORDER BY crm_l.id desc;
                                                ")->fetchAll(PDO::FETCH_ASSOC);

            $leads_qualified = ORM::get_db()->query("SELECT 
                                                crm_l.id,
                                                crm_l.id_admin,
                                                crm_l.salutation,
                                                crm_l.first_name,
                                                crm_l.middle_name,
                                                crm_l.last_name,
                                                crm_l.title,
                                                crm_l.company,
                                                crm_l.company_id,
                                                crm_l.email,
                                                crm_l.phone,
                                                crm_l.o,
                                                crm_l.status,
                                                crm_l.oid,
                                                crm_l.services,
                                                crm_l.created_at,
                                                crm_l.update_status,
                                                crm_l.updated_at,
                                                sys_i.name AS nombre_servicio,
                                                sys_u.fullname AS nombre_usuario_asignado
                                                FROM 
                                                crm_leads AS crm_l 
                                                LEFT JOIN 
                                                sys_items AS sys_i 
                                                ON 
                                                sys_i.id = crm_l.services 
                                                LEFT JOIN 
                                                    sys_users AS sys_u
                                                ON
                                                    sys_u.id=crm_l.id_admin
                                                WHERE 
                                                crm_l.status = 'Leads Qualified'
                                                ORDER BY crm_l.id desc;
                                                ")->fetchAll(PDO::FETCH_ASSOC);
                                                

            //$leads_discarded = ORM::for_table('crm_leads')->where('status',"Discarded Leads"); 
            //$leads_in_process = ORM::for_table('crm_leads')->where('status',"Leads in Process"); 
        }

 
        $ui->assign('leads_course', $leads_course);

        $ui->assign('leads_discarded', $leads_discarded);

        $ui->assign('leads_in_process', $leads_in_process);

        $ui->assign('leads_qualified', $leads_qualified);


        $ui->assign('url_download', U . "leads/download-file");

        //print_r(json_encode($leads_course)); exit;
    
        view('leads_v1');
    break;

    case 'download-file':

        $leads = [];

        if ($user->roleid == "3")
        {
            $id_user = $user->id;
            $leads = ORM::get_db()->query("SELECT 
                                                 -- crm_l.id,
                                                -- COALESCE(NULLIF(crm_l.salutation, ''), 'Mrs.') AS salutation,
                                                -- crm_l.first_name,
                                                -- crm_l.last_name,
                                                    crm_l.title,
                                                    crm_l.company,
                                                    crm_l.email,
                                                    crm_l.phone,
                                                    crm_l.o AS 'owner',
                                                    crm_l.status,
                                                -- crm_l.oid,
                                                    crm_l.created_at,
                                                    crm_l.update_status,
                                                    sys_i.name AS nombre_servicio,
                                                    sys_u.fullname AS nombre_usuario_asignado,
                                                    CONCAT(COALESCE(NULLIF(crm_l.salutation, ''), 'Mr.'), ' ', crm_l.first_name, ' ', crm_l.last_name) AS cliente
                                                FROM 
                                                    crm_leads AS crm_l 
                                                LEFT JOIN 
                                                    sys_items AS sys_i 
                                                ON 
                                                    sys_i.id = crm_l.services 
                                                LEFT JOIN 
                                                    sys_users AS sys_u
                                                ON
                                                    sys_u.id=crm_l.id_admin
                                                WHERE 
                                                     
                                                    id_admin='$id_user'

                                                 ORDER BY crm_l.id desc;
                                                ")->fetchAll(PDO::FETCH_ASSOC);
        }else{
            $leads = ORM::get_db()->query("SELECT 
                                               -- crm_l.id,
                                               -- COALESCE(NULLIF(crm_l.salutation, ''), 'Mrs.') AS salutation,
                                               -- crm_l.first_name,
                                               -- crm_l.last_name,
                                                crm_l.title,
                                                crm_l.company,
                                                crm_l.email,
                                                crm_l.phone,
                                                crm_l.o AS 'owner',
                                                crm_l.status,
                                               -- crm_l.oid,
                                                crm_l.created_at,
                                                crm_l.update_status,
                                                sys_i.name AS nombre_servicio,
                                                sys_u.fullname AS nombre_usuario_asignado,
                                                CONCAT(COALESCE(NULLIF(crm_l.salutation, ''), 'Mr.'), ' ', crm_l.first_name, ' ', crm_l.last_name) AS cliente
                                            FROM 
                                                crm_leads AS crm_l 
                                            LEFT JOIN 
                                                sys_items AS sys_i 
                                                ON sys_i.id = crm_l.services 
                                            LEFT JOIN 
                                                sys_users AS sys_u
                                                ON sys_u.id = crm_l.id_admin
                                            WHERE 
                                                1
                                            ORDER BY 
                                                crm_l.id DESC 
                                          --  LIMIT 3;
                                                ")->fetchAll(PDO::FETCH_ASSOC);
        }
         

    

        ob_clean();
        ini_set('display_errors', 0);
        error_reporting(0);

        // Crear array con los títulos de las columnas
        $data = [
            ['NAME','TITLE', 'COMPANY', 'EMAIL', 'PHONE', 'OWNER', 'STATUS', 'CREATED AT', 'UPDATE STATUS', 'SERVICES', 'ASSIGNED STAFF']
        ];

        // Añadir los datos obtenidos del query al array $data
        foreach ($leads as $lead) {
            $data[] = [
                $lead['cliente'],
                $lead['title'],
                $lead['company'],
                $lead['email'],
                $lead['phone'],
                $lead['owner'],
                $lead['status'],
                $lead['created_at'],
                $lead['update_status'],
                $lead['nombre_servicio'],
                $lead['nombre_usuario_asignado']
            ];
        }

        // Crear nuevo objeto Spreadsheet
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Llenar el archivo Excel con datos del arreglo
        foreach ($data as $rowIndex => $row) {
            foreach ($row as $colIndex => $cellValue) {
                $sheet->setCellValueByColumnAndRow($colIndex + 1, $rowIndex + 1, $cellValue);
            }
        }

        // Aplicar negrita a la fila de títulos (primera fila)
        $sheet->getStyle('A1:K1')->getFont()->setBold(true);

        // Ajustar el ancho de las columnas para agregar separación
        foreach (range('A', 'K') as $col) {
            $sheet->getColumnDimension($col)->setAutoSize(true);
        }

        // Crear archivo Excel y configurarlo para descargar
        $writer = new Xlsx($spreadsheet);
        $filename = date("Y-m-d") . '_leads_all.xlsx';

        // Enviar cabeceras para forzar la descarga del archivo
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');

        // Descargar el archivo
        $writer->save('php://output');
        exit;
    break;

    case 'filtro-leands-post':
        $json = file_get_contents('php://input');

        // Decodifica el JSON a un array asociativo
        $informacion_front = json_decode($json, true);
 
        $servicio_id = $informacion_front['servicio_id'];
        $usuario_id = $informacion_front['usuario_id'];
        $first_name = $informacion_front['first_name'];
        $last_name = $informacion_front['last_name'];

        $sql_lead_curso = " AND crm_l.status = 'Leads New'";
 
        if(empty($servicio_id) == false)
        {
            $sql_lead_curso .= " AND crm_l.services = '$servicio_id'";
        }

        if(empty($usuario_id) == false)
        {
            $sql_lead_curso .= " AND crm_l.id_admin = '$usuario_id'";
        }

        if(empty($first_name) == false)
        {
            $sql_lead_curso .= " AND crm_l.first_name LIKE '%$first_name%'";
        }

        if(empty($last_name) == false)
        {
            $sql_lead_curso .= " AND crm_l.last_name LIKE '%$last_name%'";
        }

        //--------------------fin de lead cursos

        $sql_lead_descartado = " AND crm_l.status = 'Discarded Leads'";
 
        if(empty($servicio_id) == false)
        {
            $sql_lead_descartado .= " AND crm_l.services = '$servicio_id'";
        }

        if(empty($usuario_id) == false)
        {
            $sql_lead_descartado .= " AND crm_l.id_admin = '$usuario_id'";
        }

        if(empty($first_name) == false)
        {
            $sql_lead_descartado .= " AND crm_l.first_name LIKE '%$first_name%'";
        }

        if(empty($last_name) == false)
        {
            $sql_lead_descartado .= " AND crm_l.last_name LIKE '%$last_name%'";
        }
        //fin lead en descartado------------------

        $sql_lead_progress = " AND crm_l.status = 'Leads in Process'";
 
        if(empty($servicio_id) == false)
        {
            $sql_lead_progress .= " AND crm_l.services = '$servicio_id'";
        }

        if(empty($usuario_id) == false)
        {
            $sql_lead_progress .= " AND crm_l.id_admin = '$usuario_id'";
        }

        if(empty($first_name) == false)
        {
            $sql_lead_progress .= " AND crm_l.first_name LIKE '%$first_name%'";
        }

        if(empty($last_name) == false)
        {
            $sql_lead_progress .= " AND crm_l.last_name LIKE '%$last_name%'";
        }

        //FIN de lead progress --------------------------

        $sql_lead_qualified = " AND crm_l.status = 'Leads Qualified'";
 
        if(empty($servicio_id) == false)
        {
            $sql_lead_qualified .= " AND crm_l.services = '$servicio_id'";
        }

        if(empty($usuario_id) == false)
        {
            $sql_lead_qualified .= " AND crm_l.id_admin = '$usuario_id'";
        }

        if(empty($first_name) == false)
        {
            $sql_lead_qualified .= " AND crm_l.first_name LIKE '%$first_name%'";
        }

        if(empty($last_name) == false)
        {
            $sql_lead_qualified .= " AND crm_l.last_name LIKE '%$last_name%'";
        }
      
        $leads_course = ORM::get_db()->query("SELECT 
                                                    crm_l.id,
                                                    crm_l.id_admin,
                                                    crm_l.salutation,
                                                    crm_l.first_name,
                                                    crm_l.middle_name,
                                                    crm_l.last_name,
                                                    crm_l.title,
                                                    crm_l.company,
                                                    crm_l.company_id,
                                                    crm_l.email,
                                                    crm_l.phone,
                                                    crm_l.o,
                                                    crm_l.status,
                                                    crm_l.oid,
                                                    crm_l.services,
                                                    crm_l.created_at,
                                                    crm_l.update_status,
                                                    crm_l.updated_at,
                                                    sys_i.name AS nombre_servicio,
                                                    sys_u.fullname AS nombre_usuario_asignado
                                                FROM 
                                                    crm_leads AS crm_l 
                                                LEFT JOIN 
                                                    sys_items AS sys_i 
                                                ON 
                                                    sys_i.id = crm_l.services
                                                LEFT JOIN 
                                                    sys_users AS sys_u
                                                ON
                                                    sys_u.id=crm_l.id_admin
                                                WHERE 
                                                    1 $sql_lead_curso
                                                    ORDER BY crm_l.id DESC
                                                    ;
                                                ")->fetchAll(PDO::FETCH_ASSOC);

        $leads_discarded = ORM::get_db()->query("SELECT 
                                                    crm_l.id,
                                                    crm_l.id_admin,
                                                    crm_l.salutation,
                                                    crm_l.first_name,
                                                    crm_l.middle_name,
                                                    crm_l.last_name,
                                                    crm_l.title,
                                                    crm_l.company,
                                                    crm_l.company_id,
                                                    crm_l.email,
                                                    crm_l.phone,
                                                    crm_l.o,
                                                    crm_l.status,
                                                    crm_l.oid,
                                                    crm_l.services,
                                                    crm_l.created_at,
                                                    crm_l.update_status,
                                                    crm_l.updated_at,
                                                    sys_i.name AS nombre_servicio,
                                                    sys_u.fullname AS nombre_usuario_asignado
                                                FROM 
                                                    crm_leads AS crm_l 
                                                LEFT JOIN 
                                                    sys_items AS sys_i 
                                                ON 
                                                    sys_i.id = crm_l.services 
                                                LEFT JOIN 
                                                    sys_users AS sys_u
                                                ON
                                                    sys_u.id=crm_l.id_admin
                                                WHERE 
                                                    1 $sql_lead_descartado
                                                     ORDER BY crm_l.id DESC
                                                    ;
                                                ")->fetchAll(PDO::FETCH_ASSOC);

        $leads_in_process = ORM::get_db()->query("SELECT 
                                                    crm_l.id,
                                                    crm_l.id_admin,
                                                    crm_l.salutation,
                                                    crm_l.first_name,
                                                    crm_l.middle_name,
                                                    crm_l.last_name,
                                                    crm_l.title,
                                                    crm_l.company,
                                                    crm_l.company_id,
                                                    crm_l.email,
                                                    crm_l.phone,
                                                    crm_l.o,
                                                    crm_l.status,
                                                    crm_l.oid,
                                                    crm_l.services,
                                                    crm_l.created_at,
                                                    crm_l.update_status,
                                                    crm_l.updated_at,
                                                    sys_i.name AS nombre_servicio,
                                                    sys_u.fullname AS nombre_usuario_asignado
                                                FROM 
                                                    crm_leads AS crm_l 
                                                LEFT JOIN 
                                                    sys_items AS sys_i 
                                                ON 
                                                    sys_i.id = crm_l.services 
                                                LEFT JOIN 
                                                    sys_users AS sys_u
                                                ON
                                                    sys_u.id=crm_l.id_admin
                                                WHERE 
                                                    1 $sql_lead_progress
                                                     ORDER BY crm_l.id DESC
                                                    ;
                                                ")->fetchAll(PDO::FETCH_ASSOC);

        $leads_in_qualified = ORM::get_db()->query("SELECT 
                                                crm_l.id,
                                                crm_l.id_admin,
                                                crm_l.salutation,
                                                crm_l.first_name,
                                                crm_l.middle_name,
                                                crm_l.last_name,
                                                crm_l.title,
                                                crm_l.company,
                                                crm_l.company_id,
                                                crm_l.email,
                                                crm_l.phone,
                                                crm_l.o,
                                                crm_l.status,
                                                crm_l.oid,
                                                crm_l.services,
                                                crm_l.created_at,
                                                crm_l.update_status,
                                                crm_l.updated_at,
                                                sys_i.name AS nombre_servicio,
                                                sys_u.fullname AS nombre_usuario_asignado
                                                FROM 
                                                crm_leads AS crm_l 
                                                LEFT JOIN 
                                                sys_items AS sys_i 
                                                ON 
                                                sys_i.id = crm_l.services 
                                                LEFT JOIN 
                                                sys_users AS sys_u
                                                ON
                                                sys_u.id=crm_l.id_admin
                                                WHERE 
                                                1 $sql_lead_qualified
                                                ORDER BY crm_l.id DESC
                                                ;
                                                ")->fetchAll(PDO::FETCH_ASSOC);

                $leads_course_html = '';
                foreach ($leads_course as $s) {
                    $leads_course_html .= '<div style="background-color: white; padding: 5px; border-radius: 5px; box-shadow: 0 0 13px 0 rgba(31,17,173,.08); overflow-x:auto; margin-bottom:20px;">';

                    if (!empty($s["title"])) {
                        $leads_course_html .= '<p style="font-weight:600; margin:0px; text-align:center">' . htmlspecialchars($s["title"]) . '</p>';
                    }

                    $leads_course_html .= '<p style="font-weight:600; margin:0px; text-align:center">' . htmlspecialchars($s["nombre_servicio"]) . '</p>';
                    $leads_course_html .= '<p style="font-weight:600; margin:0px; text-align:center">' . htmlspecialchars($s["company"]) . '</p>';
                    $leads_course_html .= '<p style="font-weight:600; margin:0px; text-align:center">Created Date: ' . date("d/m/Y", strtotime($s["created_at"])) . '</p>';
                    $leads_course_html .= '<hr>';
                    $leads_course_html .= '<p style="font-weight:600; margin:0px; text-align:center">Owner: ' . htmlspecialchars($s["o"]) . '</p>';
                    $leads_course_html .= '<p style="font-weight:600; margin:0px; text-align:center">Assigned: ';

                    if (!empty($s["nombre_usuario_asignado"]) && $s["id_admin"] != 0) {
                        $leads_course_html .= htmlspecialchars($s["nombre_usuario_asignado"]);
                    } else {
                        $leads_course_html .= 'unassigned';
                    }

                    $leads_course_html .= '</p>';
                    $leads_course_html .= '<p style="font-weight:600; margin:0px; text-align:center">Name: ';

                    if (!empty($s["salutation"])) {
                        $leads_course_html .= htmlspecialchars($s["salutation"]);
                    } else {
                        $leads_course_html .= 'Mr.';
                    }

                    if (!empty($s["first_name"])) {
                        $leads_course_html .= ' ' . htmlspecialchars($s["first_name"]);
                    }

                    if (!empty($s["middle_name"])) {
                        $leads_course_html .= ' ' . htmlspecialchars($s["middle_name"]);
                    }

                    if (!empty($s["last_name"])) {
                        $leads_course_html .= ' ' . htmlspecialchars($s["last_name"]);
                    }

                    $leads_course_html .= '</p>';

                    if (!empty($s["email"])) {
                        $leads_course_html .= '<p style="font-weight:600; margin:0px; text-align:center">Email: ' . htmlspecialchars($s["email"]) . '</p>';
                    }

                    if (!empty($s["phone"])) {
                        $leads_course_html .= '<p style="font-weight:600; margin:0px; text-align:center">Phone: ' . htmlspecialchars($s["phone"]) . '</p>';
                    }

                    $leads_course_html .= '<br>';
                    $leads_course_html .= '<div class="container btn-group text-center">';
                    $leads_course_html .= '<a href="#" class="btn btn-dark btn-xs chistoryLead" data-id="' . htmlspecialchars($s['id']) . '" id="' . htmlspecialchars($s['id']) . '"><i class="fal fa-eye"></i></a>';
                    $leads_course_html .= '<a href="#" class="btn btn-primary btn-xs cview" data-id="vid' . htmlspecialchars($s['id']) . '" id="vid' . htmlspecialchars($s['id']) . '"><i class="fal fa-search"></i></a>';
                    $leads_course_html .= '<a href="#" class="btn btn-warning btn-xs cedit" data-id="eid' . htmlspecialchars($s['id']) . '" id="eid' . htmlspecialchars($s['id']) . '"><i class="fal fa-pencil"></i></a>';
                    $leads_course_html .= '<a href="#" class="btn btn-danger btn-xs cdelete" data-id="did' . htmlspecialchars($s['id']) . '" id="did' . htmlspecialchars($s['id']) . '"><i class="fal fa-trash-alt"></i></a>';
                    $leads_course_html .= '</div>';
                    $leads_course_html .= '</div>';
                }

 
              
                $leads_discarded_html = '';
                foreach ($leads_discarded as $s) {
                    $leads_discarded_html .= '<div style="background-color: white; padding: 5px; border-radius: 5px; box-shadow: 0 0 13px 0 rgba(31,17,173,.08); overflow-x:auto; margin-bottom:20px;">';

                    if (!empty($s["title"])) {
                        $leads_discarded_html .= '<p style="font-weight:600; margin:0px; text-align:center">' . htmlspecialchars($s["title"]) . '</p>';
                    }

                    $leads_discarded_html .= '<p style="font-weight:600; margin:0px; text-align:center">' . htmlspecialchars($s["nombre_servicio"]) . '</p>';
                    $leads_discarded_html .= '<p style="font-weight:600; margin:0px; text-align:center">' . htmlspecialchars($s["company"]) . '</p>';
                    $leads_discarded_html .= '<p style="font-weight:600; margin:0px; text-align:center">Created Date: ' . date("d/m/Y", strtotime($s["created_at"])) . '</p>';
                    $leads_discarded_html .= '<hr>';
                    $leads_discarded_html .= '<p style="font-weight:600; margin:0px; text-align:center">Owner: ' . htmlspecialchars($s["o"]) . '</p>';
                    $leads_discarded_html .= '<p style="font-weight:600; margin:0px; text-align:center">Assigned: ';

                    if (!empty($s["nombre_usuario_asignado"]) && $s["id_admin"] != 0) {
                        $leads_discarded_html .= htmlspecialchars($s["nombre_usuario_asignado"]);
                    } else {
                        $leads_discarded_html .= 'unassigned';
                    }

                    $leads_discarded_html .= '</p>';
                    $leads_discarded_html .= '<p style="font-weight:600; margin:0px; text-align:center">Name: ';

                    if (!empty($s["salutation"])) {
                        $leads_discarded_html .= htmlspecialchars($s["salutation"]);
                    } else {
                        $leads_discarded_html .= 'Mr.';
                    }

                    if (!empty($s["first_name"])) {
                        $leads_discarded_html .= ' ' . htmlspecialchars($s["first_name"]);
                    }

                    if (!empty($s["middle_name"])) {
                        $leads_discarded_html .= ' ' . htmlspecialchars($s["middle_name"]);
                    }

                    if (!empty($s["last_name"])) {
                        $leads_discarded_html .= ' ' . htmlspecialchars($s["last_name"]);
                    }

                    $leads_discarded_html .= '</p>';

                    if (!empty($s["email"])) {
                        $leads_discarded_html .= '<p style="font-weight:600; margin:0px; text-align:center">Email: ' . htmlspecialchars($s["email"]) . '</p>';
                    }

                    if (!empty($s["phone"])) {
                        $leads_discarded_html .= '<p style="font-weight:600; margin:0px; text-align:center">Phone: ' . htmlspecialchars($s["phone"]) . '</p>';
                    }

                    $leads_discarded_html .= '<br>';
                    $leads_discarded_html .= '<div class="container btn-group text-center">';
                    $leads_discarded_html .= '<a href="#" class="btn btn-dark btn-xs chistoryLead" data-id="' . htmlspecialchars($s['id']) . '" id="' . htmlspecialchars($s['id']) . '"><i class="fal fa-eye"></i></a>';
                    $leads_discarded_html .= '<a href="#" class="btn btn-primary btn-xs cview" data-id="vid' . htmlspecialchars($s['id']) . '" id="vid' . htmlspecialchars($s['id']) . '"><i class="fal fa-search"></i></a>';
                    $leads_discarded_html .= '<a href="#" class="btn btn-warning btn-xs cedit" data-id="eid' . htmlspecialchars($s['id']) . '" id="eid' . htmlspecialchars($s['id']) . '"><i class="fal fa-pencil"></i></a>';
                    $leads_discarded_html .= '<a href="#" class="btn btn-danger btn-xs cdelete" data-id="did' . htmlspecialchars($s['id']) . '" id="did' . htmlspecialchars($s['id']) . '"><i class="fal fa-trash-alt"></i></a>';
                    $leads_discarded_html .= '</div>';
                    $leads_discarded_html .= '</div>';
                }


                $leads_in_process_html = '';
                foreach ($leads_in_process as $s) {
                    $leads_in_process_html .= '<div style="background-color: white; padding: 5px; border-radius: 5px; box-shadow: 0 0 13px 0 rgba(31,17,173,.08); overflow-x:auto; margin-bottom:20px;">';

                    if (!empty($s["title"])) {
                        $leads_in_process_html .= '<p style="font-weight:600; margin:0px; text-align:center">' . htmlspecialchars($s["title"]) . '</p>';
                    }

                    $leads_in_process_html .= '<p style="font-weight:600; margin:0px; text-align:center">' . htmlspecialchars($s["nombre_servicio"]) . '</p>';
                    $leads_in_process_html .= '<p style="font-weight:600; margin:0px; text-align:center">' . htmlspecialchars($s["company"]) . '</p>';
                    $leads_in_process_html .= '<p style="font-weight:600; margin:0px; text-align:center">Created Date: ' . date("d/m/Y", strtotime($s["created_at"])) . '</p>';
                    $leads_in_process_html .= '<hr>';
                    $leads_in_process_html .= '<p style="font-weight:600; margin:0px; text-align:center">Owner: ' . htmlspecialchars($s["o"]) . '</p>';
                    $leads_in_process_html .= '<p style="font-weight:600; margin:0px; text-align:center">Assigned: ';

                    if (!empty($s["nombre_usuario_asignado"]) && $s["id_admin"] != 0) {
                        $leads_in_process_html .= htmlspecialchars($s["nombre_usuario_asignado"]);
                    } else {
                        $leads_in_process_html .= 'unassigned';
                    }

                    $leads_in_process_html .= '</p>';
                    $leads_in_process_html .= '<p style="font-weight:600; margin:0px; text-align:center">Name: ';

                    if (!empty($s["salutation"])) {
                        $leads_in_process_html .= htmlspecialchars($s["salutation"]);
                    } else {
                        $leads_in_process_html .= 'Mr.';
                    }

                    if (!empty($s["first_name"])) {
                        $leads_in_process_html .= ' ' . htmlspecialchars($s["first_name"]);
                    }

                    if (!empty($s["middle_name"])) {
                        $leads_in_process_html .= ' ' . htmlspecialchars($s["middle_name"]);
                    }

                    if (!empty($s["last_name"])) {
                        $leads_in_process_html .= ' ' . htmlspecialchars($s["last_name"]);
                    }

                    $leads_in_process_html .= '</p>';

                    if (!empty($s["email"])) {
                        $leads_in_process_html .= '<p style="font-weight:600; margin:0px; text-align:center">Email: ' . htmlspecialchars($s["email"]) . '</p>';
                    }

                    if (!empty($s["phone"])) {
                        $leads_in_process_html .= '<p style="font-weight:600; margin:0px; text-align:center">Phone: ' . htmlspecialchars($s["phone"]) . '</p>';
                    }

                    $leads_in_process_html .= '<br>';
                    $leads_in_process_html .= '<div class="container btn-group text-center">';
                    $leads_in_process_html .= '<a href="#" class="btn btn-dark btn-xs chistoryLead" data-id="' . htmlspecialchars($s['id']) . '" id="' . htmlspecialchars($s['id']) . '"><i class="fal fa-eye"></i></a>';
                    $leads_in_process_html .= '<a href="#" class="btn btn-primary btn-xs cview" data-id="vid' . htmlspecialchars($s['id']) . '" id="vid' . htmlspecialchars($s['id']) . '"><i class="fal fa-search"></i></a>';
                    $leads_in_process_html .= '<a href="#" class="btn btn-warning btn-xs cedit" data-id="eid' . htmlspecialchars($s['id']) . '" id="eid' . htmlspecialchars($s['id']) . '"><i class="fal fa-pencil"></i></a>';
                    $leads_in_process_html .= '<a href="#" class="btn btn-danger btn-xs cdelete" data-id="did' . htmlspecialchars($s['id']) . '" id="did' . htmlspecialchars($s['id']) . '"><i class="fal fa-trash-alt"></i></a>';
                    $leads_in_process_html .= '</div>';
                    $leads_in_process_html .= '</div>';
                }

                $leads_in_qualified_html = '';
                foreach ($leads_in_qualified as $s) {
                    $leads_in_qualified_html .= '<div style="background-color: white; padding: 5px; border-radius: 5px; box-shadow: 0 0 13px 0 rgba(31,17,173,.08); overflow-x:auto; margin-bottom:20px;">';

                    if (!empty($s["title"])) {
                        $leads_in_qualified_html .= '<p style="font-weight:600; margin:0px; text-align:center">' . htmlspecialchars($s["title"]) . '</p>';
                    }

                    $leads_in_qualified_html .= '<p style="font-weight:600; margin:0px; text-align:center">' . htmlspecialchars($s["nombre_servicio"]) . '</p>';
                    $leads_in_qualified_html .= '<p style="font-weight:600; margin:0px; text-align:center">' . htmlspecialchars($s["company"]) . '</p>';
                    $leads_in_qualified_html .= '<p style="font-weight:600; margin:0px; text-align:center">Created Date: ' . date("d/m/Y", strtotime($s["created_at"])) . '</p>';
                    $leads_in_qualified_html .= '<hr>';
                    $leads_in_qualified_html .= '<p style="font-weight:600; margin:0px; text-align:center">Owner: ' . htmlspecialchars($s["o"]) . '</p>';
                    $leads_in_qualified_html .= '<p style="font-weight:600; margin:0px; text-align:center">Assigned: ';

                    if (!empty($s["nombre_usuario_asignado"]) && $s["id_admin"] != 0) {
                        $leads_in_qualified_html .= htmlspecialchars($s["nombre_usuario_asignado"]);
                    } else {
                        $leads_in_qualified_html .= 'unassigned';
                    }

                    $leads_in_qualified_html .= '</p>';
                    $leads_in_qualified_html .= '<p style="font-weight:600; margin:0px; text-align:center">Name: ';

                    if (!empty($s["salutation"])) {
                        $leads_in_qualified_html .= htmlspecialchars($s["salutation"]);
                    } else {
                        $leads_in_qualified_html .= 'Mr.';
                    }

                    if (!empty($s["first_name"])) {
                        $leads_in_qualified_html .= ' ' . htmlspecialchars($s["first_name"]);
                    }

                    if (!empty($s["middle_name"])) {
                        $leads_in_qualified_html .= ' ' . htmlspecialchars($s["middle_name"]);
                    }

                    if (!empty($s["last_name"])) {
                        $leads_in_qualified_html .= ' ' . htmlspecialchars($s["last_name"]);
                    }

                    $leads_in_qualified_html .= '</p>';

                    if (!empty($s["email"])) {
                        $leads_in_qualified_html .= '<p style="font-weight:600; margin:0px; text-align:center">Email: ' . htmlspecialchars($s["email"]) . '</p>';
                    }

                    if (!empty($s["phone"])) {
                        $leads_in_qualified_html .= '<p style="font-weight:600; margin:0px; text-align:center">Phone: ' . htmlspecialchars($s["phone"]) . '</p>';
                    }

                    $leads_in_qualified_html .= '<br>';
                    $leads_in_qualified_html .= '<div class="container btn-group text-center">';
                    $leads_in_qualified_html .= '<a href="#" class="btn btn-dark btn-xs chistoryLead" data-id="' . htmlspecialchars($s['id']) . '" id="' . htmlspecialchars($s['id']) . '"><i class="fal fa-eye"></i></a>';
                    $leads_in_qualified_html .= '<a href="#" class="btn btn-primary btn-xs cview" data-id="vid' . htmlspecialchars($s['id']) . '" id="vid' . htmlspecialchars($s['id']) . '"><i class="fal fa-search"></i></a>';
                    $leads_in_qualified_html .= '<a href="#" class="btn btn-warning btn-xs cedit" data-id="eid' . htmlspecialchars($s['id']) . '" id="eid' . htmlspecialchars($s['id']) . '"><i class="fal fa-pencil"></i></a>';
                    $leads_in_qualified_html .= '<a href="#" class="btn btn-danger btn-xs cdelete" data-id="did' . htmlspecialchars($s['id']) . '" id="did' . htmlspecialchars($s['id']) . '"><i class="fal fa-trash-alt"></i></a>';
                    $leads_in_qualified_html .= '</div>';
                    $leads_in_qualified_html .= '</div>';
                }


        $response = array(
            "type" => "success",
            "leads_course" => $leads_course_html ?? "",  
            "leads_discarded" => $leads_discarded_html  ?? "",  
            "leads_in_process" => $leads_in_process_html  ?? "",  
            "leads_in_qualified" => $leads_in_qualified_html  ?? "",  
        );
        print_r(json_encode($response)) ; exit;
    break;

    case 'modal_lead':
    $act = route(2);
    $items = Item::select(['id','name'])->where('type', 'Service')->get();
    $agents = User::select(['id', 'fullname'])->where('user_type','Employee')->orderBy('id', 'desc')->get();

    $ui->assign('act', $act);
    $ui->assign('salutations', db_find_array('crm_salutations'));
    $ui->assign('sources', db_find_array('crm_lead_sources'));
    $ui->assign('industries', db_find_array('crm_industries'));
    $ui->assign('ls', db_find_array('crm_lead_status'));
    $ui->assign('services', $items);
    $ui->assign('agents', $agents);

    $ui->assign(
        'companies',
        db_find_array('sys_companies', ['id', 'company_name'])
    );
    $val = [];
    if ($act == 'view') {
        $id = route(3);
        $id = str_replace('vid', '', $id);
        $id = str_replace('xid', '', $id);
        $lead = ORM::for_table('crm_leads')->find($id);
        $items = Item::select(['name'])->where('id', $lead->services)->get();
        $items=$items[0]->name;
        $agents = User::select(['fullname'])->where('id', $lead->id_admin)->get();
        $agents=$agents[0]->fullname;

        if ($lead) {
            $ui->assign('lead', $lead);
            $ui->assign('items', $items);
            $ui->assign('agents', $agents);
        }
    } elseif ($act == 'edit') {
        $lid = route(3);
        $lid = str_replace('eid', '', $lid);
        $lead = db_find_one('crm_leads', $lid);
        if ($lead) {
            $val['status'] = $lead->status;
            $val['salutation'] = $lead->salutation;
            $val['first_name'] = $lead->first_name;
            $val['middle_name'] = $lead->middle_name;
            $val['last_name'] = $lead->last_name;
            $val['suffix'] = $lead->suffix;
            $val['title'] = $lead->title;
            $val['company'] = $lead->company;
            $val['website'] = $lead->website;
            $val['industry'] = $lead->industry;
            $val['employees'] = $lead->employees;
            $val['email'] = $lead->email;
            $val['phone'] = $lead->phone;
            $val['source'] = $lead->source;
            $val['address'] = $lead->address;
            $val['street'] = $lead->street;
            $val['city'] = $lead->city;
            $val['state'] = $lead->state;
            $val['zip'] = $lead->zip;
            $val['country'] = $lead->country;
            $val['public'] = $lead->public;

            $val['ratings'] = $lead->ratings;
            $val['street'] = $lead->street;
            $val['country'] = $lead->country;
            $val['assigned'] = $lead->assigned;
            $val['lid'] = $lead->id;
            $val['agents'] = $lead->id_admin;
            $val['services'] = $lead->services;

        }
    } else {
        $val['status'] = '';
        $val['salutation'] = '';
        $val['first_name'] = '';
        $val['middle_name'] = '';
        $val['last_name'] = '';
        $val['suffix'] = '';
        $val['title'] = '';
        $val['company'] = '';
        $val['website'] = '';
        $val['industry'] = '';
        $val['employees'] = '';
        $val['email'] = '';
        $val['phone'] = '';
        $val['source'] = '';
        $val['address'] = '';
        $val['street'] = '';
        $val['city'] = '';
        $val['state'] = '';
        $val['zip'] = '';
        $val['country'] = '';
        $val['public'] = '';
        $val['ratings'] = '';
        $val['street'] = '';
        $val['country'] = '';
        $val['assigned'] = '';
        $val['lid'] = '';
        $val['agents'] = '';
        $val['services'] = '';

    }

    $ui->assign('val', $val);
    view('modal_lead');
    break;

    case 'post':
    $act = _post('act');
    $data = ib_posted_data();
    $data['oid'] = $user->id;

    //echo  $data; exit;

    if ($act == 'view') {
    } elseif ($act == 'edit') {
        echo Leads::update($data['lid'], $data,$user->roleid,$user->id);
    } else {
        echo Leads::create($data,$user->roleid,$user->id);
    }

    break;

    case 'json_list':
    $data = request()->all();
    $columns = [];
    $columns[] = 'id';
    $columns[] = 'created_at';
    $columns[] = 'services';
    $columns[] = 'assigned';
    $columns[] = 'name';
    $columns[] = 'title';
    $columns[] = 'company';
    $columns[] = 'phone';
    $columns[] = 'email';
    $columns[] = 'status';
    $columns[] = 'owner';
    $columns[] = 'manage';
    $order_by = $data['order'];
    $o_c_id = $order_by[0]['column'];
    $o_type = $order_by[0]['dir'];
    $a_order_by = $columns[$o_c_id];
    if ($user->roleid == "3") {
        $d = ORM::for_table('crm_leads')->where('id_admin',$user->id);
    }else{
        $d = ORM::for_table('crm_leads'); 
    }
    $d->select('id');
    $d->select('id_admin');
    $d->select('salutation');
    $d->select('first_name');
    $d->select('middle_name');
    $d->select('last_name');
    $d->select('title');
    $d->select('company');
    $d->select('company_id');
    $d->select('email');
    $d->select('phone');
    $d->select('o');
    $d->select('status');
    $d->select('oid');
    $d->select('services');
    $d->select('created_at');
    $d->select('update_status');
    $d->select('updated_at');


    $services = _post('services');
    if ($services != '') {
        $d->where_like('services', "$services");
    }

    $users_id = _post('users');
    if ($users_id != '') {
        $d->where_like('id_admin', "$users_id");
    }

    $first_name = _post('first_name');
    if ($first_name != '') {
        $d->where_like('first_name', "%$first_name%");
    }

    $last_name = _post('last_name');
    if ($last_name != '') {
        $d->where_like('last_name', "%$last_name%");
    }

    $middle_name = _post('middle_name');
    if ($middle_name != '') {
        $d->where_like('middle_name', "%$middle_name%");
    }

    $email = _post('email');
    if ($email != '') {
        $d->where_like('email', "%$email%");
    }

    $salutation = _post('salutation');
    if ($salutation != '') {
        $d->where_like('salutation', "%$salutation%");
    }

    $company = _post('company');
    if ($company != '') {
        $d->where_like('company', "%$company%");
    }

    $phone = _post('phone');
    if ($phone != '') {
        $d->where_like('phone', "%$phone%");
    }

    $status = _post('status');
    if ($status != '') {
        $d->where('status', "%$status%");
    }
    $d->where('status_customer', "1");

    $x = $d->find_array();
    $iTotalRecords = $d->count();
    $iDisplayLength = (int) $_REQUEST['length'];
    $iDisplayLength =
    $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
    $iDisplayStart = (int) $_REQUEST['start'];
    $sEcho = (int) $_REQUEST['draw'];
    $records = [];
    $records["data"] = [];
    $end = $iDisplayStart + $iDisplayLength;
    $end = $end > $iTotalRecords ? $iTotalRecords : $end;
    if ($o_type == 'desc') {
        $d->order_by_desc($a_order_by);
    } else {
        $d->order_by_asc($a_order_by);
    }

    if (!has_access($user->roleid, 'leads', 'all_data')) {
        $d->where('aid', $user->id);
    }

    $d->limit($end);
    $d->offset($iDisplayStart);
    $x = $d->find_array();
    $i = $iDisplayStart;
    foreach ($x as $xs) {

        $fechai=(is_null($xs['update_status'])) ? $xs['updated_at'] : $xs['update_status'];

        $fechai = date("Y-m-d", strtotime($fechai));
        $fechaf = date("Y-m-d");
        $date1=date_create($fechai);
        $date2 = date_create($fechaf);
        $diff = $date1->diff($date2);
        $diff= $diff->format('%a');

        $status = $xs['status'];
        
        /* switch ($diff) {
            case '0':
            $color="bg-success";
            break;
            case '1':
            $color="bg-success";
            break;
            case '2':
            $color="bg-warning";
            break;
            case '3':
            $color="bg-warning";
            break;
            default:
            $color="bg-danger";
            break;
        } */

        $color="bg-dark text-decoration-line-through";
 
        if($status == "Discarded Leads")
        {
            $color="bg-danger";
        }

        if($status == "Leads New")
        {
            $color="bg-info text-white";
        }

        if($status == "Leads in Process")
        {
            $color="bg-success";
        }

        if(in_array($status,["Discarded Leads","Leads New","Leads in Process"]) == true)
        {
            $status = '<span class="badge '.$color.'">'.$status.'</span>';
        }else{
            $status = '<span class="badge '.$color.'">'.$status.'</span>';
        }

         
        $service = $xs['services'];
        $items = Item::select(['name'])->where('id', $service)->get();
        $service=$items[0]->name;
        
        $service = $xs['services'];
        $fullname = $xs['id_admin'];

        $fullname_value = "Unassigned";
        if($fullname != 0)
        {
            $fullname_value = User::select(['fullname'])->where('id', $fullname)->first()->fullname ?? "";
        } 

        $created_at = $xs['created_at'];

        $created_at = date("d/m/Y", strtotime($created_at));

        $records["data"][] = [
            $xs['id'],
            $created_at,
            $service,
            $fullname_value,
            '<a href="#" class="cview" id="xid' .
            $xs['id'] .
            '">' .
            $xs['salutation'] .
            ' ' .
            $xs['first_name'] .
            ' ' .
            $xs['middle_name'] .
            ' ' .
            $xs['last_name'] .
            '</a>',
            $xs['title'],
            $xs['company'],
            $xs['phone'],
            $xs['email'],
            $status,
            $xs['o'],
            '
            <div class="btn-group">

            <a href="#" class="btn btn-dark btn-xs chistoryLead" id="' .
            $xs['id'] .
            '"><i class="fal fa-eye"></i> </a>

            <a href="#" class="btn btn-primary btn-xs cview" id="vid' .
            $xs['id'] .
            '"><i class="fal fa-search"></i> </a>
            <a href="#" class="btn btn-warning btn-xs cedit" id="eid' .
            $xs['id'] .
            '"><i class="fal fa-pencil"></i> </a>
            <a href="#" class="btn btn-danger btn-xs cdelete" id="did' .
            $xs['id'] .
            '"><i class="fal fa-trash-alt"></i> </a>
            </div>
            ',
        ];
    }


    $mimama = _post('mi_mama');

    $records["draw"] = $sEcho;
    $records["recordsTotal"] = $iTotalRecords;
    $records["recordsFiltered"] = $iTotalRecords;
    api_response($records);
    break;

    case 'convert_to_customer':
    $lid = _post('lid');
    echo Leads::convertToCustomer($lid);
    break;

    case 'update_memo':
    $data = request()->all();
    $lid = _post('lid');
    $memo = $data['memo'];
    echo Leads::updateMemo($lid, $memo);
    break;

    case 'web-to-lead':
    $lead_forms = LeadForm::select(['id', 'uuid', 'name', 'created_at'])
    ->orderBy('id', 'desc')
    ->get();

    $lead_form_ids = $lead_forms
    ->keyBy('id')
    ->keys()
    ->all();

    $leads = Lead::whereIn('form_id', $lead_form_ids)
    ->select(['id', 'form_id'])
    ->get();

    $leads_count = [];

    foreach ($leads as $lead) {
        if (isset($leads_count[$lead->form_id])) {
            ++$leads_count[$lead->form_id];
            continue;
        }
        $leads_count[$lead->form_id] = 1;
    }

    view('leads_web_to_lead', [
        'lead_forms' => $lead_forms,
        'leads_count' => $leads_count,
    ]);

    break;

    case 'form':
    $selected_form = false;

    $id = route(2);
    if ($id !== '' && $id !== '0') {
        $selected_form = LeadForm::find($id);
    }

    $lead_sources = LeadSource::get();

    view('lead_form', [
        'lead_sources' => $lead_sources,
        'selected_form' => $selected_form,
    ]);

    break;

    case 'form-embed':
    $id = route(2);
    if ($id !== '' && $id !== '0') {
        $lead_form = LeadForm::find($id);

        if ($lead_form) {
            $embed_code =
            '<iframe width="100%" height="800"
            src="' .
            U .
            'client/form/' .
            $lead_form->uuid .
            '/embed/" 
            frameborder="0" 
            allowfullscreen>

            </iframe>';
            $embed_code = htmlentities($embed_code);
            view('leads_form_embed', [
                'lead_form' => $lead_form,
                'embed_code' => $embed_code,
            ]);
        }
    }

    break;

    case 'save-form':
    $validator = new Validator();
    $data = $request->all();
    $validation = $validator->validate($data, [
        'name' => 'required',
        'submit_button_name' => 'required',
        'success_message' => 'required',
        'source_id' => 'required',
        'admin_id' => 'required',
    ]);

    $lead_form = false;

    if ($validation->fails()) {
        responseWithError($_L['All Fields are Required']);
    } else {
        if (isset($data['form_id'])) {
            $lead_form_id = (int) $data['form_id'];
            $lead_form = LeadForm::find($lead_form_id);
        }

        if (!$lead_form) {
            $lead_form = new LeadForm();
            $lead_form->uuid = (string) sp_uuid();
        }

        $lead_form->name = $data['name'];
        $lead_form->submit_button_name = $data['submit_button_name'];
        $lead_form->success_message = $data['success_message'];
        $lead_form->lead_source_id = $data['source_id'];
        $lead_form->admin_id = $data['admin_id'];
        $lead_form->save();

        jsonResponse([
            'url' => 'leads/form-builder/' . $lead_form->id,
        ]);
    }

    break;

    case 'form-builder':
    $id = route(2);

    if ($id !== '' && $id !== '0') {
        $lead_form = LeadForm::find($id);

        if ($lead_form) {
            \view('lead_form_data', [
                'lead_form' => $lead_form,
            ]);
        }
    }

    break;

    case 'save-form-data':
    $id = _post('id');

    if ($id !== '' && $id !== '0') {
        $lead_form = LeadForm::find($id);

        $data = request()->all();

        if ($lead_form && !empty($data['form_data'])) {
            $lead_form->form_data = $data['form_data'];
            $lead_form->save();
        }
    }

    break;

    case 'delete-web-to-lead-form':
    $id = route(2);
    $id = str_replace('delete_', '', $id);

    if ($id !== '' && $id !== '0') {
        $lead_form = LeadForm::find($id);
        $lead_form->delete();
    }

    r2(U . 'leads/web-to-lead/', 's', $_L['delete_successful']);

    break;

    case 's':
    is_dev();
    $t = new Schema('crm_leads');
    $t->drop();
    $t->add('secret', 'varchar', 100);
    $t->add('status', 'varchar', 200);
    $t->add('o', 'varchar', 200);
    $t->add('oid', 'int', 11, '0');
    $t->add('salutation', 'varchar', 200);
    $t->add('first_name', 'varchar', 200);
    $t->add('middle_name', 'varchar', 200);
    $t->add('last_name', 'varchar', 200);
    $t->add('suffix', 'varchar', 200);
    $t->add('title', 'varchar', 200);
    $t->add('company', 'varchar', 200);
    $t->add('company_id', 'int', 11, '0');
    $t->add('website', 'varchar', 200);
    $t->add('industry', 'varchar', 200);
    $t->add('employees', 'varchar', 200);
    $t->add('email', 'varchar', 200);
    $t->add('phone', 'varchar', 50);
    $t->add('color', 'varchar', 20);
    $t->add('source', 'varchar', 200);
    $t->add('added_from', 'varchar', 200);
    $t->add('mobile', 'varchar', 200);
    $t->add('address', 'varchar', 200);
    $t->add('street', 'varchar', 200);
    $t->add('city', 'varchar', 200);
    $t->add('state', 'varchar', 200);
    $t->add('zip', 'varchar', 50);
    $t->add('country', 'varchar', 50);
    $t->add('created_by', 'varchar', 200);
    $t->add('created_at', 'datetime');
    $t->add('updated_at', 'datetime');
    $t->add('updated_by', 'varchar', 200);
    $t->add('viewed_at', 'datetime');
    $t->add('cid', 'int', 11, '0');
    $t->add('aid', 'int', 11, '0');
    $t->add('iid', 'int', 11, '0');
    $t->add('rid', 'int', 11, '0');
    $t->add('sorder', 'int', 11, '0');
    $t->add('assigned', 'int', 11, '0');
    $t->add('last_contact', 'datetime');
    $t->add('last_contact_by', 'varchar', 200);
    $t->add('date_converted', 'datetime');
    $t->add('public', 'int', 1, '0');
    $t->add('ratings', 'varchar', '50');
    $t->add('flag', 'int', 1, '0');
    $t->add('lost', 'int', 1, '0');
    $t->add('junk', 'int', 1, '0');
    $t->add('trash', 'int', 1, '0');
    $t->add('archived', 'int', 1, '0');
    $t->add('memo');
    $t->save();
    $t = new Schema('crm_lead_sources');
    $t->drop();
    $t->add('sname', 'varchar', '200');
    $t->add('is_active', 'int', '1', '1');
    $t->add('is_default', 'int', '1', '1');
    $t->add('sorder', 'int', '11', '0');
    $t->add_primary_data('(`sname`) VALUES 
        (\'Advertisement\'),
        (\'Customer Event\'),
        (\'Employee Referral\'),
        (\'Google AdWords\'),
        (\'Other\'),
        (\'Partner\'),
        (\'Purchased List\'),
        (\'Trade Show\'),
        (\'Webinar\'),
        (\'Website\'),
        (\'Facebook\')
        ');
    $t->save();
    $t = new Schema('crm_industries');
    $t->drop();
    $t->add('industry', 'varchar', '200');
    $t->add('is_active', 'int', '1', '1');
    $t->add('is_default', 'int', '1', '0');
    $t->add('sorder', 'int', '11', '0');
    $t->add_primary_data('(`industry`) VALUES 
        (\'Agriculture\'),
        (\'Apparel\'),
        (\'Banking\'),
        (\'Biotechnology\'),
        (\'Chemicals\'),
        (\'Communications\'),
        (\'Construction\'),
        (\'Consulting\'),
        (\'Education\'),
        (\'Electronics\'),
        (\'Energy\'),
        (\'Engineering\'),
        (\'Entertainment\'),
        (\'Environmental\'),
        (\'Finance\'),
        (\'Food & Beverage\'),
        (\'Government\'),
        (\'Healthcare\'),
        (\'Hospitality\'),
        (\'Insurance\'),
        (\'Machinery\'),
        (\'Manufacturing\'),
        (\'Media\'),
        (\'Not For Profit\'),
        (\'Other\'),
        (\'Recreation\'),
        (\'Retail\'),
        (\'Shipping\'),
        (\'Technology\'),
        (\'Telecommunications\'),
        (\'Transportation\'),
        (\'Utilities\')
        ');
    $t->save();
    $t = new Schema('crm_lead_status');
    $t->drop();
    $t->add('sname', 'varchar', '200');
    $t->add('is_active', 'int', '1', '1');
    $t->add('is_default', 'int', '1', '0');
    $t->add('is_converted', 'int', '1', '0');
    $t->add('sorder', 'int', '11', '0');
    $t->add_primary_data('(`sname`,`is_default`) VALUES 
        (\'Leads New\',\'1\'),
        (\'Discarded Leads\',\'0\'),
        (\'Leads in Process\',\'0\')
        ');
    $t->save();
    $t = new Schema('crm_salutations');
    $t->drop();
    $t->add('sname', 'varchar', '200');
    $t->add('is_active', 'int', '1', '1');
    $t->add('is_default', 'int', '1', '0');
    $t->add('sorder', 'int', '11', '0');
    $t->add_primary_data('(`sname`) VALUES 
        (\'Mr.\'),
        (\'Ms.\'),
        (\'Mrs.\'),
        (\'Dr.\'),
        (\'Prof.\')
        ');
    $t->save();
    break;

    default:
    echo 'action not defined';
}
