{extends file="$layouts_admin"}
{block name="head"}

 

<link
  href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
  rel="stylesheet"
/>

 

{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    .swal2-container {
         z-index: 9999;
      }

.wrapper {
  overflow: hidden;  
}

ul.breadcrumbs {
  margin: 0;
  padding: 0;
  display: flex; /* Cambiar a flex para un mejor ajuste en pantallas pequeñas */
  flex-wrap: wrap; /* Permitir que los elementos se ajusten en múltiples líneas si es necesario */
  justify-content:center;
}

ul.breadcrumbs li {
  position: relative;
  margin: 0;
  padding: 0;
  list-style: none;
  display: inline-block;
  border-left: 1px solid #ccc;
  transition: 0.3s ease;
}

ul.breadcrumbs li:hover:before {
  /* border-left: 10px solid #5e6e82; */
}

ul.breadcrumbs li:hover a {
  /* color: white;
  background: #5e6e82; */
 
}

ul.breadcrumbs li:before {
  content: "";
  position: absolute;
  right: -9px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 20;
  border-left: 10px solid #fff;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
  transition: 0.3s ease;
}

ul.breadcrumbs li:after {
  content: "";
  position: absolute;
  right: -10px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 10;
  border-left: 10px solid #ccc;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
}

ul.breadcrumbs li.active {
  background: #5e6e82; /* Fondo para el activo */
}

ul.breadcrumbs li.active a {
  color: white !important; /* Color del texto activo */
  padding: 0 15px 0 25px; /* Ajustar el padding */
  background: #5e6e82;
}

ul.breadcrumbs li.first {
  border-left: none;
}

ul.breadcrumbs li.first a {
  font-size: 18px;
  padding-left: 20px;
  border-radius: 5px 0px 0px 5px;
}

ul.breadcrumbs li.last:before {
  display: none;
}

ul.breadcrumbs li.last:after {
  display: none;
}

ul.breadcrumbs li.last a {
  padding-right: 20px;
  border-radius: 0px 40px 40px 0px;
}

ul.breadcrumbs li a {
  display: block;
  font-size: 12px;
  line-height: 40px;
  color: #757575;
  padding: 0px 15px 0px 25px;
  text-decoration: none;
  background: #fff;
  border: 1px solid #ddd;
  white-space: nowrap; /* Evitar que el texto se envuelva */
  overflow: hidden;
  transition: 0.3s ease;
}

ul.breadcrumbs li.active:before {
  display: block; /* Mostrar el triángulo en el activo */
}

ul.breadcrumbs li.active:after {
  display: block; /* Mostrar el triángulo secundario en el activo */
}

@media (max-width: 768px) {
  ul.breadcrumbs {
    flex-direction: column; /* Cambiar a una columna en pantallas más pequeñas */
  }

  ul.breadcrumbs li {
    border-left: none; /* Eliminar el borde izquierdo en pantallas pequeñas */
    margin-bottom: 5px; /* Espaciado entre elementos */
    margin-right: 10px;
  }
}
ul.breadcrumbs li.active:before {
  border-left: 10px solid #5e6e82; /* Cambia el color del triángulo al hacer hover sobre el activo */
}

.cursor_manito {
  cursor: pointer;
}

table.estilosTabla > :not(caption) > * > * {
        /*
        padding-top: 5px !important;
        padding-bottom: 5px !important;
        */
    }

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
   }

   .btn-edit-referencia-personal {
         margin-bottom: 4px; 
         background-color: #001b3b; 
         color: white; 
         border: 1px solid rgb(211, 202, 192) !important; 
         box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
         float: inline-end;
    }

   .btn-eliminar-referencia-personal {
      margin-bottom: 4px;
      background-color: red;
      color: white;
      border: 1px solid rgb(211, 202, 192) !important;
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
      float: inline-end;
    }

   .btn-edit-referencia-personal:hover i,
   .btn-eliminar-referencia-personal:hover i {
      color: white; /* Mantén el color blanco del icono en hover */
   }

   .tamano-icono{
      font-size:small;
   }
    
   .centrar-botones{
      text-align: center;
      justify-content: center;
      display: flex;
      padding: 0px;
   }

   .btn-descargar {
         margin-bottom: 4px; 
         background-color: #001b3b; 
         color: white; 
         border: 1px solid rgb(211, 202, 192) !important; 
         box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
         float: inline-end;
    }

   .btn-eliminar {
      margin-bottom: 4px;
      background-color: red;
      color: white;
      border: 1px solid rgb(211, 202, 192) !important;
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
      float: inline-end;
    }

   .btn-descargar:hover i,
   .btn-eliminar:hover i {
      color: white; /* Mantén el color blanco del icono en hover */
   }

   @media (max-width: 576px)
   {
      .btn_general_plan{
         margin-top: 10px;
      }
   }

   .texto-p {
      color: #32325d;
      font-weight: 600;
   }

   .descargas {
      font-size: 14px;
      cursor: pointer;
      font-weight: 600;
      color: white;
     
   }
  
</style>

    <input
         type="text"
         value="{$url_base}"
         disabled
         hidden
         id="URL_BASE"
    />

     <input
         type="text"
         value="{$UUID_ENC}"
         disabled
         hidden
         id="UUID_ENC"
    />

    <input
         type="text"
         value="{$UUID}"
         disabled
         hidden
         id="UUID"
    />

    <input
         type="text"
         value="{$id_ifp}"
         disabled
         hidden
         id="id_ifp"
    />

    <input
         type="text"
         value="{$id_user}"
         disabled
         hidden
         id="ID_USER"
    />

 
<div class="row pantalla_cargada"  style="display: none;">
   <div class="col-12 col-lg-12 col-sm-12 col-md-12">
      <div class="panel">
         <div class="panel-hdr">
            <h2><span></span>Print contract  <span class="ms-2 titulo_cabecera_credito"></span> </h2>
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="wrapper">
                  <ul class="breadcrumbs">

                     <li class="cursor_manito enableMenu" data-id="datos_prestamos" style="display: none;">
                        <a>Loan details</a>
                     </li>

                     <li class="cursor_manito enableMenu" data-id="historial_crediticio" style="display: none;">
                        <a>Credit history</a>
                     </li>

                     <li class="cursor_manito" data-id="general_information">
                        <a>General information</a>
                     </li>

                     <li class="cursor_manito" data-id="referencia">
                        <a>References</a>
                     </li>

                     <li class="cursor_manito" data-id="documento_respaldo">
                        <a>Supporting documents</a>
                     </li>

                     <li class="cursor_manito" data-id="preaprobacion">
                        <a>Pre-approval</a>
                     </li>

                     <li class="cursor_manito" data-id="plan_pago">
                        <a>Payment plan</a>
                     </li>

                     <li class="cursor_manito active" data-id="desembolzo">
                        <a>Disbursement</a>
                     </li>

                     <!--  -->
                  </ul>
               </div>
            </div>
         </div>
      </div>
   </div>

   {**}
   <div class="col-md-12">
      <div class="panel">
         <div class="panel-hdr">
            <h2>Loan information</h2>
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  <div>
                     <div class="row">
                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="valor_monto_solicitado_li"
                                 class="col-sm-3"
                                 ><span class="h6"
                                    >Value of the requested amount</span
                                 ><span class="text-danger"></span
                              ></label>
                              <div class="col-sm-9">
                                 <input
                                    type="text"
                                    id="valor_monto_solicitado_li"
                                    name="valor_monto_solicitado_li"
                                    class="form-control valor_monto_solicitado_li"
                                    disabled
                                 />
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="motivo_prestamo_li"
                                 class="col-sm-3"
                                 ><span class="h6">Reason for the loan</span
                                 ><span class="text-danger"></span
                              ></label>
                              <div class="col-sm-9">
                                 <textarea
                                    rows="3"
                                    id="motivo_prestamo_li"
                                    name="motivo_prestamo_li"
                                    class="form-control motivo_prestamo_li"
                                    disabled
                                 ></textarea>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>

   {**}
   <div class="col-md-12">
      <div class="panel">
         <div class="panel-hdr">
            <h2>Plan information</h2>
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  <div>
                     <div class="row">
                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="nombre_plan"
                                 class="col-sm-3"
                                 ><span class="h6"
                                    >Plan name</span
                                 ><span class="text-danger"></span
                              ></label>
                              <div class="col-sm-9">
                                 <input
                                    type="text"
                                    id="nombre_plan"
                                    name="nombre_plan"
                                    class="form-control nombre_plan"
                                    disabled
                                 />
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="nombre_plan"
                                 class="col-sm-3"
                                 ><span class="h6"
                                    >Plan interest rate</span
                                 ><span class="text-danger"></span
                              ></label>
                              <div class="col-sm-9">
                                 <div class="input-group mb-3">
                                    <input
                                       class="form-control tasa_plan"
                                       type="number"
                                       id="tasa_plan"
                                       name="tasa_plan"
                                    /><span class="input-group-text" >%</span>
                                 </div>
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="relacion_cuota_ingreso"
                                 class="col-sm-3"
                                 ><span class="h6"
                                    >Income quota ratio</span
                                 ><span class="text-danger"></span
                              ></label>
                              <div class="col-sm-9">
                              
                                 <div class="input-group mb-3">
                                    <input
                                       class="form-control relacion_cuota_ingreso"
                                       type="number"
                                       id="relacion_cuota_ingreso"
                                       name="relacion_cuota_ingreso"
                                    /><span class="input-group-text" >%</span>
                                 </div>

                              </div>
                           </div>
                        </div>
 
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>

   {*metodo de pagos acreditar*}
      <div class="col-md-12">
         <div class="panel">
            <div class="panel-hdr">
               <h2>Payment method to credit</h2>
            </div>

            <div class="panel-container show" id="ibox_form">
               <div class="panel-content">
                  <div class="px-2">
                     <form id="rform">
                        <div class="row">

                           <div class="col-md-12 col-sm-12">
                              <div class="mb-3 row">
                                 <label for="tipo_cuenta_acreditar" class="col-sm-3"
                                    ><span class="h6">Account type</span
                                    ><span class="text-danger">*</span></label
                                 >
                                 <div class="col-sm-9">
                                     

                                    <input
                                       type="text"
                                       id="tipo_cuenta_acreditar"
                                       name="tipo_cuenta_acreditar"
                                       class="form-control tipo_cuenta_acreditar"
                                    />

                                 </div>
                              </div>
                           </div>


                           <div class="col-md-12 col-sm-12 mostrar_no_cash_acreditar" style="display:none"> 
                              <div class="mb-3 row">
                                 <label for="banco_acreditar" class="col-sm-3"
                                    ><span class="h6">Bank</span
                                    ><span class="text-danger">*</span></label
                                 >
                                 <div class="col-sm-9">
                                    <input
                                       type="text"
                                       id="banco_acreditar"
                                       name="banco_acreditar"
                                       class="form-control banco_acreditar"
                                    />
                                 </div>
                              </div>
                           </div>

                           <div class="col-md-12 col-sm-12 mostrar_no_cash_acreditar" style="display:none">
                              <div class="mb-3 row">
                                 <label for="numero_cuenta_acreditar" class="col-sm-3"
                                    ><span class="h6">Account number</span
                                    ><span class="text-danger">*</span></label
                                 >
                                 <div class="col-sm-9">
                                    <input
                                       type="text"
                                       id="numero_cuenta_acreditar"
                                       name="numero_cuenta_acreditar"
                                       class="form-control numero_cuenta_acreditar"
                                    />
                                 </div>
                              </div>
                           </div>

                           <div class="col-md-12 col-sm-12 mostrar_no_cash_acreditar" style="display:none">
                              <div class="mb-3 row">
                                 <label for="numero_ruta_acreditar" class="col-sm-3"
                                    ><span class="h6">Route number</span
                                    ><span class="text-danger">*</span></label
                                 >
                                 <div class="col-sm-9">
                                    <input
                                       type="text"
                                       id="numero_ruta_acreditar"
                                       name="numero_ruta_acreditar"
                                       class="form-control numero_ruta_acreditar"
                                    />
                                 </div>
                              </div>
                           </div>

                            <div class="col-md-12 col-sm-12 mostrar_no_cash_acreditar" style="display:none">
                              <div class="mb-3 row">
                                 <label for="email_acreditar" class="col-sm-3"
                                    ><span class="h6">Email</span
                                    ><span class="text-danger">*</span></label
                                 >
                                 <div class="col-sm-9">
                                    <input
                                       type="text"
                                       id="email_acreditar"
                                       name="email_acreditar"
                                       class="form-control email_acreditar"
                                    />
                                 </div>
                              </div>
                           </div>


                           <div class="col-md-12 col-sm-12 mostrar_no_cash_acreditar" style="display:none">
                              <div class="mb-3 row">
                                 <label for="nombre_beneficiario_acreditar" class="col-sm-3"
                                    ><span class="h6">Beneficiary name</span
                                    ><span class="text-danger">*</span></label
                                 >
                                 <div class="col-sm-9">
                                    <input
                                       type="text"
                                       id="nombre_beneficiario_acreditar"
                                       name="nombre_beneficiario_acreditar"
                                       class="form-control nombre_beneficiario_acreditar"
                                    />
                                 </div>
                              </div>
                           </div>

                        </div>
                     </form>
                  </div>
               </div>
            </div>
         </div>
      </div>

   {**}
   <div class="col-md-12 show-presentation" >
      <div class="panel">
         <div class="panel-hdr">
            <h2>Loan Approved</h2>
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  <div class="row">
                     <div class="col-md-12 col-sm-12 show-presentation">
                        <p class="texto-p">
                           Your loan request has been approved. Please download the contract, print it, and obtain the client’s signature.
                        </p>

                        <p class="texto-p">
                          Once signed, upload the digital version of the contract to the system for record-keeping.
                        </p>
                     </div>

                     <div class="col-12 col-sm-12 col-md-6 show-presentation">
                        <p class="texto-p">
                         Required Action: Upload the signed contract in digital format.
                        </p>
                     </div>

                     <div class="col-12 col-sm-12 col-md-6 show-presentation">
                        <div style="text-decoration: underline;text-align: end;">
 

                           <button class="link_descargar btn btn-success btn-sm  " type="button" >
                              <i class="fa-solid fa-download descargas"></i>
                              <span class="descargas">Download contract here</span>
                           </button>
                            
                        </div>
                     </div>

                   

                     {*
                     
                     <div class="row card_container"></div>
                     *}
 

                  </div>

               
               </div>
            </div>
         </div>
      </div>
   </div>

   <div class="col-md-12">
      <div class="panel">
         <div class="panel-hdr">
            <h2>Contract Upload</h2>
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  <div class="row">
                      
                   

                     <div class="col-md-12 col-sm-12 show-presentation mt-2">
                        <div class="mb-3 row">
                           <label for="file" class="col-sm-3"
                              ><span class="h6"
                                 >Please upload to the system the digital file of the contract previously signed by the client.</span
                              ><span class="text-danger">*</span></label
                           >
                           <div class="col-sm-9">
                              <input
                                 type="file"
                                 id="file"
                                 name="file"
                                 class="form-control file"
                              />
                           </div>
                        </div>
                     </div>

                     {**}
                     <div class="row card_container"></div>
 

                  </div>

                  <div class="row">
                     <div class="col-md-12">
                        <div
                           class="mb-3"
                           style="display: flex; justify-content: space-between"
                        >
                           <button
                              class="btn btn-default mt-2 waves-effect waves-themed back"
                              type="button"
                              id="submit"
                           >
                              Back
                           </button>

                           {*---*}
                           <button
                              class="btn btn-primary mt-2 waves-effect waves-themed guardar_siguiente"
                              type="button"
                              id="submit"
                           >
                              Confirm & Finish
                           </button>

                           <button
                              class="btn btn-primary mt-2 waves-effect waves-themed loading_guardar_siguiente"
                              style="display: none"
                              disabled
                           >
                              <div style="display: flex; align-items: center">
                                 <span
                                    class="spinner-border spinner-border-sm"
                                    style="
                                       height: 20px;
                                       width: 20px;
                                       margin-right: 5px;
                                    "
                                    role="status"
                                    aria-hidden="true"
                                 ></span>
                                 Confirm & Finish
                              </div>
                           </button>
                           {*---*}
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>

   {**}
   <div
      class="modal fade"
      id="modalMensaje"
      data-bs-backdrop="static"
      data-bs-keyboard="false"
      tabindex="-1"
      aria-labelledby="staticBackdropLabel"
      aria-hidden="true"
   >
      <div class="modal-dialog modal-dialog-centered">
         <div class="modal-content">
            <div class="modal-header">
               <h5
                  class="modal-title modal_titulo_mensaje"
                  id="staticBackdropLabel"
               >
                  Group Message
               </h5>
               <button
                  type="button"
                  class="btn-close btn_cerrar_confirmacion_modal"
               ></button>
            </div>
            <div class="modal-body text-center">
               <p class="modal_contenido_mensaje">
                  The group advertising campaign has been sent. For more
               </p>
            </div>
         </div>
      </div>
   </div>


   {**}
   <div
      class="modal fade"
      id="ventana_confirmacion"
      tabindex="-1"
      aria-labelledby="exampleModalLabel__ventanaconfirmacion"
      aria-hidden="true"
      data-bs-backdrop="static"
      data-bs-keyboard="false"
   >
      <div class="modal-dialog modal-dialog-centered">
         <div class="modal-content" style="background-color: white">
            <div class="modal-header">
               <h3 class="titulo_modal_confirmar">Estas seguro de eliminar</h3>
               <button
                  type="button"
                  class="btn-close"
                  id="btn_close_ventana_confirmacion"
               ></button>
            </div>
            <div
               class="modal-body"
               style="background-color: white; border-radius: 10px"
            >
               <div class="row">
                  <div class="col-md-12">
                     <div class="panel-container show" id="ibox_form">
                        <div class="panel-content">
                           <div class="px-2">
                              <div
                                 class="alert alert-danger"
                                 id="emsg"
                                 style="display: none"
                              >
                                 <span id="emsgbody"></span>
                              </div>
                              <input
                                 class="tipo_modal_confirmar"
                                 hidden
                                 disabled
                              />
                              <input class="data_id" hidden disabled />
                              <div class="row">
                                 <div class="col-md-12 col-sm-12">
                                    <h4
                                       class="mensaje_modal_confirmar"
                                       style="text-align: center; color: black"
                                    >
                                       Estas seguro de eliminar
                                    </h4>

                                    <p
                                       class="mensaje_espera_moda_confirmacion mt-3"
                                       style="
                                          text-align: center;
                                          color: red;
                                          font-weight: 600;
                                       "
                                    >
                                       Espere mientras termina el proceso
                                    </p>
                                 </div>
                              </div>

                              <div class="row mt-2">
                                 <div class="col-md-12">
                                    <div style="float: inline-end">
                                       <button
                                          class="btn me-2"
                                          type="button"
                                          id="btn_cerrar_ventana_confirmacion"
                                          style="background: #001b3b"
                                       >
                                          close
                                       </button>
                                       <button
                                          class="btn"
                                          type="button"
                                          id="btn_aplicar_ventana_confirmacion"
                                          style="background: red"
                                       >
                                          Remove
                                       </button>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>

   {*tabla tarifario*}
   <div class="col-md-12">
         <div class="panel">
            <div class="panel-container show" id="ibox_form">
               <div class="panel-content" style="padding: 0px">
                  <div>
                     <div>
                        <div>
                           <div class="table-responsive">
                              <table
                                 class="table table-striped table-hover estilosTabla"
                                 id="my-table"
                                 style="margin: 0px"
                              >
                                 <thead>
                                    <tr>
                                       <th class="centrar">No. fee</th>
                                       <th class="centrar">Payment date</th>
                                       <th class="centrar">Interest value</th>
                                       <th class="centrar">Capital value</th>
                                       <th class="centrar">Total quota</th>
                                       <th class="centrar">Capital balance</th>
                                    </tr>
                                 </thead> 
                                 <tbody class="tbody_envios">  
                                    <tr><th colspan="6" class="centrar " style=" text-align: center; "> No information</th></tr> 
                                    {*

                                       <tr>
                                       <td class="centrar">1</td>
                                       <td class="centrar">28/abril/2025</td>
                                       <td class="centrar">600.00</td>
                                       <td class="centrar">413.38</td>
                                       <td class="centrar">70.20</td>
                                       <td class="centrar">5,656.82</td>
                                    </tr>
                                    *} 


                                 </tbody>
                              </table>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
   </div>


</div>

<div class="row cargando_pantalla " style=" margin: 0px; ">

   <div
      class="container"
      style="
         display: flex;
         justify-content: center;
         align-items: center;
         height: 45vh;
         box-shadow: 0 0 13px 0 rgba(31,17,173,.08);
         border-radius: 11px;
         background-color: white;
      "
   >
      <div style="text-align: center">
         <span
         class="spinner-border spinner-border-sm"
         style="height: 45px; width: 45px; margin-bottom: 10px"
         role="status"
         aria-hidden="true"
         ></span>
         <br />
         <strong>Please wait while the <span style=" font-weight: 600; ">"Disbursed"</span> screen loads...</strong>
         <br />
      </div>
   </div>

</div>

 


{/block}

{block name="script"}

{literal}
<script>

   var URL_BASE = $("#URL_BASE").val();
   var ID_USER = $("#ID_USER").val();
   var url_dashboard = $("#url_dashboard").val();
   var roll_id = $("#roll_id").val();

   var UUID_ENC = $("#UUID_ENC").val();
   var UUID     = $("#UUID").val();
   var id_ifp   = $("#id_ifp").val();

   var COLOR_FONDO_VENTANA_CERRAR = "#001b3b";
   var COLOR_TEXT_VENTANA_CERRAR = "white";

   var COLOR_FONDO_VENTANA_CONFIRMACION = "red";
   var COLOR_TEXT_VENTANA_CONFIRMACION = "white";

   var COLOR_FONDO_VENTANA_IR = "#001b3b";
   var COLOR_TEXT_VENTANA_IR = "white";

   var menus_disponibles = {};

   var base64 = "";
   var base64_original = "";
   var extension = "";
   var nombre_original = "";

   var imagen_sistema = "";

   var data_gip = {};
 
   $(document).ready(function () {

      cargarPrincipal();
  
      $(".progress").hide();
      $("#emsg").hide();
      $("#emsgSuccess").hide();

      var _url = '{$_url}';

      $('.cursor_manito').click(function() {

         const atributo_data =  $(this).attr('data-id');

         if(atributo_data == "datos_prestamos")
         {
            window.location = URL_BASE + "credit/data-loans/" + UUID_ENC;
         }

         if(atributo_data == "historial_crediticio")
         {
            window.location = URL_BASE + "credit/credit-history/" + UUID_ENC;
         }
 
         if(atributo_data == "general_information")
         {
            if(menus_disponibles.general_information == 1)
            {
               window.location = URL_BASE + "credit/new-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
            
         }

         if(atributo_data == "referencia")
         {
            if(menus_disponibles.referencia == 1)
            {
               window.location = URL_BASE + "credit/reference-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "documento_respaldo")
         {
            if(menus_disponibles.documento_respaldo == 1)
            {
               window.location = URL_BASE + "credit/supporting-document-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "preaprobacion")
         {
            if(menus_disponibles.preaprobacion == 1)
            {
               window.location = URL_BASE + "credit/pre-approval-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "plan_pago")
         {
            if(menus_disponibles.plan_pago == 1)
            {
               window.location = URL_BASE + "credit/payment-plan-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "desembolzo")
         {
            return;

            if(menus_disponibles.desembolzo == 1)
            {
               window.location = URL_BASE + "credit/disbursement-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

 
      });
 
      $('#submit_modal_confirmacion_correo').on('click', function() {
         window.location = url_dashboard;    
      });
 
      $("#btn_aplicar_ventana_confirmacion").off("click")
      .on("click", function () {

            $('#btn_aplicar_ventana_confirmacion').prop('disabled', true);
            $('#btn_close_ventana_confirmacion').prop('disabled', true);
            $('#btn_cerrar_ventana_confirmacion').prop('disabled', true);
             
            let opcion_predefinida = $(".tipo_modal_confirmar").val();
            let data_id = $(".data_id").val();

            if(opcion_predefinida == "eliminar_card_documento")
            {
               $(".mensaje_espera_moda_confirmacion").text("Please wait while the process finishes...");

               $(".card_eliminar_" + data_id).remove();

               $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
               $('#btn_close_ventana_confirmacion').prop('disabled', false);
               $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
               
               //$("#ventana_confirmacion").modal("hide");

               ventanaRegistroExito("Record deleted", "¡The record has been successfully deleted!");

               $(".file").val("");

            }

            if(opcion_predefinida == "navegar_pantalla_siguiente")
            {
               window.location = URL_BASE + "credit/search-loans";
            }

            if(opcion_predefinida == "navegar_otras_pantallas")
            {
               window.location = URL_BASE + data_id;
            }
 
      });

      $("#btn_cerrar_ventana_confirmacion").off("click")
      .on("click", function () {
         
         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         $("#ventana_confirmacion").modal("hide");
       
      });

      $("#btn_close_ventana_confirmacion").off("click")
      .on("click", function () {

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         
         $("#ventana_confirmacion").modal("hide");
       
      });

      $('.btn_cerrar_confirmacion_modal').click(function() {
         $("#modalMensaje").modal("hide");
      });

      $('.abrir_modal_contacto').click(function() {
         $("#modal_asignar_clientes_contactos").modal("show");
      });

      $('.back').click(function() {
          
         window.location = URL_BASE + "credit/payment-plan-prospecting/" + UUID_ENC;

      });

      $('.guardar_siguiente').click(function() {

         //window.location = URL_BASE + "credit/disbursement-prospecting/UUID_ENCRIPTION";
         //return;

         //cuando se le de click a guardar y siguiente, se cambira el estado
         guardarInformacion(1);
          
      });
 
      function guardarInformacion(esBorrador = 2)
      {
         
         if(isEmpty(base64))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.plan_crediticio');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Disbursement" the field "Upload digital file of contract signed by client" is required.');
            return;
         }
 
         let informacionFront = {
            id_ifp: id_ifp,
            base64: base64,
            base64_original: base64_original,
            nombre_original: nombre_original,
            extension: extension
         };

         $('input, select, button, textarea').prop('disabled', true);
         if(esBorrador == 2)
         {
            $('.loading_guardar_borrador').css('display', '');
            $('.guardar_borrador').css('display', 'none');
         }

         if(esBorrador == 1)
         {
            $('.loading_guardar_siguiente').css('display', '');
            $('.guardar_siguiente').css('display', 'none');
         }

         console.log(JSON.stringify(informacionFront));
         //console.log("return aqui abajo")
         //alert("return aqui abajo");
         //return;

         $.ajax({
            type: "POST",
            url: URL_BASE + "credit/post-save-disbursed",
            data: JSON.stringify(informacionFront), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               $('input, select, button, textarea').prop('disabled', false);
               $('.valor_monto_solicitado_li, .motivo_prestamo_li').prop('disabled', true);

               if(esBorrador == 2)
               {
                  $('.loading_guardar_borrador').css('display', 'none');
                  $('.guardar_borrador').css('display', '');
               }

               if(esBorrador == 1)
               {
                  $('.loading_guardar_siguiente').css('display', 'none');
                  $('.guardar_siguiente').css('display', '');
               }
 
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {

                     if(esBorrador == 1)
                     {

                        toastr.success(
                            "Record added",
                            "¡Record added successfully!",
                        );

                        window.location = URL_BASE + "credit/search-loans";

                        //navegarPantallaSiguiente(UUID_ENC); 
                     }

                     if(esBorrador == 2)
                     {
                        toastr.success(
                            "Draft saved successfully",
                            "¡Draft saved successfully, you can edit again!",
                        );

                        //ventanaRegistroExito("Draft saved successfully", "¡Draft saved successfully, you can edit again!")
                     }
 
                  } else if (info.type == "error") {

                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {

                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
            
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

               $('input, select, button, textarea').prop('disabled', false);
               $('.valor_monto_solicitado_li, .motivo_prestamo_li').prop('disabled', true);

               if(esBorrador == 2)
               {
                  $('.loading_guardar_borrador').css('display', 'none');
                  $('.guardar_borrador').css('display', '');
               }

               if(esBorrador == 1)
               {
                  $('.loading_guardar_siguiente').css('display', 'none');
                  $('.guardar_siguiente').css('display', '');
               }
            },
         });
 

      }

      function getFileBase64AndExtension(inputSelector, callback) {
         const fileInput = $(inputSelector)[0];
         if (!fileInput || !fileInput.files || fileInput.files.length === 0) {
            callback({ error: "No file selected" });
            return;
         }

         const file = fileInput.files[0];
         const reader = new FileReader();
         
         // Get file extension
         const fileName = file.name;
         const extension = fileName.split('.').pop().toLowerCase();

         reader.onload = function(e) {
            const base64String = e.target.result; // Full data URL (e.g., "data:image/png;base64,...")
            callback({
                  base64: base64String,
                  extension: extension,
                  name: file.name
            });
         };
 
         reader.onerror = function() {
            callback({ error: "Error reading file" });
         };

         reader.readAsDataURL(file);
      }

      // Example usage:
      $('.file').on('change', function() {
         getFileBase64AndExtension('#file', function(result) {
            if (result.error) {
                  toastr.error(result.error);
                  return;
            }

            base64_original  = result.base64;
            const base64Data = result.base64.split(',')[1]; // Extract only the Base64 part
            
            //console.log('Base64:', base64Data);
            //console.log('Extension:', );

            base64          = base64Data;
            extension       = result.extension;
            nombre_original = result.name;

            $(".card_container").html(generateCardHtml("id", extension, base64_original, nombre_original));

            eliminarDocumento();
             
            // Optional: Show success message
            //toastr.success(`File processed: ${result.extension} format`);
         });
      });

      $('.link_descargar').click(async function() {

         const resizedBase64 = await resizeImageBase64(imagen_sistema, 400, 400);

         if(isEmpty(imagen_sistema) == true)
         {
            toastr.error('!Sorry, you cannot download the PDF because the CRM logo was not found');
            return;
         }

         if(Object.keys(data_gip).length === 0)
         {
            toastr.error('!Sorry, you cannot download the PDF because the menus are not loaded');
            return;
         }
          
         // Acceder a jsPDF desde el módulo UMD
         const { jsPDF } = window.jspdf;

         // Crear nuevo documento PDF
         const doc = new jsPDF({
             orientation: "portrait",
             unit: "px",
             format: "letter"
         });

         // Dimensiones de la imagen
         const imgWidth = 100; // Ancho de la imagen en px
         const imgHeight = 100; // Alto de la imagen en px
         const pageWidth = doc.internal.pageSize.getWidth(); // Ancho de la página
         const x = (pageWidth - imgWidth) / 2; // Centrar horizontalmente
         const y = -10; // 20 px desde la parte superior

         // Agregar imagen centrada
         doc.addImage( resizedBase64, 'PNG', x, y, imgWidth, imgHeight);

         // Generar segunda tabla con alto de filas ajustado
         doc.autoTable({
             startY: 60,
             body: [
                 [
                     {
                         content: 'DISBURSEMENT RECEIPT CREDIT NO.' + data_gip.numero_credito,
                         styles: { fontStyle: 'bold', halign: 'center', fontSize: 8 },
                         colSpan: 4
                     }
                 ],
                 [
                     {
                         content: 'NAME PRODUCT:' + data_gip.plan_crediticio,
                         styles: { fontStyle: 'bold', halign: 'center', fontSize: 8 },
                         colSpan: 4
                     }
                 ],
                 [
                     {
                         content: data_gip.telefono_empresa,
                         styles: { fontStyle: 'bold', halign: 'center', fontSize: 8 },
                         colSpan: 4
                     }
                 ]
             ],
              
             rowStyles: {
                 0: { minCellHeight: 20 }, // Alto mínimo para la primera fila
                 1: { minCellHeight: 20 }, // Alto mínimo para la segunda fila
                 2: { minCellHeight: 20 }  // Alto mínimo para la tercera fila
             },
             styles: {
                 fontSize: 8,
                 textColor: [0, 0, 0],
                 cellPadding: 2 // Ajusta el relleno interno para controlar el espacio vertical
             },

             theme: 'plain'
         });

 
         // Calcular la posición Y para la cuarta tabla
         const nextTableStartY2 = doc.lastAutoTable.finalY + 10;

         // Generar cuarta tabla combinada
         doc.autoTable({
             startY: nextTableStartY2,
             body: [

                 [
                     {
                         content: "DATE: ",
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         },
                         colSpan: 1
                     },
                     {
                         content:  data_gip.fecha_desembolso,
                         colSpan: 1,
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         }
                     },
                     {
                         content: "AMOUNT TO BE DISBURSEMENT:",
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         },
                         colSpan: 1
                     },
                     {
                         content: data_gip.monto_desembolsar,
                         colSpan: 1,
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         }
                     }
                 ],


                 [
                     {
                         content: "CUSTOMER NAME: ",
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         },
                         colSpan: 1
                     },
                     {
                         content: data_gip.account,
                         colSpan: 1,
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         }
                     },
                     {
                         content: "QUOTA VALUE:",
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         },
                         colSpan: 1
                     },
                     {
                         content: data_gip.valor_cuota,
                         colSpan: 1,
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         }
                     }
                 ],

                 [
                     {
                         content: "CUSTOMER ID: ",
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         },
                         colSpan: 1
                     },
                     {
                         content: data_gip.numero_identificacion_ig,
                         colSpan: 1,
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         }
                     },
                     {
                         content: "ANNUAL RATE:",
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         },
                         colSpan: 1
                     },
                     {
                         content: data_gip.tasa_anual,
                         colSpan: 1,
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         }
                     }
                 ],

                 [
                     {
                         content: "PHONE: ",
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         },
                         colSpan: 1
                     },
                     {
                         content: data_gip.tasa_anual,
                         colSpan: 1,
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         }
                     },
                     {
                         content: "",
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         },
                         colSpan: 1
                     },
                     {
                         content: "",
                         colSpan: 1,
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         }
                     }
                 ],

                 // 
                 [
                     {
                         content: "ADDRESS: ",
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         },
                         colSpan: 1
                     },
                     {
                         content: data_gip.address,
                         colSpan: 1,
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         }
                     },
                     {
                         content: "",
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         },
                         colSpan: 1
                     },
                     {
                         content: "",
                         colSpan: 1,
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "left"
                         }
                     }
                 ],
                  
             ],
             columnStyles: {
                 //0: { cellWidth: 80 }, // Columna izquierda 1 (etiquetas)
                 //1: { cellWidth: 100 }, // Columna izquierda 2 (valores)
                 //2: { cellWidth: 100 }, // Columna derecha 1 (etiquetas)
                 //3: { cellWidth: 80 }  // Columna derecha 2 (valores)
             },
             styles: {
                 fontSize: 8,
                 textColor: [0, 0, 0],
                 cellPadding: 2
             },
             margin: { left: 20, right: 20 },
             theme: 'plain'
         });

         const nextTableStartY__ = doc.lastAutoTable.finalY + 15; 
         // Generar tabla final con firmas
         // Generar tabla final con firmas centrada con línea corregida
          
         // Generar tabla final con firmas centrada
         doc.autoTable({
             startY: nextTableStartY__,
             body: [
                 [
                     { content: '', colSpan: 1, styles: { fontStyle: 'bold' } }
                 ],
                 [
                     {
                         content: data_gip.account || '--',
                         colSpan: 1,
                         styles: { fontStyle: 'bold', halign: 'center', fontSize: 10 }
                     }
                 ]
             ],
             columnStyles: {
                 0: { cellWidth: 380 } // Ancho total de la columna
             },
             styles: {
                 lineWidth: 0.0,
                 lineColor: [0, 0, 0],
                 fontSize: 10,
                 textColor: [0, 0, 0],
                 halign: 'center',
                 valign: 'middle'
             },
             theme: 'grid',
             margin: {
                 left: (pageWidth - 380) / 2, // Centrar la tabla
                 right: (pageWidth - 380) / 2
             },
             didDrawCell: (data) => {
                 // Insertar imágenes en las celdas correspondientes
                 if (data.row.index === 0 && data.column.index === 0) {
                     const imgWidth = 30;
                     const imgHeight = 30;
                     const x = data.cell.x + (data.cell.width - imgWidth) / 2;
                     const y = data.cell.y + (data.cell.height - imgHeight) / 2;
                     if (typeof logoBase64Jefe !== 'undefined' && logoBase64Jefe) {
                         doc.addImage(logoBase64Jefe, 'PNG', x, y, imgWidth, imgHeight);
                     }
                 }
                 // Nota: Eliminé la referencia a la columna 2 ya que ahora solo hay 1 columna
                 // Dibujar línea al 60% del ancho de la celda
                 if (data.row.index === 0) {
                     const { x, y, width } = data.cell;
                     const lineWidth = width * 0.6; // 60% del ancho (168 px de 280 px)
                     const startX = x + (width - lineWidth) / 2; // Centrar la línea
                     doc.setLineWidth(1.5);
                     doc.line(startX, y + data.cell.height, startX + lineWidth, y + data.cell.height);
                 }
             },
             didParseCell: (data) => {
                 if (data.row.index === 0) {
                     data.row.height = 50; // Altura en px
                 }
             }
         });
      
         // Calcular la posición Y para el texto (después de la tabla)
         //const textY = doc.lastAutoTable.finalY + 20; // 20 px de margen después de la tabla
         //const pageWidth_ = doc.internal.pageSize.getWidth();
         //const text = "PAYMENT PLAN"; // Reemplaza con tu texto
         //const textWidth = doc.getTextWidth(text); // Ancho del texto
         //const textX = (pageWidth_ - textWidth + 20) / 2; // Posición x centrada

         // Añadir el texto centrado
         //doc.setFont('', 'bold');
         //doc.setFontSize(8);

         // Registrar la fuente Cabin Bold
         //doc.addFileToVFS('Cabin-Bold.ttf', fuente);
         //doc.addFont('Cabin-Bold.ttf', 'Cabin', 'bold');

         // Configurar la fuente y tamaño
         //doc.setFont('', 'bold');
         //doc.setFontSize(8);

         //doc.text(text, textX, textY);

         //nextTableStartY += 20; // Aumentar la posición Y para dejar espacio para el texto

         // Generar tabla desde el elemento HTML con id="my-table"
         //doc.autoTable({
         //    html: '#my-table',
         //    startY: nextTableStartY, // Comenzar la tabla más abajo para dejar espacio para la imagen
         //    theme: 'striped',
         //    headStyles: { fillColor: [79, 129, 189] },
         //    styles: { fontSize: 10, cellPadding: 2 },
         //});
         
         const nextTableStartY___ = doc.lastAutoTable.finalY + 10; // 50 px de margen
         //if (nextTableStartY_ > 260) { 
         //    doc.addPage();
         //}

         doc.autoTable({
             startY: nextTableStartY___,
             body: [

                 [
                     {
                         content: "PAYMENT PLAN",
                         styles: {
                             fontStyle: "bold",
                             fontSize: 8,
                             halign: "center"
                         },
                     },
                      
                 ],                  
             ],
             
             styles: {
                 fontSize: 8,
                 textColor: [0, 0, 0],
                 cellPadding: 2
             },
             margin: { left: 20, right: 20 },
             theme: 'plain'
         });

         let nextTableStartY = doc.lastAutoTable.finalY + 4; // 10 px de margen después de la primera tabla

         doc.autoTable({
            html: '#my-table',
            startY: nextTableStartY, // Comenzar la tabla más abajo para dejar espacio para la imagen
            theme: 'striped',
            margin: { left: 20, right: 20 },
            headStyles: {
               fillColor: [255, 255, 255], // Color azul para el encabezado
               textColor: [0, 0, 0], // Texto blanco para contraste
               fontStyle: 'bold',
               halign: 'center'
            },
            bodyStyles: {
               fillColor: [255, 255, 255], // Fondo blanco para todas las filas
               textColor: [0, 0, 0], // Texto negro
               halign: 'center',
               valign: 'middle'
            },
            styles: {
               fontSize: 10,
               lineWidth: 0.5, // Bordes definidos
               lineColor: [0, 0, 0], // Color gris claro para los bordes
               fillColor: [255, 255, 255] // Fondo blanco para todas las celdas
            }
         });


          

         // Guardar el PDF
         doc.save("document-signature.pdf");

         
      });

      function resizeImageBase64(base64String, maxWidth, maxHeight) {
         return new Promise((resolve, reject) => {
            // Agregar prefijo si no está presente
            let fullBase64 = base64String;
            if (!base64String.startsWith('data:image/')) {
                  fullBase64 = 'data:image/png;base64,' + base64String; // Ajusta el tipo si es necesario
                  console.log("Base64 corregido:", fullBase64); // Depuración
            }

            const img = new Image();
            img.src = fullBase64;

            img.onload = () => {
                  const canvas = document.createElement('canvas');
                  const ctx = canvas.getContext('2d');

                  if (ctx) {
                     const canvasWidth = maxWidth;
                     const canvasHeight = maxHeight;

                     let width = img.width;
                     let height = img.height;

                     if (width > height) {
                        if (width > maxWidth) {
                              height *= maxWidth / width;
                              width = maxWidth;
                        }
                     } else {
                        if (height > maxHeight) {
                              width *= maxHeight / height;
                              height = maxHeight;
                        }
                     }

                     const x = (canvasWidth - width) / 2;
                     const y = (canvasHeight - height) / 2;

                     canvas.width = canvasWidth;
                     canvas.height = canvasHeight;

                     ctx.fillStyle = 'rgba(0, 0, 0, 0)'; // Transparente
                     ctx.fillRect(0, 0, canvasWidth, canvasHeight);

                     ctx.drawImage(img, x, y, width, height);

                     const resizedBase64 = canvas.toDataURL('image/png', 1);
                     resolve(resizedBase64);
                  } else {
                     reject(new Error('El contexto 2D del lienzo no se ha creado correctamente.'));
                  }
            };

            img.onerror = (error) => {
                  console.error("Error al cargar la imagen:", error);
                  reject(new Error('No se pudo cargar la imagen desde la cadena base64.'));
            };
         });
      }


   });

   /*
         // Or use javascript directly:
         autoTable(doc, {
            head: [['Name', 'Email', 'Country']],
            body: [
               ['David', 'david@example.com', 'Sweden'],
               ['Castille', 'castille@example.com', 'Spain'],
           
            ],
         })
         */


   function contadorPosicion()
   {
      //if(menus_disponibles.plan_pago == 1 || menus_disponibles.plan_pago == "1")
      //{
      //   menus_disponibles.desembolzo = "1";
      //}

      // Ordered list of properties to process
      const propertiesToCheck = [
         "general_information",
         "referencia",
         "documento_respaldo",
         "preaprobacion",
         "plan_pago",
         "desembolzo"
      ];

      // Find the first "1" and set the next property (if it's "2") to "1"
      for (let i = 0; i < propertiesToCheck.length - 1; i++) {
         const currentProp = propertiesToCheck[i];
         if (menus_disponibles[currentProp] === "1") {
            const nextProp = propertiesToCheck[i + 1];
            if (menus_disponibles[nextProp] === "2") {
                  menus_disponibles[nextProp] = "1";
                  break; // Stop after updating the next property
            }
         }
      }
 
   }

   function cargarPrincipal()
   {

      let data = {
         id_ifp: id_ifp,
      };

      console.log(JSON.stringify(data));

      //return;

      $.ajax({
         type: "POST",
         url: URL_BASE + "credit/get-data-disbursed",
         data: JSON.stringify(data),
         contentType: "application/json", // Tipo de contenido JSON
         success: function (response) {
 
            try {
               let info = JSON.parse(response);

               if (info.type == "success") {


                  //data_gip

                  data_gip          = info.data_gip || {};
                  imagen_sistema    = info.base64Image_logo || {};

                  menus_disponibles = info.menu_habilitados || {};

                  let data_disbursed = info.data_disbursed || {};
                  let upload_signed_file_credit = info.upload_signed_file_credit || {};

                  let planes = info.list_credit_history || [];

                  var newRow = "";

                  // Iterar sobre el arreglo y concatenar las filas
                  planes.forEach((element) => {

                     let {
                        cuotas,
                        fecha_pago,
                        valor_cuota,
                        valor_mora,
                        valor_interes,
                        valor_capital,
                        total_cuota,
                        saldo_capital,
                        valor_pagado,
                        mora_pagado,
                        interes_pagado,
                        capital_pagado,
                        mora_pendiente,
                        interes_pendiente,
                        capital_pendiente,
                        saldo_pendiente,
                     } = element;

                     newRow +=
                        "<tr>" +
                           '<td class="centrar">' + cuotas + "</td>" +
                           '<td class="centrar">' + formatFecha(fecha_pago) + "</td>" +
                           '<td class="centrar">$' + formatNumber(valor_interes) + "</td>" +
                           '<td class="centrar">$' + formatNumber(valor_capital) + "</td>" +
                           '<td class="centrar">$' + formatNumber(total_cuota) + "</td>" +
                           '<td class="centrar">$' + formatNumber(saldo_capital) + "</td>" +
                        "</tr>";

                  });

                  $('.tbody_envios').html(newRow);

                  if(Object.keys(upload_signed_file_credit).length != 0)
                  {  

                     

                     let url_documento = upload_signed_file_credit.url_completa || "";
                     let nombre_original = upload_signed_file_credit.nombre_original || "";

                     //$('.link_descargar').attr({
                     //      'href': url_documento,
                     //      'target': '_blank',
                     //      'download': nombre_original  
                     //});


                     
                  }
 
                  if(Object.keys(data_disbursed).length != 0)
                  {

                     //habilitar el modo de edicion
                     $(".btn-edicion").attr("data-edicion", "1");
                     $(".btn-edicion-text").text("Enabled editing");

                     $('input, select, button, textarea').prop('disabled', true);
                     $('.back').prop('disabled', false);
                     $('.btn-edicion').prop('disabled', false);

                     $(".guardar_siguiente").css("display", "none");

                     let tipoArchivo = data_disbursed.extension || "";
                     let downloadUrl = data_disbursed.url_completa || "";
                     let fileName = data_disbursed.nombre_original || "";
                     let id = data_disbursed.id_gip || "";
 
                     $(".card_container").html(generateCardHtmlURL(id, tipoArchivo, downloadUrl, fileName));
                     
                     $(".btn-eliminar").css("display", "none");
                     $(".show-presentation").css("display", "none");

                     if(menus_disponibles.desembolzo == 1 && menus_disponibles.estado_prestamo == 4)
                     {
                        $(".enableMenu").css("display", "");
                     }

 

                  }else{

                     //habilitar el modo de edicion
                     $(".btn-edicion").attr("data-edicion", "2");
                     $(".btn-edicion-text").text("Disabled editing");

                     $('input, select, button, textarea').prop('disabled', false);
                     $('.valor_monto_solicitado_li, .motivo_prestamo_li').prop('disabled', true);

                     $('.back').prop('disabled', false);
                     $('.btn-edicion').prop('disabled', false);

                     $(".btn-edicion").css("display", "none");

                     $('.plan_crediticio, .cliente_aprueba, .btn_general_plan, .guardar_borrador, .guardar_siguiente ').prop('disabled', false);
                  }

                  if(Object.keys(data_gip).length != 0)
                  {
                     $(".valor_monto_solicitado_li").val(data_gip.monto_desembolsar);
                     $(".motivo_prestamo_li").val(data_gip.motivo_prestamo_li);
                     $(".nombre_plan").val(data_gip.plan_crediticio);
                     $(".tasa_plan").val(data_gip.tasa_interes);
                     $(".relacion_cuota_ingreso").val(data_gip.relacion_cuota_ingreso);
  
                     if(isEmpty(data_gip.numero_credito) == true)
                     {
                        $(".titulo_cabecera_credito").text(" " + data_gip.account);
                     }else{
                        $(".titulo_cabecera_credito").text(" No. Credit: " + data_gip.numero_credito + " - " + data_gip.account);
                     }

                     

                     $(".relacion_cuota_ingreso").val(data_gip.relacion_cuota_ingreso);

                     $(".mostrar_no_cash_acreditar").css("display", "none");

                     $(".tipo_cuenta_acreditar").val(data_gip.nombre_tipo_cuenta_acreditar);
                     $(".banco_acreditar").val(data_gip.nombre_banco_acreditar);
                     $(".numero_cuenta_acreditar").val(data_gip.numero_cuenta_acreditar);
                     $(".numero_ruta_acreditar").val(data_gip.numero_ruta_acredita);
                     $(".numero_ruta_acreditar").attr("disabled", true);

                     $(".email_acreditar").val(data_gip.correo_electronico_acreditar);
                     $(".email_acreditar").attr("disabled", true);

                      
    

                     $(".nombre_beneficiario_acreditar").val(data_gip.nombre_beneficiario_acreditar);

                     if(data_gip.tipo_cuenta_acreditar !=1 )
                     {
                        $(".mostrar_no_cash_acreditar").css("display", "");
                     }

                     $(".nombre_plan").attr("disabled", true);
                     $(".tasa_plan").attr("disabled", true);
                     $(".relacion_cuota_ingreso").attr("disabled", true);

                     $(".tipo_cuenta_acreditar").attr("disabled", true);
                     $(".banco_acreditar").attr("disabled", true);
                     $(".numero_cuenta_acreditar").attr("disabled", true);
                     $(".nombre_beneficiario_acreditar").attr("disabled", true);
                  }

                  //if(menus_disponibles.preaprobacion == 1)
                  //{
                  //   //$(".btn-edicion").css("display", "none");
                  //   //$(".guardar_rechazar").css("display", "none");
                  //   //$(".guardar_borrador").css("display", "none");
                  //   //$(".guardar_siguiente").css("display", "");

                  //   if(menus_disponibles.estado_prestamo == 5)
                  //   {
                  //      
                  //      $(".btn-edicion").css("display", "none");
                  //      $(".guardar_rechazar").css("display", "none");
                  //      $(".guardar_borrador").css("display", "none");
                  //      $(".guardar_siguiente").css("display", "none");

                  //   }else{
                  //      //$(".guardar_siguiente").css("display", "none");
                  //   }
                  //    
                  //}

                  //if(menus_disponibles.plan_pago == 1)
                  //{
                  //   $(".guardar_borrador").css("display", "none");
                  //   //$(".guardar_siguiente").css("display", "none");

                  //   $(".guardar_siguiente").text("Next");
                  //   $(".guardar_siguiente").attr("disabled", false);
                  //}

                  contadorPosicion();

                  $(".cargando_pantalla").css("display", "none");
                  $(".pantalla_cargada").css("display", "");
 
               } else if (info.type == "error") {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: info.message,
                  //});

                  ventanaError("Opps there was an error", info.message);
               }
            } catch (error) {
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);
            }
         },
         error: function (xhr, status, error) {
            console.error("Error en la solicitud:", error);
            // Manejar errores aquí
            //Swal.fire({
            //   icon: "error",
            //   title: "Oops...",
            //   text: error,
            //});

            ventanaError("Opps there was an error", error);

         },
      });

       
   }

   function eliminarDocumento() 
   {
      $('.btn-eliminar').off('click');

      $('.btn-eliminar').on('click', function() {
         
         let data_id = $(this).data("id");
         console.log("data_id eliminar: " + data_id);

         $(".titulo_modal_confirmar").text("You are sure?");
         $(".mensaje_modal_confirmar").text("Are you sure you want to delete this record?");
         $(".mensaje_espera_moda_confirmacion").text("");
         $(".tipo_modal_confirmar").val("eliminar_card_documento");
         $(".data_id").val(data_id);

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);

         //ventanaRegistroExito("Record deleted", "The record has been successfully deleted");
         //return;
          
         $('#btn_cerrar_ventana_confirmacion').css({
            'background-color': COLOR_FONDO_VENTANA_CERRAR,
            'color': COLOR_TEXT_VENTANA_CERRAR,
            'display': "",
         });

         $('#btn_aplicar_ventana_confirmacion').css({
            'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
            'color': COLOR_TEXT_VENTANA_CONFIRMACION,
            'display': "",
         });
 
         $("#ventana_confirmacion").modal("show");

         //$(".card_eliminar_" + data_id).remove();

      });

 
   }
 
   function ventanaRegistroExito(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
       
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }

   function isEmpty(value) {
       // Verificar si es null o undefined
       if (value == null) return true;

       // Verificar si es una cadena vacía
       if (typeof value === "string" && value.trim() === "") return true;

       // Verificar si es un array vacío
       if (Array.isArray(value) && value.length === 0) return true;

       // Verificar si es un objeto vacío
       if (typeof value === "object" && Object.keys(value).length === 0) return true;

       return false;
   }
 
   function validarSoloNumeros(input) {
       const number = parseInt(input, 10);
       return !isNaN(number) && number.toString() === input;
   }

   function validateEmail(email) {
      // Expresión regular para validar un formato de correo electrónico
      var emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
      
      if (emailPattern.test(email)) {
         return true;  // Es un correo válido
      } else {
         return false;  // No es un correo válido
      }
   }
 
   function isInvalidEmail(email) {
      const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      return !emailRegex.test(email);
   }

   function getRandomInt(min, max) {
      return Math.floor(Math.random() * (max - min + 1)) + min;
   }

   function validateFormFields() {
      const fields = [
         { selector: '.referencias_contactadas', section: 'Pre-approval', name: 'Were references contacted?' },
         { selector: '.cliente_nuevo', section: 'Pre-approval', name: 'Are you a new customer?' },
         { selector: '.relacion_ingreso_cuota', section: 'Pre-approval', name: 'Income quota ratio' },
         { selector: '.documentacion_completa', section: 'Pre-approval', name: 'Complete documentation?' },
         { selector: '.calificacion_final', section: 'Pre-approval', name: 'Final grade' },
         { selector: '.banco', section: 'Account information', name: 'Bank' },
         { selector: '.tipo_cuenta', section: 'Account information', name: 'Account type' },
         { selector: '.numero_cuenta', section: 'Account information', name: 'Account number' },
         { selector: '.metodo_pago', section: 'Payment methods', name: 'Payment methods' }
      ];

      for (const field of fields) {
         const value = $(field.selector).val();
         if (value && value.length > 255) {
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector(field.selector);
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               };
               toastr.error(`In "${field.section}" the field "${field.name}" cannot exceed 255 characters.`);
               return true;
         }
      }
      
      return false;
   }

   function generateCardHtmlURL(id, tipoArchivo, downloadUrl, fileName) {
      // Input validation
      if (!id || !tipoArchivo || !downloadUrl) {
         console.error('Missing required parameters in generateCardHtml');
         return '';
      }

      // Sanitize inputs to prevent XSS
      const sanitize = (str) => {
         const div = document.createElement('div');
         div.textContent = str;
         return div.innerHTML;
      };

      const sanitizedId = sanitize(id);
      const sanitizedTipoArchivo = sanitize(tipoArchivo);
      const sanitizedNombre = sanitize(fileName);
      const sanitizedDownloadUrl = String(downloadUrl);
      const sanitizedFileName = fileName ? sanitize(fileName) : `document.${sanitizedTipoArchivo.toLowerCase()}`;

      // Validate tipoArchivo for safe filename
      const validExtension = /^[a-zA-Z0-9]+$/.test(sanitizedTipoArchivo);
      if (!validExtension) {
         console.error('Invalid file extension:', sanitizedTipoArchivo);
         return '';
      }

      return `
         <div class="col-12 col-sm-4 pt-4 card_eliminar_${sanitizedId}">
               <div class="card  " style="width: 100%; max-width: 300px;">
                  <div class="card-body">
                     <h5 class="card-title">File type: <span class="card_tipo_archivo">${sanitizedTipoArchivo}</span></h5>
                     <h5 class="card-title">File name: <span class="card_tipo_archivo">${sanitizedFileName}</span></h5>
                     <div class="row">
                           <div class="col-12">
                              <button class="btn btn-sm btn-eliminar waves-effect waves-themed" data-id="${sanitizedId}">
                                 <i class="fas fa-trash tamano-icono" aria-hidden="true"></i>
                              </button>
                              <a class="btn btn-sm btn-descargar waves-effect waves-themed" data-id="${sanitizedId}" href="${sanitizedDownloadUrl}" download="${sanitizedFileName}">
                                 <i class="fas fa-download tamano-icono" aria-hidden="true"></i>
                              </a>
                           </div>
                     </div>
                  </div>
               </div>
         </div>
      `;
   }

   function generateCardHtml(id, tipoArchivo, base64Data, fileName) {
      // Input validation
      if (!id || !tipoArchivo || !base64Data) {
         console.error('Missing required parameters in generateCardHtml');
         return '';
      }

      // Sanitize inputs to prevent XSS
      const sanitize = (str) => {
         const div = document.createElement('div');
         div.textContent = str;
         return div.innerHTML;
      };

      const sanitizedId = sanitize(id);
      const sanitizedTipoArchivo = sanitize(tipoArchivo);
      const sanitizedFileName = fileName ? sanitize(fileName) : `document.${sanitizedTipoArchivo.toLowerCase()}`;

      // Validate tipoArchivo for safe filename
      const validExtension = /^[a-zA-Z0-9]+$/.test(sanitizedTipoArchivo);
      if (!validExtension) {
         console.error('Invalid file extension:', sanitizedTipoArchivo);
         return '';
      }
   

      return `
         <div class="col-12 col-sm-4 pt-4 card_eliminar_${sanitizedId}">
            <div class="card" style="width: 100%; max-width: 300px;">
               <div class="card-body">
                  <h5 class="card-title">File type: <span class="card_tipo_archivo">${sanitizedTipoArchivo}</span></h5>
                  <h5 class="card-title">File name: <span class="card_tipo_archivo">${sanitizedFileName}</span></h5>
                  <div class="row">
                     <div class="col-12">
                        <button class="btn btn-sm btn-eliminar waves-effect waves-themed" data-id="${sanitizedId}">
                           <i class="fas fa-trash tamano-icono" aria-hidden="true"></i>
                        </button>
                        <a class="btn btn-sm btn-descargar waves-effect waves-themed" data-id="${sanitizedId}" href="${base64Data}" download="${sanitizedFileName}">
                           <i class="fas fa-download tamano-icono" aria-hidden="true"></i>
                        </a>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      `;
   }
 
   function navegarPantallaSiguiente(UUID_ENC_)
   {
      $(".titulo_modal_confirmar").text("Record added");
      $(".mensaje_modal_confirmar").text("¡Record added successfully!");
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("navegar_pantalla_siguiente");
      $(".data_id").val(UUID_ENC_);

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });

      $('#btn_close_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });
 
      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_IR,
         'color': COLOR_TEXT_VENTANA_IR,
         'display': "",
      });

      $('#btn_aplicar_ventana_confirmacion').text("Continue");
 
      $("#ventana_confirmacion").modal("show");
   }

   function navegarPantallaListado(titulo="", mensaje="", url="")
   {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("navegar_otras_pantallas");
      $(".data_id").val(url);

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });

      $('#btn_close_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });
 
      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_IR,
         'color': COLOR_TEXT_VENTANA_IR,
         'display': "",
      });

      $('#btn_aplicar_ventana_confirmacion').text("Continue");
 
      $("#ventana_confirmacion").modal("show");
   }

   function ventanaError(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }

   // Función para formatear números como 1,000.00
   const formatNumber = (number) => {
      return Number(number).toLocaleString('en-US', {
         minimumFractionDigits: 2,
         maximumFractionDigits: 2
      });
   };

   // Función para formatear fecha YYYY-MM-DD a DD/MMMM/YYYY
   const formatFecha = (fecha) => {
      //const meses = ["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
      const meses = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

      const date = new Date(fecha);
      return `${date.getDate()}/${meses[date.getMonth()]}/${date.getFullYear()}`;
   };


</script>
{/literal}


{/block}