{extends file="$layouts_admin"}
{block name="head"}

   <link href="{$theme}default/css/grupo.css?v={$config['version']}" rel="stylesheet">
 
 

{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    
 
      

.nuevo_control{
    min-height: calc(1.47em + .75rem + 2px);
    padding: .375rem .844rem;
    font-size: .75rem;
    border-radius: 8px;
}

table.estilosTabla > :not(caption) > * > * {
        /*
        padding-top: 5px !important;
        padding-bottom: 5px !important;
        */
    }

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
        
    }

</style>

<input type="text" disabled hidden id="ws_nombre_socket" value="{$ws_nombre_socket}">


<input
         type="text"
         value="{$APP_URL_ORIGINAL_SOCKET}"
         disabled
         hidden
         id="APP_URL_ORIGINAL_SOCKET"
      />

 
<input
         type="text"
         value="{$DB_NAME}"
         disabled
         hidden
         id="DB_NAME"
      />

<div class="row">

    <div class="col-md-12">

       
        <div class="panel">
            <div class="panel-hdr">
                <h2 style="color: #666; font-weight: 600; "><span></span>List Staff</h2>
                <input type="text" class=" tener_url_base" value={$url_base} disabled hidden/>
 
                 
            </div>
                                                         
            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">

                    <div class="px-2">
                        
                        <div class="row contenedor" style="padding: 10px">
 
                            <br />
                             
                            <div class="col-12 col-sm-12 pt-4">
                            
                            
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover mt-3 estilosTabla"  id="clx_datatable">
                                        <thead>
                                        <tr>
                                            <th class="centrar">Agent</th>
                                            <th class="centrar">Assigned contacts</th>
                                            <th class="centrar">State</th>
                                            <th class="centrar">Last connection</th>
                                            <th class="centrar">Open conversations</th>
                                            <th class="centrar">Overall Success Rate (%)</th>
                                        </tr>
                                        </thead>
                                        <tbody class="tbody_envios">
                                          {$listado_staff}
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            </div>

                       
                    </div>

                  

                </div>
 
                
               
            </div>
        </div>
    </div>
</div>




{/block}

{block name="script"}

 
{literal}
<script type="module">

 
   const URL_BASE      = $(".tener_url_base").val();
   const tener_role_id = $(".tener_role_id").val();

   var APP_URL_ORIGINAL_SOCKET = $("#APP_URL_ORIGINAL_SOCKET").val();
   var BASE_DE_DATOS_GLOBAL = $("#DB_NAME").val();

   var WS_NOMBRE_SOCKET = document.getElementById('ws_nombre_socket').value;
   
   var NOMBRE_LISTADO_ASISTENCIAS_LOCALSTORAGE = "listado_asistencias_" + BASE_DE_DATOS_GLOBAL;

   console.log("URL_BASE");
   console.log(URL_BASE);

   const socket = io(APP_URL_ORIGINAL_SOCKET, {
       path: "/" + WS_NOMBRE_SOCKET + "/socket.io",
       //path: "/socket-chat/socket.io",
       //transports: ["websocket"],
         transports: ["polling"],  // Usar
    });

    setInterval(resetAsistenciaStaffSocket, 9000);

    $(document).ready(function() {

 
        //AREA DEL SOCKET
        socket.on("connect", () => {
            console.log("Conectado al servidor de Socket.IO");
        });

        // Manejar la desconexión
        socket.on("disconnect", () => {
            console.log("Desconectado del servidor de Socket.IO");
        });
 
        socket.on("estado-online-staff/" + BASE_DE_DATOS_GLOBAL, (data) => {
        
            //console.log("Datos de chat recibidos estado-online-staff:", data);

            let listado_asistencias_staff  = getFromLocalStorage(NOMBRE_LISTADO_ASISTENCIAS_LOCALSTORAGE) || [];

            let existe_staff = listado_asistencias_staff.find(item => item.staff_id == data.staff_id);

            if(!existe_staff)
            {
                listado_asistencias_staff.push(data);
                saveToLocalStorage(NOMBRE_LISTADO_ASISTENCIAS_LOCALSTORAGE, listado_asistencias_staff);
            }

            //listado_asistencias_staff  = getFromLocalStorage(NOMBRE_LISTADO_ASISTENCIAS_LOCALSTORAGE) || [];

            //console.log("listado_asistencias_staff despues de agregar");
            //console.log(listado_asistencias_staff);

            let var_offline = '<span class=" badge " style="display: inline-block; background-color:red; ccolor:white;" style="display: inline-block">Offline</span>';
            let var_online = '<span class=" badge " style="display: inline-block; background-color:green; ccolor:white;" style="display: inline-block">Online</span>';

            $(".estado_staff_general").html(var_offline);
            $(".estado_staff_general").attr("data-estado", "offline");

            listado_asistencias_staff.forEach((item) => {

                let {
                    staff_id,
                    fecha_login,
                    db,
                } = item;

                $(".estado_staff_" + staff_id).html(var_online);
                $(".estado_staff_" + staff_id).attr("data-estado", "online");
                $(".fecha_ultimo_login_staff_" + staff_id).text(fecha_login);

            }); 

            //filtrarOnlineOfflineStaff($('#select_estado_staff').val()); 

        });
         
         

    });

    function resetAsistenciaStaffSocket()
    {
        deleteLocalStorage(NOMBRE_LISTADO_ASISTENCIAS_LOCALSTORAGE);
 
    }

    function deleteLocalStorage(key) {
        try {
            localStorage.setItem(key, JSON.stringify([]));
        } catch (error) {
            console.error("Error al eliminar en localStorage:", error);
        }
    }

    function saveToLocalStorage(key, data) {
        try {
            localStorage.setItem(key, JSON.stringify(data));
            //console.log(`Datos guardados en localStorage con clave ${key}:`, data);
        } catch (error) {
            console.error("Error al guardar en localStorage:", error);
        }
    }

    // Función para leer datos de localStorage
    function getFromLocalStorage(key) {
        try {
            const data = localStorage.getItem(key);
            return data ? JSON.parse(data) : null;
        } catch (error) {
            console.error("Error al leer de localStorage:", error);
            return null;
        }
    }

 
      $("#fecha_desde_tiempo_abierto").prop("disabled", true);
      $("#fecha_hasta_tiempo_abierto").prop("disabled", true);

 
         $("#consultar_filtros").click(function () {

 
            let estatus_conversacion = $("#estatus_conversacion").val() || "";
            let category_form        = $("#category_form").val() || "";
            let producto        = $("#producto").val() || "";
            let staff        = $("#staff").val() || "";
            let fecha_desde        = $("#fecha_desde").val() || "";
            let fecha_hasta        = $("#fecha_hasta").val() || "";

            let fecha_desde_tiempo_abierto        = $("#fecha_desde_tiempo_abierto").val() || "";
            let fecha_hasta_tiempo_abierto        = $("#fecha_hasta_tiempo_abierto").val() || "";
       
            //if(isEmpty(fecha_desde) == true)
            //{
            //    toastr.error("!Date from is required¡");
            //    return;
            //}

            

            let enviar_informacion = {
               fecha_desde: fecha_desde,
               fecha_hasta: fecha_hasta,

               fecha_desde_tiempo_abierto: fecha_desde_tiempo_abierto,
               fecha_hasta_tiempo_abierto: fecha_hasta_tiempo_abierto,

               estatus_conversacion: estatus_conversacion,
               category_form: category_form,
               producto: producto == "0" ? "" : producto,
               staff: staff == "0" ? "" : staff,
                
            };

            console.log(enviar_informacion);
            //console.log("aqui abajo ahi un return");
            //return;

            $("#consultar_filtros").prop("disabled", true);

            $.ajax({
               type: "POST",
               url: URL_BASE + "social/filtra-listado-conversaciones-v1",
               data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
               contentType: "application/json", // Tipo de contenido JSON
               success: function (response) {

                  $("#consultar_filtros").prop("disabled", false);
                 
                  $(".tbody_envios").html("");

                  try {
                     let info = JSON.parse(response);
                     if (info.type == "success") {
                        let arr = info.data_html;

                        if (arr == "") {
                           $(".tbody_envios").html(
                              '<tr><th colspan="9" class="centrar pt-4"> No information</th></tr>',
                           );
                        } else {
                           $(".tbody_envios").html(arr);

                        }
 
                     } else {
                        alert("Error sending group messages");
                     }
                  } catch (error) {
                     $(".tbody_envios").html("");
                     alert("Error:" + error);
                  }
               },
               error: function (xhr, status, error) {
                  $("#consultar_filtros").prop("disabled", false);
                  $(".tbody_envios").html("");
                  console.error("Error en la solicitud:", error);
               },
            });
         });


        function cargar_fecha() {
            const today = new Date();

            // Formatear la fecha como YYYY-MM-DD
            const year = today.getFullYear();
            const month = String(today.getMonth() + 1).padStart(2, "0"); // Mes de 2 dígitos
            const day = String(today.getDate()).padStart(2, "0"); // Día de 2 dígitos

            const formattedDate = year + "-" + month + "-" + day;
            return formattedDate;
        }

        function isEmpty(value) {
            // Verificar si es null o undefined
            if (value == null) return true;

            // Verificar si es una cadena vacía
            if (typeof value === "string" && value.trim() === "") return true;

            // Verificar si es un array vacío
            if (Array.isArray(value) && value.length === 0) return true;

            // Verificar si es un objeto vacío
            if (typeof value === "object" && Object.keys(value).length === 0) return true;

            return false;
        }
 
</script>
{/literal}

{/block}