<?php
require APP_SYSTEM_PATH . '/lib/misc/smsdriver.php';

class Tickets
{
    public function get_department($did)
    {
        $dname = '';

        $d = ORM::for_table('sys_ticketdepartments')->find($did);

        if ($d) {
            $dname = $d->dname;
        }

        return $dname;
    }

    public static function sendReplyNotification($tid, $message)
    {
        $d = ORM::for_table('sys_tickets')->find($tid);

        if ($d && $d->email == '') {
            return false;
        }

        return false;
    }

    public function create(
        $cid = 0,
        $admin = 0,
        $flag = 0,
        $source = 'Web',
        $data = false,
        $extras = false,
        $ticket_prefix = false,
        $send_email = true,
        $otherInformations = []
    ) {
        global $config, $_L;
        $msg = '';

        /* $salida = [
            "db"                           => "xhde365_itgrahnpro", 
            "message"                      => "A new ticket has been created", 
        ];

        emitInformationSocket($salida, "new-ticket-notification");
        echo "llegamos";
        exit; */


        $fullname_sys_users = $otherInformations["fullname_sys_users"] ?? ""; 

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
            //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
            //$response = array(
            //    "type" => "error",
            //    "message" => "Database connection failed",
            //    "data" => [],
            //);
            //print_r(json_encode( $response)) ; exit;

            $ret_val = [
                "success" => "No",
                "msg" => "Database connection failed",
            ];

            return $ret_val;
        }


        $arregloArchivos                = _post('arregloArchivos');
        $CompanyName                    = _post('CompanyName');
        $partner_crm_administrativo     = _post('partner_crm_administrativo');
        $url_crm_administrativo         = _post('url_crm_administrativo');

        //echo $arregloArchivos; exit;
 
        //echo $validArrayFile; exit; 


        $ib_now = date('Y-m-d H:i:s');

        if (!$ticket_prefix) {
            $ticket_prefix = $config['ticket_code_prefix'] != '' ? $config['ticket_code_prefix'] : strtoupper(Str::random(3));
        }

        /* if ($config['ticket_code_current_number'] != '') {
            $ticket_code_number = str_pad(
                $config['ticket_code_current_number'],
                $config['number_pad'],
                '0',
                STR_PAD_LEFT
            );
            update_option(
                'ticket_code_current_number',
                current_number_would_be($config['ticket_code_current_number'])
            );

            //echo "Se llego a la configuracion de tickets"; exit;

        } else {
            $ticket_code_number = _raid(8);
        } */

        $ticket_code_number = _raid(10);

        $tid = $ticket_prefix . '-' . $ticket_code_number;

        if (isset($data['did'])) {
            $did = $data['did'] == '' ? 0 : $data['did'];
        } else {
            $did = _post('department');
        }

        $dname = $this->get_department($did);

        $account = '';
        $email = '';
        $last_reply = '';

        if ($cid != 0) {
            $d = ORM::for_table('crm_accounts')->find($cid);

            if ($d) {
                $account = $d->account;
                $email = $d->email;
                $last_reply = $d->account;
            }
        } else {
            $account = _post('account');

            $first_name = '';
            $middle_name = '';
            $last_name = '';

            $email = _post('email');
            $last_reply = $account;
            if ($account == '') {
                //$account = 'Web';
                //$account = 'Cesar Pineda Lopez';
                $account = "";
                //$account = $CompanyName;
            }

            $account_e = explode(' ', $account);

            if (isset($account_e[0])) {
                $first_name = $account_e[0];
            }

            if (isset($account_e[1])) {
                $last_name = $account_e[1];
            }

            if (isset($account_e[3])) {
                $middle_name = $last_name;
                $last_name = $account_e[3];
            }

            if ($last_name == '') {
                $last_name = $first_name;
            }

            $e_user = ORM::for_table('crm_accounts')
                ->where('email', $email)
                ->first();

            if ($e_user && $email != '') {
                $cid = $e_user->id;
            } else {
                $l_add['first_name'] = $first_name;
                $l_add['last_name'] = $last_name;
                $l_add['middle_name'] = $middle_name;
                $l_add['email'] = _post('email');
                $l_add['phone'] = _post('phone');
            }
        }

        $message = isset($data['message']) ? $data['message'] : ib_post('message');

        $subject = isset($data['subject']) ? $data['subject'] : ib_post('subject');

        $email_client   = isset($data['email_client']) ? $data['email_client'] : ib_post('email_client');
        $phone_client   = isset($data['phone_client']) ? $data['phone_client'] : ib_post('phone_client');
        $contact_client = isset($data['contact_client']) ? $data['contact_client'] : ib_post('contact_client');

        if ($subject == '') {
            $msg .= 'Subject is required. <br>';
        }

        if ($message == '') {
            $msg .= 'Message is required. <br>';
        }

        if ($email_client == '') {
            $msg .= 'Email is required. <br>';
        }

        if ($phone_client == '') {
            $msg .= 'Phone is required. <br>';
        }

        $urgency = isset($data['urgency']) ? $data['urgency'] : _post('urgency');

        //-------------------
        /* $data = [
            "sys_ticket_id"            => 2,
            "url_crm_admin"            => $url_crm_administrativo,
            "id_cliente_crm"           => 2,
            "arregloArchivos"          => json_decode($arregloArchivos),
        ];

        //http://localhost:50001/app_dev_parnerts/?ng=

        echo json_encode($data); exit; */

 
        // Convert to JSON for FormData
        $jsonData = json_encode($data);

        if ($msg == '') {

            //echo $partner_crm_administrativo . " - "; exit;

            $UUID = generateUUIDv4_especialv1();
            $id_cliente_crm = null;

            //solo cuando el cliente envia a crm administrativo
            if($partner_crm_administrativo == 2)
            {
                //en caso de que lo cree el cliente 
                $created_origin = 2;

                $dataRegister = [
                    "tid"            => $tid,
                    "did"            => $did,
                    "dname"          => $dname,
                    "userid"         => $cid,
                    "account"        => $account,
                    "email"          => $email,
                    "created_at"     => $ib_now,
                    "updated_at"     => $ib_now,
                    "subject"        => $subject,
                    "message"        => $message,
                    "status"         => 'Open',
                    "urgency"        => $urgency,
                    "admin"          => $admin,
                    "attachments"    => ib_post('attachments'),
                    "last_reply"     => $last_reply,
                    "flag"           => $flag,
                    "is_spam"        => 0,
                    "client_read"    => 'No',
                    "admin_read"     => 'No',
                    "source"         => $source,
                    "ttype"          => _post('ttype'),
                    "tstart"         => '',
                    "tend"           => '',
                    "ttotal"         => '',
                    "todo"           => '',
                    "tags"           => '',
                    "notes"          => '',
                    "c1"             => _post('c1'),
                    "c2"             => _post('c2'),
                    "email_client"   => $email_client,
                    "phone_client"   => $phone_client,
                    "contact_client" => $contact_client,
                    "tipo_registro" => "clients_to_crm_admin",
                    "opening_date"  => $ib_now,
                    "staff_created" => null,
                    "staff_name_created"       => null,
                    "UUID"           => $UUID,
                ];
                //------------------------------------

                $response = insertRegisterTickets($dataRegister);

                if($response["type"] == "error" )
                {
                    $ret_val = [
                        "success" => "No",
                        "msg" => $response["message"],
                    ];

                    return $ret_val;
                }

                //echo json_encode($response); exit;

                $sys_tickets_id = $response["sys_tickets_id"];
                $id_cliente_crm = $response["id_cliente_crm"];

                //$ticket_id = $sys_tickets_id;

                $status_id   = $response["status_id"];
                $status_name = $response["status_name"];

                $dataRegister["status"]    = $status_name; 
                $dataRegister["status_id"] = $status_id; 

                try {

                    $sql = "INSERT INTO `sys_tickets`(
                                `crm_admin_sys_tickets_id`,
                                `tid`,
                                `did`,
                                `dname`,
                                `userid`,
                                `account`,
                                `email`,
                                `created_at`,
                                `updated_at`,
                                `subject`,
                                `message`,
                                `status`,
                                `urgency`,
                                `admin`,
                                `attachments`,
                                `last_reply`,
                                `flag`,
                                `is_spam`,
                                `client_read`,
                                `admin_read`,
                                `source`,
                                `ttype`,
                                `tstart`,
                                `tend`,
                                `ttotal`,
                                `todo`,
                                `tags`,
                                `notes`,
                                `c1`,
                                `c2`,
                                `email_client`,
                                `phone_client`,
                                `contact_client`,
                                `created_origin`,
                                `staff_created`,
                                `opening_date`,
                                `staff_name_created`,
                                `status_id`,
                                `UUID`
                        )
                        VALUES(
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?
                        )";
                
                    $stmt = $mysqli->prepare($sql);
                    
                    $stmt->bind_param(
                        'sssssssssssssssssssssssssssssssssssssss',
                        $sys_tickets_id,
                        $dataRegister["tid"],
                        $dataRegister["did"],
                        $dataRegister["dname"],
                        $dataRegister["userid"],
                        $dataRegister["account"],
                        $dataRegister["email"],
                        $dataRegister["created_at"],
                        $dataRegister["updated_at"],
                        $dataRegister["subject"],
                        $dataRegister["message"],
                        $dataRegister["status"],
                        $dataRegister["urgency"],
                        $dataRegister["admin"],
                        $dataRegister["attachments"],
                        $dataRegister["last_reply"],
                        $dataRegister["flag"],
                        $dataRegister["is_spam"],
                        $dataRegister["client_read"],
                        $dataRegister["admin_read"],
                        $dataRegister["source"],
                        $dataRegister["ttype"],
                        $dataRegister["tstart"],
                        $dataRegister["tend"],
                        $dataRegister["ttotal"],
                        $dataRegister["todo"],
                        $dataRegister["tags"],
                        $dataRegister["notes"],
                        $dataRegister["c1"],
                        $dataRegister["c2"],
                        $dataRegister["email_client"],
                        $dataRegister["phone_client"],
                        $dataRegister["contact_client"],
                        $created_origin,
                        $dataRegister["staff_created"],
                        $dataRegister["opening_date"],
                        $dataRegister["staff_name_created"],
                        $dataRegister["status_id"],
                        $dataRegister["UUID"],
                    );
                    
                    $stmt->execute();
                    $sys_tickets_id = $mysqli->insert_id;
                    $stmt->close();

                    $ticket_id = $sys_tickets_id;

                } catch (\Exception  $e) {
                    $ret_val = [
                        "success" => "No",
                        "msg" => "Error: " . $e->getMessage(),
                    ];
                    return $ret_val;
                }
 
            }else{

                $dataSysTicketStatus = ORM::get_db()->query("SELECT * FROM `sys_ticketstatus` WHERE id = 1 ")->fetch(PDO::FETCH_ASSOC);

                $status_id   = 0;
                $status_name = "New";

                if(!empty($dataSysTicketStatus))
                {
                    $status_id   = $dataSysTicketStatus["id"];
                    $status_name = $dataSysTicketStatus["name"];
                }

                //el caso de que lo cree el administrador crm 
                $created_origin = 1;

                $dataRegister = [
                    "tid"            => $tid,
                    "did"            => $did,
                    "dname"          => $dname,
                    "userid"         => $cid,
                    "account"        => $account,
                    "email"          => $email,
                    "created_at"     => $ib_now,
                    "updated_at"     => $ib_now,
                    "subject"        => $subject,
                    "message"        => $message,
                    "status"         => $status_name,
                    "status_id"      => $status_id,


                    "urgency"        => $urgency,
                    "admin"          => $admin,
                    "attachments"    => ib_post('attachments'),
                    "last_reply"     => $last_reply,
                    "flag"           => $flag,
                    "is_spam"        => 0,
                    "client_read"    => 'No',
                    "admin_read"     => 'No',
                    "source"         => $source,
                    "ttype"          => _post('ttype'),
                    "tstart"         => '',
                    "tend"           => '',
                    "ttotal"         => '',
                    "todo"           => '',
                    "tags"           => '',
                    "notes"          => '',
                    "c1"             => _post('c1'),
                    "c2"             => _post('c2'),
                    "email_client"   => $email_client,
                    "phone_client"   => $phone_client,
                    "contact_client" => $contact_client,
                    "tipo_registro" => "crm_admin_to_clients",
                    "opening_date"  => $ib_now,
                    "staff_created" => $admin,
                    "crm_admin_sys_tickets_id" => 0, //colocar el id del servidor
                    "staff_name_created"       => $fullname_sys_users, 
                    "UUID"           => $UUID,
                ];

                //crm_admin_sys_tickets_id
                //echo json_encode($dataRegister); exit;

                try {

                    $sql = "INSERT INTO `sys_tickets`(
                                `tid`,
                                `did`,
                                `dname`,
                                `userid`,
                                `account`,
                                `email`,
                                `created_at`,
                                `updated_at`,
                                `subject`,
                                `message`,
                                `status`,
                                `urgency`,
                                `admin`,
                                `attachments`,
                                `last_reply`,
                                `flag`,
                                `is_spam`,
                                `client_read`,
                                `admin_read`,
                                `source`,
                                `ttype`,
                                `tstart`,
                                `tend`,
                                `ttotal`,
                                `todo`,
                                `tags`,
                                `notes`,
                                `c1`,
                                `c2`,
                                `email_client`,
                                `phone_client`,
                                `contact_client`,
                                `created_origin`,
                                `staff_created`,
                                `opening_date`,
                                `staff_name_created`,
                                `status_id`,
                                `UUID`

                        )
                        VALUES(
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?
                        )";
                
                    $stmt = $mysqli->prepare($sql);
                    
                    $stmt->bind_param(
                        'ssssssssssssssssssssssssssssssssssssss',
                        $dataRegister["tid"],
                        $dataRegister["did"],
                        $dataRegister["dname"],
                        $dataRegister["userid"],
                        $dataRegister["account"],
                        $dataRegister["email"],
                        $dataRegister["created_at"],
                        $dataRegister["updated_at"],
                        $dataRegister["subject"],
                        $dataRegister["message"],
                        $dataRegister["status"],
                        $dataRegister["urgency"],
                        $dataRegister["admin"],
                        $dataRegister["attachments"],
                        $dataRegister["last_reply"],
                        $dataRegister["flag"],
                        $dataRegister["is_spam"],
                        $dataRegister["client_read"],
                        $dataRegister["admin_read"],
                        $dataRegister["source"],
                        $dataRegister["ttype"],
                        $dataRegister["tstart"],
                        $dataRegister["tend"],
                        $dataRegister["ttotal"],
                        $dataRegister["todo"],
                        $dataRegister["tags"],
                        $dataRegister["notes"],
                        $dataRegister["c1"],
                        $dataRegister["c2"],
                        $dataRegister["email_client"],
                        $dataRegister["phone_client"],
                        $dataRegister["contact_client"],
                        $created_origin,
                        $dataRegister["staff_created"],
                        $dataRegister["opening_date"],
                        $dataRegister["staff_name_created"],
                        $dataRegister["status_id"],
                        $dataRegister["UUID"],
                    );
                    
                    $stmt->execute();
                    $sys_tickets_id = $mysqli->insert_id;
                    $ticket_id = $sys_tickets_id;

                    $stmt->close();

                } catch (\Exception  $e) {
                    $ret_val = [
                        "success" => "No",
                        "msg" => "Error: " . $e->getMessage(),
                    ];
                    return $ret_val;
                }

                $dataRegister["crm_admin_sys_tickets_id"] = $sys_tickets_id;

                $response = insertRegisterTickets($dataRegister);

                if($response["type"] == "error" )
                {
                    $ret_val = [
                        "success" => "No",
                        "msg" => $response["message"],
                    ];

                    return $ret_val;
                }

                $id_cliente_crm = $response["id_cliente_crm"];


            }

            //echo "llegmamos al top";
            //exit;

            /* $d = ORM::for_table('sys_tickets')->create();
            $d->tid          = $tid;
            $d->did          = $did;
            $d->dname        = $dname;
            $d->userid       = $cid;
            $d->account      = $account;
            $d->email        = $email;
            $d->created_at   = $ib_now;
            $d->updated_at   = $ib_now;
            $d->subject      = $subject;
            $d->message      = $message;
            $d->status       = 'Open';
            $d->urgency      = $urgency;
            $d->admin = $admin;
            $d->attachments = ib_post('attachments');
            $d->last_reply = $last_reply;
            $d->flag = $flag;
            $d->is_spam = 0;
            $d->client_read = 'No';
            $d->admin_read = 'No';
            $d->source = $source;
            $d->ttype = _post('ttype'); //  Question Incident Problem Feature Request
            $d->tstart = '';
            $d->tend = '';
            $d->ttotal = '';
            $d->todo = '';
            $d->tags = '';
            $d->notes = '';
            $d->c1 = _post('c1');
            $d->c2 = _post('c2');
            $d->email_client = $email_client;
            $d->phone_client = $phone_client;
            $d->contact_client = $contact_client; */
 
            if ($extras) {
                foreach ($extras as $key => $value) {
                    $d->$key = $value;
                }
            }

            //$d->save();
            //$ticket_id = $d->id();


            if(!empty($arregloArchivos))
            {

                $validArrayFile = json_decode($arregloArchivos, true);

                if(is_array($validArrayFile) && count($validArrayFile) != 0)
                {
                    $data = [
                        "sys_ticket_id"            => $ticket_id,
                        "url_crm_admin"            => $url_crm_administrativo,
                        "id_cliente_crm"           => $id_cliente_crm,
                        "arregloArchivos"          => json_decode($arregloArchivos),
                    ];
        
                    $payload = json_encode($data);

                    //echo $payload; exit;

                    $url_crm_administrativo = rtrim($url_crm_administrativo, "/");

                    $url = $url_crm_administrativo . "/?ng=upload/save-upload-file-tickets";

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => $url,
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 60,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => $payload,
                        CURLOPT_HTTPHEADER => array(
                            'Content-Type: application/json',
                        //     'Cookie: PHPSESSID=sq9g3pbr3mp9u25utfm4dafc6o; ib_at=0von5bnrycxlj3f6muah1; tplsub=default'
                        ),
                    ));

                    $response = curl_exec($curl);
                    curl_close($curl);

                    //echo $response; exit;

                    // Decodificar la respuesta JSON
                    $result = json_decode($response, true);
        
                    // Verificar si existe 'type' y si es 'error'
                    if (isset($result['type']) && $result['type'] === 'error') {
                        // Mostrar el mensaje de error
                        //echo "Error: " . htmlspecialchars($result['message'] ?? 'Mensaje no disponible');

                        $menssage = "The entire process was completed, but the images/document could not be uploaded. Details: " . $result['message'];

                        $ret_val = [
                            "success" => "No",
                            "msg" => htmlspecialchars($menssage),
                            "otros" => $response 
                        ];
                        
                        return $ret_val;

                    } 
                } 

            }
 
            $salida = [
                "db"                           => $_SESSION['db_crm_administrative_for_cliente'], 
                "UUID"                         => $UUID,
                "message"                      => "A new ticket has been created", 
            ];

            emitInformationSocket($salida, "new-ticket-notification");

 
            $admin_view_link = U . 'tickets/admin/view/' . $d->id;

            if (
                isset($config['create_task_from_ticket']) &&
                $config['create_task_from_ticket'] == 1
            ) {
                Tasks::create([
                    'title' => $tid,
                    'description' => $message,
                    'cid' => $cid,
                    'priority' => $urgency,
                    'rel_type' => 'Ticket',
                    'rel_id' => $ticket_id,
                    'tid' => $ticket_id,
                ]);
            }

            if($mysqli != null)
            {
                $mysqli->close();
            }

            $ret_val = [
                "success" => "Yes",
                "msg" => "Ticket Created Successfully",
                "account" => $account,
                "email" => $email,
                "subject" => $subject,
                "body" => $message,
                "id" => $ticket_id,
                "tid" => $tid,
                "urgency" => $urgency,
            ];

            $eml = ORM::for_table('sys_email_templates')
                ->where('tplname', 'Tickets:Client Ticket Created')
                ->where('send', 'Yes')
                ->first();
            if ($eml) {
                $client_view_link = U . 'client/tickets/view/' . $d->tid . '/';

                $eml_subject = new Template($eml->subject);
                $eml_subject->set('business_name', $config['CompanyName']);
                $eml_subject->set('subject', $subject);
                $eml_subject->set('ticket_subject', $subject);
                $subj = $eml_subject->output();

                $eml_message = new Template($eml->message);
                $eml_message->set('client_name', $account);
                $eml_message->set('client_email', $email);
                $eml_message->set('priority', $urgency);
                $eml_message->set('urgency', $urgency);
                $eml_message->set('subject', $subject);
                $eml_message->set('subject', $subject);
                $eml_message->set('ticket_subject', $subject);
                $eml_message->set('status', $urgency);
                $eml_message->set('ticket_status', $d->status);
                $eml_message->set('ticket_urgency', $urgency);
                $eml_message->set('ticket_priority', $urgency);
                $eml_message->set('ticket_id', '#' . $tid);
                $eml_message->set('message', $message);
                $eml_message->set('business_name', $config['CompanyName']);
                $eml_message->set('ticket_link', $client_view_link);
                $message_o = $eml_message->output();

                if ($send_email) {
                }
            }

            $eml = ORM::for_table('sys_email_templates')
                ->where('tplname', 'Tickets:Admin Ticket Created')
                ->where('send', 'Yes')
                ->first();

            if ($eml) {
                $eml_subject = new Template($eml->subject);
                $eml_subject->set('business_name', $config['CompanyName']);
                $eml_subject->set('subject', $subject);
                $eml_subject->set('ticket_subject', $subject);
                $subj = $eml_subject->output();

                $eml_message = new Template($eml->message);
                $eml_message->set('client_name', $account);
                $eml_message->set('client_email', $email);
                $eml_message->set('priority', $urgency);
                $eml_message->set('urgency', $urgency);
                $eml_message->set('status', $urgency);
                $eml_message->set('ticket_status', $d->status);
                $eml_message->set('ticket_urgency', $urgency);
                $eml_message->set('ticket_priority', $urgency);
                $eml_message->set('ticket_id', '#' . $tid);
                $eml_message->set('message', $message);
                $eml_message->set('business_name', $config['CompanyName']);
                $eml_message->set('admin_view_link', $admin_view_link);
                $message_o = $eml_message->output();

                $users = User::all();

                foreach ($users as $user) {
                    if ($user->email_notify) {
                    }
                }
            }

            $staffs = User::all();

            $sms_message =
                $account .
                ' | ' .
                $subject .
                '. ' .
                $_L['View'] .
                ': ' .
                $admin_view_link;

            foreach ($staffs as $staff) {
                if (
                    $staff->sms_notify &&
                    $staff->phonenumber != '' &&
                    has_access($staff->roleid, 'support', 'view')
                ) {
                    spSendSMS($staff->phonenumber, $sms_message);
                }
            }

            if (
                isset($config['ticket_create_task_automatically']) &&
                $config['ticket_create_task_automatically'] == 1
            ) {
                $data['aid'] = $admin;

                $user = User::find($admin);

                if ($user) {
                    $data['created_by'] = $user->fullname;
                }

                $task = Tasks::create($data);
            }

            Event::trigger('tickets/created/', $ret_val);
        } else {
            $ret_val = [
                "success" => "No",
                "msg" => $msg,
            ];
        }

        return $ret_val;
    }

    public static function gen_link_attachments($attachments)
    {
        $html = '';

        $a = explode(',', $attachments);

        foreach ($a as $l) {
            $html .=
                '<img src="' .
                APP_URL .
                '/storage/tickets/' .
                $l .
                '" class="img-thumbnail" alt="Cinque Terre" width="300"> ';
        }

        return $html;
    }

    public static function gen_link_attachments_v1($attachments)
    {
        $html = '<div style=" text-align: center; ">';

        $a = explode(',', $attachments);

        foreach ($a as $l) {
            
            $html .= '<div style=" text-align: center; ">';

            $html .= '<div style=" text-align: center; ">';
            $html .=
                '<img src="' 
                .
                $l 
                .
                '" class="img-thumbnail" alt="Cinque Terre" width="300"> ';

            $html .= '</div>';

            $html .= '<a class="btn btn-sm btn-dowload-style waves-effect waves-themed"  href="' . $l . '" target="_blank" download="check.PNG"><i class="fas fa-download tamano-icono" aria-hidden="true"></i></a>';


            $html .= '</div>';

        }

        $html .= '</div>';

        return $html;
    }

    public function add_reply($admin = 0, $sendEmail = true)
    {

        $mysqli = null;

        try {
            $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
            $mysqli->set_charset("utf8");
        } catch (\Exception  $e) {
            //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
            //$response = array(
            //    "type" => "error",
            //    "message" => "Database connection failed",
            //    "data" => [],
            //);
            //print_r(json_encode( $response)) ; exit;

            $ret_val = [
                "success" => "No",
                "msg" => "Database connection failed",
            ];

            return $ret_val;
        }
        
        global $config;
        global $_L;
        $msg = '';
        $is_admin = false;

        $ib_now = date('Y-m-d H:i:s');

        $tid = _post('f_tid');

        $ret_val = [
            "success" => "No",
        ];

        $account = '';
        $email = '';
        $last_reply = false;
        $replied_by = '';
        $reply_type = _post('reply_type', 'Public');

        $message = ib_post('message');
        if ($message == '') {
            $msg .= 'Message is required. <br>';
        }

        $t = ORM::for_table('sys_tickets')->find($tid);
        if ($t) {
            $t->updated_at = $ib_now;

            $t->save();

            $cid = $t->userid;
        } else {

            $ret_val = [
                "success" => "No",
                "msg" => "The ticket identifier was not found",
            ];

            return $ret_val;
            //$cid = 0;
        }

        $adm = ORM::for_table('sys_users')->find($admin);

        if ($adm) {
            $is_admin = true;
            $email = $t->email;
            $account = $t->account;
            $replied_by = $adm->fullname;

            $last_reply = $adm->fullname;
            $reply_account = $adm->fullname;
            $reply_email = $adm->email;
        } else {
            $d = ORM::for_table('sys_ticketdepartments')->find($t->did);

            $email = $d->email;
            $account = '';

            $reply_account = $t->account;
            $reply_email = $t->email;
            $last_reply = $t->account;
        }

        if ($msg == '') {

            $dataCRMPartnerAdmins = ORM::get_db()->query("SELECT `value` FROM `sys_appconfig` WHERE setting = 'crm_partnert_administrativo' ")->fetch(PDO::FETCH_ASSOC);

            $crm_partnert_administrativo = 2;

            if(!empty($dataCRMPartnerAdmins))
            {
                $crm_partnert_administrativo = $dataCRMPartnerAdmins["value"];
            }



            //que sea api publica para poder gurdar imagen
            $attachments_backend      = "";
            
            $tid_                     = _post('f_tid');

            $url_crm_administrativo   = _post('url_crm_administrativo');
            $arrayImageSticketReplies = _post('arrayImageSticketReplies');
            //$arrayImageSticketReplies = $data['arrayImageSticketReplies'];

            //echo $arrayImageSticketReplies; exit;

            if(!empty($arrayImageSticketReplies))
            {
                $arrayImageSticketReplies = json_decode($arrayImageSticketReplies, true);  // true = array asociativo

                //echo $arrayImageSticketReplies; exit;

                if(is_array($arrayImageSticketReplies))
                {
                    if(count($arrayImageSticketReplies) > 0)
                    {
                        //echo "llegue xd"; exit;

                        //--------------------------------
                        $data = [
                            //"url_crm_admin"            => "https://itgrahnpro.xhde365.net",
                            "url_crm_admin"              => $url_crm_administrativo,
                            "ticket_id"                  => $tid_,
                            "arregloArchivos"            => $arrayImageSticketReplies,
                        ];
                
                        $payload = json_encode($data);

                        //echo $payload; exit;

                        $url_crm_administrativo = rtrim($url_crm_administrativo, "/");

                        $url = $url_crm_administrativo . "/?ng=upload/save-upload-file-tickets-reply";

                        $curl = curl_init();
                        curl_setopt_array($curl, array(
                            CURLOPT_URL => $url,
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => '',
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 60,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => 'POST',
                            CURLOPT_POSTFIELDS => $payload,
                            CURLOPT_HTTPHEADER => array(
                                'Content-Type: application/json',
                            //     'Cookie: PHPSESSID=sq9g3pbr3mp9u25utfm4dafc6o; ib_at=0von5bnrycxlj3f6muah1; tplsub=default'
                            ),
                        ));

                        $response = curl_exec($curl);
                        curl_close($curl);

                        //echo $response; exit;

                        // Decodificar la respuesta JSON
                        $result = json_decode($response, true);
                
                        //echo $response; exit;

                        // Verificar si existe 'type' y si es 'error'
                        if (isset($result['type']) && $result['type'] === 'error') {
                            // Mostrar el mensaje de error
                            //echo "Error: " . htmlspecialchars($result['message'] ?? 'Mensaje no disponible');

                            $menssage = "Error uploading image, for more details: " . $result['message'];

                            $ret_val = [
                                "success" => "No",
                                "msg" => $menssage,
                            ];
                            
                            return $ret_val;
                        } 

                        $attachments_backend = $result["arraySeparateByComma"];
                    }

                }
            }

            //echo "llegamos aqui: " . $attachments_backend; exit;
 
            //------------------------------------------

            $sys_ticketreplies_id = null;

            $UUID = generateUUIDv4_especialv1();

            //echo $crm_partnert_administrativo; exit;

            //caso de que sea administrador
            if($crm_partnert_administrativo == 1)
            {

                //$who_sent = "CRM Administrative";
                $who_sent = 1;

                /* $d = ORM::for_table('sys_ticketreplies')->create();
                $d->tid         = $tid;
                $d->userid      = $cid;
                $d->account     = $reply_account;
                $d->reply_type  = $reply_type;
                $d->email       = $reply_email;
                $d->created_at  = $ib_now;
                $d->updated_at  = $ib_now;
                $d->message     = $message;
                $d->replied_by  = $last_reply;
                $d->admin       = $admin;
                $d->attachments = ib_post('attachments');
                $d->client_read = '';
                $d->admin_read  = '';
                $d->UUID        = $UUID;
                $d->who_sent    = $who_sent;
                $d->save();

                $sys_ticketreplies_id = $d->id(); */

                $dataRegister = [
                    "tid"               =>  $tid,
                    "tid_crm_admin"     =>  null, //despues se lo asigamos
                    "id_cliente_crm"    =>  $t->userid,
                    "userid"            =>  $cid,
                    "account"           =>  $reply_account,
                    "reply_type"        =>  $reply_type,
                    "email"             =>  $reply_email,
                    "created_at"        =>  $ib_now,
                    "updated_at"        =>  $ib_now,
                    "message"           =>  $message,
                    "replied_by"        =>  $last_reply,
                    "admin"             =>  $admin,
                    //"attachments"       =>  ib_post('attachments'),
                    "attachments"       =>  $attachments_backend,
                    "client_read"       =>  '',
                    "admin_read"        =>  '',
                    "type_accion"       =>  'crm_admin_to_send_client',
                    "UUID"              => $UUID,
                    "who_sent"          => $who_sent,
                ];

                $tid_crm_admin = null;

                try {
                    
                    //creacion de registro para asignacion de id
                    $sql = "INSERT INTO `sys_ticketreplies`(
                                `tid`,
                                `userid`,
                                `account`,
                                `reply_type`,
                                `email`,
                                `created_at`,
                                `updated_at`,
                                `message`,
                                `replied_by`,
                                `admin`,
                                `attachments`,
                                `client_read`,
                                `admin_read`,
                                `UUID`,
                                `who_sent`
                        )
                        VALUES(
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?
                        )";
                    
                    $stmt = $mysqli->prepare($sql);
    
                    $stmt->bind_param(
                        'sssssssssssssss',
                        $dataRegister["tid"],
                        $dataRegister["userid"],
                        $dataRegister["account"],
                        $dataRegister["reply_type"],
                        $dataRegister["email"],
                        $dataRegister["created_at"],
                        $dataRegister["updated_at"],
                        $dataRegister["message"],
                        $dataRegister["replied_by"],
                        $dataRegister["admin"],
                        $dataRegister["attachments"],
                        $dataRegister["client_read"],
                        $dataRegister["admin_read"],
                        $dataRegister["UUID"],
                        $dataRegister["who_sent"],
                    );
                    
                    $stmt->execute();
                    $tid_crm_admin = $mysqli->insert_id;
                    //$ticket_id = $sys_tickets_id;
                    $dataRegister["tid_crm_admin"] = $tid_crm_admin; 
                    $stmt->close();
                    //-----------

                } catch (\Exception  $e) {
      
                    $ret_val = [
                        "success" => "No",
                        "msg" => "Error: " . $e->getMessage(),
                    ];

                    return $ret_val;
                }

                $reply_type_cp =  $reply_type; 

                if(strtolower($reply_type_cp) == "public")
                {
                    $response = insertTicketsReplies($dataRegister);

                    if($response["type"] == "error" )
                    {
                        $ret_val = [
                            "success" => "No",
                            "msg" => $response["message"],
                        ];
                        return $ret_val;
                    }
                }

                //echo json_encode($response); exit;
                //echo "llegmaos hasta abajo"; 
                //exit;
                

            }else{
                 

                //echo "que paso"; exit;
                //$who_sent = "CRM Client";
                $who_sent = 2;

                $dataRegister = [
                    "tid"                       =>  $tid,
                    "tid_crm_admin"             =>  null, //despues se lo asigamos
                    "crm_admin_sys_tickets_id"  =>  $t->crm_admin_sys_tickets_id, //despues se lo asigamos
                    "id_cliente_crm"            =>  $t->userid,
                    "userid"                    =>  $cid,
                    "account"                   =>  $reply_account,
                    "reply_type"                =>  $reply_type,
                    "email"                     =>  $reply_email,
                    "created_at"                =>  $ib_now,
                    "updated_at"                =>  $ib_now,
                    "message"                   =>  $message,
                    "replied_by"                =>  $last_reply,
                    "admin"                     =>  $admin,
                    //"attachments"               =>  ib_post('attachments'),
                    "attachments"               =>  $attachments_backend,
                    "client_read"               =>  '',
                    "admin_read"                =>  '',
                    "type_accion"               =>  'client_to_send_crm_admin',
                    "UUID"                      => $UUID,
                    "who_sent"                  => $who_sent,
                ];
                
                $reply_type_cp =  $reply_type; 

                $tid_crm_admin_id = null;

                if(strtolower($reply_type_cp) == "public")
                {

                    $response = insertTicketsReplies($dataRegister);

                    //echo json_encode($response);

                    if($response["type"] == "error" )
                    {
                        $ret_val = [
                            "success" => "No",
                            "msg" => $response["message"],
                        ];
                        return $ret_val;
                    }

                    $tid_crm_admin_id = $response["tid_crm_admin_id"];


                }
                //--------------------------------------------------------------

                try {
                    //creacion de registro para asignacion de id
                    $sql = "INSERT INTO `sys_ticketreplies`(
                                `tid_crm_admin`,
                                `tid`,
                                `userid`,
                                `account`,
                                `reply_type`,
                                `email`,
                                `created_at`,
                                `updated_at`,
                                `message`,
                                `replied_by`,
                                `admin`,
                                `attachments`,
                                `client_read`,
                                `admin_read`,
                                `UUID`,
                                `who_sent`
                        )
                        VALUES(
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?,
                            ?
                        )";
                    
                    $stmt = $mysqli->prepare($sql);
    
                    $stmt->bind_param(
                        'ssssssssssssssss',
                        $tid_crm_admin_id,
                        $dataRegister["tid"],
                        $dataRegister["userid"],
                        $dataRegister["account"],
                        $dataRegister["reply_type"],
                        $dataRegister["email"],
                        $dataRegister["created_at"],
                        $dataRegister["updated_at"],
                        $dataRegister["message"],
                        $dataRegister["replied_by"],
                        $dataRegister["admin"],
                        $dataRegister["attachments"],
                        $dataRegister["client_read"],
                        $dataRegister["admin_read"],
                        $dataRegister["UUID"],
                        $dataRegister["who_sent"],
                    );
                    
                    $stmt->execute();
                    //$tid_crm_admin = $mysqli->insert_id;
                    //$ticket_id = $sys_tickets_id;
                    //$dataRegister["tid_crm_admin"] = $tid_crm_admin; 
                    $stmt->close();
                    //-----------

                } catch (\Exception  $e) {
      
                    $ret_val = [
                        "success" => "No",
                        "msg" => "Error: " . $e->getMessage(),
                    ];

                    return $ret_val;
                }


                //echo json_encode($response); exit;


            }
                
            /* $d = ORM::for_table('sys_ticketreplies')->create();
            $d->tid = $tid;
            $d->userid = $cid;
            $d->account = $reply_account;
            $d->reply_type = $reply_type;
            $d->email = $reply_email;
            $d->created_at = $ib_now;
            $d->updated_at = $ib_now;
            $d->message = $message;
            $d->replied_by = $last_reply;
            $d->admin = $admin;
            $d->attachments = ib_post('attachments');
            $d->client_read = '';
            $d->admin_read = '';
            $d->save(); */

            if($mysqli != null)
            {
                $mysqli->close();
            }

            $ret_val = [
                "success" => "Yes",
                "msg"     => "Ticket Updated Successfully",
                "id"      => $sys_ticketreplies_id,
                "tid"     => $tid,
            ];

            if ($sendEmail) {
                if ($is_admin) {
                    $eml = ORM::for_table('sys_email_templates')
                        ->where('tplname', 'Tickets:Admin Response')
                        ->where('send', 'Yes')
                        ->first();

                    $email = $t->email;

                    if ($eml) {
                        $client_view_link =
                            U . 'client/tickets/view/' . $t->tid . '/';

                        $eml_subject = new Template($eml->subject);
                        $eml_subject->set(
                            'business_name',
                            $config['CompanyName']
                        );
                        $eml_subject->set('subject', $t->subject);
                        $eml_subject->set('ticket_subject', $t->subject);
                        $subj = $eml_subject->output();

                        $eml_message = new Template($eml->message);
                        $eml_message->set('client_name', $account);
                        $eml_message->set('client_email', $email);
                        $eml_message->set('priority', $t->urgency);
                        $eml_message->set('urgency', $t->urgency);
                        $eml_message->set('ticket_subject', $t->subject);
                        $eml_message->set('status', $t->urgency);
                        $eml_message->set('ticket_status', $t->status);
                        $eml_message->set('ticket_urgency', $t->urgency);
                        $eml_message->set('ticket_priority', $t->urgency);
                        $eml_message->set('ticket_id', $t->tid);
                        $eml_message->set('ticket_message', $message);
                        $eml_message->set(
                            'business_name',
                            $config['CompanyName']
                        );
                        $eml_message->set('ticket_link', $client_view_link);
                        $message_o = $eml_message->output();

                        if ($reply_type !== 'internal') {
                            Email::sendEmail(
                                $config,
                                $_L,
                                $t->account,
                                $email,
                                $subj,
                                $message_o,
                                $cid
                            );
                        }
                    }
                } else {
                    $eml = ORM::for_table('sys_email_templates')
                        ->where('tplname', 'Tickets:Client Response')
                        ->where('send', 'Yes')
                        ->first();

                    if (APP_STAGE == 'Dev') {
                        Logger::write('Sending email to admin.');
                    }

                    if ($eml) {
                        if (APP_STAGE == 'Dev') {
                            Logger::write('Sending email to admin..');
                        }

                        $client_view_link =
                            U . 'client/tickets/view/' . $t->tid . '/';

                        $ticket_link = U . 'tickets/admin/view/' . $t->id;

                        $eml_subject = new Template($eml->subject);
                        $eml_subject->set(
                            'business_name',
                            $config['CompanyName']
                        );
                        $eml_subject->set('subject', $t->subject);
                        $eml_subject->set('ticket_subject', $t->subject);
                        $subj = $eml_subject->output();

                        $eml_message = new Template($eml->message);
                        $eml_message->set('client_name', $account);
                        $eml_message->set('client_email', $email);
                        $eml_message->set('priority', $t->urgency);
                        $eml_message->set('urgency', $t->urgency);
                        $eml_message->set('ticket_subject', $t->subject);
                        $eml_message->set('status', $t->urgency);
                        $eml_message->set('ticket_status', $t->status);
                        $eml_message->set('ticket_urgency', $t->urgency);
                        $eml_message->set('ticket_priority', $t->urgency);
                        $eml_message->set('ticket_id', $t->tid);
                        $eml_message->set('ticket_message', $message);
                        $eml_message->set(
                            'business_name',
                            $config['CompanyName']
                        );
                        $eml_message->set('ticket_link', $ticket_link);
                        $message_o = $eml_message->output();

                        $users = User::all();

                        foreach ($users as $user) {
                            if ($user->email_notify) {
                                Email::sendEmail(
                                    $config,
                                    $_L,
                                    '',
                                    $user->username,
                                    $subj,
                                    $message_o,
                                    $cid
                                );
                            }
                        }
                    }
                }
            }
        } else {
            $ret_val = [
                "success" => "No",
                "msg" => $msg,
            ];
        }

        return $ret_val;
    }

    public static function addPredefinedReply($data = [])
    {
        $msg = '';

        $id = '';

        $success = 'No';

        if (!isset($data['title']) || $data['title'] == '') {
            $msg .= 'Title is required. <br>';
        }

        if (!isset($data['message']) || $data['message'] == '') {
            $msg .= 'Message is required. <br>';
        }

        if ($msg == '') {
            $d = ORM::for_table('sys_canned_responses')->create();

            $d->title = $data['title'];
            $d->message = $data['message'];
            $d->save();

            $success = 'Yes';

            $id = $d->id();

            $msg = 'Added Successfully';
        }

        return [
            "success" => $success,
            "msg" => $msg,
            "id" => $id,
        ];
    }

    public static function deletePredefinedReply($id)
    {
        $d = ORM::for_table('sys_canned_responses')->find($id);

        if ($d) {
            $d->delete();

            return true;
        }

        return false;
    }

    public static function departments()
    {
        return ORM::for_table('sys_ticketdepartments')
            ->select('dname', 'value')
            ->find_array();
    }
}
