<?php
/*
|--------------------------------------------------------------------------
| Controller
|--------------------------------------------------------------------------
|
*/

_auth();

$ui->assign('_title', $_L['Dashboard'] . '- ' . $config['CompanyName']);
$user = User::_info();
$ui->assign('user', $user);

$ui->assign('base_datos_para_socket', DB_NAME);
$ui->assign('config_whatsapp_other_id_para_socket', empty($user["config_whatsapp_other_id"]) == true ? "No_existe" : $user["config_whatsapp_other_id"] );
$ui->assign('url_ir_chat_empleado', U . "social/social-chat-employee");
$ui->assign('url_ir_chat_admin', U . "social/social-chat");

$ui->assign('url_ir_chat_crm', U . "social/chat-crm");
$ui->assign('url_base_plantilla_admintpl', U);
$ui->assign('APP_URL_ORIGINAL_SOCKET', APP_URL_ORIGINAL_SOCKET);
$ui->assign('url_setting_CRM_Parnerts_prepared', url_setting_CRM_Parnerts_prepared);

$ui->assign('db_crm_administrative', getDBCRMAdministrative());
$ui->assign('url_origen', U);

$ruta_segundaria = route(1);
$armado_ruta = "";
$ui->assign('ws_nombre_socket', ws_nombre_socket);
if(empty($ruta_segundaria) == true )
{
    $armado_ruta = route(0);
}else{
    $armado_ruta = route(0) . "/" . route(1);
}

//$ui->assign('sin_ruta', $armado_ruta);
$ui->assign('sin_ruta', _get('ng'));


if(empty($_SESSION['menu_categorias_user']) == false)
{
    $ui->assign('menu_categorias_user', $_SESSION['menu_categorias_user']);
}

$action = route(1, 'view');

switch ($action) {
    case 'view':
        break;

    case 'update_picture':
        $upload = Upload::factory('storage/temp');
        $upload->file($_FILES['file']);

        //set max. file size (in mb)
        $upload->set_max_file_size(5);

        //set allowed mime types
        $upload->set_allowed_mime_types([
            'image/jpg',
            'image/png',
            'image/gif',
            'image/jpeg',
        ]);

        $results = $upload->upload();

        $file_name = $user->id . '_' . md5(time());

        $img = Image::make($results['full_path']);

        $img->resize(null, 100, function ($constraint) {
            $constraint->aspectRatio();
        })->save('storage/admins/' . $file_name . '_md.png');

        $img->resize(null, 36, function ($constraint) {
            $constraint->aspectRatio();
        })->save('storage/admins/' . $file_name . '_sm.png');

        $user->img = $file_name;
        $user->save();

        echo $user->id;

        break;

    case 'get_img_from_url':
        $file_name = $user->id . '_' . md5(time());

        $url = _post('url');

        $img = Image::make($url);

        $img->resize(null, 100, function ($constraint) {
            $constraint->aspectRatio();
        })->save('storage/admins/' . $file_name . '_md.png');

        $img->resize(null, 36, function ($constraint) {
            $constraint->aspectRatio();
        })->save('storage/admins/' . $file_name . '_sm.png');

        $user->img = $file_name;
        $user->save();

        echo $user->id;

        break;

    case 'update_admin':
        $request = Request::createFromGlobals()->request;

        $v = new V($request->all());

        $v->rule('required', ['fullname']);

        $u = User::find($user->id);

        if ($v->validate()) {
            $u->fullname = $request->get('fullname');
            $u->phonenumber = $request->get('phonenumber');
            $u->notes = $request->get('notes');

            $u->save();

            echo $u->id;
        } else {
            api_response($v->errors());
        }

        break;

    case 'update_password':
        $request = Request::createFromGlobals()->request;

        $v = new V($request->all());

        $v->rule('required', ['password1', 'password2']);
        $v->rule('lengthMin', 'password1', 6);
        $v->rule('equals', 'password1', 'password2');

        $u = User::find($user->id);

        if ($v->validate()) {
            $u->password = Password::_crypt(trim($request->get('password')));

            $u->save();

            echo $u->id;
        } else {
            api_response($v->errors());
        }

        break;
}
