{extends file="$layouts_admin"}


{block name="head"}


    <style>

        .btn-default {
            color: #333;
            background-color: #fff;
            border-color: #ccc;
        }

        .btn-default:hover, .btn-default:focus, .btn-default:active, .btn-default.active {
            color: #333;
            background-color: #fff;
            border-color: #ccc;
        }

        {if $pos eq 'pos'}
        .pos_item {

        {if $config['nstyle'] == 'dark_mode'}
            background: #182138;
        {else}
            background: #f3f6f9;
        {/if}


            cursor: pointer;
        }

        .pos_item:hover {
            background: #2196f3;
            color: #ffffff;
        }



        {/if}

    </style>
{/block}


{block name="content"}

    <form id="invform" method="post">

        <div class="row" id="ibox_form">



            <div class="alert alert-danger" id="emsg" style="display: none;">
                <span id="emsgbody"></span>
            </div>

            <div class="col-md-12">


                <div class="panel">

                    <div class="panel-hdr">
                        <h2>
                            Invoice
                        </h2>
                        <div class="panel-toolbar">

                           <!-- <div class="btn-group">
                                <button class="btn btn-sm btn-primary" id="submit"> {$_L['Save']}</button>
                                <button class="btn btn-sm btn-info"
                                        id="save_n_close"> {$_L['Save n Close']}</button>
                            </div>-->
                        </div>
                    </div>

                    <div class="panel-container">
                        <div class="panel-content">


                            <div class="table-responsive">

                                <table id="clx_datatable" class="table table-striped w-100 sys_table footable">
                                    <thead style="background: #f0f2ff">
                                    <tr>
                                        <th>#</th>
                                        <th>Creation date</th>
                                        <th>Date from</th>
                                        <th>Date until</th>
                                        <th>Payment type</th>
                                        <th>Total Paid</th>
                                        <th>Payment status</th>
                                        <th>Client</th>
                                        <th class="text-end" width="140px;">Manage</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    {foreach $data as $ds}
                                        <tr>
                                            <td data-value="{$ds['factura_maestra_id']}" data-order="{$ds@iteration}"><a href="{$_url}system/view/{$ds['factura_maestra_id']}/">{$ds['factura_maestra_id']}</a></td>
                                            <td>
                                                {$ds['fecha']}
                                            </td>
                                            <td>
                                                {$ds['periodo_desde']}
                                            </td>

                                            <td>
                                                {$ds['periodo_hasta']}
                                            </td>

                                            <td>
                                                 
                                                {if ($ds['forma_pago'] == 1)}
                                                     Payment per user
                                                {/if}

                                                {if ($ds['forma_pago'] == 2)}
                                                     Payment per month
                                                {/if}
                                            </td>

                                            <td>
                                               
                                                {number_format($ds['total'], 2, '.', ',')}
                                            </td>
 
                                            <td>

                                                {if $ds['estado_pago'] eq '1'}
                                                    <span class="badge badge-outline badge-outline-warning">Earring</span>
                                                {elseif $ds['estado_pago'] eq '2'}
                                                    <span class="badge badge-outline badge-outline-success">Paid</span>
                                                {/if}

                                            </td>

                                            <td>
                                              {$ds['cliente']}
                                            </td>
 
                                            <td class="text-end">


                                                <div class="btn-group">
                                                    <a href="{$_url}system/pay/{$ds['factura_maestra_id']}/" class="btn btn-success btn-icon" data-bs-toggle="tooltip" data-placement="top" title="Pay"><i class="fal fa-money-bill-alt"></i></a>
                                                    <a href="{$_url}system/view/{$ds['factura_maestra_id']}/" class="btn btn-primary btn-icon" data-bs-toggle="tooltip" data-placement="top" title="{$_L['View']}"><i class="fal fa-file-alt"></i></a>
                                                </div>


                                            </td>
                                        </tr>
                                    {/foreach}

                                    </tbody>



                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <input type="hidden" name="document_type" value="{{$action}}">

    </form>

    {* lan variables *}
    <input type="hidden" id="_lan_set_discount" value="{$_L['Set Discount']}">
    <input type="hidden" id="_lan_discount" value="{$_L['Discount']}">
    <input type="hidden" id="_lan_discount_type" value="{$_L['Discount Type']}">
    <input type="hidden" id="_lan_percentage" value="{$_L['Percentage']}">
    <input type="hidden" id="_lan_fixed_amount" value="{$_L['Fixed Amount']}">
    <input type="hidden" id="_lan_btn_save" value="{$_L['Save']}">
    <input type="hidden" id="_lan_no_results_found" value="{$_L['No results found']}">
{/block}


{block name="script"}

    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.2/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.2/js/buttons.html5.min.js"></script>


    <script>
        $(function () {

            var $modal = $('#cloudonex_body');

            $('#clx_datatable').dataTable(
                {
                    responsive: true,
                    lengthChange: false,
                    dom:
                    /*	--- Layout Structure
                        --- Options
                        l	-	length changing input control
                        f	-	filtering input
                        t	-	The table!
                        i	-	Table information summary
                        p	-	pagination control
                        r	-	processing display element
                        B	-	buttons
                        R	-	ColReorder
                        S	-	Select

                        --- Markup
                        < and >				- div element
                        <"class" and >		- div with a class
                        <"#id" and >		- div with an ID
                        <"#id.class" and >	- div with an ID and a class

                        --- Further reading
                        https://datatables.net/reference/option/dom
                        --------------------------------------
                     */
                        "<'row mb-3'<'col-sm-12 col-md-6 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-6 d-flex align-items-center justify-content-end'lB>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                    buttons: [
                        /*{
                            extend:    'colvis',
                            text:      'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'mr-sm-3'
                        },*/
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            titleAttr: 'Generate PDF',
                            className: 'btn-danger btn-sm mr-1'
                        },
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            titleAttr: 'Generate Excel',
                            className: 'btn-success btn-sm mr-1'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-primary btn-sm mr-1'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-warning btn-sm mr-1'
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            titleAttr: 'Print Table',
                            className: 'btn-secondary btn-sm'
                        }
                    ],
                    "language": {
                        "emptyTable": "{$_L['No items to display']}",
                        "info":      "{$_L['Showing _START_ to _END_ of _TOTAL_ entries']}",
                        "infoEmpty":      "{$_L['Showing 0 to 0 of 0 entries']}",
                        buttons: {
                            pageLength: '{$_L['Show all']}'
                        },
                        searchPlaceholder: "{__('Search')}"
                    },
                }
            );

 
        });
    </script>

{/block}
