{extends file="$layouts_admin"}
{block name="head"}

   <link href="{$theme}default/css/whatsapp.css?v={$config['version']}" rel="stylesheet">

   <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet" />
 
{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    
 
    .nuevo_control{
        min-height: calc(1.47em + .75rem + 2px);
        padding: .375rem .844rem;
        font-size: .75rem;
        border-radius: 8px;
    }

    .list-group {
        max-height: 200px; /* Altura máxima para activar el desplazamiento */
        overflow-y: auto; /* Habilita el desplazamiento vertical */
        overflow-x: hidden; /* Desactiva el desplazamiento horizontal */
        position: relative; /* Para posicionar las flechas */
        width: 100%; /* Asegura que ocupe todo el ancho disponible */
        box-sizing: border-box; /* Incluye padding y border en el cálculo del ancho */
    }

    /* Estilo del scrollbar en WebKit (Chrome, Safari, Edge) */
    .list-group::-webkit-scrollbar {
        width: 12px; /* Ancho del scrollbar */
        background-color: #f1f1f1; /* Fondo claro como en la imagen */
    }

    .list-group::-webkit-scrollbar-thumb {
        background-color: #555; /* Color del thumb (deslizador), gris oscuro */
        border-radius: 6px; /* Bordes redondeados */
    }

    .list-group::-webkit-scrollbar-thumb:hover {
        background-color: #444; /* Cambio de color al pasar el mouse */
    }

    .list-group::-webkit-scrollbar-track {
        background: #f1f1f1; /* Fondo del track */
    }

    /* Compatibilidad con Firefox */
    .list-group {
        scrollbar-width: thin; /* Ancho del scrollbar en Firefox */
        scrollbar-color: #555 #f1f1f1; /* Color del thumb y track en Firefox */
    }

    /* Evitar desbordamiento horizontal */
    .list-group-item {
        word-break: break-word; /* Rompe palabras largas */
        overflow-wrap: break-word; /* Compatibilidad adicional */
        white-space: normal; /* Permite ajuste de texto */
    }

 

</style>

<input
         type="text"
         value="{$url_base}"
         disabled
         hidden
         id="URL_BASE"
      />

      <input
         type="text"
         value="{$imagen_perfil}"
         disabled
         hidden
         id="IMAGEN_PERFIL"
      />

      <input
         type="text"
         value="{$img_nombre_perfil}"
         disabled
         hidden
         id="IMG_NOMBRE_PERFIL"
      />

      <input
         type="text"
         value="{$ruta_img}"
         disabled
         hidden
         id="RUTA_IMAGEN_PERFIL"
      />

      <input
         type="text"
         value="{$ruta_proyecto}"
         disabled
         hidden
         id="RUTA_PROYECTO"
      />

      <input
         type="text"
         value="{$DB_NAME}"
         disabled
         hidden
         id="DB_NAME"
      />

      <input
         type="text"
         value="{$id_user}"
         disabled
         hidden
         id="ID_USER"
      />

      <input
         type="text"
         value="{$APP_URL_ORIGINAL_SOCKET}"
         disabled
         hidden
         id="APP_URL_ORIGINAL_SOCKET"
      />

      <input type="text" disabled hidden class=" tener_path_img" value={$path_img} />

      <input type="text" id="url_modulo_api_direccion_smarty" name="url_modulo_api_direccion_smarty" class="form-control url_modulo_api_direccion_smarty" value="{$url_modulo_api_direccion_smarty}" disabled hidden >
      <input type="text" id="key_modulo_api_direccion_smarty" name="key_modulo_api_direccion_smarty" class="form-control key_modulo_api_direccion_smarty" value="{$key_modulo_api_direccion_smarty}" disabled hidden  >
      <input type="text" id="host_modulo_api_direccion_smarty" name="host_modulo_api_direccion_smarty" class="form-control host_modulo_api_direccion_smarty" value="{$host_modulo_api_direccion_smarty}" disabled hidden  >
      <input type="text" id="referer_modulo_api_direccion_smarty" name="referer_modulo_api_direccion_smarty" class="form-control referer_modulo_api_direccion_smarty" value="{$referer_modulo_api_direccion_smarty}" disabled hidden  >

 
      <input
         type="text"
         value="{$imagen_url_sms}"
         disabled
         hidden
         id="URL_IMAGEN_SMS"
      />
 
      <input
         type="text"
         value="{$imagen_url_whatsapp}"
         disabled
         hidden
         id="URL_IMAGEN_WHATSAPP"
      />

<div class="row">

    <div class="col-md-12">

       
        <div class="panel">
            <div class="panel-hdr">
                <h2 style="color: #666; font-weight: 600; "><span></span>List of conversations</h2>
                <input type="text" class=" tener_url_base" value={$url_base} disabled hidden/>
            </div>
                                                         
            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">

                    <div class="px-2">
                        
                        <div class="row contenedor" style="padding: 10px">

                           {* formulario *}
                            <div class="col-12 col-sm-6 pt-3">
                                <label for="estatus_conversacion"><span style="color:#666;">Conversation status</span> </label>
                                
                                <select
                                    class="form-select tener_estatus_conversacion nuevo_control"
                                    name="estatus_conversacion"
                                    id="estatus_conversacion"
                                    style="width: 100%"
                                    placeholder="Select a status"
                                >
                                    <option value="" >All</option>
                                    <option value="1" >Open</option>
                                    <option value="2" >Close</option>
                                </select>
                            </div>

                           {* formulario *}
                            <div class="col-12 col-sm-6 pt-3">
                                <label for="category_form"><span style="color:#666;">Conversation stage</span> </label>
                                
                                <select
                                    class="form-select nuevo_control tener_category_form"
                                    name="category_form"
                                    id="category_form"
                                    style="width: 100%"
                                    placeholder="Select a stage"
                                >
                                    <option value="" >All</option>
                                    {foreach $listado_etapas as $ds}
                                        <option value="{$ds['id']}" >{$ds['nombre_etapa']}</option>
                                    {/foreach}
                                </select>
                            </div>

                            {* Servicios de interes *}
                            <div class="col-12 col-sm-6 pt-3">
                                <label for="producto"><span style="color:#666;">Services of interest</span> </label>
                                
                                <select
                                    class="form-select nuevo_control tener_producto"
                                    name="producto"
                                    id="producto"
                                    style="width: 100%"
                                    placeholder="Select a stage"
                                >
                                    <option value="0" >All</option>
                                    {foreach $listado_productos as $ds}
                                        <option value="{$ds['id']}" >{$ds['name']}</option>
                                    {/foreach}
                                </select>
                            </div>

                            {* Assigned Agent *}
                            <div class="col-12 col-sm-6 pt-3">
                                <label for="staff"><span style="color:#666;">Assigned Agent</span> </label>
                                
                                <select
                                    class="form-select nuevo_control tener_staff"
                                    name="staff"
                                    id="staff"
                                    style="width: 100%"
                                    placeholder="Select a staff"
                                >
                                    <option value="0" >All</option>
                                    {foreach $listado_staff as $ds}
                                        <option value="{$ds['id']}" >{$ds['fullname']}</option>
                                    {/foreach}
                                </select>
                            </div>

                            <div class="col-12 col-sm-12 pt-3">
                                

                                 <div class="form-check mt-3"  >
                                     <input class="form-check-input check_fecha_propuesta   "   id="check_fecha_propuesta" type="checkbox"     />
                                     <label class="form-check-label  " for="check_fecha_propuesta"><span  >Enable filter Date proposed Next contact</span></label>
                                 </div>
                            </div>
 
                            {* fecha desde *}
                            <div class="col-12 col-sm-6 ">
                                <label for="fecha_desde"
                                    ><span style="color:#666;">Date From Proposed Next Contact</span>
                                </label>
                                <input
                                    type="date"
                                    id="fecha_desde"
                                    name="fecha_desde"
                                    class="form-control form-control-sm tener_fecha_desde"
                                />
                            </div>

                           {* fecha hasta *}
                            <div class="col-12 col-sm-6 ">
                                <label for="fecha_hasta"
                                    ><span style="color:#666;">Date Until proposed next contact</span>
                                </label>
                                <input
                                    type="date"
                                    id="fecha_hasta"
                                    name="fecha_hasta"
                                    class="form-control form-control-sm tener_fecha_hasta"
                                />
                            </div>
  

                            <div class="col-12 col-sm-12 pt-3">
                                
                                 <div class="form-check mt-3"  >
                                     <input class="form-check-input tiempo_abierto " id="tiempo_abierto" type="checkbox" />
                                     <label class="form-check-label  " for="tiempo_abierto"><span  >Enable open time dates filter</span></label>
                                 </div>
                            </div>

                            {* fecha desde *}
                            <div class="col-12 col-sm-6 ">
                                <label for="fecha_desde_tiempo_abierto"
                                    ><span style="color:#666;">Date from open time</span>
                                </label>
                                <input
                                    type="date"
                                    id="fecha_desde_tiempo_abierto"
                                    name="fecha_desde_tiempo_abierto"
                                    class="form-control form-control-sm tener_fecha_desde_tiempo_abierto"
                                    disabled
                                />
                            </div>
 
                            <div class="col-12 col-sm-6 ">
                                <label for="fecha_hasta_tiempo_abierto"
                                    ><span style="color:#666;">Date until open time</span>
                                </label>
                                <input
                                    type="date"
                                    id="fecha_hasta_tiempo_abierto"
                                    name="fecha_hasta_tiempo_abierto"
                                    class="form-control form-control-sm tener_fecha_hasta_tiempo_abierto"
                                    disabled
                                />
                            </div>

                            {* formulario *}
                            <div class="col-12 col-sm-12 pt-3">
                                <label for="configuracion_whatsapp_id"><span style="color:#666;">Whatsapp/SMS settings</span> </label>
                                
                                <select
                                    class="form-select nuevo_control tener_configuracion_whatsapp_id"
                                    name="configuracion_whatsapp_id"
                                    id="configuracion_whatsapp_id"
                                    style="width: 100%"
                                    placeholder="Select a option"
                                >
                                    <option value="" disabled selected>Select a option</option>
                                    {foreach $listado_configuracions as $ds}
                                        <option value="{$ds['id']}" >{$ds['identifier']} </option>
                                    {/foreach}
                                </select>
                            </div>
 
 
                            <div class="col-12 col-sm-12 pt-3">
                                <button
                                    type="button"
                                    class="btn btn-default"
                                    id="consultar_filtros"
                                    style="
                                        border-color: #d3cac0;
                                        border: 1px solid #d3cac0;
                                        float: right;
                                    "
                                >
                                    Search
                                </button>
                            </div>

 
                            <br />
                             
                            <div class="col-12 col-sm-12 pt-4">
                            
                                {* aqui empieza la parte de whatsapp *}

                                <div class="tile tile-alt" id="messages-main" >
                                    <div class="ms-menu" style="padding-bottom: 0px;">
                                   
                                        <div class="list-group lg-alt mi-bandeja-mensajes-contactos" style="border-radius:0px; max-height:100%">
                                             
                                         
                                        </div>
                                    </div>

                                    <div class="ms-body">
 
                                    <div class="action-header clearfix cargando_mensajes_chat_interno" style="padding: 8px; display: none;">
                                        <div class="d-flex justify-content-center align-items-center" style="gap: 10px;">
                                            {*
                                            <div class="spinner" style="font-size: 18px;">
                                                <i class="fa fa-circle-o-notch fa-spin"></i>
                                            </div>
                                            *}
                                            
                                            <span class="loader_ld me-4"></span>

                                            Loading messages...
                                        </div>
                                    </div>

 
                                    <!--Sin Mensajes-->
                                    <div class="sin_mensaje cuerpo_sin_mensajes">
                                        <div class="pintar_card"  style="border:none;box-shadow:none; -webkit-box-shadow: none;">
                                            <div class="pintar_body_card container">
                                                <h4 style="color:#082645">Let's start a conversation!</h4>


                                                {if $cantidad_cuentas_whatsapp eq "1"}

                                                <span style="color:#082645">
                                                    You don't have an account set up yet. To do so, go to
                                                </span>
                                                
                                                <a style="color:#082645" href="{$url_setting_CRM_Parnerts_prepared}" target="_blank"> Settings > Chat Settings. </a>
                                                
                                                {/if}

                                                <br />
                                                <img
                                                src="{{APP_URL}}/storage/system/{{$config['logo_default']}}"
                                                alt=""
                                                style="max-width: 100%; width: 213px;height: 152px"
                                                />


                                                <div style="width:100%; height:44px">
                                                
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!--CARGANDO CHAT-->
                                    <div
                                        class="sin_mensaje cuerpo_cargando_mensajes"
                                        style="display: none"
                                    >
                                        <div class="pintar_card" style="border:none;box-shadow:none; -webkit-box-shadow: none;">
                                            <div class="pintar_body_card container">
                                            {* 
                                                <div class="spinner">
                                                <i class="fa fa-circle-o-notch fa-spin"></i>
                                                </div>
                                                <br />
                                                <h4>Loading conversations...</h4>

                                                *}

                                                <h4 style="color:#082645">Let's start a conversation!</h4>

                                                {if $cantidad_cuentas_whatsapp eq "1"}
                                                <span style="color:#082645">
                                                    You don't have an account set up yet. To do so, go to
                                                </span>
                                                
                                                <a style="color:#082645" href="{$url_setting_CRM_Parnerts_prepared}" target="_blank"> Settings > Chat Settings. </a>
                                                
                                                {/if}

                                                <br>
                                                <img
                                                src="{{APP_URL}}/storage/system/{{$config['logo_default']}}"
                                                alt=""
                                                style="max-width: 100%; width: 213px;height: 152px"
                                                />

                                                <div style="width:100%; height:40px">
                                                <span class="loader_ws"></span>
                                                </div>
                                                

                        

                                            </div>
                                        </div>
                                    </div>

                                    <!--mensajes chat-->
                                    <div class="cuerpo_mensaje" style="display: none">
                                        <!-- FIN  plantillas templates -->

                                        <!-- plantilla para audios -->
                                        <div
                                            class="message-feed media"
                                            data-wam-id="wamid.HBgLNTA0OTc3NDc0NDYVAgARGBIyNDI3QjRGM0MyODBFOEFBQ0MA"
                                        >
                                            <div class="pull-left">
                                                <!--  <img
                                                src="https://bootdey.com/img/Content/avatar/avatar1.png"
                                                alt=""
                                                class="img-avatar"
                                                /> -->
                                                <div class="image-container-perfil">
                                                <img
                                                    src="https://bootdey.com/img/Content/avatar/avatar1.png"
                                                    alt=""
                                                    class="img-avatar"
                                                />
                                                <img
                                                    src="{$path_img}whatsapp.png"
                                                    alt=""
                                                    class="img-avatar-small"
                                                />
                                                </div>
                                            </div>

                                            <div class="media-body media-body-change-display">
                                                <div class="mf-content mf-content-documentos">
                                                <div class="palomitas">
                                                    <audio controls class="audio-general">
                                                        <source
                                                            src="https://xhde365.com/app_dev/storage/whatsapp/ogg/2024-07-25-17-09-51_74600_enviado.ogg"
                                                            type="audio/mpeg"
                                                        />
                                                        Your browser does not support the audio
                                                        element.
                                                    </audio>
                                                </div>
                                                <div class="caption_mensaje">
                                                    <span class="texto">Texto o caption</span>
                                                </div>
                                                <small class="mf-date fecha_y_palomitas">
                                                    2024-07-17 18:10:14
                                                    <img
                                                        class="palomita_texto"
                                                        src="{$path_img}sent.png"
                                                        alt=""
                                                        width="20px"
                                                    />
                                                </small>
                                                </div>
                                            </div>
                                        </div>
                                        <!--FIN plantilla para audios -->

                                        <!-- plantilla para archivos -->
                                        <div
                                            class="message-feed media"
                                            data-wam-id="wamid.HBgLNTA0OTc3NDc0NDYVAgARGBIyNDI3QjRGM0MyODBFOEFBQ0MA"
                                        >
                                            <div class="pull-left">
                                                <!--  <img
                                                src="https://bootdey.com/img/Content/avatar/avatar1.png"
                                                alt=""
                                                class="img-avatar"
                                                /> -->
                                                <div class="image-container-perfil">
                                                <img
                                                    src="https://bootdey.com/img/Content/avatar/avatar1.png"
                                                    alt=""
                                                    class="img-avatar"
                                                />
                                                <img
                                                    src="{$path_img}whatsapp.png"
                                                    alt=""
                                                    class="img-avatar-small"
                                                />
                                                </div>
                                            </div>

                                            <div class="media-body media-body-change-display">
                                                <div class="mf-content mf-content-documentos">
                                                <div class="palomitas">
                                                    <div class="contenedor_archivos">
                                                        <div class="contenedor_contenido_archivos">
                                                            <a
                                                            href="{$path_img}prueba.jpg"
                                                            target="_blank"
                                                            style="
                                                                width: 100%;
                                                                text-decoration: none;
                                                                color: black;
                                                            "
                                                            >
                                                            <div class="nombre_archivo">
                                                                <div class="logo_archivo">
                                                                    <img
                                                                        src="{$path_img}imagen_pdf.png"
                                                                        alt=""
                                                                        class="imagen"
                                                                        title="PDF"
                                                                    />
                                                                </div>
                                                                <div
                                                                    class="texto_archivo"
                                                                    title="File.pdf"
                                                                >
                                                                    <p class="formatear_margin_0">
                                                                        File.pdf
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="caption_mensaje">
                                                    <span class="texto">Texto o caption</span>
                                                </div>
                                                <small class="mf-date fecha_y_palomitas">
                                                    2024-07-17 18:10:14
                                                    <img
                                                        class="palomita_texto"
                                                        src="{$path_img}sent.png"
                                                        alt=""
                                                        width="20px"
                                                    />
                                                </small>
                                                </div>
                                            </div>
                                        </div>
                                        <!--FIN plantilla para archivos -->

                                        <!-- --------------------   para clientes --------------------------- -->

                                        <!-- plantilla para video -->
                                        <div
                                            class="message-feed media right"
                                            data-wam-id="wamid.HBgLNTA0OTc3NDc0NDYVAgARGBIyNDI3QjRGM0MyODBFOEFBQ0MA"
                                        >
                                            <div class="pull-right">
                                                <!--  <img
                                                src="https://bootdey.com/img/Content/avatar/avatar1.png"
                                                alt=""
                                                class="img-avatar"
                                            /> -->
                                                <div class="image-container-perfil">
                                                <img
                                                    src="{$path_img}perfil.jpg"
                                                    alt=""
                                                    class="img-avatar"
                                                />
                                                <img
                                                    src="{$path_img}whatsapp.png"
                                                    alt=""
                                                    class="img-avatar-small"
                                                />
                                                </div>
                                            </div>

                                            <div class="media-body media-body-change-display">
                                                <div class="mf-content mf-content-documentos">
                                                <div class="palomitas">
                                                    <video controls class="video-general">
                                                        <source
                                                            src="https://xhde365.com/app_dev/storage/whatsapp/mp4/2024-08-02-10-24-19_411093_recibido.mp4"
                                                        />

                                                        Your browser does not support the video tag.
                                                    </video>
                                                </div>
                                                <div class="caption_mensaje">
                                                    <span class="texto">Texto o caption</span>
                                                </div>
                                                <small class="mf-date"> 2024-07-17 18:10:14 </small>
                                                </div>
                                            </div>
                                        </div>
                                        <!--FIN plantilla para video -->

                                        <!-- plantilla para audios -->
                                        <div
                                            class="message-feed media right"
                                            data-wam-id="wamid.HBgLNTA0OTc3NDc0NDYVAgARGBIyNDI3QjRGM0MyODBFOEFBQ0MA"
                                        >
                                            <div class="pull-right">
                                                <!--  <img
                                                src="https://bootdey.com/img/Content/avatar/avatar1.png"
                                                alt=""
                                                class="img-avatar"
                                            /> -->
                                                <div class="image-container-perfil">
                                                <img
                                                    src="{$path_img}perfil.jpg"
                                                    alt=""
                                                    class="img-avatar"
                                                />
                                                <img
                                                    src="{$path_img}whatsapp.png"
                                                    alt=""
                                                    class="img-avatar-small"
                                                />
                                                </div>
                                            </div>

                                            <div class="media-body media-body-change-display">
                                                <div class="mf-content mf-content-documentos">
                                                <div class="palomitas">
                                                    <audio controls class="audio-general">
                                                        <source
                                                            src="https://xhde365.com/app_dev/storage/whatsapp/ogg/2024-07-25-17-09-51_74600_enviado.ogg"
                                                        />
                                                        Your browser does not support the audio
                                                        element.
                                                    </audio>
                                                </div>
                                                <div class="caption_mensaje">
                                                    <span class="texto">Texto o caption</span>
                                                </div>
                                                <small class="mf-date"> 2024-07-17 18:10:14 </small>
                                                </div>
                                            </div>
                                        </div>
                                        <!--FIN plantilla para audios -->

                                        <!-- plantilla para archivos -->
                                        <div
                                            class="message-feed media right"
                                            data-wam-id="wamid.HBgLNTA0OTc3NDc0NDYVAgARGBIyNDI3QjRGM0MyODBFOEFBQ0MA"
                                        >
                                            <div class="pull-right">
                                                <!--  <img
                                                src="https://bootdey.com/img/Content/avatar/avatar1.png"
                                                alt=""
                                                class="img-avatar"
                                            /> -->
                                                <div class="image-container-perfil">
                                                <img
                                                    src="{$path_img}perfil.jpg"
                                                    alt=""
                                                    class="img-avatar"
                                                />
                                                <img
                                                    src="{$path_img}whatsapp.png"
                                                    alt=""
                                                    class="img-avatar-small"
                                                />
                                                </div>
                                            </div>

                                            <div class="media-body media-body-change-display">
                                                <div class="mf-content mf-content-documentos">
                                                <div class="palomitas">
                                                    <div class="contenedor_archivos">
                                                        <div class="contenedor_contenido_archivos">
                                                            <a
                                                            href="{$path_img}prueba.jpg"
                                                            target="_blank"
                                                            style="
                                                                width: 100%;
                                                                text-decoration: none;
                                                                color: black;
                                                            "
                                                            >
                                                            <div class="nombre_archivo">
                                                                <div class="logo_archivo">
                                                                    <img
                                                                        src="{$path_img}imagen_pdf.png"
                                                                        alt=""
                                                                        class="imagen"
                                                                        title="PDF"
                                                                    />
                                                                </div>
                                                                <div
                                                                    class="texto_archivo"
                                                                    title="File.pdf"
                                                                >
                                                                    <p class="formatear_margin_0">
                                                                        File.pdf
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="caption_mensaje">
                                                    <span class="texto">Texto o caption</span>
                                                </div>
                                                <small class="mf-date">
                                                    <div>
                                                        <i class="fa fa-clock-o"></i> 2024-07-17
                                                        18:10:14
                                                    </div>
                                                </small>
                                                </div>
                                            </div>
                                        </div>
                                        <!--FIN plantilla para archivos -->

                                        <!-- plantilla para imagenes -->
                                        <div
                                            class="message-feed media right"
                                            data-wam-id="wamid.HBgLNTA0OTc3NDc0NDYVAgARGBIyNDI3QjRGM0MyODBFOEFBQ0MA"
                                        >
                                            <div class="pull-right">
                                                <!-- <img src="./img/perfil.jpg" alt="" class="img-avatar" /> -->
                                                <div class="image-container-perfil">
                                                <img
                                                    src="{$path_img}perfil.jpg"
                                                    alt=""
                                                    class="img-avatar"
                                                />
                                                <img
                                                    src="{$path_img}sms.png"
                                                    alt=""
                                                    class="img-avatar-small-sms"
                                                />
                                                </div>
                                            </div>
                                            <div class="media-body media-body-change-display">
                                                <div
                                                class="mf-content mf-content-imagen mf-content-all"
                                                >
                                                <div class="palomitas">
                                                    <div class="tamano_div_imagen">
                                                        <a
                                                            href="https://xhde365.com/app_dev/storage/whatsapp/2024-07-18-16-41-39_11354.jpeg"
                                                            target="_blank"
                                                        >
                                                            <div class="spinner">
                                                            <i
                                                                class="fa fa-circle-o-notch fa-spin"
                                                            ></i>
                                                            </div>

                                                            <img
                                                            class="imagen_imagen"
                                                            src="{$path_img}prueba.jpg"
                                                            alt=""
                                                            style="display: none"
                                                            onerror="this.src='{$path_img}error_imagen.png'"
                                                            />
                                                        </a>
                                                    </div>
                                                </div>
                                                <div class="caption_mensaje">
                                                    <span class="texto">ssssssssssssss</span>
                                                </div>
                                                <small class="mf-date">
                                                    <div>
                                                        <i class="fa fa-clock-o"></i> 2024-07-17
                                                        18:10:14
                                                    </div>
                                                </small>
                                                </div>
                                            </div>
                                        </div>
                                        <!--FIN plantilla para imagenes -->
                                    </div>

                              

                   
 
                                    </div>
                                </div>

                                {* ----------- *}
                        
                            </div>
                        </div>

                       
                    </div>

                  

                </div>
 
                
               
            </div>
        </div>
    </div>
</div>




{/block}

{block name="script"}

<script src="{$theme}default/js/whatsapp.js?v={{_raid()}}"></script>

<script src="{$theme}default/js/plantillas.js?v={{_raid()}}"></script>

{literal}
<script type="module">

    $(".contenedor_principal").hide();
    $("#messages-main").show();
    $(".dropdown_config").show();

    //la parte de arriba del chat
    $(".cabecera_perfil_contacto").html(
       quitar_cabecera_contacto_seleccionado(),
    );

    $(".ocultar_mostrar_botones_cerca_contactos").css("display", "");

    $("#btn_elejir_contacto").prop("disabled", true);
    $("#btn_new_contacto").prop("disabled", true);
    $("#btn_search_contacto").prop("disabled", true);
 
    //$(".mi-bandeja-mensajes-contactos").html(esqueletonContactos());   
    $(".mi-bandeja-mensajes-contactos").html("");   

    //cargando mensajes de chat
    $(".cuerpo_cargando_mensajes").css("display", "none");
    $(".cuerpo_sin_mensajes").css("display", "");

    

    const URL_BASE      = $(".tener_url_base").val();
    const tener_role_id = $(".tener_role_id").val();

    console.log("URL_BASE");
    console.log(URL_BASE);

    $("#fecha_desde_tiempo_abierto").prop("disabled", true);
    $("#fecha_hasta_tiempo_abierto").prop("disabled", true);

    $("#fecha_desde_tiempo_abierto").val("");
    $("#fecha_hasta_tiempo_abierto").val("");

    $("#check_fecha_propuesta").prop("checked", true);

    //var URL_BASE = $("#URL_BASE").val();
    const PATH_IMG = $(".tener_path_img").val();

    var IMG_NOMBRE_PERFIL = $("#IMG_NOMBRE_PERFIL").val();

    var MI_IMAGEN_PERFIL = $("#IMAGEN_PERFIL").val();
    var MI_RUTA_IMAGEN_PERFIL = $("#RUTA_IMAGEN_PERFIL").val();
    var MI_RUTA_PROYECTO = $("#RUTA_PROYECTO").val();

    var APP_URL_ORIGINAL_SOCKET = $("#APP_URL_ORIGINAL_SOCKET").val();
 
    var ID_USER = $("#ID_USER").val();
    var STAFF_ID_GLOBAL = ID_USER;

    //configuracion de whatsapp
    var FROM_GLOBAL = null;
    var ID_CONFIG_WHATSAPP_OTHER_GLOBAL = null;
    var PHONE_NUMBER_ID_GLOBAL = null;
    var VERSION_WHATSAPP_GLOBAL = null;
    var TOKEN_WHATSAPP_GLOBAL = null;
    var WHATSAPP_BUSINESS_ACCOUNT_IDENTIFIER = null;

    //configuracion de mensajes
    var SMS_FROM_GLOBAL = null;
    var ACCOUNT_SID_SMS = null;
    var AUTH_TOKEN_SMS = null;

    var TIPO_DE_PLATAFORMA = "whatsapp-sms";
    var TIPO_DE_CONFIGURACION_WHATSAPP_SMS_ID = null;

    var isEnabledWhatsapp = null;
    var isEnabledSMS = null;

    var ID_PLANTILLA_SELECCIONADO = "";
    var INFORMACION_PLANTILLA_HEADER = ""; //esta variable la cree para tener la base 64 cuando es header y es tipo imagen, documento, video. tomo su base 64
    var INFORMACION_PLANTILLA_HEADER_EXTENSION = ""; //esta variable la cree para tener la base 64 cuando sea header tener el tipo de documento
    var NOMBRE_CONTACTO_SELECCIONADO = null;

    var LISTADO_CONFIGURACION_WHATSAPP_SMS = [];

    //me servira para tener la lista de personas que me escribieron o contactos
    var lista_contactos = [];
    var lista_etapa_conversacion = [];
    var html_listado_etapa_conversacion_select = "";

    var lista_productos = [];
    
    var listado_custumers = [];

    var listado_staff = [];


    var numero_contacto_seleccionado = null;
    var id_contacto_seleccionado = null;

    var loading = false;

    var esTW_WS = false;

 
    //se usa cuando se selecciona un contacto o cuando se cre un mensaje o imagen para asignarlo manual
    var chat_mensajes = [];
    var chat_mensajes_dbLocal_temporal = [];

    //listado de plantilla tenidas de facebook
    var listado_plantillas = [];
    
    var id_chat_mensajes = null;
    var wam_id_chat_mensajes = null;
    var sid_id_chat_mensajes = null;
    var UUID_chat_mensajes = null;

    //cargar_usuarios_sistema().then((listado_usuarios_admin) =>{
    //    $(".tener_usuario_id").html(
    //        select_html_usuario_sistema(listado_usuarios_admin),
    //    );
    //});

    function esqueletonContactos() {

        let concatenar = "";
        
        for (let index = 0; index < 5; index++) {
           concatenar +=
              '<a class="list-group-item media item-contactos placeholder-glow blur-in-expand" style=" padding-left: 11px; padding-right: 11px; ">' +
              '  <div class="pull-left" style="height: 100%;">' +
              '    <div class="placeholder placeholder-glow rounded-circle bg-info" style="width: 40px; height: 40px;"></div>' +
              "  </div>" +
              '  <div class="active-display-inline">' +
              "    <div>" +
              '      <small class="list-group-item-text c-gray placeholder col-6" style="background: gray; color: transparent; user-select: none; border-radius: 4px;">Integraciones Tec...</small>' +
              '      <small class="fecha_humana placeholder col-2 bg-info" style="float: right; font-size: 9px; color: transparent !important; user-select: none; border-radius: 4px;">03/06/2025</small>' +
              "    </div>" +
              '    <hr style="padding: 0px; margin: 0px; border: 0; margin-top:5px;">' +
              "    <i>" +
              '      <small class="list-group-item-heading nombre_whatsapp placeholder col-8" title="*Si es prioridad Llámame" style="background: gray; color: transparent; user-select: none; border-radius: 4px;">*Si es prioridad ...</small>' +
              "    </i><br>" +
              '    <small class="list-group-item-text c-gray placeholder col-4" style="color: transparent; background: gray; user-select: none; border-radius: 4px;">+50498632131</small><br>' +
              '    <small class="list-group-item-text c-gray contacto_fullname_staff placeholder col-3" style="color: transparent; background: gray; user-select: none; border-radius: 4px;">jair</small>' +
              "  </div>" +
              '  <span class="badge-contactos badge badge-colors"></span>' +
              "</a>";
        }

        return concatenar;
    }

    function esqueletonMensajes(){

       let concatenar = "";

       let miMensaje = "<div class=\"message-feed media placeholder-glow \">" +
          "  <div class=\"pull-left\">" +
          "    <div class=\"image-container-perfil\">" +
          "      <div class=\"placeholder rounded-circle bg-info\" style=\"width: 40px; height: 40px;\"></div>" +
          "    </div>" +
          "  </div>" +
          "  <div class=\"media-body media-body-change-display\">" +
          "    <div class=\"mf-content mf-content-documentos\">" +
          "      <div class=\"palomitas\">" +
          "        <div class=\"plantilla-header-mensaje placeholder col-6\" style=\"border-radius: 4px; background: #beb9b9; \"></div>" +
          "        <div class=\"plantilla-body-mensaje\">" +
          "          <p class=\"texto_body_mensaje placeholder col-8\" style=\"color: transparent; background: #beb9b9; user-select: none; border-radius: 4px; width: 100%; height: 69px; margin-top: 4px;\">Tu código de verificación es *12345*. Por tu seguridad, no lo compartas.</p>" +
          "        </div>" +
          "        <div class=\"plantilla-footer-mensaje\" style=\"/* background: #beb9b9; */ /* border-radius: 4px; */\">" +
          "          <span class=\"texto_footer_mensaje placeholder col-4\" style=\"color: transparent; background: #beb9b9; border-radius: 4px; width: 100%; user-select: none;\">...</span>" +
          "        </div>" +
          "      </div>" +
          "      <small class=\"mf-date fecha_y_palomitas\">" +
          "        <div class=\"placeholder col-3\" style=\"color: transparent; background: #beb9b9; user-select: none; border-radius: 4px;\">02-04-2025 05:56 pm</div>" +
          "        <div class=\"placeholder rounded bg-info\" style=\"width: 18px; height: 18px;\"></div>" +
          "      </small>" +
          "      <div class=\"mensajes_botones\" style=\"display: none;\"></div>" +
          "    </div>" +
          "  </div>" +
          "</div>";

          //#beb9b9

          let miMensajeCliente = "<div class=\"message-feed media right placeholder-glow\">" +
          "  <div class=\"pull-right\">" +
          "    <div class=\"image-container-perfil\">" +
          "      <div class=\"placeholder rounded-circle bg-info\" style=\"width: 40px; height: 40px;\"></div>" +
          "    </div>" +
          "  </div>" +
          "  <div class=\"media-body media-body-change-display\">" +
          "    <div class=\"mf-content\">" +
          "      <div class=\"palomitas\">" +
          "        <div class=\"izquierda\">" +
          "          <span class=\"placeholder col-6\" style=\"display: inline-block; height: 14px; border-radius: 4px; user-select: none; color: transparent; background: #beb9b9;\">asdasdas3333333333333333333333333333333dasd</span><br>" +
          "          <span class=\"placeholder col-5\" style=\"display: inline-block; height: 14px; border-radius: 4px; user-select: none; color: transparent; background: #beb9b9;\"></span><br>" +
          "          <span class=\"placeholder col-4\" style=\"display: inline-block; height: 14px; border-radius: 4px; user-select: none; color: transparent; background: #beb9b9;\"></span>" +
          "        </div>" +
          "      </div>" +
          "      <small class=\"mf-date\">" +
          "        <div class=\"placeholder col-3\" style=\"height: 12px; border-radius: 4px;\"></div>" +
          "      </small>" +
          "    </div>" +
          "  </div>" +
          "</div>";

          concatenar =   miMensajeCliente + miMensaje + miMensajeCliente + miMensaje;
 
          return concatenar;
 
    }


    function htmlCambiarStaff() {
       const opciones = [
          { texto: 'Todos', tipo: 'todos' },
          { texto: 'Mis Asignados', tipo: 'asignados' },
          { texto: 'Sin Asignar', tipo: 'sin_asignar' }
       ];

       return opciones.map(opcion => `
          <li class="item_cambiar_staff" data-tipo="${opcion.tipo}" data-tipo_usuario="2" style="border-bottom: 1px solid #f5f5f5;">
                ${opcion.texto}
          </li>
       `).join('');
    }

    function htmlCambiarStaffEtapa(texto="Todos", tipo_etapa = 2, etapa_id = 0) {
     

       return `
          <li class="item_cambiar_etapa"  data-etapa_id="${etapa_id}" data-tipo_etapa="${tipo_etapa}" style="border-bottom: 1px solid #f5f5f5;">
                ${texto}
          </li>
       `;
    }

    function crearHtmlCambiarStaff(data={}, ultimo=false) {
        let{
          tipo,
          tipo_usuario,
          texto
        } = data;


       if(ultimo == true)
       {
          return `
             <li class="item_cambiar_staff" data-tipo="${tipo}" data-tipo_usuario="${tipo_usuario}">
                   ${texto}
             </li>
          `;
       }else{
          return `
             <li class="item_cambiar_staff" data-tipo="${tipo}" data-tipo_usuario="${tipo_usuario}" style="border-bottom: 1px solid #f5f5f5;">
                   ${texto}
             </li>
          `;
       }

        
    }

   $(".tener_producto").select2({
      placeholder: "Select an option",
      allowClear: true,
   });

   $(".tener_staff").select2({
      placeholder: "Select an option",
      allowClear: true,
   });

   $(document).ready(function() {

        $("#check_fecha_propuesta").on("change", function() {
            let isChecked = $(this).prop("checked");
            if (isChecked) {
                console.log("Checkbox está marcado (true)");
                // Acciones cuando está marcado

               $("#tiempo_abierto").prop("checked", false);
               $("#fecha_desde_tiempo_abierto").prop("disabled", true);
               $("#fecha_hasta_tiempo_abierto").prop("disabled", true);

               $("#fecha_desde_tiempo_abierto").val("");
               $("#fecha_hasta_tiempo_abierto").val("");

               $("#fecha_desde").prop("disabled", false);
               $("#fecha_hasta").prop("disabled", false);


            } else {
                console.log("Checkbox está desmarcado (false)");
                // Acciones cuando está desmarcado
            }
        });

        $("#tiempo_abierto").on("change", function() {
            let isChecked = $(this).prop("checked");
            if (isChecked) {
                console.log("Checkbox está marcado (true)");
                // Acciones cuando está marcado
               
               $("#check_fecha_propuesta").prop("checked", false);

               $("#fecha_desde").prop("disabled", true);
               $("#fecha_hasta").prop("disabled", true);

               $("#fecha_desde").val("");
               $("#fecha_hasta").val("");

               $("#fecha_desde_tiempo_abierto").prop("disabled", false);
               $("#fecha_hasta_tiempo_abierto").prop("disabled", false);
 
            } else {
                console.log("Checkbox está desmarcado (false)");
                // Acciones cuando está desmarcado
            }
        });

        $("#consultar_filtros").click(function () {

 
            let estatus_conversacion = $("#estatus_conversacion").val() || "";
            let category_form        = $("#category_form").val() || "";
            let producto        = $("#producto").val() || "";
            let staff        = $("#staff").val() || "";
            let fecha_desde        = $("#fecha_desde").val() || "";
            let fecha_hasta        = $("#fecha_hasta").val() || "";

            let fecha_desde_tiempo_abierto        = $("#fecha_desde_tiempo_abierto").val() || "";
            let fecha_hasta_tiempo_abierto        = $("#fecha_hasta_tiempo_abierto").val() || "";

            let configuracion_whatsapp_id        = $("#configuracion_whatsapp_id").val() || "";
       
            if(isEmpty(configuracion_whatsapp_id) == true)
            {
                toastr.error("!Whatsapp/SMS settings is required¡");
                return;
            }
            
            let enviar_informacion = {
               fecha_desde: fecha_desde,
               fecha_hasta: fecha_hasta,

               fecha_desde_tiempo_abierto: fecha_desde_tiempo_abierto,
               fecha_hasta_tiempo_abierto: fecha_hasta_tiempo_abierto,

               estatus_conversacion: estatus_conversacion,
               category_form: category_form,
               producto: producto == "0" ? "" : producto,
               staff: staff == "0" ? "" : staff,

               configuracion_whatsapp_id: configuracion_whatsapp_id,
            };

            console.log(enviar_informacion);
            //console.log("aqui abajo ahi un return");
            //return;

            $("#consultar_filtros").prop("disabled", true);

            $.ajax({
               type: "POST",
               url: URL_BASE + "social/filtra-listado-analisis-conversaciones",
               data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
               contentType: "application/json", // Tipo de contenido JSON
               success: function (response) {

                  $("#consultar_filtros").prop("disabled", false);
                 
                  //$(".tbody_envios").html("");

                  try {
                     let info = JSON.parse(response);
                     if (info.type == "success") {
                        let arr = info.data || [];
 

                        lista_contactos = arr;

                        
                        $(".cuerpo_sin_mensajes").css("display", "none");
                        $(".cuerpo_mensaje").css("display", "none"); //habilita las conversaciones

                        $(".msb-footer-sin-enviar-mensajes").css("display", "");
                        $(".msb-footer").css("display", "none");

                        var lista_contactos_html = "";

                        lista_contactos.forEach((element) => {

                           lista_contactos_html += contactos(element);
                        });

                        $(".mi-bandeja-mensajes-contactos").html(lista_contactos_html);

                        //puse el dar click en una funcion se repetira el codigo
                        click_contactos();

                        $("#btn_search_contacto").css("display", "");

                        numero_contacto_seleccionado = null;
                        id_contacto_seleccionado = null;

                        loading = false;
                        chat_mensajes = [];
 
                        $(".cuerpo_mensaje").html("");

                        $(".cuerpo_sin_mensajes").css("display", "");
                        $(".cuerpo_mensaje").css("display", "none"); //habilita las conversaciones

                        $(".msb-footer-sin-enviar-mensajes").css("display", "");
                        $(".msb-footer").css("display", "none");

 
                     } else {
                        alert("Error sending group messages");
                     }
                  } catch (error) {
                     $(".tbody_envios").html("");
                     alert("Error:" + error);
                  }
               },
               error: function (xhr, status, error) {
                  $("#consultar_filtros").prop("disabled", false);
                  $(".tbody_envios").html("");
                  console.error("Error en la solicitud:", error);
               },
            });
        });

         
    
    });

    function click_contactos() {

       $(".item-contactos").off("click");

       $(".item-contactos").on("click", async function () {

          $('.cargando_mensajes_chat_interno').fadeOut(300);
           
          // Obtener los valores de los atributos data
          const idContacto = $(this).data("id_contacto");
          const numeroContacto = $(this).data("numero-contacto");
          const nombreContacto = $(this).data("nombre-contacto");
          const nombre = $(this).data("nombre");
          const chat_conversaciones_id = $(this).data("chat_conversaciones_id");

          NOMBRE_CONTACTO_SELECCIONADO = $(this).data("nombre");

          numero_contacto_seleccionado = numeroContacto;
          id_contacto_seleccionado = idContacto;

          operacionClickContacto(idContacto, 
                                 numeroContacto, 
                                 nombreContacto, 
                                 NOMBRE_CONTACTO_SELECCIONADO,
                                 $(this),
                                 nombre,
                                 chat_conversaciones_id,
                                 );  
           

          //
       });
    }

    function click_only_contactos(idContacto)
    {
       $(".item-contactos[data-id_contacto='" + idContacto + "']").on("click", async function () {
          
          $('.cargando_mensajes_chat_interno').fadeOut(300);
           
          // Obtener los valores de los atributos data
          const idContacto = $(this).data("id_contacto");
          const numeroContacto = $(this).data("numero-contacto");
          const nombre = $(this).data("nombre");
          const nombreContacto = $(this).data("nombre-contacto");

          NOMBRE_CONTACTO_SELECCIONADO = $(this).data("nombre");

          numero_contacto_seleccionado = numeroContacto;
          id_contacto_seleccionado = idContacto;

          operacionClickContacto(idContacto, 
                                 numeroContacto, 
                                 nombreContacto, 
                                 NOMBRE_CONTACTO_SELECCIONADO,
                                 $(this),
                                 nombre
                                 );  
         
       });
    }

    async function operacionClickContacto(
            id_contacto_seleccionado,
            numero_contacto_seleccionado,
            nombre_contacto_seleccionado,
            nombre_seleccionado,
            $this,
            nombre = "",
            chat_conversaciones_id = ""
            
    ) {

            const idContacto =  id_contacto_seleccionado;
            const numeroContacto = numero_contacto_seleccionado;
            const nombreContacto = nombre_contacto_seleccionado;
            NOMBRE_CONTACTO_SELECCIONADO = nombre_seleccionado;

            numero_contacto_seleccionado = numeroContacto;
            id_contacto_seleccionado = idContacto;

            numero_contacto_seleccionado
 
            console.log("idContacto");
            console.log(idContacto);
 

            $(".ocultarBarraOpcionesChat").css("display", "none"); // Ocultar  

            chat_mensajes = [];
 
            $(".cuerpo_sin_mensajes").css("display", "none");
            $(".cuerpo_mensaje").css("display", ""); //habilita las conversaciones

            $(".msb-footer-sin-enviar-mensajes").css("display", "");
            $(".msb-footer").css("display", "none");

            //cargando mensajes de chat
            $(".cuerpo_cargando_mensajes").css("display", "none");

            $(".cuerpo_mensaje").html(esqueletonMensajes());

            //activamos boton para agregar contactos a chat
            $("#btn_elejir_contacto").show();
 
            $(".item-contactos").removeClass("item-contacto-seleccionado");

            $this.addClass("item-contacto-seleccionado");

            var se_cargo_por_base_datos_local = true;

            chat_mensajes_dbLocal_temporal = [];

            let estatus_conversacion = $("#estatus_conversacion").val() || "";
            let category_form        = $("#category_form").val() || "";
            let producto             = $("#producto").val() || "";
            let staff                = $("#staff").val() || "";
            let fecha_desde          = $("#fecha_desde").val() || "";
            let fecha_hasta          = $("#fecha_hasta").val() || "";

            let fecha_desde_tiempo_abierto        = $("#fecha_desde_tiempo_abierto").val() || "";
            let fecha_hasta_tiempo_abierto        = $("#fecha_hasta_tiempo_abierto").val() || "";

            let configuracion_whatsapp_id         = $("#configuracion_whatsapp_id").val() || "";
       
            if(isEmpty(configuracion_whatsapp_id) == true)
            {
                toastr.error("!Whatsapp/SMS settings is required¡");
                return;
            }
            
            let enviar_informacion = {
               fecha_desde: fecha_desde,
               fecha_hasta: fecha_hasta,

               fecha_desde_tiempo_abierto: fecha_desde_tiempo_abierto,
               fecha_hasta_tiempo_abierto: fecha_hasta_tiempo_abierto,

               estatus_conversacion: estatus_conversacion,
               category_form: category_form,
               producto: producto == "0" ? "" : producto,
               staff: staff == "0" ? "" : staff,
               configuracion_whatsapp_id: configuracion_whatsapp_id,

               numero_contacto_seleccionado: numero_contacto_seleccionado,
               FROM_GLOBAL: FROM_GLOBAL,
               PHONE_NUMBER_ID_GLOBAL: PHONE_NUMBER_ID_GLOBAL,
               chat_conversaciones_id: chat_conversaciones_id
            };

            console.log("enviar_informacion");
            console.log(enviar_informacion);
            //return;

            //carga los primeros 30 o N registros
            chat_mensajes = await cargar_listado_chat_contactos_analisis_conversaciones_api(
               URL_BASE,
               enviar_informacion,
            );

            const esMiMensaje = chat_mensajes.filter((data) => data.chat_number_id == idContacto && data.chat_conversacion_id == chat_conversaciones_id);
 
            if(esMiMensaje.length == 0)
            {
              $(".cuerpo_mensaje").html("");
              cargarFooterClickContacto(idContacto);
              return;   
            }
 
            console.log("MI LISTADO DE MENSAJES DE BASE DE DATOS");
            console.log(chat_mensajes);

            $(".cuerpo_mensaje").html("");

            cargar_mensajes_numeros_plantillas(chat_mensajes);
 
            setTimeout(() => {
               //console.log("Desplazando hacia abajo después de 1 segundo");
               const container = $(".cuerpo_mensaje");
               if (container.length) { // Verificar que el elemento exista
                  container.animate({
                        scrollTop: container[0].scrollHeight
                  }, 0); // Duración de la animación en milisegundos (1 segundo)
               }
            }, 0); // Retraso inicial de 1 segundo

            const condicion = cargarFooterClickContacto(idContacto);
 
            if(condicion)
            {
               return;
            }

            if (chat_mensajes.length == 0) {
               $('.cargando_mensajes_chat_interno').fadeOut(300);
               return;
            }

            id_chat_mensajes = chat_mensajes[0]["id"];
            UUID_chat_mensajes = chat_mensajes[0]["UUID"];
            wam_id_chat_mensajes = chat_mensajes[0]["wam_id"];
            sid_id_chat_mensajes = chat_mensajes[0]["sid"];
 
            //console.log("El ultimo id id_chat_mensajes");
            //console.log(id_chat_mensajes);
  
            const scrollButton = $("#scrollButton");

            const elemento = $(".cuerpo_mensaje");

            if (elemento.length > 0) {

               // Mover el scroll al final sin animación
               elemento.scrollTop(elemento[0].scrollHeight);

               const container = $(".cuerpo_mensaje");

               container.off("scroll");

               container.on("scroll", async function () {

                const scrollHeight = this.scrollHeight;
                const clientHeight = this.clientHeight;
                const scrollTop = this.scrollTop;

                if (scrollTop < 240) {

                   if (loading == true) {
                       
                        if (chat_mensajes.length == 0){
                            $('.cargando_mensajes_chat_interno').fadeOut(300);
                           return;
                        }

                        $('.cargando_mensajes_chat_interno').fadeIn(300);

                        id_chat_mensajes = chat_mensajes[0]["id"];
                        wam_id_chat_mensajes = chat_mensajes[0]["wam_id"];
                        sid_id_chat_mensajes = chat_mensajes[0]["sid"];
                        UUID_chat_mensajes = chat_mensajes[0]["UUID"];

                        let data =
                        (await cargar_listado_chat_contactos_by_last_id_analiar_conversaciones_api(
                           URL_BASE,
                           numero_contacto_seleccionado,
                           //FROM_GLOBAL, //antes estaba asi en el backend lo quite
                           //PHONE_NUMBER_ID_GLOBAL, //antes estaba asi en el backend lo quite
                           id_chat_mensajes,
                           TIPO_DE_PLATAFORMA,
                           configuracion_whatsapp_id,
                           chat_conversaciones_id
                        )) || {
                           data: [],
                           cargado: false,
                        };

                        console.log("El ultimo id");
                        console.log(id_chat_mensajes);

                        let arreglo_nuevo = data["data"];

                        const esMiMensaje = arreglo_nuevo.filter((data) => data.chat_number_id == idContacto && data.chat_conversacion_id == chat_conversaciones_id);

                        if(esMiMensaje.length == 0)
                        {
                             $('.cargando_mensajes_chat_interno').fadeOut(300);
                           return;   
                        }

                        console.log("informacion de base de datos arreglo_nuevo");
                        console.log(arreglo_nuevo);

                        if (arreglo_nuevo.length != 0) {

                           console.log("ENTRO AL arreglo con arraySinCoincidencias");

                           //id_chat_mensajes = arreglo_nuevo[0]["id"];

                           cargar_mensajes_numeros_plantillas(
                              arreglo_nuevo,
                           );
                           
                           chat_mensajes.unshift(...arreglo_nuevo);

                           if(chat_mensajes.length == 0)
                           {
                               console.log("no hay mensajes en el arreglo");
                               return;
                           }
 
                           if(isEmpty(arreglo_nuevo[0]["UUID"]) == false)
                           {
                                  //
                                  var targetId = UUID_chat_mensajes;

                                  // Find the target div
                                  var $targetDiv = $(
                                     '.cuerpo_mensaje div[data-uuid="' +
                                        targetId +
                                        '"]',
                                  );

                                  if ($targetDiv.length) {
                                     
                                     //await sleep(300);
 
                                     $targetDiv[0].scrollIntoView(); 

                                  }

                                  /*
                                  if(
                                     isEmpty(UUID_chat_mensajes[0]["UUID"]) == true  
                                  )
                                  {

                                     console.log("targetId wam_id");
                                     console.log(arreglo_nuevo[0]["wam_id"]);

                                     console.log("targetId wam_id");
                                     console.log(arreglo_nuevo[0]["wam_id"]);

                                     console.log("targetId sid");
                                     console.log(arreglo_nuevo[0]["sid"]);
                                  }
                                  */

                                  console.log("mensaje UUID");
                                  console.log(UUID_chat_mensajes[0]["UUID"]);
 
                           }

                           //
 
                        }

                        $('.cargando_mensajes_chat_interno').fadeOut(300);
                    

                   }
                   // Perform your action here
                } else {
                   loading = true;
                }

                if (scrollHeight - scrollTop - clientHeight >= 100) {
                   scrollButton.fadeIn();
                } else {
                   scrollButton.fadeOut();
                }
               });

               scrollButton.click(function () {
                  scroll_abajo();
               });

               

 
            }
 
    }


    function cargarFooterClickContacto(idContacto)
    {

       $('.cargando_mensajes_chat_interno').fadeOut(300);
       $(".ocultarBarraOpcionesChat").css("display", ""); // Ocultar  

       $(".cuerpo_sin_mensajes").css("display", "none");
       $(".cuerpo_mensaje").css("display", "none"); //habilita las conversaciones

       $(".msb-footer-sin-enviar-mensajes").css("display", "");
       $(".msb-footer").css("display", "none");

       //cargando mensajes de chat
       $(".cuerpo_cargando_mensajes").css("display", "");
       //

       $(".cuerpo_cargando_mensajes").css("display", "none"); //modal carganos
       $(".cuerpo_mensaje").css("display", ""); //habilita las conversaciones

       //aparezca la parte de textarea y botones
       $(".msb-footer-sin-enviar-mensajes").css("display", "none");
       $(".msb-footer").css("display", "");

       //TODA ESTA FUNCION ME PERMITIRA VER MAS A DETALLE (es donde se selecciona staff y cliente)
       let tener_contacto = lista_contactos.find(
          (data) => data.id == idContacto,
       );

       if (!tener_contacto) {
          return true;
       }
 

       //console.log(tener_contacto);

       /*
       if (tener_contacto.custumer_id != null) {
          //cliente
          let data_customer = listado_custumers.find(
             (data) => data.id == tener_contacto.custumer_id,
          );

          if (data_customer) {
             $(".custumers_div").html(
                descripcion_seleccion_custumer_plantilla(data_customer),
             );

             $(".select_custumers")
                .val(tener_contacto.custumer_id)
                .trigger("change");
          }
       } else {
          $(".select_custumers").val(null).trigger("change");
          $(".custumers_div").html("");
       }

       if (tener_contacto.staff_id != null) {
          //staff
          let data_staff = listado_staff.find(
             (data) => data.id == tener_contacto.staff_id,
          );

          if (data_staff) {
             $(".staff_div").html(
                descripcion_seleccion_staff_plantilla(data_staff),
             );

             $(".select_staff")
                .val(tener_contacto.staff_id)
                .trigger("change");
          }

      
       } else {
        
          $(".select_staff").val(null).trigger("change");
          $(".staff_div").html("");
       }

       */


       return false;

    }

    function updateText(prueba) {
       let updatedText = prueba;

       $("input[id^='texto_input_plantilla_header_']").each(function () {
          const value = $(this).val();
          const dataId = $(this).data("id");
          const placeholder = "{{" + dataId + "}}";

          // Escapar el placeholder para usarlo en una expresión regular
          const escapedPlaceholder = placeholder.replace(
             /[.*+?^${}()|[\]\\]/g,
             "\\$&",
          );
          const regex = new RegExp(escapedPlaceholder, "g");

          // Reemplazar el placeholder con el valor o mantener el placeholder si el valor está vacío
          updatedText = updatedText.replace(regex, value || placeholder);
       });

       $("#texto_header_plantilla_previa").text(updatedText);
    }

    function updateTextBody(miTexto) {
       let updatedText = miTexto;

       $("input[id^='texto_input_plantilla_body_']").each(function () {
          const value = $(this).val();
          const dataId = $(this).data("id");
          const placeholder = "{{" + dataId + "}}";

          // Escapar el placeholder para usarlo en una expresión regular
          const escapedPlaceholder = placeholder.replace(
             /[.*+?^${}()|[\]\\]/g,
             "\\$&",
          );
          const regex = new RegExp(escapedPlaceholder, "g");

          // Reemplazar el placeholder con el valor o mantener el placeholder si el valor está vacío
          updatedText = updatedText.replace(regex, value || placeholder);
       });

       $("#texto_body_plantilla_previa").text(updatedText);
    }

    function adjustHeightTexto_TextArea_Header() {
       const textarea = document.getElementById("texto_textarea_header");

       textarea.addEventListener("input", () => {
          // Reset the height to auto to shrink the textarea if necessary
          textarea.style.height = "auto";
          // Set the height to scrollHeight to expand to fit the content
          textarea.style.height = textarea.scrollHeight + "px";

          //const currentText = textarea.value;
          //console.log("Current text:", currentText);
       });

       // Initialize height on page load
       textarea.style.height = "auto";
       textarea.style.height = textarea.scrollHeight + "px";
    }

    function adjustHeightTexto_TextArea_Body(text) {
       const textarea = document.getElementById("texto_textarea_body");

       // Define a function to adjust the height
       const adjustHeight = () => {
          textarea.value = text; // Asigna el texto al textarea

          textarea.style.height = "auto";
          textarea.style.height = textarea.scrollHeight + "px";

          textarea.value = text; // Asigna el texto al textarea
       };

       // Adjust height on input
       textarea.addEventListener("input", adjustHeight);

       // Initialize height on page load
       adjustHeight();
    }

    function seleccionar_archivo_plantilla_headers(
       tipo_documento,
       tipo_archivo,
    ) {
       const htmlContent =
          "<label>Open file</label>" +
          '<input type="file" class="form-control form-control-sm" placeholder="Select a file" id="archivo_plantilla_header" />';

       $(".contenido_principal_header").html(htmlContent);

       const inputFile = document.getElementById(
          "archivo_plantilla_header",
       );
       inputFile.accept = tipo_archivo;

       // Agregar un listener para manejar el archivo seleccionado
       inputFile.addEventListener("change", function () {
               const file = inputFile.files[0];
               if (file) {
                  const reader = new FileReader();
                  reader.onload = function (event) {
                     //const base64String = event.target.result.split(",")[1]; // Eliminar el prefijo de datos
                     //const base64Url = `data:${file.type};base64,${base64String}`;

                     let outputHtml = "";

                     const base64String = reader.result
                        .replace("data:", "")
                        .replace(/^.+,/, "");

                     let htmlToInsert = "";

                     //console.log(base64String);

                     INFORMACION_PLANTILLA_HEADER = base64String;

                     INFORMACION_PLANTILLA_HEADER_EXTENSION = file.type;

                     /* if (file.type.startsWith("image/")) {
                        htmlToInsert =
                           '<div class="contenedor_header_plantilla">' +
                           `<img src="data:${file.type};base64,${base64String}" alt="Selected Image" style="max-width: 100%; height: 180px; object-fit:contain; border-radius:5px">` +
                           "</div>";
                     } else if (file.type === "application/pdf") {
                        htmlToInsert =
                           '<div class="contenedor_header_plantilla">' +
                           `<iframe src="data:${file.type};base64,${base64String}" style="width: 100%; height: 180px;" frameborder="0"></iframe>` +
                           "</div>";
                     } else if (file.type.startsWith("video/")) {
                        htmlToInsert =
                           '<div class="contenedor_header_plantilla" style="min-height:0px">' +
                           `<video controls style="width: 100%; height: auto; border-radius:5px">
                                     <source src="data:${file.type};base64,${base64String}" type="${file.type}">
                                     Your browser does not support the video tag.
                                 </video>` +
                           "</div>";
                     } */

                     if (file.type.startsWith("image/")) {
                        htmlToInsert =
                           '<div class="contenedor_header_plantilla">' +
                           '<img src="data:' +
                           file.type +
                           ";base64," +
                           base64String +
                           '" alt="Selected Image" style="max-width: 100%; height: 180px; object-fit: contain; border-radius: 5px;">' +
                           "</div>";
                     } else if (file.type === "application/pdf") {
                        htmlToInsert =
                           '<div class="contenedor_header_plantilla">' +
                           '<iframe src="data:' +
                           file.type +
                           ";base64," +
                           base64String +
                           '" style="width: 100%; height: 180px;" frameborder="0"></iframe>' +
                           "</div>";
                     } else if (file.type.startsWith("video/")) {
                        htmlToInsert =
                           '<div class="contenedor_header_plantilla" style="min-height: 0px;">' +
                           '<video controls style="width: 100%; height: auto; border-radius: 5px;">' +
                           '<source src="data:' +
                           file.type +
                           ";base64," +
                           base64String +
                           '" type="' +
                           file.type +
                           '">' +
                           "Your browser does not support the video tag." +
                           "</video>" +
                           "</div>";
                     }
                     $(".plantilla-header").html(htmlToInsert);
                  };

                  reader.readAsDataURL(file);
               }
       });
    }



    function cargar_fecha() {
       const today = new Date();

       // Formatear la fecha como YYYY-MM-DD
       const year = today.getFullYear();
       const month = String(today.getMonth() + 1).padStart(2, "0"); // Mes de 2 dígitos
       const day = String(today.getDate()).padStart(2, "0"); // Día de 2 dígitos

       const formattedDate = year + "-" + month + "-" + day;
       return formattedDate;
    }
 
    function isEmpty(value) {
       // Verificar si es null o undefined
       if (value == null) return true;

       // Verificar si es una cadena vacía
       if (typeof value === "string" && value.trim() === "") return true;

       // Verificar si es un array vacío
       if (Array.isArray(value) && value.length === 0) return true;

       // Verificar si es un objeto vacío
       if (typeof value === "object" && Object.keys(value).length === 0) return true;

       return false;
    }

 
</script>
{/literal}

{/block}