{extends file="$layouts_admin"}
{block name="head"}

   <link href="{$theme}default/css/grupo.css?v={$config['version']}" rel="stylesheet">
 
           
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">       

{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    table.estilosTabla > :not(caption) > * > * {
        /*
        padding-top: 5px !important;
        padding-bottom: 5px !important;
        */
    }

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
        
    }

    #texto_body_plantilla_previa
    {
        margin: 0px;
    }

  

    
.offcanvas_ {
   position: fixed;
   top: 0;
   bottom: 0;
   right: -500px; /* Initially hide offcanvas */
   width: 500px;
   background-color: white;
   overflow-y: auto;
   transition: right 0.3s ease-in-out;
   z-index: 2030;
   display: flex;
   flex-direction: column;
   max-width: 100%;
   background-clip: padding-box;
   outline: 0;
   box-shadow: white 0px 3px 6px, #646464 0px 3px 6px !important;
}

.offcanvas-show {
   right: 0; /* Show offcanvas */
}
.offcanvas-backdrop {
   position: fixed;
   top: 0;
   bottom: 0;
   left: 0;
   right: 0;
   background-color: rgba(0, 0, 0, 0.5);
   display: none;
   z-index: 1030;
}

.offcanvas-header {
   display: flex;
   align-items: center;
   /* padding: 1.5rem 1rem; */
   padding: 9px;
   justify-content: space-between;
   border-bottom: 1px solid #b7b7b7;
}

.offcanvas-title {
   margin-bottom: 0;
   line-height: 1.5;
   font-weight: 600;
}

.btn-close-offcanvas {
   /* background-color: transparent;
   border: none;
   font-size: 14px; */
}

.estilos_p{
   color: black;
   font-weight: 600;
   margin: 0px;
}

.estilos_p_resultado{
   color: black;
    margin: 0px;
}

</style>

<input
         type="text"
         value="{$path_img}"
         disabled
         hidden
         id="PATH_IMG"
      />

      <input
         type="text"
         value="{$url_qualify}"
         disabled
         hidden
         id="URL_QUALIFY"
      />

<div class="row">

    <div class="col-md-12">

       
        <div class="panel">
            <div class="panel-hdr">
                <h2 style="color: #666; font-weight: 600; "><span></span>List of WhatsApp templates</h2>
                <input type="text" class=" tener_url_base" value={$url_base} disabled hidden/>

            </div>
                                                         
            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">

                    <div class="px-2">
                        
                        <div class="row contenedor" style="padding: 10px">

                           <div class="col-12 col-sm-6 pt-3">
                                <label for="fecha_desde"><span style="color:#666;">Date from</span> </label>
                                 
                                 <input
                                    type="date"
                                    id="fecha_desde"
                                    name="fecha_desde"
                                    class="form-control form-control-sm fecha_desde"
                                />

                           </div>

                           <div class="col-12 col-sm-6 pt-3">
                                <label for="fecha_hasta"><span style="color:#666;">Date to</span> </label>
                                 
                                 <input
                                    type="date"
                                    id="fecha_hasta"
                                    name="fecha_hasta"
                                    class="form-control form-control-sm fecha_hasta"
                                />

                           </div>
 

                            {* listado de configuracion *}
                            <div class="col-12 col-sm-12 pt-3">
                                <label for="configuracion"><span style="color:#666;">WhatsApp settings</span> </label>
                                <select
                                    class="form-select form-select-sm  tener_configuracion"
                                    name="configuracion"
                                    id="configuracion"
                                    style="width: 100%"
                                    placeholder="Select a settings"
                                >

                                    {foreach $listado_empresas as $ds}
                                       <option value="{$ds['id']}" >{$ds['identifier']}</option>
                                    {/foreach}
                                </select>
                            </div>

                           
                             
                            <div class="col-12 col-sm-12 pt-3">
                              
                                <button
                                    type="button"
                                    class="btn btn-default"
                                    id="consultar_filtros"
                                    style="
                                        border-color: #d3cac0;
                                        border: 1px solid #d3cac0;
                                        float: right;
                                    "
                                >
                                    Search
                                </button>
                              
                            

                            </div>

   
                           
                            <br />
                             
                            <div class="col-12 col-sm-12 pt-4">
                            
                            
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover mt-3 estilosTabla"  id="clx_datatable">
                                        <thead>
                                        <tr>
                                            <th class="centrar">WhatsApp configuration identifier</th>
                                            <th class="centrar">Template name</th>
                                            <th class="centrar">From</th>
                                            <th class="centrar">To</th>
                                            <th class="centrar">Configuration date</th>
                                            <th class="centrar">Configuration time</th>
                                            <th class="centrar">Staff</th>
                                            <th class="centrar"></th>
                                             
                                        </tr>
                                        </thead>
                                        <tbody class="tbody_envios">

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            </div>

                       
                    </div>

                  

                </div>

                {**}
               <div class="block bloqueo_v1" style="display:none" hidden></div>
                <div class="block blockOverlay bloqueo_v2" hidden style="z-index: 21000; border: none; margin: 0px; padding: 0px; width: 100%; height: 100%; top: 0px; left: 0px; background-color: rgb(0, 0, 0); opacity: 0.6; cursor: wait; position: absolute;" ></div>
                <div
                    class="block blockMsg blockElement bloqueo_v3"
                    hidden
                    style="
                        z-index: 201100;
                        position: absolute;
                        padding: 0px;
                        margin: 0px;
                        width: 100%;
                        top: 50%;
                         
                        text-align: center;
                        color: rgb(0, 0, 0);
                        cursor: wait;
                    "
                    >
                     
                    <div class="md-preloader text-center">
                        <svg
                            xmlns="http://www.w3.org/2000/svg"
                            version="1.1"
                            height="32"
                            width="32"
                            viewBox="0 0 75 75"
                        >
                            <circle cx="37.5" cy="37.5" r="33.5" stroke-width="6"></circle>
                        </svg>
                    </div>

                     <div class="text-center mt-6" style="
                                                                color: white;
                                                                font-weight: 600;
                                                                font-size: 15px;
                                                            ">
                        Please wait while the information loads.
                    </div>
                </div>
 
                
               
            </div>
        </div>
    </div>
</div>

<!--configuracion a la derecha-->
      <div class="offcanvas_" id="offcanvas-menu">

         <div class="row" style=" height: 100vh; padding: 0px; margin: 0px; ">

            <div class="col-11" style=" padding: 0px; ">

               <div class="offcanvas-header" >
                  <h3  style=" margin: 4px; " class="offcanvas_titulo">Template detail</h3>
               </div>

               <div class="card_seguro_desea_crear_usuario">

                  <div class="card mb-3" style=" margin: 13px; box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; ">
                     
                    
                     <div class="card-body position-relative" style=" padding: 11px; ">
                        <div class="row">

                           <div class="col-12 col-sm-6">
                              <p class="estilos_p">
                                 Category:
                              </p>     
                           </div>

                           <div class="col-12 col-sm-6">
                              <p class="estilos_p_resultado texto_categoria">
                                 Category
                              </p>     
                           </div>

                           <div class="col-12 col-sm-6 mt-2">
                              <p class="estilos_p">
                                 Language:
                              </p>     
                           </div>

                           <div class="col-12 col-sm-6 mt-2">
                              <p class="estilos_p_resultado texto_idioma">
                                 Language
                              </p>     
                           </div>

                           <div class="col-12 col-sm-6 mt-2">
                              <p class="estilos_p">
                                 State template:
                              </p>     
                           </div>

                           <div class="col-12 col-sm-6 mt-2">
                              <span class="badge rounded-pill bg-success estado_plantilla">APPROVED</span>   
                           </div>

                        </div>
                     </div>
                  </div>
               
               </div>
            
                <div class="sticky-header" style=" margin: 13px; box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; ">
                   <div class="plantilla_vista_previa">

                      <div class="plantilla_vista_previa_headers">
                         <p
                            style="
                               font-weight: 600;
                               font-size: 17px;
                               padding: 16px;
                               height: 100%;
                               padding-bottom: 0px;
                               color: black;
                            "
                         >
                            Template preview
                         </p>
                      </div>

                      <div class="plantilla_vista_previa_body">
                         <div class="message-feed media right">
                            <div
                               class="media-body media-body-change-display"
                            >
                               <div
                                  class="mf-content extender-contenedores"
                               >
                                  <div class="palomitas">
                                     <div class="izquierda">
                                        <!-- header -->
                                        <div
                                           class="plantilla-header"
                                        >
                                           <!--TEXTO NORMAL-->
                                           <!-- <p id="texto_header_plantilla_previa">
                                           Hello, World
                                        </p> -->

                                           <!--IMAGEN-->
                                           <!-- <div
                                           class="imagen_header_plantilla"
                                        ></div> -->

                                           <!--VIDEO-->
                                           <!-- <div
                                           class="video_header_plantilla"
                                        ></div> -->

                                           <!--DOCUMENTO-->
                                           <!-- <div
                                           class="documento_header_plantilla"
                                        ></div> -->
                                        </div>
                                        <!-- FIN header -->

                                        <!-- body -->
                                        <div class="plantilla-body">
                                           <p
                                              id="texto_body_plantilla_previa"
                                           >
                                              Welcome and
                                              congratulations!! This
                                              message demonstrates
                                              your ability to send a
                                              WhatsApp message
                                              notification from the
                                              Cloud API, hosted by
                                              Meta. Thank you for
                                              taking the time to test
                                              with us.
                                           </p>
                                        </div>
                                        <!-- FIN body -->

                                        <!-- FOOTER -->
                                        <div
                                           class="plantilla-footer"
                                        >
                                           <span
                                              id="texto_footer_plantilla_previa"
                                           >
                                              Soy footer a que si
                                           </span>
                                        </div>
                                        <!-- FIN FOOTER -->
                                     </div>
                                  </div>
                                  <small class="mf-date"
                                     ><div>
                                        01-08-2024 12:00 pm
                                     </div></small
                                  >
                                  <div class="mensajes_botones">
                                     <div class="div_mensaje_boton">
                                        <img
                                           src="{$path_img}telefono.png"
                                        />
                                        <a
                                           href=""
                                           class="angotar_mensajes_botones"
                                        >
                                           asass</a
                                        >
                                     </div>
                                     <hr class="class_hr" />
                                  </div>
                               </div>
                            </div>
                         </div>
                      </div>

                   </div>
                </div>
 
  
          
            </div>

            <div class="col-1" style="border: 1px solid #b7b7b7;padding: 0px; background-color: #001b3b;">
            
               {*  *}
               <div style=" width: 100%; height: 49px; border-bottom: 1px solid #b7b7b7; ">

                  <button type="button" class="btn hover_boton_setting btn-close-offcanvas" style=" width: 100%; height: 100%; ">
                     <i class="fa fa-times" style="font-size:14px;display: flex;justify-content: center;align-items: center;color: white;"  ></i>  
                  </button>

               </div>
               {*  *}

               {*   
               <div style=" width: 100%; height: 49px; border-bottom: 1px solid #b7b7b7; ">

                  <button type="button" class="btn hover_boton_setting btn_editar_plantilla" style=" width: 100%; height: 100%; ">
                     <i class="fa-solid fa-pen-to-square" style="font-size:14px;display: flex;justify-content: center;align-items: center;color: white;"  ></i>  
                  </button>
 
               </div>*}
               {*  *}

               {*  *}
               <div style=" width: 100%; height: 49px; border-bottom: 1px solid #b7b7b7; background:red; ">

                  <button type="button" class="btn hover_boton_setting btn_eliminar_plantilla" style=" width: 100%; height: 100%; ">
                     <i class="fa-solid fa-trash-can" style="font-size:14px;display: flex;justify-content: center;align-items: center;color: white;"  ></i>  
                  </button>

                  
 
               </div>
               {*  *}

               

            </div>

         </div>

          

          
      </div>

      <!--FIN configuracion a la derecha-->
      <div class="offcanvas-backdrop" id="offcanvas-backdrop"></div>




{/block}

{block name="script"}

 
<script src="{$theme}default/js/whatsapp.js?v={{_raid()}}"></script>

<script src="{$theme}default/js/plantillas.js?v={{_raid()}}"></script>

{literal}
<script>

 
   const URL_BASE      = $(".tener_url_base").val();
   const tener_role_id = $(".tener_role_id").val();
   var PATH_IMG_      = $("#PATH_IMG").val();
   var listado_plantillas = [];
 
 
    //cargar_usuarios_sistema().then((listado_usuarios_admin) =>{
    //    $(".tener_usuario_id").html(
    //        select_html_usuario_sistema(listado_usuarios_admin),
    //    );
    //});
 
   let fecha = cargar_fecha();
   $(".tener_fecha_desde").val(fecha);
   $(".tener_fecha_hasta").val(fecha);

   var $offcanvasMenu = $("#offcanvas-menu");
   var $offcanvasBackdrop = $("#offcanvas-backdrop");
   var $offcanvasClose = $(".btn-close-offcanvas");
   
   var URL_MODIFICAR_PLANTILLA = "";

   var PLANTILLA_ID_ELIMINAR = "";
   var PLANTILLA_CSPM_ID_ELIMINAR = "";
   var PLANTILLA_NOMBRE_ELIMINAR = "";

 
    //$('#clx_datatable').DataTable();
 
 
         $("#consultar_filtros").click(function () {


            let tener_configuracion = $(".tener_configuracion").val() || "";
 
            let fecha_desde = $(".fecha_desde").val() || "";
            let fecha_hasta = $(".fecha_hasta").val() || "";
 
            let enviar_informacion = {
               fecha_desde: fecha_desde,
               fecha_hasta: fecha_hasta,
               configuracion_id: tener_configuracion,
            };

            console.log(enviar_informacion);
            console.log("aqui abajo ahi un return");
            console.log(URL_BASE);

            //return;
            
            $("#consultar_filtros").prop("disabled", true);

            ejecutar_consulta(enviar_informacion);
             
         });

        function ejecutar_consulta(enviar_informacion, aplicar_mensaje = true) {

            if(aplicar_mensaje == true){
               $(".bloqueo_v1").removeAttr("hidden");
               $(".bloqueo_v2").removeAttr("hidden");
               $(".bloqueo_v3").removeAttr("hidden");
            }

            $.ajax({
               type: "POST",
               url: URL_BASE + "social/get-list-scheduled-messages",
               data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
               contentType: "application/json", // Tipo de contenido JSON
               success: function (response) {
                  
                  $("#consultar_filtros").prop("disabled", false);
                  //console.log("Respuesta del servidor:", response);
                  // Hacer algo con la respuesta del servidor
                  //$("#myModal").modal("hide");
                  $(".tbody_envios").html("");

                  if(aplicar_mensaje == true){
                     $(".bloqueo_v1").attr("hidden", true);
                     $(".bloqueo_v2").attr("hidden", true);
                     $(".bloqueo_v3").attr("hidden", true);
                  }

                  try {
                     let info = JSON.parse(response);
                     if (info.type == "success") {
                        
                        let arr = info.data;
                        if (arr == "") {
                           $(".tbody_envios").html(
                              '<tr><th colspan="8" class="centrar pt-4"> No information</th></tr>',
                           );
                        } else {
                           $(".tbody_envios").html(arr);

                           console.log("info");
                           console.log(info.data_);

                           eliminar_plantilla();

                           //modificar_plantilla();

                           abrir_detalle_plantilla();


                           listado_plantillas = info.data_ || [];

                           PLANTILLA_ID_ELIMINAR = "";
                           PLANTILLA_NOMBRE_ELIMINAR = "";
                           PLANTILLA_CSPM_ID_ELIMINAR = "";

                        }


                     } else {
                        alert("Error sending group messages");
                     }
                  } catch (error) {
                     $(".tbody_envios").html("");
                     alert("Error:" + error);
                  }
               },
               error: function (xhr, status, error) {
                  $("#consultar_filtros").prop("disabled", false);
                  $(".tbody_envios").html("");
                  console.error("Error en la solicitud:", error);

                  $(".bloqueo_v1").attr("hidden", true);
                  $(".bloqueo_v2").attr("hidden", true);
                  $(".bloqueo_v3").attr("hidden", true);
               },
            });

        }

         function eliminar_plantilla() {
            
            $(".btn_eliminar").on("click", function() {
                // Obtener el valor del atributo data-id
                const plantilla_id = $(this).data("id");
                const cspm_id = $(this).data("cspm_id");

               PLANTILLA_ID_ELIMINAR = plantilla_id|| "";
               PLANTILLA_CSPM_ID_ELIMINAR = cspm_id || "";
 
                $(this).prop("disabled", true);
 
                // Mostrar el ID (para depuración)
                console.log("ID de la plantilla a eliminar: " + plantilla_id);

                Swal.fire({
                    title: "Delete template?",
                    text: "Are you sure you want to delete this template?",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#d33",
                    cancelButtonColor: "#3085d6",
                    confirmButtonText: "Yes",
                    cancelButtonText: "No"
                }).then((result) => {
                    if (result.isConfirmed) {

                        let tener_configuracion = $(".tener_configuracion").val() || "";

                        let enviar_informacion = {
                            id: PLANTILLA_ID_ELIMINAR,
                            cspm_id: PLANTILLA_CSPM_ID_ELIMINAR,
                            configuracion_id: tener_configuracion,
                        };

                        console.log("El usuario confirmó la eliminación de la plantilla");
                        console.log(enviar_informacion);

                        //return;

                        $.ajax({
                        type: "POST",
                        url: URL_BASE + "social/delete-scheduled-messages",
                        data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
                        contentType: "application/json", // Tipo de contenido JSON
                        success: function (response) {
                            
                            $(this).prop("disabled", false);

                            //console.log("Respuesta del servidor:", response);
                            // Hacer algo con la respuesta del servidor
                           
                            try {
                                let info = JSON.parse(response);
                                if (info.type == "success") {
                         

                                    Swal.fire({
                                        title: "",
                                        text: info.message,
                                        icon: "success",
                                    });
 
                                    let tener_configuracion = $(".tener_configuracion").val() || "";
 
                                    let fecha_desde = $(".fecha_desde").val() || "";
                                    let fecha_hasta = $(".fecha_hasta").val() || "";
                        
                                    let enviar_informacion = {
                                       fecha_desde: fecha_desde,
                                       fecha_hasta: fecha_hasta,
                                       configuracion_id: tener_configuracion,
                                    };
 
                                    ejecutar_consulta(enviar_informacion);


                                } else {
                                    //alert("Error sending group messages");

                                    Swal.fire({
                                        title: "",
                                        text: info.message,
                                        icon: "error",
                                    });

                                }
                            } catch (error) {
                                 
                                //alert("Error:" + error);

                                Swal.fire({
                                    title: "",
                                    text: error,
                                    icon: "error",
                                });
                            }
                        },
                        error: function (xhr, status, error) {
                            $(this).prop("disabled", false);
                           
                            console.error("Error en la solicitud:", error);
                        },
                        });

 
                    }else{
                        $(this).prop("disabled", false);
                    }
                });

                 
            });

         }

        function modificar_plantilla(){
            $(".btn_modificar").on("click", function() {



                console.log("modificar plantilla");

                // Obtener el valor del atributo data-id
                const plantilla_id = $(this).data("id");
                const nombre_plantilla = $(this).data("nombre");
                const categoria = $(this).data("categoria");

               
               /*

                let tener_configuracion = $(".tener_configuracion").val() || "";

                if(isEmpty(tener_configuracion)) {
                    
                    Swal.fire({
                        title: "",
                        text: "!Please select a WhatsApp settings¡",
                        icon: "error",
                    });

                    return;
                }

                if(categoria =="MARKETING")
                {
                    //window.location = URL_BASE + "template/update-whatsapp-utility-template/" + nombre_plantilla + "/" + tener_configuracion;
                }

                if(categoria == "AUTHENTICATION")
                {
                    //window.location = URL_BASE + "template/update-whatsapp-autentificacion-template/" + nombre_plantilla + "/" + tener_configuracion;
                }

 
                console.log(URL_BASE)
                */

                 
            });
        }

        function abrir_detalle_plantilla(){
            
             
            $(".click_fila").on("click", function() {

               const id = $(this).closest('tr').data("id");
               const cspm_id = $(this).closest('tr').data("cspm_id");

               PLANTILLA_ID_ELIMINAR = id|| "";
               PLANTILLA_CSPM_ID_ELIMINAR = cspm_id || "";

               if(isEmpty(id) == true)
               {
                   Swal.fire({
                      icon: "error",
                      title: "Oops...",
                      text: "The template id was not found",
                   });
                   return;
               }

               //console.log("id");
               //console.log(id);
               //return;

               //URL_MODIFICAR_PLANTILLA = $(this).closest('tr').find(".btn_modificar").attr("href");

               //console.log("click_fila plantilla");
               //console.log(nombre_plantilla);
               //console.log(listado_plantillas);

               let plantilla = listado_plantillas.find((data) => data.id  == id);
 
               if(plantilla)
               {
                  var existeHeaders = false;
                  $(".contenido_principal_header").html("");


                  var miArregloBotones = [];
                  var buttons_controlador = [];

                  /*
                  //HEADER INFORMACION
                  //header
                  $("#input_header_plantilla").val("None");
                  $(".contenido_principal_header").html("");

                  //body
                  $(".contenido_principal_body").html("");

                  //footer
                  $(".footer_plantilla").hide();

                  $(".buttons_plantilla").hide();

                  //VISTA PREVIA
                  //$("#texto_header_plantilla_previa").text("");
                  //header
                  $(".plantilla-header").html("");

                  //body
                  $("#texto_body_plantilla_previa").text("");

                  //footer
                  $("#texto_footer_plantilla_previa").text("");

                  //botones
                  $(".mensajes_botones").hide();
                  $(".mensajes_botones").html("");
                  */

                  $(".mensajes_botones").html("");

                  $("#texto_footer_plantilla_previa").text("");

                  $(".plantilla-header").html(
                     ""
                  );

                  if(isEmpty(plantilla.template_original) == false)
                  {
                     ///let temp_templates_original = JSON.parse(plantilla.template_original);
                     ///let temp_templates_data = JSON.parse(plantilla.template_data);

                     console.log(JSON.parse(plantilla.template_original));
                     console.log(JSON.parse(plantilla.template_data));
                     console.log(JSON.parse (JSON.parse(plantilla.consumer_template)));

                     var template_original = JSON.parse(plantilla.template_original);
                     var template_data     = JSON.parse(plantilla.template_data);


                     //console.log("template_data")
                     //console.log(template_data)

                     //return;
                     //let components = temp_templates_original.components || [];

                     status == "failed"
                           ? "Codigo (" + error_codigo + ") " + error_mensaje
                           : "";

                     let url_status_img = PATH_IMG + status + ".png";
                     let tamaño_palomita =
                        status == "read" ? "18px" : status == "wait" ? "16px" : "20px";

                     if (template_original != null && template_data != null) {
                        let temp_templates_original = JSON.parse(plantilla.template_original);
                        let temp_templates_data = JSON.parse(plantilla.template_data);

                        let { components: components_original_templates } =
                           temp_templates_original;

                        //console.log("templates original");
                        //console.log(components_original_templates);
                        //console.log("templates data");
                        //console.log(temp_templates_data);

                        var mensaje_cabecera = "";
                        var mensaje_body = "";
                        var mensaje_footer = "";
                        var mensaje_botones = "";

                        components_original_templates.forEach((elementos) => {
                           let { type, text, format, example, buttons } = elementos;

                           if (type == "HEADER") {
                              let formato_minuscula = format.toLowerCase();

                              if (formato_minuscula == "text") {
                                 if (example != null || example != undefined) {
                                    let contenido = temp_templates_data.find(
                                       (data) =>
                                          data.format == formato_minuscula && data.type == type,
                                    );

                                    mensaje_cabecera = text;

                                    mensaje_cabecera = reemplazarComodinPorText(
                                       mensaje_cabecera,
                                       "{{1}}",
                                       contenido.contenido,
                                    );

                                    $(".plantilla-header").html(
                                       "<p id='texto_header_plantilla_previa'>" +
                                          mensaje_cabecera +
                                       "</p>",
                                    );

                                 } else {
                                    mensaje_cabecera = text;

                                    $(".plantilla-header").html(
                                       "<p id='texto_header_plantilla_previa'>" +
                                          mensaje_cabecera +
                                       "</p>",
                                    );
                                 }
                              }

                              if (formato_minuscula == "image") {
                                    
                                 try {
                                    let data_completa = JSON.parse(JSON.parse(plantilla.consumer_template))

                                    if(isEmpty(data_completa) == false)
                                    {
                                       let templates_ = data_completa.template;

                                       if(isEmpty(templates_) == false)
                                       {
                                          let componente_ = templates_.components || [];

                                          let compleComponente = validateArrayOEmpty(componente_);

                                          //console.log("compleComponente")
                                          //console.log(compleComponente)

                                          if(compleComponente == true)
                                          {
                                             let componente_header = componente_[0];

                                             let parametro = componente_header.parameters[0]

                                             //console.log("parametro")
                                             //console.log(parametro)

                                             let url = parametro.image.link;

                                             //console.log("url")
                                             //console.log(url)

                                             if(isEmpty(url) == false)
                                             {
                                                mensaje_cabecera =
                                                   '<div class="contenedor_header_plantilla">' +
                                                   '<img src="' +
                                                   url +
                                                   '" alt="Selected Image" style="max-width: 100%; height: 180px; object-fit: contain; border-radius: 5px;">' +
                                                   "</div>";

                                                   $(".plantilla-header").html(mensaje_cabecera);

                                                 

                                             }else{
                                                $("#input_header_plantilla").val("IMAGE");

                                                $(".plantilla-header").html(
                                                   '<div class="imagen_header_plantilla">' +
                                                      "</div>",
                                                );
                                             }

                                          }else{
                                             $("#input_header_plantilla").val("IMAGE");

                                             $(".plantilla-header").html(
                                                '<div class="imagen_header_plantilla">' +
                                                   "</div>",
                                             );
                                          }
                                           
                                       }else{
                                          $("#input_header_plantilla").val("IMAGE");

                                          $(".plantilla-header").html(
                                             '<div class="imagen_header_plantilla">' +
                                                "</div>",
                                          );
                                       }

                                        
                                    }
                                     
                                 } catch (e) {

                                    $("#input_header_plantilla").val("IMAGE");

                                    $(".plantilla-header").html(
                                       '<div class="imagen_header_plantilla">' +
                                          "</div>",
                                    );

                                     
                                 }

                              }

                              if (formato_minuscula == "document") {

                                 try {
                                    let data_completa = JSON.parse(JSON.parse(plantilla.consumer_template))

                                    if(isEmpty(data_completa) == false)
                                    {
                                       let templates_ = data_completa.template;

                                       if(isEmpty(templates_) == false)
                                       {
                                          let componente_ = templates_.components || [];

                                          let compleComponente = validateArrayOEmpty(componente_);

                                          //console.log("compleComponente")
                                          //console.log(compleComponente)

                                          if(compleComponente == true)
                                          {
                                             let componente_header = componente_[0];

                                             let parametro = componente_header.parameters[0]

                                             //console.log("parametro")
                                             //console.log(parametro)

                                             let url = parametro.document.link;

                                             //console.log("url")
                                             //console.log(url)

                                             if(isEmpty(url) == false)
                                             {
              
                                                 mensaje_cabecera =
                                                   '<div class="contenedor_header_plantilla">' +
                                                   '<iframe src="' +
                                                   url +
                                                   '" style="width: 100%; height: 180px;" frameborder="0"></iframe>' +
                                                   "</div>";

                                                   $(".plantilla-header").html(mensaje_cabecera);

                                                let compleHeader = validateArrayOEmpty(componente_header);

                                             }else{
                                                $("#input_header_plantilla").val("DOCUMENT");

                                                $(".plantilla-header").html(
                                                   '<div class="documento_header_plantilla">' +
                                                      "</div>",
                                                );
                                             }

                                          }else{
                                             $("#input_header_plantilla").val("DOCUMENT");

                                             $(".plantilla-header").html(
                                                '<div class="documento_header_plantilla">' +
                                                   "</div>",
                                             );
                                          }
                                           
                                       }else{
                                          $("#input_header_plantilla").val("DOCUMENT");

                                          $(".plantilla-header").html(
                                             '<div class="documento_header_plantilla">' +
                                                "</div>",
                                          );
                                       }

                                        
                                    }
                                     
                                 } catch (e) {

                                    $("#input_header_plantilla").val("DOCUMENT");

                                    $(".plantilla-header").html(
                                       '<div class="documento_header_plantilla">' +
                                          "</div>",
                                    );

                                     
                                 }

                          

                              }

                              if (formato_minuscula == "video") {

                                 try {
                                    let data_completa = JSON.parse(JSON.parse(plantilla.consumer_template))

                                    if(isEmpty(data_completa) == false)
                                    {
                                       let templates_ = data_completa.template;

                                       if(isEmpty(templates_) == false)
                                       {
                                          let componente_ = templates_.components || [];

                                          let compleComponente = validateArrayOEmpty(componente_);

                                          console.log("compleComponente")
                                          console.log(compleComponente)

                                          if(compleComponente == true)
                                          {
                                             let componente_header = componente_[0];

                                             let parametro = componente_header.parameters[0]

                                             console.log("parametro")
                                             console.log(parametro)

                                             let url = parametro.video.link;

                                             console.log("url")
                                             console.log(url)

                                             if(isEmpty(url) == false)
                                             {
            
                                                let mensaje_cabecera = `
                                                   <div class="contenedor_header_plantilla" style="min-height: 0px;">
                                                      <video controls style="width: 100%; height: auto; border-radius: 5px;" onerror="console.error('Error al cargar el video:', this.error)">
                                                            <source src="${url}" type="video/mp4">
                                                            Your browser does not support the video tag.
                                                      </video>
                                                   </div>
                                                `;

                                                if ($(".plantilla-header").length === 0) {
                                                   console.error("El elemento .plantilla-header no existe en el DOM");
                                                } else {
                                                   $(".plantilla-header").html(mensaje_cabecera);
                                                   // Verificar si el video se carga
                                                   $(".plantilla-header video").on("loadeddata", function() {
                                                      console.log("Video cargado correctamente");
                                                   }).on("error", function(e) {
                                                      console.error("Error al reproducir el video:", e.target.error);
                                                   });
                                                }

                                             }else{
                                                $("#input_header_plantilla").val("VIDEO");

                                                $(".plantilla-header").html(
                                                   '<div class="video_header_plantilla">' +
                                                      "</div>",
                                                );
                                             }

                                          }else{
                                             $("#input_header_plantilla").val("VIDEO");

                                             $(".plantilla-header").html(
                                                '<div class="video_header_plantilla">' +
                                                   "</div>",
                                             );
                                          }
                                           
                                       }else{
                                          $("#input_header_plantilla").val("VIDEO");

                                          $(".plantilla-header").html(
                                             '<div class="video_header_plantilla">' +
                                                "</div>",
                                          );
                                       }

                                        
                                    }
                                     
                                 } catch (e) {

                                    $("#input_header_plantilla").val("VIDEO");

                                    $(".plantilla-header").html(
                                       '<div class="video_header_plantilla">' +
                                          "</div>",
                                    );

                                     
                                 }
 
                              }

                              if (formato_minuscula == "location") {
                                 let contenido = temp_templates_data.find(
                                    (data) =>
                                       data.format == formato_minuscula && data.type == type,
                                 );

                                 mensaje_cabecera =
                                    '<div class="plantilla-header">' +
                                    '<div class="imagen_header_plantilla_location"></div>' +
                                    '<p style="margin-bottom:0px;font-size: 11px; color: black;" class="p_headers_name_location">' +
                                    contenido.name +
                                    "</p>" +
                                    '<p style="font-size: 11px; color: black;" class="p_headers_address_location">' +
                                    contenido.address +
                                    "</p>" +
                                    "</div>";

                                    $("#input_header_plantilla").val("LOCATION");

                                    $(".plantilla-header").html(
                                       '<div class="imagen_header_plantilla_location">' +
                                          "</div>",
                                    );

                                    let nombre_location =  contenido.name;

                                    $(".plantilla-header").append(
                                       '<p style="margin-bottom:0px;font-size: 11px; color: black;" class="p_headers_name_location">{{nombre_location}}' +
                                          "</p>",
                                    );

                                    $(".plantilla-header").append(
                                       '<p style="font-size: 11px; color: black;" class="p_headers_address_location">{{contenido.address}}' +
                                          "</p>",
                                    );
                              }
                           }

                           if (type == "BODY") {
                              if (example != null || example != undefined) {
                                 let contenido_b = temp_templates_data.find(
                                    (data) => data.type == type,
                                 );

                                 if (contenido_b) {
                                    let tem_body_text = text;
                                    contenido_b.contenido.forEach((element) => {
                                       let { buscar, texto } = element;
                                       tem_body_text = reemplazarComodinPorText(
                                          tem_body_text,
                                          buscar,
                                          texto,
                                       );
                                    });

                                    mensaje_body = tem_body_text; // Asegúrate de que `mensaje_body` no sobrescriba `mensaje_cabecera`

                                    $(".plantilla-body").html(
                                       "<p id='texto_body_plantilla_previa'>" +
                                          mensaje_body +
                                       "</p>"
                                    );
                                 }
                              } else {
                                 mensaje_body = text;

                                 $(".plantilla-body").html(
                                    "<p id='texto_body_plantilla_previa'>" +
                                       mensaje_body +
                                    "</p>"
                                 );
                              }
                           }

                           if (type == "FOOTER") {
                              mensaje_footer = text;

                              $("#texto_footer_plantilla_previa").text(mensaje_footer);
                           }

                           if (type == "BUTTONS") {
                              mensaje_botones = '<div class="mensajes_botones">';
 
                              var html_input_buttons = "";
                              var html_input_buttons_vista_previa = "";

                              let contador_url = 0;

                              buttons.forEach((element, index, array) => {
                                 let typeButtonValue = element.type;
                                 let textButtonValue = element.text;
                                 let textButtonURL = element.url;
                                 let textButtonPhoneNumber = element.phone_number;
                                 let required = element.example;
 
                                 if(typeButtonValue == "URL")
                                 {
                                    contador_url++;
                                    
                                    miArregloBotones.push({
                                       type: typeButtonValue + contador_url,
                                       text: textButtonValue,
                                       url: textButtonURL || "",
                                       phone_number: textButtonPhoneNumber || "",
                                       requerido: Array.isArray(required) == true? (required.length != 0 ? required[0] : ""  ) : "",
                                    });

                                 }else{
                                    miArregloBotones.push({
                                       type: typeButtonValue,
                                       text: textButtonValue,
                                       url: textButtonURL || "",
                                       phone_number: textButtonPhoneNumber || "",
                                       requerido: Array.isArray(required) == true? (required.length != 0 ? required[0] : ""  ) : "",
                                    });
                                 }
                                 
                              
                                 
                              });

                              mensaje_botones += "</div>";
                           }
                        });

                        console.log("miArregloBotones");
                        console.log(miArregloBotones);

                        miArregloBotones.forEach((elementos, index) => {
                           
                           let {
                              type = "",
                              text = "",
                              url ="",
                              phone_number = "",
                              requerido,
                           } = elementos;

                           if(type != "QUICK_REPLY" )
                           {
                              if(type == "URL1")
                              {
                                 
                                 buttons_controlador.push({
                                    "type": "URL1",
                                    "text": text
                                 });

                              }

                              if(type == "URL2")
                              {
                                 buttons_controlador.push({
                                    "type": "URL2",
                                    "text": text
                                 });

                              }     

                              if(type == "PHONE_NUMBER")
                              {
                                 buttons_controlador.push({
                                    "type": "PHONE_NUMBER",
                                    "text": text
                                 });
                              }  

                              if(type == "COPY_CODE")
                              {
                                 buttons_controlador.push({
                                    "type": "COPY_CODE",
                                    "text": text
                                 });
                              }  

                           }else{

                              //seccion de solo QUICK_REPLY

                              //console.log("index");
                              //console.log(index);
         
                              buttons_controlador.push({
                                 "type": "QUICK_REPLY",
                                 "text": text,
                                 
                              });
                              
         


                           }

         
                        });

                        dibujar_botones(buttons_controlador);

                         
                        /*

                        // Construcción del nuevo HTML
                        var imageSrc = "https://bootdey.com/img/Content/avatar/avatar1.png"; // Ejemplo de URL de imagen

                        var textHeader =
                           isEmpty(mensaje_cabecera) == false
                              ? "<p class='texto_header_mensaje'>" + mensaje_cabecera + "</p>"
                              : "";
                        var textFooter = isEmpty(mensaje_footer) == true ? "" : mensaje_footer;

                        let img_whatsapp = PATH_IMG + "whatsapp.png";
                        var img_default = PATH_IMG + "perfil.jpg";

                        // Construcción del nuevo HTML
                        var nuevoMensaje =
                          
                           '<div class="message-feed media right blur-in"   >' +
                           '<div class="pull-right">' +
                           '<div class="image-container-perfil">' +
                        
                           "</div>" +
                           "</div>" +
                           '<div class="media-body media-body-change-display">' +
                           '<div class="mf-content mf-content-documentos">' +
                           '<div class="palomitas">' +
                           '<div class="plantilla-header-mensaje">' +
                           textHeader + // Variable de contenido aquí
                           "</div>" +
                           '<div class="plantilla-body-mensaje">' +
                           '<p class="texto_body_mensaje">' +
                           mensaje_body +
                           "</p>" +
                           "</div>" +
                           '<div class="plantilla-footer-mensaje">' +
                           '<span class="texto_footer_mensaje">' +
                           textFooter + // Variable de contenido aquí
                           "</span>" +
                           "</div>" +
                           "</div>" +
                           '<small class="mf-date fecha_y_palomitas">' +
                           "<div>" +
                           "fecha_creacion" +
                           "</div>" +
                           "<div>" +
                           //tipo producto
                           '<img class="imagen_producto" src="' +
                           img_whatsapp +
                           '" alt="" width="' +
                           tamaño_palomita +
                           '" />' +
                           //

                           '<img class="palomita_texto margin_left_10" src="' +
                           url_status_img +
                           '" alt="" width="' +
                           tamaño_palomita +
                           '" />' +
                           "</div>" +
                           "</small>" +
                           mensaje_botones +
                           "</div>" +
                           "</div>" +
                           "</div>";

                        // Puedes usar `nuevoMensaje` para insertar en el DOM

                        console.log(nuevoMensaje);
                        */
                     }
 
                     //console.log("return aqui anao")
                     //return

                     //cargar_informacion_plantillas(components, []);

                     let otros_datos_plantilla_original = JSON.parse(plantilla.template_original);
                     
                     $(".texto_categoria").text(otros_datos_plantilla_original.category);
                     $(".texto_idioma").text(otros_datos_plantilla_original.language);
                     $(".estado_plantilla").text(otros_datos_plantilla_original.status);

                     $(".estado_plantilla").removeClass('bg-danger');
                     $(".estado_plantilla").removeClass('bg-success');
                     $(".estado_plantilla").removeClass('bg-secondary');

                     if(otros_datos_plantilla_original.status == "APPROVED") 
                     {
                        $(".estado_plantilla").addClass('bg-success');
                     }else{
                     
                        if(otros_datos_plantilla_original.status == "PENDING")
                        {
                           $(".estado_plantilla").addClass('bg-danger');
                        }else{
                           $(".estado_plantilla").addClass('bg-secondary'); 
                        }
                     }
 
                     var $offcanvasMenu = $("#offcanvas-menu");
                     var $offcanvasBackdrop = $("#offcanvas-backdrop");
                     var $offcanvasClose = $(".btn-close-offcanvas");

                     $offcanvasMenu.toggleClass("offcanvas-show");
                     $offcanvasBackdrop.toggle();


                  }

               }

                    

                 
            });

        }

        function validateArrayOEmpty(jsonString) {

            if(isEmpty(jsonString) == false)
            {
               return true;
            }

            if(Array.isArray(jsonString) == true)
            {
               return true;
            }

            return false;
        
         }


        function reemplazarComodinPorText(text, placeholder, value) {
            let updatedText = text;

            // Escapar el placeholder para usarlo en una expresión regular
            const escapedPlaceholder = placeholder.replace(
               /[.*+?^${}()|[\]\\]/g,
               "\\$&",
            );

            const regex = new RegExp(escapedPlaceholder, "g");

            // Reemplazar el placeholder con el valor o mantener el placeholder si el valor está vacío
            updatedText = updatedText.replace(regex, value || placeholder);

            return updatedText;
         }

         $(".tener_configuracion").on("change", function() {
             
            $(".tbody_envios").html(
               '<tr><th colspan="8" class="centrar pt-4"> No information</th></tr>',
            );
            
        });

        $offcanvasBackdrop
         .off("click")
         .on("click", function () {
            $offcanvasMenu.removeClass("offcanvas-show");
            $offcanvasBackdrop.hide();
         });

         $offcanvasClose
         .off("click")
         .on("click", function () {
            $offcanvasMenu.removeClass("offcanvas-show");
            $offcanvasBackdrop.hide();

         });

         $(".btn_eliminar_plantilla")
         .off("click")
         .on("click", function () {
             
            console.log("click btn_eliminar_plantilla");
 
            Swal.fire({
                title: "Delete template?",
                text: "Are you sure you want to delete this template?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#d33",
                cancelButtonColor: "#3085d6",
                confirmButtonText: "Yes",
                cancelButtonText: "No"
            }).then((result) => {
                if (result.isConfirmed) {

                    let tener_configuracion = $(".tener_configuracion").val() || "";
 
                    $(".btn_eliminar_plantilla").prop("disabled", true);
 
                     let enviar_informacion = {
                         id: PLANTILLA_ID_ELIMINAR,
                         cspm_id: PLANTILLA_CSPM_ID_ELIMINAR,
                         configuracion_id: tener_configuracion,
                     };

                    console.log("El usuario confirmó la eliminación de la plantilla");
                    console.log(enviar_informacion);

                    //return;

                    $.ajax({
                    type: "POST",
                    url: URL_BASE + "social/delete-scheduled-messages",
                    data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
                    contentType: "application/json", // Tipo de contenido JSON
                    success: function (response) {
                        
                        $(".btn_eliminar_plantilla").prop("disabled", false);

                        //console.log("Respuesta del servidor:", response);
                        // Hacer algo con la respuesta del servidor
                       
                        try {
                            let info = JSON.parse(response);
                            if (info.type == "success") {
                     

                                Swal.fire({
                                    title: "",
                                    text: info.message,
                                    icon: "success",
                                });

                                $offcanvasMenu.removeClass("offcanvas-show");
                                $offcanvasBackdrop.hide();

                                 let tener_configuracion = $(".tener_configuracion").val() || "";
 
                                 let fecha_desde = $(".fecha_desde").val() || "";
                                 let fecha_hasta = $(".fecha_hasta").val() || "";
                        
                                 let enviar_informacion = {
                                    fecha_desde: fecha_desde,
                                    fecha_hasta: fecha_hasta,
                                    configuracion_id: tener_configuracion,
                                 };
 
                                 ejecutar_consulta(enviar_informacion);

 
                            } else {
                                //alert("Error sending group messages");

                                Swal.fire({
                                    title: "",
                                    text: info.message,
                                    icon: "error",
                                });

                            }
                        } catch (error) {
                             
                            //alert("Error:" + error);

                            Swal.fire({
                                title: "",
                                text: error,
                                icon: "error",
                            });
                        }
                    },
                    error: function (xhr, status, error) {
                        $(this).prop("disabled", false);
                       
                        console.error("Error en la solicitud:", error);
                    },
                    });

 
                }else{
                    $(this).prop("disabled", false);
                }
            });
 
         });

         

         $(".btn_editar_plantilla ")
         .off("click")
         .on("click", function () {

            window.open(URL_MODIFICAR_PLANTILLA, '_blank');

         });

 
         function cargar_fecha() {
            const today = new Date();

            // Formatear la fecha como YYYY-MM-DD
            const year = today.getFullYear();
            const month = String(today.getMonth() + 1).padStart(2, "0"); // Mes de 2 dígitos
            const day = String(today.getDate()).padStart(2, "0"); // Día de 2 dígitos

            const formattedDate = year + "-" + month + "-" + day;
            return formattedDate;
         }
    
         function isEmpty(value) {
            // Verificar si es null o undefined
            if (value == null) return true;

            // Verificar si es una cadena vacía
            if (typeof value === "string" && value.trim() === "") return true;

            // Verificar si es un array vacío
            if (Array.isArray(value) && value.length === 0) return true;

            // Verificar si es un objeto vacío
            if (typeof value === "object" && Object.keys(value).length === 0) return true;

            return false;
         }

         function cargar_informacion_plantillas(components = [], parsearContenidoBotones = "") 
         {
 
 
               let componentsBotones = [];

 
               var existeHeaders = false;
               $(".contenido_principal_header").html("");

               /*
               //HEADER INFORMACION
               //header
               $("#input_header_plantilla").val("None");
               $(".contenido_principal_header").html("");

               //body
               $(".contenido_principal_body").html("");

               //footer
               $(".footer_plantilla").hide();

               $(".buttons_plantilla").hide();

               //VISTA PREVIA
               //$("#texto_header_plantilla_previa").text("");
               //header
               $(".plantilla-header").html("");

               //body
               $("#texto_body_plantilla_previa").text("");

               //footer
               $("#texto_footer_plantilla_previa").text("");

               //botones
               $(".mensajes_botones").hide();
               $(".mensajes_botones").html("");
               */

               $(".mensajes_botones").html("");

               $("#texto_footer_plantilla_previa").text("");

               $(".plantilla-header").html(
                   ""
               );

               var existeHeaderDiferenteTexto = false;
 
               var miArregloBotones = [];
               var buttons_controlador = [];
 
               components.forEach((elementos) => {
                  //tipo type: HEADER, BODY Y FOOTER
                  //text puede ser: Hola, mundo / Hola, {{ 1 }}
                  //format: IMAGEN, DOCUMENT, VIDEO

                  let { type = "", text = "", format = "", example, buttons } = elementos;

                   /* console.log("Text: ", text);
                           console.log("Type: ", type);
                           console.log("Formato: ", format);
                           console.log("Example: ", example);
                           console.log("Botones: ", buttons) 
                           */

                  if (type == "HEADER") {
                     //existeHeaders = true;
                     let tempo_formt =
                        format.charAt(0).toUpperCase() +
                        format.slice(1).toLowerCase();

                      let formato_minuscula = format.toLowerCase();

                     if (formato_minuscula == "text") {
                     
                        $(".plantilla-header").html(
                           "<p id='texto_header_plantilla_previa'>" +
                              text +
                           "</p>",
                        );

 
                        if (example != null || example != undefined) {
 
                           let cantidad_parametros =
                              countNestedElements(example);

                            let updatedText = text;

                            //console.log("text");
                            //console.log(text);
 
                           var html_input = "<div class='row contenido_segundario_header'>";

                           for (let i = 1; i <= cantidad_parametros; i++) {
                                 
                                let informacion_parametro = example.header_text[i - 1];

                                //console.log(informacion_parametro);
  
                                const placeholder = "{{" + i + "}}";
                                //console.log(placeholder);

                                // Escapar el placeholder para usarlo en una expresión regular
                                const escapedPlaceholder = placeholder.replace(
                                    /[.*+?^${}()|[\]\\]/g,
                                    "\\$&",
                                );

                                const regex = new RegExp(escapedPlaceholder, "g");

                                updatedText = updatedText.replace(
                                    regex,
                                    informacion_parametro,
                                );
                             
                                $(".plantilla-header").html(
                                   "<p id='texto_header_plantilla_previa'>" +
                                      updatedText +
                                   "</p>"
                                );
                                 
                           }

  
                        }

                      
                     }

                     if (formato_minuscula == "image") {

                        existeHeaderDiferenteTexto = true;
                        //poner tipo de plantilla imagen, texto, documentos o videos
                        $("#input_header_plantilla").val("IMAGE");

                        $(".plantilla-header").html(
                           '<div class="imagen_header_plantilla">' +
                              "</div>",
                        );

                        //seleccionar_archivo_plantilla_headersWhatsapp(
                        //   formato_minuscula,
                        //   "image/jpeg, image/png",
                        //);
                     }

                      

                     if (formato_minuscula == "document") {
                        existeHeaderDiferenteTexto = true;
                        //poner tipo de plantilla imagen, texto, documentos o videos
                        $("#input_header_plantilla").val("DOCUMENT");

                        $(".plantilla-header").html(
                           '<div class="documento_header_plantilla">' +
                              "</div>",
                        );

                        //seleccionar_archivo_plantilla_headersWhatsapp(
                        //   formato_minuscula,
                        //   ".pdf",
                        //);
                     }

           
                     if (formato_minuscula == "video") {
                        existeHeaderDiferenteTexto = true;
                        //poner tipo de plantilla imagen, texto, documentos o videos
                        $("#input_header_plantilla").val("VIDEO");

                        $(".plantilla-header").html(
                           '<div class="video_header_plantilla">' + "</div>",
                        );

                        //seleccionar_archivo_plantilla_headersWhatsapp(
                        //   formato_minuscula,
                        //   "video/mp4, video/3gpp",
                        //);
                     }

                     if (formato_minuscula == "location") {
                        existeHeaderDiferenteTexto = true;
                        $("#input_header_plantilla").val("LOCATION");

                        $(".plantilla-header").html(
                           '<div class="imagen_header_plantilla_location">' +
                              "</div>",
                        );

                        $(".plantilla-header").append(
                           '<p style="margin-bottom:0px;font-size: 11px; color: black;" class="p_headers_name_location">{{Location name}}' +
                              "</p>",
                        );

                        $(".plantilla-header").append(
                           '<p style="font-size: 11px; color: black;" class="p_headers_address_location">{{Address}}' +
                              "</p>",
                        );

                       

                        
                     }
 
                  }
         
                  if (type == "BODY") {

                    $("#texto_body_plantilla_previa").text(text);

                    let updatedText = text;
 
                     if (example != null || example != undefined) {

                        let cantidad_parametros =
                           countNestedElements(example);

                        var html_input = "<div class='row contenido_segundario_body'>";

                        let parametros_body = example.body_text[0] || [];

                        for (let i = 1; i <= cantidad_parametros; i++) {

                           let informacion_parametro = parametros_body[i - 1];

                           console.log(informacion_parametro)

                           const placeholder = "{{" + i + "}}";
                           console.log(placeholder);

                           // Escapar el placeholder para usarlo en una expresión regular
                           const escapedPlaceholder = placeholder.replace(
                               /[.*+?^${}()|[\]\\]/g,
                               "\\$&",
                           );

                           const regex = new RegExp(escapedPlaceholder, "g");

                           updatedText = updatedText.replace(
                               regex,
                               informacion_parametro,
                           );
                           
                           $(".plantilla-body").html(
                              "<p id='texto_body_plantilla_previa'>" +
                                 updatedText +
                              "</p>"
                           );

                        }

                        //FIN BODY
                     }

              
                  }
              
 
                  if (type == "FOOTER") {
                     $("#texto_footer_plantilla_previa").text(text);
 
                  }
 
                
                  if (type == "BUTTONS") {
                     //$(".mensajes_botones").show();
                     //$(".contenido_principal_buttons").html("");

                     var html_input_buttons = "";
                     var html_input_buttons_vista_previa = "";

                     let contador_url = 0;

                     buttons.forEach((element, index, array) => {
                        let typeButtonValue = element.type;
                        let textButtonValue = element.text;
                        let textButtonURL = element.url;
                        let textButtonPhoneNumber = element.phone_number;
                        let required = element.example;

                        //console.log("typeButtonValue: " + typeButtonValue);
                        //console.log("textButtonValue: " + textButtonValue);
                        //console.log("textButtonURL: " + textButtonURL);
                        //console.log("textButtonPhoneNumber: " + textButtonPhoneNumber);
                        //console.log("required: " + required);

                        if(typeButtonValue == "URL")
                        {
                           contador_url++;
                           
                           miArregloBotones.push({
                              type: typeButtonValue + contador_url,
                              text: textButtonValue,
                              url: textButtonURL || "",
                              phone_number: textButtonPhoneNumber || "",
                              requerido: Array.isArray(required) == true? (required.length != 0 ? required[0] : ""  ) : "",
                           });


                        }else{
                           miArregloBotones.push({
                              type: typeButtonValue,
                              text: textButtonValue,
                              url: textButtonURL || "",
                              phone_number: textButtonPhoneNumber || "",
                              requerido: Array.isArray(required) == true? (required.length != 0 ? required[0] : ""  ) : "",
                           });
                        }
                        
                       
                        
                     });

                 

                     //$(".buttons_plantilla").show();
                  }
             
 

               });
 
 
            
               console.log("miArregloBotones");
               console.log(miArregloBotones);

               miArregloBotones.forEach((elementos, index) => {
                  
                  let {
                     type = "",
                     text = "",
                     url ="",
                     phone_number = "",
                     requerido,
                  } = elementos;

                  if(type != "QUICK_REPLY" )
                  {
                     if(type == "URL1")
                     {
                        
                        buttons_controlador.push({
                           "type": "URL1",
                           "text": text
                        });

                     }

                     if(type == "URL2")
                     {
                        buttons_controlador.push({
                           "type": "URL2",
                           "text": text
                        });

                     }     

                     if(type == "PHONE_NUMBER")
                     {
                        buttons_controlador.push({
                           "type": "PHONE_NUMBER",
                           "text": text
                        });
                     }  

                     if(type == "COPY_CODE")
                     {
                        buttons_controlador.push({
                           "type": "COPY_CODE",
                           "text": text
                        });
                     }  

                  }else{

                     //seccion de solo QUICK_REPLY

                     //console.log("index");
                     //console.log(index);
 
                     buttons_controlador.push({
                        "type": "QUICK_REPLY",
                        "text": text,
                        
                     });
                     
 


                  }

 
               });


               dibujar_botones(buttons_controlador);

 
               console.log("buttons_controlador");
               console.log(buttons_controlador);
            

    
 
         }

            function seleccionar_archivo_plantilla_headersWhatsapp(
            tipo_documento,
            tipo_archivo,
            ) {
    

               let htmlToInsert = "";

               if (tipo_documento == "image") {
                   htmlToInsert =
                   '<div class="contenedor_header_plantilla">' +
                   '<img src="data:' +
                   file.type +
                   ";base64," +
                   base64String +
                   '" alt="Selected Image" style="max-width: 100%; height: 180px; object-fit: contain; border-radius: 5px;">' +
                   "</div>";
               } else if (tipo_documento == "application/pdf") {
                   htmlToInsert =
                   '<div class="contenedor_header_plantilla">' +
                   '<iframe src="data:' +
                   file.type +
                   ";base64," +
                   base64String +
                   '" style="width: 100%; height: 180px;" frameborder="0"></iframe>' +
                   "</div>";
               } else if (file.type.startsWith("video/")) {
                   htmlToInsert =
                   '<div class="contenedor_header_plantilla" style="min-height: 0px;">' +
                   '<video controls style="width: 100%; height: auto; border-radius: 5px;">' +
                   '<source src="data:' +
                   file.type +
                   ";base64," +
                   base64String +
                   '" type="' +
                   file.type +
                   '">' +
                   "Your browser does not support the video tag." +
                   "</video>" +
                   "</div>";
               }
               
               $(".plantilla-header").html(htmlToInsert);

                 
                
            }

            function removeExactMarker(template, marker) {
               // Usar una expresión regular para coincidencias exactas de la variable
               const regex = new RegExp(marker.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&'), 'g');
               return template.replace(regex, '').replace(/\s+/g, ' '); // Eliminar el marcador y normalizar espacios
            }

            function renumberPlaceholders(template) {
              const regex = /{{(.*?)}}/g;
               let seen = new Map();
               let counter = 1;

               // Reemplazar en una sola pasada asignando un número nuevo a cada aparición
               return template.replace(regex, (match, key) => {
                  seen.set(match, `{{${counter++}}}`);
                  return seen.get(match);
               });
            }

            function OrdendandoCadena(template) {
               const regex = /{{(.*?)}}/g;
               let seen = new Map();
               let counter = 1;

               // Reemplazar en una sola pasada asignando un número nuevo a cada aparición
               return template.replace(regex, (match, key) => {
                  seen.set(match, `{{${counter++}}}`);
                  return seen.get(match);
               });
            }

            function updateTextBodyWhatsappV1(miTexto) {
               let updatedText = miTexto;

               $("input[id^='texto_input_plantilla_body_']").each(function () {
                  const value = $(this).val();
                  const dataId = $(this).data("id");
                  const placeholder = "{{" + dataId + "}}";

                  // Escapar el placeholder para usarlo en una expresión regular
                  const escapedPlaceholder = placeholder.replace(
                     /[.*+?^${}()|[\]\\]/g,
                     "\\$&",
                  );

                  const regex = new RegExp(escapedPlaceholder, "g");

                  updatedText = updatedText.replace(
                     regex,
                     value || placeholder,
                  );
               });

               $("#texto_body_plantilla_previa").text(updatedText);
            }

            function countPlaceholders(template) {
               const regex = /{{([^}]+)}}/g;
               const matches = template.match(regex) || [];
               return matches.length; // Retorna la cantidad de marcadores encontrados
            }

            function ReorderTemplate(template) {
               template = template.replace(
                  /{{\s*(\d+)\s*}}/g,
                  function (match, number) {
                     return `{{${number}}}`;
                  },
               );

               // Luego, realizar el reordenamiento si es necesario
               let match;
               let index = 1;
               const regex = /{{(\d+)}}/g;
               const replacements = {};

               while ((match = regex.exec(template)) !== null) {
                  const placeholder = match[0];
                  const number = parseInt(match[1], 10);

                  if (!replacements[number]) {
                     replacements[number] = placeholder;
                  }
               }

               return template.replace(regex, function (match, number) {
                  return `{{${index++}}}`;
               });
            }

            // 
            
            // Función para mantener solo el primer marcador como {{1}} y eliminar los demás
            function cleanAndKeepOnlyFirstTemplate(template) {
               // Buscar todos los marcadores {{cualquiercosa}}
               const regex = /{{([^}]+)}}/g;
               let match;
               const placeholders = [];
               let firstOneIndex = -1;

               // Guardar todos los marcadores en orden de aparición
               while ((match = regex.exec(template)) !== null) {
                  placeholders.push({
                        text: match[0], // El marcador completo, ej. {{1}}
                        index: match.index,
                        value: match[1] // El contenido dentro, ej. 1
                  });
                  if (match[1] === "1" && firstOneIndex === -1) {
                        firstOneIndex = placeholders.length - 1; // Guardar el índice del primer {{1}}
                  }
               }

               // Si no hay marcadores, devolver el texto sin cambios
               if (placeholders.length === 0) {
                  return template;
               }

               // Si hay al menos un {{1}}, mantener solo el primero y eliminar todos los demás marcadores
               if (firstOneIndex !== -1) {
                  let result = template;
                  placeholders.forEach((placeholder, index) => {
                        if (index !== firstOneIndex) {
                           result = result.replace(placeholder.text, "");
                        }
                  });
                  return result.replace(/\s+/g, " "); // Limpiar espacios extras
               }

               // Si no hay {{1}}, convertir el primer marcador en {{1}} y eliminar los demás
               let result = template;
               for (let i = 0; i < placeholders.length; i++) {
                  if (i === 0) {
                        result = result.replace(placeholders[i].text, "{{1}}");
                  } else {
                        result = result.replace(placeholders[i].text, "");
                  }
               }

               return result.replace(/\s+/g, " "); // Limpiar espacios extras
            }

            function reorderAndRenumberTemplate(template) {
              // Si está vacío, añadir {{1}}
               if (!template) {
                  return "{{1}}";
               }

               // Encontrar todos los marcadores {{n}} o {{text}}
               const regex = /{{(\d+|text)}}/g;
               let match;
               const placeholders = [];
               
               // Guardar todos los marcadores existentes en orden
               while ((match = regex.exec(template)) !== null) {
                  placeholders.push(match[0]);
               }

               // Añadir un nuevo marcador si no está vacío
               placeholders.push("{{temp_placeholder}}");

               // Reemplazar {{text}} con un marcador temporal
               template = template.replace(/{{\s*text\s*}}/g, "{{temp_placeholder}}");

               // Reconstruir el texto con los marcadores reordenados
               let result = template;
               let index = 1;

               // Reemplazar cada marcador con un número secuencial
               for (let i = 0; i < placeholders.length; i++) {
                  const placeholder = placeholders[i];
                  if (result.includes(placeholder)) {
                        result = result.replace(placeholder, `{{${index++}}}`);
                  } else {
                        // Si es el nuevo marcador, añadirlo al final
                        result += ` {{${index++}}}`;
                  }
               }

               // Limpiar marcadores temporales sobrantes (por si acaso)
               result = result.replace(/{{temp_placeholder}}/g, "");

               return result.trim();
            }

            function cleanAndReorderTemplate(template) {
            
               // Reemplazar {{text}} con un marcador de posición único temporal
               template = template.replace(
                  /{{\s*text\s*}}/g,
                  "{{text_placeholder}}",
               );

               // Eliminar espacios adicionales y mantener la secuencia de números y el marcador de posición temporal
               template = template.replace(
                  /{{\s*(\d+|text_placeholder)\s*}}/g,
                  function (match, number) {
                     return "{{" + number + "}}";
                  },
               );

               // Crear un objeto para reemplazar números secuenciales y text_placeholder
               let index = 1;
               const replacements = {};

               // Primero, reemplazar los números secuenciales
               template = template.replace(/{{(\d+)}}/g, function (match, number) {
                  if (!replacements[number]) {
                     let tempo = index++;
                     replacements[number] ="{{" + tempo + "}}";
                  }
                  return replacements[number];
               });

               // Luego, reemplazar el marcador de posición temporal con números secuenciales
               template = template.replace(/{{text_placeholder}}/g, function () {
                  let tempo = index++;
                  return "{{" + tempo + "}}";
               });

               return template;
            }

            function dibujar_botones(buttons_controlador = [])
            {

               var html_input_buttons_vista_previa = "";

               buttons_controlador.forEach((element, index, array) => {
                  let typeButtonValue = element.type;
                  let textButtonValue = element.text;
               
                  var valueButtonValue = "";

                  let img = "";
                  if (typeButtonValue == "PHONE_NUMBER") {
                     img = PATH_IMG_ + "telefono.png";
                  }

                  if (typeButtonValue == "URL1" || typeButtonValue == "URL2") {
                     img = PATH_IMG_ + "url_icono_plantilla.png";
                  }

                  if (typeButtonValue == "COPY_CODE") {
                     img = PATH_IMG_ + "copiar_icono_plantilla.png";
                  }

                  if (typeButtonValue == "QUICK_REPLY") {
                     img = PATH_IMG_ + "quick_reply.png";
                  }

                   

                  if (img == "") {
                     img = PATH_IMG_ + "trasparente_plantilla.png";
                  }

                  html_input_buttons_vista_previa +=
                        '<div class="div_mensaje_boton">' +
                        '<img src="' +
                        img +
                        '" class="icono_plantilla"> <a class="angotar_mensajes_botones">' +
                        textButtonValue +
                        "</a>" +
                        "</div>";
               

                  /*
                  if( typeButtonValue == "QUICK_REPLY" )
                  {
                      // Genera el HTML para la vista previa
                     html_input_buttons_vista_previa +=
                        '<div class="div_mensaje_boton">' +
                         '<a class="angotar_mensajes_botones">' +
                        textButtonValue +
                        "</a>" +
                        "</div>";
                  }else{
                      // Genera el HTML para la vista previa
                     html_input_buttons_vista_previa +=
                        '<div class="div_mensaje_boton">' +
                        '<img src="' +
                        img +
                        '" class="icono_plantilla"> <a class="angotar_mensajes_botones">' +
                        textButtonValue +
                        "</a>" +
                        "</div>";
                  }
                  */

                  

                  /*
                  if (index !== array.length - 1) {
                     html_input_buttons +=
                        '<hr style="border-top: 1px solid #c1bdbd; width: 100%; margin-top: 10px; margin-bottom: 15px;" />';

                     html_input_buttons_vista_previa +=
                        '<hr class="class_hr" />';
                  }
                  */
               });

               $(".div_mensaje_boton").remove();


               // Inserta el contenido HTML en los divs correspondientes
               $(".mensajes_botones").html(
                  html_input_buttons_vista_previa,
               );
            }
     
 
</script>
{/literal}

{/block}