{extends file="$layouts_admin"}

{block name="content"}
    <div class="row">
        <div class="col-md-4">
            <div class="panel">
                <div class="panel-hdr">
                    <h5>{$_L['Edit Transaction']} - [#{ib_lan_get_line($t['type'])}-{$t['id']}]</h5>

                </div>
                <div class="panel-container" id="ibox_form">
                    <div class="panel-content">
                        <div class="alert alert-danger" id="emsg">
                            <span id="emsgbody"></span>
                        </div>

                        <form class="form-horizontal" method="post" id="tform" role="form">
                            <div class="mb-3">
                                <label for="account" class="col-sm-3 control-label">{$_L['Account']}</label>
                                <select id="account" name="account" class="form-control" disabled>
                                    {foreach $d as $ds}
                                        <option value="{$ds['account']}" {if $ds['account'] eq $t['account']}selected="selected" {/if}>{$ds['account']}</option>
                                    {/foreach}


                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="date" class="col-sm-3 control-label">{$_L['Date']}</label>
                                <input type="text" class="form-control"  value="{$t['date']}" name="date" id="date" datepicker data-date-format="yyyy-mm-dd" data-auto-close="true">
                            </div>

                            <div class="mb-3">
                                <label for="description" class="col-sm-3 control-label">{$_L['Description']}</label>
                                <input type="text" class="form-control" id="description" name="description" value="{$t['description']}">
                            </div>

                            <div class="mb-3">
                                <label for="amount" class="col-sm-3 control-label">{$_L['Amount']}</label>
                                <input type="text" class="form-control amount" id="amount"  data-a-sign="{$config['currency_code']} " data-d-group="2" value="{$t['amount']}"  name="amount" disabled>
                            </div>

                            {if $t['type'] neq 'In' && $t['type'] neq 'Out' && $t['type'] neq 'Transfer'}
                                <div class="mb-3">
                                    <label for="cats" class="col-sm-3 control-label">{$_L['Category']}</label>
                                    <select id="cats" name="cats" class="form-control">
                                        <option value="0">{$_L['Uncategorized']}</option>
                                        {foreach $cats as $cat}
                                            <option value="{$cat['id']}" {if $cat['name'] eq $t['category']}selected="selected" {/if}>{$cat['name']}</option>
                                        {/foreach}


                                    </select>
                                </div>
                            {else}
                                <input type="hidden" name="cats" id="cats" value="">
                            {/if}



                            <div class="mb-3">
                                <label for="tags" class="col-sm-3 control-label">{$_L['Tags']}</label>
                                <select name="tags[]" id="tags"  class="form-control" multiple="multiple">
                                    {foreach $tags as $tag}
                                        <option value="{$tag['text']}" {if in_array($tag['text'],$dtags)}selected="selected"{/if}>{$tag['text']}</option>
                                    {/foreach}

                                </select>
                            </div>
                            {*                        <div class="mb-3">*}
                            {*                            <div class="col-sm-3">*}
                            {*                                &nbsp;*}
                            {*                            </div>*}
                            {*                            <div class="col-sm-9">*}
                            {*                                <h4><a href="#" id="a_toggle">{$_L['Advanced']}</a> </h4>*}
                            {*                            </div>*}
                            {*                        </div>*}


                            <div class="mb-3">
                                <label for="company" class="col-sm-3 control-label">{$_L['Company']}</label>
                                <select id="company" name="company" class="form-control">
                                    <option value="0">{$_L['None']}</option>
                                    {foreach $companies as $company}
                                        <option value="{$company->id}" {if $t->company_id == $company->id} selected{/if}>{$company->company_name}</option>
                                    {/foreach}


                                </select>
                            </div>

                            {if $t['type'] eq 'Income'}
                                <div class="mb-3">
                                    <label for="payer" >{$_L['Payer']}</label>
                                    <div>
                                        <select id="payer" name="payer" class="s2 form-control">
                                            <option value="">{$_L['Choose Contact']}</option>
                                            {foreach $p as $ps}
                                                <option value="{$ps['id']}" {if ($t['payerid']) eq ($ps['id'])}selected="selected" {/if}>{$ps['account']}</option>
                                            {/foreach}


                                        </select>
                                        <input type="hidden" name="payee" id="payee" value="0">

                                    </div>
                                </div>

                            {elseif $t['type'] eq 'Expense'}
                                <div class="mb-3">
                                    <label for="payee" >{$_L['Payee']}</label>

                                    <select id="payee" name="payee" class="s2 form-control">
                                        <option value="">{$_L['Choose Contact']}</option>
                                        {foreach $p as $ps}
                                            <option value="{$ps['id']}" {if ($t['payeeid']) eq ($ps['id'])}selected="selected" {/if}>{$ps['account']}</option>
                                        {/foreach}


                                    </select>
                                    <input type="hidden" name="payer" id="payer" value="0">

                                </div>
                            {/if}

                            <div class="mb-3">
                                <label for="staff_id" class="col-sm-3 control-label">{$_L['Staff']}</label>
                                <select id="staff_id" name="staff_id" class="form-select">
                                    <option value="0">{$_L['None']}</option>
                                    {foreach $staffs as $staff}
                                        <option value="{$staff->id}" {if $staff->id == $t['staff_id']}selected{/if}>{$staff->fullname}</option>
                                    {/foreach}
                                </select>
                            </div>


                            <div class="mb-3">
                                <label for="pmethod" class="col-sm-3 control-label">{$_L['Method']}</label>
                                <select id="pmethod" name="pmethod" class="form-select">

                                    {foreach $pms as $pm}
                                        <option value="{$pm['name']}" {if $pm['name'] eq $t['method']}selected="selected" {/if}>{$pm['name']}</option>
                                    {/foreach}


                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="ref" class="col-sm-3 control-label">{$_L['Ref']}#</label>
                                <input type="text" class="form-control" id="ref" name="ref" value="{$t['ref']}">
                                <span class="help-block">{$_L['ref_example']}</span>
                            </div>

                            <div class="mb-3">
                                <label for="item"><span class="h6">{$_L['Item']}</span></label>
                                <select id="item" name="item_id" class="form-select">
                                    <option value="0">{$_L['None']}</option>
                                    {foreach $items as $item}
                                        <option value="{$item->id}" {if $item['id'] eq $t['item_id']} selected {/if} >{$item->name}</option>
                                    {/foreach}
                                </select>
                            </div>

                            <div class="mb-3">
                                <div class="col-sm-offset-3 col-sm-9">
                                    <input type="hidden" name="trid" id="trid" value="{$t['id']}">
                                    <input type="hidden" id="trtype" name="trtype" value="{$t['type']}">
                                    <button type="submit" id="submit" class="btn btn-primary"><i class="fal fa-check"></i> {$_L['Submit']}</button>
                                </div>
                            </div>
                        </form>
                    </div>



                </div>
            </div>
        </div>

        <div class="col-md-8">



            {if ($t['type'] eq 'Income') || ($t['type'] eq 'Expense')}
                <div class="panel">
                    <div class="panel-hdr">
                        <h5>{$_L['Print']}</h5>

                    </div>
                    <div class="panel-container">
                        <div class="panel-content">
                            <a href="{$_url}client/receipt/{$t['id']}/{$t['vid']}" target="_blank" class="btn btn-success"><i class="fal fa-print"></i> {$_L['Receipt']}</a>

                        </div>

                        {*<a href="{$_url}transactions/print/{$t['id']}" target="_blank" class="btn btn-primary"><i class="fal fa-print"></i> {$_L['Print']}</a>*}

                    </div>
                </div>
            {/if}


            {if $t['attachments'] neq ''}
                <div class="ibox float-e-margins">

                    <div class="ibox-content">

                        {Misc::transaction_attachment($t['attachments'])}

                    </div>
                </div>
            {/if}


            <div class="panel">
                <div class="panel-hdr">
                    <h5>{$_L['Delete']}</h5>

                </div>
                <div class="panel-container">
                    <div class="panel-content">
                        <p>{$_L['tr_delete_warning']}</p>
                        <form role="form" method="post" action="{$_url}transactions/delete-post/">





                            <input type="hidden" name="id" value="{$t['id']}">

                            <button type="submit" class="btn btn-danger"><i class="fal fa-trash"></i> {$_L['Delete']}</button>
                        </form>
                    </div>




                </div>
            </div>


        </div>

    </div>

    <input type="hidden" id="_lan_no_results_found" value="{$_L['No results found']}">
{/block}

{block name="script"}
    <script>
        $(document).ready(function () {

            $('.amount').autoNumeric('init');



            $("#account").select2({

                language: {
                    noResults: function () {
                        return $("#_lan_no_results_found").val();
                    }
                }
            });



            $("#pmethod").select2({

                language: {
                    noResults: function () {
                        return $("#_lan_no_results_found").val();
                    }
                }
            });

            $("#company").select2({

                language: {
                    noResults: function () {
                        return $("#_lan_no_results_found").val();
                    }
                }
            });

            $(".s2").select2({

                language: {
                    noResults: function () {
                        return $("#_lan_no_results_found").val();
                    }
                }
            });

            $('#tags').select2({
                tags: true,
                tokenSeparators: [','],

                language: {
                    noResults: function () {
                        return $("#_lan_no_results_found").val();
                    }
                }
            });

            $('#item').select2(
                {
                    language: {
                        noResults: function () {
                            return $("#_lan_no_results_found").val();
                        }
                    }
                }
            );

            // $("#a_hide").hide();
            $("#emsg").hide();
            // $("#a_toggle").click(function(e){
            //     e.preventDefault();
            //     $("#a_hide").toggle( "slow" );
            // });


            var trtype =  $('#trtype').val();
            trtype = trtype.toLowerCase();

            var _url = $("#_url").val();

            $("#submit").click(function (e) {
                e.preventDefault();
                $('#ibox_form').block({ message: null });
                var _url = $("#_url").val();
                $.post(_url + 'transactions/edit-post/', {



                    date: $('#date').val(),

                    id: $('#trid').val(),
                    cats: $('#cats').val(),
                    description: $('#description').val(),
                    tags: $('#tags').val(),

                    pmethod: $('#pmethod').val(),
                    payee: $('#payee').val(),
                    payer: $('#payer').val(),
                    ref: $('#ref').val(),
                    company: $('#company').val(),
                    staff_id: $('#staff_id').val(),
                    item_id: $('#item').val(),

                })
                    .done(function (data) {

                        var sbutton = $("#submit");
                        var _url = $("#_url").val();
                        if ($.isNumeric(data)) {

                            location.reload();
                        }
                        else {
                            $('#ibox_form').unblock();
                            var body = $("html, body");
                            body.animate({ scrollTop:0 }, '1000', 'swing');
                            $("#emsgbody").html(data);
                            $("#emsg").show("slow");
                        }
                    });
            });
        });
    </script>
{/block}
