<?php

/*
|--------------------------------------------------------------------------
| Controller
|--------------------------------------------------------------------------
|
*/

_auth();
$ui->assign('selected_navigation', 'mnu-17');
$ui->assign('_title', $_L['Documents'] . '- ' . $config['CompanyName']);
$action = route(1);

if ($action == '') {
    $action = 'list';
}
$user = User::_info();
$ui->assign('user', $user);

$ui->assign('base_datos_para_socket', DB_NAME);
$ui->assign('config_whatsapp_other_id_para_socket', empty($user["config_whatsapp_other_id"]) == true ? "No_existe" : $user["config_whatsapp_other_id"] );
$ui->assign('url_ir_chat_empleado', U . "social/social-chat-employee");
$ui->assign('url_ir_chat_admin', U . "social/social-chat");

$ui->assign('url_ir_chat_crm', U . "social/chat-crm");

$ui->assign('url_base_plantilla_admintpl', U);
$ui->assign('APP_URL_ORIGINAL_SOCKET', APP_URL_ORIGINAL_SOCKET);
$ui->assign('url_setting_CRM_Parnerts_prepared', url_setting_CRM_Parnerts_prepared);
$ui->assign('ws_nombre_socket', ws_nombre_socket);
$ui->assign('db_crm_administrative', getDBCRMAdministrative());
$ui->assign('url_origen', U);

$ruta_segundaria = route(1);
$armado_ruta = "";

if(empty($ruta_segundaria) == true )
{
    $armado_ruta = route(0);
}else{
    $armado_ruta = route(0) . "/" . route(1);
}

//$ui->assign('sin_ruta', $armado_ruta);
$ui->assign('sin_ruta', _get('ng'));


if(empty($_SESSION['menu_categorias_user']) == false)
{
    $ui->assign('menu_categorias_user', $_SESSION['menu_categorias_user']);
}


Event::trigger('documents');

if (!has_access($user->roleid, 'documents', 'view')) {
    permissionDenied();
}

switch ($action) {
    case 'list':
        $upload_max_size = ini_get('upload_max_filesize');
        $post_max_size = ini_get('post_max_size');

        $ui->assign('upload_max_size', $upload_max_size);
        $ui->assign('post_max_size', $post_max_size);

        $files = Document::orderBy('id', 'desc');

        if (!has_access($user->roleid, 'documents', 'all_data')) {
            $files = $files->where('aid', $user->id);
        }

        $files = $files->limit(1500)->get();

        view('documents', [
            'files' => $files,
        ]);

        break;

    case 'upload':
        if (APP_STAGE == 'Demo') {
            exit();
        }

        if (!has_access($user->roleid, 'documents', 'edit')) {
            permissionDenied();
        }

        $uploader = new Uploader();
        $uploader->setDir('storage/docs/');
        $uploader->sameName(false);
        $uploader->allowAllFormats();
        if ($uploader->uploadFile('file')) {
            $uploaded = $uploader->getUploadName(); //get uploaded file name, renames on upload//

            $file = $uploaded;
            $msg = $_L['Uploaded Successfully'];
            $success = 'Yes';
        } else {
            //upload failed
            $file = '';
            $msg = $uploader->getMessage();
            $success = 'No';
        }

        $a = [
            'success' => $success,
            'msg' => $msg,
            'file' => $file,
        ];

        header('Content-Type: application/json');

        echo json_encode($a);

        break;

    case 'post':
        if (!has_access($user->roleid, 'documents', 'edit')) {
            permissionDenied();
        }

        $title = _post('title');
        $file_link = _post('file_link');
        $is_global = _post('is_global');
        $rid = _post('rid');
        $rtype = _post('rtype');

        $did = Documents::assign($file_link, $title, $is_global, $rid, $rtype, [
            'admin_id' => $user->id,
        ]);

        if ($did) {
            echo $did;
        } else {
            ib_die($_L['All Fields are Required']);
        }

        break;

    case 'view':
        $id = route(2);



        $doc = ORM::for_table('sys_documents')->find($id);

        if ($doc) {
            $ext = pathinfo($doc->file_path, PATHINFO_EXTENSION);

            $ui->assign('ext', $ext);

            $ui->assign('doc', $doc);

            view('documents_view');
        } else {
            i_close('Not Found');
        }

        break;

    case 'download':
        $id = route(2);

        $doc = ORM::for_table('sys_documents')->find($id);

        if ($doc) {
            $file = 'storage/docs/' . $doc->file_path;

            $c_type = mime_content_type($file);

            if (file_exists($file)) {
                $basename = basename($file);

                // $mime = ($mime = getimagesize($file)) ? $mime['mime'] : $mime;
                $mime = mime_content_type($file);
                $size = filesize($file);
                $fp = fopen($file, "rb");
                if (!($mime && $size && $fp)) {
                    // Error.
                    return;
                }

                header("Content-type: " . $mime);
                header("Content-Length: " . $size);
                header(
                    "Content-Disposition: attachment; filename=" . $basename
                );
                header('Content-Transfer-Encoding: binary');
                header(
                    'Cache-Control: must-revalidate, post-check=0, pre-check=0'
                );
                fpassthru($fp);
            }
        } else {
            i_close('Not Found');
        }

        break;

    case 'set_global':
        $did = _post('did');

        $val = _post('val');

        if ($val != '1') {
            $val = '0';
        }

        $doc = ORM::for_table('sys_documents')->find($did);

        if ($doc) {
            $doc->is_global = $val;
            $doc->save();
        }

        echo $val;

        break;

    default:
        echo 'action not defined';
}
