{extends file="$layouts_admin"}
{block name="head"}

{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

</style>
<div class="row">

    <div class="col-md-12">

        <div class="panel">
            <div class="panel-hdr">
                <h2><span></span>Add Payment Gateways</h2>
            </div>

            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">

                    <div class="px-2">
                        <div class="alert alert-danger" id="emsg" style="display: none;">
                            <span id="emsgbody"></span>
                        </div>

                        <div class="alert alert-success" id="emsgSuccess" style="display: none;">
                            <span id="emsgbodySuccess"></span>
                        </div>

                        <form id="rform">

                            <div class="row">

                                <div class="col-md-12 col-sm-12">

                                    <div class="mb-3 row">
                                        <label for="tipoPago" class="col-sm-3"><span class="h6">Payment Gateway Type</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">                                  
                                            <select id="tipoPago" name="tipoPago" class="form-control  viaPago" >
                                                <option value="1" selected>Paypal</option>
                                                <option value="2">Stripe</option>
                                                <option value="3">Bank / Cash</option>
                                                <option value="4">Authorize.net</option>
                                                <option value="5">Braintree</option>
                                            </select>
                                        </div>
                                    </div>

                                    <!--  Identificador -->
                                    <div class="mb-3 row">
                                        <label for="identificador_payment" class="col-sm-3"><span class="h6">Identifier</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">
                                            <input type="text" id="identificador_payment" name="identificador_payment" class="form-control tener_identificador_payment" autofocus>
                                        </div>
                                    </div>
                                    <!-- fin Identificador -->

                                    <!-- seccion para paypal -->
                                    <div class="seccionPaypal" >
                                        <!-- email -->
                                        <div class="mb-3 row">
                                            <label for="seccion_paypal_email" class="col-sm-3"><span class="h6">Paypal Email</span><span class="text-danger">*</span></label>
                                            <div class="col-sm-9">
                                                <input type="email" id="seccion_paypal_email" name="seccion_paypal_email" class="form-control tener_seccion_paypal_email" autofocus>
                                            </div>
                                        </div>
                                        <!-- fin email -->

                                        <!-- Currency Code -->
                                        <div class="mb-3 row">
                                            <label for="seccion_paypal_curreny_code" class="col-sm-3"><span class="h6">Currency Code</span><span class="text-danger">*</span></label>
                                            <div class="col-sm-9">
                                                <input type="text" id="seccion_paypal_curreny_code" name="seccion_paypal_curreny_code" class="form-control tener_seccion_paypal_curreny_code" value="{$currency_code}" >
                                            </div>
                                        </div>
                                        <!-- fin Currency Code -->

                                        <!-- Conversion Rate -->
                                        <div class="mb-3 row">
                                            <label for="seccion_paypal_conversion_rate" class="col-sm-3"><span class="h6">Conversion Rate</span><span class="text-danger">*</span></label>
                                            <div class="col-sm-9">
                                                <input type="text" id="seccion_paypal_conversion_rate" name="seccion_paypal_conversion_rate" class="form-control tener_seccion_paypal_conversion_rate" >
                                            </div>
                                        </div>
                                        <!-- fin Conversion Rate -->

                                    </div>
                                    <!-- fin seccion para paypal -->

                                    <!-- seccion para stripe -->
                                    <div class="seccionStripe" style="display: none;">
                                        <!-- Publishable key -->
                                        <div class="mb-3 row">
                                            <label for="seccion_stripe_publishable_key" class="col-sm-3"><span class="h6">Publishable key</span><span class="text-danger">*</span></label>
                                            <div class="col-sm-9">
                                                <input type="text" id="seccion_stripe_publishable_key" name="seccion_stripe_publishable_key" class="form-control tener_seccion_stripe_publishable_key" autofocus>
                                            </div>
                                        </div>
                                        <!-- fin Publishable key -->

                                        <!-- Secret key -->
                                        <div class="mb-3 row">
                                            <label for="seccion_stripe_secret_key" class="col-sm-3"><span class="h6">Secret key</span><span class="text-danger">*</span></label>
                                            <div class="col-sm-9">
                                                <input type="text" id="seccion_stripe_secret_key" name="seccion_stripe_secret_key" class="form-control tener_seccion_stripe_secret_key" >
                                            </div>
                                        </div>
                                        <!-- fin Secret key -->

                                        <!-- Currency Code -->
                                        <div class="mb-3 row">
                                            <label for="seccion_stripe_curreny_code" class="col-sm-3"><span class="h6">Currency Code</span><span class="text-danger">*</span></label>
                                            <div class="col-sm-9">
                                                <input type="text" id="seccion_stripe_curreny_code" name="seccion_stripe_curreny_code" class="form-control tener_seccion_stripe_curreny_code" value="{$currency_code}" >
                                            </div>
                                        </div>
                                        <!-- fin Currency Code -->

                                    </div>
                                    <!-- fin seccion para stripe -->

                                    <!-- seccion para Bank / Cash -->
                                    <div class="seccionBankCash" style="display: none;">
                                        <!-- Payment Instructions -->
                                        <div class="mb-3 row">
                                            <label for="seccion_bank_cash_payment_instructions" class="col-sm-3"><span class="h6">Payment Instructions</span><span class="text-danger">*</span></label>
                                            <div class="col-sm-9">
                                                <textarea id="seccion_bank_cash_payment_instructions" name="seccion_bank_cash_payment_instructions" class="form-control tener_seccion_bank_cash_payment_instructions" rows="3" autofocus></textarea>

                                            </div>
                                        </div>
                                        <!-- fin Payment Instructions -->

                                    </div>
                                    <!-- fin seccion para Bank / Cash -->

                                    <!-- seccion para Authorize.net -->
                                    <div class="seccionAuthorize_net" style="display: none;">
                                        <!-- API Login ID -->
                                        <div class="mb-3 row">
                                            <label for="seccion_authorize_api_login" class="col-sm-3"><span class="h6">API Login ID</span><span class="text-danger">*</span></label>
                                            <div class="col-sm-9">
                                                <input type="text" id="seccion_authorize_api_login" name="seccion_authorize_api_login" class="form-control tener_seccion_authorize_api_login" autofocus>
                                            </div>
                                        </div>
                                        <!-- fin API Login ID -->

                                        <!-- Transaction Key -->
                                        <div class="mb-3 row">
                                            <label for="seccion_authorize_net_transaction_key" class="col-sm-3"><span class="h6">Transaction Key</span><span class="text-danger">*</span></label>
                                            <div class="col-sm-9">
                                                <input type="text" id="seccion_authorize_net_transaction_key" name="seccion_authorize_net_transaction_key" class="form-control tener_seccion_authorize_net_transaction_key" >
                                            </div>
                                        </div>
                                        <!-- fin Transaction Key -->

                                    </div>
                                    <!-- fin seccion para Authorize.net -->

                                    <!-- seccion para Braintree -->
                                    <div class="seccionBraintree" style="display: none;">
                                        <!--  Your Merchant ID -->
                                        <div class="mb-3 row">
                                            <label for="seccion_braintree_your_merchant_id" class="col-sm-3"><span class="h6">Your Merchant ID</span><span class="text-danger">*</span></label>
                                            <div class="col-sm-9">
                                                <input type="text" id="seccion_braintree_your_merchant_id" name="seccion_braintree_your_merchant_id" class="form-control tener_seccion_braintree_your_merchant_id" autofocus>
                                            </div>
                                        </div>
                                        <!-- fin Your Merchant ID -->

                                        <!-- Public Key -->
                                        <div class="mb-3 row">
                                            <label for="seccion_braintree_public_key" class="col-sm-3"><span class="h6">Public Key</span><span class="text-danger">*</span></label>
                                            <div class="col-sm-9">
                                                <input type="text" id="seccion_braintree_public_key" name="seccion_braintree_public_key" class="form-control tener_seccion_braintree_public_key" >
                                            </div>
                                        </div>
                                        <!-- fin Public Key -->

                                        <!-- Private Key -->
                                        <div class="mb-3 row">
                                            <label for="seccion_braintree_private_key" class="col-sm-3"><span class="h6">Private Key</span><span class="text-danger">*</span></label>
                                            <div class="col-sm-9">
                                                <input type="text" id="seccion_braintree_private_key" name="seccion_braintree_private_key" class="form-control tener_seccion_braintree_private_key" >
                                            </div>
                                        </div>
                                        <!-- fin Private Key -->

                                        <!-- Default Account -->
                                        <div class="mb-3 row">
                                            <label for="seccion_braintree_default_account" class="col-sm-3"><span class="h6">Default Account</span><span class="text-danger">*</span></label>
                                            <div class="col-sm-9">
                                                <input type="text" id="seccion_braintree_default_account" name="seccion_braintree_default_account" class="form-control tener_seccion_braintree_default_account" >
                                            </div>
                                        </div>
                                        <!-- fin Default Account -->

                                        <!-- live or sandbox -->
                                        <div class="mb-3 row">
                                            <label for="seccion_braintree_live_sandbox" class="col-sm-3"><span class="h6">live or sandbox</span><span class="text-danger">*</span></label>
                                            <div class="col-sm-9">
                                                <input type="text" id="seccion_braintree_live_sandbox" name="seccion_braintree_live_sandbox" class="form-control tener_seccion_braintree_live_sandbox" >
                                            </div>
                                        </div>
                                        <!-- fin live or sandbox -->

                                    </div>
                                    <!-- fin seccion para Braintree -->

                                    <div class="mb-3 row">
                                        <label for="estado" class="col-sm-3"><span class="h6">State</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">                                  
                                            <select id="estado" name="estado" class="form-control tenerestado" >
                                                <option value="1" selected>Active</option>
                                                <option value="2">Inactive</option>
                                            </select>
                                        </div>
                                    </div>
 
                                </div>
 
                                

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <button class="btn btn-primary mt-3 me-3" type="submit" id="submit">{$_L['Save']}</button>
                                    </div>
                                </div>
                            </div>


                        </form>
                    </div>

                </div>



            </div>
        </div>
    </div>
</div>




{/block}

{block name="script"}
<script>

    $(".seccionStripe").hide();
    $(".seccionBankCash").hide();
    $(".seccionAuthorize_net").hide();
    $(".seccionBraintree").hide();

    var viaPagoSeleccionada = 1;

    $(document).ready(function () {

 
 
        $(".progress").hide();
        $("#emsg").hide();
        $("#emsgSuccess").hide();
        var _url = '{$_url}';
        
        var $cid = $('#cid');

        $cid.select2();

        $country = $("#country");

        $country.select2();
  
        //aqui enviamos informacion al backend
        $("#submit").click(function (e) {
            e.preventDefault();
 
            $('#ibox_form').block({ message:block_msg });

            $("#emsg").hide();
            $("#emsgSuccess").hide();

            //console.log(base_url + 'parnerts/add-parnert-post/');

            //viaPagoSeleccionada = $(".tenerestado").val();



            var informacionEnviar = {
                viaPagoSeleccionada: viaPagoSeleccionada, // si es paypal o otros

                //paypal
                paypal_email: $(".tener_seccion_paypal_email").val(),  
                paypal_curreny_code: $(".tener_seccion_paypal_curreny_code").val(),  
                paypal_conversion_rate: $(".tener_seccion_paypal_conversion_rate").val(),  

                //stripe
                stripe_publishable_key: $(".tener_seccion_stripe_publishable_key").val(),  
                stripe_secret_key: $(".tener_seccion_stripe_secret_key").val(),  
                stripe_curreny_code: $(".tener_seccion_stripe_curreny_code").val(),  

                //bank / cash
                bank_payment_instructions: $(".tener_seccion_bank_cash_payment_instructions").val(),  

                //Authorize.net
                authorize_api_login: $(".tener_seccion_authorize_api_login").val(),  
                authorize_transaction_key: $(".tener_seccion_authorize_net_transaction_key").val(),  
                
                //Braintree
                braintree_your_merchant_id: $(".tener_seccion_braintree_your_merchant_id").val(),  
                braintree_public_key: $(".tener_seccion_braintree_public_key").val(),  
                braintree_private_key: $(".tener_seccion_braintree_private_key").val(),  
                braintree_default_account: $(".tener_seccion_braintree_default_account").val(),  
                braintree_live_sandbox: $(".tener_seccion_braintree_live_sandbox").val(), 

                //status
                status: $(".tenerestado").val(), 

                //identificador
                identificador: $(".tener_identificador_payment").val(), 

            }; 

   
            /* console.log(JSON.stringify(informacionEnviar));
               return; */
           
            $.post(base_url + 'settings/pg-post-general/', JSON.stringify(informacionEnviar)  ) //$( "#rform" ).serialize()
            .done(function (data) {
                    //console.log(data);
                    /* console.log(data);
                    return; */

                     try {
                         const info = JSON.parse(data);
                       
                        if( info.type == "success")
                        {
                            $('#ibox_form').unblock();

                            toastr.success(info.message);

                            /* var body = $("html, body");
                            body.animate({ scrollTop:0 }, '1000', 'swing'); 
                            $("#emsgbodySuccess").html(info.message);
                            $("#emsgSuccess").show("slow"); */

                            window.location = info.redirect;

                            limpiar();

                        }else{
                            $('#ibox_form').unblock();
                            var body = $("html, body");
                            body.animate({ scrollTop:0 }, '1000', 'swing');
                            $("#emsgbody").html(info.message);
                            $("#emsg").show("slow");
                        }
                    } catch (error) {
                        $('#ibox_form').unblock();
                        var body = $("html, body");
                        body.animate({ scrollTop:0 }, '1000', 'swing');
                        $("#emsgbody").html(data);
                        $("#emsg").show("slow");
                    }
 
        
            });
        });


    });

    $('.viaPago').change(function() {
        // Obtener el valor seleccionado
        var valorSeleccionado = $(this).val();

        viaPagoSeleccionada = valorSeleccionado;
        
        // Obtener el texto de la opción seleccionada
        //var textoSeleccionado = $(this).find('option:selected').text();

        limpiar();
 
        if(valorSeleccionado == "1" )
        {
            //$('.tenerValorMensual').prop('disabled', true);
             $(".seccionPaypal").show();
             $(".seccionStripe").hide();
             $(".seccionBankCash").hide();
             $(".seccionAuthorize_net").hide();
             $(".seccionBraintree").hide();
                
        } 

        if(valorSeleccionado == "2" )
        {
            $(".seccionPaypal").hide();
            $(".seccionStripe").show();
            $(".seccionBankCash").hide();
            $(".seccionAuthorize_net").hide();
            $(".seccionBraintree").hide();
            
 
           //$('.tenerValorPorUsuario').prop('disabled', true);
        }

        if(valorSeleccionado == "3" )
        {
            $(".seccionPaypal").hide();
            $(".seccionStripe").hide();
            $(".seccionBankCash").show();
            $(".seccionAuthorize_net").hide();
            $(".seccionBraintree").hide();
            
           //$('.tenerValorPorUsuario').prop('disabled', true);
        }

        if(valorSeleccionado == "4" )
        {
            $(".seccionPaypal").hide();
            $(".seccionStripe").hide();
            $(".seccionBankCash").hide();
            $(".seccionAuthorize_net").show();
            $(".seccionBraintree").hide();
           //$('.tenerValorPorUsuario').prop('disabled', true);
        }

        if(valorSeleccionado == "5" )
        {
            $(".seccionPaypal").hide();
            $(".seccionStripe").hide();
            $(".seccionBankCash").hide();
            $(".seccionAuthorize_net").hide();
            $(".seccionBraintree").show();
           //$('.tenerValorPorUsuario').prop('disabled', true);
        }
    
    
    });


    function limpiar()
    {
        $("#emsg").hide();
        $("#emsgSuccess").hide();

        //paypal
        $(".tener_seccion_paypal_email").val("");
        $(".tener_seccion_paypal_curreny_code").val("{$currency_code}");
        $(".tener_seccion_paypal_conversion_rate").val("");

        //stripe
        $(".tener_seccion_stripe_publishable_key").val("");
        $(".tener_seccion_stripe_secret_key").val("");
        $(".tener_seccion_stripe_curreny_code").val("{$currency_code}");

        //bank / cash
        $(".tener_seccion_bank_cash_payment_instructions").val("");
    
        //Authorize.net
        $(".tener_seccion_authorize_api_login").val("");
        $(".tener_seccion_authorize_net_transaction_key").val("");
 
        //Braintree
        $(".tener_seccion_braintree_your_merchant_id").val("");
        $(".tener_seccion_braintree_public_key").val("");
        $(".tener_seccion_braintree_private_key").val("");
        $(".tener_seccion_braintree_default_account").val("");
        $(".tener_seccion_braintree_live_sandbox").val("");

        //identificador
        $(".tener_identificador_payment").val("");

         


 
    }

 

function serach_address(address,secundary,option = 1) {

  var country = $('#country').val();
  let x=address.trim();
  if (x.length > 2 && country === "United States") {
    var settings = {
      "url": "https://us-autocomplete-pro.api.smarty.com/lookup?key=188805315395749398&search="+address+"&selected="+secundary+"&include_only_cities=&include_only_states=&include_only_zip_codes=&exclude_states=&prefer_cities=&prefer_states=&prefer_zip_codes=&source=all",
      "method": "GET",
      "timeout": 0,
      "headers": {
        "Host": "us-autocomplete-pro.api.smarty.com",
        "Referer": "https://hispanosdeexitollc.com"
    },
};

$('#browsers').html('');
$('#browsers').show();

$.ajax(settings).done(function (response) {

  $.each(response.suggestions, function (k, v) {
    let text=v.street_line+' '+v.secondary+' '+v.city+', '+v.state+' '+v.zipcode;
    let line=v.street_line+' '+v.secondary+' ('+v.entries+') '+v.city+', '+v.state+' '+v.zipcode;
    let line2=v.street_line+' '+v.secondary;
    let entries=(v.entries > 1) ? '<a href="#" data-data1="'+line+'" data-data2="'+line2+'" class="addresssec"><span class="badge bg-primary rounded-pill">+ '+v.entries+' Address</span></a>' : "" ;
    let option='<li class="list-group-item d-flex justify-content-between align-items-start "><div class="ms-2 me-auto address1" data-data1="'+v.city+'" data-data2="'+v.state+'" data-data3="'+v.zipcode+'" data-data4="'+v.street_line+' '+v.secondary+'"><div class="fw-bold">'+text+'</div></div>'+entries+'</li>';
    $('#browsers').append(option);
    x++;
});
});
}
}


$("input[name='address']").on('input', function(e){
  var address = $(this).val();
  var country = $('#country').val();
  let x=address.trim();
  if (x.length > 2 && country === "United States") {
    address = address.replace(/,/g, "");
    address = address.replace(/ /g, "+");
    address = address.replace(/#/g, "%23");
    serach_address(address,"",1);    
}
});


$(document).on('click', '.address1', function(e){
    e.preventDefault();
    $('#city').val($(this).data('data1'));
    $('#state').val($(this).data('data2'));
    $('#zip').val($(this).data('data3'));
    $('#address').val($(this).data('data4'));
    $('#browsers').hide();

});


$(document).on('click', '.addresssec', function(e){
    e.preventDefault();
    let address=$(this).data('data2');
    $('#address').val(address);
    let secundary=$(this).data('data1');
    secundary = secundary.replace(/,/g, "");
    secundary = secundary.replace(/ /g, "+");
    secundary = secundary.replace(/#/g, "%23");
    address = address.replace(/,/g, "");
    address = address.replace(/ /g, "+");
    address = address.replace(/#/g, "%23");
    serach_address(address,secundary,2);
});

</script>
{/block}