
 

<input type="text" class="form-control url_base" id="url_base" name="url_base" value="{$url_base}" disable hidden>
<input hidden id="cid" class="cid" name="cid" value="{$cid}">

<form id="rform">


    <div class="mb-3"><label for="c_file">{$_L['Files']}</label>

        <select name="c_file" id="c_file" class="form-control">
            {foreach $files as $file}
                <option value="{$file['id']}">{$file['title']}</option>
            {/foreach}

        </select>
    </div>


    <div class="mb-3">
        <button class="btn btn-primary" type="submit" id="assign_file">{$_L['Submit']}</button>

        <a data-bs-toggle="modal" href="#modal_add_item" class="btn btn-primary add_document waves-effect waves-light" id="add_document"><i class="fal fa-plus"></i> {$_L['New Document']}</a>

    </div>

</form>
<hr>
<table class="table table-bordered table-hover sys_table">
    <thead>
    <tr>

        <th class="text-end" data-sort-ignore="true" width="20px;">{$_L['Type']}</th>

        <th>{$_L['Title']}</th>

        <th class="text-end" data-sort-ignore="true" width="100px;">{$_L['Manage']}</th>

    </tr>
    </thead>
    <tbody>

    {foreach $d as $ds}

        <tr>

            <td>
                {if $ds['file_mime_type'] eq 'jpg' || $ds['file_mime_type'] eq 'png' || $ds['file_mime_type'] eq 'gif'}
                    <i class="fal fa-file-image-o"></i>
                {elseif $ds['file_mime_type'] eq 'pdf'}
                    <i class="fal fa-file-pdf-o"></i>
                {elseif $ds['file_mime_type'] eq 'zip'}
                    <i class="fal fa-file-archive-o"></i>
                {else}
                    <i class="fal fa-file"></i>
                {/if}
            </td>


            <td>

                <a href="{$_url}documents/view/{$ds['id']}/">{$ds['title']}</a>

            </td>

            <td class="text-end">

                {*
                    <a href="{$_url}contacts/remove_file/{$cid}/{$ds['id']}/" class="btn btn-success btn-xs btn_eliminar" ><i class="fal fa-times"></i> </a>
                *}
                
                <button data-url="{$_url}contacts/remove_file/{$cid}/{$ds['id']}/" class="btn btn-success btn-xs btn_eliminar" ><i class="fal fa-times"></i> </button>

            </td>


        </tr>

    {/foreach}

    </tbody>
</table>

<div class="modal fade" id="modal_add_item" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-md modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{$_L['New Document']}</h5>
                <button type="button" class="close btn btn-danger" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <form>
                    <div class="mb-3">
                        <label for="doc_title">{$_L['Title']}</label>
                        <input type="text" class="form-control" id="doc_title" name="doc_title">
                    </div>
                </form>
                <hr>
                <form action="" class="dropzone" id="upload_container">
                    <div class="dz-message">
                        <h3> <i class="fal fa-cloud-upload"></i>  {$_L['Drop File Here']}</h3>
                        <br />
                        <span class="note">{$_L['Click to Upload']}</span>
                    </div>
                </form>
                <hr>
                <p>{$_L['Upload Maximum Size']}: {$upload_max_size}</p>
                <p>{$_L['POST Maximum Size']}: {$post_max_size}</p>
            </div>
            <div class="modal-footer">
                <input type="hidden" name="file_link" id="file_link" value="">
                <button type="button" data-bs-dismiss="modal" class="btn btn-danger">{$_L['Close']}</button>
                <button type="button" id="btn_add_file1" class="btn btn-primary">{$_L['Submit']}</button>
            </div>
        </div>
    </div>
</div>

{block name="script"}
    <script>
        Dropzone.autoDiscover = false;
        $(function() {

            var _url = $(".url_base").val();

            var cid = $(".cid").val();

            //console.log("_url");
            //console.log(_url);

            var $modal = $('#cloudonex_body');

            $('[data-bs-toggle="tooltip"]').tooltip();

            var $btn_add_file1 = $("#btn_add_file1");

            var $file_link = $("#file_link");

            var upload_resp;


            var ib_file = new Dropzone("#upload_container",
                {
                    url: _url + "contacts/document_upload/",
                    maxFiles: 1
                }
            );


            ib_file.on("sending", function() {

                $btn_add_file1.prop('disabled', true);

            });

            ib_file.on("success", function(file,response) {

                $btn_add_file1.prop('disabled', false);

                upload_resp = response;

                console.log(upload_resp);

                if(upload_resp.success == 'Yes'){

                    toastr.success(upload_resp.msg);
                    $file_link.val(upload_resp.file);


                }
                else{
                    toastr.error(upload_resp.msg);
                }


            });




            var $doc_title = $("#doc_title");

            var is_global = '0';


            $btn_add_file1.on('click', function(e) {
                e.preventDefault();

                let informacion = {
                    title: $doc_title.val(),
                    file_link: $file_link.val(),
                    cid: cid, // este es el id del contacto
                };

                console.log(informacion);

                
                $.post( _url + "contacts/save_upload/", informacion)
                    .done(function( data ) {

                    //console.log(data);

                    try {
                        const info = JSON.parse(data);

                        if (info.type == "success") {
                            toastr.success(info.mensaje);

                            location.reload();

                        } else {
                            toastr.error(info.mensaje);
                        }
                    } catch (error) {
                        toastr.error(error);
                    }
 
                });


            });




        });

        $('.btn_eliminar').on('click', function() {
            const url = $(this).data('url');
            
            //console.log("url");
            //console.log(url);

            Swal.fire({
                title: 'Are you sure?',
                text: 'Do you want to delete this file?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545', // Red for "Delete"
                cancelButtonColor: '#6c757d',  // Gray for "Close"
                confirmButtonText: 'Delete',
                cancelButtonText: 'Close'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = url; // Redirect to the URL on confirmation
                }
            });

            //window.location.href = url; // Redirect to the URL
            
        });

    </script>
{/block}
