{extends file="$layouts_admin"}
{block name="head"}

   <link href="{$theme}default/css/grupo.css?v={$config['version']}" rel="stylesheet">
 
   <link
         href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css"
         rel="stylesheet"
      />

{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    .plantilla {
      max-width: 84%;
   }

   #texto_textarea_header {
            min-height: 100px;
            box-sizing: border-box;
            width: 100%;
            border: 1px solid #ccc;
            border-radius: 4px;
            resize: vertical;
            overflow: hidden;
         }

</style>

<input type="text" class=" tener_url_base" value={$url_base} disabled hidden/>
 

<div class="row">

    <div class="col-md-12">

       
        <div class="panel">
            <div class="panel-hdr">
                <h2 style="color: #666; font-weight: 600; "><span></span>Create SMS Template</h2>               
            </div>
                                                         
            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">

                    <div class="px-2">
                        
                        <div class="container mi_contenedor_especial">
                           <div class="contenedor_principal"></div>

                           <div class="tile tile-alt" id="messages-main">
                              <div class="row contenedor p-4">
                                 <div class="col-12 col-sm-12 reset">
                                     

                                    <label for="channel" class="col-sm-3"
                                       ><span class="h6">Template Identifier</span
                                       ><span class="text-danger">*</span></label
                                    >
                                    <input
                                       type="text"
                                       class="form-control form-control-sm"
                                       id="tener_input_identificador"
                                    />

                                    <p></p>

                                    <label for="channel" class="col-sm-3"
                                       ><span class="h6">Template SMS</span
                                       ><span class="text-danger">*</span></label
                                    >

                                    <textarea
                                       rows="3"
                                       style="width: 100%; min-height: 200px"
                                       id="texto_textarea_header"
                                       class="form-control form-control-sm"
                                    ></textarea>

                                    <div class="mt-2">
                                       <button
                                          type="button"
                                          class="btn btn-default me-2 mt-1"
                                          id="add_variable"
                                          style="
                                             border-color: #d3cac0;
                                             border: 1px solid #d3cac0;
                                             float: right;
                                          "
                                       >
                                          Add Variable
                                       </button>

                                       <button
                                          type="button"
                                          class="btn btn-default me-2 mt-1"
                                          id="ordenar_variables_plantilla"
                                          style="
                                             border-color: #d3cac0;
                                             border: 1px solid #d3cac0;
                                             float: right;
                                          "
                                       >
                                          Sort variables
                                       </button>
                                    
                                    </div>
                                    <br>
                                     

                                    <p></p>
                                    <label for="channel" class="col-sm-3"
                                       ><span class="h6">Status</span
                                       ><span class="text-danger">*</span></label
                                    >

                                    <select
                                       class="form-control form-control-sm tener_status"
                                       name="status"
                                       id="status"
                                       style="width: 100%"
                                    >
                                       <option value="1">Active</option>
                                       <option value="2">Inactive</option>
                                    </select>

                                    <br />
                                    <p>Rulers:</p>
                                   <ul>
                                       <li>
                                          To write variables &lbrace;&lbrace;n&rbrace;&rbrace; or &lbrace;&lbrace;text&rbrace;&rbrace;. Where n can be any number, for example &lbrace;&lbrace;1&rbrace;&rbrace;, &lbrace;&lbrace;2&rbrace;&rbrace;.
                                       </li>
                                       <li>
                                          2. There are 2 brackets, open and closed brackets, the variable number must be joined together.
                                       </li>
                                    </ul>

                                 </div>
                              </div>

                              <div class="mt-3 row reset">
                                 <div class="col-sm-12">
                                    <button
                                       type="button"
                                       class="btn btn-default me-2 mt-1"
                                       id="guardar_plantilla"
                                       style="
                                          border-color: #d3cac0;
                                          border: 1px solid #d3cac0;
                                          float: right;
                                       "
                                    >
                                       Save template
                                    </button>
                                     
                                    <button
                                       type="button"
                                       class="btn btn-default me-2 mt-1"
                                       id="clean"
                                       style="
                                          border-color: #d3cac0;
                                          border: 1px solid #d3cac0;
                                          float: right;
                                       "
                                    >
                                       New
                                    </button>

                                     
                                 </div>
                              </div>

                              <br />
                              <div class="col-12 col-sm-12">
                                 <div class="table-responsive">
                                    <table class="table table-borderless mt-3">
                                       <thead>
                                          <tr>
                                             <th class="centrar">Identifier</th>
                                             <th class="centrar">Template</th>
                                             <th class="centrar">Status</th>
                                             <th class="centrar">Date Post</th>
                                             <th class="centrar">Date Update</th>
                                             <th class="centrar">Action</th>
                                          </tr>
                                       </thead>
                                       <tbody class="tbody_envios">
                                          <tr>
                                             <th colspan="6" class="centrar pt-4">
                                                No information
                                             </th>
                                          </tr>
                                       </tbody>
                                    </table>
                                 </div>
                              </div>
                           </div>
                        </div>

                       
                    </div>

                  

                </div>
 
                
               
            </div>
        </div>
    </div>
</div>

 

{/block}

{block name="script"}

<script src="{$theme}default/js/whatsapp.js?v={{_raid()}}"></script>

<script src="{$theme}default/js/plantillas.js?v={{_raid()}}"></script>
 

{literal}
<script type="module">

 


   const URL_BASE = $(".tener_url_base").val();
   const tener_id_parametro = $(".tener_id_parametro").val();
   const PATH_IMG = $(".tener_path_img").val();
   
        iniciar_tabla();

         adjustHeightTexto_TextArea();

         var ID_PLANTILLA = null;

         $("#ordenar_variables_plantilla").click(async function () {
            let texto = $("#texto_textarea_header").val();

            if (isEmpty(texto) == true) {
               return;
            }
            let reorderedTemplate = cleanAndReorderTemplate(
               cleanAndReorderTemplate(texto),
            );

           reorderedTemplate = ReorderTemplate(reorderedTemplate);

            //let reorderedTemplate = cleanAndReorderTemplate(texto);
            $("#texto_textarea_header").val(reorderedTemplate);
            $("#texto_textarea_header").text(reorderedTemplate);
            //console.log(texto);
         });

         $("#clean").click(async function () {
            limpiar();

            //console.log(texto);
         });

         $("#add_variable").click(async function () {
            $("#texto_textarea_header").val(
               $("#texto_textarea_header").val() + "{{text}}",
            );
            //console.log(texto);
         });

         function limpiar() {
            $("#texto_textarea_header").val("");
            $("#tener_input_identificador").val("");
            $("#status").val(1);
            ID_PLANTILLA = null;
         }

         function enviarDatosForm(
            textarea = "",
            identificador = "",
            status = 1,
            id,
         ) {
            $("#texto_textarea_header").text(textarea);
            $("#texto_textarea_header").val(textarea);
            $("#tener_input_identificador").val(identificador);
            $("#status").val(status);
            ID_PLANTILLA = id;
         }

         $("#guardar_plantilla").click(async function () {
            let texto = $("#texto_textarea_header").val();
            if (isEmpty(texto) == true) {
               return;
            }

            let status = $(".tener_status").val();

            let identificador = $("#tener_input_identificador").val();
            if (isEmpty(identificador) == true) {
               alert("Identifier is required");
               return;
            }

            let plantilla_ordenada = cleanAndReorderTemplate(
               cleanAndReorderTemplate(texto),
            );

            plantilla_ordenada = ReorderTemplate(plantilla_ordenada);

            if (ID_PLANTILLA == null) {
               let enviar_informacion = {
                  identificador,
                  templates: plantilla_ordenada,
                  accion: "crear",
                  id: null,
                  status,
               };

               $("#texto_textarea_header").val(plantilla_ordenada);

               $.ajax({
                  type: "POST",
                  url: URL_BASE + "social/crear_o_modificar_plantilla_sms",
                  data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
                  contentType: "application/json", // Tipo de contenido JSON
                  success: function (response) {
                     //console.log("Respuesta del servidor:", response);
                     // Hacer algo con la respuesta del servidor
                     //$("#myModal").modal("hide");

                     try {
                        let info = JSON.parse(response);
                        if (info.type == "success") {
                           limpiar();

                           iniciar_tabla();

                           Swal.fire({
                              title: "Templates saved!",
                              text: "Changes saved successfully!",
                              icon: "success",
                           });
                        } else {
                           alert("Error sending group messages");
                        }
                     } catch (error) {
                        alert("Error:" + error);
                     }
                  },
                  error: function (xhr, status, error) {
                     console.error("Error en la solicitud:", error);
                  },
               });
            } else {
               let enviar_informacion = {
                  identificador,
                  templates: plantilla_ordenada,
                  accion: "modificar",
                  id: ID_PLANTILLA,
                  status,
               };

               $("#texto_textarea_header").val(plantilla_ordenada);

               $.ajax({
                  type: "POST",
                  url: URL_BASE + "social/crear_o_modificar_plantilla_sms",
                  data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
                  contentType: "application/json", // Tipo de contenido JSON
                  success: function (response) {
                     //console.log("Respuesta del servidor:", response);
                     // Hacer algo con la respuesta del servidor
                     //$("#myModal").modal("hide");

                     try {
                        let info = JSON.parse(response);
                        if (info.type == "success") {
                           limpiar();
                           Swal.fire({
                              title: "Templates saved!",
                              text: "Changes saved successfully!",
                              icon: "success",
                           });
                           iniciar_tabla();
                        } else {
                           alert("Error sending group messages");
                        }
                     } catch (error) {
                        alert("Error:" + error);
                     }
                  },
                  error: function (xhr, status, error) {
                     console.error("Error en la solicitud:", error);
                  },
               });
            }

            //let reorderedTemplate = cleanAndReorderTemplate(texto);
            //console.log(reorderedTemplate);
            //console.log(texto);
         });

         
         function ReorderTemplate(template) {
            template = template.replace(
               /{{\s*(\d+)\s*}}/g,
               function (match, number) {
                  return `{{${number}}}`;
               },
            );

            // Luego, realizar el reordenamiento si es necesario
            let match;
            let index = 1;
            const regex = /{{(\d+)}}/g;
            const replacements = {};

            while ((match = regex.exec(template)) !== null) {
               const placeholder = match[0];
               const number = parseInt(match[1], 10);

               if (!replacements[number]) {
                  replacements[number] = placeholder;
               }
            }

            return template.replace(regex, function (match, number) {
               return `{{${index++}}}`;
            });
         }


         function cleanAndReorderTemplate(template) {
            
            // Reemplazar {{text}} con un marcador de posición único temporal
            template = template.replace(
               /{{\s*text\s*}}/g,
               "{{text_placeholder}}",
            );

            // Eliminar espacios adicionales y mantener la secuencia de números y el marcador de posición temporal
            template = template.replace(
               /{{\s*(\d+|text_placeholder)\s*}}/g,
               function (match, number) {
                  return "{{" + number + "}}";
               },
            );

            // Crear un objeto para reemplazar números secuenciales y text_placeholder
            let index = 1;
            const replacements = {};

            // Primero, reemplazar los números secuenciales
            template = template.replace(/{{(\d+)}}/g, function (match, number) {
               if (!replacements[number]) {
                  let tempo = index++;
                  replacements[number] ="{{" + tempo + "}}";
               }
               return replacements[number];
            });

            // Luego, reemplazar el marcador de posición temporal con números secuenciales
            template = template.replace(/{{text_placeholder}}/g, function () {
               let tempo = index++;
               return "{{" + tempo + "}}";
            });

            return template;
         }

         function adjustHeightTexto_TextArea() {
            const textarea = document.getElementById("texto_textarea_header");

            textarea.addEventListener("input", () => {
               // Reset the height to auto to shrink the textarea if necessary
               textarea.style.height = "auto";
               // Set the height to scrollHeight to expand to fit the content
               textarea.style.height = textarea.scrollHeight + "px";

               //const currentText = textarea.value;
               //console.log("Current text:", currentText);
            });

            // Initialize height on page load
            textarea.style.height = "auto";
            textarea.style.height = textarea.scrollHeight + "px";
         }

         function isEmpty(variable) {
            if (variable === null || variable === undefined) {
               return true;
            }

            if (typeof variable === "string") {
               return variable.trim() === "";
            }

            if (Array.isArray(variable)) {
               return variable.length === 0;
            }

            if (typeof variable === "object") {
               return Object.keys(variable).length === 0;
            }

            return false;
         }

         function iniciar_tabla() {
            let enviar_informacion = {
               status: "",
               nombres: "",
            };

            $.ajax({
               type: "POST",
               url: URL_BASE + "social/tener_plantilla_sms",
               data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
               contentType: "application/json", // Tipo de contenido JSON
               success: function (response) {
                  // console.log("Respuesta del servidor:", response);
                  // Hacer algo con la respuesta del servidor
                  //$("#myModal").modal("hide");

                  try {
                     let info = JSON.parse(response);
                     if (info.type == "success") {
                        if (Array.isArray(info.data) == true) {
                           let newRow = "";
                           info.data.forEach((element) => {
                              let {
                                 id,
                                 identificador,
                                 plantilla,
                                 status,
                                 fecha_post,
                                 fecha_update,
                              } = element;

                              let fecha =
                                 fecha_update == null || fecha_update == "null"
                                    ? ""
                                    : fecha_update;

                              newRow +=
                                 "<tr>" +
                                 "<td class='centrar'>" +
                                 identificador +
                                 "</td>" +
                                 "<td class='centrar'>" +
                                 plantilla +
                                 "</td>" +
                                 "<td class='centrar'>" +
                                 status +
                                 "</td>" +
                                 "<td class='centrar'>" +
                                 fecha_post +
                                 "</td>" +
                                 "<td class='centrar'>" +
                                 fecha +
                                 "</td>" +
                                 '<td class="text-center">' +
                                 '<div class="btn-group" role="group" aria-label="Basic mixed styles example">' +
                                 '<button type="button" class="btn btn-primary btn-sm btnEdit" data-id="' +
                                 id +
                                 '">Edit</button>' +
                                 '<button type="button" class="btn btn-danger btn-sm btnDelete" data-id="' +
                                 id +
                                 '">Delete</button>' +
                                 "</div>" +
                                 "</td>" +
                                 "</tr>";
                           });

                           $(".tbody_envios").html(newRow);

                           $(".btnEdit").click(async function () {
                              let id = $(this).data("id");

                              let existeData = info.data.find(
                                 (data) => data.id == id,
                              );

                              if (existeData) {
                                 let {
                                    id,
                                    identificador,
                                    plantilla,
                                    status_id,
                                    fecha_post,
                                    fecha_update,
                                 } = existeData;

                                 enviarDatosForm(
                                    plantilla,
                                    identificador,
                                    status_id,
                                    id,
                                 );

                                 //console.log("se dio click");
                                 //$('html, body').animate({ scrollTop: 0 }, 'slow');
                                 $('html, body').scrollTop(0);

                                 //$('.mi_contenedor_especial').scrollTop(0);

                              }
                           });

                           $(".btnDelete").click(async function () {
                              let id = $(this).data("id");
                              inactivar_plantilla(id);
                           });
                        }
                     } else {
                        alert("Error sending group messages");
                     }
                  } catch (error) {
                     alert("Error:" + error);
                  }
               },
               error: function (xhr, status, error) {
                  console.error("Error en la solicitud:", error);
               },
            });
         }

         function inactivar_plantilla(id) {
            let enviar_informacion = {
               id,
            };
            $.ajax({
               type: "POST",
               url: URL_BASE + "social/deshabilitar_sms",
               data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
               contentType: "application/json", // Tipo de contenido JSON
               success: function (response) {
                  // console.log("Respuesta del servidor:", response);

                  try {
                     let info = JSON.parse(response);
                     if (info.type == "success") {
                        Swal.fire({
                           title: "Templates disabled!",
                           text: "Changes saved successfully!",
                           icon: "success",
                        });
                        limpiar();
                        iniciar_tabla();

                        $('html, body').scrollTop(0);
                     } else {
                        alert("Error deactivating templates");
                     }
                  } catch (error) {
                     alert("Error:" + error);
                  }
               },
               error: function (xhr, status, error) {
                  console.error(
                     "Error en la solicitud deshabilitar_sms:",
                     error,
                  );
               },
            });
         }
    
    
  

      function spEditor(selector) {
          $(selector).redactor({
              minHeight: 30,
              buttons: ['html', '|', 'formatting', '|', 'bold', 'italic', 'link', 'unorderedlist', 'orderedlist']
          });
      }


</script>
{/literal}


{/block}