{extends file="$layouts_admin"}
{block name="head"}

    <link href="{$theme}default/css/grupo.css?v={$config['version']}" rel="stylesheet">
 
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">       


{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    .clase_placeholder
    {
        box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
        user-select: none;
        border-radius: 4px;
        color:transparent;
    }
 
.shadow-drop-center {
    animation: shadow-drop-center 0.4s linear both;
}
@keyframes shadow-drop-center {
   0% {
      box-shadow: 0 0 0 0 transparent;
   }
   100% {
      box-shadow: 0 0 20px 0 rgba(255, 255, 255, 0.55);
   }
} 

        
.nuevo_control{
    min-height: calc(1.47em + .75rem + 2px);
    padding: .375rem .844rem;
    font-size: .75rem;
    border-radius: 8px;
}

table.estilosTabla > :not(caption) > * > * {
        /*
        padding-top: 5px !important;
        padding-bottom: 5px !important;
        */
    }

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
        
    }

        .contenedor_etapas {
            display: flex;
            overflow-x: auto;
            scroll-behavior: smooth;
            padding: 10px;
            white-space: nowrap;
            -ms-overflow-style: none;
            scrollbar-width: none;
        }

        .contenedor_etapas::-webkit-scrollbar {
            display: none;
        }

        .contenedor_etapas .col-12 {
            flex: 0 0 auto;
            width: 250px;
        }

        .tamano_icono {
            font-size: 18px;
            color: black;
        }

        .scroll-btn {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            background-color: #001B3B;
            color: white;
            border: none;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            z-index: 10;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
        }

        .scroll-btn.left {
            left: 0px; /* Increased from 10px for more space */
        }

        .scroll-btn.right {
            right: 0px; /* Increased from 10px for more space */
        }

        .scroll-btn:hover {
            background-color:#144681;
        }

        .scroll-container {
            position: relative;
            padding: 0 60px; /* Adjusted padding to match button positions and center cards */
        }

        .cursos_pointer {
            cursor: pointer;
        }

        .quitar_margen {
            padding: 0px;
            margin: 0px;
        }

        .avatar-container {
            height: 30px;
            width: 30px;
            overflow: hidden;
            border-radius: 50%;
        }

        .avatar-container .img-avatar {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
         

        .fecha_contacto {
            text-align: end;
            font-size: 10px;
            font-weight: 600;
            color: #000000c2;
            margin-top:3px;
        }
    
        .conversation-item {
            display: flex;
            align-items: center;
            gap: 10px;
            justify-content: end;
        }

        .text-container {
            display: flex;
            flex-direction: column;
        }

        .conversation-text {
            font-size: 16px;
            color: #333;
            font-weight: 500;
        }

        .quitar_margen {
            margin: 0;
        }

        .fecha-contacto-container {
            display: flex;
            align-items: center;
            justify-content: flex-end; /* Align to the right */
            gap: 5px; /* Space between date and icon */
        }

 
        .action-icon {
           
            color: #001B3B;
            line-height: 1; /* Prevent extra vertical space */
        }

      
      
        .mi-placeholder {
            background-color: #dbdbdb;
            animation: mi-placeholder-glow 1.2s ease-in-out infinite;
            cursor: wait;
        }

        @keyframes mi-placeholder-glow {
            0% {
                opacity: 0.6;
            }
            50% {
                opacity: 0.3;
            }
            100% {
                opacity: 0.6;
            }
        }

        .aplicar_hover_contactos:hover {
            background-color: #EAEDF3;  
            cursor: pointer;

        }

        .blur-in-expand {
            animation: blur-in-expand 0.2s linear both;
        }

        @keyframes blur-in-expand {
            0% {
                transform: scale(0.8);  
                filter: blur(10px);   
                opacity: 0;
            }
            100% {
                transform: scale(1);
                filter: blur(0);
                opacity: 1;
            }
        }

  
        .conversation-item-staff {
            display: flex;
            align-items: center;
            gap: 10px;
            justify-content: flex-start;
            flex-wrap: nowrap;
        }

        .avatar-container-staff {
            height: 40px;
            width: 40px;
            overflow: hidden;
            /* border-radius: 50%;*/
            flex-shrink: 0;
            position: relative; /* Ensure this is explicitly set */
        }

        .avatar-container-staff .img-avatar {
            width: 100%;
            height: 100%;
            object-fit: cover;
            position: relative; /* Ensure image is in flow */
        }

        .text-container {
            display: flex;
            align-items: center;
        }

        .conversation-text {
            font-size: 16px;
            color: #333;
            font-weight: 600;
            margin: 0;
        }

        .quitar_margen {
            margin: 0;
        }

 

        /* Online status indicator */
        .online-status-staff {
            position: absolute;
            width: 12px !important; /* Ensure width is applied */
            height: 12px !important; /* Ensure height is applied */
            background-color: #28a745; /* Green for online */
            border-radius: 50% !important; /* Ensure circular shape */
            bottom: 0px; /* Overlap the avatar */
            right: 0px; /* Overlap the avatar */
            border: 2px solid #fff; /* White border for contrast */
            z-index: 1; /* Above the image */
            box-sizing: border-box; /* Include border in dimensions */
            padding: 0; /* Remove any padding */
            margin: 0; /* Remove any margin */
        }

        .report-link {
            text-decoration: underline !important;
            color: #0000FF; /* Blue color for unvisited links */
        }

        .report-link:visited {
            color: #800080;  
        }

        .report-link:hover {
            text-decoration:underline !important;
            color: #0000EE;  
        }


        #chart {
           
            width: 100%;
            height: 400px;         
        }

        #chart_filtros {
            width: 100%;
            height: 400px;
        }

        .tener_staff_id_form + .select2-container .select2-selection--single {
            height: 36px !important;  
            line-height: 36px !important; 
        }

        .tener_staff_id_form + .select2-container .select2-selection__rendered {
            line-height: 36px !important;  
            font-size: 16px !important;  
        }
       
        .tener_staff_id_form + .select2-container .select2-selection__arrow {
            height: 36px !important; 
        }

        .tamano_input_select{
            height: 36px;
            min-height: 36px;
        }

 
</style>

<input type="text" disabled hidden id="ws_nombre_socket" value="{$ws_nombre_socket}">

<input
         type="text"
         value="{$APP_URL_ORIGINAL_SOCKET}"
         disabled
         hidden
         id="APP_URL_ORIGINAL_SOCKET"
      />

<input
         type="text"
         value="{$path_img_default}"
         disabled
         hidden
         id="PATH_IMG_DEFAULT"
      />

<input
         type="text"
         value="{$DB_NAME}"
         disabled
         hidden
         id="DB_NAME"
      />

<input type="text" class=" tener_url_base" value={$url_base} disabled hidden/>
 
<div class="row">

    <div class="col-md-12">
        <button
            type="button"
            class="btn btn-default update"
             style=" border-color: #d3cac0; border: 1px solid #d3cac0; float: right; background: #001B3B; color: white; "
        >
            Update
        </button>


        <span style=" float: right; align-content: center; align-items: center; height: 100%; padding-right: 10px; font-weight: 700; color: black; " id="fecha_ultimo_update">Last update: 27 march 2025, 10:25AM<span/>

    </div>

 
    <div class="col-md-12">
        <div class="scroll-container">
            <button class="scroll-btn left" id="scrollLeft"><i class="fa-solid fa-chevron-left"></i></button>
            <button class="scroll-btn right" id="scrollRight"><i class="fa-solid fa-chevron-right"></i></button>
            <div class="contenedor_etapas" style="padding: 10px">
                 
                <br />
            </div>
        </div>
    </div>

    <div class="col-12 col-md-6">

        <div class="panel" style="box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;">
            <div class="panel-hdr" style="border-bottom: none;">
                <h2 style="color: black; font-weight: 600; ">Contacts (last 5 records)</h2>
            </div>
                                                         
            <div class="panel-container show" id="ibox_form">

                <div class="panel-content" style="padding-top: 0px;padding-left: 0px; padding-right: 0px;" >

                    <ul class="nav nav-tabs nav-tabs-clean mb-3" role="tablist">
                        <li class="nav-item"><a class="nav-link cursos_pointer contactos_abiertas active">Open</a></li>
                        <li class="nav-item"><a class="nav-link cursos_pointer contactos_no_asignadas" >Unnasigned</a></li>
                    </ul> 

                    <div class="row quitar_margen contactos_listado" style="padding: 10px; ">

                    {*
                    
                        {foreach $listado_conversaciones_abiertas as $item}
                            <div class="col-12 col-sm-6">
                                <h3 class="quitar_margen" style="color: #001B3B;">{$item['nombre_asignado']}</h3>
                                <p class="quitar_margen" style="font-style: italic;">{$item['ultimo_mensaje']}</p>
                            </div>

                            <div class="col-12 col-sm-6">
                                <div class="fecha-contacto-container">
                                    <p class="quitar_margen fecha_contacto">{$item['fecha_humana']}</p>
                                    <i class="fa-solid fa-user-minus action-icon"></i>
                                </div>

                                <div class="conversation-item">
                                    <div class="avatar-container">
                                        <img src="{$item['ruta_img_staff']}" class="img-avatar" onerror="this.src='{$path_img_default}'"/>
                                    </div>
                                    <div class="text-container">
                                        <span class="conversation-text">{$item['nombre_staff']}</span>
                                    </div>
                                </div>
                            </div>

                            {if !$item@last}
                                <hr style="margin-top: 10px;"/>
                            {/if}
                        {/foreach}
                    *}

                     

                    </div>

                    <a href="{$url_chat}" target="_blank" class="report-link" style=" display: flex; justify-content: end; padding-right: 18px; ">Go to chat</a>


                    

                     
                </div>
               
            </div>

        </div>

    </div>

    <div class="col-12 col-md-6">

        <div class="panel" style="box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;">
            <div class="panel-hdr" style="border-bottom: none;">

                <div class="row" style=" padding: 0; margin: 0; width: 100%; ">

                    <div class="col-12 col-sm-6">
                        <h2 style="color: black; font-weight: 600; ">Team members</h2>
                    </div>

                    <div class="col-12 col-sm-6">
                       
                        <select class="form-select form-select-sm select_estado_staff" id="select_estado_staff" style=" min-height: 36px !important; height: 36px; margin-top: 10px; ">
                            <option value="all">All</option>
                            <option value="online">Online</option>
                            <option value="offline">Offline</option>
                        </select>

                    </div>

                </div>

                 
            </div>
                                                         
            <div class="panel-container show" id="ibox_form">

                <div class="panel-content listado_staff_estado" style="padding-top: 0px;padding-left: 0px; padding-right: 0px;" >
                
                    {*

                    {foreach $listado_staff as $item}
                        <div class="row quitar_margen aplicar_hover_contactos blur-in-expand" style="margin: 10px;border-radius: 4px;padding: 4px;">
                            <div class="col-12 col-sm-6">
                                <div class="conversation-item-staff">
                                    <div class="avatar-container-staff">
                                        <img src="{$item['ruta_img_staff']}" class="img-avatar" onerror="this.src='{$path_img_default}'"/>
                                        <div class="online-status-staff estado_staff_{$item['id_staff']}"></div> 
                                    </div>
                                    <div class="text-container">
                                        <span class="conversation-text" style="font-weight: 600;">{$item['nombre_staff']}</span>
                                    </div>
                                </div>
                                <p style=" font-size: 10px; margin-top: 4px; " class="quitar_margen">Asignados a 670 Contactos</p>
                            </div>

                            <div class="col-12 col-sm-6">
                                <h3 class="quitar_margen fecha_contacto fecha_ultimo_login_staff_{$item['id_staff']}" style="color: #001B3B;">{$item['fecha_ultimo_login']}</h3>
                            </div>

                            {if !$item@last}
                                <hr style="margin-top: 10px;margin-bottom: 0px;"/>
                            {/if}
                        </div>
                    {/foreach}
                    
                    *}
                     
                </div>

                 
               
            </div>

        </div>

    </div>

    <div class="col-12 col-md-12">
        
        <div class="panel" style="box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;">
            <div class="panel-hdr" style="border-bottom: none;">
                <div style="display: flex; justify-content: space-between; align-items: center; width: 100%">

                    <div>
                      <h2 style="color: black; font-weight: 600; ">Conversations</h2>
                    </div>

                    <div>
                        <h2 style="color: black; font-weight: 600; ">{$fecha_actual}  /  {$fecha_restado_siete_dias}</h2>
                    </div>                

                </div>
                 
            </div>
                                                         
            <div class="panel-container show" id="ibox_form">

                <div class="panel-content" style="padding-top: 0px;padding-left: 0px; padding-right: 0px;" >

                    <div class="row" style=" padding: 0; margin: 0; ">

                        <div class="col-12">
                            <div id="chart" style="display:none"></div>

                        </div>

                        <div class="col-12 mostras_placeholder_graficos" >
                            <div class="mi-placeholder" style="width: 100%;height: 400px;padding: 10px; border-radius: 4px; box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; "></div>
                        </div>

                        <div class="col-12">
                            <a href="{$url_ver_conversacion}" target="_blank" class="report-link" style=" display: flex; justify-content: end; padding-right: 18px; ">View conversations</a>
                        </div>

                    </div>

                      
                </div>
               
            </div>

        </div>

         
    </div>

    <div class="col-12 col-md-12">
        
        <div class="panel" style="box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;">
            <div class="panel-hdr" style="border-bottom: none;">
                <div style="display: flex; justify-content: space-between; align-items: center; width: 100%">

                    <div>
                      <h2 style="color: black; font-weight: 600; ">Converting conversations to sales</h2>
                    </div>

                    {* 
                    <div>
                        <h2 style="color: black; font-weight: 600; ">{$fecha_actual}  /  {$fecha_restado_siete_dias}</h2>
                    </div>
                    *}                

                </div>
                 
            </div>
                                                         
            <div class="panel-container show" id="ibox_form">

                <div class="panel-content" style="padding-top: 0px;padding-left: 0px; padding-right: 0px;" >

                    <div class="row" style=" padding: 0; margin: 0; ">


                        <div class="col-12 col-sm-12">
                             
                            <label for="staff"><span style="color: black;">Assigned Agent</span> </label>
                            <select
                                class="form-select nuevo_control tener_staff_id_form"
                                name="staff_id_form"
                                id="staff_id_form"
                                style="width: 100%"
                                placeholder="Select a staff"
                            >
                                <option value="0" >All</option>
                                {foreach $listado_staff_activos as $ds}
                                    <option value="{$ds['id']}" >{$ds['fullname']}</option>
                                {/foreach}
                            </select>
 
                        </div>

                        {* fecha desde *}
                        <div class="col-12 col-sm-6 mt-2">
                            <label for="fecha_desde"
                                ><span style="color: black;">Date From</span>
                            </label>
                            <input
                                type="date"
                                id="fecha_desde"
                                name="fecha_desde"
                                class="form-control form-control-sm tener_fecha_desde tamano_input_select"
                            />
                        </div>

                        {* fecha hasta *}
                        <div class="col-12 col-sm-6 mt-2">
                            <label for="fecha_hasta"
                                ><span style="color: black;">Date to</span>
                            </label>
                            <input
                                type="date"
                                id="fecha_hasta"
                                name="fecha_hasta"
                                class="form-control form-control-sm tener_fecha_hasta tamano_input_select"
                            />
                        </div>

                        <div class="col-12 col-sm-12 mt-2">
                            <button
                                type="button"
                                class="btn btn-default filtrar_informacion_dashboard"
                                style=" border-color: #d3cac0; border: 1px solid #d3cac0; float: right; background: #001B3B; color: white; "
                            >
                                Filter
                            </button>
                        </div>

                        <div class="col-12">
                            {*style="display:none"*}

                            <div id="chart_filtros"></div>
                        </div>

                        {*
                        <div class="col-12 mostras_placeholder_graficos" >
                            <div class="mi-placeholder" style="width: 100%;height: 400px;padding: 10px; border-radius: 4px; box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; "></div>
                        </div>
                        *}

                        <div class="col-12">
                            <a href="{$url_ver_conversacion}" target="_blank" class="report-link" style=" display: flex; justify-content: end; padding-right: 18px; ">View conversations</a>
                        </div>

                    </div>

                      
                </div>
               
            </div>

        </div>

         
    </div>

    <div class="col-12 col-md-12">

        <div class="panel" style="box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;">
            <div class="panel-hdr" style="border-bottom: none;">
                <div style="display: flex; justify-content: space-between; align-items: center; width: 100%">

                    <div>
                      <h2 style="color: black; font-weight: 600; ">Top personal highest conversion rate</h2>
                    </div>

                    <div>
                        <h2 style="color: black; font-weight: 600; ">{$fecha_actual}  /  {$fecha_restado_siete_dias}</h2>
                    </div>                

                </div>
                 
            </div>
                                                         
            <div class="panel-container show" id="ibox_form">

                <div class="panel-content" style="padding-top: 0px;padding-left: 0px; padding-right: 0px;" >

                    <div class="table-responsive">
                        <table class="table table-striped table-hover mt-3 estilosTabla"  id="clx_datatable">
                            <thead>
                            <tr>
                                <th class="centrar">Contact</th>
                                <th class="centrar">Open Conversations</th>
                                <th class="centrar">Closed Sales</th>
                                <th class="centrar">Unconverted (discarded)</th>
                                <th class="centrar">Success Rate (%)</th>
                                <th class="centrar">Best Selling Product</th>
                                <th class="centrar">Average Days Closing</th>
                               
                            </tr>
                            </thead>
                            <tbody class="tbody_envios">
                              
                            </tbody>
                        </table>
                    </div>

                    <a href="{$url_mayor_tasa_conversion}" target="_blank" class="report-link" style=" display: flex; justify-content: end; padding-right: 18px; ">View reports</a>

                    {*

                    {foreach $listado_staff as $item}
                        <div class="row quitar_margen aplicar_hover_contactos blur-in-expand" style="margin: 10px;border-radius: 4px;padding: 4px;">
                            <div class="col-12 col-sm-6">
                                <div class="conversation-item-staff">
                                    <div class="avatar-container-staff">
                                        <img src="{$item['ruta_img_staff']}" class="img-avatar" onerror="this.src='{$path_img_default}'"/>
                                        <div class="online-status-staff estado_staff_{$item['id_staff']}"></div> 
                                    </div>
                                    <div class="text-container">
                                        <span class="conversation-text" style="font-weight: 600;">{$item['nombre_staff']}</span>
                                    </div>
                                </div>
                                <p style=" font-size: 10px; margin-top: 4px; " class="quitar_margen">Asignados a 670 Contactos</p>
                            </div>

                            <div class="col-12 col-sm-6">
                                <h3 class="quitar_margen fecha_contacto fecha_ultimo_login_staff_{$item['id_staff']}" style="color: #001B3B;">{$item['fecha_ultimo_login']}</h3>
                            </div>

                            {if !$item@last}
                                <hr style="margin-top: 10px;margin-bottom: 0px;"/>
                            {/if}
                        </div>
                    {/foreach}
                    
                    *}
                     
                </div>
               
            </div>

        </div>

    </div>

     



</div>

 

{/block}

{block name="script"}

 
{literal}
<script type="module">

 
    const URL_BASE      = $(".tener_url_base").val();
    const tener_role_id = $(".tener_role_id").val();

    var WS_NOMBRE_SOCKET = document.getElementById('ws_nombre_socket').value;

    console.log("URL_BASE");
    console.log(URL_BASE);

    var listado_etapas_conversaciones       = [];
    var listado_conversaciones_abiertas     = [];
    var listado_conversaciones_no_asignadas = [];
    var listado_staff                       = [];
    var listado_mayor_tasa_conversion       = [];
    var listado_mayor_tasa_conversion_html  = ""; 
    var fecha_ultima_actualizacion          = 0;

    var listado_conversaciones              = [];
    var listado_conversaciones_dias         = [];
    var listado_conversaciones_dias_fechas  = [];

    var fecha_desde = "";
    var fecha_hasta = "";

    var APP_URL_ORIGINAL_SOCKET = $("#APP_URL_ORIGINAL_SOCKET").val();
    var BASE_DE_DATOS_GLOBAL = $("#DB_NAME").val();

    var NOMBRE_LISTADO_ASISTENCIAS_LOCALSTORAGE = "listado_asistencias_" + BASE_DE_DATOS_GLOBAL;

    var NOMBRE_ULTIMA_EJECUCION = "data_dashboard_message_" + BASE_DE_DATOS_GLOBAL;

    llenarFechaActual();
    
    let estructura_storage = {
        listado_etapas_conversaciones: [],
        listado_conversaciones_abiertas: [],
        listado_conversaciones_no_asignadas: [],
        listado_staff: [],
        listado_mayor_tasa_conversion: [],
        listado_mayor_tasa_conversion_html: "",
        fecha_ultima_actualizacion: "",
        listado_conversaciones: [],
        listado_conversaciones_dias: [],
        listado_conversaciones_dias_fechas: [],
        fecha_desde: "",
        fecha_hasta: "",
    };
 
    //ejecutamos la primera ves
    ejecutarInformacionBackend(true);

    //setInterval(ejecutarInformacionBackend(false), 3000); // 20000 se ejecuta 20 segundos

    setInterval(() => ejecutarInformacionBackend(false), 20000);

    function filtrarOnlineOfflineStaff(estado = "") 
    {
         
        if(estado == "all")
        {
            // Mostrar todos los contenedores row
            $('.listado_staff_estado .row.quitar_margen').css('display', '');
            return;  
        }

        const onlineElements = $('.online-status-staff[data-estado="'  + estado +  '"]');

        // Mostrar solo los contenedores row asociados a los elementos online
        onlineElements.each(function() {
            $(this).closest('.row.quitar_margen').css('display', ''); // Asegura visibilidad
        });

        // Ocultar todos los demás contenedores row que no están asociados a online
        $('.listado_staff_estado .row.quitar_margen').each(function() {
            const hasOnlineStatus = $(this).find('.online-status-staff[data-estado="' + estado + '"]').length > 0;
            if (!hasOnlineStatus) {
                $(this).css('display', 'none');
            }
        });
    }

    const socket = io(APP_URL_ORIGINAL_SOCKET, {
       path: "/" + WS_NOMBRE_SOCKET + "/socket.io",
       //path: "/socket-chat/socket.io",
       //transports: ["websocket"],
         transports: ["polling"],  // Usar
    });

    function pintarInformacionConversacionesVentas(data = [])
    {


        let maximo = 0;

        let maximo_abierto = Math.max(...data.map((data) =>  parseInt(data.total_conversaciones_abiertas, 10) ));
        let maximo_cerrado = Math.max(...data.map((data) =>  parseInt(data.total_conversaciones_cerradas, 10) ));
        let maximo_no_convertidas = Math.max(...data.map((data) =>  parseInt(data.total_conversaciones_no_convertidas, 10) ));

        maximo = Math.max(maximo_abierto, maximo_cerrado, maximo_no_convertidas) + 1;

        //---------
        const chartData = {
            dates:  data.map((data) => data.nombre_mes ),
            abierto: data.map((data) => parseInt(data.total_conversaciones_abiertas)),  
            cerrado: data.map((data) => parseInt(data.total_conversaciones_cerradas)),   
            no_convertidas: data.map((data) => parseInt(data.total_conversaciones_no_convertidas)),   
        };

        const totalAbierto = chartData.abierto.reduce((sum, value) => sum + value, 0);
        const totalCerrado = chartData.cerrado.reduce((sum, value) => sum + value, 0);
        const totalNoConvertidas = chartData.no_convertidas.reduce((sum, value) => sum + value, 0);

        // Inicializar el gráfico ECharts
        const chartDom = document.getElementById('chart_filtros');

        const myChart = echarts.init(chartDom);

        const option = {
            title: {
                text: ''
            },
            tooltip: {
                trigger: 'axis',
                axisPointer: { type: 'shadow' }
            },
            legend: {
                data: ['Open', 'Close', 'Discarded']
            },
            xAxis: {
                type: 'category',
                data: chartData.dates
            },
            yAxis: {
                type: 'value',
                max: maximo // Ajustado según el máximo aproximado de la imagen
            },
            series: [
                {
                    name: 'Open',
                    type: 'bar',
                    data: chartData.abierto,
                    itemStyle: {
                        color: '#1E90FF' // Azul
                    },
                    label: {
                        show: true,
                        position: 'top'
                    }
                },
                {
                    name: 'Close',
                    type: 'bar',
                    data: chartData.cerrado,
                    itemStyle: {
                        color: '#D3D3D3' // Gris claro
                    },
                    label: {
                        show: true,
                        position: 'top'
                    }
                },

                {
                    name: 'Discarded',
                    type: 'bar',
                    data: chartData.no_convertidas,
                    itemStyle: {
                        color: '#e9e400'  
                    },
                    label: {
                        show: true,
                        position: 'top'
                    }
                }
            ],
            graphic: [
                {
                    type: 'text',
                    left: 'end',
                    style: {
                        text: `Open: ${totalAbierto} Close: ${totalCerrado} Discarded: ${totalNoConvertidas}`,
                        textAlign: 'center',
                        fill: '#000',
                        fontSize: 14,
                        fontWeight: 600
                    },
                
                }
            ]
        };

        myChart.setOption(option);
    }

    $(document).ready(function() {

         

        $(".tener_staff_id_form").select2({
            placeholder: "Select an option",
            allowClear: true,
        });

        const $contenedor = $('.contenedor_etapas');
        const scrollAmount = 250;

        $('#scrollLeft').on('click', function() {
            $contenedor.animate({
                scrollLeft: $contenedor.scrollLeft() - scrollAmount
            }, 300, 'easeInOutQuad');
        });

        $('#scrollRight').on('click', function() {
            $contenedor.animate({
                scrollLeft: $contenedor.scrollLeft() + scrollAmount
            }, 300, 'easeInOutQuad');
        });

        function updateButtonVisibility() {
            const scrollLeft = $contenedor.scrollLeft();
            const maxScroll = $contenedor[0].scrollWidth - $contenedor[0].clientWidth;

            $('#scrollLeft').toggle(scrollLeft > 0);
            $('#scrollRight').toggle(scrollLeft < maxScroll - 1);
        }

        $contenedor.on('scroll', updateButtonVisibility);
        updateButtonVisibility();

        $('#select_estado_staff').on('change', function() {
            const selectedValue = $(this).val();
            console.log('Valor seleccionado:', selectedValue);

            filtrarOnlineOfflineStaff(selectedValue); 
 
        });



        $('.filtrar_informacion_dashboard').on('click', function() {
            
            let staff_id_form = $("#staff_id_form").val();
            let fecha_desde = $("#fecha_desde").val();
            let fecha_hasta = $("#fecha_hasta").val();

            if(isEmpty(fecha_desde) == true)
            {
                Swal.fire('Required Fields', '!The date from field is required¡', 'error');
                return;
            }

            if(isEmpty(fecha_hasta) == true)
            {
                Swal.fire('Required Fields', '!The date to field is required¡', 'error');
                return;
            }

            //$(".filtrar_informacion_dashboard").prop("disabled", true);

            let enviar_informacion = {
                staff_id: staff_id_form == "0" || isEmpty(staff_id_form) == true ? "" : staff_id_form,
                fecha_desde: fecha_desde,
                fecha_hasta: fecha_hasta,
            };

            console.log("Informacion a enviar para filtrar");
            console.log(enviar_informacion);

            $(".filtrar_informacion_dashboard").prop("disabled", true);

            $.ajax({
            type: "POST",
            url: URL_BASE + "social/post-dashboard-message-conversion-conversaciones-ventas",
            data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

                $(".filtrar_informacion_dashboard").prop("disabled", false);
                
                try {
                    let info = JSON.parse(response);
 

                    if (info.type == "success") {
                     
                        let data              = info.data || [];
                        let data_copia        = info.data || [];

                        let maximo = 0;

                        let maximo_abierto = Math.max(...data.map((data) =>  parseInt(data.total_conversaciones_abiertas, 10) ));
                        let maximo_cerrado = Math.max(...data.map((data) =>  parseInt(data.total_conversaciones_cerradas, 10) ));
                        let maximo_no_convertidas = Math.max(...data.map((data) =>  parseInt(data.total_conversaciones_no_convertidas, 10) ));

                        maximo = Math.max(maximo_abierto, maximo_cerrado, maximo_no_convertidas) + 1;

                        //---------
                        const chartData = {
                            dates:  data.map((data) => data.nombre_mes ),
                            abierto: data.map((data) => parseInt(data.total_conversaciones_abiertas)),  
                            cerrado: data.map((data) => parseInt(data.total_conversaciones_cerradas)),   
                            no_convertidas: data.map((data) => parseInt(data.total_conversaciones_no_convertidas)),   
                        };

                        const totalAbierto = chartData.abierto.reduce((sum, value) => sum + value, 0);
                        const totalCerrado = chartData.cerrado.reduce((sum, value) => sum + value, 0);
                        const totalNoConvertidas = chartData.no_convertidas.reduce((sum, value) => sum + value, 0);

                        // Inicializar el gráfico ECharts
                        const chartDom = document.getElementById('chart_filtros');

                        const myChart = echarts.init(chartDom);

                        const option = {
                            title: {
                                text: ''
                            },
                            tooltip: {
                                trigger: 'axis',
                                axisPointer: { type: 'shadow' }
                            },
                            legend: {
                                data: ['Open', 'Close', 'Discarded']
                            },
                            xAxis: {
                                type: 'category',
                                data: chartData.dates
                            },
                            yAxis: {
                                type: 'value',
                                max: maximo // Ajustado según el máximo aproximado de la imagen
                            },
                            series: [
                                {
                                    name: 'Open',
                                    type: 'bar',
                                    data: chartData.abierto,
                                    itemStyle: {
                                        color: '#1E90FF' // Azul
                                    },
                                    label: {
                                        show: true,
                                        position: 'top'
                                    }
                                },
                                {
                                    name: 'Close',
                                    type: 'bar',
                                    data: chartData.cerrado,
                                    itemStyle: {
                                        color: '#D3D3D3' // Gris claro
                                    },
                                    label: {
                                        show: true,
                                        position: 'top'
                                    }
                                },

                                {
                                    name: 'Discarded',
                                    type: 'bar',
                                    data: chartData.no_convertidas,
                                    itemStyle: {
                                        color: '#e9e400'  
                                    },
                                    label: {
                                        show: true,
                                        position: 'top'
                                    }
                                }
                            ],
                            graphic: [
                                {
                                    type: 'text',
                                    left: 'end',
                                    style: {
                                        text: `Open: ${totalAbierto} Close: ${totalCerrado} Discarded: ${totalNoConvertidas}`,
                                        textAlign: 'center',
                                        fill: '#000',
                                        fontSize: 14,
                                        fontWeight: 600
                                    },
                                
                                }
                            ]
                        };

                        myChart.setOption(option);


                        let data_storage  = getFromLocalStorage(NOMBRE_ULTIMA_EJECUCION) || [];

                        data_storage.listado_conversaciones_dias_fechas = [];
                        data_storage.listado_conversaciones_dias_fechas = [...data_copia];

                        data_storage.fecha_desde = fecha_desde;
                        data_storage.fecha_hasta = fecha_hasta;
 
                        saveToLocalStorage(NOMBRE_ULTIMA_EJECUCION, data_storage);
 
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: info.message,
                        });
                    }
                } catch (error) {
                    
                    //alert("Error:" + error);
                    //console.error("Error ", error);

                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: error,
                    });
                }
            },
            error: function (xhr, status, error) {
                $(".filtrar_informacion_dashboard").prop("disabled", false);
                $(".tbody_envios").html("");
                console.error("Error en la solicitud:", error);
            },
        });
             

        });

        socket.emit("join-chat-room", BASE_DE_DATOS_GLOBAL);

 
        //AREA DEL SOCKET
        socket.on("connect", () => {
            console.log("Conectado al servidor de Socket.IO");

            socket.emit("join-chat-room", BASE_DE_DATOS_GLOBAL);
        });

        // Manejar la desconexión
        socket.on("disconnect", () => {
            console.log("Desconectado del servidor de Socket.IO");
        });

        socket.on("estado-online-staff/" + BASE_DE_DATOS_GLOBAL, (data) => {
        
            //console.log("Datos de chat recibidos estado-online-staff dashboard:", data);

            let listado_asistencias_staff  = getFromLocalStorage(NOMBRE_LISTADO_ASISTENCIAS_LOCALSTORAGE) || [];

            let existe_staff = listado_asistencias_staff.find(item => item.staff_id == data.staff_id);

            if(!existe_staff)
            {
                listado_asistencias_staff.push(data);
                saveToLocalStorage(NOMBRE_LISTADO_ASISTENCIAS_LOCALSTORAGE, listado_asistencias_staff);
            }

            //listado_asistencias_staff  = getFromLocalStorage(NOMBRE_LISTADO_ASISTENCIAS_LOCALSTORAGE) || [];

            //console.log("listado_asistencias_staff despues de agregar");
            //console.log(listado_asistencias_staff);

            $(".estado_staff_general").css("background-color", "red");

            $(".estado_staff_general").attr("data-estado", "offline");

            listado_asistencias_staff.forEach((item) => {

                let {
                    staff_id,
                    fecha_login,
                    db,
                } = item;

                $(".estado_staff_" + staff_id).css("background-color", "green");
                $(".estado_staff_" + staff_id).attr("data-estado", "online");
                $(".fecha_ultimo_login_staff_" + staff_id).text(fecha_login);

                $(".estado_staff_" + staff_id).addClass("shadow-drop-center");

            }); 

             

            filtrarOnlineOfflineStaff($('#select_estado_staff').val()); 

        });
         
         

    });

    function llenarFechaActual()
    {
        const today = new Date(); // May 28, 2025, 20:53 PM CST

        // Formatear la fecha como YYYY-MM-DD
        const year = today.getFullYear(); // 2025
        const month = String(today.getMonth() + 1).padStart(2, '0'); // 05 (getMonth() es 0-based, por eso +1)
        const day = String(today.getDate()).padStart(2, '0'); // 28
        const formattedDate = `${year}-${month}-${day}`; // 2025-05-28

        return formattedDate;
    } 
 
    //setInterval(ejecutarAsisteciaSocket, 3000);
    //setInterval(ejecutarAsisteciaSocket, 3000);
    setInterval(resetAsistenciaStaffSocket, 45000);

    //$("#fecha_desde_tiempo_abierto").prop("disabled", true);
    //$("#fecha_hasta_tiempo_abierto").prop("disabled", true);

     
 
    $(".update").click(function () {
 
        cargar_update();
    });

    function cargar_update()
    {
        $(".update").prop("disabled", true);

        $(".contenedor_etapas").html(DibujarEtapasConversacionesEsqueleton());
        $(".contactos_listado").html(DibujarContactosAbiertosEsqueleton());
        $(".listado_staff_estado").html(DibujarStaffEstadoEsqueleton());
        $(".tbody_envios").html(DibujarTablaMayorTasaConversionPlaceHolder());

        $(".mostras_placeholder_graficos").css("display", "");
        $("#chart").css("display", "none");

        $('.contactos_abiertas').off('click');
        $('.contactos_no_asignadas').off('click');

        let fecha_desde = $("#fecha_desde").val();
        let fecha_hasta = $("#fecha_hasta").val();

        console.log("fecha_desde cargando");
        console.log(fecha_desde);
        console.log("fecha_hasta cargando");
        console.log(fecha_hasta);

        if(isEmpty(fecha_desde) == true || isEmpty(fecha_hasta) == true)
        {
            fecha_desde = "";
            fecha_hasta = "";
        }
        
        let enviar_informacion = {
            staff_id: "",
            fecha_desde: fecha_desde,
            fecha_hasta: fecha_hasta,
        };

        console.log("Informacion a enviar para cargar update");
        console.log(enviar_informacion);

       $.ajax({
          type: "POST",
          url: URL_BASE + "social/post-dashboard-message",
          data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
          contentType: "application/json", // Tipo de contenido JSON
          success: function (response) {

             $(".update").prop("disabled", false);
            
             try {
                let info = JSON.parse(response);
                if (info.type == "success") {

                    $("#select_estado_staff").val("all");

                   listado_etapas_conversaciones            = info.listado_etapas_conversaciones || [];
                   listado_conversaciones_abiertas          = info.listado_conversaciones_abiertas || [];
                   listado_conversaciones_no_asignadas      = info.listado_conversaciones_no_asignadas || [];
                   listado_staff                            = info.listado_staff || [];
                   listado_mayor_tasa_conversion            = info.listado_mayor_tasa_conversion || [];
                   listado_mayor_tasa_conversion_html       = info.listado_mayor_tasa_conversion_html || [];
                   fecha_ultima_actualizacion               = Math.floor(Date.now() / 1000);

                   listado_conversaciones                   = info.listado_conversaciones || [];
                   listado_conversaciones_dias              = info.listado_conversaciones_dias || [];
                   listado_conversaciones_dias_fechas       = info.listado_conversaciones_dias_fechas || [];

                   fecha_desde                              = info.fecha_desde || "";
                   fecha_hasta                              = info.fecha_hasta || "";

                   if(isEmpty(fecha_desde) == true || isEmpty(fecha_hasta) == true)
                   {
                        const today = new Date();
                        const year = today.getFullYear(); // 2025
                        const month = today.getMonth(); // 5 (junio, los meses son 0-11)

                        // Fecha desde: Primer día del mes actual
                        const firstDay = new Date(year, month, 1);
                        const formattedFirstDay = firstDay.toISOString().split('T')[0]; // Formato YYYY-MM-DD
                       

                        // Fecha hasta: Último día del mes actual
                        const lastDay = new Date(year, month + 1, 0); // 0 da el último día del mes anterior
                        const formattedLastDay = lastDay.toISOString().split('T')[0]; // Formato YYYY-MM-DD

                        
                    

                        fecha_desde = formattedFirstDay;
                        fecha_hasta = formattedLastDay;
                   }
 
                   let estructura_storage = {
                       listado_etapas_conversaciones: listado_etapas_conversaciones,
                       listado_conversaciones_abiertas: listado_conversaciones_abiertas,
                       listado_conversaciones_no_asignadas: listado_conversaciones_no_asignadas,
                       listado_staff: listado_staff,
                       listado_mayor_tasa_conversion: listado_mayor_tasa_conversion,
                       listado_mayor_tasa_conversion_html: listado_mayor_tasa_conversion_html,
                       fecha_ultima_actualizacion: fecha_ultima_actualizacion,
                       listado_conversaciones: listado_conversaciones,
                       listado_conversaciones_dias: listado_conversaciones_dias,
                       listado_conversaciones_dias_fechas: listado_conversaciones_dias_fechas,

                       fecha_desde: fecha_desde,
                       fecha_hasta: fecha_hasta,
                    };

                    saveToLocalStorage(NOMBRE_ULTIMA_EJECUCION, estructura_storage);
 
                    pintarTodaInformacion();
 
                    $('#fecha_desde').val(fecha_desde);
                    $('#fecha_hasta').val(fecha_hasta);

 
                } else {
                   alert("Error sending group messages");
                }
             } catch (error) {
                
                alert("Error:" + error);
             }
          },
          error: function (xhr, status, error) {
             $(".update").prop("disabled", false);
             $(".tbody_envios").html("");
             console.error("Error en la solicitud:", error);
          },
       });
    }

    function ejecutarInformacionBackend(ejecutar=true)
    {
        let informacion_storage = getFromLocalStorage(NOMBRE_ULTIMA_EJECUCION);

         
    

        if(isEmpty(informacion_storage) == true)
        {
            cargar_update();   

            const today = new Date();
            const year = today.getFullYear(); // 2025
            const month = today.getMonth(); // 5 (junio, los meses son 0-11)

            // Fecha desde: Primer día del mes actual
            const firstDay = new Date(year, month, 1);
            const formattedFirstDay = firstDay.toISOString().split('T')[0]; // Formato YYYY-MM-DD
            $('#fecha_desde').val(formattedFirstDay);

            // Fecha hasta: Último día del mes actual
            const lastDay = new Date(year, month + 1, 0); // 0 da el último día del mes anterior
            const formattedLastDay = lastDay.toISOString().split('T')[0]; // Formato YYYY-MM-DD

            console.log("Fecha desde:", formattedFirstDay); // 2025-06-01
            console.log("Fecha hasta:", formattedLastDay); // 2025-06-30
            $('#fecha_hasta').val(formattedLastDay);

            fecha_desde = formattedFirstDay;
            fecha_hasta = formattedLastDay;
        }else{

            listado_etapas_conversaciones            = informacion_storage.listado_etapas_conversaciones || [];
            listado_conversaciones_abiertas          = informacion_storage.listado_conversaciones_abiertas || [];
            listado_conversaciones_no_asignadas      = informacion_storage.listado_conversaciones_no_asignadas || [];
            listado_staff                            = informacion_storage.listado_staff || [];
            listado_mayor_tasa_conversion            = informacion_storage.listado_mayor_tasa_conversion || [];
            listado_mayor_tasa_conversion_html       = informacion_storage.listado_mayor_tasa_conversion_html || "";
            fecha_ultima_actualizacion               = informacion_storage.fecha_ultima_actualizacion || "";

            listado_conversaciones                   = informacion_storage.listado_conversaciones || [];
            listado_conversaciones_dias              = informacion_storage.listado_conversaciones_dias || [];
            listado_conversaciones_dias_fechas       = informacion_storage.listado_conversaciones_dias_fechas || [];

            fecha_desde                              = informacion_storage.fecha_desde || [];
            fecha_hasta                              = informacion_storage.fecha_hasta || [];

            $('#fecha_desde').val(fecha_desde);
            $('#fecha_hasta').val(fecha_hasta);

 
            if(isEmpty(fecha_ultima_actualizacion) == true)
            {
                cargar_update();
            }

            //const timestamp = 1748465249; // han pasado mas de 25 minutos
            const timestamp = Number(fecha_ultima_actualizacion);
            const ahora = Math.floor(Date.now() / 1000);  
            const diferencia = ahora - timestamp;

            const minutosPasados = Math.floor(diferencia / 60);

            if (minutosPasados > 25) {  
                cargar_update();
            } else {
                //console.log("No han pasado 25 minutos. lleva: " + minutosPasados);
                
                if(ejecutar == true)
                {
                   pintarTodaInformacion();
                }
                 
            }
            

        }
    }

    function pintarTodaInformacion()
    {

        $(".mostras_placeholder_graficos").css("display", "none");
        $("#chart").css("display", "");

        $(".contenedor_etapas").html(DibujarEtapasConversaciones(listado_etapas_conversaciones));

        const $contenedor = $('.contenedor_etapas');
        const scrollAmount = 250;

        $('#scrollLeft').on('click', function() {
            $contenedor.animate({
                scrollLeft: $contenedor.scrollLeft() - scrollAmount
            }, 300, 'easeInOutQuad');
        });

        $('#scrollRight').on('click', function() {
            $contenedor.animate({
                scrollLeft: $contenedor.scrollLeft() + scrollAmount
            }, 300, 'easeInOutQuad');
        });

        function updateButtonVisibility() {
            const scrollLeft = $contenedor.scrollLeft();
            const maxScroll = $contenedor[0].scrollWidth - $contenedor[0].clientWidth;

            $('#scrollLeft').toggle(scrollLeft > 0);
            $('#scrollRight').toggle(scrollLeft < maxScroll - 1);
        }

        $contenedor.on('scroll', updateButtonVisibility);
        updateButtonVisibility();

        $(".contactos_listado").html(DibujarContactosAbiertos(listado_conversaciones_abiertas));

        $('.contactos_abiertas').removeClass('active');
        $('.contactos_no_asignadas').removeClass('active');
        
        $('.contactos_abiertas').addClass('active');

        click_contactos();

        $(".listado_staff_estado").html(DibujarStaffEstado(listado_staff));

        $(".tbody_envios").html(listado_mayor_tasa_conversion_html);

 
        const timestamp = Number(fecha_ultima_actualizacion) * 1000; // convertir a milisegundos
        const fecha = new Date(timestamp);

        // Opciones para formato largo con hora AM/PM
        const opciones = {
            day: '2-digit',
            month: 'long',
            year: 'numeric',
            hour: '2-digit',
            minute: '2-digit',
            hour12: true
        };

        // Formatear la fecha en inglés
        const formato = fecha.toLocaleString('en-US', opciones);
 
        $("#fecha_ultimo_update").html("Last update: " + formato.replace(',', ''));

        //listado_conversaciones                   = informacion_storage.listado_conversaciones || [];
        //listado_conversaciones_dias              = informacion_storage.listado_conversaciones_dias || [];

        if(Array.isArray(listado_conversaciones_dias)  == false)
        {
           listado_conversaciones_dias = [];
        }

        if(Array.isArray(listado_conversaciones)  == false)
        {
           listado_conversaciones = [];
        }

        //console.log("listado_conversaciones");
        //console.log(listado_conversaciones);

        //console.log("listado_conversaciones_dias");
        //console.log(listado_conversaciones_dias);

        let maximo = 0;

        let maximo_abierto = Math.max(...listado_conversaciones.map((data) =>  parseInt(data.total_conversaciones_abiertas, 10) ));
        let maximo_cerrado = Math.max(...listado_conversaciones.map((data) =>  parseInt(data.total_conversaciones_cerradas, 10) ));

        if(maximo_abierto > maximo_cerrado)
        {
            maximo = maximo_abierto + 1;
        }else{
            maximo = maximo_cerrado + 1;
        }


        //---------
        const chartData = {
            dates: listado_conversaciones_dias,
            abierto: listado_conversaciones.map((data) => parseInt(data.total_conversaciones_abiertas)), // Estimado
            cerrado: listado_conversaciones.map((data) => parseInt(data.total_conversaciones_cerradas))  // Estimado
        };

        //const chartData = {
        //    dates: ['6 Marzo', '7 Marzo', '8 Marzo', '9 Marzo', '10 Marzo', '11 Marzo'],
        //    abierto: [100, 50, 150, 100, 50, 150], // Estimado
        //    cerrado: [150, 50, 100, 150, 50, 100]  // Estimado
        //};

        const totalAbierto = chartData.abierto.reduce((sum, value) => sum + value, 0);
        const totalCerrado = chartData.cerrado.reduce((sum, value) => sum + value, 0);

        // Inicializar el gráfico ECharts
        const chartDom = document.getElementById('chart');
        const myChart = echarts.init(chartDom);
        const option = {
            title: {
                text: ''
            },
            tooltip: {
                trigger: 'axis',
                axisPointer: { type: 'shadow' }
            },
            legend: {
                data: ['Open', 'Close']
            },
            xAxis: {
                type: 'category',
                data: chartData.dates
            },
            yAxis: {
                type: 'value',
                max: maximo // Ajustado según el máximo aproximado de la imagen
            },
            series: [
                {
                    name: 'Open',
                    type: 'bar',
                    data: chartData.abierto,
                    itemStyle: {
                        color: '#1E90FF' // Azul
                    },
                    label: {
                        show: true,
                        position: 'top'
                    }
                },
                {
                    name: 'Close',
                    type: 'bar',
                    data: chartData.cerrado,
                    itemStyle: {
                        color: '#D3D3D3' // Gris claro
                    },
                    label: {
                        show: true,
                        position: 'top'
                    }
                }
            ],
            graphic: [
                {
                    type: 'text',
                    left: 'end',
                     style: {
                        text: `Open: ${totalAbierto} Close: ${totalCerrado}`,
                        textAlign: 'center',
                        fill: '#000',
                        fontSize: 14,
                        fontWeight: 600
                    },
                   
                }
            ]
        };

        myChart.setOption(option);


        //listado_conversaciones_dias_fechas

        pintarInformacionConversacionesVentas(listado_conversaciones_dias_fechas);

        
        $('#fecha_desde').val(fecha_desde);
        $('#fecha_hasta').val(fecha_hasta);


    }
 
    function ejecutarAsisteciaSocket()
    {
        const data = {
            staff_id: 17,
            fecha_login: formatDateJS(),
            db: BASE_DE_DATOS_GLOBAL,
        };

        socket.emit("estado-online-staff", data);
    }

    function formatDateJS() 
    {
        const now = new Date();
        
        const months = [
            "January", "February", "March", "April", "May", "June",
            "July", "August", "September", "October", "November", "December"
        ];
        
        const month = months[now.getMonth()];
        const day = now.getDate();
        const year = now.getFullYear();
        
        let hours = now.getHours();
        const minutes = now.getMinutes().toString().padStart(2, "0");
        
        return `${month} ${day}, ${year}, ${hours}:${minutes}`;
    }

    function resetAsistenciaStaffSocket()
    {
        deleteLocalStorage(NOMBRE_LISTADO_ASISTENCIAS_LOCALSTORAGE);

         
    }

    function deleteLocalStorage(key) {
        try {
            localStorage.setItem(key, JSON.stringify([]));
        } catch (error) {
            console.error("Error al eliminar en localStorage:", error);
        }
    }

    function saveToLocalStorage(key, data) {
        try {
            localStorage.setItem(key, JSON.stringify(data));
            //console.log(`Datos guardados en localStorage con clave ${key}:`, data);
        } catch (error) {
            console.error("Error al guardar en localStorage:", error);
        }
    }

    // Función para leer datos de localStorage
    function getFromLocalStorage(key) {
        try {
            const data = localStorage.getItem(key);
            return data ? JSON.parse(data) : null;
        } catch (error) {
            console.error("Error al leer de localStorage:", error);
            return null;
        }
    }

    function click_contactos()
    {
        $('.contactos_abiertas').on('click', function() {

            //console.log("click contactos_abiertas");
             
            $('.contactos_abiertas').addClass('active');
            $('.contactos_no_asignadas').removeClass('active');

            $(".contactos_listado").html(DibujarContactosAbiertos(listado_conversaciones_abiertas));
                    
           
        });

        $('.contactos_no_asignadas').on('click', function() {

            //console.log("click contactos_no_asignadas");
             
            $('.contactos_abiertas').removeClass('active');
            $('.contactos_no_asignadas').addClass('active');

            $(".contactos_listado").html(DibujarContactosNoAsignados(listado_conversaciones_no_asignadas));
          
        });
    }
 
    function cargar_fecha() {
        const today = new Date();

        // Formatear la fecha como YYYY-MM-DD
        const year = today.getFullYear();
        const month = String(today.getMonth() + 1).padStart(2, "0"); // Mes de 2 dígitos
        const day = String(today.getDate()).padStart(2, "0"); // Día de 2 dígitos

        const formattedDate = year + "-" + month + "-" + day;
        return formattedDate;
    }

    function isEmpty(value) {
        // Verificar si es null o undefined
        if (value == null) return true;

        // Verificar si es una cadena vacía
        if (typeof value === "string" && value.trim() === "") return true;

        // Verificar si es un array vacío
        if (Array.isArray(value) && value.length === 0) return true;

        // Verificar si es un objeto vacío
        if (typeof value === "object" && Object.keys(value).length === 0) return true;

        return false;
    }

    function DibujarEtapasConversaciones(listadoEtapasConversaciones = [])
    {
        let concatenatedHtml = '';

        for (let i = 0; i < listadoEtapasConversaciones.length; i++) {
            const item = listadoEtapasConversaciones[i];
            concatenatedHtml += `
                <div class="col-12 col-sm-3" style="padding: 0px">
                    <div class="card mb-3" style="margin: 13px; box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;">
                        <div class="card-body position-relative" style="padding: 15px;">
                            <div class="row">
                                <div class="col-lg-12">
                                    <span class="badge" style="background-color: ${item.color_fondo_etapa_conversacion}; color: ${item.color_texto_etapa_conversacion}; font-size: 13px; box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; white-space: normal; font-weight: 600;">
                                        ${item.nombre_etapa}
                                    </span>
                                    <br/>
                                    <h3 class="mt-2" style="font-size: 24px; margin: 0px; color: black;">${item.total_conversaciones}</h3>
                                    <div class="row">
                                        <div class="col-12" style="display: flex; justify-content: end; gap: 12px;">
                                            <i class="fa-solid fa-sticky-note tamano_icono" title="${item.conversaciones_abiertas}"  data-bs-toggle="tooltip"></i>
                                            <i class="fa-solid fa-user tamano_icono" title="${item.conversaciones_sin_asignar}"  data-bs-toggle="tooltip"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        }

        return concatenatedHtml;

    }

    function DibujarEtapasConversacionesEsqueleton()
    {

        let listadoEtapasConversaciones = [
            {
                nombre_etapa: 'New Lead',
                color_fondo_etapa_conversacion: '#ffcc00',
                color_texto_etapa_conversacion: '#000000',
                total_conversaciones: 5,
                conversaciones_abiertas: 3,
                conversaciones_sin_asignar: 2
            },
            {
                nombre_etapa: 'Hot Lead',
                color_fondo_etapa_conversacion: '#ff0000',
                color_texto_etapa_conversacion: '#ffffff',
                total_conversaciones: 8,
                conversaciones_abiertas: 4,
                conversaciones_sin_asignar: 1
            },
            {
                nombre_etapa: 'Hot Lead',
                color_fondo_etapa_conversacion: '#ff0000',
                color_texto_etapa_conversacion: '#ffffff',
                total_conversaciones: 8,
                conversaciones_abiertas: 4,
                conversaciones_sin_asignar: 1
            },

            {
                nombre_etapa: 'Hot Lead',
                color_fondo_etapa_conversacion: '#ff0000',
                color_texto_etapa_conversacion: '#ffffff',
                total_conversaciones: 8,
                conversaciones_abiertas: 4,
                conversaciones_sin_asignar: 1
            }
        ];


        let concatenatedHtml = '';

        for (let i = 0; i < listadoEtapasConversaciones.length; i++) {
            const item = listadoEtapasConversaciones[i];
            concatenatedHtml += `
                <div class="col-12 col-sm-3" style="padding: 0px">
                    <div class="card mb-3" style="margin: 13px; box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;">
                        <div class="card-body position-relative" style="padding: 15px;">
                            <div class="row">
                                <div class="col-lg-12">
                                    <span class="badge mi-placeholder" style="user-select: none; color: transparent; font-size: 13px; box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; white-space: normal; font-weight: 600; width: 100%;">
                                        ${item.nombre_etapa}
                                    </span>
                                    <br/>
                                    <h3 class="mt-2 mi-placeholder" style="font-size: 24px;margin: 0px;color: transparent;border-radius: 9px;box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;width: 50px;">${item.total_conversaciones}</h3>
                                    <div class="row">
                                        <div class="col-12" style="display: flex; justify-content: end; gap: 12px;">
                                            <i class=" tamano_icono mi-placeholder" style=" width: 20px; height: 20px; border-radius: 4px; "></i>

                                            <i class=" tamano_icono mi-placeholder" style=" width: 20px; height: 20px; border-radius: 4px; " ></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        }

        return concatenatedHtml;

    }
 
    function DibujarContactosAbiertos(listadoConversacionesAbiertas = [])
    {
        let concatenatedHtml = '';

        let path_img_default  = $("#PATH_IMG_DEFAULT").val();

        for (let i = 0; i < listadoConversacionesAbiertas.length; i++) {
            const item = listadoConversacionesAbiertas[i];

            let tiene_fecha = ''

            if(isEmpty(item.fecha_humana) == false )
            {
                tiene_fecha = `
                    <div class="fecha-contacto-container">
                        <p class="quitar_margen fecha_contacto">${item.fecha_humana || ''}</p>
                        <i class="fa-solid fa-clock action-icon" style="color: #000000c2"></i>
                    </div>
                `;
            }

            let tiene_nombre_staff = "";

            if(isEmpty(item.tiene_nombre_staff) == false )
            {
                tiene_nombre_staff = `
                     <div class="avatar-container">
                                <img src="${item.ruta_img_staff}" class="img-avatar" onerror="this.src='${path_img_default}'"/>
                            </div>
                            <div class="text-container">
                                <span class="conversation-text">${item.nombre_staff || ''}</span>
                            </div>
                `;
            }



            concatenatedHtml += `
                
                <div class="aplicar_hover_contactos row blur-in-expand"  style="margin: 0;border-radius: 4px;padding: 5px  ">

                    <div class="col-12 col-sm-6">
                        <h3 class="quitar_margen" style="color: #000000c2;">${item.nombre_asignado}</h3>
                        <p class="quitar_margen" style="font-style: italic;">${item.ultimo_mensaje || ''}</p>
                    </div>

                    <div class="col-12 col-sm-6 ">

                        ${tiene_fecha} 

                        <div class="conversation-item">
                            ${tiene_nombre_staff} 
                        </div>
                    </div>                
                
                </div>

            `;
            if (i < listadoConversacionesAbiertas.length - 1) {
                concatenatedHtml += `<hr style="margin-top: 10px;"/>`;
            }
        }

        return concatenatedHtml;

    }

    function DibujarContactosAbiertosEsqueleton()
    {
        let concatenatedHtml = '';

        const listadoConversacionesAbiertas = [
            {
                nombre_asignado: "John Doe",
                ultimo_mensaje: "Hello!",
                fecha_humana: "05/27/2025",
                ruta_img_staff: "/img/staff1.png",
                nombre_staff: "Staff 1"
            },
            {
                nombre_asignado: "Jane Smith",
                ultimo_mensaje: "Hi there!",
                fecha_humana: "05/28/2025",
                ruta_img_staff: "/img/staff2.png",
                nombre_staff: "Staff 2"
            },
            {
                nombre_asignado: "Jane Smith",
                ultimo_mensaje: "Hi there!",
                fecha_humana: "05/28/2025",
                ruta_img_staff: "/img/staff2.png",
                nombre_staff: "Staff 2"
            },
            {
                nombre_asignado: "Jane Smith",
                ultimo_mensaje: "Hi there!",
                fecha_humana: "05/28/2025",
                ruta_img_staff: "/img/staff2.png",
                nombre_staff: "Staff 2"
            },
            {
                nombre_asignado: "Jane Smith",
                ultimo_mensaje: "Hi there!",
                fecha_humana: "05/28/2025",
                ruta_img_staff: "/img/staff2.png",
                nombre_staff: "Staff 2"
            }
        ];

        let path_img_default  = $("#PATH_IMG_DEFAULT").val();


        for (let i = 0; i < listadoConversacionesAbiertas.length; i++) {
            const item = listadoConversacionesAbiertas[i];
            concatenatedHtml += `
                
                <div class="aplicar_hover_contactos row"  style="margin: 0;border-radius: 4px;padding: 5px;">
                
                    <div class="col-12 col-sm-6  ">
                        <h3 class="quitar_margen  mi-placeholder" style="color: transparent;margin-bottom: 3px;border-radius: 4px; user-select: none; box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; ">${item.nombre_asignado}</h3>
                        <p class="quitar_margen  mi-placeholder" style="color: transparent; border-radius: 4px; width:50%; user-select: none; ">${item.ultimo_mensaje}</p>
                    </div>

                    <div class="col-12 col-sm-6  ">
                        <div class="fecha-contacto-container">
                            <p class="quitar_margen fecha_contacto  mi-placeholder" style=" color: transparent !important; border-radius: 4px !important; user-select: none;  box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;">${item.fecha_humana}</p>
                            <i class="action-icon  mi-placeholder" style=" width: 40px; height: 20px; border-radius: 4px;  box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; "></i>
                        </div>

                        <div class="conversation-item">
                            <div class="avatar-container">
                                <div class="img-avatar mi-placeholder" style="box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; margin-top: 5px;" > </div>
                            </div>
                            <div class="text-container">
                                <span class="conversation-text  mi-placeholder" style=" user-select: auto; color: transparent; border-radius: 4px; height: 19px; box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; ">${item.nombre_staff}</span>
                            </div>
                        </div>
                    </div>

                </div>

                 
            `;
            if (i < listadoConversacionesAbiertas.length - 1) {
                concatenatedHtml += `<hr style="margin-top: 10px;"/>`;
            }
        }


        return concatenatedHtml;

    }

    function DibujarContactosNoAsignados(listadoConversacionesAbiertas = [])
    {
        let concatenatedHtml = '';

        let path_img_default  = $("#PATH_IMG_DEFAULT").val();

        for (let i = 0; i < listadoConversacionesAbiertas.length; i++) {
            const item = listadoConversacionesAbiertas[i];
 
            let tiene_fecha = ''

            if(isEmpty(item.fecha_humana) == false )
            {
                tiene_fecha = `
                    <div class="fecha-contacto-container">
                        <p class="quitar_margen fecha_contacto">${item.fecha_humana || ''}</p>
                        <i class="fa-solid fa-clock action-icon" style="color: #000000c2"></i>
                    </div>
                `;
            }

            concatenatedHtml += `
                
                <div class="aplicar_hover_contactos row blur-in-expand"  style="margin: 0;border-radius: 4px;padding: 5px  ">

                    <div class="col-12 col-sm-6">
                        <h3 class="quitar_margen" style="color: #000000c2;">${item.nombre_asignado}</h3>
                        <p class="quitar_margen" style="font-style: italic;">${item.ultimo_mensaje || ''}</p>
                    </div>

                    <div class="col-12 col-sm-6 ">

                        ${tiene_fecha} 

                    </div>                
                
                </div>

            `;
            if (i < listadoConversacionesAbiertas.length - 1) {
                concatenatedHtml += `<hr style="margin-top: 10px;"/>`;
            }
        }

        return concatenatedHtml;

    }

    function DibujarStaffEstado(listadoStaff = [])
    {
        
        let path_img_default  = $("#PATH_IMG_DEFAULT").val();

        let htmlStaff = '';

        listadoStaff.forEach((item, index) => {

            htmlStaff += `
                <div class="row quitar_margen aplicar_hover_contactos blur-in-expand ocultar_div_genetal_staff_${item.id_staff}" style="margin: 10px;border-radius: 4px;padding: 4px;">
                    <div class="col-12 col-sm-6">
                        <div class="conversation-item-staff">
                            <div class="avatar-container-staff">
                                <img src="${item.ruta_img_staff}" class="img-avatar" onerror="this.src='${path_img_default}'"/>
                                <div class="online-status-staff estado_staff_${item.id_staff} estado_staff_general" data-estado="offline" style="background-color: red; "></div> 
                            </div>
                            <div class="text-container">
                                <span class="conversation-text" style="font-weight: 600;">${item.nombre_staff || ''}</span>
                            </div>
                        </div>
                        <p style=" font-size: 10px; margin-top: 4px; " class="quitar_margen">Assigned to ${item.contactos_asignados || '0'} Contacts</p>
                    </div>

                    <div class="col-12 col-sm-6">
                        <h3 class="quitar_margen fecha_contacto fecha_ultimo_login_staff_${item.id_staff}" style="color: #001B3B;">${item.fecha_ultimo_login || ''}</h3>
                    </div>

                    ${index !== listadoStaff.length - 1 ? `<hr style="margin-top: 10px;margin-bottom: 0px;"/>` : ''}
                </div>
            `;

        });

        return htmlStaff;
    }

    function DibujarStaffEstadoEsqueleton()
    {

       let listadoStaff = [

            {
              "nombre_staff": "mel",
              "ruta_img_staff": "http://localhost:50001/app_dev_parnerts/",
              "img_staff": "",
              "id_staff": "22",
              "fecha_ultimo_login": null,
              "contactos_asignados": "0"
            },

            {
              "nombre_staff": "mel",
              "ruta_img_staff": "http://localhost:50001/app_dev_parnerts/",
              "img_staff": "",
              "id_staff": "22",
              "fecha_ultimo_login": null,
              "contactos_asignados": "0"
            },

            {
              "nombre_staff": "mel",
              "ruta_img_staff": "http://localhost:50001/app_dev_parnerts/",
              "img_staff": "",
              "id_staff": "22",
              "fecha_ultimo_login": null,
              "contactos_asignados": "0"
            },

            {
              "nombre_staff": "mel",
              "ruta_img_staff": "http://localhost:50001/app_dev_parnerts/",
              "img_staff": "",
              "id_staff": "22",
              "fecha_ultimo_login": null,
              "contactos_asignados": "0"
            },

            {
              "nombre_staff": "mel",
              "ruta_img_staff": "http://localhost:50001/app_dev_parnerts/",
              "img_staff": "",
              "id_staff": "22",
              "fecha_ultimo_login": null,
              "contactos_asignados": "0"
            },

        ];
        
        let path_img_default  = $("#PATH_IMG_DEFAULT").val();

        let htmlStaff = '';

        listadoStaff.forEach((item, index) => {

            htmlStaff += `
                <div class="row quitar_margen aplicar_hover_contactos blur-in-expand" style="margin: 10px;border-radius: 4px;padding: 4px;">
                    <div class="col-12 col-sm-6">
                        <div class="conversation-item-staff">
                            <div class="avatar-container-staff">
                                <div style="width: 40px; height: 40px; border-radius: 50%" class="mi-placeholder" > </div>
                            </div>
                            <div class="text-container">
                                <span class=" mi-placeholder" style=" min-width: 150px; user-select: none; color: transparent; border-radius: 4px; box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; ">${item.nombre_staff || ''}</span>
                            </div>
                        </div>
                        <p style="font-size: 12px;margin-top: 4px;box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;user-select: none;color: transparent; border-radius:4px" class="quitar_margen  mi-placeholder">Assigned to ${item.contactos_asignados || '0'} Contacts</p>
                    </div>

                    <div class="col-12 col-sm-6">
                        <h3 class="quitar_margen fecha_contacto mi-placeholder" style="color: #001B3B;width: 100%;height: 20px;border-radius: 4px;user-select: none;box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;">${item.fecha_ultimo_login || ''}</h3>
                    </div>

                    ${index !== listadoStaff.length - 1 ? `<hr style="margin-top: 10px;margin-bottom: 0px;"/>` : ''}
                </div>
            `;

        });

        return htmlStaff;
    }

    function DibujarTablaMayorTasaConversionPlaceHolder()
    {
        let tbody = '';

        const listado_mayor_tasa_conversion = [
            {
                "agente_id": "17",
                "agente": "cesar pineda",
                "conversaciones_abiertas": "2",
                "ventas_cerradas": "3",
                "ventas_descartadas": "0",
                "tasa_exito_general": "60%",
                "producto_mas_vendido": "producto mantenimiento computadoras",
                "promedio_dia_cierre": "1.4224"
            },
            {
                "agente_id": "19",
                "agente": "Juana velazquez",
                "conversaciones_abiertas": "0",
                "ventas_cerradas": "0",
                "ventas_descartadas": "1",
                "tasa_exito_general": "0%",
                "producto_mas_vendido": "producto mantenimiento computadoras",
                "promedio_dia_cierre": "0.0000"
            },
            {
                "agente_id": "19",
                "agente": "Juana velazquez",
                "conversaciones_abiertas": "0",
                "ventas_cerradas": "0",
                "ventas_descartadas": "1",
                "tasa_exito_general": "0%",
                "producto_mas_vendido": "producto mantenimiento computadoras",
                "promedio_dia_cierre": "0.0000"
            },
            {
                "agente_id": "19",
                "agente": "Juana velazquez",
                "conversaciones_abiertas": "0",
                "ventas_cerradas": "0",
                "ventas_descartadas": "1",
                "tasa_exito_general": "0%",
                "producto_mas_vendido": "producto mantenimiento computadoras",
                "promedio_dia_cierre": "0.0000"
            },
            {
                "agente_id": "19",
                "agente": "Juana velazquez",
                "conversaciones_abiertas": "0",
                "ventas_cerradas": "0",
                "ventas_descartadas": "1",
                "tasa_exito_general": "0%",
                "producto_mas_vendido": "producto mantenimiento computadoras",
                "promedio_dia_cierre": "0.0000"
            }
        ];
    
        listado_mayor_tasa_conversion.forEach(row => {
             
            const agente_id = row.agente_id ?? '';
            const agente = row.agente ?? '';
            const conversaciones_abiertas = row.conversaciones_abiertas ?? '';
            const ventas_cerradas = row.ventas_cerradas ?? '';
            const ventas_descartadas = row.ventas_descartadas ?? '';
            const tasa_exito_general = row.tasa_exito_general ?? '';
            const producto_mas_vendido = row.producto_mas_vendido ?? '';
            const promedio_dia_cierre = row.promedio_dia_cierre ?? '';
            
            const ultima_conexion = row.ultima_conexion ?? '';
            const contactos_asignados = row.contactos_asignados ?? '';
            const estado = row.estado ?? '';

            tbody += '<tr>' +
                `<td class="centrar "> <div class="mi-placeholder clase_placeholder">${agente}</div> </td>` +
                `<td class="centrar "> <div class="mi-placeholder clase_placeholder">${conversaciones_abiertas}</div></td>` +
                `<td class="centrar "> <div class="mi-placeholder clase_placeholder">${ventas_cerradas}</div> </td>` +
                `<td class="centrar "> <div class="mi-placeholder clase_placeholder">${ventas_descartadas}</div> </td>` +
                `<td class="centrar "> <div class="mi-placeholder clase_placeholder">${tasa_exito_general}</div> </td>` +
                `<td class="centrar "> <div class="mi-placeholder clase_placeholder">${producto_mas_vendido}</div> </td>` +
                `<td class="centrar "> <div class="mi-placeholder clase_placeholder">${promedio_dia_cierre}</div> </td>` +
                '</tr>';
        });

        return tbody;
    }


</script>
{/literal}

{/block}