{extends file="layouts/base.tpl"}
{block name="head_extras_from_layout"}

<script>
    var clx_admin_layout = 1;
 

</script>
 

<style>

 .image-container-perfil-header {
        position: relative;
        display: inline-block;
    }

    .img-avatar-small-header {
        position: absolute;
        bottom: 34px;
        right: -8px;
        width: 20px;
        height: 20px;
        border-radius: 50%;
        border: 1px solid #000000;
    }
    .img-avatar-header {
     /* border-radius: 50%; */ 
     width: 1.7rem; 
     height: auto;
    }
</style>


{if !empty($config['admin_dark_theme'])}
<style>
    html body {
        background-color: #1E1E2C;
        color: #fff;
    }
    html body a {
        color: #3699ff;
    }
    .page-header {
        background-color: #1E1E2C;
    }

    .page-content {
        background-color: #151520;
    }
    .panel, .card {
        background-color: #1E1E2C;
    }
    .panel-hdr {
        background: #1E1E2C;
    }
    .panel-hdr h2 {
        color: #fff;
    }
    .table-bordered td, .table-bordered th {
        border: 1px solid #323248;
    }
    .table-striped tbody tr:nth-of-type(odd) {
        background-color: #2B2C3F;
    }
    .text-dark {
        color: #fff!important;
    }
    .text-muted, .text-muted-green {
        color: #dedee0!important;
    }
    .panel {
        border: 0;
    }

    .table thead th {
        border-bottom: 2px solid #323248;
    }

    .h1, .h2, .h3, .h4, .h5, .h6, h1, h2, h3, h4, h5, h6 {
        color: #fff;
    }
    .table {
        color: #fff;
    }

    .btn-default {
        background-color: #565773;
        background-image: none;
        color: #fff;
    }
    .fc-head-container thead tr {
        background-image: none;
    }
    .fc-other-month {
        background-image: none;
        background-color: #15151F;
        background-size: 1rem 1rem;
    }
    .progress {
        background-color: #323347;
    }
    .alert-info {
        color: #fff;
        background-color: #2f264f;
        border-color: transparent;
    }

    .badge.badge-outline-danger {
        color: #f64e60;
        background-color: #3a2434;
    }

    .page-content {
        color: #fff;
    }

    .symbol .symbol-label {
        background-color: #565772;
    }

    .clx-avatar {
        background: #372533;
        color: #E45B64;
    }

    .form-control {
        background-color: #1b1b29;
        border-color: #1b1b29;
        color: #92929f;
    }

    .select2-container--default .select2-selection--single {
        background-color: #1b1b29;
        border: 1px solid #1b1b29;
        border-radius: 4px;
    }
    .select2-container--default .select2-selection--single .select2-selection__rendered {
        color: #fff;
    }

    .form-control:focus {
        background-color: #171723;
        border-color: #171723;
        color: #92929f;
    }

    .custom-control-label::before {
        background-color: #2B2C3F;
        border: #3c3d5a solid 2px;
    }

    .settings-panel .list:hover {
        color: #6d6d80;
        background: #323347;
    }

    .table td, .table th {
        padding: .75rem;
        vertical-align: top;
        border-top: 1px solid #6d6d80;
    }



    .table-hover tbody tr:hover {
        color: #fff;
        background: #323347;
    }

    .table-striped tbody tr:nth-of-type(odd) {
        color: #6d6d80;
        background-color: #323347;
    }

    .settings-panel h5 {
        color: #fff;
    }

    .alert-danger {
        border-color: rgba(255,168,0,.5);
        color: #fff;
        background-color: #392f28;
    }

    .page-link {
        color: #fff;
        background-color: #3699ff;
        border-color: transparent;
    }
    .pagination .page-item:first-child:not(.active) .page-link, .pagination .page-item:last-child:not(.active) .page-link, .pagination .page-item.disabled .page-link {
        background: #232F47;
    }

    .input-group-text {

        background-color: #1b1b29;
        border: 1px solid #1b1b29;
    }

    .select2-dropdown {
        background-color: #171723;
        border-color: #171723;
    }

    .select2-results__message {
        color: #92929f !important;
    }

    .select2-container--default .select2-selection--multiple {
        background-color: #171723;
        border-color: #171723;
        color: #fff;
    }
    .select2-search--dropdown:before {
        color: #fff;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        background-color: #171723;
        border-color: #171723;
        color: #fff;
    }

    .table-bordered {
        border: none;
    }

    .table thead th {
        background-color: #1E1E2B;
    }

    .list-group-item {
        background-color: #1E1E2B;
    }

    .nav-tabs .nav-item.show .nav-link, .nav-tabs .nav-link.active {
        background-color: #1E1E2B;

    }

    .nav-tabs-clean .nav-item .nav-link.active {
        border-bottom: 1px solid #3699ff;
        color: #3699ff;
    }

    .nav-tabs .nav-item .nav-link.active:not(:hover) {
        color: #3699ff;
    }

    .form-control:disabled, .form-control[readonly] {
        background-color: #1b1b29;
        border-color: #1b1b29;
        color: #92929f;
    }

    .redactor-box, .redactor-editor {
        background-color: #1b1b29;
    }
    .redactor-toolbar {
        background: #323347;
    }
    .redactor-toolbar li a {
        color: #fff;
    }
    .redactor-editor {
        border: 1px solid #2b2b40;
    }


    .dashboard-stat2 {

        background-color: #1b1b29;

    }

    .alert-success {
        color: #ffffff;
        background-color: #063a31;
        border-color: #a3ebe4;
    }

    code {
        background: #1c1c29;
    }
    .badge.badge-outline-success {
        color: #ffffff;
        background-color: #047051;
    }

    .table-striped>tbody>tr:nth-of-type(odd)>* {
        color: #ffffff!important;
    }

    .thead-light th {
        background-color: #5d6675;
    }

    .swal2-popup {
        background: #000;
    }

    .swal2-title {
        color: #ffffff;
    }

    .form-control {
        background-color: #3d3d4c;
        color: #bebec1;
    }

    .form-control:focus {
        background-color: #5c5c64;
        color: #bebec1;
    }


    .text-black {
        color: #fff!important;
    }

    .bg-white {
        background-color: #000000 !important;
    }

    .subheader-title {
        color: #ffffff;
        text-shadow: #000 0 1px;
    }

    .dropdown-item {
        color: #ffffff;
    }

    .table-hover > tbody > tr:hover > * {
        --bs-table-accent-bg: black;
        color: #ffffff;
    }

    .dropzone {
        background: #000000;
    }

    .form-select {
        color: #bebec1;
        background-color: #3d3d4c;
        border: none;
    }

    .select2-container--default.select2-container--disabled .select2-selection--single {
        background-color: #3d3d4c;
    }

    .datepicker-content li {
        background-color: #3d3d4c;
    }

    .datepicker-week li, .datepicker-week li:hover {
        background-color: #15151f;
    }

    .card-header {
        background-color: #3d3d4c;
    }

    .daterangepicker{
        background-color: #3d3d4c;
    }

    .daterangepicker .ranges li:hover {
        background-color: #151E29;
    }

    .daterangepicker .calendar-table{
        background-color: #3d3d4c;
    }

    .daterangepicker td.off, .daterangepicker td.off.in-range, .daterangepicker td.off.start-date, .daterangepicker td.off.end-date {
        background-color: #3d3d4c;
    }

    .dropdown-menu {
        background: #1e1f2c;
    }

    .dropdown-item:hover, .dropdown-item:focus {
        color: #fff;
        background-color: #2E2E3C;
    }

    
    .image-container-perfil-header {
        position: relative;
        display: inline-block;
    }

    .img-avatar-small-header {
        position: absolute;
        bottom: 34px;
        right: -8px;
        width: 20px;
        height: 20px;
        border-radius: 50%;
        border: 1px solid #000000;
    }

    .img-avatar-header {
    /* border-radius: 50%; */
    width: 1.7rem;
    height: auto;
}


</style>
{/if}


{/block}

{block name="content_body"}

    <aside class="page-sidebar">

        <input type="text" disabled hidden id="user_id1" value="{$user->id}">
        <input type="text" disabled hidden id="ws_nombre_socket" value="{$ws_nombre_socket}">
      
        {if !empty($config['header_show_logo_as'])  && $config['header_show_logo_as'] == 'default_logo' && !empty($config['logo_default'])}

            <div class="page-logo">
                <a href="{$_url}dashboard" class="logo-default">
                    <img style="max-height: 35px; width: auto; height: auto;" src="{{APP_URL}}/storage/system/{{$config['logo_default']}}" alt="{{$config['CompanyName']}}" aria-roledescription="logo">
            
                
                </a>
            </div>

        {else}

        <div class="page-logo">
            <a href="{$_url}dashboard" class="page-logo-link d-flex align-items-center position-relative">
                {if isset($config['logo_square'])}
                <img src="{{APP_URL}}/storage/system/{{$config['logo_square']}}" alt="{{$config['CompanyName']}}" aria-roledescription="logo">
                {elseif isset($config['default_logo'])}

                {else}
                <img src="{{APP_URL}}/storage/system/logo-512x512.png?v=2" alt="{{$config['CompanyName']}}" aria-roledescription="logo">
                {/if}

                {if isset($config['logo_square'])}
                <span class="page-logo-text text-info-alt mr-1 fw-bolder">{$config['logo_text']}</span>
                {else}
                <span class="page-logo-text text-info-alt fw-bolder mr-1">CloudOnex</span>
                {/if}
            </a>
        </div>

        {/if}

        <nav id="clx-primary-navigation" class="primary-nav" role="navigation">

            <ul id="clx-navigation-menu" class="nav-menu">
    
                {*
                {if has_access($user->roleid,'reports')}
                    <li {if $selected_navigation eq 'dashboard'}class="active"{/if}><a href="{$_url}{$config['redirect_url']}">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <rect x="0" y="0" width="24" height="24"></rect>
                                <rect fill="#000000" opacity="0.3" x="13" y="4" width="3" height="16" rx="1.5"></rect>
                                <rect fill="#000000" x="8" y="9" width="3" height="11" rx="1.5"></rect>
                                <rect fill="#000000" x="18" y="11" width="3" height="9" rx="1.5"></rect>
                                <rect fill="#000000" x="3" y="13" width="3" height="7" rx="1.5"></rect>
                            </g>
                        </svg>
                        <span class="nav-link-text">{$_L['Dashboard']}</span></a>
                    </li>
                {/if}
                *}

                {*
                {if has_access($user->roleid,'customers')}

                    <li class="{if $selected_navigation eq 'contacts'}active  open{/if}">
                        <a href="#">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                    <polygon points="0 0 24 0 24 24 0 24"/>
                                    <path d="M12,11 C9.790861,11 8,9.209139 8,7 C8,4.790861 9.790861,3 12,3 C14.209139,3 16,4.790861 16,7 C16,9.209139 14.209139,11 12,11 Z" fill="#000000" fill-rule="nonzero" opacity="0.3"/>
                                    <path d="M3.00065168,20.1992055 C3.38825852,15.4265159 7.26191235,13 11.9833413,13 C16.7712164,13 20.7048837,15.2931929 20.9979143,20.2 C21.0095879,20.3954741 20.9979143,21 20.2466999,21 C16.541124,21 11.0347247,21 3.72750223,21 C3.47671215,21 2.97953825,20.45918 3.00065168,20.1992055 Z" fill="#000000" fill-rule="nonzero"/>
                                </g>
                            </svg>
                            <span class="nav-link-text">{$_L['Customers']}</span>
                        </a>
                        <ul>
                            {if has_access($user->roleid,'customers','create')}
                            <li>
                                <a href="{$_url}contacts/add">
                                    <span class="nav-link-text">{$_L['Add Customer']}</span>
                                </a>
                            </li>
                            {/if}

                            <li>
                                <a href="{$_url}contacts/list">
                                    <span class="nav-link-text">{$_L['List Customers']}</span>
                                </a>
                            </li>

                            {if has_access($user->roleid,'companies','view') && ($config['companies'])}
                            <li>
                                <a href="{$_url}contacts/companies">
                                    <span class="nav-link-text">{$_L['Companies']}</span>
                                </a>
                            </li>
                            {/if}
                            <li>
                                <a href="{$_url}contacts/groups">
                                    <span class="nav-link-text">{$_L['Groups']}</span>
                                </a>
                            </li><li>
                                <a href="{$_url}contacts/drive">
                                    <span class="nav-link-text">{$_L['Files']}</span>
                                </a>
                            </li>

                        </ul>
                    </li>
    
                {/if}
                *}

                {foreach $menu_categorias_user as $item_categorias}

                    <li  {if $selected_navigation eq $item_categorias['key']}class="active open"{/if} >
                        <a href="{if empty($item_categorias['url']) || $item_categorias['url'] == '' || $item_categorias['url']|strstr:'#'}{$item_categorias['url']}{else}{$_url}{$item_categorias['url']}{/if}">
                            {$item_categorias["icono"]} 
                            <span class="nav-link-text">{$item_categorias["nombre"]}</span>
                        </a>
                        
                        {if count($item_categorias["subpermisos"]) != 0}
                            <ul>
                                {foreach $item_categorias["subpermisos"] as $item_subcategorias}
                                    <li>
                                        <a href="{$_url}{$item_subcategorias['url']}">
                                            <span class="nav-link-text">{$item_subcategorias["nombre"]}</span>
                                        </a>
                                    </li>
                                {/foreach}
                            </ul>
                        {/if}
                    </li>

                {/foreach}
    
                <li>
                    <a href="{$url_setting_CRM_Parnerts_prepared}" target="_blank">
                         <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                             <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                 <rect x="0" y="0" width="24" height="24"/>
                                 <path d="M5,8.6862915 L5,5 L8.6862915,5 L11.5857864,2.10050506 L14.4852814,5 L19,5 L19,9.51471863 L21.4852814,12 L19,14.4852814 L19,19 L14.4852814,19 L11.5857864,21.8994949 L8.6862915,19 L5,19 L5,15.3137085 L1.6862915,12 L5,8.6862915 Z M12,15 C13.6568542,15 15,13.6568542 15,12 C15,10.3431458 13.6568542,9 12,9 C10.3431458,9 9,10.3431458 9,12 C9,13.6568542 10.3431458,15 12,15 Z" fill="#000000"/>
                             </g>
                         </svg>
                         <span class="nav-link-text">{$_L['Settings']} </span>
                    </a>
                </li>
    
    

    
                                                    
                                                        

                                                            
    

                                                                                
    
    


            </ul>
        </nav>

    </aside>

    {*Esto no es parte del menu*}
    <div class="page-content-wrapper">
        <header class="page-header" role="banner">
            <div class="page-logo">
                <a href="{$_url}dashboard" class="page-logo-link press-scale-down d-flex align-items-center position-relative">
                    {if isset($config['logo_square'])}
                    <img src="{{APP_URL}}/storage/system/{{$config['logo_square']}}" alt="{{$config['CompanyName']}}" aria-roledescription="logo">
                    {else}
                    <img src="{{APP_URL}}/storage/system/logo-512x512.png?v=2" alt="{{$config['CompanyName']}}" aria-roledescription="logo">
                    {/if}

                    {if isset($config['logo_text'])}
                    <span class="page-logo-text mr-1">{{$config['logo_text']}}</span>
                    {else}
                    <span class="page-logo-text mr-1">CloudOnex</span>
                    {/if}


                    <span class="position-absolute text-white opacity-50 small pos-top pos-right me-2 mt-n2"></span>
                </a>
            </div>
            <div class="hidden-md-down dropdown-icon-menu position-relative">
                <a href="#" class="header-btn btn js-waves-off svg-icon svg-icon-primary rounded-0" style="border: none;" data-action="toggle" data-class="nav-function-hidden" title="Hide Navigation">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="32px" height="32px" viewBox="0 0 24 24" version="1.1">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect x="0" y="0" width="24" height="24"></rect>
                            <rect fill="#000000" opacity="0.3" x="4" y="5" width="16" height="2" rx="1"></rect>
                            <rect fill="#000000" opacity="0.3" x="4" y="13" width="16" height="2" rx="1"></rect>
                            <path d="M5,9 L13,9 C13.5522847,9 14,9.44771525 14,10 C14,10.5522847 13.5522847,11 13,11 L5,11 C4.44771525,11 4,10.5522847 4,10 C4,9.44771525 4.44771525,9 5,9 Z M5,17 L13,17 C13.5522847,17 14,17.4477153 14,18 C14,18.5522847 13.5522847,19 13,19 L5,19 C4.44771525,19 4,18.5522847 4,18 C4,17.4477153 4.44771525,17 5,17 Z" fill="#000000"></path>
                        </g>
                    </svg>
                </a>
                <ul>
                    <li>
                        <a href="#" class="btn js-waves-off" data-action="toggle" data-class="nav-function-minify" title="Minify Navigation">
                            <span class="svg-icon svg-icon-primary svg-icon-2x"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                    <polygon points="0 0 24 0 24 24 0 24"/>
                                    <path d="M5.29288961,6.70710318 C4.90236532,6.31657888 4.90236532,5.68341391 5.29288961,5.29288961 C5.68341391,4.90236532 6.31657888,4.90236532 6.70710318,5.29288961 L12.7071032,11.2928896 C13.0856821,11.6714686 13.0989277,12.281055 12.7371505,12.675721 L7.23715054,18.675721 C6.86395813,19.08284 6.23139076,19.1103429 5.82427177,18.7371505 C5.41715278,18.3639581 5.38964985,17.7313908 5.76284226,17.3242718 L10.6158586,12.0300721 L5.29288961,6.70710318 Z" fill="#000000" fill-rule="nonzero" transform="translate(8.999997, 11.999999) scale(-1, 1) translate(-8.999997, -11.999999) "/>
                                    <path d="M10.7071009,15.7071068 C10.3165766,16.0976311 9.68341162,16.0976311 9.29288733,15.7071068 C8.90236304,15.3165825 8.90236304,14.6834175 9.29288733,14.2928932 L15.2928873,8.29289322 C15.6714663,7.91431428 16.2810527,7.90106866 16.6757187,8.26284586 L22.6757187,13.7628459 C23.0828377,14.1360383 23.1103407,14.7686056 22.7371482,15.1757246 C22.3639558,15.5828436 21.7313885,15.6103465 21.3242695,15.2371541 L16.0300699,10.3841378 L10.7071009,15.7071068 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" transform="translate(15.999997, 11.999999) scale(-1, 1) rotate(-270.000000) translate(-15.999997, -11.999999) "/>
                                </g>
                            </svg></span>
                        </a>
                    </li>
                    <li>
                        <a href="#" class="btn js-waves-off" data-action="toggle" data-class="clx-fixed-navigation" title="Lock Navigation">
                            <span class="svg-icon svg-icon-primary svg-icon-2x"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                    <mask fill="white">
                                        <use xlink:href="#path-1"/>
                                    </mask>
                                    <g/>
                                    <path d="M7,10 L7,8 C7,5.23857625 9.23857625,3 12,3 C14.7614237,3 17,5.23857625 17,8 L17,10 L18,10 C19.1045695,10 20,10.8954305 20,12 L20,18 C20,19.1045695 19.1045695,20 18,20 L6,20 C4.8954305,20 4,19.1045695 4,18 L4,12 C4,10.8954305 4.8954305,10 6,10 L7,10 Z M12,5 C10.3431458,5 9,6.34314575 9,8 L9,10 L15,10 L15,8 C15,6.34314575 13.6568542,5 12,5 Z" fill="#000000"/>
                                </g>
                            </svg></span>
                        </a>
                    </li>
                </ul>
            </div>
            <div class="hidden-lg-up">
                <a href="#" class="header-btn btn press-scale-down" data-action="toggle" data-class="mobile-nav-on">
                    <span class="svg-icon svg-icon-primary svg-icon-2x"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="32px" height="32px" viewBox="0 0 24 24" version="1.1">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect x="0" y="0" width="24" height="24"/>
                            <rect fill="#000000" x="4" y="5" width="16" height="3" rx="1.5"/>
                            <path d="M5.5,15 L18.5,15 C19.3284271,15 20,15.6715729 20,16.5 C20,17.3284271 19.3284271,18 18.5,18 L5.5,18 C4.67157288,18 4,17.3284271 4,16.5 C4,15.6715729 4.67157288,15 5.5,15 Z M5.5,10 L18.5,10 C19.3284271,10 20,10.6715729 20,11.5 C20,12.3284271 19.3284271,13 18.5,13 L5.5,13 C4.67157288,13 4,12.3284271 4,11.5 C4,10.6715729 4.67157288,10 5.5,10 Z" fill="#000000" opacity="0.3"/>
                        </g>
                    </svg></span>
                </a>
            </div>

            


            <div class="ms-auto d-flex">
                <!-- <input type="text" class="mi_directorio"  value="{$directorio}" > -->
             

                {if has_access($user->roleid,'appearance')}

                    <div class="hidden-md-down">
                        
                
                    </div>

                {/if}

            

            {if $user["roleid"] == 3 }

                <a href="{$url_base_plantilla_admintpl}social/social-chat-employee" class="header-icon align-items-center justify-content-center ms-2 cursor-pointer opcion_ws_existente"  data-bs-toggle="tooltip" data-bs-placement="bottom" title="Whatsapp/SMS Notification" >
                    <div class="image-container-perfil-header" style="margin-top:0px">
                        <div class="img-avatar-header">
                            <svg class="img-avatar-header" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><!--!Font Awesome Free 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7 .9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/></svg>
                        </div>
                       {* <img src="{$theme}default/img/signo.PNG" alt="" class="img-avatar-small-header signo_existe_mensaje_ws" style="display:none"> *}
                    </div>

                </a>

            {/if}


            {if $user["roleid"] == 2 || $user["roleid"] == 0 }

                <a href="{$url_base_plantilla_admintpl}social/social-chat" class="header-icon align-items-center justify-content-center ms-2 cursor-pointer opcion_ws_existente"  data-bs-toggle="tooltip" data-bs-placement="bottom" title="Whatsapp/SMS Notification" >
                    <div class="image-container-perfil-header" style="margin-top:0px">
                        <div class="img-avatar-header">
                            <svg class="img-avatar-header" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><!--!Font Awesome Free 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7 .9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/></svg>
                        </div>
                    {*  <img src="{$theme}default/img/signo.PNG" alt="" class="img-avatar-small-header signo_existe_mensaje_ws" style="display:none"> *}
                    </div>

                </a>

            {/if}

            <a href="{$url_base_plantilla_admintpl}social/chat-crm" class="header-icon align-items-center justify-content-center ms-2 cursor-pointer opcion_tw_existente"  data-bs-toggle="tooltip" data-bs-placement="bottom" title="CRM Chat Notification">
                 <div class="image-container-perfil-header" style="margin-top:0px">
                    <div class="img-avatar-header">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--!Font Awesome Free 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M123.6 391.3c12.9-9.4 29.6-11.8 44.6-6.4c26.5 9.6 56.2 15.1 87.8 15.1c124.7 0 208-80.5 208-160s-83.3-160-208-160S48 160.5 48 240c0 32 12.4 62.8 35.7 89.2c8.6 9.7 12.8 22.5 11.8 35.5c-1.4 18.1-5.7 34.7-11.3 49.4c17-7.9 31.1-16.7 39.4-22.7zM21.2 431.9c1.8-2.7 3.5-5.4 5.1-8.1c10-16.6 19.5-38.4 21.4-62.9C17.7 326.8 0 285.1 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208s-114.6 208-256 208c-37.1 0-72.3-6.4-104.1-17.9c-11.9 8.7-31.3 20.6-54.3 30.6c-15.1 6.6-32.3 12.6-50.1 16.1c-.8 .2-1.6 .3-2.4 .5c-4.4 .8-8.7 1.5-13.2 1.9c-.2 0-.5 .1-.7 .1c-5.1 .5-10.2 .8-15.3 .8c-6.5 0-12.3-3.9-14.8-9.9c-2.5-6-1.1-12.8 3.4-17.4c4.1-4.2 7.8-8.7 11.3-13.5c1.7-2.3 3.3-4.6 4.8-6.9l.3-.5z"/></svg>
                    </div>
                {*    <img src="{$theme}default/img/signo.PNG" alt="" class="img-avatar-small-header signo_existe_mensaje_crm" style="display:none"> *}
                </div>

            </a>


            {if has_access($user->roleid,'appearance')}

            <div class="hidden-md-down">
                <a href="{$_url}appearance/ui" class="header-icon cursor-pointer">
                    <span class="svg-icon svg-icon-primary svg-icon-2x"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect opacity="0.200000003" x="0" y="0" width="24" height="24"/>
                            <path d="M4.5,7 L9.5,7 C10.3284271,7 11,7.67157288 11,8.5 C11,9.32842712 10.3284271,10 9.5,10 L4.5,10 C3.67157288,10 3,9.32842712 3,8.5 C3,7.67157288 3.67157288,7 4.5,7 Z M13.5,15 L18.5,15 C19.3284271,15 20,15.6715729 20,16.5 C20,17.3284271 19.3284271,18 18.5,18 L13.5,18 C12.6715729,18 12,17.3284271 12,16.5 C12,15.6715729 12.6715729,15 13.5,15 Z" fill="#000000" opacity="0.3"/>
                            <path d="M17,11 C15.3431458,11 14,9.65685425 14,8 C14,6.34314575 15.3431458,5 17,5 C18.6568542,5 20,6.34314575 20,8 C20,9.65685425 18.6568542,11 17,11 Z M6,19 C4.34314575,19 3,17.6568542 3,16 C3,14.3431458 4.34314575,13 6,13 C7.65685425,13 9,14.3431458 9,16 C9,17.6568542 7.65685425,19 6,19 Z" fill="#000000"/>
                        </g>
                    </svg></span>
                </a>
            </div>

            {/if}

            

            <div>

                {if has_access($user->roleid, 'utilities')}

                    <a href="javasctipt:;" id="get_activity" class="header-icon cursor-pointer" data-bs-toggle="dropdown" aria-expanded="false">
                        <span class="svg-icon svg-icon-primary svg-icon-2x"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <rect x="0" y="0" width="24" height="24"/>
                                <path d="M13.2070325,4 C13.0721672,4.47683179 13,4.97998812 13,5.5 C13,8.53756612 15.4624339,11 18.5,11 C19.0200119,11 19.5231682,10.9278328 20,10.7929675 L20,17 C20,18.6568542 18.6568542,20 17,20 L7,20 C5.34314575,20 4,18.6568542 4,17 L4,7 C4,5.34314575 5.34314575,4 7,4 L13.2070325,4 Z" fill="#000000"/>
                                <circle fill="#000000" opacity="0.3" cx="18.5" cy="5.5" r="2.5"/>
                            </g>
                        </svg></span>
                    </a>

                {/if}

                <div class="dropdown-menu dropdown-menu-end dropdown-xl p-0">
                    <div class="dropdown-header d-flex justify-content-center align-items-center rounded-top mb-2">
                        <h4 class="m-0 text-center">
                            {$_L['Notifications']}
                        </h4>
                    </div>
                    <div class="custom-scroll h-100" id="activity_loaded">
                        <div class="text-center my-3">
                            <div class="md-preloader"><svg xmlns="http://www.w3.org/2000/svg" version="1.1" height="32" width="32" viewbox="0 0 75 75"><circle cx="37.5" cy="37.5" r="33.5" stroke-width="6"/></svg></div>
                        </div>
                    </div>
                    <div class="py-2 px-3 bg-faded d-block rounded-bottom text-center border-faded border-bottom-0 border-right-0 border-left-0">
                        <a href="{$_url}util/activity" class="fs-xs fw-500 ms-auto">{$_L['See All Activity']}</a>
                    </div>
                </div>
            </div>

            <div>
                <a href="javascript:;" class="header-icon cursor-pointer" data-bs-toggle="modal" data-bs-target=".js-modal-notes">
                    <span class="svg-icon svg-icon-primary svg-icon-2x"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect x="0" y="0" width="24" height="24"/>
                            <path d="M8,3 L8,3.5 C8,4.32842712 8.67157288,5 9.5,5 L14.5,5 C15.3284271,5 16,4.32842712 16,3.5 L16,3 L18,3 C19.1045695,3 20,3.8954305 20,5 L20,21 C20,22.1045695 19.1045695,23 18,23 L6,23 C4.8954305,23 4,22.1045695 4,21 L4,5 C4,3.8954305 4.8954305,3 6,3 L8,3 Z" fill="#000000" opacity="0.3"/>
                            <path d="M11,2 C11,1.44771525 11.4477153,1 12,1 C12.5522847,1 13,1.44771525 13,2 L14.5,2 C14.7761424,2 15,2.22385763 15,2.5 L15,3.5 C15,3.77614237 14.7761424,4 14.5,4 L9.5,4 C9.22385763,4 9,3.77614237 9,3.5 L9,2.5 C9,2.22385763 9.22385763,2 9.5,2 L11,2 Z" fill="#000000"/>
                            <rect fill="#000000" opacity="0.3" x="7" y="10" width="5" height="2" rx="1"/>
                            <rect fill="#000000" opacity="0.3" x="7" y="14" width="9" height="2" rx="1"/>
                        </g>
                    </svg></span>
                </a>
            </div>


             

            <div>


                <a href="#" class="header-icon align-items-center justify-content-center ms-2 cursor-pointer" data-bs-toggle="dropdown" data-bs-target="#user-dropdown-menu" aria-expanded="false">
                    {if $user['img'] eq ''}
                    <img src="{$app_url}ui/lib/img/default-user-avatar.png"  class="profile-image rounded-circle" alt="{$user->fullname}">
                    {else}
                    <img src="{$app_url}{$user['img']}"  class="profile-image rounded-circle" alt="{$user->fullname}">
                    {/if}
                </a>

                <div class="dropdown-menu dropdown-menu-end p-0" id="user-dropdown-menu">
                    <div class="dropdown-header d-flex flex-row py-4 rounded-top">
                        <div class="d-flex flex-row align-items-center mt-1 mb-1">
                            <span class="me-2">

                                {if $user['img'] eq ''}
                                <img src="{$app_url}ui/lib/img/default-user-avatar.png" class="rounded-circle profile-image" alt="{$user->fullname}">
                                {else}
                                <img src="{$app_url}{$user['img']}" class="rounded-circle profile-image" alt="{$user->fullname}">
                                {/if}
                            </span>
                            <div class="info-card-text">
                                <div class="fs-lg text-truncate text-truncate-lg">{$user->fullname}</div>
                                <span class="text-truncate text-truncate-md opacity-80">{$user->username}</span>
                            </div>
                        </div>
                    </div>
                    <div class="dropdown-divider m-0"></div>
                    {*
                        <a href="{$_url}settings/users-edit/{$user->id}" class="dropdown-item">
                            {$_L['Edit Profile']}
                        </a>
                    *}
                     

                    <a href="{$_url}settings/change-password" class="dropdown-item">
                        {$_L['Change Password']}
                    </a>



                    <div class="dropdown-divider m-0"></div>
                    <a class="dropdown-item fw-500 pt-3 pb-3" href="{$_url}logout">
                        {$_L['Logout']}
                    </a>
                </div>



            </div>


    
        </div>


        </header>

        <main id="clx-page-content" role="main" class="page-content {if isset($page_content_extra_class)} {$page_content_extra_class} {/if}">

            {*            {if empty($config['installation_id'])}*}
            {*            <div class="alert alert-danger mb-3">*}
                {*                <div class="d-flex justify-content-between align-items-center">*}
                    {*                    <div>*}
                        {*                        <strong>{__('Please activate your item.')}</strong>*}
                    {*                    </div>*}
                    {*                    <div>*}
                        {*                        <a href="{$_url}settings/activate" class="btn btn-primary">Activate</a>*}
                    {*                    </div>*}
                {*                </div>*}
            {*            </div>*}
            {*            {/if}*}

            {if isset($notify)}{$notify}{/if}

            {block name="content"}{/block}


        </main>

        <div class="page-content-overlay" data-action="toggle" data-class="mobile-nav-on"></div>


        <div class="modal fade js-modal-notes modal-backdrop-transparent" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-right">
                <div class="modal-content h-100">
                    <div class="dropdown-header bg-primary-900 d-flex align-items-center w-100">
                        <h3 class="text-white mt-2 mb-1">{$_L['Notes']}</h3>
                        <button type="button" class="btn btn-danger text-white position-absolute pos-top pos-right p-2 m-1 me-2" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><i class="fal fa-times"></i></span>
                        </button>
                    </div>
                    <div class="modal-body p-0 h-100 d-flex">
                        <textarea class="form-control rounded-0" id="clx_notes_clipboard" placeholder="{$_L['Whats on your mind']}">{$user->notes}</textarea>
                    </div>
                </div>
            </div>
        </div>



    </div>

                                                

    <input value="{$user["id"]}" hidden disabled id="ID_USUARIO_CHAT" />
    <input value="{$user["roleid"]}" hidden disabled id="ROLL_ID_USUARIO_CHAT" />
    <input value="{$base_datos_para_socket}" hidden disabled id="DB_socket_admin_tpl" />
    <input value="{$config_whatsapp_other_id_para_socket}" hidden disabled id="config_whatsapp_other_id_para_socket_admin_tpl" />

    <input value="{$url_ir_chat_empleado}" hidden disabled id="url_ir_chat_empleado_admin_tpl" />
    <input value="{$url_ir_chat_admin}" hidden disabled id="url_ir_chat_admin_admin_tpl" />

    <input value="{$url_ir_chat_crm}" hidden disabled id="url_ir_chat_crm_admin_tpl" />

    <input type="text" id="mi_directorio" hidden disabled value="{$directorio}" >

    <input type="text" id="url_base_plantilla" hidden disabled value="{$url_base_plantilla_admintpl}" >
    
    <input type="text" id="db_crm_administrative" hidden disabled value="{$db_crm_administrative}" >

    <input
       type="text"
       value="{$APP_URL_ORIGINAL_SOCKET}"
       disabled
       hidden
       id="APP_URL_ORIGINAL_SOCKET"
    />

    <input
       type="text"
       value="{$url_origen}"
       disabled
       hidden
       id="url_origen"
    />


       

                        
{literal}
<script type="module">

    const menuCategoriasUser = {/literal}{$menu_categorias_user|json_encode}{literal};

    //console.log("menuCategoriasUser");
    //console.log(menuCategoriasUser);
 
    if(Array.isArray(menuCategoriasUser) == true)
    {
        //menuCategoriasUser
        let existe_chat_ws = menuCategoriasUser.find((item) => item.key == "mnu-8");

        if(existe_chat_ws)
        { 
            let existe_ws = existe_chat_ws.subpermisos.find((item) => item.key == "mnu-8-1");

            if(existe_ws)
            {
                $(".opcion_ws_existente").css("display", "");
            }else{
                $(".opcion_ws_existente").css("display", "none");
            }

            let existe_mensajeria_crm = existe_chat_ws.subpermisos.find((item) => item.key == "mnu-8-2");

            if(existe_mensajeria_crm)
            {
                $(".opcion_tw_existente").css("display", "");
            }else{
                $(".opcion_tw_existente").css("display", "none");
            }
            
            //console.log("existe_chat_ws");
            //console.log(existe_chat_ws);
        }else{

            $(".opcion_tw_existente").css("display", "none");
            $(".opcion_ws_existente").css("display", "none");
        }
    }

      var db_crm_administrative = document.getElementById('db_crm_administrative').value;
      var url_origen = document.getElementById('url_origen').value;
      
        console.log("db_crm_administrative");
        console.log(db_crm_administrative);

      
      var APP_URL_ORIGINAL_SOCKET = document.getElementById('APP_URL_ORIGINAL_SOCKET').value;
      var WS_NOMBRE_SOCKET = document.getElementById('ws_nombre_socket').value;


 
        var directorio_ = document.getElementById('mi_directorio').value;
        var id_usuario_especial = document.getElementById('ID_USUARIO_CHAT').value;
        var roll_id_usuario_especial = document.getElementById('ROLL_ID_USUARIO_CHAT').value;
        var DB_socket_admin_tpl = document.getElementById('DB_socket_admin_tpl').value;
        var config_whatsapp_other_id_para_socket_admin_tpl = document.getElementById('config_whatsapp_other_id_para_socket_admin_tpl').value;

        var url_ir_chat_empleado_admin_tpl = document.getElementById('url_ir_chat_empleado_admin_tpl').value;
        var url_ir_chat_admin_admin_tpl = document.getElementById('url_ir_chat_admin_admin_tpl').value;

        var url_ir_chat_crm_admin_tpl = document.getElementById('url_ir_chat_crm_admin_tpl').value;

        var url_base_plantilla = document.getElementById('url_base_plantilla').value;

        console.log("APP_URL_ORIGINAL_SOCKET");
        console.log(APP_URL_ORIGINAL_SOCKET);
        //console.log("roll_id_usuario_especial");
        //console.log(roll_id_usuario_especial);
        console.log("DB_socket_admin_tpl");
        console.log(DB_socket_admin_tpl);
        //console.log("config_whatsapp_other_id_para_socket_admin_tpl");
        //console.log(config_whatsapp_other_id_para_socket_admin_tpl);
        //console.log("url_ir_chat_empleado_admin_tpl");
        //console.log(url_ir_chat_empleado_admin_tpl);
        //console.log("url_ir_chat_admin_admin_tpl");
        //console.log(url_ir_chat_admin_admin_tpl);

        var mensajes_encontrados = [];

        //signo_existe_mensaje_ws
        //signo_existe_mensaje_crm

        const socket = io(APP_URL_ORIGINAL_SOCKET, {
            //path: "/socket-chat/socket.io",
            path: "/" + WS_NOMBRE_SOCKET + "/socket.io",
            //transports: ["websocket"],
              transports: ["polling"],  // Usar
        });

        console.log(APP_URL_ORIGINAL_SOCKET);
        //"https://xhde365.com"

        socket.emit("join-chat-room", DB_socket_admin_tpl);

        socket.on("connect", () => {
            console.log("Conectado al servidor de Socket.IO");

            socket.emit("join-chat-room", DB_socket_admin_tpl);
 
        });

        // Manejar la desconexión
        socket.on("disconnect", () => {
            console.log("Desconectado del servidor de Socket.IO");
        });

        if(isEmpty(id_usuario_especial) != true)
        {
            setInterval(() => ejecutarAsisteciaSocket(socket), 35000);
 
            if(isEmpty(roll_id_usuario_especial) != true){
                //en caso de que sea igual a 3 es para solo empleados
                if(roll_id_usuario_especial == "3" || roll_id_usuario_especial == 3)
                {
                    //console.log("empleado fs");

   
                    socket.on("chat-social/" + DB_socket_admin_tpl, (data) => {

                        //console.log("Datos de chat recibidos:", data);

                        var {
                            id,
                            tipo_producto,
                            error_codigo,
                            error_mensaje,
                            status,
                            wam_id,
                            sid,
                            phone_number_id,
                            from,
                            to,
                            mensaje,
                            url,
                            filename,
                            template_original,
                            template_data,
                            tipo_mensaje,
                            db,
                            esContacto,
                            fecha_creacion,
                            id_chat_number,
                            staff_id,
                            config_whatsapp_other_id,
                            donde_estamos,
                        } = data;

                        if (
                            isEmpty(tipo_mensaje) == true &&
                            isEmpty(tipo_producto) == true &&
                            isEmpty(esContacto) == true &&
                            isEmpty(status) == true
                        ) {
                                return;
                        }

                        if(esContacto == false)
                        {
                            return;
                        }

                        //$(".signo_existe_mensaje_ws").fadeIn();

                        toastr.clear();
                        toastr.options.preventDuplicates = true;

                        toastr.options.onclick = function () {
                            toastr.clear(); // Cierra todos los toastr activos
                            //alert("asa");
                            //window.location.href = url_ir_chat_crm_admin_tpl;
                        };

                        if (tipo_mensaje == "text") {
                            toastr.success(
                                mensaje,
                                "+" + to + " (" + tipo_producto.toUpperCase() + ")",
                            );
                        } else {
                            toastr.success(
                                "Received Attached file",
                                "+" + to + " (" + tipo_producto.toUpperCase() + ")",
                            );
                        }

                            

                        // Aquí puedes manejar los datos como necesites
                    });

                     //socket para chat soscial
                     /* socket.on(
                        "chat-social-empleados/" +
                        DB_socket_admin_tpl +
                        "/" +
                        id_usuario_especial +
                        "/" +
                        config_whatsapp_other_id_para_socket_admin_tpl,
                        (data) => {
                  
                            console.log("Datos de chat recibidos: xd");

                            //console.log("Datos de chat recibidos:", data);

                            var {
                                tipo_producto,
                                error_codigo,
                                error_mensaje,
                                status,
                                wam_id,
                                sid,
                                phone_number_id,
                                from,
                                to,
                                mensaje,
                                url,
                                filename,
                                tipo_mensaje,
                                db,
                                esContacto,
                                fecha_creacion,
                                id_chat_number,
                                staff_id,
                                config_whatsapp_other_id,

                                donde_estamos,
                            } = data;

                            if (
                                isEmpty(tipo_mensaje) == true &&
                                isEmpty(tipo_producto) == true &&
                                isEmpty(esContacto) == true &&
                                isEmpty(status) == true
                            ) {
                                return;
                            }

                            if(esContacto == false)
                            {
                                return;
                            }
                            
                            //$(".signo_existe_mensaje_ws").fadeIn();

                            toastr.clear();
                            toastr.options.preventDuplicates = true;

                            toastr.options.onclick = function () {
                                toastr.clear(); // Cierra todos los toastr activos
                                //alert("asa");
                                //window.location.href = url_ir_chat_empleado_admin_tpl;
                            };

                            if (tipo_mensaje == "text") {
                                toastr.success(
                                    mensaje,
                                    "+" + to + " (" + tipo_producto.toUpperCase() + ")",
                                );
                            } else {
                                toastr.success(
                                    "Received Attached file",
                                    "+" + to + " (" + tipo_producto.toUpperCase() + ")",
                                );
                            }

 
                        // Aquí puedes manejar los datos como necesites
                        },
                    ); */

                    //chat crm
                    socket.on(
                        "chat-sistema-usuarios/" + DB_socket_admin_tpl + "/" + id_usuario_especial,
                        (data) => {
                     
                        //console.log("Datos de chat recibidos:", data);

                        let {
                            id,
                            from_user_id,
                            to_user_id,
                            img_to_user,
                            rol_to_user,
                            fullname_from_user,
                            mensaje,
                            url,
                            filename,
                            tipo_mensaje,
                            fecha_creacion,
                            status,
                            unique_user_id,
                            db,
                            user_id,
                        } = data;

                        //console.log("-----------------------------------");
                        //console.log("id: ", id);
                        //console.log("from_user_id: ", from_user_id);
                        //console.log("to_user_id: ", to_user_id);
                        //console.log("img_to_user: ", img_to_user);
                        //console.log("rol_to_user: ", rol_to_user);
                        //console.log("fullname_from_user: ", fullname_from_user);
                        //console.log("mensaje: ", mensaje);
                        //console.log("url: ", url);
                        //console.log("filename: ", filename);
                        //console.log("tipo_mensaje: ", tipo_mensaje);
                        //console.log("status: ", status);
                        //console.log("unique_user_id: ", unique_user_id);
                        //console.log("-----------------------------------");

                        if (isEmpty(id) == true) {
                            return;
                        }

                        //$(".signo_existe_mensaje_crm").fadeIn();

                        toastr.clear();
                        toastr.options.preventDuplicates = true;

                        toastr.options.onclick = function () {
                            toastr.clear(); // Cierra todos los toastr activos
                            //alert("asa");
                            //window.location.href = url_ir_chat_crm_admin_tpl;
                        };

                        if (tipo_mensaje == "text") {
                            toastr.success(
                                mensaje,
                                fullname_from_user + " Chat CRM",
                            );
                        } else {
                            toastr.success(
                                "Received Attached file",
                               fullname_from_user + " Chat CRM",
                            );
                        }

                    });

                }else{
                    console.log("admin");
                    
                    //socket para chat soscial
                    socket.on("chat-social/" + DB_socket_admin_tpl, (data) => {

                        //console.log("Datos de chat recibidos:", data);

                        var {
                            id,
                            tipo_producto,
                            error_codigo,
                            error_mensaje,
                            status,
                            wam_id,
                            sid,
                            phone_number_id,
                            from,
                            to,
                            mensaje,
                            url,
                            filename,
                            template_original,
                            template_data,
                            tipo_mensaje,
                            db,
                            esContacto,
                            fecha_creacion,
                            id_chat_number,
                            staff_id,
                            config_whatsapp_other_id,
                            donde_estamos,
                        } = data;

                        if (
                            isEmpty(tipo_mensaje) == true &&
                            isEmpty(tipo_producto) == true &&
                            isEmpty(esContacto) == true &&
                            isEmpty(status) == true
                        ) {
                                return;
                        }

                        if(esContacto == false)
                        {
                            return;
                        }

                        //$(".signo_existe_mensaje_ws").fadeIn();

                        toastr.clear();
                        toastr.options.preventDuplicates = true;

                        toastr.options.onclick = function () {
                            toastr.clear(); // Cierra todos los toastr activos
                            //alert("asa");
                            //window.location.href = url_ir_chat_crm_admin_tpl;
                        };

                        if (tipo_mensaje == "text") {
                            toastr.success(
                                mensaje,
                                "+" + to + " (" + tipo_producto.toUpperCase() + ")",
                            );
                        } else {
                            toastr.success(
                                "Received Attached file",
                                "+" + to + " (" + tipo_producto.toUpperCase() + ")",
                            );
                        }

                            

                        // Aquí puedes manejar los datos como necesites
                    });

                    //socket para chat crm
                    socket.on(
                        "chat-sistema-usuarios/" + DB_socket_admin_tpl + "/" + id_usuario_especial,
                        (data) => {
                     

                        //console.log("Datos de chat recibidos:", data);

                        let {
                            id,
                            from_user_id,
                            to_user_id,
                            img_to_user,
                            rol_to_user,
                            fullname_from_user,
                            mensaje,
                            url,
                            filename,
                            tipo_mensaje,
                            fecha_creacion,
                            status,
                            unique_user_id,
                            db,
                            user_id,
                        } = data;

                        //console.log("-----------------------------------");
                        //console.log("id: ", id);
                        //console.log("from_user_id: ", from_user_id);
                        //console.log("to_user_id: ", to_user_id);
                        //console.log("img_to_user: ", img_to_user);
                        //console.log("rol_to_user: ", rol_to_user);
                        //console.log("fullname_from_user: ", fullname_from_user);
                        //console.log("mensaje: ", mensaje);
                        //console.log("url: ", url);
                        //console.log("filename: ", filename);
                        //console.log("tipo_mensaje: ", tipo_mensaje);
                        //console.log("status: ", status);
                        //console.log("unique_user_id: ", unique_user_id);
                        //console.log("-----------------------------------");

                        if (isEmpty(id) == true) {
                            return;
                        }

                        //$(".signo_existe_mensaje_crm").fadeIn();

                        toastr.clear();
                        toastr.options.preventDuplicates = true;

                        toastr.options.onclick = function () {
                            toastr.clear(); // Cierra todos los toastr activos
                            //alert("asa");
                            //window.location.href = url_ir_chat_admin_admin_tpl;
                        };

                        if (tipo_mensaje == "text") {
                            toastr.success(
                                mensaje,
                                fullname_from_user + " Chat CRM",
                            );
                        } else {
                            toastr.success(
                                "Received Attached file",
                               fullname_from_user + " Chat CRM",
                            );
                        }
                        

                        

                        
                         
                    });



                }

                //console.log( url_base_plantilla + "social/total-mensajes-no-leidos/" + roll_id_usuario_especial + "/" + id_usuario_especial);

                //api para verificar mensajes whatsapp/sms
                if(isEmpty(url_base_plantilla) != true)
                {
                    /* $.get(
                        url_base_plantilla + "social/total-mensajes-no-leidos-ws-crm/" + roll_id_usuario_especial + "/" + id_usuario_especial,
                        function (data) {
                            console.log(data);
                            try {
                                let info = JSON.parse(data);
                                if(info.type == "success")
                                {
                                    if(info.data == 0)
                                    {
                                         //$(".signo_existe_mensaje_ws").hide();
                                    }else{
                                         //$(".signo_existe_mensaje_ws").fadeIn();
                                    }

                                    if(info.data_crm == 0)
                                    {
                                         //$(".signo_existe_mensaje_crm").hide();
                                    }else{
                                         //$(".signo_existe_mensaje_crm").fadeIn();
                                    }

                                   
                                }
                                
                            } catch (error) {
                                console.log(
                                    "error en admin.tpl " +
                                        error.message,
                                );
                            
                            }
                        }
                    ).fail(function (jqXHR, textStatus, errorThrown) {
                        console.log(
                            "error en admin.tpl " +
                            textStatus +
                            " - " +
                            errorThrown
                        );
                    }); */

                    

                }
                 


            }

        }


        console.log("new-ticket-notification/" + db_crm_administrative);
        
        //chat crm
        socket.on(
            "new-ticket-notification/" + db_crm_administrative ,
            (data) => {
         
            //console.log("se creo un nuevo tickets", data);

            let {
                UUID
            } = data;

            if(isEmpty(UUID))
            {
                toastr.info("A new ticket has been created","Click for more details");
            }else{
                toastr.options.onclick = function () {
                    toastr.clear(); // Cierra todos los toastr activos
                    window.location.href = url_origen + "tickets/admin/view/" + UUID ;
                };

                toastr.info("A new ticket has been created","Click for more details");
            }
 
        });


 
 
        //console.log("inv");
        //console.log(inputElement);

        //console.log("ESTOY EN ADMIN.TPL");

        $('.abriendo_telefono').on('click', function() {
            //antes donde dice abriendo telefono estaba algo asi onclick="myFunction()"
            myFunction();
        });
        

        
    function sleep(ms) {
        return new Promise(resolve => setTimeout(resolve, ms));
    }
 
    function myFunction() {

        //let directorio = $(".mi_directorio").val();

        var url = window.location.href;
        var url2=window.location.pathname;
        var url = url.split(url2);
        let params = 'scrollbars=no,resizable=no,status=no,location=no,toolbar=no,menubar=no,width=600,height=300,left=100,top=100';
        var user_id1=$('#user_id1').val();

        let ur_dinamic = url[0]+"/"+ directorio_ +"/voice/calls.php?&ui="+user_id1
     // let ur_dinamic = url[0]+"/"+"app"+"/voice/calls.php?&ui="+user_id1


        open(ur_dinamic, "test", params);
    }

    function isEmpty(variable) {
        if (variable === null || variable === undefined) {
            return true;
        }

        if (typeof variable === "string") {
            return variable.trim() === "";
        }

        if (Array.isArray(variable)) {
            return variable.length === 0;
        }

        if (typeof variable === "object") {
            return Object.keys(variable).length === 0;
        }

        return false;
    }

    function ejecutarAsisteciaSocket(socket)
    {
        const data = {
            staff_id: id_usuario_especial,
            fecha_login: formatDateJS(),
            db: DB_socket_admin_tpl,
        };

        socket.emit("estado-online-staff", data);

    }

    function formatDateJS() 
    {
        const now = new Date();
        
        const months = [
            "January", "February", "March", "April", "May", "June",
            "July", "August", "September", "October", "November", "December"
        ];
        
        const month = months[now.getMonth()];
        const day = now.getDate();
        const year = now.getFullYear();
        
        let hours = now.getHours();
        const minutes = now.getMinutes().toString().padStart(2, "0");
        
        return `${month} ${day}, ${year}, ${hours}:${minutes}`;
    }

</script>
{/literal}

{/block}
